import * as React from 'react';

const LandingImage = () => (
  <svg
    width={917}
    height={251}
    viewBox="0 0 917 251"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <rect
      x={171}
      y={140}
      width={26}
      height={16}
      rx={2}
      fill="#C4C4C4"
      fillOpacity={0.3}
    />
    <path
      d="M179.642 151.054c-.924 0-1.659-.294-2.205-.882-.546-.588-.819-1.371-.819-2.349 0-.984.258-1.764.774-2.34.522-.582 1.245-.873 2.169-.873a5.72 5.72 0 011.863.324l-.162 1.008a4.575 4.575 0 00-.891-.207 5.654 5.654 0 00-.855-.09c-.498 0-.888.192-1.17.576-.282.378-.423.891-.423 1.539 0 .648.15 1.188.45 1.62.306.426.696.639 1.17.639.276 0 .528-.06.756-.18v-1.224h-1.044v-1.035h2.349v2.988a4.238 4.238 0 01-1.962.486zm6.953-.054h-3.753v-6.3h3.753v1.035h-2.448v1.323h2.223v1.053h-2.223v1.854h2.448V151zm2.115 0v-5.247h-1.449V144.7h4.176v1.053h-1.431V151h-1.296z"
      fill="#707070"
    />
    <rect
      x={205}
      y={140}
      width={30}
      height={16}
      rx={2}
      fill="#C4C4C4"
      fillOpacity={0.3}
    />
    <path
      d="M212.313 148.579h-.468V151h-1.305v-6.3h1.98c.738 0 1.272.159 1.602.477.33.312.495.798.495 1.458 0 .654-.204 1.143-.612 1.467-.402.318-.966.477-1.692.477zm-.099-2.853h-.369v1.827h.144c.456 0 .789-.069.999-.207.216-.138.324-.369.324-.693 0-.33-.087-.567-.261-.711-.174-.144-.453-.216-.837-.216zm5.464 5.319c-.882 0-1.548-.303-1.998-.909-.45-.612-.675-1.389-.675-2.331s.225-1.71.675-2.304c.456-.594 1.122-.891 1.998-.891.882 0 1.551.297 2.007.891.456.594.684 1.362.684 2.304 0 1.29-.393 2.22-1.179 2.79-.414.3-.918.45-1.512.45zm.018-5.4c-.318 0-.585.111-.801.333-.384.384-.576.993-.576 1.827 0 .63.117 1.155.351 1.575.234.414.576.621 1.026.621.456 0 .798-.21 1.026-.63.228-.426.342-.942.342-1.548 0-.612-.123-1.128-.369-1.548-.24-.42-.573-.63-.999-.63zm7.077-.72l-.216 1.053-.558-.153a4.758 4.758 0 00-1.035-.135c-.408 0-.612.195-.612.585 0 .15.069.288.207.414.144.12.324.222.54.306.216.078.447.177.693.297.246.12.477.249.693.387.216.138.393.327.531.567.144.24.216.516.216.828 0 .618-.201 1.104-.603 1.458-.396.348-.957.522-1.683.522a4.45 4.45 0 01-1.116-.144 4.298 4.298 0 01-.909-.351l.387-.963a3.92 3.92 0 001.638.378c.306 0 .546-.069.72-.207a.682.682 0 00.261-.549c0-.222-.099-.405-.297-.549a3.13 3.13 0 00-.72-.396c-.282-.12-.564-.252-.846-.396a2.16 2.16 0 01-.72-.621 1.57 1.57 0 01-.297-.954c0-.546.171-.963.513-1.251.342-.294.801-.441 1.377-.441.582 0 1.194.105 1.836.315zm2.419 6.075v-5.247h-1.449V144.7h4.176v1.053h-1.431V151h-1.296z"
      fill="#707070"
    />
    <rect
      x={243}
      y={140}
      width={26}
      height={16}
      rx={2}
      fill="#C4C4C4"
      fillOpacity={0.3}
    />
    <path
      d="M250.722 148.579h-.468V151h-1.305v-6.3h1.98c.738 0 1.272.159 1.602.477.33.312.495.798.495 1.458 0 .654-.204 1.143-.612 1.467-.402.318-.966.477-1.692.477zm-.099-2.853h-.369v1.827h.144c.456 0 .789-.069.999-.207.216-.138.324-.369.324-.693 0-.33-.087-.567-.261-.711-.174-.144-.453-.216-.837-.216zm7.29 4.734c-.402.396-.984.594-1.746.594s-1.344-.198-1.746-.594c-.402-.402-.603-.996-.603-1.782V144.7h1.314v4.086c0 .396.087.702.261.918.18.21.435.315.765.315s.585-.105.765-.315c.186-.216.279-.522.279-.918V144.7h1.314v3.978c0 .786-.201 1.38-.603 1.782zm2.871.54v-5.247h-1.449V144.7h4.176v1.053h-1.431V151h-1.296z"
      fill="#707070"
    />
    <rect
      x={171}
      y={164}
      width={47}
      height={16}
      rx={2}
      fill="#C4C4C4"
      fillOpacity={0.3}
    />
    <path
      d="M185.316 172.848h-.416V175h-1.16v-5.6h1.76c.656 0 1.131.141 1.424.424.293.277.44.709.44 1.296 0 .581-.181 1.016-.544 1.304-.357.283-.859.424-1.504.424zm-.088-2.536h-.328v1.624h.128c.405 0 .701-.061.888-.184.192-.123.288-.328.288-.616 0-.293-.077-.504-.232-.632-.155-.128-.403-.192-.744-.192zm6.96 4.688h-1.152l-.4-1.368h-1.688l-.392 1.368h-1.112l1.68-5.6h1.368l1.696 5.6zm-1.768-2.288l-.616-2.304-.624 2.304h1.24zm2.841 2.288v-4.664h-1.288v-.936h3.712v.936h-1.272V175h-1.152zm5.351.048c-.816 0-1.443-.256-1.88-.768-.432-.517-.648-1.216-.648-2.096 0-.88.229-1.576.688-2.088.464-.512 1.106-.768 1.928-.768.448 0 .893.077 1.336.232l-.224.896c-.326-.139-.71-.208-1.152-.208-.443 0-.79.168-1.04.504-.251.336-.376.8-.376 1.392 0 .592.117 1.072.352 1.44.234.363.565.544.992.544.32 0 .776-.104 1.368-.312l.24.816a3.145 3.145 0 01-1.584.416zm6.648-.048h-1.16v-2.448h-1.856V175h-1.16v-5.6h1.16v2.232h1.856V169.4h1.16v5.6z"
      fill="#707070"
    />
    <rect
      x={226}
      y={164}
      width={43}
      height={16}
      rx={2}
      fill="#C4C4C4"
      fillOpacity={0.3}
    />
    <path
      d="M239.436 172c0 .901-.261 1.627-.784 2.176-.523.549-1.221.824-2.096.824h-1.488v-5.6h1.736c.795 0 1.432.243 1.912.728s.72 1.109.72 1.872zm-1.208-.064c0-.501-.136-.896-.408-1.184a1.305 1.305 0 00-.984-.432h-.64v3.76h.432c.448 0 .827-.189 1.136-.568.309-.384.464-.909.464-1.576zm5.356 3.064h-3.336v-5.6h3.336v.92h-2.176v1.176h1.976v.936h-1.976v1.648h2.176v.92zm4.32 0h-3.32v-5.6h1.16v4.68h2.16v.92zm3.797 0h-3.336v-5.6h3.336v.92h-2.176v1.176h1.976v.936h-1.976v1.648h2.176v.92zm1.88 0v-4.664h-1.288v-.936h3.712v.936h-1.272V175h-1.152zm6.487 0h-3.336v-5.6h3.336v.92h-2.176v1.176h1.976v.936h-1.976v1.648h2.176v.92zM149.293 127.293a.999.999 0 000 1.414l6.364 6.364a.999.999 0 101.414-1.414L151.414 128l5.657-5.657a.999.999 0 10-1.414-1.414l-6.364 6.364zm140.414 1.414a.999.999 0 000-1.414l-6.364-6.364a.999.999 0 10-1.414 1.414l5.657 5.657-5.657 5.657a.999.999 0 101.414 1.414l6.364-6.364zM150 129h139v-2H150v2z"
      fill="#707070"
    />
    <rect
      x={12}
      y={71}
      width={107}
      height={78}
      rx={3}
      fill="#fff"
      stroke="#707070"
      strokeWidth={2}
    />
    <path
      d="M109 80H22"
      stroke="#707070"
      strokeWidth={2}
      strokeLinecap="round"
    />
    <rect
      x={101}
      y={104}
      width={34}
      height={63}
      rx={3}
      fill="#fff"
      stroke="#707070"
      strokeWidth={2}
    />
    <path
      d="M127 161h-18"
      stroke="#707070"
      strokeWidth={2}
      strokeLinecap="round"
    />
    <path
      d="M11.127 201.084c-1.428 0-2.524-.448-3.29-1.344-.756-.905-1.134-2.128-1.134-3.668s.402-2.758 1.204-3.654c.812-.896 1.937-1.344 3.374-1.344.784 0 1.563.135 2.338.406l-.392 1.568c-.57-.243-1.241-.364-2.016-.364-.774 0-1.381.294-1.82.882-.438.588-.658 1.4-.658 2.436s.206 1.876.616 2.52c.41.635.99.952 1.736.952.56 0 1.358-.182 2.394-.546l.42 1.428a5.495 5.495 0 01-2.772.728zm6.286-.084h-1.82v-9.8h1.82v9.8zm4.169-8.05h-1.82v-1.75h1.82v1.75zm0 8.05h-1.82v-7h1.82v7zm7.31-.434c-.887.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.019.77-.056 1.078H24.93c0 .551.15.957.448 1.218.299.261.7.392 1.204.392s1.171-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.187-.261-.48-.392-.882-.392-.401 0-.7.145-.896.434-.196.289-.299.653-.308 1.092h2.366zM36.664 201h-1.848v-4.186c0-.383-.075-.691-.224-.924-.15-.243-.397-.364-.742-.364-.346 0-.775.215-1.288.644V201h-1.834v-7h1.54l.294.63c.401-.299.746-.499 1.036-.602a2.941 2.941 0 011.036-.168c.625 0 1.12.21 1.484.63.364.411.546 1.022.546 1.834V201zm2.197-1.512v-3.948h-.714V194h.728v-2.002h1.806V194h1.47v1.54h-1.484v3.052c0 .625.191.938.574.938.215 0 .443-.028.686-.084l.294 1.456c-.43.121-.887.182-1.372.182-.476 0-.929-.121-1.358-.364-.42-.252-.63-.663-.63-1.232zm4.784-.35a4.198 4.198 0 001.918.476c.662 0 .994-.243.994-.728 0-.448-.374-.779-1.12-.994a12.387 12.387 0 01-.952-.294 2.01 2.01 0 01-.798-.574c-.215-.271-.322-.616-.322-1.036 0-.681.21-1.204.63-1.568.42-.373 1.003-.56 1.75-.56.756 0 1.47.131 2.142.392l-.294 1.456a4.75 4.75 0 00-1.806-.378c-.41 0-.616.14-.616.42 0 .289.275.509.826.658a5.45 5.45 0 011.54.644c.233.14.43.35.588.63.158.28.238.616.238 1.008 0 .737-.248 1.321-.742 1.75-.495.429-1.176.644-2.044.644-.868 0-1.643-.201-2.324-.602l.392-1.344zm15.95-3.192h1.568c-.074 1.083-.196 1.857-.364 2.324a7.962 7.962 0 01-.294.672l2.002 2.044h-2.38l-.728-.686c-.308.224-.732.415-1.274.574a6.198 6.198 0 01-1.652.224c-1.11 0-1.96-.252-2.548-.756-.588-.504-.882-1.185-.882-2.044 0-.803.257-1.428.77-1.876.224-.196.537-.415.938-.658-.41-.485-.714-.901-.91-1.246a2.268 2.268 0 01-.28-1.064c0-.7.266-1.274.798-1.722.532-.448 1.214-.672 2.044-.672.831 0 1.494.21 1.988.63.504.411.756.915.756 1.512s-.144 1.097-.434 1.498c-.28.401-.737.798-1.372 1.19l1.946 1.876c.206-.439.308-1.045.308-1.82zm-1.414 3.122l-2.17-2.184c-.812.42-1.218.919-1.218 1.498 0 .373.15.677.448.91.308.224.677.336 1.106.336.43 0 .808-.056 1.134-.168.327-.121.56-.252.7-.392zm-2.786-5.376l.126.252c.028.056.08.131.154.224l.168.21.196.238c.094.112.16.191.196.238.803-.467 1.204-1.008 1.204-1.624a.553.553 0 00-.308-.518c-.205-.121-.462-.182-.77-.182s-.56.065-.756.196c-.196.121-.294.285-.294.49 0 .205.028.364.084.476zM74.643 201h-2.016l-.7-2.394h-2.954L68.287 201h-1.946l2.94-9.8h2.394l2.969 9.8zm-3.094-4.004l-1.078-4.032-1.092 4.032h2.17zm5.952 7.322h-1.82V194h1.386l.336.742c.345-.289.658-.509.938-.658.29-.149.611-.224.966-.224.775 0 1.362.322 1.764.966.41.644.616 1.545.616 2.702s-.261 2.044-.784 2.66c-.523.607-1.139.91-1.848.91-.514 0-1.032-.224-1.554-.672v3.892zm0-8.162v2.562c.298.485.667.728 1.106.728.448 0 .756-.159.924-.476.177-.317.266-.803.266-1.456 0-.653-.093-1.157-.28-1.512-.187-.355-.42-.532-.7-.532-.401 0-.84.229-1.316.686zm7.642 8.162h-1.82V194h1.387l.336.742c.345-.289.657-.509.938-.658.289-.149.61-.224.966-.224.774 0 1.362.322 1.763.966.411.644.617 1.545.617 2.702s-.262 2.044-.784 2.66c-.523.607-1.14.91-1.849.91-.513 0-1.03-.224-1.553-.672v3.892zm0-8.162v2.562c.3.485.668.728 1.106.728.449 0 .757-.159.925-.476.177-.317.265-.803.265-1.456 0-.653-.093-1.157-.28-1.512-.186-.355-.42-.532-.7-.532-.4 0-.84.229-1.316.686zM92.787 201h-1.82v-9.8h1.82v9.8zm4.169-8.05h-1.82v-1.75h1.82v1.75zm0 8.05h-1.82v-7h1.82v7zm6.554-1.526l.224 1.26c-.812.233-1.456.35-1.932.35-1.157 0-1.993-.303-2.506-.91-.513-.607-.77-1.489-.77-2.646 0-1.167.266-2.067.798-2.702.532-.644 1.307-.966 2.324-.966.597 0 1.279.112 2.044.336l-.658 1.274c-.513-.159-.938-.238-1.274-.238-.336 0-.602.065-.798.196a1.096 1.096 0 00-.406.56c-.14.401-.21.952-.21 1.652 0 .691.145 1.199.434 1.526.289.327.709.49 1.26.49s1.041-.061 1.47-.182zm5.386 1.526l-.28-.7c-.327.299-.616.509-.868.63a2.234 2.234 0 01-.91.168c-.598 0-1.12-.205-1.568-.616-.439-.42-.658-.975-.658-1.666s.27-1.232.812-1.624c.541-.401 1.358-.602 2.45-.602h.574c0-.401-.098-.723-.294-.966-.187-.243-.476-.364-.868-.364a8 8 0 00-2.072.28l-.308-1.232a8.998 8.998 0 012.786-.448c1.698 0 2.548.793 2.548 2.38V201h-1.344zm-.476-3.066h-.602c-.523 0-.878.07-1.064.21-.187.14-.28.345-.28.616 0 .261.07.476.21.644.14.168.322.252.546.252.317 0 .714-.252 1.19-.756v-.966zm3.737 1.554v-3.948h-.714V194h.728v-2.002h1.806V194h1.47v1.54h-1.484v3.052c0 .625.191.938.574.938.214 0 .443-.028.686-.084l.294 1.456c-.43.121-.887.182-1.372.182-.476 0-.929-.121-1.358-.364-.42-.252-.63-.663-.63-1.232zm6.674-6.538h-1.82v-1.75h1.82v1.75zm0 8.05h-1.82v-7h1.82v7zm7.996-3.486c0 1.12-.285 1.997-.854 2.632s-1.377.952-2.422.952c-1.045 0-1.839-.317-2.38-.952-.541-.635-.812-1.517-.812-2.646s.271-2.016.812-2.66c.541-.653 1.321-.98 2.338-.98 1.017 0 1.825.331 2.422.994.597.653.896 1.54.896 2.66zm-1.862-.028c0-1.428-.457-2.142-1.372-2.142-.933 0-1.4.709-1.4 2.128s.471 2.128 1.414 2.128c.504 0 .854-.177 1.05-.532.205-.364.308-.891.308-1.582zm9.399 3.514h-1.848v-4.186c0-.383-.075-.691-.224-.924-.149-.243-.397-.364-.742-.364s-.775.215-1.288.644V201h-1.834v-7h1.54l.294.63c.401-.299.747-.499 1.036-.602a2.943 2.943 0 011.036-.168c.625 0 1.12.21 1.484.63.364.411.546 1.022.546 1.834V201zm2.141-1.862a4.198 4.198 0 001.918.476c.663 0 .994-.243.994-.728 0-.448-.373-.779-1.12-.994a12.374 12.374 0 01-.952-.294 2.01 2.01 0 01-.798-.574c-.215-.271-.322-.616-.322-1.036 0-.681.21-1.204.63-1.568.42-.373 1.003-.56 1.75-.56.756 0 1.47.131 2.142.392l-.294 1.456a4.75 4.75 0 00-1.806-.378c-.411 0-.616.14-.616.42 0 .289.275.509.826.658a5.446 5.446 0 011.54.644c.233.14.429.35.588.63.159.28.238.616.238 1.008 0 .737-.247 1.321-.742 1.75-.495.429-1.176.644-2.044.644-.868 0-1.643-.201-2.324-.602l.392-1.344zM843.53 127.47a.749.749 0 010 1.06l-4.773 4.773a.749.749 0 11-1.06-1.06l4.242-4.243-4.242-4.243a.749.749 0 111.06-1.06l4.773 4.773zM702 128.75a.75.75 0 010-1.5v1.5zm141 0H702v-1.5h141v1.5zM843.53 50.47a.75.75 0 010 1.06l-4.773 4.773a.75.75 0 11-1.06-1.06L841.939 51l-4.242-4.243a.75.75 0 011.06-1.06l4.773 4.773zM716.75 123a.75.75 0 01-1.5 0h1.5zM843 51.75H724v-1.5h119v1.5zM716.75 59v64h-1.5V59h1.5zm7.25-7.25a7.25 7.25 0 00-7.25 7.25h-1.5a8.75 8.75 0 018.75-8.75v1.5zM843.53 205.53a.749.749 0 000-1.06l-4.773-4.773a.749.749 0 10-1.06 1.06l4.242 4.243-4.242 4.243a.749.749 0 101.06 1.06l4.773-4.773zM716.75 133a.75.75 0 00-1.5 0h1.5zM843 204.25H724v1.5h119v-1.5zM716.75 197v-64h-1.5v64h1.5zm7.25 7.25a7.25 7.25 0 01-7.25-7.25h-1.5a8.75 8.75 0 008.75 8.75v-1.5zM732.259 189.744h-.168v4.242h-2.03v-9.8h3.108c1.055 0 1.844.233 2.366.7.523.457.784 1.115.784 1.974 0 .523-.182 1.003-.546 1.442-.364.429-.807.677-1.33.742.374.103.663.275.868.518.206.233.42.616.644 1.148l1.386 3.276h-2.086l-1.358-3.136c-.196-.448-.406-.742-.63-.882-.214-.149-.55-.224-1.008-.224zm.854-3.962h-1.022v2.366h.882c.374 0 .663-.121.868-.364.215-.243.322-.541.322-.896 0-.737-.35-1.106-1.05-1.106zm10.62 7.784c-.887.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.019.77-.056 1.078h-4.046c0 .551.149.957.448 1.218.299.261.7.392 1.204.392s1.171-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.187-.261-.481-.392-.882-.392s-.7.145-.896.434c-.196.289-.299.653-.308 1.092h2.366zm5.28 4.242h-1.834v-7h1.54l.238.63c.401-.299.746-.499 1.036-.602a2.939 2.939 0 011.036-.168c.709 0 1.227.322 1.554.966.522-.383.942-.639 1.26-.77a2.828 2.828 0 011.064-.196c.578 0 1.036.215 1.372.644.336.42.504 1.041.504 1.862V194h-1.834v-4.144c0-.859-.257-1.288-.77-1.288-.383 0-.822.215-1.316.644V194h-1.82v-4.144c0-.859-.252-1.288-.756-1.288-.374 0-.798.201-1.274.602V194zm15.815-3.486c0 1.12-.285 1.997-.854 2.632-.57.635-1.377.952-2.422.952-1.046 0-1.839-.317-2.38-.952-.542-.635-.812-1.517-.812-2.646s.27-2.016.812-2.66c.541-.653 1.32-.98 2.338-.98 1.017 0 1.824.331 2.422.994.597.653.896 1.54.896 2.66zm-1.862-.028c0-1.428-.458-2.142-1.372-2.142-.934 0-1.4.709-1.4 2.128s.471 2.128 1.414 2.128c.504 0 .854-.177 1.05-.532.205-.364.308-.891.308-1.582zm3.393 2.002v-3.948h-.714V187h.728v-2.002h1.806V187h1.47v1.54h-1.484v3.052c0 .625.191.938.574.938.214 0 .443-.028.686-.084l.294 1.456c-.43.121-.887.182-1.372.182-.476 0-.929-.121-1.358-.364-.42-.252-.63-.663-.63-1.232zm10.005 1.078c-.886.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.018.77-.056 1.078h-4.046c0 .551.15.957.448 1.218.299.261.7.392 1.204.392s1.172-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.186-.261-.48-.392-.882-.392-.401 0-.7.145-.896.434-.196.289-.298.653-.308 1.092h2.366zm12.294-5.208l-.336 1.638-.868-.238c-.616-.14-1.153-.21-1.61-.21-.635 0-.952.303-.952.91 0 .233.107.448.322.644a3 3 0 00.84.476c.336.121.695.275 1.078.462.383.187.742.387 1.078.602.336.215.611.509.826.882.224.373.336.803.336 1.288 0 .961-.313 1.717-.938 2.268-.616.541-1.489.812-2.618.812a6.938 6.938 0 01-1.736-.224c-.569-.159-1.041-.341-1.414-.546l.602-1.498c.859.392 1.708.588 2.548.588.476 0 .849-.107 1.12-.322a1.06 1.06 0 00.406-.854c0-.345-.154-.63-.462-.854a4.862 4.862 0 00-1.12-.616 21.006 21.006 0 01-1.316-.616 3.35 3.35 0 01-1.12-.966c-.308-.42-.462-.915-.462-1.484 0-.849.266-1.498.798-1.946.532-.457 1.246-.686 2.142-.686.905 0 1.857.163 2.856.49zm6.703 7.924l.224 1.26c-.812.233-1.456.35-1.932.35-1.157 0-1.993-.303-2.506-.91-.513-.607-.77-1.489-.77-2.646 0-1.167.266-2.067.798-2.702.532-.644 1.307-.966 2.324-.966.597 0 1.279.112 2.044.336l-.658 1.274c-.513-.159-.938-.238-1.274-.238-.336 0-.602.065-.798.196a1.096 1.096 0 00-.406.56c-.14.401-.21.952-.21 1.652 0 .691.145 1.199.434 1.526.289.327.709.49 1.26.49s1.041-.061 1.47-.182zm7.598 1.526h-1.82v-4.186c0-.383-.075-.691-.224-.924-.15-.243-.402-.364-.756-.364-.355 0-.789.215-1.302.644V194h-1.82v-9.8h1.82v3.43c.401-.299.746-.499 1.036-.602a2.939 2.939 0 011.036-.168c.625 0 1.12.21 1.484.63.364.411.546 1.022.546 1.834V194zm7.363-.434c-.887.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.019.77-.056 1.078h-4.046c0 .551.149.957.448 1.218.299.261.7.392 1.204.392s1.171-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.187-.261-.481-.392-.882-.392s-.7.145-.896.434c-.196.289-.299.653-.308 1.092h2.366zm5.28 4.242h-1.834v-7h1.54l.238.63c.401-.299.746-.499 1.036-.602a2.939 2.939 0 011.036-.168c.709 0 1.227.322 1.554.966.522-.383.942-.639 1.26-.77a2.828 2.828 0 011.064-.196c.578 0 1.036.215 1.372.644.336.42.504 1.041.504 1.862V194h-1.834v-4.144c0-.859-.257-1.288-.77-1.288-.383 0-.822.215-1.316.644V194h-1.82v-4.144c0-.859-.252-1.288-.756-1.288-.374 0-.798.201-1.274.602V194zm13.743 0l-.28-.7c-.327.299-.616.509-.868.63a2.23 2.23 0 01-.91.168c-.597 0-1.12-.205-1.568-.616-.439-.42-.658-.975-.658-1.666s.271-1.232.812-1.624c.541-.401 1.358-.602 2.45-.602h.574c0-.401-.098-.723-.294-.966-.187-.243-.476-.364-.868-.364-.681 0-1.372.093-2.072.28l-.308-1.232a9.002 9.002 0 012.786-.448c1.699 0 2.548.793 2.548 2.38V194h-1.344zm-.476-3.066h-.602c-.523 0-.877.07-1.064.21-.187.14-.28.345-.28.616 0 .261.07.476.21.644.14.168.322.252.546.252.317 0 .714-.252 1.19-.756v-.966zm3.681 1.204a4.198 4.198 0 001.918.476c.663 0 .994-.243.994-.728 0-.448-.373-.779-1.12-.994a12.374 12.374 0 01-.952-.294 2.01 2.01 0 01-.798-.574c-.215-.271-.322-.616-.322-1.036 0-.681.21-1.204.63-1.568.42-.373 1.003-.56 1.75-.56.756 0 1.47.131 2.142.392l-.294 1.456a4.75 4.75 0 00-1.806-.378c-.411 0-.616.14-.616.42 0 .289.275.509.826.658a5.446 5.446 0 011.54.644c.233.14.429.35.588.63.159.28.238.616.238 1.008 0 .737-.247 1.321-.742 1.75-.495.429-1.176.644-2.044.644-.868 0-1.643-.201-2.324-.602l.392-1.344zM735.858 118h-5.838v-9.8h5.838v1.61h-3.808v2.058h3.458v1.638h-3.458v2.884h3.808V118zm2.898-7l1.05 1.904 1.05-1.904h1.862l-1.96 3.43 2.044 3.57h-1.862l-1.134-2.212-1.134 2.212h-1.862l2.044-3.57-1.96-3.43h1.862zm5.307 5.488v-3.948h-.714V111h.728v-2.002h1.806V111h1.47v1.54h-1.484v3.052c0 .625.191.938.574.938.215 0 .443-.028.686-.084l.294 1.456a5.037 5.037 0 01-1.372.182c-.476 0-.929-.121-1.358-.364-.42-.252-.63-.663-.63-1.232zm10.006 1.078c-.887.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.019.77-.056 1.078h-4.046c0 .551.149.957.448 1.218.299.261.7.392 1.204.392s1.171-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.187-.261-.481-.392-.882-.392s-.7.145-.896.434c-.196.289-.299.653-.308 1.092h2.366zm5.28-.406V118h-1.834v-7h1.456l.168.686c.373-.299.686-.509.938-.63.252-.131.471-.196.658-.196.196 0 .326.005.392.014.065 0 .121.005.168.014.046.009.126.028.238.056l-.168 1.666c-.168-.056-.397-.084-.686-.084-.392 0-.836.275-1.33.826zm9.57 4.648h-1.848v-4.186c0-.383-.074-.691-.224-.924-.149-.243-.396-.364-.742-.364-.345 0-.774.215-1.288.644V118h-1.834v-7h1.54l.294.63c.402-.299.747-.499 1.036-.602a2.943 2.943 0 011.036-.168c.626 0 1.12.21 1.484.63.364.411.546 1.022.546 1.834V118zm5.977 0l-.28-.7c-.326.299-.616.509-.868.63a2.23 2.23 0 01-.91.168c-.597 0-1.12-.205-1.568-.616-.438-.42-.658-.975-.658-1.666s.271-1.232.812-1.624c.542-.401 1.358-.602 2.45-.602h.574c0-.401-.098-.723-.294-.966-.186-.243-.476-.364-.868-.364-.681 0-1.372.093-2.072.28l-.308-1.232a9.002 9.002 0 012.786-.448c1.699 0 2.548.793 2.548 2.38V118h-1.344zm-.476-3.066h-.602c-.522 0-.877.07-1.064.21-.186.14-.28.345-.28.616 0 .261.07.476.21.644.14.168.322.252.546.252.318 0 .714-.252 1.19-.756v-.966zm5.627 3.066h-1.82v-9.8h1.82v9.8zm11.253-9.45l-.336 1.638-.868-.238c-.616-.14-1.153-.21-1.61-.21-.635 0-.952.303-.952.91 0 .233.107.448.322.644a3 3 0 00.84.476c.336.121.695.275 1.078.462.383.187.742.387 1.078.602.336.215.611.509.826.882.224.373.336.803.336 1.288 0 .961-.313 1.717-.938 2.268-.616.541-1.489.812-2.618.812a6.938 6.938 0 01-1.736-.224c-.569-.159-1.041-.341-1.414-.546l.602-1.498c.859.392 1.708.588 2.548.588.476 0 .849-.107 1.12-.322a1.06 1.06 0 00.406-.854c0-.345-.154-.63-.462-.854a4.862 4.862 0 00-1.12-.616 21.006 21.006 0 01-1.316-.616 3.35 3.35 0 01-1.12-.966c-.308-.42-.462-.915-.462-1.484 0-.849.266-1.498.798-1.946.532-.457 1.246-.686 2.142-.686.905 0 1.857.163 2.856.49zm7.459 9.016c-.887.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.019.77-.056 1.078h-4.046c0 .551.149.957.448 1.218.299.261.7.392 1.204.392s1.171-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.187-.261-.481-.392-.882-.392s-.7.145-.896.434c-.196.289-.299.653-.308 1.092h2.366zm5.28-.406V118h-1.834v-7h1.456l.168.686c.373-.299.686-.509.938-.63.252-.131.471-.196.658-.196.196 0 .326.005.392.014.065 0 .121.005.168.014.046.009.126.028.238.056l-.168 1.666c-.168-.056-.397-.084-.686-.084-.392 0-.836.275-1.33.826zm8.996-2.352l-2.226 7h-2.044l-2.212-7h1.89l1.358 5.18 1.372-5.18h1.862zm2.91-1.05h-1.82v-1.75h1.82v1.75zm0 8.05h-1.82v-7h1.82v7zm6.555-1.526l.224 1.26c-.812.233-1.456.35-1.932.35-1.158 0-1.993-.303-2.506-.91-.514-.607-.77-1.489-.77-2.646 0-1.167.266-2.067.798-2.702.532-.644 1.306-.966 2.324-.966.597 0 1.278.112 2.044.336l-.658 1.274c-.514-.159-.938-.238-1.274-.238-.336 0-.602.065-.798.196a1.096 1.096 0 00-.406.56c-.14.401-.21.952-.21 1.652 0 .691.144 1.199.434 1.526.289.327.709.49 1.26.49.55 0 1.04-.061 1.47-.182zm6.771 1.092c-.886.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.018.77-.056 1.078h-4.046c0 .551.15.957.448 1.218.299.261.7.392 1.204.392s1.172-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.186-.261-.48-.392-.882-.392-.401 0-.7.145-.896.434-.196.289-.298.653-.308 1.092h2.366zm3.32 2.38a4.198 4.198 0 001.918.476c.663 0 .994-.243.994-.728 0-.448-.373-.779-1.12-.994a12.374 12.374 0 01-.952-.294 2.01 2.01 0 01-.798-.574c-.215-.271-.322-.616-.322-1.036 0-.681.21-1.204.63-1.568.42-.373 1.003-.56 1.75-.56.756 0 1.47.131 2.142.392l-.294 1.456a4.75 4.75 0 00-1.806-.378c-.411 0-.616.14-.616.42 0 .289.275.509.826.658a5.446 5.446 0 011.54.644c.233.14.429.35.588.63.159.28.238.616.238 1.008 0 .737-.247 1.321-.742 1.75-.495.429-1.176.644-2.044.644-.868 0-1.643-.201-2.324-.602l.392-1.344zM758.658 34.75c0 1.577-.458 2.847-1.372 3.808-.915.961-2.138 1.442-3.668 1.442h-2.604v-9.8h3.038c1.39 0 2.506.425 3.346 1.274.84.85 1.26 1.941 1.26 3.276zm-2.114-.112c0-.877-.238-1.568-.714-2.072s-1.05-.756-1.722-.756h-1.12v6.58h.756c.784 0 1.446-.331 1.988-.994.541-.672.812-1.591.812-2.758zM763.928 40l-.28-.7c-.327.299-.616.509-.868.63a2.23 2.23 0 01-.91.168c-.597 0-1.12-.205-1.568-.616-.439-.42-.658-.975-.658-1.666 0-.69.271-1.232.812-1.624.541-.401 1.358-.602 2.45-.602h.574c0-.401-.098-.723-.294-.966-.187-.243-.476-.364-.868-.364-.681 0-1.372.093-2.072.28l-.308-1.232a9.011 9.011 0 012.786-.448c1.699 0 2.548.793 2.548 2.38V40h-1.344zm-.476-3.066h-.602c-.523 0-.877.07-1.064.21-.187.14-.28.345-.28.616 0 .261.07.476.21.644.14.168.322.252.546.252.317 0 .714-.252 1.19-.756v-.966zm3.737 1.554V34.54h-.714V33h.728v-2.002h1.806V33h1.47v1.54h-1.484v3.052c0 .625.191.938.574.938.215 0 .443-.028.686-.084l.294 1.456a5.025 5.025 0 01-1.372.182c-.476 0-.929-.121-1.358-.364-.42-.252-.63-.663-.63-1.232zm8.62 1.512l-.28-.7c-.327.299-.616.509-.868.63a2.23 2.23 0 01-.91.168c-.597 0-1.12-.205-1.568-.616-.439-.42-.658-.975-.658-1.666 0-.69.271-1.232.812-1.624.541-.401 1.358-.602 2.45-.602h.574c0-.401-.098-.723-.294-.966-.187-.243-.476-.364-.868-.364-.681 0-1.372.093-2.072.28l-.308-1.232a9.011 9.011 0 012.786-.448c1.699 0 2.548.793 2.548 2.38V40h-1.344zm-.476-3.066h-.602c-.523 0-.877.07-1.064.21-.187.14-.28.345-.28.616 0 .261.07.476.21.644.14.168.322.252.546.252.317 0 .714-.252 1.19-.756v-.966zm7.489-4.074c.719 0 1.293.308 1.722.924.439.607.658 1.489.658 2.646 0 1.148-.247 2.03-.742 2.646-.495.616-1.129.924-1.904.924-.597 0-1.185-.261-1.764-.784l-.266.784h-1.386v-9.8h1.82v3.444c.719-.523 1.339-.784 1.862-.784zm.588 3.57c0-1.297-.392-1.946-1.176-1.946-.355 0-.779.21-1.274.63v2.702c.495.42.915.63 1.26.63.355 0 .639-.168.854-.504.224-.336.336-.84.336-1.512zm7 3.57l-.28-.7c-.326.299-.616.509-.868.63a2.23 2.23 0 01-.91.168c-.597 0-1.12-.205-1.568-.616-.438-.42-.658-.975-.658-1.666 0-.69.271-1.232.812-1.624.542-.401 1.358-.602 2.45-.602h.574c0-.401-.098-.723-.294-.966-.186-.243-.476-.364-.868-.364-.681 0-1.372.093-2.072.28l-.308-1.232a9.011 9.011 0 012.786-.448c1.699 0 2.548.793 2.548 2.38V40h-1.344zm-.476-3.066h-.602c-.522 0-.877.07-1.064.21-.186.14-.28.345-.28.616 0 .261.07.476.21.644.14.168.322.252.546.252.318 0 .714-.252 1.19-.756v-.966zm3.681 1.204a4.197 4.197 0 001.918.476c.663 0 .994-.243.994-.728 0-.448-.373-.78-1.12-.994a12.511 12.511 0 01-.952-.294 2.01 2.01 0 01-.798-.574c-.214-.27-.322-.616-.322-1.036 0-.681.21-1.204.63-1.568.42-.373 1.004-.56 1.75-.56.756 0 1.47.13 2.142.392l-.294 1.456a4.75 4.75 0 00-1.806-.378c-.41 0-.616.14-.616.42 0 .29.276.509.826.658.579.15 1.092.364 1.54.644.234.14.43.35.588.63.159.28.238.616.238 1.008 0 .737-.247 1.32-.742 1.75-.494.43-1.176.644-2.044.644-.868 0-1.642-.2-2.324-.602l.392-1.344zm11.443 1.428c-.887.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .41-.019.77-.056 1.078h-4.046c0 .55.149.957.448 1.218.299.261.7.392 1.204.392s1.171-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.43-.093-.775-.28-1.036-.187-.261-.481-.392-.882-.392s-.7.145-.896.434c-.196.29-.299.653-.308 1.092h2.366zm3.32 2.38a4.191 4.191 0 001.918.476c.662 0 .994-.243.994-.728 0-.448-.374-.78-1.12-.994a12.239 12.239 0 01-.952-.294 2.01 2.01 0 01-.798-.574c-.215-.27-.322-.616-.322-1.036 0-.681.21-1.204.63-1.568.42-.373 1.003-.56 1.75-.56.756 0 1.47.13 2.142.392l-.294 1.456a4.75 4.75 0 00-1.806-.378c-.411 0-.616.14-.616.42 0 .29.275.509.826.658.578.15 1.092.364 1.54.644.233.14.429.35.588.63.158.28.238.616.238 1.008 0 .737-.248 1.32-.742 1.75-.495.43-1.176.644-2.044.644-.868 0-1.643-.2-2.324-.602l.392-1.344z"
      fill="#707070"
    />
    <circle
      cx={885}
      cy={201}
      r={31}
      fill="#fff"
      stroke="#707070"
      strokeWidth={2}
    />
    <path
      d="M871.507 209.193l1.248.72 13.904-24.083-1.248-.72-13.904 24.083z"
      fill="#707070"
    />
    <path d="M899.03 207.269h-27.809v1.441h27.809v-1.441z" fill="#707070" />
    <path
      d="M871.771 208.078l13.91 8.031.721-1.248-13.91-8.031-.721 1.248zM883.855 187.147l13.91 8.031.72-1.248-13.91-8.031-.72 1.248z"
      fill="#707070"
    />
    <path
      d="M871.775 193.925l.721 1.248 13.909-8.031-.72-1.249-13.91 8.032z"
      fill="#707070"
    />
    <path
      d="M883.603 185.831l13.905 24.083 1.248-.721-13.904-24.083-1.249.721zM873.765 192.969h-1.442v16.062h1.442v-16.062z"
      fill="#707070"
    />
    <path d="M897.936 192.969h-1.441v16.062h1.441v-16.062z" fill="#707070" />
    <path
      d="M884.806 214.409l.63 1.091 12.098-6.985-.63-1.091-12.098 6.985z"
      fill="#707070"
    />
    <path
      d="M899.846 209.5a3.034 3.034 0 01-4.141 1.111 3.034 3.034 0 01-1.111-4.141 3.034 3.034 0 014.141-1.111 3.02 3.02 0 011.111 4.141zM875.657 195.53a3.035 3.035 0 01-4.141 1.112 3.035 3.035 0 01-1.111-4.142 3.034 3.034 0 014.141-1.111 3.036 3.036 0 011.111 4.141zM870.413 209.5a3.037 3.037 0 011.112-4.141 3.036 3.036 0 014.141 1.111 3.033 3.033 0 01-5.253 3.03zM894.602 195.53a3.037 3.037 0 011.112-4.141 3.036 3.036 0 014.141 1.111 3.037 3.037 0 01-1.111 4.142 3.036 3.036 0 01-4.142-1.112zM885.13 218a3.027 3.027 0 01-3.03-3.03 3.027 3.027 0 013.03-3.03 3.027 3.027 0 013.03 3.03 3.032 3.032 0 01-3.03 3.03zM885.13 190.06a3.027 3.027 0 01-3.03-3.03 3.027 3.027 0 013.03-3.03 3.027 3.027 0 013.03 3.03 3.027 3.027 0 01-3.03 3.03z"
      fill="#707070"
    />
    <circle
      cx={885}
      cy={126}
      r={31}
      fill="#fff"
      stroke="#707070"
      strokeWidth={2}
    />
    <circle
      cx={885}
      cy={51}
      r={31}
      fill="#fff"
      stroke="#707070"
      strokeWidth={2}
    />
    <path
      d="M884.5 47.083c8.008 0 14.5-2.705 14.5-6.041 0-3.337-6.492-6.042-14.5-6.042S870 37.705 870 41.042c0 3.336 6.492 6.041 14.5 6.041zM899 47.536c0 3.337-6.495 6.042-14.5 6.042-8.005 0-14.5-2.705-14.5-6.042m29 6.495c0 3.337-6.495 6.042-14.5 6.042-8.005 0-14.5-2.705-14.5-6.042"
      stroke="#707070"
      strokeWidth={2}
      strokeMiterlimit={10}
      strokeLinecap="round"
    />
    <path
      d="M870 40.984v19.448c0 3.305 6.495 5.985 14.5 5.985 8.005 0 14.5-2.68 14.5-5.985V40.984"
      stroke="#707070"
      strokeWidth={2}
      strokeMiterlimit={10}
      strokeLinecap="round"
    />
    <path
      d="M489.47 127.47a.749.749 0 000 1.06l4.773 4.773a.749.749 0 101.06-1.06L491.061 128l4.242-4.243a.749.749 0 10-1.06-1.06l-4.773 4.773zm21.06 1.06a.749.749 0 000-1.06l-4.773-4.773a.749.749 0 10-1.06 1.06l4.242 4.243-4.242 4.243a.749.749 0 101.06 1.06l4.773-4.773zm-20.53.22h20v-1.5h-20v1.5zM310.47 127.47a.749.749 0 000 1.06l4.773 4.773a.749.749 0 101.06-1.06L312.061 128l4.242-4.243a.749.749 0 10-1.06-1.06l-4.773 4.773zm21.06 1.06a.749.749 0 000-1.06l-4.773-4.773a.749.749 0 10-1.06 1.06l4.242 4.243-4.242 4.243a.749.749 0 101.06 1.06l4.773-4.773zm-20.53.22h20v-1.5h-20v1.5zM669.47 127.47a.749.749 0 000 1.06l4.773 4.773a.749.749 0 101.06-1.06L671.061 128l4.242-4.243a.749.749 0 10-1.06-1.06l-4.773 4.773zm.53 1.28h20v-1.5h-20v1.5z"
      fill="#FF9A00"
    />
    <rect
      x={304}
      y={1}
      width={392}
      height={249}
      rx={8}
      stroke="#FF9A00"
      strokeWidth={2}
      strokeLinecap="round"
      strokeDasharray="2 6"
    />
    <path
      d="M367.43 197.084c-1.437 0-2.58-.457-3.43-1.372-.849-.915-1.274-2.133-1.274-3.654 0-1.531.402-2.744 1.204-3.64.812-.905 1.937-1.358 3.374-1.358.952 0 1.918.168 2.898.504l-.252 1.568c-.354-.131-.816-.238-1.386-.322-.569-.093-1.012-.14-1.33-.14-.774 0-1.381.299-1.82.896-.438.588-.658 1.386-.658 2.394 0 1.008.234 1.848.7 2.52.476.663 1.083.994 1.82.994.43 0 .822-.093 1.176-.28v-1.904h-1.624v-1.61h3.654v4.648a6.59 6.59 0 01-3.052.756zm10.213-.518c-.887.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.019.77-.056 1.078h-4.046c0 .551.149.957.448 1.218.299.261.7.392 1.204.392s1.171-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.187-.261-.481-.392-.882-.392s-.7.145-.896.434c-.196.289-.299.653-.308 1.092h2.366zm9.382 4.242h-1.848v-4.186c0-.383-.075-.691-.224-.924-.15-.243-.397-.364-.742-.364-.346 0-.775.215-1.288.644V197h-1.834v-7h1.54l.294.63c.401-.299.746-.499 1.036-.602a2.939 2.939 0 011.036-.168c.625 0 1.12.21 1.484.63.364.411.546 1.022.546 1.834V197zm7.363-.434c-.887.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.019.77-.056 1.078h-4.046c0 .551.149.957.448 1.218.299.261.7.392 1.204.392s1.171-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.187-.261-.481-.392-.882-.392s-.7.145-.896.434c-.196.289-.299.653-.308 1.092h2.366zm5.279-.406V197h-1.834v-7h1.456l.168.686c.374-.299.686-.509.938-.63.252-.131.472-.196.658-.196.196 0 .327.005.392.014.066 0 .122.005.168.014.047.009.126.028.238.056l-.168 1.666c-.168-.056-.396-.084-.686-.084-.392 0-.835.275-1.33.826zm7.345 4.648l-.28-.7c-.326.299-.616.509-.868.63a2.23 2.23 0 01-.91.168c-.597 0-1.12-.205-1.568-.616-.438-.42-.658-.975-.658-1.666s.271-1.232.812-1.624c.542-.401 1.358-.602 2.45-.602h.574c0-.401-.098-.723-.294-.966-.186-.243-.476-.364-.868-.364-.681 0-1.372.093-2.072.28l-.308-1.232a9.002 9.002 0 012.786-.448c1.699 0 2.548.793 2.548 2.38V197h-1.344zm-.476-3.066h-.602c-.522 0-.877.07-1.064.21-.186.14-.28.345-.28.616 0 .261.07.476.21.644.14.168.322.252.546.252.318 0 .714-.252 1.19-.756v-.966zm3.737 1.554v-3.948h-.714V190h.728v-2.002h1.806V190h1.47v1.54h-1.484v3.052c0 .625.192.938.574.938.215 0 .444-.028.686-.084l.294 1.456a5.032 5.032 0 01-1.372.182c-.476 0-.928-.121-1.358-.364-.42-.252-.63-.663-.63-1.232zm10.006 1.078c-.887.345-1.708.518-2.464.518-2.193 0-3.29-1.185-3.29-3.556 0-1.204.266-2.114.798-2.73.532-.625 1.307-.938 2.324-.938.84 0 1.512.261 2.016.784s.756 1.297.756 2.324c0 .411-.019.77-.056 1.078h-4.046c0 .551.149.957.448 1.218.299.261.7.392 1.204.392s1.171-.112 2.002-.336l.308 1.246zm-1.61-3.808v-.098c0-.429-.093-.775-.28-1.036-.187-.261-.481-.392-.882-.392s-.7.145-.896.434c-.196.289-.299.653-.308 1.092h2.366zm8.752 4.242h-1.372l-.28-.798c-.784.588-1.498.882-2.142.882-.635 0-1.162-.299-1.582-.896-.411-.607-.616-1.498-.616-2.674 0-1.185.233-2.091.7-2.716.476-.625 1.096-.938 1.862-.938.504 0 1.045.233 1.624.7v-3.36h1.806v9.8zm-1.82-2.156v-2.786c-.495-.411-.91-.616-1.246-.616-.336 0-.607.173-.812.518-.196.345-.294.859-.294 1.54 0 1.307.354 1.96 1.064 1.96.364 0 .793-.205 1.288-.616zm9.66-2.1h-.168v4.242h-2.03v-9.8h3.108c1.054 0 1.843.233 2.366.7.522.457.784 1.115.784 1.974 0 .523-.182 1.003-.546 1.442-.364.429-.808.677-1.33.742.373.103.662.275.868.518.205.233.42.616.644 1.148l1.386 3.276h-2.086l-1.358-3.136c-.196-.448-.406-.742-.63-.882-.215-.149-.551-.224-1.008-.224zm.854-3.962h-1.022v2.366h.882c.373 0 .662-.121.868-.364.214-.243.322-.541.322-.896 0-.737-.35-1.106-1.05-1.106zM444.116 197h-5.838v-9.8h5.838v1.61h-3.808v2.058h3.458v1.638h-3.458v2.884h3.808V197zm7.238-9.45l-.336 1.638-.868-.238c-.616-.14-1.153-.21-1.61-.21-.635 0-.952.303-.952.91 0 .233.107.448.322.644a3 3 0 00.84.476c.336.121.695.275 1.078.462.383.187.742.387 1.078.602.336.215.611.509.826.882.224.373.336.803.336 1.288 0 .961-.313 1.717-.938 2.268-.616.541-1.489.812-2.618.812a6.938 6.938 0 01-1.736-.224c-.569-.159-1.041-.341-1.414-.546l.602-1.498c.859.392 1.708.588 2.548.588.476 0 .849-.107 1.12-.322a1.06 1.06 0 00.406-.854c0-.345-.154-.63-.462-.854a4.862 4.862 0 00-1.12-.616 21.006 21.006 0 01-1.316-.616 3.35 3.35 0 01-1.12-.966c-.308-.42-.462-.915-.462-1.484 0-.849.266-1.498.798-1.946.532-.457 1.246-.686 2.142-.686.905 0 1.857.163 2.856.49zm3.763 9.45v-8.162h-2.254V187.2h6.496v1.638h-2.226V197h-2.016zm-64.998 17h-5.838v-9.8h5.838v1.61h-3.808v2.058h3.458v1.638h-3.458v2.884h3.808V214zm7.826 0h-1.848v-4.186c0-.383-.075-.691-.224-.924-.149-.243-.397-.364-.742-.364s-.775.215-1.288.644V214h-1.834v-7h1.54l.294.63c.401-.299.747-.499 1.036-.602a2.943 2.943 0 011.036-.168c.625 0 1.12.21 1.484.63.364.411.546 1.022.546 1.834V214zm7.573 0h-1.372l-.28-.798c-.784.588-1.498.882-2.142.882-.635 0-1.162-.299-1.582-.896-.411-.607-.616-1.498-.616-2.674 0-1.185.233-2.091.7-2.716.476-.625 1.097-.938 1.862-.938.504 0 1.045.233 1.624.7v-3.36h1.806v9.8zm-1.82-2.156v-2.786c-.495-.411-.91-.616-1.246-.616-.336 0-.607.173-.812.518-.196.345-.294.859-.294 1.54 0 1.307.355 1.96 1.064 1.96.364 0 .793-.205 1.288-.616zm5.922 5.474h-1.82V207h1.386l.336.742c.345-.289.658-.509.938-.658.289-.149.611-.224.966-.224.775 0 1.363.322 1.764.966.411.644.616 1.545.616 2.702s-.261 2.044-.784 2.66c-.523.607-1.139.91-1.848.91-.513 0-1.031-.224-1.554-.672v3.892zm0-8.162v2.562c.299.485.667.728 1.106.728.448 0 .756-.159.924-.476.177-.317.266-.803.266-1.456 0-.653-.093-1.157-.28-1.512-.187-.355-.42-.532-.7-.532-.401 0-.84.229-1.316.686zm11.605 1.358c0 1.12-.285 1.997-.854 2.632-.57.635-1.377.952-2.422.952-1.046 0-1.839-.317-2.38-.952-.542-.635-.812-1.517-.812-2.646s.27-2.016.812-2.66c.541-.653 1.32-.98 2.338-.98 1.017 0 1.824.331 2.422.994.597.653.896 1.54.896 2.66zm-1.862-.028c0-1.428-.458-2.142-1.372-2.142-.934 0-1.4.709-1.4 2.128s.471 2.128 1.414 2.128c.504 0 .854-.177 1.05-.532.205-.364.308-.891.308-1.582zm5.226-4.536h-1.82v-1.75h1.82v1.75zm0 8.05h-1.82v-7h1.82v7zm8.151 0h-1.848v-4.186c0-.383-.075-.691-.224-.924-.149-.243-.397-.364-.742-.364s-.775.215-1.288.644V214h-1.834v-7h1.54l.294.63c.401-.299.747-.499 1.036-.602a2.943 2.943 0 011.036-.168c.625 0 1.12.21 1.484.63.364.411.546 1.022.546 1.834V214zm2.197-1.512v-3.948h-.714V207h.728v-2.002h1.806V207h1.47v1.54h-1.484v3.052c0 .625.191.938.574.938.215 0 .443-.028.686-.084l.294 1.456a5.037 5.037 0 01-1.372.182c-.476 0-.929-.121-1.358-.364-.42-.252-.63-.663-.63-1.232zM567.504 214.084c-1.438 0-2.581-.457-3.43-1.372-.85-.915-1.274-2.133-1.274-3.654 0-1.531.401-2.744 1.204-3.64.812-.905 1.936-1.358 3.374-1.358.952 0 1.918.168 2.898.504l-.252 1.568c-.355-.131-.817-.238-1.386-.322-.57-.093-1.013-.14-1.33-.14-.775 0-1.382.299-1.82.896-.439.588-.658 1.386-.658 2.394 0 1.008.233 1.848.7 2.52.476.663 1.082.994 1.82.994.429 0 .821-.093 1.176-.28v-1.904h-1.624v-1.61h3.654v4.648a6.594 6.594 0 01-3.052.756zm6.95-4.732V214h-1.834v-7h1.456l.168.686c.374-.299.686-.509.938-.63.252-.131.472-.196.658-.196.196 0 .327.005.392.014.066 0 .122.005.168.014.047.009.126.028.238.056l-.168 1.666c-.168-.056-.396-.084-.686-.084-.392 0-.835.275-1.33.826zm7.345 4.648l-.28-.7c-.327.299-.616.509-.868.63a2.23 2.23 0 01-.91.168c-.597 0-1.12-.205-1.568-.616-.439-.42-.658-.975-.658-1.666s.271-1.232.812-1.624c.541-.401 1.358-.602 2.45-.602h.574c0-.401-.098-.723-.294-.966-.187-.243-.476-.364-.868-.364-.681 0-1.372.093-2.072.28l-.308-1.232a9.002 9.002 0 012.786-.448c1.699 0 2.548.793 2.548 2.38V214h-1.344zm-.476-3.066h-.602c-.523 0-.877.07-1.064.21-.187.14-.28.345-.28.616 0 .261.07.476.21.644.14.168.322.252.546.252.317 0 .714-.252 1.19-.756v-.966zm5.627 6.384h-1.82V207h1.386l.336.742c.345-.289.658-.509.938-.658.289-.149.611-.224.966-.224.775 0 1.363.322 1.764.966.411.644.616 1.545.616 2.702s-.261 2.044-.784 2.66c-.523.607-1.139.91-1.848.91-.513 0-1.031-.224-1.554-.672v3.892zm0-8.162v2.562c.299.485.667.728 1.106.728.448 0 .756-.159.924-.476.177-.317.266-.803.266-1.456 0-.653-.093-1.157-.28-1.512-.187-.355-.42-.532-.7-.532-.401 0-.84.229-1.316.686zM598.695 214h-1.82v-4.186c0-.383-.075-.691-.224-.924-.15-.243-.402-.364-.756-.364-.355 0-.789.215-1.302.644V214h-1.82v-9.8h1.82v3.43c.401-.299.746-.499 1.036-.602a2.939 2.939 0 011.036-.168c.625 0 1.12.21 1.484.63.364.411.546 1.022.546 1.834V214zm8.945-1.554l1.302 1.344-1.106 1.106-1.33-1.414c-.569.411-1.302.616-2.198.616-.896 0-1.661-.238-2.296-.714-1.213-.887-1.82-2.338-1.82-4.354 0-1.465.35-2.66 1.05-3.584.709-.924 1.745-1.386 3.108-1.386 1.372 0 2.413.462 3.122 1.386.709.924 1.064 2.105 1.064 3.542 0 1.428-.299 2.581-.896 3.458zm-1.946-2.058l.448.546c.243-.476.364-1.143.364-2.002 0-.868-.191-1.629-.574-2.282-.373-.663-.91-.994-1.61-.994-.7 0-1.223.327-1.568.98s-.518 1.461-.518 2.422c0 .961.182 1.773.546 2.436.364.653.891.98 1.582.98.364 0 .658-.084.882-.252l-.672-.728 1.12-1.106zM615.751 214h-5.81v-9.8h2.03v8.19h3.78V214z"
      fill="#707070"
    />
    <rect
      x={515}
      y={69}
      width={148}
      height={123}
      rx={7}
      fill="#fff"
      stroke="#FF9A00"
      strokeWidth={2}
    />
    <path
      d="M522.946 91.818l.784.453 8.73-15.122-.783-.452-8.731 15.121z"
      fill="#E535AB"
    />
    <path d="M540.228 90.61h-17.461v.905h17.461v-.905z" fill="#E535AB" />
    <path
      d="M523.112 91.119l8.734 5.043.453-.784-8.734-5.043-.453.784zM530.699 77.976l8.734 5.043.453-.784-8.734-5.043-.453.784z"
      fill="#E535AB"
    />
    <path
      d="M523.114 82.232l.453.783 8.734-5.042-.453-.784-8.734 5.043z"
      fill="#E535AB"
    />
    <path
      d="M530.542 77.15l8.73 15.121.784-.452-8.731-15.122-.783.452zM524.364 81.632h-.905v10.085h.905V81.632z"
      fill="#E535AB"
    />
    <path d="M539.541 81.632h-.905v10.085h.905V81.632z" fill="#E535AB" />
    <path
      d="M531.297 95.094l.395.684 7.596-4.385-.395-.685-7.596 4.386z"
      fill="#E535AB"
    />
    <path
      d="M540.74 92.011a1.905 1.905 0 01-2.6.698 1.906 1.906 0 01-.698-2.6 1.906 1.906 0 012.601-.698 1.897 1.897 0 01.697 2.6zM525.552 83.24a1.905 1.905 0 01-2.6.698 1.905 1.905 0 01-.698-2.6 1.905 1.905 0 012.6-.699 1.906 1.906 0 01.698 2.6zM522.259 92.011a1.908 1.908 0 01.698-2.6 1.907 1.907 0 012.601.698 1.905 1.905 0 01-3.299 1.903zM537.448 83.24a1.906 1.906 0 01.698-2.6 1.906 1.906 0 012.6.697c.523.91.213 2.072-.698 2.6a1.905 1.905 0 01-2.6-.697zM531.5 97.349a1.901 1.901 0 01-1.903-1.903c0-1.052.851-1.903 1.903-1.903s1.903.85 1.903 1.903a1.905 1.905 0 01-1.903 1.903zM531.5 79.805a1.901 1.901 0 01-1.903-1.902c0-1.053.851-1.903 1.903-1.903s1.903.85 1.903 1.903a1.901 1.901 0 01-1.903 1.902z"
      fill="#E535AB"
    />
    <path
      d="M550.607 86.046v.113c0 .422.05.814.15 1.176.104.358.253.668.446.93.193.264.432.472.714.622.283.147.607.22.973.22.172 0 .331-.017.478-.053a1.81 1.81 0 00.413-.14 1.74 1.74 0 00.527-.408v2.728h1.498V83.19h-1.316l-.091.59a2.008 2.008 0 00-.516-.45 1.798 1.798 0 00-.451-.183 2.057 2.057 0 00-.532-.065c-.368 0-.696.072-.983.215a2.03 2.03 0 00-.714.601 2.77 2.77 0 00-.446.94c-.1.366-.15.769-.15 1.209zm1.493.113v-.113c0-.247.022-.476.065-.688.046-.214.118-.4.214-.558a1.05 1.05 0 01.36-.37c.151-.094.331-.14.543-.14.125 0 .24.012.343.037a.946.946 0 01.511.29c.064.068.121.147.172.236v2.471a1.498 1.498 0 01-.172.253.948.948 0 01-.226.182 1.317 1.317 0 01-.29.113c-.104.025-.22.038-.349.038-.211 0-.392-.047-.542-.14a1.082 1.082 0 01-.36-.381 1.78 1.78 0 01-.204-.554 3.388 3.388 0 01-.065-.676zM561.156 89h1.353v-5.811h-1.498v4.076a1.232 1.232 0 01-.167.253c-.064.075-.138.14-.22.193-.097.06-.209.107-.338.14a1.715 1.715 0 01-.425.048c-.175 0-.324-.022-.445-.064a.617.617 0 01-.296-.215.956.956 0 01-.166-.387 3.037 3.037 0 01-.049-.596v-3.448h-1.493v3.437c0 .44.048.818.145 1.133.1.312.24.568.419.768.179.204.394.353.645.446.25.093.526.14.827.14.329 0 .632-.083.907-.247.28-.165.518-.392.715-.682l.086.816zm5.634.107c.562 0 1.049-.109 1.461-.327.412-.219.713-.462.902-.73l-.746-.806a1.574 1.574 0 01-.672.5c-.275.11-.56.166-.854.166-.207 0-.399-.033-.574-.097a1.487 1.487 0 01-.785-.655 2.126 2.126 0 01-.193-.564v-.016h3.942v-.634a3.64 3.64 0 00-.177-1.166 2.541 2.541 0 00-.515-.907 2.329 2.329 0 00-.838-.58 2.817 2.817 0 00-1.117-.21 2.83 2.83 0 00-1.123.22 2.643 2.643 0 00-.892.618c-.25.265-.445.582-.585.95-.14.366-.21.77-.21 1.215v.214c0 .39.07.758.21 1.101.143.34.345.636.607.887.261.254.575.454.94.601.365.147.771.22 1.219.22zm-.177-4.817c.19 0 .356.03.499.09.147.058.271.137.371.237a1.15 1.15 0 01.322.811v.118h-2.449c.036-.19.089-.361.161-.515.072-.154.161-.287.269-.398.103-.11.225-.195.365-.252.14-.061.293-.091.462-.091zm8.137-1.209c-.39 0-.75.095-1.08.285a2.636 2.636 0 00-.848.773l-.011-.129-.059-.822h-1.391V89h1.493v-3.491c.068-.165.154-.308.258-.43.104-.122.229-.222.376-.3.122-.069.259-.119.413-.151.158-.036.333-.054.527-.054.186 0 .381.013.585.038.208.021.41.055.607.102l.22-1.488a3.367 3.367 0 00-.467-.097 3.731 3.731 0 00-.623-.048zm3.352 8.266c.3 0 .56-.05.778-.15.222-.1.41-.224.564-.37.154-.148.281-.307.382-.479.104-.172.188-.331.252-.478l2.949-6.681h-1.649l-1.327 3.416-.22.58-.161-.591-1.332-3.405h-1.633l2.46 5.564-.344.64c-.043.078-.08.139-.113.182a4.43 4.43 0 01-.139.193 1.248 1.248 0 01-.236.236.472.472 0 01-.312.113c-.057 0-.134-.003-.231-.01a6.367 6.367 0 00-.231-.006l-.183 1.139a2.303 2.303 0 00.726.108zm16.586-.413l.182-.849a.604.604 0 01-.44-.14.983.983 0 01-.263-.386 2.161 2.161 0 01-.135-.543 5.52 5.52 0 01-.032-.585v-.876c0-.426-.104-.802-.312-1.128-.207-.326-.533-.575-.977-.746.44-.172.764-.423.972-.752.211-.33.317-.707.317-1.134v-.875c0-.193.004-.389.011-.585.01-.201.043-.382.096-.543a.826.826 0 01.258-.387c.118-.1.287-.147.505-.14l-.182-.843c-.348 0-.647.067-.897.2a1.77 1.77 0 00-.607.51c-.187.24-.323.522-.409.848a3.638 3.638 0 00-.129.94v.875c0 .484-.111.83-.333 1.037-.222.208-.56.312-1.015.312v1.074c.455 0 .793.104 1.015.311.222.208.333.55.333 1.026v.876c0 .282.038.57.113.864.079.298.204.57.376.817.161.236.371.431.629.585.261.158.569.237.924.237zm-25.562 5.246h-1.498l-.005 5.183a2.873 2.873 0 01-.081.671 1.3 1.3 0 01-.226.484.885.885 0 01-.354.284 1.2 1.2 0 01-.483.092c-.169 0-.317-.029-.446-.086a.885.885 0 01-.328-.269 1.363 1.363 0 01-.22-.489 3.138 3.138 0 01-.075-.687l-.006-5.183h-1.509l-.005 5.183c0 .437.061.827.182 1.171.126.34.301.626.527.859.225.233.496.41.811.532.318.122.675.182 1.069.182.418 0 .791-.06 1.117-.182.329-.122.608-.301.838-.537.225-.233.397-.52.515-.86.122-.34.183-.728.183-1.165l-.006-5.183zm5.2 6.225a.466.466 0 01-.07.247.59.59 0 01-.199.199 1.27 1.27 0 01-.36.139 2.329 2.329 0 01-.505.049c-.161 0-.318-.017-.472-.049a1.273 1.273 0 01-.403-.156.867.867 0 01-.29-.268.841.841 0 01-.129-.408h-1.423c0 .236.057.472.171.709.119.232.291.44.516.623.226.186.505.336.838.451.337.115.723.172 1.16.172.398 0 .757-.043 1.08-.129.322-.09.598-.213.827-.371.225-.157.399-.343.521-.558.125-.219.188-.457.188-.715a1.33 1.33 0 00-.188-.719 1.612 1.612 0 00-.51-.521 3.038 3.038 0 00-.779-.344 7.76 7.76 0 00-.978-.22 4.42 4.42 0 01-.601-.124 1.482 1.482 0 01-.371-.166.503.503 0 01-.193-.194.55.55 0 01.005-.483.617.617 0 01.183-.204.958.958 0 01.333-.15c.136-.037.295-.054.478-.054.215 0 .397.026.548.08a.951.951 0 01.365.215.684.684 0 01.145.231.736.736 0 01.048.269h1.493c0-.269-.059-.518-.177-.747a1.751 1.751 0 00-.51-.596 2.618 2.618 0 00-.822-.387 3.79 3.79 0 00-1.09-.145c-.387 0-.734.048-1.042.145-.308.097-.57.228-.784.392a1.75 1.75 0 00-.495.575 1.466 1.466 0 00-.171.687c0 .247.055.466.166.656.115.189.272.356.473.499.2.147.44.272.719.376.283.1.595.185.935.253.269.05.491.1.666.15.176.05.317.104.424.161a.574.574 0 01.215.193.434.434 0 01.065.237zm5.677 1.702c.562 0 1.049-.109 1.461-.327.412-.219.712-.462.902-.731l-.746-.805a1.573 1.573 0 01-.672.499c-.275.111-.56.167-.854.167-.207 0-.399-.033-.574-.097a1.48 1.48 0 01-.468-.274 1.47 1.47 0 01-.317-.381 2.146 2.146 0 01-.193-.564v-.016h3.942v-.634a3.64 3.64 0 00-.177-1.166 2.541 2.541 0 00-.515-.907 2.329 2.329 0 00-.838-.58 2.818 2.818 0 00-1.118-.21c-.404 0-.778.073-1.122.22a2.643 2.643 0 00-.892.618c-.25.265-.446.582-.585.95-.14.366-.21.77-.21 1.214v.215c0 .391.07.758.21 1.101.143.341.345.636.607.887.261.254.574.454.94.601.365.147.771.22 1.219.22zm-.177-4.817c.189 0 .356.03.499.09.147.058.271.137.371.237a1.17 1.17 0 01.322.81v.119h-2.449c.036-.189.089-.361.161-.515.072-.154.161-.287.269-.398a1.139 1.139 0 01.827-.344zm8.137-1.209c-.39 0-.75.095-1.08.285a2.636 2.636 0 00-.848.773l-.011-.129-.059-.822h-1.391V104h1.493v-3.491a1.59 1.59 0 01.258-.43 1.443 1.443 0 01.789-.451c.158-.036.333-.054.527-.054.186 0 .381.013.585.038.208.021.41.055.607.102l.22-1.488a3.367 3.367 0 00-.467-.097 3.74 3.74 0 00-.623-.048zm6.182 4.324a.457.457 0 01-.07.247.59.59 0 01-.199.199 1.275 1.275 0 01-.359.139 2.342 2.342 0 01-.505.049c-.161 0-.319-.017-.473-.049a1.282 1.282 0 01-.403-.156.867.867 0 01-.29-.268.841.841 0 01-.129-.408h-1.423c0 .236.057.472.172.709.118.232.29.44.515.623.226.186.505.336.838.451.337.115.724.172 1.16.172.398 0 .758-.043 1.08-.129.322-.09.598-.213.827-.371a1.7 1.7 0 00.521-.558c.126-.219.188-.457.188-.715 0-.279-.062-.519-.188-.719a1.612 1.612 0 00-.51-.521 3.023 3.023 0 00-.779-.344 7.743 7.743 0 00-.977-.22 4.438 4.438 0 01-.602-.124 1.5 1.5 0 01-.371-.166.503.503 0 01-.193-.194.55.55 0 01.005-.483.617.617 0 01.183-.204.958.958 0 01.333-.15 1.89 1.89 0 01.478-.054c.215 0 .398.026.548.08a.944.944 0 01.365.215.736.736 0 01.194.5h1.493c0-.269-.059-.518-.178-.747a1.751 1.751 0 00-.51-.596 2.597 2.597 0 00-.822-.387 3.785 3.785 0 00-1.09-.145c-.387 0-.734.048-1.042.145a2.515 2.515 0 00-.784.392c-.215.165-.38.356-.494.575a1.455 1.455 0 00-.172.687c0 .247.055.466.166.656.115.189.273.356.473.499.201.147.441.272.72.376.283.1.594.185.934.253.269.05.491.1.666.15.176.05.317.104.425.161a.582.582 0 01.215.193.434.434 0 01.064.237zm13.755 3.529l.183-.849a.601.601 0 01-.44-.14.988.988 0 01-.264-.386 2.214 2.214 0 01-.134-.543 5.518 5.518 0 01-.032-.585v-.876c0-.426-.104-.802-.312-1.128-.207-.326-.533-.574-.977-.746.44-.172.764-.423.972-.752.211-.33.317-.707.317-1.134v-.875c0-.193.003-.389.011-.585.01-.201.043-.382.096-.543a.826.826 0 01.258-.387c.118-.1.287-.147.505-.14l-.183-.843c-.347 0-.646.067-.897.2-.25.132-.453.302-.607.51-.186.24-.322.522-.408.848a3.638 3.638 0 00-.129.94v.875c0 .484-.111.83-.333 1.037-.222.208-.56.312-1.015.312v1.074c.455 0 .793.104 1.015.311.222.208.333.55.333 1.026v.876c0 .283.038.571.113.864.079.298.204.57.376.817.161.236.371.431.629.585.261.158.569.237.923.237zm-30.319 7.254v1.22h1.654v3.378h-1.654V119h4.737v-1.214h-1.574v-4.598h-3.163zm1.546-1.487c0 .114.02.222.06.322a.79.79 0 00.445.414c.108.039.226.059.355.059.265 0 .474-.074.628-.221a.758.758 0 00.237-.574.743.743 0 00-.237-.57c-.154-.15-.363-.225-.628-.225-.129 0-.247.019-.355.059a.826.826 0 00-.268.161.766.766 0 00-.237.575zm4.507 4.35v.113c0 .423.052.815.156 1.176.103.358.254.668.451.93.193.261.429.467.709.617.283.147.601.22.956.22.326 0 .612-.062.859-.188.247-.125.462-.3.645-.526l.075.607h1.348v-8.25h-1.499v2.959a1.87 1.87 0 00-.617-.461 1.815 1.815 0 00-.8-.167c-.362 0-.684.072-.967.215-.28.143-.518.345-.715.607a2.832 2.832 0 00-.451.94c-.1.365-.15.768-.15 1.208zm1.493.113v-.113c0-.243.021-.471.064-.682.043-.215.111-.403.205-.564.093-.157.213-.281.359-.37.151-.094.332-.14.543-.14.254 0 .465.055.634.166.168.108.302.26.402.457v2.353c-.1.193-.236.345-.408.456-.168.111-.381.167-.639.167a1.01 1.01 0 01-.537-.135 1.047 1.047 0 01-.36-.37 1.714 1.714 0 01-.204-.543 3.75 3.75 0 01-.059-.682zm-5.124 17.943c.562 0 1.049-.109 1.461-.327.412-.219.712-.462.902-.731l-.746-.805a1.573 1.573 0 01-.672.499c-.275.111-.56.167-.854.167-.207 0-.399-.033-.574-.097a1.48 1.48 0 01-.468-.274 1.47 1.47 0 01-.317-.381 2.146 2.146 0 01-.193-.564v-.016h3.942v-.634c0-.426-.059-.815-.177-1.166a2.537 2.537 0 00-.515-.907 2.322 2.322 0 00-.838-.58 2.811 2.811 0 00-1.118-.21c-.404 0-.778.073-1.122.22a2.646 2.646 0 00-.892.618c-.25.265-.446.582-.585.951a3.36 3.36 0 00-.21 1.213v.215c0 .391.07.758.21 1.101.143.341.345.636.607.887.261.254.574.454.94.601.365.147.771.22 1.219.22zm-.177-4.817c.189 0 .356.03.499.091.147.057.271.136.371.236a1.153 1.153 0 01.322.811v.118h-2.449c.036-.189.089-.361.161-.515.072-.154.161-.287.269-.398a1.137 1.137 0 01.827-.343zm4.893-1.102h-1.284V134h1.359v-4.351c.018-.046.038-.089.059-.128a.48.48 0 01.075-.103.448.448 0 01.134-.091.479.479 0 01.334-.005.31.31 0 01.134.08c.036.04.064.095.086.167a.99.99 0 01.032.274V134h1.316v-4.286-.102-.049a.538.538 0 01.15-.188.611.611 0 01.124-.059.535.535 0 01.311.006.303.303 0 01.14.08c.039.043.07.101.091.172a.845.845 0 01.038.274V134h1.359v-4.146c0-.323-.032-.595-.097-.817a1.56 1.56 0 00-.258-.553 1.023 1.023 0 00-.403-.306 1.215 1.215 0 00-.488-.097c-.14 0-.269.018-.387.054a1.145 1.145 0 00-.526.333 1.395 1.395 0 00-.167.231 1.049 1.049 0 00-.118-.237.769.769 0 00-.435-.333 1.28 1.28 0 00-.365-.048c-.28 0-.518.073-.715.22-.193.143-.345.34-.456.591l-.043-.704zm9.308 5.812h1.515v-.091a1.941 1.941 0 01-.172-.527 4.139 4.139 0 01-.059-.773v-2.492a1.99 1.99 0 00-.188-.887 1.767 1.767 0 00-.521-.639 2.36 2.36 0 00-.79-.381 3.548 3.548 0 00-.978-.129c-.39 0-.737.05-1.042.15-.3.097-.555.23-.762.398a1.744 1.744 0 00-.484.585 1.603 1.603 0 00-.161.704h1.493c0-.104.015-.199.043-.285a.591.591 0 01.145-.22.708.708 0 01.28-.156c.114-.039.25-.059.408-.059.179 0 .335.024.467.07a.897.897 0 01.339.188c.086.079.15.174.193.285a.974.974 0 01.064.365v.344h-.832c-.43 0-.811.039-1.144.118-.33.075-.607.186-.833.333a1.56 1.56 0 00-.564.618 1.864 1.864 0 00-.188.854 1.622 1.622 0 00.57 1.246c.179.154.392.274.639.36.25.085.524.128.822.128.182 0 .352-.017.51-.053a2.052 2.052 0 00.789-.344c.108-.079.203-.163.285-.252.018.103.039.202.065.295.025.093.055.175.091.247zm-1.423-1.047c-.14 0-.264-.016-.371-.049a.872.872 0 01-.263-.139.638.638 0 01-.167-.221.88.88 0 01.022-.655.763.763 0 01.231-.295c.104-.079.238-.14.402-.183.165-.046.364-.07.597-.07h.762v.999a1.067 1.067 0 01-.177.226 1.278 1.278 0 01-.268.193 1.598 1.598 0 01-.768.194zm4.796-4.765v1.22h1.654v3.378H597.4V134h4.737v-1.214h-1.574v-4.598H597.4zm1.547-1.487a.86.86 0 00.059.322.794.794 0 00.446.414c.107.039.225.059.354.059.265 0 .475-.074.629-.221a.76.76 0 00.236-.574.746.746 0 00-.236-.57c-.154-.15-.364-.225-.629-.225-.129 0-.247.019-.354.059a.83.83 0 00-.269.161.78.78 0 00-.177.258.817.817 0 00-.059.317zm4.973-.951v1.219h1.741v5.817h-1.741V134h4.915v-1.214h-1.665v-7.036h-3.25zM580.975 149h1.354v-5.812h-1.499v4.077a1.257 1.257 0 01-.166.253 1.043 1.043 0 01-.221.193 1.164 1.164 0 01-.338.14 1.717 1.717 0 01-.424.048c-.176 0-.324-.022-.446-.065a.615.615 0 01-.296-.214.974.974 0 01-.166-.387 3.124 3.124 0 01-.048-.596v-3.449h-1.494v3.438c0 .44.049.818.145 1.133.101.312.24.568.419.768.179.204.394.353.645.446.251.093.526.14.827.14.33 0 .632-.083.908-.247.279-.165.517-.392.714-.682l.086.816zm6.564-1.595a.466.466 0 01-.07.247.59.59 0 01-.199.199 1.27 1.27 0 01-.36.139 2.329 2.329 0 01-.505.049c-.161 0-.318-.017-.472-.049a1.273 1.273 0 01-.403-.156.867.867 0 01-.29-.268.841.841 0 01-.129-.408h-1.423c0 .236.057.472.171.709.119.232.29.44.516.623.226.186.505.336.838.451a3.58 3.58 0 001.16.172c.398 0 .757-.043 1.08-.129.322-.09.598-.213.827-.371.225-.157.399-.343.521-.558.125-.219.188-.457.188-.715a1.33 1.33 0 00-.188-.719 1.612 1.612 0 00-.51-.521 3.054 3.054 0 00-.779-.344 7.76 7.76 0 00-.978-.22 4.42 4.42 0 01-.601-.124 1.482 1.482 0 01-.371-.166.496.496 0 01-.193-.194.552.552 0 01.005-.483.61.61 0 01.183-.204.951.951 0 01.333-.151c.136-.035.295-.053.478-.053.215 0 .397.027.548.08a.97.97 0 01.365.215.683.683 0 01.145.231.735.735 0 01.048.269h1.493c0-.269-.059-.518-.177-.747a1.75 1.75 0 00-.51-.596 2.61 2.61 0 00-.822-.387 3.78 3.78 0 00-1.09-.145c-.387 0-.734.048-1.042.145-.308.097-.57.227-.784.392-.215.165-.38.356-.495.575a1.464 1.464 0 00-.172.687c0 .247.056.466.167.656.115.189.272.356.473.499.2.147.44.272.719.376.283.1.595.185.935.253.269.05.491.1.666.15.175.05.317.104.424.161a.574.574 0 01.215.193.434.434 0 01.065.237zm5.677 1.702c.562 0 1.049-.109 1.461-.327.412-.219.712-.462.902-.731l-.746-.805a1.573 1.573 0 01-.672.499c-.276.111-.56.167-.854.167-.208 0-.399-.033-.575-.097a1.486 1.486 0 01-.784-.655 2.11 2.11 0 01-.193-.564v-.016h3.942v-.634c0-.426-.059-.815-.177-1.166a2.524 2.524 0 00-.516-.907 2.31 2.31 0 00-.837-.58 2.811 2.811 0 00-1.118-.21c-.404 0-.778.073-1.122.22a2.646 2.646 0 00-.892.618c-.25.265-.446.582-.585.951a3.36 3.36 0 00-.21 1.213v.215c0 .391.07.758.21 1.101.143.341.345.636.607.887.261.254.574.454.94.601.365.147.771.22 1.219.22zm-.177-4.817c.189 0 .356.03.499.091.147.057.27.136.371.236a1.153 1.153 0 01.322.811v.118h-2.449c.036-.189.089-.361.161-.515.071-.154.161-.287.268-.398a1.137 1.137 0 01.828-.343zm8.137-1.209c-.391 0-.75.095-1.08.285a2.638 2.638 0 00-.848.773l-.011-.129-.059-.822h-1.391V149h1.493v-3.491a1.59 1.59 0 01.258-.43 1.434 1.434 0 01.789-.451c.158-.036.333-.054.527-.054.186 0 .381.013.585.038.208.021.41.055.607.102l.22-1.488a3.39 3.39 0 00-.467-.097 3.763 3.763 0 00-.623-.048zm2.433 5.919h1.498v-4.13c.051-.079.106-.151.167-.215a1.02 1.02 0 01.204-.167c.093-.064.199-.113.317-.145a1.56 1.56 0 01.397-.048c.172 0 .326.018.462.054a.783.783 0 01.349.177.799.799 0 01.221.354c.053.147.08.335.08.564V149h1.493v-3.577c0-.423-.05-.781-.15-1.074a1.953 1.953 0 00-.408-.731 1.618 1.618 0 00-.634-.408 2.408 2.408 0 00-.806-.129c-.229 0-.445.032-.65.097a2.007 2.007 0 00-.848.521c-.09.089-.172.188-.247.295l-.092-.806h-1.353V149zm10.237 0h1.515v-.091a1.977 1.977 0 01-.172-.527 4.226 4.226 0 01-.059-.773v-2.492a1.99 1.99 0 00-.188-.887 1.757 1.757 0 00-.521-.639 2.351 2.351 0 00-.79-.381 3.535 3.535 0 00-.977-.129c-.39 0-.738.05-1.042.15-.301.097-.555.23-.763.398a1.74 1.74 0 00-.483.585 1.589 1.589 0 00-.161.704h1.493c0-.104.014-.199.043-.285a.568.568 0 01.145-.22.697.697 0 01.279-.156c.115-.039.251-.059.408-.059.179 0 .335.024.468.07a.893.893 0 01.338.188c.086.079.15.174.193.285a.973.973 0 01.065.365v.344h-.833c-.429 0-.811.039-1.144.118a2.549 2.549 0 00-.832.333 1.546 1.546 0 00-.564.618 1.852 1.852 0 00-.188.854c0 .25.05.483.15.698.1.211.24.394.419.548.179.154.392.274.639.36.251.085.525.128.822.128.183 0 .353-.017.51-.053a2.016 2.016 0 001.074-.596c.018.103.04.202.065.295.025.093.055.175.091.247zm-1.423-1.047c-.14 0-.263-.016-.371-.049a.884.884 0 01-.263-.139.623.623 0 01-.166-.221.88.88 0 01.021-.655.763.763 0 01.231-.295c.104-.079.238-.14.403-.183.165-.046.363-.07.596-.07h.763v.999a1.042 1.042 0 01-.178.226 1.253 1.253 0 01-.268.193 1.59 1.59 0 01-.768.194zm5.328-4.765h-1.284V149h1.359v-4.351c.018-.046.038-.089.059-.128a.48.48 0 01.075-.103.452.452 0 01.135-.091.473.473 0 01.333-.005c.05.014.095.041.134.08.036.04.064.095.086.167a.99.99 0 01.032.274V149h1.316v-4.286-.102-.049a.532.532 0 01.15-.188.611.611 0 01.124-.059.54.54 0 01.312.006c.053.014.1.041.139.08.04.043.07.101.091.172a.818.818 0 01.038.274V149h1.359v-4.146c0-.323-.032-.595-.097-.817a1.56 1.56 0 00-.258-.553 1.02 1.02 0 00-.402-.306 1.223 1.223 0 00-.489-.097c-.14 0-.269.018-.387.054a1.145 1.145 0 00-.526.333 1.395 1.395 0 00-.167.231 1.009 1.009 0 00-.118-.237.753.753 0 00-.435-.333 1.276 1.276 0 00-.365-.048c-.279 0-.518.073-.715.22-.193.143-.345.34-.456.591l-.043-.704zm8.497 5.919c.562 0 1.049-.109 1.461-.327.412-.219.713-.462.902-.731l-.746-.805a1.573 1.573 0 01-.672.499c-.275.111-.56.167-.854.167-.207 0-.399-.033-.574-.097a1.48 1.48 0 01-.468-.274 1.47 1.47 0 01-.317-.381 2.146 2.146 0 01-.193-.564v-.016h3.942v-.634c0-.426-.059-.815-.177-1.166a2.537 2.537 0 00-.515-.907 2.322 2.322 0 00-.838-.58 2.81 2.81 0 00-1.117-.21c-.405 0-.779.073-1.123.22a2.646 2.646 0 00-.892.618 2.83 2.83 0 00-.585.951 3.36 3.36 0 00-.21 1.213v.215c0 .391.07.758.21 1.101.143.341.345.636.607.887.261.254.575.454.94.601.365.147.771.22 1.219.22zm-.177-4.817c.19 0 .356.03.499.091.147.057.271.136.371.236a1.153 1.153 0 01.322.811v.118h-2.449c.036-.189.089-.361.161-.515.072-.154.161-.287.269-.398.103-.111.225-.195.365-.252.14-.061.294-.091.462-.091zm-61.075 20.795l.183.849c.354 0 .66-.077.918-.231.262-.151.473-.349.634-.597.161-.236.283-.504.365-.805.083-.301.124-.591.124-.87v-.876c0-.168.012-.319.037-.451.029-.136.07-.254.124-.354a.87.87 0 01.446-.403c.197-.086.444-.129.741-.129v-1.074c-.265 0-.492-.034-.682-.102a.898.898 0 01-.435-.323 1.132 1.132 0 01-.178-.392 2.411 2.411 0 01-.053-.532v-.875c0-.272-.034-.553-.102-.843a2.328 2.328 0 00-.333-.795 1.866 1.866 0 00-.639-.623c-.262-.158-.584-.237-.967-.237l-.183.844c.219-.008.387.039.505.139a.829.829 0 01.258.387c.053.161.084.342.091.542.011.197.016.393.016.586v.875c0 .247.034.482.102.704.068.218.174.417.317.596.097.122.211.233.344.333.132.1.285.186.456.258a2.17 2.17 0 00-.547.328 1.759 1.759 0 00-.376.429 1.905 1.905 0 00-.226.521 2.41 2.41 0 00-.07.591v.876c0 .193-.012.388-.037.585a2.17 2.17 0 01-.135.543.955.955 0 01-.268.386.577.577 0 01-.43.14zm-13.213 15l.183.849c.354 0 .66-.077.918-.231.262-.151.473-.349.634-.597.161-.236.283-.504.365-.805.083-.301.124-.591.124-.87v-.876c0-.168.012-.319.037-.451.029-.136.07-.254.124-.354a.87.87 0 01.446-.403c.197-.086.444-.129.741-.129v-1.074c-.265 0-.492-.034-.682-.102a.898.898 0 01-.435-.323 1.113 1.113 0 01-.177-.392 2.349 2.349 0 01-.054-.532v-.875c0-.272-.034-.553-.102-.843a2.328 2.328 0 00-.333-.795 1.866 1.866 0 00-.639-.623c-.262-.158-.584-.237-.967-.237l-.183.844c.219-.008.387.039.505.139a.829.829 0 01.258.387c.054.161.084.342.091.542.011.197.016.393.016.586v.875c0 .247.034.482.102.704.068.218.174.417.317.596.097.122.212.233.344.333.133.1.285.186.457.258-.212.09-.394.199-.548.328a1.759 1.759 0 00-.376.429 1.905 1.905 0 00-.226.521 2.46 2.46 0 00-.07.591v.876c0 .193-.012.388-.037.585a2.17 2.17 0 01-.135.543.955.955 0 01-.268.386.577.577 0 01-.43.14z"
      fill="#707070"
    />
    <rect
      x={337}
      y={109}
      width={148}
      height={37}
      rx={7}
      fill="#fff"
      stroke="#FF9A00"
      strokeWidth={2}
    />
    <path
      d="M357.302 124.375a3.022 3.022 0 00-1.818.392 3.116 3.116 0 00-1.265 1.39 3.197 3.197 0 00-.25 1.88c.108.638.407 1.226.855 1.683a3.026 3.026 0 003.492.619 3.1 3.1 0 001.361-1.292 3.192 3.192 0 00.385-1.856 3.172 3.172 0 00-.888-1.91 3.061 3.061 0 00-1.872-.906zm7.409 3.125a7.739 7.739 0 01-.074 1.02l2.173 1.74a.537.537 0 01.118.675l-2.056 3.63a.513.513 0 01-.632.226l-2.158-.887a.769.769 0 00-.729.085c-.33.232-.676.438-1.036.616a.777.777 0 00-.424.595l-.323 2.35a.555.555 0 01-.178.319.529.529 0 01-.336.131h-4.112a.523.523 0 01-.332-.126.546.546 0 01-.182-.309l-.323-2.347a.794.794 0 00-.433-.599 7.377 7.377 0 01-1.031-.617.77.77 0 00-.353-.136.772.772 0 00-.374.052l-2.158.887a.513.513 0 01-.632-.225l-2.056-3.631a.54.54 0 01.118-.674l1.837-1.472a.799.799 0 00.289-.691 6.74 6.74 0 010-1.219.809.809 0 00-.062-.38.785.785 0 00-.23-.304l-1.836-1.472a.538.538 0 01-.114-.672l2.056-3.63a.513.513 0 01.632-.226l2.158.887a.769.769 0 00.729-.085c.33-.232.676-.438 1.036-.616a.777.777 0 00.424-.595l.323-2.35a.555.555 0 01.178-.319.529.529 0 01.336-.131h4.112a.523.523 0 01.332.126.546.546 0 01.182.309l.323 2.347a.794.794 0 00.433.599c.359.177.704.383 1.031.617a.77.77 0 00.353.136.772.772 0 00.374-.052l2.158-.887a.513.513 0 01.632.225l2.056 3.631a.54.54 0 01-.118.674l-1.837 1.472a.797.797 0 00-.291.691c.016.203.027.407.027.612z"
      stroke="#5AA200"
      strokeWidth={1.5}
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M410.573 131.671l2.927-8.491h-1.391l-2.927 8.491h1.391zm8.583-.671h1.353v-5.812h-1.498v4.077a1.26 1.26 0 01-.167.253 1.037 1.037 0 01-.22.193 1.176 1.176 0 01-.338.14 1.725 1.725 0 01-.425.048 1.34 1.34 0 01-.445-.065.61.61 0 01-.296-.214.96.96 0 01-.166-.387 3.036 3.036 0 01-.049-.596v-3.449h-1.493v3.438c0 .44.048.818.145 1.133.1.312.24.568.419.768.179.204.394.353.645.446.25.093.526.14.827.14.329 0 .632-.083.907-.247a2.23 2.23 0 00.715-.682l.086.816zm6.563-1.595a.457.457 0 01-.07.247.596.596 0 01-.198.199 1.27 1.27 0 01-.36.139 2.335 2.335 0 01-.505.049c-.161 0-.319-.017-.473-.049a1.292 1.292 0 01-.403-.156.876.876 0 01-.29-.268.83.83 0 01-.128-.408h-1.424c0 .236.057.472.172.709.118.232.29.44.516.623.225.186.505.336.838.451a3.58 3.58 0 001.16.172c.397 0 .757-.043 1.079-.129.323-.09.598-.213.827-.371.226-.157.4-.343.521-.558.126-.219.188-.457.188-.715 0-.279-.062-.519-.188-.719a1.592 1.592 0 00-.51-.521 3.023 3.023 0 00-.779-.344c-.3-.09-.626-.163-.977-.22a4.438 4.438 0 01-.602-.124 1.473 1.473 0 01-.37-.166.506.506 0 01-.194-.194.565.565 0 01-.053-.241c0-.086.019-.167.059-.242a.619.619 0 01.182-.204.951.951 0 01.333-.151c.136-.035.296-.053.478-.053.215 0 .398.027.548.08a.955.955 0 01.365.215.715.715 0 01.194.5h1.493c0-.269-.059-.518-.177-.747a1.753 1.753 0 00-.511-.596 2.593 2.593 0 00-.821-.387 3.787 3.787 0 00-1.091-.145c-.386 0-.734.048-1.042.145a2.515 2.515 0 00-.784.392 1.745 1.745 0 00-.494.575 1.452 1.452 0 00-.172.687c0 .247.056.466.167.656.114.189.272.356.472.499.201.147.441.272.72.376.283.1.594.185.935.253.268.05.49.1.666.15.175.05.317.104.424.161a.582.582 0 01.215.193.434.434 0 01.064.237zm5.677 1.702c.563 0 1.05-.109 1.461-.327.412-.219.713-.462.903-.731l-.747-.805a1.57 1.57 0 01-.671.499 2.27 2.27 0 01-.854.167c-.208 0-.399-.033-.575-.097a1.486 1.486 0 01-.784-.655 2.11 2.11 0 01-.193-.564v-.016h3.942v-.634c0-.426-.059-.815-.177-1.166a2.524 2.524 0 00-.516-.907 2.305 2.305 0 00-.838-.58 2.806 2.806 0 00-1.117-.21c-.405 0-.779.073-1.123.22a2.642 2.642 0 00-.891.618 2.817 2.817 0 00-.586.951 3.383 3.383 0 00-.209 1.213v.215c0 .391.07.758.209 1.101.144.341.346.636.607.887.262.254.575.454.94.601.365.147.772.22 1.219.22zm-.177-4.817c.19 0 .357.03.5.091.147.057.27.136.37.236a1.155 1.155 0 01.323.811v.118h-2.45c.036-.189.09-.361.162-.515.071-.154.161-.287.268-.398.104-.111.226-.195.365-.252.14-.061.294-.091.462-.091zm8.137-1.209c-.39 0-.75.095-1.079.285-.33.186-.612.444-.849.773l-.011-.129-.059-.822h-1.391V131h1.493v-3.491a1.59 1.59 0 01.258-.43 1.29 1.29 0 01.376-.301c.122-.068.26-.118.414-.15.157-.036.333-.054.526-.054.186 0 .382.013.586.038.207.021.41.055.607.102l.22-1.488a3.377 3.377 0 00-.468-.097 3.746 3.746 0 00-.623-.048zm6.183 4.324a.466.466 0 01-.07.247.59.59 0 01-.199.199 1.27 1.27 0 01-.36.139 2.329 2.329 0 01-.505.049c-.161 0-.318-.017-.472-.049a1.273 1.273 0 01-.403-.156.867.867 0 01-.29-.268.841.841 0 01-.129-.408h-1.423c0 .236.057.472.171.709.119.232.29.44.516.623.226.186.505.336.838.451a3.58 3.58 0 001.16.172c.398 0 .757-.043 1.08-.129.322-.09.598-.213.827-.371.225-.157.399-.343.521-.558.125-.219.188-.457.188-.715a1.33 1.33 0 00-.188-.719 1.612 1.612 0 00-.51-.521 3.054 3.054 0 00-.779-.344 7.76 7.76 0 00-.978-.22 4.42 4.42 0 01-.601-.124 1.482 1.482 0 01-.371-.166.496.496 0 01-.193-.194.552.552 0 01.005-.483.61.61 0 01.183-.204.951.951 0 01.333-.151c.136-.035.295-.053.478-.053.215 0 .397.027.548.08a.97.97 0 01.365.215.683.683 0 01.145.231.735.735 0 01.048.269h1.493c0-.269-.059-.518-.177-.747a1.75 1.75 0 00-.51-.596 2.61 2.61 0 00-.822-.387 3.78 3.78 0 00-1.09-.145c-.387 0-.734.048-1.042.145-.308.097-.57.227-.784.392-.215.165-.38.356-.495.575a1.464 1.464 0 00-.172.687c0 .247.056.466.167.656.115.189.272.356.473.499.2.147.44.272.719.376.283.1.595.185.935.253.269.05.491.1.666.15.175.05.317.104.424.161a.574.574 0 01.215.193.434.434 0 01.065.237z"
      fill="#707070"
    />
    <rect
      x={377}
      y={120}
      width={26}
      height={16}
      rx={4}
      fill="#C4C4C4"
      fillOpacity={0.3}
    />
    <path
      d="M385.642 131.054c-.924 0-1.659-.294-2.205-.882-.546-.588-.819-1.371-.819-2.349 0-.984.258-1.764.774-2.34.522-.582 1.245-.873 2.169-.873a5.72 5.72 0 011.863.324l-.162 1.008a4.575 4.575 0 00-.891-.207 5.654 5.654 0 00-.855-.09c-.498 0-.888.192-1.17.576-.282.378-.423.891-.423 1.539 0 .648.15 1.188.45 1.62.306.426.696.639 1.17.639.276 0 .528-.06.756-.18v-1.224h-1.044v-1.035h2.349v2.988a4.238 4.238 0 01-1.962.486zm6.953-.054h-3.753v-6.3h3.753v1.035h-2.448v1.323h2.223v1.053h-2.223v1.854h2.448V131zm2.115 0v-5.247h-1.449V124.7h4.176v1.053h-1.431V131h-1.296z"
      fill="#707070"
    />
    <path
      d="M476.1 30.578c.98-3.05.391-9.134-1.507-11.38a.572.572 0 00-.919.073l-2.338 3.67a1.8 1.8 0 01-2.403.39 16.05 16.05 0 00-8.823-2.625c-3.256 0-6.287.964-8.824 2.625-.78.512-1.821.34-2.403-.39l-2.337-3.67a.575.575 0 00-.919-.073c-1.898 2.25-2.487 8.334-1.507 11.38a6.435 6.435 0 01.222 3.126c-.192 1.033-.383 2.28-.383 3.149 0 8.92 7.232 16.147 16.147 16.147 8.919 0 16.147-7.232 16.147-16.147 0-.869-.191-2.116-.382-3.15a6.473 6.473 0 01.229-3.125zm-15.994 18.817c-6.895 0-12.501-5.609-12.501-12.504 0-.226.008-.448.02-.67.248-4.698 3.103-8.712 7.139-10.625a12.376 12.376 0 015.346-1.202c1.913 0 3.723.429 5.345 1.206 4.037 1.913 6.891 5.93 7.14 10.625.012.222.019.448.019.67-.004 6.891-5.613 12.5-12.508 12.5z"
      fill="#001934"
    />
    <path
      d="M465.524 41.705l-3.195-5.54-2.739-4.62a.36.36 0 00-.31-.175h-2.618a.357.357 0 00-.313.183.356.356 0 00.003.36l2.621 4.404-3.516 5.365a.358.358 0 00.302.555h2.637a.356.356 0 00.302-.165l1.902-2.97 1.706 2.959c.065.11.184.18.31.18h2.598c.13 0 .249-.07.31-.18a.349.349 0 000-.356zM491.145 27.608h3.333v18.275h-3.333v-7.787h-3.765v7.79h-3.332V27.609h3.332v7.936h3.765v-7.936zM504.759 45.887l-.696-3.796h-3.999l-.638 3.796h-3.333l3.677-18.275h4.488l3.853 18.275h-3.352zm-4.258-6.318h3.099l-1.592-8.747-1.507 8.747zM515.534 42.554v-3.91c0-.31-.057-.517-.172-.624-.115-.107-.329-.16-.639-.16h-2.345c-1.99 0-2.985-.965-2.985-2.897v-4.485c0-1.913 1.041-2.866 3.126-2.866h3.188c2.085 0 3.126.957 3.126 2.866v2.548h-3.36v-2.085c0-.31-.057-.517-.172-.624-.115-.107-.329-.16-.639-.16h-1.102c-.329 0-.551.053-.666.16-.114.107-.172.314-.172.624v3.677c0 .31.058.517.172.624.115.107.337.16.666.16h2.288c2.028 0 3.042.946 3.042 2.84v4.779c0 1.913-1.052 2.866-3.157 2.866h-3.13c-2.104 0-3.156-.957-3.156-2.866v-2.522h3.329v2.055c0 .31.057.517.172.624.115.107.337.16.666.16h1.102c.309 0 .52-.053.639-.16.118-.107.179-.314.179-.624zM527.782 27.608h3.33v15.41c0 1.912-1.053 2.865-3.157 2.865h-3.532c-2.105 0-3.157-.957-3.157-2.866V27.608h3.333v14.946c0 .31.057.517.172.624.115.107.329.16.639.16h1.535c.329 0 .551-.053.665-.16.115-.107.172-.314.172-.624V27.608zM537.195 38.762v7.125h-3.328V27.608h6.718c2.105 0 3.157.957 3.157 2.866v5.418c0 1.584-.704 2.51-2.116 2.782l3.042 7.213h-3.593l-2.781-7.125h-1.099zm0-8.605v6.141h2.403c.31 0 .521-.054.639-.16.115-.108.173-.314.173-.624V30.94c0-.31-.058-.516-.173-.624-.114-.107-.329-.16-.639-.16h-2.403zM553.821 45.887l-.697-3.796h-3.998l-.639 3.796h-3.329l3.677-18.275h4.489l3.852 18.275h-3.355zm-4.255-6.318h3.099l-1.592-8.747-1.507 8.747z"
      fill="#001934"
    />
    <mask id="prefix__a" fill="#fff">
      <path d="M895.774 128.509c2.288-2.288 3.789-5.176 4.172-8.028.383-2.852-.383-5.436-2.129-7.182-1.746-1.746-4.329-2.511-7.181-2.128-2.853.383-5.74 1.884-8.028 4.171l6.583 6.584 6.583 6.583z" />
    </mask>
    <path
      d="M895.774 128.509c2.288-2.288 3.789-5.176 4.172-8.028.383-2.852-.383-5.436-2.129-7.182-1.746-1.746-4.329-2.511-7.181-2.128-2.853.383-5.74 1.884-8.028 4.171l6.583 6.584 6.583 6.583z"
      stroke="#707070"
      strokeWidth={4}
      mask="url(#prefix__a)"
    />
    <mask id="prefix__b" fill="#fff">
      <path d="M875.343 122.607c-2.287 2.288-3.788 5.175-4.171 8.028-.383 2.852.382 5.435 2.128 7.181 1.746 1.746 4.33 2.512 7.182 2.129 2.852-.383 5.74-1.884 8.028-4.172l-6.583-6.583-6.584-6.583z" />
    </mask>
    <path
      d="M875.343 122.607c-2.287 2.288-3.788 5.175-4.171 8.028-.383 2.852.382 5.435 2.128 7.181 1.746 1.746 4.33 2.512 7.182 2.129 2.852-.383 5.74-1.884 8.028-4.172l-6.583-6.583-6.584-6.583z"
      stroke="#707070"
      strokeWidth={4}
      mask="url(#prefix__b)"
    />
    <path
      d="M898 114.086l3-3M873.086 137l-3 3M882.752 123.313l-3.929 3.929M888.366 128.926l-3.93 3.929"
      stroke="#707070"
      strokeWidth={2}
    />
  </svg>
);

const MemoSvgComponent = React.memo(LandingImage);
export default MemoSvgComponent;
