-- -- /*******************************************************************************
-- --    Chinook Database - Version 1.4
-- --    Script: Chinook_PostgreSql.sql
-- --    Description: Creates and populates the Chinook database.
-- --    DB Server: PostgreSql
-- --    Author: Luis Rocha
-- --    License: http://www.codeplex.com/ChinookDatabase/license
-- -- ********************************************************************************/


-- ----------------------------
-- Sequence structure for album_album_id_seq
-- ----------------------------
CREATE SEQUENCE IF NOT EXISTS "albums_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 2147483647
 START 347
 CACHE 1;
SELECT setval('"public"."albums_id_seq"', 347, true);


-- ----------------------------
-- Sequence structure for artist_artist_id_seq
-- ----------------------------
CREATE SEQUENCE IF NOT EXISTS "artists_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 2147483647
 START 275
 CACHE 1;
SELECT setval('"public"."artists_id_seq"', 275, true);

-- ----------------------------
-- Sequence structure for genre_genre_id_seq
-- ----------------------------
CREATE SEQUENCE IF NOT EXISTS "genres_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 2147483647
 START 25
 CACHE 1;
SELECT setval('"public"."genres_id_seq"', 25, true);


-- ----------------------------
-- Sequence structure for mediatype_mediatype_id_seq
-- ----------------------------
CREATE SEQUENCE IF NOT EXISTS "mediatypes_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 2147483647
 START 5
 CACHE 1;
SELECT setval('"public"."mediatypes_id_seq"', 5, true);


-- ----------------------------
-- Sequence structure for playlist_playlist_id_seq
-- ----------------------------
CREATE SEQUENCE IF NOT EXISTS "playlists_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 2147483647
 START 18
 CACHE 1;
SELECT setval('"public"."playlists_id_seq"', 18, true);


-- ----------------------------
-- Sequence structure for track_track_id_seq
-- ----------------------------
CREATE SEQUENCE IF NOT EXISTS "tracks_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 2147483647
 START 3503
 CACHE 1;
SELECT setval('"public"."tracks_id_seq"', 3503, true);

-- /*******************************************************************************
--    CREATE TABLE IF NOT EXISTSs
-- ********************************************************************************/
CREATE TABLE IF NOT EXISTS albums
(
    id int DEFAULT nextval('albums_id_seq'::regclass) NOT NULL,
    title VARCHAR(160) NOT NULL,
    artist_id INT NOT NULL,
    CONSTRAINT pk_albums PRIMARY KEY  (id)
);

CREATE TABLE IF NOT EXISTS artists
(
    id int DEFAULT nextval('artists_id_seq'::regclass) NOT NULL,
    name VARCHAR(120),
    CONSTRAINT pk_artists PRIMARY KEY  (id)
);

CREATE TABLE IF NOT EXISTS genres
(
    id int DEFAULT nextval('genres_id_seq'::regclass) NOT NULL,
    name VARCHAR(120),
    CONSTRAINT pk_genres PRIMARY KEY  (id)
);

CREATE TABLE IF NOT EXISTS media_types
(
    id int DEFAULT nextval('mediatypes_id_seq'::regclass) NOT NULL,
    name VARCHAR(120),
    CONSTRAINT pk_media_types PRIMARY KEY  (id)
);

CREATE TABLE IF NOT EXISTS playlists
(
    id int DEFAULT nextval('playlists_id_seq'::regclass) NOT NULL,
    name VARCHAR(120),
    CONSTRAINT pk_playlists PRIMARY KEY  (id)
);

CREATE TABLE IF NOT EXISTS playlist_track
(
    playlist_id INT NOT NULL,
    track_id INT NOT NULL,
    CONSTRAINT pk_playlist_track PRIMARY KEY  (playlist_id, track_id)
);

CREATE TABLE IF NOT EXISTS tracks
(
    id int DEFAULT nextval('tracks_id_seq'::regclass) NOT NULL,
    name VARCHAR(200) NOT NULL,
    album_id INT,
    media_type_id INT NOT NULL,
    genre_id INT,
    composer VARCHAR(220),
    milliseconds INT NOT NULL,
    bytes INT,
    unit_price NUMERIC(10,2) NOT NULL,
    CONSTRAINT pk_tracks PRIMARY KEY  (id)
);



/*******************************************************************************
   Create Primary Key Unique Indexes
********************************************************************************/

/*******************************************************************************
   Create Foreign Keys
********************************************************************************/
ALTER TABLE albums ADD CONSTRAINT fk_album_artist_id
    FOREIGN KEY (artist_id) REFERENCES artists (id) ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE INDEX IF NOT EXISTS ifk_album_artist_id ON albums (artist_id);

ALTER TABLE playlist_track ADD CONSTRAINT fk_playlist_track_playlist_id
    FOREIGN KEY (playlist_id) REFERENCES playlists (id) ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE playlist_track ADD CONSTRAINT fk_playlist_track_track_id
    FOREIGN KEY (track_id) REFERENCES tracks (id) ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE INDEX IF NOT EXISTS ifk_playlist_track_track_id ON playlist_track (track_id);

ALTER TABLE tracks ADD CONSTRAINT fk_track_album_id
    FOREIGN KEY (album_id) REFERENCES albums (id) ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE INDEX IF NOT EXISTS ifk_track_album_id ON tracks (album_id);

ALTER TABLE tracks ADD CONSTRAINT fk_track_genre_id
    FOREIGN KEY (genre_id) REFERENCES genres (id) ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE INDEX IF NOT EXISTS ifk_track_genre_id ON tracks (genre_id);

ALTER TABLE tracks ADD CONSTRAINT fk_track_media_type_id
    FOREIGN KEY (media_type_id) REFERENCES media_types (id) ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE INDEX IF NOT EXISTS ifk_track_media_type_id ON tracks (media_type_id);


/*******************************************************************************
   Populate Tables
********************************************************************************/
INSERT INTO genres (id, name) VALUES (1, N'Rock');
INSERT INTO genres (id, name) VALUES (2, N'Jazz');
INSERT INTO genres (id, name) VALUES (3, N'Metal');
INSERT INTO genres (id, name) VALUES (4, N'Alternative & Punk');
INSERT INTO genres (id, name) VALUES (5, N'Rock And Roll');
INSERT INTO genres (id, name) VALUES (6, N'Blues');
INSERT INTO genres (id, name) VALUES (7, N'Latin');
INSERT INTO genres (id, name) VALUES (8, N'Reggae');
INSERT INTO genres (id, name) VALUES (9, N'Pop');
INSERT INTO genres (id, name) VALUES (10, N'Soundtrack');
INSERT INTO genres (id, name) VALUES (11, N'Bossa Nova');
INSERT INTO genres (id, name) VALUES (12, N'Easy Listening');
INSERT INTO genres (id, name) VALUES (13, N'Heavy Metal');
INSERT INTO genres (id, name) VALUES (14, N'R&B/Soul');
INSERT INTO genres (id, name) VALUES (15, N'Electronica/Dance');
INSERT INTO genres (id, name) VALUES (16, N'World');
INSERT INTO genres (id, name) VALUES (17, N'Hip Hop/Rap');
INSERT INTO genres (id, name) VALUES (18, N'Science Fiction');
INSERT INTO genres (id, name) VALUES (19, N'TV Shows');
INSERT INTO genres (id, name) VALUES (20, N'Sci Fi & Fantasy');
INSERT INTO genres (id, name) VALUES (21, N'Drama');
INSERT INTO genres (id, name) VALUES (22, N'Comedy');
INSERT INTO genres (id, name) VALUES (23, N'Alternative');
INSERT INTO genres (id, name) VALUES (24, N'Classical');
INSERT INTO genres (id, name) VALUES (25, N'Opera');

INSERT INTO media_types (id, name) VALUES (1, N'MPEG audio file');
INSERT INTO media_types (id, name) VALUES (2, N'Protected AAC audio file');
INSERT INTO media_types (id, name) VALUES (3, N'Protected MPEG-4 video file');
INSERT INTO media_types (id, name) VALUES (4, N'Purchased AAC audio file');
INSERT INTO media_types (id, name) VALUES (5, N'AAC audio file');

INSERT INTO artists (id, name) VALUES (1, N'AC/DC');
INSERT INTO artists (id, name) VALUES (2, N'Accept');
INSERT INTO artists (id, name) VALUES (3, N'Aerosmith');
INSERT INTO artists (id, name) VALUES (4, N'Alanis Morissette');
INSERT INTO artists (id, name) VALUES (5, N'Alice In Chains');
INSERT INTO artists (id, name) VALUES (6, N'Antônio Carlos Jobim');
INSERT INTO artists (id, name) VALUES (7, N'Apocalyptica');
INSERT INTO artists (id, name) VALUES (8, N'Audioslave');
INSERT INTO artists (id, name) VALUES (9, N'BackBeat');
INSERT INTO artists (id, name) VALUES (10, N'Billy Cobham');
INSERT INTO artists (id, name) VALUES (11, N'Black Label Society');
INSERT INTO artists (id, name) VALUES (12, N'Black Sabbath');
INSERT INTO artists (id, name) VALUES (13, N'Body Count');
INSERT INTO artists (id, name) VALUES (14, N'Bruce Dickinson');
INSERT INTO artists (id, name) VALUES (15, N'Buddy Guy');
INSERT INTO artists (id, name) VALUES (16, N'Caetano Veloso');
INSERT INTO artists (id, name) VALUES (17, N'Chico Buarque');
INSERT INTO artists (id, name) VALUES (18, N'Chico Science & Nação Zumbi');
INSERT INTO artists (id, name) VALUES (19, N'Cidade Negra');
INSERT INTO artists (id, name) VALUES (20, N'Cláudio Zoli');
INSERT INTO artists (id, name) VALUES (21, N'Various artistss');
INSERT INTO artists (id, name) VALUES (22, N'Led Zeppelin');
INSERT INTO artists (id, name) VALUES (23, N'Frank Zappa & Captain Beefheart');
INSERT INTO artists (id, name) VALUES (24, N'Marcos Valle');
INSERT INTO artists (id, name) VALUES (25, N'Milton Nascimento & Bebeto');
INSERT INTO artists (id, name) VALUES (26, N'Azymuth');
INSERT INTO artists (id, name) VALUES (27, N'Gilberto Gil');
INSERT INTO artists (id, name) VALUES (28, N'João Gilberto');
INSERT INTO artists (id, name) VALUES (29, N'Bebel Gilberto');
INSERT INTO artists (id, name) VALUES (30, N'Jorge Vercilo');
INSERT INTO artists (id, name) VALUES (31, N'Baby Consuelo');
INSERT INTO artists (id, name) VALUES (32, N'Ney Matogrosso');
INSERT INTO artists (id, name) VALUES (33, N'Luiz Melodia');
INSERT INTO artists (id, name) VALUES (34, N'Nando Reis');
INSERT INTO artists (id, name) VALUES (35, N'Pedro Luís & A Parede');
INSERT INTO artists (id, name) VALUES (36, N'O Rappa');
INSERT INTO artists (id, name) VALUES (37, N'Ed Motta');
INSERT INTO artists (id, name) VALUES (38, N'Banda Black Rio');
INSERT INTO artists (id, name) VALUES (39, N'Fernanda Porto');
INSERT INTO artists (id, name) VALUES (40, N'Os Cariocas');
INSERT INTO artists (id, name) VALUES (41, N'Elis Regina');
INSERT INTO artists (id, name) VALUES (42, N'Milton Nascimento');
INSERT INTO artists (id, name) VALUES (43, N'A Cor Do Som');
INSERT INTO artists (id, name) VALUES (44, N'Kid Abelha');
INSERT INTO artists (id, name) VALUES (45, N'Sandra De Sá');
INSERT INTO artists (id, name) VALUES (46, N'Jorge Ben');
INSERT INTO artists (id, name) VALUES (47, N'Hermeto Pascoal');
INSERT INTO artists (id, name) VALUES (48, N'Barão Vermelho');
INSERT INTO artists (id, name) VALUES (49, N'Edson, DJ Marky & DJ Patife Featuring Fernanda Porto');
INSERT INTO artists (id, name) VALUES (50, N'Metallica');
INSERT INTO artists (id, name) VALUES (51, N'Queen');
INSERT INTO artists (id, name) VALUES (52, N'Kiss');
INSERT INTO artists (id, name) VALUES (53, N'Spyro Gyra');
INSERT INTO artists (id, name) VALUES (54, N'Green Day');
INSERT INTO artists (id, name) VALUES (55, N'David Coverdale');
INSERT INTO artists (id, name) VALUES (56, N'Gonzaguinha');
INSERT INTO artists (id, name) VALUES (57, N'Os Mutantes');
INSERT INTO artists (id, name) VALUES (58, N'Deep Purple');
INSERT INTO artists (id, name) VALUES (59, N'Santana');
INSERT INTO artists (id, name) VALUES (60, N'Santana Feat. Dave Matthews');
INSERT INTO artists (id, name) VALUES (61, N'Santana Feat. Everlast');
INSERT INTO artists (id, name) VALUES (62, N'Santana Feat. Rob Thomas');
INSERT INTO artists (id, name) VALUES (63, N'Santana Feat. Lauryn Hill & Cee-Lo');
INSERT INTO artists (id, name) VALUES (64, N'Santana Feat. The Project G&B');
INSERT INTO artists (id, name) VALUES (65, N'Santana Feat. Maná');
INSERT INTO artists (id, name) VALUES (66, N'Santana Feat. Eagle-Eye Cherry');
INSERT INTO artists (id, name) VALUES (67, N'Santana Feat. Eric Clapton');
INSERT INTO artists (id, name) VALUES (68, N'Miles Davis');
INSERT INTO artists (id, name) VALUES (69, N'Gene Krupa');
INSERT INTO artists (id, name) VALUES (70, N'Toquinho & Vinícius');
INSERT INTO artists (id, name) VALUES (71, N'Vinícius De Moraes & Baden Powell');
INSERT INTO artists (id, name) VALUES (72, N'Vinícius De Moraes');
INSERT INTO artists (id, name) VALUES (73, N'Vinícius E Qurteto Em Cy');
INSERT INTO artists (id, name) VALUES (74, N'Vinícius E Odette Lara');
INSERT INTO artists (id, name) VALUES (75, N'Vinicius, Toquinho & Quarteto Em Cy');
INSERT INTO artists (id, name) VALUES (76, N'Creedence Clearwater Revival');
INSERT INTO artists (id, name) VALUES (77, N'Cássia Eller');
INSERT INTO artists (id, name) VALUES (78, N'Def Leppard');
INSERT INTO artists (id, name) VALUES (79, N'Dennis Chambers');
INSERT INTO artists (id, name) VALUES (80, N'Djavan');
INSERT INTO artists (id, name) VALUES (81, N'Eric Clapton');
INSERT INTO artists (id, name) VALUES (82, N'Faith No More');
INSERT INTO artists (id, name) VALUES (83, N'Falamansa');
INSERT INTO artists (id, name) VALUES (84, N'Foo Fighters');
INSERT INTO artists (id, name) VALUES (85, N'Frank Sinatra');
INSERT INTO artists (id, name) VALUES (86, N'Funk Como Le Gusta');
INSERT INTO artists (id, name) VALUES (87, N'Godsmack');
INSERT INTO artists (id, name) VALUES (88, N'Guns N'' Roses');
INSERT INTO artists (id, name) VALUES (89, N'Incognito');
INSERT INTO artists (id, name) VALUES (90, N'Iron Maiden');
INSERT INTO artists (id, name) VALUES (91, N'James Brown');
INSERT INTO artists (id, name) VALUES (92, N'Jamiroquai');
INSERT INTO artists (id, name) VALUES (93, N'JET');
INSERT INTO artists (id, name) VALUES (94, N'Jimi Hendrix');
INSERT INTO artists (id, name) VALUES (95, N'Joe Satriani');
INSERT INTO artists (id, name) VALUES (96, N'Jota Quest');
INSERT INTO artists (id, name) VALUES (97, N'João Suplicy');
INSERT INTO artists (id, name) VALUES (98, N'Judas Priest');
INSERT INTO artists (id, name) VALUES (99, N'Legião Urbana');
INSERT INTO artists (id, name) VALUES (100, N'Lenny Kravitz');
INSERT INTO artists (id, name) VALUES (101, N'Lulu Santos');
INSERT INTO artists (id, name) VALUES (102, N'Marillion');
INSERT INTO artists (id, name) VALUES (103, N'Marisa Monte');
INSERT INTO artists (id, name) VALUES (104, N'Marvin Gaye');
INSERT INTO artists (id, name) VALUES (105, N'Men At Work');
INSERT INTO artists (id, name) VALUES (106, N'Motörhead');
INSERT INTO artists (id, name) VALUES (107, N'Motörhead & Girlschool');
INSERT INTO artists (id, name) VALUES (108, N'Mônica Marianno');
INSERT INTO artists (id, name) VALUES (109, N'Mötley Crüe');
INSERT INTO artists (id, name) VALUES (110, N'Nirvana');
INSERT INTO artists (id, name) VALUES (111, N'O Terço');
INSERT INTO artists (id, name) VALUES (112, N'Olodum');
INSERT INTO artists (id, name) VALUES (113, N'Os Paralamas Do Sucesso');
INSERT INTO artists (id, name) VALUES (114, N'Ozzy Osbourne');
INSERT INTO artists (id, name) VALUES (115, N'Page & Plant');
INSERT INTO artists (id, name) VALUES (116, N'Passengers');
INSERT INTO artists (id, name) VALUES (117, N'Paul D''Ianno');
INSERT INTO artists (id, name) VALUES (118, N'Pearl Jam');
INSERT INTO artists (id, name) VALUES (119, N'Peter Tosh');
INSERT INTO artists (id, name) VALUES (120, N'Pink Floyd');
INSERT INTO artists (id, name) VALUES (121, N'Planet Hemp');
INSERT INTO artists (id, name) VALUES (122, N'R.E.M. Feat. Kate Pearson');
INSERT INTO artists (id, name) VALUES (123, N'R.E.M. Feat. KRS-One');
INSERT INTO artists (id, name) VALUES (124, N'R.E.M.');
INSERT INTO artists (id, name) VALUES (125, N'Raimundos');
INSERT INTO artists (id, name) VALUES (126, N'Raul Seixas');
INSERT INTO artists (id, name) VALUES (127, N'Red Hot Chili Peppers');
INSERT INTO artists (id, name) VALUES (128, N'Rush');
INSERT INTO artists (id, name) VALUES (129, N'Simply Red');
INSERT INTO artists (id, name) VALUES (130, N'Skank');
INSERT INTO artists (id, name) VALUES (131, N'Smashing Pumpkins');
INSERT INTO artists (id, name) VALUES (132, N'Soundgarden');
INSERT INTO artists (id, name) VALUES (133, N'Stevie Ray Vaughan & Double Trouble');
INSERT INTO artists (id, name) VALUES (134, N'Stone Temple Pilots');
INSERT INTO artists (id, name) VALUES (135, N'System Of A Down');
INSERT INTO artists (id, name) VALUES (136, N'Terry Bozzio, Tony Levin & Steve Stevens');
INSERT INTO artists (id, name) VALUES (137, N'The Black Crowes');
INSERT INTO artists (id, name) VALUES (138, N'The Clash');
INSERT INTO artists (id, name) VALUES (139, N'The Cult');
INSERT INTO artists (id, name) VALUES (140, N'The Doors');
INSERT INTO artists (id, name) VALUES (141, N'The Police');
INSERT INTO artists (id, name) VALUES (142, N'The Rolling Stones');
INSERT INTO artists (id, name) VALUES (143, N'The Tea Party');
INSERT INTO artists (id, name) VALUES (144, N'The Who');
INSERT INTO artists (id, name) VALUES (145, N'Tim Maia');
INSERT INTO artists (id, name) VALUES (146, N'Titãs');
INSERT INTO artists (id, name) VALUES (147, N'Battlestar Galactica');
INSERT INTO artists (id, name) VALUES (148, N'Heroes');
INSERT INTO artists (id, name) VALUES (149, N'Lost');
INSERT INTO artists (id, name) VALUES (150, N'U2');
INSERT INTO artists (id, name) VALUES (151, N'UB40');
INSERT INTO artists (id, name) VALUES (152, N'Van Halen');
INSERT INTO artists (id, name) VALUES (153, N'Velvet Revolver');
INSERT INTO artists (id, name) VALUES (154, N'Whitesnake');
INSERT INTO artists (id, name) VALUES (155, N'Zeca Pagodinho');
INSERT INTO artists (id, name) VALUES (156, N'The Office');
INSERT INTO artists (id, name) VALUES (157, N'Dread Zeppelin');
INSERT INTO artists (id, name) VALUES (158, N'Battlestar Galactica (Classic)');
INSERT INTO artists (id, name) VALUES (159, N'Aquaman');
INSERT INTO artists (id, name) VALUES (160, N'Christina Aguilera featuring BigElf');
INSERT INTO artists (id, name) VALUES (161, N'Aerosmith & Sierra Leone''s Refugee Allstars');
INSERT INTO artists (id, name) VALUES (162, N'Los Lonely Boys');
INSERT INTO artists (id, name) VALUES (163, N'Corinne Bailey Rae');
INSERT INTO artists (id, name) VALUES (164, N'Dhani Harrison & Jakob Dylan');
INSERT INTO artists (id, name) VALUES (165, N'Jackson Browne');
INSERT INTO artists (id, name) VALUES (166, N'Avril Lavigne');
INSERT INTO artists (id, name) VALUES (167, N'Big & Rich');
INSERT INTO artists (id, name) VALUES (168, N'Youssou N''Dour');
INSERT INTO artists (id, name) VALUES (169, N'Black Eyed Peas');
INSERT INTO artists (id, name) VALUES (170, N'Jack Johnson');
INSERT INTO artists (id, name) VALUES (171, N'Ben Harper');
INSERT INTO artists (id, name) VALUES (172, N'Snow Patrol');
INSERT INTO artists (id, name) VALUES (173, N'Matisyahu');
INSERT INTO artists (id, name) VALUES (174, N'The Postal Service');
INSERT INTO artists (id, name) VALUES (175, N'Jaguares');
INSERT INTO artists (id, name) VALUES (176, N'The Flaming Lips');
INSERT INTO artists (id, name) VALUES (177, N'Jack''s Mannequin & Mick Fleetwood');
INSERT INTO artists (id, name) VALUES (178, N'Regina Spektor');
INSERT INTO artists (id, name) VALUES (179, N'Scorpions');
INSERT INTO artists (id, name) VALUES (180, N'House Of Pain');
INSERT INTO artists (id, name) VALUES (181, N'Xis');
INSERT INTO artists (id, name) VALUES (182, N'Nega Gizza');
INSERT INTO artists (id, name) VALUES (183, N'Gustavo & Andres Veiga & Salazar');
INSERT INTO artists (id, name) VALUES (184, N'Rodox');
INSERT INTO artists (id, name) VALUES (185, N'Charlie Brown Jr.');
INSERT INTO artists (id, name) VALUES (186, N'Pedro Luís E A Parede');
INSERT INTO artists (id, name) VALUES (187, N'Los Hermanos');
INSERT INTO artists (id, name) VALUES (188, N'Mundo Livre S/A');
INSERT INTO artists (id, name) VALUES (189, N'Otto');
INSERT INTO artists (id, name) VALUES (190, N'Instituto');
INSERT INTO artists (id, name) VALUES (191, N'Nação Zumbi');
INSERT INTO artists (id, name) VALUES (192, N'DJ Dolores & Orchestra Santa Massa');
INSERT INTO artists (id, name) VALUES (193, N'Seu Jorge');
INSERT INTO artists (id, name) VALUES (194, N'Sabotage E Instituto');
INSERT INTO artists (id, name) VALUES (195, N'Stereo Maracana');
INSERT INTO artists (id, name) VALUES (196, N'Cake');
INSERT INTO artists (id, name) VALUES (197, N'Aisha Duo');
INSERT INTO artists (id, name) VALUES (198, N'Habib Koité and Bamada');
INSERT INTO artists (id, name) VALUES (199, N'Karsh Kale');
INSERT INTO artists (id, name) VALUES (200, N'The Posies');
INSERT INTO artists (id, name) VALUES (201, N'Luciana Souza/Romero Lubambo');
INSERT INTO artists (id, name) VALUES (202, N'Aaron Goldberg');
INSERT INTO artists (id, name) VALUES (203, N'Nicolaus Esterhazy Sinfonia');
INSERT INTO artists (id, name) VALUES (204, N'Temple of the Dog');
INSERT INTO artists (id, name) VALUES (205, N'Chris Cornell');
INSERT INTO artists (id, name) VALUES (206, N'Alberto Turco & Nova Schola Gregoriana');
INSERT INTO artists (id, name) VALUES (207, N'Richard Marlow & The Choir of Trinity College, Cambridge');
INSERT INTO artists (id, name) VALUES (208, N'English Concert & Trevor Pinnock');
INSERT INTO artists (id, name) VALUES (209, N'Anne-Sophie Mutter, Herbert Von Karajan & Wiener Philharmoniker');
INSERT INTO artists (id, name) VALUES (210, N'Hilary Hahn, Jeffrey Kahane, Los Angeles Chamber Orchestra & Margaret Batjer');
INSERT INTO artists (id, name) VALUES (211, N'Wilhelm Kempff');
INSERT INTO artists (id, name) VALUES (212, N'Yo-Yo Ma');
INSERT INTO artists (id, name) VALUES (213, N'Scholars Baroque Ensemble');
INSERT INTO artists (id, name) VALUES (214, N'Academy of St. Martin in the Fields & Sir Neville Marriner');
INSERT INTO artists (id, name) VALUES (215, N'Academy of St. Martin in the Fields Chamber Ensemble & Sir Neville Marriner');
INSERT INTO artists (id, name) VALUES (216, N'Berliner Philharmoniker, Claudio Abbado & Sabine Meyer');
INSERT INTO artists (id, name) VALUES (217, N'Royal Philharmonic Orchestra & Sir Thomas Beecham');
INSERT INTO artists (id, name) VALUES (218, N'Orchestre Révolutionnaire et Romantique & John Eliot Gardiner');
INSERT INTO artists (id, name) VALUES (219, N'Britten Sinfonia, Ivor Bolton & Lesley Garrett');
INSERT INTO artists (id, name) VALUES (220, N'Chicago Symphony Chorus, Chicago Symphony Orchestra & Sir Georg Solti');
INSERT INTO artists (id, name) VALUES (221, N'Sir Georg Solti & Wiener Philharmoniker');
INSERT INTO artists (id, name) VALUES (222, N'Academy of St. Martin in the Fields, John Birch, Sir Neville Marriner & Sylvia McNair');
INSERT INTO artists (id, name) VALUES (223, N'London Symphony Orchestra & Sir Charles Mackerras');
INSERT INTO artists (id, name) VALUES (224, N'Barry Wordsworth & BBC Concert Orchestra');
INSERT INTO artists (id, name) VALUES (225, N'Herbert Von Karajan, Mirella Freni & Wiener Philharmoniker');
INSERT INTO artists (id, name) VALUES (226, N'Eugene Ormandy');
INSERT INTO artists (id, name) VALUES (227, N'Luciano Pavarotti');
INSERT INTO artists (id, name) VALUES (228, N'Leonard Bernstein & New York Philharmonic');
INSERT INTO artists (id, name) VALUES (229, N'Boston Symphony Orchestra & Seiji Ozawa');
INSERT INTO artists (id, name) VALUES (230, N'Aaron Copland & London Symphony Orchestra');
INSERT INTO artists (id, name) VALUES (231, N'Ton Koopman');
INSERT INTO artists (id, name) VALUES (232, N'Sergei Prokofiev & Yuri Temirkanov');
INSERT INTO artists (id, name) VALUES (233, N'Chicago Symphony Orchestra & Fritz Reiner');
INSERT INTO artists (id, name) VALUES (234, N'Orchestra of The Age of Enlightenment');
INSERT INTO artists (id, name) VALUES (235, N'Emanuel Ax, Eugene Ormandy & Philadelphia Orchestra');
INSERT INTO artists (id, name) VALUES (236, N'James Levine');
INSERT INTO artists (id, name) VALUES (237, N'Berliner Philharmoniker & Hans Rosbaud');
INSERT INTO artists (id, name) VALUES (238, N'Maurizio Pollini');
INSERT INTO artists (id, name) VALUES (239, N'Academy of St. Martin in the Fields, Sir Neville Marriner & William Bennett');
INSERT INTO artists (id, name) VALUES (240, N'Gustav Mahler');
INSERT INTO artists (id, name) VALUES (241, N'Felix Schmidt, London Symphony Orchestra & Rafael Frühbeck de Burgos');
INSERT INTO artists (id, name) VALUES (242, N'Edo de Waart & San Francisco Symphony');
INSERT INTO artists (id, name) VALUES (243, N'Antal Doráti & London Symphony Orchestra');
INSERT INTO artists (id, name) VALUES (244, N'Choir Of Westminster Abbey & Simon Preston');
INSERT INTO artists (id, name) VALUES (245, N'Michael Tilson Thomas & San Francisco Symphony');
INSERT INTO artists (id, name) VALUES (246, N'Chor der Wiener Staatsoper, Herbert Von Karajan & Wiener Philharmoniker');
INSERT INTO artists (id, name) VALUES (247, N'The King''s Singers');
INSERT INTO artists (id, name) VALUES (248, N'Berliner Philharmoniker & Herbert Von Karajan');
INSERT INTO artists (id, name) VALUES (249, N'Sir Georg Solti, Sumi Jo & Wiener Philharmoniker');
INSERT INTO artists (id, name) VALUES (250, N'Christopher O''Riley');
INSERT INTO artists (id, name) VALUES (251, N'Fretwork');
INSERT INTO artists (id, name) VALUES (252, N'Amy Winehouse');
INSERT INTO artists (id, name) VALUES (253, N'Calexico');
INSERT INTO artists (id, name) VALUES (254, N'Otto Klemperer & Philharmonia Orchestra');
INSERT INTO artists (id, name) VALUES (255, N'Yehudi Menuhin');
INSERT INTO artists (id, name) VALUES (256, N'Philharmonia Orchestra & Sir Neville Marriner');
INSERT INTO artists (id, name) VALUES (257, N'Academy of St. Martin in the Fields, Sir Neville Marriner & Thurston Dart');
INSERT INTO artists (id, name) VALUES (258, N'Les Arts Florissants & William Christie');
INSERT INTO artists (id, name) VALUES (259, N'The 12 Cellists of The Berlin Philharmonic');
INSERT INTO artists (id, name) VALUES (260, N'Adrian Leaper & Doreen de Feis');
INSERT INTO artists (id, name) VALUES (261, N'Roger Norrington, London Classical Players');
INSERT INTO artists (id, name) VALUES (262, N'Charles Dutoit & L''Orchestre Symphonique de Montréal');
INSERT INTO artists (id, name) VALUES (263, N'Equale Brass Ensemble, John Eliot Gardiner & Munich Monteverdi Orchestra and Choir');
INSERT INTO artists (id, name) VALUES (264, N'Kent Nagano and Orchestre de l''Opéra de Lyon');
INSERT INTO artists (id, name) VALUES (265, N'Julian Bream');
INSERT INTO artists (id, name) VALUES (266, N'Martin Roscoe');
INSERT INTO artists (id, name) VALUES (267, N'Göteborgs Symfoniker & Neeme Järvi');
INSERT INTO artists (id, name) VALUES (268, N'Itzhak Perlman');
INSERT INTO artists (id, name) VALUES (269, N'Michele Campanella');
INSERT INTO artists (id, name) VALUES (270, N'Gerald Moore');
INSERT INTO artists (id, name) VALUES (271, N'Mela Tenenbaum, Pro Musica Prague & Richard Kapp');
INSERT INTO artists (id, name) VALUES (272, N'Emerson String Quartet');
INSERT INTO artists (id, name) VALUES (273, N'C. Monteverdi, Nigel Rogers - Chiaroscuro; London Baroque; London Cornett & Sackbu');
INSERT INTO artists (id, name) VALUES (274, N'Nash Ensemble');
INSERT INTO artists (id, name) VALUES (275, N'Philip Glass Ensemble');

INSERT INTO albums (id, title, artist_id) VALUES (1, N'For Those About To Rock We Salute You', 1);
INSERT INTO albums (id, title, artist_id) VALUES (2, N'Balls to the Wall', 2);
INSERT INTO albums (id, title, artist_id) VALUES (3, N'Restless and Wild', 2);
INSERT INTO albums (id, title, artist_id) VALUES (4, N'Let There Be Rock', 1);
INSERT INTO albums (id, title, artist_id) VALUES (5, N'Big Ones', 3);
INSERT INTO albums (id, title, artist_id) VALUES (6, N'Jagged Little Pill', 4);
INSERT INTO albums (id, title, artist_id) VALUES (7, N'Facelift', 5);
INSERT INTO albums (id, title, artist_id) VALUES (8, N'Warner 25 Anos', 6);
INSERT INTO albums (id, title, artist_id) VALUES (9, N'Plays Metallica By Four Cellos', 7);
INSERT INTO albums (id, title, artist_id) VALUES (10, N'Audioslave', 8);
INSERT INTO albums (id, title, artist_id) VALUES (11, N'Out Of Exile', 8);
INSERT INTO albums (id, title, artist_id) VALUES (12, N'BackBeat Soundtrack', 9);
INSERT INTO albums (id, title, artist_id) VALUES (13, N'The Best Of Billy Cobham', 10);
INSERT INTO albums (id, title, artist_id) VALUES (14, N'Alcohol Fueled Brewtality Live! [Disc 1]', 11);
INSERT INTO albums (id, title, artist_id) VALUES (15, N'Alcohol Fueled Brewtality Live! [Disc 2]', 11);
INSERT INTO albums (id, title, artist_id) VALUES (16, N'Black Sabbath', 12);
INSERT INTO albums (id, title, artist_id) VALUES (17, N'Black Sabbath Vol. 4 (Remaster)', 12);
INSERT INTO albums (id, title, artist_id) VALUES (18, N'Body Count', 13);
INSERT INTO albums (id, title, artist_id) VALUES (19, N'Chemical Wedding', 14);
INSERT INTO albums (id, title, artist_id) VALUES (20, N'The Best Of Buddy Guy - The Millenium Collection', 15);
INSERT INTO albums (id, title, artist_id) VALUES (21, N'Prenda Minha', 16);
INSERT INTO albums (id, title, artist_id) VALUES (22, N'Sozinho Remix Ao Vivo', 16);
INSERT INTO albums (id, title, artist_id) VALUES (23, N'Minha Historia', 17);
INSERT INTO albums (id, title, artist_id) VALUES (24, N'Afrociberdelia', 18);
INSERT INTO albums (id, title, artist_id) VALUES (25, N'Da Lama Ao Caos', 18);
INSERT INTO albums (id, title, artist_id) VALUES (26, N'Acústico MTV [Live]', 19);
INSERT INTO albums (id, title, artist_id) VALUES (27, N'Cidade Negra - Hits', 19);
INSERT INTO albums (id, title, artist_id) VALUES (28, N'Na Pista', 20);
INSERT INTO albums (id, title, artist_id) VALUES (29, N'Axé Bahia 2001', 21);
INSERT INTO albums (id, title, artist_id) VALUES (30, N'BBC Sessions [Disc 1] [Live]', 22);
INSERT INTO albums (id, title, artist_id) VALUES (31, N'Bongo Fury', 23);
INSERT INTO albums (id, title, artist_id) VALUES (32, N'Carnaval 2001', 21);
INSERT INTO albums (id, title, artist_id) VALUES (33, N'Chill: Brazil (Disc 1)', 24);
INSERT INTO albums (id, title, artist_id) VALUES (34, N'Chill: Brazil (Disc 2)', 6);
INSERT INTO albums (id, title, artist_id) VALUES (35, N'Garage Inc. (Disc 1)', 50);
INSERT INTO albums (id, title, artist_id) VALUES (36, N'Greatest Hits II', 51);
INSERT INTO albums (id, title, artist_id) VALUES (37, N'Greatest Kiss', 52);
INSERT INTO albums (id, title, artist_id) VALUES (38, N'Heart of the Night', 53);
INSERT INTO albums (id, title, artist_id) VALUES (39, N'International Superhits', 54);
INSERT INTO albums (id, title, artist_id) VALUES (40, N'Into The Light', 55);
INSERT INTO albums (id, title, artist_id) VALUES (41, N'Meus Momentos', 56);
INSERT INTO albums (id, title, artist_id) VALUES (42, N'Minha História', 57);
INSERT INTO albums (id, title, artist_id) VALUES (43, N'MK III The Final Concerts [Disc 1]', 58);
INSERT INTO albums (id, title, artist_id) VALUES (44, N'Physical Graffiti [Disc 1]', 22);
INSERT INTO albums (id, title, artist_id) VALUES (45, N'Sambas De Enredo 2001', 21);
INSERT INTO albums (id, title, artist_id) VALUES (46, N'Supernatural', 59);
INSERT INTO albums (id, title, artist_id) VALUES (47, N'The Best of Ed Motta', 37);
INSERT INTO albums (id, title, artist_id) VALUES (48, N'The Essential Miles Davis [Disc 1]', 68);
INSERT INTO albums (id, title, artist_id) VALUES (49, N'The Essential Miles Davis [Disc 2]', 68);
INSERT INTO albums (id, title, artist_id) VALUES (50, N'The Final Concerts (Disc 2)', 58);
INSERT INTO albums (id, title, artist_id) VALUES (51, N'Up An'' Atom', 69);
INSERT INTO albums (id, title, artist_id) VALUES (52, N'Vinícius De Moraes - Sem Limite', 70);
INSERT INTO albums (id, title, artist_id) VALUES (53, N'Vozes do MPB', 21);
INSERT INTO albums (id, title, artist_id) VALUES (54, N'Chronicle, Vol. 1', 76);
INSERT INTO albums (id, title, artist_id) VALUES (55, N'Chronicle, Vol. 2', 76);
INSERT INTO albums (id, title, artist_id) VALUES (56, N'Cássia Eller - Coleção Sem Limite [Disc 2]', 77);
INSERT INTO albums (id, title, artist_id) VALUES (57, N'Cássia Eller - Sem Limite [Disc 1]', 77);
INSERT INTO albums (id, title, artist_id) VALUES (58, N'Come Taste The Band', 58);
INSERT INTO albums (id, title, artist_id) VALUES (59, N'Deep Purple In Rock', 58);
INSERT INTO albums (id, title, artist_id) VALUES (60, N'Fireball', 58);
INSERT INTO albums (id, title, artist_id) VALUES (61, N'Knocking at Your Back Door: The Best Of Deep Purple in the 80''s', 58);
INSERT INTO albums (id, title, artist_id) VALUES (62, N'Machine Head', 58);
INSERT INTO albums (id, title, artist_id) VALUES (63, N'Purpendicular', 58);
INSERT INTO albums (id, title, artist_id) VALUES (64, N'Slaves And Masters', 58);
INSERT INTO albums (id, title, artist_id) VALUES (65, N'Stormbringer', 58);
INSERT INTO albums (id, title, artist_id) VALUES (66, N'The Battle Rages On', 58);
INSERT INTO albums (id, title, artist_id) VALUES (67, N'Vault: Def Leppard''s Greatest Hits', 78);
INSERT INTO albums (id, title, artist_id) VALUES (68, N'Outbreak', 79);
INSERT INTO albums (id, title, artist_id) VALUES (69, N'Djavan Ao Vivo - Vol. 02', 80);
INSERT INTO albums (id, title, artist_id) VALUES (70, N'Djavan Ao Vivo - Vol. 1', 80);
INSERT INTO albums (id, title, artist_id) VALUES (71, N'Elis Regina-Minha História', 41);
INSERT INTO albums (id, title, artist_id) VALUES (72, N'The Cream Of Clapton', 81);
INSERT INTO albums (id, title, artist_id) VALUES (73, N'Unplugged', 81);
INSERT INTO albums (id, title, artist_id) VALUES (74, N'albums Of The Year', 82);
INSERT INTO albums (id, title, artist_id) VALUES (75, N'Angel Dust', 82);
INSERT INTO albums (id, title, artist_id) VALUES (76, N'King For A Day Fool For A Lifetime', 82);
INSERT INTO albums (id, title, artist_id) VALUES (77, N'The Real Thing', 82);
INSERT INTO albums (id, title, artist_id) VALUES (78, N'Deixa Entrar', 83);
INSERT INTO albums (id, title, artist_id) VALUES (79, N'In Your Honor [Disc 1]', 84);
INSERT INTO albums (id, title, artist_id) VALUES (80, N'In Your Honor [Disc 2]', 84);
INSERT INTO albums (id, title, artist_id) VALUES (81, N'One By One', 84);
INSERT INTO albums (id, title, artist_id) VALUES (82, N'The Colour And The Shape', 84);
INSERT INTO albums (id, title, artist_id) VALUES (83, N'My Way: The Best Of Frank Sinatra [Disc 1]', 85);
INSERT INTO albums (id, title, artist_id) VALUES (84, N'Roda De Funk', 86);
INSERT INTO albums (id, title, artist_id) VALUES (85, N'As Canções de Eu Tu Eles', 27);
INSERT INTO albums (id, title, artist_id) VALUES (86, N'Quanta Gente Veio Ver (Live)', 27);
INSERT INTO albums (id, title, artist_id) VALUES (87, N'Quanta Gente Veio ver--Bônus De Carnaval', 27);
INSERT INTO albums (id, title, artist_id) VALUES (88, N'Faceless', 87);
INSERT INTO albums (id, title, artist_id) VALUES (89, N'American Idiot', 54);
INSERT INTO albums (id, title, artist_id) VALUES (90, N'Appetite for Destruction', 88);
INSERT INTO albums (id, title, artist_id) VALUES (91, N'Use Your Illusion I', 88);
INSERT INTO albums (id, title, artist_id) VALUES (92, N'Use Your Illusion II', 88);
INSERT INTO albums (id, title, artist_id) VALUES (93, N'Blue Moods', 89);
INSERT INTO albums (id, title, artist_id) VALUES (94, N'A Matter of Life and Death', 90);
INSERT INTO albums (id, title, artist_id) VALUES (95, N'A Real Dead One', 90);
INSERT INTO albums (id, title, artist_id) VALUES (96, N'A Real Live One', 90);
INSERT INTO albums (id, title, artist_id) VALUES (97, N'Brave New World', 90);
INSERT INTO albums (id, title, artist_id) VALUES (98, N'Dance Of Death', 90);
INSERT INTO albums (id, title, artist_id) VALUES (99, N'Fear Of The Dark', 90);
INSERT INTO albums (id, title, artist_id) VALUES (100, N'Iron Maiden', 90);
INSERT INTO albums (id, title, artist_id) VALUES (101, N'Killers', 90);
INSERT INTO albums (id, title, artist_id) VALUES (102, N'Live After Death', 90);
INSERT INTO albums (id, title, artist_id) VALUES (103, N'Live At Donington 1992 (Disc 1)', 90);
INSERT INTO albums (id, title, artist_id) VALUES (104, N'Live At Donington 1992 (Disc 2)', 90);
INSERT INTO albums (id, title, artist_id) VALUES (105, N'No Prayer For The Dying', 90);
INSERT INTO albums (id, title, artist_id) VALUES (106, N'Piece Of Mind', 90);
INSERT INTO albums (id, title, artist_id) VALUES (107, N'Powerslave', 90);
INSERT INTO albums (id, title, artist_id) VALUES (108, N'Rock In Rio [CD1]', 90);
INSERT INTO albums (id, title, artist_id) VALUES (109, N'Rock In Rio [CD2]', 90);
INSERT INTO albums (id, title, artist_id) VALUES (110, N'Seventh Son of a Seventh Son', 90);
INSERT INTO albums (id, title, artist_id) VALUES (111, N'Somewhere in Time', 90);
INSERT INTO albums (id, title, artist_id) VALUES (112, N'The Number of The Beast', 90);
INSERT INTO albums (id, title, artist_id) VALUES (113, N'The X Factor', 90);
INSERT INTO albums (id, title, artist_id) VALUES (114, N'Virtual XI', 90);
INSERT INTO albums (id, title, artist_id) VALUES (115, N'Sex Machine', 91);
INSERT INTO albums (id, title, artist_id) VALUES (116, N'Emergency On Planet Earth', 92);
INSERT INTO albums (id, title, artist_id) VALUES (117, N'Synkronized', 92);
INSERT INTO albums (id, title, artist_id) VALUES (118, N'The Return Of The Space Cowboy', 92);
INSERT INTO albums (id, title, artist_id) VALUES (119, N'Get Born', 93);
INSERT INTO albums (id, title, artist_id) VALUES (120, N'Are You Experienced?', 94);
INSERT INTO albums (id, title, artist_id) VALUES (121, N'Surfing with the Alien (Remastered)', 95);
INSERT INTO albums (id, title, artist_id) VALUES (122, N'Jorge Ben Jor 25 Anos', 46);
INSERT INTO albums (id, title, artist_id) VALUES (123, N'Jota Quest-1995', 96);
INSERT INTO albums (id, title, artist_id) VALUES (124, N'Cafezinho', 97);
INSERT INTO albums (id, title, artist_id) VALUES (125, N'Living After Midnight', 98);
INSERT INTO albums (id, title, artist_id) VALUES (126, N'Unplugged [Live]', 52);
INSERT INTO albums (id, title, artist_id) VALUES (127, N'BBC Sessions [Disc 2] [Live]', 22);
INSERT INTO albums (id, title, artist_id) VALUES (128, N'Coda', 22);
INSERT INTO albums (id, title, artist_id) VALUES (129, N'Houses Of The Holy', 22);
INSERT INTO albums (id, title, artist_id) VALUES (130, N'In Through The Out Door', 22);
INSERT INTO albums (id, title, artist_id) VALUES (131, N'IV', 22);
INSERT INTO albums (id, title, artist_id) VALUES (132, N'Led Zeppelin I', 22);
INSERT INTO albums (id, title, artist_id) VALUES (133, N'Led Zeppelin II', 22);
INSERT INTO albums (id, title, artist_id) VALUES (134, N'Led Zeppelin III', 22);
INSERT INTO albums (id, title, artist_id) VALUES (135, N'Physical Graffiti [Disc 2]', 22);
INSERT INTO albums (id, title, artist_id) VALUES (136, N'Presence', 22);
INSERT INTO albums (id, title, artist_id) VALUES (137, N'The Song Remains The Same (Disc 1)', 22);
INSERT INTO albums (id, title, artist_id) VALUES (138, N'The Song Remains The Same (Disc 2)', 22);
INSERT INTO albums (id, title, artist_id) VALUES (139, N'A TempestadeTempestade Ou O Livro Dos Dias', 99);
INSERT INTO albums (id, title, artist_id) VALUES (140, N'Mais Do Mesmo', 99);
INSERT INTO albums (id, title, artist_id) VALUES (141, N'Greatest Hits', 100);
INSERT INTO albums (id, title, artist_id) VALUES (142, N'Lulu Santos - RCA 100 Anos De Música - Álbum 01', 101);
INSERT INTO albums (id, title, artist_id) VALUES (143, N'Lulu Santos - RCA 100 Anos De Música - Álbum 02', 101);
INSERT INTO albums (id, title, artist_id) VALUES (144, N'Misplaced Childhood', 102);
INSERT INTO albums (id, title, artist_id) VALUES (145, N'Barulhinho Bom', 103);
INSERT INTO albums (id, title, artist_id) VALUES (146, N'Seek And Shall Find: More Of The Best (1963-1981)', 104);
INSERT INTO albums (id, title, artist_id) VALUES (147, N'The Best Of Men At Work', 105);
INSERT INTO albums (id, title, artist_id) VALUES (148, N'Black albums', 50);
INSERT INTO albums (id, title, artist_id) VALUES (149, N'Garage Inc. (Disc 2)', 50);
INSERT INTO albums (id, title, artist_id) VALUES (150, N'Kill ''Em All', 50);
INSERT INTO albums (id, title, artist_id) VALUES (151, N'Load', 50);
INSERT INTO albums (id, title, artist_id) VALUES (152, N'Master Of Puppets', 50);
INSERT INTO albums (id, title, artist_id) VALUES (153, N'ReLoad', 50);
INSERT INTO albums (id, title, artist_id) VALUES (154, N'Ride The Lightning', 50);
INSERT INTO albums (id, title, artist_id) VALUES (155, N'St. Anger', 50);
INSERT INTO albums (id, title, artist_id) VALUES (156, N'...And Justice For All', 50);
INSERT INTO albums (id, title, artist_id) VALUES (157, N'Miles Ahead', 68);
INSERT INTO albums (id, title, artist_id) VALUES (158, N'Milton Nascimento Ao Vivo', 42);
INSERT INTO albums (id, title, artist_id) VALUES (159, N'Minas', 42);
INSERT INTO albums (id, title, artist_id) VALUES (160, N'Ace Of Spades', 106);
INSERT INTO albums (id, title, artist_id) VALUES (161, N'Demorou...', 108);
INSERT INTO albums (id, title, artist_id) VALUES (162, N'Motley Crue Greatest Hits', 109);
INSERT INTO albums (id, title, artist_id) VALUES (163, N'From The Muddy Banks Of The Wishkah [Live]', 110);
INSERT INTO albums (id, title, artist_id) VALUES (164, N'Nevermind', 110);
INSERT INTO albums (id, title, artist_id) VALUES (165, N'Compositores', 111);
INSERT INTO albums (id, title, artist_id) VALUES (166, N'Olodum', 112);
INSERT INTO albums (id, title, artist_id) VALUES (167, N'Acústico MTV', 113);
INSERT INTO albums (id, title, artist_id) VALUES (168, N'Arquivo II', 113);
INSERT INTO albums (id, title, artist_id) VALUES (169, N'Arquivo Os Paralamas Do Sucesso', 113);
INSERT INTO albums (id, title, artist_id) VALUES (170, N'Bark at the Moon (Remastered)', 114);
INSERT INTO albums (id, title, artist_id) VALUES (171, N'Blizzard of Ozz', 114);
INSERT INTO albums (id, title, artist_id) VALUES (172, N'Diary of a Madman (Remastered)', 114);
INSERT INTO albums (id, title, artist_id) VALUES (173, N'No More Tears (Remastered)', 114);
INSERT INTO albums (id, title, artist_id) VALUES (174, N'Tribute', 114);
INSERT INTO albums (id, title, artist_id) VALUES (175, N'Walking Into Clarksdale', 115);
INSERT INTO albums (id, title, artist_id) VALUES (176, N'Original Soundtracks 1', 116);
INSERT INTO albums (id, title, artist_id) VALUES (177, N'The Beast Live', 117);
INSERT INTO albums (id, title, artist_id) VALUES (178, N'Live On Two Legs [Live]', 118);
INSERT INTO albums (id, title, artist_id) VALUES (179, N'Pearl Jam', 118);
INSERT INTO albums (id, title, artist_id) VALUES (180, N'Riot Act', 118);
INSERT INTO albums (id, title, artist_id) VALUES (181, N'Ten', 118);
INSERT INTO albums (id, title, artist_id) VALUES (182, N'Vs.', 118);
INSERT INTO albums (id, title, artist_id) VALUES (183, N'Dark Side Of The Moon', 120);
INSERT INTO albums (id, title, artist_id) VALUES (184, N'Os Cães Ladram Mas A Caravana Não Pára', 121);
INSERT INTO albums (id, title, artist_id) VALUES (185, N'Greatest Hits I', 51);
INSERT INTO albums (id, title, artist_id) VALUES (186, N'News Of The World', 51);
INSERT INTO albums (id, title, artist_id) VALUES (187, N'Out Of Time', 122);
INSERT INTO albums (id, title, artist_id) VALUES (188, N'Green', 124);
INSERT INTO albums (id, title, artist_id) VALUES (189, N'New Adventures In Hi-Fi', 124);
INSERT INTO albums (id, title, artist_id) VALUES (190, N'The Best Of R.E.M.: The IRS Years', 124);
INSERT INTO albums (id, title, artist_id) VALUES (191, N'Cesta Básica', 125);
INSERT INTO albums (id, title, artist_id) VALUES (192, N'Raul Seixas', 126);
INSERT INTO albums (id, title, artist_id) VALUES (193, N'Blood Sugar Sex Magik', 127);
INSERT INTO albums (id, title, artist_id) VALUES (194, N'By The Way', 127);
INSERT INTO albums (id, title, artist_id) VALUES (195, N'Californication', 127);
INSERT INTO albums (id, title, artist_id) VALUES (196, N'Retrospective I (1974-1980)', 128);
INSERT INTO albums (id, title, artist_id) VALUES (197, N'Santana - As Years Go By', 59);
INSERT INTO albums (id, title, artist_id) VALUES (198, N'Santana Live', 59);
INSERT INTO albums (id, title, artist_id) VALUES (199, N'Maquinarama', 130);
INSERT INTO albums (id, title, artist_id) VALUES (200, N'O Samba Poconé', 130);
INSERT INTO albums (id, title, artist_id) VALUES (201, N'Judas 0: B-Sides and Rarities', 131);
INSERT INTO albums (id, title, artist_id) VALUES (202, N'Rotten Apples: Greatest Hits', 131);
INSERT INTO albums (id, title, artist_id) VALUES (203, N'A-Sides', 132);
INSERT INTO albums (id, title, artist_id) VALUES (204, N'Morning Dance', 53);
INSERT INTO albums (id, title, artist_id) VALUES (205, N'In Step', 133);
INSERT INTO albums (id, title, artist_id) VALUES (206, N'Core', 134);
INSERT INTO albums (id, title, artist_id) VALUES (207, N'Mezmerize', 135);
INSERT INTO albums (id, title, artist_id) VALUES (208, N'[1997] Black Light Syndrome', 136);
INSERT INTO albums (id, title, artist_id) VALUES (209, N'Live [Disc 1]', 137);
INSERT INTO albums (id, title, artist_id) VALUES (210, N'Live [Disc 2]', 137);
INSERT INTO albums (id, title, artist_id) VALUES (211, N'The Singles', 138);
INSERT INTO albums (id, title, artist_id) VALUES (212, N'Beyond Good And Evil', 139);
INSERT INTO albums (id, title, artist_id) VALUES (213, N'Pure Cult: The Best Of The Cult (For Rockers, Ravers, Lovers & Sinners) [UK]', 139);
INSERT INTO albums (id, title, artist_id) VALUES (214, N'The Doors', 140);
INSERT INTO albums (id, title, artist_id) VALUES (215, N'The Police Greatest Hits', 141);
INSERT INTO albums (id, title, artist_id) VALUES (216, N'Hot Rocks, 1964-1971 (Disc 1)', 142);
INSERT INTO albums (id, title, artist_id) VALUES (217, N'No Security', 142);
INSERT INTO albums (id, title, artist_id) VALUES (218, N'Voodoo Lounge', 142);
INSERT INTO albums (id, title, artist_id) VALUES (219, N'Tangents', 143);
INSERT INTO albums (id, title, artist_id) VALUES (220, N'Transmission', 143);
INSERT INTO albums (id, title, artist_id) VALUES (221, N'My Generation - The Very Best Of The Who', 144);
INSERT INTO albums (id, title, artist_id) VALUES (222, N'Serie Sem Limite (Disc 1)', 145);
INSERT INTO albums (id, title, artist_id) VALUES (223, N'Serie Sem Limite (Disc 2)', 145);
INSERT INTO albums (id, title, artist_id) VALUES (224, N'Acústico', 146);
INSERT INTO albums (id, title, artist_id) VALUES (225, N'Volume Dois', 146);
INSERT INTO albums (id, title, artist_id) VALUES (226, N'Battlestar Galactica: The Story So Far', 147);
INSERT INTO albums (id, title, artist_id) VALUES (227, N'Battlestar Galactica, Season 3', 147);
INSERT INTO albums (id, title, artist_id) VALUES (228, N'Heroes, Season 1', 148);
INSERT INTO albums (id, title, artist_id) VALUES (229, N'Lost, Season 3', 149);
INSERT INTO albums (id, title, artist_id) VALUES (230, N'Lost, Season 1', 149);
INSERT INTO albums (id, title, artist_id) VALUES (231, N'Lost, Season 2', 149);
INSERT INTO albums (id, title, artist_id) VALUES (232, N'Achtung Baby', 150);
INSERT INTO albums (id, title, artist_id) VALUES (233, N'All That You Can''t Leave Behind', 150);
INSERT INTO albums (id, title, artist_id) VALUES (234, N'B-Sides 1980-1990', 150);
INSERT INTO albums (id, title, artist_id) VALUES (235, N'How To Dismantle An Atomic Bomb', 150);
INSERT INTO albums (id, title, artist_id) VALUES (236, N'Pop', 150);
INSERT INTO albums (id, title, artist_id) VALUES (237, N'Rattle And Hum', 150);
INSERT INTO albums (id, title, artist_id) VALUES (238, N'The Best Of 1980-1990', 150);
INSERT INTO albums (id, title, artist_id) VALUES (239, N'War', 150);
INSERT INTO albums (id, title, artist_id) VALUES (240, N'Zooropa', 150);
INSERT INTO albums (id, title, artist_id) VALUES (241, N'UB40 The Best Of - Volume Two [UK]', 151);
INSERT INTO albums (id, title, artist_id) VALUES (242, N'Diver Down', 152);
INSERT INTO albums (id, title, artist_id) VALUES (243, N'The Best Of Van Halen, Vol. I', 152);
INSERT INTO albums (id, title, artist_id) VALUES (244, N'Van Halen', 152);
INSERT INTO albums (id, title, artist_id) VALUES (245, N'Van Halen III', 152);
INSERT INTO albums (id, title, artist_id) VALUES (246, N'Contraband', 153);
INSERT INTO albums (id, title, artist_id) VALUES (247, N'Vinicius De Moraes', 72);
INSERT INTO albums (id, title, artist_id) VALUES (248, N'Ao Vivo [IMPORT]', 155);
INSERT INTO albums (id, title, artist_id) VALUES (249, N'The Office, Season 1', 156);
INSERT INTO albums (id, title, artist_id) VALUES (250, N'The Office, Season 2', 156);
INSERT INTO albums (id, title, artist_id) VALUES (251, N'The Office, Season 3', 156);
INSERT INTO albums (id, title, artist_id) VALUES (252, N'Un-Led-Ed', 157);
INSERT INTO albums (id, title, artist_id) VALUES (253, N'Battlestar Galactica (Classic), Season 1', 158);
INSERT INTO albums (id, title, artist_id) VALUES (254, N'Aquaman', 159);
INSERT INTO albums (id, title, artist_id) VALUES (255, N'Instant Karma: The Amnesty International Campaign to Save Darfur', 150);
INSERT INTO albums (id, title, artist_id) VALUES (256, N'Speak of the Devil', 114);
INSERT INTO albums (id, title, artist_id) VALUES (257, N'20th Century Masters - The Millennium Collection: The Best of Scorpions', 179);
INSERT INTO albums (id, title, artist_id) VALUES (258, N'House of Pain', 180);
INSERT INTO albums (id, title, artist_id) VALUES (259, N'Radio Brasil (O Som da Jovem Vanguarda) - Seleccao de Henrique Amaro', 36);
INSERT INTO albums (id, title, artist_id) VALUES (260, N'Cake: B-Sides and Rarities', 196);
INSERT INTO albums (id, title, artist_id) VALUES (261, N'LOST, Season 4', 149);
INSERT INTO albums (id, title, artist_id) VALUES (262, N'Quiet Songs', 197);
INSERT INTO albums (id, title, artist_id) VALUES (263, N'Muso Ko', 198);
INSERT INTO albums (id, title, artist_id) VALUES (264, N'Realize', 199);
INSERT INTO albums (id, title, artist_id) VALUES (265, N'Every Kind of Light', 200);
INSERT INTO albums (id, title, artist_id) VALUES (266, N'Duos II', 201);
INSERT INTO albums (id, title, artist_id) VALUES (267, N'Worlds', 202);
INSERT INTO albums (id, title, artist_id) VALUES (268, N'The Best of Beethoven', 203);
INSERT INTO albums (id, title, artist_id) VALUES (269, N'Temple of the Dog', 204);
INSERT INTO albums (id, title, artist_id) VALUES (270, N'Carry On', 205);
INSERT INTO albums (id, title, artist_id) VALUES (271, N'Revelations', 8);
INSERT INTO albums (id, title, artist_id) VALUES (272, N'Adorate Deum: Gregorian Chant from the Proper of the Mass', 206);
INSERT INTO albums (id, title, artist_id) VALUES (273, N'Allegri: Miserere', 207);
INSERT INTO albums (id, title, artist_id) VALUES (274, N'Pachelbel: Canon & Gigue', 208);
INSERT INTO albums (id, title, artist_id) VALUES (275, N'Vivaldi: The Four Seasons', 209);
INSERT INTO albums (id, title, artist_id) VALUES (276, N'Bach: Violin Concertos', 210);
INSERT INTO albums (id, title, artist_id) VALUES (277, N'Bach: Goldberg Variations', 211);
INSERT INTO albums (id, title, artist_id) VALUES (278, N'Bach: The Cello Suites', 212);
INSERT INTO albums (id, title, artist_id) VALUES (279, N'Handel: The Messiah (Highlights)', 213);
INSERT INTO albums (id, title, artist_id) VALUES (280, N'The World of Classical Favourites', 214);
INSERT INTO albums (id, title, artist_id) VALUES (281, N'Sir Neville Marriner: A Celebration', 215);
INSERT INTO albums (id, title, artist_id) VALUES (282, N'Mozart: Wind Concertos', 216);
INSERT INTO albums (id, title, artist_id) VALUES (283, N'Haydn: Symphonies 99 - 104', 217);
INSERT INTO albums (id, title, artist_id) VALUES (284, N'Beethoven: Symhonies Nos. 5 & 6', 218);
INSERT INTO albums (id, title, artist_id) VALUES (285, N'A Soprano Inspired', 219);
INSERT INTO albums (id, title, artist_id) VALUES (286, N'Great Opera Choruses', 220);
INSERT INTO albums (id, title, artist_id) VALUES (287, N'Wagner: Favourite Overtures', 221);
INSERT INTO albums (id, title, artist_id) VALUES (288, N'Fauré: Requiem, Ravel: Pavane & Others', 222);
INSERT INTO albums (id, title, artist_id) VALUES (289, N'Tchaikovsky: The Nutcracker', 223);
INSERT INTO albums (id, title, artist_id) VALUES (290, N'The Last Night of the Proms', 224);
INSERT INTO albums (id, title, artist_id) VALUES (291, N'Puccini: Madama Butterfly - Highlights', 225);
INSERT INTO albums (id, title, artist_id) VALUES (292, N'Holst: The Planets, Op. 32 & Vaughan Williams: Fantasies', 226);
INSERT INTO albums (id, title, artist_id) VALUES (293, N'Pavarotti''s Opera Made Easy', 227);
INSERT INTO albums (id, title, artist_id) VALUES (294, N'Great Performances - Barber''s Adagio and Other Romantic Favorites for Strings', 228);
INSERT INTO albums (id, title, artist_id) VALUES (295, N'Carmina Burana', 229);
INSERT INTO albums (id, title, artist_id) VALUES (296, N'A Copland Celebration, Vol. I', 230);
INSERT INTO albums (id, title, artist_id) VALUES (297, N'Bach: Toccata & Fugue in D Minor', 231);
INSERT INTO albums (id, title, artist_id) VALUES (298, N'Prokofiev: Symphony No.1', 232);
INSERT INTO albums (id, title, artist_id) VALUES (299, N'Scheherazade', 233);
INSERT INTO albums (id, title, artist_id) VALUES (300, N'Bach: The Brandenburg Concertos', 234);
INSERT INTO albums (id, title, artist_id) VALUES (301, N'Chopin: Piano Concertos Nos. 1 & 2', 235);
INSERT INTO albums (id, title, artist_id) VALUES (302, N'Mascagni: Cavalleria Rusticana', 236);
INSERT INTO albums (id, title, artist_id) VALUES (303, N'Sibelius: Finlandia', 237);
INSERT INTO albums (id, title, artist_id) VALUES (304, N'Beethoven Piano Sonatas: Moonlight & Pastorale', 238);
INSERT INTO albums (id, title, artist_id) VALUES (305, N'Great Recordings of the Century - Mahler: Das Lied von der Erde', 240);
INSERT INTO albums (id, title, artist_id) VALUES (306, N'Elgar: Cello Concerto & Vaughan Williams: Fantasias', 241);
INSERT INTO albums (id, title, artist_id) VALUES (307, N'Adams, John: The Chairman Dances', 242);
INSERT INTO albums (id, title, artist_id) VALUES (308, N'Tchaikovsky: 1812 Festival Overture, Op.49, Capriccio Italien & Beethoven: Wellington''s Victory', 243);
INSERT INTO albums (id, title, artist_id) VALUES (309, N'Palestrina: Missa Papae Marcelli & Allegri: Miserere', 244);
INSERT INTO albums (id, title, artist_id) VALUES (310, N'Prokofiev: Romeo & Juliet', 245);
INSERT INTO albums (id, title, artist_id) VALUES (311, N'Strauss: Waltzes', 226);
INSERT INTO albums (id, title, artist_id) VALUES (312, N'Berlioz: Symphonie Fantastique', 245);
INSERT INTO albums (id, title, artist_id) VALUES (313, N'Bizet: Carmen Highlights', 246);
INSERT INTO albums (id, title, artist_id) VALUES (314, N'English Renaissance', 247);
INSERT INTO albums (id, title, artist_id) VALUES (315, N'Handel: Music for the Royal Fireworks (Original Version 1749)', 208);
INSERT INTO albums (id, title, artist_id) VALUES (316, N'Grieg: Peer Gynt Suites & Sibelius: Pelléas et Mélisande', 248);
INSERT INTO albums (id, title, artist_id) VALUES (317, N'Mozart Gala: Famous Arias', 249);
INSERT INTO albums (id, title, artist_id) VALUES (318, N'SCRIABIN: Vers la flamme', 250);
INSERT INTO albums (id, title, artist_id) VALUES (319, N'Armada: Music from the Courts of England and Spain', 251);
INSERT INTO albums (id, title, artist_id) VALUES (320, N'Mozart: Symphonies Nos. 40 & 41', 248);
INSERT INTO albums (id, title, artist_id) VALUES (321, N'Back to Black', 252);
INSERT INTO albums (id, title, artist_id) VALUES (322, N'Frank', 252);
INSERT INTO albums (id, title, artist_id) VALUES (323, N'Carried to Dust (Bonus Track Version)', 253);
INSERT INTO albums (id, title, artist_id) VALUES (324, N'Beethoven: Symphony No. 6 ''Pastoral'' Etc.', 254);
INSERT INTO albums (id, title, artist_id) VALUES (325, N'Bartok: Violin & Viola Concertos', 255);
INSERT INTO albums (id, title, artist_id) VALUES (326, N'Mendelssohn: A Midsummer Night''s Dream', 256);
INSERT INTO albums (id, title, artist_id) VALUES (327, N'Bach: Orchestral Suites Nos. 1 - 4', 257);
INSERT INTO albums (id, title, artist_id) VALUES (328, N'Charpentier: Divertissements, Airs & Concerts', 258);
INSERT INTO albums (id, title, artist_id) VALUES (329, N'South American Getaway', 259);
INSERT INTO albums (id, title, artist_id) VALUES (330, N'Górecki: Symphony No. 3', 260);
INSERT INTO albums (id, title, artist_id) VALUES (331, N'Purcell: The Fairy Queen', 261);
INSERT INTO albums (id, title, artist_id) VALUES (332, N'The Ultimate Relexation albums', 262);
INSERT INTO albums (id, title, artist_id) VALUES (333, N'Purcell: Music for the Queen Mary', 263);
INSERT INTO albums (id, title, artist_id) VALUES (334, N'Weill: The Seven Deadly Sins', 264);
INSERT INTO albums (id, title, artist_id) VALUES (335, N'J.S. Bach: Chaconne, Suite in E Minor, Partita in E Major & Prelude, Fugue and Allegro', 265);
INSERT INTO albums (id, title, artist_id) VALUES (336, N'Prokofiev: Symphony No.5 & Stravinksy: Le Sacre Du Printemps', 248);
INSERT INTO albums (id, title, artist_id) VALUES (337, N'Szymanowski: Piano Works, Vol. 1', 266);
INSERT INTO albums (id, title, artist_id) VALUES (338, N'Nielsen: The Six Symphonies', 267);
INSERT INTO albums (id, title, artist_id) VALUES (339, N'Great Recordings of the Century: Paganini''s 24 Caprices', 268);
INSERT INTO albums (id, title, artist_id) VALUES (340, N'Liszt - 12 Études D''Execution Transcendante', 269);
INSERT INTO albums (id, title, artist_id) VALUES (341, N'Great Recordings of the Century - Shubert: Schwanengesang, 4 Lieder', 270);
INSERT INTO albums (id, title, artist_id) VALUES (342, N'Locatelli: Concertos for Violin, Strings and Continuo, Vol. 3', 271);
INSERT INTO albums (id, title, artist_id) VALUES (343, N'Respighi:Pines of Rome', 226);
INSERT INTO albums (id, title, artist_id) VALUES (344, N'Schubert: The Late String Quartets & String Quintet (3 CD''s)', 272);
INSERT INTO albums (id, title, artist_id) VALUES (345, N'Monteverdi: L''Orfeo', 273);
INSERT INTO albums (id, title, artist_id) VALUES (346, N'Mozart: Chamber Music', 274);
INSERT INTO albums (id, title, artist_id) VALUES (347, N'Koyaanisqatsi (Soundtrack from the Motion Picture)', 275);

INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1, N'For Those About To Rock (We Salute You)', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 343719, 11170334, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2, N'Balls to the Wall', 2, 2, 1, 342562, 5510424, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3, N'Fast As a Shark', 3, 2, 1, N'F. Baltes, S. Kaufman, U. Dirkscneider & W. Hoffman', 230619, 3990994, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (4, N'Restless and Wild', 3, 2, 1, N'F. Baltes, R.A. Smith-Diesel, S. Kaufman, U. Dirkscneider & W. Hoffman', 252051, 4331779, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (5, N'Princess of the Dawn', 3, 2, 1, N'Deaffy & R.A. Smith-Diesel', 375418, 6290521, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (6, N'Put The Finger On You', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 205662, 6713451, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (7, N'Let''s Get It Up', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 233926, 7636561, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (8, N'Inject The Venom', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 210834, 6852860, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (9, N'Snowballed', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 203102, 6599424, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (10, N'Evil Walks', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 263497, 8611245, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (11, N'C.O.D.', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 199836, 6566314, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (12, N'Breaking The Rules', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 263288, 8596840, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (13, N'Night Of The Long Knives', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 205688, 6706347, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (14, N'Spellbound', 1, 1, 1, N'Angus Young, Malcolm Young, Brian Johnson', 270863, 8817038, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (15, N'Go Down', 4, 1, 1, N'AC/DC', 331180, 10847611, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (16, N'Dog Eat Dog', 4, 1, 1, N'AC/DC', 215196, 7032162, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (17, N'Let There Be Rock', 4, 1, 1, N'AC/DC', 366654, 12021261, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (18, N'Bad Boy Boogie', 4, 1, 1, N'AC/DC', 267728, 8776140, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (19, N'Problem Child', 4, 1, 1, N'AC/DC', 325041, 10617116, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (20, N'Overdose', 4, 1, 1, N'AC/DC', 369319, 12066294, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (21, N'Hell Ain''t A Bad Place To Be', 4, 1, 1, N'AC/DC', 254380, 8331286, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (22, N'Whole Lotta Rosie', 4, 1, 1, N'AC/DC', 323761, 10547154, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (23, N'Walk On Water', 5, 1, 1, N'Steven Tyler, Joe Perry, Jack Blades, Tommy Shaw', 295680, 9719579, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (24, N'Love In An Elevator', 5, 1, 1, N'Steven Tyler, Joe Perry', 321828, 10552051, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (25, N'Rag Doll', 5, 1, 1, N'Steven Tyler, Joe Perry, Jim Vallance, Holly Knight', 264698, 8675345, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (26, N'What It Takes', 5, 1, 1, N'Steven Tyler, Joe Perry, Desmond Child', 310622, 10144730, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (27, N'Dude (Looks Like A Lady)', 5, 1, 1, N'Steven Tyler, Joe Perry, Desmond Child', 264855, 8679940, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (28, N'Janie''s Got A Gun', 5, 1, 1, N'Steven Tyler, Tom Hamilton', 330736, 10869391, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (29, N'Cryin''', 5, 1, 1, N'Steven Tyler, Joe Perry, Taylor Rhodes', 309263, 10056995, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (30, N'Amazing', 5, 1, 1, N'Steven Tyler, Richie Supa', 356519, 11616195, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (31, N'Blind Man', 5, 1, 1, N'Steven Tyler, Joe Perry, Taylor Rhodes', 240718, 7877453, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (32, N'Deuces Are Wild', 5, 1, 1, N'Steven Tyler, Jim Vallance', 215875, 7074167, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (33, N'The Other Side', 5, 1, 1, N'Steven Tyler, Jim Vallance', 244375, 7983270, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (34, N'Crazy', 5, 1, 1, N'Steven Tyler, Joe Perry, Desmond Child', 316656, 10402398, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (35, N'Eat The Rich', 5, 1, 1, N'Steven Tyler, Joe Perry, Jim Vallance', 251036, 8262039, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (36, N'Angel', 5, 1, 1, N'Steven Tyler, Desmond Child', 307617, 9989331, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (37, N'Livin'' On The Edge', 5, 1, 1, N'Steven Tyler, Joe Perry, Mark Hudson', 381231, 12374569, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (38, N'All I Really Want', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 284891, 9375567, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (39, N'You Oughta Know', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 249234, 8196916, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (40, N'Perfect', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 188133, 6145404, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (41, N'Hand In My Pocket', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 221570, 7224246, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (42, N'Right Through You', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 176117, 5793082, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (43, N'Forgiven', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 300355, 9753256, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (44, N'You Learn', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 239699, 7824837, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (45, N'Head Over Feet', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 267493, 8758008, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (46, N'Mary Jane', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 280607, 9163588, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (47, N'Ironic', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 229825, 7598866, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (48, N'Not The Doctor', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 227631, 7604601, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (49, N'Wake Up', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 293485, 9703359, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (50, N'You Oughta Know (Alternate)', 6, 1, 1, N'Alanis Morissette & Glenn Ballard', 491885, 16008629, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (51, N'We Die Young', 7, 1, 1, N'Jerry Cantrell', 152084, 4925362, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (52, N'Man In The Box', 7, 1, 1, N'Jerry Cantrell, Layne Staley', 286641, 9310272, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (53, N'Sea Of Sorrow', 7, 1, 1, N'Jerry Cantrell', 349831, 11316328, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (54, N'Bleed The Freak', 7, 1, 1, N'Jerry Cantrell', 241946, 7847716, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (55, N'I Can''t Remember', 7, 1, 1, N'Jerry Cantrell, Layne Staley', 222955, 7302550, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (56, N'Love, Hate, Love', 7, 1, 1, N'Jerry Cantrell, Layne Staley', 387134, 12575396, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (57, N'It Ain''t Like That', 7, 1, 1, N'Jerry Cantrell, Michael Starr, Sean Kinney', 277577, 8993793, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (58, N'Sunshine', 7, 1, 1, N'Jerry Cantrell', 284969, 9216057, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (59, N'Put You Down', 7, 1, 1, N'Jerry Cantrell', 196231, 6420530, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (60, N'Confusion', 7, 1, 1, N'Jerry Cantrell, Michael Starr, Layne Staley', 344163, 11183647, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (61, N'I Know Somethin (Bout You)', 7, 1, 1, N'Jerry Cantrell', 261955, 8497788, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (62, N'Real Thing', 7, 1, 1, N'Jerry Cantrell, Layne Staley', 243879, 7937731, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (63, N'Desafinado', 8, 1, 2, 185338, 5990473, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (64, N'Garota De Ipanema', 8, 1, 2, 285048, 9348428, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (65, N'Samba De Uma Nota Só (One Note Samba)', 8, 1, 2, 137273, 4535401, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (66, N'Por Causa De Você', 8, 1, 2, 169900, 5536496, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (67, N'Ligia', 8, 1, 2, 251977, 8226934, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (68, N'Fotografia', 8, 1, 2, 129227, 4198774, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (69, N'Dindi (Dindi)', 8, 1, 2, 253178, 8149148, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (70, N'Se Todos Fossem Iguais A Você (Instrumental)', 8, 1, 2, 134948, 4393377, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (71, N'Falando De Amor', 8, 1, 2, 219663, 7121735, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (72, N'Angela', 8, 1, 2, 169508, 5574957, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (73, N'Corcovado (Quiet Nights Of Quiet Stars)', 8, 1, 2, 205662, 6687994, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (74, N'Outra Vez', 8, 1, 2, 126511, 4110053, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (75, N'O Boto (Bôto)', 8, 1, 2, 366837, 12089673, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (76, N'Canta, Canta Mais', 8, 1, 2, 271856, 8719426, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (77, N'Enter Sandman', 9, 1, 3, N'Apocalyptica', 221701, 7286305, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (78, N'Master Of Puppets', 9, 1, 3, N'Apocalyptica', 436453, 14375310, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (79, N'Harvester Of Sorrow', 9, 1, 3, N'Apocalyptica', 374543, 12372536, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (80, N'The Unforgiven', 9, 1, 3, N'Apocalyptica', 322925, 10422447, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (81, N'Sad But True', 9, 1, 3, N'Apocalyptica', 288208, 9405526, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (82, N'Creeping Death', 9, 1, 3, N'Apocalyptica', 308035, 10110980, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (83, N'Wherever I May Roam', 9, 1, 3, N'Apocalyptica', 369345, 12033110, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (84, N'Welcome Home (Sanitarium)', 9, 1, 3, N'Apocalyptica', 350197, 11406431, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (85, N'Cochise', 10, 1, 1, N'Audioslave/Chris Cornell', 222380, 5339931, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (86, N'Show Me How to Live', 10, 1, 1, N'Audioslave/Chris Cornell', 277890, 6672176, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (87, N'Gasoline', 10, 1, 1, N'Audioslave/Chris Cornell', 279457, 6709793, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (88, N'What You Are', 10, 1, 1, N'Audioslave/Chris Cornell', 249391, 5988186, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (89, N'Like a Stone', 10, 1, 1, N'Audioslave/Chris Cornell', 294034, 7059624, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (90, N'Set It Off', 10, 1, 1, N'Audioslave/Chris Cornell', 263262, 6321091, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (91, N'Shadow on the Sun', 10, 1, 1, N'Audioslave/Chris Cornell', 343457, 8245793, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (92, N'I am the Highway', 10, 1, 1, N'Audioslave/Chris Cornell', 334942, 8041411, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (93, N'Exploder', 10, 1, 1, N'Audioslave/Chris Cornell', 206053, 4948095, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (94, N'Hypnotize', 10, 1, 1, N'Audioslave/Chris Cornell', 206628, 4961887, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (95, N'Bring''em Back Alive', 10, 1, 1, N'Audioslave/Chris Cornell', 329534, 7911634, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (96, N'Light My Way', 10, 1, 1, N'Audioslave/Chris Cornell', 303595, 7289084, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (97, N'Getaway Car', 10, 1, 1, N'Audioslave/Chris Cornell', 299598, 7193162, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (98, N'The Last Remaining Light', 10, 1, 1, N'Audioslave/Chris Cornell', 317492, 7622615, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (99, N'Your Time Has Come', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 255529, 8273592, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (100, N'Out Of Exile', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 291291, 9506571, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (101, N'Be Yourself', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 279484, 9106160, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (102, N'Doesn''t Remind Me', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 255869, 8357387, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (103, N'Drown Me Slowly', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 233691, 7609178, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (104, N'Heaven''s Dead', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 276688, 9006158, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (105, N'The Worm', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 237714, 7710800, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (106, N'Man Or Animal', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 233195, 7542942, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (107, N'Yesterday To Tomorrow', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 273763, 8944205, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (108, N'Dandelion', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 278125, 9003592, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (109, N'#1 Zero', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 299102, 9731988, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (110, N'The Curse', 11, 1, 4, N'Cornell, Commerford, Morello, Wilk', 309786, 10029406, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (111, N'Money', 12, 1, 5, N'Berry Gordy, Jr./Janie Bradford', 147591, 2365897, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (112, N'Long Tall Sally', 12, 1, 5, N'Enotris Johnson/Little Richard/Robert "Bumps" Blackwell', 106396, 1707084, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (113, N'Bad Boy', 12, 1, 5, N'Larry Williams', 116088, 1862126, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (114, N'Twist And Shout', 12, 1, 5, N'Bert Russell/Phil Medley', 161123, 2582553, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (115, N'Please Mr. Postman', 12, 1, 5, N'Brian Holland/Freddie Gorman/Georgia Dobbins/Robert Bateman/William Garrett', 137639, 2206986, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (116, N'C''Mon Everybody', 12, 1, 5, N'Eddie Cochran/Jerry Capehart', 140199, 2247846, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (117, N'Rock ''N'' Roll Music', 12, 1, 5, N'Chuck Berry', 141923, 2276788, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (118, N'Slow Down', 12, 1, 5, N'Larry Williams', 163265, 2616981, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (119, N'Roadrunner', 12, 1, 5, N'Bo Diddley', 143595, 2301989, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (120, N'Carol', 12, 1, 5, N'Chuck Berry', 143830, 2306019, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (121, N'Good Golly Miss Molly', 12, 1, 5, N'Little Richard', 106266, 1704918, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (122, N'20 Flight Rock', 12, 1, 5, N'Ned Fairchild', 107807, 1299960, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (123, N'Quadrant', 13, 1, 2, N'Billy Cobham', 261851, 8538199, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (124, N'Snoopy''s search-Red baron', 13, 1, 2, N'Billy Cobham', 456071, 15075616, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (125, N'Spanish moss-"A sound portrait"-Spanish moss', 13, 1, 2, N'Billy Cobham', 248084, 8217867, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (126, N'Moon germs', 13, 1, 2, N'Billy Cobham', 294060, 9714812, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (127, N'Stratus', 13, 1, 2, N'Billy Cobham', 582086, 19115680, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (128, N'The pleasant pheasant', 13, 1, 2, N'Billy Cobham', 318066, 10630578, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (129, N'Solo-Panhandler', 13, 1, 2, N'Billy Cobham', 246151, 8230661, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (130, N'Do what cha wanna', 13, 1, 2, N'George Duke', 274155, 9018565, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (131, N'Intro/ Low Down', 14, 1, 3, 323683, 10642901, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (132, N'13 Years Of Grief', 14, 1, 3, 246987, 8137421, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (133, N'Stronger Than Death', 14, 1, 3, 300747, 9869647, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (134, N'All For You', 14, 1, 3, 235833, 7726948, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (135, N'Super Terrorizer', 14, 1, 3, 319373, 10513905, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (136, N'Phoney Smile Fake Hellos', 14, 1, 3, 273606, 9011701, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (137, N'Lost My Better Half', 14, 1, 3, 284081, 9355309, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (138, N'Bored To Tears', 14, 1, 3, 247327, 8130090, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (139, N'A.N.D.R.O.T.A.Z.', 14, 1, 3, 266266, 8574746, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (140, N'Born To Booze', 14, 1, 3, 282122, 9257358, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (141, N'World Of Trouble', 14, 1, 3, 359157, 11820932, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (142, N'No More Tears', 14, 1, 3, 555075, 18041629, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (143, N'The Begining... At Last', 14, 1, 3, 365662, 11965109, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (144, N'Heart Of Gold', 15, 1, 3, 194873, 6417460, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (145, N'Snowblind', 15, 1, 3, 420022, 13842549, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (146, N'Like A Bird', 15, 1, 3, 276532, 9115657, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (147, N'Blood In The Wall', 15, 1, 3, 284368, 9359475, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (148, N'The Beginning...At Last', 15, 1, 3, 271960, 8975814, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (149, N'Black Sabbath', 16, 1, 3, 382066, 12440200, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (150, N'The Wizard', 16, 1, 3, 264829, 8646737, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (151, N'Behind The Wall Of Sleep', 16, 1, 3, 217573, 7169049, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (152, N'N.I.B.', 16, 1, 3, 368770, 12029390, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (153, N'Evil Woman', 16, 1, 3, 204930, 6655170, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (154, N'Sleeping Village', 16, 1, 3, 644571, 21128525, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (155, N'Warning', 16, 1, 3, 212062, 6893363, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (156, N'Wheels Of Confusion / The Straightener', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 494524, 16065830, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (157, N'Tomorrow''s Dream', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 192496, 6252071, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (158, N'Changes', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 286275, 9175517, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (159, N'FX', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 103157, 3331776, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (160, N'Supernaut', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 285779, 9245971, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (161, N'Snowblind', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 331676, 10813386, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (162, N'Cornucopia', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 234814, 7653880, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (163, N'Laguna Sunrise', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 173087, 5671374, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (164, N'St. Vitus Dance', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 149655, 4884969, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (165, N'Under The Sun/Every Day Comes and Goes', 17, 1, 3, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 350458, 11360486, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (166, N'Smoked Pork', 18, 1, 4, 47333, 1549074, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (167, N'Body Count''s In The House', 18, 1, 4, 204251, 6715413, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (168, N'Now Sports', 18, 1, 4, 4884, 161266, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (169, N'Body Count', 18, 1, 4, 317936, 10489139, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (170, N'A Statistic', 18, 1, 4, 6373, 211997, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (171, N'Bowels Of The Devil', 18, 1, 4, 223216, 7324125, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (172, N'The Real Problem', 18, 1, 4, 11650, 387360, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (173, N'KKK Bitch', 18, 1, 4, 173008, 5709631, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (174, N'D Note', 18, 1, 4, 95738, 3067064, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (175, N'Voodoo', 18, 1, 4, 300721, 9875962, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (176, N'The Winner Loses', 18, 1, 4, 392254, 12843821, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (177, N'There Goes The Neighborhood', 18, 1, 4, 350171, 11443471, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (178, N'Oprah', 18, 1, 4, 6635, 224313, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (179, N'Evil Dick', 18, 1, 4, 239020, 7828873, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (180, N'Body Count Anthem', 18, 1, 4, 166426, 5463690, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (181, N'Momma''s Gotta Die Tonight', 18, 1, 4, 371539, 12122946, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (182, N'Freedom Of Speech', 18, 1, 4, 281234, 9337917, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (183, N'King In Crimson', 19, 1, 3, N'Roy Z', 283167, 9218499, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (184, N'Chemical Wedding', 19, 1, 3, N'Roy Z', 246177, 8022764, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (185, N'The Tower', 19, 1, 3, N'Roy Z', 285257, 9435693, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (186, N'Killing Floor', 19, 1, 3, N'Adrian Smith', 269557, 8854240, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (187, N'Book Of Thel', 19, 1, 3, N'Eddie Casillas/Roy Z', 494393, 16034404, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (188, N'Gates Of Urizen', 19, 1, 3, N'Roy Z', 265351, 8627004, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (189, N'Jerusalem', 19, 1, 3, N'Roy Z', 402390, 13194463, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (190, N'Trupets Of Jericho', 19, 1, 3, N'Roy Z', 359131, 11820908, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (191, N'Machine Men', 19, 1, 3, N'Adrian Smith', 341655, 11138147, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (192, N'The Alchemist', 19, 1, 3, N'Roy Z', 509413, 16545657, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (193, N'Realword', 19, 1, 3, N'Roy Z', 237531, 7802095, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (194, N'First Time I Met The Blues', 20, 1, 6, N'Eurreal Montgomery', 140434, 4604995, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (195, N'Let Me Love You Baby', 20, 1, 6, N'Willie Dixon', 175386, 5716994, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (196, N'Stone Crazy', 20, 1, 6, N'Buddy Guy', 433397, 14184984, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (197, N'Pretty Baby', 20, 1, 6, N'Willie Dixon', 237662, 7848282, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (198, N'When My Left Eye Jumps', 20, 1, 6, N'Al Perkins/Willie Dixon', 235311, 7685363, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (199, N'Leave My Girl Alone', 20, 1, 6, N'Buddy Guy', 204721, 6859518, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (200, N'She Suits Me To A Tee', 20, 1, 6, N'Buddy Guy', 136803, 4456321, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (201, N'Keep It To Myself (Aka Keep It To Yourself)', 20, 1, 6, N'Sonny Boy Williamson [I]', 166060, 5487056, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (202, N'My Time After Awhile', 20, 1, 6, N'Robert Geddins/Ron Badger/Sheldon Feinberg', 182491, 6022698, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (203, N'Too Many Ways (Alternate)', 20, 1, 6, N'Willie Dixon', 135053, 4459946, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (204, N'Talkin'' ''Bout Women Obviously', 20, 1, 6, N'Amos Blakemore/Buddy Guy', 589531, 19161377, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (205, N'Jorge Da Capadócia', 21, 1, 7, N'Jorge Ben', 177397, 5842196, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (206, N'Prenda Minha', 21, 1, 7, N'Tradicional', 99369, 3225364, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (207, N'Meditação', 21, 1, 7, N'Tom Jobim - Newton Mendoça', 148793, 4865597, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (208, N'Terra', 21, 1, 7, N'Caetano Veloso', 482429, 15889054, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (209, N'Eclipse Oculto', 21, 1, 7, N'Caetano Veloso', 221936, 7382703, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (210, N'Texto "Verdade Tropical"', 21, 1, 7, N'Caetano Veloso', 84088, 2752161, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (211, N'Bem Devagar', 21, 1, 7, N'Gilberto Gil', 133172, 4333651, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (212, N'Drão', 21, 1, 7, N'Gilberto Gil', 156264, 5065932, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (213, N'Saudosismo', 21, 1, 7, N'Caetano Veloso', 144326, 4726981, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (214, N'Carolina', 21, 1, 7, N'Chico Buarque', 181812, 5924159, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (215, N'Sozinho', 21, 1, 7, N'Peninha', 190589, 6253200, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (216, N'Esse Cara', 21, 1, 7, N'Caetano Veloso', 223111, 7217126, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (217, N'Mel', 21, 1, 7, N'Caetano Veloso - Waly Salomão', 294765, 9854062, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (218, N'Linha Do Equador', 21, 1, 7, N'Caetano Veloso - Djavan', 299337, 10003747, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (219, N'Odara', 21, 1, 7, N'Caetano Veloso', 141270, 4704104, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (220, N'A Luz De Tieta', 21, 1, 7, N'Caetano Veloso', 251742, 8507446, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (221, N'Atrás Da Verd-E-Rosa Só Não Vai Quem Já Morreu', 21, 1, 7, N'David Corrêa - Paulinho Carvalho - Carlos Sena - Bira do Ponto', 307252, 10364247, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (222, N'Vida Boa', 21, 1, 7, N'Fausto Nilo - Armandinho', 281730, 9411272, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (223, N'Sozinho (Hitmakers Classic Mix)', 22, 1, 7, 436636, 14462072, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (224, N'Sozinho (Hitmakers Classic Radio Edit)', 22, 1, 7, 195004, 6455134, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (225, N'Sozinho (Caêdrum ''n'' Bass)', 22, 1, 7, 328071, 10975007, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (226, N'Carolina', 23, 1, 7, 163056, 5375395, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (227, N'Essa Moça Ta Diferente', 23, 1, 7, 167235, 5568574, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (228, N'Vai Passar', 23, 1, 7, 369763, 12359161, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (229, N'Samba De Orly', 23, 1, 7, 162429, 5431854, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (230, N'Bye, Bye Brasil', 23, 1, 7, 283402, 9499590, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (231, N'Atras Da Porta', 23, 1, 7, 189675, 6132843, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (232, N'Tatuagem', 23, 1, 7, 172120, 5645703, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (233, N'O Que Será (À Flor Da Terra)', 23, 1, 7, 167288, 5574848, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (234, N'Morena De Angola', 23, 1, 7, 186801, 6373932, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (235, N'Apesar De Você', 23, 1, 7, 234501, 7886937, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (236, N'A Banda', 23, 1, 7, 132493, 4349539, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (237, N'Minha Historia', 23, 1, 7, 182256, 6029673, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (238, N'Com Açúcar E Com Afeto', 23, 1, 7, 175386, 5846442, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (239, N'Brejo Da Cruz', 23, 1, 7, 214099, 7270749, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (240, N'Meu Caro Amigo', 23, 1, 7, 260257, 8778172, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (241, N'Geni E O Zepelim', 23, 1, 7, 317570, 10342226, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (242, N'Trocando Em Miúdos', 23, 1, 7, 169717, 5461468, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (243, N'Vai Trabalhar Vagabundo', 23, 1, 7, 139154, 4693941, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (244, N'Gota D''água', 23, 1, 7, 153208, 5074189, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (245, N'Construção / Deus Lhe Pague', 23, 1, 7, 383059, 12675305, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (246, N'Mateus Enter', 24, 1, 7, N'Chico Science', 33149, 1103013, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (247, N'O Cidadão Do Mundo', 24, 1, 7, N'Chico Science', 200933, 6724966, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (248, N'Etnia', 24, 1, 7, N'Chico Science', 152555, 5061413, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (249, N'Quilombo Groove [Instrumental]', 24, 1, 7, N'Chico Science', 151823, 5042447, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (250, N'Macô', 24, 1, 7, N'Chico Science', 249600, 8253934, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (251, N'Um Passeio No Mundo Livre', 24, 1, 7, N'Chico Science', 240091, 7984291, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (252, N'Samba Do Lado', 24, 1, 7, N'Chico Science', 227317, 7541688, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (253, N'Maracatu Atômico', 24, 1, 7, N'Chico Science', 284264, 9670057, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (254, N'O Encontro De Isaac Asimov Com Santos Dumont No Céu', 24, 1, 7, N'Chico Science', 99108, 3240816, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (255, N'Corpo De Lama', 24, 1, 7, N'Chico Science', 232672, 7714954, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (256, N'Sobremesa', 24, 1, 7, N'Chico Science', 240091, 7960868, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (257, N'Manguetown', 24, 1, 7, N'Chico Science', 194560, 6475159, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (258, N'Um Satélite Na Cabeça', 24, 1, 7, N'Chico Science', 126615, 4272821, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (259, N'Baião Ambiental [Instrumental]', 24, 1, 7, N'Chico Science', 152659, 5198539, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (260, N'Sangue De Bairro', 24, 1, 7, N'Chico Science', 132231, 4415557, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (261, N'Enquanto O Mundo Explode', 24, 1, 7, N'Chico Science', 88764, 2968650, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (262, N'Interlude Zumbi', 24, 1, 7, N'Chico Science', 71627, 2408550, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (263, N'Criança De Domingo', 24, 1, 7, N'Chico Science', 208222, 6984813, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (264, N'Amor De Muito', 24, 1, 7, N'Chico Science', 175333, 5881293, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (265, N'Samidarish [Instrumental]', 24, 1, 7, N'Chico Science', 272431, 8911641, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (266, N'Maracatu Atômico [Atomic Version]', 24, 1, 7, N'Chico Science', 273084, 9019677, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (267, N'Maracatu Atômico [Ragga Mix]', 24, 1, 7, N'Chico Science', 210155, 6986421, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (268, N'Maracatu Atômico [Trip Hop]', 24, 1, 7, N'Chico Science', 221492, 7380787, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (269, N'Banditismo Por Uma Questa', 25, 1, 7, 307095, 10251097, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (270, N'Banditismo Por Uma Questa', 25, 1, 7, 243644, 8147224, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (271, N'Rios Pontes & Overdrives', 25, 1, 7, 286720, 9659152, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (272, N'Cidade', 25, 1, 7, 216346, 7241817, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (273, N'Praiera', 25, 1, 7, 183640, 6172781, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (274, N'Samba Makossa', 25, 1, 7, 271856, 9095410, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (275, N'Da Lama Ao Caos', 25, 1, 7, 251559, 8378065, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (276, N'Maracatu De Tiro Certeiro', 25, 1, 7, 88868, 2901397, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (277, N'Salustiano Song', 25, 1, 7, 215405, 7183969, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (278, N'Antene Se', 25, 1, 7, 248372, 8253618, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (279, N'Risoflora', 25, 1, 7, 105586, 3536938, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (280, N'Lixo Do Mangue', 25, 1, 7, 193253, 6534200, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (281, N'Computadores Fazem Arte', 25, 1, 7, 404323, 13702771, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (282, N'Girassol', 26, 1, 8, N'Bino Farias/Da Gama/Lazão/Pedro Luis/Toni Garrido', 249808, 8327676, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (283, N'A Sombra Da Maldade', 26, 1, 8, N'Da Gama/Toni Garrido', 230922, 7697230, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (284, N'Johnny B. Goode', 26, 1, 8, N'Chuck Berry', 254615, 8505985, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (285, N'Soldado Da Paz', 26, 1, 8, N'Herbert Vianna', 194220, 6455080, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (286, N'Firmamento', 26, 1, 8, N'Bino Farias/Da Gama/Henry Lawes/Lazão/Toni Garrido/Winston Foser-Vers', 222145, 7402658, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (287, N'Extra', 26, 1, 8, N'Gilberto Gil', 304352, 10078050, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (288, N'O Erê', 26, 1, 8, N'Bernardo Vilhena/Bino Farias/Da Gama/Lazão/Toni Garrido', 236382, 7866924, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (289, N'Podes Crer', 26, 1, 8, N'Bino Farias/Da Gama/Lazão/Toni Garrido', 232280, 7747747, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (290, N'A Estrada', 26, 1, 8, N'Bino Farias/Da Gama/Lazão/Toni Garrido', 248842, 8275673, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (291, N'Berlim', 26, 1, 8, N'Da Gama/Toni Garrido', 207542, 6920424, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (292, N'Já Foi', 26, 1, 8, N'Bino Farias/Da Gama/Lazão/Toni Garrido', 221544, 7388466, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (293, N'Onde Você Mora?', 26, 1, 8, N'Marisa Monte/Nando Reis', 256026, 8502588, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (294, N'Pensamento', 26, 1, 8, N'Bino Farias/Da Gamma/Lazão/Rás Bernard', 173008, 5748424, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (295, N'Conciliação', 26, 1, 8, N'Da Gama/Lazão/Rás Bernardo', 257619, 8552474, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (296, N'Realidade Virtual', 26, 1, 8, N'Bino Farias/Da Gama/Lazão/Toni Garrido', 195239, 6503533, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (297, N'Mensagem', 26, 1, 8, N'Bino Farias/Da Gama/Lazão/Rás Bernardo', 225332, 7488852, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (298, N'A Cor Do Sol', 26, 1, 8, N'Bernardo Vilhena/Da Gama/Lazão', 231392, 7663348, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (299, N'Onde Você Mora?', 27, 1, 8, N'Marisa Monte/Nando Reis', 298396, 10056970, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (300, N'O Erê', 27, 1, 8, N'Bernardo Vilhena/Bino/Da Gama/Lazao/Toni Garrido', 206942, 6950332, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (301, N'A Sombra Da Maldade', 27, 1, 8, N'Da Gama/Toni Garrido', 285231, 9544383, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (302, N'A Estrada', 27, 1, 8, N'Da Gama/Lazao/Toni Garrido', 282174, 9344477, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (303, N'Falar A Verdade', 27, 1, 8, N'Bino/Da Gama/Ras Bernardo', 244950, 8189093, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (304, N'Firmamento', 27, 1, 8, N'Harry Lawes/Winston Foster-Vers', 225488, 7507866, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (305, N'Pensamento', 27, 1, 8, N'Bino/Da Gama/Ras Bernardo', 192391, 6399761, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (306, N'Realidade Virtual', 27, 1, 8, N'Bino/Da Gamma/Lazao/Toni Garrido', 240300, 8069934, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (307, N'Doutor', 27, 1, 8, N'Bino/Da Gama/Toni Garrido', 178155, 5950952, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (308, N'Na Frente Da TV', 27, 1, 8, N'Bino/Da Gama/Lazao/Ras Bernardo', 289750, 9633659, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (309, N'Downtown', 27, 1, 8, N'Cidade Negra', 239725, 8024386, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (310, N'Sábado A Noite', 27, 1, 8, N'Lulu Santos', 267363, 8895073, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (311, N'A Cor Do Sol', 27, 1, 8, N'Bernardo Vilhena/Da Gama/Lazao', 273031, 9142937, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (312, N'Eu Também Quero Beijar', 27, 1, 8, N'Fausto Nilo/Moraes Moreira/Pepeu Gomes', 211147, 7029400, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (313, N'Noite Do Prazer', 28, 1, 7, 311353, 10309980, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (314, N'À Francesa', 28, 1, 7, 244532, 8150846, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (315, N'Cada Um Cada Um (A Namoradeira)', 28, 1, 7, 253492, 8441034, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (316, N'Linha Do Equador', 28, 1, 7, 244715, 8123466, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (317, N'Amor Demais', 28, 1, 7, 254040, 8420093, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (318, N'Férias', 28, 1, 7, 264202, 8731945, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (319, N'Gostava Tanto De Você', 28, 1, 7, 230452, 7685326, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (320, N'Flor Do Futuro', 28, 1, 7, 275748, 9205941, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (321, N'Felicidade Urgente', 28, 1, 7, 266605, 8873358, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (322, N'Livre Pra Viver', 28, 1, 7, 214595, 7111596, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (323, N'Dig-Dig, Lambe-Lambe (Ao Vivo)', 29, 1, 9, N'Cassiano Costa/Cintia Maviane/J.F./Lucas Costa', 205479, 6892516, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (324, N'Pererê', 29, 1, 9, N'Augusto Conceição/Chiclete Com Banana', 198661, 6643207, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (325, N'TriboTchan', 29, 1, 9, N'Cal Adan/Paulo Levi', 194194, 6507950, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (326, N'Tapa Aqui, Descobre Ali', 29, 1, 9, N'Paulo Levi/W. Rangel', 188630, 6327391, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (327, N'Daniela', 29, 1, 9, N'Jorge Cardoso/Pierre Onasis', 230791, 7748006, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (328, N'Bate Lata', 29, 1, 9, N'Fábio Nolasco/Gal Sales/Ivan Brasil', 206733, 7034985, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (329, N'Garotas do Brasil', 29, 1, 9, N'Garay, Ricardo Engels/Luca Predabom/Ludwig, Carlos Henrique/Maurício Vieira', 210155, 6973625, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (330, N'Levada do Amor (Ailoviu)', 29, 1, 9, N'Luiz Wanderley/Paulo Levi', 190093, 6457752, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (331, N'Lavadeira', 29, 1, 9, N'Do Vale, Valverde/Gal Oliveira/Luciano Pinto', 214256, 7254147, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (332, N'Reboladeira', 29, 1, 9, N'Cal Adan/Ferrugem/Julinho Carioca/Tríona Ní Dhomhnaill', 210599, 7027525, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (333, N'É que Nessa Encarnação Eu Nasci Manga', 29, 1, 9, N'Lucina/Luli', 196519, 6568081, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (334, N'Reggae Tchan', 29, 1, 9, N'Cal Adan/Del Rey, Tension/Edu Casanova', 206654, 6931328, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (335, N'My Love', 29, 1, 9, N'Jauperi/Zeu Góes', 203493, 6772813, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (336, N'Latinha de Cerveja', 29, 1, 9, N'Adriano Bernandes/Edmar Neves', 166687, 5532564, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (337, N'You Shook Me', 30, 1, 1, N'J B Lenoir/Willie Dixon', 315951, 10249958, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (338, N'I Can''t Quit You Baby', 30, 1, 1, N'Willie Dixon', 263836, 8581414, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (339, N'Communication Breakdown', 30, 1, 1, N'Jimmy Page/John Bonham/John Paul Jones', 192653, 6287257, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (340, N'Dazed and Confused', 30, 1, 1, N'Jimmy Page', 401920, 13035765, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (341, N'The Girl I Love She Got Long Black Wavy Hair', 30, 1, 1, N'Jimmy Page/John Bonham/John Estes/John Paul Jones/Robert Plant', 183327, 5995686, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (342, N'What is and Should Never Be', 30, 1, 1, N'Jimmy Page/Robert Plant', 260675, 8497116, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (343, N'Communication Breakdown(2)', 30, 1, 1, N'Jimmy Page/John Bonham/John Paul Jones', 161149, 5261022, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (344, N'Travelling Riverside Blues', 30, 1, 1, N'Jimmy Page/Robert Johnson/Robert Plant', 312032, 10232581, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (345, N'Whole Lotta Love', 30, 1, 1, N'Jimmy Page/John Bonham/John Paul Jones/Robert Plant/Willie Dixon', 373394, 12258175, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (346, N'Somethin'' Else', 30, 1, 1, N'Bob Cochran/Sharon Sheeley', 127869, 4165650, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (347, N'Communication Breakdown(3)', 30, 1, 1, N'Jimmy Page/John Bonham/John Paul Jones', 185260, 6041133, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (348, N'I Can''t Quit You Baby(2)', 30, 1, 1, N'Willie Dixon', 380551, 12377615, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (349, N'You Shook Me(2)', 30, 1, 1, N'J B Lenoir/Willie Dixon', 619467, 20138673, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (350, N'How Many More Times', 30, 1, 1, N'Chester Burnett/Jimmy Page/John Bonham/John Paul Jones/Robert Plant', 711836, 23092953, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (351, N'Debra Kadabra', 31, 1, 1, N'Frank Zappa', 234553, 7649679, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (352, N'Carolina Hard-Core Ecstasy', 31, 1, 1, N'Frank Zappa', 359680, 11731061, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (353, N'Sam With The Showing Scalp Flat Top', 31, 1, 1, N'Don Van Vliet', 171284, 5572993, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (354, N'Poofter''s Froth Wyoming Plans Ahead', 31, 1, 1, N'Frank Zappa', 183902, 6007019, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (355, N'200 Years Old', 31, 1, 1, N'Frank Zappa', 272561, 8912465, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (356, N'Cucamonga', 31, 1, 1, N'Frank Zappa', 144483, 4728586, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (357, N'Advance Romance', 31, 1, 1, N'Frank Zappa', 677694, 22080051, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (358, N'Man With The Woman Head', 31, 1, 1, N'Don Van Vliet', 88894, 2922044, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (359, N'Muffin Man', 31, 1, 1, N'Frank Zappa', 332878, 10891682, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (360, N'Vai-Vai 2001', 32, 1, 10, 276349, 9402241, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (361, N'X-9 2001', 32, 1, 10, 273920, 9310370, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (362, N'Gavioes 2001', 32, 1, 10, 282723, 9616640, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (363, N'Nene 2001', 32, 1, 10, 284969, 9694508, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (364, N'Rosas De Ouro 2001', 32, 1, 10, 284342, 9721084, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (365, N'Mocidade Alegre 2001', 32, 1, 10, 282488, 9599937, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (366, N'Camisa Verde 2001', 32, 1, 10, 283454, 9633755, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (367, N'Leandro De Itaquera 2001', 32, 1, 10, 274808, 9451845, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (368, N'Tucuruvi 2001', 32, 1, 10, 287921, 9883335, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (369, N'Aguia De Ouro 2001', 32, 1, 10, 284160, 9698729, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (370, N'Ipiranga 2001', 32, 1, 10, 248293, 8522591, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (371, N'Morro Da Casa Verde 2001', 32, 1, 10, 284708, 9718778, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (372, N'Perola Negra 2001', 32, 1, 10, 281626, 9619196, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (373, N'Sao Lucas 2001', 32, 1, 10, 296254, 10020122, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (374, N'Guanabara', 33, 1, 7, N'Marcos Valle', 247614, 8499591, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (375, N'Mas Que Nada', 33, 1, 7, N'Jorge Ben', 248398, 8255254, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (376, N'Vôo Sobre o Horizonte', 33, 1, 7, N'J.r.Bertami/Parana', 225097, 7528825, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (377, N'A Paz', 33, 1, 7, N'Donato/Gilberto Gil', 263183, 8619173, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (378, N'Wave (Vou te Contar)', 33, 1, 7, N'Antonio Carlos Jobim', 271647, 9057557, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (379, N'Água de Beber', 33, 1, 7, N'Antonio Carlos Jobim/Vinicius de Moraes', 146677, 4866476, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (380, N'Samba da Bençaco', 33, 1, 7, N'Baden Powell/Vinicius de Moraes', 282200, 9440676, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (381, N'Pode Parar', 33, 1, 7, N'Jorge Vercilo/Jota Maranhao', 179408, 6046678, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (382, N'Menino do Rio', 33, 1, 7, N'Caetano Veloso', 262713, 8737489, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (383, N'Ando Meio Desligado', 33, 1, 7, N'Caetano Veloso', 195813, 6547648, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (384, N'Mistério da Raça', 33, 1, 7, N'Luiz Melodia/Ricardo Augusto', 184320, 6191752, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (385, N'All Star', 33, 1, 7, N'Nando Reis', 176326, 5891697, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (386, N'Menina Bonita', 33, 1, 7, N'Alexandre Brazil/Pedro Luis/Rodrigo Cabelo', 237087, 7938246, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (387, N'Pescador de Ilusões', 33, 1, 7, N'Macelo Yuka/O Rappa', 245524, 8267067, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (388, N'À Vontade (Live Mix)', 33, 1, 7, N'Bombom/Ed Motta', 180636, 5972430, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (389, N'Maria Fumaça', 33, 1, 7, N'Luiz Carlos/Oberdan', 141008, 4743149, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (390, N'Sambassim (dj patife remix)', 33, 1, 7, N'Alba Carvalho/Fernando Porto', 213655, 7243166, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (391, N'Garota De Ipanema', 34, 1, 7, N'Vários', 279536, 9141343, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (392, N'Tim Tim Por Tim Tim', 34, 1, 7, N'Vários', 213237, 7143328, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (393, N'Tarde Em Itapoã', 34, 1, 7, N'Vários', 313704, 10344491, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (394, N'Tanto Tempo', 34, 1, 7, N'Vários', 170292, 5572240, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (395, N'Eu Vim Da Bahia - Live', 34, 1, 7, N'Vários', 157988, 5115428, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (396, N'Alô Alô Marciano', 34, 1, 7, N'Vários', 238106, 8013065, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (397, N'Linha Do Horizonte', 34, 1, 7, N'Vários', 279484, 9275929, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (398, N'Only A Dream In Rio', 34, 1, 7, N'Vários', 371356, 12192989, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (399, N'Abrir A Porta', 34, 1, 7, N'Vários', 271960, 8991141, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (400, N'Alice', 34, 1, 7, N'Vários', 165982, 5594341, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (401, N'Momentos Que Marcam', 34, 1, 7, N'Vários', 280137, 9313740, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (402, N'Um Jantar Pra Dois', 34, 1, 7, N'Vários', 237714, 7819755, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (403, N'Bumbo Da Mangueira', 34, 1, 7, N'Vários', 270158, 9073350, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (404, N'Mr Funk Samba', 34, 1, 7, N'Vários', 213890, 7102545, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (405, N'Santo Antonio', 34, 1, 7, N'Vários', 162716, 5492069, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (406, N'Por Você', 34, 1, 7, N'Vários', 205557, 6792493, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (407, N'Só Tinha De Ser Com Você', 34, 1, 7, N'Vários', 389642, 13085596, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (408, N'Free Speech For The Dumb', 35, 1, 3, N'Molaney/Morris/Roberts/Wainwright', 155428, 5076048, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (409, N'It''s Electric', 35, 1, 3, N'Harris/Tatler', 213995, 6978601, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (410, N'Sabbra Cadabra', 35, 1, 3, N'Black Sabbath', 380342, 12418147, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (411, N'Turn The Page', 35, 1, 3, N'Seger', 366524, 11946327, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (412, N'Die Die My Darling', 35, 1, 3, N'Danzig', 149315, 4867667, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (413, N'Loverman', 35, 1, 3, N'Cave', 472764, 15446975, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (414, N'Mercyful Fate', 35, 1, 3, N'Diamond/Shermann', 671712, 21942829, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (415, N'Astronomy', 35, 1, 3, N'A.Bouchard/J.Bouchard/S.Pearlman', 397531, 13065612, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (416, N'Whiskey In The Jar', 35, 1, 3, N'Traditional', 305005, 9943129, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (417, N'Tuesday''s Gone', 35, 1, 3, N'Collins/Van Zandt', 545750, 17900787, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (418, N'The More I See', 35, 1, 3, N'Molaney/Morris/Roberts/Wainwright', 287973, 9378873, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (419, N'A Kind Of Magic', 36, 1, 1, N'Roger Taylor', 262608, 8689618, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (420, N'Under Pressure', 36, 1, 1, N'Queen & David Bowie', 236617, 7739042, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (421, N'Radio GA GA', 36, 1, 1, N'Roger Taylor', 343745, 11358573, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (422, N'I Want It All', 36, 1, 1, N'Queen', 241684, 7876564, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (423, N'I Want To Break Free', 36, 1, 1, N'John Deacon', 259108, 8552861, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (424, N'Innuendo', 36, 1, 1, N'Queen', 387761, 12664591, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (425, N'It''s A Hard Life', 36, 1, 1, N'Freddie Mercury', 249417, 8112242, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (426, N'Breakthru', 36, 1, 1, N'Queen', 249234, 8150479, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (427, N'Who Wants To Live Forever', 36, 1, 1, N'Brian May', 297691, 9577577, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (428, N'Headlong', 36, 1, 1, N'Queen', 273057, 8921404, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (429, N'The Miracle', 36, 1, 1, N'Queen', 294974, 9671923, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (430, N'I''m Going Slightly Mad', 36, 1, 1, N'Queen', 248032, 8192339, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (431, N'The Invisible Man', 36, 1, 1, N'Queen', 238994, 7920353, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (432, N'Hammer To Fall', 36, 1, 1, N'Brian May', 220316, 7255404, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (433, N'Friends Will Be Friends', 36, 1, 1, N'Freddie Mercury & John Deacon', 248920, 8114582, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (434, N'The Show Must Go On', 36, 1, 1, N'Queen', 263784, 8526760, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (435, N'One Vision', 36, 1, 1, N'Queen', 242599, 7936928, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (436, N'Detroit Rock City', 37, 1, 1, N'Paul Stanley, B. Ezrin', 218880, 7146372, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (437, N'Black Diamond', 37, 1, 1, N'Paul Stanley', 314148, 10266007, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (438, N'Hard Luck Woman', 37, 1, 1, N'Paul Stanley', 216032, 7109267, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (439, N'Sure Know Something', 37, 1, 1, N'Paul Stanley, Vincent Poncia', 242468, 7939886, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (440, N'Love Gun', 37, 1, 1, N'Paul Stanley', 196257, 6424915, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (441, N'Deuce', 37, 1, 1, N'Gene Simmons', 185077, 6097210, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (442, N'Goin'' Blind', 37, 1, 1, N'Gene Simmons, S. Coronel', 216215, 7045314, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (443, N'Shock Me', 37, 1, 1, N'Ace Frehley', 227291, 7529336, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (444, N'Do You Love Me', 37, 1, 1, N'Paul Stanley, B. Ezrin, K. Fowley', 214987, 6976194, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (445, N'She', 37, 1, 1, N'Gene Simmons, S. Coronel', 248346, 8229734, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (446, N'I Was Made For Loving You', 37, 1, 1, N'Paul Stanley, Vincent Poncia, Desmond Child', 271360, 9018078, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (447, N'Shout It Out Loud', 37, 1, 1, N'Paul Stanley, Gene Simmons, B. Ezrin', 219742, 7194424, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (448, N'God Of Thunder', 37, 1, 1, N'Paul Stanley', 255791, 8309077, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (449, N'Calling Dr. Love', 37, 1, 1, N'Gene Simmons', 225332, 7395034, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (450, N'Beth', 37, 1, 1, N'S. Penridge, Bob Ezrin, Peter Criss', 166974, 5360574, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (451, N'Strutter', 37, 1, 1, N'Paul Stanley, Gene Simmons', 192496, 6317021, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (452, N'Rock And Roll All Nite', 37, 1, 1, N'Paul Stanley, Gene Simmons', 173609, 5735902, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (453, N'Cold Gin', 37, 1, 1, N'Ace Frehley', 262243, 8609783, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (454, N'Plaster Caster', 37, 1, 1, N'Gene Simmons', 207333, 6801116, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (455, N'God Gave Rock ''n'' Roll To You', 37, 1, 1, N'Paul Stanley, Gene Simmons, Rus Ballard, Bob Ezrin', 320444, 10441590, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (456, N'Heart of the Night', 38, 1, 2, 273737, 9098263, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (457, N'De La Luz', 38, 1, 2, 315219, 10518284, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (458, N'Westwood Moon', 38, 1, 2, 295627, 9765802, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (459, N'Midnight', 38, 1, 2, 266866, 8851060, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (460, N'Playtime', 38, 1, 2, 273580, 9070880, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (461, N'Surrender', 38, 1, 2, 287634, 9422926, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (462, N'Valentino''s', 38, 1, 2, 296124, 9848545, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (463, N'Believe', 38, 1, 2, 310778, 10317185, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (464, N'As We Sleep', 38, 1, 2, 316865, 10429398, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (465, N'When Evening Falls', 38, 1, 2, 298135, 9863942, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (466, N'J Squared', 38, 1, 2, 288757, 9480777, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (467, N'Best Thing', 38, 1, 2, 274259, 9069394, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (468, N'Maria', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 167262, 5484747, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (469, N'Poprocks And Coke', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 158354, 5243078, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (470, N'Longview', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 234083, 7714939, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (471, N'Welcome To Paradise', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 224208, 7406008, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (472, N'Basket Case', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 181629, 5951736, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (473, N'When I Come Around', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 178364, 5839426, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (474, N'She', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 134164, 4425128, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (475, N'J.A.R. (Jason Andrew Relva)', 39, 1, 4, N'Mike Dirnt -Words Green Day -Music', 170997, 5645755, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (476, N'Geek Stink Breath', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 135888, 4408983, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (477, N'Brain Stew', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 193149, 6305550, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (478, N'Jaded', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 90331, 2950224, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (479, N'Walking Contradiction', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 151170, 4932366, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (480, N'Stuck With Me', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 135523, 4431357, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (481, N'Hitchin'' A Ride', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 171546, 5616891, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (482, N'Good Riddance (Time Of Your Life)', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 153600, 5075241, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (483, N'Redundant', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 198164, 6481753, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (484, N'Nice Guys Finish Last', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 170187, 5604618, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (485, N'Minority', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 168803, 5535061, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (486, N'Warning', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 221910, 7343176, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (487, N'Waiting', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 192757, 6316430, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (488, N'Macy''s Day Parade', 39, 1, 4, N'Billie Joe Armstrong -Words Green Day -Music', 213420, 7075573, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (489, N'Into The Light', 40, 1, 1, N'David Coverdale', 76303, 2452653, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (490, N'River Song', 40, 1, 1, N'David Coverdale', 439510, 14359478, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (491, N'She Give Me ...', 40, 1, 1, N'David Coverdale', 252551, 8385478, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (492, N'Don''t You Cry', 40, 1, 1, N'David Coverdale', 347036, 11269612, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (493, N'Love Is Blind', 40, 1, 1, N'David Coverdale/Earl Slick', 344999, 11409720, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (494, N'Slave', 40, 1, 1, N'David Coverdale/Earl Slick', 291892, 9425200, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (495, N'Cry For Love', 40, 1, 1, N'Bossi/David Coverdale/Earl Slick', 293015, 9567075, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (496, N'Living On Love', 40, 1, 1, N'Bossi/David Coverdale/Earl Slick', 391549, 12785876, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (497, N'Midnight Blue', 40, 1, 1, N'David Coverdale/Earl Slick', 298631, 9750990, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (498, N'Too Many Tears', 40, 1, 1, N'Adrian Vanderberg/David Coverdale', 359497, 11810238, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (499, N'Don''t Lie To Me', 40, 1, 1, N'David Coverdale/Earl Slick', 283585, 9288007, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (500, N'Wherever You May Go', 40, 1, 1, N'David Coverdale', 239699, 7803074, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (501, N'Grito De Alerta', 41, 1, 7, N'Gonzaga Jr.', 202213, 6539422, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (502, N'Não Dá Mais Pra Segurar (Explode Coração)', 41, 1, 7, 219768, 7083012, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (503, N'Começaria Tudo Outra Vez', 41, 1, 7, 196545, 6473395, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (504, N'O Que É O Que É ?', 41, 1, 7, 259291, 8650647, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (505, N'Sangrando', 41, 1, 7, N'Gonzaga Jr/Gonzaguinha', 169717, 5494406, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (506, N'Diga Lá, Coração', 41, 1, 7, 255921, 8280636, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (507, N'Lindo Lago Do Amor', 41, 1, 7, N'Gonzaga Jr.', 249678, 8353191, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (508, N'Eu Apenas Queria Que Voçê Soubesse', 41, 1, 7, 155637, 5130056, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (509, N'Com A Perna No Mundo', 41, 1, 7, N'Gonzaga Jr.', 227448, 7747108, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (510, N'E Vamos À Luta', 41, 1, 7, 222406, 7585112, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (511, N'Um Homem Também Chora (Guerreiro Menino)', 41, 1, 7, 207229, 6854219, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (512, N'Comportamento Geral', 41, 1, 7, N'Gonzaga Jr', 181577, 5997444, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (513, N'Ponto De Interrogação', 41, 1, 7, 180950, 5946265, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (514, N'Espere Por Mim, Morena', 41, 1, 7, N'Gonzaguinha', 207072, 6796523, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (515, N'Meia-Lua Inteira', 23, 1, 7, 222093, 7466288, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (516, N'Voce e Linda', 23, 1, 7, 242938, 8050268, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (517, N'Um Indio', 23, 1, 7, 195944, 6453213, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (518, N'Podres Poderes', 23, 1, 7, 259761, 8622495, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (519, N'Voce Nao Entende Nada - Cotidiano', 23, 1, 7, 421982, 13885612, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (520, N'O Estrangeiro', 23, 1, 7, 374700, 12472890, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (521, N'Menino Do Rio', 23, 1, 7, 147670, 4862277, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (522, N'Qualquer Coisa', 23, 1, 7, 193410, 6372433, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (523, N'Sampa', 23, 1, 7, 185051, 6151831, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (524, N'Queixa', 23, 1, 7, 299676, 9953962, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (525, N'O Leaozinho', 23, 1, 7, 184398, 6098150, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (526, N'Fora Da Ordem', 23, 1, 7, 354011, 11746781, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (527, N'Terra', 23, 1, 7, 401319, 13224055, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (528, N'Alegria, Alegria', 23, 1, 7, 169221, 5497025, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (529, N'Balada Do Louco', 42, 1, 4, N'Arnaldo Baptista - Rita Lee', 241057, 7852328, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (530, N'Ando Meio Desligado', 42, 1, 4, N'Arnaldo Baptista - Rita Lee -  Sérgio Dias', 287817, 9484504, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (531, N'Top Top', 42, 1, 4, N'Os Mutantes - Arnolpho Lima Filho', 146938, 4875374, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (532, N'Baby', 42, 1, 4, N'Caetano Veloso', 177188, 5798202, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (533, N'A E O Z', 42, 1, 4, N'Mutantes', 518556, 16873005, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (534, N'Panis Et Circenses', 42, 1, 4, N'Caetano Veloso - Gilberto Gil', 125152, 4069688, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (535, N'Chão De Estrelas', 42, 1, 4, N'Orestes Barbosa-Sílvio Caldas', 284813, 9433620, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (536, N'Vida De Cachorro', 42, 1, 4, N'Rita Lee - Arnaldo Baptista - Sérgio Baptista', 195186, 6411149, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (537, N'Bat Macumba', 42, 1, 4, N'Gilberto Gil - Caetano Veloso', 187794, 6295223, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (538, N'Desculpe Babe', 42, 1, 4, N'Arnaldo Baptista - Rita Lee', 170422, 5637959, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (539, N'Rita Lee', 42, 1, 4, N'Arnaldo Baptista/Rita Lee/Sérgio Dias', 189257, 6270503, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (540, N'Posso Perder Minha Mulher, Minha Mãe, Desde Que Eu Tenha O Rock And Roll', 42, 1, 4, N'Arnaldo Baptista - Rita Lee - Arnolpho Lima Filho', 222955, 7346254, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (541, N'Banho De Lua', 42, 1, 4, N'B. de Filippi - F. Migliaci - Versão: Fred Jorge', 221831, 7232123, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (542, N'Meu Refrigerador Não Funciona', 42, 1, 4, N'Arnaldo Baptista - Rita Lee - Sérgio Dias', 382981, 12495906, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (543, N'Burn', 43, 1, 1, N'Coverdale/Lord/Paice', 453955, 14775708, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (544, N'Stormbringer', 43, 1, 1, N'Coverdale', 277133, 9050022, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (545, N'Gypsy', 43, 1, 1, N'Coverdale/Hughes/Lord/Paice', 339173, 11046952, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (546, N'Lady Double Dealer', 43, 1, 1, N'Coverdale', 233586, 7608759, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (547, N'Mistreated', 43, 1, 1, N'Coverdale', 758648, 24596235, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (548, N'Smoke On The Water', 43, 1, 1, N'Gillan/Glover/Lord/Paice', 618031, 20103125, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (549, N'You Fool No One', 43, 1, 1, N'Coverdale/Lord/Paice', 804101, 26369966, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (550, N'Custard Pie', 44, 1, 1, N'Jimmy Page/Robert Plant', 253962, 8348257, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (551, N'The Rover', 44, 1, 1, N'Jimmy Page/Robert Plant', 337084, 11011286, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (552, N'In My Time Of Dying', 44, 1, 1, N'John Bonham/John Paul Jones', 666017, 21676727, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (553, N'Houses Of The Holy', 44, 1, 1, N'Jimmy Page/Robert Plant', 242494, 7972503, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (554, N'Trampled Under Foot', 44, 1, 1, N'John Paul Jones', 336692, 11154468, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (555, N'Kashmir', 44, 1, 1, N'John Bonham', 508604, 16686580, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (556, N'Imperatriz', 45, 1, 7, N'Guga/Marquinho Lessa/Tuninho Professor', 339173, 11348710, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (557, N'Beija-Flor', 45, 1, 7, N'Caruso/Cleber/Deo/Osmar', 327000, 10991159, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (558, N'Viradouro', 45, 1, 7, N'Dadinho/Gilbreto Gomes/Gustavo/P.C. Portugal/R. Mocoto', 344320, 11484362, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (559, N'Mocidade', 45, 1, 7, N'Domenil/J. Brito/Joaozinho/Rap, Marcelo Do', 261720, 8817757, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (560, N'Unidos Da Tijuca', 45, 1, 7, N'Douglas/Neves, Vicente Das/Silva, Gilmar L./Toninho Gentil/Wantuir', 338834, 11440689, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (561, N'Salgueiro', 45, 1, 7, N'Augusto/Craig Negoescu/Rocco Filho/Saara, Ze Carlos Da', 305920, 10294741, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (562, N'Mangueira', 45, 1, 7, N'Bizuca/Clóvis Pê/Gilson Bernini/Marelo D''Aguia', 298318, 9999506, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (563, N'União Da Ilha', 45, 1, 7, N'Dito/Djalma Falcao/Ilha, Almir Da/Márcio André', 330945, 11100945, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (564, N'Grande Rio', 45, 1, 7, N'Carlos Santos/Ciro/Claudio Russo/Zé Luiz', 307252, 10251428, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (565, N'Portela', 45, 1, 7, N'Flavio Bororo/Paulo Apparicio/Wagner Alves/Zeca Sereno', 319608, 10712216, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (566, N'Caprichosos', 45, 1, 7, N'Gule/Jorge 101/Lequinho/Luiz Piao', 351320, 11870956, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (567, N'Tradição', 45, 1, 7, N'Adalto Magalha/Lourenco', 269165, 9114880, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (568, N'Império Serrano', 45, 1, 7, N'Arlindo Cruz/Carlos Sena/Elmo Caetano/Mauricao', 334942, 11161196, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (569, N'Tuiuti', 45, 1, 7, N'Claudio Martins/David Lima/Kleber Rodrigues/Livre, Cesare Som', 259657, 8749492, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (570, N'(Da Le) Yaleo', 46, 1, 1, N'Santana', 353488, 11769507, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (571, N'Love Of My Life', 46, 1, 1, N'Carlos Santana & Dave Matthews', 347820, 11634337, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (572, N'Put Your Lights On', 46, 1, 1, N'E. Shrody', 285178, 9394769, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (573, N'Africa Bamba', 46, 1, 1, N'I. Toure, S. Tidiane Toure, Carlos Santana & K. Perazzo', 282827, 9492487, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (574, N'Smooth', 46, 1, 1, N'M. Itaal Shur & Rob Thomas', 298161, 9867455, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (575, N'Do You Like The Way', 46, 1, 1, N'L. Hill', 354899, 11741062, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (576, N'Maria Maria', 46, 1, 1, N'W. Jean, J. Duplessis, Carlos Santana, K. Perazzo & R. Rekow', 262635, 8664601, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (577, N'Migra', 46, 1, 1, N'R. Taha, Carlos Santana & T. Lindsay', 329064, 10963305, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (578, N'Corazon Espinado', 46, 1, 1, N'F. Olivera', 276114, 9206802, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (579, N'Wishing It Was', 46, 1, 1, N'Eale-Eye Cherry, M. Simpson, J. King & M. Nishita', 292832, 9771348, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (580, N'El Farol', 46, 1, 1, N'Carlos Santana & KC Porter', 291160, 9599353, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (581, N'Primavera', 46, 1, 1, N'KC Porter & JB Eckl', 378618, 12504234, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (582, N'The Calling', 46, 1, 1, N'Carlos Santana & C. Thompson', 747755, 24703884, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (583, N'Solução', 47, 1, 7, 247431, 8100449, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (584, N'Manuel', 47, 1, 7, 230269, 7677671, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (585, N'Entre E Ouça', 47, 1, 7, 286302, 9391004, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (586, N'Um Contrato Com Deus', 47, 1, 7, 202501, 6636465, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (587, N'Um Jantar Pra Dois', 47, 1, 7, 244009, 8021589, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (588, N'Vamos Dançar', 47, 1, 7, 226194, 7617432, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (589, N'Um Love', 47, 1, 7, 181603, 6095524, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (590, N'Seis Da Tarde', 47, 1, 7, 238445, 7935898, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (591, N'Baixo Rio', 47, 1, 7, 198008, 6521676, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (592, N'Sombras Do Meu Destino', 47, 1, 7, 280685, 9161539, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (593, N'Do You Have Other Loves?', 47, 1, 7, 295235, 9604273, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (594, N'Agora Que O Dia Acordou', 47, 1, 7, 323213, 10572752, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (595, N'Já!!!', 47, 1, 7, 217782, 7103608, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (596, N'A Rua', 47, 1, 7, 238027, 7930264, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (597, N'Now''s The Time', 48, 1, 2, N'Miles Davis', 197459, 6358868, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (598, N'Jeru', 48, 1, 2, N'Miles Davis', 193410, 6222536, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (599, N'Compulsion', 48, 1, 2, N'Miles Davis', 345025, 11254474, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (600, N'Tempus Fugit', 48, 1, 2, N'Miles Davis', 231784, 7548434, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (601, N'Walkin''', 48, 1, 2, N'Miles Davis', 807392, 26411634, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (602, N'''Round Midnight', 48, 1, 2, N'Miles Davis', 357459, 11590284, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (603, N'Bye Bye Blackbird', 48, 1, 2, N'Miles Davis', 476003, 15549224, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (604, N'New Rhumba', 48, 1, 2, N'Miles Davis', 277968, 9018024, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (605, N'Generique', 48, 1, 2, N'Miles Davis', 168777, 5437017, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (606, N'Summertime', 48, 1, 2, N'Miles Davis', 200437, 6461370, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (607, N'So What', 48, 1, 2, N'Miles Davis', 564009, 18360449, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (608, N'The Pan Piper', 48, 1, 2, N'Miles Davis', 233769, 7593713, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (609, N'Someday My Prince Will Come', 48, 1, 2, N'Miles Davis', 544078, 17890773, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (610, N'My Funny Valentine (Live)', 49, 1, 2, N'Miles Davis', 907520, 29416781, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (611, N'E.S.P.', 49, 1, 2, N'Miles Davis', 330684, 11079866, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (612, N'Nefertiti', 49, 1, 2, N'Miles Davis', 473495, 15478450, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (613, N'Petits Machins (Little Stuff)', 49, 1, 2, N'Miles Davis', 487392, 16131272, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (614, N'Miles Runs The Voodoo Down', 49, 1, 2, N'Miles Davis', 843964, 27967919, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (615, N'Little Church (Live)', 49, 1, 2, N'Miles Davis', 196101, 6273225, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (616, N'Black Satin', 49, 1, 2, N'Miles Davis', 316682, 10529483, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (617, N'Jean Pierre (Live)', 49, 1, 2, N'Miles Davis', 243461, 7955114, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (618, N'Time After Time', 49, 1, 2, N'Miles Davis', 220734, 7292197, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (619, N'Portia', 49, 1, 2, N'Miles Davis', 378775, 12520126, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (620, N'Space Truckin''', 50, 1, 1, N'Blackmore/Gillan/Glover/Lord/Paice', 1196094, 39267613, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (621, N'Going Down / Highway Star', 50, 1, 1, N'Gillan/Glover/Lord/Nix - Blackmore/Paice', 913658, 29846063, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (622, N'Mistreated (Alternate Version)', 50, 1, 1, N'Blackmore/Coverdale', 854700, 27775442, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (623, N'You Fool No One (Alternate Version)', 50, 1, 1, N'Blackmore/Coverdale/Lord/Paice', 763924, 24887209, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (624, N'Jeepers Creepers', 51, 1, 2, 185965, 5991903, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (625, N'Blue Rythm Fantasy', 51, 1, 2, 348212, 11204006, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (626, N'Drum Boogie', 51, 1, 2, 191555, 6185636, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (627, N'Let Me Off Uptown', 51, 1, 2, 187637, 6034685, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (628, N'Leave Us Leap', 51, 1, 2, 182726, 5898810, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (629, N'Opus No.1', 51, 1, 2, 179800, 5846041, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (630, N'Boogie Blues', 51, 1, 2, 204199, 6603153, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (631, N'How High The Moon', 51, 1, 2, 201430, 6529487, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (632, N'Disc Jockey Jump', 51, 1, 2, 193149, 6260820, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (633, N'Up An'' Atom', 51, 1, 2, 179565, 5822645, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (634, N'Bop Boogie', 51, 1, 2, 189596, 6093124, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (635, N'Lemon Drop', 51, 1, 2, 194089, 6287531, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (636, N'Coronation Drop', 51, 1, 2, 176222, 5899898, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (637, N'Overtime', 51, 1, 2, 163030, 5432236, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (638, N'Imagination', 51, 1, 2, 289306, 9444385, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (639, N'Don''t Take Your Love From Me', 51, 1, 2, 282331, 9244238, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (640, N'Midget', 51, 1, 2, 217025, 7257663, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (641, N'I''m Coming Virginia', 51, 1, 2, 280163, 9209827, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (642, N'Payin'' Them Dues Blues', 51, 1, 2, 198556, 6536918, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (643, N'Jungle Drums', 51, 1, 2, 199627, 6546063, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (644, N'Showcase', 51, 1, 2, 201560, 6697510, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (645, N'Swedish Schnapps', 51, 1, 2, 191268, 6359750, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (646, N'Samba Da Bênção', 52, 1, 11, 409965, 13490008, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (647, N'Pot-Pourri N.º 4', 52, 1, 11, 392437, 13125975, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (648, N'Onde Anda Você', 52, 1, 11, 168437, 5550356, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (649, N'Samba Da Volta', 52, 1, 11, 170631, 5676090, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (650, N'Canto De Ossanha', 52, 1, 11, 204956, 6771624, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (651, N'Pot-Pourri N.º 5', 52, 1, 11, 219898, 7117769, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (652, N'Formosa', 52, 1, 11, 137482, 4560873, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (653, N'Como É Duro Trabalhar', 52, 1, 11, 226168, 7541177, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (654, N'Minha Namorada', 52, 1, 11, 244297, 7927967, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (655, N'Por Que Será', 52, 1, 11, 162142, 5371483, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (656, N'Berimbau', 52, 1, 11, 190667, 6335548, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (657, N'Deixa', 52, 1, 11, 179826, 5932799, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (658, N'Pot-Pourri N.º 2', 52, 1, 11, 211748, 6878359, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (659, N'Samba Em Prelúdio', 52, 1, 11, 212636, 6923473, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (660, N'Carta Ao Tom 74', 52, 1, 11, 162560, 5382354, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (661, N'Linha de Passe (João Bosco)', 53, 1, 7, 230948, 7902328, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (662, N'Pela Luz dos Olhos Teus (Miúcha e Tom Jobim)', 53, 1, 7, 163970, 5399626, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (663, N'Chão de Giz (Elba Ramalho)', 53, 1, 7, 274834, 9016916, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (664, N'Marina (Dorival Caymmi)', 53, 1, 7, 172643, 5523628, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (665, N'Aquarela (Toquinho)', 53, 1, 7, 259944, 8480140, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (666, N'Coração do Agreste (Fafá de Belém)', 53, 1, 7, 258194, 8380320, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (667, N'Dona (Roupa Nova)', 53, 1, 7, 243356, 7991295, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (668, N'Começaria Tudo Outra Vez (Maria Creuza)', 53, 1, 7, 206994, 6851151, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (669, N'Caçador de Mim (Sá & Guarabyra)', 53, 1, 7, 238341, 7751360, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (670, N'Romaria (Renato Teixeira)', 53, 1, 7, 244793, 8033885, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (671, N'As Rosas Não Falam (Beth Carvalho)', 53, 1, 7, 116767, 3836641, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (672, N'Wave (Os Cariocas)', 53, 1, 7, 130063, 4298006, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (673, N'Garota de Ipanema (Dick Farney)', 53, 1, 7, 174367, 5767474, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (674, N'Preciso Apender a Viver Só (Maysa)', 53, 1, 7, 143464, 4642359, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (675, N'Susie Q', 54, 1, 1, N'Hawkins-Lewis-Broadwater', 275565, 9043825, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (676, N'I Put A Spell On You', 54, 1, 1, N'Jay Hawkins', 272091, 8943000, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (677, N'Proud Mary', 54, 1, 1, N'J. C. Fogerty', 189022, 6229590, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (678, N'Bad Moon Rising', 54, 1, 1, N'J. C. Fogerty', 140146, 4609835, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (679, N'Lodi', 54, 1, 1, N'J. C. Fogerty', 191451, 6260214, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (680, N'Green River', 54, 1, 1, N'J. C. Fogerty', 154279, 5105874, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (681, N'Commotion', 54, 1, 1, N'J. C. Fogerty', 162899, 5354252, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (682, N'Down On The Corner', 54, 1, 1, N'J. C. Fogerty', 164858, 5521804, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (683, N'Fortunate Son', 54, 1, 1, N'J. C. Fogerty', 140329, 4617559, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (684, N'Travelin'' Band', 54, 1, 1, N'J. C. Fogerty', 129358, 4270414, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (685, N'Who''ll Stop The Rain', 54, 1, 1, N'J. C. Fogerty', 149394, 4899579, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (686, N'Up Around The Bend', 54, 1, 1, N'J. C. Fogerty', 162429, 5368701, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (687, N'Run Through The Jungle', 54, 1, 1, N'J. C. Fogerty', 186044, 6156567, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (688, N'Lookin'' Out My Back Door', 54, 1, 1, N'J. C. Fogerty', 152946, 5034670, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (689, N'Long As I Can See The Light', 54, 1, 1, N'J. C. Fogerty', 213237, 6924024, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (690, N'I Heard It Through The Grapevine', 54, 1, 1, N'Whitfield-Strong', 664894, 21947845, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (691, N'Have You Ever Seen The Rain?', 54, 1, 1, N'J. C. Fogerty', 160052, 5263675, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (692, N'Hey Tonight', 54, 1, 1, N'J. C. Fogerty', 162847, 5343807, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (693, N'Sweet Hitch-Hiker', 54, 1, 1, N'J. C. Fogerty', 175490, 5716603, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (694, N'Someday Never Comes', 54, 1, 1, N'J. C. Fogerty', 239360, 7945235, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (695, N'Walking On The Water', 55, 1, 1, N'J.C. Fogerty', 281286, 9302129, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (696, N'Suzie-Q, Pt. 2', 55, 1, 1, N'J.C. Fogerty', 244114, 7986637, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (697, N'Born On The Bayou', 55, 1, 1, N'J.C. Fogerty', 316630, 10361866, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (698, N'Good Golly Miss Molly', 55, 1, 1, N'J.C. Fogerty', 163604, 5348175, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (699, N'Tombstone Shadow', 55, 1, 1, N'J.C. Fogerty', 218880, 7209080, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (700, N'Wrote A Song For Everyone', 55, 1, 1, N'J.C. Fogerty', 296385, 9675875, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (701, N'Night Time Is The Right Time', 55, 1, 1, N'J.C. Fogerty', 190119, 6211173, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (702, N'Cotton Fields', 55, 1, 1, N'J.C. Fogerty', 178181, 5919224, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (703, N'It Came Out Of The Sky', 55, 1, 1, N'J.C. Fogerty', 176718, 5807474, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (704, N'Don''t Look Now', 55, 1, 1, N'J.C. Fogerty', 131918, 4366455, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (705, N'The Midnight Special', 55, 1, 1, N'J.C. Fogerty', 253596, 8297482, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (706, N'Before You Accuse Me', 55, 1, 1, N'J.C. Fogerty', 207804, 6815126, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (707, N'My Baby Left Me', 55, 1, 1, N'J.C. Fogerty', 140460, 4633440, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (708, N'Pagan Baby', 55, 1, 1, N'J.C. Fogerty', 385619, 12713813, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (709, N'(Wish I Could) Hideaway', 55, 1, 1, N'J.C. Fogerty', 228466, 7432978, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (710, N'It''s Just A Thought', 55, 1, 1, N'J.C. Fogerty', 237374, 7778319, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (711, N'Molina', 55, 1, 1, N'J.C. Fogerty', 163239, 5390811, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (712, N'Born To Move', 55, 1, 1, N'J.C. Fogerty', 342804, 11260814, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (713, N'Lookin'' For A Reason', 55, 1, 1, N'J.C. Fogerty', 209789, 6933135, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (714, N'Hello Mary Lou', 55, 1, 1, N'J.C. Fogerty', 132832, 4476563, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (715, N'Gatas Extraordinárias', 56, 1, 7, 212506, 7095702, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (716, N'Brasil', 56, 1, 7, 243696, 7911683, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (717, N'Eu Sou Neguinha (Ao Vivo)', 56, 1, 7, 251768, 8376000, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (718, N'Geração Coca-Cola (Ao Vivo)', 56, 1, 7, 228153, 7573301, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (719, N'Lanterna Dos Afogados', 56, 1, 7, 204538, 6714582, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (720, N'Coroné Antonio Bento', 56, 1, 7, 200437, 6713066, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (721, N'Você Passa, Eu Acho Graça (Ao Vivo)', 56, 1, 7, 206733, 6943576, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (722, N'Meu Mundo Fica Completo (Com Você)', 56, 1, 7, 247771, 8322240, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (723, N'1° De Julho', 56, 1, 7, 270262, 9017535, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (724, N'Música Urbana 2', 56, 1, 7, 194899, 6383472, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (725, N'Vida Bandida (Ao Vivo)', 56, 1, 7, 192626, 6360785, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (726, N'Palavras Ao Vento', 56, 1, 7, 212453, 7048676, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (727, N'Não Sei O Que Eu Quero Da Vida', 56, 1, 7, 151849, 5024963, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (728, N'Woman Is The Nigger Of The World (Ao Vivo)', 56, 1, 7, 298919, 9724145, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (729, N'Juventude Transviada (Ao Vivo)', 56, 1, 7, 278622, 9183808, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (730, N'Malandragem', 57, 1, 7, 247588, 8165048, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (731, N'O Segundo Sol', 57, 1, 7, 252133, 8335629, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (732, N'Smells Like Teen Spirit (Ao Vivo)', 57, 1, 7, 316865, 10384506, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (733, N'E.C.T.', 57, 1, 7, 227500, 7571834, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (734, N'Todo Amor Que Houver Nesta Vida', 57, 1, 7, 227160, 7420347, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (735, N'Metrô. Linha 743', 57, 1, 7, 174654, 5837495, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (736, N'Nós (Ao Vivo)', 57, 1, 7, 193828, 6498661, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (737, N'Na Cadência Do Samba', 57, 1, 7, 196075, 6483952, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (738, N'Admirável Gado Novo', 57, 1, 7, 274390, 9144031, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (739, N'Eleanor Rigby', 57, 1, 7, 189466, 6303205, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (740, N'Socorro', 57, 1, 7, 258586, 8549393, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (741, N'Blues Da Piedade', 57, 1, 7, 257123, 8472964, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (742, N'Rubens', 57, 1, 7, 211853, 7026317, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (743, N'Não Deixe O Samba Morrer - Cassia Eller e Alcione', 57, 1, 7, 268173, 8936345, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (744, N'Mis Penas Lloraba Yo (Ao Vivo) Soy Gitano (Tangos)', 57, 1, 7, 188473, 6195854, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (745, N'Comin'' Home', 58, 1, 1, N'Bolin/Coverdale/Paice', 235781, 7644604, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (746, N'Lady Luck', 58, 1, 1, N'Cook/Coverdale', 168202, 5501379, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (747, N'Gettin'' Tighter', 58, 1, 1, N'Bolin/Hughes', 218044, 7176909, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (748, N'Dealer', 58, 1, 1, N'Bolin/Coverdale', 230922, 7591066, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (749, N'I Need Love', 58, 1, 1, N'Bolin/Coverdale', 263836, 8701064, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (750, N'Drifter', 58, 1, 1, N'Bolin/Coverdale', 242834, 8001505, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (751, N'Love Child', 58, 1, 1, N'Bolin/Coverdale', 188160, 6173806, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (752, N'This Time Around / Owed to ''G'' [Instrumental]', 58, 1, 1, N'Bolin/Hughes/Lord', 370102, 11995679, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (753, N'You Keep On Moving', 58, 1, 1, N'Coverdale/Hughes', 319111, 10447868, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (754, N'Speed King', 59, 1, 1, N'Blackmore, Gillan, Glover, Lord, Paice', 264385, 8587578, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (755, N'Bloodsucker', 59, 1, 1, N'Blackmore, Gillan, Glover, Lord, Paice', 256261, 8344405, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (756, N'Child In Time', 59, 1, 1, N'Blackmore, Gillan, Glover, Lord, Paice', 620460, 20230089, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (757, N'Flight Of The Rat', 59, 1, 1, N'Blackmore, Gillan, Glover, Lord, Paice', 478302, 15563967, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (758, N'Into The Fire', 59, 1, 1, N'Blackmore, Gillan, Glover, Lord, Paice', 210259, 6849310, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (759, N'Living Wreck', 59, 1, 1, N'Blackmore, Gillan, Glover, Lord, Paice', 274886, 8993056, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (760, N'Hard Lovin'' Man', 59, 1, 1, N'Blackmore, Gillan, Glover, Lord, Paice', 431203, 13931179, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (761, N'Fireball', 60, 1, 1, N'Ritchie Blackmore, Ian Gillan, Roger Glover, Jon Lord, Ian Paice', 204721, 6714807, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (762, N'No No No', 60, 1, 1, N'Ritchie Blackmore, Ian Gillan, Roger Glover, Jon Lord, Ian Paice', 414902, 13646606, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (763, N'Strange Kind Of Woman', 60, 1, 1, N'Ritchie Blackmore, Ian Gillan, Roger Glover, Jon Lord, Ian Paice', 247092, 8072036, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (764, N'Anyone''s Daughter', 60, 1, 1, N'Ritchie Blackmore, Ian Gillan, Roger Glover, Jon Lord, Ian Paice', 284682, 9354480, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (765, N'The Mule', 60, 1, 1, N'Ritchie Blackmore, Ian Gillan, Roger Glover, Jon Lord, Ian Paice', 322063, 10638390, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (766, N'Fools', 60, 1, 1, N'Ritchie Blackmore, Ian Gillan, Roger Glover, Jon Lord, Ian Paice', 500427, 16279366, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (767, N'No One Came', 60, 1, 1, N'Ritchie Blackmore, Ian Gillan, Roger Glover, Jon Lord, Ian Paice', 385880, 12643813, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (768, N'Knocking At Your Back Door', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover', 424829, 13779332, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (769, N'Bad Attitude', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover, Jon Lord', 307905, 10035180, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (770, N'Child In Time (Son Of Aleric - Instrumental)', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover, Jon Lord, Ian Paice', 602880, 19712753, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (771, N'Nobody''s Home', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover, Jon Lord, Ian Paice', 243017, 7929493, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (772, N'Black Night', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover, Jon Lord, Ian Paice', 368770, 12058906, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (773, N'Perfect Strangers', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover', 321149, 10445353, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (774, N'The Unwritten Law', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover, Ian Paice', 295053, 9740361, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (775, N'Call Of The Wild', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover, Jon Lord', 293851, 9575295, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (776, N'Hush', 61, 1, 1, N'South', 213054, 6944928, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (777, N'Smoke On The Water', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover, Jon Lord, Ian Paice', 464378, 15180849, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (778, N'Space Trucking', 61, 1, 1, N'Richie Blackmore, Ian Gillian, Roger Glover, Jon Lord, Ian Paice', 341185, 11122183, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (779, N'Highway Star', 62, 1, 1, N'Ian Gillan/Ian Paice/Jon Lord/Ritchie Blckmore/Roger Glover', 368770, 12012452, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (780, N'Maybe I''m A Leo', 62, 1, 1, N'Ian Gillan/Ian Paice/Jon Lord/Ritchie Blckmore/Roger Glover', 290455, 9502646, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (781, N'Pictures Of Home', 62, 1, 1, N'Ian Gillan/Ian Paice/Jon Lord/Ritchie Blckmore/Roger Glover', 303777, 9903835, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (782, N'Never Before', 62, 1, 1, N'Ian Gillan/Ian Paice/Jon Lord/Ritchie Blckmore/Roger Glover', 239830, 7832790, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (783, N'Smoke On The Water', 62, 1, 1, N'Ian Gillan/Ian Paice/Jon Lord/Ritchie Blckmore/Roger Glover', 340871, 11246496, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (784, N'Lazy', 62, 1, 1, N'Ian Gillan/Ian Paice/Jon Lord/Ritchie Blckmore/Roger Glover', 442096, 14397671, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (785, N'Space Truckin''', 62, 1, 1, N'Ian Gillan/Ian Paice/Jon Lord/Ritchie Blckmore/Roger Glover', 272796, 8981030, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (786, N'Vavoom : Ted The Mechanic', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 257384, 8510755, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (787, N'Loosen My Strings', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 359680, 11702232, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (788, N'Soon Forgotten', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 287791, 9401383, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (789, N'Sometimes I Feel Like Screaming', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 451840, 14789410, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (790, N'Cascades : I''m Not Your Lover', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 283689, 9209693, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (791, N'The Aviator', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 320992, 10532053, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (792, N'Rosa''s Cantina', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 312372, 10323804, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (793, N'A Castle Full Of Rascals', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 311693, 10159566, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (794, N'A Touch Away', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 276323, 9098561, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (795, N'Hey Cisco', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 354089, 11600029, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (796, N'Somebody Stole My Guitar', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 249443, 8180421, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (797, N'The Purpendicular Waltz', 63, 1, 1, N'Ian Gillan, Roger Glover, Jon Lord, Steve Morse, Ian Paice', 283924, 9299131, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (798, N'King Of Dreams', 64, 1, 1, N'Blackmore, Glover, Turner', 328385, 10733847, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (799, N'The Cut Runs Deep', 64, 1, 1, N'Blackmore, Glover, Turner, Lord, Paice', 342752, 11191650, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (800, N'Fire In The Basement', 64, 1, 1, N'Blackmore, Glover, Turner, Lord, Paice', 283977, 9267550, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (801, N'Truth Hurts', 64, 1, 1, N'Blackmore, Glover, Turner', 314827, 10224612, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (802, N'Breakfast In Bed', 64, 1, 1, N'Blackmore, Glover, Turner', 317126, 10323804, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (803, N'Love Conquers All', 64, 1, 1, N'Blackmore, Glover, Turner', 227186, 7328516, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (804, N'Fortuneteller', 64, 1, 1, N'Blackmore, Glover, Turner, Lord, Paice', 349335, 11369671, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (805, N'Too Much Is Not Enough', 64, 1, 1, N'Turner, Held, Greenwood', 257724, 8382800, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (806, N'Wicked Ways', 64, 1, 1, N'Blackmore, Glover, Turner, Lord, Paice', 393691, 12826582, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (807, N'Stormbringer', 65, 1, 1, N'D.Coverdale/R.Blackmore/Ritchie Blackmore', 246413, 8044864, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (808, N'Love Don''t Mean a Thing', 65, 1, 1, N'D.Coverdale/G.Hughes/Glenn Hughes/I.Paice/Ian Paice/J.Lord/John Lord/R.Blackmore/Ritchie Blackmore', 263862, 8675026, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (809, N'Holy Man', 65, 1, 1, N'D.Coverdale/G.Hughes/Glenn Hughes/J.Lord/John Lord', 270236, 8818093, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (810, N'Hold On', 65, 1, 1, N'D.Coverdal/G.Hughes/Glenn Hughes/I.Paice/Ian Paice/J.Lord/John Lord', 306860, 10022428, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (811, N'Lady Double Dealer', 65, 1, 1, N'D.Coverdale/R.Blackmore/Ritchie Blackmore', 201482, 6554330, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (812, N'You Can''t Do it Right (With the One You Love)', 65, 1, 1, N'D.Coverdale/G.Hughes/Glenn Hughes/R.Blackmore/Ritchie Blackmore', 203755, 6709579, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (813, N'High Ball Shooter', 65, 1, 1, N'D.Coverdale/G.Hughes/Glenn Hughes/I.Paice/Ian Paice/J.Lord/John Lord/R.Blackmore/Ritchie Blackmore', 267833, 8772471, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (814, N'The Gypsy', 65, 1, 1, N'D.Coverdale/G.Hughes/Glenn Hughes/I.Paice/Ian Paice/J.Lord/John Lord/R.Blackmore/Ritchie Blackmore', 242886, 7946614, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (815, N'Soldier Of Fortune', 65, 1, 1, N'D.Coverdale/R.Blackmore/Ritchie Blackmore', 193750, 6315321, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (816, N'The Battle Rages On', 66, 1, 1, N'ian paice/jon lord', 356963, 11626228, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (817, N'Lick It Up', 66, 1, 1, N'roger glover', 240274, 7792604, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (818, N'Anya', 66, 1, 1, N'jon lord/roger glover', 392437, 12754921, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (819, N'Talk About Love', 66, 1, 1, N'roger glover', 247823, 8072171, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (820, N'Time To Kill', 66, 1, 1, N'roger glover', 351033, 11354742, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (821, N'Ramshackle Man', 66, 1, 1, N'roger glover', 334445, 10874679, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (822, N'A Twist In The Tail', 66, 1, 1, N'roger glover', 257462, 8413103, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (823, N'Nasty Piece Of Work', 66, 1, 1, N'jon lord/roger glover', 276662, 9076997, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (824, N'Solitaire', 66, 1, 1, N'roger glover', 282226, 9157021, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (825, N'One Man''s Meat', 66, 1, 1, N'roger glover', 278804, 9068960, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (826, N'Pour Some Sugar On Me', 67, 1, 1, 292519, 9518842, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (827, N'Photograph', 67, 1, 1, 248633, 8108507, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (828, N'Love Bites', 67, 1, 1, 346853, 11305791, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (829, N'Let''s Get Rocked', 67, 1, 1, 296019, 9724150, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (830, N'Two Steps Behind [Acoustic Version]', 67, 1, 1, 259787, 8523388, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (831, N'Animal', 67, 1, 1, 244741, 7985133, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (832, N'Heaven Is', 67, 1, 1, 214021, 6988128, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (833, N'Rocket', 67, 1, 1, 247248, 8092463, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (834, N'When Love & Hate Collide', 67, 1, 1, 257280, 8364633, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (835, N'Action', 67, 1, 1, 220604, 7130830, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (836, N'Make Love Like A Man', 67, 1, 1, 255660, 8309725, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (837, N'Armageddon It', 67, 1, 1, 322455, 10522352, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (838, N'Have You Ever Needed Someone So Bad', 67, 1, 1, 319320, 10400020, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (839, N'Rock Of Ages', 67, 1, 1, 248424, 8150318, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (840, N'Hysteria', 67, 1, 1, 355056, 11622738, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (841, N'Bringin'' On The Heartbreak', 67, 1, 1, 272457, 8853324, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (842, N'Roll Call', 68, 1, 2, N'Jim Beard', 321358, 10653494, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (843, N'Otay', 68, 1, 2, N'John Scofield, Robert Aries, Milton Chambers and Gary Grainger', 423653, 14176083, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (844, N'Groovus Interruptus', 68, 1, 2, N'Jim Beard', 319373, 10602166, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (845, N'Paris On Mine', 68, 1, 2, N'Jon Herington', 368875, 12059507, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (846, N'In Time', 68, 1, 2, N'Sylvester Stewart', 368953, 12287103, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (847, N'Plan B', 68, 1, 2, N'Dean Brown, Dennis Chambers & Jim Beard', 272039, 9032315, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (848, N'Outbreak', 68, 1, 2, N'Jim Beard & Jon Herington', 659226, 21685807, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (849, N'Baltimore, DC', 68, 1, 2, N'John Scofield', 346932, 11394473, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (850, N'Talkin Loud and Saying Nothin', 68, 1, 2, N'James Brown & Bobby Byrd', 360411, 11994859, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (851, N'Pétala', 69, 1, 7, 270080, 8856165, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (852, N'Meu Bem-Querer', 69, 1, 7, 255608, 8330047, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (853, N'Cigano', 69, 1, 7, 304692, 10037362, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (854, N'Boa Noite', 69, 1, 7, 338755, 11283582, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (855, N'Fato Consumado', 69, 1, 7, 211565, 7018586, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (856, N'Faltando Um Pedaço', 69, 1, 7, 267728, 8788760, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (857, N'Álibi', 69, 1, 7, 213237, 6928434, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (858, N'Esquinas', 69, 1, 7, 280999, 9096726, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (859, N'Se...', 69, 1, 7, 286432, 9413777, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (860, N'Eu Te Devoro', 69, 1, 7, 311614, 10312775, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (861, N'Lilás', 69, 1, 7, 274181, 9049542, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (862, N'Acelerou', 69, 1, 7, 284081, 9396942, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (863, N'Um Amor Puro', 69, 1, 7, 327784, 10687311, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (864, N'Samurai', 70, 1, 7, N'Djavan', 330997, 10872787, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (865, N'Nem Um Dia', 70, 1, 7, N'Djavan', 337423, 11181446, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (866, N'Oceano', 70, 1, 7, N'Djavan', 217338, 7026441, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (867, N'Açai', 70, 1, 7, N'Djavan', 270968, 8893682, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (868, N'Serrado', 70, 1, 7, N'Djavan', 295314, 9842240, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (869, N'Flor De Lis', 70, 1, 7, N'Djavan', 236355, 7801108, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (870, N'Amar É Tudo', 70, 1, 7, N'Djavan', 211617, 7073899, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (871, N'Azul', 70, 1, 7, N'Djavan', 253962, 8381029, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (872, N'Seduzir', 70, 1, 7, N'Djavan', 277524, 9163253, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (873, N'A Carta', 70, 1, 7, N'Djavan - Gabriel, O Pensador', 347297, 11493463, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (874, N'Sina', 70, 1, 7, N'Djavan', 268173, 8906539, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (875, N'Acelerou', 70, 1, 7, N'Djavan', 284133, 9391439, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (876, N'Um Amor Puro', 70, 1, 7, N'Djavan', 327105, 10664698, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (877, N'O Bêbado e a Equilibrista', 71, 1, 7, 223059, 7306143, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (878, N'O Mestre-Sala dos Mares', 71, 1, 7, 186226, 6180414, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (879, N'Atrás da Porta', 71, 1, 7, 166608, 5432518, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (880, N'Dois Pra Lá, Dois Pra Cá', 71, 1, 7, 263026, 8684639, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (881, N'Casa no Campo', 71, 1, 7, 170788, 5531841, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (882, N'Romaria', 71, 1, 7, 242834, 7968525, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (883, N'Alô, Alô, Marciano', 71, 1, 7, 241397, 8137254, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (884, N'Me Deixas Louca', 71, 1, 7, 214831, 6888030, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (885, N'Fascinação', 71, 1, 7, 180793, 5793959, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (886, N'Saudosa Maloca', 71, 1, 7, 278125, 9059416, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (887, N'As Aparências Enganam', 71, 1, 7, 247379, 8014346, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (888, N'Madalena', 71, 1, 7, 157387, 5243721, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (889, N'Maria Rosa', 71, 1, 7, 232803, 7592504, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (890, N'Aprendendo A Jogar', 71, 1, 7, 290664, 9391041, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (891, N'Layla', 72, 1, 6, N'Clapton/Gordon', 430733, 14115792, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (892, N'Badge', 72, 1, 6, N'Clapton/Harrison', 163552, 5322942, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (893, N'I Feel Free', 72, 1, 6, N'Bruce/Clapton', 174576, 5725684, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (894, N'Sunshine Of Your Love', 72, 1, 6, N'Bruce/Clapton', 252891, 8225889, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (895, N'Crossroads', 72, 1, 6, N'Clapton/Robert Johnson Arr: Eric Clapton', 253335, 8273540, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (896, N'Strange Brew', 72, 1, 6, N'Clapton/Collins/Pappalardi', 167810, 5489787, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (897, N'White Room', 72, 1, 6, N'Bruce/Clapton', 301583, 9872606, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (898, N'Bell Bottom Blues', 72, 1, 6, N'Clapton', 304744, 9946681, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (899, N'Cocaine', 72, 1, 6, N'Cale/Clapton', 215928, 7138399, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (900, N'I Shot The Sheriff', 72, 1, 6, N'Marley', 263862, 8738973, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (901, N'After Midnight', 72, 1, 6, N'Clapton/J. J. Cale', 191320, 6460941, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (902, N'Swing Low Sweet Chariot', 72, 1, 6, N'Clapton/Trad. Arr. Clapton', 208143, 6896288, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (903, N'Lay Down Sally', 72, 1, 6, N'Clapton/Levy', 231732, 7774207, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (904, N'Knockin On Heavens Door', 72, 1, 6, N'Clapton/Dylan', 264411, 8758819, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (905, N'Wonderful Tonight', 72, 1, 6, N'Clapton', 221387, 7326923, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (906, N'Let It Grow', 72, 1, 6, N'Clapton', 297064, 9742568, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (907, N'Promises', 72, 1, 6, N'Clapton/F.eldman/Linn', 180401, 6006154, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (908, N'I Can''t Stand It', 72, 1, 6, N'Clapton', 249730, 8271980, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (909, N'Signe', 73, 1, 6, N'Eric Clapton', 193515, 6475042, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (910, N'Before You Accuse Me', 73, 1, 6, N'Eugene McDaniel', 224339, 7456807, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (911, N'Hey Hey', 73, 1, 6, N'Big Bill Broonzy', 196466, 6543487, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (912, N'Tears In Heaven', 73, 1, 6, N'Eric Clapton, Will Jennings', 274729, 9032835, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (913, N'Lonely Stranger', 73, 1, 6, N'Eric Clapton', 328724, 10894406, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (914, N'Nobody Knows You When You''re Down & Out', 73, 1, 6, N'Jimmy Cox', 231836, 7669922, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (915, N'Layla', 73, 1, 6, N'Eric Clapton, Jim Gordon', 285387, 9490542, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (916, N'Running On Faith', 73, 1, 6, N'Jerry Lynn Williams', 378984, 12536275, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (917, N'Walkin'' Blues', 73, 1, 6, N'Robert Johnson', 226429, 7435192, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (918, N'Alberta', 73, 1, 6, N'Traditional', 222406, 7412975, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (919, N'San Francisco Bay Blues', 73, 1, 6, N'Jesse Fuller', 203363, 6724021, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (920, N'Malted Milk', 73, 1, 6, N'Robert Johnson', 216528, 7096781, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (921, N'Old Love', 73, 1, 6, N'Eric Clapton, Robert Cray', 472920, 15780747, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (922, N'Rollin'' And Tumblin''', 73, 1, 6, N'McKinley Morgenfield (Muddy Waters)', 251768, 8407355, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (923, N'Collision', 74, 1, 4, N'Jon Hudson/Mike Patton', 204303, 6656596, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (924, N'Stripsearch', 74, 1, 4, N'Jon Hudson/Mike Bordin/Mike Patton', 270106, 8861119, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (925, N'Last Cup Of Sorrow', 74, 1, 4, N'Bill Gould/Mike Patton', 251663, 8221247, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (926, N'Naked In Front Of The Computer', 74, 1, 4, N'Mike Patton', 128757, 4225077, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (927, N'Helpless', 74, 1, 4, N'Bill Gould/Mike Bordin/Mike Patton', 326217, 10753135, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (928, N'Mouth To Mouth', 74, 1, 4, N'Bill Gould/Jon Hudson/Mike Bordin/Mike Patton', 228493, 7505887, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (929, N'Ashes To Ashes', 74, 1, 4, N'Bill Gould/Jon Hudson/Mike Bordin/Mike Patton/Roddy Bottum', 217391, 7093746, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (930, N'She Loves Me Not', 74, 1, 4, N'Bill Gould/Mike Bordin/Mike Patton', 209867, 6887544, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (931, N'Got That Feeling', 74, 1, 4, N'Mike Patton', 140852, 4643227, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (932, N'Paths Of Glory', 74, 1, 4, N'Bill Gould/Jon Hudson/Mike Bordin/Mike Patton/Roddy Bottum', 257253, 8436300, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (933, N'Home Sick Home', 74, 1, 4, N'Mike Patton', 119040, 3898976, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (934, N'Pristina', 74, 1, 4, N'Bill Gould/Mike Patton', 232698, 7497361, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (935, N'Land Of Sunshine', 75, 1, 4, 223921, 7353567, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (936, N'Caffeine', 75, 1, 4, 267937, 8747367, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (937, N'Midlife Crisis', 75, 1, 4, 263235, 8628841, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (938, N'RV', 75, 1, 4, 223242, 7288162, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (939, N'Smaller And Smaller', 75, 1, 4, 310831, 10180103, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (940, N'Everything''s Ruined', 75, 1, 4, 273658, 9010917, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (941, N'Malpractice', 75, 1, 4, 241371, 7900683, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (942, N'Kindergarten', 75, 1, 4, 270680, 8853647, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (943, N'Be Aggressive', 75, 1, 4, 222432, 7298027, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (944, N'A Small Victory', 75, 1, 4, 297168, 9733572, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (945, N'Crack Hitler', 75, 1, 4, 279144, 9162435, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (946, N'Jizzlobber', 75, 1, 4, 398341, 12926140, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (947, N'Midnight Cowboy', 75, 1, 4, 251924, 8242626, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (948, N'Easy', 75, 1, 4, 185835, 6073008, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (949, N'Get Out', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 137482, 4524972, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (950, N'Ricochet', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 269400, 8808812, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (951, N'Evidence', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton, Trey Spruance', 293590, 9626136, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (952, N'The Gentle Art Of Making Enemies', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 209319, 6908609, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (953, N'Star A.D.', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 203807, 6747658, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (954, N'Cuckoo For Caca', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton, Trey Spruance', 222902, 7388369, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (955, N'Caralho Voador', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton, Trey Spruance', 242102, 8029054, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (956, N'Ugly In The Morning', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 186435, 6224997, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (957, N'Digging The Grave', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 185129, 6109259, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (958, N'Take This Bottle', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton, Trey Spruance', 298997, 9779971, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (959, N'King For A Day', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton, Trey Spruance', 395859, 13163733, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (960, N'What A Day', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 158275, 5203430, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (961, N'The Last To Know', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 267833, 8736776, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (962, N'Just A Man', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 336666, 11031254, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (963, N'Absolute Zero', 76, 1, 1, N'Mike Bordin, Billy Gould, Mike Patton', 181995, 5929427, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (964, N'From Out Of Nowhere', 77, 1, 4, N'Faith No More', 202527, 6587802, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (965, N'Epic', 77, 1, 4, N'Faith No More', 294008, 9631296, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (966, N'Falling To Pieces', 77, 1, 4, N'Faith No More', 316055, 10333123, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (967, N'Surprise! You''re Dead!', 77, 1, 4, N'Faith No More', 147226, 4823036, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (968, N'Zombie Eaters', 77, 1, 4, N'Faith No More', 360881, 11835367, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (969, N'The Real Thing', 77, 1, 4, N'Faith No More', 493635, 16233080, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (970, N'Underwater Love', 77, 1, 4, N'Faith No More', 231993, 7634387, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (971, N'The Morning After', 77, 1, 4, N'Faith No More', 223764, 7355898, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (972, N'Woodpecker From Mars', 77, 1, 4, N'Faith No More', 340532, 11174250, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (973, N'War Pigs', 77, 1, 4, N'Tony Iommi, Bill Ward, Geezer Butler, Ozzy Osbourne', 464770, 15267802, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (974, N'Edge Of The World', 77, 1, 4, N'Faith No More', 250357, 8235607, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (975, N'Deixa Entrar', 78, 1, 7, 33619, 1095012, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (976, N'Falamansa Song', 78, 1, 7, 237165, 7921313, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (977, N'Xote Dos Milagres', 78, 1, 7, 269557, 8897778, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (978, N'Rindo À Toa', 78, 1, 7, 222066, 7365321, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (979, N'Confidência', 78, 1, 7, 222197, 7460829, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (980, N'Forró De Tóquio', 78, 1, 7, 169273, 5588756, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (981, N'Zeca Violeiro', 78, 1, 7, 143673, 4781949, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (982, N'Avisa', 78, 1, 7, 355030, 11844320, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (983, N'Principiando/Decolagem', 78, 1, 7, 116767, 3923789, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (984, N'Asas', 78, 1, 7, 231915, 7711669, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (985, N'Medo De Escuro', 78, 1, 7, 213760, 7056323, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (986, N'Oração', 78, 1, 7, 271072, 9003882, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (987, N'Minha Gata', 78, 1, 7, 181838, 6039502, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (988, N'Desaforo', 78, 1, 7, 174524, 5853561, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (989, N'In Your Honor', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 230191, 7468463, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (990, N'No Way Back', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 196675, 6421400, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (991, N'Best Of You', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 255712, 8363467, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (992, N'DOA', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 252186, 8232342, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (993, N'Hell', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 117080, 3819255, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (994, N'The Last Song', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 199523, 6496742, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (995, N'Free Me', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 278700, 9109340, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (996, N'Resolve', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 288731, 9416186, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (997, N'The Deepest Blues Are Black', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 238419, 7735473, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (998, N'End Over End', 79, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett', 352078, 11395296, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (999, N'Still', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 313182, 10323157, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1000, N'What If I Do?', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 302994, 9929799, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1001, N'Miracle', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 209684, 6877994, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1002, N'Another Round', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 265848, 8752670, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1003, N'Friend Of A Friend', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 193280, 6355088, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1004, N'Over And Out', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 316264, 10428382, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1005, N'On The Mend', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 271908, 9071997, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1006, N'Virginia Moon', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 229198, 7494639, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1007, N'Cold Day In The Sun', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 200724, 6596617, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1008, N'Razor', 80, 1, 1, N'Dave Grohl, Taylor Hawkins, Nate Mendel, Chris Shiflett/FOO FIGHTERS', 293276, 9721373, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1009, N'All My Life', 81, 1, 4, N'Foo Fighters', 263653, 8665545, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1010, N'Low', 81, 1, 4, N'Foo Fighters', 268120, 8847196, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1011, N'Have It All', 81, 1, 4, N'Foo Fighters', 298057, 9729292, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1012, N'Times Like These', 81, 1, 4, N'Foo Fighters', 266370, 8624691, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1013, N'Disenchanted Lullaby', 81, 1, 4, N'Foo Fighters', 273528, 8919111, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1014, N'Tired Of You', 81, 1, 4, N'Foo Fighters', 311353, 10094743, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1015, N'Halo', 81, 1, 4, N'Foo Fighters', 306442, 10026371, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1016, N'Lonely As You', 81, 1, 4, N'Foo Fighters', 277185, 9022628, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1017, N'Overdrive', 81, 1, 4, N'Foo Fighters', 270550, 8793187, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1018, N'Burn Away', 81, 1, 4, N'Foo Fighters', 298396, 9678073, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1019, N'Come Back', 81, 1, 4, N'Foo Fighters', 469968, 15371980, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1020, N'Doll', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 83487, 2702572, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1021, N'Monkey Wrench', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 231523, 7527531, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1022, N'Hey, Johnny Park!', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 248528, 8079480, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1023, N'My Poor Brain', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 213446, 6973746, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1024, N'Wind Up', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 152163, 4950667, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1025, N'Up In Arms', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 135732, 4406227, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1026, N'My Hero', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 260101, 8472365, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1027, N'See You', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 146782, 4888173, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1028, N'Enough Space', 82, 1, 1, N'Dave Grohl', 157387, 5169280, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1029, N'February Stars', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 289306, 9344875, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1030, N'Everlong', 82, 1, 1, N'Dave Grohl', 250749, 8270816, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1031, N'Walking After You', 82, 1, 1, N'Dave Grohl', 303856, 9898992, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1032, N'New Way Home', 82, 1, 1, N'Dave, Taylor, Nate, Chris', 342230, 11205664, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1033, N'My Way', 83, 1, 12, N'claude françois/gilles thibault/jacques revaux/paul anka', 275879, 8928684, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1034, N'Strangers In The Night', 83, 1, 12, N'berthold kaempfert/charles singleton/eddie snyder', 155794, 5055295, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1035, N'New York, New York', 83, 1, 12, N'fred ebb/john kander', 206001, 6707993, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1036, N'I Get A Kick Out Of You', 83, 1, 12, N'cole porter', 194429, 6332441, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1037, N'Something Stupid', 83, 1, 12, N'carson c. parks', 158615, 5210643, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1038, N'Moon River', 83, 1, 12, N'henry mancini/johnny mercer', 198922, 6395808, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1039, N'What Now My Love', 83, 1, 12, N'carl sigman/gilbert becaud/pierre leroyer', 149995, 4913383, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1040, N'Summer Love', 83, 1, 12, N'hans bradtke/heinz meier/johnny mercer', 174994, 5693242, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1041, N'For Once In My Life', 83, 1, 12, N'orlando murden/ronald miller', 171154, 5557537, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1042, N'Love And Marriage', 83, 1, 12, N'jimmy van heusen/sammy cahn', 89730, 2930596, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1043, N'They Can''t Take That Away From Me', 83, 1, 12, N'george gershwin/ira gershwin', 161227, 5240043, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1044, N'My Kind Of Town', 83, 1, 12, N'jimmy van heusen/sammy cahn', 188499, 6119915, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1045, N'Fly Me To The Moon', 83, 1, 12, N'bart howard', 149263, 4856954, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1046, N'I''ve Got You Under My Skin', 83, 1, 12, N'cole porter', 210808, 6883787, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1047, N'The Best Is Yet To Come', 83, 1, 12, N'carolyn leigh/cy coleman', 173583, 5633730, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1048, N'It Was A Very Good Year', 83, 1, 12, N'ervin drake', 266605, 8554066, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1049, N'Come Fly With Me', 83, 1, 12, N'jimmy van heusen/sammy cahn', 190458, 6231029, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1050, N'That''s Life', 83, 1, 12, N'dean kay thompson/kelly gordon', 187010, 6095727, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1051, N'The Girl From Ipanema', 83, 1, 12, N'antonio carlos jobim/norman gimbel/vinicius de moraes', 193750, 6410674, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1052, N'The Lady Is A Tramp', 83, 1, 12, N'lorenz hart/richard rodgers', 184111, 5987372, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1053, N'Bad, Bad Leroy Brown', 83, 1, 12, N'jim croce', 169900, 5548581, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1054, N'Mack The Knife', 83, 1, 12, N'bert brecht/kurt weill/marc blitzstein', 292075, 9541052, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1055, N'Loves Been Good To Me', 83, 1, 12, N'rod mckuen', 203964, 6645365, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1056, N'L.A. Is My Lady', 83, 1, 12, N'alan bergman/marilyn bergman/peggy lipton jones/quincy jones', 193175, 6378511, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1057, N'Entrando Na Sua (Intro)', 84, 1, 7, 179252, 5840027, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1058, N'Nervosa', 84, 1, 7, 229537, 7680421, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1059, N'Funk De Bamba (Com Fernanda Abreu)', 84, 1, 7, 237191, 7866165, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1060, N'Call Me At Cleo´s', 84, 1, 7, 236617, 7920510, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1061, N'Olhos Coloridos (Com Sandra De Sá)', 84, 1, 7, 321332, 10567404, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1062, N'Zambação', 84, 1, 7, 301113, 10030604, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1063, N'Funk Hum', 84, 1, 7, 244453, 8084475, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1064, N'Forty Days (Com DJ Hum)', 84, 1, 7, 221727, 7347172, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1065, N'Balada Da Paula', 84, 1, 7, N'Emerson Villani', 322821, 10603717, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1066, N'Dujji', 84, 1, 7, 324597, 10833935, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1067, N'Meu Guarda-Chuva', 84, 1, 7, 248528, 8216625, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1068, N'Motéis', 84, 1, 7, 213498, 7041077, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1069, N'Whistle Stop', 84, 1, 7, 526132, 17533664, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1070, N'16 Toneladas', 84, 1, 7, 191634, 6390885, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1071, N'Divirta-Se (Saindo Da Sua)', 84, 1, 7, 74919, 2439206, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1072, N'Forty Days Instrumental', 84, 1, 7, 292493, 9584317, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1073, N'Óia Eu Aqui De Novo', 85, 1, 10, 219454, 7469735, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1074, N'Baião Da Penha', 85, 1, 10, 247928, 8393047, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1075, N'Esperando Na Janela', 85, 1, 10, N'Manuca/Raimundinho DoAcordion/Targino Godim', 261041, 8660617, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1076, N'Juazeiro', 85, 1, 10, N'Humberto Teixeira/Luiz Gonzaga', 222275, 7349779, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1077, N'Último Pau-De-Arara', 85, 1, 10, N'Corumbá/José Gumarães/Venancio', 200437, 6638563, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1078, N'Asa Branca', 85, 1, 10, N'Humberto Teixeira/Luiz Gonzaga', 217051, 7387183, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1079, N'Qui Nem Jiló', 85, 1, 10, N'Humberto Teixeira/Luiz Gonzaga', 204695, 6937472, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1080, N'Assum Preto', 85, 1, 10, N'Humberto Teixeira/Luiz Gonzaga', 199653, 6625000, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1081, N'Pau-De-Arara', 85, 1, 10, N'Guio De Morais E Seus "Parentes"/Luiz Gonzaga', 191660, 6340649, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1082, N'A Volta Da Asa Branca', 85, 1, 10, N'Luiz Gonzaga/Zé Dantas', 271020, 9098093, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1083, N'O Amor Daqui De Casa', 85, 1, 10, N'Gilberto Gil', 148636, 4888292, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1084, N'As Pegadas Do Amor', 85, 1, 10, N'Gilberto Gil', 209136, 6899062, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1085, N'Lamento Sertanejo', 85, 1, 10, N'Dominguinhos/Gilberto Gil', 260963, 8518290, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1086, N'Casinha Feliz', 85, 1, 10, N'Gilberto Gil', 32287, 1039615, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1087, N'Introdução (Live)', 86, 1, 7, 154096, 5227579, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1088, N'Palco (Live)', 86, 1, 7, 238315, 8026622, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1089, N'Is This Love (Live)', 86, 1, 7, 295262, 9819759, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1090, N'Stir It Up (Live)', 86, 1, 7, 282409, 9594738, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1091, N'Refavela (Live)', 86, 1, 7, 236695, 7985305, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1092, N'Vendedor De Caranguejo (Live)', 86, 1, 7, 248842, 8358128, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1093, N'Quanta (Live)', 86, 1, 7, 357485, 11774865, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1094, N'Estrela (Live)', 86, 1, 7, 285309, 9436411, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1095, N'Pela Internet (Live)', 86, 1, 7, 263471, 8804401, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1096, N'Cérebro Eletrônico (Live)', 86, 1, 7, 231627, 7805352, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1097, N'Opachorô (Live)', 86, 1, 7, 259526, 8596384, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1098, N'Copacabana (Live)', 86, 1, 7, 289671, 9673672, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1099, N'A Novidade (Live)', 86, 1, 7, 316969, 10508000, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1100, N'Ghandi (Live)', 86, 1, 7, 222458, 7481950, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1101, N'De Ouro E Marfim (Live)', 86, 1, 7, 234971, 7838453, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1102, N'Doce De Carnaval (Candy All)', 87, 1, 2, 356101, 11998470, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1103, N'Lamento De Carnaval', 87, 1, 2, 294530, 9819276, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1104, N'Pretinha', 87, 1, 2, 265273, 8914579, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1105, N'A Novidade', 73, 1, 7, N'Gilberto Gil', 324780, 10765600, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1106, N'Tenho Sede', 73, 1, 7, N'Gilberto Gil', 261616, 8708114, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1107, N'Refazenda', 73, 1, 7, N'Gilberto Gil', 218305, 7237784, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1108, N'Realce', 73, 1, 7, N'Gilberto Gil', 264489, 8847612, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1109, N'Esotérico', 73, 1, 7, N'Gilberto Gil', 317779, 10530533, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1110, N'Drão', 73, 1, 7, N'Gilberto Gil', 301453, 9931950, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1111, N'A Paz', 73, 1, 7, N'Gilberto Gil', 293093, 9593064, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1112, N'Beira Mar', 73, 1, 7, N'Gilberto Gil', 295444, 9597994, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1113, N'Sampa', 73, 1, 7, N'Gilberto Gil', 225697, 7469905, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1114, N'Parabolicamará', 73, 1, 7, N'Gilberto Gil', 284943, 9543435, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1115, N'Tempo Rei', 73, 1, 7, N'Gilberto Gil', 302733, 10019269, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1116, N'Expresso 2222', 73, 1, 7, N'Gilberto Gil', 284760, 9690577, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1117, N'Aquele Abraço', 73, 1, 7, N'Gilberto Gil', 263993, 8805003, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1118, N'Palco', 73, 1, 7, N'Gilberto Gil', 270550, 9049901, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1119, N'Toda Menina Baiana', 73, 1, 7, N'Gilberto Gil', 278177, 9351000, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1120, N'Sítio Do Pica-Pau Amarelo', 73, 1, 7, N'Gilberto Gil', 218070, 7217955, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1121, N'Straight Out Of Line', 88, 1, 3, N'Sully Erna', 259213, 8511877, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1122, N'Faceless', 88, 1, 3, N'Sully Erna', 216006, 6992417, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1123, N'Changes', 88, 1, 3, N'Sully Erna; Tony Rombola', 260022, 8455835, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1124, N'Make Me Believe', 88, 1, 3, N'Sully Erna', 248607, 8075050, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1125, N'I Stand Alone', 88, 1, 3, N'Sully Erna', 246125, 8017041, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1126, N'Re-Align', 88, 1, 3, N'Sully Erna', 260884, 8513891, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1127, N'I Fucking Hate You', 88, 1, 3, N'Sully Erna', 247170, 8059642, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1128, N'Releasing The Demons', 88, 1, 3, N'Sully Erna', 252760, 8276372, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1129, N'Dead And Broken', 88, 1, 3, N'Sully Erna', 251454, 8206611, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1130, N'I Am', 88, 1, 3, N'Sully Erna', 239516, 7803270, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1131, N'The Awakening', 88, 1, 3, N'Sully Erna', 89547, 3035251, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1132, N'Serenity', 88, 1, 3, N'Sully Erna; Tony Rombola', 274834, 9172976, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1133, N'American Idiot', 89, 1, 4, N'Billie Joe Armstrong, Mike Dirnt, Tré Cool', 174419, 5705793, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1134, N'Jesus Of Suburbia / City Of The Damned / I Don''t Care / Dearly Beloved / Tales Of Another Broken Home', 89, 1, 4, N'Billie Joe Armstrong/Green Day', 548336, 17875209, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1135, N'Holiday', 89, 1, 4, N'Billie Joe Armstrong, Mike Dirnt, Tré Cool', 232724, 7599602, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1136, N'Boulevard Of Broken Dreams', 89, 1, 4, N'Mike Dint, Billie Joe, Tré Cool', 260858, 8485122, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1137, N'Are We The Waiting', 89, 1, 4, N'Green Day', 163004, 5328329, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1138, N'St. Jimmy', 89, 1, 4, N'Green Day', 175307, 5716589, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1139, N'Give Me Novacaine', 89, 1, 4, N'Green Day', 205871, 6752485, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1140, N'She''s A Rebel', 89, 1, 4, N'Green Day', 120528, 3901226, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1141, N'Extraordinary Girl', 89, 1, 4, N'Green Day', 214021, 6975177, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1142, N'Letterbomb', 89, 1, 4, N'Green Day', 246151, 7980902, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1143, N'Wake Me Up When September Ends', 89, 1, 4, N'Mike Dint, Billie Joe, Tré Cool', 285753, 9325597, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1144, N'Homecoming / The Death Of St. Jimmy / East 12th St. / Nobody Likes You / Rock And Roll Girlfriend / We''re Coming Home Again', 89, 1, 4, N'Mike Dirnt/Tré Cool', 558602, 18139840, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1145, N'Whatsername', 89, 1, 4, N'Green Day', 252316, 8244843, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1146, N'Welcome to the Jungle', 90, 2, 1, 273552, 4538451, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1147, N'It''s So Easy', 90, 2, 1, 202824, 3394019, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1148, N'Nightrain', 90, 2, 1, 268537, 4457283, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1149, N'Out Ta Get Me', 90, 2, 1, 263893, 4382147, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1150, N'Mr. Brownstone', 90, 2, 1, 228924, 3816323, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1151, N'Paradise City', 90, 2, 1, 406347, 6687123, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1152, N'My Michelle', 90, 2, 1, 219961, 3671299, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1153, N'Think About You', 90, 2, 1, 231640, 3860275, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1154, N'Sweet Child O'' Mine', 90, 2, 1, 356424, 5879347, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1155, N'You''re Crazy', 90, 2, 1, 197135, 3301971, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1156, N'Anything Goes', 90, 2, 1, 206400, 3451891, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1157, N'Rocket Queen', 90, 2, 1, 375349, 6185539, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1158, N'Right Next Door to Hell', 91, 2, 1, 182321, 3175950, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1159, N'Dust N'' Bones', 91, 2, 1, 298374, 5053742, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1160, N'Live and Let Die', 91, 2, 1, 184016, 3203390, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1161, N'Don''t Cry (Original)', 91, 2, 1, 284744, 4833259, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1162, N'Perfect Crime', 91, 2, 1, 143637, 2550030, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1163, N'You Ain''t the First', 91, 2, 1, 156268, 2754414, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1164, N'Bad Obsession', 91, 2, 1, 328282, 5537678, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1165, N'Back off Bitch', 91, 2, 1, 303436, 5135662, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1166, N'Double Talkin'' Jive', 91, 2, 1, 203637, 3520862, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1167, N'November Rain', 91, 2, 1, 537540, 8923566, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1168, N'The Garden', 91, 2, 1, 322175, 5438862, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1169, N'Garden of Eden', 91, 2, 1, 161539, 2839694, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1170, N'Don''t Damn Me', 91, 2, 1, 318901, 5385886, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1171, N'Bad Apples', 91, 2, 1, 268351, 4567966, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1172, N'Dead Horse', 91, 2, 1, 257600, 4394014, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1173, N'Coma', 91, 2, 1, 616511, 10201342, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1174, N'Civil War', 92, 1, 3, N'Duff McKagan/Slash/W. Axl Rose', 461165, 15046579, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1175, N'14 Years', 92, 1, 3, N'Izzy Stradlin''/W. Axl Rose', 261355, 8543664, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1176, N'Yesterdays', 92, 1, 3, N'Billy/Del James/W. Axl Rose/West Arkeen', 196205, 6398489, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1177, N'Knockin'' On Heaven''s Door', 92, 1, 3, N'Bob Dylan', 336457, 10986716, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1178, N'Get In The Ring', 92, 1, 3, N'Duff McKagan/Slash/W. Axl Rose', 341054, 11134105, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1179, N'Shotgun Blues', 92, 1, 3, N'W. Axl Rose', 203206, 6623916, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1180, N'Breakdown', 92, 1, 3, N'W. Axl Rose', 424960, 13978284, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1181, N'Pretty Tied Up', 92, 1, 3, N'Izzy Stradlin''', 287477, 9408754, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1182, N'Locomotive', 92, 1, 3, N'Slash/W. Axl Rose', 522396, 17236842, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1183, N'So Fine', 92, 1, 3, N'Duff McKagan', 246491, 8039484, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1184, N'Estranged', 92, 1, 3, N'W. Axl Rose', 563800, 18343787, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1185, N'You Could Be Mine', 92, 1, 3, N'Izzy Stradlin''/W. Axl Rose', 343875, 11207355, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1186, N'Don''t Cry', 92, 1, 3, N'Izzy Stradlin''/W. Axl Rose', 284238, 9222458, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1187, N'My World', 92, 1, 3, N'W. Axl Rose', 84532, 2764045, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1188, N'Colibri', 93, 1, 2, N'Richard Bull', 361012, 12055329, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1189, N'Love Is The Colour', 93, 1, 2, N'R. Carless', 251585, 8419165, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1190, N'Magnetic Ocean', 93, 1, 2, N'Patrick Claher/Richard Bull', 321123, 10720741, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1191, N'Deep Waters', 93, 1, 2, N'Richard Bull', 396460, 13075359, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1192, N'L''Arc En Ciel De Miles', 93, 1, 2, N'Kevin Robinson/Richard Bull', 242390, 8053997, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1193, N'Gypsy', 93, 1, 2, N'Kevin Robinson', 330997, 11083374, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1194, N'Journey Into Sunlight', 93, 1, 2, N'Jean Paul Maunick', 249756, 8241177, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1195, N'Sunchild', 93, 1, 2, N'Graham Harvey', 259970, 8593143, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1196, N'Millenium', 93, 1, 2, N'Maxton Gig Beesley Jnr.', 379167, 12511939, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1197, N'Thinking ''Bout Tomorrow', 93, 1, 2, N'Fayyaz Virgi/Richard Bull', 355395, 11865384, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1198, N'Jacob''s Ladder', 93, 1, 2, N'Julian Crampton', 367647, 12201595, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1199, N'She Wears Black', 93, 1, 2, N'G Harvey/R Hope-Taylor', 528666, 17617944, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1200, N'Dark Side Of The Cog', 93, 1, 2, N'Jean Paul Maunick', 377155, 12491122, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1201, N'Different World', 94, 2, 1, 258692, 4383764, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1202, N'These Colours Don''t Run', 94, 2, 1, 412152, 6883500, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1203, N'Brighter Than a Thousand Suns', 94, 2, 1, 526255, 8721490, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1204, N'The Pilgrim', 94, 2, 1, 307593, 5172144, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1205, N'The Longest Day', 94, 2, 1, 467810, 7785748, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1206, N'Out of the Shadows', 94, 2, 1, 336896, 5647303, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1207, N'The Reincarnation of Benjamin Breeg', 94, 2, 1, 442106, 7367736, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1208, N'For the Greater Good of God', 94, 2, 1, 564893, 9367328, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1209, N'Lord of Light', 94, 2, 1, 444614, 7393698, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1210, N'The Legacy', 94, 2, 1, 562966, 9314287, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1211, N'Hallowed Be Thy Name (Live) [Non Album Bonus tracks]', 94, 2, 1, 431262, 7205816, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1212, N'The Number Of The Beast', 95, 1, 3, N'Steve Harris', 294635, 4718897, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1213, N'The Trooper', 95, 1, 3, N'Steve Harris', 235311, 3766272, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1214, N'Prowler', 95, 1, 3, N'Steve Harris', 255634, 4091904, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1215, N'Transylvania', 95, 1, 3, N'Steve Harris', 265874, 4255744, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1216, N'Remember Tomorrow', 95, 1, 3, N'Paul Di''Anno/Steve Harris', 352731, 5648438, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1217, N'Where Eagles Dare', 95, 1, 3, N'Steve Harris', 289358, 4630528, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1218, N'Sanctuary', 95, 1, 3, N'David Murray/Paul Di''Anno/Steve Harris', 293250, 4694016, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1219, N'Running Free', 95, 1, 3, N'Paul Di''Anno/Steve Harris', 228937, 3663872, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1220, N'Run To The Hilss', 95, 1, 3, N'Steve Harris', 237557, 3803136, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1221, N'2 Minutes To Midnight', 95, 1, 3, N'Adrian Smith/Bruce Dickinson', 337423, 5400576, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1222, N'Iron Maiden', 95, 1, 3, N'Steve Harris', 324623, 5195776, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1223, N'Hallowed Be Thy Name', 95, 1, 3, N'Steve Harris', 471849, 7550976, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1224, N'Be Quick Or Be Dead', 96, 1, 3, N'Bruce Dickinson/Janick Gers', 196911, 3151872, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1225, N'From Here To Eternity', 96, 1, 3, N'Steve Harris', 259866, 4159488, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1226, N'Can I Play With Madness', 96, 1, 3, N'Adrian Smith/Bruce Dickinson/Steve Harris', 282488, 4521984, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1227, N'Wasting Love', 96, 1, 3, N'Bruce Dickinson/Janick Gers', 347846, 5566464, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1228, N'Tailgunner', 96, 1, 3, N'Bruce Dickinson/Steve Harris', 249469, 3993600, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1229, N'The Evil That Men Do', 96, 1, 3, N'Adrian Smith/Bruce Dickinson/Steve Harris', 325929, 5216256, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1230, N'Afraid To Shoot Strangers', 96, 1, 3, N'Steve Harris', 407980, 6529024, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1231, N'Bring Your Daughter... To The Slaughter', 96, 1, 3, N'Bruce Dickinson', 317727, 5085184, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1232, N'Heaven Can Wait', 96, 1, 3, N'Steve Harris', 448574, 7178240, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1233, N'The Clairvoyant', 96, 1, 3, N'Steve Harris', 269871, 4319232, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1234, N'Fear Of The Dark', 96, 1, 3, N'Steve Harris', 431333, 6906078, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1235, N'The Wicker Man', 97, 1, 1, N'Adrian Smith/Bruce Dickinson/Steve Harris', 275539, 11022464, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1236, N'Ghost Of The Navigator', 97, 1, 1, N'Bruce Dickinson/Janick Gers/Steve Harris', 410070, 16404608, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1237, N'Brave New World', 97, 1, 1, N'Bruce Dickinson/David Murray/Steve Harris', 378984, 15161472, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1238, N'Blood Brothers', 97, 1, 1, N'Steve Harris', 434442, 17379456, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1239, N'The Mercenary', 97, 1, 1, N'Janick Gers/Steve Harris', 282488, 11300992, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1240, N'Dream Of Mirrors', 97, 1, 1, N'Janick Gers/Steve Harris', 561162, 22448256, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1241, N'The Fallen Angel', 97, 1, 1, N'Adrian Smith/Steve Harris', 240718, 9629824, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1242, N'The Nomad', 97, 1, 1, N'David Murray/Steve Harris', 546115, 21846144, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1243, N'Out Of The Silent Planet', 97, 1, 1, N'Bruce Dickinson/Janick Gers/Steve Harris', 385541, 15423616, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1244, N'The Thin Line Between Love & Hate', 97, 1, 1, N'David Murray/Steve Harris', 506801, 20273280, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1245, N'Wildest Dreams', 98, 1, 13, N'Adrian Smith/Steve Harris', 232777, 9312384, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1246, N'Rainmaker', 98, 1, 13, N'Bruce Dickinson/David Murray/Steve Harris', 228623, 9146496, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1247, N'No More Lies', 98, 1, 13, N'Steve Harris', 441782, 17672320, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1248, N'Montsegur', 98, 1, 13, N'Bruce Dickinson/Janick Gers/Steve Harris', 350484, 14020736, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1249, N'Dance Of Death', 98, 1, 13, N'Janick Gers/Steve Harris', 516649, 20670727, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1250, N'Gates Of Tomorrow', 98, 1, 13, N'Bruce Dickinson/Janick Gers/Steve Harris', 312032, 12482688, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1251, N'New Frontier', 98, 1, 13, N'Adrian Smith/Bruce Dickinson/Nicko McBrain', 304509, 12181632, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1252, N'Paschendale', 98, 1, 13, N'Adrian Smith/Steve Harris', 508107, 20326528, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1253, N'Face In The Sand', 98, 1, 13, N'Adrian Smith/Bruce Dickinson/Steve Harris', 391105, 15648948, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1254, N'Age Of Innocence', 98, 1, 13, N'David Murray/Steve Harris', 370468, 14823478, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1255, N'Journeyman', 98, 1, 13, N'Bruce Dickinson/David Murray/Steve Harris', 427023, 17082496, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1256, N'Be Quick Or Be Dead', 99, 1, 1, N'Bruce Dickinson/Janick Gers', 204512, 8181888, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1257, N'From Here To Eternity', 99, 1, 1, N'Steve Harris', 218357, 8739038, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1258, N'Afraid To Shoot Strangers', 99, 1, 1, N'Steve Harris', 416496, 16664589, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1259, N'Fear Is The Key', 99, 1, 1, N'Bruce Dickinson/Janick Gers', 335307, 13414528, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1260, N'Childhood''s End', 99, 1, 1, N'Steve Harris', 280607, 11225216, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1261, N'Wasting Love', 99, 1, 1, N'Bruce Dickinson/Janick Gers', 350981, 14041216, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1262, N'The Fugitive', 99, 1, 1, N'Steve Harris', 294112, 11765888, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1263, N'Chains Of Misery', 99, 1, 1, N'Bruce Dickinson/David Murray', 217443, 8700032, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1264, N'The Apparition', 99, 1, 1, N'Janick Gers/Steve Harris', 234605, 9386112, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1265, N'Judas Be My Guide', 99, 1, 1, N'Bruce Dickinson/David Murray', 188786, 7553152, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1266, N'Weekend Warrior', 99, 1, 1, N'Janick Gers/Steve Harris', 339748, 13594678, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1267, N'Fear Of The Dark', 99, 1, 1, N'Steve Harris', 436976, 17483789, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1268, N'01 - Prowler', 100, 1, 6, N'Steve Harris', 236173, 5668992, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1269, N'02 - Sanctuary', 100, 1, 6, N'David Murray/Paul Di''Anno/Steve Harris', 196284, 4712576, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1270, N'03 - Remember Tomorrow', 100, 1, 6, N'Harris/Paul Di´Anno', 328620, 7889024, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1271, N'04 - Running Free', 100, 1, 6, N'Harris/Paul Di´Anno', 197276, 4739122, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1272, N'05 - Phantom of the Opera', 100, 1, 6, N'Steve Harris', 428016, 10276872, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1273, N'06 - Transylvania', 100, 1, 6, N'Steve Harris', 259343, 6226048, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1274, N'07 - Strange World', 100, 1, 6, N'Steve Harris', 332460, 7981184, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1275, N'08 - Charlotte the Harlot', 100, 1, 6, N'Murray  Dave', 252708, 6066304, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1276, N'09 - Iron Maiden', 100, 1, 6, N'Steve Harris', 216058, 5189891, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1277, N'The Ides Of March', 101, 1, 13, N'Steve Harris', 105926, 2543744, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1278, N'Wrathchild', 101, 1, 13, N'Steve Harris', 174471, 4188288, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1279, N'Murders In The Rue Morgue', 101, 1, 13, N'Steve Harris', 258377, 6205786, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1280, N'Another Life', 101, 1, 13, N'Steve Harris', 203049, 4874368, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1281, N'Genghis Khan', 101, 1, 13, N'Steve Harris', 187141, 4493440, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1282, N'Innocent Exile', 101, 1, 13, N'Di´Anno/Harris', 232515, 5584861, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1283, N'Killers', 101, 1, 13, N'Steve Harris', 300956, 7227440, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1284, N'Prodigal Son', 101, 1, 13, N'Steve Harris', 372349, 8937600, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1285, N'Purgatory', 101, 1, 13, N'Steve Harris', 200150, 4804736, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1286, N'Drifter', 101, 1, 13, N'Steve Harris', 288757, 6934660, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1287, N'Intro- Churchill S Speech', 102, 1, 13, 48013, 1154488, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1288, N'Aces High', 102, 1, 13, 276375, 6635187, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1289, N'2 Minutes To Midnight', 102, 1, 3, N'Smith/Dickinson', 366550, 8799380, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1290, N'The Trooper', 102, 1, 3, N'Harris', 268878, 6455255, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1291, N'Revelations', 102, 1, 3, N'Dickinson', 371826, 8926021, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1292, N'Flight Of Icarus', 102, 1, 3, N'Smith/Dickinson', 229982, 5521744, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1293, N'Rime Of The Ancient Mariner', 102, 1, 3, 789472, 18949518, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1294, N'Powerslave', 102, 1, 3, 454974, 10921567, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1295, N'The Number Of The Beast', 102, 1, 3, N'Harris', 275121, 6605094, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1296, N'Hallowed Be Thy Name', 102, 1, 3, N'Harris', 451422, 10836304, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1297, N'Iron Maiden', 102, 1, 3, N'Harris', 261955, 6289117, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1298, N'Run To The Hills', 102, 1, 3, N'Harris', 231627, 5561241, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1299, N'Running Free', 102, 1, 3, N'Harris/Di Anno', 204617, 4912986, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1300, N'Wrathchild', 102, 1, 13, N'Steve Harris', 183666, 4410181, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1301, N'Acacia Avenue', 102, 1, 13, 379872, 9119118, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1302, N'Children Of The Damned', 102, 1, 13, N'Steve Harris', 278177, 6678446, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1303, N'Die With Your Boots On', 102, 1, 13, N'Adrian Smith/Bruce Dickinson/Steve Harris', 314174, 7542367, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1304, N'Phantom Of The Opera', 102, 1, 13, N'Steve Harris', 441155, 10589917, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1305, N'Be Quick Or Be Dead', 103, 1, 1, 233142, 5599853, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1306, N'The Number Of The Beast', 103, 1, 1, 294008, 7060625, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1307, N'Wrathchild', 103, 1, 1, 174106, 4182963, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1308, N'From Here To Eternity', 103, 1, 1, 284447, 6831163, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1309, N'Can I Play With Madness', 103, 1, 1, 213106, 5118995, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1310, N'Wasting Love', 103, 1, 1, 336953, 8091301, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1311, N'Tailgunner', 103, 1, 1, 247640, 5947795, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1312, N'The Evil That Men Do', 103, 1, 1, 478145, 11479913, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1313, N'Afraid To Shoot Strangers', 103, 1, 1, 412525, 9905048, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1314, N'Fear Of The Dark', 103, 1, 1, 431542, 10361452, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1315, N'Bring Your Daughter... To The Slaughter...', 104, 1, 1, 376711, 9045532, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1316, N'The Clairvoyant', 104, 1, 1, 262426, 6302648, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1317, N'Heaven Can Wait', 104, 1, 1, 440555, 10577743, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1318, N'Run To The Hills', 104, 1, 1, 235859, 5665052, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1319, N'2 Minutes To Midnight', 104, 1, 1, N'Adrian Smith/Bruce Dickinson', 338233, 8122030, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1320, N'Iron Maiden', 104, 1, 1, 494602, 11874875, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1321, N'Hallowed Be Thy Name', 104, 1, 1, 447791, 10751410, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1322, N'The Trooper', 104, 1, 1, 232672, 5588560, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1323, N'Sanctuary', 104, 1, 1, 318511, 7648679, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1324, N'Running Free', 104, 1, 1, 474017, 11380851, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1325, N'Tailgunner', 105, 1, 3, N'Bruce Dickinson/Steve Harris', 255582, 4089856, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1326, N'Holy Smoke', 105, 1, 3, N'Bruce Dickinson/Steve Harris', 229459, 3672064, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1327, N'No Prayer For The Dying', 105, 1, 3, N'Steve Harris', 263941, 4225024, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1328, N'Public Enema Number One', 105, 1, 3, N'Bruce Dickinson/David Murray', 254197, 4071587, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1329, N'Fates Warning', 105, 1, 3, N'David Murray/Steve Harris', 250853, 4018088, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1330, N'The Assassin', 105, 1, 3, N'Steve Harris', 258768, 4141056, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1331, N'Run Silent Run Deep', 105, 1, 3, N'Bruce Dickinson/Steve Harris', 275408, 4407296, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1332, N'Hooks In You', 105, 1, 3, N'Adrian Smith/Bruce Dickinson', 247510, 3960832, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1333, N'Bring Your Daughter... ...To The Slaughter', 105, 1, 3, N'Bruce Dickinson', 284238, 4548608, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1334, N'Mother Russia', 105, 1, 3, N'Steve Harris', 332617, 5322752, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1335, N'Where Eagles Dare', 106, 1, 3, N'Steve Harris', 369554, 5914624, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1336, N'Revelations', 106, 1, 3, N'Bruce Dickinson', 408607, 6539264, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1337, N'Flight Of The Icarus', 106, 1, 3, N'Adrian Smith/Bruce Dickinson', 230269, 3686400, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1338, N'Die With Your Boots On', 106, 1, 3, N'Adrian Smith/Bruce Dickinson/Steve Harris', 325694, 5212160, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1339, N'The Trooper', 106, 1, 3, N'Steve Harris', 251454, 4024320, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1340, N'Still Life', 106, 1, 3, N'David Murray/Steve Harris', 294347, 4710400, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1341, N'Quest For Fire', 106, 1, 3, N'Steve Harris', 221309, 3543040, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1342, N'Sun And Steel', 106, 1, 3, N'Adrian Smith/Bruce Dickinson', 206367, 3306324, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1343, N'To Tame A Land', 106, 1, 3, N'Steve Harris', 445283, 7129264, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1344, N'Aces High', 107, 1, 3, N'Harris', 269531, 6472088, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1345, N'2 Minutes To Midnight', 107, 1, 3, N'Smith/Dickinson', 359810, 8638809, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1346, N'Losfer Words', 107, 1, 3, N'Steve Harris', 252891, 6074756, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1347, N'Flash of The Blade', 107, 1, 3, N'Dickinson', 242729, 5828861, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1348, N'Duelists', 107, 1, 3, N'Steve Harris', 366471, 8800686, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1349, N'Back in the Village', 107, 1, 3, N'Dickinson/Smith', 320548, 7696518, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1350, N'Powerslave', 107, 1, 3, N'Dickinson', 407823, 9791106, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1351, N'Rime of the Ancient Mariner', 107, 1, 3, N'Harris', 816509, 19599577, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1352, N'Intro', 108, 1, 3, 115931, 4638848, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1353, N'The Wicker Man', 108, 1, 3, N'Adrian Smith/Bruce Dickinson/Steve Harris', 281782, 11272320, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1354, N'Ghost Of The Navigator', 108, 1, 3, N'Bruce Dickinson/Janick Gers/Steve Harris', 408607, 16345216, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1355, N'Brave New World', 108, 1, 3, N'Bruce Dickinson/David Murray/Steve Harris', 366785, 14676148, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1356, N'Wrathchild', 108, 1, 3, N'Steve Harris', 185808, 7434368, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1357, N'2 Minutes To Midnight', 108, 1, 3, N'Adrian Smith/Bruce Dickinson', 386821, 15474816, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1358, N'Blood Brothers', 108, 1, 3, N'Steve Harris', 435513, 17422464, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1359, N'Sign Of The Cross', 108, 1, 3, N'Steve Harris', 649116, 25966720, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1360, N'The Mercenary', 108, 1, 3, N'Janick Gers/Steve Harris', 282697, 11309184, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1361, N'The Trooper', 108, 1, 3, N'Steve Harris', 273528, 10942592, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1362, N'Dream Of Mirrors', 109, 1, 1, N'Janick Gers/Steve Harris', 578324, 23134336, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1363, N'The Clansman', 109, 1, 1, N'Steve Harris', 559203, 22370432, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1364, N'The Evil That Men Do', 109, 1, 3, N'Adrian Smith/Bruce Dickinson/Steve Harris', 280737, 11231360, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1365, N'Fear Of The Dark', 109, 1, 1, N'Steve Harris', 460695, 18430080, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1366, N'Iron Maiden', 109, 1, 1, N'Steve Harris', 351869, 14076032, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1367, N'The Number Of The Beast', 109, 1, 1, N'Steve Harris', 300434, 12022107, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1368, N'Hallowed Be Thy Name', 109, 1, 1, N'Steve Harris', 443977, 17760384, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1369, N'Sanctuary', 109, 1, 1, N'David Murray/Paul Di''Anno/Steve Harris', 317335, 12695680, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1370, N'Run To The Hills', 109, 1, 1, N'Steve Harris', 292179, 11688064, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1371, N'Moonchild', 110, 1, 3, N'Adrian Smith; Bruce Dickinson', 340767, 8179151, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1372, N'Infinite Dreams', 110, 1, 3, N'Steve Harris', 369005, 8858669, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1373, N'Can I Play With Madness', 110, 1, 3, N'Adrian Smith; Bruce Dickinson; Steve Harris', 211043, 5067867, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1374, N'The Evil That Men Do', 110, 1, 3, N'Adrian Smith; Bruce Dickinson; Steve Harris', 273998, 6578930, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1375, N'Seventh Son of a Seventh Son', 110, 1, 3, N'Steve Harris', 593580, 14249000, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1376, N'The Prophecy', 110, 1, 3, N'Dave Murray; Steve Harris', 305475, 7334450, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1377, N'The Clairvoyant', 110, 1, 3, N'Adrian Smith; Bruce Dickinson; Steve Harris', 267023, 6411510, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1378, N'Only the Good Die Young', 110, 1, 3, N'Bruce Dickinson; Harris', 280894, 6744431, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1379, N'Caught Somewhere in Time', 111, 1, 3, N'Steve Harris', 445779, 10701149, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1380, N'Wasted Years', 111, 1, 3, N'Adrian Smith', 307565, 7384358, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1381, N'Sea of Madness', 111, 1, 3, N'Adrian Smith', 341995, 8210695, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1382, N'Heaven Can Wait', 111, 1, 3, N'Steve Harris', 441417, 10596431, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1383, N'Stranger in a Strange Land', 111, 1, 3, N'Adrian Smith', 344502, 8270899, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1384, N'Alexander the Great', 111, 1, 3, N'Steve Harris', 515631, 12377742, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1385, N'De Ja Vu', 111, 1, 3, N'David Murray/Steve Harris', 296176, 7113035, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1386, N'The Loneliness of the Long Dis', 111, 1, 3, N'Steve Harris', 391314, 9393598, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1387, N'22 Acacia Avenue', 112, 1, 3, N'Adrian Smith/Steve Harris', 395572, 5542516, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1388, N'Children of the Damned', 112, 1, 3, N'Steve Harris', 274364, 3845631, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1389, N'Gangland', 112, 1, 3, N'Adrian Smith/Clive Burr/Steve Harris', 228440, 3202866, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1390, N'Hallowed Be Thy Name', 112, 1, 3, N'Steve Harris', 428669, 6006107, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1391, N'Invaders', 112, 1, 3, N'Steve Harris', 203180, 2849181, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1392, N'Run to the Hills', 112, 1, 3, N'Steve Harris', 228884, 3209124, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1393, N'The Number Of The Beast', 112, 1, 1, N'Steve Harris', 293407, 11737216, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1394, N'The Prisoner', 112, 1, 3, N'Adrian Smith/Steve Harris', 361299, 5062906, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1395, N'Sign Of The Cross', 113, 1, 1, N'Steve Harris', 678008, 27121792, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1396, N'Lord Of The Flies', 113, 1, 1, N'Janick Gers/Steve Harris', 303699, 12148864, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1397, N'Man On The Edge', 113, 1, 1, N'Blaze Bayley/Janick Gers', 253413, 10137728, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1398, N'Fortunes Of War', 113, 1, 1, N'Steve Harris', 443977, 17760384, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1399, N'Look For The Truth', 113, 1, 1, N'Blaze Bayley/Janick Gers/Steve Harris', 310230, 12411008, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1400, N'The Aftermath', 113, 1, 1, N'Blaze Bayley/Janick Gers/Steve Harris', 380786, 15233152, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1401, N'Judgement Of Heaven', 113, 1, 1, N'Steve Harris', 312476, 12501120, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1402, N'Blood On The World''s Hands', 113, 1, 1, N'Steve Harris', 357799, 14313600, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1403, N'The Edge Of Darkness', 113, 1, 1, N'Blaze Bayley/Janick Gers/Steve Harris', 399333, 15974528, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1404, N'2 A.M.', 113, 1, 1, N'Blaze Bayley/Janick Gers/Steve Harris', 337658, 13511087, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1405, N'The Unbeliever', 113, 1, 1, N'Janick Gers/Steve Harris', 490422, 19617920, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1406, N'Futureal', 114, 1, 1, N'Blaze Bayley/Steve Harris', 175777, 7032960, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1407, N'The Angel And The Gambler', 114, 1, 1, N'Steve Harris', 592744, 23711872, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1408, N'Lightning Strikes Twice', 114, 1, 1, N'David Murray/Steve Harris', 290377, 11616384, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1409, N'The Clansman', 114, 1, 1, N'Steve Harris', 539689, 21592327, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1410, N'When Two Worlds Collide', 114, 1, 1, N'Blaze Bayley/David Murray/Steve Harris', 377312, 15093888, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1411, N'The Educated Fool', 114, 1, 1, N'Steve Harris', 404767, 16191616, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1412, N'Don''t Look To The Eyes Of A Stranger', 114, 1, 1, N'Steve Harris', 483657, 19347584, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1413, N'Como Estais Amigos', 114, 1, 1, N'Blaze Bayley/Janick Gers', 330292, 13213824, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1414, N'Please Please Please', 115, 1, 14, N'James Brown/Johnny Terry', 165067, 5394585, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1415, N'Think', 115, 1, 14, N'Lowman Pauling', 166739, 5513208, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1416, N'Night Train', 115, 1, 14, N'Jimmy Forrest/Lewis C. Simpkins/Oscar Washington', 212401, 7027377, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1417, N'Out Of Sight', 115, 1, 14, N'Ted Wright', 143725, 4711323, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1418, N'Papa''s Got A Brand New Bag Pt.1', 115, 1, 14, N'James Brown', 127399, 4174420, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1419, N'I Got You (I Feel Good)', 115, 1, 14, N'James Brown', 167392, 5468472, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1420, N'It''s A Man''s Man''s Man''s World', 115, 1, 14, N'Betty Newsome/James Brown', 168228, 5541611, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1421, N'Cold Sweat', 115, 1, 14, N'Alfred Ellis/James Brown', 172408, 5643213, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1422, N'Say It Loud, I''m Black And I''m Proud Pt.1', 115, 1, 14, N'Alfred Ellis/James Brown', 167392, 5478117, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1423, N'Get Up (I Feel Like Being A) Sex Machine', 115, 1, 14, N'Bobby Byrd/James Brown/Ron Lenhoff', 316551, 10498031, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1424, N'Hey America', 115, 1, 14, N'Addie William Jones/Nat Jones', 218226, 7187857, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1425, N'Make It Funky Pt.1', 115, 1, 14, N'Charles Bobbitt/James Brown', 196231, 6507782, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1426, N'I''m A Greedy Man Pt.1', 115, 1, 14, N'Charles Bobbitt/James Brown', 217730, 7251211, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1427, N'Get On The Good Foot', 115, 1, 14, N'Fred Wesley/James Brown/Joseph Mims', 215902, 7182736, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1428, N'Get Up Offa That Thing', 115, 1, 14, N'Deanna Brown/Deidra Jenkins/Yamma Brown', 250723, 8355989, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1429, N'It''s Too Funky In Here', 115, 1, 14, N'Brad Shapiro/George Jackson/Robert Miller/Walter Shaw', 239072, 7973979, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1430, N'Living In America', 115, 1, 14, N'Charlie Midnight/Dan Hartman', 282880, 9432346, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1431, N'I''m Real', 115, 1, 14, N'Full Force/James Brown', 334236, 11183457, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1432, N'Hot Pants Pt.1', 115, 1, 14, N'Fred Wesley/James Brown', 188212, 6295110, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1433, N'Soul Power (Live)', 115, 1, 14, N'James Brown', 260728, 8593206, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1434, N'When You Gonna Learn (Digeridoo)', 116, 1, 1, N'Jay Kay/Kay, Jay', 230635, 7655482, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1435, N'Too Young To Die', 116, 1, 1, N'Smith, Toby', 365818, 12391660, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1436, N'Hooked Up', 116, 1, 1, N'Smith, Toby', 275879, 9301687, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1437, N'If I Like It, I Do It', 116, 1, 1, N'Gelder, Nick van', 293093, 9848207, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1438, N'Music Of The Wind', 116, 1, 1, N'Smith, Toby', 383033, 12870239, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1439, N'Emergency On Planet Earth', 116, 1, 1, N'Smith, Toby', 245263, 8117218, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1440, N'Whatever It Is, I Just Can''t Stop', 116, 1, 1, N'Jay Kay/Kay, Jay', 247222, 8249453, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1441, N'Blow Your Mind', 116, 1, 1, N'Smith, Toby', 512339, 17089176, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1442, N'Revolution 1993', 116, 1, 1, N'Smith, Toby', 616829, 20816872, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1443, N'Didgin'' Out', 116, 1, 1, N'Buchanan, Wallis', 157100, 5263555, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1444, N'Canned Heat', 117, 1, 14, N'Jay Kay', 331964, 11042037, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1445, N'Planet Home', 117, 1, 14, N'Jay Kay/Toby Smith', 284447, 9566237, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1446, N'Black Capricorn Day', 117, 1, 14, N'Jay Kay', 341629, 11477231, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1447, N'Soul Education', 117, 1, 14, N'Jay Kay/Toby Smith', 255477, 8575435, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1448, N'Failling', 117, 1, 14, N'Jay Kay/Toby Smith', 225227, 7503999, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1449, N'Destitute Illusions', 117, 1, 14, N'Derrick McKenzie/Jay Kay/Toby Smith', 340218, 11452651, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1450, N'Supersonic', 117, 1, 14, N'Jay Kay', 315872, 10699265, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1451, N'Butterfly', 117, 1, 14, N'Jay Kay/Toby Smith', 268852, 8947356, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1452, N'Were Do We Go From Here', 117, 1, 14, N'Jay Kay', 313626, 10504158, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1453, N'King For A Day', 117, 1, 14, N'Jay Kay/Toby Smith', 221544, 7335693, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1454, N'Deeper Underground', 117, 1, 14, N'Toby Smith', 281808, 9351277, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1455, N'Just Another Story', 118, 1, 15, N'Toby Smith', 529684, 17582818, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1456, N'Stillness In Time', 118, 1, 15, N'Toby Smith', 257097, 8644290, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1457, N'Half The Man', 118, 1, 15, N'Toby Smith', 289854, 9577679, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1458, N'Light Years', 118, 1, 15, N'Toby Smith', 354560, 11796244, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1459, N'Manifest Destiny', 118, 1, 15, N'Toby Smith', 382197, 12676962, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1460, N'The Kids', 118, 1, 15, N'Toby Smith', 309995, 10334529, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1461, N'Mr. Moon', 118, 1, 15, N'Stuard Zender/Toby Smith', 329534, 11043559, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1462, N'Scam', 118, 1, 15, N'Stuart Zender', 422321, 14019705, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1463, N'Journey To Arnhemland', 118, 1, 15, N'Toby Smith/Wallis Buchanan', 322455, 10843832, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1464, N'Morning Glory', 118, 1, 15, N'J. Kay/Jay Kay', 384130, 12777210, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1465, N'Space Cowboy', 118, 1, 15, N'J. Kay/Jay Kay', 385697, 12906520, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1466, N'Last Chance', 119, 1, 4, N'C. Cester/C. Muncey', 112352, 3683130, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1467, N'Are You Gonna Be My Girl', 119, 1, 4, N'C. Muncey/N. Cester', 213890, 6992324, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1468, N'Rollover D.J.', 119, 1, 4, N'C. Cester/N. Cester', 196702, 6406517, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1469, N'Look What You''ve Done', 119, 1, 4, N'N. Cester', 230974, 7517083, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1470, N'Get What You Need', 119, 1, 4, N'C. Cester/C. Muncey/N. Cester', 247719, 8043765, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1471, N'Move On', 119, 1, 4, N'C. Cester/N. Cester', 260623, 8519353, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1472, N'Radio Song', 119, 1, 4, N'C. Cester/C. Muncey/N. Cester', 272117, 8871509, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1473, N'Get Me Outta Here', 119, 1, 4, N'C. Cester/N. Cester', 176274, 5729098, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1474, N'Cold Hard Bitch', 119, 1, 4, N'C. Cester/C. Muncey/N. Cester', 243278, 7929610, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1475, N'Come Around Again', 119, 1, 4, N'C. Muncey/N. Cester', 270497, 8872405, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1476, N'Take It Or Leave It', 119, 1, 4, N'C. Muncey/N. Cester', 142889, 4643370, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1477, N'Lazy Gun', 119, 1, 4, N'C. Cester/N. Cester', 282174, 9186285, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1478, N'Timothy', 119, 1, 4, N'C. Cester', 270341, 8856507, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1479, N'Foxy Lady', 120, 1, 1, N'Jimi Hendrix', 199340, 6480896, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1480, N'Manic Depression', 120, 1, 1, N'Jimi Hendrix', 222302, 7289272, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1481, N'Red House', 120, 1, 1, N'Jimi Hendrix', 224130, 7285851, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1482, N'Can You See Me', 120, 1, 1, N'Jimi Hendrix', 153077, 4987068, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1483, N'Love Or Confusion', 120, 1, 1, N'Jimi Hendrix', 193123, 6329408, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1484, N'I Don''t Live Today', 120, 1, 1, N'Jimi Hendrix', 235311, 7661214, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1485, N'May This Be Love', 120, 1, 1, N'Jimi Hendrix', 191216, 6240028, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1486, N'Fire', 120, 1, 1, N'Jimi Hendrix', 164989, 5383075, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1487, N'Third Stone From The Sun', 120, 1, 1, N'Jimi Hendrix', 404453, 13186975, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1488, N'Remember', 120, 1, 1, N'Jimi Hendrix', 168150, 5509613, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1489, N'Are You Experienced?', 120, 1, 1, N'Jimi Hendrix', 254537, 8292497, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1490, N'Hey Joe', 120, 1, 1, N'Billy Roberts', 210259, 6870054, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1491, N'Stone Free', 120, 1, 1, N'Jimi Hendrix', 216293, 7002331, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1492, N'Purple Haze', 120, 1, 1, N'Jimi Hendrix', 171572, 5597056, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1493, N'51st Anniversary', 120, 1, 1, N'Jimi Hendrix', 196388, 6398044, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1494, N'The Wind Cries Mary', 120, 1, 1, N'Jimi Hendrix', 200463, 6540638, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1495, N'Highway Chile', 120, 1, 1, N'Jimi Hendrix', 212453, 6887949, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1496, N'Surfing with the Alien', 121, 2, 1, 263707, 4418504, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1497, N'Ice 9', 121, 2, 1, 239721, 4036215, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1498, N'Crushing Day', 121, 2, 1, 314768, 5232158, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1499, N'Always With Me, Always With You', 121, 2, 1, 202035, 3435777, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1500, N'Satch Boogie', 121, 2, 1, 193560, 3300654, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1501, N'Hill of the Skull', 121, 2, 1, N'J. Satriani', 108435, 1944738, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1502, N'Circles', 121, 2, 1, 209071, 3548553, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1503, N'Lords of Karma', 121, 2, 1, N'J. Satriani', 288227, 4809279, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1504, N'Midnight', 121, 2, 1, N'J. Satriani', 102630, 1851753, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1505, N'Echo', 121, 2, 1, N'J. Satriani', 337570, 5595557, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1506, N'Engenho De Dentro', 122, 1, 7, 310073, 10211473, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1507, N'Alcohol', 122, 1, 7, 355239, 12010478, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1508, N'Mama Africa', 122, 1, 7, 283062, 9488316, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1509, N'Salve Simpatia', 122, 1, 7, 343484, 11314756, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1510, N'W/Brasil (Chama O Síndico)', 122, 1, 7, 317100, 10599953, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1511, N'País Tropical', 122, 1, 7, 452519, 14946972, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1512, N'Os Alquimistas Estão Chegando', 122, 1, 7, 367281, 12304520, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1513, N'Charles Anjo 45', 122, 1, 7, 389276, 13022833, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1514, N'Selassiê', 122, 1, 7, 326321, 10724982, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1515, N'Menina Sarará', 122, 1, 7, 191477, 6393818, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1516, N'Que Maravilha', 122, 1, 7, 338076, 10996656, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1517, N'Santa Clara Clareou', 122, 1, 7, 380081, 12524725, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1518, N'Filho Maravilha', 122, 1, 7, 227526, 7498259, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1519, N'Taj Mahal', 122, 1, 7, 289750, 9502898, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1520, N'Rapidamente', 123, 1, 7, 252238, 8470107, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1521, N'As Dores do Mundo', 123, 1, 7, N'Hyldon', 255477, 8537092, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1522, N'Vou Pra Ai', 123, 1, 7, 300878, 10053718, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1523, N'My Brother', 123, 1, 7, 253231, 8431821, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1524, N'Há Quanto Tempo', 123, 1, 7, 270027, 9004470, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1525, N'Vício', 123, 1, 7, 269897, 8887216, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1526, N'Encontrar Alguém', 123, 1, 7, N'Marco Tulio Lara/Rogerio Flausino', 224078, 7437935, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1527, N'Dance Enquanto é Tempo', 123, 1, 7, 229093, 7583799, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1528, N'A Tarde', 123, 1, 7, 266919, 8836127, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1529, N'Always Be All Right', 123, 1, 7, 128078, 4299676, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1530, N'Sem Sentido', 123, 1, 7, 250462, 8292108, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1531, N'Onibusfobia', 123, 1, 7, 315977, 10474904, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1532, N'Pura Elegancia', 124, 1, 16, N'João Suplicy', 284107, 9632269, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1533, N'Choramingando', 124, 1, 16, N'João Suplicy', 190484, 6400532, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1534, N'Por Merecer', 124, 1, 16, N'João Suplicy', 230582, 7764601, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1535, N'No Futuro', 124, 1, 16, N'João Suplicy', 182308, 6056200, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1536, N'Voce Inteira', 124, 1, 16, N'João Suplicy', 241084, 8077282, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1537, N'Cuando A Noite Vai Chegando', 124, 1, 16, N'João Suplicy', 270628, 9081874, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1538, N'Naquele Dia', 124, 1, 16, N'João Suplicy', 251768, 8452654, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1539, N'Equinocio', 124, 1, 16, N'João Suplicy', 269008, 8871455, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1540, N'Papelão', 124, 1, 16, N'João Suplicy', 213263, 7257390, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1541, N'Cuando Eu For Pro Ceu', 124, 1, 16, N'João Suplicy', 118804, 3948371, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1542, N'Do Nosso Amor', 124, 1, 16, N'João Suplicy', 203415, 6774566, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1543, N'Borogodo', 124, 1, 16, N'João Suplicy', 208457, 7104588, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1544, N'Cafezinho', 124, 1, 16, N'João Suplicy', 180924, 6031174, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1545, N'Enquanto O Dia Não Vem', 124, 1, 16, N'João Suplicy', 220891, 7248336, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1546, N'The Green Manalishi', 125, 1, 3, 205792, 6720789, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1547, N'Living After Midnight', 125, 1, 3, 213289, 7056785, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1548, N'Breaking The Law (Live)', 125, 1, 3, 144195, 4728246, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1549, N'Hot Rockin''', 125, 1, 3, 197328, 6509179, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1550, N'Heading Out To The Highway (Live)', 125, 1, 3, 276427, 9006022, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1551, N'The Hellion', 125, 1, 3, 41900, 1351993, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1552, N'Electric Eye', 125, 1, 3, 222197, 7231368, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1553, N'You''ve Got Another Thing Comin''', 125, 1, 3, 305162, 9962558, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1554, N'Turbo Lover', 125, 1, 3, 335542, 11068866, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1555, N'Freewheel Burning', 125, 1, 3, 265952, 8713599, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1556, N'Some Heads Are Gonna Roll', 125, 1, 3, 249939, 8198617, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1557, N'Metal Meltdown', 125, 1, 3, 290664, 9390646, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1558, N'Ram It Down', 125, 1, 3, 292179, 9554023, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1559, N'Diamonds And Rust (Live)', 125, 1, 3, 219350, 7163147, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1560, N'Victim Of Change (Live)', 125, 1, 3, 430942, 14067512, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1561, N'Tyrant (Live)', 125, 1, 3, 282253, 9190536, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1562, N'Comin'' Home', 126, 1, 1, N'Paul Stanley, Ace Frehley', 172068, 5661120, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1563, N'Plaster Caster', 126, 1, 1, N'Gene Simmons', 198060, 6528719, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1564, N'Goin'' Blind', 126, 1, 1, N'Gene Simmons, Stephen Coronel', 217652, 7167523, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1565, N'Do You Love Me', 126, 1, 1, N'Paul Stanley, Bob Ezrin, Kim Fowley', 193619, 6343111, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1566, N'Domino', 126, 1, 1, N'Gene Simmons', 226377, 7488191, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1567, N'Sure Know Something', 126, 1, 1, N'Paul Stanley, Vincent Poncia', 254354, 8375190, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1568, N'A World Without Heroes', 126, 1, 1, N'Paul Stanley, Gene Simmons, Bob Ezrin, Lewis Reed', 177815, 5832524, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1569, N'Rock Bottom', 126, 1, 1, N'Paul Stanley, Ace Frehley', 200594, 6560818, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1570, N'See You Tonight', 126, 1, 1, N'Gene Simmons', 146494, 4817521, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1571, N'I Still Love You', 126, 1, 1, N'Paul Stanley', 369815, 12086145, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1572, N'Every Time I Look At You', 126, 1, 1, N'Paul Stanley, Vincent Cusano', 283898, 9290948, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1573, N'2,000 Man', 126, 1, 1, N'Mick Jagger, Keith Richard', 312450, 10292829, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1574, N'Beth', 126, 1, 1, N'Peter Criss, Stan Penridge, Bob Ezrin', 170187, 5577807, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1575, N'Nothin'' To Lose', 126, 1, 1, N'Gene Simmons', 222354, 7351460, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1576, N'Rock And Roll All Nite', 126, 1, 1, N'Paul Stanley, Gene Simmons', 259631, 8549296, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1577, N'Immigrant Song', 127, 1, 1, N'Robert Plant', 201247, 6457766, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1578, N'Heartbreaker', 127, 1, 1, N'John Bonham/John Paul Jones/Robert Plant', 316081, 10179657, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1579, N'Since I''ve Been Loving You', 127, 1, 1, N'John Paul Jones/Robert Plant', 416365, 13471959, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1580, N'Black Dog', 127, 1, 1, N'John Paul Jones/Robert Plant', 317622, 10267572, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1581, N'Dazed And Confused', 127, 1, 1, N'Jimmy Page/Led Zeppelin', 1116734, 36052247, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1582, N'Stairway To Heaven', 127, 1, 1, N'Robert Plant', 529658, 17050485, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1583, N'Going To California', 127, 1, 1, N'Robert Plant', 234605, 7646749, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1584, N'That''s The Way', 127, 1, 1, N'Robert Plant', 343431, 11248455, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1585, N'Whole Lotta Love (Medley)', 127, 1, 1, N'Arthur Crudup/Bernard Besman/Bukka White/Doc Pomus/John Bonham/John Lee Hooker/John Paul Jones/Mort Shuman/Robert Plant/Willie Dixon', 825103, 26742545, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1586, N'Thank You', 127, 1, 1, N'Robert Plant', 398262, 12831826, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1587, N'We''re Gonna Groove', 128, 1, 1, N'Ben E.King/James Bethea', 157570, 5180975, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1588, N'Poor Tom', 128, 1, 1, N'Jimmy Page/Robert Plant', 182491, 6016220, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1589, N'I Can''t Quit You Baby', 128, 1, 1, N'Willie Dixon', 258168, 8437098, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1590, N'Walter''s Walk', 128, 1, 1, N'Jimmy Page, Robert Plant', 270785, 8712499, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1591, N'Ozone Baby', 128, 1, 1, N'Jimmy Page, Robert Plant', 215954, 7079588, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1592, N'Darlene', 128, 1, 1, N'Jimmy Page, Robert Plant, John Bonham, John Paul Jones', 307226, 10078197, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1593, N'Bonzo''s Montreux', 128, 1, 1, N'John Bonham', 258925, 8557447, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1594, N'Wearing And Tearing', 128, 1, 1, N'Jimmy Page, Robert Plant', 330004, 10701590, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1595, N'The Song Remains The Same', 129, 1, 1, N'Jimmy Page/Jimmy Page & Robert Plant/Robert Plant', 330004, 10708950, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1596, N'The Rain Song', 129, 1, 1, N'Jimmy Page/Jimmy Page & Robert Plant/Robert Plant', 459180, 15029875, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1597, N'Over The Hills And Far Away', 129, 1, 1, N'Jimmy Page/Jimmy Page & Robert Plant/Robert Plant', 290089, 9552829, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1598, N'The Crunge', 129, 1, 1, N'John Bonham/John Paul Jones', 197407, 6460212, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1599, N'Dancing Days', 129, 1, 1, N'Jimmy Page/Jimmy Page & Robert Plant/Robert Plant', 223216, 7250104, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1600, N'D''Yer Mak''er', 129, 1, 1, N'John Bonham/John Paul Jones', 262948, 8645935, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1601, N'No Quarter', 129, 1, 1, N'John Paul Jones', 420493, 13656517, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1602, N'The Ocean', 129, 1, 1, N'John Bonham/John Paul Jones', 271098, 8846469, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1603, N'In The Evening', 130, 1, 1, N'Jimmy Page, Robert Plant & John Paul Jones', 410566, 13399734, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1604, N'South Bound Saurez', 130, 1, 1, N'John Paul Jones & Robert Plant', 254406, 8420427, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1605, N'Fool In The Rain', 130, 1, 1, N'Jimmy Page, Robert Plant & John Paul Jones', 372950, 12371433, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1606, N'Hot Dog', 130, 1, 1, N'Jimmy Page & Robert Plant', 197198, 6536167, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1607, N'Carouselambra', 130, 1, 1, N'John Paul Jones, Jimmy Page & Robert Plant', 634435, 20858315, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1608, N'All My Love', 130, 1, 1, N'Robert Plant & John Paul Jones', 356284, 11684862, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1609, N'I''m Gonna Crawl', 130, 1, 1, N'Jimmy Page, Robert Plant & John Paul Jones', 329639, 10737665, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1610, N'Black Dog', 131, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones', 296672, 9660588, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1611, N'Rock & Roll', 131, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones, John Bonham', 220917, 7142127, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1612, N'The Battle Of Evermore', 131, 1, 1, N'Jimmy Page, Robert Plant', 351555, 11525689, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1613, N'Stairway To Heaven', 131, 1, 1, N'Jimmy Page, Robert Plant', 481619, 15706767, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1614, N'Misty Mountain Hop', 131, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones', 278857, 9092799, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1615, N'Four Sticks', 131, 1, 1, N'Jimmy Page, Robert Plant', 284447, 9481301, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1616, N'Going To California', 131, 1, 1, N'Jimmy Page, Robert Plant', 215693, 7068737, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1617, N'When The Levee Breaks', 131, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones, John Bonham, Memphis Minnie', 427702, 13912107, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1618, N'Good Times Bad Times', 132, 1, 1, N'Jimmy Page/John Bonham/John Paul Jones', 166164, 5464077, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1619, N'Babe I''m Gonna Leave You', 132, 1, 1, N'Jimmy Page/Robert Plant', 401475, 13189312, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1620, N'You Shook Me', 132, 1, 1, N'J. B. Lenoir/Willie Dixon', 388179, 12643067, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1621, N'Dazed and Confused', 132, 1, 1, N'Jimmy Page', 386063, 12610326, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1622, N'Your Time Is Gonna Come', 132, 1, 1, N'Jimmy Page/John Paul Jones', 274860, 9011653, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1623, N'Black Mountain Side', 132, 1, 1, N'Jimmy Page', 132702, 4440602, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1624, N'Communication Breakdown', 132, 1, 1, N'Jimmy Page/John Bonham/John Paul Jones', 150230, 4899554, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1625, N'I Can''t Quit You Baby', 132, 1, 1, N'Willie Dixon', 282671, 9252733, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1626, N'How Many More Times', 132, 1, 1, N'Jimmy Page/John Bonham/John Paul Jones', 508055, 16541364, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1627, N'Whole Lotta Love', 133, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones, John Bonham', 334471, 11026243, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1628, N'What Is And What Should Never Be', 133, 1, 1, N'Jimmy Page, Robert Plant', 287973, 9369385, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1629, N'The Lemon Song', 133, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones, John Bonham', 379141, 12463496, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1630, N'Thank You', 133, 1, 1, N'Jimmy Page, Robert Plant', 287791, 9337392, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1631, N'Heartbreaker', 133, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones, John Bonham', 253988, 8387560, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1632, N'Living Loving Maid (She''s Just A Woman)', 133, 1, 1, N'Jimmy Page, Robert Plant', 159216, 5219819, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1633, N'Ramble On', 133, 1, 1, N'Jimmy Page, Robert Plant', 275591, 9199710, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1634, N'Moby Dick', 133, 1, 1, N'John Bonham, John Paul Jones, Jimmy Page', 260728, 8664210, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1635, N'Bring It On Home', 133, 1, 1, N'Jimmy Page, Robert Plant', 259970, 8494731, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1636, N'Immigrant Song', 134, 1, 1, N'Jimmy Page, Robert Plant', 144875, 4786461, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1637, N'Friends', 134, 1, 1, N'Jimmy Page, Robert Plant', 233560, 7694220, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1638, N'Celebration Day', 134, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones', 209528, 6871078, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1639, N'Since I''ve Been Loving You', 134, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones', 444055, 14482460, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1640, N'Out On The Tiles', 134, 1, 1, N'Jimmy Page, Robert Plant, John Bonham', 246047, 8060350, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1641, N'Gallows Pole', 134, 1, 1, N'Traditional', 296228, 9757151, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1642, N'Tangerine', 134, 1, 1, N'Jimmy Page', 189675, 6200893, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1643, N'That''s The Way', 134, 1, 1, N'Jimmy Page, Robert Plant', 337345, 11202499, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1644, N'Bron-Y-Aur Stomp', 134, 1, 1, N'Jimmy Page, Robert Plant, John Paul Jones', 259500, 8674508, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1645, N'Hats Off To (Roy) Harper', 134, 1, 1, N'Traditional', 219376, 7236640, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1646, N'In The Light', 135, 1, 1, N'John Paul Jones/Robert Plant', 526785, 17033046, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1647, N'Bron-Yr-Aur', 135, 1, 1, N'Jimmy Page', 126641, 4150746, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1648, N'Down By The Seaside', 135, 1, 1, N'Robert Plant', 316186, 10371282, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1649, N'Ten Years Gone', 135, 1, 1, N'Robert Plant', 393116, 12756366, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1650, N'Night Flight', 135, 1, 1, N'John Paul Jones/Robert Plant', 217547, 7160647, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1651, N'The Wanton Song', 135, 1, 1, N'Robert Plant', 249887, 8180988, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1652, N'Boogie With Stu', 135, 1, 1, N'Ian Stewart/John Bonham/John Paul Jones/Mrs. Valens/Robert Plant', 233273, 7657086, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1653, N'Black Country Woman', 135, 1, 1, N'Robert Plant', 273084, 8951732, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1654, N'Sick Again', 135, 1, 1, N'Robert Plant', 283036, 9279263, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1655, N'Achilles Last Stand', 136, 1, 1, N'Jimmy Page/Robert Plant', 625502, 20593955, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1656, N'For Your Life', 136, 1, 1, N'Jimmy Page/Robert Plant', 384391, 12633382, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1657, N'Royal Orleans', 136, 1, 1, N'John Bonham/John Paul Jones', 179591, 5930027, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1658, N'Nobody''s Fault But Mine', 136, 1, 1, N'Jimmy Page/Robert Plant', 376215, 12237859, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1659, N'Candy Store Rock', 136, 1, 1, N'Jimmy Page/Robert Plant', 252055, 8397423, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1660, N'Hots On For Nowhere', 136, 1, 1, N'Jimmy Page/Robert Plant', 284107, 9342342, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1661, N'Tea For One', 136, 1, 1, N'Jimmy Page/Robert Plant', 566752, 18475264, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1662, N'Rock & Roll', 137, 1, 1, N'John Bonham/John Paul Jones/Robert Plant', 242442, 7897065, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1663, N'Celebration Day', 137, 1, 1, N'John Paul Jones/Robert Plant', 230034, 7478487, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1664, N'The Song Remains The Same', 137, 1, 1, N'Robert Plant', 353358, 11465033, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1665, N'Rain Song', 137, 1, 1, N'Robert Plant', 505808, 16273705, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1666, N'Dazed And Confused', 137, 1, 1, N'Jimmy Page', 1612329, 52490554, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1667, N'No Quarter', 138, 1, 1, N'John Paul Jones/Robert Plant', 749897, 24399285, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1668, N'Stairway To Heaven', 138, 1, 1, N'Robert Plant', 657293, 21354766, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1669, N'Moby Dick', 138, 1, 1, N'John Bonham/John Paul Jones', 766354, 25345841, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1670, N'Whole Lotta Love', 138, 1, 1, N'John Bonham/John Paul Jones/Robert Plant/Willie Dixon', 863895, 28191437, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1671, N'Natália', 139, 1, 7, N'Renato Russo', 235728, 7640230, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1672, N'L''Avventura', 139, 1, 7, N'Renato Russo', 278256, 9165769, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1673, N'Música De Trabalho', 139, 1, 7, N'Renato Russo', 260231, 8590671, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1674, N'Longe Do Meu Lado', 139, 1, 7, N'Renato Russo - Marcelo Bonfá', 266161, 8655249, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1675, N'A Via Láctea', 139, 1, 7, N'Renato Russo', 280084, 9234879, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1676, N'Música Ambiente', 139, 1, 7, N'Renato Russo', 247614, 8234388, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1677, N'Aloha', 139, 1, 7, N'Renato Russo', 325955, 10793301, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1678, N'Soul Parsifal', 139, 1, 7, N'Renato Russo - Marisa Monte', 295053, 9853589, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1679, N'Dezesseis', 139, 1, 7, N'Renato Russo', 323918, 10573515, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1680, N'Mil Pedaços', 139, 1, 7, N'Renato Russo', 203337, 6643291, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1681, N'Leila', 139, 1, 7, N'Renato Russo', 323056, 10608239, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1682, N'1º De Julho', 139, 1, 7, N'Renato Russo', 290298, 9619257, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1683, N'Esperando Por Mim', 139, 1, 7, N'Renato Russo', 261668, 8844133, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1684, N'Quando Você Voltar', 139, 1, 7, N'Renato Russo', 173897, 5781046, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1685, N'O Livro Dos Dias', 139, 1, 7, N'Renato Russo', 257253, 8570929, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1686, N'Será', 140, 1, 7, N'Dado Villa-Lobos/Marcelo Bonfá', 148401, 4826528, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1687, N'Ainda É Cedo', 140, 1, 7, N'Dado Villa-Lobos/Ico Ouro-Preto/Marcelo Bonfá', 236826, 7796400, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1688, N'Geração Coca-Cola', 140, 1, 7, N'Renato Russo', 141453, 4625731, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1689, N'Eduardo E Mônica', 140, 1, 7, N'Renato Russo', 271229, 9026691, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1690, N'Tempo Perdido', 140, 1, 7, N'Renato Russo', 302158, 9963914, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1691, N'Indios', 140, 1, 7, N'Renato Russo', 258168, 8610226, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1692, N'Que País É Este', 140, 1, 7, N'Renato Russo', 177606, 5822124, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1693, N'Faroeste Caboclo', 140, 1, 7, N'Renato Russo', 543007, 18092739, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1694, N'Há Tempos', 140, 1, 7, N'Dado Villa-Lobos/Marcelo Bonfá', 197146, 6432922, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1695, N'Pais E Filhos', 140, 1, 7, N'Dado Villa-Lobos/Marcelo Bonfá', 308401, 10130685, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1696, N'Meninos E Meninas', 140, 1, 7, N'Dado Villa-Lobos/Marcelo Bonfá', 203781, 6667802, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1697, N'Vento No Litoral', 140, 1, 7, N'Dado Villa-Lobos/Marcelo Bonfá', 366445, 12063806, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1698, N'Perfeição', 140, 1, 7, N'Dado Villa-Lobos/Marcelo Bonfá', 276558, 9258489, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1699, N'Giz', 140, 1, 7, N'Dado Villa-Lobos/Marcelo Bonfá', 202213, 6677671, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1700, N'Dezesseis', 140, 1, 7, N'Dado Villa-Lobos/Marcelo Bonfá', 321724, 10501773, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1701, N'Antes Das Seis', 140, 1, 7, N'Dado Villa-Lobos', 189231, 6296531, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1702, N'Are You Gonna Go My Way', 141, 1, 1, N'Craig Ross/Lenny Kravitz', 211591, 6905135, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1703, N'Fly Away', 141, 1, 1, N'Lenny Kravitz', 221962, 7322085, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1704, N'Rock And Roll Is Dead', 141, 1, 1, N'Lenny Kravitz', 204199, 6680312, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1705, N'Again', 141, 1, 1, N'Lenny Kravitz', 228989, 7490476, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1706, N'It Ain''t Over ''Til It''s Over', 141, 1, 1, N'Lenny Kravitz', 242703, 8078936, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1707, N'Can''t Get You Off My Mind', 141, 1, 1, N'Lenny Kravitz', 273815, 8937150, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1708, N'Mr. Cab Driver', 141, 1, 1, N'Lenny Kravitz', 230321, 7668084, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1709, N'American Woman', 141, 1, 1, N'B. Cummings/G. Peterson/M.J. Kale/R. Bachman', 261773, 8538023, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1710, N'Stand By My Woman', 141, 1, 1, N'Henry Kirssch/Lenny Kravitz/S. Pasch A. Krizan', 259683, 8447611, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1711, N'Always On The Run', 141, 1, 1, N'Lenny Kravitz/Slash', 232515, 7593397, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1712, N'Heaven Help', 141, 1, 1, N'Gerry DeVeaux/Terry Britten', 190354, 6222092, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1713, N'I Belong To You', 141, 1, 1, N'Lenny Kravitz', 257123, 8477980, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1714, N'Believe', 141, 1, 1, N'Henry Hirsch/Lenny Kravitz', 295131, 9661978, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1715, N'Let Love Rule', 141, 1, 1, N'Lenny Kravitz', 342648, 11298085, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1716, N'Black Velveteen', 141, 1, 1, N'Lenny Kravitz', 290899, 9531301, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1717, N'Assim Caminha A Humanidade', 142, 1, 7, 210755, 6993763, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1718, N'Honolulu', 143, 1, 7, 261433, 8558481, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1719, N'Dancin´Days', 143, 1, 7, 237400, 7875347, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1720, N'Um Pro Outro', 142, 1, 7, 236382, 7825215, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1721, N'Aviso Aos Navegantes', 143, 1, 7, 242808, 8058651, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1722, N'Casa', 142, 1, 7, 307591, 10107269, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1723, N'Condição', 142, 1, 7, 263549, 8778465, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1724, N'Hyperconectividade', 143, 1, 7, 180636, 5948039, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1725, N'O Descobridor Dos Sete Mares', 143, 1, 7, 225854, 7475780, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1726, N'Satisfação', 142, 1, 7, 208065, 6901681, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1727, N'Brumário', 142, 1, 7, 216241, 7243499, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1728, N'Um Certo Alguém', 143, 1, 7, 194063, 6430939, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1729, N'Fullgás', 143, 1, 7, 346070, 11505484, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1730, N'Sábado À Noite', 142, 1, 7, 193854, 6435114, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1731, N'A Cura', 142, 1, 7, 280920, 9260588, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1732, N'Aquilo', 143, 1, 7, 246073, 8167819, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1733, N'Atrás Do Trio Elétrico', 142, 1, 7, 149080, 4917615, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1734, N'Senta A Pua', 143, 1, 7, 217547, 7205844, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1735, N'Ro-Que-Se-Da-Ne', 143, 1, 7, 146703, 4805897, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1736, N'Tudo Bem', 142, 1, 7, 196101, 6419139, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1737, N'Toda Forma De Amor', 142, 1, 7, 227813, 7496584, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1738, N'Tudo Igual', 143, 1, 7, 276035, 9201645, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1739, N'Fogo De Palha', 143, 1, 7, 246804, 8133732, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1740, N'Sereia', 142, 1, 7, 278047, 9121087, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1741, N'Assaltaram A Gramática', 143, 1, 7, 261041, 8698959, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1742, N'Se Você Pensa', 142, 1, 7, 195996, 6552490, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1743, N'Lá Vem O Sol (Here Comes The Sun)', 142, 1, 7, 189492, 6229645, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1744, N'O Último Romântico (Ao Vivo)', 143, 1, 7, 231993, 7692697, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1745, N'Pseudo Silk Kimono', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 134739, 4334038, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1746, N'Kayleigh', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 234605, 7716005, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1747, N'Lavender', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 153417, 4999814, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1748, N'Bitter Suite: Brief Encounter / Lost Weekend / Blue Angel', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 356493, 11791068, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1749, N'Heart Of Lothian: Wide Boy / Curtain Call', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 366053, 11893723, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1750, N'Waterhole (Expresso Bongo)', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 133093, 4378835, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1751, N'Lords Of The Backstage', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 112875, 3741319, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1752, N'Blind Curve: Vocal Under A Bloodlight / Passing Strangers / Mylo / Perimeter Walk / Threshold', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 569704, 18578995, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1753, N'Childhoods End?', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 272796, 9015366, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1754, N'White Feather', 144, 1, 1, N'Kelly, Mosley, Rothery, Trewaves', 143595, 4711776, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1755, N'Arrepio', 145, 1, 7, N'Carlinhos Brown', 136254, 4511390, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1756, N'Magamalabares', 145, 1, 7, N'Carlinhos Brown', 215875, 7183757, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1757, N'Chuva No Brejo', 145, 1, 7, N'Morais', 145606, 4857761, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1758, N'Cérebro Eletrônico', 145, 1, 7, N'Gilberto Gil', 172800, 5760864, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1759, N'Tempos Modernos', 145, 1, 7, N'Lulu Santos', 183066, 6066234, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1760, N'Maraçá', 145, 1, 7, N'Carlinhos Brown', 230008, 7621482, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1761, N'Blanco', 145, 1, 7, N'Marisa Monte/poema de Octavio Paz/versão: Haroldo de Campos', 45191, 1454532, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1762, N'Panis Et Circenses', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 192339, 6318373, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1763, N'De Noite Na Cama', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 209005, 7012658, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1764, N'Beija Eu', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 197276, 6512544, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1765, N'Give Me Love', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 249808, 8196331, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1766, N'Ainda Lembro', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 218801, 7211247, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1767, N'A Menina Dança', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 129410, 4326918, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1768, N'Dança Da Solidão', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 203520, 6699368, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1769, N'Ao Meu Redor', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 275591, 9158834, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1770, N'Bem Leve', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 159190, 5246835, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1771, N'Segue O Seco', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 178207, 5922018, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1772, N'O Xote Das Meninas', 145, 1, 7, N'Caetano Veloso e Gilberto Gil', 291866, 9553228, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1773, N'Wherever I Lay My Hat', 146, 1, 14, 136986, 4477321, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1774, N'Get My Hands On Some Lovin''', 146, 1, 14, 149054, 4860380, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1775, N'No Good Without You', 146, 1, 14, N'William "Mickey" Stevenson', 161410, 5259218, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1776, N'You''ve Been A Long Time Coming', 146, 1, 14, N'Brian Holland/Eddie Holland/Lamont Dozier', 137221, 4437949, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1777, N'When I Had Your Love', 146, 1, 14, N'Robert Rogers/Warren "Pete" Moore/William "Mickey" Stevenson', 152424, 4972815, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1778, N'You''re What''s Happening (In The World Today)', 146, 1, 14, N'Allen Story/George Gordy/Robert Gordy', 142027, 4631104, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1779, N'Loving You Is Sweeter Than Ever', 146, 1, 14, N'Ivy Hunter/Stevie Wonder', 166295, 5377546, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1780, N'It''s A Bitter Pill To Swallow', 146, 1, 14, N'Smokey Robinson/Warren "Pete" Moore', 194821, 6477882, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1781, N'Seek And You Shall Find', 146, 1, 14, N'Ivy Hunter/William "Mickey" Stevenson', 223451, 7306719, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1782, N'Gonna Keep On Tryin'' Till I Win Your Love', 146, 1, 14, N'Barrett Strong/Norman Whitfield', 176404, 5789945, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1783, N'Gonna Give Her All The Love I''ve Got', 146, 1, 14, N'Barrett Strong/Norman Whitfield', 210886, 6893603, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1784, N'I Wish It Would Rain', 146, 1, 14, N'Barrett Strong/Norman Whitfield/Roger Penzabene', 172486, 5647327, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1785, N'Abraham, Martin And John', 146, 1, 14, N'Dick Holler', 273057, 8888206, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1786, N'Save The Children', 146, 1, 14, N'Al Cleveland/Marvin Gaye/Renaldo Benson', 194821, 6342021, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1787, N'You Sure Love To Ball', 146, 1, 14, N'Marvin Gaye', 218540, 7217872, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1788, N'Ego Tripping Out', 146, 1, 14, N'Marvin Gaye', 314514, 10383887, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1789, N'Praise', 146, 1, 14, N'Marvin Gaye', 235833, 7839179, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1790, N'Heavy Love Affair', 146, 1, 14, N'Marvin Gaye', 227892, 7522232, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1791, N'Down Under', 147, 1, 1, 222171, 7366142, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1792, N'Overkill', 147, 1, 1, 225410, 7408652, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1793, N'Be Good Johnny', 147, 1, 1, 216320, 7139814, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1794, N'Everything I Need', 147, 1, 1, 216476, 7107625, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1795, N'Down by the Sea', 147, 1, 1, 408163, 13314900, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1796, N'Who Can It Be Now?', 147, 1, 1, 202396, 6682850, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1797, N'It''s a Mistake', 147, 1, 1, 273371, 8979965, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1798, N'Dr. Heckyll & Mr. Jive', 147, 1, 1, 278465, 9110403, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1799, N'Shakes and Ladders', 147, 1, 1, 198008, 6560753, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (1800, N'No Sign of Yesterday', 147, 1, 1, 362004, 11829011, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1801, N'Enter Sandman', 148, 1, 3, N'James Hetfield, Lars Ulrich and Kirk Hammett', 332251, 10852002, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1802, N'Sad But True', 148, 1, 3, N'Ulrich', 324754, 10541258, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1803, N'Holier Than Thou', 148, 1, 3, N'Ulrich', 227892, 7462011, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1804, N'The Unforgiven', 148, 1, 3, N'James Hetfield, Lars Ulrich and Kirk Hammett', 387082, 12646886, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1805, N'Wherever I May Roam', 148, 1, 3, N'Ulrich', 404323, 13161169, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1806, N'Don''t Tread On Me', 148, 1, 3, N'Ulrich', 240483, 7827907, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1807, N'Through The Never', 148, 1, 3, N'James Hetfield, Lars Ulrich and Kirk Hammett', 244375, 8024047, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1808, N'Nothing Else Matters', 148, 1, 3, N'Ulrich', 388832, 12606241, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1809, N'Of Wolf And Man', 148, 1, 3, N'James Hetfield, Lars Ulrich and Kirk Hammett', 256835, 8339785, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1810, N'The God That Failed', 148, 1, 3, N'Ulrich', 308610, 10055959, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1811, N'My Friend Of Misery', 148, 1, 3, N'James Hetfield, Lars Ulrich and Jason Newsted', 409547, 13293515, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1812, N'The Struggle Within', 148, 1, 3, N'Ulrich', 234240, 7654052, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1813, N'Helpless', 149, 1, 3, N'Harris/Tatler', 398315, 12977902, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1814, N'The Small Hours', 149, 1, 3, N'Holocaust', 403435, 13215133, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1815, N'The Wait', 149, 1, 3, N'Killing Joke', 295418, 9688418, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1816, N'Crash Course In Brain Surgery', 149, 1, 3, N'Bourge/Phillips/Shelley', 190406, 6233729, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1817, N'Last Caress/Green Hell', 149, 1, 3, N'Danzig', 209972, 6854313, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1818, N'Am I Evil?', 149, 1, 3, N'Harris/Tatler', 470256, 15387219, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1819, N'Blitzkrieg', 149, 1, 3, N'Jones/Sirotto/Smith', 216685, 7090018, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1820, N'Breadfan', 149, 1, 3, N'Bourge/Phillips/Shelley', 341551, 11100130, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1821, N'The Prince', 149, 1, 3, N'Harris/Tatler', 265769, 8624492, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1822, N'Stone Cold Crazy', 149, 1, 3, N'Deacon/May/Mercury/Taylor', 137717, 4514830, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1823, N'So What', 149, 1, 3, N'Culmer/Exalt', 189152, 6162894, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1824, N'Killing Time', 149, 1, 3, N'Sweet Savage', 183693, 6021197, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1825, N'Overkill', 149, 1, 3, N'Clarke/Kilmister/Tayler', 245133, 7971330, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1826, N'Damage Case', 149, 1, 3, N'Clarke/Farren/Kilmister/Tayler', 220212, 7212997, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1827, N'Stone Dead Forever', 149, 1, 3, N'Clarke/Kilmister/Tayler', 292127, 9556060, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1828, N'Too Late Too Late', 149, 1, 3, N'Clarke/Kilmister/Tayler', 192052, 6276291, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1829, N'Hit The Lights', 150, 1, 3, N'James Hetfield, Lars Ulrich', 257541, 8357088, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1830, N'The Four Horsemen', 150, 1, 3, N'James Hetfield, Lars Ulrich, Dave Mustaine', 433188, 14178138, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1831, N'Motorbreath', 150, 1, 3, N'James Hetfield', 188395, 6153933, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1832, N'Jump In The Fire', 150, 1, 3, N'James Hetfield, Lars Ulrich, Dave Mustaine', 281573, 9135755, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1833, N'(Anesthesia) Pulling Teeth', 150, 1, 3, N'Cliff Burton', 254955, 8234710, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1834, N'Whiplash', 150, 1, 3, N'James Hetfield, Lars Ulrich', 249208, 8102839, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1835, N'Phantom Lord', 150, 1, 3, N'James Hetfield, Lars Ulrich, Dave Mustaine', 302053, 9817143, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1836, N'No Remorse', 150, 1, 3, N'James Hetfield, Lars Ulrich', 386795, 12672166, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1837, N'Seek & Destroy', 150, 1, 3, N'James Hetfield, Lars Ulrich', 415817, 13452301, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1838, N'Metal Militia', 150, 1, 3, N'James Hetfield, Lars Ulrich, Dave Mustaine', 311327, 10141785, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1839, N'Ain''t My Bitch', 151, 1, 3, N'James Hetfield, Lars Ulrich', 304457, 9931015, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1840, N'2 X 4', 151, 1, 3, N'James Hetfield, Lars Ulrich, Kirk Hammett', 328254, 10732251, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1841, N'The House Jack Built', 151, 1, 3, N'James Hetfield, Lars Ulrich, Kirk Hammett', 398942, 13005152, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1842, N'Until It Sleeps', 151, 1, 3, N'James Hetfield, Lars Ulrich', 269740, 8837394, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1843, N'King Nothing', 151, 1, 3, N'James Hetfield, Lars Ulrich, Kirk Hammett', 328097, 10681477, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1844, N'Hero Of The Day', 151, 1, 3, N'James Hetfield, Lars Ulrich, Kirk Hammett', 261982, 8540298, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1845, N'Bleeding Me', 151, 1, 3, N'James Hetfield, Lars Ulrich, Kirk Hammett', 497998, 16249420, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1846, N'Cure', 151, 1, 3, N'James Hetfield, Lars Ulrich', 294347, 9648615, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1847, N'Poor Twisted Me', 151, 1, 3, N'James Hetfield, Lars Ulrich', 240065, 7854349, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1848, N'Wasted My Hate', 151, 1, 3, N'James Hetfield, Lars Ulrich, Kirk Hammett', 237296, 7762300, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1849, N'Mama Said', 151, 1, 3, N'James Hetfield, Lars Ulrich', 319764, 10508310, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1850, N'Thorn Within', 151, 1, 3, N'James Hetfield, Lars Ulrich, Kirk Hammett', 351738, 11486686, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1851, N'Ronnie', 151, 1, 3, N'James Hetfield, Lars Ulrich', 317204, 10390947, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1852, N'The Outlaw Torn', 151, 1, 3, N'James Hetfield, Lars Ulrich', 588721, 19286261, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1853, N'Battery', 152, 1, 3, N'J.Hetfield/L.Ulrich', 312424, 10229577, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1854, N'Master Of Puppets', 152, 1, 3, N'K.Hammett', 515239, 16893720, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1855, N'The Thing That Should Not Be', 152, 1, 3, N'K.Hammett', 396199, 12952368, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1856, N'Welcome Home (Sanitarium)', 152, 1, 3, N'K.Hammett', 387186, 12679965, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1857, N'Disposable Heroes', 152, 1, 3, N'J.Hetfield/L.Ulrich', 496718, 16135560, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1858, N'Leper Messiah', 152, 1, 3, N'C.Burton', 347428, 11310434, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1859, N'Orion', 152, 1, 3, N'K.Hammett', 500062, 16378477, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1860, N'Damage Inc.', 152, 1, 3, N'K.Hammett', 330919, 10725029, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1861, N'Fuel', 153, 1, 3, N'Hetfield, Ulrich, Hammett', 269557, 8876811, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1862, N'The Memory Remains', 153, 1, 3, N'Hetfield, Ulrich', 279353, 9110730, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1863, N'Devil''s Dance', 153, 1, 3, N'Hetfield, Ulrich', 318955, 10414832, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1864, N'The Unforgiven II', 153, 1, 3, N'Hetfield, Ulrich, Hammett', 395520, 12886474, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1865, N'Better Than You', 153, 1, 3, N'Hetfield, Ulrich', 322899, 10549070, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1866, N'Slither', 153, 1, 3, N'Hetfield, Ulrich, Hammett', 313103, 10199789, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1867, N'Carpe Diem Baby', 153, 1, 3, N'Hetfield, Ulrich, Hammett', 372480, 12170693, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1868, N'Bad Seed', 153, 1, 3, N'Hetfield, Ulrich, Hammett', 245394, 8019586, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1869, N'Where The Wild Things Are', 153, 1, 3, N'Hetfield, Ulrich, Newsted', 414380, 13571280, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1870, N'Prince Charming', 153, 1, 3, N'Hetfield, Ulrich', 365061, 12009412, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1871, N'Low Man''s Lyric', 153, 1, 3, N'Hetfield, Ulrich', 457639, 14855583, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1872, N'Attitude', 153, 1, 3, N'Hetfield, Ulrich', 315898, 10335734, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1873, N'Fixxxer', 153, 1, 3, N'Hetfield, Ulrich, Hammett', 496065, 16190041, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1874, N'Fight Fire With Fire', 154, 1, 3, N'Metallica', 285753, 9420856, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1875, N'Ride The Lightning', 154, 1, 3, N'Metallica', 397740, 13055884, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1876, N'For Whom The Bell Tolls', 154, 1, 3, N'Metallica', 311719, 10159725, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1877, N'Fade To Black', 154, 1, 3, N'Metallica', 414824, 13531954, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1878, N'Trapped Under Ice', 154, 1, 3, N'Metallica', 244532, 7975942, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1879, N'Escape', 154, 1, 3, N'Metallica', 264359, 8652332, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1880, N'Creeping Death', 154, 1, 3, N'Metallica', 396878, 12955593, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1881, N'The Call Of Ktulu', 154, 1, 3, N'Metallica', 534883, 17486240, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1882, N'Frantic', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 350458, 11510849, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1883, N'St. Anger', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 441234, 14363779, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1884, N'Some Kind Of Monster', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 505626, 16557497, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1885, N'Dirty Window', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 324989, 10670604, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1886, N'Invisible Kid', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 510197, 16591800, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1887, N'My World', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 345626, 11253756, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1888, N'Shoot Me Again', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 430210, 14093551, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1889, N'Sweet Amber', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 327235, 10616595, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1890, N'The Unnamed Feeling', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 429479, 14014582, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1891, N'Purify', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 314017, 10232537, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1892, N'All Within My Hands', 155, 1, 3, N'Bob Rock/James Hetfield/Kirk Hammett/Lars Ulrich', 527986, 17162741, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1893, N'Blackened', 156, 1, 3, N'James Hetfield, Lars Ulrich & Jason Newsted', 403382, 13254874, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1894, N'...And Justice For All', 156, 1, 3, N'James Hetfield, Lars Ulrich & Kirk Hammett', 585769, 19262088, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1895, N'Eye Of The Beholder', 156, 1, 3, N'James Hetfield, Lars Ulrich & Kirk Hammett', 385828, 12747894, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1896, N'One', 156, 1, 3, N'James Hetfield & Lars Ulrich', 446484, 14695721, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1897, N'The Shortest Straw', 156, 1, 3, N'James Hetfield and Lars Ulrich', 395389, 13013990, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1898, N'Harvester Of Sorrow', 156, 1, 3, N'James Hetfield and Lars Ulrich', 345547, 11377339, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1899, N'The Frayed Ends Of Sanity', 156, 1, 3, N'James Hetfield, Lars Ulrich and Kirk Hammett', 464039, 15198986, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1900, N'To Live Is To Die', 156, 1, 3, N'James Hetfield, Lars Ulrich and Cliff Burton', 588564, 19243795, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1901, N'Dyers Eve', 156, 1, 3, N'James Hetfield, Lars Ulrich and Kirk Hammett', 313991, 10302828, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1902, N'Springsville', 157, 1, 2, N'J. Carisi', 207725, 6776219, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1903, N'The Maids Of Cadiz', 157, 1, 2, N'L. Delibes', 233534, 7505275, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1904, N'The Duke', 157, 1, 2, N'Dave Brubeck', 214961, 6977626, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1905, N'My Ship', 157, 1, 2, N'Ira Gershwin, Kurt Weill', 268016, 8581144, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1906, N'Miles Ahead', 157, 1, 2, N'Miles Davis, Gil Evans', 209893, 6807707, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1907, N'Blues For Pablo', 157, 1, 2, N'Gil Evans', 318328, 10218398, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1908, N'New Rhumba', 157, 1, 2, N'A. Jamal', 276871, 8980400, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1909, N'The Meaning Of The Blues', 157, 1, 2, N'R. Troup, L. Worth', 168594, 5395412, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1910, N'Lament', 157, 1, 2, N'J.J. Johnson', 134191, 4293394, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1911, N'I Don''t Wanna Be Kissed (By Anyone But You)', 157, 1, 2, N'H. Spina, J. Elliott', 191320, 6219487, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1912, N'Springsville (Alternate Take)', 157, 1, 2, N'J. Carisi', 196388, 6382079, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1913, N'Blues For Pablo (Alternate Take)', 157, 1, 2, N'Gil Evans', 212558, 6900619, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1914, N'The Meaning Of The Blues/Lament (Alternate Take)', 157, 1, 2, N'J.J. Johnson/R. Troup, L. Worth', 309786, 9912387, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1915, N'I Don''t Wanna Be Kissed (By Anyone But You) (Alternate Take)', 157, 1, 2, N'H. Spina, J. Elliott', 192078, 6254796, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1916, N'Coração De Estudante', 158, 1, 7, N'Wagner Tiso, Milton Nascimento', 238550, 7797308, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1917, N'A Noite Do Meu Bem', 158, 1, 7, N'Dolores Duran', 220081, 7125225, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1918, N'Paisagem Na Janela', 158, 1, 7, N'Lô Borges, Fernando Brant', 197694, 6523547, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1919, N'Cuitelinho', 158, 1, 7, N'Folclore', 209397, 6803970, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1920, N'Caxangá', 158, 1, 7, N'Milton Nascimento, Fernando Brant', 245551, 8144179, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1921, N'Nos Bailes Da Vida', 158, 1, 7, N'Milton Nascimento, Fernando Brant', 275748, 9126170, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1922, N'Menestrel Das Alagoas', 158, 1, 7, N'Milton Nascimento, Fernando Brant', 199758, 6542289, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1923, N'Brasil', 158, 1, 7, N'Milton Nascimento, Fernando Brant', 155428, 5252560, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1924, N'Canção Do Novo Mundo', 158, 1, 7, N'Beto Guedes, Ronaldo Bastos', 215353, 7032626, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1925, N'Um Gosto De Sol', 158, 1, 7, N'Milton Nascimento, Ronaldo Bastos', 307200, 9893875, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1926, N'Solar', 158, 1, 7, N'Milton Nascimento, Fernando Brant', 156212, 5098288, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1927, N'Para Lennon E McCartney', 158, 1, 7, N'Lô Borges, Márcio Borges, Fernando Brant', 321828, 10626920, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1928, N'Maria, Maria', 158, 1, 7, N'Milton Nascimento, Fernando Brant', 72463, 2371543, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1929, N'Minas', 159, 1, 7, N'Milton Nascimento, Caetano Veloso', 152293, 4921056, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1930, N'Fé Cega, Faca Amolada', 159, 1, 7, N'Milton Nascimento, Ronaldo Bastos', 278099, 9258649, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1931, N'Beijo Partido', 159, 1, 7, N'Toninho Horta', 229564, 7506969, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1932, N'Saudade Dos Aviões Da Panair (Conversando No Bar)', 159, 1, 7, N'Milton Nascimento, Fernando Brant', 268721, 8805088, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1933, N'Gran Circo', 159, 1, 7, N'Milton Nascimento, Márcio Borges', 251297, 8237026, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1934, N'Ponta de Areia', 159, 1, 7, N'Milton Nascimento, Fernando Brant', 272796, 8874285, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1935, N'Trastevere', 159, 1, 7, N'Milton Nascimento, Ronaldo Bastos', 265665, 8708399, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1936, N'Idolatrada', 159, 1, 7, N'Milton Nascimento, Fernando Brant', 286249, 9426153, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1937, N'Leila (Venha Ser Feliz)', 159, 1, 7, N'Milton Nascimento', 209737, 6898507, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1938, N'Paula E Bebeto', 159, 1, 7, N'Milton Nascimento, Caetano Veloso', 135732, 4583956, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1939, N'Simples', 159, 1, 7, N'Nelson Angelo', 133093, 4326333, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1940, N'Norwegian Wood', 159, 1, 7, N'John Lennon, Paul McCartney', 413910, 13520382, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1941, N'Caso Você Queira Saber', 159, 1, 7, N'Beto Guedes, Márcio Borges', 205688, 6787901, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1942, N'Ace Of Spades', 160, 1, 3, N'Clarke/Kilmister/Taylor', 169926, 5523552, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1943, N'Love Me Like A Reptile', 160, 1, 3, N'Clarke/Kilmister/Taylor', 203546, 6616389, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1944, N'Shoot You In The Back', 160, 1, 3, N'Clarke/Kilmister/Taylor', 160026, 5175327, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1945, N'Live To Win', 160, 1, 3, N'Clarke/Kilmister/Taylor', 217626, 7102182, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1946, N'Fast And Loose', 160, 1, 3, N'Clarke/Kilmister/Taylor', 203337, 6643350, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1947, N'(We Are) The Road Crew', 160, 1, 3, N'Clarke/Kilmister/Taylor', 192600, 6283035, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1948, N'Fire Fire', 160, 1, 3, N'Clarke/Kilmister/Taylor', 164675, 5416114, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1949, N'Jailbait', 160, 1, 3, N'Clarke/Kilmister/Taylor', 213916, 6983609, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1950, N'Dance', 160, 1, 3, N'Clarke/Kilmister/Taylor', 158432, 5155099, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1951, N'Bite The Bullet', 160, 1, 3, N'Clarke/Kilmister/Taylor', 98115, 3195536, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1952, N'The Chase Is Better Than The Catch', 160, 1, 3, N'Clarke/Kilmister/Taylor', 258403, 8393310, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1953, N'The Hammer', 160, 1, 3, N'Clarke/Kilmister/Taylor', 168071, 5543267, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1954, N'Dirty Love', 160, 1, 3, N'Clarke/Kilmister/Taylor', 176457, 5805241, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1955, N'Please Don''t Touch', 160, 1, 3, N'Heath/Robinson', 169926, 5557002, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1956, N'Emergency', 160, 1, 3, N'Dufort/Johnson/McAuliffe/Williams', 180427, 5828728, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1957, N'Kir Royal', 161, 1, 16, N'Mônica Marianno', 234788, 7706552, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1958, N'O Que Vai Em Meu Coração', 161, 1, 16, N'Mônica Marianno', 255373, 8366846, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1959, N'Aos Leões', 161, 1, 16, N'Mônica Marianno', 234684, 7790574, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1960, N'Dois Índios', 161, 1, 16, N'Mônica Marianno', 219271, 7213072, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1961, N'Noite Negra', 161, 1, 16, N'Mônica Marianno', 206811, 6819584, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1962, N'Beijo do Olhar', 161, 1, 16, N'Mônica Marianno', 252682, 8369029, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1963, N'É Fogo', 161, 1, 16, N'Mônica Marianno', 194873, 6501520, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1964, N'Já Foi', 161, 1, 16, N'Mônica Marianno', 245681, 8094872, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1965, N'Só Se For Pelo Cabelo', 161, 1, 16, N'Mônica Marianno', 238288, 8006345, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1966, N'No Clima', 161, 1, 16, N'Mônica Marianno', 249495, 8362040, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1967, N'A Moça e a Chuva', 161, 1, 16, N'Mônica Marianno', 274625, 8929357, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1968, N'Demorou!', 161, 1, 16, N'Mônica Marianno', 39131, 1287083, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1969, N'Bitter Pill', 162, 1, 3, N'Mick Mars/Nikki Sixx/Tommy Lee/Vince Neil', 266814, 8666786, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1970, N'Enslaved', 162, 1, 3, N'Mick Mars/Nikki Sixx/Tommy Lee', 269844, 8789966, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1971, N'Girls, Girls, Girls', 162, 1, 3, N'Mick Mars/Nikki Sixx/Tommy Lee', 270288, 8874814, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1972, N'Kickstart My Heart', 162, 1, 3, N'Nikki Sixx', 283559, 9237736, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1973, N'Wild Side', 162, 1, 3, N'Nikki Sixx/Tommy Lee/Vince Neil', 276767, 9116997, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1974, N'Glitter', 162, 1, 3, N'Bryan Adams/Nikki Sixx/Scott Humphrey', 340114, 11184094, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1975, N'Dr. Feelgood', 162, 1, 3, N'Mick Mars/Nikki Sixx', 282618, 9281875, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1976, N'Same Ol'' Situation', 162, 1, 3, N'Mick Mars/Nikki Sixx/Tommy Lee/Vince Neil', 254511, 8283958, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1977, N'Home Sweet Home', 162, 1, 3, N'Nikki Sixx/Tommy Lee/Vince Neil', 236904, 7697538, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1978, N'Afraid', 162, 1, 3, N'Nikki Sixx', 248006, 8077464, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1979, N'Don''t Go Away Mad (Just Go Away)', 162, 1, 3, N'Mick Mars/Nikki Sixx', 279980, 9188156, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1980, N'Without You', 162, 1, 3, N'Mick Mars/Nikki Sixx', 268956, 8738371, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1981, N'Smokin'' in The Boys Room', 162, 1, 3, N'Cub Coda/Michael Lutz', 206837, 6735408, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1982, N'Primal Scream', 162, 1, 3, N'Mick Mars/Nikki Sixx/Tommy Lee/Vince Neil', 286197, 9421164, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1983, N'Too Fast For Love', 162, 1, 3, N'Nikki Sixx', 200829, 6580542, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1984, N'Looks That Kill', 162, 1, 3, N'Nikki Sixx', 240979, 7831122, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1985, N'Shout At The Devil', 162, 1, 3, N'Nikki Sixx', 221962, 7281974, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1986, N'Intro', 163, 1, 1, N'Kurt Cobain', 52218, 1688527, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1987, N'School', 163, 1, 1, N'Kurt Cobain', 160235, 5234885, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1988, N'Drain You', 163, 1, 1, N'Kurt Cobain', 215196, 7013175, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1989, N'Aneurysm', 163, 1, 1, N'Nirvana', 271516, 8862545, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1990, N'Smells Like Teen Spirit', 163, 1, 1, N'Nirvana', 287190, 9425215, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1991, N'Been A Son', 163, 1, 1, N'Kurt Cobain', 127555, 4170369, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1992, N'Lithium', 163, 1, 1, N'Kurt Cobain', 250017, 8148800, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1993, N'Sliver', 163, 1, 1, N'Kurt Cobain', 116218, 3784567, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1994, N'Spank Thru', 163, 1, 1, N'Kurt Cobain', 190354, 6186487, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1995, N'Scentless Apprentice', 163, 1, 1, N'Nirvana', 211200, 6898177, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1996, N'Heart-Shaped Box', 163, 1, 1, N'Kurt Cobain', 281887, 9210982, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1997, N'Milk It', 163, 1, 1, N'Kurt Cobain', 225724, 7406945, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1998, N'Negative Creep', 163, 1, 1, N'Kurt Cobain', 163761, 5354854, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (1999, N'Polly', 163, 1, 1, N'Kurt Cobain', 149995, 4885331, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2000, N'Breed', 163, 1, 1, N'Kurt Cobain', 208378, 6759080, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2001, N'Tourette''s', 163, 1, 1, N'Kurt Cobain', 115591, 3753246, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2002, N'Blew', 163, 1, 1, N'Kurt Cobain', 216346, 7096936, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2003, N'Smells Like Teen Spirit', 164, 1, 1, N'Kurt Cobain', 301296, 9823847, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2004, N'In Bloom', 164, 1, 1, N'Kurt Cobain', 254928, 8327077, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2005, N'Come As You Are', 164, 1, 1, N'Kurt Cobain', 219219, 7123357, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2006, N'Breed', 164, 1, 1, N'Kurt Cobain', 183928, 5984812, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2007, N'Lithium', 164, 1, 1, N'Kurt Cobain', 256992, 8404745, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2008, N'Polly', 164, 1, 1, N'Kurt Cobain', 177031, 5788407, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2009, N'Territorial Pissings', 164, 1, 1, N'Kurt Cobain', 143281, 4613880, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2010, N'Drain You', 164, 1, 1, N'Kurt Cobain', 223973, 7273440, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2011, N'Lounge Act', 164, 1, 1, N'Kurt Cobain', 156786, 5093635, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2012, N'Stay Away', 164, 1, 1, N'Kurt Cobain', 212636, 6956404, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2013, N'On A Plain', 164, 1, 1, N'Kurt Cobain', 196440, 6390635, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2014, N'Something In The Way', 164, 1, 1, N'Kurt Cobain', 230556, 7472168, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2015, N'Time', 165, 1, 1, 96888, 3124455, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2016, N'P.S.Apareça', 165, 1, 1, 209188, 6842244, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2017, N'Sangue Latino', 165, 1, 1, 223033, 7354184, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2018, N'Folhas Secas', 165, 1, 1, 161253, 5284522, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2019, N'Poeira', 165, 1, 1, 267075, 8784141, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2020, N'Mágica', 165, 1, 1, 233743, 7627348, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2021, N'Quem Mata A Mulher Mata O Melhor', 165, 1, 1, 262791, 8640121, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2022, N'Mundaréu', 165, 1, 1, 217521, 7158975, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2023, N'O Braço Da Minha Guitarra', 165, 1, 1, 258351, 8469531, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2024, N'Deus', 165, 1, 1, 284160, 9188110, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2025, N'Mãe Terra', 165, 1, 1, 306625, 9949269, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2026, N'Às Vezes', 165, 1, 1, 330292, 10706614, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2027, N'Menino De Rua', 165, 1, 1, 329795, 10784595, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2028, N'Prazer E Fé', 165, 1, 1, 214831, 7031383, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2029, N'Elza', 165, 1, 1, 199105, 6517629, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2030, N'Requebra', 166, 1, 7, 240744, 8010811, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2031, N'Nossa Gente (Avisa Là)', 166, 1, 7, 188212, 6233201, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2032, N'Olodum - Alegria Geral', 166, 1, 7, 233404, 7754245, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2033, N'Madagáscar Olodum', 166, 1, 7, 252264, 8270584, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2034, N'Faraó Divindade Do Egito', 166, 1, 7, 228571, 7523278, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2035, N'Todo Amor (Asas Da Liberdade)', 166, 1, 7, 245133, 8121434, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2036, N'Denúncia', 166, 1, 7, 159555, 5327433, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2037, N'Olodum, A Banda Do Pelô', 166, 1, 7, 146599, 4900121, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2038, N'Cartao Postal', 166, 1, 7, 211565, 7082301, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2039, N'Jeito Faceiro', 166, 1, 7, 217286, 7233608, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2040, N'Revolta Olodum', 166, 1, 7, 230191, 7557065, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2041, N'Reggae Odoyá', 166, 1, 7, 224470, 7499807, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2042, N'Protesto Do Olodum (Ao Vivo)', 166, 1, 7, 206001, 6766104, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2043, N'Olodum - Smile (Instrumental)', 166, 1, 7, 235833, 7871409, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2044, N'Vulcão Dub - Fui Eu', 167, 1, 7, N'Bi Ribeira/Herbert Vianna/João Barone', 287059, 9495202, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2045, N'O Trem Da Juventude', 167, 1, 7, N'Herbert Vianna', 225880, 7507655, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2046, N'Manguetown', 167, 1, 7, N'Chico Science/Dengue/Lúcio Maia', 162925, 5382018, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2047, N'Um Amor, Um Lugar', 167, 1, 7, N'Herbert Vianna', 184555, 6090334, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2048, N'Bora-Bora', 167, 1, 7, N'Herbert Vianna', 182987, 6036046, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2049, N'Vai Valer', 167, 1, 7, N'Herbert Vianna', 206524, 6899778, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2050, N'I Feel Good (I Got You) - Sossego', 167, 1, 7, N'James Brown/Tim Maia', 244976, 8091302, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2051, N'Uns Dias', 167, 1, 7, N'Herbert Vianna', 240796, 7931552, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2052, N'Sincero Breu', 167, 1, 7, N'C. A./C.A./Celso Alvim/Herbert Vianna/Mário Moura/Pedro Luís/Sidon Silva', 208013, 6921669, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2053, N'Meu Erro', 167, 1, 7, N'Herbert Vianna', 188577, 6192791, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2054, N'Selvagem', 167, 1, 7, N'Bi Ribeiro/Herbert Vianna/João Barone', 148558, 4942831, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2055, N'Brasília 5:31', 167, 1, 7, N'Herbert Vianna', 178337, 5857116, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2056, N'Tendo A Lua', 167, 1, 7, N'Herbert Vianna/Tet Tillett', 198922, 6568180, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2057, N'Que País É Este', 167, 1, 7, N'Renato Russo', 216685, 7137865, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2058, N'Navegar Impreciso', 167, 1, 7, N'Herbert Vianna', 262870, 8761283, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2059, N'Feira Moderna', 167, 1, 7, N'Beto Guedes/Fernando Brant/L Borges', 182517, 6001793, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2060, N'Tequila - Lourinha Bombril (Parate Y Mira)', 167, 1, 7, N'Bahiano/Chuck Rio/Diego Blanco/Herbert Vianna', 255738, 8514961, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2061, N'Vamo Batê Lata', 167, 1, 7, N'Herbert Vianna', 228754, 7585707, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2062, N'Life During Wartime', 167, 1, 7, N'Chris Frantz/David Byrne/Jerry Harrison/Tina Weymouth', 259186, 8543439, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2063, N'Nebulosa Do Amor', 167, 1, 7, N'Herbert Vianna', 203415, 6732496, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2064, N'Caleidoscópio', 167, 1, 7, N'Herbert Vianna', 256522, 8484597, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2065, N'Trac Trac', 168, 1, 7, N'Fito Paez/Herbert Vianna', 231653, 7638256, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2066, N'Tendo A Lua', 168, 1, 7, N'Herbert Vianna/Tetê Tillet', 219585, 7342776, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2067, N'Mensagen De Amor (2000)', 168, 1, 7, N'Herbert Vianna', 183588, 6061324, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2068, N'Lourinha Bombril', 168, 1, 7, N'Bahiano/Diego Blanco/Herbert Vianna', 159895, 5301882, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2069, N'La Bella Luna', 168, 1, 7, N'Herbert Vianna', 192653, 6428598, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2070, N'Busca Vida', 168, 1, 7, N'Herbert Vianna', 176431, 5798663, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2071, N'Uma Brasileira', 168, 1, 7, N'Carlinhos Brown/Herbert Vianna', 217573, 7280574, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2072, N'Luis Inacio (300 Picaretas)', 168, 1, 7, N'Herbert Vianna', 198191, 6576790, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2073, N'Saber Amar', 168, 1, 7, N'Herbert Vianna', 202788, 6723733, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2074, N'Ela Disse Adeus', 168, 1, 7, N'Herbert Vianna', 226298, 7608999, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2075, N'O Amor Nao Sabe Esperar', 168, 1, 7, N'Herbert Vianna', 241084, 8042534, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2076, N'Aonde Quer Que Eu Va', 168, 1, 7, N'Herbert Vianna/Paulo Sérgio Valle', 258089, 8470121, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2077, N'Caleidoscópio', 169, 1, 7, 211330, 7000017, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2078, N'Óculos', 169, 1, 7, 219271, 7262419, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2079, N'Cinema Mudo', 169, 1, 7, 227918, 7612168, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2080, N'Alagados', 169, 1, 7, 302393, 10255463, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2081, N'Lanterna Dos Afogados', 169, 1, 7, 190197, 6264318, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2082, N'Melô Do Marinheiro', 169, 1, 7, 208352, 6905668, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2083, N'Vital E Sua Moto', 169, 1, 7, 210207, 6902878, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2084, N'O Beco', 169, 1, 7, 189178, 6293184, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2085, N'Meu Erro', 169, 1, 7, 208431, 6893533, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2086, N'Perplexo', 169, 1, 7, 161175, 5355013, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2087, N'Me Liga', 169, 1, 7, 229590, 7565912, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2088, N'Quase Um Segundo', 169, 1, 7, 275644, 8971355, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2089, N'Selvagem', 169, 1, 7, 245890, 8141084, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2090, N'Romance Ideal', 169, 1, 7, 250070, 8260477, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2091, N'Será Que Vai Chover?', 169, 1, 7, 337057, 11133830, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2092, N'SKA', 169, 1, 7, 148871, 4943540, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2093, N'Bark at the Moon', 170, 2, 1, N'O. Osbourne', 257252, 4601224, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2094, N'I Don''t Know', 171, 2, 1, N'B. Daisley, O. Osbourne & R. Rhoads', 312980, 5525339, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2095, N'Crazy Train', 171, 2, 1, N'B. Daisley, O. Osbourne & R. Rhoads', 295960, 5255083, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2096, N'Flying High Again', 172, 2, 1, N'L. Kerslake, O. Osbourne, R. Daisley & R. Rhoads', 290851, 5179599, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2097, N'Mama, I''m Coming Home', 173, 2, 1, N'L. Kilmister, O. Osbourne & Z. Wylde', 251586, 4302390, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2098, N'No More Tears', 173, 2, 1, N'J. Purdell, M. Inez, O. Osbourne, R. Castillo & Z. Wylde', 444358, 7362964, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2099, N'I Don''t Know', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads', 283088, 9207869, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2100, N'Crazy Train', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads', 322716, 10517408, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2101, N'Believer', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads', 308897, 10003794, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2102, N'Mr. Crowley', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads', 344241, 11184130, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2103, N'Flying High Again', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads, L. Kerslake', 261224, 8481822, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2104, N'Relvelation (Mother Earth)', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads', 349440, 11367866, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2105, N'Steal Away (The Night)', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads', 485720, 15945806, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2106, N'Suicide Solution (With Guitar Solo)', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads', 467069, 15119938, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2107, N'Iron Man', 174, 1, 3, N'A. F. Iommi, W. Ward, T. Butler, J. Osbourne', 172120, 5609799, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2108, N'Children Of The Grave', 174, 1, 3, N'A. F. Iommi, W. Ward, T. Butler, J. Osbourne', 357067, 11626740, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2109, N'Paranoid', 174, 1, 3, N'A. F. Iommi, W. Ward, T. Butler, J. Osbourne', 176352, 5729813, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2110, N'Goodbye To Romance', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads', 334393, 10841337, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2111, N'No Bone Movies', 174, 1, 3, N'O. Osbourne, R. Daisley, R. Rhoads', 249208, 8095199, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2112, N'Dee', 174, 1, 3, N'R. Rhoads', 261302, 8555963, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2113, N'Shining In The Light', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 240796, 7951688, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2114, N'When The World Was Young', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 373394, 12198930, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2115, N'Upon A Golden Horse', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 232359, 7594829, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2116, N'Blue Train', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 405028, 13170391, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2117, N'Please Read The Letter', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 262112, 8603372, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2118, N'Most High', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 336535, 10999203, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2119, N'Heart In Your Hand', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 230896, 7598019, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2120, N'Walking Into Clarksdale', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 318511, 10396315, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2121, N'Burning Up', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 321619, 10525136, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2122, N'When I Was A Child', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 345626, 11249456, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2123, N'House Of Love', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 335699, 10990880, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2124, N'Sons Of Freedom', 175, 1, 1, N'Jimmy Page, Robert Plant, Charlie Jones, Michael Lee', 246465, 8087944, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2125, N'United Colours', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 330266, 10939131, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2126, N'Slug', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 281469, 9295950, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2127, N'Your Blue Room', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 328228, 10867860, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2128, N'Always Forever Now', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 383764, 12727928, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2129, N'A Different Kind Of Blue', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 120816, 3884133, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2130, N'Beach Sequence', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 212297, 6928259, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2131, N'Miss Sarajevo', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 340767, 11064884, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2132, N'Ito Okashi', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 205087, 6572813, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2133, N'One Minute Warning', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 279693, 9335453, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2134, N'Corpse (These Chains Are Way Too Long)', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 214909, 6920451, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2135, N'Elvis Ate America', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 180166, 5851053, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2136, N'Plot 180', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 221596, 7253729, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2137, N'Theme From The Swan', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 203911, 6638076, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2138, N'Theme From Let''s Go Native', 176, 1, 10, N'Brian Eno, Bono, Adam Clayton, The Edge & Larry Mullen Jnr.', 186723, 6179777, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2139, N'Wrathchild', 177, 1, 1, N'Steve Harris', 170396, 5499390, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2140, N'Killers', 177, 1, 1, N'Paul Di''Anno/Steve Harris', 309995, 10009697, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2141, N'Prowler', 177, 1, 1, N'Steve Harris', 240274, 7782963, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2142, N'Murders In The Rue Morgue', 177, 1, 1, N'Steve Harris', 258638, 8360999, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2143, N'Women In Uniform', 177, 1, 1, N'Greg Macainsh', 189936, 6139651, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2144, N'Remember Tomorrow', 177, 1, 1, N'Paul Di''Anno/Steve Harris', 326426, 10577976, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2145, N'Sanctuary', 177, 1, 1, N'David Murray/Paul Di''Anno/Steve Harris', 198844, 6423543, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2146, N'Running Free', 177, 1, 1, N'Paul Di''Anno/Steve Harris', 199706, 6483496, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2147, N'Phantom Of The Opera', 177, 1, 1, N'Steve Harris', 418168, 13585530, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2148, N'Iron Maiden', 177, 1, 1, N'Steve Harris', 235232, 7600077, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2149, N'Corduroy', 178, 1, 1, N'Pearl Jam & Eddie Vedder', 305293, 9991106, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2150, N'Given To Fly', 178, 1, 1, N'Eddie Vedder & Mike McCready', 233613, 7678347, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2151, N'Hail, Hail', 178, 1, 1, N'Stone Gossard & Eddie Vedder & Jeff Ament & Mike McCready', 223764, 7364206, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2152, N'Daughter', 178, 1, 1, N'Dave Abbruzzese & Jeff Ament & Stone Gossard & Mike McCready & Eddie Vedder', 407484, 13420697, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2153, N'Elderly Woman Behind The Counter In A Small Town', 178, 1, 1, N'Dave Abbruzzese & Jeff Ament & Stone Gossard & Mike McCready & Eddie Vedder', 229328, 7509304, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2154, N'Untitled', 178, 1, 1, N'Pearl Jam', 122801, 3957141, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2155, N'MFC', 178, 1, 1, N'Eddie Vedder', 148192, 4817665, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2156, N'Go', 178, 1, 1, N'Dave Abbruzzese & Jeff Ament & Stone Gossard & Mike McCready & Eddie Vedder', 161541, 5290810, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2157, N'Red Mosquito', 178, 1, 1, N'Jeff Ament & Stone Gossard & Jack Irons & Mike McCready & Eddie Vedder', 242991, 7944923, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2158, N'Even Flow', 178, 1, 1, N'Stone Gossard & Eddie Vedder', 317100, 10394239, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2159, N'Off He Goes', 178, 1, 1, N'Eddie Vedder', 343222, 11245109, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2160, N'Nothingman', 178, 1, 1, N'Jeff Ament & Eddie Vedder', 278595, 9107017, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2161, N'Do The Evolution', 178, 1, 1, N'Eddie Vedder & Stone Gossard', 225462, 7377286, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2162, N'Better Man', 178, 1, 1, N'Eddie Vedder', 246204, 8019563, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2163, N'Black', 178, 1, 1, N'Stone Gossard & Eddie Vedder', 415712, 13580009, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2164, N'F*Ckin'' Up', 178, 1, 1, N'Neil Young', 377652, 12360893, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2165, N'Life Wasted', 179, 1, 4, N'Stone Gossard', 234344, 7610169, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2166, N'World Wide Suicide', 179, 1, 4, N'Eddie Vedder', 209188, 6885908, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2167, N'Comatose', 179, 1, 4, N'Mike McCready & Stone Gossard', 139990, 4574516, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2168, N'Severed Hand', 179, 1, 4, N'Eddie Vedder', 270341, 8817438, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2169, N'Marker In The Sand', 179, 1, 4, N'Mike McCready', 263235, 8656578, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2170, N'Parachutes', 179, 1, 4, N'Stone Gossard', 216555, 7074973, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2171, N'Unemployable', 179, 1, 4, N'Matt Cameron & Mike McCready', 184398, 6066542, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2172, N'Big Wave', 179, 1, 4, N'Jeff Ament', 178573, 5858788, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2173, N'Gone', 179, 1, 4, N'Eddie Vedder', 249547, 8158204, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2174, N'Wasted Reprise', 179, 1, 4, N'Stone Gossard', 53733, 1731020, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2175, N'Army Reserve', 179, 1, 4, N'Jeff Ament', 225567, 7393771, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2176, N'Come Back', 179, 1, 4, N'Eddie Vedder & Mike McCready', 329743, 10768701, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2177, N'Inside Job', 179, 1, 4, N'Eddie Vedder & Mike McCready', 428643, 14006924, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2178, N'Can''t Keep', 180, 1, 1, N'Eddie Vedder', 219428, 7215713, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2179, N'Save You', 180, 1, 1, N'Eddie Vedder/Jeff Ament/Matt Cameron/Mike McCready/Stone Gossard', 230112, 7609110, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2180, N'Love Boat Captain', 180, 1, 1, N'Eddie Vedder', 276453, 9016789, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2181, N'Cropduster', 180, 1, 1, N'Matt Cameron', 231888, 7588928, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2182, N'Ghost', 180, 1, 1, N'Jeff Ament', 195108, 6383772, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2183, N'I Am Mine', 180, 1, 1, N'Eddie Vedder', 215719, 7086901, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2184, N'Thumbing My Way', 180, 1, 1, N'Eddie Vedder', 250226, 8201437, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2185, N'You Are', 180, 1, 1, N'Matt Cameron', 270863, 8938409, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2186, N'Get Right', 180, 1, 1, N'Matt Cameron', 158589, 5223345, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2187, N'Green Disease', 180, 1, 1, N'Eddie Vedder', 161253, 5375818, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2188, N'Help Help', 180, 1, 1, N'Jeff Ament', 215092, 7033002, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2189, N'Bushleager', 180, 1, 1, N'Stone Gossard', 237479, 7849757, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2190, N'1/2 Full', 180, 1, 1, N'Jeff Ament', 251010, 8197219, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2191, N'Arc', 180, 1, 1, N'Pearl Jam', 65593, 2099421, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2192, N'All or None', 180, 1, 1, N'Stone Gossard', 277655, 9104728, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2193, N'Once', 181, 1, 1, N'Stone Gossard', 231758, 7561555, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2194, N'Evenflow', 181, 1, 1, N'Stone Gossard', 293720, 9622017, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2195, N'Alive', 181, 1, 1, N'Stone Gossard', 341080, 11176623, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2196, N'Why Go', 181, 1, 1, N'Jeff Ament', 200254, 6539287, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2197, N'Black', 181, 1, 1, N'Dave Krusen/Stone Gossard', 343823, 11213314, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2198, N'Jeremy', 181, 1, 1, N'Jeff Ament', 318981, 10447222, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2199, N'Oceans', 181, 1, 1, N'Jeff Ament/Stone Gossard', 162194, 5282368, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2200, N'Porch', 181, 1, 1, N'Eddie Vedder', 210520, 6877475, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2201, N'Garden', 181, 1, 1, N'Jeff Ament/Stone Gossard', 299154, 9740738, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2202, N'Deep', 181, 1, 1, N'Jeff Ament/Stone Gossard', 258324, 8432497, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2203, N'Release', 181, 1, 1, N'Jeff Ament/Mike McCready/Stone Gossard', 546063, 17802673, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2204, N'Go', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 193123, 6351920, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2205, N'Animal', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 169325, 5503459, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2206, N'Daughter', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 235598, 7824586, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2207, N'Glorified G', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 206968, 6772116, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2208, N'Dissident', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 215510, 7034500, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2209, N'W.M.A.', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 359262, 12037261, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2210, N'Blood', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 170631, 5551478, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2211, N'Rearviewmirror', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 284186, 9321053, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2212, N'Rats', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 255425, 8341934, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2213, N'Elderly Woman Behind The Counter In A Small Town', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 196336, 6499398, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2214, N'Leash', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 189257, 6191560, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2215, N'Indifference', 182, 1, 1, N'Dave Abbruzzese/Eddie Vedder/Jeff Ament/Mike McCready/Stone Gossard', 302053, 9756133, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2216, N'Johnny B. Goode', 141, 1, 8, 243200, 8092024, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2217, N'Don''t Look Back', 141, 1, 8, 221100, 7344023, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2218, N'Jah Seh No', 141, 1, 8, 276871, 9134476, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2219, N'I''m The Toughest', 141, 1, 8, 230191, 7657594, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2220, N'Nothing But Love', 141, 1, 8, 221570, 7335228, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2221, N'Buk-In-Hamm Palace', 141, 1, 8, 265665, 8964369, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2222, N'Bush Doctor', 141, 1, 8, 239751, 7942299, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2223, N'Wanted Dread And Alive', 141, 1, 8, 260310, 8670933, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2224, N'Mystic Man', 141, 1, 8, 353671, 11812170, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2225, N'Coming In Hot', 141, 1, 8, 213054, 7109414, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2226, N'Pick Myself Up', 141, 1, 8, 234684, 7788255, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2227, N'Crystal Ball', 141, 1, 8, 309733, 10319296, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2228, N'Equal Rights Downpresser Man', 141, 1, 8, 366733, 12086524, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2229, N'Speak To Me/Breathe', 183, 1, 1, N'Mason/Waters, Gilmour, Wright', 234213, 7631305, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2230, N'On The Run', 183, 1, 1, N'Gilmour, Waters', 214595, 7206300, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2231, N'Time', 183, 1, 1, N'Mason, Waters, Wright, Gilmour', 425195, 13955426, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2232, N'The Great Gig In The Sky', 183, 1, 1, N'Wright, Waters', 284055, 9147563, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2233, N'Money', 183, 1, 1, N'Waters', 391888, 12930070, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2234, N'Us And Them', 183, 1, 1, N'Waters, Wright', 461035, 15000299, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2235, N'Any Colour You Like', 183, 1, 1, N'Gilmour, Mason, Wright, Waters', 205740, 6707989, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2236, N'Brain Damage', 183, 1, 1, N'Waters', 230556, 7497655, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2237, N'Eclipse', 183, 1, 1, N'Waters', 125361, 4065299, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2238, N'ZeroVinteUm', 184, 1, 17, 315637, 10426550, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2239, N'Queimando Tudo', 184, 1, 17, 172591, 5723677, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2240, N'Hip Hop Rio', 184, 1, 17, 151536, 4991935, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2241, N'Bossa', 184, 1, 17, 29048, 967098, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2242, N'100% HardCore', 184, 1, 17, 165146, 5407744, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2243, N'Biruta', 184, 1, 17, 213263, 7108200, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2244, N'Mão Na Cabeça', 184, 1, 17, 202631, 6642753, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2245, N'O Bicho Tá Pregando', 184, 1, 17, 171964, 5683369, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2246, N'Adoled (Ocean)', 184, 1, 17, 185103, 6009946, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2247, N'Seus Amigos', 184, 1, 17, 100858, 3304738, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2248, N'Paga Pau', 184, 1, 17, 197485, 6529041, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2249, N'Rappers Reais', 184, 1, 17, 202004, 6684160, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2250, N'Nega Do Cabelo Duro', 184, 1, 17, 121808, 4116536, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2251, N'Hemp Family', 184, 1, 17, 205923, 6806900, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2252, N'Quem Me Cobrou?', 184, 1, 17, 121704, 3947664, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2253, N'Se Liga', 184, 1, 17, 410409, 13559173, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2254, N'Bohemian Rhapsody', 185, 1, 1, N'Mercury, Freddie', 358948, 11619868, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2255, N'Another One Bites The Dust', 185, 1, 1, N'Deacon, John', 216946, 7172355, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2256, N'Killer Queen', 185, 1, 1, N'Mercury, Freddie', 182099, 5967749, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2257, N'Fat Bottomed Girls', 185, 1, 1, N'May, Brian', 204695, 6630041, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2258, N'Bicycle Race', 185, 1, 1, N'Mercury, Freddie', 183823, 6012409, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2259, N'You''re My Best Friend', 185, 1, 1, N'Deacon, John', 172225, 5602173, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2260, N'Don''t Stop Me Now', 185, 1, 1, N'Mercury, Freddie', 211826, 6896666, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2261, N'Save Me', 185, 1, 1, N'May, Brian', 228832, 7444624, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2262, N'Crazy Little Thing Called Love', 185, 1, 1, N'Mercury, Freddie', 164231, 5435501, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2263, N'Somebody To Love', 185, 1, 1, N'Mercury, Freddie', 297351, 9650520, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2264, N'Now I''m Here', 185, 1, 1, N'May, Brian', 255346, 8328312, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2265, N'Good Old-Fashioned Lover Boy', 185, 1, 1, N'Mercury, Freddie', 175960, 5747506, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2266, N'Play The Game', 185, 1, 1, N'Mercury, Freddie', 213368, 6915832, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2267, N'Flash', 185, 1, 1, N'May, Brian', 168489, 5464986, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2268, N'Seven Seas Of Rhye', 185, 1, 1, N'Mercury, Freddie', 170553, 5539957, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2269, N'We Will Rock You', 185, 1, 1, N'Deacon, John/May, Brian', 122880, 4026955, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2270, N'We Are The Champions', 185, 1, 1, N'Mercury, Freddie', 180950, 5880231, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2271, N'We Will Rock You', 186, 1, 1, N'May', 122671, 4026815, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2272, N'We Are The Champions', 186, 1, 1, N'Mercury', 182883, 5939794, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2273, N'Sheer Heart Attack', 186, 1, 1, N'Taylor', 207386, 6642685, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2274, N'All Dead, All Dead', 186, 1, 1, N'May', 190119, 6144878, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2275, N'Spread Your Wings', 186, 1, 1, N'Deacon', 275356, 8936992, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2276, N'Fight From The Inside', 186, 1, 1, N'Taylor', 184737, 6078001, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2277, N'Get Down, Make Love', 186, 1, 1, N'Mercury', 231235, 7509333, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2278, N'Sleep On The Sidewalk', 186, 1, 1, N'May', 187428, 6099840, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2279, N'Who Needs You', 186, 1, 1, N'Deacon', 186958, 6292969, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2280, N'It''s Late', 186, 1, 1, N'May', 386194, 12519388, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2281, N'My Melancholy Blues', 186, 1, 1, N'Mercury', 206471, 6691838, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2282, N'Shiny Happy People', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 226298, 7475323, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2283, N'Me In Honey', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 246674, 8194751, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2284, N'Radio Song', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 255477, 8421172, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2285, N'Pop Song 89', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 185730, 6132218, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2286, N'Get Up', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 160235, 5264376, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2287, N'You Are The Everything', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 226298, 7373181, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2288, N'Stand', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 192862, 6349090, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2289, N'World Leader Pretend', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 259761, 8537282, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2290, N'The Wrong Child', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 216633, 7065060, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2291, N'Orange Crush', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 231706, 7742894, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2292, N'Turn You Inside-Out', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 257358, 8395671, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2293, N'Hairshirt', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 235911, 7753807, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2294, N'I Remember California', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 304013, 9950311, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2295, N'Untitled', 188, 1, 4, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 191503, 6332426, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2296, N'How The West Was Won And Where It Got Us', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 271151, 8994291, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2297, N'The Wake-Up Bomb', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 308532, 10077337, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2298, N'New Test Leper', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 326791, 10866447, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2299, N'Undertow', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 309498, 10131005, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2300, N'E-Bow The Letter', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 324963, 10714576, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2301, N'Leave', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 437968, 14433365, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2302, N'Departure', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 209423, 6818425, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2303, N'Bittersweet Me', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 245812, 8114718, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2304, N'Be Mine', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 333087, 10790541, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2305, N'Binky The Doormat', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 301688, 9950320, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2306, N'Zither', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 154148, 5032962, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2307, N'So Fast, So Numb', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 252682, 8341223, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2308, N'Low Desert', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 212062, 6989288, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2309, N'Electrolite', 189, 1, 1, N'Bill Berry-Peter Buck-Mike Mills-Michael Stipe', 245315, 8051199, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2310, N'Losing My Religion', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 269035, 8885672, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2311, N'Low', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 296777, 9633860, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2312, N'Near Wild Heaven', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 199862, 6610009, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2313, N'Endgame', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 230687, 7664479, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2314, N'Belong', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 247013, 8219375, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2315, N'Half A World Away', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 208431, 6837283, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2316, N'Texarkana', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 220081, 7260681, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2317, N'Country Feedback', 187, 1, 4, N'Bill Berry/Michael Stipe/Mike Mills/Peter Buck', 249782, 8178943, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2318, N'Carnival Of Sorts', 190, 1, 4, N'R.E.M.', 233482, 7669658, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2319, N'Radio Free Aurope', 190, 1, 4, N'R.E.M.', 245315, 8163490, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2320, N'Perfect Circle', 190, 1, 4, N'R.E.M.', 208509, 6898067, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2321, N'Talk About The Passion', 190, 1, 4, N'R.E.M.', 203206, 6725435, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2322, N'So Central Rain', 190, 1, 4, N'R.E.M.', 194768, 6414550, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2323, N'Don''t Go Back To Rockville', 190, 1, 4, N'R.E.M.', 272352, 9010715, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2324, N'Pretty Persuasion', 190, 1, 4, N'R.E.M.', 229929, 7577754, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2325, N'Green Grow The Rushes', 190, 1, 4, N'R.E.M.', 225671, 7422425, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2326, N'Can''t Get There From Here', 190, 1, 4, N'R.E.M.', 220630, 7285936, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2327, N'Driver 8', 190, 1, 4, N'R.E.M.', 204747, 6779076, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2328, N'Fall On Me', 190, 1, 4, N'R.E.M.', 172016, 5676811, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2329, N'I Believe', 190, 1, 4, N'R.E.M.', 227709, 7542929, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2330, N'Cuyahoga', 190, 1, 4, N'R.E.M.', 260623, 8591057, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2331, N'The One I Love', 190, 1, 4, N'R.E.M.', 197355, 6495125, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2332, N'The Finest Worksong', 190, 1, 4, N'R.E.M.', 229276, 7574856, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2333, N'It''s The End Of The World As We Know It (And I Feel Fine)', 190, 1, 4, N'R.E.M.', 244819, 7998987, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2334, N'Infeliz Natal', 191, 1, 4, N'Rodolfo', 138266, 4503299, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2335, N'A Sua', 191, 1, 4, N'Rodolfo', 142132, 4622064, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2336, N'Papeau Nuky Doe', 191, 1, 4, N'Rodolfo', 121652, 3995022, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2337, N'Merry Christmas', 191, 1, 4, N'Rodolfo', 126040, 4166652, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2338, N'Bodies', 191, 1, 4, N'Rodolfo', 180035, 5873778, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2339, N'Puteiro Em João Pessoa', 191, 1, 4, N'Rodolfo', 195578, 6395490, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2340, N'Esporrei Na Manivela', 191, 1, 4, N'Rodolfo', 293276, 9618499, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2341, N'Bê-a-Bá', 191, 1, 4, N'Rodolfo', 249051, 8130636, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2342, N'Cajueiro', 191, 1, 4, N'Rodolfo', 158589, 5164837, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2343, N'Palhas Do Coqueiro', 191, 1, 4, N'Rodolfo', 133851, 4396466, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2344, N'Maluco Beleza', 192, 1, 1, 203206, 6628067, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2345, N'O Dia Em Que A Terra Parou', 192, 1, 1, 261720, 8586678, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2346, N'No Fundo Do Quintal Da Escola', 192, 1, 1, 177606, 5836953, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2347, N'O Segredo Do Universo', 192, 1, 1, 192679, 6315187, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2348, N'As Profecias', 192, 1, 1, 232515, 7657732, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2349, N'Mata Virgem', 192, 1, 1, 142602, 4690029, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2350, N'Sapato 36', 192, 1, 1, 196702, 6507301, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2351, N'Todo Mundo Explica', 192, 1, 1, 134896, 4449772, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2352, N'Que Luz É Essa', 192, 1, 1, 165067, 5620058, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2353, N'Diamante De Mendigo', 192, 1, 1, 206053, 6775101, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2354, N'Negócio É', 192, 1, 1, 175464, 5826775, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2355, N'Muita Estrela, Pouca Constelação', 192, 1, 1, 268068, 8781021, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2356, N'Século XXI', 192, 1, 1, 244897, 8040563, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2357, N'Rock Das Aranhas (Ao Vivo) (Live)', 192, 1, 1, 231836, 7591945, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2358, N'The Power Of Equality', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 243591, 8148266, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2359, N'If You Have To Ask', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 216790, 7199175, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2360, N'Breaking The Girl', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 295497, 9805526, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2361, N'Funky Monks', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 323395, 10708168, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2362, N'Suck My Kiss', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 217234, 7129137, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2363, N'I Could Have Lied', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 244506, 8088244, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2364, N'Mellowship Slinky In B Major', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 240091, 7971384, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2365, N'The Righteous & The Wicked', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 248084, 8134096, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2366, N'Give It Away', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 283010, 9308997, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2367, N'Blood Sugar Sex Magik', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 271229, 8940573, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2368, N'Under The Bridge', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 264359, 8682716, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2369, N'Naked In The Rain', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 265717, 8724674, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2370, N'Apache Rose Peacock', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 282226, 9312588, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2371, N'The Greeting Song', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 193593, 6346507, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2372, N'My Lovely Man', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 279118, 9220114, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2373, N'Sir Psycho Sexy', 193, 1, 4, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 496692, 16354362, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2374, N'They''re Red Hot', 193, 1, 4, N'Robert Johnson', 71941, 2382220, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2375, N'By The Way', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 218017, 7197430, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2376, N'Universally Speaking', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 259213, 8501904, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2377, N'This Is The Place', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 257906, 8469765, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2378, N'Dosed', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 312058, 10235611, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2379, N'Don''t Forget Me', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 277995, 9107071, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2380, N'The Zephyr Song', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 232960, 7690312, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2381, N'Can''t Stop', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 269400, 8872479, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2382, N'I Could Die For You', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 193906, 6333311, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2383, N'Midnight', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 295810, 9702450, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2384, N'Throw Away Your Television', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 224574, 7483526, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2385, N'Cabron', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 218592, 7458864, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2386, N'Tear', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 317413, 10395500, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2387, N'On Mercury', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 208509, 6834762, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2388, N'Minor Thing', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 217835, 7148115, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2389, N'Warm Tape', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 256653, 8358200, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2390, N'Venice Queen', 194, 1, 1, N'Anthony Kiedis, Flea, John Frusciante, and Chad Smith', 369110, 12280381, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2391, N'Around The World', 195, 1, 1, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 238837, 7859167, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2392, N'Parallel Universe', 195, 1, 1, N'Red Hot Chili Peppers', 270654, 8958519, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2393, N'Scar Tissue', 195, 1, 1, N'Red Hot Chili Peppers', 217469, 7153744, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2394, N'Otherside', 195, 1, 1, N'Red Hot Chili Peppers', 255973, 8357989, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2395, N'Get On Top', 195, 1, 1, N'Red Hot Chili Peppers', 198164, 6587883, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2396, N'Californication', 195, 1, 1, N'Red Hot Chili Peppers', 321671, 10568999, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2397, N'Easily', 195, 1, 1, N'Red Hot Chili Peppers', 231418, 7504534, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2398, N'Porcelain', 195, 1, 1, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 163787, 5278793, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2399, N'Emit Remmus', 195, 1, 1, N'Red Hot Chili Peppers', 240300, 7901717, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2400, N'I Like Dirt', 195, 1, 1, N'Red Hot Chili Peppers', 157727, 5225917, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2401, N'This Velvet Glove', 195, 1, 1, N'Red Hot Chili Peppers', 225280, 7480537, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2402, N'Savior', 195, 1, 1, N'Anthony Kiedis/Chad Smith/Flea/John Frusciante', 292493, 9551885, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2403, N'Purple Stain', 195, 1, 1, N'Red Hot Chili Peppers', 253440, 8359971, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2404, N'Right On Time', 195, 1, 1, N'Red Hot Chili Peppers', 112613, 3722219, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2405, N'Road Trippin''', 195, 1, 1, N'Red Hot Chili Peppers', 205635, 6685831, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2406, N'The Spirit Of Radio', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 299154, 9862012, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2407, N'The Trees', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 285126, 9345473, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2408, N'Something For Nothing', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 240770, 7898395, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2409, N'Freewill', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 324362, 10694110, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2410, N'Xanadu', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 667428, 21753168, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2411, N'Bastille Day', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 280528, 9264769, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2412, N'By-Tor And The Snow Dog', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 519888, 17076397, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2413, N'Anthem', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 264515, 8693343, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2414, N'Closer To The Heart', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 175412, 5767005, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2415, N'2112 Overture', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 272718, 8898066, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2416, N'The Temples Of Syrinx', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 133459, 4360163, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2417, N'La Villa Strangiato', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 577488, 19137855, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2418, N'Fly By Night', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 202318, 6683061, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2419, N'Finding My Way', 196, 1, 1, N'Geddy Lee And Alex Lifeson/Geddy Lee And Neil Peart/Rush', 305528, 9985701, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2420, N'Jingo', 197, 1, 1, N'M.Babatunde Olantunji', 592953, 19736495, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2421, N'El Corazon Manda', 197, 1, 1, N'E.Weiss', 713534, 23519583, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2422, N'La Puesta Del Sol', 197, 1, 1, N'E.Weiss', 628062, 20614621, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2423, N'Persuasion', 197, 1, 1, N'Carlos Santana', 318432, 10354751, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2424, N'As The Years Go by', 197, 1, 1, N'Albert King', 233064, 7566829, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2425, N'Soul Sacrifice', 197, 1, 1, N'Carlos Santana', 296437, 9801120, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2426, N'Fried Neckbones And Home Fries', 197, 1, 1, N'W.Correa', 638563, 20939646, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2427, N'Santana Jam', 197, 1, 1, N'Carlos Santana', 882834, 29207100, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2428, N'Evil Ways', 198, 1, 1, 475402, 15289235, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2429, N'We''ve Got To Get Together/Jingo', 198, 1, 1, 1070027, 34618222, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2430, N'Rock Me', 198, 1, 1, 94720, 3037596, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2431, N'Just Ain''t Good Enough', 198, 1, 1, 850259, 27489067, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2432, N'Funky Piano', 198, 1, 1, 934791, 30200730, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2433, N'The Way You Do To Mer', 198, 1, 1, 618344, 20028702, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2434, N'Holding Back The Years', 141, 1, 1, N'Mick Hucknall and Neil Moss', 270053, 8833220, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2435, N'Money''s Too Tight To Mention', 141, 1, 1, N'John and William Valentine', 268408, 8861921, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2436, N'The Right Thing', 141, 1, 1, N'Mick Hucknall', 262687, 8624063, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2437, N'It''s Only Love', 141, 1, 1, N'Jimmy and Vella Cameron', 232594, 7659017, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2438, N'A New Flame', 141, 1, 1, N'Mick Hucknall', 237662, 7822875, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2439, N'You''ve Got It', 141, 1, 1, N'Mick Hucknall and Lamont Dozier', 235232, 7712845, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2440, N'If You Don''t Know Me By Now', 141, 1, 1, N'Kenny Gamble and Leon Huff', 206524, 6712634, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2441, N'Stars', 141, 1, 1, N'Mick Hucknall', 248137, 8194906, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2442, N'Something Got Me Started', 141, 1, 1, N'Mick Hucknall and Fritz McIntyre', 239595, 7997139, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2443, N'Thrill Me', 141, 1, 1, N'Mick Hucknall and Fritz McIntyre', 303934, 10034711, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2444, N'Your Mirror', 141, 1, 1, N'Mick Hucknall', 240666, 7893821, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2445, N'For Your Babies', 141, 1, 1, N'Mick Hucknall', 256992, 8408803, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2446, N'So Beautiful', 141, 1, 1, N'Mick Hucknall', 298083, 9837832, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2447, N'Angel', 141, 1, 1, N'Carolyn Franklin and Sonny Saunders', 240561, 7880256, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2448, N'Fairground', 141, 1, 1, N'Mick Hucknall', 263888, 8793094, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2449, N'Água E Fogo', 199, 1, 1, N'Chico Amaral/Edgard Scandurra/Samuel Rosa', 278987, 9272272, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2450, N'Três Lados', 199, 1, 1, N'Chico Amaral/Samuel Rosa', 233665, 7699609, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2451, N'Ela Desapareceu', 199, 1, 1, N'Chico Amaral/Samuel Rosa', 250122, 8289200, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2452, N'Balada Do Amor Inabalável', 199, 1, 1, N'Fausto Fawcett/Samuel Rosa', 240613, 8025816, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2453, N'Canção Noturna', 199, 1, 1, N'Chico Amaral/Lelo Zanettik', 238628, 7874774, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2454, N'Muçulmano', 199, 1, 1, N'Leão, Rodrigo F./Samuel Rosa', 249600, 8270613, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2455, N'Maquinarama', 199, 1, 1, N'Chico Amaral/Samuel Rosa', 245629, 8213710, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2456, N'Rebelião', 199, 1, 1, N'Chico Amaral/Samuel Rosa', 298527, 9817847, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2457, N'A Última Guerra', 199, 1, 1, N'Leão, Rodrigo F./Lô Borges/Samuel Rosa', 314723, 10480391, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2458, N'Fica', 199, 1, 1, N'Chico Amaral/Samuel Rosa', 272169, 8980972, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2459, N'Ali', 199, 1, 1, N'Nando Reis/Samuel Rosa', 306390, 10110351, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2460, N'Preto Damião', 199, 1, 1, N'Chico Amaral/Samuel Rosa', 264568, 8697658, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2461, N'É Uma Partida De Futebol', 200, 1, 1, N'Samuel Rosa', 1071, 38747, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2462, N'Eu Disse A Ela', 200, 1, 1, N'Samuel Rosa', 254223, 8479463, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2463, N'Zé Trindade', 200, 1, 1, N'Samuel Rosa', 247954, 8331310, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2464, N'Garota Nacional', 200, 1, 1, N'Samuel Rosa', 317492, 10511239, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2465, N'Tão Seu', 200, 1, 1, N'Samuel Rosa', 243748, 8133126, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2466, N'Sem Terra', 200, 1, 1, N'Samuel Rosa', 279353, 9196411, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2467, N'Os Exilados', 200, 1, 1, N'Samuel Rosa', 245551, 8222095, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2468, N'Um Dia Qualquer', 200, 1, 1, N'Samuel Rosa', 292414, 9805570, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2469, N'Los Pretos', 200, 1, 1, N'Samuel Rosa', 239229, 8025667, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2470, N'Sul Da América', 200, 1, 1, N'Samuel Rosa', 254928, 8484871, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2471, N'Poconé', 200, 1, 1, N'Samuel Rosa', 318406, 10771610, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2472, N'Lucky 13', 201, 1, 4, N'Billy Corgan', 189387, 6200617, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2473, N'Aeroplane Flies High', 201, 1, 4, N'Billy Corgan', 473391, 15408329, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2474, N'Because You Are', 201, 1, 4, N'Billy Corgan', 226403, 7405137, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2475, N'Slow Dawn', 201, 1, 4, N'Billy Corgan', 192339, 6269057, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2476, N'Believe', 201, 1, 4, N'James Iha', 192940, 6320652, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2477, N'My Mistake', 201, 1, 4, N'Billy Corgan', 240901, 7843477, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2478, N'Marquis In Spades', 201, 1, 4, N'Billy Corgan', 192731, 6304789, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2479, N'Here''s To The Atom Bomb', 201, 1, 4, N'Billy Corgan', 266893, 8763140, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2480, N'Sparrow', 201, 1, 4, N'Billy Corgan', 176822, 5696989, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2481, N'Waiting', 201, 1, 4, N'Billy Corgan', 228336, 7627641, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2482, N'Saturnine', 201, 1, 4, N'Billy Corgan', 229877, 7523502, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2483, N'Rock On', 201, 1, 4, N'David Cook', 366471, 12133825, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2484, N'Set The Ray To Jerry', 201, 1, 4, N'Billy Corgan', 249364, 8215184, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2485, N'Winterlong', 201, 1, 4, N'Billy Corgan', 299389, 9670616, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2486, N'Soot & Stars', 201, 1, 4, N'Billy Corgan', 399986, 12866557, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2487, N'Blissed & Gone', 201, 1, 4, N'Billy Corgan', 286302, 9305998, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2488, N'Siva', 202, 1, 4, N'Billy Corgan', 261172, 8576622, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2489, N'Rhinocerous', 202, 1, 4, N'Billy Corgan', 353462, 11526684, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2490, N'Drown', 202, 1, 4, N'Billy Corgan', 270497, 8883496, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2491, N'Cherub Rock', 202, 1, 4, N'Billy Corgan', 299389, 9786739, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2492, N'Today', 202, 1, 4, N'Billy Corgan', 202213, 6596933, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2493, N'Disarm', 202, 1, 4, N'Billy Corgan', 198556, 6508249, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2494, N'Landslide', 202, 1, 4, N'Stevie Nicks', 190275, 6187754, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2495, N'Bullet With Butterfly Wings', 202, 1, 4, N'Billy Corgan', 257306, 8431747, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2496, N'1979', 202, 1, 4, N'Billy Corgan', 263653, 8728470, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2497, N'Zero', 202, 1, 4, N'Billy Corgan', 161123, 5267176, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2498, N'Tonight, Tonight', 202, 1, 4, N'Billy Corgan', 255686, 8351543, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2499, N'Eye', 202, 1, 4, N'Billy Corgan', 294530, 9784201, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2500, N'Ava Adore', 202, 1, 4, N'Billy Corgan', 261433, 8590412, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2501, N'Perfect', 202, 1, 4, N'Billy Corgan', 203023, 6734636, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2502, N'The Everlasting Gaze', 202, 1, 4, N'Billy Corgan', 242155, 7844404, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2503, N'Stand Inside Your Love', 202, 1, 4, N'Billy Corgan', 253753, 8270113, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2504, N'Real Love', 202, 1, 4, N'Billy Corgan', 250697, 8025896, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2505, N'[Untitled]', 202, 1, 4, N'Billy Corgan', 231784, 7689713, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2506, N'Nothing To Say', 203, 1, 1, N'Chris Cornell/Kim Thayil', 238027, 7744833, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2507, N'Flower', 203, 1, 1, N'Chris Cornell/Kim Thayil', 208822, 6830732, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2508, N'Loud Love', 203, 1, 1, N'Chris Cornell', 297456, 9660953, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2509, N'Hands All Over', 203, 1, 1, N'Chris Cornell/Kim Thayil', 362475, 11893108, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2510, N'Get On The Snake', 203, 1, 1, N'Chris Cornell/Kim Thayil', 225123, 7313744, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2511, N'Jesus Christ Pose', 203, 1, 1, N'Ben Shepherd/Chris Cornell/Kim Thayil/Matt Cameron', 352966, 11739886, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2512, N'Outshined', 203, 1, 1, N'Chris Cornell', 312476, 10274629, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2513, N'Rusty Cage', 203, 1, 1, N'Chris Cornell', 267728, 8779485, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2514, N'Spoonman', 203, 1, 1, N'Chris Cornell', 248476, 8289906, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2515, N'The Day I Tried To Live', 203, 1, 1, N'Chris Cornell', 321175, 10507137, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2516, N'Black Hole Sun', 203, 1, 1, N'Soundgarden', 320365, 10425229, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2517, N'Fell On Black Days', 203, 1, 1, N'Chris Cornell', 282331, 9256082, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2518, N'Pretty Noose', 203, 1, 1, N'Chris Cornell', 253570, 8317931, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2519, N'Burden In My Hand', 203, 1, 1, N'Chris Cornell', 292153, 9659911, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2520, N'Blow Up The Outside World', 203, 1, 1, N'Chris Cornell', 347898, 11379527, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2521, N'Ty Cobb', 203, 1, 1, N'Ben Shepherd/Chris Cornell', 188786, 6233136, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2522, N'Bleed Together', 203, 1, 1, N'Chris Cornell', 232202, 7597074, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2523, N'Morning Dance', 204, 1, 2, N'Jay Beckenstein', 238759, 8101979, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2524, N'Jubilee', 204, 1, 2, N'Jeremy Wall', 275147, 9151846, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2525, N'Rasul', 204, 1, 2, N'Jeremy Wall', 238315, 7854737, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2526, N'Song For Lorraine', 204, 1, 2, N'Jay Beckenstein', 240091, 8101723, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2527, N'Starburst', 204, 1, 2, N'Jeremy Wall', 291500, 9768399, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2528, N'Heliopolis', 204, 1, 2, N'Jay Beckenstein', 338729, 11365655, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2529, N'It Doesn''t Matter', 204, 1, 2, N'Chet Catallo', 270027, 9034177, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2530, N'Little Linda', 204, 1, 2, N'Jeremy Wall', 264019, 8958743, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2531, N'End Of Romanticism', 204, 1, 2, N'Rick Strauss', 320078, 10553155, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2532, N'The House Is Rockin''', 205, 1, 6, N'Doyle Bramhall/Stevie Ray Vaughan', 144352, 4706253, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2533, N'Crossfire', 205, 1, 6, N'B. Carter/C. Layton/R. Ellsworth/R. Wynans/T. Shannon', 251219, 8238033, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2534, N'Tightrope', 205, 1, 6, N'Doyle Bramhall/Stevie Ray Vaughan', 281155, 9254906, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2535, N'Let Me Love You Baby', 205, 1, 6, N'Willie Dixon', 164127, 5378455, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2536, N'Leave My Girl Alone', 205, 1, 6, N'B. Guy', 256365, 8438021, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2537, N'Travis Walk', 205, 1, 6, N'Stevie Ray Vaughan', 140826, 4650979, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2538, N'Wall Of Denial', 205, 1, 6, N'Doyle Bramhall/Stevie Ray Vaughan', 336927, 11085915, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2539, N'Scratch-N-Sniff', 205, 1, 6, N'Doyle Bramhall/Stevie Ray Vaughan', 163422, 5353627, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2540, N'Love Me Darlin''', 205, 1, 6, N'C. Burnett', 201586, 6650869, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2541, N'Riviera Paradise', 205, 1, 6, N'Stevie Ray Vaughan', 528692, 17232776, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2542, N'Dead And Bloated', 206, 1, 1, N'R. DeLeo/Weiland', 310386, 10170433, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2543, N'Sex Type Thing', 206, 1, 1, N'D. DeLeo/Kretz/Weiland', 218723, 7102064, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2544, N'Wicked Garden', 206, 1, 1, N'D. DeLeo/R. DeLeo/Weiland', 245368, 7989505, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2545, N'No Memory', 206, 1, 1, N'Dean Deleo', 80613, 2660859, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2546, N'Sin', 206, 1, 1, N'R. DeLeo/Weiland', 364800, 12018823, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2547, N'Naked Sunday', 206, 1, 1, N'D. DeLeo/Kretz/R. DeLeo/Weiland', 229720, 7444201, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2548, N'Creep', 206, 1, 1, N'R. DeLeo/Weiland', 333191, 10894988, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2549, N'Piece Of Pie', 206, 1, 1, N'R. DeLeo/Weiland', 324623, 10605231, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2550, N'Plush', 206, 1, 1, N'R. DeLeo/Weiland', 314017, 10229848, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2551, N'Wet My Bed', 206, 1, 1, N'R. DeLeo/Weiland', 96914, 3198627, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2552, N'Crackerman', 206, 1, 1, N'Kretz/R. DeLeo/Weiland', 194403, 6317361, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2553, N'Where The River Goes', 206, 1, 1, N'D. DeLeo/Kretz/Weiland', 505991, 16468904, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2554, N'Soldier Side - Intro', 207, 1, 3, N'Dolmayan, John/Malakian, Daron/Odadjian, Shavo', 63764, 2056079, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2555, N'B.Y.O.B.', 207, 1, 3, N'Tankian, Serj', 255555, 8407935, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2556, N'Revenga', 207, 1, 3, N'Tankian, Serj', 228127, 7503805, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2557, N'Cigaro', 207, 1, 3, N'Tankian, Serj', 131787, 4321705, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2558, N'Radio/Video', 207, 1, 3, N'Dolmayan, John/Malakian, Daron/Odadjian, Shavo', 249312, 8224917, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2559, N'This Cocaine Makes Me Feel Like I''m On This Song', 207, 1, 3, N'Tankian, Serj', 128339, 4185193, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2560, N'Violent Pornography', 207, 1, 3, N'Dolmayan, John/Malakian, Daron/Odadjian, Shavo', 211435, 6985960, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2561, N'Question!', 207, 1, 3, N'Tankian, Serj', 200698, 6616398, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2562, N'Sad Statue', 207, 1, 3, N'Tankian, Serj', 205897, 6733449, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2563, N'Old School Hollywood', 207, 1, 3, N'Dolmayan, John/Malakian, Daron/Odadjian, Shavo', 176953, 5830258, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2564, N'Lost in Hollywood', 207, 1, 3, N'Tankian, Serj', 320783, 10535158, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2565, N'The Sun Road', 208, 1, 1, N'Terry Bozzio, Steve Stevens, Tony Levin', 880640, 29008407, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2566, N'Dark Corners', 208, 1, 1, N'Terry Bozzio, Steve Stevens, Tony Levin', 513541, 16839223, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2567, N'Duende', 208, 1, 1, N'Terry Bozzio, Steve Stevens, Tony Levin', 447582, 14956771, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2568, N'Black Light Syndrome', 208, 1, 1, N'Terry Bozzio, Steve Stevens, Tony Levin', 526471, 17300835, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2569, N'Falling in Circles', 208, 1, 1, N'Terry Bozzio, Steve Stevens, Tony Levin', 549093, 18263248, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2570, N'Book of Hours', 208, 1, 1, N'Terry Bozzio, Steve Stevens, Tony Levin', 583366, 19464726, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2571, N'Chaos-Control', 208, 1, 1, N'Terry Bozzio, Steve Stevens, Tony Levin', 529841, 17455568, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2572, N'Midnight From The Inside Out', 209, 1, 6, N'Chris Robinson/Rich Robinson', 286981, 9442157, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2573, N'Sting Me', 209, 1, 6, N'Chris Robinson/Rich Robinson', 268094, 8813561, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2574, N'Thick & Thin', 209, 1, 6, N'Chris Robinson/Rich Robinson', 222720, 7284377, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2575, N'Greasy Grass River', 209, 1, 6, N'Chris Robinson/Rich Robinson', 218749, 7157045, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2576, N'Sometimes Salvation', 209, 1, 6, N'Chris Robinson/Rich Robinson', 389146, 12749424, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2577, N'Cursed Diamonds', 209, 1, 6, N'Chris Robinson/Rich Robinson', 368300, 12047978, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2578, N'Miracle To Me', 209, 1, 6, N'Chris Robinson/Rich Robinson', 372636, 12222116, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2579, N'Wiser Time', 209, 1, 6, N'Chris Robinson/Rich Robinson', 459990, 15161907, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2580, N'Girl From A Pawnshop', 209, 1, 6, N'Chris Robinson/Rich Robinson', 404688, 13250848, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2581, N'Cosmic Fiend', 209, 1, 6, N'Chris Robinson/Rich Robinson', 308401, 10115556, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2582, N'Black Moon Creeping', 210, 1, 6, N'Chris Robinson/Rich Robinson', 359314, 11740886, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2583, N'High Head Blues', 210, 1, 6, N'Chris Robinson/Rich Robinson', 371879, 12227998, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2584, N'Title Song', 210, 1, 6, N'Chris Robinson/Rich Robinson', 505521, 16501316, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2585, N'She Talks To Angels', 210, 1, 6, N'Chris Robinson/Rich Robinson', 361978, 11837342, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2586, N'Twice As Hard', 210, 1, 6, N'Chris Robinson/Rich Robinson', 275565, 9008067, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2587, N'Lickin''', 210, 1, 6, N'Chris Robinson/Rich Robinson', 314409, 10331216, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2588, N'Soul Singing', 210, 1, 6, N'Chris Robinson/Rich Robinson', 233639, 7672489, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2589, N'Hard To Handle', 210, 1, 6, N'A.Isbell/A.Jones/O.Redding', 206994, 6786304, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2590, N'Remedy', 210, 1, 6, N'Chris Robinson/Rich Robinson', 337084, 11049098, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2591, N'White Riot', 211, 1, 4, N'Joe Strummer/Mick Jones', 118726, 3922819, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2592, N'Remote Control', 211, 1, 4, N'Joe Strummer/Mick Jones', 180297, 5949647, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2593, N'Complete Control', 211, 1, 4, N'Joe Strummer/Mick Jones', 192653, 6272081, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2594, N'Clash City Rockers', 211, 1, 4, N'Joe Strummer/Mick Jones', 227500, 7555054, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2595, N'(White Man) In Hammersmith Palais', 211, 1, 4, N'Joe Strummer/Mick Jones', 240640, 7883532, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2596, N'Tommy Gun', 211, 1, 4, N'Joe Strummer/Mick Jones', 195526, 6399872, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2597, N'English Civil War', 211, 1, 4, N'Mick Jones/Traditional arr. Joe Strummer', 156708, 5111226, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2598, N'I Fought The Law', 211, 1, 4, N'Sonny Curtis', 159764, 5245258, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2599, N'London Calling', 211, 1, 4, N'Joe Strummer/Mick Jones', 199706, 6569007, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2600, N'Train In Vain', 211, 1, 4, N'Joe Strummer/Mick Jones', 189675, 6329877, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2601, N'Bankrobber', 211, 1, 4, N'Joe Strummer/Mick Jones', 272431, 9067323, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2602, N'The Call Up', 211, 1, 4, N'The Clash', 324336, 10746937, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2603, N'Hitsville UK', 211, 1, 4, N'The Clash', 261433, 8606887, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2604, N'The Magnificent Seven', 211, 1, 4, N'The Clash', 268486, 8889821, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2605, N'This Is Radio Clash', 211, 1, 4, N'The Clash', 249756, 8366573, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2606, N'Know Your Rights', 211, 1, 4, N'The Clash', 217678, 7195726, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2607, N'Rock The Casbah', 211, 1, 4, N'The Clash', 222145, 7361500, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2608, N'Should I Stay Or Should I Go', 211, 1, 4, N'The Clash', 187219, 6188688, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2609, N'War (The Process)', 212, 1, 1, N'Billy Duffy/Ian Astbury', 252630, 8254842, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2610, N'The Saint', 212, 1, 1, N'Billy Duffy/Ian Astbury', 216215, 7061584, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2611, N'Rise', 212, 1, 1, N'Billy Duffy/Ian Astbury', 219088, 7106195, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2612, N'Take The Power', 212, 1, 1, N'Billy Duffy/Ian Astbury', 235755, 7650012, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2613, N'Breathe', 212, 1, 1, N'Billy Duffy/Ian Astbury/Marti Frederiksen/Mick Jones', 299781, 9742361, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2614, N'Nico', 212, 1, 1, N'Billy Duffy/Ian Astbury', 289488, 9412323, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2615, N'American Gothic', 212, 1, 1, N'Billy Duffy/Ian Astbury', 236878, 7739840, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2616, N'Ashes And Ghosts', 212, 1, 1, N'Billy Duffy/Bob Rock/Ian Astbury', 300591, 9787692, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2617, N'Shape The Sky', 212, 1, 1, N'Billy Duffy/Ian Astbury', 209789, 6885647, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2618, N'Speed Of Light', 212, 1, 1, N'Billy Duffy/Bob Rock/Ian Astbury', 262817, 8563352, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2619, N'True Believers', 212, 1, 1, N'Billy Duffy/Ian Astbury', 308009, 9981359, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2620, N'My Bridges Burn', 212, 1, 1, N'Billy Duffy/Ian Astbury', 231862, 7571370, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2621, N'She Sells Sanctuary', 213, 1, 1, 253727, 8368634, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2622, N'Fire Woman', 213, 1, 1, 312790, 10196995, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2623, N'Lil'' Evil', 213, 1, 1, 165825, 5419655, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2624, N'Spirit Walker', 213, 1, 1, 230060, 7555897, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2625, N'The Witch', 213, 1, 1, 258768, 8725403, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2626, N'Revolution', 213, 1, 1, 256026, 8371254, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2627, N'Wild Hearted Son', 213, 1, 1, 266893, 8670550, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2628, N'Love Removal Machine', 213, 1, 1, 257619, 8412167, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2629, N'Rain', 213, 1, 1, 236669, 7788461, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2630, N'Edie (Ciao Baby)', 213, 1, 1, 241632, 7846177, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2631, N'Heart Of Soul', 213, 1, 1, 274207, 8967257, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2632, N'Love', 213, 1, 1, 326739, 10729824, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2633, N'Wild Flower', 213, 1, 1, 215536, 7084321, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2634, N'Go West', 213, 1, 1, 238158, 7777749, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2635, N'Resurrection Joe', 213, 1, 1, 255451, 8532840, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2636, N'Sun King', 213, 1, 1, 368431, 12010865, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2637, N'Sweet Soul Sister', 213, 1, 1, 212009, 6889883, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2638, N'Earth Mofo', 213, 1, 1, 282200, 9204581, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2639, N'Break on Through', 214, 1, 1, N'Robby Krieger, Ray Manzarek, John Densmore, Jim Morrison', 149342, 4943144, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2640, N'Soul Kitchen', 214, 1, 1, N'Robby Krieger, Ray Manzarek, John Densmore, Jim Morrison', 215066, 7040865, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2641, N'The Crystal Ship', 214, 1, 1, N'Robby Krieger, Ray Manzarek, John Densmore, Jim Morrison', 154853, 5052658, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2642, N'Twentienth Century Fox', 214, 1, 1, N'Robby Krieger, Ray Manzarek, John Densmore, Jim Morrison', 153913, 5069211, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2643, N'Alabama Song', 214, 1, 1, N'Weill-Brecht', 200097, 6563411, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2644, N'Light My Fire', 214, 1, 1, N'Robby Krieger, Ray Manzarek, John Densmore, Jim Morrison', 428329, 13963351, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2645, N'Back Door Man', 214, 1, 1, N'Willie Dixon, C. Burnett', 214360, 7035636, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2646, N'I Looked At You', 214, 1, 1, N'Robby Krieger, Ray Manzarek, John Densmore, Jim Morrison', 142080, 4663988, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2647, N'End Of The Night', 214, 1, 1, N'Robby Krieger, Ray Manzarek, John Densmore, Jim Morrison', 172695, 5589732, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2648, N'Take It As It Comes', 214, 1, 1, N'Robby Krieger, Ray Manzarek, John Densmore, Jim Morrison', 137168, 4512656, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2649, N'The End', 214, 1, 1, N'Robby Krieger, Ray Manzarek, John Densmore, Jim Morrison', 701831, 22927336, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2650, N'Roxanne', 215, 1, 1, N'G M Sumner', 192992, 6330159, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2651, N'Can''t Stand Losing You', 215, 1, 1, N'G M Sumner', 181159, 5971983, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2652, N'Message in a Bottle', 215, 1, 1, N'G M Sumner', 291474, 9647829, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2653, N'Walking on the Moon', 215, 1, 1, N'G M Sumner', 302080, 10019861, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2654, N'Don''t Stand so Close to Me', 215, 1, 1, N'G M Sumner', 241031, 7956658, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2655, N'De Do Do Do, De Da Da Da', 215, 1, 1, N'G M Sumner', 247196, 8227075, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2656, N'Every Little Thing She Does is Magic', 215, 1, 1, N'G M Sumner', 261120, 8646853, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2657, N'Invisible Sun', 215, 1, 1, N'G M Sumner', 225593, 7304320, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2658, N'Spirit''s in the Material World', 215, 1, 1, N'G M Sumner', 181133, 5986622, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2659, N'Every Breath You Take', 215, 1, 1, N'G M Sumner', 254615, 8364520, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2660, N'King Of Pain', 215, 1, 1, N'G M Sumner', 300512, 9880303, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2661, N'Wrapped Around Your Finger', 215, 1, 1, N'G M Sumner', 315454, 10361490, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2662, N'Don''t Stand So Close to Me ''86', 215, 1, 1, N'G M Sumner', 293590, 9636683, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2663, N'Message in a Bottle (new classic rock mix)', 215, 1, 1, N'G M Sumner', 290951, 9640349, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2664, N'Time Is On My Side', 216, 1, 1, N'Jerry Ragavoy', 179983, 5855836, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2665, N'Heart Of Stone', 216, 1, 1, N'Jagger/Richards', 164493, 5329538, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2666, N'Play With Fire', 216, 1, 1, N'Nanker Phelge', 132022, 4265297, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2667, N'Satisfaction', 216, 1, 1, N'Jagger/Richards', 226612, 7398766, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2668, N'As Tears Go By', 216, 1, 1, N'Jagger/Richards/Oldham', 164284, 5357350, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2669, N'Get Off Of My Cloud', 216, 1, 1, N'Jagger/Richards', 176013, 5719514, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2670, N'Mother''s Little Helper', 216, 1, 1, N'Jagger/Richards', 167549, 5422434, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2671, N'19th Nervous Breakdown', 216, 1, 1, N'Jagger/Richards', 237923, 7742984, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2672, N'Paint It Black', 216, 1, 1, N'Jagger/Richards', 226063, 7442888, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2673, N'Under My Thumb', 216, 1, 1, N'Jagger/Richards', 221387, 7371799, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2674, N'Ruby Tuesday', 216, 1, 1, N'Jagger/Richards', 197459, 6433467, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2675, N'Let''s Spend The Night Together', 216, 1, 1, N'Jagger/Richards', 217495, 7137048, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2676, N'Intro', 217, 1, 1, N'Jagger/Richards', 49737, 1618591, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2677, N'You Got Me Rocking', 217, 1, 1, N'Jagger/Richards', 205766, 6734385, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2678, N'Gimmie Shelters', 217, 1, 1, N'Jagger/Richards', 382119, 12528764, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2679, N'Flip The Switch', 217, 1, 1, N'Jagger/Richards', 252421, 8336591, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2680, N'Memory Motel', 217, 1, 1, N'Jagger/Richards', 365844, 11982431, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2681, N'Corinna', 217, 1, 1, N'Jesse Ed Davis III/Taj Mahal', 257488, 8449471, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2682, N'Saint Of Me', 217, 1, 1, N'Jagger/Richards', 325694, 10725160, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2683, N'Wainting On A Friend', 217, 1, 1, N'Jagger/Richards', 302497, 9978046, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2684, N'Sister Morphine', 217, 1, 1, N'Faithfull/Jagger/Richards', 376215, 12345289, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2685, N'Live With Me', 217, 1, 1, N'Jagger/Richards', 234893, 7709006, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2686, N'Respectable', 217, 1, 1, N'Jagger/Richards', 215693, 7099669, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2687, N'Thief In The Night', 217, 1, 1, N'De Beauport/Jagger/Richards', 337266, 10952756, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2688, N'The Last Time', 217, 1, 1, N'Jagger/Richards', 287294, 9498758, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2689, N'Out Of Control', 217, 1, 1, N'Jagger/Richards', 479242, 15749289, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2690, N'Love Is Strong', 218, 1, 1, N'Jagger/Richards', 230896, 7639774, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2691, N'You Got Me Rocking', 218, 1, 1, N'Jagger/Richards', 215928, 7162159, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2692, N'Sparks Will Fly', 218, 1, 1, N'Jagger/Richards', 196466, 6492847, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2693, N'The Worst', 218, 1, 1, N'Jagger/Richards', 144613, 4750094, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2694, N'New Faces', 218, 1, 1, N'Jagger/Richards', 172146, 5689122, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2695, N'Moon Is Up', 218, 1, 1, N'Jagger/Richards', 222119, 7366316, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2696, N'Out Of Tears', 218, 1, 1, N'Jagger/Richards', 327418, 10677236, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2697, N'I Go Wild', 218, 1, 1, N'Jagger/Richards', 264019, 8630833, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2698, N'Brand New Car', 218, 1, 1, N'Jagger/Richards', 256052, 8459344, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2699, N'Sweethearts Together', 218, 1, 1, N'Jagger/Richards', 285492, 9550459, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2700, N'Suck On The Jugular', 218, 1, 1, N'Jagger/Richards', 268225, 8920566, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2701, N'Blinded By Rainbows', 218, 1, 1, N'Jagger/Richards', 273946, 8971343, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2702, N'Baby Break It Down', 218, 1, 1, N'Jagger/Richards', 249417, 8197309, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2703, N'Thru And Thru', 218, 1, 1, N'Jagger/Richards', 375092, 12175406, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2704, N'Mean Disposition', 218, 1, 1, N'Jagger/Richards', 249155, 8273602, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2705, N'Walking Wounded', 219, 1, 4, N'The Tea Party', 277968, 9184345, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2706, N'Temptation', 219, 1, 4, N'The Tea Party', 205087, 6711943, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2707, N'The Messenger', 219, 1, 4, N'Daniel Lanois', 212062, 6975437, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2708, N'Psychopomp', 219, 1, 4, N'The Tea Party', 315559, 10295199, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2709, N'Sister Awake', 219, 1, 4, N'The Tea Party', 343875, 11299407, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2710, N'The Bazaar', 219, 1, 4, N'The Tea Party', 222458, 7245691, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2711, N'Save Me (Remix)', 219, 1, 4, N'The Tea Party', 396303, 13053839, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2712, N'Fire In The Head', 219, 1, 4, N'The Tea Party', 306337, 10005675, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2713, N'Release', 219, 1, 4, N'The Tea Party', 244114, 8014606, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2714, N'Heaven Coming Down', 219, 1, 4, N'The Tea Party', 241867, 7846459, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2715, N'The River (Remix)', 219, 1, 4, N'The Tea Party', 343170, 11193268, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2716, N'Babylon', 219, 1, 4, N'The Tea Party', 169795, 5568808, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2717, N'Waiting On A Sign', 219, 1, 4, N'The Tea Party', 261903, 8558590, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2718, N'Life Line', 219, 1, 4, N'The Tea Party', 277786, 9082773, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2719, N'Paint It Black', 219, 1, 4, N'Keith Richards/Mick Jagger', 214752, 7101572, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2720, N'Temptation', 220, 1, 4, N'The Tea Party', 205244, 6719465, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2721, N'Army Ants', 220, 1, 4, N'The Tea Party', 215405, 7075838, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2722, N'Psychopomp', 220, 1, 4, N'The Tea Party', 317231, 10351778, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2723, N'Gyroscope', 220, 1, 4, N'The Tea Party', 177711, 5810323, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2724, N'Alarum', 220, 1, 4, N'The Tea Party', 298187, 9712545, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2725, N'Release', 220, 1, 4, N'The Tea Party', 266292, 8725824, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2726, N'Transmission', 220, 1, 4, N'The Tea Party', 317257, 10351152, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2727, N'Babylon', 220, 1, 4, N'The Tea Party', 292466, 9601786, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2728, N'Pulse', 220, 1, 4, N'The Tea Party', 250253, 8183872, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2729, N'Emerald', 220, 1, 4, N'The Tea Party', 289750, 9543789, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2730, N'Aftermath', 220, 1, 4, N'The Tea Party', 343745, 11085607, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2731, N'I Can''t Explain', 221, 1, 1, N'Pete Townshend', 125152, 4082896, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2732, N'Anyway, Anyhow, Anywhere', 221, 1, 1, N'Pete Townshend, Roger Daltrey', 161253, 5234173, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2733, N'My Generation', 221, 1, 1, N'John Entwistle/Pete Townshend', 197825, 6446634, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2734, N'Substitute', 221, 1, 1, N'Pete Townshend', 228022, 7409995, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2735, N'I''m A Boy', 221, 1, 1, N'Pete Townshend', 157126, 5120605, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2736, N'Boris The Spider', 221, 1, 1, N'John Entwistle', 149472, 4835202, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2737, N'Happy Jack', 221, 1, 1, N'Pete Townshend', 132310, 4353063, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2738, N'Pictures Of Lily', 221, 1, 1, N'Pete Townshend', 164414, 5329751, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2739, N'I Can See For Miles', 221, 1, 1, N'Pete Townshend', 262791, 8604989, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2740, N'Magic Bus', 221, 1, 1, N'Pete Townshend', 197224, 6452700, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2741, N'Pinball Wizard', 221, 1, 1, N'John Entwistle/Pete Townshend', 181890, 6055580, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2742, N'The Seeker', 221, 1, 1, N'Pete Townshend', 204643, 6736866, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2743, N'Baba O''Riley', 221, 1, 1, N'John Entwistle/Pete Townshend', 309472, 10141660, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2744, N'Won''t Get Fooled Again (Full Length Version)', 221, 1, 1, N'John Entwistle/Pete Townshend', 513750, 16855521, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2745, N'Let''s See Action', 221, 1, 1, N'Pete Townshend', 243513, 8078418, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2746, N'5.15', 221, 1, 1, N'Pete Townshend', 289619, 9458549, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2747, N'Join Together', 221, 1, 1, N'Pete Townshend', 262556, 8602485, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2748, N'Squeeze Box', 221, 1, 1, N'Pete Townshend', 161280, 5256508, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2749, N'Who Are You (Single Edit Version)', 221, 1, 1, N'John Entwistle/Pete Townshend', 299232, 9900469, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2750, N'You Better You Bet', 221, 1, 1, N'Pete Townshend', 338520, 11160877, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2751, N'Primavera', 222, 1, 7, N'Genival Cassiano/Silvio Rochael', 126615, 4152604, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2752, N'Chocolate', 222, 1, 7, N'Tim Maia', 194690, 6411587, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2753, N'Azul Da Cor Do Mar', 222, 1, 7, N'Tim Maia', 197955, 6475007, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2754, N'O Descobridor Dos Sete Mares', 222, 1, 7, N'Gilson Mendonça/Michel', 262974, 8749583, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2755, N'Até Que Enfim Encontrei Você', 222, 1, 7, N'Tim Maia', 105064, 3477751, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2756, N'Coroné Antonio Bento', 222, 1, 7, N'Do Vale, João/Luiz Wanderley', 131317, 4340326, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2757, N'New Love', 222, 1, 7, N'Tim Maia', 237897, 7786824, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2758, N'Não Vou Ficar', 222, 1, 7, N'Tim Maia', 172068, 5642919, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2759, N'Música No Ar', 222, 1, 7, N'Tim Maia', 158511, 5184891, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2760, N'Salve Nossa Senhora', 222, 1, 7, N'Carlos Imperial/Edardo Araújo', 115461, 3827629, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2761, N'Você Fugiu', 222, 1, 7, N'Genival Cassiano', 238367, 7971147, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2762, N'Cristina Nº 2', 222, 1, 7, N'Carlos Imperial/Tim Maia', 90148, 2978589, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2763, N'Compadre', 222, 1, 7, N'Tim Maia', 171389, 5631446, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2764, N'Over Again', 222, 1, 7, N'Tim Maia', 200489, 6612634, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2765, N'Réu Confesso', 222, 1, 7, N'Tim Maia', 217391, 7189874, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2766, N'O Que Me Importa', 223, 1, 7, 153155, 4977852, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2767, N'Gostava Tanto De Você', 223, 1, 7, 253805, 8380077, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2768, N'Você', 223, 1, 7, 242599, 7911702, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2769, N'Não Quero Dinheiro', 223, 1, 7, 152607, 5031797, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2770, N'Eu Amo Você', 223, 1, 7, 242782, 7914628, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2771, N'A Festa Do Santo Reis', 223, 1, 7, 159791, 5204995, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2772, N'I Don''t Know What To Do With Myself', 223, 1, 7, 221387, 7251478, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2773, N'Padre Cícero', 223, 1, 7, 139598, 4581685, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2774, N'Nosso Adeus', 223, 1, 7, 206471, 6793270, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2775, N'Canário Do Reino', 223, 1, 7, 139337, 4552858, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2776, N'Preciso Ser Amado', 223, 1, 7, 174001, 5618895, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2777, N'Balanço', 223, 1, 7, 209737, 6890327, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2778, N'Preciso Aprender A Ser Só', 223, 1, 7, 162220, 5213894, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2779, N'Esta É A Canção', 223, 1, 7, 184450, 6069933, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2780, N'Formigueiro', 223, 1, 7, 252943, 8455132, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2781, N'Comida', 224, 1, 4, N'Titãs', 322612, 10786578, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2782, N'Go Back', 224, 1, 4, N'Titãs', 230504, 7668899, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2783, N'Prá Dizer Adeus', 224, 1, 4, N'Titãs', 222484, 7382048, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2784, N'Família', 224, 1, 4, N'Titãs', 218331, 7267458, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2785, N'Os Cegos Do Castelo', 224, 1, 4, N'Titãs', 296829, 9868187, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2786, N'O Pulso', 224, 1, 4, N'Titãs', 199131, 6566998, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2787, N'Marvin', 224, 1, 4, N'Titãs', 264359, 8741444, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2788, N'Nem 5 Minutos Guardados', 224, 1, 4, N'Titãs', 245995, 8143797, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2789, N'Flores', 224, 1, 4, N'Titãs', 215510, 7148017, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2790, N'Palavras', 224, 1, 4, N'Titãs', 158458, 5285715, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2791, N'Hereditário', 224, 1, 4, N'Titãs', 151693, 5020547, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2792, N'A Melhor Forma', 224, 1, 4, N'Titãs', 191503, 6349938, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2793, N'Cabeça Dinossauro', 224, 1, 4, N'Titãs', 37120, 1220930, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2794, N'32 Dentes', 224, 1, 4, N'Titãs', 184946, 6157904, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2795, N'Bichos Escrotos (Vinheta)', 224, 1, 4, N'Titãs', 104986, 3503755, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2796, N'Não Vou Lutar', 224, 1, 4, N'Titãs', 189988, 6308613, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2797, N'Homem Primata (Vinheta)', 224, 1, 4, N'Titãs', 34168, 1124909, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2798, N'Homem Primata', 224, 1, 4, N'Titãs', 195500, 6486470, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2799, N'Polícia (Vinheta)', 224, 1, 4, N'Titãs', 56111, 1824213, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2800, N'Querem Meu Sangue', 224, 1, 4, N'Titãs', 212401, 7069773, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2801, N'Diversão', 224, 1, 4, N'Titãs', 285936, 9531268, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2802, N'Televisão', 224, 1, 4, N'Titãs', 293668, 9776548, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2803, N'Sonifera Ilha', 225, 1, 4, N'Branco Mello/Carlos Barmack/Ciro Pessoa/Marcelo Fromer/Toni Belloto', 170684, 5678290, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2804, N'Lugar Nenhum', 225, 1, 4, N'Arnaldo Antunes/Charles Gavin/Marcelo Fromer/Sérgio Britto/Toni Bellotto', 195840, 6472780, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2805, N'Sua Impossivel Chance', 225, 1, 4, N'Nando Reis', 246622, 8073248, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2806, N'Desordem', 225, 1, 4, N'Charles Gavin/Marcelo Fromer/Sérgio Britto', 213289, 7067340, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2807, N'Não Vou Me Adaptar', 225, 1, 4, N'Arnaldo Antunes', 221831, 7304656, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2808, N'Domingo', 225, 1, 4, N'Sérgio Britto/Toni Bellotto', 208613, 6883180, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2809, N'Amanhã Não Se Sabe', 225, 1, 4, N'Sérgio Britto', 189440, 6243967, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2810, N'Caras Como Eu', 225, 1, 4, N'Toni Bellotto', 183092, 5999048, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2811, N'Senhora E Senhor', 225, 1, 4, N'Arnaldo Anutnes/Marcelo Fromer/Paulo Miklos', 203702, 6733733, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2812, N'Era Uma Vez', 225, 1, 4, N'Arnaldo Anutnes/Branco Mello/Marcelo Fromer/Sergio Brotto/Toni Bellotto', 224261, 7453156, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2813, N'Miséria', 225, 1, 4, N'Arnaldo Antunes/Britto, SergioMiklos, Paulo', 262191, 8727645, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2814, N'Insensível', 225, 1, 4, N'Sérgio Britto', 207830, 6893664, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2815, N'Eu E Ela', 225, 1, 4, N'Nando Reis', 276035, 9138846, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2816, N'Toda Cor', 225, 1, 4, N'Ciro Pressoa/Marcelo Fromer', 209084, 6939176, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2817, N'É Preciso Saber Viver', 225, 1, 4, N'Erasmo Carlos/Roberto Carlos', 251115, 8271418, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2818, N'Senhor Delegado/Eu Não Aguento', 225, 1, 4, N'Antonio Lopes', 156656, 5277983, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2819, N'Battlestar Galactica: The Story So Far', 226, 3, 18, 2622250, 490750393, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2820, N'Occupation / Precipice', 227, 3, 19, 5286953, 1054423946, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2821, N'Exodus, Pt. 1', 227, 3, 19, 2621708, 475079441, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2822, N'Exodus, Pt. 2', 227, 3, 19, 2618000, 466820021, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2823, N'Collaborators', 227, 3, 19, 2626626, 483484911, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2824, N'Torn', 227, 3, 19, 2631291, 495262585, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2825, N'A Measure of Salvation', 227, 3, 18, 2563938, 489715554, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2826, N'Hero', 227, 3, 18, 2713755, 506896959, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2827, N'Unfinished Business', 227, 3, 18, 2622038, 528499160, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2828, N'The Passage', 227, 3, 18, 2623875, 490375760, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2829, N'The Eye of Jupiter', 227, 3, 18, 2618750, 517909587, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2830, N'Rapture', 227, 3, 18, 2624541, 508406153, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2831, N'Taking a Break from All Your Worries', 227, 3, 18, 2624207, 492700163, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2832, N'The Woman King', 227, 3, 18, 2626376, 552893447, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2833, N'A Day In the Life', 227, 3, 18, 2620245, 462818231, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2834, N'Dirty Hands', 227, 3, 18, 2627961, 537648614, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2835, N'Maelstrom', 227, 3, 18, 2622372, 514154275, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2836, N'The Son Also Rises', 227, 3, 18, 2621830, 499258498, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2837, N'Crossroads, Pt. 1', 227, 3, 20, 2622622, 486233524, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2838, N'Crossroads, Pt. 2', 227, 3, 20, 2869953, 497335706, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2839, N'Genesis', 228, 3, 19, 2611986, 515671080, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2840, N'Don''t Look Back', 228, 3, 21, 2571154, 493628775, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2841, N'One Giant Leap', 228, 3, 21, 2607649, 521616246, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2842, N'Collision', 228, 3, 21, 2605480, 526182322, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2843, N'Hiros', 228, 3, 21, 2533575, 488835454, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2844, N'Better Halves', 228, 3, 21, 2573031, 549353481, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2845, N'Nothing to Hide', 228, 3, 19, 2605647, 510058181, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2846, N'Seven Minutes to Midnight', 228, 3, 21, 2613988, 515590682, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2847, N'Homecoming', 228, 3, 21, 2601351, 516015339, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2848, N'Six Months Ago', 228, 3, 19, 2602852, 505133869, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2849, N'Fallout', 228, 3, 21, 2594761, 501145440, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2850, N'The Fix', 228, 3, 21, 2600266, 507026323, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2851, N'Distractions', 228, 3, 21, 2590382, 537111289, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2852, N'Run!', 228, 3, 21, 2602602, 542936677, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2853, N'Unexpected', 228, 3, 21, 2598139, 511777758, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2854, N'Company Man', 228, 3, 21, 2601226, 493168135, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2855, N'Company Man', 228, 3, 21, 2601101, 503786316, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2856, N'Parasite', 228, 3, 21, 2602727, 487461520, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2857, N'A Tale of Two Cities', 229, 3, 19, 2636970, 513691652, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2858, N'Lost (Pilot, Part 1) [Premiere]', 230, 3, 19, 2548875, 217124866, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2859, N'Man of Science, Man of Faith (Premiere)', 231, 3, 19, 2612250, 543342028, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2860, N'Adrift', 231, 3, 19, 2564958, 502663995, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2861, N'Lost (Pilot, Part 2)', 230, 3, 19, 2436583, 204995876, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2862, N'The Glass Ballerina', 229, 3, 21, 2637458, 535729216, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2863, N'Further Instructions', 229, 3, 19, 2563980, 502041019, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2864, N'Orientation', 231, 3, 19, 2609083, 500600434, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2865, N'Tabula Rasa', 230, 3, 19, 2627105, 210526410, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2866, N'Every Man for Himself', 229, 3, 21, 2637387, 513803546, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2867, N'Everybody Hates Hugo', 231, 3, 19, 2609192, 498163145, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2868, N'Walkabout', 230, 3, 19, 2587370, 207748198, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2869, N'...And Found', 231, 3, 19, 2563833, 500330548, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2870, N'The Cost of Living', 229, 3, 19, 2637500, 505647192, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2871, N'White Rabbit', 230, 3, 19, 2571965, 201654606, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2872, N'Abandoned', 231, 3, 19, 2587041, 537348711, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2873, N'House of the Rising Sun', 230, 3, 19, 2590032, 210379525, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2874, N'I Do', 229, 3, 19, 2627791, 504676825, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2875, N'Not In Portland', 229, 3, 21, 2637303, 499061234, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2876, N'Not In Portland', 229, 3, 21, 2637345, 510546847, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2877, N'The Moth', 230, 3, 19, 2631327, 228896396, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2878, N'The Other 48 Days', 231, 3, 19, 2610625, 535256753, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2879, N'Collision', 231, 3, 19, 2564916, 475656544, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2880, N'Confidence Man', 230, 3, 19, 2615244, 223756475, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2881, N'Flashes Before Your Eyes', 229, 3, 21, 2636636, 537760755, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2882, N'Lost Survival Guide', 229, 3, 21, 2632590, 486675063, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2883, N'Solitary', 230, 3, 19, 2612894, 207045178, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2884, N'What Kate Did', 231, 3, 19, 2610250, 484583988, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2885, N'Raised By Another', 230, 3, 19, 2590459, 223623810, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2886, N'Stranger In a Strange Land', 229, 3, 21, 2636428, 505056021, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2887, N'The 23rd Psalm', 231, 3, 19, 2610416, 487401604, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2888, N'All the Best Cowboys Have Daddy Issues', 230, 3, 19, 2555492, 211743651, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2889, N'The Hunting Party', 231, 3, 21, 2611333, 520350364, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2890, N'Tricia Tanaka Is Dead', 229, 3, 21, 2635010, 548197162, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2891, N'Enter 77', 229, 3, 21, 2629796, 517521422, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2892, N'Fire + Water', 231, 3, 21, 2600333, 488458695, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2893, N'Whatever the Case May Be', 230, 3, 19, 2616410, 183867185, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2894, N'Hearts and Minds', 230, 3, 19, 2619462, 207607466, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2895, N'Par Avion', 229, 3, 21, 2629879, 517079642, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2896, N'The Long Con', 231, 3, 19, 2679583, 518376636, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2897, N'One of Them', 231, 3, 21, 2698791, 542332389, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2898, N'Special', 230, 3, 19, 2618530, 219961967, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2899, N'The Man from Tallahassee', 229, 3, 21, 2637637, 550893556, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2900, N'Exposé', 229, 3, 21, 2593760, 511338017, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2901, N'Homecoming', 230, 3, 19, 2515882, 210675221, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2902, N'Maternity Leave', 231, 3, 21, 2780416, 555244214, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2903, N'Left Behind', 229, 3, 21, 2635343, 538491964, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2904, N'Outlaws', 230, 3, 19, 2619887, 206500939, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2905, N'The Whole Truth', 231, 3, 21, 2610125, 495487014, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2906, N'...In Translation', 230, 3, 19, 2604575, 215441983, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2907, N'Lockdown', 231, 3, 21, 2610250, 543886056, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2908, N'One of Us', 229, 3, 21, 2638096, 502387276, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2909, N'Catch-22', 229, 3, 21, 2561394, 489773399, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2910, N'Dave', 231, 3, 19, 2825166, 574325829, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2911, N'Numbers', 230, 3, 19, 2609772, 214709143, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2912, N'D.O.C.', 229, 3, 21, 2616032, 518556641, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2913, N'Deus Ex Machina', 230, 3, 19, 2582009, 214996732, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2914, N'S.O.S.', 231, 3, 19, 2639541, 517979269, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2915, N'Do No Harm', 230, 3, 19, 2618487, 212039309, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2916, N'Two for the Road', 231, 3, 21, 2610958, 502404558, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2917, N'The Greater Good', 230, 3, 19, 2617784, 214130273, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2918, N'"?"', 231, 3, 19, 2782333, 528227089, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2919, N'Born to Run', 230, 3, 19, 2618619, 213772057, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2920, N'Three Minutes', 231, 3, 19, 2763666, 531556853, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2921, N'Exodus (Part 1)', 230, 3, 19, 2620747, 213107744, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2922, N'Live Together, Die Alone, Pt. 1', 231, 3, 21, 2478041, 457364940, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2923, N'Exodus (Part 2) [Season Finale]', 230, 3, 19, 2605557, 208667059, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2924, N'Live Together, Die Alone, Pt. 2', 231, 3, 19, 2656531, 503619265, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (2925, N'Exodus (Part 3) [Season Finale]', 230, 3, 19, 2619869, 197937785, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2926, N'Zoo Station', 232, 1, 1, N'U2', 276349, 9056902, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2927, N'Even Better Than The Real Thing', 232, 1, 1, N'U2', 221361, 7279392, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2928, N'One', 232, 1, 1, N'U2', 276192, 9158892, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2929, N'Until The End Of The World', 232, 1, 1, N'U2', 278700, 9132485, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2930, N'Who''s Gonna Ride Your Wild Horses', 232, 1, 1, N'U2', 316551, 10304369, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2931, N'So Cruel', 232, 1, 1, N'U2', 349492, 11527614, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2932, N'The Fly', 232, 1, 1, N'U2', 268982, 8825399, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2933, N'Mysterious Ways', 232, 1, 1, N'U2', 243826, 8062057, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2934, N'Tryin'' To Throw Your Arms Around The World', 232, 1, 1, N'U2', 232463, 7612124, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2935, N'Ultraviolet (Light My Way)', 232, 1, 1, N'U2', 330788, 10754631, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2936, N'Acrobat', 232, 1, 1, N'U2', 270288, 8824723, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2937, N'Love Is Blindness', 232, 1, 1, N'U2', 263497, 8531766, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2938, N'Beautiful Day', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 248163, 8056723, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2939, N'Stuck In A Moment You Can''t Get Out Of', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 272378, 8997366, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2940, N'Elevation', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 227552, 7479414, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2941, N'Walk On', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 296280, 9800861, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2942, N'Kite', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 266893, 8765761, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2943, N'In A Little While', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 219271, 7189647, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2944, N'Wild Honey', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 226768, 7466069, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2945, N'Peace On Earth', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 288496, 9476171, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2946, N'When I Look At The World', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 257776, 8500491, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2947, N'New York', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 330370, 10862323, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2948, N'Grace', 233, 1, 1, N'Adam Clayton, Bono, Larry Mullen, The Edge', 330657, 10877148, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2949, N'The Three Sunrises', 234, 1, 1, N'U2', 234788, 7717990, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2950, N'Spanish Eyes', 234, 1, 1, N'U2', 196702, 6392710, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2951, N'Sweetest Thing', 234, 1, 1, N'U2', 185103, 6154896, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2952, N'Love Comes Tumbling', 234, 1, 1, N'U2', 282671, 9328802, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2953, N'Bass Trap', 234, 1, 1, N'U2', 213289, 6834107, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2954, N'Dancing Barefoot', 234, 1, 1, N'Ivan Kral/Patti Smith', 287895, 9488294, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2955, N'Everlasting Love', 234, 1, 1, N'Buzz Cason/Mac Gayden', 202631, 6708932, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2956, N'Unchained Melody', 234, 1, 1, N'Alex North/Hy Zaret', 294164, 9597568, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2957, N'Walk To The Water', 234, 1, 1, N'U2', 289253, 9523336, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2958, N'Luminous Times (Hold On To Love)', 234, 1, 1, N'Brian Eno/U2', 277760, 9015513, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2959, N'Hallelujah Here She Comes', 234, 1, 1, N'U2', 242364, 8027028, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2960, N'Silver And Gold', 234, 1, 1, N'Bono', 279875, 9199746, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2961, N'Endless Deep', 234, 1, 1, N'U2', 179879, 5899070, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2962, N'A Room At The Heartbreak Hotel', 234, 1, 1, N'U2', 274546, 9015416, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2963, N'Trash, Trampoline And The Party Girl', 234, 1, 1, N'U2', 153965, 5083523, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2964, N'Vertigo', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 194612, 6329502, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2965, N'Miracle Drug', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 239124, 7760916, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2966, N'Sometimes You Can''t Make It On Your Own', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 308976, 10112863, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2967, N'Love And Peace Or Else', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 290690, 9476723, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2968, N'City Of Blinding Lights', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 347951, 11432026, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2969, N'All Because Of You', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 219141, 7198014, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2970, N'A Man And A Woman', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 270132, 8938285, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2971, N'Crumbs From Your Table', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 303568, 9892349, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2972, N'One Step Closer', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 231680, 7512912, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2973, N'Original Of The Species', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 281443, 9230041, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2974, N'Yahweh', 235, 1, 1, N'Adam Clayton, Bono, Larry Mullen & The Edge', 262034, 8636998, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2975, N'Discotheque', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 319582, 10442206, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2976, N'Do You Feel Loved', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 307539, 10122694, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2977, N'Mofo', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 349178, 11583042, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2978, N'If God Will Send His Angels', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 322533, 10563329, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2979, N'Staring At The Sun', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 276924, 9082838, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2980, N'Last Night On Earth', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 285753, 9401017, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2981, N'Gone', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 266866, 8746301, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2982, N'Miami', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 293041, 9741603, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2983, N'The Playboy Mansion', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 280555, 9274144, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2984, N'If You Wear That Velvet Dress', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 315167, 10227333, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2985, N'Please', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 302602, 9909484, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2986, N'Wake Up Dead Man', 236, 1, 1, N'Bono, The Edge, Adam Clayton, and Larry Mullen', 292832, 9515903, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2987, N'Helter Skelter', 237, 1, 1, N'Lennon, John/McCartney, Paul', 187350, 6097636, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2988, N'Van Diemen''s Land', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 186044, 5990280, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2989, N'Desire', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 179226, 5874535, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2990, N'Hawkmoon 269', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 382458, 12494987, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2991, N'All Along The Watchtower', 237, 1, 1, N'Dylan, Bob', 264568, 8623572, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2992, N'I Still Haven''t Found What I''m Looking for', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 353567, 11542247, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2993, N'Freedom For My People', 237, 1, 1, N'Mabins, Macie/Magee, Sterling/Robinson, Bobby', 38164, 1249764, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2994, N'Silver And Gold', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 349831, 11450194, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2995, N'Pride (In The Name Of Love)', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 267807, 8806361, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2996, N'Angel Of Harlem', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 229276, 7498022, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2997, N'Love Rescue Me', 237, 1, 1, N'Bono/Clayton, Adam/Dylan, Bob/Mullen Jr., Larry/The Edge', 384522, 12508716, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2998, N'When Love Comes To Town', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 255869, 8340954, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (2999, N'Heartland', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 303360, 9867748, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3000, N'God Part II', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 195604, 6497570, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3001, N'The Star Spangled Banner', 237, 1, 1, N'Hendrix, Jimi', 43232, 1385810, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3002, N'Bullet The Blue Sky', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 337005, 10993607, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3003, N'All I Want Is You', 237, 1, 1, N'Bono/Clayton, Adam/Mullen Jr., Larry/The Edge', 390243, 12729820, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3004, N'Pride (In The Name Of Love)', 238, 1, 1, N'U2', 230243, 7549085, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3005, N'New Year''s Day', 238, 1, 1, N'U2', 258925, 8491818, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3006, N'With Or Without You', 238, 1, 1, N'U2', 299023, 9765188, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3007, N'I Still Haven''t Found What I''m Looking For', 238, 1, 1, N'U2', 280764, 9306737, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3008, N'Sunday Bloody Sunday', 238, 1, 1, N'U2', 282174, 9269668, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3009, N'Bad', 238, 1, 1, N'U2', 351817, 11628058, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3010, N'Where The Streets Have No Name', 238, 1, 1, N'U2', 276218, 9042305, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3011, N'I Will Follow', 238, 1, 1, N'U2', 218253, 7184825, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3012, N'The Unforgettable Fire', 238, 1, 1, N'U2', 295183, 9684664, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3013, N'Sweetest Thing', 238, 1, 1, N'U2 & Daragh O''Toole', 183066, 6071385, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3014, N'Desire', 238, 1, 1, N'U2', 179853, 5893206, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3015, N'When Love Comes To Town', 238, 1, 1, N'U2', 258194, 8479525, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3016, N'Angel Of Harlem', 238, 1, 1, N'U2', 230217, 7527339, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3017, N'All I Want Is You', 238, 1, 1, N'U2 & Van Dyke Parks', 591986, 19202252, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3018, N'Sunday Bloody Sunday', 239, 1, 1, N'U2', 278204, 9140849, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3019, N'Seconds', 239, 1, 1, N'U2', 191582, 6352121, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3020, N'New Year''s Day', 239, 1, 1, N'U2', 336274, 11054732, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3021, N'Like A Song...', 239, 1, 1, N'U2', 287294, 9365379, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3022, N'Drowning Man', 239, 1, 1, N'U2', 254458, 8457066, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3023, N'The Refugee', 239, 1, 1, N'U2', 221283, 7374043, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3024, N'Two Hearts Beat As One', 239, 1, 1, N'U2', 243487, 7998323, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3025, N'Red Light', 239, 1, 1, N'U2', 225854, 7453704, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3026, N'Surrender', 239, 1, 1, N'U2', 333505, 11221406, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3027, N'"40"', 239, 1, 1, N'U2', 157962, 5251767, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3028, N'Zooropa', 240, 1, 1, N'U2; Bono', 392359, 12807979, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3029, N'Babyface', 240, 1, 1, N'U2; Bono', 241998, 7942573, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3030, N'Numb', 240, 1, 1, N'U2; Edge, The', 260284, 8577861, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3031, N'Lemon', 240, 1, 1, N'U2; Bono', 418324, 13988878, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3032, N'Stay (Faraway, So Close!)', 240, 1, 1, N'U2; Bono', 298475, 9785480, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3033, N'Daddy''s Gonna Pay For Your Crashed Car', 240, 1, 1, N'U2; Bono', 320287, 10609581, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3034, N'Some Days Are Better Than Others', 240, 1, 1, N'U2; Bono', 257436, 8417690, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3035, N'The First Time', 240, 1, 1, N'U2; Bono', 225697, 7247651, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3036, N'Dirty Day', 240, 1, 1, N'U2; Bono & Edge, The', 324440, 10652877, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3037, N'The Wanderer', 240, 1, 1, N'U2; Bono', 283951, 9258717, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3038, N'Breakfast In Bed', 241, 1, 8, 196179, 6513325, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3039, N'Where Did I Go Wrong', 241, 1, 8, 226742, 7485054, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3040, N'I Would Do For You', 241, 1, 8, 334524, 11193602, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3041, N'Homely Girl', 241, 1, 8, 203833, 6790788, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3042, N'Here I Am (Come And Take Me)', 241, 1, 8, 242102, 8106249, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3043, N'Kingston Town', 241, 1, 8, 226951, 7638236, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3044, N'Wear You To The Ball', 241, 1, 8, 213342, 7159527, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3045, N'(I Can''t Help) Falling In Love With You', 241, 1, 8, 207568, 6905623, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3046, N'Higher Ground', 241, 1, 8, 260179, 8665244, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3047, N'Bring Me Your Cup', 241, 1, 8, 341498, 11346114, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3048, N'C''est La Vie', 241, 1, 8, 270053, 9031661, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3049, N'Reggae Music', 241, 1, 8, 245106, 8203931, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3050, N'Superstition', 241, 1, 8, 319582, 10728099, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3051, N'Until My Dying Day', 241, 1, 8, 235807, 7886195, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3052, N'Where Have All The Good Times Gone?', 242, 1, 1, N'Ray Davies', 186723, 6063937, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3053, N'Hang ''Em High', 242, 1, 1, N'Alex Van Halen/David Lee Roth/Edward Van Halen/Michael Anthony', 210259, 6872314, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3054, N'Cathedral', 242, 1, 1, N'Alex Van Halen/David Lee Roth/Edward Van Halen/Michael Anthony', 82860, 2650998, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3055, N'Secrets', 242, 1, 1, N'Alex Van Halen/David Lee Roth/Edward Van Halen/Michael Anthony', 206968, 6803255, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3056, N'Intruder', 242, 1, 1, N'Alex Van Halen/David Lee Roth/Edward Van Halen/Michael Anthony', 100153, 3282142, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3057, N'(Oh) Pretty Woman', 242, 1, 1, N'Bill Dees/Roy Orbison', 174680, 5665828, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3058, N'Dancing In The Street', 242, 1, 1, N'Ivy Jo Hunter/Marvin Gaye/William Stevenson', 225985, 7461499, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3059, N'Little Guitars (Intro)', 242, 1, 1, N'Alex Van Halen/David Lee Roth/Edward Van Halen/Michael Anthony', 42240, 1439530, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3060, N'Little Guitars', 242, 1, 1, N'Alex Van Halen/David Lee Roth/Edward Van Halen/Michael Anthony', 228806, 7453043, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3061, N'Big Bad Bill (Is Sweet William Now)', 242, 1, 1, N'Jack Yellen/Milton Ager', 165146, 5489609, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3062, N'The Full Bug', 242, 1, 1, N'Alex Van Halen/David Lee Roth/Edward Van Halen/Michael Anthony', 201116, 6551013, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3063, N'Happy Trails', 242, 1, 1, N'Dale Evans', 65488, 2111141, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3064, N'Eruption', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, David Lee Roth, Michael Anthony', 102164, 3272891, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3065, N'Ain''t Talkin'' ''bout Love', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, David Lee Roth, Michael Anthony', 228336, 7569506, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3066, N'Runnin'' With The Devil', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, David Lee Roth, Michael Anthony', 215902, 7061901, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3067, N'Dance the Night Away', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, David Lee Roth, Michael Anthony', 185965, 6087433, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3068, N'And the Cradle Will Rock...', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, David Lee Roth, Michael Anthony', 213968, 7011402, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3069, N'Unchained', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, David Lee Roth, Michael Anthony', 208953, 6777078, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3070, N'Jump', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, David Lee Roth', 241711, 7911090, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3071, N'Panama', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, David Lee Roth', 211853, 6921784, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3072, N'Why Can''t This Be Love', 243, 1, 1, N'Van Halen', 227761, 7457655, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3073, N'Dreams', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony,/Edward Van Halen, Alex Van Halen, Michael Anthony, Sammy Hagar', 291813, 9504119, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3074, N'When It''s Love', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony,/Edward Van Halen, Alex Van Halen, Michael Anthony, Sammy Hagar', 338991, 11049966, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3075, N'Poundcake', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony,/Edward Van Halen, Alex Van Halen, Michael Anthony, Sammy Hagar', 321854, 10366978, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3076, N'Right Now', 243, 1, 1, N'Van Halen', 321828, 10503352, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3077, N'Can''t Stop Loving You', 243, 1, 1, N'Van Halen', 248502, 8107896, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3078, N'Humans Being', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony,/Edward Van Halen, Alex Van Halen, Michael Anthony, Sammy Hagar', 308950, 10014683, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3079, N'Can''t Get This Stuff No More', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony,/Edward Van Halen, Alex Van Halen, Michael Anthony, David Lee Roth', 315376, 10355753, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3080, N'Me Wise Magic', 243, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony,/Edward Van Halen, Alex Van Halen, Michael Anthony, David Lee Roth', 366053, 12013467, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3081, N'Runnin'' With The Devil', 244, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony and David Lee Roth', 216032, 7056863, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3082, N'Eruption', 244, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony and David Lee Roth', 102556, 3286026, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3083, N'You Really Got Me', 244, 1, 1, N'Ray Davies', 158589, 5194092, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3084, N'Ain''t Talkin'' ''Bout Love', 244, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony and David Lee Roth', 230060, 7617284, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3085, N'I''m The One', 244, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony and David Lee Roth', 226507, 7373922, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3086, N'Jamie''s Cryin''', 244, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony and David Lee Roth', 210546, 6946086, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3087, N'Atomic Punk', 244, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony and David Lee Roth', 182073, 5908861, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3088, N'Feel Your Love Tonight', 244, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony and David Lee Roth', 222850, 7293608, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3089, N'Little Dreamer', 244, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony and David Lee Roth', 203258, 6648122, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3090, N'Ice Cream Man', 244, 1, 1, N'John Brim', 200306, 6573145, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3091, N'On Fire', 244, 1, 1, N'Edward Van Halen, Alex Van Halen, Michael Anthony and David Lee Roth', 180636, 5879235, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3092, N'Neworld', 245, 1, 1, N'Van Halen', 105639, 3495897, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3093, N'Without You', 245, 1, 1, N'Van Halen', 390295, 12619558, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3094, N'One I Want', 245, 1, 1, N'Van Halen', 330788, 10743970, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3095, N'From Afar', 245, 1, 1, N'Van Halen', 324414, 10524554, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3096, N'Dirty Water Dog', 245, 1, 1, N'Van Halen', 327392, 10709202, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3097, N'Once', 245, 1, 1, N'Van Halen', 462837, 15378082, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3098, N'Fire in the Hole', 245, 1, 1, N'Van Halen', 331728, 10846768, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3099, N'Josephina', 245, 1, 1, N'Van Halen', 342491, 11161521, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3100, N'Year to the Day', 245, 1, 1, N'Van Halen', 514612, 16621333, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3101, N'Primary', 245, 1, 1, N'Van Halen', 86987, 2812555, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3102, N'Ballot or the Bullet', 245, 1, 1, N'Van Halen', 342282, 11212955, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3103, N'How Many Say I', 245, 1, 1, N'Van Halen', 363937, 11716855, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3104, N'Sucker Train Blues', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 267859, 8738780, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3105, N'Do It For The Kids', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 235911, 7693331, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3106, N'Big Machine', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 265613, 8673442, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3107, N'Illegal I Song', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 257750, 8483347, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3108, N'Spectacle', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 221701, 7252876, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3109, N'Fall To Pieces', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 270889, 8823096, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3110, N'Headspace', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 223033, 7237986, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3111, N'Superhuman', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 255921, 8365328, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3112, N'Set Me Free', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 247954, 8053388, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3113, N'You Got No Right', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 335412, 10991094, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3114, N'Slither', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 248398, 8118785, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3115, N'Dirty Little Thing', 246, 1, 1, N'Dave Kushner, Duff, Keith Nelson, Matt Sorum, Scott Weiland & Slash', 237844, 7732982, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3116, N'Loving The Alien', 246, 1, 1, N'Dave Kushner, Duff, Matt Sorum, Scott Weiland & Slash', 348786, 11412762, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3117, N'Pela Luz Dos Olhos Teus', 247, 1, 7, 119196, 3905715, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3118, N'A Bencao E Outros', 247, 1, 7, 421093, 14234427, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3119, N'Tudo Na Mais Santa Paz', 247, 1, 7, 222406, 7426757, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3120, N'O Velho E Aflor', 247, 1, 7, 275121, 9126828, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3121, N'Cotidiano N 2', 247, 1, 7, 55902, 1805797, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3122, N'Adeus', 247, 1, 7, 221884, 7259351, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3123, N'Samba Pra Endrigo', 247, 1, 7, 259265, 8823551, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3124, N'So Por Amor', 247, 1, 7, 236591, 7745764, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3125, N'Meu Pranto Rolou', 247, 1, 7, 181760, 6003345, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3126, N'Mulher Carioca', 247, 1, 7, 191686, 6395048, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3127, N'Um Homem Chamado Alfredo', 247, 1, 7, 151640, 4976227, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3128, N'Samba Do Jato', 247, 1, 7, 220813, 7357840, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3129, N'Oi, La', 247, 1, 7, 167053, 5562700, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3130, N'Vinicius, Poeta Do Encontro', 247, 1, 7, 336431, 10858776, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3131, N'Soneto Da Separacao', 247, 1, 7, 193880, 6277511, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3132, N'Still Of The Night', 141, 1, 3, N'Sykes', 398210, 13043817, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3133, N'Here I Go Again', 141, 1, 3, N'Marsden', 233874, 7652473, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3134, N'Is This Love', 141, 1, 3, N'Sykes', 283924, 9262360, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3135, N'Love Ain''t No Stranger', 141, 1, 3, N'Galley', 259395, 8490428, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3136, N'Looking For Love', 141, 1, 3, N'Sykes', 391941, 12769847, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3137, N'Now You''re Gone', 141, 1, 3, N'Vandenberg', 251141, 8162193, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3138, N'Slide It In', 141, 1, 3, N'Coverdale', 202475, 6615152, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3139, N'Slow An'' Easy', 141, 1, 3, N'Moody', 367255, 11961332, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3140, N'Judgement Day', 141, 1, 3, N'Vandenberg', 317074, 10326997, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3141, N'You''re Gonna Break My Hart Again', 141, 1, 3, N'Sykes', 250853, 8176847, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3142, N'The Deeper The Love', 141, 1, 3, N'Vandenberg', 262791, 8606504, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3143, N'Crying In The Rain', 141, 1, 3, N'Coverdale', 337005, 10931921, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3144, N'Fool For Your Loving', 141, 1, 3, N'Marsden/Moody', 250801, 8129820, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3145, N'Sweet Lady Luck', 141, 1, 3, N'Vandenberg', 273737, 8919163, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3146, N'Faixa Amarela', 248, 1, 7, N'Beto Gogo/Jessé Pai/Luiz Carlos/Zeca Pagodinho', 240692, 8082036, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3147, N'Posso Até Me Apaixonar', 248, 1, 7, N'Dudu Nobre', 200698, 6735526, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3148, N'Não Sou Mais Disso', 248, 1, 7, N'Jorge Aragão/Zeca Pagodinho', 225985, 7613817, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3149, N'Vivo Isolado Do Mundo', 248, 1, 7, N'Alcides Dias Lopes', 180035, 6073995, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3150, N'Coração Em Desalinho', 248, 1, 7, N'Mauro Diniz/Ratino Sigem', 185208, 6225948, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3151, N'Seu Balancê', 248, 1, 7, N'Paulinho Rezende/Toninho Geraes', 219454, 7311219, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3152, N'Vai Adiar', 248, 1, 7, N'Alcino Corrêa/Monarco', 270393, 9134882, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3153, N'Rugas', 248, 1, 7, N'Augusto Garcez/Nelson Cavaquinho', 140930, 4703182, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3154, N'Feirinha da Pavuna/Luz do Repente/Bagaço da Laranja', 248, 1, 7, N'Arlindo Cruz/Franco/Marquinhos PQD/Negro, Jovelina Pérolo/Zeca Pagodinho', 107206, 3593684, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3155, N'Sem Essa de Malandro Agulha', 248, 1, 7, N'Aldir Blanc/Jayme Vignoli', 158484, 5332668, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3156, N'Chico Não Vai na Corimba', 248, 1, 7, N'Dudu Nobre/Zeca Pagodinho', 269374, 9122188, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3157, N'Papel Principal', 248, 1, 7, N'Almir Guineto/Dedé Paraiso/Luverci Ernesto', 217495, 7325302, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3158, N'Saudade Louca', 248, 1, 7, N'Acyr Marques/Arlindo Cruz/Franco', 243591, 8136475, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3159, N'Camarão que Dorme e Onda Leva', 248, 1, 7, N'Acyi Marques/Arlindo Bruz/Braço, Beto Sem/Zeca Pagodinho', 299102, 10012231, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3160, N'Sapopemba e Maxambomba', 248, 1, 7, N'Nei Lopes/Wilson Moreira', 245394, 8268712, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3161, N'Minha Fé', 248, 1, 7, N'Murilão', 206994, 6981474, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3162, N'Lua de Ogum', 248, 1, 7, N'Ratinho/Zeca Pagodinho', 168463, 5719129, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3163, N'Samba pras moças', 248, 1, 7, N'Grazielle/Roque Ferreira', 152816, 5121366, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3164, N'Verdade', 248, 1, 7, N'Carlinhos Santana/Nelson Rufino', 332826, 11120708, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3165, N'The Brig', 229, 3, 21, 2617325, 488919543, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3166, N'.07%', 228, 3, 21, 2585794, 541715199, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3167, N'Five Years Gone', 228, 3, 21, 2587712, 530551890, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3168, N'The Hard Part', 228, 3, 21, 2601017, 475996611, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3169, N'The Man Behind the Curtain', 229, 3, 21, 2615990, 493951081, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3170, N'Greatest Hits', 229, 3, 21, 2617117, 522102916, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3171, N'Landslide', 228, 3, 21, 2600725, 518677861, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3172, N'The Office: An American Workplace (Pilot)', 249, 3, 19, 1380833, 290482361, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3173, N'Diversity Day', 249, 3, 19, 1306416, 257879716, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3174, N'Health Care', 249, 3, 19, 1321791, 260493577, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3175, N'The Alliance', 249, 3, 19, 1317125, 266203162, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3176, N'Basketball', 249, 3, 19, 1323541, 267464180, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3177, N'Hot Girl', 249, 3, 19, 1325458, 267836576, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3178, N'The Dundies', 250, 3, 19, 1253541, 246845576, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3179, N'Sexual Harassment', 250, 3, 19, 1294541, 273069146, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3180, N'Office Olympics', 250, 3, 19, 1290458, 256247623, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3181, N'The Fire', 250, 3, 19, 1288166, 266856017, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3182, N'Halloween', 250, 3, 19, 1315333, 249205209, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3183, N'The Fight', 250, 3, 19, 1320028, 277149457, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3184, N'The Client', 250, 3, 19, 1299341, 253836788, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3185, N'Performance Review', 250, 3, 19, 1292458, 256143822, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3186, N'Email Surveillance', 250, 3, 19, 1328870, 265101113, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3187, N'Christmas Party', 250, 3, 19, 1282115, 260891300, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3188, N'Booze Cruise', 250, 3, 19, 1267958, 252518021, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3189, N'The Injury', 250, 3, 19, 1275275, 253912762, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3190, N'The Secret', 250, 3, 19, 1264875, 253143200, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3191, N'The Carpet', 250, 3, 19, 1264375, 256477011, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3192, N'Boys and Girls', 250, 3, 19, 1278333, 255245729, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3193, N'Valentine''s Day', 250, 3, 19, 1270375, 253552710, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3194, N'Dwight''s Speech', 250, 3, 19, 1278041, 255001728, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3195, N'Take Your Daughter to Work Day', 250, 3, 19, 1268333, 253451012, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3196, N'Michael''s Birthday', 250, 3, 19, 1237791, 247238398, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3197, N'Drug Testing', 250, 3, 19, 1278625, 244626927, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3198, N'Conflict Resolution', 250, 3, 19, 1274583, 253808658, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3199, N'Casino Night - Season Finale', 250, 3, 19, 1712791, 327642458, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3200, N'Gay Witch Hunt', 251, 3, 19, 1326534, 276942637, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3201, N'The Convention', 251, 3, 19, 1297213, 255117055, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3202, N'The Coup', 251, 3, 19, 1276526, 267205501, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3203, N'Grief Counseling', 251, 3, 19, 1282615, 256912833, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3204, N'The Initiation', 251, 3, 19, 1280113, 251728257, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3205, N'Diwali', 251, 3, 19, 1279904, 252726644, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3206, N'Branch Closing', 251, 3, 19, 1822781, 358761786, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3207, N'The Merger', 251, 3, 19, 1801926, 345960631, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3208, N'The Convict', 251, 3, 22, 1273064, 248863427, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3209, N'A Benihana Christmas, Pts. 1 & 2', 251, 3, 22, 2519436, 515301752, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3210, N'Back from Vacation', 251, 3, 22, 1271688, 245378749, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3211, N'Traveling Salesmen', 251, 3, 22, 1289039, 250822697, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3212, N'Producer''s Cut: The Return', 251, 3, 22, 1700241, 337219980, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3213, N'Ben Franklin', 251, 3, 22, 1271938, 264168080, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3214, N'Phyllis''s Wedding', 251, 3, 22, 1271521, 258561054, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3215, N'Business School', 251, 3, 22, 1302093, 254402605, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3216, N'Cocktails', 251, 3, 22, 1272522, 259011909, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3217, N'The Negotiation', 251, 3, 22, 1767851, 371663719, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3218, N'Safety Training', 251, 3, 22, 1271229, 253054534, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3219, N'Product Recall', 251, 3, 22, 1268268, 251208610, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3220, N'Women''s Appreciation', 251, 3, 22, 1732649, 338778844, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3221, N'Beach Games', 251, 3, 22, 1676134, 333671149, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3222, N'The Job', 251, 3, 22, 2541875, 501060138, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3223, N'How to Stop an Exploding Man', 228, 3, 21, 2687103, 487881159, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3224, N'Through a Looking Glass', 229, 3, 21, 5088838, 1059546140, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3225, N'Your Time Is Gonna Come', 252, 2, 1, N'Page, Jones', 310774, 5126563, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3226, N'Battlestar Galactica, Pt. 1', 253, 3, 20, 2952702, 541359437, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3227, N'Battlestar Galactica, Pt. 2', 253, 3, 20, 2956081, 521387924, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3228, N'Battlestar Galactica, Pt. 3', 253, 3, 20, 2927802, 554509033, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3229, N'Lost Planet of the Gods, Pt. 1', 253, 3, 20, 2922547, 537812711, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3230, N'Lost Planet of the Gods, Pt. 2', 253, 3, 20, 2914664, 534343985, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3231, N'The Lost Warrior', 253, 3, 20, 2920045, 558872190, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3232, N'The Long Patrol', 253, 3, 20, 2925008, 513122217, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3233, N'The Gun On Ice Planet Zero, Pt. 1', 253, 3, 20, 2907615, 540980196, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3234, N'The Gun On Ice Planet Zero, Pt. 2', 253, 3, 20, 2924341, 546542281, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3235, N'The Magnificent Warriors', 253, 3, 20, 2924716, 570152232, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3236, N'The Young Lords', 253, 3, 20, 2863571, 587051735, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3237, N'The Living Legend, Pt. 1', 253, 3, 20, 2924507, 503641007, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3238, N'The Living Legend, Pt. 2', 253, 3, 20, 2923298, 515632754, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3239, N'Fire In Space', 253, 3, 20, 2926593, 536784757, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3240, N'War of the Gods, Pt. 1', 253, 3, 20, 2922630, 505761343, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3241, N'War of the Gods, Pt. 2', 253, 3, 20, 2923381, 487899692, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3242, N'The Man With Nine Lives', 253, 3, 20, 2956998, 577829804, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3243, N'Murder On the Rising Star', 253, 3, 20, 2935894, 551759986, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3244, N'Greetings from Earth, Pt. 1', 253, 3, 20, 2960293, 536824558, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3245, N'Greetings from Earth, Pt. 2', 253, 3, 20, 2903778, 527842860, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3246, N'Baltar''s Escape', 253, 3, 20, 2922088, 525564224, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3247, N'Experiment In Terra', 253, 3, 20, 2923548, 547982556, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3248, N'Take the Celestra', 253, 3, 20, 2927677, 512381289, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3249, N'The Hand of God', 253, 3, 20, 2924007, 536583079, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3250, N'Pilot', 254, 3, 19, 2484567, 492670102, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3251, N'Through the Looking Glass, Pt. 2', 229, 3, 21, 2617117, 550943353, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3252, N'Through the Looking Glass, Pt. 1', 229, 3, 21, 2610860, 493211809, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3253, N'Instant Karma', 255, 2, 9, 193188, 3150090, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3254, N'#9 Dream', 255, 2, 9, 278312, 4506425, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3255, N'Mother', 255, 2, 9, 287740, 4656660, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3256, N'Give Peace a Chance', 255, 2, 9, 274644, 4448025, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3257, N'Cold Turkey', 255, 2, 9, 281424, 4556003, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3258, N'Whatever Gets You Thru the Night', 255, 2, 9, 215084, 3499018, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3259, N'I''m Losing You', 255, 2, 9, 240719, 3907467, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3260, N'Gimme Some Truth', 255, 2, 9, 232778, 3780807, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3261, N'Oh, My Love', 255, 2, 9, 159473, 2612788, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3262, N'Imagine', 255, 2, 9, 192329, 3136271, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3263, N'Nobody Told Me', 255, 2, 9, 210348, 3423395, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3264, N'Jealous Guy', 255, 2, 9, 239094, 3881620, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3265, N'Working Class Hero', 255, 2, 9, 265449, 4301430, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3266, N'Power to the People', 255, 2, 9, 213018, 3466029, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3267, N'Imagine', 255, 2, 9, 219078, 3562542, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3268, N'Beautiful Boy', 255, 2, 9, 227995, 3704642, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3269, N'Isolation', 255, 2, 9, 156059, 2558399, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3270, N'Watching the Wheels', 255, 2, 9, 198645, 3237063, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3271, N'Grow Old With Me', 255, 2, 9, 149093, 2447453, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3272, N'Gimme Some Truth', 255, 2, 9, 187546, 3060083, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3273, N'[Just Like] Starting Over', 255, 2, 9, 215549, 3506308, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3274, N'God', 255, 2, 9, 260410, 4221135, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3275, N'Real Love', 255, 2, 9, 236911, 3846658, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3276, N'Sympton of the Universe', 256, 2, 1, 340890, 5489313, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3277, N'Snowblind', 256, 2, 1, 295960, 4773171, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3278, N'Black Sabbath', 256, 2, 1, 364180, 5860455, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3279, N'Fairies Wear Boots', 256, 2, 1, 392764, 6315916, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3280, N'War Pigs', 256, 2, 1, 515435, 8270194, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3281, N'The Wizard', 256, 2, 1, 282678, 4561796, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3282, N'N.I.B.', 256, 2, 1, 335248, 5399456, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3283, N'Sweet Leaf', 256, 2, 1, 354706, 5709700, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3284, N'Never Say Die', 256, 2, 1, 258343, 4173799, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3285, N'Sabbath, Bloody Sabbath', 256, 2, 1, 333622, 5373633, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3286, N'Iron Man/Children of the Grave', 256, 2, 1, 552308, 8858616, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3287, N'Paranoid', 256, 2, 1, 189171, 3071042, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3288, N'Rock You Like a Hurricane', 257, 2, 1, 255766, 4300973, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3289, N'No One Like You', 257, 2, 1, 240325, 4050259, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3290, N'The Zoo', 257, 2, 1, 332740, 5550779, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3291, N'Loving You Sunday Morning', 257, 2, 1, 339125, 5654493, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3292, N'Still Loving You', 257, 2, 1, 390674, 6491444, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3293, N'Big City Nights', 257, 2, 1, 251865, 4237651, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3294, N'Believe in Love', 257, 2, 1, 325774, 5437651, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3295, N'Rhythm of Love', 257, 2, 1, 231246, 3902834, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3296, N'I Can''t Explain', 257, 2, 1, 205332, 3482099, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3297, N'Tease Me Please Me', 257, 2, 1, 287229, 4811894, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3298, N'Wind of Change', 257, 2, 1, 315325, 5268002, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3299, N'Send Me an Angel', 257, 2, 1, 273041, 4581492, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3300, N'Jump Around', 258, 1, 17, N'E. Schrody/L. Muggerud', 217835, 8715653, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3301, N'Salutations', 258, 1, 17, N'E. Schrody/L. Dimant', 69120, 2767047, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3302, N'Put Your Head Out', 258, 1, 17, N'E. Schrody/L. Freese/L. Muggerud', 182230, 7291473, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3303, N'Top O'' The Morning To Ya', 258, 1, 17, N'E. Schrody/L. Dimant', 216633, 8667599, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3304, N'Commercial 1', 258, 1, 17, N'L. Muggerud', 7941, 319888, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3305, N'House And The Rising Sun', 258, 1, 17, N'E. Schrody/J. Vasquez/L. Dimant', 219402, 8778369, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3306, N'Shamrocks And Shenanigans', 258, 1, 17, N'E. Schrody/L. Dimant', 218331, 8735518, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3307, N'House Of Pain Anthem', 258, 1, 17, N'E. Schrody/L. Dimant', 155611, 6226713, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3308, N'Danny Boy, Danny Boy', 258, 1, 17, N'E. Schrody/L. Muggerud', 114520, 4583091, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3309, N'Guess Who''s Back', 258, 1, 17, N'E. Schrody/L. Muggerud', 238393, 9537994, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3310, N'Commercial 2', 258, 1, 17, N'L. Muggerud', 21211, 850698, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3311, N'Put On Your Shit Kickers', 258, 1, 17, N'E. Schrody/L. Muggerud', 190432, 7619569, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3312, N'Come And Get Some Of This', 258, 1, 17, N'E. Schrody/L. Muggerud/R. Medrano', 170475, 6821279, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3313, N'Life Goes On', 258, 1, 17, N'E. Schrody/R. Medrano', 163030, 6523458, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3314, N'One For The Road', 258, 1, 17, N'E. Schrody/L. Dimant/L. Muggerud', 170213, 6810820, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3315, N'Feel It', 258, 1, 17, N'E. Schrody/R. Medrano', 239908, 9598588, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3316, N'All My Love', 258, 1, 17, N'E. Schrody/L. Dimant', 200620, 8027065, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3317, N'Jump Around (Pete Rock Remix)', 258, 1, 17, N'E. Schrody/L. Muggerud', 236120, 9447101, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3318, N'Shamrocks And Shenanigans (Boom Shalock Lock Boom/Butch Vig Mix)', 258, 1, 17, N'E. Schrody/L. Dimant', 237035, 9483705, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3319, N'Instinto Colectivo', 259, 1, 15, 300564, 12024875, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3320, N'Chapa o Coco', 259, 1, 15, 143830, 5755478, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3321, N'Prostituta', 259, 1, 15, 359000, 14362307, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3322, N'Eu So Queria Sumir', 259, 1, 15, 269740, 10791921, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3323, N'Tres Reis', 259, 1, 15, 304143, 12168015, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3324, N'Um Lugar ao Sol', 259, 1, 15, 212323, 8495217, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3325, N'Batalha Naval', 259, 1, 15, 285727, 11431382, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3326, N'Todo o Carnaval tem seu Fim', 259, 1, 15, 237426, 9499371, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3327, N'O Misterio do Samba', 259, 1, 15, 226142, 9047970, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3328, N'Armadura', 259, 1, 15, 232881, 9317533, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3329, N'Na Ladeira', 259, 1, 15, 221570, 8865099, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3330, N'Carimbo', 259, 1, 15, 328751, 13152314, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3331, N'Catimbo', 259, 1, 15, 254484, 10181692, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3332, N'Funk de Bamba', 259, 1, 15, 237322, 9495184, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3333, N'Chega no Suingue', 259, 1, 15, 221805, 8874509, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3334, N'Mun-Ra', 259, 1, 15, 274651, 10988338, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3335, N'Freestyle Love', 259, 1, 15, 318484, 12741680, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3336, N'War Pigs', 260, 4, 23, 234013, 8052374, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3337, N'Past, Present, and Future', 261, 3, 21, 2492867, 490796184, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3338, N'The Beginning of the End', 261, 3, 21, 2611903, 526865050, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3339, N'LOST Season 4 Trailer', 261, 3, 21, 112712, 20831818, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3340, N'LOST In 8:15', 261, 3, 21, 497163, 98460675, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3341, N'Confirmed Dead', 261, 3, 21, 2611986, 512168460, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3342, N'The Economist', 261, 3, 21, 2609025, 516934914, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3343, N'Eggtown', 261, 3, 19, 2608817, 501061240, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3344, N'The Constant', 261, 3, 21, 2611569, 520209363, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3345, N'The Other Woman', 261, 3, 21, 2605021, 513246663, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3346, N'Ji Yeon', 261, 3, 19, 2588797, 506458858, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3347, N'Meet Kevin Johnson', 261, 3, 19, 2612028, 504132981, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3348, N'The Shape of Things to Come', 261, 3, 21, 2591299, 502284266, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3349, N'Amanda', 262, 5, 2, N'Luca Gusella', 246503, 4011615, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3350, N'Despertar', 262, 5, 2, N'Andrea Dulbecco', 307385, 4821485, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3351, N'Din Din Wo (Little Child)', 263, 5, 16, N'Habib Koité', 285837, 4615841, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3352, N'Distance', 264, 5, 15, N'Karsh Kale/Vishal Vaid', 327122, 5327463, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3353, N'I Guess You''re Right', 265, 5, 1, N'Darius "Take One" Minwalla/Jon Auer/Ken Stringfellow/Matt Harris', 212044, 3453849, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3354, N'I Ka Barra (Your Work)', 263, 5, 16, N'Habib Koité', 300605, 4855457, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3355, N'Love Comes', 265, 5, 1, N'Darius "Take One" Minwalla/Jon Auer/Ken Stringfellow/Matt Harris', 199923, 3240609, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3356, N'Muita Bobeira', 266, 5, 7, N'Luciana Souza', 172710, 2775071, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3357, N'OAM''s Blues', 267, 5, 2, N'Aaron Goldberg', 266936, 4292028, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3358, N'One Step Beyond', 264, 5, 15, N'Karsh Kale', 366085, 6034098, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3359, N'Symphony No. 3 in E-flat major, Op. 55, "Eroica" - Scherzo: Allegro Vivace', 268, 5, 24, N'Ludwig van Beethoven', 356426, 5817216, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3360, N'Something Nice Back Home', 261, 3, 21, 2612779, 484711353, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3361, N'Cabin Fever', 261, 3, 21, 2612028, 477733942, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3362, N'There''s No Place Like Home, Pt. 1', 261, 3, 21, 2609526, 522919189, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3363, N'There''s No Place Like Home, Pt. 2', 261, 3, 21, 2497956, 523748920, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3364, N'There''s No Place Like Home, Pt. 3', 261, 3, 21, 2582957, 486161766, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3365, N'Say Hello 2 Heaven', 269, 2, 23, 384497, 6477217, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3366, N'Reach Down', 269, 2, 23, 672773, 11157785, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3367, N'Hunger Strike', 269, 2, 23, 246292, 4233212, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3368, N'Pushin Forward Back', 269, 2, 23, 225278, 3892066, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3369, N'Call Me a Dog', 269, 2, 23, 304458, 5177612, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3370, N'Times of Trouble', 269, 2, 23, 342539, 5795951, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3371, N'Wooden Jesus', 269, 2, 23, 250565, 4302603, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3372, N'Your Savior', 269, 2, 23, 244226, 4199626, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3373, N'Four Walled World', 269, 2, 23, 414474, 6964048, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3374, N'All Night Thing', 269, 2, 23, 231803, 3997982, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3375, N'No Such Thing', 270, 2, 23, N'Chris Cornell', 224837, 3691272, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3376, N'Poison Eye', 270, 2, 23, N'Chris Cornell', 237120, 3890037, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3377, N'Arms Around Your Love', 270, 2, 23, N'Chris Cornell', 214016, 3516224, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3378, N'Safe and Sound', 270, 2, 23, N'Chris Cornell', 256764, 4207769, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3379, N'She''ll Never Be Your Man', 270, 2, 23, N'Chris Cornell', 204078, 3355715, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3380, N'Ghosts', 270, 2, 23, N'Chris Cornell', 231547, 3799745, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3381, N'Killing Birds', 270, 2, 23, N'Chris Cornell', 218498, 3588776, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3382, N'Billie Jean', 270, 2, 23, N'Michael Jackson', 281401, 4606408, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3383, N'Scar On the Sky', 270, 2, 23, N'Chris Cornell', 220193, 3616618, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3384, N'Your Soul Today', 270, 2, 23, N'Chris Cornell', 205959, 3385722, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3385, N'Finally Forever', 270, 2, 23, N'Chris Cornell', 217035, 3565098, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3386, N'Silence the Voices', 270, 2, 23, N'Chris Cornell', 267376, 4379597, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3387, N'Disappearing Act', 270, 2, 23, N'Chris Cornell', 273320, 4476203, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3388, N'You Know My Name', 270, 2, 23, N'Chris Cornell', 240255, 3940651, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3389, N'Revelations', 271, 2, 23, 252376, 4111051, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3390, N'One and the Same', 271, 2, 23, 217732, 3559040, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3391, N'Sound of a Gun', 271, 2, 23, 260154, 4234990, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3392, N'Until We Fall', 271, 2, 23, 230758, 3766605, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3393, N'Original Fire', 271, 2, 23, 218916, 3577821, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3394, N'Broken City', 271, 2, 23, 228366, 3728955, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3395, N'Somedays', 271, 2, 23, 213831, 3497176, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3396, N'Shape of Things to Come', 271, 2, 23, 274597, 4465399, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3397, N'Jewel of the Summertime', 271, 2, 23, 233242, 3806103, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3398, N'Wide Awake', 271, 2, 23, 266308, 4333050, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3399, N'Nothing Left to Say But Goodbye', 271, 2, 23, 213041, 3484335, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3400, N'Moth', 271, 2, 23, 298049, 4838884, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3401, N'Show Me How to Live (Live at the Quart Festival)', 271, 2, 23, 301974, 4901540, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3402, N'Band Members Discuss trackss from "Revelations"', 271, 3, 23, 294294, 61118891, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3403, N'Intoitus: Adorate Deum', 272, 2, 24, N'Anonymous', 245317, 4123531, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3404, N'Miserere mei, Deus', 273, 2, 24, N'Gregorio Allegri', 501503, 8285941, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3405, N'Canon and Gigue in D Major: I. Canon', 274, 2, 24, N'Johann Pachelbel', 271788, 4438393, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3406, N'Concerto No. 1 in E Major, RV 269 "Spring": I. Allegro', 275, 2, 24, N'Antonio Vivaldi', 199086, 3347810, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3407, N'Concerto for 2 Violins in D Minor, BWV 1043: I. Vivace', 276, 2, 24, N'Johann Sebastian Bach', 193722, 3192890, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3408, N'Aria Mit 30 Veränderungen, BWV 988 "Goldberg Variations": Aria', 277, 2, 24, N'Johann Sebastian Bach', 120463, 2081895, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3409, N'Suite for Solo Cello No. 1 in G Major, BWV 1007: I. Prélude', 278, 2, 24, N'Johann Sebastian Bach', 143288, 2315495, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3410, N'The Messiah: Behold, I Tell You a Mystery... The Trumpet Shall Sound', 279, 2, 24, N'George Frideric Handel', 582029, 9553140, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3411, N'Solomon HWV 67: The Arrival of the Queen of Sheba', 280, 2, 24, N'George Frideric Handel', 197135, 3247914, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3412, N'"Eine Kleine Nachtmusik" Serenade In G, K. 525: I. Allegro', 281, 2, 24, N'Wolfgang Amadeus Mozart', 348971, 5760129, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3413, N'Concerto for Clarinet in A Major, K. 622: II. Adagio', 282, 2, 24, N'Wolfgang Amadeus Mozart', 394482, 6474980, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3414, N'Symphony No. 104 in D Major "London": IV. Finale: Spiritoso', 283, 4, 24, N'Franz Joseph Haydn', 306687, 10085867, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3415, N'Symphony No.5 in C Minor: I. Allegro con brio', 284, 2, 24, N'Ludwig van Beethoven', 392462, 6419730, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3416, N'Ave Maria', 285, 2, 24, N'Franz Schubert', 338243, 5605648, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3417, N'Nabucco: Chorus, "Va, Pensiero, Sull''ali Dorate"', 286, 2, 24, N'Giuseppe Verdi', 274504, 4498583, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3418, N'Die Walküre: The Ride of the Valkyries', 287, 2, 24, N'Richard Wagner', 189008, 3114209, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3419, N'Requiem, Op.48: 4. Pie Jesu', 288, 2, 24, N'Gabriel Fauré', 258924, 4314850, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3420, N'The Nutcracker, Op. 71a, Act II: Scene 14: Pas de deux: Dance of the Prince & the Sugar-Plum Fairy', 289, 2, 24, N'Peter Ilyich Tchaikovsky', 304226, 5184289, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3421, N'Nimrod (Adagio) from Variations On an Original Theme, Op. 36 "Enigma"', 290, 2, 24, N'Edward Elgar', 250031, 4124707, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3422, N'Madama Butterfly: Un Bel Dì Vedremo', 291, 2, 24, N'Giacomo Puccini', 277639, 4588197, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3423, N'Jupiter, the Bringer of Jollity', 292, 2, 24, N'Gustav Holst', 522099, 8547876, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3424, N'Turandot, Act III, Nessun dorma!', 293, 2, 24, N'Giacomo Puccini', 176911, 2920890, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3425, N'Adagio for Strings from the String Quartet, Op. 11', 294, 2, 24, N'Samuel Barber', 596519, 9585597, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3426, N'Carmina Burana: O Fortuna', 295, 2, 24, N'Carl Orff', 156710, 2630293, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3427, N'Fanfare for the Common Man', 296, 2, 24, N'Aaron Copland', 198064, 3211245, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3428, N'Branch Closing', 251, 3, 22, 1814855, 360331351, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3429, N'The Return', 251, 3, 22, 1705080, 343877320, 1.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3430, N'Toccata and Fugue in D Minor, BWV 565: I. Toccata', 297, 2, 24, N'Johann Sebastian Bach', 153901, 2649938, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3431, N'Symphony No.1 in D Major, Op.25 "Classical", Allegro Con Brio', 298, 2, 24, N'Sergei Prokofiev', 254001, 4195542, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3432, N'Scheherazade, Op. 35: I. The Sea and Sindbad''s Ship', 299, 2, 24, N'Nikolai Rimsky-Korsakov', 545203, 8916313, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3433, N'Concerto No.2 in F Major, BWV1047, I. Allegro', 300, 2, 24, N'Johann Sebastian Bach', 307244, 5064553, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3434, N'Concerto for Piano No. 2 in F Minor, Op. 21: II. Larghetto', 301, 2, 24, N'Frédéric Chopin', 560342, 9160082, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3435, N'Cavalleria Rusticana \ Act \ Intermezzo Sinfonico', 302, 2, 24, N'Pietro Mascagni', 243436, 4001276, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3436, N'Karelia Suite, Op.11: 2. Ballade (Tempo Di Menuetto)', 303, 2, 24, N'Jean Sibelius', 406000, 5908455, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3437, N'Piano Sonata No. 14 in C Sharp Minor, Op. 27, No. 2, "Moonlight": I. Adagio sostenuto', 304, 2, 24, N'Ludwig van Beethoven', 391000, 6318740, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3438, N'Fantasia On Greensleeves', 280, 2, 24, N'Ralph Vaughan Williams', 268066, 4513190, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3439, N'Das Lied Von Der Erde, Von Der Jugend', 305, 2, 24, N'Gustav Mahler', 223583, 3700206, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3440, N'Concerto for Cello and Orchestra in E minor, Op. 85: I. Adagio - Moderato', 306, 2, 24, N'Edward Elgar', 483133, 7865479, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3441, N'Two Fanfares for Orchestra: II. Short Ride in a Fast Machine', 307, 2, 24, N'John Adams', 254930, 4310896, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3442, N'Wellington''s Victory or the Battle Symphony, Op.91: 2. Symphony of Triumph', 308, 2, 24, N'Ludwig van Beethoven', 412000, 6965201, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3443, N'Missa Papae Marcelli: Kyrie', 309, 2, 24, N'Giovanni Pierluigi da Palestrina', 240666, 4244149, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3444, N'Romeo et Juliette: No. 11 - Danse des Chevaliers', 310, 2, 24, 275015, 4519239, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3445, N'On the Beautiful Blue Danube', 311, 2, 24, N'Johann Strauss II', 526696, 8610225, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3446, N'Symphonie Fantastique, Op. 14: V. Songe d''une nuit du sabbat', 312, 2, 24, N'Hector Berlioz', 561967, 9173344, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3447, N'Carmen: Overture', 313, 2, 24, N'Georges Bizet', 132932, 2189002, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3448, N'Lamentations of Jeremiah, First Set \ Incipit Lamentatio', 314, 2, 24, N'Thomas Tallis', 69194, 1208080, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3449, N'Music for the Royal Fireworks, HWV351 (1749): La Réjouissance', 315, 2, 24, N'George Frideric Handel', 120000, 2193734, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3450, N'Peer Gynt Suite No.1, Op.46: 1. Morning Mood', 316, 2, 24, N'Edvard Grieg', 253422, 4298769, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3451, N'Die Zauberflöte, K.620: "Der Hölle Rache Kocht in Meinem Herze"', 317, 2, 25, N'Wolfgang Amadeus Mozart', 174813, 2861468, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3452, N'SCRIABIN: Prelude in B Major, Op. 11, No. 11', 318, 4, 24, 101293, 3819535, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3453, N'Pavan, Lachrimae Antiquae', 319, 2, 24, N'John Dowland', 253281, 4211495, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3454, N'Symphony No. 41 in C Major, K. 551, "Jupiter": IV. Molto allegro', 320, 2, 24, N'Wolfgang Amadeus Mozart', 362933, 6173269, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3455, N'Rehab', 321, 2, 14, 213240, 3416878, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3456, N'You Know I''m No Good', 321, 2, 14, 256946, 4133694, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3457, N'Me & Mr. Jones', 321, 2, 14, 151706, 2449438, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3458, N'Just Friends', 321, 2, 14, 191933, 3098906, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3459, N'Back to Black', 321, 2, 14, N'Mark Ronson', 240320, 3852953, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3460, N'Love Is a Losing Game', 321, 2, 14, 154386, 2509409, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3461, N'Tears Dry On Their Own', 321, 2, 14, N'Nickolas Ashford & Valerie Simpson', 185293, 2996598, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3462, N'Wake Up Alone', 321, 2, 14, N'Paul O''duffy', 221413, 3576773, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3463, N'Some Unholy War', 321, 2, 14, 141520, 2304465, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3464, N'He Can Only Hold Her', 321, 2, 14, N'Richard Poindexter & Robert Poindexter', 166680, 2666531, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3465, N'You Know I''m No Good (feat. Ghostface Killah)', 321, 2, 14, 202320, 3260658, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3466, N'Rehab (Hot Chip Remix)', 321, 2, 14, 418293, 6670600, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3467, N'Intro / Stronger Than Me', 322, 2, 9, 234200, 3832165, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3468, N'You Sent Me Flying / Cherry', 322, 2, 9, 409906, 6657517, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3469, N'F**k Me Pumps', 322, 2, 9, N'Salaam Remi', 200253, 3324343, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3470, N'I Heard Love Is Blind', 322, 2, 9, 129666, 2190831, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3471, N'(There Is) No Greater Love (Teo Licks)', 322, 2, 9, N'Isham Jones & Marty Symes', 167933, 2773507, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3472, N'In My Bed', 322, 2, 9, N'Salaam Remi', 315960, 5211774, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3473, N'Take the Box', 322, 2, 9, N'Luke Smith', 199160, 3281526, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3474, N'October Song', 322, 2, 9, N'Matt Rowe & Stefan Skarbek', 204846, 3358125, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3475, N'What Is It About Men', 322, 2, 9, N'Delroy "Chris" Cooper, Donovan Jackson, Earl Chinna Smith, Felix Howard, Gordon Williams, Luke Smith, Paul Watson & Wilburn Squiddley Cole', 209573, 3426106, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3476, N'Help Yourself', 322, 2, 9, N'Freddy James, Jimmy hogarth & Larry Stock', 300884, 5029266, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3477, N'Amy Amy Amy (Outro)', 322, 2, 9, N'Astor Campbell, Delroy "Chris" Cooper, Donovan Jackson, Dorothy Fields, Earl Chinna Smith, Felix Howard, Gordon Williams, James Moody, Jimmy McHugh, Matt Rowe, Salaam Remi & Stefan Skarbek', 663426, 10564704, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3478, N'Slowness', 323, 2, 23, 215386, 3644793, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3479, N'Prometheus Overture, Op. 43', 324, 4, 24, N'Ludwig van Beethoven', 339567, 10887931, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3480, N'Sonata for Solo Violin: IV: Presto', 325, 4, 24, N'Béla Bartók', 299350, 9785346, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3481, N'A Midsummer Night''s Dream, Op.61 Incidental Music: No.7 Notturno', 326, 2, 24, 387826, 6497867, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3482, N'Suite No. 3 in D, BWV 1068: III. Gavotte I & II', 327, 2, 24, N'Johann Sebastian Bach', 225933, 3847164, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3483, N'Concert pour 4 Parties de V**les, H. 545: I. Prelude', 328, 2, 24, N'Marc-Antoine Charpentier', 110266, 1973559, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3484, N'Adios nonino', 329, 2, 24, N'Astor Piazzolla', 289388, 4781384, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3485, N'Symphony No. 3 Op. 36 for Orchestra and Soprano "Symfonia Piesni Zalosnych" \ Lento E Largo - Tranquillissimo', 330, 2, 24, N'Henryk Górecki', 567494, 9273123, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3486, N'Act IV, Symphony', 331, 2, 24, N'Henry Purcell', 364296, 5987695, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3487, N'3 Gymnopédies: No.1 - Lent Et Grave, No.3 - Lent Et Douloureux', 332, 2, 24, N'Erik Satie', 385506, 6458501, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3488, N'Music for the Funeral of Queen Mary: VI. "Thou Knowest, Lord, the Secrets of Our Hearts"', 333, 2, 24, N'Henry Purcell', 142081, 2365930, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3489, N'Symphony No. 2: III. Allegro vivace', 334, 2, 24, N'Kurt Weill', 376510, 6129146, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3490, N'Partita in E Major, BWV 1006A: I. Prelude', 335, 2, 24, N'Johann Sebastian Bach', 285673, 4744929, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3491, N'Le Sacre Du Printemps: I.iv. Spring Rounds', 336, 2, 24, N'Igor Stravinsky', 234746, 4072205, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3492, N'Sing Joyfully', 314, 2, 24, N'William Byrd', 133768, 2256484, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3493, N'Metopes, Op. 29: Calypso', 337, 2, 24, N'Karol Szymanowski', 333669, 5548755, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3494, N'Symphony No. 2, Op. 16 -  "The Four Temperaments": II. Allegro Comodo e Flemmatico', 338, 2, 24, N'Carl Nielsen', 286998, 4834785, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3495, N'24 Caprices, Op. 1, No. 24, for Solo Violin, in A Minor', 339, 2, 24, N'Niccolò Paganini', 265541, 4371533, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3496, N'Étude 1, In C Major - Preludio (Presto) - Liszt', 340, 4, 24, 51780, 2229617, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3497, N'Erlkonig, D.328', 341, 2, 24, 261849, 4307907, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3498, N'Concerto for Violin, Strings and Continuo in G Major, Op. 3, No. 9: I. Allegro', 342, 4, 24, N'Pietro Antonio Locatelli', 493573, 16454937, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, milliseconds, bytes, unit_price) VALUES (3499, N'Pini Di Roma (Pinien Von Rom) \ I Pini Della Via Appia', 343, 2, 24, 286741, 4718950, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3500, N'String Quartet No. 12 in C Minor, D. 703 "Quartettsatz": II. Andante - Allegro assai', 344, 2, 24, N'Franz Schubert', 139200, 2283131, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3501, N'L''orfeo, Act 3, Sinfonia (Orchestra)', 345, 2, 24, N'Claudio Monteverdi', 66639, 1189062, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3502, N'Quintet for Horn, Violin, 2 Violas, and Cello in E Flat Major, K. 407/386c: III. Allegro', 346, 2, 24, N'Wolfgang Amadeus Mozart', 221331, 3665114, 0.99);
INSERT INTO tracks (id, name, album_id, media_type_id, genre_id, composer, milliseconds, bytes, unit_price) VALUES (3503, N'Koyaanisqatsi', 347, 2, 10, N'Philip Glass', 206005, 3305164, 0.99);

INSERT INTO playlists (id, name) VALUES (1, N'Music');
INSERT INTO playlists (id, name) VALUES (2, N'Movies');
INSERT INTO playlists (id, name) VALUES (3, N'TV Shows');
INSERT INTO playlists (id, name) VALUES (4, N'Audiobooks');
INSERT INTO playlists (id, name) VALUES (5, N'90’s Music');
INSERT INTO playlists (id, name) VALUES (6, N'Audiobooks');
INSERT INTO playlists (id, name) VALUES (7, N'Movies');
INSERT INTO playlists (id, name) VALUES (8, N'Music');
INSERT INTO playlists (id, name) VALUES (9, N'Music Videos');
INSERT INTO playlists (id, name) VALUES (10, N'TV Shows');
INSERT INTO playlists (id, name) VALUES (11, N'Brazilian Music');
INSERT INTO playlists (id, name) VALUES (12, N'Classical');
INSERT INTO playlists (id, name) VALUES (13, N'Classical 101 - Deep Cuts');
INSERT INTO playlists (id, name) VALUES (14, N'Classical 101 - Next Steps');
INSERT INTO playlists (id, name) VALUES (15, N'Classical 101 - The Basics');
INSERT INTO playlists (id, name) VALUES (16, N'Grunge');
INSERT INTO playlists (id, name) VALUES (17, N'Heavy Metal Classic');
INSERT INTO playlists (id, name) VALUES (18, N'On-The-Go 1');

INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3402);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3389);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3390);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3391);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3392);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3393);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3394);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3395);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3396);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3397);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3398);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3399);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3400);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3401);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3336);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3478);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3375);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3376);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3377);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3378);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3379);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3380);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3381);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3382);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3383);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3384);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3385);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3386);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3387);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3388);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3365);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3366);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3367);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3368);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3369);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3370);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3371);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3372);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3373);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 3374);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 99);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 100);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 101);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 102);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 103);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 104);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 105);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 106);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 107);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 108);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 109);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 110);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 166);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 167);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 168);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 169);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 170);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 171);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 172);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 173);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 174);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 175);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 176);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 177);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 178);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 179);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 180);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 181);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 182);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2591);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2592);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2593);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2594);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2595);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2596);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2597);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2598);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2599);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2600);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2601);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2602);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2603);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2604);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2605);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2606);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2607);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 2608);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 923);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 924);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 925);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 926);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 927);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 928);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 929);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 930);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 931);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 932);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 933);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 934);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 935);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 936);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 937);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 938);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 939);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 940);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 941);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 942);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 943);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 944);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 945);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 946);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 947);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 948);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 964);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 965);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 966);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 967);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 968);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 969);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 970);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 971);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 972);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 973);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (1, 974);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3250);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2819);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2820);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2821);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2822);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2823);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2824);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2825);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2826);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2827);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2828);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2829);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2830);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2831);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2832);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2833);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2834);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2835);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2836);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2837);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2838);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3226);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3227);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3228);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3229);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3230);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3231);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3232);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3233);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3234);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3235);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3236);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3237);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3238);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3239);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3240);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3241);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3242);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3243);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3244);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3245);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3246);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3247);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3248);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3249);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2839);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2840);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2841);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2842);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2843);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2844);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2845);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2846);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2847);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2848);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2849);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2850);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2851);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2852);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2853);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2854);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2855);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2856);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3166);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3167);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3168);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3171);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3223);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2858);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2861);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2865);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2868);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2871);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2873);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2877);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2880);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2883);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2885);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2888);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2893);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2894);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2898);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2901);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2904);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2906);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2911);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2913);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2915);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2917);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2919);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2921);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2923);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2925);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2859);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2860);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2864);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2867);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2869);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2872);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2878);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2879);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2884);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2887);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2889);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2892);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2896);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2897);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2902);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2905);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2907);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2910);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2914);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2916);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2918);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2920);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2922);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2924);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2857);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2862);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2863);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2866);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2870);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2874);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2875);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2876);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2881);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2882);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2886);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2890);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2891);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2895);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2899);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2900);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2903);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2908);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2909);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 2912);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3165);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3169);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3170);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3252);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3224);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3251);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3340);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3339);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3338);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3337);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3341);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3345);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3342);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3346);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3343);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3347);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3344);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3348);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3360);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3361);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3362);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3363);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3364);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3172);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3173);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3174);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3175);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3176);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3177);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3178);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3179);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3180);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3181);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3182);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3183);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3184);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3185);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3186);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3187);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3188);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3189);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3190);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3191);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3192);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3193);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3194);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3195);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3196);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3197);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3198);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3199);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3200);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3201);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3202);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3203);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3204);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3205);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3206);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3428);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3207);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3208);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3209);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3210);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3211);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3212);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3429);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3213);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3214);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3215);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3216);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3217);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3218);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3219);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3220);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3221);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (3, 3222);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 51);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 52);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 53);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 54);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 55);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 56);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 57);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 58);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 59);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 60);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 61);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 62);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 798);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 799);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 800);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 801);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 802);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 803);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 804);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 805);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 806);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3225);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1325);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1326);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1327);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1328);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1329);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1330);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1331);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1332);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1333);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1334);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1557);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2506);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2591);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2592);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2593);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2594);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2595);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2596);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2597);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2598);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2599);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2600);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2601);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2602);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2603);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2604);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2605);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2606);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2607);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2608);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2627);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2631);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2638);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1158);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1159);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1160);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1161);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1162);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1163);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1164);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1165);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1166);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1167);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1168);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1169);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1170);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1171);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1172);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1173);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1174);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1175);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1176);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1177);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1178);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1179);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1180);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1181);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1182);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1183);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1184);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1185);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1186);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1187);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1414);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1415);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1416);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1417);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1418);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1419);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1420);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1421);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1422);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1423);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1424);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1425);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1426);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1427);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1428);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1429);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1430);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1431);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1432);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1433);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1801);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1802);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1803);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1804);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1805);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1806);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1807);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1808);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1809);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1810);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1811);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 1812);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2003);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2004);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2005);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2006);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2007);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2008);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2009);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2010);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2011);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2012);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2013);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2014);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2193);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2194);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2195);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2196);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2197);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2198);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2199);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2200);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2201);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2202);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2203);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 424);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 428);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 430);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 434);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2310);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2311);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2312);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2313);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2314);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2315);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2316);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2317);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2282);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2283);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2284);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2358);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2359);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2360);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2361);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2362);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2363);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2364);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2365);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2366);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2367);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2368);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2369);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2370);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2371);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2372);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2373);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2374);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2420);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2421);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2422);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2423);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2424);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2425);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2426);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2427);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2488);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2489);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2511);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2512);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2513);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2711);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2715);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3365);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3366);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3367);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3368);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3369);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3370);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3371);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3372);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3373);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 3374);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2926);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2927);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2928);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (5, 2929);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3427);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3357);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 1);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 6);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 7);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 8);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 9);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 10);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 11);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 12);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 13);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 14);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 15);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 16);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 17);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 18);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 19);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 20);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 21);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 22);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3411);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3412);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3419);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 2);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 4);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 5);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 23);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 24);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 25);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 26);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 27);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 28);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 29);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 30);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 31);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 32);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 33);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 34);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 35);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 36);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 37);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3256);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3350);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3349);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 38);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 39);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 40);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 41);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 42);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 43);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 44);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 45);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 46);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 47);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 48);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 49);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 50);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3403);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 51);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 52);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 53);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 54);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 55);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 56);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 57);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 58);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 59);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 60);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 61);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 62);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 3406);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 379);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 391);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 63);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 64);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 65);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 66);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 67);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 68);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 69);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 70);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 71);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 72);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 73);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 74);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 75);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 76);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 77);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 78);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 79);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 80);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 81);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 82);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 83);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 84);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 85);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 86);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 87);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 88);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 89);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 90);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 91);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 92);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (8, 93);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (9, 3402);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 3250);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2819);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2820);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2821);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2822);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2823);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2824);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2825);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2826);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2827);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2828);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2829);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2830);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2831);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2832);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2833);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2834);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2835);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2836);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (10, 2837);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 391);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 516);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 523);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 219);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 220);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 215);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 730);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 738);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 228);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 230);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 236);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 852);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 858);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 864);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 867);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 874);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 877);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 885);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 888);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1088);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1093);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1099);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1105);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 501);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 504);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1518);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1519);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1514);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1916);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1928);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 1921);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 2752);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 2753);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 2754);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 2758);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 2767);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 2768);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 2769);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (11, 393);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3479);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3480);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3481);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3482);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3483);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3484);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3485);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3486);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3487);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3488);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3489);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3490);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3491);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3492);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3493);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3494);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3495);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3496);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3497);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3498);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3499);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3500);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3501);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3502);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3503);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3430);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3431);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3432);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3433);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3434);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3435);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3436);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3437);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3438);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3439);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3440);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3441);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3442);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3443);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3444);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3445);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3446);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3447);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3448);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3449);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3450);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3451);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3452);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3453);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3454);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3403);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3404);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3405);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3406);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3407);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3408);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3409);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3410);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3411);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3412);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3413);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3414);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3415);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3416);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3417);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3418);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3419);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3420);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3421);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3422);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3423);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3424);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3425);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3426);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (12, 3427);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3479);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3480);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3481);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3482);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3483);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3484);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3485);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3486);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3487);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3488);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3489);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3490);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3491);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3492);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3493);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3494);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3495);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3496);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3497);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3498);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3499);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3500);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3501);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3502);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (13, 3503);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3430);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3431);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3432);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3433);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3434);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3435);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3436);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3437);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3438);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3439);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3440);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3441);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3442);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3443);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3444);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3445);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3446);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3447);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3448);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3449);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3450);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3451);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3452);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3453);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (14, 3454);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3403);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3404);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3405);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3406);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3407);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3408);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3409);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3410);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3411);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3412);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3413);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3414);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3415);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3416);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3417);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3418);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3419);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3420);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3421);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3422);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3423);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3424);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3425);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3426);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (15, 3427);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 3367);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 52);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2194);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2195);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2198);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2206);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2512);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2516);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2550);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2003);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2004);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2005);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2007);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2010);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (16, 2013);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 2);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 3);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 4);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 5);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 152);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 160);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1278);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1283);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1392);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1335);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1345);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1380);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1801);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1830);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1837);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1854);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1876);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1880);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1984);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1942);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 1945);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 2094);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 2095);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 2096);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (17, 3290);
INSERT INTO playlist_track (playlist_id, track_id) VALUES (18, 597);
