import React from 'react';

export function HeroEnabled() {
  return (
    <svg
      width="100%"
      height="100%"
      viewBox="0 0 824 258"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className="w-full"
    >
      <g id="Variant=Default">
        <rect x="0.5" y="1" width="823" height="256" rx="3.5" fill="#E2E8F0" />
        <g id="Left">
          <g id="Col1">
            <g id="Cards">
              <g id="SchemaTitle">
                <path
                  id="Title"
                  d="M25.556 69.4L25.268 70.804L24.524 70.6C23.996 70.48 23.536 70.42 23.144 70.42C22.6 70.42 22.328 70.68 22.328 71.2C22.328 71.4 22.42 71.584 22.604 71.752C22.796 71.912 23.036 72.048 23.324 72.16C23.612 72.264 23.92 72.396 24.248 72.556C24.576 72.716 24.884 72.888 25.172 73.072C25.46 73.256 25.696 73.508 25.88 73.828C26.072 74.148 26.168 74.516 26.168 74.932C26.168 75.756 25.9 76.404 25.364 76.876C24.836 77.34 24.088 77.572 23.12 77.572C22.624 77.572 22.128 77.508 21.632 77.38C21.144 77.244 20.74 77.088 20.42 76.912L20.936 75.628C21.672 75.964 22.4 76.132 23.12 76.132C23.528 76.132 23.848 76.04 24.08 75.856C24.312 75.664 24.428 75.42 24.428 75.124C24.428 74.828 24.296 74.584 24.032 74.392C23.768 74.192 23.448 74.016 23.072 73.864C22.696 73.704 22.32 73.528 21.944 73.336C21.568 73.136 21.248 72.86 20.984 72.508C20.72 72.148 20.588 71.724 20.588 71.236C20.588 70.508 20.816 69.952 21.272 69.568C21.728 69.176 22.34 68.98 23.108 68.98C23.884 68.98 24.7 69.12 25.556 69.4ZM30.4854 77.56C29.3094 77.56 28.4214 77.156 27.8214 76.348C27.2214 75.532 26.9214 74.496 26.9214 73.24C26.9214 71.984 27.2214 70.96 27.8214 70.168C28.4294 69.376 29.3174 68.98 30.4854 68.98C31.6614 68.98 32.5534 69.376 33.1614 70.168C33.7694 70.96 34.0734 71.984 34.0734 73.24C34.0734 74.96 33.5494 76.2 32.5014 76.96C31.9494 77.36 31.2774 77.56 30.4854 77.56ZM30.5094 70.36C30.0854 70.36 29.7294 70.508 29.4414 70.804C28.9294 71.316 28.6734 72.128 28.6734 73.24C28.6734 74.08 28.8294 74.78 29.1414 75.34C29.4534 75.892 29.9094 76.168 30.5094 76.168C31.1174 76.168 31.5734 75.888 31.8774 75.328C32.1814 74.76 32.3334 74.072 32.3334 73.264C32.3334 72.448 32.1694 71.76 31.8414 71.2C31.5214 70.64 31.0774 70.36 30.5094 70.36ZM40.7026 76.78C40.1666 77.308 39.3906 77.572 38.3746 77.572C37.3586 77.572 36.5826 77.308 36.0466 76.78C35.5106 76.244 35.2426 75.452 35.2426 74.404V69.1H36.9946V74.548C36.9946 75.076 37.1106 75.484 37.3426 75.772C37.5826 76.052 37.9226 76.192 38.3626 76.192C38.8026 76.192 39.1426 76.052 39.3826 75.772C39.6306 75.484 39.7546 75.076 39.7546 74.548V69.1H41.5066V74.404C41.5066 75.452 41.2386 76.244 40.7026 76.78ZM45.0954 73.852H44.9514V77.488H43.2114V69.088H45.8754C46.7794 69.088 47.4554 69.288 47.9034 69.688C48.3514 70.08 48.5754 70.644 48.5754 71.38C48.5754 71.828 48.4194 72.24 48.1074 72.616C47.7954 72.984 47.4154 73.196 46.9674 73.252C47.2874 73.34 47.5354 73.488 47.7114 73.696C47.8874 73.896 48.0714 74.224 48.2634 74.68L49.4514 77.488H47.6634L46.4994 74.8C46.3314 74.416 46.1514 74.164 45.9594 74.044C45.7754 73.916 45.4874 73.852 45.0954 73.852ZM45.8274 70.456H44.9514V72.484H45.7074C46.0274 72.484 46.2754 72.38 46.4514 72.172C46.6354 71.964 46.7274 71.708 46.7274 71.404C46.7274 70.772 46.4274 70.456 45.8274 70.456ZM53.7418 77.572C52.5178 77.572 51.5778 77.188 50.9218 76.42C50.2738 75.644 49.9498 74.596 49.9498 73.276C49.9498 71.956 50.2938 70.912 50.9818 70.144C51.6778 69.376 52.6418 68.992 53.8738 68.992C54.5458 68.992 55.2138 69.108 55.8778 69.34L55.5418 70.684C55.0538 70.476 54.4778 70.372 53.8138 70.372C53.1498 70.372 52.6298 70.624 52.2538 71.128C51.8778 71.632 51.6898 72.328 51.6898 73.216C51.6898 74.104 51.8658 74.824 52.2178 75.376C52.5698 75.92 53.0658 76.192 53.7058 76.192C54.1858 76.192 54.8698 76.036 55.7578 75.724L56.1178 76.948C55.3898 77.364 54.5978 77.572 53.7418 77.572ZM62.4537 77.5H57.4497V69.1H62.4537V70.48H59.1897V72.244H62.1537V73.648H59.1897V76.12H62.4537V77.5ZM68.6576 69.4L68.3696 70.804L67.6256 70.6C67.0976 70.48 66.6376 70.42 66.2456 70.42C65.7016 70.42 65.4296 70.68 65.4296 71.2C65.4296 71.4 65.5216 71.584 65.7056 71.752C65.8976 71.912 66.1376 72.048 66.4256 72.16C66.7136 72.264 67.0216 72.396 67.3496 72.556C67.6776 72.716 67.9856 72.888 68.2736 73.072C68.5616 73.256 68.7976 73.508 68.9816 73.828C69.1736 74.148 69.2696 74.516 69.2696 74.932C69.2696 75.756 69.0016 76.404 68.4656 76.876C67.9376 77.34 67.1896 77.572 66.2216 77.572C65.7256 77.572 65.2296 77.508 64.7336 77.38C64.2456 77.244 63.8416 77.088 63.5216 76.912L64.0376 75.628C64.7736 75.964 65.5016 76.132 66.2216 76.132C66.6296 76.132 66.9496 76.04 67.1816 75.856C67.4136 75.664 67.5296 75.42 67.5296 75.124C67.5296 74.828 67.3976 74.584 67.1336 74.392C66.8696 74.192 66.5496 74.016 66.1736 73.864C65.7976 73.704 65.4216 73.528 65.0456 73.336C64.6696 73.136 64.3496 72.86 64.0856 72.508C63.8216 72.148 63.6896 71.724 63.6896 71.236C63.6896 70.508 63.9176 69.952 64.3736 69.568C64.8296 69.176 65.4416 68.98 66.2096 68.98C66.9856 68.98 67.8016 69.12 68.6576 69.4Z"
                  fill="#94A3B8"
                />
              </g>
              <g id="SchemaCard">
                <g id="Container">
                  <g id="Icon">
                    <path
                      id="Vector"
                      d="M42.6025 110.295L42.4488 110.563C42.3925 110.663 42.2725 110.704 42.1657 110.665C41.9444 110.582 41.7419 110.464 41.5638 110.316C41.4775 110.245 41.455 110.119 41.5113 110.022L41.665 109.753C41.5357 109.603 41.4344 109.429 41.3669 109.24H41.0575C40.945 109.24 40.8475 109.159 40.8288 109.047C40.7913 108.822 40.7894 108.585 40.8288 108.351C40.8475 108.238 40.945 108.156 41.0575 108.156H41.3669C41.4344 107.967 41.5357 107.792 41.665 107.642L41.5113 107.374C41.455 107.277 41.4757 107.151 41.5638 107.08C41.7419 106.932 41.9463 106.813 42.1657 106.731C42.2725 106.692 42.3925 106.733 42.4488 106.832L42.6025 107.1C42.7994 107.065 43 107.065 43.1969 107.1L43.3507 106.832C43.4069 106.733 43.5269 106.692 43.6338 106.731C43.855 106.813 44.0575 106.932 44.2357 107.08C44.3219 107.151 44.3444 107.277 44.2882 107.374L44.1344 107.642C44.2638 107.792 44.365 107.967 44.4325 108.156H44.7419C44.8544 108.156 44.9519 108.237 44.9707 108.349C45.0082 108.574 45.01 108.81 44.9707 109.045C44.9519 109.157 44.8544 109.24 44.7419 109.24H44.4325C44.365 109.429 44.2638 109.603 44.1344 109.753L44.2882 110.022C44.3444 110.119 44.3238 110.245 44.2357 110.316C44.0575 110.464 43.8532 110.582 43.6338 110.665C43.5269 110.704 43.4069 110.663 43.3507 110.563L43.1969 110.295C43.0019 110.331 42.7994 110.331 42.6025 110.295V110.295ZM42.4057 109.193C43.1275 109.748 43.9507 108.925 43.3957 108.203C42.6738 107.646 41.8507 108.471 42.4057 109.193V109.193ZM40.2438 112.078L40.8757 112.393C41.065 112.502 41.1475 112.733 41.0725 112.939C40.9057 113.393 40.5775 113.809 40.2738 114.173C40.135 114.34 39.895 114.381 39.7057 114.272L39.16 113.957C38.86 114.214 38.5113 114.418 38.1307 114.552V115.182C38.1307 115.399 37.975 115.587 37.7613 115.624C37.3 115.703 36.8163 115.707 36.3382 115.624C36.1225 115.587 35.9632 115.401 35.9632 115.182V114.552C35.5825 114.417 35.2338 114.214 34.9338 113.957L34.3882 114.27C34.2007 114.379 33.9588 114.338 33.82 114.171C33.5163 113.807 33.1957 113.391 33.0288 112.939C32.9538 112.735 33.0363 112.504 33.2257 112.393L33.85 112.078C33.7769 111.687 33.7769 111.283 33.85 110.89L33.2257 110.573C33.0363 110.464 32.9519 110.233 33.0288 110.029C33.1957 109.575 33.5163 109.159 33.82 108.795C33.9588 108.628 34.1988 108.587 34.3882 108.696L34.9338 109.011C35.2338 108.754 35.5825 108.55 35.9632 108.417V107.785C35.9632 107.569 36.1169 107.382 36.3307 107.344C36.7919 107.265 37.2775 107.262 37.7557 107.342C37.9713 107.38 38.1307 107.565 38.1307 107.785V108.415C38.5113 108.55 38.86 108.752 39.16 109.009L39.7057 108.694C39.8932 108.585 40.135 108.627 40.2738 108.793C40.5775 109.157 40.8963 109.573 41.0632 110.027C41.1382 110.232 41.065 110.462 40.8757 110.573L40.2438 110.888C40.3169 111.282 40.3169 111.685 40.2438 112.078V112.078ZM38.0388 112.474C39.1488 111.03 37.5007 109.382 36.0569 110.492C34.9469 111.936 36.595 113.584 38.0388 112.474ZM42.6025 115.9L42.4488 116.168C42.3925 116.267 42.2725 116.308 42.1657 116.269C41.9444 116.187 41.7419 116.068 41.5638 115.92C41.4775 115.849 41.455 115.723 41.5113 115.626L41.665 115.358C41.5357 115.208 41.4344 115.033 41.3669 114.844H41.0575C40.945 114.844 40.8475 114.763 40.8288 114.651C40.7913 114.426 40.7894 114.19 40.8288 113.955C40.8475 113.843 40.945 113.76 41.0575 113.76H41.3669C41.4344 113.571 41.5357 113.397 41.665 113.247L41.5113 112.978C41.455 112.881 41.4757 112.755 41.5638 112.684C41.7419 112.536 41.9463 112.418 42.1657 112.335C42.2725 112.296 42.3925 112.337 42.4488 112.437L42.6025 112.705C42.7994 112.669 43 112.669 43.1969 112.705L43.3507 112.437C43.4069 112.337 43.5269 112.296 43.6338 112.335C43.855 112.418 44.0575 112.536 44.2357 112.684C44.3219 112.755 44.3444 112.881 44.2882 112.978L44.1344 113.247C44.2638 113.397 44.365 113.571 44.4325 113.76H44.7419C44.8544 113.76 44.9519 113.841 44.9707 113.953C45.0082 114.178 45.01 114.415 44.9707 114.649C44.9519 114.762 44.8544 114.844 44.7419 114.844H44.4325C44.365 115.033 44.2638 115.208 44.1344 115.358L44.2882 115.626C44.3444 115.723 44.3238 115.849 44.2357 115.92C44.0575 116.068 43.8532 116.187 43.6338 116.269C43.5269 116.308 43.4069 116.267 43.3507 116.168L43.1969 115.9C43.0019 115.935 42.7994 115.935 42.6025 115.9ZM42.4057 114.795C43.1275 115.35 43.9507 114.527 43.3957 113.805C42.6738 113.25 41.8507 114.073 42.4057 114.795V114.795Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label"
                    d="M53.192 111.894H52.324V116.486H51.274V106.686H54.102C55.054 106.686 55.768 106.905 56.244 107.344C56.7293 107.773 56.972 108.389 56.972 109.192C56.972 109.752 56.776 110.265 56.384 110.732C56.0013 111.199 55.5253 111.469 54.956 111.544C55.4133 111.647 55.7353 111.796 55.922 111.992C56.118 112.179 56.3467 112.585 56.608 113.21L57.994 116.486H56.888L55.53 113.35C55.278 112.762 54.9933 112.375 54.676 112.188C54.368 111.992 53.8733 111.894 53.192 111.894ZM54.046 107.582H52.324V110.998H53.906C54.4847 110.998 54.942 110.83 55.278 110.494C55.6233 110.149 55.796 109.715 55.796 109.192C55.796 108.669 55.642 108.273 55.334 108.002C55.026 107.722 54.5967 107.582 54.046 107.582ZM64.9875 116.5H59.7095V106.7H64.9875V107.61H60.7595V110.718H64.6375V111.656H60.7595V115.59H64.9875V116.5ZM72.2254 107.05L72.0014 107.988L71.1894 107.75C70.6108 107.61 70.1114 107.54 69.6914 107.54C68.5901 107.54 68.0394 108.03 68.0394 109.01C68.0394 109.439 68.2074 109.794 68.5434 110.074C68.8794 110.345 69.2854 110.564 69.7614 110.732C70.2468 110.891 70.7274 111.068 71.2034 111.264C71.6888 111.451 72.0994 111.745 72.4354 112.146C72.7714 112.538 72.9394 113.037 72.9394 113.644C72.9394 114.568 72.6548 115.291 72.0854 115.814C71.5161 116.327 70.7088 116.584 69.6634 116.584C69.1408 116.584 68.6134 116.509 68.0814 116.36C67.5588 116.201 67.1294 116.019 66.7934 115.814L67.1434 115.016C67.9928 115.408 68.7954 115.604 69.5514 115.604C70.3168 115.604 70.8954 115.45 71.2874 115.142C71.6888 114.834 71.8894 114.386 71.8894 113.798C71.8894 113.201 71.5674 112.734 70.9234 112.398C70.6341 112.249 70.3121 112.109 69.9574 111.978C69.6121 111.847 69.2621 111.707 68.9074 111.558C68.5621 111.399 68.2448 111.222 67.9554 111.026C67.6754 110.83 67.4421 110.564 67.2554 110.228C67.0781 109.892 66.9894 109.5 66.9894 109.052C66.9894 108.249 67.2274 107.633 67.7034 107.204C68.1888 106.775 68.8374 106.56 69.6494 106.56C70.4614 106.56 71.3201 106.723 72.2254 107.05ZM76.7584 116.5V107.638H74.0144V106.7H80.5104V107.638H77.7944V116.5H76.7584ZM90.8411 116.5H85.5631V106.7H90.8411V107.61H86.6131V110.718H90.4911V111.656H86.6131V115.59H90.8411V116.5ZM94.201 110.942V116.5H93.151V109.5H93.823L93.991 110.186C94.2056 110.018 94.3783 109.887 94.509 109.794C94.649 109.701 94.8683 109.607 95.167 109.514C95.4656 109.411 95.783 109.36 96.119 109.36C96.763 109.36 97.295 109.561 97.715 109.962C98.1443 110.354 98.359 110.914 98.359 111.642V116.5H97.309V111.95C97.309 110.821 96.8376 110.256 95.895 110.256C95.223 110.256 94.6583 110.485 94.201 110.942ZM104.893 106.7H105.943V116.5H105.327L104.977 115.702C104.118 116.309 103.372 116.612 102.737 116.612C101.057 116.612 100.217 115.403 100.217 112.986C100.217 111.614 100.516 110.657 101.113 110.116C101.645 109.621 102.247 109.374 102.919 109.374C103.591 109.374 104.249 109.603 104.893 110.06V106.7ZM104.893 114.764V111.124C104.697 110.891 104.436 110.69 104.109 110.522C103.792 110.354 103.498 110.27 103.227 110.27C102.499 110.27 101.99 110.485 101.701 110.914C101.412 111.343 101.267 112.015 101.267 112.93C101.267 113.845 101.412 114.535 101.701 115.002C101.99 115.469 102.359 115.702 102.807 115.702C103.479 115.702 104.174 115.389 104.893 114.764ZM109.541 119.832H108.491V109.514H109.107L109.471 110.298C109.863 109.999 110.227 109.771 110.563 109.612C110.908 109.444 111.286 109.36 111.697 109.36C113.377 109.36 114.217 110.569 114.217 112.986C114.217 114.358 113.918 115.315 113.321 115.856C112.789 116.351 112.182 116.598 111.501 116.598C110.829 116.598 110.175 116.374 109.541 115.926V119.832ZM109.541 111.236V114.974C109.727 115.198 109.979 115.375 110.297 115.506C110.614 115.637 110.917 115.702 111.207 115.702C111.935 115.702 112.443 115.487 112.733 115.058C113.022 114.629 113.167 113.957 113.167 113.042C113.167 112.127 113.022 111.437 112.733 110.97C112.443 110.503 112.075 110.27 111.627 110.27C111.328 110.27 111.029 110.331 110.731 110.452C110.441 110.573 110.222 110.69 110.073 110.802C109.933 110.905 109.755 111.049 109.541 111.236ZM120.459 113.056C120.459 112.151 120.282 111.46 119.927 110.984C119.573 110.508 119.055 110.27 118.373 110.27C117.692 110.27 117.207 110.499 116.917 110.956C116.637 111.404 116.497 112.095 116.497 113.028C116.497 114.792 117.146 115.674 118.443 115.674C119.125 115.674 119.629 115.464 119.955 115.044C120.291 114.615 120.459 113.952 120.459 113.056ZM120.711 115.632C120.179 116.267 119.428 116.584 118.457 116.584C117.487 116.584 116.74 116.271 116.217 115.646C115.704 115.011 115.447 114.129 115.447 113C115.447 111.861 115.695 110.97 116.189 110.326C116.693 109.682 117.426 109.36 118.387 109.36C119.358 109.36 120.119 109.687 120.669 110.34C121.229 110.993 121.509 111.88 121.509 113C121.509 114.12 121.243 114.997 120.711 115.632ZM123.183 116.5V109.5H124.233V116.5H123.183ZM124.233 106.7V107.946H123.183V106.7H124.233ZM127.615 110.942V116.5H126.565V109.5H127.237L127.405 110.186C127.62 110.018 127.792 109.887 127.923 109.794C128.063 109.701 128.282 109.607 128.581 109.514C128.88 109.411 129.197 109.36 129.533 109.36C130.177 109.36 130.709 109.561 131.129 109.962C131.558 110.354 131.773 110.914 131.773 111.642V116.5H130.723V111.95C130.723 110.821 130.252 110.256 129.309 110.256C128.637 110.256 128.072 110.485 127.615 110.942ZM134.485 114.988V110.34H133.533V109.5H134.499V107.498H135.549V109.5H137.257V110.34H135.535V114.792C135.535 115.417 135.852 115.73 136.487 115.73C136.636 115.73 136.865 115.702 137.173 115.646L137.327 116.402C136.944 116.523 136.548 116.584 136.137 116.584C135.736 116.584 135.358 116.463 135.003 116.22C134.658 115.968 134.485 115.557 134.485 114.988ZM138.891 115.254C139.497 115.534 140.076 115.674 140.627 115.674C141.177 115.674 141.593 115.567 141.873 115.352C142.162 115.128 142.307 114.834 142.307 114.47C142.307 114.106 142.185 113.826 141.943 113.63C141.7 113.425 141.401 113.266 141.047 113.154C140.701 113.042 140.351 112.921 139.997 112.79C139.651 112.659 139.357 112.463 139.115 112.202C138.872 111.941 138.751 111.609 138.751 111.208C138.751 110.62 138.942 110.167 139.325 109.85C139.707 109.523 140.225 109.36 140.879 109.36C141.532 109.36 142.139 109.458 142.699 109.654L142.797 109.696L142.615 110.592C142.055 110.377 141.532 110.27 141.047 110.27C140.571 110.27 140.244 110.345 140.067 110.494C139.889 110.643 139.801 110.895 139.801 111.25C139.801 111.474 139.922 111.665 140.165 111.824C140.407 111.983 140.701 112.123 141.047 112.244C141.401 112.356 141.751 112.491 142.097 112.65C142.451 112.799 142.75 113.028 142.993 113.336C143.235 113.644 143.357 114.022 143.357 114.47C143.357 115.123 143.128 115.641 142.671 116.024C142.213 116.397 141.583 116.584 140.781 116.584C139.978 116.584 139.264 116.402 138.639 116.038L138.891 115.254Z"
                    fill="#94A3B8"
                  />
                </g>
                <rect
                  x="20.5"
                  y="90"
                  width="146"
                  height="43"
                  rx="3.5"
                  stroke="#94A3B8"
                />
              </g>
              <g id="SchemaCard_2">
                <g id="Container_2">
                  <g id="Icon_2">
                    <path
                      id="Vector_2"
                      d="M44.25 159.214V160.286C44.25 161.23 41.8984 162 39 162C36.1016 162 33.75 161.23 33.75 160.286V159.214C33.75 158.27 36.1016 157.5 39 157.5C41.8984 157.5 44.25 158.27 44.25 159.214ZM44.25 161.625V164.036C44.25 164.98 41.8984 165.75 39 165.75C36.1016 165.75 33.75 164.98 33.75 164.036V161.625C34.8779 162.402 36.9424 162.763 39 162.763C41.0576 162.763 43.122 162.402 44.25 161.625ZM44.25 165.375V167.786C44.25 168.73 41.8984 169.5 39 169.5C36.1016 169.5 33.75 168.73 33.75 167.786V165.375C34.8779 166.152 36.9424 166.513 39 166.513C41.0576 166.513 43.122 166.152 44.25 165.375Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_2"
                    d="M58.358 163.25C58.358 164.827 57.9007 166.097 56.986 167.058C56.0713 168.019 54.8487 168.5 53.318 168.5H51.274V158.7H53.752C55.1427 158.7 56.258 159.125 57.098 159.974C57.938 160.823 58.358 161.915 58.358 163.25ZM57.224 163.138C57.224 162.037 56.888 161.173 56.216 160.548C55.544 159.923 54.7413 159.61 53.808 159.61H52.408V167.59H53.444C54.4987 167.59 55.39 167.193 56.118 166.4C56.8553 165.607 57.224 164.519 57.224 163.138ZM63.3625 164.314H63.9365C63.9365 163.465 63.8291 162.914 63.6145 162.662C63.3998 162.401 62.9238 162.27 62.1865 162.27C61.4491 162.27 60.8238 162.368 60.3105 162.564L60.1145 161.752C60.8985 161.491 61.7105 161.36 62.5505 161.36C64.1931 161.36 65.0145 162.181 65.0145 163.824V168.5H64.3985L64.0345 167.674C63.6051 168.029 63.2318 168.271 62.9145 168.402C62.6065 168.523 62.2471 168.584 61.8365 168.584C61.1831 168.584 60.6745 168.393 60.3105 168.01C59.9465 167.618 59.7645 167.105 59.7645 166.47C59.7645 165.033 60.9638 164.314 63.3625 164.314ZM63.9505 165.196H63.3205C62.3685 165.196 61.7105 165.289 61.3465 165.476C60.9918 165.663 60.8145 165.957 60.8145 166.358C60.8145 166.75 60.9171 167.072 61.1225 167.324C61.3278 167.576 61.5938 167.702 61.9205 167.702C62.2565 167.702 62.5738 167.627 62.8725 167.478C63.1805 167.319 63.5398 167.049 63.9505 166.666V165.196ZM67.7252 166.988V162.34H66.7732V161.5H67.7392V159.498H68.7892V161.5H70.4972V162.34H68.7752V166.792C68.7752 167.417 69.0925 167.73 69.7272 167.73C69.8765 167.73 70.1052 167.702 70.4132 167.646L70.5672 168.402C70.1845 168.523 69.7879 168.584 69.3772 168.584C68.9759 168.584 68.5979 168.463 68.2432 168.22C67.8979 167.968 67.7252 167.557 67.7252 166.988ZM75.421 164.314H75.995C75.995 163.465 75.8877 162.914 75.673 162.662C75.4584 162.401 74.9824 162.27 74.245 162.27C73.5077 162.27 72.8824 162.368 72.369 162.564L72.173 161.752C72.957 161.491 73.769 161.36 74.609 161.36C76.2517 161.36 77.073 162.181 77.073 163.824V168.5H76.457L76.093 167.674C75.6637 168.029 75.2904 168.271 74.973 168.402C74.665 168.523 74.3057 168.584 73.895 168.584C73.2417 168.584 72.733 168.393 72.369 168.01C72.005 167.618 71.823 167.105 71.823 166.47C71.823 165.033 73.0224 164.314 75.421 164.314ZM76.009 165.196H75.379C74.427 165.196 73.769 165.289 73.405 165.476C73.0504 165.663 72.873 165.957 72.873 166.358C72.873 166.75 72.9757 167.072 73.181 167.324C73.3864 167.576 73.6524 167.702 73.979 167.702C74.315 167.702 74.6324 167.627 74.931 167.478C75.239 167.319 75.5984 167.049 76.009 166.666V165.196ZM79.6158 158.7H80.6658V162.2C81.4685 161.631 82.1871 161.346 82.8218 161.346C84.5018 161.346 85.3418 162.555 85.3418 164.972C85.3418 166.344 85.0431 167.305 84.4458 167.856C83.9138 168.341 83.2885 168.584 82.5698 168.584C82.2058 168.584 81.8371 168.505 81.4638 168.346C81.0905 168.178 80.7825 168.001 80.5398 167.814L80.2318 168.5H79.6158V158.7ZM80.6658 163.194V167.002C80.8525 167.217 81.0998 167.385 81.4078 167.506C81.7251 167.627 82.0331 167.688 82.3318 167.688C83.0598 167.688 83.5685 167.473 83.8578 167.044C84.1471 166.615 84.2918 165.943 84.2918 165.028C84.2918 164.113 84.1471 163.423 83.8578 162.956C83.5685 162.489 83.1998 162.256 82.7518 162.256C82.0798 162.256 81.3845 162.569 80.6658 163.194ZM90.2824 164.314H90.8564C90.8564 163.465 90.749 162.914 90.5344 162.662C90.3197 162.401 89.8437 162.27 89.1064 162.27C88.369 162.27 87.7437 162.368 87.2304 162.564L87.0344 161.752C87.8184 161.491 88.6304 161.36 89.4704 161.36C91.113 161.36 91.9344 162.181 91.9344 163.824V168.5H91.3184L90.9544 167.674C90.525 168.029 90.1517 168.271 89.8344 168.402C89.5264 168.523 89.167 168.584 88.7564 168.584C88.103 168.584 87.5944 168.393 87.2304 168.01C86.8664 167.618 86.6844 167.105 86.6844 166.47C86.6844 165.033 87.8837 164.314 90.2824 164.314ZM90.8704 165.196H90.2404C89.2884 165.196 88.6304 165.289 88.2664 165.476C87.9117 165.663 87.7344 165.957 87.7344 166.358C87.7344 166.75 87.837 167.072 88.0424 167.324C88.2477 167.576 88.5137 167.702 88.8404 167.702C89.1764 167.702 89.4937 167.627 89.7924 167.478C90.1004 167.319 90.4597 167.049 90.8704 166.666V165.196ZM94.2111 167.254C94.8178 167.534 95.3965 167.674 95.9471 167.674C96.4978 167.674 96.9131 167.567 97.1931 167.352C97.4825 167.128 97.6271 166.834 97.6271 166.47C97.6271 166.106 97.5058 165.826 97.2631 165.63C97.0205 165.425 96.7218 165.266 96.3671 165.154C96.0218 165.042 95.6718 164.921 95.3171 164.79C94.9718 164.659 94.6778 164.463 94.4351 164.202C94.1925 163.941 94.0711 163.609 94.0711 163.208C94.0711 162.62 94.2625 162.167 94.6451 161.85C95.0278 161.523 95.5458 161.36 96.1991 161.36C96.8525 161.36 97.4591 161.458 98.0191 161.654L98.1171 161.696L97.9351 162.592C97.3751 162.377 96.8525 162.27 96.3671 162.27C95.8911 162.27 95.5645 162.345 95.3871 162.494C95.2098 162.643 95.1211 162.895 95.1211 163.25C95.1211 163.474 95.2425 163.665 95.4851 163.824C95.7278 163.983 96.0218 164.123 96.3671 164.244C96.7218 164.356 97.0718 164.491 97.4171 164.65C97.7718 164.799 98.0705 165.028 98.3131 165.336C98.5558 165.644 98.6771 166.022 98.6771 166.47C98.6771 167.123 98.4485 167.641 97.9911 168.024C97.5338 168.397 96.9038 168.584 96.1011 168.584C95.2985 168.584 94.5845 168.402 93.9591 168.038L94.2111 167.254ZM105.433 165.224H100.967C100.967 166.12 101.177 166.755 101.597 167.128C102.026 167.501 102.563 167.688 103.207 167.688C103.533 167.688 103.762 167.674 103.893 167.646C104.023 167.609 104.145 167.576 104.257 167.548C104.378 167.511 104.462 167.483 104.509 167.464C104.742 167.399 104.943 167.338 105.111 167.282L105.279 168.094C104.345 168.421 103.617 168.584 103.095 168.584C102.133 168.584 101.363 168.295 100.785 167.716C100.206 167.128 99.9168 166.251 99.9168 165.084C99.9168 163.908 100.187 162.993 100.729 162.34C101.279 161.687 101.97 161.36 102.801 161.36C103.641 161.36 104.294 161.631 104.761 162.172C105.227 162.713 105.461 163.446 105.461 164.37C105.461 164.622 105.451 164.907 105.433 165.224ZM101.037 164.426H104.453C104.453 163.735 104.331 163.203 104.089 162.83C103.846 162.457 103.421 162.27 102.815 162.27C102.217 162.27 101.779 162.471 101.499 162.872C101.219 163.273 101.065 163.791 101.037 164.426Z"
                    fill="#94A3B8"
                  />
                </g>
                <rect
                  x="20.5"
                  y="142"
                  width="146"
                  height="43"
                  rx="3.5"
                  stroke="#94A3B8"
                />
              </g>
              <g id="SchemaCard_3">
                <g id="Container_3">
                  <g id="Icon_3">
                    <path
                      id="Vector_3"
                      d="M42 210.25C42 210.051 41.921 209.86 41.7803 209.72C41.6397 209.579 41.4489 209.5 41.25 209.5C41.0511 209.5 40.8603 209.579 40.7197 209.72C40.579 209.86 40.5 210.051 40.5 210.25V212.5H42V210.25ZM43.125 213.25H34.875C34.7755 213.25 34.6802 213.29 34.6098 213.36C34.5395 213.43 34.5 213.526 34.5 213.625V214.375C34.5 214.474 34.5395 214.57 34.6098 214.64C34.6802 214.71 34.7755 214.75 34.875 214.75H35.25V215.5C35.2501 216.364 35.5488 217.202 36.0954 217.872C36.642 218.541 37.4031 219.002 38.25 219.175V221.5H39.75V219.175C40.5969 219.002 41.358 218.541 41.9046 217.872C42.4512 217.202 42.7499 216.364 42.75 215.5V214.75H43.125C43.2245 214.75 43.3198 214.71 43.3902 214.64C43.4605 214.57 43.5 214.474 43.5 214.375V213.625C43.5 213.526 43.4605 213.43 43.3902 213.36C43.3198 213.29 43.2245 213.25 43.125 213.25ZM37.5 210.25C37.5 210.051 37.421 209.86 37.2803 209.72C37.1397 209.579 36.9489 209.5 36.75 209.5C36.5511 209.5 36.3603 209.579 36.2197 209.72C36.079 209.86 36 210.051 36 210.25V212.5H37.5V210.25Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_3"
                    d="M55.068 220.584C53.7147 220.584 52.6367 220.127 51.834 219.212C51.0407 218.297 50.644 217.079 50.644 215.558C50.644 214.027 51.022 212.814 51.778 211.918C52.534 211.013 53.5887 210.56 54.942 210.56C55.8007 210.56 56.6733 210.728 57.56 211.064L57.308 211.932C56.9907 211.801 56.5753 211.694 56.062 211.61C55.5487 211.517 55.152 211.47 54.872 211.47C53.892 211.47 53.1173 211.829 52.548 212.548C51.9787 213.267 51.694 214.237 51.694 215.46C51.694 216.683 51.9927 217.691 52.59 218.484C53.1967 219.277 53.9713 219.674 54.914 219.674C55.5767 219.674 56.202 219.581 56.79 219.394V216.44H54.746V215.53H57.84V219.828C56.9627 220.332 56.0387 220.584 55.068 220.584ZM61.3748 215.152V220.5H60.3248V213.5H60.9968L61.1648 214.326C61.6128 213.971 61.9861 213.724 62.2848 213.584C62.5834 213.435 62.9241 213.36 63.3068 213.36C63.4934 213.36 63.6334 213.369 63.7268 213.388L63.9228 213.444L63.7548 214.41C63.5868 214.354 63.3581 214.326 63.0688 214.326C62.5088 214.326 61.9441 214.601 61.3748 215.152ZM68.5441 216.314H69.1181C69.1181 215.465 69.0108 214.914 68.7961 214.662C68.5814 214.401 68.1054 214.27 67.3681 214.27C66.6308 214.27 66.0054 214.368 65.4921 214.564L65.2961 213.752C66.0801 213.491 66.8921 213.36 67.7321 213.36C69.3748 213.36 70.1961 214.181 70.1961 215.824V220.5H69.5801L69.2161 219.674C68.7868 220.029 68.4134 220.271 68.0961 220.402C67.7881 220.523 67.4288 220.584 67.0181 220.584C66.3648 220.584 65.8561 220.393 65.4921 220.01C65.1281 219.618 64.9461 219.105 64.9461 218.47C64.9461 217.033 66.1454 216.314 68.5441 216.314ZM69.1321 217.196H68.5021C67.5501 217.196 66.8921 217.289 66.5281 217.476C66.1734 217.663 65.9961 217.957 65.9961 218.358C65.9961 218.75 66.0988 219.072 66.3041 219.324C66.5094 219.576 66.7754 219.702 67.1021 219.702C67.4381 219.702 67.7554 219.627 68.0541 219.478C68.3621 219.319 68.7214 219.049 69.1321 218.666V217.196ZM73.7888 223.832H72.7388V213.514H73.3548L73.7188 214.298C74.1108 213.999 74.4748 213.771 74.8108 213.612C75.1562 213.444 75.5342 213.36 75.9448 213.36C77.6248 213.36 78.4648 214.569 78.4648 216.986C78.4648 218.358 78.1662 219.315 77.5688 219.856C77.0368 220.351 76.4302 220.598 75.7488 220.598C75.0768 220.598 74.4235 220.374 73.7888 219.926V223.832ZM73.7888 215.236V218.974C73.9755 219.198 74.2275 219.375 74.5448 219.506C74.8622 219.637 75.1655 219.702 75.4548 219.702C76.1828 219.702 76.6915 219.487 76.9808 219.058C77.2702 218.629 77.4148 217.957 77.4148 217.042C77.4148 216.127 77.2702 215.437 76.9808 214.97C76.6915 214.503 76.3228 214.27 75.8748 214.27C75.5762 214.27 75.2775 214.331 74.9788 214.452C74.6895 214.573 74.4702 214.69 74.3208 214.802C74.1808 214.905 74.0035 215.049 73.7888 215.236ZM85.6174 220.5H84.5674V215.894C84.5674 214.765 84.0961 214.2 83.1534 214.2C82.4534 214.2 81.8794 214.424 81.4314 214.872V220.5H80.3814V210.7H81.4174V214.018C81.6228 213.85 81.7814 213.729 81.8934 213.654C82.0148 213.579 82.2061 213.505 82.4674 213.43C82.7381 213.355 83.0414 213.318 83.3774 213.318C84.0214 213.318 84.5534 213.514 84.9734 213.906C85.4028 214.298 85.6174 214.858 85.6174 215.586V220.5ZM94.3487 219.156L95.7207 220.57L95.0347 221.256L93.7047 219.842C93.0794 220.346 92.3234 220.598 91.4367 220.598C90.5594 220.598 89.8221 220.36 89.2247 219.884C88.0954 218.997 87.5307 217.546 87.5307 215.53C87.5307 214.065 87.8574 212.87 88.5107 211.946C89.1734 211.022 90.1394 210.56 91.4087 210.56C92.6874 210.56 93.6581 211.022 94.3207 211.946C94.9834 212.87 95.3147 214.079 95.3147 215.572C95.3147 217.065 94.9927 218.26 94.3487 219.156ZM92.4727 217.168L93.6207 218.414C94.0501 217.705 94.2647 216.767 94.2647 215.6C94.2647 214.424 94.0127 213.439 93.5087 212.646C93.0141 211.853 92.3187 211.456 91.4227 211.456C90.9281 211.456 90.4894 211.573 90.1067 211.806C89.7334 212.039 89.4394 212.352 89.2247 212.744C88.8047 213.528 88.5947 214.485 88.5947 215.614C88.5947 216.734 88.8327 217.691 89.3087 218.484C89.7941 219.277 90.4987 219.674 91.4227 219.674C92.0387 219.674 92.5661 219.497 93.0047 219.142L91.7727 217.854L92.4727 217.168ZM102.53 220.5H97.2799V210.7H98.3299V219.59H102.53V220.5ZM112.325 211.05L112.101 211.988L111.289 211.75C110.71 211.61 110.211 211.54 109.791 211.54C108.69 211.54 108.139 212.03 108.139 213.01C108.139 213.439 108.307 213.794 108.643 214.074C108.979 214.345 109.385 214.564 109.861 214.732C110.346 214.891 110.827 215.068 111.303 215.264C111.788 215.451 112.199 215.745 112.535 216.146C112.871 216.538 113.039 217.037 113.039 217.644C113.039 218.568 112.754 219.291 112.185 219.814C111.616 220.327 110.808 220.584 109.763 220.584C109.24 220.584 108.713 220.509 108.181 220.36C107.658 220.201 107.229 220.019 106.893 219.814L107.243 219.016C108.092 219.408 108.895 219.604 109.651 219.604C110.416 219.604 110.995 219.45 111.387 219.142C111.788 218.834 111.989 218.386 111.989 217.798C111.989 217.201 111.667 216.734 111.023 216.398C110.734 216.249 110.412 216.109 110.057 215.978C109.712 215.847 109.362 215.707 109.007 215.558C108.662 215.399 108.344 215.222 108.055 215.026C107.775 214.83 107.542 214.564 107.355 214.228C107.178 213.892 107.089 213.5 107.089 213.052C107.089 212.249 107.327 211.633 107.803 211.204C108.288 210.775 108.937 210.56 109.749 210.56C110.561 210.56 111.42 210.723 112.325 211.05ZM119.966 217.224H115.5C115.5 218.12 115.71 218.755 116.13 219.128C116.559 219.501 117.096 219.688 117.74 219.688C118.067 219.688 118.295 219.674 118.426 219.646C118.557 219.609 118.678 219.576 118.79 219.548C118.911 219.511 118.995 219.483 119.042 219.464C119.275 219.399 119.476 219.338 119.644 219.282L119.812 220.094C118.879 220.421 118.151 220.584 117.628 220.584C116.667 220.584 115.897 220.295 115.318 219.716C114.739 219.128 114.45 218.251 114.45 217.084C114.45 215.908 114.721 214.993 115.262 214.34C115.813 213.687 116.503 213.36 117.334 213.36C118.174 213.36 118.827 213.631 119.294 214.172C119.761 214.713 119.994 215.446 119.994 216.37C119.994 216.622 119.985 216.907 119.966 217.224ZM115.57 216.426H118.986C118.986 215.735 118.865 215.203 118.622 214.83C118.379 214.457 117.955 214.27 117.348 214.27C116.751 214.27 116.312 214.471 116.032 214.872C115.752 215.273 115.598 215.791 115.57 216.426ZM123.008 215.152V220.5H121.958V213.5H122.63L122.798 214.326C123.246 213.971 123.619 213.724 123.918 213.584C124.216 213.435 124.557 213.36 124.94 213.36C125.126 213.36 125.266 213.369 125.36 213.388L125.556 213.444L125.388 214.41C125.22 214.354 124.991 214.326 124.702 214.326C124.142 214.326 123.577 214.601 123.008 215.152ZM131.955 213.486L129.589 220.5H128.385L126.033 213.486H127.223L129.001 219.38L130.793 213.486H131.955ZM133.191 220.5V213.5H134.241V220.5H133.191ZM134.241 210.7V211.946H133.191V210.7H134.241ZM140.689 219.408L140.899 220.234C140.152 220.458 139.494 220.57 138.925 220.57C137.926 220.57 137.175 220.243 136.671 219.59C136.167 218.937 135.915 218.036 135.915 216.888C135.915 215.74 136.176 214.867 136.699 214.27C137.221 213.663 137.991 213.36 139.009 213.36C139.447 213.36 140.063 213.472 140.857 213.696L140.437 214.508C139.923 214.359 139.461 214.284 139.051 214.284C138.341 214.284 137.828 214.494 137.511 214.914C137.203 215.334 137.049 215.997 137.049 216.902C137.049 218.741 137.707 219.66 139.023 219.66C139.545 219.66 140.101 219.576 140.689 219.408ZM147.487 217.224H143.021C143.021 218.12 143.231 218.755 143.651 219.128C144.081 219.501 144.617 219.688 145.261 219.688C145.588 219.688 145.817 219.674 145.947 219.646C146.078 219.609 146.199 219.576 146.311 219.548C146.433 219.511 146.517 219.483 146.563 219.464C146.797 219.399 146.997 219.338 147.165 219.282L147.333 220.094C146.4 220.421 145.672 220.584 145.149 220.584C144.188 220.584 143.418 220.295 142.839 219.716C142.261 219.128 141.971 218.251 141.971 217.084C141.971 215.908 142.242 214.993 142.783 214.34C143.334 213.687 144.025 213.36 144.855 213.36C145.695 213.36 146.349 213.631 146.815 214.172C147.282 214.713 147.515 215.446 147.515 216.37C147.515 216.622 147.506 216.907 147.487 217.224ZM143.091 216.426H146.507C146.507 215.735 146.386 215.203 146.143 214.83C145.901 214.457 145.476 214.27 144.869 214.27C144.272 214.27 143.833 214.471 143.553 214.872C143.273 215.273 143.119 215.791 143.091 216.426ZM149.213 219.254C149.82 219.534 150.398 219.674 150.949 219.674C151.5 219.674 151.915 219.567 152.195 219.352C152.484 219.128 152.629 218.834 152.629 218.47C152.629 218.106 152.508 217.826 152.265 217.63C152.022 217.425 151.724 217.266 151.369 217.154C151.024 217.042 150.674 216.921 150.319 216.79C149.974 216.659 149.68 216.463 149.437 216.202C149.194 215.941 149.073 215.609 149.073 215.208C149.073 214.62 149.264 214.167 149.647 213.85C150.03 213.523 150.548 213.36 151.201 213.36C151.854 213.36 152.461 213.458 153.021 213.654L153.119 213.696L152.937 214.592C152.377 214.377 151.854 214.27 151.369 214.27C150.893 214.27 150.566 214.345 150.389 214.494C150.212 214.643 150.123 214.895 150.123 215.25C150.123 215.474 150.244 215.665 150.487 215.824C150.73 215.983 151.024 216.123 151.369 216.244C151.724 216.356 152.074 216.491 152.419 216.65C152.774 216.799 153.072 217.028 153.315 217.336C153.558 217.644 153.679 218.022 153.679 218.47C153.679 219.123 153.45 219.641 152.993 220.024C152.536 220.397 151.906 220.584 151.103 220.584C150.3 220.584 149.586 220.402 148.961 220.038L149.213 219.254Z"
                    fill="#94A3B8"
                  />
                </g>
                <rect
                  x="20.5"
                  y="194"
                  width="146"
                  height="43"
                  rx="3.5"
                  stroke="#94A3B8"
                />
              </g>
            </g>
            <g id="SchemaGrouper">
              <g id="Borders">
                <mask id="path-12-inside-1_404_14460" fill="white">
                  <path d="M179 65.5H195V237.5H179V65.5Z" />
                </mask>
                <path
                  d="M195 65.5H196V64.5H195V65.5ZM195 237.5V238.5H196V237.5H195ZM179 66.5H195V64.5H179V66.5ZM194 65.5V237.5H196V65.5H194ZM195 236.5H179V238.5H195V236.5Z"
                  fill="#94A3B8"
                  mask="url(#path-12-inside-1_404_14460)"
                />
              </g>
            </g>
          </g>
          <g id="SchemaArrowWithLabel">
            <g id="Horizontal">
              <g id="Arrow left">
                <g id="SchemaArrow">
                  <rect
                    id="Line"
                    x="195"
                    y="169"
                    width="15"
                    height="1"
                    fill="#94A3B8"
                  />
                </g>
              </g>
              <g id="SchemaArrowLabel">
                <g id="Icon_4">
                  <path
                    id="Vector_4"
                    d="M225.655 167.845C227.055 169.247 227.036 171.494 225.663 172.875C225.661 172.877 225.658 172.88 225.655 172.883L224.08 174.458C222.691 175.847 220.431 175.847 219.042 174.458C217.653 173.069 217.653 170.809 219.042 169.42L219.912 168.55C220.142 168.32 220.539 168.473 220.551 168.799C220.566 169.214 220.641 169.632 220.778 170.035C220.825 170.171 220.792 170.322 220.69 170.424L220.383 170.731C219.726 171.388 219.705 172.457 220.356 173.12C221.013 173.79 222.092 173.794 222.754 173.132L224.329 171.558C224.99 170.897 224.987 169.829 224.329 169.171C224.242 169.084 224.155 169.017 224.087 168.97C224.038 168.937 223.999 168.893 223.97 168.842C223.942 168.79 223.926 168.733 223.924 168.675C223.915 168.427 224.002 168.172 224.198 167.976L224.692 167.483C224.821 167.353 225.024 167.337 225.174 167.442C225.346 167.562 225.507 167.697 225.655 167.845V167.845ZM228.958 164.542C227.569 163.153 225.309 163.153 223.92 164.542L222.345 166.117C222.342 166.12 222.339 166.123 222.337 166.125C220.964 167.506 220.945 169.753 222.345 171.155C222.493 171.303 222.654 171.438 222.826 171.558C222.976 171.663 223.179 171.647 223.308 171.517L223.802 171.024C223.998 170.828 224.085 170.573 224.076 170.325C224.074 170.267 224.058 170.21 224.03 170.158C224.001 170.107 223.962 170.063 223.913 170.03C223.845 169.983 223.758 169.916 223.671 169.829C223.013 169.171 223.01 168.103 223.671 167.442L225.246 165.868C225.908 165.206 226.987 165.21 227.644 165.88C228.294 166.543 228.274 167.612 227.617 168.269L227.31 168.576C227.208 168.678 227.175 168.829 227.222 168.965C227.359 169.368 227.434 169.786 227.449 170.201C227.461 170.527 227.858 170.68 228.088 170.45L228.958 169.58C230.347 168.191 230.347 165.931 228.958 164.542V164.542Z"
                    fill="#94A3B8"
                  />
                </g>
                <path
                  id="Card label_4"
                  d="M238.152 173.572C237.008 173.572 236.128 173.188 235.512 172.42C234.904 171.644 234.6 170.596 234.6 169.276C234.6 167.956 234.924 166.912 235.572 166.144C236.22 165.376 237.124 164.992 238.284 164.992C238.924 164.992 239.552 165.108 240.168 165.34L239.952 166.084C239.464 165.876 238.888 165.772 238.224 165.772C237.384 165.772 236.72 166.08 236.232 166.696C235.744 167.304 235.5 168.144 235.5 169.216C235.5 170.28 235.728 171.144 236.184 171.808C236.648 172.464 237.292 172.792 238.116 172.792C238.66 172.792 239.344 172.636 240.168 172.324L240.408 172.948C239.72 173.364 238.968 173.572 238.152 173.572ZM245.808 170.548C245.808 169.772 245.656 169.18 245.352 168.772C245.048 168.364 244.604 168.16 244.02 168.16C243.436 168.16 243.02 168.356 242.772 168.748C242.532 169.132 242.412 169.724 242.412 170.524C242.412 172.036 242.968 172.792 244.08 172.792C244.664 172.792 245.096 172.612 245.376 172.252C245.664 171.884 245.808 171.316 245.808 170.548ZM246.024 172.756C245.568 173.3 244.924 173.572 244.092 173.572C243.26 173.572 242.62 173.304 242.172 172.768C241.732 172.224 241.512 171.468 241.512 170.5C241.512 169.524 241.724 168.76 242.148 168.208C242.58 167.656 243.208 167.38 244.032 167.38C244.864 167.38 245.516 167.66 245.988 168.22C246.468 168.78 246.708 169.54 246.708 170.5C246.708 171.46 246.48 172.212 246.024 172.756ZM249.211 168.736V173.5H248.311V167.5H248.887L249.031 168.088C249.215 167.944 249.363 167.832 249.475 167.752C249.595 167.672 249.783 167.592 250.039 167.512C250.295 167.424 250.567 167.38 250.855 167.38C251.407 167.38 251.863 167.552 252.223 167.896C252.591 168.232 252.775 168.712 252.775 169.336V173.5H251.875V169.6C251.875 168.632 251.471 168.148 250.663 168.148C250.087 168.148 249.603 168.344 249.211 168.736ZM255.855 168.736V173.5H254.955V167.5H255.531L255.675 168.088C255.859 167.944 256.007 167.832 256.119 167.752C256.239 167.672 256.427 167.592 256.683 167.512C256.939 167.424 257.211 167.38 257.499 167.38C258.051 167.38 258.507 167.552 258.867 167.896C259.235 168.232 259.419 168.712 259.419 169.336V173.5H258.519V169.6C258.519 168.632 258.115 168.148 257.307 168.148C256.731 168.148 256.247 168.344 255.855 168.736ZM265.764 170.692H261.936C261.936 171.46 262.116 172.004 262.476 172.324C262.844 172.644 263.304 172.804 263.856 172.804C264.136 172.804 264.332 172.792 264.444 172.768C264.556 172.736 264.66 172.708 264.756 172.684C264.86 172.652 264.932 172.628 264.972 172.612C265.172 172.556 265.344 172.504 265.488 172.456L265.632 173.152C264.832 173.432 264.208 173.572 263.76 173.572C262.936 173.572 262.276 173.324 261.78 172.828C261.284 172.324 261.036 171.572 261.036 170.572C261.036 169.564 261.268 168.78 261.732 168.22C262.204 167.66 262.796 167.38 263.508 167.38C264.228 167.38 264.788 167.612 265.188 168.076C265.588 168.54 265.788 169.168 265.788 169.96C265.788 170.176 265.78 170.42 265.764 170.692ZM261.996 170.008H264.924C264.924 169.416 264.82 168.96 264.612 168.64C264.404 168.32 264.04 168.16 263.52 168.16C263.008 168.16 262.632 168.332 262.392 168.676C262.152 169.02 262.02 169.464 261.996 170.008ZM270.999 172.564L271.179 173.272C270.539 173.464 269.975 173.56 269.487 173.56C268.631 173.56 267.987 173.28 267.555 172.72C267.123 172.16 266.907 171.388 266.907 170.404C266.907 169.42 267.131 168.672 267.579 168.16C268.027 167.64 268.687 167.38 269.559 167.38C269.935 167.38 270.463 167.476 271.143 167.668L270.783 168.364C270.343 168.236 269.947 168.172 269.595 168.172C268.987 168.172 268.547 168.352 268.275 168.712C268.011 169.072 267.879 169.64 267.879 170.416C267.879 171.992 268.443 172.78 269.571 172.78C270.019 172.78 270.495 172.708 270.999 172.564ZM272.806 172.204V168.22H271.99V167.5H272.818V165.784H273.718V167.5H275.182V168.22H273.706V172.036C273.706 172.572 273.978 172.84 274.522 172.84C274.65 172.84 274.846 172.816 275.11 172.768L275.242 173.416C274.914 173.52 274.574 173.572 274.222 173.572C273.878 173.572 273.554 173.468 273.25 173.26C272.954 173.044 272.806 172.692 272.806 172.204ZM280.975 170.692H277.147C277.147 171.46 277.327 172.004 277.687 172.324C278.055 172.644 278.515 172.804 279.067 172.804C279.347 172.804 279.543 172.792 279.655 172.768C279.767 172.736 279.871 172.708 279.967 172.684C280.071 172.652 280.143 172.628 280.183 172.612C280.383 172.556 280.555 172.504 280.699 172.456L280.843 173.152C280.043 173.432 279.419 173.572 278.971 173.572C278.147 173.572 277.487 173.324 276.991 172.828C276.495 172.324 276.247 171.572 276.247 170.572C276.247 169.564 276.479 168.78 276.943 168.22C277.415 167.66 278.007 167.38 278.719 167.38C279.439 167.38 279.999 167.612 280.399 168.076C280.799 168.54 280.999 169.168 280.999 169.96C280.999 170.176 280.991 170.42 280.975 170.692ZM277.207 170.008H280.135C280.135 169.416 280.031 168.96 279.823 168.64C279.615 168.32 279.251 168.16 278.731 168.16C278.219 168.16 277.843 168.332 277.603 168.676C277.363 169.02 277.231 169.464 277.207 170.008ZM286.102 165.1H287.002V173.5H286.474L286.174 172.816C285.438 173.336 284.798 173.596 284.254 173.596C282.814 173.596 282.094 172.56 282.094 170.488C282.094 169.312 282.35 168.492 282.862 168.028C283.318 167.604 283.834 167.392 284.41 167.392C284.986 167.392 285.55 167.588 286.102 167.98V165.1ZM286.102 172.012V168.892C285.934 168.692 285.71 168.52 285.43 168.376C285.158 168.232 284.906 168.16 284.674 168.16C284.05 168.16 283.614 168.344 283.366 168.712C283.118 169.08 282.994 169.656 282.994 170.44C282.994 171.224 283.118 171.816 283.366 172.216C283.614 172.616 283.93 172.816 284.314 172.816C284.89 172.816 285.486 172.548 286.102 172.012Z"
                  fill="#94A3B8"
                />
              </g>
              <g id="Arrow right">
                <g id="SchemaArrow_2">
                  <rect
                    id="Line_2"
                    x="297"
                    y="169"
                    width="10.5"
                    height="1"
                    fill="#94A3B8"
                  />
                  <path
                    id="Vector_5"
                    d="M307.92 174L307.5 173.69V165.295L307.905 165L312 169.22V169.841L307.92 174Z"
                    fill="#94A3B8"
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
        <g id="Col3">
          <g id="SchemaCard_4" filter="url(#filter0_d_404_14460)">
            <g clipPath="url(#clip0_404_14460)">
              <rect
                x="312"
                y="21.5"
                width="200"
                height="44"
                rx="4"
                fill="white"
              />
              <g id="Container_4">
                <g id="Icon_5">
                  <g id="Icon_6">
                    <path
                      id="Vector_6"
                      d="M331.936 44.6991C331.297 45.3382 331.297 46.3743 331.936 47.0134C332.575 47.6524 333.611 47.6524 334.25 47.0134C334.889 46.3743 334.889 45.3382 334.25 44.6991C333.611 44.0601 332.575 44.0601 331.936 44.6991ZM333.666 46.4306C333.349 46.7471 332.837 46.7471 332.52 46.4306C332.204 46.1142 332.204 45.6014 332.52 45.2849C332.837 44.9685 333.349 44.9685 333.666 45.2849C333.982 45.5999 333.982 46.1142 333.666 46.4306ZM334.223 36.6472L333.22 37.6499C333.024 37.8462 333.024 38.1687 333.22 38.365L337.135 42.2799C337.331 42.4762 337.654 42.4762 337.85 42.2799L338.853 41.2772C339.049 41.0809 339.049 40.7584 338.853 40.5621L334.936 36.6472C334.74 36.4509 334.419 36.4509 334.223 36.6472V36.6472ZM327.198 49.46C327.376 49.282 327.376 48.9914 327.198 48.8134L326.688 48.3036C326.51 48.1256 326.22 48.1256 326.042 48.3036L324.989 49.3565L324.987 49.3581L324.698 49.069C324.538 48.9092 324.278 48.9092 324.12 49.069C323.96 49.2287 323.96 49.4889 324.12 49.6472L325.854 51.3817C326.014 51.5415 326.274 51.5415 326.433 51.3817C326.591 51.2219 326.592 50.9618 326.433 50.8035L326.143 50.5144L326.145 50.5129L327.198 49.46Z"
                      fill="#EA580C"
                    />
                    <path
                      id="Vector_7"
                      d="M332.502 39.526L330.274 41.7535C330.076 41.9513 330.076 42.2769 330.274 42.4747L331.65 43.8501C332.622 43.1502 333.985 43.237 334.86 44.1118L335.974 42.9981C336.172 42.8003 336.172 42.4747 335.974 42.2769L333.223 39.526C333.025 39.3266 332.7 39.3266 332.502 39.526ZM331.072 44.4298L330.259 43.6173C330.069 43.4272 329.757 43.4272 329.567 43.6173L326.702 46.4839C326.511 46.6741 326.511 46.986 326.702 47.1762L328.325 48.7997C328.515 48.9899 328.827 48.9899 329.017 48.7997L330.86 46.9541C330.471 46.1492 330.54 45.1769 331.072 44.4298Z"
                      fill="#425CC7"
                    />
                  </g>
                </g>
                <path
                  id="Card label_5"
                  d="M346.522 48.57C345.15 48.57 344.114 48.0987 343.414 47.156C342.714 46.204 342.364 44.9953 342.364 43.53C342.364 42.0647 342.714 40.87 343.414 39.946C344.123 39.022 345.159 38.56 346.522 38.56C347.894 38.56 348.935 39.022 349.644 39.946C350.353 40.87 350.708 42.0647 350.708 43.53C350.708 45.5367 350.097 46.9833 348.874 47.87C348.23 48.3367 347.446 48.57 346.522 48.57ZM346.55 40.17C346.055 40.17 345.64 40.3427 345.304 40.688C344.707 41.2853 344.408 42.2327 344.408 43.53C344.408 44.51 344.59 45.3267 344.954 45.98C345.318 46.624 345.85 46.946 346.55 46.946C347.259 46.946 347.791 46.6193 348.146 45.966C348.501 45.3033 348.678 44.5007 348.678 43.558C348.678 42.606 348.487 41.8033 348.104 41.15C347.731 40.4967 347.213 40.17 346.55 40.17ZM354.032 51.818H352.212V41.5H353.598L353.934 42.242C354.279 41.9527 354.592 41.7333 354.872 41.584C355.161 41.4347 355.483 41.36 355.838 41.36C356.613 41.36 357.201 41.682 357.602 42.326C358.013 42.97 358.218 43.8707 358.218 45.028C358.218 46.1853 357.957 47.072 357.434 47.688C356.911 48.2947 356.295 48.598 355.586 48.598C355.073 48.598 354.555 48.374 354.032 47.926V51.818ZM354.032 43.656V46.218C354.331 46.7033 354.699 46.946 355.138 46.946C355.586 46.946 355.894 46.7873 356.062 46.47C356.239 46.1527 356.328 45.6673 356.328 45.014C356.328 44.3607 356.235 43.8567 356.048 43.502C355.861 43.1473 355.628 42.97 355.348 42.97C354.947 42.97 354.508 43.1987 354.032 43.656ZM364.951 48.066C364.064 48.4113 363.243 48.584 362.487 48.584C360.293 48.584 359.197 47.3987 359.197 45.028C359.197 43.824 359.463 42.914 359.995 42.298C360.527 41.6727 361.301 41.36 362.319 41.36C363.159 41.36 363.831 41.6213 364.335 42.144C364.839 42.6667 365.091 43.4413 365.091 44.468C365.091 44.8787 365.072 45.238 365.035 45.546H360.989C360.989 46.0967 361.138 46.5027 361.437 46.764C361.735 47.0253 362.137 47.156 362.641 47.156C363.145 47.156 363.812 47.044 364.643 46.82L364.951 48.066ZM363.341 44.258V44.16C363.341 43.7307 363.247 43.3853 363.061 43.124C362.874 42.8627 362.58 42.732 362.179 42.732C361.777 42.732 361.479 42.8767 361.283 43.166C361.087 43.4553 360.984 43.8193 360.975 44.258H363.341ZM372.722 48.5H370.874V44.314C370.874 43.9313 370.8 43.6233 370.65 43.39C370.501 43.1473 370.254 43.026 369.908 43.026C369.563 43.026 369.134 43.2407 368.62 43.67V48.5H366.786V41.5H368.326L368.62 42.13C369.022 41.8313 369.367 41.6307 369.656 41.528C369.955 41.416 370.3 41.36 370.692 41.36C371.318 41.36 371.812 41.57 372.176 41.99C372.54 42.4007 372.722 43.012 372.722 43.824V48.5ZM376.389 48.5V40.338H374.135V38.7H380.631V40.338H378.405V48.5H376.389ZM387.14 48.066C386.253 48.4113 385.432 48.584 384.676 48.584C382.483 48.584 381.386 47.3987 381.386 45.028C381.386 43.824 381.652 42.914 382.184 42.298C382.716 41.6727 383.491 41.36 384.508 41.36C385.348 41.36 386.02 41.6213 386.524 42.144C387.028 42.6667 387.28 43.4413 387.28 44.468C387.28 44.8787 387.261 45.238 387.224 45.546H383.178C383.178 46.0967 383.327 46.5027 383.626 46.764C383.925 47.0253 384.326 47.156 384.83 47.156C385.334 47.156 386.001 47.044 386.832 46.82L387.14 48.066ZM385.53 44.258V44.16C385.53 43.7307 385.437 43.3853 385.25 43.124C385.063 42.8627 384.769 42.732 384.368 42.732C383.967 42.732 383.668 42.8767 383.472 43.166C383.276 43.4553 383.173 43.8193 383.164 44.258H385.53ZM390.796 48.5H388.976V38.7H390.796V48.5ZM398.296 48.066C397.41 48.4113 396.588 48.584 395.832 48.584C393.639 48.584 392.542 47.3987 392.542 45.028C392.542 43.824 392.808 42.914 393.34 42.298C393.872 41.6727 394.647 41.36 395.664 41.36C396.504 41.36 397.176 41.6213 397.68 42.144C398.184 42.6667 398.436 43.4413 398.436 44.468C398.436 44.8787 398.418 45.238 398.38 45.546H394.334C394.334 46.0967 394.484 46.5027 394.782 46.764C395.081 47.0253 395.482 47.156 395.986 47.156C396.49 47.156 397.158 47.044 397.988 46.82L398.296 48.066ZM396.686 44.258V44.16C396.686 43.7307 396.593 43.3853 396.406 43.124C396.22 42.8627 395.926 42.732 395.524 42.732C395.123 42.732 394.824 42.8767 394.628 43.166C394.432 43.4553 394.33 43.8193 394.32 44.258H396.686ZM401.966 48.5H400.132V41.5H401.672L401.91 42.13C402.311 41.8313 402.657 41.6307 402.946 41.528C403.245 41.416 403.59 41.36 403.982 41.36C404.691 41.36 405.209 41.682 405.536 42.326C406.059 41.9433 406.479 41.6867 406.796 41.556C407.123 41.4253 407.477 41.36 407.86 41.36C408.439 41.36 408.896 41.5747 409.232 42.004C409.568 42.424 409.736 43.0447 409.736 43.866V48.5H407.902V44.356C407.902 43.4973 407.645 43.068 407.132 43.068C406.749 43.068 406.311 43.2827 405.816 43.712V48.5H403.996V44.356C403.996 43.4973 403.744 43.068 403.24 43.068C402.867 43.068 402.442 43.2687 401.966 43.67V48.5ZM417.095 48.066C416.209 48.4113 415.387 48.584 414.631 48.584C412.438 48.584 411.341 47.3987 411.341 45.028C411.341 43.824 411.607 42.914 412.139 42.298C412.671 41.6727 413.446 41.36 414.463 41.36C415.303 41.36 415.975 41.6213 416.479 42.144C416.983 42.6667 417.235 43.4413 417.235 44.468C417.235 44.8787 417.217 45.238 417.179 45.546H413.133C413.133 46.0967 413.283 46.5027 413.581 46.764C413.88 47.0253 414.281 47.156 414.785 47.156C415.289 47.156 415.957 47.044 416.787 46.82L417.095 48.066ZM415.485 44.258V44.16C415.485 43.7307 415.392 43.3853 415.205 43.124C415.019 42.8627 414.725 42.732 414.323 42.732C413.922 42.732 413.623 42.8767 413.427 43.166C413.231 43.4553 413.129 43.8193 413.119 44.258H415.485ZM418.861 46.988V43.04H418.147V41.5H418.875V39.498H420.681V41.5H422.151V43.04H420.667V46.092C420.667 46.7173 420.858 47.03 421.241 47.03C421.456 47.03 421.684 47.002 421.927 46.946L422.221 48.402C421.792 48.5233 421.334 48.584 420.849 48.584C420.373 48.584 419.92 48.4627 419.491 48.22C419.071 47.968 418.861 47.5573 418.861 46.988ZM425.605 43.852V48.5H423.771V41.5H425.227L425.395 42.186C425.768 41.8873 426.081 41.6773 426.333 41.556C426.585 41.4253 426.804 41.36 426.991 41.36C427.187 41.36 427.317 41.3647 427.383 41.374C427.448 41.374 427.504 41.3787 427.551 41.388C427.597 41.3973 427.677 41.416 427.789 41.444L427.621 43.11C427.453 43.054 427.224 43.026 426.935 43.026C426.543 43.026 426.099 43.3013 425.605 43.852ZM430.415 48.64L428.119 41.5H429.939L431.297 46.33L432.669 41.5H434.461L432.123 48.5C431.834 49.3587 431.47 50.0447 431.031 50.558C430.593 51.0713 430.042 51.4867 429.379 51.804L428.707 50.516C429.081 50.3573 429.431 50.1147 429.757 49.788C430.084 49.4707 430.303 49.088 430.415 48.64Z"
                  fill="#0F172A"
                />
              </g>
            </g>
            <rect
              x="312.5"
              y="22"
              width="199"
              height="43"
              rx="3.5"
              stroke="#FBBF24"
            />
          </g>
          <g id="SchemaArrowWithLabel_2">
            <g id="Arrow top">
              <g id="SchemaArrow_3">
                <path
                  id="Vector_8"
                  d="M416.5 69.58L416.19 70H407.795L407.5 69.595L411.72 65.5H412.341L416.5 69.58Z"
                  fill="#94A3B8"
                />
                <rect
                  id="Line_3"
                  x="412.5"
                  y="70"
                  width="17.5"
                  height="1"
                  transform="rotate(90 412.5 70)"
                  fill="#94A3B8"
                />
              </g>
            </g>
            <g id="Horizontal_2" transform="translate(-20,0)">
              <g id="SchemaArrowLabel_2">
                <g id="Icon_7">
                  <path
                    id="Vector_9"
                    d="M376.75 100.688V97.5H372.062C371.751 97.5 371.5 97.7508 371.5 98.0625V108.938C371.5 109.249 371.751 109.5 372.062 109.5H379.938C380.249 109.5 380.5 109.249 380.5 108.938V101.25H377.312C377.003 101.25 376.75 100.997 376.75 100.688ZM378.278 105.75H376.75V107.625C376.75 107.832 376.582 108 376.375 108H375.625C375.418 108 375.25 107.832 375.25 107.625V105.75H373.722C373.388 105.75 373.221 105.345 373.458 105.109L375.718 102.866C375.874 102.711 376.126 102.711 376.281 102.866L378.541 105.109C378.779 105.345 378.612 105.75 378.278 105.75ZM380.336 99.9609L378.041 97.6641C377.936 97.5586 377.793 97.5 377.643 97.5H377.5V100.5H380.5V100.357C380.5 100.209 380.441 100.066 380.336 99.9609Z"
                    fill="#475569"
                  />
                </g>
                <text x="385" y="108" font-size="12" fill="#475569">
                  Export traces/metrics/logs
                </text>
              </g>
            </g>
            <g id="Arrow bottom">
              <g id="SchemaArrow_4">
                <rect
                  id="Line_4"
                  x="412.5"
                  y="119.5"
                  width="22"
                  height="1"
                  transform="rotate(90 412.5 119.5)"
                  fill="#94A3B8"
                />
              </g>
            </g>
          </g>
          <g id="SchemaCard_5" filter="url(#filter1_d_404_14460)">
            <rect
              x="312"
              y="145.5"
              width="200"
              height="92"
              rx="4"
              fill="white"
            />
            <g id="Container_5">
              <g id="Icon_8">
                <g id="Group">
                  <path
                    id="Vector_10"
                    d="M336.83 165.512C337.187 164.395 336.972 162.163 336.28 161.34C336.19 161.232 336.02 161.247 335.945 161.366L335.093 162.711C334.882 162.98 334.502 163.042 334.217 162.854C333.293 162.246 332.188 161.892 331 161.892C329.812 161.892 328.707 162.246 327.783 162.854C327.498 163.042 327.118 162.979 326.907 162.711L326.055 161.366C325.98 161.247 325.81 161.232 325.72 161.34C325.028 162.163 324.813 164.395 325.17 165.512C325.288 165.883 325.322 166.275 325.251 166.658C325.182 167.037 325.112 167.495 325.112 167.813C325.112 171.081 327.749 173.733 331 173.733C334.252 173.733 336.888 171.083 336.888 167.813C336.888 167.494 336.819 167.037 336.749 166.658C336.678 166.275 336.712 165.883 336.83 165.512ZM331 172.409C328.487 172.409 326.442 170.353 326.442 167.826C326.442 167.743 326.445 167.662 326.448 167.58C326.54 165.858 327.579 164.385 329.052 163.684C329.642 163.4 330.304 163.243 331 163.243C331.696 163.243 332.358 163.402 332.95 163.685C334.422 164.387 335.462 165.86 335.553 167.58C335.558 167.662 335.56 167.743 335.56 167.826C335.558 170.353 333.513 172.409 331 172.409Z"
                    fill="black"
                  />
                  <path
                    id="Vector_11"
                    d="M332.974 169.59L331.81 167.56L330.81 165.867C330.787 165.827 330.744 165.803 330.697 165.803H329.742C329.694 165.803 329.652 165.829 329.629 165.869C329.606 165.91 329.606 165.961 329.63 166.001L330.585 167.617L329.303 169.584C329.277 169.624 329.273 169.676 329.296 169.719C329.319 169.762 329.364 169.788 329.411 169.788H330.372C330.417 169.788 330.458 169.765 330.483 169.728L331.176 168.639L331.797 169.722C331.82 169.764 331.865 169.788 331.911 169.788H332.858C332.906 169.788 332.948 169.764 332.971 169.722C332.999 169.681 332.999 169.631 332.974 169.59Z"
                    fill="black"
                  />
                </g>
              </g>
              <path
                id="Card label_7"
                d="M350.302 172.5H348.272V168.216H345.024V172.5H342.994V162.7H345.024V166.606H348.272V162.7H350.302V172.5ZM356.141 172.5L355.861 171.8C355.534 172.099 355.245 172.309 354.993 172.43C354.741 172.542 354.438 172.598 354.083 172.598C353.486 172.598 352.963 172.393 352.515 171.982C352.076 171.562 351.857 171.007 351.857 170.316C351.857 169.625 352.128 169.084 352.669 168.692C353.21 168.291 354.027 168.09 355.119 168.09H355.693C355.693 167.689 355.595 167.367 355.399 167.124C355.212 166.881 354.923 166.76 354.531 166.76C353.85 166.76 353.159 166.853 352.459 167.04L352.151 165.808C353.075 165.509 354.004 165.36 354.937 165.36C356.636 165.36 357.485 166.153 357.485 167.74V172.5H356.141ZM355.665 169.434H355.063C354.54 169.434 354.186 169.504 353.999 169.644C353.812 169.784 353.719 169.989 353.719 170.26C353.719 170.521 353.789 170.736 353.929 170.904C354.069 171.072 354.251 171.156 354.475 171.156C354.792 171.156 355.189 170.904 355.665 170.4V169.434ZM359.346 170.638C359.971 170.955 360.611 171.114 361.264 171.114C361.927 171.114 362.258 170.871 362.258 170.386C362.258 169.938 361.885 169.607 361.138 169.392C360.821 169.308 360.503 169.21 360.186 169.098C359.878 168.977 359.612 168.785 359.388 168.524C359.173 168.253 359.066 167.908 359.066 167.488C359.066 166.807 359.276 166.284 359.696 165.92C360.116 165.547 360.699 165.36 361.446 165.36C362.202 165.36 362.916 165.491 363.588 165.752L363.294 167.208C362.678 166.956 362.076 166.83 361.488 166.83C361.077 166.83 360.872 166.97 360.872 167.25C360.872 167.539 361.147 167.759 361.698 167.908C362.277 168.057 362.79 168.272 363.238 168.552C363.471 168.692 363.667 168.902 363.826 169.182C363.985 169.462 364.064 169.798 364.064 170.19C364.064 170.927 363.817 171.511 363.322 171.94C362.827 172.369 362.146 172.584 361.278 172.584C360.41 172.584 359.635 172.383 358.954 171.982L359.346 170.638ZM365.553 165.5H367.401V169.784C367.401 170.167 367.475 170.479 367.625 170.722C367.774 170.955 368.021 171.072 368.367 171.072C368.712 171.072 369.141 170.857 369.655 170.428V165.5H371.489V172.5H369.949L369.655 171.828C369.253 172.127 368.903 172.327 368.605 172.43C368.315 172.533 367.975 172.584 367.583 172.584C366.957 172.584 366.463 172.379 366.099 171.968C365.735 171.557 365.553 170.946 365.553 170.134V165.5ZM375.593 167.852V172.5H373.759V165.5H375.215L375.383 166.186C375.756 165.887 376.069 165.677 376.321 165.556C376.573 165.425 376.792 165.36 376.979 165.36C377.175 165.36 377.306 165.365 377.371 165.374C377.436 165.374 377.492 165.379 377.539 165.388C377.586 165.397 377.665 165.416 377.777 165.444L377.609 167.11C377.441 167.054 377.212 167.026 376.923 167.026C376.531 167.026 376.088 167.301 375.593 167.852ZM382.938 172.5L382.658 171.8C382.331 172.099 382.042 172.309 381.79 172.43C381.538 172.542 381.234 172.598 380.88 172.598C380.282 172.598 379.76 172.393 379.312 171.982C378.873 171.562 378.654 171.007 378.654 170.316C378.654 169.625 378.924 169.084 379.466 168.692C380.007 168.291 380.824 168.09 381.916 168.09H382.49C382.49 167.689 382.392 167.367 382.196 167.124C382.009 166.881 381.72 166.76 381.328 166.76C380.646 166.76 379.956 166.853 379.256 167.04L378.948 165.808C379.872 165.509 380.8 165.36 381.734 165.36C383.432 165.36 384.282 166.153 384.282 167.74V172.5H382.938ZM382.462 169.434H381.86C381.337 169.434 380.982 169.504 380.796 169.644C380.609 169.784 380.516 169.989 380.516 170.26C380.516 170.521 380.586 170.736 380.726 170.904C380.866 171.072 381.048 171.156 381.272 171.156C381.589 171.156 381.986 170.904 382.462 170.4V169.434Z"
                fill="#0F172A"
              />
            </g>

            <a
              href="https://hasura.io/docs/2.0/observability/opentelemetry/graphql-engine/#view-traces"
              className="hover:cursor-pointer"
              target="_blank"
              rel="noreferrer noopener"
            >
              <g id="Items">
                <path
                  d="M312 189.5H512V234C512 235.933 510.433 237.5 508.5 237.5H315.5C313.567 237.5 312 235.933 312 234V189.5Z"
                  fill="#F1F5F9"
                />
                <g id="SchemaCardItem">
                  <g id="Content">
                    <g id="SchemaCardItemText">
                      <g id="Icon_9">
                        <path
                          id="Vector_12"
                          d="M335.44 201.5C335.44 204.366 333.116 206.69 330.25 206.69C327.384 206.69 325.06 204.366 325.06 201.5C325.06 198.634 327.384 196.31 330.25 196.31C333.116 196.31 335.44 198.634 335.44 201.5ZM329.65 204.248L333.5 200.398C333.631 200.267 333.631 200.055 333.5 199.924L333.027 199.451C332.896 199.32 332.684 199.32 332.553 199.451L329.413 202.591L327.947 201.125C327.816 200.994 327.604 200.994 327.473 201.125L327 201.598C326.869 201.729 326.869 201.941 327 202.072L329.176 204.248C329.307 204.379 329.519 204.379 329.65 204.248V204.248Z"
                          fill="#059669"
                        />
                      </g>
                      <path
                        id="Card item label"
                        d="M344.376 205.56C343.28 205.56 342.452 205.156 341.892 204.348C341.332 203.532 341.052 202.496 341.052 201.24C341.052 199.984 341.332 198.96 341.892 198.168C342.46 197.376 343.288 196.98 344.376 196.98C345.472 196.98 346.304 197.376 346.872 198.168C347.44 198.96 347.724 199.984 347.724 201.24C347.724 202.96 347.236 204.2 346.26 204.96C345.74 205.36 345.112 205.56 344.376 205.56ZM344.4 197.76C343.584 197.76 342.972 198.1 342.564 198.78C342.164 199.46 341.964 200.292 341.964 201.276C341.964 202.26 342.168 203.088 342.576 203.76C342.992 204.432 343.6 204.768 344.4 204.768C345.2 204.768 345.804 204.428 346.212 203.748C346.62 203.068 346.824 202.212 346.824 201.18C346.824 199.884 346.46 198.916 345.732 198.276C345.356 197.932 344.912 197.76 344.4 197.76ZM350.273 208.356H349.373V199.512H349.901L350.213 200.184C350.549 199.928 350.861 199.732 351.149 199.596C351.445 199.452 351.769 199.38 352.121 199.38C353.561 199.38 354.281 200.416 354.281 202.488C354.281 203.664 354.025 204.484 353.513 204.948C353.057 205.372 352.537 205.584 351.953 205.584C351.377 205.584 350.817 205.392 350.273 205.008V208.356ZM350.273 200.988V204.192C350.433 204.384 350.649 204.536 350.921 204.648C351.193 204.76 351.453 204.816 351.701 204.816C352.325 204.816 352.761 204.632 353.009 204.264C353.257 203.896 353.381 203.32 353.381 202.536C353.381 201.752 353.257 201.16 353.009 200.76C352.761 200.36 352.445 200.16 352.061 200.16C351.805 200.16 351.549 200.212 351.293 200.316C351.045 200.42 350.857 200.52 350.729 200.616C350.609 200.704 350.457 200.828 350.273 200.988ZM360.088 202.692H356.26C356.26 203.46 356.44 204.004 356.8 204.324C357.168 204.644 357.628 204.804 358.18 204.804C358.46 204.804 358.656 204.792 358.768 204.768C358.88 204.736 358.984 204.708 359.08 204.684C359.184 204.652 359.256 204.628 359.296 204.612C359.496 204.556 359.668 204.504 359.812 204.456L359.956 205.152C359.156 205.432 358.532 205.572 358.084 205.572C357.26 205.572 356.6 205.324 356.104 204.828C355.608 204.324 355.36 203.572 355.36 202.572C355.36 201.564 355.592 200.78 356.056 200.22C356.528 199.66 357.12 199.38 357.832 199.38C358.552 199.38 359.112 199.612 359.512 200.076C359.912 200.54 360.112 201.168 360.112 201.96C360.112 202.176 360.104 202.42 360.088 202.692ZM356.32 202.008H359.248C359.248 201.416 359.144 200.96 358.936 200.64C358.728 200.32 358.364 200.16 357.844 200.16C357.332 200.16 356.956 200.332 356.716 200.676C356.476 201.02 356.344 201.464 356.32 202.008ZM362.695 200.736V205.5H361.795V199.5H362.371L362.515 200.088C362.699 199.944 362.847 199.832 362.959 199.752C363.079 199.672 363.267 199.592 363.523 199.512C363.779 199.424 364.051 199.38 364.339 199.38C364.891 199.38 365.347 199.552 365.707 199.896C366.075 200.232 366.259 200.712 366.259 201.336V205.5H365.359V201.6C365.359 200.632 364.955 200.148 364.147 200.148C363.571 200.148 363.087 200.344 362.695 200.736ZM369.94 205.5V197.904H367.588V197.1H373.156V197.904H370.828V205.5H369.94ZM378.651 202.692H374.823C374.823 203.46 375.003 204.004 375.363 204.324C375.731 204.644 376.191 204.804 376.743 204.804C377.023 204.804 377.219 204.792 377.331 204.768C377.443 204.736 377.547 204.708 377.643 204.684C377.747 204.652 377.819 204.628 377.859 204.612C378.059 204.556 378.231 204.504 378.375 204.456L378.519 205.152C377.719 205.432 377.095 205.572 376.647 205.572C375.823 205.572 375.163 205.324 374.667 204.828C374.171 204.324 373.923 203.572 373.923 202.572C373.923 201.564 374.155 200.78 374.619 200.22C375.091 199.66 375.683 199.38 376.395 199.38C377.115 199.38 377.675 199.612 378.075 200.076C378.475 200.54 378.675 201.168 378.675 201.96C378.675 202.176 378.667 202.42 378.651 202.692ZM374.883 202.008H377.811C377.811 201.416 377.707 200.96 377.499 200.64C377.291 200.32 376.927 200.16 376.407 200.16C375.895 200.16 375.519 200.332 375.279 200.676C375.039 201.02 374.907 201.464 374.883 202.008ZM380.358 205.5V197.1H381.258V205.5H380.358ZM387.604 202.692H383.776C383.776 203.46 383.956 204.004 384.316 204.324C384.684 204.644 385.144 204.804 385.696 204.804C385.976 204.804 386.172 204.792 386.284 204.768C386.396 204.736 386.5 204.708 386.596 204.684C386.7 204.652 386.772 204.628 386.812 204.612C387.012 204.556 387.184 204.504 387.328 204.456L387.472 205.152C386.672 205.432 386.048 205.572 385.6 205.572C384.776 205.572 384.116 205.324 383.62 204.828C383.124 204.324 382.876 203.572 382.876 202.572C382.876 201.564 383.108 200.78 383.572 200.22C384.044 199.66 384.636 199.38 385.348 199.38C386.068 199.38 386.628 199.612 387.028 200.076C387.428 200.54 387.628 201.168 387.628 201.96C387.628 202.176 387.62 202.42 387.604 202.692ZM383.836 202.008H386.764C386.764 201.416 386.66 200.96 386.452 200.64C386.244 200.32 385.88 200.16 385.36 200.16C384.848 200.16 384.472 200.332 384.232 200.676C383.992 201.02 383.86 201.464 383.836 202.008ZM391.843 199.368C392.611 199.368 393.159 199.64 393.487 200.184C394.167 199.64 394.795 199.368 395.371 199.368C395.947 199.368 396.415 199.532 396.775 199.86C397.143 200.18 397.327 200.648 397.327 201.264V205.5H396.451V201.636C396.451 201.148 396.339 200.78 396.115 200.532C395.899 200.276 395.607 200.148 395.239 200.148C394.735 200.148 394.227 200.348 393.715 200.748C393.755 200.924 393.775 201.096 393.775 201.264V205.5H392.899V201.636C392.899 201.148 392.787 200.78 392.563 200.532C392.347 200.276 392.055 200.148 391.687 200.148C391.447 200.148 391.227 200.18 391.027 200.244C390.827 200.308 390.679 200.372 390.583 200.436C390.487 200.5 390.363 200.596 390.211 200.724V205.5H389.311V199.5H389.887L390.043 200.112C390.243 199.944 390.395 199.824 390.499 199.752C390.611 199.672 390.791 199.588 391.039 199.5C391.287 199.412 391.555 199.368 391.843 199.368ZM403.67 202.692H399.842C399.842 203.46 400.022 204.004 400.382 204.324C400.75 204.644 401.21 204.804 401.762 204.804C402.042 204.804 402.238 204.792 402.35 204.768C402.462 204.736 402.566 204.708 402.662 204.684C402.766 204.652 402.838 204.628 402.878 204.612C403.078 204.556 403.25 204.504 403.394 204.456L403.538 205.152C402.738 205.432 402.114 205.572 401.666 205.572C400.842 205.572 400.182 205.324 399.686 204.828C399.19 204.324 398.942 203.572 398.942 202.572C398.942 201.564 399.174 200.78 399.638 200.22C400.11 199.66 400.702 199.38 401.414 199.38C402.134 199.38 402.694 199.612 403.094 200.076C403.494 200.54 403.694 201.168 403.694 201.96C403.694 202.176 403.686 202.42 403.67 202.692ZM399.902 202.008H402.83C402.83 201.416 402.726 200.96 402.518 200.64C402.31 200.32 401.946 200.16 401.426 200.16C400.914 200.16 400.538 200.332 400.298 200.676C400.058 201.02 399.926 201.464 399.902 202.008ZM405.521 204.204V200.22H404.705V199.5H405.533V197.784H406.433V199.5H407.897V200.22H406.421V204.036C406.421 204.572 406.693 204.84 407.237 204.84C407.365 204.84 407.561 204.816 407.825 204.768L407.957 205.416C407.629 205.52 407.289 205.572 406.937 205.572C406.593 205.572 406.269 205.468 405.965 205.26C405.669 205.044 405.521 204.692 405.521 204.204ZM410.426 200.916V205.5H409.526V199.5H410.102L410.246 200.208C410.63 199.904 410.95 199.692 411.206 199.572C411.462 199.444 411.754 199.38 412.082 199.38C412.242 199.38 412.362 199.388 412.442 199.404L412.61 199.452L412.466 200.28C412.322 200.232 412.126 200.208 411.878 200.208C411.398 200.208 410.914 200.444 410.426 200.916ZM415.047 205.62L413.019 199.5H414.039L415.563 204.54L417.099 199.5H418.095L416.031 205.5C415.767 206.276 415.475 206.876 415.155 207.3C414.835 207.724 414.423 208.068 413.919 208.332L413.583 207.708C413.903 207.524 414.203 207.252 414.483 206.892C414.763 206.532 414.951 206.108 415.047 205.62ZM426.846 205.5H422.322V197.1H426.846V197.88H423.222V200.544H426.546V201.348H423.222V204.72H426.846V205.5ZM429.726 200.736V205.5H428.826V199.5H429.402L429.546 200.088C429.73 199.944 429.878 199.832 429.99 199.752C430.11 199.672 430.298 199.592 430.554 199.512C430.81 199.424 431.082 199.38 431.37 199.38C431.922 199.38 432.378 199.552 432.738 199.896C433.106 200.232 433.29 200.712 433.29 201.336V205.5H432.39V201.6C432.39 200.632 431.986 200.148 431.178 200.148C430.602 200.148 430.118 200.344 429.726 200.736ZM438.063 201.912H438.555C438.555 201.184 438.463 200.712 438.279 200.496C438.095 200.272 437.687 200.16 437.055 200.16C436.423 200.16 435.887 200.244 435.447 200.412L435.279 199.716C435.951 199.492 436.647 199.38 437.367 199.38C438.775 199.38 439.479 200.084 439.479 201.492V205.5H438.951L438.639 204.792C438.271 205.096 437.951 205.304 437.679 205.416C437.415 205.52 437.107 205.572 436.755 205.572C436.195 205.572 435.759 205.408 435.447 205.08C435.135 204.744 434.979 204.304 434.979 203.76C434.979 202.528 436.007 201.912 438.063 201.912ZM438.567 202.668H438.027C437.211 202.668 436.647 202.748 436.335 202.908C436.031 203.068 435.879 203.32 435.879 203.664C435.879 204 435.967 204.276 436.143 204.492C436.319 204.708 436.547 204.816 436.827 204.816C437.115 204.816 437.387 204.752 437.643 204.624C437.907 204.488 438.215 204.256 438.567 203.928V202.668ZM441.658 197.1H442.558V200.1C443.246 199.612 443.862 199.368 444.406 199.368C445.846 199.368 446.566 200.404 446.566 202.476C446.566 203.652 446.31 204.476 445.798 204.948C445.342 205.364 444.806 205.572 444.19 205.572C443.878 205.572 443.562 205.504 443.242 205.368C442.922 205.224 442.658 205.072 442.45 204.912L442.186 205.5H441.658V197.1ZM442.558 200.952V204.216C442.718 204.4 442.93 204.544 443.194 204.648C443.466 204.752 443.73 204.804 443.986 204.804C444.61 204.804 445.046 204.62 445.294 204.252C445.542 203.884 445.666 203.308 445.666 202.524C445.666 201.74 445.542 201.148 445.294 200.748C445.046 200.348 444.73 200.148 444.346 200.148C443.77 200.148 443.174 200.416 442.558 200.952ZM448.209 205.5V197.1H449.109V205.5H448.209ZM455.455 202.692H451.627C451.627 203.46 451.807 204.004 452.167 204.324C452.535 204.644 452.995 204.804 453.547 204.804C453.827 204.804 454.023 204.792 454.135 204.768C454.247 204.736 454.351 204.708 454.447 204.684C454.551 204.652 454.623 204.628 454.663 204.612C454.863 204.556 455.035 204.504 455.179 204.456L455.323 205.152C454.523 205.432 453.899 205.572 453.451 205.572C452.627 205.572 451.967 205.324 451.471 204.828C450.975 204.324 450.727 203.572 450.727 202.572C450.727 201.564 450.959 200.78 451.423 200.22C451.895 199.66 452.487 199.38 453.199 199.38C453.919 199.38 454.479 199.612 454.879 200.076C455.279 200.54 455.479 201.168 455.479 201.96C455.479 202.176 455.471 202.42 455.455 202.692ZM451.687 202.008H454.615C454.615 201.416 454.511 200.96 454.303 200.64C454.095 200.32 453.731 200.16 453.211 200.16C452.699 200.16 452.323 200.332 452.083 200.676C451.843 201.02 451.711 201.464 451.687 202.008ZM460.582 197.1H461.482V205.5H460.954L460.654 204.816C459.918 205.336 459.278 205.596 458.734 205.596C457.294 205.596 456.574 204.56 456.574 202.488C456.574 201.312 456.83 200.492 457.342 200.028C457.798 199.604 458.314 199.392 458.89 199.392C459.466 199.392 460.03 199.588 460.582 199.98V197.1ZM460.582 204.012V200.892C460.414 200.692 460.19 200.52 459.91 200.376C459.638 200.232 459.386 200.16 459.154 200.16C458.53 200.16 458.094 200.344 457.846 200.712C457.598 201.08 457.474 201.656 457.474 202.44C457.474 203.224 457.598 203.816 457.846 204.216C458.094 204.616 458.41 204.816 458.794 204.816C459.37 204.816 459.966 204.548 460.582 204.012Z"
                        fill="#0F172A"
                      />
                    </g>
                  </g>
                  <path
                    d="M312 190.5H512V188.5H312V190.5Z"
                    fill="#E2E8F0"
                    mask="url(#path-34-inside-2_404_14460)"
                  />
                </g>
                <g id="SchemaCardItem_2">
                  <g id="Content_2">
                    <g id="SchemaCardItemText_2">
                      <g id="Content_3">
                        <g id="Icon_10">
                          <path
                            id="Vector_13"
                            d="M332.05 227H332.95C333.1 227 333.25 226.85 333.25 226.7V223.55C333.25 223.4 333.1 223.25 332.95 223.25H332.05C331.9 223.25 331.75 223.4 331.75 223.55V226.7C331.75 226.85 331.9 227 332.05 227V227ZM334.3 227H335.2C335.35 227 335.5 226.85 335.5 226.7V221.3C335.5 221.15 335.35 221 335.2 221H334.3C334.15 221 334 221.15 334 221.3V226.7C334 226.85 334.15 227 334.3 227ZM327.55 227H328.45C328.6 227 328.75 226.85 328.75 226.7V225.05C328.75 224.9 328.6 224.75 328.45 224.75H327.55C327.4 224.75 327.25 224.9 327.25 225.05V226.7C327.25 226.85 327.4 227 327.55 227ZM329.8 227H330.7C330.85 227 331 226.85 331 226.7V222.05C331 221.9 330.85 221.75 330.7 221.75H329.8C329.65 221.75 329.5 221.9 329.5 222.05V226.7C329.5 226.85 329.65 227 329.8 227V227ZM335.875 228.5H325.75V221.375C325.75 221.168 325.582 221 325.375 221H324.625C324.418 221 324.25 221.168 324.25 221.375V229.25C324.25 229.664 324.586 230 325 230H335.875C336.082 230 336.25 229.832 336.25 229.625V228.875C336.25 228.668 336.082 228.5 335.875 228.5Z"
                            fill="#297393"
                          />
                        </g>
                        <text x="342" y="229" font-size="11" fill="#297393">
                          Available traces/metrics/logs
                        </text>
                      </g>
                      <g id="Icon_11" opacity="0.9">
                        <path
                          id="Vector_14"
                          d="M495.109 227.562H494.453C494.366 227.562 494.283 227.597 494.221 227.659C494.16 227.72 494.125 227.804 494.125 227.891V230.188H487.562V223.625H490.516C490.603 223.625 490.686 223.59 490.748 223.529C490.809 223.467 490.844 223.384 490.844 223.297V222.641C490.844 222.554 490.809 222.47 490.748 222.409C490.686 222.347 490.603 222.312 490.516 222.312H487.234C486.973 222.312 486.723 222.416 486.538 222.601C486.354 222.785 486.25 223.036 486.25 223.297V230.516C486.25 230.777 486.354 231.027 486.538 231.212C486.723 231.396 486.973 231.5 487.234 231.5H494.453C494.714 231.5 494.965 231.396 495.149 231.212C495.334 231.027 495.438 230.777 495.438 230.516V227.891C495.438 227.804 495.403 227.72 495.341 227.659C495.28 227.597 495.196 227.562 495.109 227.562ZM496.258 221H493.633C493.195 221 492.976 221.531 493.284 221.841L494.017 222.574L489.019 227.57C488.973 227.616 488.936 227.67 488.911 227.73C488.887 227.79 488.874 227.854 488.874 227.919C488.874 227.983 488.887 228.048 488.911 228.107C488.936 228.167 488.973 228.222 489.019 228.267L489.483 228.731C489.529 228.777 489.584 228.814 489.643 228.839C489.703 228.863 489.767 228.876 489.832 228.876C489.897 228.876 489.961 228.863 490.021 228.839C490.081 228.814 490.135 228.777 490.181 228.731L495.177 223.734L495.909 224.466C496.217 224.773 496.75 224.558 496.75 224.117V221.492C496.75 221.362 496.698 221.236 496.606 221.144C496.514 221.052 496.388 221 496.258 221V221Z"
                          fill="#94A3B8"
                        />
                      </g>
                    </g>
                  </g>
                  <path
                    d="M312 214.5H512V212.5H312V214.5Z"
                    fill="#E2E8F0"
                    mask="url(#path-38-inside-3_404_14460)"
                  />
                </g>
              </g>
            </a>
          </g>
          <g id="SchemaBlink">
            <circle
              id="SchemaBlink_2"
              cx="412"
              cy="146.75"
              r="5.25"
              fill="#FB923C"
              className="animate-ping"
              style={{
                transformOrigin: 'unset',
                transformBox: 'fill-box',
              }}
            />
          </g>
          <g id="SchemaBlink">
            <circle
              id="SchemaBlink_2"
              cx="411.5"
              cy="146.75"
              r="5.25"
              fill="#FB923C"
            />
          </g>
        </g>
        <g id="Right">
          <g id="SchemaArrowWithLabel_3">
            <g id="Horizontal_3">
              <g id="Arrow left_2">
                <g id="SchemaArrow_5">
                  <rect
                    id="Line_5"
                    x="512"
                    y="169"
                    width="22"
                    height="1"
                    fill="#94A3B8"
                  />
                  <path
                    id="Vector_15"
                    d="M534.42 174L534 173.69V165.295L534.405 165L538.5 169.22V169.841L534.42 174Z"
                    fill="#94A3B8"
                  />
                </g>
              </g>
              <g id="SchemaArrowLabel_3">
                <g id="Icon_12">
                  <path
                    id="Vector_16"
                    d="M555.688 167.25H552.983L553.981 164.208C554.075 163.852 553.806 163.5 553.438 163.5H550.063C549.781 163.5 549.542 163.709 549.505 163.987L548.755 169.612C548.71 169.95 548.973 170.25 549.313 170.25H552.095L551.014 174.809C550.93 175.165 551.202 175.5 551.56 175.5C551.757 175.5 551.945 175.397 552.048 175.219L556.173 168.094C556.391 167.721 556.121 167.25 555.688 167.25Z"
                    fill="#94A3B8"
                  />
                </g>
                <path
                  id="Card label_8"
                  d="M565.716 169.972H564.492V173.5H563.592V165.1H565.992C566.888 165.1 567.536 165.296 567.936 165.688C568.344 166.08 568.548 166.692 568.548 167.524C568.548 168.348 568.3 168.964 567.804 169.372C567.308 169.772 566.612 169.972 565.716 169.972ZM565.584 165.868H564.492V169.204H565.284C566.108 169.204 566.708 169.08 567.084 168.832C567.46 168.584 567.648 168.16 567.648 167.56C567.648 166.952 567.484 166.52 567.156 166.264C566.828 166 566.304 165.868 565.584 165.868ZM573.675 170.548C573.675 169.772 573.523 169.18 573.219 168.772C572.915 168.364 572.471 168.16 571.887 168.16C571.303 168.16 570.887 168.356 570.639 168.748C570.399 169.132 570.279 169.724 570.279 170.524C570.279 172.036 570.835 172.792 571.947 172.792C572.531 172.792 572.963 172.612 573.243 172.252C573.531 171.884 573.675 171.316 573.675 170.548ZM573.891 172.756C573.435 173.3 572.791 173.572 571.959 173.572C571.127 173.572 570.487 173.304 570.039 172.768C569.599 172.224 569.379 171.468 569.379 170.5C569.379 169.524 569.591 168.76 570.015 168.208C570.447 167.656 571.075 167.38 571.899 167.38C572.731 167.38 573.383 167.66 573.855 168.22C574.335 168.78 574.575 169.54 574.575 170.5C574.575 171.46 574.347 172.212 573.891 172.756ZM576.97 173.5L575.218 167.5H576.154L577.486 172.552L578.722 167.5H579.61L580.942 172.6L582.166 167.5H583.102L581.458 173.5H580.402L579.166 168.76L578.002 173.5H576.97ZM588.486 170.692H584.658C584.658 171.46 584.838 172.004 585.198 172.324C585.566 172.644 586.026 172.804 586.578 172.804C586.858 172.804 587.054 172.792 587.166 172.768C587.278 172.736 587.382 172.708 587.478 172.684C587.582 172.652 587.654 172.628 587.694 172.612C587.894 172.556 588.066 172.504 588.21 172.456L588.354 173.152C587.554 173.432 586.93 173.572 586.482 173.572C585.658 173.572 584.998 173.324 584.502 172.828C584.006 172.324 583.758 171.572 583.758 170.572C583.758 169.564 583.99 168.78 584.454 168.22C584.926 167.66 585.518 167.38 586.23 167.38C586.95 167.38 587.51 167.612 587.91 168.076C588.31 168.54 588.51 169.168 588.51 169.96C588.51 170.176 588.502 170.42 588.486 170.692ZM584.718 170.008H587.646C587.646 169.416 587.542 168.96 587.334 168.64C587.126 168.32 586.762 168.16 586.242 168.16C585.73 168.16 585.354 168.332 585.114 168.676C584.874 169.02 584.742 169.464 584.718 170.008ZM591.094 168.916V173.5H590.194V167.5H590.77L590.914 168.208C591.298 167.904 591.618 167.692 591.874 167.572C592.13 167.444 592.422 167.38 592.75 167.38C592.91 167.38 593.03 167.388 593.11 167.404L593.278 167.452L593.134 168.28C592.99 168.232 592.794 168.208 592.546 168.208C592.066 168.208 591.582 168.444 591.094 168.916ZM594.479 173.5V167.5H595.379V173.5H594.479ZM595.379 165.1V166.168H594.479V165.1H595.379ZM598.277 168.736V173.5H597.377V167.5H597.953L598.097 168.088C598.281 167.944 598.429 167.832 598.541 167.752C598.661 167.672 598.849 167.592 599.105 167.512C599.361 167.424 599.633 167.38 599.921 167.38C600.473 167.38 600.929 167.552 601.289 167.896C601.657 168.232 601.841 168.712 601.841 169.336V173.5H600.941V169.6C600.941 168.632 600.537 168.148 599.729 168.148C599.153 168.148 598.669 168.344 598.277 168.736ZM607.43 172.864C606.758 173.344 606.146 173.584 605.594 173.584C604.154 173.584 603.434 172.548 603.434 170.476C603.434 169.3 603.69 168.476 604.202 168.004C604.658 167.588 605.21 167.38 605.858 167.38C606.514 167.38 607.062 167.676 607.502 168.268L607.814 167.488H608.342V173.8C608.342 174.672 608.126 175.32 607.694 175.744C607.262 176.168 606.678 176.38 605.942 176.38C605.566 176.38 605.23 176.332 604.934 176.236C604.638 176.14 604.33 176.032 604.01 175.912L604.178 175.276C604.85 175.492 605.41 175.6 605.858 175.6C606.314 175.6 606.69 175.46 606.986 175.18C607.282 174.9 607.43 174.476 607.43 173.908V172.864ZM607.43 172V169.756C607.43 169.284 607.274 168.9 606.962 168.604C606.65 168.308 606.33 168.16 606.002 168.16C605.378 168.16 604.942 168.344 604.694 168.712C604.446 169.072 604.322 169.652 604.322 170.452C604.322 172.02 604.762 172.804 605.642 172.804C606.218 172.804 606.814 172.536 607.43 172Z"
                  fill="#94A3B8"
                />
              </g>
              <g id="Arrow right_2">
                <g id="SchemaArrow_6">
                  <rect
                    id="Line_6"
                    x="617.5"
                    y="169"
                    width="26.5"
                    height="1"
                    fill="#94A3B8"
                  />
                </g>
              </g>
            </g>
          </g>
          <g id="Col5">
            <g id="SchemaGrouper_2">
              <g id="Borders_2">
                <mask id="path-49-inside-4_404_14460" fill="white">
                  <path d="M660 237.5H644V65.5H660V237.5Z" />
                </mask>
                <path
                  d="M644 237.5H643V238.5H644V237.5ZM644 65.5V64.5H643V65.5H644ZM660 236.5H644V238.5H660V236.5ZM645 237.5V65.5H643V237.5H645ZM644 66.5H660V64.5H644V66.5Z"
                  fill="#94A3B8"
                  mask="url(#path-49-inside-4_404_14460)"
                />
              </g>
            </g>
            <g id="Cards_2">
              <g id="SchemaTitle_2">
                <path
                  id="Title_2"
                  d="M741.152 77.572C739.928 77.572 738.988 77.188 738.332 76.42C737.684 75.644 737.36 74.596 737.36 73.276C737.36 71.956 737.704 70.912 738.392 70.144C739.088 69.376 740.052 68.992 741.284 68.992C741.956 68.992 742.624 69.108 743.288 69.34L742.952 70.684C742.464 70.476 741.888 70.372 741.224 70.372C740.56 70.372 740.04 70.624 739.664 71.128C739.288 71.632 739.1 72.328 739.1 73.216C739.1 74.104 739.276 74.824 739.628 75.376C739.98 75.92 740.476 76.192 741.116 76.192C741.596 76.192 742.28 76.036 743.168 75.724L743.528 76.948C742.8 77.364 742.008 77.572 741.152 77.572ZM747.884 77.56C746.708 77.56 745.82 77.156 745.22 76.348C744.62 75.532 744.32 74.496 744.32 73.24C744.32 71.984 744.62 70.96 745.22 70.168C745.828 69.376 746.716 68.98 747.884 68.98C749.06 68.98 749.952 69.376 750.56 70.168C751.168 70.96 751.472 71.984 751.472 73.24C751.472 74.96 750.948 76.2 749.9 76.96C749.348 77.36 748.676 77.56 747.884 77.56ZM747.908 70.36C747.484 70.36 747.128 70.508 746.84 70.804C746.328 71.316 746.072 72.128 746.072 73.24C746.072 74.08 746.228 74.78 746.54 75.34C746.852 75.892 747.308 76.168 747.908 76.168C748.516 76.168 748.972 75.888 749.276 75.328C749.58 74.76 749.732 74.072 749.732 73.264C749.732 72.448 749.568 71.76 749.24 71.2C748.92 70.64 748.476 70.36 747.908 70.36ZM759.085 77.512H757.261L754.417 72.34V77.5H752.641V69.1H754.417L757.345 74.524V69.1H759.085V77.512ZM765.49 69.4L765.202 70.804L764.458 70.6C763.93 70.48 763.47 70.42 763.078 70.42C762.534 70.42 762.262 70.68 762.262 71.2C762.262 71.4 762.354 71.584 762.538 71.752C762.73 71.912 762.97 72.048 763.258 72.16C763.546 72.264 763.854 72.396 764.182 72.556C764.51 72.716 764.818 72.888 765.106 73.072C765.394 73.256 765.63 73.508 765.814 73.828C766.006 74.148 766.102 74.516 766.102 74.932C766.102 75.756 765.834 76.404 765.298 76.876C764.77 77.34 764.022 77.572 763.054 77.572C762.558 77.572 762.062 77.508 761.566 77.38C761.078 77.244 760.674 77.088 760.354 76.912L760.87 75.628C761.606 75.964 762.334 76.132 763.054 76.132C763.462 76.132 763.782 76.04 764.014 75.856C764.246 75.664 764.362 75.42 764.362 75.124C764.362 74.828 764.23 74.584 763.966 74.392C763.702 74.192 763.382 74.016 763.006 73.864C762.63 73.704 762.254 73.528 761.878 73.336C761.502 73.136 761.182 72.86 760.918 72.508C760.654 72.148 760.522 71.724 760.522 71.236C760.522 70.508 760.75 69.952 761.206 69.568C761.662 69.176 762.274 68.98 763.042 68.98C763.818 68.98 764.634 69.12 765.49 69.4ZM772.855 76.78C772.319 77.308 771.543 77.572 770.527 77.572C769.511 77.572 768.735 77.308 768.199 76.78C767.663 76.244 767.395 75.452 767.395 74.404V69.1H769.147V74.548C769.147 75.076 769.263 75.484 769.495 75.772C769.735 76.052 770.075 76.192 770.515 76.192C770.955 76.192 771.295 76.052 771.535 75.772C771.783 75.484 771.907 75.076 771.907 74.548V69.1H773.659V74.404C773.659 75.452 773.391 76.244 772.855 76.78ZM782.924 77.5H781.184V72.292L779.684 75.532H778.172L776.672 72.304V77.5H774.944V69.1H776.792L778.94 73.6L781.184 69.1H782.924V77.5ZM789.215 77.5H784.211V69.1H789.215V70.48H785.951V72.244H788.915V73.648H785.951V76.12H789.215V77.5ZM792.599 73.852H792.455V77.488H790.715V69.088H793.379C794.283 69.088 794.959 69.288 795.407 69.688C795.855 70.08 796.079 70.644 796.079 71.38C796.079 71.828 795.923 72.24 795.611 72.616C795.299 72.984 794.919 73.196 794.471 73.252C794.791 73.34 795.039 73.488 795.215 73.696C795.391 73.896 795.575 74.224 795.767 74.68L796.955 77.488H795.167L794.003 74.8C793.835 74.416 793.655 74.164 793.463 74.044C793.279 73.916 792.991 73.852 792.599 73.852ZM793.331 70.456H792.455V72.484H793.211C793.531 72.484 793.779 72.38 793.955 72.172C794.139 71.964 794.231 71.708 794.231 71.404C794.231 70.772 793.931 70.456 793.331 70.456ZM802.65 69.4L802.362 70.804L801.618 70.6C801.09 70.48 800.63 70.42 800.238 70.42C799.694 70.42 799.422 70.68 799.422 71.2C799.422 71.4 799.514 71.584 799.698 71.752C799.89 71.912 800.13 72.048 800.418 72.16C800.706 72.264 801.014 72.396 801.342 72.556C801.67 72.716 801.978 72.888 802.266 73.072C802.554 73.256 802.79 73.508 802.974 73.828C803.166 74.148 803.262 74.516 803.262 74.932C803.262 75.756 802.994 76.404 802.458 76.876C801.93 77.34 801.182 77.572 800.214 77.572C799.718 77.572 799.222 77.508 798.726 77.38C798.238 77.244 797.834 77.088 797.514 76.912L798.03 75.628C798.766 75.964 799.494 76.132 800.214 76.132C800.622 76.132 800.942 76.04 801.174 75.856C801.406 75.664 801.522 75.42 801.522 75.124C801.522 74.828 801.39 74.584 801.126 74.392C800.862 74.192 800.542 74.016 800.166 73.864C799.79 73.704 799.414 73.528 799.038 73.336C798.662 73.136 798.342 72.86 798.078 72.508C797.814 72.148 797.682 71.724 797.682 71.236C797.682 70.508 797.91 69.952 798.366 69.568C798.822 69.176 799.434 68.98 800.202 68.98C800.978 68.98 801.794 69.12 802.65 69.4Z"
                  fill="#94A3B8"
                />
              </g>
              <g id="SchemaCard_6">
                <g id="Container_6">
                  <g id="Icon_13">
                    <path
                      id="Vector_17"
                      d="M693.625 105.5H688.375C687.754 105.5 687.25 106.004 687.25 106.625V116.375C687.25 116.996 687.754 117.5 688.375 117.5H693.625C694.246 117.5 694.75 116.996 694.75 116.375V106.625C694.75 106.004 694.246 105.5 693.625 105.5ZM691 116.75C690.585 116.75 690.25 116.415 690.25 116C690.25 115.585 690.585 115.25 691 115.25C691.415 115.25 691.75 115.585 691.75 116C691.75 116.415 691.415 116.75 691 116.75ZM693.625 114.219C693.625 114.373 693.498 114.5 693.344 114.5H688.656C688.502 114.5 688.375 114.373 688.375 114.219V106.906C688.375 106.752 688.502 106.625 688.656 106.625H693.344C693.498 106.625 693.625 106.752 693.625 106.906V114.219Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_9"
                    d="M709.924 116.5H708.748L707.768 113.406H704.254L703.288 116.5H702.182L705.402 106.7H706.676L709.924 116.5ZM707.53 112.496L706.032 107.764L704.52 112.496H707.53ZM712.431 119.832H711.381V109.514H711.997L712.361 110.298C712.753 109.999 713.117 109.771 713.453 109.612C713.799 109.444 714.177 109.36 714.587 109.36C716.267 109.36 717.107 110.569 717.107 112.986C717.107 114.358 716.809 115.315 716.211 115.856C715.679 116.351 715.073 116.598 714.391 116.598C713.719 116.598 713.066 116.374 712.431 115.926V119.832ZM712.431 111.236V114.974C712.618 115.198 712.87 115.375 713.187 115.506C713.505 115.637 713.808 115.702 714.097 115.702C714.825 115.702 715.334 115.487 715.623 115.058C715.913 114.629 716.057 113.957 716.057 113.042C716.057 112.127 715.913 111.437 715.623 110.97C715.334 110.503 714.965 110.27 714.517 110.27C714.219 110.27 713.92 110.331 713.621 110.452C713.332 110.573 713.113 110.69 712.963 110.802C712.823 110.905 712.646 111.049 712.431 111.236ZM720.074 119.832H719.024V109.514H719.64L720.004 110.298C720.396 109.999 720.76 109.771 721.096 109.612C721.441 109.444 721.819 109.36 722.23 109.36C723.91 109.36 724.75 110.569 724.75 112.986C724.75 114.358 724.451 115.315 723.854 115.856C723.322 116.351 722.715 116.598 722.034 116.598C721.362 116.598 720.709 116.374 720.074 115.926V119.832ZM720.074 111.236V114.974C720.261 115.198 720.513 115.375 720.83 115.506C721.147 115.637 721.451 115.702 721.74 115.702C722.468 115.702 722.977 115.487 723.266 115.058C723.555 114.629 723.7 113.957 723.7 113.042C723.7 112.127 723.555 111.437 723.266 110.97C722.977 110.503 722.608 110.27 722.16 110.27C721.861 110.27 721.563 110.331 721.264 110.452C720.975 110.573 720.755 110.69 720.606 110.802C720.466 110.905 720.289 111.049 720.074 111.236ZM726.401 115.254C727.007 115.534 727.586 115.674 728.137 115.674C728.687 115.674 729.103 115.567 729.383 115.352C729.672 115.128 729.817 114.834 729.817 114.47C729.817 114.106 729.695 113.826 729.453 113.63C729.21 113.425 728.911 113.266 728.557 113.154C728.211 113.042 727.861 112.921 727.507 112.79C727.161 112.659 726.867 112.463 726.625 112.202C726.382 111.941 726.261 111.609 726.261 111.208C726.261 110.62 726.452 110.167 726.835 109.85C727.217 109.523 727.735 109.36 728.389 109.36C729.042 109.36 729.649 109.458 730.209 109.654L730.307 109.696L730.125 110.592C729.565 110.377 729.042 110.27 728.557 110.27C728.081 110.27 727.754 110.345 727.577 110.494C727.399 110.643 727.311 110.895 727.311 111.25C727.311 111.474 727.432 111.665 727.675 111.824C727.917 111.983 728.211 112.123 728.557 112.244C728.911 112.356 729.261 112.491 729.607 112.65C729.961 112.799 730.26 113.028 730.503 113.336C730.745 113.644 730.867 114.022 730.867 114.47C730.867 115.123 730.638 115.641 730.181 116.024C729.723 116.397 729.093 116.584 728.291 116.584C727.488 116.584 726.774 116.402 726.149 116.038L726.401 115.254Z"
                    fill="#94A3B8"
                  />
                </g>
                <rect
                  x="672.5"
                  y="90"
                  width="131"
                  height="43"
                  rx="3.5"
                  stroke="#94A3B8"
                />
              </g>
              <g id="SchemaCard_7">
                <g id="Container_7">
                  <g id="Icon_14">
                    <path
                      id="Vector_18"
                      d="M696.25 161.25H685.75C685.336 161.25 685 160.914 685 160.5V159C685 158.586 685.336 158.25 685.75 158.25H696.25C696.664 158.25 697 158.586 697 159V160.5C697 160.914 696.664 161.25 696.25 161.25ZM695.125 159.188C694.814 159.188 694.562 159.439 694.562 159.75C694.562 160.061 694.814 160.312 695.125 160.312C695.436 160.312 695.688 160.061 695.688 159.75C695.688 159.439 695.436 159.188 695.125 159.188ZM693.625 159.188C693.314 159.188 693.062 159.439 693.062 159.75C693.062 160.061 693.314 160.312 693.625 160.312C693.936 160.312 694.188 160.061 694.188 159.75C694.188 159.439 693.936 159.188 693.625 159.188ZM696.25 165H685.75C685.336 165 685 164.664 685 164.25V162.75C685 162.336 685.336 162 685.75 162H696.25C696.664 162 697 162.336 697 162.75V164.25C697 164.664 696.664 165 696.25 165ZM695.125 162.938C694.814 162.938 694.562 163.189 694.562 163.5C694.562 163.811 694.814 164.062 695.125 164.062C695.436 164.062 695.688 163.811 695.688 163.5C695.688 163.189 695.436 162.938 695.125 162.938ZM693.625 162.938C693.314 162.938 693.062 163.189 693.062 163.5C693.062 163.811 693.314 164.062 693.625 164.062C693.936 164.062 694.188 163.811 694.188 163.5C694.188 163.189 693.936 162.938 693.625 162.938ZM696.25 168.75H685.75C685.336 168.75 685 168.414 685 168V166.5C685 166.086 685.336 165.75 685.75 165.75H696.25C696.664 165.75 697 166.086 697 166.5V168C697 168.414 696.664 168.75 696.25 168.75ZM695.125 166.688C694.814 166.688 694.562 166.939 694.562 167.25C694.562 167.561 694.814 167.812 695.125 167.812C695.436 167.812 695.688 167.561 695.688 167.25C695.688 166.939 695.436 166.688 695.125 166.688ZM693.625 166.688C693.314 166.688 693.062 166.939 693.062 167.25C693.062 167.561 693.314 167.812 693.625 167.812C693.936 167.812 694.188 167.561 694.188 167.25C694.188 166.939 693.936 166.688 693.625 166.688Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_10"
                    d="M710.358 163.25C710.358 164.827 709.901 166.097 708.986 167.058C708.071 168.019 706.849 168.5 705.318 168.5H703.274V158.7H705.752C707.143 158.7 708.258 159.125 709.098 159.974C709.938 160.823 710.358 161.915 710.358 163.25ZM709.224 163.138C709.224 162.037 708.888 161.173 708.216 160.548C707.544 159.923 706.741 159.61 705.808 159.61H704.408V167.59H705.444C706.499 167.59 707.39 167.193 708.118 166.4C708.855 165.607 709.224 164.519 709.224 163.138ZM715.362 164.314H715.936C715.936 163.465 715.829 162.914 715.614 162.662C715.4 162.401 714.924 162.27 714.186 162.27C713.449 162.27 712.824 162.368 712.31 162.564L712.114 161.752C712.898 161.491 713.71 161.36 714.55 161.36C716.193 161.36 717.014 162.181 717.014 163.824V168.5H716.398L716.034 167.674C715.605 168.029 715.232 168.271 714.914 168.402C714.606 168.523 714.247 168.584 713.836 168.584C713.183 168.584 712.674 168.393 712.31 168.01C711.946 167.618 711.764 167.105 711.764 166.47C711.764 165.033 712.964 164.314 715.362 164.314ZM715.95 165.196H715.32C714.368 165.196 713.71 165.289 713.346 165.476C712.992 165.663 712.814 165.957 712.814 166.358C712.814 166.75 712.917 167.072 713.122 167.324C713.328 167.576 713.594 167.702 713.92 167.702C714.256 167.702 714.574 167.627 714.872 167.478C715.18 167.319 715.54 167.049 715.95 166.666V165.196ZM719.725 166.988V162.34H718.773V161.5H719.739V159.498H720.789V161.5H722.497V162.34H720.775V166.792C720.775 167.417 721.093 167.73 721.727 167.73C721.877 167.73 722.105 167.702 722.413 167.646L722.567 168.402C722.185 168.523 721.788 168.584 721.377 168.584C720.976 168.584 720.598 168.463 720.243 168.22C719.898 167.968 719.725 167.557 719.725 166.988ZM727.421 164.314H727.995C727.995 163.465 727.888 162.914 727.673 162.662C727.458 162.401 726.982 162.27 726.245 162.27C725.508 162.27 724.882 162.368 724.369 162.564L724.173 161.752C724.957 161.491 725.769 161.36 726.609 161.36C728.252 161.36 729.073 162.181 729.073 163.824V168.5H728.457L728.093 167.674C727.664 168.029 727.29 168.271 726.973 168.402C726.665 168.523 726.306 168.584 725.895 168.584C725.242 168.584 724.733 168.393 724.369 168.01C724.005 167.618 723.823 167.105 723.823 166.47C723.823 165.033 725.022 164.314 727.421 164.314ZM728.009 165.196H727.379C726.427 165.196 725.769 165.289 725.405 165.476C725.05 165.663 724.873 165.957 724.873 166.358C724.873 166.75 724.976 167.072 725.181 167.324C725.386 167.576 725.652 167.702 725.979 167.702C726.315 167.702 726.632 167.627 726.931 167.478C727.239 167.319 727.598 167.049 728.009 166.666V165.196ZM737.594 164.384H736.166V168.5H735.116V158.7H737.916C738.961 158.7 739.717 158.929 740.184 159.386C740.66 159.843 740.898 160.557 740.898 161.528C740.898 162.489 740.608 163.208 740.03 163.684C739.451 164.151 738.639 164.384 737.594 164.384ZM737.44 159.596H736.166V163.488H737.09C738.051 163.488 738.751 163.343 739.19 163.054C739.628 162.765 739.848 162.27 739.848 161.57C739.848 160.861 739.656 160.357 739.274 160.058C738.891 159.75 738.28 159.596 737.44 159.596ZM742.69 168.5V158.7H743.74V168.5H742.69ZM749.31 164.314H749.884C749.884 163.465 749.776 162.914 749.562 162.662C749.347 162.401 748.871 162.27 748.134 162.27C747.396 162.27 746.771 162.368 746.258 162.564L746.062 161.752C746.846 161.491 747.658 161.36 748.498 161.36C750.14 161.36 750.962 162.181 750.962 163.824V168.5H750.346L749.982 167.674C749.552 168.029 749.179 168.271 748.862 168.402C748.554 168.523 748.194 168.584 747.784 168.584C747.13 168.584 746.622 168.393 746.258 168.01C745.894 167.618 745.712 167.105 745.712 166.47C745.712 165.033 746.911 164.314 749.31 164.314ZM749.898 165.196H749.268C748.316 165.196 747.658 165.289 747.294 165.476C746.939 165.663 746.762 165.957 746.762 166.358C746.762 166.75 746.864 167.072 747.07 167.324C747.275 167.576 747.541 167.702 747.868 167.702C748.204 167.702 748.521 167.627 748.82 167.478C749.128 167.319 749.487 167.049 749.898 166.666V165.196ZM753.672 166.988V162.34H752.72V161.5H753.686V159.498H754.736V161.5H756.444V162.34H754.722V166.792C754.722 167.417 755.04 167.73 755.674 167.73C755.824 167.73 756.052 167.702 756.36 167.646L756.514 168.402C756.132 168.523 755.735 168.584 755.324 168.584C754.923 168.584 754.545 168.463 754.19 168.22C753.845 167.968 753.672 167.557 753.672 166.988ZM758.652 161.5V160.156C758.652 159.587 758.825 159.181 759.17 158.938C759.525 158.686 759.903 158.56 760.304 158.56C760.715 158.56 761.112 158.621 761.494 158.742L761.34 159.498C761.032 159.442 760.804 159.414 760.654 159.414C760.01 159.414 759.688 159.727 759.688 160.352V161.5H761.116V162.34H759.688V168.5H758.638V162.34H757.56V161.5H758.652ZM766.745 165.056C766.745 164.151 766.567 163.46 766.213 162.984C765.858 162.508 765.34 162.27 764.659 162.27C763.977 162.27 763.492 162.499 763.203 162.956C762.923 163.404 762.783 164.095 762.783 165.028C762.783 166.792 763.431 167.674 764.729 167.674C765.41 167.674 765.914 167.464 766.241 167.044C766.577 166.615 766.745 165.952 766.745 165.056ZM766.997 167.632C766.465 168.267 765.713 168.584 764.743 168.584C763.772 168.584 763.025 168.271 762.503 167.646C761.989 167.011 761.733 166.129 761.733 165C761.733 163.861 761.98 162.97 762.475 162.326C762.979 161.682 763.711 161.36 764.673 161.36C765.643 161.36 766.404 161.687 766.955 162.34C767.515 162.993 767.795 163.88 767.795 165C767.795 166.12 767.529 166.997 766.997 167.632ZM770.715 163.152V168.5H769.665V161.5H770.337L770.505 162.326C770.953 161.971 771.326 161.724 771.625 161.584C771.923 161.435 772.264 161.36 772.647 161.36C772.833 161.36 772.973 161.369 773.067 161.388L773.263 161.444L773.095 162.41C772.927 162.354 772.698 162.326 772.409 162.326C771.849 162.326 771.284 162.601 770.715 163.152ZM777.814 161.346C778.71 161.346 779.349 161.663 779.732 162.298C780.525 161.663 781.258 161.346 781.93 161.346C782.602 161.346 783.148 161.537 783.568 161.92C783.997 162.293 784.212 162.839 784.212 163.558V168.5H783.19V163.992C783.19 163.423 783.059 162.993 782.798 162.704C782.546 162.405 782.205 162.256 781.776 162.256C781.188 162.256 780.595 162.489 779.998 162.956C780.045 163.161 780.068 163.362 780.068 163.558V168.5H779.046V163.992C779.046 163.423 778.915 162.993 778.654 162.704C778.402 162.405 778.061 162.256 777.632 162.256C777.352 162.256 777.095 162.293 776.862 162.368C776.629 162.443 776.456 162.517 776.344 162.592C776.232 162.667 776.087 162.779 775.91 162.928V168.5H774.86V161.5H775.532L775.714 162.214C775.947 162.018 776.125 161.878 776.246 161.794C776.377 161.701 776.587 161.603 776.876 161.5C777.165 161.397 777.478 161.346 777.814 161.346ZM786.488 167.254C787.095 167.534 787.674 167.674 788.224 167.674C788.775 167.674 789.19 167.567 789.47 167.352C789.76 167.128 789.904 166.834 789.904 166.47C789.904 166.106 789.783 165.826 789.54 165.63C789.298 165.425 788.999 165.266 788.644 165.154C788.299 165.042 787.949 164.921 787.594 164.79C787.249 164.659 786.955 164.463 786.712 164.202C786.47 163.941 786.348 163.609 786.348 163.208C786.348 162.62 786.54 162.167 786.922 161.85C787.305 161.523 787.823 161.36 788.476 161.36C789.13 161.36 789.736 161.458 790.296 161.654L790.394 161.696L790.212 162.592C789.652 162.377 789.13 162.27 788.644 162.27C788.168 162.27 787.842 162.345 787.664 162.494C787.487 162.643 787.398 162.895 787.398 163.25C787.398 163.474 787.52 163.665 787.762 163.824C788.005 163.983 788.299 164.123 788.644 164.244C788.999 164.356 789.349 164.491 789.694 164.65C790.049 164.799 790.348 165.028 790.59 165.336C790.833 165.644 790.954 166.022 790.954 166.47C790.954 167.123 790.726 167.641 790.268 168.024C789.811 168.397 789.181 168.584 788.378 168.584C787.576 168.584 786.862 168.402 786.236 168.038L786.488 167.254Z"
                    fill="#94A3B8"
                  />
                </g>
                <rect
                  x="672.5"
                  y="142"
                  width="131"
                  height="43"
                  rx="3.5"
                  stroke="#94A3B8"
                />
              </g>
              <g id="SchemaCard_8">
                <g id="Container_8">
                  <g id="Icon_15">
                    <path
                      id="Vector_19"
                      d="M692.2 216.7H689.8C689.469 216.7 689.2 216.969 689.2 217.3V219.7C689.2 220.031 689.469 220.3 689.8 220.3H692.2C692.531 220.3 692.8 220.031 692.8 219.7V217.3C692.8 216.969 692.531 216.7 692.2 216.7ZM688.6 211.3C688.6 210.969 688.331 210.7 688 210.7H685.6C685.269 210.7 685 210.969 685 211.3V213.7C685 214.031 685.269 214.3 685.6 214.3H687.395L688.767 216.701C688.975 216.343 689.358 216.1 689.8 216.1H689.805L688.6 213.991V213.1H692.8V211.9H688.6V211.3ZM696.4 210.7H694C693.669 210.7 693.4 210.969 693.4 211.3V213.7C693.4 214.031 693.669 214.3 694 214.3H696.4C696.731 214.3 697 214.031 697 213.7V211.3C697 210.969 696.731 210.7 696.4 210.7Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_11"
                    d="M706.522 220.57C705.243 220.57 704.277 220.099 703.624 219.156C702.971 218.204 702.644 216.995 702.644 215.53C702.644 214.065 702.971 212.87 703.624 211.946C704.287 211.022 705.253 210.56 706.522 210.56C707.801 210.56 708.771 211.022 709.434 211.946C710.097 212.87 710.428 214.065 710.428 215.53C710.428 217.537 709.859 218.983 708.72 219.87C708.113 220.337 707.381 220.57 706.522 220.57ZM706.55 211.47C705.598 211.47 704.884 211.867 704.408 212.66C703.941 213.453 703.708 214.424 703.708 215.572C703.708 216.72 703.946 217.686 704.422 218.47C704.907 219.254 705.617 219.646 706.55 219.646C707.483 219.646 708.188 219.249 708.664 218.456C709.14 217.663 709.378 216.664 709.378 215.46C709.378 213.948 708.953 212.819 708.104 212.072C707.665 211.671 707.147 211.47 706.55 211.47ZM712.52 218.988V214.34H711.568V213.5H712.534V211.498H713.584V213.5H715.292V214.34H713.57V218.792C713.57 219.417 713.887 219.73 714.522 219.73C714.671 219.73 714.9 219.702 715.208 219.646L715.362 220.402C714.979 220.523 714.583 220.584 714.172 220.584C713.771 220.584 713.393 220.463 713.038 220.22C712.693 219.968 712.52 219.557 712.52 218.988ZM722.428 220.5H721.378V215.894C721.378 214.765 720.907 214.2 719.964 214.2C719.264 214.2 718.69 214.424 718.242 214.872V220.5H717.192V210.7H718.228V214.018C718.433 213.85 718.592 213.729 718.704 213.654C718.825 213.579 719.017 213.505 719.278 213.43C719.549 213.355 719.852 213.318 720.188 213.318C720.832 213.318 721.364 213.514 721.784 213.906C722.213 214.298 722.428 214.858 722.428 215.586V220.5ZM729.829 217.224H725.363C725.363 218.12 725.573 218.755 725.993 219.128C726.423 219.501 726.959 219.688 727.603 219.688C727.93 219.688 728.159 219.674 728.289 219.646C728.42 219.609 728.541 219.576 728.653 219.548C728.775 219.511 728.859 219.483 728.905 219.464C729.139 219.399 729.339 219.338 729.507 219.282L729.675 220.094C728.742 220.421 728.014 220.584 727.491 220.584C726.53 220.584 725.76 220.295 725.181 219.716C724.603 219.128 724.313 218.251 724.313 217.084C724.313 215.908 724.584 214.993 725.125 214.34C725.676 213.687 726.367 213.36 727.197 213.36C728.037 213.36 728.691 213.631 729.157 214.172C729.624 214.713 729.857 215.446 729.857 216.37C729.857 216.622 729.848 216.907 729.829 217.224ZM725.433 216.426H728.849C728.849 215.735 728.728 215.203 728.485 214.83C728.243 214.457 727.818 214.27 727.211 214.27C726.614 214.27 726.175 214.471 725.895 214.872C725.615 215.273 725.461 215.791 725.433 216.426ZM732.871 215.152V220.5H731.821V213.5H732.493L732.661 214.326C733.109 213.971 733.482 213.724 733.781 213.584C734.08 213.435 734.42 213.36 734.803 213.36C734.99 213.36 735.13 213.369 735.223 213.388L735.419 213.444L735.251 214.41C735.083 214.354 734.854 214.326 734.565 214.326C734.005 214.326 733.44 214.601 732.871 215.152ZM745.444 211.05L745.22 211.988L744.408 211.75C743.83 211.61 743.33 211.54 742.91 211.54C741.809 211.54 741.258 212.03 741.258 213.01C741.258 213.439 741.426 213.794 741.762 214.074C742.098 214.345 742.504 214.564 742.98 214.732C743.466 214.891 743.946 215.068 744.422 215.264C744.908 215.451 745.318 215.745 745.654 216.146C745.99 216.538 746.158 217.037 746.158 217.644C746.158 218.568 745.874 219.291 745.304 219.814C744.735 220.327 743.928 220.584 742.882 220.584C742.36 220.584 741.832 220.509 741.3 220.36C740.778 220.201 740.348 220.019 740.012 219.814L740.362 219.016C741.212 219.408 742.014 219.604 742.77 219.604C743.536 219.604 744.114 219.45 744.506 219.142C744.908 218.834 745.108 218.386 745.108 217.798C745.108 217.201 744.786 216.734 744.142 216.398C743.853 216.249 743.531 216.109 743.176 215.978C742.831 215.847 742.481 215.707 742.126 215.558C741.781 215.399 741.464 215.222 741.174 215.026C740.894 214.83 740.661 214.564 740.474 214.228C740.297 213.892 740.208 213.5 740.208 213.052C740.208 212.249 740.446 211.633 740.922 211.204C741.408 210.775 742.056 210.56 742.868 210.56C743.68 210.56 744.539 210.723 745.444 211.05ZM753.085 217.224H748.619C748.619 218.12 748.829 218.755 749.249 219.128C749.678 219.501 750.215 219.688 750.859 219.688C751.186 219.688 751.414 219.674 751.545 219.646C751.676 219.609 751.797 219.576 751.909 219.548C752.03 219.511 752.114 219.483 752.161 219.464C752.394 219.399 752.595 219.338 752.763 219.282L752.931 220.094C751.998 220.421 751.27 220.584 750.747 220.584C749.786 220.584 749.016 220.295 748.437 219.716C747.858 219.128 747.569 218.251 747.569 217.084C747.569 215.908 747.84 214.993 748.381 214.34C748.932 213.687 749.622 213.36 750.453 213.36C751.293 213.36 751.946 213.631 752.413 214.172C752.88 214.713 753.113 215.446 753.113 216.37C753.113 216.622 753.104 216.907 753.085 217.224ZM748.689 216.426H752.105C752.105 215.735 751.984 215.203 751.741 214.83C751.498 214.457 751.074 214.27 750.467 214.27C749.87 214.27 749.431 214.471 749.151 214.872C748.871 215.273 748.717 215.791 748.689 216.426ZM756.127 215.152V220.5H755.077V213.5H755.749L755.917 214.326C756.365 213.971 756.738 213.724 757.037 213.584C757.335 213.435 757.676 213.36 758.059 213.36C758.245 213.36 758.385 213.369 758.479 213.388L758.675 213.444L758.507 214.41C758.339 214.354 758.11 214.326 757.821 214.326C757.261 214.326 756.696 214.601 756.127 215.152ZM765.074 213.486L762.708 220.5H761.504L759.152 213.486H760.342L762.12 219.38L763.912 213.486H765.074ZM766.31 220.5V213.5H767.36V220.5H766.31ZM767.36 210.7V211.946H766.31V210.7H767.36ZM773.808 219.408L774.018 220.234C773.271 220.458 772.613 220.57 772.044 220.57C771.045 220.57 770.294 220.243 769.79 219.59C769.286 218.937 769.034 218.036 769.034 216.888C769.034 215.74 769.295 214.867 769.818 214.27C770.341 213.663 771.111 213.36 772.128 213.36C772.567 213.36 773.183 213.472 773.976 213.696L773.556 214.508C773.043 214.359 772.581 214.284 772.17 214.284C771.461 214.284 770.947 214.494 770.63 214.914C770.322 215.334 770.168 215.997 770.168 216.902C770.168 218.741 770.826 219.66 772.142 219.66C772.665 219.66 773.22 219.576 773.808 219.408ZM780.607 217.224H776.141C776.141 218.12 776.351 218.755 776.771 219.128C777.2 219.501 777.737 219.688 778.381 219.688C778.707 219.688 778.936 219.674 779.067 219.646C779.197 219.609 779.319 219.576 779.431 219.548C779.552 219.511 779.636 219.483 779.683 219.464C779.916 219.399 780.117 219.338 780.285 219.282L780.453 220.094C779.519 220.421 778.791 220.584 778.269 220.584C777.307 220.584 776.537 220.295 775.959 219.716C775.38 219.128 775.091 218.251 775.091 217.084C775.091 215.908 775.361 214.993 775.903 214.34C776.453 213.687 777.144 213.36 777.975 213.36C778.815 213.36 779.468 213.631 779.935 214.172C780.401 214.713 780.635 215.446 780.635 216.37C780.635 216.622 780.625 216.907 780.607 217.224ZM776.211 216.426H779.627C779.627 215.735 779.505 215.203 779.263 214.83C779.02 214.457 778.595 214.27 777.989 214.27C777.391 214.27 776.953 214.471 776.673 214.872C776.393 215.273 776.239 215.791 776.211 216.426ZM782.332 219.254C782.939 219.534 783.518 219.674 784.068 219.674C784.619 219.674 785.034 219.567 785.314 219.352C785.604 219.128 785.748 218.834 785.748 218.47C785.748 218.106 785.627 217.826 785.384 217.63C785.142 217.425 784.843 217.266 784.488 217.154C784.143 217.042 783.793 216.921 783.438 216.79C783.093 216.659 782.799 216.463 782.556 216.202C782.314 215.941 782.192 215.609 782.192 215.208C782.192 214.62 782.384 214.167 782.766 213.85C783.149 213.523 783.667 213.36 784.32 213.36C784.974 213.36 785.58 213.458 786.14 213.654L786.238 213.696L786.056 214.592C785.496 214.377 784.974 214.27 784.488 214.27C784.012 214.27 783.686 214.345 783.508 214.494C783.331 214.643 783.242 214.895 783.242 215.25C783.242 215.474 783.364 215.665 783.606 215.824C783.849 215.983 784.143 216.123 784.488 216.244C784.843 216.356 785.193 216.491 785.538 216.65C785.893 216.799 786.192 217.028 786.434 217.336C786.677 217.644 786.798 218.022 786.798 218.47C786.798 219.123 786.57 219.641 786.112 220.024C785.655 220.397 785.025 220.584 784.222 220.584C783.42 220.584 782.706 220.402 782.08 220.038L782.332 219.254Z"
                    fill="#94A3B8"
                  />
                </g>
                <rect
                  x="672.5"
                  y="194"
                  width="131"
                  height="43"
                  rx="3.5"
                  stroke="#94A3B8"
                />
              </g>
            </g>
          </g>
        </g>
        <rect
          x="0.5"
          y="1"
          width="823"
          height="256"
          rx="3.5"
          stroke="#CBD5E1"
        />
      </g>
      <defs>
        <filter
          id="filter0_d_404_14460"
          x="310"
          y="19.5"
          width="204"
          height="48"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="2"
            operator="dilate"
            in="SourceAlpha"
            result="effect1_dropShadow_404_14460"
          />
          <feOffset />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.992157 0 0 0 0 0.901961 0 0 0 0 0.541176 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_404_14460"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_404_14460"
            result="shape"
          />
        </filter>
        <filter
          id="filter1_d_404_14460"
          x="310"
          y="144.5"
          width="204"
          height="96"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_404_14460"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_404_14460"
            result="shape"
          />
        </filter>
        <clipPath id="clip0_404_14460">
          <rect x="312" y="21.5" width="200" height="44" rx="4" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}
