import React from 'react';

type Props = {
  className?: string;
};

export function MultipleJWTSecretsSvg(props: Props) {
  const { className } = props;
  return (
    <svg
      className={className}
      width="673"
      height="272"
      viewBox="0 0 673 272"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect x="1" y="1" width="671" height="270" rx="2" fill="#E2E8F0" />
      <g filter="url(#filter0_dd_571_49556)">
        <rect
          x="322.482"
          y="109"
          width="54.0691"
          height="54"
          rx="27"
          fill="white"
          shapeRendering="crispEdges"
        />
        <g clipPath="url(#clip0_571_49556)">
          <path
            d="M361.137 132.172C361.849 130.021 361.421 125.724 360.04 124.139C359.86 123.932 359.52 123.962 359.371 124.19L357.668 126.779C357.247 127.298 356.489 127.416 355.92 127.055C354.074 125.884 351.868 125.203 349.497 125.203C347.125 125.203 344.919 125.884 343.073 127.055C342.504 127.416 341.746 127.295 341.325 126.779L339.622 124.19C339.473 123.962 339.134 123.932 338.953 124.139C337.572 125.724 337.144 130.021 337.856 132.172C338.091 132.886 338.159 133.641 338.018 134.379C337.881 135.108 337.74 135.991 337.74 136.601C337.74 142.895 343.006 148 349.497 148C355.991 148 361.253 142.898 361.253 136.601C361.253 135.988 361.116 135.108 360.975 134.379C360.834 133.641 360.902 132.886 361.137 132.172ZM349.497 145.452C344.479 145.452 340.396 141.493 340.396 136.628C340.396 136.468 340.402 136.311 340.408 136.154C340.591 132.839 342.666 130.003 345.606 128.652C346.786 128.107 348.106 127.804 349.497 127.804C350.887 127.804 352.207 128.11 353.39 128.655C356.33 130.006 358.405 132.841 358.588 136.154C358.597 136.311 358.6 136.468 358.6 136.628C358.597 141.493 354.514 145.452 349.497 145.452Z"
            fill="black"
          />
          <path
            d="M353.439 140.024L351.113 136.115L349.118 132.856C349.072 132.779 348.986 132.732 348.892 132.732H346.985C346.89 132.732 346.804 132.782 346.758 132.859C346.713 132.939 346.713 133.037 346.762 133.114L348.668 136.225L346.108 140.012C346.056 140.089 346.049 140.189 346.095 140.272C346.141 140.355 346.23 140.406 346.325 140.406H348.244C348.332 140.406 348.415 140.361 348.464 140.29L349.848 138.192L351.089 140.278C351.135 140.358 351.223 140.406 351.315 140.406H353.207C353.301 140.406 353.387 140.358 353.433 140.278C353.488 140.198 353.488 140.104 353.439 140.024Z"
            fill="black"
          />
        </g>
      </g>
      <g filter="url(#filter1_dd_571_49556)">
        <rect
          x="367.54"
          y="123"
          width="26.0332"
          height="26"
          rx="13"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M383.994 135.375H383.525V133.969C383.525 132.332 382.193 131 380.557 131C378.92 131 377.588 132.332 377.588 133.969V135.375H377.119C376.602 135.375 376.182 135.795 376.182 136.312V140.062C376.182 140.58 376.602 141 377.119 141H383.994C384.512 141 384.932 140.58 384.932 140.062V136.312C384.932 135.795 384.512 135.375 383.994 135.375ZM381.963 135.375H379.15V133.969C379.15 133.193 379.781 132.562 380.557 132.562C381.332 132.562 381.963 133.193 381.963 133.969V135.375Z"
          fill="#64748B"
        />
      </g>
      <path
        d="M53.5393 47.0312H51.1727L52.0463 44.3693C52.1283 44.0576 51.8925 43.75 51.5705 43.75H48.6174C48.3713 43.75 48.1621 43.9325 48.1293 44.1766L47.4731 49.0984C47.4341 49.3937 47.6638 49.6562 47.9612 49.6562H50.3954L49.45 53.645C49.3762 53.9567 49.6141 54.25 49.9279 54.25C50.1001 54.25 50.2642 54.1598 50.3544 54.0039L53.9638 47.7695C54.1545 47.4435 53.9187 47.0312 53.5393 47.0312Z"
        fill="#94A3B8"
      />
      <path
        d="M63.986 49.352H63.842V52.988H62.102V44.588H64.766C65.67 44.588 66.346 44.788 66.794 45.188C67.242 45.58 67.466 46.144 67.466 46.88C67.466 47.328 67.31 47.74 66.998 48.116C66.686 48.484 66.306 48.696 65.858 48.752C66.178 48.84 66.426 48.988 66.602 49.196C66.778 49.396 66.962 49.724 67.154 50.18L68.342 52.988H66.554L65.39 50.3C65.222 49.916 65.042 49.664 64.85 49.544C64.666 49.416 64.378 49.352 63.986 49.352ZM64.718 45.956H63.842V47.984H64.598C64.918 47.984 65.166 47.88 65.342 47.672C65.526 47.464 65.618 47.208 65.618 46.904C65.618 46.272 65.318 45.956 64.718 45.956ZM74.3365 53H69.3325V44.6H74.3365V45.98H71.0725V47.744H74.0365V49.148H71.0725V51.62H74.3365V53ZM80.5404 44.9L80.2524 46.304L79.5084 46.1C78.9804 45.98 78.5204 45.92 78.1284 45.92C77.5844 45.92 77.3124 46.18 77.3124 46.7C77.3124 46.9 77.4044 47.084 77.5884 47.252C77.7804 47.412 78.0204 47.548 78.3084 47.66C78.5964 47.764 78.9044 47.896 79.2324 48.056C79.5604 48.216 79.8684 48.388 80.1564 48.572C80.4444 48.756 80.6804 49.008 80.8644 49.328C81.0564 49.648 81.1524 50.016 81.1524 50.432C81.1524 51.256 80.8844 51.904 80.3484 52.376C79.8204 52.84 79.0724 53.072 78.1044 53.072C77.6084 53.072 77.1124 53.008 76.6164 52.88C76.1284 52.744 75.7244 52.588 75.4044 52.412L75.9204 51.128C76.6564 51.464 77.3844 51.632 78.1044 51.632C78.5124 51.632 78.8324 51.54 79.0644 51.356C79.2964 51.164 79.4124 50.92 79.4124 50.624C79.4124 50.328 79.2804 50.084 79.0164 49.892C78.7524 49.692 78.4324 49.516 78.0564 49.364C77.6804 49.204 77.3044 49.028 76.9284 48.836C76.5524 48.636 76.2324 48.36 75.9684 48.008C75.7044 47.648 75.5724 47.224 75.5724 46.736C75.5724 46.008 75.8004 45.452 76.2564 45.068C76.7124 44.676 77.3244 44.48 78.0924 44.48C78.8684 44.48 79.6844 44.62 80.5404 44.9ZM83.7658 53V46.004H81.8338V44.6H87.4018V46.004H85.4938V53H83.7658ZM96.4966 53H91.4926V44.6H96.4966V45.98H93.2326V47.744H96.1966V49.148H93.2326V51.62H96.4966V53ZM103.205 53H101.621V49.412C101.621 49.084 101.557 48.82 101.429 48.62C101.301 48.412 101.089 48.308 100.793 48.308C100.497 48.308 100.129 48.492 99.6885 48.86V53H98.1165V47H99.4365L99.6885 47.54C100.033 47.284 100.329 47.112 100.577 47.024C100.833 46.928 101.129 46.88 101.465 46.88C102.001 46.88 102.425 47.06 102.737 47.42C103.049 47.772 103.205 48.296 103.205 48.992V53ZM109.696 53H108.52L108.28 52.316C107.608 52.82 106.996 53.072 106.444 53.072C105.9 53.072 105.448 52.816 105.088 52.304C104.736 51.784 104.56 51.02 104.56 50.012C104.56 48.996 104.76 48.22 105.16 47.684C105.568 47.148 106.1 46.88 106.756 46.88C107.188 46.88 107.652 47.08 108.148 47.48V44.6H109.696V53ZM108.136 51.152V48.764C107.712 48.412 107.356 48.236 107.068 48.236C106.78 48.236 106.548 48.384 106.372 48.68C106.204 48.976 106.12 49.416 106.12 50C106.12 51.12 106.424 51.68 107.032 51.68C107.344 51.68 107.712 51.504 108.136 51.152ZM113.212 55.844H111.652V47H112.84L113.128 47.636C113.424 47.388 113.692 47.2 113.932 47.072C114.18 46.944 114.456 46.88 114.76 46.88C115.424 46.88 115.928 47.156 116.272 47.708C116.624 48.26 116.8 49.032 116.8 50.024C116.8 51.016 116.576 51.776 116.128 52.304C115.68 52.824 115.152 53.084 114.544 53.084C114.104 53.084 113.66 52.892 113.212 52.508V55.844ZM113.212 48.848V51.044C113.468 51.46 113.784 51.668 114.16 51.668C114.544 51.668 114.808 51.532 114.952 51.26C115.104 50.988 115.18 50.572 115.18 50.012C115.18 49.452 115.1 49.02 114.94 48.716C114.78 48.412 114.58 48.26 114.34 48.26C113.996 48.26 113.62 48.456 113.212 48.848ZM123.158 50.012C123.158 50.972 122.914 51.724 122.426 52.268C121.938 52.812 121.246 53.084 120.35 53.084C119.454 53.084 118.774 52.812 118.31 52.268C117.846 51.724 117.614 50.968 117.614 50C117.614 49.032 117.846 48.272 118.31 47.72C118.774 47.16 119.442 46.88 120.314 46.88C121.186 46.88 121.878 47.164 122.39 47.732C122.902 48.292 123.158 49.052 123.158 50.012ZM121.562 49.988C121.562 48.764 121.17 48.152 120.386 48.152C119.586 48.152 119.186 48.76 119.186 49.976C119.186 51.192 119.59 51.8 120.398 51.8C120.83 51.8 121.13 51.648 121.298 51.344C121.474 51.032 121.562 50.58 121.562 49.988ZM126.043 46.1H124.483V44.6H126.043V46.1ZM126.043 53H124.483V47H126.043V53ZM133.029 53H131.445V49.412C131.445 49.084 131.381 48.82 131.253 48.62C131.125 48.412 130.913 48.308 130.617 48.308C130.321 48.308 129.953 48.492 129.513 48.86V53H127.941V47H129.261L129.513 47.54C129.857 47.284 130.153 47.112 130.401 47.024C130.657 46.928 130.953 46.88 131.289 46.88C131.825 46.88 132.249 47.06 132.561 47.42C132.873 47.772 133.029 48.296 133.029 48.992V53ZM134.912 51.704V48.32H134.3V47H134.924V45.284H136.472V47H137.732V48.32H136.46V50.936C136.46 51.472 136.624 51.74 136.952 51.74C137.136 51.74 137.332 51.716 137.54 51.668L137.792 52.916C137.424 53.02 137.032 53.072 136.616 53.072C136.208 53.072 135.82 52.968 135.452 52.76C135.092 52.544 134.912 52.192 134.912 51.704ZM139.012 51.404C139.548 51.676 140.096 51.812 140.656 51.812C141.224 51.812 141.508 51.604 141.508 51.188C141.508 50.804 141.188 50.52 140.548 50.336C140.276 50.264 140.004 50.18 139.732 50.084C139.468 49.98 139.24 49.816 139.048 49.592C138.864 49.36 138.772 49.064 138.772 48.704C138.772 48.12 138.952 47.672 139.312 47.36C139.672 47.04 140.172 46.88 140.812 46.88C141.46 46.88 142.072 46.992 142.648 47.216L142.396 48.464C141.868 48.248 141.352 48.14 140.848 48.14C140.496 48.14 140.32 48.26 140.32 48.5C140.32 48.748 140.556 48.936 141.028 49.064C141.524 49.192 141.964 49.376 142.348 49.616C142.548 49.736 142.716 49.916 142.852 50.156C142.988 50.396 143.056 50.684 143.056 51.02C143.056 51.652 142.844 52.152 142.42 52.52C141.996 52.888 141.412 53.072 140.668 53.072C139.924 53.072 139.26 52.9 138.676 52.556L139.012 51.404Z"
        fill="#94A3B8"
      />
      <rect
        x="35.5"
        y="25.5"
        width="167.215"
        height="47"
        rx="3"
        stroke="#94A3B8"
      />
      <path
        d="M53.375 218.406C53.375 218.232 53.3059 218.065 53.1828 217.942C53.0597 217.819 52.8928 217.75 52.7188 217.75C52.5447 217.75 52.3778 217.819 52.2547 217.942C52.1316 218.065 52.0625 218.232 52.0625 218.406V220.375H53.375V218.406ZM54.3594 221.031H47.1406C47.0536 221.031 46.9701 221.066 46.9086 221.127C46.8471 221.189 46.8125 221.272 46.8125 221.359V222.016C46.8125 222.103 46.8471 222.186 46.9086 222.248C46.9701 222.309 47.0536 222.344 47.1406 222.344H47.4688V223C47.4689 223.756 47.7302 224.489 48.2085 225.075C48.6868 225.661 49.3527 226.064 50.0938 226.216V228.25H51.4062V226.216C52.1473 226.064 52.8132 225.661 53.2915 225.075C53.7698 224.489 54.0311 223.756 54.0312 223V222.344H54.3594C54.4464 222.344 54.5299 222.309 54.5914 222.248C54.6529 222.186 54.6875 222.103 54.6875 222.016V221.359C54.6875 221.272 54.6529 221.189 54.5914 221.127C54.5299 221.066 54.4464 221.031 54.3594 221.031ZM49.4375 218.406C49.4375 218.232 49.3684 218.065 49.2453 217.942C49.1222 217.819 48.9553 217.75 48.7812 217.75C48.6072 217.75 48.4403 217.819 48.3172 217.942C48.1941 218.065 48.125 218.232 48.125 218.406V220.375H49.4375V218.406Z"
        fill="#94A3B8"
      />
      <path
        d="M65.594 227.072C64.362 227.072 63.382 226.68 62.654 225.896C61.926 225.112 61.562 224.068 61.562 222.764C61.562 221.452 61.906 220.412 62.594 219.644C63.29 218.868 64.254 218.48 65.486 218.48C66.302 218.48 67.13 218.624 67.97 218.912L67.754 220.256C67.45 220.144 67.054 220.052 66.566 219.98C66.078 219.9 65.698 219.86 65.426 219.86C64.762 219.86 64.242 220.116 63.866 220.628C63.49 221.132 63.302 221.816 63.302 222.68C63.302 223.544 63.502 224.264 63.902 224.84C64.31 225.408 64.83 225.692 65.462 225.692C65.83 225.692 66.166 225.612 66.47 225.452V223.82H65.078V222.44H68.21V226.424C67.37 226.856 66.498 227.072 65.594 227.072ZM71.5518 223.016V227H69.9798V221H71.2278L71.3718 221.588C71.6918 221.332 71.9598 221.152 72.1758 221.048C72.3918 220.936 72.5798 220.88 72.7398 220.88C72.9078 220.88 73.0198 220.884 73.0758 220.892C73.1318 220.892 73.1798 220.896 73.2198 220.904C73.2598 220.912 73.3278 220.928 73.4238 220.952L73.2798 222.38C73.1358 222.332 72.9398 222.308 72.6918 222.308C72.3558 222.308 71.9758 222.544 71.5518 223.016ZM77.8473 227L77.6073 226.4C77.3273 226.656 77.0793 226.836 76.8633 226.94C76.6473 227.036 76.3873 227.084 76.0833 227.084C75.5713 227.084 75.1233 226.908 74.7393 226.556C74.3633 226.196 74.1753 225.72 74.1753 225.128C74.1753 224.536 74.4073 224.072 74.8713 223.736C75.3353 223.392 76.0353 223.22 76.9713 223.22H77.4633C77.4633 222.876 77.3793 222.6 77.2113 222.392C77.0513 222.184 76.8033 222.08 76.4673 222.08C75.8833 222.08 75.2913 222.16 74.6913 222.32L74.4273 221.264C75.2193 221.008 76.0153 220.88 76.8153 220.88C78.2713 220.88 78.9993 221.56 78.9993 222.92V227H77.8473ZM77.4393 224.372H76.9233C76.4753 224.372 76.1713 224.432 76.0113 224.552C75.8513 224.672 75.7713 224.848 75.7713 225.08C75.7713 225.304 75.8313 225.488 75.9513 225.632C76.0713 225.776 76.2273 225.848 76.4193 225.848C76.6913 225.848 77.0313 225.632 77.4393 225.2V224.372ZM82.2625 229.844H80.7025V221H81.8905L82.1785 221.636C82.4745 221.388 82.7425 221.2 82.9825 221.072C83.2305 220.944 83.5065 220.88 83.8105 220.88C84.4745 220.88 84.9785 221.156 85.3225 221.708C85.6745 222.26 85.8505 223.032 85.8505 224.024C85.8505 225.016 85.6265 225.776 85.1785 226.304C84.7305 226.824 84.2025 227.084 83.5945 227.084C83.1545 227.084 82.7105 226.892 82.2625 226.508V229.844ZM82.2625 222.848V225.044C82.5185 225.46 82.8345 225.668 83.2105 225.668C83.5945 225.668 83.8585 225.532 84.0025 225.26C84.1545 224.988 84.2305 224.572 84.2305 224.012C84.2305 223.452 84.1505 223.02 83.9905 222.716C83.8305 222.412 83.6305 222.26 83.3905 222.26C83.0465 222.26 82.6705 222.456 82.2625 222.848ZM92.3293 227H90.7693V223.412C90.7693 223.084 90.7053 222.82 90.5773 222.62C90.4493 222.412 90.2333 222.308 89.9293 222.308C89.6253 222.308 89.2533 222.492 88.8133 222.86V227H87.2533V218.6H88.8133V221.54C89.1573 221.284 89.4533 221.112 89.7013 221.024C89.9573 220.928 90.2533 220.88 90.5893 220.88C91.1253 220.88 91.5493 221.06 91.8613 221.42C92.1733 221.772 92.3293 222.296 92.3293 222.992V227ZM99.9968 225.668L101.113 226.82L100.165 227.768L99.0248 226.556C98.5368 226.908 97.9088 227.084 97.1408 227.084C96.3728 227.084 95.7168 226.88 95.1728 226.472C94.1328 225.712 93.6128 224.468 93.6128 222.74C93.6128 221.484 93.9128 220.46 94.5128 219.668C95.1208 218.876 96.0088 218.48 97.1768 218.48C98.3528 218.48 99.2448 218.876 99.8528 219.668C100.461 220.46 100.765 221.472 100.765 222.704C100.765 223.928 100.509 224.916 99.9968 225.668ZM98.3288 223.904L98.7128 224.372C98.9208 223.964 99.0248 223.392 99.0248 222.656C99.0248 221.912 98.8608 221.26 98.5328 220.7C98.2128 220.132 97.7528 219.848 97.1528 219.848C96.5528 219.848 96.1048 220.128 95.8088 220.688C95.5128 221.248 95.3648 221.94 95.3648 222.764C95.3648 223.588 95.5208 224.284 95.8328 224.852C96.1448 225.412 96.5968 225.692 97.1888 225.692C97.5008 225.692 97.7528 225.62 97.9448 225.476L97.3688 224.852L98.3288 223.904ZM106.949 227H101.969V218.6H103.709V225.62H106.949V227ZM115.345 218.9L115.057 220.304L114.313 220.1C113.785 219.98 113.325 219.92 112.933 219.92C112.389 219.92 112.117 220.18 112.117 220.7C112.117 220.9 112.209 221.084 112.393 221.252C112.585 221.412 112.825 221.548 113.113 221.66C113.401 221.764 113.709 221.896 114.037 222.056C114.365 222.216 114.673 222.388 114.961 222.572C115.249 222.756 115.485 223.008 115.669 223.328C115.861 223.648 115.957 224.016 115.957 224.432C115.957 225.256 115.689 225.904 115.153 226.376C114.625 226.84 113.877 227.072 112.909 227.072C112.413 227.072 111.917 227.008 111.421 226.88C110.933 226.744 110.529 226.588 110.209 226.412L110.725 225.128C111.461 225.464 112.189 225.632 112.909 225.632C113.317 225.632 113.637 225.54 113.869 225.356C114.101 225.164 114.217 224.92 114.217 224.624C114.217 224.328 114.085 224.084 113.821 223.892C113.557 223.692 113.237 223.516 112.861 223.364C112.485 223.204 112.109 223.028 111.733 222.836C111.357 222.636 111.037 222.36 110.773 222.008C110.509 221.648 110.377 221.224 110.377 220.736C110.377 220.008 110.605 219.452 111.061 219.068C111.517 218.676 112.129 218.48 112.897 218.48C113.673 218.48 114.489 218.62 115.345 218.9ZM121.738 226.628C120.978 226.924 120.274 227.072 119.626 227.072C117.746 227.072 116.806 226.056 116.806 224.024C116.806 222.992 117.034 222.212 117.49 221.684C117.946 221.148 118.61 220.88 119.482 220.88C120.202 220.88 120.778 221.104 121.21 221.552C121.642 222 121.858 222.664 121.858 223.544C121.858 223.896 121.842 224.204 121.81 224.468H118.342C118.342 224.94 118.47 225.288 118.726 225.512C118.982 225.736 119.326 225.848 119.758 225.848C120.19 225.848 120.762 225.752 121.474 225.56L121.738 226.628ZM120.358 223.364V223.28C120.358 222.912 120.278 222.616 120.118 222.392C119.958 222.168 119.706 222.056 119.362 222.056C119.018 222.056 118.762 222.18 118.594 222.428C118.426 222.676 118.338 222.988 118.33 223.364H120.358ZM124.884 223.016V227H123.312V221H124.56L124.704 221.588C125.024 221.332 125.292 221.152 125.508 221.048C125.724 220.936 125.912 220.88 126.072 220.88C126.24 220.88 126.352 220.884 126.408 220.892C126.464 220.892 126.512 220.896 126.552 220.904C126.592 220.912 126.66 220.928 126.756 220.952L126.612 222.38C126.468 222.332 126.272 222.308 126.024 222.308C125.688 222.308 125.308 222.544 124.884 223.016ZM132.595 221L130.687 227H128.935L127.039 221H128.659L129.823 225.44L130.999 221H132.595ZM135.089 220.1H133.529V218.6H135.089V220.1ZM135.089 227H133.529V221H135.089V227ZM140.708 225.692L140.9 226.772C140.204 226.972 139.652 227.072 139.244 227.072C138.252 227.072 137.536 226.812 137.096 226.292C136.656 225.772 136.436 225.016 136.436 224.024C136.436 223.024 136.664 222.252 137.12 221.708C137.576 221.156 138.24 220.88 139.112 220.88C139.624 220.88 140.208 220.976 140.864 221.168L140.3 222.26C139.86 222.124 139.496 222.056 139.208 222.056C138.92 222.056 138.692 222.112 138.524 222.224C138.364 222.336 138.248 222.496 138.176 222.704C138.056 223.048 137.996 223.52 137.996 224.12C137.996 224.712 138.12 225.148 138.368 225.428C138.616 225.708 138.976 225.848 139.448 225.848C139.92 225.848 140.34 225.796 140.708 225.692ZM146.512 226.628C145.752 226.924 145.048 227.072 144.4 227.072C142.52 227.072 141.58 226.056 141.58 224.024C141.58 222.992 141.808 222.212 142.264 221.684C142.72 221.148 143.384 220.88 144.256 220.88C144.976 220.88 145.552 221.104 145.984 221.552C146.416 222 146.632 222.664 146.632 223.544C146.632 223.896 146.616 224.204 146.584 224.468H143.116C143.116 224.94 143.244 225.288 143.5 225.512C143.756 225.736 144.1 225.848 144.532 225.848C144.964 225.848 145.536 225.752 146.248 225.56L146.512 226.628ZM145.132 223.364V223.28C145.132 222.912 145.052 222.616 144.892 222.392C144.732 222.168 144.48 222.056 144.136 222.056C143.792 222.056 143.536 222.18 143.368 222.428C143.2 222.676 143.112 222.988 143.104 223.364H145.132ZM147.977 225.404C148.513 225.676 149.061 225.812 149.621 225.812C150.189 225.812 150.473 225.604 150.473 225.188C150.473 224.804 150.153 224.52 149.513 224.336C149.241 224.264 148.969 224.18 148.697 224.084C148.433 223.98 148.205 223.816 148.013 223.592C147.829 223.36 147.737 223.064 147.737 222.704C147.737 222.12 147.917 221.672 148.277 221.36C148.637 221.04 149.137 220.88 149.777 220.88C150.425 220.88 151.037 220.992 151.613 221.216L151.361 222.464C150.833 222.248 150.317 222.14 149.813 222.14C149.461 222.14 149.285 222.26 149.285 222.5C149.285 222.748 149.521 222.936 149.993 223.064C150.489 223.192 150.929 223.376 151.313 223.616C151.513 223.736 151.681 223.916 151.817 224.156C151.953 224.396 152.021 224.684 152.021 225.02C152.021 225.652 151.809 226.152 151.385 226.52C150.961 226.888 150.377 227.072 149.633 227.072C148.889 227.072 148.225 226.9 147.641 226.556L147.977 225.404Z"
        fill="#94A3B8"
      />
      <rect
        x="35.5"
        y="199.5"
        width="167.215"
        height="47"
        rx="3"
        stroke="#94A3B8"
      />
      <path
        d="M55.3438 132.25V133.187C55.3438 134.014 53.2861 134.688 50.75 134.688C48.2139 134.688 46.1562 134.014 46.1562 133.187V132.25C46.1562 131.424 48.2139 130.75 50.75 130.75C53.2861 130.75 55.3438 131.424 55.3438 132.25ZM55.3438 134.359V136.469C55.3438 137.295 53.2861 137.969 50.75 137.969C48.2139 137.969 46.1562 137.295 46.1562 136.469V134.359C47.1432 135.039 48.9496 135.355 50.75 135.355C52.5504 135.355 54.3568 135.039 55.3438 134.359ZM55.3438 137.641V139.75C55.3438 140.576 53.2861 141.25 50.75 141.25C48.2139 141.25 46.1562 140.576 46.1562 139.75V137.641C47.1432 138.32 48.9496 138.637 50.75 138.637C52.5504 138.637 54.3568 138.32 55.3438 137.641Z"
        fill="#94A3B8"
      />
      <path
        d="M68.654 135.5C68.654 136.852 68.262 137.94 67.478 138.764C66.694 139.588 65.646 140 64.334 140H62.102V131.6H64.706C65.898 131.6 66.854 131.964 67.574 132.692C68.294 133.42 68.654 134.356 68.654 135.5ZM66.842 135.404C66.842 134.652 66.638 134.06 66.23 133.628C65.822 133.196 65.33 132.98 64.754 132.98H63.794V138.62H64.442C65.114 138.62 65.682 138.336 66.146 137.768C66.61 137.192 66.842 136.404 66.842 135.404ZM73.1715 140L72.9315 139.4C72.6515 139.656 72.4035 139.836 72.1875 139.94C71.9715 140.036 71.7115 140.084 71.4075 140.084C70.8955 140.084 70.4475 139.908 70.0635 139.556C69.6875 139.196 69.4995 138.72 69.4995 138.128C69.4995 137.536 69.7315 137.072 70.1955 136.736C70.6595 136.392 71.3595 136.22 72.2955 136.22H72.7875C72.7875 135.876 72.7035 135.6 72.5355 135.392C72.3755 135.184 72.1275 135.08 71.7915 135.08C71.2075 135.08 70.6155 135.16 70.0155 135.32L69.7515 134.264C70.5435 134.008 71.3395 133.88 72.1395 133.88C73.5955 133.88 74.3235 134.56 74.3235 135.92V140H73.1715ZM72.7635 137.372H72.2475C71.7995 137.372 71.4955 137.432 71.3355 137.552C71.1755 137.672 71.0955 137.848 71.0955 138.08C71.0955 138.304 71.1555 138.488 71.2755 138.632C71.3955 138.776 71.5515 138.848 71.7435 138.848C72.0155 138.848 72.3555 138.632 72.7635 138.2V137.372ZM75.9667 138.704V135.32H75.3547V134H75.9787V132.284H77.5267V134H78.7867V135.32H77.5147V137.936C77.5147 138.472 77.6787 138.74 78.0067 138.74C78.1907 138.74 78.3867 138.716 78.5947 138.668L78.8467 139.916C78.4787 140.02 78.0867 140.072 77.6707 140.072C77.2627 140.072 76.8747 139.968 76.5067 139.76C76.1467 139.544 75.9667 139.192 75.9667 138.704ZM83.3551 140L83.1151 139.4C82.8351 139.656 82.5871 139.836 82.3711 139.94C82.1551 140.036 81.8951 140.084 81.5911 140.084C81.0791 140.084 80.6311 139.908 80.2471 139.556C79.8711 139.196 79.6831 138.72 79.6831 138.128C79.6831 137.536 79.9151 137.072 80.3791 136.736C80.8431 136.392 81.5431 136.22 82.4791 136.22H82.9711C82.9711 135.876 82.8871 135.6 82.7191 135.392C82.5591 135.184 82.3111 135.08 81.9751 135.08C81.3911 135.08 80.7991 135.16 80.1991 135.32L79.9351 134.264C80.7271 134.008 81.5231 133.88 82.3231 133.88C83.7791 133.88 84.5071 134.56 84.5071 135.92V140H83.3551ZM82.9471 137.372H82.4311C81.9831 137.372 81.6791 137.432 81.5191 137.552C81.3591 137.672 81.2791 137.848 81.2791 138.08C81.2791 138.304 81.3391 138.488 81.4591 138.632C81.5791 138.776 81.7351 138.848 81.9271 138.848C82.1991 138.848 82.5391 138.632 82.9471 138.2V137.372ZM89.3663 133.88C89.9823 133.88 90.4743 134.144 90.8423 134.672C91.2183 135.192 91.4063 135.948 91.4063 136.94C91.4063 137.924 91.1943 138.68 90.7703 139.208C90.3463 139.736 89.8023 140 89.1383 140C88.6263 140 88.1223 139.776 87.6263 139.328L87.3983 140H86.2103V131.6H87.7703V134.552C88.3863 134.104 88.9183 133.88 89.3663 133.88ZM89.8703 136.94C89.8703 135.828 89.5343 135.272 88.8623 135.272C88.5583 135.272 88.1943 135.452 87.7703 135.812V138.128C88.1943 138.488 88.5543 138.668 88.8503 138.668C89.1543 138.668 89.3983 138.524 89.5823 138.236C89.7743 137.948 89.8703 137.516 89.8703 136.94ZM95.8708 140L95.6308 139.4C95.3508 139.656 95.1028 139.836 94.8867 139.94C94.6708 140.036 94.4108 140.084 94.1068 140.084C93.5948 140.084 93.1468 139.908 92.7628 139.556C92.3868 139.196 92.1988 138.72 92.1988 138.128C92.1988 137.536 92.4308 137.072 92.8948 136.736C93.3588 136.392 94.0588 136.22 94.9948 136.22H95.4868C95.4868 135.876 95.4028 135.6 95.2348 135.392C95.0748 135.184 94.8268 135.08 94.4908 135.08C93.9068 135.08 93.3148 135.16 92.7148 135.32L92.4508 134.264C93.2428 134.008 94.0388 133.88 94.8388 133.88C96.2948 133.88 97.0228 134.56 97.0228 135.92V140H95.8708ZM95.4628 137.372H94.9468C94.4988 137.372 94.1948 137.432 94.0348 137.552C93.8748 137.672 93.7948 137.848 93.7948 138.08C93.7948 138.304 93.8548 138.488 93.9748 138.632C94.0948 138.776 94.2508 138.848 94.4428 138.848C94.7148 138.848 95.0548 138.632 95.4628 138.2V137.372ZM98.6179 138.404C99.1539 138.676 99.7019 138.812 100.262 138.812C100.83 138.812 101.114 138.604 101.114 138.188C101.114 137.804 100.794 137.52 100.154 137.336C99.8819 137.264 99.6099 137.18 99.3379 137.084C99.0739 136.98 98.8459 136.816 98.6539 136.592C98.4699 136.36 98.3779 136.064 98.3779 135.704C98.3779 135.12 98.5579 134.672 98.9179 134.36C99.2779 134.04 99.7779 133.88 100.418 133.88C101.066 133.88 101.678 133.992 102.254 134.216L102.002 135.464C101.474 135.248 100.958 135.14 100.454 135.14C100.102 135.14 99.9259 135.26 99.9259 135.5C99.9259 135.748 100.162 135.936 100.634 136.064C101.13 136.192 101.57 136.376 101.954 136.616C102.154 136.736 102.322 136.916 102.458 137.156C102.594 137.396 102.662 137.684 102.662 138.02C102.662 138.652 102.45 139.152 102.026 139.52C101.602 139.888 101.018 140.072 100.274 140.072C99.5299 140.072 98.8659 139.9 98.2819 139.556L98.6179 138.404ZM108.426 139.628C107.666 139.924 106.962 140.072 106.314 140.072C104.434 140.072 103.494 139.056 103.494 137.024C103.494 135.992 103.722 135.212 104.178 134.684C104.634 134.148 105.298 133.88 106.17 133.88C106.89 133.88 107.466 134.104 107.898 134.552C108.33 135 108.546 135.664 108.546 136.544C108.546 136.896 108.53 137.204 108.498 137.468H105.03C105.03 137.94 105.158 138.288 105.414 138.512C105.67 138.736 106.014 138.848 106.446 138.848C106.878 138.848 107.45 138.752 108.162 138.56L108.426 139.628ZM107.046 136.364V136.28C107.046 135.912 106.966 135.616 106.806 135.392C106.646 135.168 106.394 135.056 106.05 135.056C105.706 135.056 105.45 135.18 105.282 135.428C105.114 135.676 105.026 135.988 105.018 136.364H107.046ZM109.891 138.404C110.427 138.676 110.975 138.812 111.535 138.812C112.103 138.812 112.387 138.604 112.387 138.188C112.387 137.804 112.067 137.52 111.427 137.336C111.155 137.264 110.883 137.18 110.611 137.084C110.347 136.98 110.119 136.816 109.927 136.592C109.743 136.36 109.651 136.064 109.651 135.704C109.651 135.12 109.831 134.672 110.191 134.36C110.551 134.04 111.051 133.88 111.691 133.88C112.339 133.88 112.951 133.992 113.527 134.216L113.275 135.464C112.747 135.248 112.231 135.14 111.727 135.14C111.375 135.14 111.199 135.26 111.199 135.5C111.199 135.748 111.435 135.936 111.907 136.064C112.403 136.192 112.843 136.376 113.227 136.616C113.427 136.736 113.595 136.916 113.731 137.156C113.867 137.396 113.935 137.684 113.935 138.02C113.935 138.652 113.723 139.152 113.299 139.52C112.875 139.888 112.291 140.072 111.547 140.072C110.803 140.072 110.139 139.9 109.555 139.556L109.891 138.404Z"
        fill="#94A3B8"
      />
      <rect
        x="35.5"
        y="112.5"
        width="167.215"
        height="47"
        rx="3"
        stroke="#94A3B8"
      />
      <g filter="url(#filter2_dd_571_49556)">
        <rect
          x="469.785"
          y="25"
          width="168.215"
          height="48"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M484.861 53.1917L483.86 52.9013C483.755 52.8718 483.696 52.7619 483.726 52.6569L485.965 44.9427C485.995 44.8377 486.105 44.7786 486.21 44.8081L487.211 45.0985C487.316 45.1281 487.375 45.238 487.345 45.343L485.106 53.0572C485.075 53.1622 484.966 53.2229 484.861 53.1917V53.1917ZM482.991 51.3509L483.705 50.5897C483.78 50.5093 483.775 50.3813 483.692 50.3075L482.205 48.9999L483.692 47.6923C483.775 47.6185 483.782 47.4906 483.705 47.4102L482.991 46.6489C482.917 46.5702 482.792 46.5652 482.712 46.6407L480.348 48.8556C480.264 48.9327 480.264 49.0656 480.348 49.1427L482.712 51.3591C482.792 51.4346 482.917 51.4313 482.991 51.3509V51.3509ZM488.359 51.3608L490.723 49.1443C490.807 49.0672 490.807 48.9343 490.723 48.8572L488.359 46.6391C488.28 46.5652 488.156 46.5685 488.08 46.6473L487.367 47.4085C487.291 47.4889 487.296 47.6169 487.38 47.6907L488.866 48.9999L487.38 50.3075C487.296 50.3813 487.289 50.5093 487.367 50.5897L488.08 51.3509C488.154 51.4313 488.279 51.4346 488.359 51.3608V51.3608Z"
          fill="black"
        />
        <path
          d="M503.067 53H501.339L500.739 50.948H498.207L497.619 53H495.951L498.471 44.6H500.523L503.067 53ZM500.415 49.568L499.491 46.112L498.555 49.568H500.415ZM505.516 55.844H503.956V47H505.144L505.432 47.636C505.728 47.388 505.996 47.2 506.236 47.072C506.484 46.944 506.76 46.88 507.064 46.88C507.728 46.88 508.232 47.156 508.576 47.708C508.928 48.26 509.104 49.032 509.104 50.024C509.104 51.016 508.88 51.776 508.432 52.304C507.984 52.824 507.456 53.084 506.848 53.084C506.408 53.084 505.964 52.892 505.516 52.508V55.844ZM505.516 48.848V51.044C505.772 51.46 506.088 51.668 506.464 51.668C506.848 51.668 507.112 51.532 507.256 51.26C507.408 50.988 507.484 50.572 507.484 50.012C507.484 49.452 507.404 49.02 507.244 48.716C507.084 48.412 506.884 48.26 506.644 48.26C506.3 48.26 505.924 48.456 505.516 48.848ZM512.067 55.844H510.507V47H511.695L511.983 47.636C512.279 47.388 512.547 47.2 512.787 47.072C513.035 46.944 513.311 46.88 513.615 46.88C514.279 46.88 514.783 47.156 515.127 47.708C515.479 48.26 515.655 49.032 515.655 50.024C515.655 51.016 515.431 51.776 514.983 52.304C514.535 52.824 514.007 53.084 513.399 53.084C512.959 53.084 512.515 52.892 512.067 52.508V55.844ZM512.067 48.848V51.044C512.323 51.46 512.639 51.668 513.015 51.668C513.399 51.668 513.663 51.532 513.807 51.26C513.959 50.988 514.035 50.572 514.035 50.012C514.035 49.452 513.955 49.02 513.795 48.716C513.635 48.412 513.435 48.26 513.195 48.26C512.851 48.26 512.475 48.456 512.067 48.848ZM516.95 51.404C517.486 51.676 518.034 51.812 518.594 51.812C519.162 51.812 519.446 51.604 519.446 51.188C519.446 50.804 519.126 50.52 518.486 50.336C518.214 50.264 517.942 50.18 517.67 50.084C517.406 49.98 517.178 49.816 516.986 49.592C516.802 49.36 516.71 49.064 516.71 48.704C516.71 48.12 516.89 47.672 517.25 47.36C517.61 47.04 518.11 46.88 518.75 46.88C519.398 46.88 520.01 46.992 520.586 47.216L520.334 48.464C519.806 48.248 519.29 48.14 518.786 48.14C518.434 48.14 518.258 48.26 518.258 48.5C518.258 48.748 518.494 48.936 518.966 49.064C519.462 49.192 519.902 49.376 520.286 49.616C520.486 49.736 520.654 49.916 520.79 50.156C520.926 50.396 520.994 50.684 520.994 51.02C520.994 51.652 520.782 52.152 520.358 52.52C519.934 52.888 519.35 53.072 518.606 53.072C517.862 53.072 517.198 52.9 516.614 52.556L516.95 51.404Z"
          fill="black"
        />
        <rect
          x="470.285"
          y="25.5"
          width="167.215"
          height="47"
          rx="3"
          stroke="#F59E0B"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter3_dd_571_49556)">
        <rect
          x="469.785"
          y="199"
          width="168.215"
          height="48"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M486.983 221.552C488.209 222.779 488.192 224.745 486.991 225.953C486.988 225.955 486.986 225.958 486.983 225.96L485.605 227.338C484.39 228.554 482.412 228.554 481.197 227.338C479.981 226.123 479.981 224.145 481.197 222.93L481.958 222.169C482.16 221.967 482.507 222.101 482.517 222.387C482.531 222.75 482.596 223.115 482.716 223.468C482.757 223.587 482.728 223.719 482.639 223.809L482.37 224.077C481.795 224.652 481.777 225.588 482.347 226.168C482.921 226.754 483.866 226.757 484.445 226.178L485.823 224.8C486.401 224.222 486.399 223.288 485.823 222.712C485.747 222.636 485.671 222.577 485.611 222.536C485.569 222.507 485.534 222.469 485.509 222.424C485.484 222.379 485.471 222.329 485.469 222.278C485.46 222.061 485.537 221.838 485.708 221.667L486.14 221.235C486.253 221.122 486.431 221.108 486.562 221.199C486.713 221.304 486.854 221.422 486.983 221.552V221.552ZM489.874 218.662C488.658 217.446 486.681 217.446 485.465 218.662L484.087 220.04C484.085 220.042 484.082 220.045 484.08 220.047C482.879 221.255 482.862 223.221 484.087 224.448C484.217 224.578 484.358 224.696 484.508 224.801C484.639 224.892 484.817 224.878 484.93 224.765L485.362 224.333C485.533 224.162 485.61 223.939 485.602 223.722C485.6 223.671 485.586 223.621 485.561 223.576C485.536 223.531 485.501 223.493 485.459 223.464C485.4 223.423 485.323 223.364 485.247 223.288C484.671 222.712 484.669 221.778 485.247 221.2L486.625 219.822C487.204 219.243 488.149 219.246 488.724 219.832C489.293 220.412 489.275 221.348 488.7 221.923L488.432 222.191C488.342 222.281 488.313 222.413 488.354 222.532C488.474 222.885 488.54 223.25 488.553 223.613C488.563 223.899 488.911 224.033 489.113 223.831L489.874 223.07C491.089 221.855 491.089 219.877 489.874 218.662V218.662Z"
          fill="black"
        />
        <path
          d="M499.911 227.06C498.735 227.06 497.847 226.656 497.247 225.848C496.647 225.032 496.347 223.996 496.347 222.74C496.347 221.484 496.647 220.46 497.247 219.668C497.855 218.876 498.743 218.48 499.911 218.48C501.087 218.48 501.979 218.876 502.587 219.668C503.195 220.46 503.499 221.484 503.499 222.74C503.499 224.46 502.975 225.7 501.927 226.46C501.375 226.86 500.703 227.06 499.911 227.06ZM499.935 219.86C499.511 219.86 499.155 220.008 498.867 220.304C498.355 220.816 498.099 221.628 498.099 222.74C498.099 223.58 498.255 224.28 498.567 224.84C498.879 225.392 499.335 225.668 499.935 225.668C500.543 225.668 500.999 225.388 501.303 224.828C501.607 224.26 501.759 223.572 501.759 222.764C501.759 221.948 501.595 221.26 501.267 220.7C500.947 220.14 500.503 219.86 499.935 219.86ZM504.728 225.704V222.32H504.116V221H504.74V219.284H506.288V221H507.548V222.32H506.276V224.936C506.276 225.472 506.44 225.74 506.768 225.74C506.952 225.74 507.148 225.716 507.356 225.668L507.608 226.916C507.24 227.02 506.848 227.072 506.432 227.072C506.024 227.072 505.636 226.968 505.268 226.76C504.908 226.544 504.728 226.192 504.728 225.704ZM514.013 227H512.453V223.412C512.453 223.084 512.389 222.82 512.261 222.62C512.133 222.412 511.917 222.308 511.613 222.308C511.309 222.308 510.937 222.492 510.497 222.86V227H508.937V218.6H510.497V221.54C510.841 221.284 511.137 221.112 511.385 221.024C511.641 220.928 511.937 220.88 512.273 220.88C512.809 220.88 513.233 221.06 513.545 221.42C513.857 221.772 514.013 222.296 514.013 222.992V227ZM520.324 226.628C519.564 226.924 518.86 227.072 518.212 227.072C516.332 227.072 515.392 226.056 515.392 224.024C515.392 222.992 515.62 222.212 516.076 221.684C516.532 221.148 517.196 220.88 518.068 220.88C518.788 220.88 519.364 221.104 519.796 221.552C520.228 222 520.444 222.664 520.444 223.544C520.444 223.896 520.428 224.204 520.396 224.468H516.928C516.928 224.94 517.056 225.288 517.312 225.512C517.568 225.736 517.912 225.848 518.344 225.848C518.776 225.848 519.348 225.752 520.06 225.56L520.324 226.628ZM518.944 223.364V223.28C518.944 222.912 518.864 222.616 518.704 222.392C518.544 222.168 518.292 222.056 517.948 222.056C517.604 222.056 517.348 222.18 517.18 222.428C517.012 222.676 516.924 222.988 516.916 223.364H518.944ZM523.47 223.016V227H521.898V221H523.146L523.29 221.588C523.61 221.332 523.878 221.152 524.094 221.048C524.31 220.936 524.498 220.88 524.658 220.88C524.826 220.88 524.938 220.884 524.994 220.892C525.05 220.892 525.098 220.896 525.138 220.904C525.178 220.912 525.246 220.928 525.342 220.952L525.198 222.38C525.054 222.332 524.858 222.308 524.61 222.308C524.274 222.308 523.894 222.544 523.47 223.016ZM534.169 218.9L533.881 220.304L533.137 220.1C532.609 219.98 532.149 219.92 531.757 219.92C531.213 219.92 530.941 220.18 530.941 220.7C530.941 220.9 531.033 221.084 531.217 221.252C531.409 221.412 531.649 221.548 531.937 221.66C532.225 221.764 532.533 221.896 532.861 222.056C533.189 222.216 533.497 222.388 533.785 222.572C534.073 222.756 534.309 223.008 534.493 223.328C534.685 223.648 534.781 224.016 534.781 224.432C534.781 225.256 534.513 225.904 533.977 226.376C533.449 226.84 532.701 227.072 531.733 227.072C531.237 227.072 530.741 227.008 530.245 226.88C529.757 226.744 529.353 226.588 529.033 226.412L529.549 225.128C530.285 225.464 531.013 225.632 531.733 225.632C532.141 225.632 532.461 225.54 532.693 225.356C532.925 225.164 533.041 224.92 533.041 224.624C533.041 224.328 532.909 224.084 532.645 223.892C532.381 223.692 532.061 223.516 531.685 223.364C531.309 223.204 530.933 223.028 530.557 222.836C530.181 222.636 529.861 222.36 529.597 222.008C529.333 221.648 529.201 221.224 529.201 220.736C529.201 220.008 529.429 219.452 529.885 219.068C530.341 218.676 530.953 218.48 531.721 218.48C532.497 218.48 533.313 218.62 534.169 218.9ZM540.563 226.628C539.803 226.924 539.099 227.072 538.451 227.072C536.571 227.072 535.631 226.056 535.631 224.024C535.631 222.992 535.859 222.212 536.315 221.684C536.771 221.148 537.435 220.88 538.307 220.88C539.027 220.88 539.603 221.104 540.035 221.552C540.467 222 540.683 222.664 540.683 223.544C540.683 223.896 540.667 224.204 540.635 224.468H537.167C537.167 224.94 537.295 225.288 537.551 225.512C537.807 225.736 538.151 225.848 538.583 225.848C539.015 225.848 539.587 225.752 540.299 225.56L540.563 226.628ZM539.183 223.364V223.28C539.183 222.912 539.103 222.616 538.943 222.392C538.783 222.168 538.531 222.056 538.187 222.056C537.843 222.056 537.587 222.18 537.419 222.428C537.251 222.676 537.163 222.988 537.155 223.364H539.183ZM543.708 223.016V227H542.136V221H543.384L543.528 221.588C543.848 221.332 544.116 221.152 544.332 221.048C544.548 220.936 544.736 220.88 544.896 220.88C545.064 220.88 545.176 220.884 545.232 220.892C545.288 220.892 545.336 220.896 545.376 220.904C545.416 220.912 545.484 220.928 545.58 220.952L545.436 222.38C545.292 222.332 545.096 222.308 544.848 222.308C544.512 222.308 544.132 222.544 543.708 223.016ZM551.42 221L549.512 227H547.76L545.864 221H547.484L548.648 225.44L549.824 221H551.42ZM553.914 220.1H552.354V218.6H553.914V220.1ZM553.914 227H552.354V221H553.914V227ZM559.532 225.692L559.724 226.772C559.028 226.972 558.476 227.072 558.068 227.072C557.076 227.072 556.36 226.812 555.92 226.292C555.48 225.772 555.26 225.016 555.26 224.024C555.26 223.024 555.488 222.252 555.944 221.708C556.4 221.156 557.064 220.88 557.936 220.88C558.448 220.88 559.032 220.976 559.688 221.168L559.124 222.26C558.684 222.124 558.32 222.056 558.032 222.056C557.744 222.056 557.516 222.112 557.348 222.224C557.188 222.336 557.072 222.496 557 222.704C556.88 223.048 556.82 223.52 556.82 224.12C556.82 224.712 556.944 225.148 557.192 225.428C557.44 225.708 557.8 225.848 558.272 225.848C558.744 225.848 559.164 225.796 559.532 225.692ZM565.336 226.628C564.576 226.924 563.872 227.072 563.224 227.072C561.344 227.072 560.404 226.056 560.404 224.024C560.404 222.992 560.632 222.212 561.088 221.684C561.544 221.148 562.208 220.88 563.08 220.88C563.8 220.88 564.376 221.104 564.808 221.552C565.24 222 565.456 222.664 565.456 223.544C565.456 223.896 565.44 224.204 565.408 224.468H561.94C561.94 224.94 562.068 225.288 562.324 225.512C562.58 225.736 562.924 225.848 563.356 225.848C563.788 225.848 564.36 225.752 565.072 225.56L565.336 226.628ZM563.956 223.364V223.28C563.956 222.912 563.876 222.616 563.716 222.392C563.556 222.168 563.304 222.056 562.96 222.056C562.616 222.056 562.36 222.18 562.192 222.428C562.024 222.676 561.936 222.988 561.928 223.364H563.956ZM566.802 225.404C567.338 225.676 567.886 225.812 568.446 225.812C569.014 225.812 569.298 225.604 569.298 225.188C569.298 224.804 568.978 224.52 568.338 224.336C568.066 224.264 567.794 224.18 567.521 224.084C567.258 223.98 567.03 223.816 566.838 223.592C566.654 223.36 566.562 223.064 566.562 222.704C566.562 222.12 566.742 221.672 567.102 221.36C567.462 221.04 567.962 220.88 568.602 220.88C569.25 220.88 569.862 220.992 570.438 221.216L570.186 222.464C569.658 222.248 569.142 222.14 568.638 222.14C568.286 222.14 568.11 222.26 568.11 222.5C568.11 222.748 568.346 222.936 568.818 223.064C569.314 223.192 569.754 223.376 570.138 223.616C570.338 223.736 570.506 223.916 570.642 224.156C570.778 224.396 570.846 224.684 570.846 225.02C570.846 225.652 570.634 226.152 570.21 226.52C569.786 226.888 569.202 227.072 568.458 227.072C567.714 227.072 567.05 226.9 566.466 226.556L566.802 225.404Z"
          fill="black"
        />
        <rect
          x="470.285"
          y="199.5"
          width="167.215"
          height="47"
          rx="3"
          stroke="#F59E0B"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter4_dd_571_49556)">
        <rect
          x="469.785"
          y="112"
          width="168.215"
          height="48"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M490.129 134.031H480.941C480.579 134.031 480.285 133.737 480.285 133.375V132.062C480.285 131.7 480.579 131.406 480.941 131.406H490.129C490.491 131.406 490.785 131.7 490.785 132.062V133.375C490.785 133.737 490.491 134.031 490.129 134.031ZM489.145 132.227C488.873 132.227 488.652 132.447 488.652 132.719C488.652 132.991 488.873 133.211 489.145 133.211C489.416 133.211 489.637 132.991 489.637 132.719C489.637 132.447 489.416 132.227 489.145 132.227ZM487.832 132.227C487.56 132.227 487.34 132.447 487.34 132.719C487.34 132.991 487.56 133.211 487.832 133.211C488.104 133.211 488.324 132.991 488.324 132.719C488.324 132.447 488.104 132.227 487.832 132.227ZM490.129 137.312H480.941C480.579 137.312 480.285 137.019 480.285 136.656V135.344C480.285 134.981 480.579 134.688 480.941 134.688H490.129C490.491 134.688 490.785 134.981 490.785 135.344V136.656C490.785 137.019 490.491 137.312 490.129 137.312ZM489.145 135.508C488.873 135.508 488.652 135.728 488.652 136C488.652 136.272 488.873 136.492 489.145 136.492C489.416 136.492 489.637 136.272 489.637 136C489.637 135.728 489.416 135.508 489.145 135.508ZM487.832 135.508C487.56 135.508 487.34 135.728 487.34 136C487.34 136.272 487.56 136.492 487.832 136.492C488.104 136.492 488.324 136.272 488.324 136C488.324 135.728 488.104 135.508 487.832 135.508ZM490.129 140.594H480.941C480.579 140.594 480.285 140.3 480.285 139.938V138.625C480.285 138.263 480.579 137.969 480.941 137.969H490.129C490.491 137.969 490.785 138.263 490.785 138.625V139.938C490.785 140.3 490.491 140.594 490.129 140.594ZM489.145 138.789C488.873 138.789 488.652 139.009 488.652 139.281C488.652 139.553 488.873 139.773 489.145 139.773C489.416 139.773 489.637 139.553 489.637 139.281C489.637 139.009 489.416 138.789 489.145 138.789ZM487.832 138.789C487.56 138.789 487.34 139.009 487.34 139.281C487.34 139.553 487.56 139.773 487.832 139.773C488.104 139.773 488.324 139.553 488.324 139.281C488.324 139.009 488.104 138.789 487.832 138.789Z"
          fill="black"
        />
        <path
          d="M503.439 135.5C503.439 136.852 503.047 137.94 502.263 138.764C501.479 139.588 500.431 140 499.119 140H496.887V131.6H499.491C500.683 131.6 501.639 131.964 502.359 132.692C503.079 133.42 503.439 134.356 503.439 135.5ZM501.627 135.404C501.627 134.652 501.423 134.06 501.015 133.628C500.607 133.196 500.115 132.98 499.539 132.98H498.579V138.62H499.227C499.899 138.62 500.467 138.336 500.931 137.768C501.395 137.192 501.627 136.404 501.627 135.404ZM507.957 140L507.717 139.4C507.437 139.656 507.189 139.836 506.973 139.94C506.757 140.036 506.497 140.084 506.193 140.084C505.681 140.084 505.233 139.908 504.849 139.556C504.473 139.196 504.285 138.72 504.285 138.128C504.285 137.536 504.517 137.072 504.981 136.736C505.445 136.392 506.145 136.22 507.081 136.22H507.573C507.573 135.876 507.489 135.6 507.321 135.392C507.161 135.184 506.913 135.08 506.577 135.08C505.993 135.08 505.401 135.16 504.801 135.32L504.537 134.264C505.329 134.008 506.125 133.88 506.925 133.88C508.381 133.88 509.109 134.56 509.109 135.92V140H507.957ZM507.549 137.372H507.033C506.585 137.372 506.281 137.432 506.121 137.552C505.961 137.672 505.881 137.848 505.881 138.08C505.881 138.304 505.941 138.488 506.061 138.632C506.181 138.776 506.337 138.848 506.529 138.848C506.801 138.848 507.141 138.632 507.549 138.2V137.372ZM510.752 138.704V135.32H510.14V134H510.764V132.284H512.312V134H513.572V135.32H512.3V137.936C512.3 138.472 512.464 138.74 512.792 138.74C512.976 138.74 513.172 138.716 513.38 138.668L513.632 139.916C513.264 140.02 512.872 140.072 512.456 140.072C512.048 140.072 511.66 139.968 511.292 139.76C510.932 139.544 510.752 139.192 510.752 138.704ZM518.14 140L517.9 139.4C517.62 139.656 517.372 139.836 517.156 139.94C516.94 140.036 516.68 140.084 516.376 140.084C515.864 140.084 515.416 139.908 515.032 139.556C514.656 139.196 514.468 138.72 514.468 138.128C514.468 137.536 514.7 137.072 515.164 136.736C515.628 136.392 516.328 136.22 517.264 136.22H517.756C517.756 135.876 517.672 135.6 517.504 135.392C517.344 135.184 517.096 135.08 516.76 135.08C516.176 135.08 515.584 135.16 514.984 135.32L514.72 134.264C515.512 134.008 516.308 133.88 517.108 133.88C518.564 133.88 519.292 134.56 519.292 135.92V140H518.14ZM517.732 137.372H517.216C516.768 137.372 516.464 137.432 516.304 137.552C516.144 137.672 516.064 137.848 516.064 138.08C516.064 138.304 516.124 138.488 516.244 138.632C516.364 138.776 516.52 138.848 516.712 138.848C516.984 138.848 517.324 138.632 517.732 138.2V137.372ZM526.239 136.772H525.615V140H523.875V131.6H526.515C527.499 131.6 528.211 131.812 528.651 132.236C529.091 132.652 529.311 133.3 529.311 134.18C529.311 135.052 529.039 135.704 528.495 136.136C527.959 136.56 527.207 136.772 526.239 136.772ZM526.107 132.968H525.615V135.404H525.807C526.415 135.404 526.859 135.312 527.139 135.128C527.427 134.944 527.571 134.636 527.571 134.204C527.571 133.764 527.455 133.448 527.223 133.256C526.991 133.064 526.619 132.968 526.107 132.968ZM532.048 140H530.488V131.6H532.048V140ZM537.289 140L537.049 139.4C536.769 139.656 536.521 139.836 536.305 139.94C536.089 140.036 535.829 140.084 535.525 140.084C535.013 140.084 534.565 139.908 534.181 139.556C533.805 139.196 533.617 138.72 533.617 138.128C533.617 137.536 533.849 137.072 534.313 136.736C534.777 136.392 535.477 136.22 536.413 136.22H536.905C536.905 135.876 536.821 135.6 536.653 135.392C536.493 135.184 536.245 135.08 535.909 135.08C535.325 135.08 534.733 135.16 534.133 135.32L533.869 134.264C534.661 134.008 535.457 133.88 536.257 133.88C537.713 133.88 538.441 134.56 538.441 135.92V140H537.289ZM536.881 137.372H536.365C535.917 137.372 535.613 137.432 535.453 137.552C535.293 137.672 535.213 137.848 535.213 138.08C535.213 138.304 535.273 138.488 535.393 138.632C535.513 138.776 535.669 138.848 535.861 138.848C536.133 138.848 536.473 138.632 536.881 138.2V137.372ZM540.084 138.704V135.32H539.472V134H540.096V132.284H541.644V134H542.904V135.32H541.632V137.936C541.632 138.472 541.796 138.74 542.124 138.74C542.308 138.74 542.504 138.716 542.712 138.668L542.964 139.916C542.596 140.02 542.204 140.072 541.788 140.072C541.38 140.072 540.992 139.968 540.624 139.76C540.264 139.544 540.084 139.192 540.084 138.704ZM547.28 131.588L547.076 132.704C546.876 132.664 546.688 132.644 546.512 132.644C546.344 132.644 546.212 132.696 546.116 132.8C546.02 132.904 545.972 133.096 545.972 133.376V134H546.956V135.284H545.972V140H544.424V135.284H543.74V134H544.436V133.088C544.436 132.576 544.58 132.18 544.868 131.9C545.164 131.62 545.568 131.48 546.08 131.48C546.592 131.48 546.992 131.516 547.28 131.588ZM553.151 137.012C553.151 137.972 552.907 138.724 552.419 139.268C551.931 139.812 551.239 140.084 550.343 140.084C549.447 140.084 548.767 139.812 548.303 139.268C547.839 138.724 547.607 137.968 547.607 137C547.607 136.032 547.839 135.272 548.303 134.72C548.767 134.16 549.435 133.88 550.307 133.88C551.179 133.88 551.871 134.164 552.383 134.732C552.895 135.292 553.151 136.052 553.151 137.012ZM551.555 136.988C551.555 135.764 551.163 135.152 550.379 135.152C549.579 135.152 549.179 135.76 549.179 136.976C549.179 138.192 549.583 138.8 550.391 138.8C550.823 138.8 551.123 138.648 551.291 138.344C551.467 138.032 551.555 137.58 551.555 136.988ZM556.095 136.016V140H554.523V134H555.771L555.915 134.588C556.235 134.332 556.503 134.152 556.719 134.048C556.935 133.936 557.123 133.88 557.283 133.88C557.451 133.88 557.563 133.884 557.619 133.892C557.675 133.892 557.723 133.896 557.763 133.904C557.803 133.912 557.871 133.928 557.967 133.952L557.823 135.38C557.679 135.332 557.483 135.308 557.235 135.308C556.899 135.308 556.519 135.544 556.095 136.016ZM560.782 140H559.21V134H560.53L560.734 134.54C561.078 134.284 561.374 134.112 561.622 134.024C561.878 133.928 562.174 133.88 562.51 133.88C563.118 133.88 563.562 134.156 563.842 134.708C564.29 134.38 564.65 134.16 564.922 134.048C565.202 133.936 565.506 133.88 565.834 133.88C566.33 133.88 566.722 134.064 567.01 134.432C567.298 134.792 567.442 135.324 567.442 136.028V140H565.87V136.448C565.87 135.712 565.65 135.344 565.21 135.344C564.882 135.344 564.506 135.528 564.082 135.896V140H562.522V136.448C562.522 135.712 562.306 135.344 561.874 135.344C561.554 135.344 561.19 135.516 560.782 135.86V140ZM569.274 138.404C569.81 138.676 570.358 138.812 570.918 138.812C571.486 138.812 571.77 138.604 571.77 138.188C571.77 137.804 571.45 137.52 570.81 137.336C570.538 137.264 570.266 137.18 569.994 137.084C569.73 136.98 569.502 136.816 569.31 136.592C569.126 136.36 569.034 136.064 569.034 135.704C569.034 135.12 569.214 134.672 569.574 134.36C569.934 134.04 570.434 133.88 571.074 133.88C571.722 133.88 572.334 133.992 572.91 134.216L572.658 135.464C572.13 135.248 571.614 135.14 571.11 135.14C570.758 135.14 570.582 135.26 570.582 135.5C570.582 135.748 570.818 135.936 571.29 136.064C571.786 136.192 572.226 136.376 572.61 136.616C572.81 136.736 572.978 136.916 573.114 137.156C573.25 137.396 573.318 137.684 573.318 138.02C573.318 138.652 573.106 139.152 572.682 139.52C572.258 139.888 571.674 140.072 570.93 140.072C570.186 140.072 569.522 139.9 568.938 139.556L569.274 138.404Z"
          fill="black"
        />
        <rect
          x="470.285"
          y="112.5"
          width="167.215"
          height="47"
          rx="3"
          stroke="#F59E0B"
          shapeRendering="crispEdges"
        />
      </g>
      <path
        d="M207.215 49H238.849C252.103 49 262.849 59.7452 262.849 73V112C262.849 125.255 273.594 136 286.849 136H318.482"
        stroke="#CBD5E1"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M397.573 136H407.679C420.934 136 431.679 125.255 431.679 112V73C431.679 59.7452 442.424 49 455.679 49H465.785"
        stroke="#94A3B8"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M397.573 136H465.785"
        stroke="#94A3B8"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M397.573 136H407.679C420.934 136 431.679 146.745 431.679 160V199C431.679 212.255 442.424 223 455.679 223H465.785"
        stroke="#94A3B8"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M207.215 223H238.849C252.103 223 262.849 212.255 262.849 199V160C262.849 146.745 273.594 136 286.849 136H318.482"
        stroke="#CBD5E1"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M207.215 136H318.482"
        stroke="#CBD5E1"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
      />
      <g filter="url(#filter5_dd_571_49556)">
        <ellipse cx="405.622" cy="136" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M409.127 136C409.127 137.932 407.559 139.5 405.622 139.5C403.686 139.5 402.117 137.932 402.117 136C402.117 134.068 403.686 132.5 405.622 132.5C407.559 132.5 409.127 134.068 409.127 136Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter6_dd_571_49556)">
        <ellipse cx="444.751" cy="136" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M448.256 136C448.256 137.932 446.688 139.5 444.751 139.5C442.815 139.5 441.246 137.932 441.246 136C441.246 134.068 442.815 132.5 444.751 132.5C446.688 132.5 448.256 134.068 448.256 136Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter7_dd_571_49556)">
        <ellipse cx="431.679" cy="86" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M435.184 86C435.184 87.9324 433.615 89.5 431.679 89.5C429.743 89.5 428.174 87.9324 428.174 86C428.174 84.0676 429.743 82.5 431.679 82.5C433.615 82.5 435.184 84.0676 435.184 86Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter8_dd_571_49556)">
        <ellipse cx="446.769" cy="51" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M450.274 51C450.274 52.9324 448.705 54.5 446.769 54.5C444.832 54.5 443.264 52.9324 443.264 51C443.264 49.0676 444.832 47.5 446.769 47.5C448.705 47.5 450.274 49.0676 450.274 51Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter9_dd_571_49556)">
        <ellipse cx="444.73" cy="220" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M448.235 220C448.235 221.932 446.666 223.5 444.73 223.5C442.793 223.5 441.225 221.932 441.225 220C441.225 218.068 442.793 216.5 444.73 216.5C446.666 216.5 448.235 218.068 448.235 220Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter10_dd_571_49556)">
        <ellipse cx="431.679" cy="188" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M435.184 188C435.184 189.932 433.615 191.5 431.679 191.5C429.743 191.5 428.174 189.932 428.174 188C428.174 186.068 429.743 184.5 431.679 184.5C433.615 184.5 435.184 186.068 435.184 188Z"
          stroke="#F59E0B"
        />
      </g>
      <rect x="1" y="1" width="671" height="270" rx="2" stroke="#CBD5E1" />
      <defs>
        <filter
          id="filter0_dd_571_49556"
          x="319.482"
          y="107"
          width="60.0693"
          height="60"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter1_dd_571_49556"
          x="364.54"
          y="121"
          width="32.0332"
          height="32"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter2_dd_571_49556"
          x="466.785"
          y="23"
          width="174.215"
          height="54"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter3_dd_571_49556"
          x="466.785"
          y="197"
          width="174.215"
          height="54"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter4_dd_571_49556"
          x="466.785"
          y="110"
          width="174.215"
          height="54"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter5_dd_571_49556"
          x="398.617"
          y="130"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter6_dd_571_49556"
          x="437.746"
          y="130"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter7_dd_571_49556"
          x="424.674"
          y="80"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter8_dd_571_49556"
          x="439.764"
          y="45"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter9_dd_571_49556"
          x="437.725"
          y="214"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <filter
          id="filter10_dd_571_49556"
          x="424.674"
          y="182"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_49556"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_49556"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_49556"
            result="effect2_dropShadow_571_49556"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_49556"
            result="shape"
          />
        </filter>
        <clipPath id="clip0_571_49556">
          <rect
            width="24"
            height="24"
            fill="white"
            transform="translate(337.517 124)"
          />
        </clipPath>
      </defs>
    </svg>
  );
}
