export type InputMaybe<T> = Maybe<T>;
export type Maybe<T> = T | null;
export type Exact<T extends { [key: string]: unknown }> = {
  [K in keyof T]: T[K];
};
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & {
  [SubKey in K]?: Maybe<T[SubKey]>;
};
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & {
  [SubKey in K]: Maybe<T[SubKey]>;
};
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string;
  String: string;
  Boolean: boolean;
  Int: number;
  Float: number;
  timestamptz: any;
  json: any;
  uuid: any;
  jsonb: any;
  project_activity_status_enum: any;
  citext: any;
  bigint: any;
  numeric: any;
  float8: any;
  invoice_item_type: any;
  timestamp: any;
  timetz: any;
  _text: any;
  opentelemetry_connection_type_enum: any;
  date: any;
  _uuid: any;
  connector_timestamptz: any;
  connector_uuid: any;
  connector_deployment_status: any;
  bytea: any;
  _json: any;
  smallint: any;
  reminder_type_enum: any;
  _int4: any;
  user_action: any;
  Map: any;
  _date: any;
  _int8: any;
};

/** Boolean expression to compare columns of type "_json". All fields are combined with logical 'AND'. */
export type _Json_Comparison_Exp = {
  _eq?: Maybe<Scalars['_json']>;
  _gt?: Maybe<Scalars['_json']>;
  _gte?: Maybe<Scalars['_json']>;
  _in?: Maybe<Array<Scalars['_json']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['_json']>;
  _lte?: Maybe<Scalars['_json']>;
  _neq?: Maybe<Scalars['_json']>;
  _nin?: Maybe<Array<Scalars['_json']>>;
};

/** Boolean expression to compare columns of type "_text". All fields are combined with logical 'AND'. */
export type _Text_Comparison_Exp = {
  _eq?: Maybe<Scalars['_text']>;
  _gt?: Maybe<Scalars['_text']>;
  _gte?: Maybe<Scalars['_text']>;
  _in?: Maybe<Array<Scalars['_text']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['_text']>;
  _lte?: Maybe<Scalars['_text']>;
  _neq?: Maybe<Scalars['_text']>;
  _nin?: Maybe<Array<Scalars['_text']>>;
};

/** The agent through which the action is executed */
export enum ActionAgent {
  CloudDashboard = 'CloudDashboard',
  HasuraConsole = 'HasuraConsole',
  Unknown = 'Unknown',
}

export type AddCustomDomainOutput = {
  __typename?: 'AddCustomDomainOutput';
  cert?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['String']>;
  dns_validation?: Maybe<Scalars['String']>;
  fqdn: Scalars['String'];
  id: Scalars['uuid'];
  tenant_id: Scalars['uuid'];
  updated_at?: Maybe<Scalars['String']>;
};

export type AddProjectInput = {
  endpoint: Scalars['String'];
  name: Scalars['String'];
};

export type AddProjectResponse = {
  __typename?: 'AddProjectResponse';
  hasura_pro_key: Scalars['String'];
  id: Scalars['uuid'];
};

/** Alert configuration for Hasura Cloud projects */
export type Alert_Config = {
  __typename?: 'alert_config';
  /** An array relationship */
  alert_config_services: Array<Alert_Config_Service>;
  /** An aggregate relationship */
  alert_config_services_aggregate: Alert_Config_Service_Aggregate;
  /** An array relationship */
  alert_types: Array<Alert_Config_Alert_Type>;
  /** An aggregate relationship */
  alert_types_aggregate: Alert_Config_Alert_Type_Aggregate;
  created_at: Scalars['timestamptz'];
  enabled: Scalars['Boolean'];
  /** An object relationship */
  project: Projects;
  project_id: Scalars['uuid'];
  /** An array relationship */
  slack_alert_configs: Array<Slack_Config>;
  /** An aggregate relationship */
  slack_alert_configs_aggregate: Slack_Config_Aggregate;
  /** An object relationship */
  tenant?: Maybe<Tenant>;
  updated_at: Scalars['timestamptz'];
};

/** Alert configuration for Hasura Cloud projects */
export type Alert_ConfigAlert_Config_ServicesArgs = {
  distinct_on?: Maybe<Array<Alert_Config_Service_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Alert_Config_Service_Order_By>>;
  where?: Maybe<Alert_Config_Service_Bool_Exp>;
};

/** Alert configuration for Hasura Cloud projects */
export type Alert_ConfigAlert_Config_Services_AggregateArgs = {
  distinct_on?: Maybe<Array<Alert_Config_Service_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Alert_Config_Service_Order_By>>;
  where?: Maybe<Alert_Config_Service_Bool_Exp>;
};

/** Alert configuration for Hasura Cloud projects */
export type Alert_ConfigAlert_TypesArgs = {
  distinct_on?: Maybe<Array<Alert_Config_Alert_Type_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Alert_Config_Alert_Type_Order_By>>;
  where?: Maybe<Alert_Config_Alert_Type_Bool_Exp>;
};

/** Alert configuration for Hasura Cloud projects */
export type Alert_ConfigAlert_Types_AggregateArgs = {
  distinct_on?: Maybe<Array<Alert_Config_Alert_Type_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Alert_Config_Alert_Type_Order_By>>;
  where?: Maybe<Alert_Config_Alert_Type_Bool_Exp>;
};

/** Alert configuration for Hasura Cloud projects */
export type Alert_ConfigSlack_Alert_ConfigsArgs = {
  distinct_on?: Maybe<Array<Slack_Config_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Slack_Config_Order_By>>;
  where?: Maybe<Slack_Config_Bool_Exp>;
};

/** Alert configuration for Hasura Cloud projects */
export type Alert_ConfigSlack_Alert_Configs_AggregateArgs = {
  distinct_on?: Maybe<Array<Slack_Config_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Slack_Config_Order_By>>;
  where?: Maybe<Slack_Config_Bool_Exp>;
};

/** aggregated selection of "alert_config" */
export type Alert_Config_Aggregate = {
  __typename?: 'alert_config_aggregate';
  aggregate?: Maybe<Alert_Config_Aggregate_Fields>;
  nodes: Array<Alert_Config>;
};

/** aggregate fields of "alert_config" */
export type Alert_Config_Aggregate_Fields = {
  __typename?: 'alert_config_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Alert_Config_Max_Fields>;
  min?: Maybe<Alert_Config_Min_Fields>;
};

/** aggregate fields of "alert_config" */
export type Alert_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Alert_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Enabled alert types for Hasura Cloud projects */
export type Alert_Config_Alert_Type = {
  __typename?: 'alert_config_alert_type';
  /** An object relationship */
  alert_config: Alert_Config;
  /** An object relationship */
  alert_type: Alert_Type;
  created_at: Scalars['timestamptz'];
  /** An object relationship */
  project?: Maybe<Projects>;
  project_id: Scalars['uuid'];
  rules?: Maybe<Scalars['json']>;
  /** An object relationship */
  slack_config?: Maybe<Slack_Config>;
  type: Scalars['String'];
};

/** Enabled alert types for Hasura Cloud projects */
export type Alert_Config_Alert_TypeRulesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Aggregate = {
  __typename?: 'alert_config_alert_type_aggregate';
  aggregate?: Maybe<Alert_Config_Alert_Type_Aggregate_Fields>;
  nodes: Array<Alert_Config_Alert_Type>;
};

export type Alert_Config_Alert_Type_Aggregate_Bool_Exp = {
  count?: Maybe<Alert_Config_Alert_Type_Aggregate_Bool_Exp_Count>;
};

export type Alert_Config_Alert_Type_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Alert_Config_Alert_Type_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Alert_Config_Alert_Type_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Aggregate_Fields = {
  __typename?: 'alert_config_alert_type_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Alert_Config_Alert_Type_Max_Fields>;
  min?: Maybe<Alert_Config_Alert_Type_Min_Fields>;
};

/** aggregate fields of "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Alert_Config_Alert_Type_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Alert_Config_Alert_Type_Max_Order_By>;
  min?: Maybe<Alert_Config_Alert_Type_Min_Order_By>;
};

/** input type for inserting array relation for remote table "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Arr_Rel_Insert_Input = {
  data: Array<Alert_Config_Alert_Type_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Alert_Config_Alert_Type_On_Conflict>;
};

/** Boolean expression to filter rows from the table "alert_config_alert_type". All fields are combined with a logical 'AND'. */
export type Alert_Config_Alert_Type_Bool_Exp = {
  _and?: Maybe<Array<Alert_Config_Alert_Type_Bool_Exp>>;
  _not?: Maybe<Alert_Config_Alert_Type_Bool_Exp>;
  _or?: Maybe<Array<Alert_Config_Alert_Type_Bool_Exp>>;
  alert_config?: Maybe<Alert_Config_Bool_Exp>;
  alert_type?: Maybe<Alert_Type_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  rules?: Maybe<Json_Comparison_Exp>;
  slack_config?: Maybe<Slack_Config_Bool_Exp>;
  type?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "alert_config_alert_type" */
export enum Alert_Config_Alert_Type_Constraint {
  /** unique or primary key constraint on columns "type", "project_id" */
  AlertConfigAlertTypePkey = 'alert_config_alert_type_pkey',
}

/** input type for inserting data into table "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Insert_Input = {
  alert_config?: Maybe<Alert_Config_Obj_Rel_Insert_Input>;
  alert_type?: Maybe<Alert_Type_Obj_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  rules?: Maybe<Scalars['json']>;
  slack_config?: Maybe<Slack_Config_Obj_Rel_Insert_Input>;
  type?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Alert_Config_Alert_Type_Max_Fields = {
  __typename?: 'alert_config_alert_type_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  type?: Maybe<Scalars['String']>;
};

/** order by max() on columns of table "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Max_Order_By = {
  created_at?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  type?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Alert_Config_Alert_Type_Min_Fields = {
  __typename?: 'alert_config_alert_type_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  type?: Maybe<Scalars['String']>;
};

/** order by min() on columns of table "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Min_Order_By = {
  created_at?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  type?: Maybe<Order_By>;
};

/** response of any mutation on the table "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Mutation_Response = {
  __typename?: 'alert_config_alert_type_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Alert_Config_Alert_Type>;
};

/** on_conflict condition type for table "alert_config_alert_type" */
export type Alert_Config_Alert_Type_On_Conflict = {
  constraint: Alert_Config_Alert_Type_Constraint;
  update_columns?: Array<Alert_Config_Alert_Type_Update_Column>;
  where?: Maybe<Alert_Config_Alert_Type_Bool_Exp>;
};

/** Ordering options when selecting data from "alert_config_alert_type". */
export type Alert_Config_Alert_Type_Order_By = {
  alert_config?: Maybe<Alert_Config_Order_By>;
  alert_type?: Maybe<Alert_Type_Order_By>;
  created_at?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  rules?: Maybe<Order_By>;
  slack_config?: Maybe<Slack_Config_Order_By>;
  type?: Maybe<Order_By>;
};

/** primary key columns input for table: alert_config_alert_type */
export type Alert_Config_Alert_Type_Pk_Columns_Input = {
  project_id: Scalars['uuid'];
  type: Scalars['String'];
};

/** select columns of table "alert_config_alert_type" */
export enum Alert_Config_Alert_Type_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  Rules = 'rules',
  /** column name */
  Type = 'type',
}

/** input type for updating data in table "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  rules?: Maybe<Scalars['json']>;
  type?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "alert_config_alert_type" */
export type Alert_Config_Alert_Type_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Alert_Config_Alert_Type_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Alert_Config_Alert_Type_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  rules?: Maybe<Scalars['json']>;
  type?: Maybe<Scalars['String']>;
};

/** update columns of table "alert_config_alert_type" */
export enum Alert_Config_Alert_Type_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  Rules = 'rules',
  /** column name */
  Type = 'type',
}

export type Alert_Config_Alert_Type_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Alert_Config_Alert_Type_Set_Input>;
  /** filter the rows which have to be updated */
  where: Alert_Config_Alert_Type_Bool_Exp;
};

/** Boolean expression to filter rows from the table "alert_config". All fields are combined with a logical 'AND'. */
export type Alert_Config_Bool_Exp = {
  _and?: Maybe<Array<Alert_Config_Bool_Exp>>;
  _not?: Maybe<Alert_Config_Bool_Exp>;
  _or?: Maybe<Array<Alert_Config_Bool_Exp>>;
  alert_config_services?: Maybe<Alert_Config_Service_Bool_Exp>;
  alert_config_services_aggregate?: Maybe<Alert_Config_Service_Aggregate_Bool_Exp>;
  alert_types?: Maybe<Alert_Config_Alert_Type_Bool_Exp>;
  alert_types_aggregate?: Maybe<Alert_Config_Alert_Type_Aggregate_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  enabled?: Maybe<Boolean_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  slack_alert_configs?: Maybe<Slack_Config_Bool_Exp>;
  slack_alert_configs_aggregate?: Maybe<Slack_Config_Aggregate_Bool_Exp>;
  tenant?: Maybe<Tenant_Bool_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "alert_config" */
export enum Alert_Config_Constraint {
  /** unique or primary key constraint on columns "project_id" */
  AlertConfigPkey = 'alert_config_pkey',
}

/** input type for inserting data into table "alert_config" */
export type Alert_Config_Insert_Input = {
  alert_config_services?: Maybe<Alert_Config_Service_Arr_Rel_Insert_Input>;
  alert_types?: Maybe<Alert_Config_Alert_Type_Arr_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  enabled?: Maybe<Scalars['Boolean']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  slack_alert_configs?: Maybe<Slack_Config_Arr_Rel_Insert_Input>;
  tenant?: Maybe<Tenant_Obj_Rel_Insert_Input>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Alert_Config_Max_Fields = {
  __typename?: 'alert_config_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Alert_Config_Min_Fields = {
  __typename?: 'alert_config_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "alert_config" */
export type Alert_Config_Mutation_Response = {
  __typename?: 'alert_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Alert_Config>;
};

/** input type for inserting object relation for remote table "alert_config" */
export type Alert_Config_Obj_Rel_Insert_Input = {
  data: Alert_Config_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Alert_Config_On_Conflict>;
};

/** on_conflict condition type for table "alert_config" */
export type Alert_Config_On_Conflict = {
  constraint: Alert_Config_Constraint;
  update_columns?: Array<Alert_Config_Update_Column>;
  where?: Maybe<Alert_Config_Bool_Exp>;
};

/** Ordering options when selecting data from "alert_config". */
export type Alert_Config_Order_By = {
  alert_config_services_aggregate?: Maybe<Alert_Config_Service_Aggregate_Order_By>;
  alert_types_aggregate?: Maybe<Alert_Config_Alert_Type_Aggregate_Order_By>;
  created_at?: Maybe<Order_By>;
  enabled?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  slack_alert_configs_aggregate?: Maybe<Slack_Config_Aggregate_Order_By>;
  tenant?: Maybe<Tenant_Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: alert_config */
export type Alert_Config_Pk_Columns_Input = {
  project_id: Scalars['uuid'];
};

/** select columns of table "alert_config" */
export enum Alert_Config_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Enabled = 'enabled',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** Alert notification service configs for Hasura Cloud projects */
export type Alert_Config_Service = {
  __typename?: 'alert_config_service';
  /** An object relationship */
  alert_config: Alert_Config;
  created_at: Scalars['timestamptz'];
  enabled: Scalars['Boolean'];
  metadata?: Maybe<Scalars['json']>;
  /** An object relationship */
  project?: Maybe<Projects>;
  project_id: Scalars['uuid'];
  rules?: Maybe<Scalars['jsonb']>;
  type: Alert_Service_Type_Enum;
  updated_at: Scalars['timestamptz'];
};

/** Alert notification service configs for Hasura Cloud projects */
export type Alert_Config_ServiceMetadataArgs = {
  path?: Maybe<Scalars['String']>;
};

/** Alert notification service configs for Hasura Cloud projects */
export type Alert_Config_ServiceRulesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "alert_config_service" */
export type Alert_Config_Service_Aggregate = {
  __typename?: 'alert_config_service_aggregate';
  aggregate?: Maybe<Alert_Config_Service_Aggregate_Fields>;
  nodes: Array<Alert_Config_Service>;
};

export type Alert_Config_Service_Aggregate_Bool_Exp = {
  bool_and?: Maybe<Alert_Config_Service_Aggregate_Bool_Exp_Bool_And>;
  bool_or?: Maybe<Alert_Config_Service_Aggregate_Bool_Exp_Bool_Or>;
  count?: Maybe<Alert_Config_Service_Aggregate_Bool_Exp_Count>;
};

export type Alert_Config_Service_Aggregate_Bool_Exp_Bool_And = {
  arguments: Alert_Config_Service_Select_Column_Alert_Config_Service_Aggregate_Bool_Exp_Bool_And_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Alert_Config_Service_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Alert_Config_Service_Aggregate_Bool_Exp_Bool_Or = {
  arguments: Alert_Config_Service_Select_Column_Alert_Config_Service_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Alert_Config_Service_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Alert_Config_Service_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Alert_Config_Service_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Alert_Config_Service_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "alert_config_service" */
export type Alert_Config_Service_Aggregate_Fields = {
  __typename?: 'alert_config_service_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Alert_Config_Service_Max_Fields>;
  min?: Maybe<Alert_Config_Service_Min_Fields>;
};

/** aggregate fields of "alert_config_service" */
export type Alert_Config_Service_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Alert_Config_Service_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "alert_config_service" */
export type Alert_Config_Service_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Alert_Config_Service_Max_Order_By>;
  min?: Maybe<Alert_Config_Service_Min_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Alert_Config_Service_Append_Input = {
  rules?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "alert_config_service" */
export type Alert_Config_Service_Arr_Rel_Insert_Input = {
  data: Array<Alert_Config_Service_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Alert_Config_Service_On_Conflict>;
};

/** Boolean expression to filter rows from the table "alert_config_service". All fields are combined with a logical 'AND'. */
export type Alert_Config_Service_Bool_Exp = {
  _and?: Maybe<Array<Alert_Config_Service_Bool_Exp>>;
  _not?: Maybe<Alert_Config_Service_Bool_Exp>;
  _or?: Maybe<Array<Alert_Config_Service_Bool_Exp>>;
  alert_config?: Maybe<Alert_Config_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  enabled?: Maybe<Boolean_Comparison_Exp>;
  metadata?: Maybe<Json_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  rules?: Maybe<Jsonb_Comparison_Exp>;
  type?: Maybe<Alert_Service_Type_Enum_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "alert_config_service" */
export enum Alert_Config_Service_Constraint {
  /** unique or primary key constraint on columns "type", "project_id" */
  AlertConfigServicePkey = 'alert_config_service_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Alert_Config_Service_Delete_At_Path_Input = {
  rules?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Alert_Config_Service_Delete_Elem_Input = {
  rules?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Alert_Config_Service_Delete_Key_Input = {
  rules?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "alert_config_service" */
export type Alert_Config_Service_Insert_Input = {
  alert_config?: Maybe<Alert_Config_Obj_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  enabled?: Maybe<Scalars['Boolean']>;
  metadata?: Maybe<Scalars['json']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  rules?: Maybe<Scalars['jsonb']>;
  type?: Maybe<Alert_Service_Type_Enum>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Alert_Config_Service_Max_Fields = {
  __typename?: 'alert_config_service_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by max() on columns of table "alert_config_service" */
export type Alert_Config_Service_Max_Order_By = {
  created_at?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Alert_Config_Service_Min_Fields = {
  __typename?: 'alert_config_service_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by min() on columns of table "alert_config_service" */
export type Alert_Config_Service_Min_Order_By = {
  created_at?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** response of any mutation on the table "alert_config_service" */
export type Alert_Config_Service_Mutation_Response = {
  __typename?: 'alert_config_service_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Alert_Config_Service>;
};

/** on_conflict condition type for table "alert_config_service" */
export type Alert_Config_Service_On_Conflict = {
  constraint: Alert_Config_Service_Constraint;
  update_columns?: Array<Alert_Config_Service_Update_Column>;
  where?: Maybe<Alert_Config_Service_Bool_Exp>;
};

/** Ordering options when selecting data from "alert_config_service". */
export type Alert_Config_Service_Order_By = {
  alert_config?: Maybe<Alert_Config_Order_By>;
  created_at?: Maybe<Order_By>;
  enabled?: Maybe<Order_By>;
  metadata?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  rules?: Maybe<Order_By>;
  type?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: alert_config_service */
export type Alert_Config_Service_Pk_Columns_Input = {
  project_id: Scalars['uuid'];
  type: Alert_Service_Type_Enum;
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Alert_Config_Service_Prepend_Input = {
  rules?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "alert_config_service" */
export enum Alert_Config_Service_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Enabled = 'enabled',
  /** column name */
  Metadata = 'metadata',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  Rules = 'rules',
  /** column name */
  Type = 'type',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** select "alert_config_service_aggregate_bool_exp_bool_and_arguments_columns" columns of table "alert_config_service" */
export enum Alert_Config_Service_Select_Column_Alert_Config_Service_Aggregate_Bool_Exp_Bool_And_Arguments_Columns {
  /** column name */
  Enabled = 'enabled',
}

/** select "alert_config_service_aggregate_bool_exp_bool_or_arguments_columns" columns of table "alert_config_service" */
export enum Alert_Config_Service_Select_Column_Alert_Config_Service_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns {
  /** column name */
  Enabled = 'enabled',
}

/** input type for updating data in table "alert_config_service" */
export type Alert_Config_Service_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  enabled?: Maybe<Scalars['Boolean']>;
  metadata?: Maybe<Scalars['json']>;
  project_id?: Maybe<Scalars['uuid']>;
  rules?: Maybe<Scalars['jsonb']>;
  type?: Maybe<Alert_Service_Type_Enum>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "alert_config_service" */
export type Alert_Config_Service_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Alert_Config_Service_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Alert_Config_Service_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  enabled?: Maybe<Scalars['Boolean']>;
  metadata?: Maybe<Scalars['json']>;
  project_id?: Maybe<Scalars['uuid']>;
  rules?: Maybe<Scalars['jsonb']>;
  type?: Maybe<Alert_Service_Type_Enum>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "alert_config_service" */
export enum Alert_Config_Service_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Enabled = 'enabled',
  /** column name */
  Metadata = 'metadata',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  Rules = 'rules',
  /** column name */
  Type = 'type',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Alert_Config_Service_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Alert_Config_Service_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Alert_Config_Service_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Alert_Config_Service_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Alert_Config_Service_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Alert_Config_Service_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Alert_Config_Service_Set_Input>;
  /** filter the rows which have to be updated */
  where: Alert_Config_Service_Bool_Exp;
};

/** input type for updating data in table "alert_config" */
export type Alert_Config_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  enabled?: Maybe<Scalars['Boolean']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "alert_config" */
export type Alert_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Alert_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Alert_Config_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  enabled?: Maybe<Scalars['Boolean']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "alert_config" */
export enum Alert_Config_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Enabled = 'enabled',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Alert_Config_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Alert_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Alert_Config_Bool_Exp;
};

/** Alert notification service type enum */
export type Alert_Service_Type = {
  __typename?: 'alert_service_type';
  description: Scalars['String'];
  name: Scalars['String'];
};

/** aggregated selection of "alert_service_type" */
export type Alert_Service_Type_Aggregate = {
  __typename?: 'alert_service_type_aggregate';
  aggregate?: Maybe<Alert_Service_Type_Aggregate_Fields>;
  nodes: Array<Alert_Service_Type>;
};

/** aggregate fields of "alert_service_type" */
export type Alert_Service_Type_Aggregate_Fields = {
  __typename?: 'alert_service_type_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Alert_Service_Type_Max_Fields>;
  min?: Maybe<Alert_Service_Type_Min_Fields>;
};

/** aggregate fields of "alert_service_type" */
export type Alert_Service_Type_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Alert_Service_Type_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "alert_service_type". All fields are combined with a logical 'AND'. */
export type Alert_Service_Type_Bool_Exp = {
  _and?: Maybe<Array<Alert_Service_Type_Bool_Exp>>;
  _not?: Maybe<Alert_Service_Type_Bool_Exp>;
  _or?: Maybe<Array<Alert_Service_Type_Bool_Exp>>;
  description?: Maybe<String_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "alert_service_type" */
export enum Alert_Service_Type_Constraint {
  /** unique or primary key constraint on columns "name" */
  AlertServiceTypePkey = 'alert_service_type_pkey',
}

export enum Alert_Service_Type_Enum {
  /** Mail */
  Mail = 'mail',
  /** Slack Notifier */
  Slack = 'slack',
}

/** Boolean expression to compare columns of type "alert_service_type_enum". All fields are combined with logical 'AND'. */
export type Alert_Service_Type_Enum_Comparison_Exp = {
  _eq?: Maybe<Alert_Service_Type_Enum>;
  _in?: Maybe<Array<Alert_Service_Type_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Alert_Service_Type_Enum>;
  _nin?: Maybe<Array<Alert_Service_Type_Enum>>;
};

/** input type for inserting data into table "alert_service_type" */
export type Alert_Service_Type_Insert_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Alert_Service_Type_Max_Fields = {
  __typename?: 'alert_service_type_max_fields';
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Alert_Service_Type_Min_Fields = {
  __typename?: 'alert_service_type_min_fields';
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "alert_service_type" */
export type Alert_Service_Type_Mutation_Response = {
  __typename?: 'alert_service_type_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Alert_Service_Type>;
};

/** on_conflict condition type for table "alert_service_type" */
export type Alert_Service_Type_On_Conflict = {
  constraint: Alert_Service_Type_Constraint;
  update_columns?: Array<Alert_Service_Type_Update_Column>;
  where?: Maybe<Alert_Service_Type_Bool_Exp>;
};

/** Ordering options when selecting data from "alert_service_type". */
export type Alert_Service_Type_Order_By = {
  description?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
};

/** primary key columns input for table: alert_service_type */
export type Alert_Service_Type_Pk_Columns_Input = {
  name: Scalars['String'];
};

/** select columns of table "alert_service_type" */
export enum Alert_Service_Type_Select_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Name = 'name',
}

/** input type for updating data in table "alert_service_type" */
export type Alert_Service_Type_Set_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "alert_service_type" */
export type Alert_Service_Type_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Alert_Service_Type_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Alert_Service_Type_Stream_Cursor_Value_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** update columns of table "alert_service_type" */
export enum Alert_Service_Type_Update_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Name = 'name',
}

export type Alert_Service_Type_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Alert_Service_Type_Set_Input>;
  /** filter the rows which have to be updated */
  where: Alert_Service_Type_Bool_Exp;
};

/** Alert type enum for alert configuration */
export type Alert_Type = {
  __typename?: 'alert_type';
  always_enabled: Scalars['Boolean'];
  description: Scalars['String'];
  hidden: Scalars['Boolean'];
  id: Scalars['String'];
  name: Scalars['String'];
  template?: Maybe<Scalars['String']>;
};

/** aggregated selection of "alert_type" */
export type Alert_Type_Aggregate = {
  __typename?: 'alert_type_aggregate';
  aggregate?: Maybe<Alert_Type_Aggregate_Fields>;
  nodes: Array<Alert_Type>;
};

/** aggregate fields of "alert_type" */
export type Alert_Type_Aggregate_Fields = {
  __typename?: 'alert_type_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Alert_Type_Max_Fields>;
  min?: Maybe<Alert_Type_Min_Fields>;
};

/** aggregate fields of "alert_type" */
export type Alert_Type_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Alert_Type_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "alert_type". All fields are combined with a logical 'AND'. */
export type Alert_Type_Bool_Exp = {
  _and?: Maybe<Array<Alert_Type_Bool_Exp>>;
  _not?: Maybe<Alert_Type_Bool_Exp>;
  _or?: Maybe<Array<Alert_Type_Bool_Exp>>;
  always_enabled?: Maybe<Boolean_Comparison_Exp>;
  description?: Maybe<String_Comparison_Exp>;
  hidden?: Maybe<Boolean_Comparison_Exp>;
  id?: Maybe<String_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  template?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "alert_type" */
export enum Alert_Type_Constraint {
  /** unique or primary key constraint on columns "id" */
  AlertTypePkey = 'alert_type_pkey',
}

/** input type for inserting data into table "alert_type" */
export type Alert_Type_Insert_Input = {
  always_enabled?: Maybe<Scalars['Boolean']>;
  description?: Maybe<Scalars['String']>;
  hidden?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  template?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Alert_Type_Max_Fields = {
  __typename?: 'alert_type_max_fields';
  description?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  template?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Alert_Type_Min_Fields = {
  __typename?: 'alert_type_min_fields';
  description?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  template?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "alert_type" */
export type Alert_Type_Mutation_Response = {
  __typename?: 'alert_type_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Alert_Type>;
};

/** input type for inserting object relation for remote table "alert_type" */
export type Alert_Type_Obj_Rel_Insert_Input = {
  data: Alert_Type_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Alert_Type_On_Conflict>;
};

/** on_conflict condition type for table "alert_type" */
export type Alert_Type_On_Conflict = {
  constraint: Alert_Type_Constraint;
  update_columns?: Array<Alert_Type_Update_Column>;
  where?: Maybe<Alert_Type_Bool_Exp>;
};

/** Ordering options when selecting data from "alert_type". */
export type Alert_Type_Order_By = {
  always_enabled?: Maybe<Order_By>;
  description?: Maybe<Order_By>;
  hidden?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  template?: Maybe<Order_By>;
};

/** primary key columns input for table: alert_type */
export type Alert_Type_Pk_Columns_Input = {
  id: Scalars['String'];
};

/** select columns of table "alert_type" */
export enum Alert_Type_Select_Column {
  /** column name */
  AlwaysEnabled = 'always_enabled',
  /** column name */
  Description = 'description',
  /** column name */
  Hidden = 'hidden',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
  /** column name */
  Template = 'template',
}

/** input type for updating data in table "alert_type" */
export type Alert_Type_Set_Input = {
  always_enabled?: Maybe<Scalars['Boolean']>;
  description?: Maybe<Scalars['String']>;
  hidden?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  template?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "alert_type" */
export type Alert_Type_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Alert_Type_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Alert_Type_Stream_Cursor_Value_Input = {
  always_enabled?: Maybe<Scalars['Boolean']>;
  description?: Maybe<Scalars['String']>;
  hidden?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  template?: Maybe<Scalars['String']>;
};

/** update columns of table "alert_type" */
export enum Alert_Type_Update_Column {
  /** column name */
  AlwaysEnabled = 'always_enabled',
  /** column name */
  Description = 'description',
  /** column name */
  Hidden = 'hidden',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
  /** column name */
  Template = 'template',
}

export type Alert_Type_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Alert_Type_Set_Input>;
  /** filter the rows which have to be updated */
  where: Alert_Type_Bool_Exp;
};

export type AllowedProjectResponse = {
  __typename?: 'AllowedProjectResponse';
  id: Scalars['uuid'];
  name: Scalars['String'];
};

/** Azure Monitor Config for Metrics Exporter */
export type Azuremonitor_Config = {
  __typename?: 'azuremonitor_config';
  activedirectory_client_id: Scalars['String'];
  activedirectory_client_secret: Scalars['String'];
  activedirectory_tenant_id: Scalars['String'];
  attributes: Scalars['jsonb'];
  azure_region: Scalars['String'];
  azuremonitor_workspace_id: Scalars['String'];
  created_at: Scalars['timestamptz'];
  instrumentation_key?: Maybe<Scalars['String']>;
  log_type: Scalars['String'];
  logs_last_logged: Scalars['timestamptz'];
  logs_response_code?: Maybe<Scalars['Int']>;
  metric_namespace: Scalars['String'];
  metrics_last_logged: Scalars['timestamptz'];
  metrics_response_code?: Maybe<Scalars['Int']>;
  /** An object relationship */
  project: Projects;
  project_id: Scalars['uuid'];
  resource_id: Scalars['String'];
  shared_key: Scalars['String'];
  traces_last_logged: Scalars['timestamptz'];
  traces_response_code?: Maybe<Scalars['Int']>;
  traces_response_message?: Maybe<Scalars['String']>;
};

/** Azure Monitor Config for Metrics Exporter */
export type Azuremonitor_ConfigAttributesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "azuremonitor_config" */
export type Azuremonitor_Config_Aggregate = {
  __typename?: 'azuremonitor_config_aggregate';
  aggregate?: Maybe<Azuremonitor_Config_Aggregate_Fields>;
  nodes: Array<Azuremonitor_Config>;
};

/** aggregate fields of "azuremonitor_config" */
export type Azuremonitor_Config_Aggregate_Fields = {
  __typename?: 'azuremonitor_config_aggregate_fields';
  avg?: Maybe<Azuremonitor_Config_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Azuremonitor_Config_Max_Fields>;
  min?: Maybe<Azuremonitor_Config_Min_Fields>;
  stddev?: Maybe<Azuremonitor_Config_Stddev_Fields>;
  stddev_pop?: Maybe<Azuremonitor_Config_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Azuremonitor_Config_Stddev_Samp_Fields>;
  sum?: Maybe<Azuremonitor_Config_Sum_Fields>;
  var_pop?: Maybe<Azuremonitor_Config_Var_Pop_Fields>;
  var_samp?: Maybe<Azuremonitor_Config_Var_Samp_Fields>;
  variance?: Maybe<Azuremonitor_Config_Variance_Fields>;
};

/** aggregate fields of "azuremonitor_config" */
export type Azuremonitor_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Azuremonitor_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Azuremonitor_Config_Append_Input = {
  attributes?: Maybe<Scalars['jsonb']>;
};

/** aggregate avg on columns */
export type Azuremonitor_Config_Avg_Fields = {
  __typename?: 'azuremonitor_config_avg_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "azuremonitor_config". All fields are combined with a logical 'AND'. */
export type Azuremonitor_Config_Bool_Exp = {
  _and?: Maybe<Array<Azuremonitor_Config_Bool_Exp>>;
  _not?: Maybe<Azuremonitor_Config_Bool_Exp>;
  _or?: Maybe<Array<Azuremonitor_Config_Bool_Exp>>;
  activedirectory_client_id?: Maybe<String_Comparison_Exp>;
  activedirectory_client_secret?: Maybe<String_Comparison_Exp>;
  activedirectory_tenant_id?: Maybe<String_Comparison_Exp>;
  attributes?: Maybe<Jsonb_Comparison_Exp>;
  azure_region?: Maybe<String_Comparison_Exp>;
  azuremonitor_workspace_id?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  instrumentation_key?: Maybe<String_Comparison_Exp>;
  log_type?: Maybe<String_Comparison_Exp>;
  logs_last_logged?: Maybe<Timestamptz_Comparison_Exp>;
  logs_response_code?: Maybe<Int_Comparison_Exp>;
  metric_namespace?: Maybe<String_Comparison_Exp>;
  metrics_last_logged?: Maybe<Timestamptz_Comparison_Exp>;
  metrics_response_code?: Maybe<Int_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  resource_id?: Maybe<String_Comparison_Exp>;
  shared_key?: Maybe<String_Comparison_Exp>;
  traces_last_logged?: Maybe<Timestamptz_Comparison_Exp>;
  traces_response_code?: Maybe<Int_Comparison_Exp>;
  traces_response_message?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "azuremonitor_config" */
export enum Azuremonitor_Config_Constraint {
  /** unique or primary key constraint on columns "project_id" */
  AzuremonitorConfigPkey = 'azuremonitor_config_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Azuremonitor_Config_Delete_At_Path_Input = {
  attributes?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Azuremonitor_Config_Delete_Elem_Input = {
  attributes?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Azuremonitor_Config_Delete_Key_Input = {
  attributes?: Maybe<Scalars['String']>;
};

/** input type for incrementing numeric columns in table "azuremonitor_config" */
export type Azuremonitor_Config_Inc_Input = {
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "azuremonitor_config" */
export type Azuremonitor_Config_Insert_Input = {
  activedirectory_client_id?: Maybe<Scalars['String']>;
  activedirectory_client_secret?: Maybe<Scalars['String']>;
  activedirectory_tenant_id?: Maybe<Scalars['String']>;
  attributes?: Maybe<Scalars['jsonb']>;
  azure_region?: Maybe<Scalars['String']>;
  azuremonitor_workspace_id?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  instrumentation_key?: Maybe<Scalars['String']>;
  log_type?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metric_namespace?: Maybe<Scalars['String']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  resource_id?: Maybe<Scalars['String']>;
  shared_key?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
  traces_response_message?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Azuremonitor_Config_Max_Fields = {
  __typename?: 'azuremonitor_config_max_fields';
  activedirectory_client_id?: Maybe<Scalars['String']>;
  activedirectory_client_secret?: Maybe<Scalars['String']>;
  activedirectory_tenant_id?: Maybe<Scalars['String']>;
  azure_region?: Maybe<Scalars['String']>;
  azuremonitor_workspace_id?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  instrumentation_key?: Maybe<Scalars['String']>;
  log_type?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metric_namespace?: Maybe<Scalars['String']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project_id?: Maybe<Scalars['uuid']>;
  resource_id?: Maybe<Scalars['String']>;
  shared_key?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
  traces_response_message?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Azuremonitor_Config_Min_Fields = {
  __typename?: 'azuremonitor_config_min_fields';
  activedirectory_client_id?: Maybe<Scalars['String']>;
  activedirectory_client_secret?: Maybe<Scalars['String']>;
  activedirectory_tenant_id?: Maybe<Scalars['String']>;
  azure_region?: Maybe<Scalars['String']>;
  azuremonitor_workspace_id?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  instrumentation_key?: Maybe<Scalars['String']>;
  log_type?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metric_namespace?: Maybe<Scalars['String']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project_id?: Maybe<Scalars['uuid']>;
  resource_id?: Maybe<Scalars['String']>;
  shared_key?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
  traces_response_message?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "azuremonitor_config" */
export type Azuremonitor_Config_Mutation_Response = {
  __typename?: 'azuremonitor_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Azuremonitor_Config>;
};

/** input type for inserting object relation for remote table "azuremonitor_config" */
export type Azuremonitor_Config_Obj_Rel_Insert_Input = {
  data: Azuremonitor_Config_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Azuremonitor_Config_On_Conflict>;
};

/** on_conflict condition type for table "azuremonitor_config" */
export type Azuremonitor_Config_On_Conflict = {
  constraint: Azuremonitor_Config_Constraint;
  update_columns?: Array<Azuremonitor_Config_Update_Column>;
  where?: Maybe<Azuremonitor_Config_Bool_Exp>;
};

/** Ordering options when selecting data from "azuremonitor_config". */
export type Azuremonitor_Config_Order_By = {
  activedirectory_client_id?: Maybe<Order_By>;
  activedirectory_client_secret?: Maybe<Order_By>;
  activedirectory_tenant_id?: Maybe<Order_By>;
  attributes?: Maybe<Order_By>;
  azure_region?: Maybe<Order_By>;
  azuremonitor_workspace_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  instrumentation_key?: Maybe<Order_By>;
  log_type?: Maybe<Order_By>;
  logs_last_logged?: Maybe<Order_By>;
  logs_response_code?: Maybe<Order_By>;
  metric_namespace?: Maybe<Order_By>;
  metrics_last_logged?: Maybe<Order_By>;
  metrics_response_code?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  resource_id?: Maybe<Order_By>;
  shared_key?: Maybe<Order_By>;
  traces_last_logged?: Maybe<Order_By>;
  traces_response_code?: Maybe<Order_By>;
  traces_response_message?: Maybe<Order_By>;
};

/** primary key columns input for table: azuremonitor_config */
export type Azuremonitor_Config_Pk_Columns_Input = {
  project_id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Azuremonitor_Config_Prepend_Input = {
  attributes?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "azuremonitor_config" */
export enum Azuremonitor_Config_Select_Column {
  /** column name */
  ActivedirectoryClientId = 'activedirectory_client_id',
  /** column name */
  ActivedirectoryClientSecret = 'activedirectory_client_secret',
  /** column name */
  ActivedirectoryTenantId = 'activedirectory_tenant_id',
  /** column name */
  Attributes = 'attributes',
  /** column name */
  AzureRegion = 'azure_region',
  /** column name */
  AzuremonitorWorkspaceId = 'azuremonitor_workspace_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  InstrumentationKey = 'instrumentation_key',
  /** column name */
  LogType = 'log_type',
  /** column name */
  LogsLastLogged = 'logs_last_logged',
  /** column name */
  LogsResponseCode = 'logs_response_code',
  /** column name */
  MetricNamespace = 'metric_namespace',
  /** column name */
  MetricsLastLogged = 'metrics_last_logged',
  /** column name */
  MetricsResponseCode = 'metrics_response_code',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  ResourceId = 'resource_id',
  /** column name */
  SharedKey = 'shared_key',
  /** column name */
  TracesLastLogged = 'traces_last_logged',
  /** column name */
  TracesResponseCode = 'traces_response_code',
  /** column name */
  TracesResponseMessage = 'traces_response_message',
}

/** input type for updating data in table "azuremonitor_config" */
export type Azuremonitor_Config_Set_Input = {
  activedirectory_client_id?: Maybe<Scalars['String']>;
  activedirectory_client_secret?: Maybe<Scalars['String']>;
  activedirectory_tenant_id?: Maybe<Scalars['String']>;
  attributes?: Maybe<Scalars['jsonb']>;
  azure_region?: Maybe<Scalars['String']>;
  azuremonitor_workspace_id?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  instrumentation_key?: Maybe<Scalars['String']>;
  log_type?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metric_namespace?: Maybe<Scalars['String']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project_id?: Maybe<Scalars['uuid']>;
  resource_id?: Maybe<Scalars['String']>;
  shared_key?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
  traces_response_message?: Maybe<Scalars['String']>;
};

/** aggregate stddev on columns */
export type Azuremonitor_Config_Stddev_Fields = {
  __typename?: 'azuremonitor_config_stddev_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Azuremonitor_Config_Stddev_Pop_Fields = {
  __typename?: 'azuremonitor_config_stddev_pop_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Azuremonitor_Config_Stddev_Samp_Fields = {
  __typename?: 'azuremonitor_config_stddev_samp_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "azuremonitor_config" */
export type Azuremonitor_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Azuremonitor_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Azuremonitor_Config_Stream_Cursor_Value_Input = {
  activedirectory_client_id?: Maybe<Scalars['String']>;
  activedirectory_client_secret?: Maybe<Scalars['String']>;
  activedirectory_tenant_id?: Maybe<Scalars['String']>;
  attributes?: Maybe<Scalars['jsonb']>;
  azure_region?: Maybe<Scalars['String']>;
  azuremonitor_workspace_id?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  instrumentation_key?: Maybe<Scalars['String']>;
  log_type?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metric_namespace?: Maybe<Scalars['String']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project_id?: Maybe<Scalars['uuid']>;
  resource_id?: Maybe<Scalars['String']>;
  shared_key?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
  traces_response_message?: Maybe<Scalars['String']>;
};

/** aggregate sum on columns */
export type Azuremonitor_Config_Sum_Fields = {
  __typename?: 'azuremonitor_config_sum_fields';
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** update columns of table "azuremonitor_config" */
export enum Azuremonitor_Config_Update_Column {
  /** column name */
  ActivedirectoryClientId = 'activedirectory_client_id',
  /** column name */
  ActivedirectoryClientSecret = 'activedirectory_client_secret',
  /** column name */
  ActivedirectoryTenantId = 'activedirectory_tenant_id',
  /** column name */
  Attributes = 'attributes',
  /** column name */
  AzureRegion = 'azure_region',
  /** column name */
  AzuremonitorWorkspaceId = 'azuremonitor_workspace_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  InstrumentationKey = 'instrumentation_key',
  /** column name */
  LogType = 'log_type',
  /** column name */
  LogsLastLogged = 'logs_last_logged',
  /** column name */
  LogsResponseCode = 'logs_response_code',
  /** column name */
  MetricNamespace = 'metric_namespace',
  /** column name */
  MetricsLastLogged = 'metrics_last_logged',
  /** column name */
  MetricsResponseCode = 'metrics_response_code',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  ResourceId = 'resource_id',
  /** column name */
  SharedKey = 'shared_key',
  /** column name */
  TracesLastLogged = 'traces_last_logged',
  /** column name */
  TracesResponseCode = 'traces_response_code',
  /** column name */
  TracesResponseMessage = 'traces_response_message',
}

export type Azuremonitor_Config_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Azuremonitor_Config_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Azuremonitor_Config_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Azuremonitor_Config_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Azuremonitor_Config_Delete_Key_Input>;
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Azuremonitor_Config_Inc_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Azuremonitor_Config_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Azuremonitor_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Azuremonitor_Config_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Azuremonitor_Config_Var_Pop_Fields = {
  __typename?: 'azuremonitor_config_var_pop_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Azuremonitor_Config_Var_Samp_Fields = {
  __typename?: 'azuremonitor_config_var_samp_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Azuremonitor_Config_Variance_Fields = {
  __typename?: 'azuremonitor_config_variance_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

export type AzureMonitorConfigResponse = {
  __typename?: 'AzureMonitorConfigResponse';
  project_id: Scalars['uuid'];
};

/** Boolean expression to compare columns of type "bigint". All fields are combined with logical 'AND'. */
export type Bigint_Comparison_Exp = {
  _eq?: Maybe<Scalars['bigint']>;
  _gt?: Maybe<Scalars['bigint']>;
  _gte?: Maybe<Scalars['bigint']>;
  _in?: Maybe<Array<Scalars['bigint']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['bigint']>;
  _lte?: Maybe<Scalars['bigint']>;
  _neq?: Maybe<Scalars['bigint']>;
  _nin?: Maybe<Array<Scalars['bigint']>>;
};

/** Address used for billing paid Hasura Cloud services */
export type Billing_Address = {
  __typename?: 'billing_address';
  address_line_1: Scalars['String'];
  address_line_2: Scalars['String'];
  city: Scalars['String'];
  country: Scalars['String'];
  created_at: Scalars['timestamptz'];
  customer_id: Scalars['String'];
  id: Scalars['uuid'];
  is_active: Scalars['Boolean'];
  last_updated_to_stripe: Scalars['timestamptz'];
  name: Scalars['String'];
  pin_code?: Maybe<Scalars['String']>;
  state: Scalars['String'];
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** An object relationship */
  user: Users;
};

/** aggregated selection of "billing_address" */
export type Billing_Address_Aggregate = {
  __typename?: 'billing_address_aggregate';
  aggregate?: Maybe<Billing_Address_Aggregate_Fields>;
  nodes: Array<Billing_Address>;
};

/** aggregate fields of "billing_address" */
export type Billing_Address_Aggregate_Fields = {
  __typename?: 'billing_address_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Billing_Address_Max_Fields>;
  min?: Maybe<Billing_Address_Min_Fields>;
};

/** aggregate fields of "billing_address" */
export type Billing_Address_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Billing_Address_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "billing_address". All fields are combined with a logical 'AND'. */
export type Billing_Address_Bool_Exp = {
  _and?: Maybe<Array<Billing_Address_Bool_Exp>>;
  _not?: Maybe<Billing_Address_Bool_Exp>;
  _or?: Maybe<Array<Billing_Address_Bool_Exp>>;
  address_line_1?: Maybe<String_Comparison_Exp>;
  address_line_2?: Maybe<String_Comparison_Exp>;
  city?: Maybe<String_Comparison_Exp>;
  country?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  customer_id?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  is_active?: Maybe<Boolean_Comparison_Exp>;
  last_updated_to_stripe?: Maybe<Timestamptz_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  pin_code?: Maybe<String_Comparison_Exp>;
  state?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  user?: Maybe<Users_Bool_Exp>;
};

/** unique or primary key constraints on table "billing_address" */
export enum Billing_Address_Constraint {
  /** unique or primary key constraint on columns "customer_id" */
  BillingAddressCustomerIdKey = 'billing_address_customer_id_key',
  /** unique or primary key constraint on columns "id" */
  BillingAddressPkey = 'billing_address_pkey',
}

/** input type for inserting data into table "billing_address" */
export type Billing_Address_Insert_Input = {
  address_line_1?: Maybe<Scalars['String']>;
  address_line_2?: Maybe<Scalars['String']>;
  city?: Maybe<Scalars['String']>;
  country?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  is_active?: Maybe<Scalars['Boolean']>;
  last_updated_to_stripe?: Maybe<Scalars['timestamptz']>;
  name?: Maybe<Scalars['String']>;
  pin_code?: Maybe<Scalars['String']>;
  state?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Billing_Address_Max_Fields = {
  __typename?: 'billing_address_max_fields';
  address_line_1?: Maybe<Scalars['String']>;
  address_line_2?: Maybe<Scalars['String']>;
  city?: Maybe<Scalars['String']>;
  country?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  last_updated_to_stripe?: Maybe<Scalars['timestamptz']>;
  name?: Maybe<Scalars['String']>;
  pin_code?: Maybe<Scalars['String']>;
  state?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Billing_Address_Min_Fields = {
  __typename?: 'billing_address_min_fields';
  address_line_1?: Maybe<Scalars['String']>;
  address_line_2?: Maybe<Scalars['String']>;
  city?: Maybe<Scalars['String']>;
  country?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  last_updated_to_stripe?: Maybe<Scalars['timestamptz']>;
  name?: Maybe<Scalars['String']>;
  pin_code?: Maybe<Scalars['String']>;
  state?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "billing_address" */
export type Billing_Address_Mutation_Response = {
  __typename?: 'billing_address_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Billing_Address>;
};

/** input type for inserting object relation for remote table "billing_address" */
export type Billing_Address_Obj_Rel_Insert_Input = {
  data: Billing_Address_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Billing_Address_On_Conflict>;
};

/** on_conflict condition type for table "billing_address" */
export type Billing_Address_On_Conflict = {
  constraint: Billing_Address_Constraint;
  update_columns?: Array<Billing_Address_Update_Column>;
  where?: Maybe<Billing_Address_Bool_Exp>;
};

/** Ordering options when selecting data from "billing_address". */
export type Billing_Address_Order_By = {
  address_line_1?: Maybe<Order_By>;
  address_line_2?: Maybe<Order_By>;
  city?: Maybe<Order_By>;
  country?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  customer_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  is_active?: Maybe<Order_By>;
  last_updated_to_stripe?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  pin_code?: Maybe<Order_By>;
  state?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user?: Maybe<Users_Order_By>;
};

/** primary key columns input for table: billing_address */
export type Billing_Address_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "billing_address" */
export enum Billing_Address_Select_Column {
  /** column name */
  AddressLine_1 = 'address_line_1',
  /** column name */
  AddressLine_2 = 'address_line_2',
  /** column name */
  City = 'city',
  /** column name */
  Country = 'country',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomerId = 'customer_id',
  /** column name */
  Id = 'id',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  LastUpdatedToStripe = 'last_updated_to_stripe',
  /** column name */
  Name = 'name',
  /** column name */
  PinCode = 'pin_code',
  /** column name */
  State = 'state',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "billing_address" */
export type Billing_Address_Set_Input = {
  address_line_1?: Maybe<Scalars['String']>;
  address_line_2?: Maybe<Scalars['String']>;
  city?: Maybe<Scalars['String']>;
  country?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  is_active?: Maybe<Scalars['Boolean']>;
  last_updated_to_stripe?: Maybe<Scalars['timestamptz']>;
  name?: Maybe<Scalars['String']>;
  pin_code?: Maybe<Scalars['String']>;
  state?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "billing_address" */
export type Billing_Address_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Billing_Address_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Billing_Address_Stream_Cursor_Value_Input = {
  address_line_1?: Maybe<Scalars['String']>;
  address_line_2?: Maybe<Scalars['String']>;
  city?: Maybe<Scalars['String']>;
  country?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  is_active?: Maybe<Scalars['Boolean']>;
  last_updated_to_stripe?: Maybe<Scalars['timestamptz']>;
  name?: Maybe<Scalars['String']>;
  pin_code?: Maybe<Scalars['String']>;
  state?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "billing_address" */
export enum Billing_Address_Update_Column {
  /** column name */
  AddressLine_1 = 'address_line_1',
  /** column name */
  AddressLine_2 = 'address_line_2',
  /** column name */
  City = 'city',
  /** column name */
  Country = 'country',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomerId = 'customer_id',
  /** column name */
  Id = 'id',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  LastUpdatedToStripe = 'last_updated_to_stripe',
  /** column name */
  Name = 'name',
  /** column name */
  PinCode = 'pin_code',
  /** column name */
  State = 'state',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Billing_Address_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Billing_Address_Set_Input>;
  /** filter the rows which have to be updated */
  where: Billing_Address_Bool_Exp;
};

export type BillingManagerInvitation = {
  __typename?: 'BillingManagerInvitation';
  id: Scalars['uuid'];
  invited_at: Scalars['String'];
  invited_by: Scalars['uuid'];
  manager_email: Scalars['String'];
  project_id: Scalars['uuid'];
};

/** Boolean expression to compare columns of type "Boolean". All fields are combined with logical 'AND'. */
export type Boolean_Comparison_Exp = {
  _eq?: Maybe<Scalars['Boolean']>;
  _gt?: Maybe<Scalars['Boolean']>;
  _gte?: Maybe<Scalars['Boolean']>;
  _in?: Maybe<Array<Scalars['Boolean']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['Boolean']>;
  _lte?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Scalars['Boolean']>;
  _nin?: Maybe<Array<Scalars['Boolean']>>;
};

export type BuildKiteBuild = {
  __typename?: 'BuildKiteBuild';
  id: Scalars['String'];
  url: Scalars['String'];
};

export type BuildVersion = {
  __typename?: 'BuildVersion';
  GitCommit: Scalars['String'];
  Tag: Scalars['String'];
};

/** Boolean expression to compare columns of type "bytea". All fields are combined with logical 'AND'. */
export type Bytea_Comparison_Exp = {
  _eq?: Maybe<Scalars['bytea']>;
  _gt?: Maybe<Scalars['bytea']>;
  _gte?: Maybe<Scalars['bytea']>;
  _in?: Maybe<Array<Scalars['bytea']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['bytea']>;
  _lte?: Maybe<Scalars['bytea']>;
  _neq?: Maybe<Scalars['bytea']>;
  _nin?: Maybe<Array<Scalars['bytea']>>;
};

/** columns and relationships of "central_cloud" */
export type Central_Cloud = {
  __typename?: 'central_cloud';
  cloud: Cloud_Enum;
  created_at: Scalars['timestamptz'];
  infra_status: Infra_Status_Enum;
  input_variables: Scalars['jsonb'];
  metrics_fqdn?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  updated_at: Scalars['timestamptz'];
};

/** columns and relationships of "central_cloud" */
export type Central_CloudInput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** columns and relationships of "central_cloud" */
export type Central_CloudOutput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "central_cloud" */
export type Central_Cloud_Aggregate = {
  __typename?: 'central_cloud_aggregate';
  aggregate?: Maybe<Central_Cloud_Aggregate_Fields>;
  nodes: Array<Central_Cloud>;
};

/** aggregate fields of "central_cloud" */
export type Central_Cloud_Aggregate_Fields = {
  __typename?: 'central_cloud_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Central_Cloud_Max_Fields>;
  min?: Maybe<Central_Cloud_Min_Fields>;
};

/** aggregate fields of "central_cloud" */
export type Central_Cloud_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Central_Cloud_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Central_Cloud_Append_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** Boolean expression to filter rows from the table "central_cloud". All fields are combined with a logical 'AND'. */
export type Central_Cloud_Bool_Exp = {
  _and?: Maybe<Array<Central_Cloud_Bool_Exp>>;
  _not?: Maybe<Central_Cloud_Bool_Exp>;
  _or?: Maybe<Array<Central_Cloud_Bool_Exp>>;
  cloud?: Maybe<Cloud_Enum_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  infra_status?: Maybe<Infra_Status_Enum_Comparison_Exp>;
  input_variables?: Maybe<Jsonb_Comparison_Exp>;
  metrics_fqdn?: Maybe<String_Comparison_Exp>;
  output_variables?: Maybe<Jsonb_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "central_cloud" */
export enum Central_Cloud_Constraint {
  /** unique or primary key constraint on columns "cloud" */
  CentralCloudPkey = 'central_cloud_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Central_Cloud_Delete_At_Path_Input = {
  input_variables?: Maybe<Array<Scalars['String']>>;
  output_variables?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Central_Cloud_Delete_Elem_Input = {
  input_variables?: Maybe<Scalars['Int']>;
  output_variables?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Central_Cloud_Delete_Key_Input = {
  input_variables?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "central_cloud" */
export type Central_Cloud_Insert_Input = {
  cloud?: Maybe<Cloud_Enum>;
  created_at?: Maybe<Scalars['timestamptz']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  metrics_fqdn?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Central_Cloud_Max_Fields = {
  __typename?: 'central_cloud_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  metrics_fqdn?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Central_Cloud_Min_Fields = {
  __typename?: 'central_cloud_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  metrics_fqdn?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "central_cloud" */
export type Central_Cloud_Mutation_Response = {
  __typename?: 'central_cloud_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Central_Cloud>;
};

/** input type for inserting object relation for remote table "central_cloud" */
export type Central_Cloud_Obj_Rel_Insert_Input = {
  data: Central_Cloud_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Central_Cloud_On_Conflict>;
};

/** on_conflict condition type for table "central_cloud" */
export type Central_Cloud_On_Conflict = {
  constraint: Central_Cloud_Constraint;
  update_columns?: Array<Central_Cloud_Update_Column>;
  where?: Maybe<Central_Cloud_Bool_Exp>;
};

/** Ordering options when selecting data from "central_cloud". */
export type Central_Cloud_Order_By = {
  cloud?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  infra_status?: Maybe<Order_By>;
  input_variables?: Maybe<Order_By>;
  metrics_fqdn?: Maybe<Order_By>;
  output_variables?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: central_cloud */
export type Central_Cloud_Pk_Columns_Input = {
  cloud: Cloud_Enum;
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Central_Cloud_Prepend_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "central_cloud" */
export enum Central_Cloud_Select_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  MetricsFqdn = 'metrics_fqdn',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "central_cloud" */
export type Central_Cloud_Set_Input = {
  cloud?: Maybe<Cloud_Enum>;
  created_at?: Maybe<Scalars['timestamptz']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  metrics_fqdn?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "central_cloud" */
export type Central_Cloud_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Central_Cloud_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Central_Cloud_Stream_Cursor_Value_Input = {
  cloud?: Maybe<Cloud_Enum>;
  created_at?: Maybe<Scalars['timestamptz']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  metrics_fqdn?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "central_cloud" */
export enum Central_Cloud_Update_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  MetricsFqdn = 'metrics_fqdn',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Central_Cloud_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Central_Cloud_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Central_Cloud_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Central_Cloud_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Central_Cloud_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Central_Cloud_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Central_Cloud_Set_Input>;
  /** filter the rows which have to be updated */
  where: Central_Cloud_Bool_Exp;
};

/** Request to change user email */
export type Change_Email_Request = {
  __typename?: 'change_email_request';
  id: Scalars['uuid'];
  key: Scalars['String'];
  new_email: Scalars['String'];
  old_email: Scalars['String'];
  resend_count: Scalars['Int'];
  status: Scalars['String'];
  /** An object relationship */
  user?: Maybe<Users>;
  user_id: Scalars['uuid'];
  verified: Scalars['Boolean'];
};

/** aggregated selection of "change_email_request" */
export type Change_Email_Request_Aggregate = {
  __typename?: 'change_email_request_aggregate';
  aggregate?: Maybe<Change_Email_Request_Aggregate_Fields>;
  nodes: Array<Change_Email_Request>;
};

/** aggregate fields of "change_email_request" */
export type Change_Email_Request_Aggregate_Fields = {
  __typename?: 'change_email_request_aggregate_fields';
  avg?: Maybe<Change_Email_Request_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Change_Email_Request_Max_Fields>;
  min?: Maybe<Change_Email_Request_Min_Fields>;
  stddev?: Maybe<Change_Email_Request_Stddev_Fields>;
  stddev_pop?: Maybe<Change_Email_Request_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Change_Email_Request_Stddev_Samp_Fields>;
  sum?: Maybe<Change_Email_Request_Sum_Fields>;
  var_pop?: Maybe<Change_Email_Request_Var_Pop_Fields>;
  var_samp?: Maybe<Change_Email_Request_Var_Samp_Fields>;
  variance?: Maybe<Change_Email_Request_Variance_Fields>;
};

/** aggregate fields of "change_email_request" */
export type Change_Email_Request_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Change_Email_Request_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Change_Email_Request_Avg_Fields = {
  __typename?: 'change_email_request_avg_fields';
  resend_count?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "change_email_request". All fields are combined with a logical 'AND'. */
export type Change_Email_Request_Bool_Exp = {
  _and?: Maybe<Array<Change_Email_Request_Bool_Exp>>;
  _not?: Maybe<Change_Email_Request_Bool_Exp>;
  _or?: Maybe<Array<Change_Email_Request_Bool_Exp>>;
  id?: Maybe<Uuid_Comparison_Exp>;
  key?: Maybe<String_Comparison_Exp>;
  new_email?: Maybe<String_Comparison_Exp>;
  old_email?: Maybe<String_Comparison_Exp>;
  resend_count?: Maybe<Int_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  user?: Maybe<Users_Bool_Exp>;
  user_id?: Maybe<Uuid_Comparison_Exp>;
  verified?: Maybe<Boolean_Comparison_Exp>;
};

/** unique or primary key constraints on table "change_email_request" */
export enum Change_Email_Request_Constraint {
  /** unique or primary key constraint on columns "key" */
  ChangeEmailRequestKeyKey = 'change_email_request_key_key',
  /** unique or primary key constraint on columns "id" */
  ChangeEmailRequestPkey = 'change_email_request_pkey',
}

/** input type for incrementing numeric columns in table "change_email_request" */
export type Change_Email_Request_Inc_Input = {
  resend_count?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "change_email_request" */
export type Change_Email_Request_Insert_Input = {
  id?: Maybe<Scalars['uuid']>;
  key?: Maybe<Scalars['String']>;
  new_email?: Maybe<Scalars['String']>;
  old_email?: Maybe<Scalars['String']>;
  resend_count?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
  user_id?: Maybe<Scalars['uuid']>;
  verified?: Maybe<Scalars['Boolean']>;
};

/** aggregate max on columns */
export type Change_Email_Request_Max_Fields = {
  __typename?: 'change_email_request_max_fields';
  id?: Maybe<Scalars['uuid']>;
  key?: Maybe<Scalars['String']>;
  new_email?: Maybe<Scalars['String']>;
  old_email?: Maybe<Scalars['String']>;
  resend_count?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate min on columns */
export type Change_Email_Request_Min_Fields = {
  __typename?: 'change_email_request_min_fields';
  id?: Maybe<Scalars['uuid']>;
  key?: Maybe<Scalars['String']>;
  new_email?: Maybe<Scalars['String']>;
  old_email?: Maybe<Scalars['String']>;
  resend_count?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** response of any mutation on the table "change_email_request" */
export type Change_Email_Request_Mutation_Response = {
  __typename?: 'change_email_request_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Change_Email_Request>;
};

/** on_conflict condition type for table "change_email_request" */
export type Change_Email_Request_On_Conflict = {
  constraint: Change_Email_Request_Constraint;
  update_columns?: Array<Change_Email_Request_Update_Column>;
  where?: Maybe<Change_Email_Request_Bool_Exp>;
};

/** Ordering options when selecting data from "change_email_request". */
export type Change_Email_Request_Order_By = {
  id?: Maybe<Order_By>;
  key?: Maybe<Order_By>;
  new_email?: Maybe<Order_By>;
  old_email?: Maybe<Order_By>;
  resend_count?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  user?: Maybe<Users_Order_By>;
  user_id?: Maybe<Order_By>;
  verified?: Maybe<Order_By>;
};

/** primary key columns input for table: change_email_request */
export type Change_Email_Request_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "change_email_request" */
export enum Change_Email_Request_Select_Column {
  /** column name */
  Id = 'id',
  /** column name */
  Key = 'key',
  /** column name */
  NewEmail = 'new_email',
  /** column name */
  OldEmail = 'old_email',
  /** column name */
  ResendCount = 'resend_count',
  /** column name */
  Status = 'status',
  /** column name */
  UserId = 'user_id',
  /** column name */
  Verified = 'verified',
}

/** input type for updating data in table "change_email_request" */
export type Change_Email_Request_Set_Input = {
  id?: Maybe<Scalars['uuid']>;
  key?: Maybe<Scalars['String']>;
  new_email?: Maybe<Scalars['String']>;
  old_email?: Maybe<Scalars['String']>;
  resend_count?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  user_id?: Maybe<Scalars['uuid']>;
  verified?: Maybe<Scalars['Boolean']>;
};

/** aggregate stddev on columns */
export type Change_Email_Request_Stddev_Fields = {
  __typename?: 'change_email_request_stddev_fields';
  resend_count?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Change_Email_Request_Stddev_Pop_Fields = {
  __typename?: 'change_email_request_stddev_pop_fields';
  resend_count?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Change_Email_Request_Stddev_Samp_Fields = {
  __typename?: 'change_email_request_stddev_samp_fields';
  resend_count?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "change_email_request" */
export type Change_Email_Request_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Change_Email_Request_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Change_Email_Request_Stream_Cursor_Value_Input = {
  id?: Maybe<Scalars['uuid']>;
  key?: Maybe<Scalars['String']>;
  new_email?: Maybe<Scalars['String']>;
  old_email?: Maybe<Scalars['String']>;
  resend_count?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  user_id?: Maybe<Scalars['uuid']>;
  verified?: Maybe<Scalars['Boolean']>;
};

/** aggregate sum on columns */
export type Change_Email_Request_Sum_Fields = {
  __typename?: 'change_email_request_sum_fields';
  resend_count?: Maybe<Scalars['Int']>;
};

/** update columns of table "change_email_request" */
export enum Change_Email_Request_Update_Column {
  /** column name */
  Id = 'id',
  /** column name */
  Key = 'key',
  /** column name */
  NewEmail = 'new_email',
  /** column name */
  OldEmail = 'old_email',
  /** column name */
  ResendCount = 'resend_count',
  /** column name */
  Status = 'status',
  /** column name */
  UserId = 'user_id',
  /** column name */
  Verified = 'verified',
}

export type Change_Email_Request_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Change_Email_Request_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Change_Email_Request_Set_Input>;
  /** filter the rows which have to be updated */
  where: Change_Email_Request_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Change_Email_Request_Var_Pop_Fields = {
  __typename?: 'change_email_request_var_pop_fields';
  resend_count?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Change_Email_Request_Var_Samp_Fields = {
  __typename?: 'change_email_request_var_samp_fields';
  resend_count?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Change_Email_Request_Variance_Fields = {
  __typename?: 'change_email_request_variance_fields';
  resend_count?: Maybe<Scalars['Float']>;
};

export type ChangeUserEmailRequest = {
  __typename?: 'ChangeUserEmailRequest';
  id: Scalars['uuid'];
  new_email: Scalars['String'];
  status: Scalars['String'];
  user_id: Scalars['uuid'];
  verified: Scalars['Boolean'];
};

export type ChangeUserEmailRequestInput = {
  new_email: Scalars['String'];
};

export type ChangeUserEmailRequestKeyInput = {
  key: Scalars['String'];
};

export type CheckDbLatencyOutput = {
  __typename?: 'CheckDBLatencyOutput';
  db_latency_job_id: Scalars['uuid'];
};

/** Connects branch(es)/PR to a particular deployment pool */
export type Cicd_Deployment_Pipeline_Config = {
  __typename?: 'cicd_deployment_pipeline_config';
  approval_required?: Maybe<Scalars['Boolean']>;
  branch_regexp?: Maybe<Scalars['String']>;
  id: Scalars['uuid'];
  /** An object relationship */
  pool?: Maybe<Cicd_Deployment_Pool>;
  pool_name: Scalars['String'];
  pull_request_id?: Maybe<Scalars['String']>;
  tag_regexp?: Maybe<Scalars['String']>;
};

/** aggregated selection of "cicd.deployment_pipeline_config" */
export type Cicd_Deployment_Pipeline_Config_Aggregate = {
  __typename?: 'cicd_deployment_pipeline_config_aggregate';
  aggregate?: Maybe<Cicd_Deployment_Pipeline_Config_Aggregate_Fields>;
  nodes: Array<Cicd_Deployment_Pipeline_Config>;
};

/** aggregate fields of "cicd.deployment_pipeline_config" */
export type Cicd_Deployment_Pipeline_Config_Aggregate_Fields = {
  __typename?: 'cicd_deployment_pipeline_config_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Cicd_Deployment_Pipeline_Config_Max_Fields>;
  min?: Maybe<Cicd_Deployment_Pipeline_Config_Min_Fields>;
};

/** aggregate fields of "cicd.deployment_pipeline_config" */
export type Cicd_Deployment_Pipeline_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Cicd_Deployment_Pipeline_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/**
 * Boolean expression to filter rows from the table
 * "cicd.deployment_pipeline_config". All fields are combined with a logical 'AND'.
 */
export type Cicd_Deployment_Pipeline_Config_Bool_Exp = {
  _and?: Maybe<Array<Cicd_Deployment_Pipeline_Config_Bool_Exp>>;
  _not?: Maybe<Cicd_Deployment_Pipeline_Config_Bool_Exp>;
  _or?: Maybe<Array<Cicd_Deployment_Pipeline_Config_Bool_Exp>>;
  approval_required?: Maybe<Boolean_Comparison_Exp>;
  branch_regexp?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  pool?: Maybe<Cicd_Deployment_Pool_Bool_Exp>;
  pool_name?: Maybe<String_Comparison_Exp>;
  pull_request_id?: Maybe<String_Comparison_Exp>;
  tag_regexp?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "cicd.deployment_pipeline_config" */
export enum Cicd_Deployment_Pipeline_Config_Constraint {
  /** unique or primary key constraint on columns "id" */
  DeploymentPipelineConfigPkey = 'deployment_pipeline_config_pkey',
}

/** input type for inserting data into table "cicd.deployment_pipeline_config" */
export type Cicd_Deployment_Pipeline_Config_Insert_Input = {
  approval_required?: Maybe<Scalars['Boolean']>;
  branch_regexp?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  pool?: Maybe<Cicd_Deployment_Pool_Obj_Rel_Insert_Input>;
  pool_name?: Maybe<Scalars['String']>;
  pull_request_id?: Maybe<Scalars['String']>;
  tag_regexp?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Cicd_Deployment_Pipeline_Config_Max_Fields = {
  __typename?: 'cicd_deployment_pipeline_config_max_fields';
  branch_regexp?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  pool_name?: Maybe<Scalars['String']>;
  pull_request_id?: Maybe<Scalars['String']>;
  tag_regexp?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Cicd_Deployment_Pipeline_Config_Min_Fields = {
  __typename?: 'cicd_deployment_pipeline_config_min_fields';
  branch_regexp?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  pool_name?: Maybe<Scalars['String']>;
  pull_request_id?: Maybe<Scalars['String']>;
  tag_regexp?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "cicd.deployment_pipeline_config" */
export type Cicd_Deployment_Pipeline_Config_Mutation_Response = {
  __typename?: 'cicd_deployment_pipeline_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Cicd_Deployment_Pipeline_Config>;
};

/** on_conflict condition type for table "cicd.deployment_pipeline_config" */
export type Cicd_Deployment_Pipeline_Config_On_Conflict = {
  constraint: Cicd_Deployment_Pipeline_Config_Constraint;
  update_columns?: Array<Cicd_Deployment_Pipeline_Config_Update_Column>;
  where?: Maybe<Cicd_Deployment_Pipeline_Config_Bool_Exp>;
};

/** Ordering options when selecting data from "cicd.deployment_pipeline_config". */
export type Cicd_Deployment_Pipeline_Config_Order_By = {
  approval_required?: Maybe<Order_By>;
  branch_regexp?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  pool?: Maybe<Cicd_Deployment_Pool_Order_By>;
  pool_name?: Maybe<Order_By>;
  pull_request_id?: Maybe<Order_By>;
  tag_regexp?: Maybe<Order_By>;
};

/** primary key columns input for table: cicd.deployment_pipeline_config */
export type Cicd_Deployment_Pipeline_Config_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "cicd.deployment_pipeline_config" */
export enum Cicd_Deployment_Pipeline_Config_Select_Column {
  /** column name */
  ApprovalRequired = 'approval_required',
  /** column name */
  BranchRegexp = 'branch_regexp',
  /** column name */
  Id = 'id',
  /** column name */
  PoolName = 'pool_name',
  /** column name */
  PullRequestId = 'pull_request_id',
  /** column name */
  TagRegexp = 'tag_regexp',
}

/** input type for updating data in table "cicd.deployment_pipeline_config" */
export type Cicd_Deployment_Pipeline_Config_Set_Input = {
  approval_required?: Maybe<Scalars['Boolean']>;
  branch_regexp?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  pool_name?: Maybe<Scalars['String']>;
  pull_request_id?: Maybe<Scalars['String']>;
  tag_regexp?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "cicd_deployment_pipeline_config" */
export type Cicd_Deployment_Pipeline_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Cicd_Deployment_Pipeline_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Cicd_Deployment_Pipeline_Config_Stream_Cursor_Value_Input = {
  approval_required?: Maybe<Scalars['Boolean']>;
  branch_regexp?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  pool_name?: Maybe<Scalars['String']>;
  pull_request_id?: Maybe<Scalars['String']>;
  tag_regexp?: Maybe<Scalars['String']>;
};

/** update columns of table "cicd.deployment_pipeline_config" */
export enum Cicd_Deployment_Pipeline_Config_Update_Column {
  /** column name */
  ApprovalRequired = 'approval_required',
  /** column name */
  BranchRegexp = 'branch_regexp',
  /** column name */
  Id = 'id',
  /** column name */
  PoolName = 'pool_name',
  /** column name */
  PullRequestId = 'pull_request_id',
  /** column name */
  TagRegexp = 'tag_regexp',
}

export type Cicd_Deployment_Pipeline_Config_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Cicd_Deployment_Pipeline_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Cicd_Deployment_Pipeline_Config_Bool_Exp;
};

/** columns and relationships of "cicd.deployment_pool" */
export type Cicd_Deployment_Pool = {
  __typename?: 'cicd_deployment_pool';
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  is_exclusive_pool?: Maybe<Scalars['Boolean']>;
  /** An array relationship */
  members: Array<Cicd_Deployment_Pool_Member>;
  /** An aggregate relationship */
  members_aggregate: Cicd_Deployment_Pool_Member_Aggregate;
  name?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** columns and relationships of "cicd.deployment_pool" */
export type Cicd_Deployment_PoolMembersArgs = {
  distinct_on?: Maybe<Array<Cicd_Deployment_Pool_Member_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Cicd_Deployment_Pool_Member_Order_By>>;
  where?: Maybe<Cicd_Deployment_Pool_Member_Bool_Exp>;
};

/** columns and relationships of "cicd.deployment_pool" */
export type Cicd_Deployment_PoolMembers_AggregateArgs = {
  distinct_on?: Maybe<Array<Cicd_Deployment_Pool_Member_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Cicd_Deployment_Pool_Member_Order_By>>;
  where?: Maybe<Cicd_Deployment_Pool_Member_Bool_Exp>;
};

/** aggregated selection of "cicd.deployment_pool" */
export type Cicd_Deployment_Pool_Aggregate = {
  __typename?: 'cicd_deployment_pool_aggregate';
  aggregate?: Maybe<Cicd_Deployment_Pool_Aggregate_Fields>;
  nodes: Array<Cicd_Deployment_Pool>;
};

/** aggregate fields of "cicd.deployment_pool" */
export type Cicd_Deployment_Pool_Aggregate_Fields = {
  __typename?: 'cicd_deployment_pool_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Cicd_Deployment_Pool_Max_Fields>;
  min?: Maybe<Cicd_Deployment_Pool_Min_Fields>;
};

/** aggregate fields of "cicd.deployment_pool" */
export type Cicd_Deployment_Pool_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Cicd_Deployment_Pool_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "cicd.deployment_pool". All fields are combined with a logical 'AND'. */
export type Cicd_Deployment_Pool_Bool_Exp = {
  _and?: Maybe<Array<Cicd_Deployment_Pool_Bool_Exp>>;
  _not?: Maybe<Cicd_Deployment_Pool_Bool_Exp>;
  _or?: Maybe<Array<Cicd_Deployment_Pool_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  description?: Maybe<String_Comparison_Exp>;
  is_exclusive_pool?: Maybe<Boolean_Comparison_Exp>;
  members?: Maybe<Cicd_Deployment_Pool_Member_Bool_Exp>;
  members_aggregate?: Maybe<Cicd_Deployment_Pool_Member_Aggregate_Bool_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** input type for inserting data into table "cicd.deployment_pool" */
export type Cicd_Deployment_Pool_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  is_exclusive_pool?: Maybe<Scalars['Boolean']>;
  members?: Maybe<Cicd_Deployment_Pool_Member_Arr_Rel_Insert_Input>;
  name?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Cicd_Deployment_Pool_Max_Fields = {
  __typename?: 'cicd_deployment_pool_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** columns and relationships of "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member = {
  __typename?: 'cicd_deployment_pool_member';
  created_at?: Maybe<Scalars['timestamptz']>;
  /** An object relationship */
  pool?: Maybe<Cicd_Deployment_Pool>;
  pool_name?: Maybe<Scalars['String']>;
  /** An object relationship */
  tenant_group?: Maybe<Tenant_Group>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregated selection of "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Aggregate = {
  __typename?: 'cicd_deployment_pool_member_aggregate';
  aggregate?: Maybe<Cicd_Deployment_Pool_Member_Aggregate_Fields>;
  nodes: Array<Cicd_Deployment_Pool_Member>;
};

export type Cicd_Deployment_Pool_Member_Aggregate_Bool_Exp = {
  count?: Maybe<Cicd_Deployment_Pool_Member_Aggregate_Bool_Exp_Count>;
};

export type Cicd_Deployment_Pool_Member_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Cicd_Deployment_Pool_Member_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Cicd_Deployment_Pool_Member_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Aggregate_Fields = {
  __typename?: 'cicd_deployment_pool_member_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Cicd_Deployment_Pool_Member_Max_Fields>;
  min?: Maybe<Cicd_Deployment_Pool_Member_Min_Fields>;
};

/** aggregate fields of "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Cicd_Deployment_Pool_Member_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Cicd_Deployment_Pool_Member_Max_Order_By>;
  min?: Maybe<Cicd_Deployment_Pool_Member_Min_Order_By>;
};

/** input type for inserting array relation for remote table "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Arr_Rel_Insert_Input = {
  data: Array<Cicd_Deployment_Pool_Member_Insert_Input>;
};

/**
 * Boolean expression to filter rows from the table "cicd.deployment_pool_member".
 * All fields are combined with a logical 'AND'.
 */
export type Cicd_Deployment_Pool_Member_Bool_Exp = {
  _and?: Maybe<Array<Cicd_Deployment_Pool_Member_Bool_Exp>>;
  _not?: Maybe<Cicd_Deployment_Pool_Member_Bool_Exp>;
  _or?: Maybe<Array<Cicd_Deployment_Pool_Member_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  pool?: Maybe<Cicd_Deployment_Pool_Bool_Exp>;
  pool_name?: Maybe<String_Comparison_Exp>;
  tenant_group?: Maybe<Tenant_Group_Bool_Exp>;
  tenant_group_id?: Maybe<Uuid_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** input type for inserting data into table "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  pool?: Maybe<Cicd_Deployment_Pool_Obj_Rel_Insert_Input>;
  pool_name?: Maybe<Scalars['String']>;
  tenant_group?: Maybe<Tenant_Group_Obj_Rel_Insert_Input>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Cicd_Deployment_Pool_Member_Max_Fields = {
  __typename?: 'cicd_deployment_pool_member_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  pool_name?: Maybe<Scalars['String']>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by max() on columns of table "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Max_Order_By = {
  created_at?: Maybe<Order_By>;
  pool_name?: Maybe<Order_By>;
  tenant_group_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Cicd_Deployment_Pool_Member_Min_Fields = {
  __typename?: 'cicd_deployment_pool_member_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  pool_name?: Maybe<Scalars['String']>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by min() on columns of table "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Min_Order_By = {
  created_at?: Maybe<Order_By>;
  pool_name?: Maybe<Order_By>;
  tenant_group_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** response of any mutation on the table "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Mutation_Response = {
  __typename?: 'cicd_deployment_pool_member_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Cicd_Deployment_Pool_Member>;
};

/** Ordering options when selecting data from "cicd.deployment_pool_member". */
export type Cicd_Deployment_Pool_Member_Order_By = {
  created_at?: Maybe<Order_By>;
  pool?: Maybe<Cicd_Deployment_Pool_Order_By>;
  pool_name?: Maybe<Order_By>;
  tenant_group?: Maybe<Tenant_Group_Order_By>;
  tenant_group_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** select columns of table "cicd.deployment_pool_member" */
export enum Cicd_Deployment_Pool_Member_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  PoolName = 'pool_name',
  /** column name */
  TenantGroupId = 'tenant_group_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "cicd.deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  pool_name?: Maybe<Scalars['String']>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "cicd_deployment_pool_member" */
export type Cicd_Deployment_Pool_Member_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Cicd_Deployment_Pool_Member_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Cicd_Deployment_Pool_Member_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  pool_name?: Maybe<Scalars['String']>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

export type Cicd_Deployment_Pool_Member_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Cicd_Deployment_Pool_Member_Set_Input>;
  /** filter the rows which have to be updated */
  where: Cicd_Deployment_Pool_Member_Bool_Exp;
};

/** aggregate min on columns */
export type Cicd_Deployment_Pool_Min_Fields = {
  __typename?: 'cicd_deployment_pool_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "cicd.deployment_pool" */
export type Cicd_Deployment_Pool_Mutation_Response = {
  __typename?: 'cicd_deployment_pool_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Cicd_Deployment_Pool>;
};

/** input type for inserting object relation for remote table "cicd.deployment_pool" */
export type Cicd_Deployment_Pool_Obj_Rel_Insert_Input = {
  data: Cicd_Deployment_Pool_Insert_Input;
};

/** Ordering options when selecting data from "cicd.deployment_pool". */
export type Cicd_Deployment_Pool_Order_By = {
  created_at?: Maybe<Order_By>;
  description?: Maybe<Order_By>;
  is_exclusive_pool?: Maybe<Order_By>;
  members_aggregate?: Maybe<Cicd_Deployment_Pool_Member_Aggregate_Order_By>;
  name?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** select columns of table "cicd.deployment_pool" */
export enum Cicd_Deployment_Pool_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Description = 'description',
  /** column name */
  IsExclusivePool = 'is_exclusive_pool',
  /** column name */
  Name = 'name',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "cicd.deployment_pool" */
export type Cicd_Deployment_Pool_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  is_exclusive_pool?: Maybe<Scalars['Boolean']>;
  name?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "cicd_deployment_pool" */
export type Cicd_Deployment_Pool_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Cicd_Deployment_Pool_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Cicd_Deployment_Pool_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  is_exclusive_pool?: Maybe<Scalars['Boolean']>;
  name?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

export type Cicd_Deployment_Pool_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Cicd_Deployment_Pool_Set_Input>;
  /** filter the rows which have to be updated */
  where: Cicd_Deployment_Pool_Bool_Exp;
};

export type Cicd_Get_Matching_Pipeline_Config_Args = {
  branch?: Maybe<Scalars['String']>;
  pull_request?: Maybe<Scalars['String']>;
  tag?: Maybe<Scalars['String']>;
};

/** Boolean expression to compare columns of type "citext". All fields are combined with logical 'AND'. */
export type Citext_Comparison_Exp = {
  _eq?: Maybe<Scalars['citext']>;
  _gt?: Maybe<Scalars['citext']>;
  _gte?: Maybe<Scalars['citext']>;
  /** does the column match the given case-insensitive pattern */
  _ilike?: Maybe<Scalars['citext']>;
  _in?: Maybe<Array<Scalars['citext']>>;
  /** does the column match the given POSIX regular expression, case insensitive */
  _iregex?: Maybe<Scalars['citext']>;
  _is_null?: Maybe<Scalars['Boolean']>;
  /** does the column match the given pattern */
  _like?: Maybe<Scalars['citext']>;
  _lt?: Maybe<Scalars['citext']>;
  _lte?: Maybe<Scalars['citext']>;
  _neq?: Maybe<Scalars['citext']>;
  /** does the column NOT match the given case-insensitive pattern */
  _nilike?: Maybe<Scalars['citext']>;
  _nin?: Maybe<Array<Scalars['citext']>>;
  /** does the column NOT match the given POSIX regular expression, case insensitive */
  _niregex?: Maybe<Scalars['citext']>;
  /** does the column NOT match the given pattern */
  _nlike?: Maybe<Scalars['citext']>;
  /** does the column NOT match the given POSIX regular expression, case sensitive */
  _nregex?: Maybe<Scalars['citext']>;
  /** does the column NOT match the given SQL regular expression */
  _nsimilar?: Maybe<Scalars['citext']>;
  /** does the column match the given POSIX regular expression, case sensitive */
  _regex?: Maybe<Scalars['citext']>;
  /** does the column match the given SQL regular expression */
  _similar?: Maybe<Scalars['citext']>;
};

export type ClientSecretInfo = {
  __typename?: 'clientSecretInfo';
  client_secret: Scalars['String'];
};

/** Hasura enum to define cloud provider. This enum is used in the tenant table. */
export type Cloud = {
  __typename?: 'cloud';
  description: Scalars['String'];
  name: Scalars['String'];
};

/** aggregated selection of "cloud" */
export type Cloud_Aggregate = {
  __typename?: 'cloud_aggregate';
  aggregate?: Maybe<Cloud_Aggregate_Fields>;
  nodes: Array<Cloud>;
};

/** aggregate fields of "cloud" */
export type Cloud_Aggregate_Fields = {
  __typename?: 'cloud_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Cloud_Max_Fields>;
  min?: Maybe<Cloud_Min_Fields>;
};

/** aggregate fields of "cloud" */
export type Cloud_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Cloud_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "cloud". All fields are combined with a logical 'AND'. */
export type Cloud_Bool_Exp = {
  _and?: Maybe<Array<Cloud_Bool_Exp>>;
  _not?: Maybe<Cloud_Bool_Exp>;
  _or?: Maybe<Array<Cloud_Bool_Exp>>;
  description?: Maybe<String_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "cloud" */
export enum Cloud_Constraint {
  /** unique or primary key constraint on columns "name" */
  CloudPkey = 'cloud_pkey',
}

export enum Cloud_Enum {
  /** Amazon Web Services */
  Aws = 'aws',
  /** Microsoft Azure */
  Azure = 'azure',
  /** Digital Ocean */
  Do = 'do',
  /** Google Cloud Platform */
  Gcp = 'gcp',
}

/** Boolean expression to compare columns of type "cloud_enum". All fields are combined with logical 'AND'. */
export type Cloud_Enum_Comparison_Exp = {
  _eq?: Maybe<Cloud_Enum>;
  _in?: Maybe<Array<Cloud_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Cloud_Enum>;
  _nin?: Maybe<Array<Cloud_Enum>>;
};

/** input type for inserting data into table "cloud" */
export type Cloud_Insert_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Cloud_Max_Fields = {
  __typename?: 'cloud_max_fields';
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** columns and relationships of "cloud_metadata" */
export type Cloud_Metadata = {
  __typename?: 'cloud_metadata';
  /** Get AWS Account ID for Hasura Cloud */
  aws_account_id?: Maybe<Scalars['String']>;
  cloud: Cloud_Enum;
  metadata: Scalars['jsonb'];
};

/** columns and relationships of "cloud_metadata" */
export type Cloud_MetadataMetadataArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "cloud_metadata" */
export type Cloud_Metadata_Aggregate = {
  __typename?: 'cloud_metadata_aggregate';
  aggregate?: Maybe<Cloud_Metadata_Aggregate_Fields>;
  nodes: Array<Cloud_Metadata>;
};

/** aggregate fields of "cloud_metadata" */
export type Cloud_Metadata_Aggregate_Fields = {
  __typename?: 'cloud_metadata_aggregate_fields';
  count: Scalars['Int'];
};

/** aggregate fields of "cloud_metadata" */
export type Cloud_Metadata_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Cloud_Metadata_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Cloud_Metadata_Append_Input = {
  metadata?: Maybe<Scalars['jsonb']>;
};

/** Boolean expression to filter rows from the table "cloud_metadata". All fields are combined with a logical 'AND'. */
export type Cloud_Metadata_Bool_Exp = {
  _and?: Maybe<Array<Cloud_Metadata_Bool_Exp>>;
  _not?: Maybe<Cloud_Metadata_Bool_Exp>;
  _or?: Maybe<Array<Cloud_Metadata_Bool_Exp>>;
  aws_account_id?: Maybe<String_Comparison_Exp>;
  cloud?: Maybe<Cloud_Enum_Comparison_Exp>;
  metadata?: Maybe<Jsonb_Comparison_Exp>;
};

/** unique or primary key constraints on table "cloud_metadata" */
export enum Cloud_Metadata_Constraint {
  /** unique or primary key constraint on columns "cloud" */
  CloudMetadataPkey = 'cloud_metadata_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Cloud_Metadata_Delete_At_Path_Input = {
  metadata?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Cloud_Metadata_Delete_Elem_Input = {
  metadata?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Cloud_Metadata_Delete_Key_Input = {
  metadata?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "cloud_metadata" */
export type Cloud_Metadata_Insert_Input = {
  cloud?: Maybe<Cloud_Enum>;
  metadata?: Maybe<Scalars['jsonb']>;
};

/** response of any mutation on the table "cloud_metadata" */
export type Cloud_Metadata_Mutation_Response = {
  __typename?: 'cloud_metadata_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Cloud_Metadata>;
};

/** on_conflict condition type for table "cloud_metadata" */
export type Cloud_Metadata_On_Conflict = {
  constraint: Cloud_Metadata_Constraint;
  update_columns?: Array<Cloud_Metadata_Update_Column>;
  where?: Maybe<Cloud_Metadata_Bool_Exp>;
};

/** Ordering options when selecting data from "cloud_metadata". */
export type Cloud_Metadata_Order_By = {
  aws_account_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  metadata?: Maybe<Order_By>;
};

/** primary key columns input for table: cloud_metadata */
export type Cloud_Metadata_Pk_Columns_Input = {
  cloud: Cloud_Enum;
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Cloud_Metadata_Prepend_Input = {
  metadata?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "cloud_metadata" */
export enum Cloud_Metadata_Select_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  Metadata = 'metadata',
}

/** input type for updating data in table "cloud_metadata" */
export type Cloud_Metadata_Set_Input = {
  cloud?: Maybe<Cloud_Enum>;
  metadata?: Maybe<Scalars['jsonb']>;
};

/** Streaming cursor of the table "cloud_metadata" */
export type Cloud_Metadata_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Cloud_Metadata_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Cloud_Metadata_Stream_Cursor_Value_Input = {
  cloud?: Maybe<Cloud_Enum>;
  metadata?: Maybe<Scalars['jsonb']>;
};

/** update columns of table "cloud_metadata" */
export enum Cloud_Metadata_Update_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  Metadata = 'metadata',
}

export type Cloud_Metadata_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Cloud_Metadata_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Cloud_Metadata_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Cloud_Metadata_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Cloud_Metadata_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Cloud_Metadata_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Cloud_Metadata_Set_Input>;
  /** filter the rows which have to be updated */
  where: Cloud_Metadata_Bool_Exp;
};

/** aggregate min on columns */
export type Cloud_Min_Fields = {
  __typename?: 'cloud_min_fields';
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "cloud" */
export type Cloud_Mutation_Response = {
  __typename?: 'cloud_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Cloud>;
};

/** on_conflict condition type for table "cloud" */
export type Cloud_On_Conflict = {
  constraint: Cloud_Constraint;
  update_columns?: Array<Cloud_Update_Column>;
  where?: Maybe<Cloud_Bool_Exp>;
};

/** Ordering options when selecting data from "cloud". */
export type Cloud_Order_By = {
  description?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
};

/** primary key columns input for table: cloud */
export type Cloud_Pk_Columns_Input = {
  name: Scalars['String'];
};

/** columns and relationships of "cloud_regions_by_plan" */
export type Cloud_Regions_By_Plan = {
  __typename?: 'cloud_regions_by_plan';
  cloud?: Maybe<Scalars['String']>;
  infra_status?: Maybe<Scalars['String']>;
  input_variables?: Maybe<Scalars['jsonb']>;
  is_active?: Maybe<Scalars['Boolean']>;
  metrics_fqdn?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  nat_ip?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  plan_name?: Maybe<Scalars['String']>;
  /** An object relationship */
  region?: Maybe<Region>;
};

/** columns and relationships of "cloud_regions_by_plan" */
export type Cloud_Regions_By_PlanInput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** columns and relationships of "cloud_regions_by_plan" */
export type Cloud_Regions_By_PlanOutput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "cloud_regions_by_plan" */
export type Cloud_Regions_By_Plan_Aggregate = {
  __typename?: 'cloud_regions_by_plan_aggregate';
  aggregate?: Maybe<Cloud_Regions_By_Plan_Aggregate_Fields>;
  nodes: Array<Cloud_Regions_By_Plan>;
};

/** aggregate fields of "cloud_regions_by_plan" */
export type Cloud_Regions_By_Plan_Aggregate_Fields = {
  __typename?: 'cloud_regions_by_plan_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Cloud_Regions_By_Plan_Max_Fields>;
  min?: Maybe<Cloud_Regions_By_Plan_Min_Fields>;
};

/** aggregate fields of "cloud_regions_by_plan" */
export type Cloud_Regions_By_Plan_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Cloud_Regions_By_Plan_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "cloud_regions_by_plan". All fields are combined with a logical 'AND'. */
export type Cloud_Regions_By_Plan_Bool_Exp = {
  _and?: Maybe<Array<Cloud_Regions_By_Plan_Bool_Exp>>;
  _not?: Maybe<Cloud_Regions_By_Plan_Bool_Exp>;
  _or?: Maybe<Array<Cloud_Regions_By_Plan_Bool_Exp>>;
  cloud?: Maybe<String_Comparison_Exp>;
  infra_status?: Maybe<String_Comparison_Exp>;
  input_variables?: Maybe<Jsonb_Comparison_Exp>;
  is_active?: Maybe<Boolean_Comparison_Exp>;
  metrics_fqdn?: Maybe<String_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  nat_ip?: Maybe<String_Comparison_Exp>;
  output_variables?: Maybe<Jsonb_Comparison_Exp>;
  plan_name?: Maybe<String_Comparison_Exp>;
  region?: Maybe<Region_Bool_Exp>;
};

/** aggregate max on columns */
export type Cloud_Regions_By_Plan_Max_Fields = {
  __typename?: 'cloud_regions_by_plan_max_fields';
  cloud?: Maybe<Scalars['String']>;
  infra_status?: Maybe<Scalars['String']>;
  metrics_fqdn?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  nat_ip?: Maybe<Scalars['String']>;
  plan_name?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Cloud_Regions_By_Plan_Min_Fields = {
  __typename?: 'cloud_regions_by_plan_min_fields';
  cloud?: Maybe<Scalars['String']>;
  infra_status?: Maybe<Scalars['String']>;
  metrics_fqdn?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  nat_ip?: Maybe<Scalars['String']>;
  plan_name?: Maybe<Scalars['String']>;
};

/** Ordering options when selecting data from "cloud_regions_by_plan". */
export type Cloud_Regions_By_Plan_Order_By = {
  cloud?: Maybe<Order_By>;
  infra_status?: Maybe<Order_By>;
  input_variables?: Maybe<Order_By>;
  is_active?: Maybe<Order_By>;
  metrics_fqdn?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  nat_ip?: Maybe<Order_By>;
  output_variables?: Maybe<Order_By>;
  plan_name?: Maybe<Order_By>;
  region?: Maybe<Region_Order_By>;
};

/** select columns of table "cloud_regions_by_plan" */
export enum Cloud_Regions_By_Plan_Select_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  MetricsFqdn = 'metrics_fqdn',
  /** column name */
  Name = 'name',
  /** column name */
  NatIp = 'nat_ip',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  PlanName = 'plan_name',
}

/** Streaming cursor of the table "cloud_regions_by_plan" */
export type Cloud_Regions_By_Plan_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Cloud_Regions_By_Plan_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Cloud_Regions_By_Plan_Stream_Cursor_Value_Input = {
  cloud?: Maybe<Scalars['String']>;
  infra_status?: Maybe<Scalars['String']>;
  input_variables?: Maybe<Scalars['jsonb']>;
  is_active?: Maybe<Scalars['Boolean']>;
  metrics_fqdn?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  nat_ip?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  plan_name?: Maybe<Scalars['String']>;
};

/** select columns of table "cloud" */
export enum Cloud_Select_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Name = 'name',
}

/** input type for updating data in table "cloud" */
export type Cloud_Set_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "cloud" */
export type Cloud_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Cloud_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Cloud_Stream_Cursor_Value_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** update columns of table "cloud" */
export enum Cloud_Update_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Name = 'name',
}

export type Cloud_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Cloud_Set_Input>;
  /** filter the rows which have to be updated */
  where: Cloud_Bool_Exp;
};

export enum CloudProvider {
  Aws = 'aws',
  Azure = 'azure',
  Gcp = 'gcp',
}

export type Compute_Project_Agg_Db_Usage_User_Args = {
  from_time?: Maybe<Scalars['timestamptz']>;
  to_time?: Maybe<Scalars['timestamptz']>;
  user_ids?: Maybe<Scalars['_uuid']>;
};

export type Compute_Project_Agg_Usage_Args = {
  from_time?: Maybe<Scalars['timestamptz']>;
  project_ids?: Maybe<Scalars['_uuid']>;
  to_time?: Maybe<Scalars['timestamptz']>;
};

export type Compute_Project_Agg_Usage_Prometheus_Args = {
  from_time?: Maybe<Scalars['timestamptz']>;
  project_ids?: Maybe<Scalars['_uuid']>;
  to_time?: Maybe<Scalars['timestamptz']>;
};

export type Compute_Project_Agg_Usage_Prometheus_User_Args = {
  from_time?: Maybe<Scalars['timestamptz']>;
  to_time?: Maybe<Scalars['timestamptz']>;
  user_ids?: Maybe<Scalars['_uuid']>;
};

export type Compute_Project_Agg_Usage_User_Args = {
  from_time?: Maybe<Scalars['timestamptz']>;
  to_time?: Maybe<Scalars['timestamptz']>;
  user_ids?: Maybe<Scalars['_uuid']>;
};

/**
 * capture compute unit configuration per cluster and allows for sharing between
 * cluster. Compute units are adhered to by the node pools or cluster autoscaling configuration
 */
export type Compute_Unit_Config = {
  __typename?: 'compute_unit_config';
  /** An object relationship */
  cluster?: Maybe<Hasura_Cluster>;
  config?: Maybe<Scalars['jsonb']>;
  created_at: Scalars['timestamptz'];
  id: Scalars['uuid'];
  /** An array relationship */
  usage: Array<Dedicated_Cloud_Bills>;
  /** An aggregate relationship */
  usage_aggregate: Dedicated_Cloud_Bills_Aggregate;
  /** An object relationship */
  user?: Maybe<Users>;
  user_id: Scalars['uuid'];
};

/**
 * capture compute unit configuration per cluster and allows for sharing between
 * cluster. Compute units are adhered to by the node pools or cluster autoscaling configuration
 */
export type Compute_Unit_ConfigConfigArgs = {
  path?: Maybe<Scalars['String']>;
};

/**
 * capture compute unit configuration per cluster and allows for sharing between
 * cluster. Compute units are adhered to by the node pools or cluster autoscaling configuration
 */
export type Compute_Unit_ConfigUsageArgs = {
  distinct_on?: Maybe<Array<Dedicated_Cloud_Bills_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Dedicated_Cloud_Bills_Order_By>>;
  where?: Maybe<Dedicated_Cloud_Bills_Bool_Exp>;
};

/**
 * capture compute unit configuration per cluster and allows for sharing between
 * cluster. Compute units are adhered to by the node pools or cluster autoscaling configuration
 */
export type Compute_Unit_ConfigUsage_AggregateArgs = {
  distinct_on?: Maybe<Array<Dedicated_Cloud_Bills_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Dedicated_Cloud_Bills_Order_By>>;
  where?: Maybe<Dedicated_Cloud_Bills_Bool_Exp>;
};

/** aggregated selection of "compute_unit_config" */
export type Compute_Unit_Config_Aggregate = {
  __typename?: 'compute_unit_config_aggregate';
  aggregate?: Maybe<Compute_Unit_Config_Aggregate_Fields>;
  nodes: Array<Compute_Unit_Config>;
};

/** aggregate fields of "compute_unit_config" */
export type Compute_Unit_Config_Aggregate_Fields = {
  __typename?: 'compute_unit_config_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Compute_Unit_Config_Max_Fields>;
  min?: Maybe<Compute_Unit_Config_Min_Fields>;
};

/** aggregate fields of "compute_unit_config" */
export type Compute_Unit_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Compute_Unit_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Compute_Unit_Config_Append_Input = {
  config?: Maybe<Scalars['jsonb']>;
};

/** Boolean expression to filter rows from the table "compute_unit_config". All fields are combined with a logical 'AND'. */
export type Compute_Unit_Config_Bool_Exp = {
  _and?: Maybe<Array<Compute_Unit_Config_Bool_Exp>>;
  _not?: Maybe<Compute_Unit_Config_Bool_Exp>;
  _or?: Maybe<Array<Compute_Unit_Config_Bool_Exp>>;
  cluster?: Maybe<Hasura_Cluster_Bool_Exp>;
  config?: Maybe<Jsonb_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  usage?: Maybe<Dedicated_Cloud_Bills_Bool_Exp>;
  usage_aggregate?: Maybe<Dedicated_Cloud_Bills_Aggregate_Bool_Exp>;
  user?: Maybe<Users_Bool_Exp>;
  user_id?: Maybe<Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "compute_unit_config" */
export enum Compute_Unit_Config_Constraint {
  /** unique or primary key constraint on columns "id" */
  ComputeUnitConfigPkey = 'compute_unit_config_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Compute_Unit_Config_Delete_At_Path_Input = {
  config?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Compute_Unit_Config_Delete_Elem_Input = {
  config?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Compute_Unit_Config_Delete_Key_Input = {
  config?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "compute_unit_config" */
export type Compute_Unit_Config_Insert_Input = {
  cluster?: Maybe<Hasura_Cluster_Obj_Rel_Insert_Input>;
  config?: Maybe<Scalars['jsonb']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  usage?: Maybe<Dedicated_Cloud_Bills_Arr_Rel_Insert_Input>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Compute_Unit_Config_Max_Fields = {
  __typename?: 'compute_unit_config_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate min on columns */
export type Compute_Unit_Config_Min_Fields = {
  __typename?: 'compute_unit_config_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** response of any mutation on the table "compute_unit_config" */
export type Compute_Unit_Config_Mutation_Response = {
  __typename?: 'compute_unit_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Compute_Unit_Config>;
};

/** input type for inserting object relation for remote table "compute_unit_config" */
export type Compute_Unit_Config_Obj_Rel_Insert_Input = {
  data: Compute_Unit_Config_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Compute_Unit_Config_On_Conflict>;
};

/** on_conflict condition type for table "compute_unit_config" */
export type Compute_Unit_Config_On_Conflict = {
  constraint: Compute_Unit_Config_Constraint;
  update_columns?: Array<Compute_Unit_Config_Update_Column>;
  where?: Maybe<Compute_Unit_Config_Bool_Exp>;
};

/** Ordering options when selecting data from "compute_unit_config". */
export type Compute_Unit_Config_Order_By = {
  cluster?: Maybe<Hasura_Cluster_Order_By>;
  config?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  usage_aggregate?: Maybe<Dedicated_Cloud_Bills_Aggregate_Order_By>;
  user?: Maybe<Users_Order_By>;
  user_id?: Maybe<Order_By>;
};

/** primary key columns input for table: compute_unit_config */
export type Compute_Unit_Config_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Compute_Unit_Config_Prepend_Input = {
  config?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "compute_unit_config" */
export enum Compute_Unit_Config_Select_Column {
  /** column name */
  Config = 'config',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  UserId = 'user_id',
}

/** input type for updating data in table "compute_unit_config" */
export type Compute_Unit_Config_Set_Input = {
  config?: Maybe<Scalars['jsonb']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** Streaming cursor of the table "compute_unit_config" */
export type Compute_Unit_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Compute_Unit_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Compute_Unit_Config_Stream_Cursor_Value_Input = {
  config?: Maybe<Scalars['jsonb']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** update columns of table "compute_unit_config" */
export enum Compute_Unit_Config_Update_Column {
  /** column name */
  Config = 'config',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  UserId = 'user_id',
}

export type Compute_Unit_Config_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Compute_Unit_Config_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Compute_Unit_Config_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Compute_Unit_Config_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Compute_Unit_Config_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Compute_Unit_Config_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Compute_Unit_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Compute_Unit_Config_Bool_Exp;
};

export type ComputeUnitCountResponse = {
  __typename?: 'ComputeUnitCountResponse';
  cloud: CloudProvider;
  cluster_id: Scalars['String'];
  values: Array<Maybe<GranularComputeUnitCount>>;
};

export type ComputeUnitUsageResponse = {
  __typename?: 'ComputeUnitUsageResponse';
  cloud: CloudProvider;
  cluster_id: Scalars['String'];
  values?: Maybe<Array<Maybe<GranularComputeUnitUsagePercentage>>>;
};

/** Metadata for tenant config in vault */
export type Config = {
  __typename?: 'config';
  hash: Scalars['String'];
  /** An array relationship */
  status: Array<Config_Status>;
  /** An aggregate relationship */
  status_aggregate: Config_Status_Aggregate;
  /** An object relationship */
  tenant: Tenant;
  tenant_id: Scalars['uuid'];
  updated_at: Scalars['timestamptz'];
  vault_path: Scalars['String'];
};

/** Metadata for tenant config in vault */
export type ConfigStatusArgs = {
  distinct_on?: Maybe<Array<Config_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Config_Status_Order_By>>;
  where?: Maybe<Config_Status_Bool_Exp>;
};

/** Metadata for tenant config in vault */
export type ConfigStatus_AggregateArgs = {
  distinct_on?: Maybe<Array<Config_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Config_Status_Order_By>>;
  where?: Maybe<Config_Status_Bool_Exp>;
};

/** aggregated selection of "config" */
export type Config_Aggregate = {
  __typename?: 'config_aggregate';
  aggregate?: Maybe<Config_Aggregate_Fields>;
  nodes: Array<Config>;
};

/** aggregate fields of "config" */
export type Config_Aggregate_Fields = {
  __typename?: 'config_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Config_Max_Fields>;
  min?: Maybe<Config_Min_Fields>;
};

/** aggregate fields of "config" */
export type Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "config". All fields are combined with a logical 'AND'. */
export type Config_Bool_Exp = {
  _and?: Maybe<Array<Config_Bool_Exp>>;
  _not?: Maybe<Config_Bool_Exp>;
  _or?: Maybe<Array<Config_Bool_Exp>>;
  hash?: Maybe<String_Comparison_Exp>;
  status?: Maybe<Config_Status_Bool_Exp>;
  status_aggregate?: Maybe<Config_Status_Aggregate_Bool_Exp>;
  tenant?: Maybe<Tenant_Bool_Exp>;
  tenant_id?: Maybe<Uuid_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  vault_path?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "config" */
export enum Config_Constraint {
  /** unique or primary key constraint on columns "tenant_id" */
  ConfigPkey = 'config_pkey',
  /** unique or primary key constraint on columns "tenant_id" */
  ConfigTenantIdKey = 'config_tenant_id_key',
}

/** input type for inserting data into table "config" */
export type Config_Insert_Input = {
  hash?: Maybe<Scalars['String']>;
  status?: Maybe<Config_Status_Arr_Rel_Insert_Input>;
  tenant?: Maybe<Tenant_Obj_Rel_Insert_Input>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  vault_path?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Config_Max_Fields = {
  __typename?: 'config_max_fields';
  hash?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  vault_path?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Config_Min_Fields = {
  __typename?: 'config_min_fields';
  hash?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  vault_path?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "config" */
export type Config_Mutation_Response = {
  __typename?: 'config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Config>;
};

/** input type for inserting object relation for remote table "config" */
export type Config_Obj_Rel_Insert_Input = {
  data: Config_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Config_On_Conflict>;
};

/** on_conflict condition type for table "config" */
export type Config_On_Conflict = {
  constraint: Config_Constraint;
  update_columns?: Array<Config_Update_Column>;
  where?: Maybe<Config_Bool_Exp>;
};

/** Ordering options when selecting data from "config". */
export type Config_Order_By = {
  hash?: Maybe<Order_By>;
  status_aggregate?: Maybe<Config_Status_Aggregate_Order_By>;
  tenant?: Maybe<Tenant_Order_By>;
  tenant_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  vault_path?: Maybe<Order_By>;
};

/** primary key columns input for table: config */
export type Config_Pk_Columns_Input = {
  tenant_id: Scalars['uuid'];
};

/** select columns of table "config" */
export enum Config_Select_Column {
  /** column name */
  Hash = 'hash',
  /** column name */
  TenantId = 'tenant_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  VaultPath = 'vault_path',
}

/** input type for updating data in table "config" */
export type Config_Set_Input = {
  hash?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  vault_path?: Maybe<Scalars['String']>;
};

/** Status of a given tenant config by hasura worker */
export type Config_Status = {
  __typename?: 'config_status';
  hash: Scalars['String'];
  is_active: Scalars['Boolean'];
  message?: Maybe<Scalars['String']>;
  /** An object relationship */
  tenant: Tenant;
  tenant_id: Scalars['uuid'];
  updated_at: Scalars['timestamptz'];
  worker_id: Scalars['uuid'];
  /** A computed field, executes function "config_status_worker_state" */
  worker_state?: Maybe<Scalars['String']>;
};

/** aggregated selection of "config_status" */
export type Config_Status_Aggregate = {
  __typename?: 'config_status_aggregate';
  aggregate?: Maybe<Config_Status_Aggregate_Fields>;
  nodes: Array<Config_Status>;
};

export type Config_Status_Aggregate_Bool_Exp = {
  bool_and?: Maybe<Config_Status_Aggregate_Bool_Exp_Bool_And>;
  bool_or?: Maybe<Config_Status_Aggregate_Bool_Exp_Bool_Or>;
  count?: Maybe<Config_Status_Aggregate_Bool_Exp_Count>;
};

export type Config_Status_Aggregate_Bool_Exp_Bool_And = {
  arguments: Config_Status_Select_Column_Config_Status_Aggregate_Bool_Exp_Bool_And_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Config_Status_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Config_Status_Aggregate_Bool_Exp_Bool_Or = {
  arguments: Config_Status_Select_Column_Config_Status_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Config_Status_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Config_Status_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Config_Status_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Config_Status_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "config_status" */
export type Config_Status_Aggregate_Fields = {
  __typename?: 'config_status_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Config_Status_Max_Fields>;
  min?: Maybe<Config_Status_Min_Fields>;
};

/** aggregate fields of "config_status" */
export type Config_Status_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Config_Status_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "config_status" */
export type Config_Status_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Config_Status_Max_Order_By>;
  min?: Maybe<Config_Status_Min_Order_By>;
};

/** input type for inserting array relation for remote table "config_status" */
export type Config_Status_Arr_Rel_Insert_Input = {
  data: Array<Config_Status_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Config_Status_On_Conflict>;
};

/** Boolean expression to filter rows from the table "config_status". All fields are combined with a logical 'AND'. */
export type Config_Status_Bool_Exp = {
  _and?: Maybe<Array<Config_Status_Bool_Exp>>;
  _not?: Maybe<Config_Status_Bool_Exp>;
  _or?: Maybe<Array<Config_Status_Bool_Exp>>;
  hash?: Maybe<String_Comparison_Exp>;
  is_active?: Maybe<Boolean_Comparison_Exp>;
  message?: Maybe<String_Comparison_Exp>;
  tenant?: Maybe<Tenant_Bool_Exp>;
  tenant_id?: Maybe<Uuid_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  worker_id?: Maybe<Uuid_Comparison_Exp>;
  worker_state?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "config_status" */
export enum Config_Status_Constraint {
  /** unique or primary key constraint on columns "tenant_id", "hash", "worker_id" */
  ConfigStatusPkey = 'config_status_pkey',
}

/** input type for inserting data into table "config_status" */
export type Config_Status_Insert_Input = {
  hash?: Maybe<Scalars['String']>;
  is_active?: Maybe<Scalars['Boolean']>;
  message?: Maybe<Scalars['String']>;
  tenant?: Maybe<Tenant_Obj_Rel_Insert_Input>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Config_Status_Max_Fields = {
  __typename?: 'config_status_max_fields';
  hash?: Maybe<Scalars['String']>;
  message?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** order by max() on columns of table "config_status" */
export type Config_Status_Max_Order_By = {
  hash?: Maybe<Order_By>;
  message?: Maybe<Order_By>;
  tenant_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Config_Status_Min_Fields = {
  __typename?: 'config_status_min_fields';
  hash?: Maybe<Scalars['String']>;
  message?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** order by min() on columns of table "config_status" */
export type Config_Status_Min_Order_By = {
  hash?: Maybe<Order_By>;
  message?: Maybe<Order_By>;
  tenant_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "config_status" */
export type Config_Status_Mutation_Response = {
  __typename?: 'config_status_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Config_Status>;
};

/** on_conflict condition type for table "config_status" */
export type Config_Status_On_Conflict = {
  constraint: Config_Status_Constraint;
  update_columns?: Array<Config_Status_Update_Column>;
  where?: Maybe<Config_Status_Bool_Exp>;
};

/** Ordering options when selecting data from "config_status". */
export type Config_Status_Order_By = {
  hash?: Maybe<Order_By>;
  is_active?: Maybe<Order_By>;
  message?: Maybe<Order_By>;
  tenant?: Maybe<Tenant_Order_By>;
  tenant_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
  worker_state?: Maybe<Order_By>;
};

/** primary key columns input for table: config_status */
export type Config_Status_Pk_Columns_Input = {
  hash: Scalars['String'];
  tenant_id: Scalars['uuid'];
  worker_id: Scalars['uuid'];
};

/** select columns of table "config_status" */
export enum Config_Status_Select_Column {
  /** column name */
  Hash = 'hash',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  Message = 'message',
  /** column name */
  TenantId = 'tenant_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  WorkerId = 'worker_id',
}

/** select "config_status_aggregate_bool_exp_bool_and_arguments_columns" columns of table "config_status" */
export enum Config_Status_Select_Column_Config_Status_Aggregate_Bool_Exp_Bool_And_Arguments_Columns {
  /** column name */
  IsActive = 'is_active',
}

/** select "config_status_aggregate_bool_exp_bool_or_arguments_columns" columns of table "config_status" */
export enum Config_Status_Select_Column_Config_Status_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns {
  /** column name */
  IsActive = 'is_active',
}

/** input type for updating data in table "config_status" */
export type Config_Status_Set_Input = {
  hash?: Maybe<Scalars['String']>;
  is_active?: Maybe<Scalars['Boolean']>;
  message?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** Streaming cursor of the table "config_status" */
export type Config_Status_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Config_Status_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Config_Status_Stream_Cursor_Value_Input = {
  hash?: Maybe<Scalars['String']>;
  is_active?: Maybe<Scalars['Boolean']>;
  message?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** update columns of table "config_status" */
export enum Config_Status_Update_Column {
  /** column name */
  Hash = 'hash',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  Message = 'message',
  /** column name */
  TenantId = 'tenant_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  WorkerId = 'worker_id',
}

export type Config_Status_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Config_Status_Set_Input>;
  /** filter the rows which have to be updated */
  where: Config_Status_Bool_Exp;
};

/** Streaming cursor of the table "config" */
export type Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Config_Stream_Cursor_Value_Input = {
  hash?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  vault_path?: Maybe<Scalars['String']>;
};

/** update columns of table "config" */
export enum Config_Update_Column {
  /** column name */
  Hash = 'hash',
  /** column name */
  TenantId = 'tenant_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  VaultPath = 'vault_path',
}

export type Config_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Config_Bool_Exp;
};

/** This table contains configuration of custom connectors added by users.  */
export type Connector_Config = {
  __typename?: 'connector_config';
  created_at: Scalars['timestamptz'];
  created_by: Scalars['uuid'];
  deployment_url?: Maybe<Scalars['String']>;
  id: Scalars['uuid'];
  is_deleted: Scalars['Boolean'];
  name: Scalars['String'];
  project_id: Scalars['uuid'];
  source_url: Scalars['String'];
  updated_at: Scalars['timestamptz'];
};

/** aggregated selection of "connector_config" */
export type Connector_Config_Aggregate = {
  __typename?: 'connector_config_aggregate';
  aggregate?: Maybe<Connector_Config_Aggregate_Fields>;
  nodes: Array<Connector_Config>;
};

/** aggregate fields of "connector_config" */
export type Connector_Config_Aggregate_Fields = {
  __typename?: 'connector_config_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Connector_Config_Max_Fields>;
  min?: Maybe<Connector_Config_Min_Fields>;
};

/** aggregate fields of "connector_config" */
export type Connector_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Connector_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "connector_config". All fields are combined with a logical 'AND'. */
export type Connector_Config_Bool_Exp = {
  _and?: Maybe<Array<Connector_Config_Bool_Exp>>;
  _not?: Maybe<Connector_Config_Bool_Exp>;
  _or?: Maybe<Array<Connector_Config_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  created_by?: Maybe<Uuid_Comparison_Exp>;
  deployment_url?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  is_deleted?: Maybe<Boolean_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  source_url?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "connector_config" */
export enum Connector_Config_Constraint {
  /** unique or primary key constraint on columns "name" */
  ConnectorConfigNameKey = 'connector_config_name_key',
  /** unique or primary key constraint on columns "id" */
  ConnectorConfigPkey = 'connector_config_pkey',
}

/** input type for inserting data into table "connector_config" */
export type Connector_Config_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  deployment_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  is_deleted?: Maybe<Scalars['Boolean']>;
  name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  source_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Connector_Config_Max_Fields = {
  __typename?: 'connector_config_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  deployment_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  source_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Connector_Config_Min_Fields = {
  __typename?: 'connector_config_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  deployment_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  source_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "connector_config" */
export type Connector_Config_Mutation_Response = {
  __typename?: 'connector_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Connector_Config>;
};

/** on_conflict condition type for table "connector_config" */
export type Connector_Config_On_Conflict = {
  constraint: Connector_Config_Constraint;
  update_columns?: Array<Connector_Config_Update_Column>;
  where?: Maybe<Connector_Config_Bool_Exp>;
};

/** Ordering options when selecting data from "connector_config". */
export type Connector_Config_Order_By = {
  created_at?: Maybe<Order_By>;
  created_by?: Maybe<Order_By>;
  deployment_url?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  is_deleted?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  source_url?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: connector_config */
export type Connector_Config_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "connector_config" */
export enum Connector_Config_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedBy = 'created_by',
  /** column name */
  DeploymentUrl = 'deployment_url',
  /** column name */
  Id = 'id',
  /** column name */
  IsDeleted = 'is_deleted',
  /** column name */
  Name = 'name',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  SourceUrl = 'source_url',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "connector_config" */
export type Connector_Config_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  deployment_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  is_deleted?: Maybe<Scalars['Boolean']>;
  name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  source_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "connector_config" */
export type Connector_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Connector_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Connector_Config_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  deployment_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  is_deleted?: Maybe<Scalars['Boolean']>;
  name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  source_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "connector_config" */
export enum Connector_Config_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedBy = 'created_by',
  /** column name */
  DeploymentUrl = 'deployment_url',
  /** column name */
  Id = 'id',
  /** column name */
  IsDeleted = 'is_deleted',
  /** column name */
  Name = 'name',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  SourceUrl = 'source_url',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Connector_Config_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Connector_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Connector_Config_Bool_Exp;
};

/** This table contains configuration of custom connectors deployed by users.  */
export type Connector_Connector_Deployment = {
  __typename?: 'connector_connector_deployment';
  build_logs_url?: Maybe<Scalars['String']>;
  cloud_run_url?: Maybe<Scalars['String']>;
  config_file?: Maybe<Scalars['String']>;
  created_at: Scalars['connector_timestamptz'];
  created_by: Scalars['connector_uuid'];
  error?: Maybe<Scalars['String']>;
  gcs_url?: Maybe<Scalars['String']>;
  id: Scalars['connector_uuid'];
  image_url?: Maybe<Scalars['String']>;
  name: Scalars['String'];
  source_url: Scalars['String'];
  status: Scalars['connector_deployment_status'];
  updated_at: Scalars['connector_timestamptz'];
  user_id: Scalars['connector_uuid'];
};

/** aggregated selection of "connector_deployment" */
export type Connector_Connector_Deployment_Aggregate = {
  __typename?: 'connector_connector_deployment_aggregate';
  aggregate?: Maybe<Connector_Connector_Deployment_Aggregate_Fields>;
  nodes: Array<Connector_Connector_Deployment>;
};

/** aggregate fields of "connector_deployment" */
export type Connector_Connector_Deployment_Aggregate_Fields = {
  __typename?: 'connector_connector_deployment_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Connector_Connector_Deployment_Max_Fields>;
  min?: Maybe<Connector_Connector_Deployment_Min_Fields>;
};

/** aggregate fields of "connector_deployment" */
export type Connector_Connector_Deployment_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Connector_Connector_Deployment_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "connector_deployment". All fields are combined with a logical 'AND'. */
export type Connector_Connector_Deployment_Bool_Exp = {
  _and?: Maybe<Array<Connector_Connector_Deployment_Bool_Exp>>;
  _not?: Maybe<Connector_Connector_Deployment_Bool_Exp>;
  _or?: Maybe<Array<Connector_Connector_Deployment_Bool_Exp>>;
  build_logs_url?: Maybe<Connector_String_Comparison_Exp>;
  cloud_run_url?: Maybe<Connector_String_Comparison_Exp>;
  config_file?: Maybe<Connector_String_Comparison_Exp>;
  created_at?: Maybe<Connector_Timestamptz_Comparison_Exp>;
  created_by?: Maybe<Connector_Uuid_Comparison_Exp>;
  error?: Maybe<Connector_String_Comparison_Exp>;
  gcs_url?: Maybe<Connector_String_Comparison_Exp>;
  id?: Maybe<Connector_Uuid_Comparison_Exp>;
  image_url?: Maybe<Connector_String_Comparison_Exp>;
  name?: Maybe<Connector_String_Comparison_Exp>;
  source_url?: Maybe<Connector_String_Comparison_Exp>;
  status?: Maybe<Connector_Deployment_Status_Comparison_Exp>;
  updated_at?: Maybe<Connector_Timestamptz_Comparison_Exp>;
  user_id?: Maybe<Connector_Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "connector_deployment" */
export enum Connector_Connector_Deployment_Constraint {
  /** unique or primary key constraint on columns "id" */
  ConnectorDeploymentPkey = 'connector_deployment_pkey',
  /** unique or primary key constraint on columns "user_id", "name" */
  UniqueNameWithinUser = 'unique_name_within_user',
}

/** input type for inserting data into table "connector_deployment" */
export type Connector_Connector_Deployment_Insert_Input = {
  build_logs_url?: Maybe<Scalars['String']>;
  cloud_run_url?: Maybe<Scalars['String']>;
  config_file?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['connector_timestamptz']>;
  created_by?: Maybe<Scalars['connector_uuid']>;
  error?: Maybe<Scalars['String']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['connector_uuid']>;
  image_url?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  source_url?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['connector_deployment_status']>;
  updated_at?: Maybe<Scalars['connector_timestamptz']>;
  user_id?: Maybe<Scalars['connector_uuid']>;
};

/** aggregate max on columns */
export type Connector_Connector_Deployment_Max_Fields = {
  __typename?: 'connector_connector_deployment_max_fields';
  build_logs_url?: Maybe<Scalars['String']>;
  cloud_run_url?: Maybe<Scalars['String']>;
  config_file?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['connector_timestamptz']>;
  created_by?: Maybe<Scalars['connector_uuid']>;
  error?: Maybe<Scalars['String']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['connector_uuid']>;
  image_url?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  source_url?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['connector_deployment_status']>;
  updated_at?: Maybe<Scalars['connector_timestamptz']>;
  user_id?: Maybe<Scalars['connector_uuid']>;
};

/** aggregate min on columns */
export type Connector_Connector_Deployment_Min_Fields = {
  __typename?: 'connector_connector_deployment_min_fields';
  build_logs_url?: Maybe<Scalars['String']>;
  cloud_run_url?: Maybe<Scalars['String']>;
  config_file?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['connector_timestamptz']>;
  created_by?: Maybe<Scalars['connector_uuid']>;
  error?: Maybe<Scalars['String']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['connector_uuid']>;
  image_url?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  source_url?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['connector_deployment_status']>;
  updated_at?: Maybe<Scalars['connector_timestamptz']>;
  user_id?: Maybe<Scalars['connector_uuid']>;
};

/** response of any mutation on the table "connector_deployment" */
export type Connector_Connector_Deployment_Mutation_Response = {
  __typename?: 'connector_connector_deployment_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Connector_Connector_Deployment>;
};

/** on_conflict condition type for table "connector_deployment" */
export type Connector_Connector_Deployment_On_Conflict = {
  constraint: Connector_Connector_Deployment_Constraint;
  update_columns?: Array<Connector_Connector_Deployment_Update_Column>;
  where?: Maybe<Connector_Connector_Deployment_Bool_Exp>;
};

/** Ordering options when selecting data from "connector_deployment". */
export type Connector_Connector_Deployment_Order_By = {
  build_logs_url?: Maybe<Connector_Order_By>;
  cloud_run_url?: Maybe<Connector_Order_By>;
  config_file?: Maybe<Connector_Order_By>;
  created_at?: Maybe<Connector_Order_By>;
  created_by?: Maybe<Connector_Order_By>;
  error?: Maybe<Connector_Order_By>;
  gcs_url?: Maybe<Connector_Order_By>;
  id?: Maybe<Connector_Order_By>;
  image_url?: Maybe<Connector_Order_By>;
  name?: Maybe<Connector_Order_By>;
  source_url?: Maybe<Connector_Order_By>;
  status?: Maybe<Connector_Order_By>;
  updated_at?: Maybe<Connector_Order_By>;
  user_id?: Maybe<Connector_Order_By>;
};

/** primary key columns input for table: connector_deployment */
export type Connector_Connector_Deployment_Pk_Columns_Input = {
  id: Scalars['connector_uuid'];
};

/** select columns of table "connector_deployment" */
export enum Connector_Connector_Deployment_Select_Column {
  /** column name */
  BuildLogsUrl = 'build_logs_url',
  /** column name */
  CloudRunUrl = 'cloud_run_url',
  /** column name */
  ConfigFile = 'config_file',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedBy = 'created_by',
  /** column name */
  Error = 'error',
  /** column name */
  GcsUrl = 'gcs_url',
  /** column name */
  Id = 'id',
  /** column name */
  ImageUrl = 'image_url',
  /** column name */
  Name = 'name',
  /** column name */
  SourceUrl = 'source_url',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
}

/** input type for updating data in table "connector_deployment" */
export type Connector_Connector_Deployment_Set_Input = {
  build_logs_url?: Maybe<Scalars['String']>;
  cloud_run_url?: Maybe<Scalars['String']>;
  config_file?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['connector_timestamptz']>;
  created_by?: Maybe<Scalars['connector_uuid']>;
  error?: Maybe<Scalars['String']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['connector_uuid']>;
  image_url?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  source_url?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['connector_deployment_status']>;
  updated_at?: Maybe<Scalars['connector_timestamptz']>;
  user_id?: Maybe<Scalars['connector_uuid']>;
};

/** Streaming cursor of the table "connector_deployment" */
export type Connector_Connector_Deployment_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Connector_Connector_Deployment_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Connector_Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Connector_Connector_Deployment_Stream_Cursor_Value_Input = {
  build_logs_url?: Maybe<Scalars['String']>;
  cloud_run_url?: Maybe<Scalars['String']>;
  config_file?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['connector_timestamptz']>;
  created_by?: Maybe<Scalars['connector_uuid']>;
  error?: Maybe<Scalars['String']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['connector_uuid']>;
  image_url?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  source_url?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['connector_deployment_status']>;
  updated_at?: Maybe<Scalars['connector_timestamptz']>;
  user_id?: Maybe<Scalars['connector_uuid']>;
};

/** update columns of table "connector_deployment" */
export enum Connector_Connector_Deployment_Update_Column {
  /** column name */
  BuildLogsUrl = 'build_logs_url',
  /** column name */
  CloudRunUrl = 'cloud_run_url',
  /** column name */
  ConfigFile = 'config_file',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedBy = 'created_by',
  /** column name */
  Error = 'error',
  /** column name */
  GcsUrl = 'gcs_url',
  /** column name */
  Id = 'id',
  /** column name */
  ImageUrl = 'image_url',
  /** column name */
  Name = 'name',
  /** column name */
  SourceUrl = 'source_url',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
}

export type Connector_Connector_Deployment_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Connector_Connector_Deployment_Set_Input>;
  /** filter the rows which have to be updated */
  where: Connector_Connector_Deployment_Bool_Exp;
};

/** ordering argument of a cursor */
export enum Connector_Cursor_Ordering {
  /** ascending ordering of the cursor */
  Asc = 'ASC',
  /** descending ordering of the cursor */
  Desc = 'DESC',
}

/** Boolean expression to compare columns of type "deployment_status". All fields are combined with logical 'AND'. */
export type Connector_Deployment_Status_Comparison_Exp = {
  _eq?: Maybe<Scalars['connector_deployment_status']>;
  _gt?: Maybe<Scalars['connector_deployment_status']>;
  _gte?: Maybe<Scalars['connector_deployment_status']>;
  _in?: Maybe<Array<Scalars['connector_deployment_status']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['connector_deployment_status']>;
  _lte?: Maybe<Scalars['connector_deployment_status']>;
  _neq?: Maybe<Scalars['connector_deployment_status']>;
  _nin?: Maybe<Array<Scalars['connector_deployment_status']>>;
};

/** Each entry in this table corresponds to a deployment made for a custom connector configure by the user. */
export type Connector_Deployments = {
  __typename?: 'connector_deployments';
  cloud_run_url?: Maybe<Scalars['String']>;
  connector_id: Scalars['uuid'];
  created_at: Scalars['timestamptz'];
  created_by: Scalars['uuid'];
  gcs_url?: Maybe<Scalars['String']>;
  id: Scalars['uuid'];
  image_url?: Maybe<Scalars['String']>;
  updated_at: Scalars['timestamptz'];
};

/** aggregated selection of "connector_deployments" */
export type Connector_Deployments_Aggregate = {
  __typename?: 'connector_deployments_aggregate';
  aggregate?: Maybe<Connector_Deployments_Aggregate_Fields>;
  nodes: Array<Connector_Deployments>;
};

/** aggregate fields of "connector_deployments" */
export type Connector_Deployments_Aggregate_Fields = {
  __typename?: 'connector_deployments_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Connector_Deployments_Max_Fields>;
  min?: Maybe<Connector_Deployments_Min_Fields>;
};

/** aggregate fields of "connector_deployments" */
export type Connector_Deployments_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Connector_Deployments_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "connector_deployments". All fields are combined with a logical 'AND'. */
export type Connector_Deployments_Bool_Exp = {
  _and?: Maybe<Array<Connector_Deployments_Bool_Exp>>;
  _not?: Maybe<Connector_Deployments_Bool_Exp>;
  _or?: Maybe<Array<Connector_Deployments_Bool_Exp>>;
  cloud_run_url?: Maybe<String_Comparison_Exp>;
  connector_id?: Maybe<Uuid_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  created_by?: Maybe<Uuid_Comparison_Exp>;
  gcs_url?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  image_url?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "connector_deployments" */
export enum Connector_Deployments_Constraint {
  /** unique or primary key constraint on columns "id" */
  ConnectorDeploymentsPkey = 'connector_deployments_pkey',
}

/** input type for inserting data into table "connector_deployments" */
export type Connector_Deployments_Insert_Input = {
  cloud_run_url?: Maybe<Scalars['String']>;
  connector_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  image_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Connector_Deployments_Max_Fields = {
  __typename?: 'connector_deployments_max_fields';
  cloud_run_url?: Maybe<Scalars['String']>;
  connector_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  image_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Connector_Deployments_Min_Fields = {
  __typename?: 'connector_deployments_min_fields';
  cloud_run_url?: Maybe<Scalars['String']>;
  connector_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  image_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "connector_deployments" */
export type Connector_Deployments_Mutation_Response = {
  __typename?: 'connector_deployments_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Connector_Deployments>;
};

/** on_conflict condition type for table "connector_deployments" */
export type Connector_Deployments_On_Conflict = {
  constraint: Connector_Deployments_Constraint;
  update_columns?: Array<Connector_Deployments_Update_Column>;
  where?: Maybe<Connector_Deployments_Bool_Exp>;
};

/** Ordering options when selecting data from "connector_deployments". */
export type Connector_Deployments_Order_By = {
  cloud_run_url?: Maybe<Order_By>;
  connector_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  created_by?: Maybe<Order_By>;
  gcs_url?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  image_url?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: connector_deployments */
export type Connector_Deployments_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "connector_deployments" */
export enum Connector_Deployments_Select_Column {
  /** column name */
  CloudRunUrl = 'cloud_run_url',
  /** column name */
  ConnectorId = 'connector_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedBy = 'created_by',
  /** column name */
  GcsUrl = 'gcs_url',
  /** column name */
  Id = 'id',
  /** column name */
  ImageUrl = 'image_url',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "connector_deployments" */
export type Connector_Deployments_Set_Input = {
  cloud_run_url?: Maybe<Scalars['String']>;
  connector_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  image_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "connector_deployments" */
export type Connector_Deployments_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Connector_Deployments_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Connector_Deployments_Stream_Cursor_Value_Input = {
  cloud_run_url?: Maybe<Scalars['String']>;
  connector_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by?: Maybe<Scalars['uuid']>;
  gcs_url?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  image_url?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "connector_deployments" */
export enum Connector_Deployments_Update_Column {
  /** column name */
  CloudRunUrl = 'cloud_run_url',
  /** column name */
  ConnectorId = 'connector_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedBy = 'created_by',
  /** column name */
  GcsUrl = 'gcs_url',
  /** column name */
  Id = 'id',
  /** column name */
  ImageUrl = 'image_url',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Connector_Deployments_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Connector_Deployments_Set_Input>;
  /** filter the rows which have to be updated */
  where: Connector_Deployments_Bool_Exp;
};

/** column ordering options */
export enum Connector_Order_By {
  /** in ascending order, nulls last */
  Asc = 'asc',
  /** in ascending order, nulls first */
  AscNullsFirst = 'asc_nulls_first',
  /** in ascending order, nulls last */
  AscNullsLast = 'asc_nulls_last',
  /** in descending order, nulls first */
  Desc = 'desc',
  /** in descending order, nulls first */
  DescNullsFirst = 'desc_nulls_first',
  /** in descending order, nulls last */
  DescNullsLast = 'desc_nulls_last',
}

/** Boolean expression to compare columns of type "String". All fields are combined with logical 'AND'. */
export type Connector_String_Comparison_Exp = {
  _eq?: Maybe<Scalars['String']>;
  _gt?: Maybe<Scalars['String']>;
  _gte?: Maybe<Scalars['String']>;
  /** does the column match the given case-insensitive pattern */
  _ilike?: Maybe<Scalars['String']>;
  _in?: Maybe<Array<Scalars['String']>>;
  /** does the column match the given POSIX regular expression, case insensitive */
  _iregex?: Maybe<Scalars['String']>;
  _is_null?: Maybe<Scalars['Boolean']>;
  /** does the column match the given pattern */
  _like?: Maybe<Scalars['String']>;
  _lt?: Maybe<Scalars['String']>;
  _lte?: Maybe<Scalars['String']>;
  _neq?: Maybe<Scalars['String']>;
  /** does the column NOT match the given case-insensitive pattern */
  _nilike?: Maybe<Scalars['String']>;
  _nin?: Maybe<Array<Scalars['String']>>;
  /** does the column NOT match the given POSIX regular expression, case insensitive */
  _niregex?: Maybe<Scalars['String']>;
  /** does the column NOT match the given pattern */
  _nlike?: Maybe<Scalars['String']>;
  /** does the column NOT match the given POSIX regular expression, case sensitive */
  _nregex?: Maybe<Scalars['String']>;
  /** does the column NOT match the given SQL regular expression */
  _nsimilar?: Maybe<Scalars['String']>;
  /** does the column match the given POSIX regular expression, case sensitive */
  _regex?: Maybe<Scalars['String']>;
  /** does the column match the given SQL regular expression */
  _similar?: Maybe<Scalars['String']>;
};

/** Boolean expression to compare columns of type "timestamptz". All fields are combined with logical 'AND'. */
export type Connector_Timestamptz_Comparison_Exp = {
  _eq?: Maybe<Scalars['connector_timestamptz']>;
  _gt?: Maybe<Scalars['connector_timestamptz']>;
  _gte?: Maybe<Scalars['connector_timestamptz']>;
  _in?: Maybe<Array<Scalars['connector_timestamptz']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['connector_timestamptz']>;
  _lte?: Maybe<Scalars['connector_timestamptz']>;
  _neq?: Maybe<Scalars['connector_timestamptz']>;
  _nin?: Maybe<Array<Scalars['connector_timestamptz']>>;
};

/** Boolean expression to compare columns of type "uuid". All fields are combined with logical 'AND'. */
export type Connector_Uuid_Comparison_Exp = {
  _eq?: Maybe<Scalars['connector_uuid']>;
  _gt?: Maybe<Scalars['connector_uuid']>;
  _gte?: Maybe<Scalars['connector_uuid']>;
  _in?: Maybe<Array<Scalars['connector_uuid']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['connector_uuid']>;
  _lte?: Maybe<Scalars['connector_uuid']>;
  _neq?: Maybe<Scalars['connector_uuid']>;
  _nin?: Maybe<Array<Scalars['connector_uuid']>>;
};

export type ConvertPlanResponse = {
  __typename?: 'ConvertPlanResponse';
  status: Scalars['String'];
};

/** Coupon for Hasura Cloud discount */
export type Coupon = {
  __typename?: 'coupon';
  /** email of users which are allowed to use the coupon */
  allowed_customer?: Maybe<Scalars['jsonb']>;
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Int']>;
  /** case insensitive text that represents a unique customer facing code that will be used to get the benefit */
  code: Scalars['citext'];
  /** unique coupon id, represents coupon id at stripe. Internal column */
  coupon_id?: Maybe<Scalars['String']>;
  /** only USD is supported at the moment. Default to USD */
  currency?: Maybe<Scalars['String']>;
  /** represents the duration applicable for a particular coupon. Valid values `once`, `forever`, `repeating` */
  duration?: Maybe<Coupon_Duration_Enum>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Int']>;
  expires_at: Scalars['timestamptz'];
  /** randomly generated uuid */
  id: Scalars['uuid'];
  /**
   * represents the state of a particular coupon, whether it is active and can be
   * redeemed or not. This is a global flag to mark a particular coupon
   * active/inactive probably in the middle of a campaign etc. Defaults to true
   */
  is_active: Scalars['Boolean'];
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions: Scalars['Int'];
  /** represents human readable name for a particular coupon */
  name: Scalars['String'];
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption: Scalars['Int'];
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['numeric']>;
  /** unique id, represents promotion id at stripe. Internal column */
  promotional_code_id?: Maybe<Scalars['String']>;
  stripe_error?: Maybe<Scalars['String']>;
  /** represents the type of a coupon. Valid values are `credit` or `coupon` */
  type: Coupon_Type_Enum;
  /** An array relationship */
  user_coupons: Array<User_Coupon>;
  /** An aggregate relationship */
  user_coupons_aggregate: User_Coupon_Aggregate;
};

/** Coupon for Hasura Cloud discount */
export type CouponAllowed_CustomerArgs = {
  path?: Maybe<Scalars['String']>;
};

/** Coupon for Hasura Cloud discount */
export type CouponUser_CouponsArgs = {
  distinct_on?: Maybe<Array<User_Coupon_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<User_Coupon_Order_By>>;
  where?: Maybe<User_Coupon_Bool_Exp>;
};

/** Coupon for Hasura Cloud discount */
export type CouponUser_Coupons_AggregateArgs = {
  distinct_on?: Maybe<Array<User_Coupon_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<User_Coupon_Order_By>>;
  where?: Maybe<User_Coupon_Bool_Exp>;
};

/** aggregated selection of "coupon" */
export type Coupon_Aggregate = {
  __typename?: 'coupon_aggregate';
  aggregate?: Maybe<Coupon_Aggregate_Fields>;
  nodes: Array<Coupon>;
};

export type Coupon_Aggregate_Bool_Exp = {
  bool_and?: Maybe<Coupon_Aggregate_Bool_Exp_Bool_And>;
  bool_or?: Maybe<Coupon_Aggregate_Bool_Exp_Bool_Or>;
  count?: Maybe<Coupon_Aggregate_Bool_Exp_Count>;
};

export type Coupon_Aggregate_Bool_Exp_Bool_And = {
  arguments: Coupon_Select_Column_Coupon_Aggregate_Bool_Exp_Bool_And_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Coupon_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Coupon_Aggregate_Bool_Exp_Bool_Or = {
  arguments: Coupon_Select_Column_Coupon_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Coupon_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Coupon_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Coupon_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Coupon_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "coupon" */
export type Coupon_Aggregate_Fields = {
  __typename?: 'coupon_aggregate_fields';
  avg?: Maybe<Coupon_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Coupon_Max_Fields>;
  min?: Maybe<Coupon_Min_Fields>;
  stddev?: Maybe<Coupon_Stddev_Fields>;
  stddev_pop?: Maybe<Coupon_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Coupon_Stddev_Samp_Fields>;
  sum?: Maybe<Coupon_Sum_Fields>;
  var_pop?: Maybe<Coupon_Var_Pop_Fields>;
  var_samp?: Maybe<Coupon_Var_Samp_Fields>;
  variance?: Maybe<Coupon_Variance_Fields>;
};

/** aggregate fields of "coupon" */
export type Coupon_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Coupon_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "coupon" */
export type Coupon_Aggregate_Order_By = {
  avg?: Maybe<Coupon_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Coupon_Max_Order_By>;
  min?: Maybe<Coupon_Min_Order_By>;
  stddev?: Maybe<Coupon_Stddev_Order_By>;
  stddev_pop?: Maybe<Coupon_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Coupon_Stddev_Samp_Order_By>;
  sum?: Maybe<Coupon_Sum_Order_By>;
  var_pop?: Maybe<Coupon_Var_Pop_Order_By>;
  var_samp?: Maybe<Coupon_Var_Samp_Order_By>;
  variance?: Maybe<Coupon_Variance_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Coupon_Append_Input = {
  /** email of users which are allowed to use the coupon */
  allowed_customer?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "coupon" */
export type Coupon_Arr_Rel_Insert_Input = {
  data: Array<Coupon_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Coupon_On_Conflict>;
};

/** aggregate avg on columns */
export type Coupon_Avg_Fields = {
  __typename?: 'coupon_avg_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Float']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Float']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Float']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Float']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "coupon" */
export type Coupon_Avg_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
};

/** Boolean expression to filter rows from the table "coupon". All fields are combined with a logical 'AND'. */
export type Coupon_Bool_Exp = {
  _and?: Maybe<Array<Coupon_Bool_Exp>>;
  _not?: Maybe<Coupon_Bool_Exp>;
  _or?: Maybe<Array<Coupon_Bool_Exp>>;
  allowed_customer?: Maybe<Jsonb_Comparison_Exp>;
  amount_off?: Maybe<Int_Comparison_Exp>;
  code?: Maybe<Citext_Comparison_Exp>;
  coupon_id?: Maybe<String_Comparison_Exp>;
  currency?: Maybe<String_Comparison_Exp>;
  duration?: Maybe<Coupon_Duration_Enum_Comparison_Exp>;
  duration_in_months?: Maybe<Int_Comparison_Exp>;
  expires_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  is_active?: Maybe<Boolean_Comparison_Exp>;
  max_redemptions?: Maybe<Int_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  per_customer_max_redemption?: Maybe<Int_Comparison_Exp>;
  percentage_off?: Maybe<Numeric_Comparison_Exp>;
  promotional_code_id?: Maybe<String_Comparison_Exp>;
  stripe_error?: Maybe<String_Comparison_Exp>;
  type?: Maybe<Coupon_Type_Enum_Comparison_Exp>;
  user_coupons?: Maybe<User_Coupon_Bool_Exp>;
  user_coupons_aggregate?: Maybe<User_Coupon_Aggregate_Bool_Exp>;
};

/** unique or primary key constraints on table "coupon" */
export enum Coupon_Constraint {
  /** unique or primary key constraint on columns "code" */
  CouponCodeKey = 'coupon_code_key',
  /** unique or primary key constraint on columns "coupon_id" */
  CouponCouponIdKey = 'coupon_coupon_id_key',
  /** unique or primary key constraint on columns "id" */
  CouponPkey = 'coupon_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Coupon_Delete_At_Path_Input = {
  /** email of users which are allowed to use the coupon */
  allowed_customer?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Coupon_Delete_Elem_Input = {
  /** email of users which are allowed to use the coupon */
  allowed_customer?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Coupon_Delete_Key_Input = {
  /** email of users which are allowed to use the coupon */
  allowed_customer?: Maybe<Scalars['String']>;
};

/** Hasura enum to capture supported duration values. This enum is used in coupon table */
export type Coupon_Duration = {
  __typename?: 'coupon_duration';
  comment: Scalars['String'];
  /** fetch data from the table: "coupon" */
  coupon: Array<Coupon>;
  /** fetch aggregated fields from the table: "coupon" */
  coupon_aggregate: Coupon_Aggregate;
  duration: Scalars['String'];
};

/** Hasura enum to capture supported duration values. This enum is used in coupon table */
export type Coupon_DurationCouponArgs = {
  distinct_on?: Maybe<Array<Coupon_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Coupon_Order_By>>;
  where?: Maybe<Coupon_Bool_Exp>;
};

/** Hasura enum to capture supported duration values. This enum is used in coupon table */
export type Coupon_DurationCoupon_AggregateArgs = {
  distinct_on?: Maybe<Array<Coupon_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Coupon_Order_By>>;
  where?: Maybe<Coupon_Bool_Exp>;
};

/** aggregated selection of "coupon_duration" */
export type Coupon_Duration_Aggregate = {
  __typename?: 'coupon_duration_aggregate';
  aggregate?: Maybe<Coupon_Duration_Aggregate_Fields>;
  nodes: Array<Coupon_Duration>;
};

/** aggregate fields of "coupon_duration" */
export type Coupon_Duration_Aggregate_Fields = {
  __typename?: 'coupon_duration_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Coupon_Duration_Max_Fields>;
  min?: Maybe<Coupon_Duration_Min_Fields>;
};

/** aggregate fields of "coupon_duration" */
export type Coupon_Duration_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Coupon_Duration_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "coupon_duration". All fields are combined with a logical 'AND'. */
export type Coupon_Duration_Bool_Exp = {
  _and?: Maybe<Array<Coupon_Duration_Bool_Exp>>;
  _not?: Maybe<Coupon_Duration_Bool_Exp>;
  _or?: Maybe<Array<Coupon_Duration_Bool_Exp>>;
  comment?: Maybe<String_Comparison_Exp>;
  coupon?: Maybe<Coupon_Bool_Exp>;
  coupon_aggregate?: Maybe<Coupon_Aggregate_Bool_Exp>;
  duration?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "coupon_duration" */
export enum Coupon_Duration_Constraint {
  /** unique or primary key constraint on columns "duration" */
  CouponDurationPkey = 'coupon_duration_pkey',
}

export enum Coupon_Duration_Enum {
  /** coupon will be applied forever */
  Forever = 'forever',
  /** coupon will be applied once */
  Once = 'once',
  /** coupon will be applied for mutiple times */
  Repeating = 'repeating',
}

/** Boolean expression to compare columns of type "coupon_duration_enum". All fields are combined with logical 'AND'. */
export type Coupon_Duration_Enum_Comparison_Exp = {
  _eq?: Maybe<Coupon_Duration_Enum>;
  _in?: Maybe<Array<Coupon_Duration_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Coupon_Duration_Enum>;
  _nin?: Maybe<Array<Coupon_Duration_Enum>>;
};

/** input type for inserting data into table "coupon_duration" */
export type Coupon_Duration_Insert_Input = {
  comment?: Maybe<Scalars['String']>;
  coupon?: Maybe<Coupon_Arr_Rel_Insert_Input>;
  duration?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Coupon_Duration_Max_Fields = {
  __typename?: 'coupon_duration_max_fields';
  comment?: Maybe<Scalars['String']>;
  duration?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Coupon_Duration_Min_Fields = {
  __typename?: 'coupon_duration_min_fields';
  comment?: Maybe<Scalars['String']>;
  duration?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "coupon_duration" */
export type Coupon_Duration_Mutation_Response = {
  __typename?: 'coupon_duration_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Coupon_Duration>;
};

/** on_conflict condition type for table "coupon_duration" */
export type Coupon_Duration_On_Conflict = {
  constraint: Coupon_Duration_Constraint;
  update_columns?: Array<Coupon_Duration_Update_Column>;
  where?: Maybe<Coupon_Duration_Bool_Exp>;
};

/** Ordering options when selecting data from "coupon_duration". */
export type Coupon_Duration_Order_By = {
  comment?: Maybe<Order_By>;
  coupon_aggregate?: Maybe<Coupon_Aggregate_Order_By>;
  duration?: Maybe<Order_By>;
};

/** primary key columns input for table: coupon_duration */
export type Coupon_Duration_Pk_Columns_Input = {
  duration: Scalars['String'];
};

/** select columns of table "coupon_duration" */
export enum Coupon_Duration_Select_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Duration = 'duration',
}

/** input type for updating data in table "coupon_duration" */
export type Coupon_Duration_Set_Input = {
  comment?: Maybe<Scalars['String']>;
  duration?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "coupon_duration" */
export type Coupon_Duration_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Coupon_Duration_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Coupon_Duration_Stream_Cursor_Value_Input = {
  comment?: Maybe<Scalars['String']>;
  duration?: Maybe<Scalars['String']>;
};

/** update columns of table "coupon_duration" */
export enum Coupon_Duration_Update_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Duration = 'duration',
}

export type Coupon_Duration_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Coupon_Duration_Set_Input>;
  /** filter the rows which have to be updated */
  where: Coupon_Duration_Bool_Exp;
};

/** input type for incrementing numeric columns in table "coupon" */
export type Coupon_Inc_Input = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Int']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Int']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Int']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Int']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['numeric']>;
};

/** input type for inserting data into table "coupon" */
export type Coupon_Insert_Input = {
  /** email of users which are allowed to use the coupon */
  allowed_customer?: Maybe<Scalars['jsonb']>;
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Int']>;
  /** case insensitive text that represents a unique customer facing code that will be used to get the benefit */
  code?: Maybe<Scalars['citext']>;
  /** unique coupon id, represents coupon id at stripe. Internal column */
  coupon_id?: Maybe<Scalars['String']>;
  /** only USD is supported at the moment. Default to USD */
  currency?: Maybe<Scalars['String']>;
  /** represents the duration applicable for a particular coupon. Valid values `once`, `forever`, `repeating` */
  duration?: Maybe<Coupon_Duration_Enum>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Int']>;
  expires_at?: Maybe<Scalars['timestamptz']>;
  /** randomly generated uuid */
  id?: Maybe<Scalars['uuid']>;
  /**
   * represents the state of a particular coupon, whether it is active and can be
   * redeemed or not. This is a global flag to mark a particular coupon
   * active/inactive probably in the middle of a campaign etc. Defaults to true
   */
  is_active?: Maybe<Scalars['Boolean']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Int']>;
  /** represents human readable name for a particular coupon */
  name?: Maybe<Scalars['String']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Int']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['numeric']>;
  /** unique id, represents promotion id at stripe. Internal column */
  promotional_code_id?: Maybe<Scalars['String']>;
  stripe_error?: Maybe<Scalars['String']>;
  /** represents the type of a coupon. Valid values are `credit` or `coupon` */
  type?: Maybe<Coupon_Type_Enum>;
  user_coupons?: Maybe<User_Coupon_Arr_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Coupon_Max_Fields = {
  __typename?: 'coupon_max_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Int']>;
  /** case insensitive text that represents a unique customer facing code that will be used to get the benefit */
  code?: Maybe<Scalars['citext']>;
  /** unique coupon id, represents coupon id at stripe. Internal column */
  coupon_id?: Maybe<Scalars['String']>;
  /** only USD is supported at the moment. Default to USD */
  currency?: Maybe<Scalars['String']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Int']>;
  expires_at?: Maybe<Scalars['timestamptz']>;
  /** randomly generated uuid */
  id?: Maybe<Scalars['uuid']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Int']>;
  /** represents human readable name for a particular coupon */
  name?: Maybe<Scalars['String']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Int']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['numeric']>;
  /** unique id, represents promotion id at stripe. Internal column */
  promotional_code_id?: Maybe<Scalars['String']>;
  stripe_error?: Maybe<Scalars['String']>;
};

/** order by max() on columns of table "coupon" */
export type Coupon_Max_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /** case insensitive text that represents a unique customer facing code that will be used to get the benefit */
  code?: Maybe<Order_By>;
  /** unique coupon id, represents coupon id at stripe. Internal column */
  coupon_id?: Maybe<Order_By>;
  /** only USD is supported at the moment. Default to USD */
  currency?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  expires_at?: Maybe<Order_By>;
  /** randomly generated uuid */
  id?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /** represents human readable name for a particular coupon */
  name?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
  /** unique id, represents promotion id at stripe. Internal column */
  promotional_code_id?: Maybe<Order_By>;
  stripe_error?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Coupon_Min_Fields = {
  __typename?: 'coupon_min_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Int']>;
  /** case insensitive text that represents a unique customer facing code that will be used to get the benefit */
  code?: Maybe<Scalars['citext']>;
  /** unique coupon id, represents coupon id at stripe. Internal column */
  coupon_id?: Maybe<Scalars['String']>;
  /** only USD is supported at the moment. Default to USD */
  currency?: Maybe<Scalars['String']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Int']>;
  expires_at?: Maybe<Scalars['timestamptz']>;
  /** randomly generated uuid */
  id?: Maybe<Scalars['uuid']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Int']>;
  /** represents human readable name for a particular coupon */
  name?: Maybe<Scalars['String']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Int']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['numeric']>;
  /** unique id, represents promotion id at stripe. Internal column */
  promotional_code_id?: Maybe<Scalars['String']>;
  stripe_error?: Maybe<Scalars['String']>;
};

/** order by min() on columns of table "coupon" */
export type Coupon_Min_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /** case insensitive text that represents a unique customer facing code that will be used to get the benefit */
  code?: Maybe<Order_By>;
  /** unique coupon id, represents coupon id at stripe. Internal column */
  coupon_id?: Maybe<Order_By>;
  /** only USD is supported at the moment. Default to USD */
  currency?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  expires_at?: Maybe<Order_By>;
  /** randomly generated uuid */
  id?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /** represents human readable name for a particular coupon */
  name?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
  /** unique id, represents promotion id at stripe. Internal column */
  promotional_code_id?: Maybe<Order_By>;
  stripe_error?: Maybe<Order_By>;
};

/** response of any mutation on the table "coupon" */
export type Coupon_Mutation_Response = {
  __typename?: 'coupon_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Coupon>;
};

/** input type for inserting object relation for remote table "coupon" */
export type Coupon_Obj_Rel_Insert_Input = {
  data: Coupon_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Coupon_On_Conflict>;
};

/** on_conflict condition type for table "coupon" */
export type Coupon_On_Conflict = {
  constraint: Coupon_Constraint;
  update_columns?: Array<Coupon_Update_Column>;
  where?: Maybe<Coupon_Bool_Exp>;
};

/** Ordering options when selecting data from "coupon". */
export type Coupon_Order_By = {
  allowed_customer?: Maybe<Order_By>;
  amount_off?: Maybe<Order_By>;
  code?: Maybe<Order_By>;
  coupon_id?: Maybe<Order_By>;
  currency?: Maybe<Order_By>;
  duration?: Maybe<Order_By>;
  duration_in_months?: Maybe<Order_By>;
  expires_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  is_active?: Maybe<Order_By>;
  max_redemptions?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  per_customer_max_redemption?: Maybe<Order_By>;
  percentage_off?: Maybe<Order_By>;
  promotional_code_id?: Maybe<Order_By>;
  stripe_error?: Maybe<Order_By>;
  type?: Maybe<Order_By>;
  user_coupons_aggregate?: Maybe<User_Coupon_Aggregate_Order_By>;
};

/** primary key columns input for table: coupon */
export type Coupon_Pk_Columns_Input = {
  /** randomly generated uuid */
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Coupon_Prepend_Input = {
  /** email of users which are allowed to use the coupon */
  allowed_customer?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "coupon" */
export enum Coupon_Select_Column {
  /** column name */
  AllowedCustomer = 'allowed_customer',
  /** column name */
  AmountOff = 'amount_off',
  /** column name */
  Code = 'code',
  /** column name */
  CouponId = 'coupon_id',
  /** column name */
  Currency = 'currency',
  /** column name */
  Duration = 'duration',
  /** column name */
  DurationInMonths = 'duration_in_months',
  /** column name */
  ExpiresAt = 'expires_at',
  /** column name */
  Id = 'id',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  MaxRedemptions = 'max_redemptions',
  /** column name */
  Name = 'name',
  /** column name */
  PerCustomerMaxRedemption = 'per_customer_max_redemption',
  /** column name */
  PercentageOff = 'percentage_off',
  /** column name */
  PromotionalCodeId = 'promotional_code_id',
  /** column name */
  StripeError = 'stripe_error',
  /** column name */
  Type = 'type',
}

/** select "coupon_aggregate_bool_exp_bool_and_arguments_columns" columns of table "coupon" */
export enum Coupon_Select_Column_Coupon_Aggregate_Bool_Exp_Bool_And_Arguments_Columns {
  /** column name */
  IsActive = 'is_active',
}

/** select "coupon_aggregate_bool_exp_bool_or_arguments_columns" columns of table "coupon" */
export enum Coupon_Select_Column_Coupon_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns {
  /** column name */
  IsActive = 'is_active',
}

/** input type for updating data in table "coupon" */
export type Coupon_Set_Input = {
  /** email of users which are allowed to use the coupon */
  allowed_customer?: Maybe<Scalars['jsonb']>;
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Int']>;
  /** case insensitive text that represents a unique customer facing code that will be used to get the benefit */
  code?: Maybe<Scalars['citext']>;
  /** unique coupon id, represents coupon id at stripe. Internal column */
  coupon_id?: Maybe<Scalars['String']>;
  /** only USD is supported at the moment. Default to USD */
  currency?: Maybe<Scalars['String']>;
  /** represents the duration applicable for a particular coupon. Valid values `once`, `forever`, `repeating` */
  duration?: Maybe<Coupon_Duration_Enum>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Int']>;
  expires_at?: Maybe<Scalars['timestamptz']>;
  /** randomly generated uuid */
  id?: Maybe<Scalars['uuid']>;
  /**
   * represents the state of a particular coupon, whether it is active and can be
   * redeemed or not. This is a global flag to mark a particular coupon
   * active/inactive probably in the middle of a campaign etc. Defaults to true
   */
  is_active?: Maybe<Scalars['Boolean']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Int']>;
  /** represents human readable name for a particular coupon */
  name?: Maybe<Scalars['String']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Int']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['numeric']>;
  /** unique id, represents promotion id at stripe. Internal column */
  promotional_code_id?: Maybe<Scalars['String']>;
  stripe_error?: Maybe<Scalars['String']>;
  /** represents the type of a coupon. Valid values are `credit` or `coupon` */
  type?: Maybe<Coupon_Type_Enum>;
};

/** aggregate stddev on columns */
export type Coupon_Stddev_Fields = {
  __typename?: 'coupon_stddev_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Float']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Float']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Float']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Float']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "coupon" */
export type Coupon_Stddev_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Coupon_Stddev_Pop_Fields = {
  __typename?: 'coupon_stddev_pop_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Float']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Float']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Float']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Float']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "coupon" */
export type Coupon_Stddev_Pop_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Coupon_Stddev_Samp_Fields = {
  __typename?: 'coupon_stddev_samp_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Float']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Float']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Float']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Float']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "coupon" */
export type Coupon_Stddev_Samp_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
};

/** Streaming cursor of the table "coupon" */
export type Coupon_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Coupon_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Coupon_Stream_Cursor_Value_Input = {
  /** email of users which are allowed to use the coupon */
  allowed_customer?: Maybe<Scalars['jsonb']>;
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Int']>;
  /** case insensitive text that represents a unique customer facing code that will be used to get the benefit */
  code?: Maybe<Scalars['citext']>;
  /** unique coupon id, represents coupon id at stripe. Internal column */
  coupon_id?: Maybe<Scalars['String']>;
  /** only USD is supported at the moment. Default to USD */
  currency?: Maybe<Scalars['String']>;
  /** represents the duration applicable for a particular coupon. Valid values `once`, `forever`, `repeating` */
  duration?: Maybe<Coupon_Duration_Enum>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Int']>;
  expires_at?: Maybe<Scalars['timestamptz']>;
  /** randomly generated uuid */
  id?: Maybe<Scalars['uuid']>;
  /**
   * represents the state of a particular coupon, whether it is active and can be
   * redeemed or not. This is a global flag to mark a particular coupon
   * active/inactive probably in the middle of a campaign etc. Defaults to true
   */
  is_active?: Maybe<Scalars['Boolean']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Int']>;
  /** represents human readable name for a particular coupon */
  name?: Maybe<Scalars['String']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Int']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['numeric']>;
  /** unique id, represents promotion id at stripe. Internal column */
  promotional_code_id?: Maybe<Scalars['String']>;
  stripe_error?: Maybe<Scalars['String']>;
  /** represents the type of a coupon. Valid values are `credit` or `coupon` */
  type?: Maybe<Coupon_Type_Enum>;
};

/** aggregate sum on columns */
export type Coupon_Sum_Fields = {
  __typename?: 'coupon_sum_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Int']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Int']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Int']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Int']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['numeric']>;
};

/** order by sum() on columns of table "coupon" */
export type Coupon_Sum_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
};

/** Hasura enum to capture supported coupon type values. This enum is used in coupon table */
export type Coupon_Type = {
  __typename?: 'coupon_type';
  comment: Scalars['String'];
  /** fetch data from the table: "coupon" */
  coupon: Array<Coupon>;
  /** fetch aggregated fields from the table: "coupon" */
  coupon_aggregate: Coupon_Aggregate;
  type: Scalars['String'];
};

/** Hasura enum to capture supported coupon type values. This enum is used in coupon table */
export type Coupon_TypeCouponArgs = {
  distinct_on?: Maybe<Array<Coupon_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Coupon_Order_By>>;
  where?: Maybe<Coupon_Bool_Exp>;
};

/** Hasura enum to capture supported coupon type values. This enum is used in coupon table */
export type Coupon_TypeCoupon_AggregateArgs = {
  distinct_on?: Maybe<Array<Coupon_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Coupon_Order_By>>;
  where?: Maybe<Coupon_Bool_Exp>;
};

/** aggregated selection of "coupon_type" */
export type Coupon_Type_Aggregate = {
  __typename?: 'coupon_type_aggregate';
  aggregate?: Maybe<Coupon_Type_Aggregate_Fields>;
  nodes: Array<Coupon_Type>;
};

/** aggregate fields of "coupon_type" */
export type Coupon_Type_Aggregate_Fields = {
  __typename?: 'coupon_type_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Coupon_Type_Max_Fields>;
  min?: Maybe<Coupon_Type_Min_Fields>;
};

/** aggregate fields of "coupon_type" */
export type Coupon_Type_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Coupon_Type_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "coupon_type". All fields are combined with a logical 'AND'. */
export type Coupon_Type_Bool_Exp = {
  _and?: Maybe<Array<Coupon_Type_Bool_Exp>>;
  _not?: Maybe<Coupon_Type_Bool_Exp>;
  _or?: Maybe<Array<Coupon_Type_Bool_Exp>>;
  comment?: Maybe<String_Comparison_Exp>;
  coupon?: Maybe<Coupon_Bool_Exp>;
  coupon_aggregate?: Maybe<Coupon_Aggregate_Bool_Exp>;
  type?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "coupon_type" */
export enum Coupon_Type_Constraint {
  /** unique or primary key constraint on columns "type" */
  CouponTypePkey = 'coupon_type_pkey',
}

export enum Coupon_Type_Enum {
  /** stripe coupon */
  Coupon = 'coupon',
  /** add balance to customers account */
  Credit = 'credit',
}

/** Boolean expression to compare columns of type "coupon_type_enum". All fields are combined with logical 'AND'. */
export type Coupon_Type_Enum_Comparison_Exp = {
  _eq?: Maybe<Coupon_Type_Enum>;
  _in?: Maybe<Array<Coupon_Type_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Coupon_Type_Enum>;
  _nin?: Maybe<Array<Coupon_Type_Enum>>;
};

/** input type for inserting data into table "coupon_type" */
export type Coupon_Type_Insert_Input = {
  comment?: Maybe<Scalars['String']>;
  coupon?: Maybe<Coupon_Arr_Rel_Insert_Input>;
  type?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Coupon_Type_Max_Fields = {
  __typename?: 'coupon_type_max_fields';
  comment?: Maybe<Scalars['String']>;
  type?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Coupon_Type_Min_Fields = {
  __typename?: 'coupon_type_min_fields';
  comment?: Maybe<Scalars['String']>;
  type?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "coupon_type" */
export type Coupon_Type_Mutation_Response = {
  __typename?: 'coupon_type_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Coupon_Type>;
};

/** on_conflict condition type for table "coupon_type" */
export type Coupon_Type_On_Conflict = {
  constraint: Coupon_Type_Constraint;
  update_columns?: Array<Coupon_Type_Update_Column>;
  where?: Maybe<Coupon_Type_Bool_Exp>;
};

/** Ordering options when selecting data from "coupon_type". */
export type Coupon_Type_Order_By = {
  comment?: Maybe<Order_By>;
  coupon_aggregate?: Maybe<Coupon_Aggregate_Order_By>;
  type?: Maybe<Order_By>;
};

/** primary key columns input for table: coupon_type */
export type Coupon_Type_Pk_Columns_Input = {
  type: Scalars['String'];
};

/** select columns of table "coupon_type" */
export enum Coupon_Type_Select_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Type = 'type',
}

/** input type for updating data in table "coupon_type" */
export type Coupon_Type_Set_Input = {
  comment?: Maybe<Scalars['String']>;
  type?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "coupon_type" */
export type Coupon_Type_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Coupon_Type_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Coupon_Type_Stream_Cursor_Value_Input = {
  comment?: Maybe<Scalars['String']>;
  type?: Maybe<Scalars['String']>;
};

/** update columns of table "coupon_type" */
export enum Coupon_Type_Update_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Type = 'type',
}

export type Coupon_Type_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Coupon_Type_Set_Input>;
  /** filter the rows which have to be updated */
  where: Coupon_Type_Bool_Exp;
};

/** update columns of table "coupon" */
export enum Coupon_Update_Column {
  /** column name */
  AllowedCustomer = 'allowed_customer',
  /** column name */
  AmountOff = 'amount_off',
  /** column name */
  Code = 'code',
  /** column name */
  CouponId = 'coupon_id',
  /** column name */
  Currency = 'currency',
  /** column name */
  Duration = 'duration',
  /** column name */
  DurationInMonths = 'duration_in_months',
  /** column name */
  ExpiresAt = 'expires_at',
  /** column name */
  Id = 'id',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  MaxRedemptions = 'max_redemptions',
  /** column name */
  Name = 'name',
  /** column name */
  PerCustomerMaxRedemption = 'per_customer_max_redemption',
  /** column name */
  PercentageOff = 'percentage_off',
  /** column name */
  PromotionalCodeId = 'promotional_code_id',
  /** column name */
  StripeError = 'stripe_error',
  /** column name */
  Type = 'type',
}

export type Coupon_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Coupon_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Coupon_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Coupon_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Coupon_Delete_Key_Input>;
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Coupon_Inc_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Coupon_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Coupon_Set_Input>;
  /** filter the rows which have to be updated */
  where: Coupon_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Coupon_Var_Pop_Fields = {
  __typename?: 'coupon_var_pop_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Float']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Float']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Float']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Float']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "coupon" */
export type Coupon_Var_Pop_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Coupon_Var_Samp_Fields = {
  __typename?: 'coupon_var_samp_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Float']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Float']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Float']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Float']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "coupon" */
export type Coupon_Var_Samp_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Coupon_Variance_Fields = {
  __typename?: 'coupon_variance_fields';
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Scalars['Float']>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Scalars['Float']>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Scalars['Float']>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Scalars['Float']>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "coupon" */
export type Coupon_Variance_Order_By = {
  /** amount off in USD. Either amount_off or percentage_off will be there and they cannot exist together */
  amount_off?: Maybe<Order_By>;
  /**
   * when duration is set to `repeating`, this column will represent no of months
   * the discount should be applied on the invoice. Should be NULL for other type of coupon
   */
  duration_in_months?: Maybe<Order_By>;
  /** represents how many times this coupon can be redeemed. If a coupon needs to be used by 100 folks, set this to 100 */
  max_redemptions?: Maybe<Order_By>;
  /**
   * represents how many times a single coupon can be redeemed by a single
   * customer. Set it to 1 if a user can use this coupon only once
   */
  per_customer_max_redemption?: Maybe<Order_By>;
  /** percentage off on the entire invoice amount */
  percentage_off?: Maybe<Order_By>;
};

export type CouponStatus = {
  __typename?: 'CouponStatus';
  status: Scalars['String'];
};

export type CreateDedicatedVpcResponse = {
  __typename?: 'CreateDedicatedVPCResponse';
  id: Scalars['uuid'];
};

export type CreateGithubPreviewAppInputPayload = {
  githubPersonalAccessToken: Scalars['String'];
  githubRepoDetails: GithubRepoDetails;
  projectOptions: ProjectOptions;
};

export type CreateInvoiceInput = {
  collection_method: Scalars['String'];
  customer: Scalars['String'];
  invoice: Scalars['String'];
  month?: Maybe<Scalars['Int']>;
  subscription: Scalars['String'];
  year?: Maybe<Scalars['Int']>;
};

export type CreateInvoiceResponse = {
  __typename?: 'CreateInvoiceResponse';
  message: Scalars['String'];
  status: InvoiceCreateStatus;
};

export type CreateJobInput = {
  payload: Scalars['Map'];
  type: JobTypeEnum;
};

export type CreateJobResponse = {
  __typename?: 'CreateJobResponse';
  job_id: Scalars['uuid'];
};

export type CreateOneClickDeploymentInputPayload = {
  additional_info: Scalars['jsonb'];
  branch?: Maybe<Scalars['String']>;
  github_url: Scalars['String'];
  hasura_dir: Scalars['String'];
};

export type CreateOneClickDeploymentOutput = {
  __typename?: 'CreateOneClickDeploymentOutput';
  project?: Maybe<Projects>;
  project_id: Scalars['uuid'];
};

export type CreateTenantResponse = {
  __typename?: 'CreateTenantResponse';
  id: Scalars['uuid'];
  name: Scalars['String'];
  tenant?: Maybe<Tenant>;
};

/** ordering argument of a cursor */
export enum Cursor_Ordering {
  /** ascending ordering of the cursor */
  Asc = 'ASC',
  /** descending ordering of the cursor */
  Desc = 'DESC',
}

/** information about custom domains that are added for tenants */
export type Custom_Domain = {
  __typename?: 'custom_domain';
  /**
   * indicates how certificate is handled: 1) letsencrypt: gateway should use LE to
   * issue cert, 2) vault://<path>: cert is stored on Vault at this path, 3) none:
   * cert is not handled
   */
  cert: Scalars['String'];
  /** Get origin server DNS record created for custom domain */
  cloudflare_origin_dns_record?: Maybe<Scalars['String']>;
  created_at: Scalars['timestamptz'];
  /** An object relationship */
  custom_domain_cloudflare?: Maybe<Custom_Domain_Cloudflare>;
  /** An object relationship */
  custom_domain_cloudflare_dns?: Maybe<Custom_Domain_Cloudflare_Dns>;
  /**
   * indicates if the dns resolves to <slug>.hasura.app: 1) pending: the validation
   * is peniding, 2) succeeded: dns is configured correctly, 3) failed: dns
   * validation failed
   */
  dns_validation: Scalars['String'];
  /** the custom domain being added */
  fqdn: Scalars['String'];
  id: Scalars['uuid'];
  /** An array relationship */
  letsencrypt_statuses: Array<Letsencrypt_Status>;
  /** An aggregate relationship */
  letsencrypt_statuses_aggregate: Letsencrypt_Status_Aggregate;
  /** Get the SSL info/error messages, if any */
  ssl_message?: Maybe<Scalars['String']>;
  /** Get the SSL status for custom domain */
  ssl_status?: Maybe<Scalars['String']>;
  /** An object relationship */
  tenant: Tenant;
  tenant_id: Scalars['uuid'];
  updated_at: Scalars['timestamptz'];
};

/** information about custom domains that are added for tenants */
export type Custom_DomainLetsencrypt_StatusesArgs = {
  distinct_on?: Maybe<Array<Letsencrypt_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Letsencrypt_Status_Order_By>>;
  where?: Maybe<Letsencrypt_Status_Bool_Exp>;
};

/** information about custom domains that are added for tenants */
export type Custom_DomainLetsencrypt_Statuses_AggregateArgs = {
  distinct_on?: Maybe<Array<Letsencrypt_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Letsencrypt_Status_Order_By>>;
  where?: Maybe<Letsencrypt_Status_Bool_Exp>;
};

/** aggregated selection of "custom_domain" */
export type Custom_Domain_Aggregate = {
  __typename?: 'custom_domain_aggregate';
  aggregate?: Maybe<Custom_Domain_Aggregate_Fields>;
  nodes: Array<Custom_Domain>;
};

export type Custom_Domain_Aggregate_Bool_Exp = {
  count?: Maybe<Custom_Domain_Aggregate_Bool_Exp_Count>;
};

export type Custom_Domain_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Custom_Domain_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Custom_Domain_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "custom_domain" */
export type Custom_Domain_Aggregate_Fields = {
  __typename?: 'custom_domain_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Custom_Domain_Max_Fields>;
  min?: Maybe<Custom_Domain_Min_Fields>;
};

/** aggregate fields of "custom_domain" */
export type Custom_Domain_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Custom_Domain_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "custom_domain" */
export type Custom_Domain_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Custom_Domain_Max_Order_By>;
  min?: Maybe<Custom_Domain_Min_Order_By>;
};

/** input type for inserting array relation for remote table "custom_domain" */
export type Custom_Domain_Arr_Rel_Insert_Input = {
  data: Array<Custom_Domain_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Custom_Domain_On_Conflict>;
};

/** Boolean expression to filter rows from the table "custom_domain". All fields are combined with a logical 'AND'. */
export type Custom_Domain_Bool_Exp = {
  _and?: Maybe<Array<Custom_Domain_Bool_Exp>>;
  _not?: Maybe<Custom_Domain_Bool_Exp>;
  _or?: Maybe<Array<Custom_Domain_Bool_Exp>>;
  cert?: Maybe<String_Comparison_Exp>;
  cloudflare_origin_dns_record?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  custom_domain_cloudflare?: Maybe<Custom_Domain_Cloudflare_Bool_Exp>;
  custom_domain_cloudflare_dns?: Maybe<Custom_Domain_Cloudflare_Dns_Bool_Exp>;
  dns_validation?: Maybe<String_Comparison_Exp>;
  fqdn?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  letsencrypt_statuses?: Maybe<Letsencrypt_Status_Bool_Exp>;
  letsencrypt_statuses_aggregate?: Maybe<Letsencrypt_Status_Aggregate_Bool_Exp>;
  ssl_message?: Maybe<String_Comparison_Exp>;
  ssl_status?: Maybe<String_Comparison_Exp>;
  tenant?: Maybe<Tenant_Bool_Exp>;
  tenant_id?: Maybe<Uuid_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** Status of cloudflare custom domain setup */
export type Custom_Domain_Cloudflare = {
  __typename?: 'custom_domain_cloudflare';
  certificate_verification_path?: Maybe<Scalars['String']>;
  certificate_verification_value?: Maybe<Scalars['String']>;
  created_at: Scalars['timestamptz'];
  /** An object relationship */
  custom_domain: Custom_Domain;
  custom_hostname_cloudflare?: Maybe<Scalars['jsonb']>;
  /** An object relationship */
  dns?: Maybe<Custom_Domain_Cloudflare_Dns>;
  force_update: Scalars['Boolean'];
  fqdn: Scalars['String'];
  id: Scalars['uuid'];
  message?: Maybe<Scalars['String']>;
  origin_server_cloudflare: Scalars['String'];
  ownership_verification_path?: Maybe<Scalars['String']>;
  ownership_verification_value?: Maybe<Scalars['String']>;
  status: Scalars['String'];
  updated_at: Scalars['timestamptz'];
};

/** Status of cloudflare custom domain setup */
export type Custom_Domain_CloudflareCustom_Hostname_CloudflareArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "custom_domain_cloudflare" */
export type Custom_Domain_Cloudflare_Aggregate = {
  __typename?: 'custom_domain_cloudflare_aggregate';
  aggregate?: Maybe<Custom_Domain_Cloudflare_Aggregate_Fields>;
  nodes: Array<Custom_Domain_Cloudflare>;
};

/** aggregate fields of "custom_domain_cloudflare" */
export type Custom_Domain_Cloudflare_Aggregate_Fields = {
  __typename?: 'custom_domain_cloudflare_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Custom_Domain_Cloudflare_Max_Fields>;
  min?: Maybe<Custom_Domain_Cloudflare_Min_Fields>;
};

/** aggregate fields of "custom_domain_cloudflare" */
export type Custom_Domain_Cloudflare_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Custom_Domain_Cloudflare_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Custom_Domain_Cloudflare_Append_Input = {
  custom_hostname_cloudflare?: Maybe<Scalars['jsonb']>;
};

/** Boolean expression to filter rows from the table "custom_domain_cloudflare". All fields are combined with a logical 'AND'. */
export type Custom_Domain_Cloudflare_Bool_Exp = {
  _and?: Maybe<Array<Custom_Domain_Cloudflare_Bool_Exp>>;
  _not?: Maybe<Custom_Domain_Cloudflare_Bool_Exp>;
  _or?: Maybe<Array<Custom_Domain_Cloudflare_Bool_Exp>>;
  certificate_verification_path?: Maybe<String_Comparison_Exp>;
  certificate_verification_value?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  custom_domain?: Maybe<Custom_Domain_Bool_Exp>;
  custom_hostname_cloudflare?: Maybe<Jsonb_Comparison_Exp>;
  dns?: Maybe<Custom_Domain_Cloudflare_Dns_Bool_Exp>;
  force_update?: Maybe<Boolean_Comparison_Exp>;
  fqdn?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  message?: Maybe<String_Comparison_Exp>;
  origin_server_cloudflare?: Maybe<String_Comparison_Exp>;
  ownership_verification_path?: Maybe<String_Comparison_Exp>;
  ownership_verification_value?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "custom_domain_cloudflare" */
export enum Custom_Domain_Cloudflare_Constraint {
  /** unique or primary key constraint on columns "id" */
  CustomDomainCloudflarePkey = 'custom_domain_cloudflare_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Custom_Domain_Cloudflare_Delete_At_Path_Input = {
  custom_hostname_cloudflare?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Custom_Domain_Cloudflare_Delete_Elem_Input = {
  custom_hostname_cloudflare?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Custom_Domain_Cloudflare_Delete_Key_Input = {
  custom_hostname_cloudflare?: Maybe<Scalars['String']>;
};

/** DNS record required for cloudflare custom domain */
export type Custom_Domain_Cloudflare_Dns = {
  __typename?: 'custom_domain_cloudflare_dns';
  created_at: Scalars['timestamptz'];
  /** An object relationship */
  custom_domain: Custom_Domain;
  dns_name: Scalars['String'];
  force_update: Scalars['Boolean'];
  id: Scalars['uuid'];
  message?: Maybe<Scalars['String']>;
  status: Scalars['String'];
  updated_at: Scalars['timestamptz'];
};

/** aggregated selection of "custom_domain_cloudflare_dns" */
export type Custom_Domain_Cloudflare_Dns_Aggregate = {
  __typename?: 'custom_domain_cloudflare_dns_aggregate';
  aggregate?: Maybe<Custom_Domain_Cloudflare_Dns_Aggregate_Fields>;
  nodes: Array<Custom_Domain_Cloudflare_Dns>;
};

/** aggregate fields of "custom_domain_cloudflare_dns" */
export type Custom_Domain_Cloudflare_Dns_Aggregate_Fields = {
  __typename?: 'custom_domain_cloudflare_dns_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Custom_Domain_Cloudflare_Dns_Max_Fields>;
  min?: Maybe<Custom_Domain_Cloudflare_Dns_Min_Fields>;
};

/** aggregate fields of "custom_domain_cloudflare_dns" */
export type Custom_Domain_Cloudflare_Dns_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Custom_Domain_Cloudflare_Dns_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/**
 * Boolean expression to filter rows from the table "custom_domain_cloudflare_dns".
 * All fields are combined with a logical 'AND'.
 */
export type Custom_Domain_Cloudflare_Dns_Bool_Exp = {
  _and?: Maybe<Array<Custom_Domain_Cloudflare_Dns_Bool_Exp>>;
  _not?: Maybe<Custom_Domain_Cloudflare_Dns_Bool_Exp>;
  _or?: Maybe<Array<Custom_Domain_Cloudflare_Dns_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  custom_domain?: Maybe<Custom_Domain_Bool_Exp>;
  dns_name?: Maybe<String_Comparison_Exp>;
  force_update?: Maybe<Boolean_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  message?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "custom_domain_cloudflare_dns" */
export enum Custom_Domain_Cloudflare_Dns_Constraint {
  /** unique or primary key constraint on columns "dns_name" */
  CustomDomainCloudflareDnsDnsNameKey = 'custom_domain_cloudflare_dns_dns_name_key',
  /** unique or primary key constraint on columns "id", "dns_name" */
  CustomDomainCloudflareDnsIdDnsNameKey = 'custom_domain_cloudflare_dns_id_dns_name_key',
  /** unique or primary key constraint on columns "id" */
  CustomDomainCloudflareDnsPkey = 'custom_domain_cloudflare_dns_pkey',
}

/** input type for inserting data into table "custom_domain_cloudflare_dns" */
export type Custom_Domain_Cloudflare_Dns_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  custom_domain?: Maybe<Custom_Domain_Obj_Rel_Insert_Input>;
  dns_name?: Maybe<Scalars['String']>;
  force_update?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Custom_Domain_Cloudflare_Dns_Max_Fields = {
  __typename?: 'custom_domain_cloudflare_dns_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  dns_name?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Custom_Domain_Cloudflare_Dns_Min_Fields = {
  __typename?: 'custom_domain_cloudflare_dns_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  dns_name?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "custom_domain_cloudflare_dns" */
export type Custom_Domain_Cloudflare_Dns_Mutation_Response = {
  __typename?: 'custom_domain_cloudflare_dns_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Custom_Domain_Cloudflare_Dns>;
};

/** input type for inserting object relation for remote table "custom_domain_cloudflare_dns" */
export type Custom_Domain_Cloudflare_Dns_Obj_Rel_Insert_Input = {
  data: Custom_Domain_Cloudflare_Dns_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Custom_Domain_Cloudflare_Dns_On_Conflict>;
};

/** on_conflict condition type for table "custom_domain_cloudflare_dns" */
export type Custom_Domain_Cloudflare_Dns_On_Conflict = {
  constraint: Custom_Domain_Cloudflare_Dns_Constraint;
  update_columns?: Array<Custom_Domain_Cloudflare_Dns_Update_Column>;
  where?: Maybe<Custom_Domain_Cloudflare_Dns_Bool_Exp>;
};

/** Ordering options when selecting data from "custom_domain_cloudflare_dns". */
export type Custom_Domain_Cloudflare_Dns_Order_By = {
  created_at?: Maybe<Order_By>;
  custom_domain?: Maybe<Custom_Domain_Order_By>;
  dns_name?: Maybe<Order_By>;
  force_update?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  message?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: custom_domain_cloudflare_dns */
export type Custom_Domain_Cloudflare_Dns_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "custom_domain_cloudflare_dns" */
export enum Custom_Domain_Cloudflare_Dns_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DnsName = 'dns_name',
  /** column name */
  ForceUpdate = 'force_update',
  /** column name */
  Id = 'id',
  /** column name */
  Message = 'message',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "custom_domain_cloudflare_dns" */
export type Custom_Domain_Cloudflare_Dns_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  dns_name?: Maybe<Scalars['String']>;
  force_update?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "custom_domain_cloudflare_dns" */
export type Custom_Domain_Cloudflare_Dns_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Custom_Domain_Cloudflare_Dns_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Custom_Domain_Cloudflare_Dns_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  dns_name?: Maybe<Scalars['String']>;
  force_update?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "custom_domain_cloudflare_dns" */
export enum Custom_Domain_Cloudflare_Dns_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DnsName = 'dns_name',
  /** column name */
  ForceUpdate = 'force_update',
  /** column name */
  Id = 'id',
  /** column name */
  Message = 'message',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Custom_Domain_Cloudflare_Dns_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Custom_Domain_Cloudflare_Dns_Set_Input>;
  /** filter the rows which have to be updated */
  where: Custom_Domain_Cloudflare_Dns_Bool_Exp;
};

/** input type for inserting data into table "custom_domain_cloudflare" */
export type Custom_Domain_Cloudflare_Insert_Input = {
  certificate_verification_path?: Maybe<Scalars['String']>;
  certificate_verification_value?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  custom_domain?: Maybe<Custom_Domain_Obj_Rel_Insert_Input>;
  custom_hostname_cloudflare?: Maybe<Scalars['jsonb']>;
  dns?: Maybe<Custom_Domain_Cloudflare_Dns_Obj_Rel_Insert_Input>;
  force_update?: Maybe<Scalars['Boolean']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  origin_server_cloudflare?: Maybe<Scalars['String']>;
  ownership_verification_path?: Maybe<Scalars['String']>;
  ownership_verification_value?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Custom_Domain_Cloudflare_Max_Fields = {
  __typename?: 'custom_domain_cloudflare_max_fields';
  certificate_verification_path?: Maybe<Scalars['String']>;
  certificate_verification_value?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  origin_server_cloudflare?: Maybe<Scalars['String']>;
  ownership_verification_path?: Maybe<Scalars['String']>;
  ownership_verification_value?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Custom_Domain_Cloudflare_Min_Fields = {
  __typename?: 'custom_domain_cloudflare_min_fields';
  certificate_verification_path?: Maybe<Scalars['String']>;
  certificate_verification_value?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  origin_server_cloudflare?: Maybe<Scalars['String']>;
  ownership_verification_path?: Maybe<Scalars['String']>;
  ownership_verification_value?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "custom_domain_cloudflare" */
export type Custom_Domain_Cloudflare_Mutation_Response = {
  __typename?: 'custom_domain_cloudflare_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Custom_Domain_Cloudflare>;
};

/** input type for inserting object relation for remote table "custom_domain_cloudflare" */
export type Custom_Domain_Cloudflare_Obj_Rel_Insert_Input = {
  data: Custom_Domain_Cloudflare_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Custom_Domain_Cloudflare_On_Conflict>;
};

/** on_conflict condition type for table "custom_domain_cloudflare" */
export type Custom_Domain_Cloudflare_On_Conflict = {
  constraint: Custom_Domain_Cloudflare_Constraint;
  update_columns?: Array<Custom_Domain_Cloudflare_Update_Column>;
  where?: Maybe<Custom_Domain_Cloudflare_Bool_Exp>;
};

/** Ordering options when selecting data from "custom_domain_cloudflare". */
export type Custom_Domain_Cloudflare_Order_By = {
  certificate_verification_path?: Maybe<Order_By>;
  certificate_verification_value?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  custom_domain?: Maybe<Custom_Domain_Order_By>;
  custom_hostname_cloudflare?: Maybe<Order_By>;
  dns?: Maybe<Custom_Domain_Cloudflare_Dns_Order_By>;
  force_update?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  message?: Maybe<Order_By>;
  origin_server_cloudflare?: Maybe<Order_By>;
  ownership_verification_path?: Maybe<Order_By>;
  ownership_verification_value?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: custom_domain_cloudflare */
export type Custom_Domain_Cloudflare_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Custom_Domain_Cloudflare_Prepend_Input = {
  custom_hostname_cloudflare?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "custom_domain_cloudflare" */
export enum Custom_Domain_Cloudflare_Select_Column {
  /** column name */
  CertificateVerificationPath = 'certificate_verification_path',
  /** column name */
  CertificateVerificationValue = 'certificate_verification_value',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomHostnameCloudflare = 'custom_hostname_cloudflare',
  /** column name */
  ForceUpdate = 'force_update',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  Message = 'message',
  /** column name */
  OriginServerCloudflare = 'origin_server_cloudflare',
  /** column name */
  OwnershipVerificationPath = 'ownership_verification_path',
  /** column name */
  OwnershipVerificationValue = 'ownership_verification_value',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "custom_domain_cloudflare" */
export type Custom_Domain_Cloudflare_Set_Input = {
  certificate_verification_path?: Maybe<Scalars['String']>;
  certificate_verification_value?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  custom_hostname_cloudflare?: Maybe<Scalars['jsonb']>;
  force_update?: Maybe<Scalars['Boolean']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  origin_server_cloudflare?: Maybe<Scalars['String']>;
  ownership_verification_path?: Maybe<Scalars['String']>;
  ownership_verification_value?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "custom_domain_cloudflare" */
export type Custom_Domain_Cloudflare_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Custom_Domain_Cloudflare_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Custom_Domain_Cloudflare_Stream_Cursor_Value_Input = {
  certificate_verification_path?: Maybe<Scalars['String']>;
  certificate_verification_value?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  custom_hostname_cloudflare?: Maybe<Scalars['jsonb']>;
  force_update?: Maybe<Scalars['Boolean']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  origin_server_cloudflare?: Maybe<Scalars['String']>;
  ownership_verification_path?: Maybe<Scalars['String']>;
  ownership_verification_value?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "custom_domain_cloudflare" */
export enum Custom_Domain_Cloudflare_Update_Column {
  /** column name */
  CertificateVerificationPath = 'certificate_verification_path',
  /** column name */
  CertificateVerificationValue = 'certificate_verification_value',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomHostnameCloudflare = 'custom_hostname_cloudflare',
  /** column name */
  ForceUpdate = 'force_update',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  Message = 'message',
  /** column name */
  OriginServerCloudflare = 'origin_server_cloudflare',
  /** column name */
  OwnershipVerificationPath = 'ownership_verification_path',
  /** column name */
  OwnershipVerificationValue = 'ownership_verification_value',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Custom_Domain_Cloudflare_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Custom_Domain_Cloudflare_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Custom_Domain_Cloudflare_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Custom_Domain_Cloudflare_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Custom_Domain_Cloudflare_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Custom_Domain_Cloudflare_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Custom_Domain_Cloudflare_Set_Input>;
  /** filter the rows which have to be updated */
  where: Custom_Domain_Cloudflare_Bool_Exp;
};

/** unique or primary key constraints on table "custom_domain" */
export enum Custom_Domain_Constraint {
  /** unique or primary key constraint on columns "fqdn" */
  CustomDomainFqdnKey = 'custom_domain_fqdn_key',
  /** unique or primary key constraint on columns "fqdn", "id" */
  CustomDomainIdFqdnKey = 'custom_domain_id_fqdn_key',
  /** unique or primary key constraint on columns "id" */
  CustomDomainPkey = 'custom_domain_pkey',
}

/** input type for inserting data into table "custom_domain" */
export type Custom_Domain_Insert_Input = {
  /**
   * indicates how certificate is handled: 1) letsencrypt: gateway should use LE to
   * issue cert, 2) vault://<path>: cert is stored on Vault at this path, 3) none:
   * cert is not handled
   */
  cert?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  custom_domain_cloudflare?: Maybe<Custom_Domain_Cloudflare_Obj_Rel_Insert_Input>;
  custom_domain_cloudflare_dns?: Maybe<Custom_Domain_Cloudflare_Dns_Obj_Rel_Insert_Input>;
  /**
   * indicates if the dns resolves to <slug>.hasura.app: 1) pending: the validation
   * is peniding, 2) succeeded: dns is configured correctly, 3) failed: dns
   * validation failed
   */
  dns_validation?: Maybe<Scalars['String']>;
  /** the custom domain being added */
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  letsencrypt_statuses?: Maybe<Letsencrypt_Status_Arr_Rel_Insert_Input>;
  tenant?: Maybe<Tenant_Obj_Rel_Insert_Input>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Custom_Domain_Max_Fields = {
  __typename?: 'custom_domain_max_fields';
  /**
   * indicates how certificate is handled: 1) letsencrypt: gateway should use LE to
   * issue cert, 2) vault://<path>: cert is stored on Vault at this path, 3) none:
   * cert is not handled
   */
  cert?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /**
   * indicates if the dns resolves to <slug>.hasura.app: 1) pending: the validation
   * is peniding, 2) succeeded: dns is configured correctly, 3) failed: dns
   * validation failed
   */
  dns_validation?: Maybe<Scalars['String']>;
  /** the custom domain being added */
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by max() on columns of table "custom_domain" */
export type Custom_Domain_Max_Order_By = {
  /**
   * indicates how certificate is handled: 1) letsencrypt: gateway should use LE to
   * issue cert, 2) vault://<path>: cert is stored on Vault at this path, 3) none:
   * cert is not handled
   */
  cert?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  /**
   * indicates if the dns resolves to <slug>.hasura.app: 1) pending: the validation
   * is peniding, 2) succeeded: dns is configured correctly, 3) failed: dns
   * validation failed
   */
  dns_validation?: Maybe<Order_By>;
  /** the custom domain being added */
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  tenant_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Custom_Domain_Min_Fields = {
  __typename?: 'custom_domain_min_fields';
  /**
   * indicates how certificate is handled: 1) letsencrypt: gateway should use LE to
   * issue cert, 2) vault://<path>: cert is stored on Vault at this path, 3) none:
   * cert is not handled
   */
  cert?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /**
   * indicates if the dns resolves to <slug>.hasura.app: 1) pending: the validation
   * is peniding, 2) succeeded: dns is configured correctly, 3) failed: dns
   * validation failed
   */
  dns_validation?: Maybe<Scalars['String']>;
  /** the custom domain being added */
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by min() on columns of table "custom_domain" */
export type Custom_Domain_Min_Order_By = {
  /**
   * indicates how certificate is handled: 1) letsencrypt: gateway should use LE to
   * issue cert, 2) vault://<path>: cert is stored on Vault at this path, 3) none:
   * cert is not handled
   */
  cert?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  /**
   * indicates if the dns resolves to <slug>.hasura.app: 1) pending: the validation
   * is peniding, 2) succeeded: dns is configured correctly, 3) failed: dns
   * validation failed
   */
  dns_validation?: Maybe<Order_By>;
  /** the custom domain being added */
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  tenant_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** response of any mutation on the table "custom_domain" */
export type Custom_Domain_Mutation_Response = {
  __typename?: 'custom_domain_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Custom_Domain>;
};

/** input type for inserting object relation for remote table "custom_domain" */
export type Custom_Domain_Obj_Rel_Insert_Input = {
  data: Custom_Domain_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Custom_Domain_On_Conflict>;
};

/** on_conflict condition type for table "custom_domain" */
export type Custom_Domain_On_Conflict = {
  constraint: Custom_Domain_Constraint;
  update_columns?: Array<Custom_Domain_Update_Column>;
  where?: Maybe<Custom_Domain_Bool_Exp>;
};

/** Ordering options when selecting data from "custom_domain". */
export type Custom_Domain_Order_By = {
  cert?: Maybe<Order_By>;
  cloudflare_origin_dns_record?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  custom_domain_cloudflare?: Maybe<Custom_Domain_Cloudflare_Order_By>;
  custom_domain_cloudflare_dns?: Maybe<Custom_Domain_Cloudflare_Dns_Order_By>;
  dns_validation?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  letsencrypt_statuses_aggregate?: Maybe<Letsencrypt_Status_Aggregate_Order_By>;
  ssl_message?: Maybe<Order_By>;
  ssl_status?: Maybe<Order_By>;
  tenant?: Maybe<Tenant_Order_By>;
  tenant_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: custom_domain */
export type Custom_Domain_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "custom_domain" */
export enum Custom_Domain_Select_Column {
  /** column name */
  Cert = 'cert',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DnsValidation = 'dns_validation',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  TenantId = 'tenant_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "custom_domain" */
export type Custom_Domain_Set_Input = {
  /**
   * indicates how certificate is handled: 1) letsencrypt: gateway should use LE to
   * issue cert, 2) vault://<path>: cert is stored on Vault at this path, 3) none:
   * cert is not handled
   */
  cert?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /**
   * indicates if the dns resolves to <slug>.hasura.app: 1) pending: the validation
   * is peniding, 2) succeeded: dns is configured correctly, 3) failed: dns
   * validation failed
   */
  dns_validation?: Maybe<Scalars['String']>;
  /** the custom domain being added */
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "custom_domain" */
export type Custom_Domain_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Custom_Domain_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Custom_Domain_Stream_Cursor_Value_Input = {
  /**
   * indicates how certificate is handled: 1) letsencrypt: gateway should use LE to
   * issue cert, 2) vault://<path>: cert is stored on Vault at this path, 3) none:
   * cert is not handled
   */
  cert?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /**
   * indicates if the dns resolves to <slug>.hasura.app: 1) pending: the validation
   * is peniding, 2) succeeded: dns is configured correctly, 3) failed: dns
   * validation failed
   */
  dns_validation?: Maybe<Scalars['String']>;
  /** the custom domain being added */
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "custom_domain" */
export enum Custom_Domain_Update_Column {
  /** column name */
  Cert = 'cert',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DnsValidation = 'dns_validation',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  TenantId = 'tenant_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Custom_Domain_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Custom_Domain_Set_Input>;
  /** filter the rows which have to be updated */
  where: Custom_Domain_Bool_Exp;
};

/** Price (amount) usage by a customer */
export type Customer_Usage = {
  __typename?: 'customer_usage';
  amount: Scalars['float8'];
  code?: Maybe<Scalars['citext']>;
  /** An object relationship */
  coupon?: Maybe<Coupon>;
  created_at: Scalars['timestamptz'];
  customer_id: Scalars['String'];
  id: Scalars['uuid'];
  invoice_id?: Maybe<Scalars['String']>;
  /** An object relationship */
  user?: Maybe<Users>;
};

/** aggregated selection of "customer_usage" */
export type Customer_Usage_Aggregate = {
  __typename?: 'customer_usage_aggregate';
  aggregate?: Maybe<Customer_Usage_Aggregate_Fields>;
  nodes: Array<Customer_Usage>;
};

export type Customer_Usage_Aggregate_Bool_Exp = {
  avg?: Maybe<Customer_Usage_Aggregate_Bool_Exp_Avg>;
  corr?: Maybe<Customer_Usage_Aggregate_Bool_Exp_Corr>;
  count?: Maybe<Customer_Usage_Aggregate_Bool_Exp_Count>;
  covar_samp?: Maybe<Customer_Usage_Aggregate_Bool_Exp_Covar_Samp>;
  max?: Maybe<Customer_Usage_Aggregate_Bool_Exp_Max>;
  min?: Maybe<Customer_Usage_Aggregate_Bool_Exp_Min>;
  stddev_samp?: Maybe<Customer_Usage_Aggregate_Bool_Exp_Stddev_Samp>;
  sum?: Maybe<Customer_Usage_Aggregate_Bool_Exp_Sum>;
  var_samp?: Maybe<Customer_Usage_Aggregate_Bool_Exp_Var_Samp>;
};

export type Customer_Usage_Aggregate_Bool_Exp_Avg = {
  arguments: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Avg_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Customer_Usage_Bool_Exp>;
  predicate: Float8_Comparison_Exp;
};

export type Customer_Usage_Aggregate_Bool_Exp_Corr = {
  arguments: Customer_Usage_Aggregate_Bool_Exp_Corr_Arguments;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Customer_Usage_Bool_Exp>;
  predicate: Float8_Comparison_Exp;
};

export type Customer_Usage_Aggregate_Bool_Exp_Corr_Arguments = {
  X: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Corr_Arguments_Columns;
  Y: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Corr_Arguments_Columns;
};

export type Customer_Usage_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Customer_Usage_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Customer_Usage_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

export type Customer_Usage_Aggregate_Bool_Exp_Covar_Samp = {
  arguments: Customer_Usage_Aggregate_Bool_Exp_Covar_Samp_Arguments;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Customer_Usage_Bool_Exp>;
  predicate: Float8_Comparison_Exp;
};

export type Customer_Usage_Aggregate_Bool_Exp_Covar_Samp_Arguments = {
  X: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Covar_Samp_Arguments_Columns;
  Y: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Covar_Samp_Arguments_Columns;
};

export type Customer_Usage_Aggregate_Bool_Exp_Max = {
  arguments: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Max_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Customer_Usage_Bool_Exp>;
  predicate: Float8_Comparison_Exp;
};

export type Customer_Usage_Aggregate_Bool_Exp_Min = {
  arguments: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Min_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Customer_Usage_Bool_Exp>;
  predicate: Float8_Comparison_Exp;
};

export type Customer_Usage_Aggregate_Bool_Exp_Stddev_Samp = {
  arguments: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Stddev_Samp_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Customer_Usage_Bool_Exp>;
  predicate: Float8_Comparison_Exp;
};

export type Customer_Usage_Aggregate_Bool_Exp_Sum = {
  arguments: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Sum_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Customer_Usage_Bool_Exp>;
  predicate: Float8_Comparison_Exp;
};

export type Customer_Usage_Aggregate_Bool_Exp_Var_Samp = {
  arguments: Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Var_Samp_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Customer_Usage_Bool_Exp>;
  predicate: Float8_Comparison_Exp;
};

/** aggregate fields of "customer_usage" */
export type Customer_Usage_Aggregate_Fields = {
  __typename?: 'customer_usage_aggregate_fields';
  avg?: Maybe<Customer_Usage_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Customer_Usage_Max_Fields>;
  min?: Maybe<Customer_Usage_Min_Fields>;
  stddev?: Maybe<Customer_Usage_Stddev_Fields>;
  stddev_pop?: Maybe<Customer_Usage_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Customer_Usage_Stddev_Samp_Fields>;
  sum?: Maybe<Customer_Usage_Sum_Fields>;
  var_pop?: Maybe<Customer_Usage_Var_Pop_Fields>;
  var_samp?: Maybe<Customer_Usage_Var_Samp_Fields>;
  variance?: Maybe<Customer_Usage_Variance_Fields>;
};

/** aggregate fields of "customer_usage" */
export type Customer_Usage_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Customer_Usage_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "customer_usage" */
export type Customer_Usage_Aggregate_Order_By = {
  avg?: Maybe<Customer_Usage_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Customer_Usage_Max_Order_By>;
  min?: Maybe<Customer_Usage_Min_Order_By>;
  stddev?: Maybe<Customer_Usage_Stddev_Order_By>;
  stddev_pop?: Maybe<Customer_Usage_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Customer_Usage_Stddev_Samp_Order_By>;
  sum?: Maybe<Customer_Usage_Sum_Order_By>;
  var_pop?: Maybe<Customer_Usage_Var_Pop_Order_By>;
  var_samp?: Maybe<Customer_Usage_Var_Samp_Order_By>;
  variance?: Maybe<Customer_Usage_Variance_Order_By>;
};

/** input type for inserting array relation for remote table "customer_usage" */
export type Customer_Usage_Arr_Rel_Insert_Input = {
  data: Array<Customer_Usage_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Customer_Usage_On_Conflict>;
};

/** aggregate avg on columns */
export type Customer_Usage_Avg_Fields = {
  __typename?: 'customer_usage_avg_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "customer_usage" */
export type Customer_Usage_Avg_Order_By = {
  amount?: Maybe<Order_By>;
};

/** Boolean expression to filter rows from the table "customer_usage". All fields are combined with a logical 'AND'. */
export type Customer_Usage_Bool_Exp = {
  _and?: Maybe<Array<Customer_Usage_Bool_Exp>>;
  _not?: Maybe<Customer_Usage_Bool_Exp>;
  _or?: Maybe<Array<Customer_Usage_Bool_Exp>>;
  amount?: Maybe<Float8_Comparison_Exp>;
  code?: Maybe<Citext_Comparison_Exp>;
  coupon?: Maybe<Coupon_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  customer_id?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  invoice_id?: Maybe<String_Comparison_Exp>;
  user?: Maybe<Users_Bool_Exp>;
};

/** unique or primary key constraints on table "customer_usage" */
export enum Customer_Usage_Constraint {
  /** unique or primary key constraint on columns "id" */
  CustomerUsagePkey = 'customer_usage_pkey',
}

/** input type for incrementing numeric columns in table "customer_usage" */
export type Customer_Usage_Inc_Input = {
  amount?: Maybe<Scalars['float8']>;
};

/** input type for inserting data into table "customer_usage" */
export type Customer_Usage_Insert_Input = {
  amount?: Maybe<Scalars['float8']>;
  code?: Maybe<Scalars['citext']>;
  coupon?: Maybe<Coupon_Obj_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  invoice_id?: Maybe<Scalars['String']>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Customer_Usage_Max_Fields = {
  __typename?: 'customer_usage_max_fields';
  amount?: Maybe<Scalars['float8']>;
  code?: Maybe<Scalars['citext']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  invoice_id?: Maybe<Scalars['String']>;
};

/** order by max() on columns of table "customer_usage" */
export type Customer_Usage_Max_Order_By = {
  amount?: Maybe<Order_By>;
  code?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  customer_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  invoice_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Customer_Usage_Min_Fields = {
  __typename?: 'customer_usage_min_fields';
  amount?: Maybe<Scalars['float8']>;
  code?: Maybe<Scalars['citext']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  invoice_id?: Maybe<Scalars['String']>;
};

/** order by min() on columns of table "customer_usage" */
export type Customer_Usage_Min_Order_By = {
  amount?: Maybe<Order_By>;
  code?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  customer_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  invoice_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "customer_usage" */
export type Customer_Usage_Mutation_Response = {
  __typename?: 'customer_usage_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Customer_Usage>;
};

/** on_conflict condition type for table "customer_usage" */
export type Customer_Usage_On_Conflict = {
  constraint: Customer_Usage_Constraint;
  update_columns?: Array<Customer_Usage_Update_Column>;
  where?: Maybe<Customer_Usage_Bool_Exp>;
};

/** Ordering options when selecting data from "customer_usage". */
export type Customer_Usage_Order_By = {
  amount?: Maybe<Order_By>;
  code?: Maybe<Order_By>;
  coupon?: Maybe<Coupon_Order_By>;
  created_at?: Maybe<Order_By>;
  customer_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  invoice_id?: Maybe<Order_By>;
  user?: Maybe<Users_Order_By>;
};

/** primary key columns input for table: customer_usage */
export type Customer_Usage_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "customer_usage" */
export enum Customer_Usage_Select_Column {
  /** column name */
  Amount = 'amount',
  /** column name */
  Code = 'code',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomerId = 'customer_id',
  /** column name */
  Id = 'id',
  /** column name */
  InvoiceId = 'invoice_id',
}

/** select "customer_usage_aggregate_bool_exp_avg_arguments_columns" columns of table "customer_usage" */
export enum Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Avg_Arguments_Columns {
  /** column name */
  Amount = 'amount',
}

/** select "customer_usage_aggregate_bool_exp_corr_arguments_columns" columns of table "customer_usage" */
export enum Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Corr_Arguments_Columns {
  /** column name */
  Amount = 'amount',
}

/** select "customer_usage_aggregate_bool_exp_covar_samp_arguments_columns" columns of table "customer_usage" */
export enum Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Covar_Samp_Arguments_Columns {
  /** column name */
  Amount = 'amount',
}

/** select "customer_usage_aggregate_bool_exp_max_arguments_columns" columns of table "customer_usage" */
export enum Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Max_Arguments_Columns {
  /** column name */
  Amount = 'amount',
}

/** select "customer_usage_aggregate_bool_exp_min_arguments_columns" columns of table "customer_usage" */
export enum Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Min_Arguments_Columns {
  /** column name */
  Amount = 'amount',
}

/** select "customer_usage_aggregate_bool_exp_stddev_samp_arguments_columns" columns of table "customer_usage" */
export enum Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Stddev_Samp_Arguments_Columns {
  /** column name */
  Amount = 'amount',
}

/** select "customer_usage_aggregate_bool_exp_sum_arguments_columns" columns of table "customer_usage" */
export enum Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Sum_Arguments_Columns {
  /** column name */
  Amount = 'amount',
}

/** select "customer_usage_aggregate_bool_exp_var_samp_arguments_columns" columns of table "customer_usage" */
export enum Customer_Usage_Select_Column_Customer_Usage_Aggregate_Bool_Exp_Var_Samp_Arguments_Columns {
  /** column name */
  Amount = 'amount',
}

/** input type for updating data in table "customer_usage" */
export type Customer_Usage_Set_Input = {
  amount?: Maybe<Scalars['float8']>;
  code?: Maybe<Scalars['citext']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  invoice_id?: Maybe<Scalars['String']>;
};

/** aggregate stddev on columns */
export type Customer_Usage_Stddev_Fields = {
  __typename?: 'customer_usage_stddev_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "customer_usage" */
export type Customer_Usage_Stddev_Order_By = {
  amount?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Customer_Usage_Stddev_Pop_Fields = {
  __typename?: 'customer_usage_stddev_pop_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "customer_usage" */
export type Customer_Usage_Stddev_Pop_Order_By = {
  amount?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Customer_Usage_Stddev_Samp_Fields = {
  __typename?: 'customer_usage_stddev_samp_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "customer_usage" */
export type Customer_Usage_Stddev_Samp_Order_By = {
  amount?: Maybe<Order_By>;
};

/** Streaming cursor of the table "customer_usage" */
export type Customer_Usage_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Customer_Usage_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Customer_Usage_Stream_Cursor_Value_Input = {
  amount?: Maybe<Scalars['float8']>;
  code?: Maybe<Scalars['citext']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_id?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  invoice_id?: Maybe<Scalars['String']>;
};

/** aggregate sum on columns */
export type Customer_Usage_Sum_Fields = {
  __typename?: 'customer_usage_sum_fields';
  amount?: Maybe<Scalars['float8']>;
};

/** order by sum() on columns of table "customer_usage" */
export type Customer_Usage_Sum_Order_By = {
  amount?: Maybe<Order_By>;
};

/** update columns of table "customer_usage" */
export enum Customer_Usage_Update_Column {
  /** column name */
  Amount = 'amount',
  /** column name */
  Code = 'code',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomerId = 'customer_id',
  /** column name */
  Id = 'id',
  /** column name */
  InvoiceId = 'invoice_id',
}

export type Customer_Usage_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Customer_Usage_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Customer_Usage_Set_Input>;
  /** filter the rows which have to be updated */
  where: Customer_Usage_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Customer_Usage_Var_Pop_Fields = {
  __typename?: 'customer_usage_var_pop_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "customer_usage" */
export type Customer_Usage_Var_Pop_Order_By = {
  amount?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Customer_Usage_Var_Samp_Fields = {
  __typename?: 'customer_usage_var_samp_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "customer_usage" */
export type Customer_Usage_Var_Samp_Order_By = {
  amount?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Customer_Usage_Variance_Fields = {
  __typename?: 'customer_usage_variance_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "customer_usage" */
export type Customer_Usage_Variance_Order_By = {
  amount?: Maybe<Order_By>;
};

/** columns and relationships of "data_connector_type" */
export type Data_Connector_Type = {
  __typename?: 'data_connector_type';
  description?: Maybe<Scalars['String']>;
  name: Scalars['String'];
};

/** aggregated selection of "data_connector_type" */
export type Data_Connector_Type_Aggregate = {
  __typename?: 'data_connector_type_aggregate';
  aggregate?: Maybe<Data_Connector_Type_Aggregate_Fields>;
  nodes: Array<Data_Connector_Type>;
};

/** aggregate fields of "data_connector_type" */
export type Data_Connector_Type_Aggregate_Fields = {
  __typename?: 'data_connector_type_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Data_Connector_Type_Max_Fields>;
  min?: Maybe<Data_Connector_Type_Min_Fields>;
};

/** aggregate fields of "data_connector_type" */
export type Data_Connector_Type_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Data_Connector_Type_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "data_connector_type". All fields are combined with a logical 'AND'. */
export type Data_Connector_Type_Bool_Exp = {
  _and?: Maybe<Array<Data_Connector_Type_Bool_Exp>>;
  _not?: Maybe<Data_Connector_Type_Bool_Exp>;
  _or?: Maybe<Array<Data_Connector_Type_Bool_Exp>>;
  description?: Maybe<String_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "data_connector_type" */
export enum Data_Connector_Type_Constraint {
  /** unique or primary key constraint on columns "name" */
  DataConnectorTypePkey = 'data_connector_type_pkey',
}

export enum Data_Connector_Type_Enum {
  MongodbConnector = 'mongodb_connector',
  SuperConnector = 'super_connector',
}

/** Boolean expression to compare columns of type "data_connector_type_enum". All fields are combined with logical 'AND'. */
export type Data_Connector_Type_Enum_Comparison_Exp = {
  _eq?: Maybe<Data_Connector_Type_Enum>;
  _in?: Maybe<Array<Data_Connector_Type_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Data_Connector_Type_Enum>;
  _nin?: Maybe<Array<Data_Connector_Type_Enum>>;
};

/** input type for inserting data into table "data_connector_type" */
export type Data_Connector_Type_Insert_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Data_Connector_Type_Max_Fields = {
  __typename?: 'data_connector_type_max_fields';
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Data_Connector_Type_Min_Fields = {
  __typename?: 'data_connector_type_min_fields';
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "data_connector_type" */
export type Data_Connector_Type_Mutation_Response = {
  __typename?: 'data_connector_type_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Data_Connector_Type>;
};

/** on_conflict condition type for table "data_connector_type" */
export type Data_Connector_Type_On_Conflict = {
  constraint: Data_Connector_Type_Constraint;
  update_columns?: Array<Data_Connector_Type_Update_Column>;
  where?: Maybe<Data_Connector_Type_Bool_Exp>;
};

/** Ordering options when selecting data from "data_connector_type". */
export type Data_Connector_Type_Order_By = {
  description?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
};

/** primary key columns input for table: data_connector_type */
export type Data_Connector_Type_Pk_Columns_Input = {
  name: Scalars['String'];
};

/** select columns of table "data_connector_type" */
export enum Data_Connector_Type_Select_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Name = 'name',
}

/** input type for updating data in table "data_connector_type" */
export type Data_Connector_Type_Set_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "data_connector_type" */
export type Data_Connector_Type_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Data_Connector_Type_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Data_Connector_Type_Stream_Cursor_Value_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** update columns of table "data_connector_type" */
export enum Data_Connector_Type_Update_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Name = 'name',
}

export type Data_Connector_Type_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Data_Connector_Type_Set_Input>;
  /** filter the rows which have to be updated */
  where: Data_Connector_Type_Bool_Exp;
};

/** Datadog exporter configuration by project */
export type Datadog_Config = {
  __typename?: 'datadog_config';
  created_at: Scalars['timestamptz'];
  /** region of the user's Datadog API key; this determines which Datadog API to use */
  datadog_region: Scalars['String'];
  host?: Maybe<Scalars['String']>;
  /** base64 encoded datadog api key */
  key: Scalars['String'];
  logs_last_logged: Scalars['timestamptz'];
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_last_logged: Scalars['timestamptz'];
  metrics_response_code?: Maybe<Scalars['Int']>;
  /** An object relationship */
  project: Projects;
  project_id: Scalars['uuid'];
  service_name?: Maybe<Scalars['String']>;
  tags?: Maybe<Scalars['String']>;
  traces_last_logged: Scalars['timestamptz'];
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** aggregated selection of "datadog_config" */
export type Datadog_Config_Aggregate = {
  __typename?: 'datadog_config_aggregate';
  aggregate?: Maybe<Datadog_Config_Aggregate_Fields>;
  nodes: Array<Datadog_Config>;
};

/** aggregate fields of "datadog_config" */
export type Datadog_Config_Aggregate_Fields = {
  __typename?: 'datadog_config_aggregate_fields';
  avg?: Maybe<Datadog_Config_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Datadog_Config_Max_Fields>;
  min?: Maybe<Datadog_Config_Min_Fields>;
  stddev?: Maybe<Datadog_Config_Stddev_Fields>;
  stddev_pop?: Maybe<Datadog_Config_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Datadog_Config_Stddev_Samp_Fields>;
  sum?: Maybe<Datadog_Config_Sum_Fields>;
  var_pop?: Maybe<Datadog_Config_Var_Pop_Fields>;
  var_samp?: Maybe<Datadog_Config_Var_Samp_Fields>;
  variance?: Maybe<Datadog_Config_Variance_Fields>;
};

/** aggregate fields of "datadog_config" */
export type Datadog_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Datadog_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Datadog_Config_Avg_Fields = {
  __typename?: 'datadog_config_avg_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "datadog_config". All fields are combined with a logical 'AND'. */
export type Datadog_Config_Bool_Exp = {
  _and?: Maybe<Array<Datadog_Config_Bool_Exp>>;
  _not?: Maybe<Datadog_Config_Bool_Exp>;
  _or?: Maybe<Array<Datadog_Config_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  datadog_region?: Maybe<String_Comparison_Exp>;
  host?: Maybe<String_Comparison_Exp>;
  key?: Maybe<String_Comparison_Exp>;
  logs_last_logged?: Maybe<Timestamptz_Comparison_Exp>;
  logs_response_code?: Maybe<Int_Comparison_Exp>;
  metrics_last_logged?: Maybe<Timestamptz_Comparison_Exp>;
  metrics_response_code?: Maybe<Int_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  service_name?: Maybe<String_Comparison_Exp>;
  tags?: Maybe<String_Comparison_Exp>;
  traces_last_logged?: Maybe<Timestamptz_Comparison_Exp>;
  traces_response_code?: Maybe<Int_Comparison_Exp>;
};

/** unique or primary key constraints on table "datadog_config" */
export enum Datadog_Config_Constraint {
  /** unique or primary key constraint on columns "project_id" */
  DatadogConfigPkey = 'datadog_config_pkey',
}

/** input type for incrementing numeric columns in table "datadog_config" */
export type Datadog_Config_Inc_Input = {
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "datadog_config" */
export type Datadog_Config_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  /** region of the user's Datadog API key; this determines which Datadog API to use */
  datadog_region?: Maybe<Scalars['String']>;
  host?: Maybe<Scalars['String']>;
  /** base64 encoded datadog api key */
  key?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  service_name?: Maybe<Scalars['String']>;
  tags?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** aggregate max on columns */
export type Datadog_Config_Max_Fields = {
  __typename?: 'datadog_config_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  /** region of the user's Datadog API key; this determines which Datadog API to use */
  datadog_region?: Maybe<Scalars['String']>;
  host?: Maybe<Scalars['String']>;
  /** base64 encoded datadog api key */
  key?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project_id?: Maybe<Scalars['uuid']>;
  service_name?: Maybe<Scalars['String']>;
  tags?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** aggregate min on columns */
export type Datadog_Config_Min_Fields = {
  __typename?: 'datadog_config_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  /** region of the user's Datadog API key; this determines which Datadog API to use */
  datadog_region?: Maybe<Scalars['String']>;
  host?: Maybe<Scalars['String']>;
  /** base64 encoded datadog api key */
  key?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project_id?: Maybe<Scalars['uuid']>;
  service_name?: Maybe<Scalars['String']>;
  tags?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** response of any mutation on the table "datadog_config" */
export type Datadog_Config_Mutation_Response = {
  __typename?: 'datadog_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Datadog_Config>;
};

/** input type for inserting object relation for remote table "datadog_config" */
export type Datadog_Config_Obj_Rel_Insert_Input = {
  data: Datadog_Config_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Datadog_Config_On_Conflict>;
};

/** on_conflict condition type for table "datadog_config" */
export type Datadog_Config_On_Conflict = {
  constraint: Datadog_Config_Constraint;
  update_columns?: Array<Datadog_Config_Update_Column>;
  where?: Maybe<Datadog_Config_Bool_Exp>;
};

/** Ordering options when selecting data from "datadog_config". */
export type Datadog_Config_Order_By = {
  created_at?: Maybe<Order_By>;
  datadog_region?: Maybe<Order_By>;
  host?: Maybe<Order_By>;
  key?: Maybe<Order_By>;
  logs_last_logged?: Maybe<Order_By>;
  logs_response_code?: Maybe<Order_By>;
  metrics_last_logged?: Maybe<Order_By>;
  metrics_response_code?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  service_name?: Maybe<Order_By>;
  tags?: Maybe<Order_By>;
  traces_last_logged?: Maybe<Order_By>;
  traces_response_code?: Maybe<Order_By>;
};

/** primary key columns input for table: datadog_config */
export type Datadog_Config_Pk_Columns_Input = {
  project_id: Scalars['uuid'];
};

/** select columns of table "datadog_config" */
export enum Datadog_Config_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DatadogRegion = 'datadog_region',
  /** column name */
  Host = 'host',
  /** column name */
  Key = 'key',
  /** column name */
  LogsLastLogged = 'logs_last_logged',
  /** column name */
  LogsResponseCode = 'logs_response_code',
  /** column name */
  MetricsLastLogged = 'metrics_last_logged',
  /** column name */
  MetricsResponseCode = 'metrics_response_code',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  ServiceName = 'service_name',
  /** column name */
  Tags = 'tags',
  /** column name */
  TracesLastLogged = 'traces_last_logged',
  /** column name */
  TracesResponseCode = 'traces_response_code',
}

/** input type for updating data in table "datadog_config" */
export type Datadog_Config_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  /** region of the user's Datadog API key; this determines which Datadog API to use */
  datadog_region?: Maybe<Scalars['String']>;
  host?: Maybe<Scalars['String']>;
  /** base64 encoded datadog api key */
  key?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project_id?: Maybe<Scalars['uuid']>;
  service_name?: Maybe<Scalars['String']>;
  tags?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** aggregate stddev on columns */
export type Datadog_Config_Stddev_Fields = {
  __typename?: 'datadog_config_stddev_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Datadog_Config_Stddev_Pop_Fields = {
  __typename?: 'datadog_config_stddev_pop_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Datadog_Config_Stddev_Samp_Fields = {
  __typename?: 'datadog_config_stddev_samp_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "datadog_config" */
export type Datadog_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Datadog_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Datadog_Config_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  /** region of the user's Datadog API key; this determines which Datadog API to use */
  datadog_region?: Maybe<Scalars['String']>;
  host?: Maybe<Scalars['String']>;
  /** base64 encoded datadog api key */
  key?: Maybe<Scalars['String']>;
  logs_last_logged?: Maybe<Scalars['timestamptz']>;
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_last_logged?: Maybe<Scalars['timestamptz']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  project_id?: Maybe<Scalars['uuid']>;
  service_name?: Maybe<Scalars['String']>;
  tags?: Maybe<Scalars['String']>;
  traces_last_logged?: Maybe<Scalars['timestamptz']>;
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** aggregate sum on columns */
export type Datadog_Config_Sum_Fields = {
  __typename?: 'datadog_config_sum_fields';
  logs_response_code?: Maybe<Scalars['Int']>;
  metrics_response_code?: Maybe<Scalars['Int']>;
  traces_response_code?: Maybe<Scalars['Int']>;
};

/** update columns of table "datadog_config" */
export enum Datadog_Config_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DatadogRegion = 'datadog_region',
  /** column name */
  Host = 'host',
  /** column name */
  Key = 'key',
  /** column name */
  LogsLastLogged = 'logs_last_logged',
  /** column name */
  LogsResponseCode = 'logs_response_code',
  /** column name */
  MetricsLastLogged = 'metrics_last_logged',
  /** column name */
  MetricsResponseCode = 'metrics_response_code',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  ServiceName = 'service_name',
  /** column name */
  Tags = 'tags',
  /** column name */
  TracesLastLogged = 'traces_last_logged',
  /** column name */
  TracesResponseCode = 'traces_response_code',
}

export type Datadog_Config_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Datadog_Config_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Datadog_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Datadog_Config_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Datadog_Config_Var_Pop_Fields = {
  __typename?: 'datadog_config_var_pop_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Datadog_Config_Var_Samp_Fields = {
  __typename?: 'datadog_config_var_samp_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Datadog_Config_Variance_Fields = {
  __typename?: 'datadog_config_variance_fields';
  logs_response_code?: Maybe<Scalars['Float']>;
  metrics_response_code?: Maybe<Scalars['Float']>;
  traces_response_code?: Maybe<Scalars['Float']>;
};

export type DatadogConfigResponse = {
  __typename?: 'DatadogConfigResponse';
  project_id: Scalars['uuid'];
};

/** Boolean expression to compare columns of type "date". All fields are combined with logical 'AND'. */
export type Date_Comparison_Exp = {
  _eq?: Maybe<Scalars['date']>;
  _gt?: Maybe<Scalars['date']>;
  _gte?: Maybe<Scalars['date']>;
  _in?: Maybe<Array<Scalars['date']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['date']>;
  _lte?: Maybe<Scalars['date']>;
  _neq?: Maybe<Scalars['date']>;
  _nin?: Maybe<Array<Scalars['date']>>;
};

/** Table to store whether the calculated db latency was displayed to the user or not */
export type Db_Latency = {
  __typename?: 'db_latency';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration: Scalars['Int'];
  created_at: Scalars['timestamptz'];
  id: Scalars['uuid'];
  is_change_region_clicked: Scalars['Boolean'];
  is_latency_displayed: Scalars['Boolean'];
  job_id: Scalars['uuid'];
  /** An object relationship */
  project?: Maybe<Projects>;
  project_id: Scalars['uuid'];
};

/** aggregated selection of "db_latency" */
export type Db_Latency_Aggregate = {
  __typename?: 'db_latency_aggregate';
  aggregate?: Maybe<Db_Latency_Aggregate_Fields>;
  nodes: Array<Db_Latency>;
};

/** aggregate fields of "db_latency" */
export type Db_Latency_Aggregate_Fields = {
  __typename?: 'db_latency_aggregate_fields';
  avg?: Maybe<Db_Latency_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Db_Latency_Max_Fields>;
  min?: Maybe<Db_Latency_Min_Fields>;
  stddev?: Maybe<Db_Latency_Stddev_Fields>;
  stddev_pop?: Maybe<Db_Latency_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Db_Latency_Stddev_Samp_Fields>;
  sum?: Maybe<Db_Latency_Sum_Fields>;
  var_pop?: Maybe<Db_Latency_Var_Pop_Fields>;
  var_samp?: Maybe<Db_Latency_Var_Samp_Fields>;
  variance?: Maybe<Db_Latency_Variance_Fields>;
};

/** aggregate fields of "db_latency" */
export type Db_Latency_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Db_Latency_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Db_Latency_Avg_Fields = {
  __typename?: 'db_latency_avg_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "db_latency". All fields are combined with a logical 'AND'. */
export type Db_Latency_Bool_Exp = {
  _and?: Maybe<Array<Db_Latency_Bool_Exp>>;
  _not?: Maybe<Db_Latency_Bool_Exp>;
  _or?: Maybe<Array<Db_Latency_Bool_Exp>>;
  console_check_duration?: Maybe<Int_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  is_change_region_clicked?: Maybe<Boolean_Comparison_Exp>;
  is_latency_displayed?: Maybe<Boolean_Comparison_Exp>;
  job_id?: Maybe<Uuid_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "db_latency" */
export enum Db_Latency_Constraint {
  /** unique or primary key constraint on columns "id" */
  DbLatencyPkey = 'db_latency_pkey',
}

/** input type for incrementing numeric columns in table "db_latency" */
export type Db_Latency_Inc_Input = {
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "db_latency" */
export type Db_Latency_Insert_Input = {
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  is_change_region_clicked?: Maybe<Scalars['Boolean']>;
  is_latency_displayed?: Maybe<Scalars['Boolean']>;
  job_id?: Maybe<Scalars['uuid']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Db_Latency_Max_Fields = {
  __typename?: 'db_latency_max_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  job_id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
};

/** aggregate min on columns */
export type Db_Latency_Min_Fields = {
  __typename?: 'db_latency_min_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  job_id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
};

/** response of any mutation on the table "db_latency" */
export type Db_Latency_Mutation_Response = {
  __typename?: 'db_latency_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Db_Latency>;
};

/** on_conflict condition type for table "db_latency" */
export type Db_Latency_On_Conflict = {
  constraint: Db_Latency_Constraint;
  update_columns?: Array<Db_Latency_Update_Column>;
  where?: Maybe<Db_Latency_Bool_Exp>;
};

/** Ordering options when selecting data from "db_latency". */
export type Db_Latency_Order_By = {
  console_check_duration?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  is_change_region_clicked?: Maybe<Order_By>;
  is_latency_displayed?: Maybe<Order_By>;
  job_id?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
};

/** primary key columns input for table: db_latency */
export type Db_Latency_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "db_latency" */
export enum Db_Latency_Select_Column {
  /** column name */
  ConsoleCheckDuration = 'console_check_duration',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  IsChangeRegionClicked = 'is_change_region_clicked',
  /** column name */
  IsLatencyDisplayed = 'is_latency_displayed',
  /** column name */
  JobId = 'job_id',
  /** column name */
  ProjectId = 'project_id',
}

/** input type for updating data in table "db_latency" */
export type Db_Latency_Set_Input = {
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  is_change_region_clicked?: Maybe<Scalars['Boolean']>;
  is_latency_displayed?: Maybe<Scalars['Boolean']>;
  job_id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
};

/** aggregate stddev on columns */
export type Db_Latency_Stddev_Fields = {
  __typename?: 'db_latency_stddev_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Db_Latency_Stddev_Pop_Fields = {
  __typename?: 'db_latency_stddev_pop_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Db_Latency_Stddev_Samp_Fields = {
  __typename?: 'db_latency_stddev_samp_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "db_latency" */
export type Db_Latency_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Db_Latency_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Db_Latency_Stream_Cursor_Value_Input = {
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  is_change_region_clicked?: Maybe<Scalars['Boolean']>;
  is_latency_displayed?: Maybe<Scalars['Boolean']>;
  job_id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
};

/** aggregate sum on columns */
export type Db_Latency_Sum_Fields = {
  __typename?: 'db_latency_sum_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Int']>;
};

/** update columns of table "db_latency" */
export enum Db_Latency_Update_Column {
  /** column name */
  ConsoleCheckDuration = 'console_check_duration',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  IsChangeRegionClicked = 'is_change_region_clicked',
  /** column name */
  IsLatencyDisplayed = 'is_latency_displayed',
  /** column name */
  JobId = 'job_id',
  /** column name */
  ProjectId = 'project_id',
}

export type Db_Latency_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Db_Latency_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Db_Latency_Set_Input>;
  /** filter the rows which have to be updated */
  where: Db_Latency_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Db_Latency_Var_Pop_Fields = {
  __typename?: 'db_latency_var_pop_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Db_Latency_Var_Samp_Fields = {
  __typename?: 'db_latency_var_samp_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Db_Latency_Variance_Fields = {
  __typename?: 'db_latency_variance_fields';
  /** duration it took for the console to send a request to API and wait for the result by polling jobs table in ms */
  console_check_duration?: Maybe<Scalars['Float']>;
};

/** columns and relationships of "ddn.build" */
export type Ddn_Build = {
  __typename?: 'ddn_build';
  /** An array relationship */
  build_sync_statuses: Array<Ddn_Build_Sync_Status>;
  /** An aggregate relationship */
  build_sync_statuses_aggregate: Ddn_Build_Sync_Status_Aggregate;
  created_at: Scalars['timestamptz'];
  description?: Maybe<Scalars['String']>;
  /** An array relationship */
  environments: Array<Ddn_Environment>;
  /** An aggregate relationship */
  environments_aggregate: Ddn_Environment_Aggregate;
  fqdn: Scalars['String'];
  id: Scalars['uuid'];
  /** this will be later moved to a blob storage */
  metadata_binary?: Maybe<Scalars['bytea']>;
  metadata_raw: Scalars['String'];
  ndc_configs: Scalars['jsonb'];
  parent_span_id?: Maybe<Scalars['String']>;
  /** An object relationship */
  project: Ddn_Projects;
  project_id: Scalars['uuid'];
  trace_id?: Maybe<Scalars['String']>;
  updated_at: Scalars['timestamptz'];
  version: Scalars['String'];
};

/** columns and relationships of "ddn.build" */
export type Ddn_BuildBuild_Sync_StatusesArgs = {
  distinct_on?: Maybe<Array<Ddn_Build_Sync_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Build_Sync_Status_Order_By>>;
  where?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
};

/** columns and relationships of "ddn.build" */
export type Ddn_BuildBuild_Sync_Statuses_AggregateArgs = {
  distinct_on?: Maybe<Array<Ddn_Build_Sync_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Build_Sync_Status_Order_By>>;
  where?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
};

/** columns and relationships of "ddn.build" */
export type Ddn_BuildEnvironmentsArgs = {
  distinct_on?: Maybe<Array<Ddn_Environment_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Environment_Order_By>>;
  where?: Maybe<Ddn_Environment_Bool_Exp>;
};

/** columns and relationships of "ddn.build" */
export type Ddn_BuildEnvironments_AggregateArgs = {
  distinct_on?: Maybe<Array<Ddn_Environment_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Environment_Order_By>>;
  where?: Maybe<Ddn_Environment_Bool_Exp>;
};

/** columns and relationships of "ddn.build" */
export type Ddn_BuildNdc_ConfigsArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "ddn.build" */
export type Ddn_Build_Aggregate = {
  __typename?: 'ddn_build_aggregate';
  aggregate?: Maybe<Ddn_Build_Aggregate_Fields>;
  nodes: Array<Ddn_Build>;
};

export type Ddn_Build_Aggregate_Bool_Exp = {
  count?: Maybe<Ddn_Build_Aggregate_Bool_Exp_Count>;
};

export type Ddn_Build_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Ddn_Build_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Ddn_Build_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "ddn.build" */
export type Ddn_Build_Aggregate_Fields = {
  __typename?: 'ddn_build_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Ddn_Build_Max_Fields>;
  min?: Maybe<Ddn_Build_Min_Fields>;
};

/** aggregate fields of "ddn.build" */
export type Ddn_Build_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Build_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "ddn.build" */
export type Ddn_Build_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Ddn_Build_Max_Order_By>;
  min?: Maybe<Ddn_Build_Min_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Ddn_Build_Append_Input = {
  ndc_configs?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "ddn.build" */
export type Ddn_Build_Arr_Rel_Insert_Input = {
  data: Array<Ddn_Build_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Build_On_Conflict>;
};

/** Boolean expression to filter rows from the table "ddn.build". All fields are combined with a logical 'AND'. */
export type Ddn_Build_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Build_Bool_Exp>>;
  _not?: Maybe<Ddn_Build_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Build_Bool_Exp>>;
  build_sync_statuses?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
  build_sync_statuses_aggregate?: Maybe<Ddn_Build_Sync_Status_Aggregate_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  description?: Maybe<String_Comparison_Exp>;
  environments?: Maybe<Ddn_Environment_Bool_Exp>;
  environments_aggregate?: Maybe<Ddn_Environment_Aggregate_Bool_Exp>;
  fqdn?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  metadata_binary?: Maybe<Bytea_Comparison_Exp>;
  metadata_raw?: Maybe<String_Comparison_Exp>;
  ndc_configs?: Maybe<Jsonb_Comparison_Exp>;
  parent_span_id?: Maybe<String_Comparison_Exp>;
  project?: Maybe<Ddn_Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  trace_id?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  version?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "ddn.build" */
export enum Ddn_Build_Constraint {
  /** unique or primary key constraint on columns "fqdn" */
  BuildFqdnKey = 'build_fqdn_key',
  /** unique or primary key constraint on columns "id" */
  BuildPkey = 'build_pkey',
  /** unique or primary key constraint on columns "project_id", "id" */
  UniqueProjectAndBuild = 'unique_project_and_build',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Ddn_Build_Delete_At_Path_Input = {
  ndc_configs?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Ddn_Build_Delete_Elem_Input = {
  ndc_configs?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Ddn_Build_Delete_Key_Input = {
  ndc_configs?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "ddn.build" */
export type Ddn_Build_Insert_Input = {
  build_sync_statuses?: Maybe<Ddn_Build_Sync_Status_Arr_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  environments?: Maybe<Ddn_Environment_Arr_Rel_Insert_Input>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  /** this will be later moved to a blob storage */
  metadata_binary?: Maybe<Scalars['bytea']>;
  metadata_raw?: Maybe<Scalars['String']>;
  ndc_configs?: Maybe<Scalars['jsonb']>;
  parent_span_id?: Maybe<Scalars['String']>;
  project?: Maybe<Ddn_Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  trace_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  version?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Ddn_Build_Max_Fields = {
  __typename?: 'ddn_build_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  metadata_raw?: Maybe<Scalars['String']>;
  parent_span_id?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  trace_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  version?: Maybe<Scalars['String']>;
};

/** order by max() on columns of table "ddn.build" */
export type Ddn_Build_Max_Order_By = {
  created_at?: Maybe<Order_By>;
  description?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  metadata_raw?: Maybe<Order_By>;
  parent_span_id?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  trace_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  version?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Ddn_Build_Min_Fields = {
  __typename?: 'ddn_build_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  metadata_raw?: Maybe<Scalars['String']>;
  parent_span_id?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  trace_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  version?: Maybe<Scalars['String']>;
};

/** order by min() on columns of table "ddn.build" */
export type Ddn_Build_Min_Order_By = {
  created_at?: Maybe<Order_By>;
  description?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  metadata_raw?: Maybe<Order_By>;
  parent_span_id?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  trace_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  version?: Maybe<Order_By>;
};

/** response of any mutation on the table "ddn.build" */
export type Ddn_Build_Mutation_Response = {
  __typename?: 'ddn_build_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Build>;
};

/** input type for inserting object relation for remote table "ddn.build" */
export type Ddn_Build_Obj_Rel_Insert_Input = {
  data: Ddn_Build_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Build_On_Conflict>;
};

/** on_conflict condition type for table "ddn.build" */
export type Ddn_Build_On_Conflict = {
  constraint: Ddn_Build_Constraint;
  update_columns?: Array<Ddn_Build_Update_Column>;
  where?: Maybe<Ddn_Build_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.build". */
export type Ddn_Build_Order_By = {
  build_sync_statuses_aggregate?: Maybe<Ddn_Build_Sync_Status_Aggregate_Order_By>;
  created_at?: Maybe<Order_By>;
  description?: Maybe<Order_By>;
  environments_aggregate?: Maybe<Ddn_Environment_Aggregate_Order_By>;
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  metadata_binary?: Maybe<Order_By>;
  metadata_raw?: Maybe<Order_By>;
  ndc_configs?: Maybe<Order_By>;
  parent_span_id?: Maybe<Order_By>;
  project?: Maybe<Ddn_Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  trace_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  version?: Maybe<Order_By>;
};

/** primary key columns input for table: ddn.build */
export type Ddn_Build_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Ddn_Build_Prepend_Input = {
  ndc_configs?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "ddn.build" */
export enum Ddn_Build_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Description = 'description',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  MetadataBinary = 'metadata_binary',
  /** column name */
  MetadataRaw = 'metadata_raw',
  /** column name */
  NdcConfigs = 'ndc_configs',
  /** column name */
  ParentSpanId = 'parent_span_id',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  TraceId = 'trace_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Version = 'version',
}

/** input type for updating data in table "ddn.build" */
export type Ddn_Build_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  /** this will be later moved to a blob storage */
  metadata_binary?: Maybe<Scalars['bytea']>;
  metadata_raw?: Maybe<Scalars['String']>;
  ndc_configs?: Maybe<Scalars['jsonb']>;
  parent_span_id?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  trace_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  version?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "ddn_build" */
export type Ddn_Build_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Build_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Build_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  description?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  /** this will be later moved to a blob storage */
  metadata_binary?: Maybe<Scalars['bytea']>;
  metadata_raw?: Maybe<Scalars['String']>;
  ndc_configs?: Maybe<Scalars['jsonb']>;
  parent_span_id?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  trace_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  version?: Maybe<Scalars['String']>;
};

/** columns and relationships of "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status = {
  __typename?: 'ddn_build_sync_status';
  /** An object relationship */
  build: Ddn_Build;
  build_id: Scalars['uuid'];
  /** An object relationship */
  build_sync_worker: Ddn_Build_Sync_Worker;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** An object relationship */
  environment?: Maybe<Ddn_Environment>;
  environment_id?: Maybe<Scalars['uuid']>;
  id: Scalars['uuid'];
  status?: Maybe<Scalars['String']>;
  updated_at: Scalars['timestamptz'];
  worker_id: Scalars['uuid'];
};

/** aggregated selection of "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Aggregate = {
  __typename?: 'ddn_build_sync_status_aggregate';
  aggregate?: Maybe<Ddn_Build_Sync_Status_Aggregate_Fields>;
  nodes: Array<Ddn_Build_Sync_Status>;
};

export type Ddn_Build_Sync_Status_Aggregate_Bool_Exp = {
  count?: Maybe<Ddn_Build_Sync_Status_Aggregate_Bool_Exp_Count>;
};

export type Ddn_Build_Sync_Status_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Ddn_Build_Sync_Status_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Aggregate_Fields = {
  __typename?: 'ddn_build_sync_status_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Ddn_Build_Sync_Status_Max_Fields>;
  min?: Maybe<Ddn_Build_Sync_Status_Min_Fields>;
};

/** aggregate fields of "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Build_Sync_Status_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Ddn_Build_Sync_Status_Max_Order_By>;
  min?: Maybe<Ddn_Build_Sync_Status_Min_Order_By>;
};

/** input type for inserting array relation for remote table "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Arr_Rel_Insert_Input = {
  data: Array<Ddn_Build_Sync_Status_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Build_Sync_Status_On_Conflict>;
};

/** Boolean expression to filter rows from the table "ddn.build_sync_status". All fields are combined with a logical 'AND'. */
export type Ddn_Build_Sync_Status_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Build_Sync_Status_Bool_Exp>>;
  _not?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Build_Sync_Status_Bool_Exp>>;
  build?: Maybe<Ddn_Build_Bool_Exp>;
  build_id?: Maybe<Uuid_Comparison_Exp>;
  build_sync_worker?: Maybe<Ddn_Build_Sync_Worker_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  environment?: Maybe<Ddn_Environment_Bool_Exp>;
  environment_id?: Maybe<Uuid_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  worker_id?: Maybe<Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "ddn.build_sync_status" */
export enum Ddn_Build_Sync_Status_Constraint {
  /** unique or primary key constraint on columns "environment_id", "worker_id", "build_id" */
  BuildSyncStatusBuildIdWorkerIdEnvironmentIdKey = 'build_sync_status_build_id_worker_id_environment_id_key',
  /** unique or primary key constraint on columns "id" */
  BuildSyncStatusPkey = 'build_sync_status_pkey',
}

/** input type for inserting data into table "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Insert_Input = {
  build?: Maybe<Ddn_Build_Obj_Rel_Insert_Input>;
  build_id?: Maybe<Scalars['uuid']>;
  build_sync_worker?: Maybe<Ddn_Build_Sync_Worker_Obj_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  environment?: Maybe<Ddn_Environment_Obj_Rel_Insert_Input>;
  environment_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Ddn_Build_Sync_Status_Max_Fields = {
  __typename?: 'ddn_build_sync_status_max_fields';
  build_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  environment_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** order by max() on columns of table "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Max_Order_By = {
  build_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  environment_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Ddn_Build_Sync_Status_Min_Fields = {
  __typename?: 'ddn_build_sync_status_min_fields';
  build_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  environment_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** order by min() on columns of table "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Min_Order_By = {
  build_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  environment_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Mutation_Response = {
  __typename?: 'ddn_build_sync_status_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Build_Sync_Status>;
};

/** on_conflict condition type for table "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_On_Conflict = {
  constraint: Ddn_Build_Sync_Status_Constraint;
  update_columns?: Array<Ddn_Build_Sync_Status_Update_Column>;
  where?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.build_sync_status". */
export type Ddn_Build_Sync_Status_Order_By = {
  build?: Maybe<Ddn_Build_Order_By>;
  build_id?: Maybe<Order_By>;
  build_sync_worker?: Maybe<Ddn_Build_Sync_Worker_Order_By>;
  created_at?: Maybe<Order_By>;
  environment?: Maybe<Ddn_Environment_Order_By>;
  environment_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** primary key columns input for table: ddn.build_sync_status */
export type Ddn_Build_Sync_Status_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "ddn.build_sync_status" */
export enum Ddn_Build_Sync_Status_Select_Column {
  /** column name */
  BuildId = 'build_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  EnvironmentId = 'environment_id',
  /** column name */
  Id = 'id',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  WorkerId = 'worker_id',
}

/** input type for updating data in table "ddn.build_sync_status" */
export type Ddn_Build_Sync_Status_Set_Input = {
  build_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  environment_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** Streaming cursor of the table "ddn_build_sync_status" */
export type Ddn_Build_Sync_Status_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Build_Sync_Status_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Build_Sync_Status_Stream_Cursor_Value_Input = {
  build_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  environment_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** update columns of table "ddn.build_sync_status" */
export enum Ddn_Build_Sync_Status_Update_Column {
  /** column name */
  BuildId = 'build_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  EnvironmentId = 'environment_id',
  /** column name */
  Id = 'id',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  WorkerId = 'worker_id',
}

export type Ddn_Build_Sync_Status_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Build_Sync_Status_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Build_Sync_Status_Bool_Exp;
};

/** columns and relationships of "ddn.build_sync_worker" */
export type Ddn_Build_Sync_Worker = {
  __typename?: 'ddn_build_sync_worker';
  /** An array relationship */
  build_sync_statuses: Array<Ddn_Build_Sync_Status>;
  /** An aggregate relationship */
  build_sync_statuses_aggregate: Ddn_Build_Sync_Status_Aggregate;
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id: Scalars['uuid'];
  is_active: Scalars['Boolean'];
  region?: Maybe<Scalars['String']>;
  /** An object relationship */
  regionByCloudRegion?: Maybe<Region>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** columns and relationships of "ddn.build_sync_worker" */
export type Ddn_Build_Sync_WorkerBuild_Sync_StatusesArgs = {
  distinct_on?: Maybe<Array<Ddn_Build_Sync_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Build_Sync_Status_Order_By>>;
  where?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
};

/** columns and relationships of "ddn.build_sync_worker" */
export type Ddn_Build_Sync_WorkerBuild_Sync_Statuses_AggregateArgs = {
  distinct_on?: Maybe<Array<Ddn_Build_Sync_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Build_Sync_Status_Order_By>>;
  where?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
};

/** aggregated selection of "ddn.build_sync_worker" */
export type Ddn_Build_Sync_Worker_Aggregate = {
  __typename?: 'ddn_build_sync_worker_aggregate';
  aggregate?: Maybe<Ddn_Build_Sync_Worker_Aggregate_Fields>;
  nodes: Array<Ddn_Build_Sync_Worker>;
};

/** aggregate fields of "ddn.build_sync_worker" */
export type Ddn_Build_Sync_Worker_Aggregate_Fields = {
  __typename?: 'ddn_build_sync_worker_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Ddn_Build_Sync_Worker_Max_Fields>;
  min?: Maybe<Ddn_Build_Sync_Worker_Min_Fields>;
};

/** aggregate fields of "ddn.build_sync_worker" */
export type Ddn_Build_Sync_Worker_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Build_Sync_Worker_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "ddn.build_sync_worker". All fields are combined with a logical 'AND'. */
export type Ddn_Build_Sync_Worker_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Build_Sync_Worker_Bool_Exp>>;
  _not?: Maybe<Ddn_Build_Sync_Worker_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Build_Sync_Worker_Bool_Exp>>;
  build_sync_statuses?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
  build_sync_statuses_aggregate?: Maybe<Ddn_Build_Sync_Status_Aggregate_Bool_Exp>;
  cloud?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  is_active?: Maybe<Boolean_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  regionByCloudRegion?: Maybe<Region_Bool_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "ddn.build_sync_worker" */
export enum Ddn_Build_Sync_Worker_Constraint {
  /** unique or primary key constraint on columns "id" */
  BuildSyncWorkerPkey = 'build_sync_worker_pkey',
}

/** input type for inserting data into table "ddn.build_sync_worker" */
export type Ddn_Build_Sync_Worker_Insert_Input = {
  build_sync_statuses?: Maybe<Ddn_Build_Sync_Status_Arr_Rel_Insert_Input>;
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  is_active?: Maybe<Scalars['Boolean']>;
  region?: Maybe<Scalars['String']>;
  regionByCloudRegion?: Maybe<Region_Obj_Rel_Insert_Input>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Ddn_Build_Sync_Worker_Max_Fields = {
  __typename?: 'ddn_build_sync_worker_max_fields';
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Ddn_Build_Sync_Worker_Min_Fields = {
  __typename?: 'ddn_build_sync_worker_min_fields';
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "ddn.build_sync_worker" */
export type Ddn_Build_Sync_Worker_Mutation_Response = {
  __typename?: 'ddn_build_sync_worker_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Build_Sync_Worker>;
};

/** input type for inserting object relation for remote table "ddn.build_sync_worker" */
export type Ddn_Build_Sync_Worker_Obj_Rel_Insert_Input = {
  data: Ddn_Build_Sync_Worker_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Build_Sync_Worker_On_Conflict>;
};

/** on_conflict condition type for table "ddn.build_sync_worker" */
export type Ddn_Build_Sync_Worker_On_Conflict = {
  constraint: Ddn_Build_Sync_Worker_Constraint;
  update_columns?: Array<Ddn_Build_Sync_Worker_Update_Column>;
  where?: Maybe<Ddn_Build_Sync_Worker_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.build_sync_worker". */
export type Ddn_Build_Sync_Worker_Order_By = {
  build_sync_statuses_aggregate?: Maybe<Ddn_Build_Sync_Status_Aggregate_Order_By>;
  cloud?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  is_active?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  regionByCloudRegion?: Maybe<Region_Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: ddn.build_sync_worker */
export type Ddn_Build_Sync_Worker_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "ddn.build_sync_worker" */
export enum Ddn_Build_Sync_Worker_Select_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  Region = 'region',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "ddn.build_sync_worker" */
export type Ddn_Build_Sync_Worker_Set_Input = {
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  is_active?: Maybe<Scalars['Boolean']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "ddn_build_sync_worker" */
export type Ddn_Build_Sync_Worker_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Build_Sync_Worker_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Build_Sync_Worker_Stream_Cursor_Value_Input = {
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  is_active?: Maybe<Scalars['Boolean']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "ddn.build_sync_worker" */
export enum Ddn_Build_Sync_Worker_Update_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  Region = 'region',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Ddn_Build_Sync_Worker_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Build_Sync_Worker_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Build_Sync_Worker_Bool_Exp;
};

/** update columns of table "ddn.build" */
export enum Ddn_Build_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Description = 'description',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  MetadataBinary = 'metadata_binary',
  /** column name */
  MetadataRaw = 'metadata_raw',
  /** column name */
  NdcConfigs = 'ndc_configs',
  /** column name */
  ParentSpanId = 'parent_span_id',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  TraceId = 'trace_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Version = 'version',
}

export type Ddn_Build_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Ddn_Build_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Ddn_Build_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Ddn_Build_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Ddn_Build_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Ddn_Build_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Build_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Build_Bool_Exp;
};

/** columns and relationships of "ddn.environment" */
export type Ddn_Environment = {
  __typename?: 'ddn_environment';
  /** An object relationship */
  build?: Maybe<Ddn_Build>;
  /** An array relationship */
  build_sync_statuses: Array<Ddn_Build_Sync_Status>;
  /** An aggregate relationship */
  build_sync_statuses_aggregate: Ddn_Build_Sync_Status_Aggregate;
  created_at: Scalars['timestamptz'];
  current_build_id?: Maybe<Scalars['uuid']>;
  fqdn: Scalars['String'];
  id: Scalars['uuid'];
  name: Scalars['String'];
  /** An object relationship */
  project: Ddn_Projects;
  project_id: Scalars['uuid'];
  updated_at: Scalars['timestamptz'];
};

/** columns and relationships of "ddn.environment" */
export type Ddn_EnvironmentBuild_Sync_StatusesArgs = {
  distinct_on?: Maybe<Array<Ddn_Build_Sync_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Build_Sync_Status_Order_By>>;
  where?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
};

/** columns and relationships of "ddn.environment" */
export type Ddn_EnvironmentBuild_Sync_Statuses_AggregateArgs = {
  distinct_on?: Maybe<Array<Ddn_Build_Sync_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Build_Sync_Status_Order_By>>;
  where?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
};

/** aggregated selection of "ddn.environment" */
export type Ddn_Environment_Aggregate = {
  __typename?: 'ddn_environment_aggregate';
  aggregate?: Maybe<Ddn_Environment_Aggregate_Fields>;
  nodes: Array<Ddn_Environment>;
};

export type Ddn_Environment_Aggregate_Bool_Exp = {
  count?: Maybe<Ddn_Environment_Aggregate_Bool_Exp_Count>;
};

export type Ddn_Environment_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Ddn_Environment_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Ddn_Environment_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "ddn.environment" */
export type Ddn_Environment_Aggregate_Fields = {
  __typename?: 'ddn_environment_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Ddn_Environment_Max_Fields>;
  min?: Maybe<Ddn_Environment_Min_Fields>;
};

/** aggregate fields of "ddn.environment" */
export type Ddn_Environment_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Environment_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "ddn.environment" */
export type Ddn_Environment_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Ddn_Environment_Max_Order_By>;
  min?: Maybe<Ddn_Environment_Min_Order_By>;
};

/** input type for inserting array relation for remote table "ddn.environment" */
export type Ddn_Environment_Arr_Rel_Insert_Input = {
  data: Array<Ddn_Environment_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Environment_On_Conflict>;
};

/** Boolean expression to filter rows from the table "ddn.environment". All fields are combined with a logical 'AND'. */
export type Ddn_Environment_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Environment_Bool_Exp>>;
  _not?: Maybe<Ddn_Environment_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Environment_Bool_Exp>>;
  build?: Maybe<Ddn_Build_Bool_Exp>;
  build_sync_statuses?: Maybe<Ddn_Build_Sync_Status_Bool_Exp>;
  build_sync_statuses_aggregate?: Maybe<Ddn_Build_Sync_Status_Aggregate_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  current_build_id?: Maybe<Uuid_Comparison_Exp>;
  fqdn?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  project?: Maybe<Ddn_Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "ddn.environment" */
export enum Ddn_Environment_Constraint {
  /** unique or primary key constraint on columns "id" */
  EnvironmentPkey = 'environment_pkey',
}

/** input type for inserting data into table "ddn.environment" */
export type Ddn_Environment_Insert_Input = {
  build?: Maybe<Ddn_Build_Obj_Rel_Insert_Input>;
  build_sync_statuses?: Maybe<Ddn_Build_Sync_Status_Arr_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  current_build_id?: Maybe<Scalars['uuid']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  project?: Maybe<Ddn_Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Ddn_Environment_Max_Fields = {
  __typename?: 'ddn_environment_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  current_build_id?: Maybe<Scalars['uuid']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by max() on columns of table "ddn.environment" */
export type Ddn_Environment_Max_Order_By = {
  created_at?: Maybe<Order_By>;
  current_build_id?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Ddn_Environment_Min_Fields = {
  __typename?: 'ddn_environment_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  current_build_id?: Maybe<Scalars['uuid']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by min() on columns of table "ddn.environment" */
export type Ddn_Environment_Min_Order_By = {
  created_at?: Maybe<Order_By>;
  current_build_id?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** response of any mutation on the table "ddn.environment" */
export type Ddn_Environment_Mutation_Response = {
  __typename?: 'ddn_environment_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Environment>;
};

/** input type for inserting object relation for remote table "ddn.environment" */
export type Ddn_Environment_Obj_Rel_Insert_Input = {
  data: Ddn_Environment_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Environment_On_Conflict>;
};

/** on_conflict condition type for table "ddn.environment" */
export type Ddn_Environment_On_Conflict = {
  constraint: Ddn_Environment_Constraint;
  update_columns?: Array<Ddn_Environment_Update_Column>;
  where?: Maybe<Ddn_Environment_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.environment". */
export type Ddn_Environment_Order_By = {
  build?: Maybe<Ddn_Build_Order_By>;
  build_sync_statuses_aggregate?: Maybe<Ddn_Build_Sync_Status_Aggregate_Order_By>;
  created_at?: Maybe<Order_By>;
  current_build_id?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  project?: Maybe<Ddn_Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: ddn.environment */
export type Ddn_Environment_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "ddn.environment" */
export enum Ddn_Environment_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CurrentBuildId = 'current_build_id',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "ddn.environment" */
export type Ddn_Environment_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  current_build_id?: Maybe<Scalars['uuid']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "ddn_environment" */
export type Ddn_Environment_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Environment_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Environment_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  current_build_id?: Maybe<Scalars['uuid']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "ddn.environment" */
export enum Ddn_Environment_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CurrentBuildId = 'current_build_id',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Ddn_Environment_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Environment_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Environment_Bool_Exp;
};

/** columns and relationships of "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access = {
  __typename?: 'ddn_project_entitlement_access';
  created_at: Scalars['timestamp'];
  /** An object relationship */
  entitlement: Ddn_Project_Entitlement_Catalogue;
  entitlement_id: Scalars['uuid'];
  id: Scalars['uuid'];
  /** An object relationship */
  project: Ddn_Projects;
  project_id: Scalars['uuid'];
  updated_at: Scalars['timestamp'];
};

/** aggregated selection of "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Aggregate = {
  __typename?: 'ddn_project_entitlement_access_aggregate';
  aggregate?: Maybe<Ddn_Project_Entitlement_Access_Aggregate_Fields>;
  nodes: Array<Ddn_Project_Entitlement_Access>;
};

export type Ddn_Project_Entitlement_Access_Aggregate_Bool_Exp = {
  count?: Maybe<Ddn_Project_Entitlement_Access_Aggregate_Bool_Exp_Count>;
};

export type Ddn_Project_Entitlement_Access_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Ddn_Project_Entitlement_Access_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Ddn_Project_Entitlement_Access_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Aggregate_Fields = {
  __typename?: 'ddn_project_entitlement_access_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Ddn_Project_Entitlement_Access_Max_Fields>;
  min?: Maybe<Ddn_Project_Entitlement_Access_Min_Fields>;
};

/** aggregate fields of "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Project_Entitlement_Access_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Ddn_Project_Entitlement_Access_Max_Order_By>;
  min?: Maybe<Ddn_Project_Entitlement_Access_Min_Order_By>;
};

/** input type for inserting array relation for remote table "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Arr_Rel_Insert_Input = {
  data: Array<Ddn_Project_Entitlement_Access_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Project_Entitlement_Access_On_Conflict>;
};

/**
 * Boolean expression to filter rows from the table
 * "ddn.project_entitlement_access". All fields are combined with a logical 'AND'.
 */
export type Ddn_Project_Entitlement_Access_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Project_Entitlement_Access_Bool_Exp>>;
  _not?: Maybe<Ddn_Project_Entitlement_Access_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Project_Entitlement_Access_Bool_Exp>>;
  created_at?: Maybe<Timestamp_Comparison_Exp>;
  entitlement?: Maybe<Ddn_Project_Entitlement_Catalogue_Bool_Exp>;
  entitlement_id?: Maybe<Uuid_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  project?: Maybe<Ddn_Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  updated_at?: Maybe<Timestamp_Comparison_Exp>;
};

/** unique or primary key constraints on table "ddn.project_entitlement_access" */
export enum Ddn_Project_Entitlement_Access_Constraint {
  /** unique or primary key constraint on columns "id" */
  ProjectEntitlementAccessPkey = 'project_entitlement_access_pkey',
}

/** input type for inserting data into table "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Insert_Input = {
  created_at?: Maybe<Scalars['timestamp']>;
  entitlement?: Maybe<Ddn_Project_Entitlement_Catalogue_Obj_Rel_Insert_Input>;
  entitlement_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  project?: Maybe<Ddn_Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** aggregate max on columns */
export type Ddn_Project_Entitlement_Access_Max_Fields = {
  __typename?: 'ddn_project_entitlement_access_max_fields';
  created_at?: Maybe<Scalars['timestamp']>;
  entitlement_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** order by max() on columns of table "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Max_Order_By = {
  created_at?: Maybe<Order_By>;
  entitlement_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Ddn_Project_Entitlement_Access_Min_Fields = {
  __typename?: 'ddn_project_entitlement_access_min_fields';
  created_at?: Maybe<Scalars['timestamp']>;
  entitlement_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** order by min() on columns of table "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Min_Order_By = {
  created_at?: Maybe<Order_By>;
  entitlement_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** response of any mutation on the table "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Mutation_Response = {
  __typename?: 'ddn_project_entitlement_access_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Project_Entitlement_Access>;
};

/** on_conflict condition type for table "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_On_Conflict = {
  constraint: Ddn_Project_Entitlement_Access_Constraint;
  update_columns?: Array<Ddn_Project_Entitlement_Access_Update_Column>;
  where?: Maybe<Ddn_Project_Entitlement_Access_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.project_entitlement_access". */
export type Ddn_Project_Entitlement_Access_Order_By = {
  created_at?: Maybe<Order_By>;
  entitlement?: Maybe<Ddn_Project_Entitlement_Catalogue_Order_By>;
  entitlement_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  project?: Maybe<Ddn_Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: ddn.project_entitlement_access */
export type Ddn_Project_Entitlement_Access_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "ddn.project_entitlement_access" */
export enum Ddn_Project_Entitlement_Access_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  EntitlementId = 'entitlement_id',
  /** column name */
  Id = 'id',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "ddn.project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Set_Input = {
  created_at?: Maybe<Scalars['timestamp']>;
  entitlement_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** Streaming cursor of the table "ddn_project_entitlement_access" */
export type Ddn_Project_Entitlement_Access_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Project_Entitlement_Access_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Project_Entitlement_Access_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamp']>;
  entitlement_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** update columns of table "ddn.project_entitlement_access" */
export enum Ddn_Project_Entitlement_Access_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  EntitlementId = 'entitlement_id',
  /** column name */
  Id = 'id',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Ddn_Project_Entitlement_Access_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Project_Entitlement_Access_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Project_Entitlement_Access_Bool_Exp;
};

/** Stores all versions of all types of v3 project entitlements. */
export type Ddn_Project_Entitlement_Catalogue = {
  __typename?: 'ddn_project_entitlement_catalogue';
  config_is_enabled: Scalars['Boolean'];
  config_limit?: Maybe<Scalars['Int']>;
  created_at: Scalars['timestamp'];
  id: Scalars['uuid'];
  name: Scalars['String'];
  type: Ddn_Project_Entitlement_Types_Enum;
  updated_at: Scalars['timestamp'];
};

/** aggregated selection of "ddn.project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_Aggregate = {
  __typename?: 'ddn_project_entitlement_catalogue_aggregate';
  aggregate?: Maybe<Ddn_Project_Entitlement_Catalogue_Aggregate_Fields>;
  nodes: Array<Ddn_Project_Entitlement_Catalogue>;
};

/** aggregate fields of "ddn.project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_Aggregate_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_aggregate_fields';
  avg?: Maybe<Ddn_Project_Entitlement_Catalogue_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Ddn_Project_Entitlement_Catalogue_Max_Fields>;
  min?: Maybe<Ddn_Project_Entitlement_Catalogue_Min_Fields>;
  stddev?: Maybe<Ddn_Project_Entitlement_Catalogue_Stddev_Fields>;
  stddev_pop?: Maybe<Ddn_Project_Entitlement_Catalogue_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Ddn_Project_Entitlement_Catalogue_Stddev_Samp_Fields>;
  sum?: Maybe<Ddn_Project_Entitlement_Catalogue_Sum_Fields>;
  var_pop?: Maybe<Ddn_Project_Entitlement_Catalogue_Var_Pop_Fields>;
  var_samp?: Maybe<Ddn_Project_Entitlement_Catalogue_Var_Samp_Fields>;
  variance?: Maybe<Ddn_Project_Entitlement_Catalogue_Variance_Fields>;
};

/** aggregate fields of "ddn.project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Project_Entitlement_Catalogue_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Ddn_Project_Entitlement_Catalogue_Avg_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_avg_fields';
  config_limit?: Maybe<Scalars['Float']>;
};

/**
 * Boolean expression to filter rows from the table
 * "ddn.project_entitlement_catalogue". All fields are combined with a logical 'AND'.
 */
export type Ddn_Project_Entitlement_Catalogue_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Project_Entitlement_Catalogue_Bool_Exp>>;
  _not?: Maybe<Ddn_Project_Entitlement_Catalogue_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Project_Entitlement_Catalogue_Bool_Exp>>;
  config_is_enabled?: Maybe<Boolean_Comparison_Exp>;
  config_limit?: Maybe<Int_Comparison_Exp>;
  created_at?: Maybe<Timestamp_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  type?: Maybe<Ddn_Project_Entitlement_Types_Enum_Comparison_Exp>;
  updated_at?: Maybe<Timestamp_Comparison_Exp>;
};

/** unique or primary key constraints on table "ddn.project_entitlement_catalogue" */
export enum Ddn_Project_Entitlement_Catalogue_Constraint {
  /** unique or primary key constraint on columns "name" */
  ProjectEntitlementCatalogueNameKey = 'project_entitlement_catalogue_name_key',
  /** unique or primary key constraint on columns "id" */
  ProjectEntitlementCataloguePkey = 'project_entitlement_catalogue_pkey',
}

/** input type for incrementing numeric columns in table "ddn.project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_Inc_Input = {
  config_limit?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "ddn.project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_Insert_Input = {
  config_is_enabled?: Maybe<Scalars['Boolean']>;
  config_limit?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamp']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  type?: Maybe<Ddn_Project_Entitlement_Types_Enum>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** aggregate max on columns */
export type Ddn_Project_Entitlement_Catalogue_Max_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_max_fields';
  config_limit?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamp']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** aggregate min on columns */
export type Ddn_Project_Entitlement_Catalogue_Min_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_min_fields';
  config_limit?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamp']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** response of any mutation on the table "ddn.project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_Mutation_Response = {
  __typename?: 'ddn_project_entitlement_catalogue_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Project_Entitlement_Catalogue>;
};

/** input type for inserting object relation for remote table "ddn.project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_Obj_Rel_Insert_Input = {
  data: Ddn_Project_Entitlement_Catalogue_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Project_Entitlement_Catalogue_On_Conflict>;
};

/** on_conflict condition type for table "ddn.project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_On_Conflict = {
  constraint: Ddn_Project_Entitlement_Catalogue_Constraint;
  update_columns?: Array<Ddn_Project_Entitlement_Catalogue_Update_Column>;
  where?: Maybe<Ddn_Project_Entitlement_Catalogue_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.project_entitlement_catalogue". */
export type Ddn_Project_Entitlement_Catalogue_Order_By = {
  config_is_enabled?: Maybe<Order_By>;
  config_limit?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  type?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: ddn.project_entitlement_catalogue */
export type Ddn_Project_Entitlement_Catalogue_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "ddn.project_entitlement_catalogue" */
export enum Ddn_Project_Entitlement_Catalogue_Select_Column {
  /** column name */
  ConfigIsEnabled = 'config_is_enabled',
  /** column name */
  ConfigLimit = 'config_limit',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
  /** column name */
  Type = 'type',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "ddn.project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_Set_Input = {
  config_is_enabled?: Maybe<Scalars['Boolean']>;
  config_limit?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamp']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  type?: Maybe<Ddn_Project_Entitlement_Types_Enum>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** aggregate stddev on columns */
export type Ddn_Project_Entitlement_Catalogue_Stddev_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_stddev_fields';
  config_limit?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Ddn_Project_Entitlement_Catalogue_Stddev_Pop_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_stddev_pop_fields';
  config_limit?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Ddn_Project_Entitlement_Catalogue_Stddev_Samp_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_stddev_samp_fields';
  config_limit?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "ddn_project_entitlement_catalogue" */
export type Ddn_Project_Entitlement_Catalogue_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Project_Entitlement_Catalogue_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Project_Entitlement_Catalogue_Stream_Cursor_Value_Input = {
  config_is_enabled?: Maybe<Scalars['Boolean']>;
  config_limit?: Maybe<Scalars['Int']>;
  created_at?: Maybe<Scalars['timestamp']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  type?: Maybe<Ddn_Project_Entitlement_Types_Enum>;
  updated_at?: Maybe<Scalars['timestamp']>;
};

/** aggregate sum on columns */
export type Ddn_Project_Entitlement_Catalogue_Sum_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_sum_fields';
  config_limit?: Maybe<Scalars['Int']>;
};

/** update columns of table "ddn.project_entitlement_catalogue" */
export enum Ddn_Project_Entitlement_Catalogue_Update_Column {
  /** column name */
  ConfigIsEnabled = 'config_is_enabled',
  /** column name */
  ConfigLimit = 'config_limit',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
  /** column name */
  Type = 'type',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Ddn_Project_Entitlement_Catalogue_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Ddn_Project_Entitlement_Catalogue_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Project_Entitlement_Catalogue_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Project_Entitlement_Catalogue_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Ddn_Project_Entitlement_Catalogue_Var_Pop_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_var_pop_fields';
  config_limit?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Ddn_Project_Entitlement_Catalogue_Var_Samp_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_var_samp_fields';
  config_limit?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Ddn_Project_Entitlement_Catalogue_Variance_Fields = {
  __typename?: 'ddn_project_entitlement_catalogue_variance_fields';
  config_limit?: Maybe<Scalars['Float']>;
};

/** Enums representing types/categories of entitlements for a Hasura v3 project */
export type Ddn_Project_Entitlement_Types = {
  __typename?: 'ddn_project_entitlement_types';
  comment: Scalars['String'];
  value: Scalars['String'];
};

/** aggregated selection of "ddn.project_entitlement_types" */
export type Ddn_Project_Entitlement_Types_Aggregate = {
  __typename?: 'ddn_project_entitlement_types_aggregate';
  aggregate?: Maybe<Ddn_Project_Entitlement_Types_Aggregate_Fields>;
  nodes: Array<Ddn_Project_Entitlement_Types>;
};

/** aggregate fields of "ddn.project_entitlement_types" */
export type Ddn_Project_Entitlement_Types_Aggregate_Fields = {
  __typename?: 'ddn_project_entitlement_types_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Ddn_Project_Entitlement_Types_Max_Fields>;
  min?: Maybe<Ddn_Project_Entitlement_Types_Min_Fields>;
};

/** aggregate fields of "ddn.project_entitlement_types" */
export type Ddn_Project_Entitlement_Types_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Project_Entitlement_Types_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/**
 * Boolean expression to filter rows from the table
 * "ddn.project_entitlement_types". All fields are combined with a logical 'AND'.
 */
export type Ddn_Project_Entitlement_Types_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Project_Entitlement_Types_Bool_Exp>>;
  _not?: Maybe<Ddn_Project_Entitlement_Types_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Project_Entitlement_Types_Bool_Exp>>;
  comment?: Maybe<String_Comparison_Exp>;
  value?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "ddn.project_entitlement_types" */
export enum Ddn_Project_Entitlement_Types_Constraint {
  /** unique or primary key constraint on columns "value" */
  ProjectEntitlementTypesPkey = 'project_entitlement_types_pkey',
}

export enum Ddn_Project_Entitlement_Types_Enum {
  /** Maximum number of builds a v3 project can have at once */
  BuildLimit = 'build_limit',
  /** Maximum number of builds a v3 project can have at once */
  EnvironmentLimit = 'environment_limit',
  /** Maximum size in for a serialized metadata artifact */
  MetadataSizeLimit = 'metadata_size_limit',
}

/**
 * Boolean expression to compare columns of type
 * "ddn_project_entitlement_types_enum". All fields are combined with logical 'AND'.
 */
export type Ddn_Project_Entitlement_Types_Enum_Comparison_Exp = {
  _eq?: Maybe<Ddn_Project_Entitlement_Types_Enum>;
  _in?: Maybe<Array<Ddn_Project_Entitlement_Types_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Ddn_Project_Entitlement_Types_Enum>;
  _nin?: Maybe<Array<Ddn_Project_Entitlement_Types_Enum>>;
};

/** input type for inserting data into table "ddn.project_entitlement_types" */
export type Ddn_Project_Entitlement_Types_Insert_Input = {
  comment?: Maybe<Scalars['String']>;
  value?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Ddn_Project_Entitlement_Types_Max_Fields = {
  __typename?: 'ddn_project_entitlement_types_max_fields';
  comment?: Maybe<Scalars['String']>;
  value?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Ddn_Project_Entitlement_Types_Min_Fields = {
  __typename?: 'ddn_project_entitlement_types_min_fields';
  comment?: Maybe<Scalars['String']>;
  value?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "ddn.project_entitlement_types" */
export type Ddn_Project_Entitlement_Types_Mutation_Response = {
  __typename?: 'ddn_project_entitlement_types_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Project_Entitlement_Types>;
};

/** on_conflict condition type for table "ddn.project_entitlement_types" */
export type Ddn_Project_Entitlement_Types_On_Conflict = {
  constraint: Ddn_Project_Entitlement_Types_Constraint;
  update_columns?: Array<Ddn_Project_Entitlement_Types_Update_Column>;
  where?: Maybe<Ddn_Project_Entitlement_Types_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.project_entitlement_types". */
export type Ddn_Project_Entitlement_Types_Order_By = {
  comment?: Maybe<Order_By>;
  value?: Maybe<Order_By>;
};

/** primary key columns input for table: ddn.project_entitlement_types */
export type Ddn_Project_Entitlement_Types_Pk_Columns_Input = {
  value: Scalars['String'];
};

/** select columns of table "ddn.project_entitlement_types" */
export enum Ddn_Project_Entitlement_Types_Select_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Value = 'value',
}

/** input type for updating data in table "ddn.project_entitlement_types" */
export type Ddn_Project_Entitlement_Types_Set_Input = {
  comment?: Maybe<Scalars['String']>;
  value?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "ddn_project_entitlement_types" */
export type Ddn_Project_Entitlement_Types_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Project_Entitlement_Types_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Project_Entitlement_Types_Stream_Cursor_Value_Input = {
  comment?: Maybe<Scalars['String']>;
  value?: Maybe<Scalars['String']>;
};

/** update columns of table "ddn.project_entitlement_types" */
export enum Ddn_Project_Entitlement_Types_Update_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Value = 'value',
}

export type Ddn_Project_Entitlement_Types_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Project_Entitlement_Types_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Project_Entitlement_Types_Bool_Exp;
};

/** columns and relationships of "ddn.projects" */
export type Ddn_Projects = {
  __typename?: 'ddn_projects';
  /** An array relationship */
  builds: Array<Ddn_Build>;
  /** An aggregate relationship */
  builds_aggregate: Ddn_Build_Aggregate;
  created_at: Scalars['timestamptz'];
  /** An array relationship */
  entitlements: Array<Ddn_Project_Entitlement_Access>;
  /** An aggregate relationship */
  entitlements_aggregate: Ddn_Project_Entitlement_Access_Aggregate;
  /** An array relationship */
  environments: Array<Ddn_Environment>;
  /** An aggregate relationship */
  environments_aggregate: Ddn_Environment_Aggregate;
  id: Scalars['uuid'];
  name: Scalars['String'];
  owner_id: Scalars['uuid'];
  updated_at: Scalars['timestamptz'];
  /** An object relationship */
  user: Users;
};

/** columns and relationships of "ddn.projects" */
export type Ddn_ProjectsBuildsArgs = {
  distinct_on?: Maybe<Array<Ddn_Build_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Build_Order_By>>;
  where?: Maybe<Ddn_Build_Bool_Exp>;
};

/** columns and relationships of "ddn.projects" */
export type Ddn_ProjectsBuilds_AggregateArgs = {
  distinct_on?: Maybe<Array<Ddn_Build_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Build_Order_By>>;
  where?: Maybe<Ddn_Build_Bool_Exp>;
};

/** columns and relationships of "ddn.projects" */
export type Ddn_ProjectsEntitlementsArgs = {
  distinct_on?: Maybe<Array<Ddn_Project_Entitlement_Access_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Project_Entitlement_Access_Order_By>>;
  where?: Maybe<Ddn_Project_Entitlement_Access_Bool_Exp>;
};

/** columns and relationships of "ddn.projects" */
export type Ddn_ProjectsEntitlements_AggregateArgs = {
  distinct_on?: Maybe<Array<Ddn_Project_Entitlement_Access_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Project_Entitlement_Access_Order_By>>;
  where?: Maybe<Ddn_Project_Entitlement_Access_Bool_Exp>;
};

/** columns and relationships of "ddn.projects" */
export type Ddn_ProjectsEnvironmentsArgs = {
  distinct_on?: Maybe<Array<Ddn_Environment_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Environment_Order_By>>;
  where?: Maybe<Ddn_Environment_Bool_Exp>;
};

/** columns and relationships of "ddn.projects" */
export type Ddn_ProjectsEnvironments_AggregateArgs = {
  distinct_on?: Maybe<Array<Ddn_Environment_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Environment_Order_By>>;
  where?: Maybe<Ddn_Environment_Bool_Exp>;
};

/** aggregated selection of "ddn.projects" */
export type Ddn_Projects_Aggregate = {
  __typename?: 'ddn_projects_aggregate';
  aggregate?: Maybe<Ddn_Projects_Aggregate_Fields>;
  nodes: Array<Ddn_Projects>;
};

/** aggregate fields of "ddn.projects" */
export type Ddn_Projects_Aggregate_Fields = {
  __typename?: 'ddn_projects_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Ddn_Projects_Max_Fields>;
  min?: Maybe<Ddn_Projects_Min_Fields>;
};

/** aggregate fields of "ddn.projects" */
export type Ddn_Projects_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Projects_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "ddn.projects". All fields are combined with a logical 'AND'. */
export type Ddn_Projects_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Projects_Bool_Exp>>;
  _not?: Maybe<Ddn_Projects_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Projects_Bool_Exp>>;
  builds?: Maybe<Ddn_Build_Bool_Exp>;
  builds_aggregate?: Maybe<Ddn_Build_Aggregate_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  entitlements?: Maybe<Ddn_Project_Entitlement_Access_Bool_Exp>;
  entitlements_aggregate?: Maybe<Ddn_Project_Entitlement_Access_Aggregate_Bool_Exp>;
  environments?: Maybe<Ddn_Environment_Bool_Exp>;
  environments_aggregate?: Maybe<Ddn_Environment_Aggregate_Bool_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  owner_id?: Maybe<Uuid_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  user?: Maybe<Users_Bool_Exp>;
};

/** unique or primary key constraints on table "ddn.projects" */
export enum Ddn_Projects_Constraint {
  /** unique or primary key constraint on columns "name" */
  ProjectsNameKey = 'projects_name_key',
  /** unique or primary key constraint on columns "id" */
  ProjectsPkey = 'projects_pkey',
}

/** input type for inserting data into table "ddn.projects" */
export type Ddn_Projects_Insert_Input = {
  builds?: Maybe<Ddn_Build_Arr_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  entitlements?: Maybe<Ddn_Project_Entitlement_Access_Arr_Rel_Insert_Input>;
  environments?: Maybe<Ddn_Environment_Arr_Rel_Insert_Input>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  owner_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Ddn_Projects_Max_Fields = {
  __typename?: 'ddn_projects_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  owner_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Ddn_Projects_Min_Fields = {
  __typename?: 'ddn_projects_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  owner_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "ddn.projects" */
export type Ddn_Projects_Mutation_Response = {
  __typename?: 'ddn_projects_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Projects>;
};

/** input type for inserting object relation for remote table "ddn.projects" */
export type Ddn_Projects_Obj_Rel_Insert_Input = {
  data: Ddn_Projects_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Projects_On_Conflict>;
};

/** on_conflict condition type for table "ddn.projects" */
export type Ddn_Projects_On_Conflict = {
  constraint: Ddn_Projects_Constraint;
  update_columns?: Array<Ddn_Projects_Update_Column>;
  where?: Maybe<Ddn_Projects_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.projects". */
export type Ddn_Projects_Order_By = {
  builds_aggregate?: Maybe<Ddn_Build_Aggregate_Order_By>;
  created_at?: Maybe<Order_By>;
  entitlements_aggregate?: Maybe<Ddn_Project_Entitlement_Access_Aggregate_Order_By>;
  environments_aggregate?: Maybe<Ddn_Environment_Aggregate_Order_By>;
  id?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  owner_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user?: Maybe<Users_Order_By>;
};

/** primary key columns input for table: ddn.projects */
export type Ddn_Projects_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "ddn.projects" */
export enum Ddn_Projects_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
  /** column name */
  OwnerId = 'owner_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "ddn.projects" */
export type Ddn_Projects_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  owner_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "ddn_projects" */
export type Ddn_Projects_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Projects_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Projects_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  owner_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "ddn.projects" */
export enum Ddn_Projects_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
  /** column name */
  OwnerId = 'owner_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Ddn_Projects_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Projects_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Projects_Bool_Exp;
};

/** columns and relationships of "ddn.tunnel" */
export type Ddn_Tunnel = {
  __typename?: 'ddn_tunnel';
  created_at?: Maybe<Scalars['timestamptz']>;
  id: Scalars['uuid'];
  last_connection_at: Scalars['timestamptz'];
  owner_id: Scalars['uuid'];
  reserved_cluster?: Maybe<Scalars['uuid']>;
  reserved_port?: Maybe<Scalars['Int']>;
  /** An object relationship */
  tunnel_cluster?: Maybe<Ddn_Tunnel_Cluster>;
  /** An object relationship */
  user: Users;
};

/** aggregated selection of "ddn.tunnel" */
export type Ddn_Tunnel_Aggregate = {
  __typename?: 'ddn_tunnel_aggregate';
  aggregate?: Maybe<Ddn_Tunnel_Aggregate_Fields>;
  nodes: Array<Ddn_Tunnel>;
};

export type Ddn_Tunnel_Aggregate_Bool_Exp = {
  count?: Maybe<Ddn_Tunnel_Aggregate_Bool_Exp_Count>;
};

export type Ddn_Tunnel_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Ddn_Tunnel_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Ddn_Tunnel_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "ddn.tunnel" */
export type Ddn_Tunnel_Aggregate_Fields = {
  __typename?: 'ddn_tunnel_aggregate_fields';
  avg?: Maybe<Ddn_Tunnel_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Ddn_Tunnel_Max_Fields>;
  min?: Maybe<Ddn_Tunnel_Min_Fields>;
  stddev?: Maybe<Ddn_Tunnel_Stddev_Fields>;
  stddev_pop?: Maybe<Ddn_Tunnel_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Ddn_Tunnel_Stddev_Samp_Fields>;
  sum?: Maybe<Ddn_Tunnel_Sum_Fields>;
  var_pop?: Maybe<Ddn_Tunnel_Var_Pop_Fields>;
  var_samp?: Maybe<Ddn_Tunnel_Var_Samp_Fields>;
  variance?: Maybe<Ddn_Tunnel_Variance_Fields>;
};

/** aggregate fields of "ddn.tunnel" */
export type Ddn_Tunnel_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Tunnel_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "ddn.tunnel" */
export type Ddn_Tunnel_Aggregate_Order_By = {
  avg?: Maybe<Ddn_Tunnel_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Ddn_Tunnel_Max_Order_By>;
  min?: Maybe<Ddn_Tunnel_Min_Order_By>;
  stddev?: Maybe<Ddn_Tunnel_Stddev_Order_By>;
  stddev_pop?: Maybe<Ddn_Tunnel_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Ddn_Tunnel_Stddev_Samp_Order_By>;
  sum?: Maybe<Ddn_Tunnel_Sum_Order_By>;
  var_pop?: Maybe<Ddn_Tunnel_Var_Pop_Order_By>;
  var_samp?: Maybe<Ddn_Tunnel_Var_Samp_Order_By>;
  variance?: Maybe<Ddn_Tunnel_Variance_Order_By>;
};

/** input type for inserting array relation for remote table "ddn.tunnel" */
export type Ddn_Tunnel_Arr_Rel_Insert_Input = {
  data: Array<Ddn_Tunnel_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Tunnel_On_Conflict>;
};

/** aggregate avg on columns */
export type Ddn_Tunnel_Avg_Fields = {
  __typename?: 'ddn_tunnel_avg_fields';
  reserved_port?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Avg_Order_By = {
  reserved_port?: Maybe<Order_By>;
};

/** Boolean expression to filter rows from the table "ddn.tunnel". All fields are combined with a logical 'AND'. */
export type Ddn_Tunnel_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Tunnel_Bool_Exp>>;
  _not?: Maybe<Ddn_Tunnel_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Tunnel_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  last_connection_at?: Maybe<Timestamptz_Comparison_Exp>;
  owner_id?: Maybe<Uuid_Comparison_Exp>;
  reserved_cluster?: Maybe<Uuid_Comparison_Exp>;
  reserved_port?: Maybe<Int_Comparison_Exp>;
  tunnel_cluster?: Maybe<Ddn_Tunnel_Cluster_Bool_Exp>;
  user?: Maybe<Users_Bool_Exp>;
};

/** columns and relationships of "ddn.tunnel_cluster" */
export type Ddn_Tunnel_Cluster = {
  __typename?: 'ddn_tunnel_cluster';
  cloud: Scalars['String'];
  created_at?: Maybe<Scalars['timestamptz']>;
  id: Scalars['uuid'];
  internal_fqdn: Scalars['String'];
  machine_type: Scalars['String'];
  name: Scalars['String'];
  public_fqdn: Scalars['String'];
  region: Scalars['String'];
  /** An object relationship */
  regionByRegionCloud?: Maybe<Region>;
  /** An array relationship */
  tunnels: Array<Ddn_Tunnel>;
  /** An aggregate relationship */
  tunnels_aggregate: Ddn_Tunnel_Aggregate;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone: Scalars['String'];
};

/** columns and relationships of "ddn.tunnel_cluster" */
export type Ddn_Tunnel_ClusterTunnelsArgs = {
  distinct_on?: Maybe<Array<Ddn_Tunnel_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Tunnel_Order_By>>;
  where?: Maybe<Ddn_Tunnel_Bool_Exp>;
};

/** columns and relationships of "ddn.tunnel_cluster" */
export type Ddn_Tunnel_ClusterTunnels_AggregateArgs = {
  distinct_on?: Maybe<Array<Ddn_Tunnel_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Ddn_Tunnel_Order_By>>;
  where?: Maybe<Ddn_Tunnel_Bool_Exp>;
};

/** aggregated selection of "ddn.tunnel_cluster" */
export type Ddn_Tunnel_Cluster_Aggregate = {
  __typename?: 'ddn_tunnel_cluster_aggregate';
  aggregate?: Maybe<Ddn_Tunnel_Cluster_Aggregate_Fields>;
  nodes: Array<Ddn_Tunnel_Cluster>;
};

/** aggregate fields of "ddn.tunnel_cluster" */
export type Ddn_Tunnel_Cluster_Aggregate_Fields = {
  __typename?: 'ddn_tunnel_cluster_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Ddn_Tunnel_Cluster_Max_Fields>;
  min?: Maybe<Ddn_Tunnel_Cluster_Min_Fields>;
};

/** aggregate fields of "ddn.tunnel_cluster" */
export type Ddn_Tunnel_Cluster_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Ddn_Tunnel_Cluster_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "ddn.tunnel_cluster". All fields are combined with a logical 'AND'. */
export type Ddn_Tunnel_Cluster_Bool_Exp = {
  _and?: Maybe<Array<Ddn_Tunnel_Cluster_Bool_Exp>>;
  _not?: Maybe<Ddn_Tunnel_Cluster_Bool_Exp>;
  _or?: Maybe<Array<Ddn_Tunnel_Cluster_Bool_Exp>>;
  cloud?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  internal_fqdn?: Maybe<String_Comparison_Exp>;
  machine_type?: Maybe<String_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  public_fqdn?: Maybe<String_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  regionByRegionCloud?: Maybe<Region_Bool_Exp>;
  tunnels?: Maybe<Ddn_Tunnel_Bool_Exp>;
  tunnels_aggregate?: Maybe<Ddn_Tunnel_Aggregate_Bool_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  zone?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "ddn.tunnel_cluster" */
export enum Ddn_Tunnel_Cluster_Constraint {
  /** unique or primary key constraint on columns "internal_fqdn" */
  TunnelClusterInternalFqdnKey = 'tunnel_cluster_internal_fqdn_key',
  /** unique or primary key constraint on columns "name" */
  TunnelClusterNameKey = 'tunnel_cluster_name_key',
  /** unique or primary key constraint on columns "id" */
  TunnelClusterPkey = 'tunnel_cluster_pkey',
  /** unique or primary key constraint on columns "public_fqdn" */
  TunnelClusterPublicFqdnKey = 'tunnel_cluster_public_fqdn_key',
}

/** input type for inserting data into table "ddn.tunnel_cluster" */
export type Ddn_Tunnel_Cluster_Insert_Input = {
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  internal_fqdn?: Maybe<Scalars['String']>;
  machine_type?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  public_fqdn?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  regionByRegionCloud?: Maybe<Region_Obj_Rel_Insert_Input>;
  tunnels?: Maybe<Ddn_Tunnel_Arr_Rel_Insert_Input>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Ddn_Tunnel_Cluster_Max_Fields = {
  __typename?: 'ddn_tunnel_cluster_max_fields';
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  internal_fqdn?: Maybe<Scalars['String']>;
  machine_type?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  public_fqdn?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Ddn_Tunnel_Cluster_Min_Fields = {
  __typename?: 'ddn_tunnel_cluster_min_fields';
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  internal_fqdn?: Maybe<Scalars['String']>;
  machine_type?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  public_fqdn?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "ddn.tunnel_cluster" */
export type Ddn_Tunnel_Cluster_Mutation_Response = {
  __typename?: 'ddn_tunnel_cluster_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Tunnel_Cluster>;
};

/** input type for inserting object relation for remote table "ddn.tunnel_cluster" */
export type Ddn_Tunnel_Cluster_Obj_Rel_Insert_Input = {
  data: Ddn_Tunnel_Cluster_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Ddn_Tunnel_Cluster_On_Conflict>;
};

/** on_conflict condition type for table "ddn.tunnel_cluster" */
export type Ddn_Tunnel_Cluster_On_Conflict = {
  constraint: Ddn_Tunnel_Cluster_Constraint;
  update_columns?: Array<Ddn_Tunnel_Cluster_Update_Column>;
  where?: Maybe<Ddn_Tunnel_Cluster_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.tunnel_cluster". */
export type Ddn_Tunnel_Cluster_Order_By = {
  cloud?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  internal_fqdn?: Maybe<Order_By>;
  machine_type?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  public_fqdn?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  regionByRegionCloud?: Maybe<Region_Order_By>;
  tunnels_aggregate?: Maybe<Ddn_Tunnel_Aggregate_Order_By>;
  updated_at?: Maybe<Order_By>;
  zone?: Maybe<Order_By>;
};

/** primary key columns input for table: ddn.tunnel_cluster */
export type Ddn_Tunnel_Cluster_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "ddn.tunnel_cluster" */
export enum Ddn_Tunnel_Cluster_Select_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  InternalFqdn = 'internal_fqdn',
  /** column name */
  MachineType = 'machine_type',
  /** column name */
  Name = 'name',
  /** column name */
  PublicFqdn = 'public_fqdn',
  /** column name */
  Region = 'region',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Zone = 'zone',
}

/** input type for updating data in table "ddn.tunnel_cluster" */
export type Ddn_Tunnel_Cluster_Set_Input = {
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  internal_fqdn?: Maybe<Scalars['String']>;
  machine_type?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  public_fqdn?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "ddn_tunnel_cluster" */
export type Ddn_Tunnel_Cluster_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Tunnel_Cluster_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Tunnel_Cluster_Stream_Cursor_Value_Input = {
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  internal_fqdn?: Maybe<Scalars['String']>;
  machine_type?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  public_fqdn?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** update columns of table "ddn.tunnel_cluster" */
export enum Ddn_Tunnel_Cluster_Update_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  InternalFqdn = 'internal_fqdn',
  /** column name */
  MachineType = 'machine_type',
  /** column name */
  Name = 'name',
  /** column name */
  PublicFqdn = 'public_fqdn',
  /** column name */
  Region = 'region',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Zone = 'zone',
}

export type Ddn_Tunnel_Cluster_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Tunnel_Cluster_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Tunnel_Cluster_Bool_Exp;
};

/** unique or primary key constraints on table "ddn.tunnel" */
export enum Ddn_Tunnel_Constraint {
  /** unique or primary key constraint on columns "id" */
  TunnelPkey = 'tunnel_pkey',
  /** unique or primary key constraint on columns "reserved_cluster", "reserved_port" */
  TunnelReservedPortReservedClusterKey = 'tunnel_reserved_port_reserved_cluster_key',
}

/** input type for incrementing numeric columns in table "ddn.tunnel" */
export type Ddn_Tunnel_Inc_Input = {
  reserved_port?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "ddn.tunnel" */
export type Ddn_Tunnel_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  last_connection_at?: Maybe<Scalars['timestamptz']>;
  owner_id?: Maybe<Scalars['uuid']>;
  reserved_cluster?: Maybe<Scalars['uuid']>;
  reserved_port?: Maybe<Scalars['Int']>;
  tunnel_cluster?: Maybe<Ddn_Tunnel_Cluster_Obj_Rel_Insert_Input>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Ddn_Tunnel_Max_Fields = {
  __typename?: 'ddn_tunnel_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  last_connection_at?: Maybe<Scalars['timestamptz']>;
  owner_id?: Maybe<Scalars['uuid']>;
  reserved_cluster?: Maybe<Scalars['uuid']>;
  reserved_port?: Maybe<Scalars['Int']>;
};

/** order by max() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Max_Order_By = {
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  last_connection_at?: Maybe<Order_By>;
  owner_id?: Maybe<Order_By>;
  reserved_cluster?: Maybe<Order_By>;
  reserved_port?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Ddn_Tunnel_Min_Fields = {
  __typename?: 'ddn_tunnel_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  last_connection_at?: Maybe<Scalars['timestamptz']>;
  owner_id?: Maybe<Scalars['uuid']>;
  reserved_cluster?: Maybe<Scalars['uuid']>;
  reserved_port?: Maybe<Scalars['Int']>;
};

/** order by min() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Min_Order_By = {
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  last_connection_at?: Maybe<Order_By>;
  owner_id?: Maybe<Order_By>;
  reserved_cluster?: Maybe<Order_By>;
  reserved_port?: Maybe<Order_By>;
};

/** response of any mutation on the table "ddn.tunnel" */
export type Ddn_Tunnel_Mutation_Response = {
  __typename?: 'ddn_tunnel_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Ddn_Tunnel>;
};

/** on_conflict condition type for table "ddn.tunnel" */
export type Ddn_Tunnel_On_Conflict = {
  constraint: Ddn_Tunnel_Constraint;
  update_columns?: Array<Ddn_Tunnel_Update_Column>;
  where?: Maybe<Ddn_Tunnel_Bool_Exp>;
};

/** Ordering options when selecting data from "ddn.tunnel". */
export type Ddn_Tunnel_Order_By = {
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  last_connection_at?: Maybe<Order_By>;
  owner_id?: Maybe<Order_By>;
  reserved_cluster?: Maybe<Order_By>;
  reserved_port?: Maybe<Order_By>;
  tunnel_cluster?: Maybe<Ddn_Tunnel_Cluster_Order_By>;
  user?: Maybe<Users_Order_By>;
};

/** primary key columns input for table: ddn.tunnel */
export type Ddn_Tunnel_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "ddn.tunnel" */
export enum Ddn_Tunnel_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  LastConnectionAt = 'last_connection_at',
  /** column name */
  OwnerId = 'owner_id',
  /** column name */
  ReservedCluster = 'reserved_cluster',
  /** column name */
  ReservedPort = 'reserved_port',
}

/** input type for updating data in table "ddn.tunnel" */
export type Ddn_Tunnel_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  last_connection_at?: Maybe<Scalars['timestamptz']>;
  owner_id?: Maybe<Scalars['uuid']>;
  reserved_cluster?: Maybe<Scalars['uuid']>;
  reserved_port?: Maybe<Scalars['Int']>;
};

/** aggregate stddev on columns */
export type Ddn_Tunnel_Stddev_Fields = {
  __typename?: 'ddn_tunnel_stddev_fields';
  reserved_port?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Stddev_Order_By = {
  reserved_port?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Ddn_Tunnel_Stddev_Pop_Fields = {
  __typename?: 'ddn_tunnel_stddev_pop_fields';
  reserved_port?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Stddev_Pop_Order_By = {
  reserved_port?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Ddn_Tunnel_Stddev_Samp_Fields = {
  __typename?: 'ddn_tunnel_stddev_samp_fields';
  reserved_port?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Stddev_Samp_Order_By = {
  reserved_port?: Maybe<Order_By>;
};

/** Streaming cursor of the table "ddn_tunnel" */
export type Ddn_Tunnel_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Ddn_Tunnel_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Ddn_Tunnel_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  last_connection_at?: Maybe<Scalars['timestamptz']>;
  owner_id?: Maybe<Scalars['uuid']>;
  reserved_cluster?: Maybe<Scalars['uuid']>;
  reserved_port?: Maybe<Scalars['Int']>;
};

/** aggregate sum on columns */
export type Ddn_Tunnel_Sum_Fields = {
  __typename?: 'ddn_tunnel_sum_fields';
  reserved_port?: Maybe<Scalars['Int']>;
};

/** order by sum() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Sum_Order_By = {
  reserved_port?: Maybe<Order_By>;
};

/** update columns of table "ddn.tunnel" */
export enum Ddn_Tunnel_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  LastConnectionAt = 'last_connection_at',
  /** column name */
  OwnerId = 'owner_id',
  /** column name */
  ReservedCluster = 'reserved_cluster',
  /** column name */
  ReservedPort = 'reserved_port',
}

export type Ddn_Tunnel_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Ddn_Tunnel_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Ddn_Tunnel_Set_Input>;
  /** filter the rows which have to be updated */
  where: Ddn_Tunnel_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Ddn_Tunnel_Var_Pop_Fields = {
  __typename?: 'ddn_tunnel_var_pop_fields';
  reserved_port?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Var_Pop_Order_By = {
  reserved_port?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Ddn_Tunnel_Var_Samp_Fields = {
  __typename?: 'ddn_tunnel_var_samp_fields';
  reserved_port?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Var_Samp_Order_By = {
  reserved_port?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Ddn_Tunnel_Variance_Fields = {
  __typename?: 'ddn_tunnel_variance_fields';
  reserved_port?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "ddn.tunnel" */
export type Ddn_Tunnel_Variance_Order_By = {
  reserved_port?: Maybe<Order_By>;
};

/** Table to keep track of dedicated cloud bills. These are not part of automated Stripe invoicing.  */
export type Dedicated_Cloud_Bills = {
  __typename?: 'dedicated_cloud_bills';
  compute_unit_config_id: Scalars['uuid'];
  created_at: Scalars['timestamptz'];
  cu_cost: Scalars['Int'];
  data_passthrough_cost: Scalars['Int'];
  /** An array relationship */
  details: Array<Dedicated_Cloud_Bills_Details>;
  /** An aggregate relationship */
  details_aggregate: Dedicated_Cloud_Bills_Details_Aggregate;
  id: Scalars['uuid'];
  metadata?: Maybe<Scalars['jsonb']>;
  month: Scalars['Int'];
  updated_at: Scalars['timestamptz'];
  user_id: Scalars['uuid'];
  year: Scalars['Int'];
};

/** Table to keep track of dedicated cloud bills. These are not part of automated Stripe invoicing.  */
export type Dedicated_Cloud_BillsDetailsArgs = {
  distinct_on?: Maybe<Array<Dedicated_Cloud_Bills_Details_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Dedicated_Cloud_Bills_Details_Order_By>>;
  where?: Maybe<Dedicated_Cloud_Bills_Details_Bool_Exp>;
};

/** Table to keep track of dedicated cloud bills. These are not part of automated Stripe invoicing.  */
export type Dedicated_Cloud_BillsDetails_AggregateArgs = {
  distinct_on?: Maybe<Array<Dedicated_Cloud_Bills_Details_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Dedicated_Cloud_Bills_Details_Order_By>>;
  where?: Maybe<Dedicated_Cloud_Bills_Details_Bool_Exp>;
};

/** Table to keep track of dedicated cloud bills. These are not part of automated Stripe invoicing.  */
export type Dedicated_Cloud_BillsMetadataArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Aggregate = {
  __typename?: 'dedicated_cloud_bills_aggregate';
  aggregate?: Maybe<Dedicated_Cloud_Bills_Aggregate_Fields>;
  nodes: Array<Dedicated_Cloud_Bills>;
};

export type Dedicated_Cloud_Bills_Aggregate_Bool_Exp = {
  count?: Maybe<Dedicated_Cloud_Bills_Aggregate_Bool_Exp_Count>;
};

export type Dedicated_Cloud_Bills_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Dedicated_Cloud_Bills_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Dedicated_Cloud_Bills_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Aggregate_Fields = {
  __typename?: 'dedicated_cloud_bills_aggregate_fields';
  avg?: Maybe<Dedicated_Cloud_Bills_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Dedicated_Cloud_Bills_Max_Fields>;
  min?: Maybe<Dedicated_Cloud_Bills_Min_Fields>;
  stddev?: Maybe<Dedicated_Cloud_Bills_Stddev_Fields>;
  stddev_pop?: Maybe<Dedicated_Cloud_Bills_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Dedicated_Cloud_Bills_Stddev_Samp_Fields>;
  sum?: Maybe<Dedicated_Cloud_Bills_Sum_Fields>;
  var_pop?: Maybe<Dedicated_Cloud_Bills_Var_Pop_Fields>;
  var_samp?: Maybe<Dedicated_Cloud_Bills_Var_Samp_Fields>;
  variance?: Maybe<Dedicated_Cloud_Bills_Variance_Fields>;
};

/** aggregate fields of "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Dedicated_Cloud_Bills_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Aggregate_Order_By = {
  avg?: Maybe<Dedicated_Cloud_Bills_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Dedicated_Cloud_Bills_Max_Order_By>;
  min?: Maybe<Dedicated_Cloud_Bills_Min_Order_By>;
  stddev?: Maybe<Dedicated_Cloud_Bills_Stddev_Order_By>;
  stddev_pop?: Maybe<Dedicated_Cloud_Bills_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Dedicated_Cloud_Bills_Stddev_Samp_Order_By>;
  sum?: Maybe<Dedicated_Cloud_Bills_Sum_Order_By>;
  var_pop?: Maybe<Dedicated_Cloud_Bills_Var_Pop_Order_By>;
  var_samp?: Maybe<Dedicated_Cloud_Bills_Var_Samp_Order_By>;
  variance?: Maybe<Dedicated_Cloud_Bills_Variance_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Dedicated_Cloud_Bills_Append_Input = {
  metadata?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Arr_Rel_Insert_Input = {
  data: Array<Dedicated_Cloud_Bills_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Dedicated_Cloud_Bills_On_Conflict>;
};

/** aggregate avg on columns */
export type Dedicated_Cloud_Bills_Avg_Fields = {
  __typename?: 'dedicated_cloud_bills_avg_fields';
  cu_cost?: Maybe<Scalars['Float']>;
  data_passthrough_cost?: Maybe<Scalars['Float']>;
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Avg_Order_By = {
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** Boolean expression to filter rows from the table "dedicated_cloud_bills". All fields are combined with a logical 'AND'. */
export type Dedicated_Cloud_Bills_Bool_Exp = {
  _and?: Maybe<Array<Dedicated_Cloud_Bills_Bool_Exp>>;
  _not?: Maybe<Dedicated_Cloud_Bills_Bool_Exp>;
  _or?: Maybe<Array<Dedicated_Cloud_Bills_Bool_Exp>>;
  compute_unit_config_id?: Maybe<Uuid_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  cu_cost?: Maybe<Int_Comparison_Exp>;
  data_passthrough_cost?: Maybe<Int_Comparison_Exp>;
  details?: Maybe<Dedicated_Cloud_Bills_Details_Bool_Exp>;
  details_aggregate?: Maybe<Dedicated_Cloud_Bills_Details_Aggregate_Bool_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  metadata?: Maybe<Jsonb_Comparison_Exp>;
  month?: Maybe<Int_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  user_id?: Maybe<Uuid_Comparison_Exp>;
  year?: Maybe<Int_Comparison_Exp>;
};

/** unique or primary key constraints on table "dedicated_cloud_bills" */
export enum Dedicated_Cloud_Bills_Constraint {
  /** unique or primary key constraint on columns "year", "month", "compute_unit_config_id" */
  DedicatedCloudBillsComputeUnitConfigIdMonthYearKey = 'dedicated_cloud_bills_compute_unit_config_id_month_year_key',
  /** unique or primary key constraint on columns "id" */
  DedicatedCloudBillsPkey = 'dedicated_cloud_bills_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Dedicated_Cloud_Bills_Delete_At_Path_Input = {
  metadata?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Dedicated_Cloud_Bills_Delete_Elem_Input = {
  metadata?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Dedicated_Cloud_Bills_Delete_Key_Input = {
  metadata?: Maybe<Scalars['String']>;
};

/** Granular details about compute unit usage based bills  */
export type Dedicated_Cloud_Bills_Details = {
  __typename?: 'dedicated_cloud_bills_details';
  bill_id: Scalars['uuid'];
  created_at: Scalars['timestamptz'];
  details?: Maybe<Scalars['jsonb']>;
  id: Scalars['uuid'];
  month: Scalars['Int'];
  updated_at: Scalars['timestamptz'];
  year: Scalars['Int'];
};

/** Granular details about compute unit usage based bills  */
export type Dedicated_Cloud_Bills_DetailsDetailsArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Aggregate = {
  __typename?: 'dedicated_cloud_bills_details_aggregate';
  aggregate?: Maybe<Dedicated_Cloud_Bills_Details_Aggregate_Fields>;
  nodes: Array<Dedicated_Cloud_Bills_Details>;
};

export type Dedicated_Cloud_Bills_Details_Aggregate_Bool_Exp = {
  count?: Maybe<Dedicated_Cloud_Bills_Details_Aggregate_Bool_Exp_Count>;
};

export type Dedicated_Cloud_Bills_Details_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Dedicated_Cloud_Bills_Details_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Dedicated_Cloud_Bills_Details_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Aggregate_Fields = {
  __typename?: 'dedicated_cloud_bills_details_aggregate_fields';
  avg?: Maybe<Dedicated_Cloud_Bills_Details_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Dedicated_Cloud_Bills_Details_Max_Fields>;
  min?: Maybe<Dedicated_Cloud_Bills_Details_Min_Fields>;
  stddev?: Maybe<Dedicated_Cloud_Bills_Details_Stddev_Fields>;
  stddev_pop?: Maybe<Dedicated_Cloud_Bills_Details_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Dedicated_Cloud_Bills_Details_Stddev_Samp_Fields>;
  sum?: Maybe<Dedicated_Cloud_Bills_Details_Sum_Fields>;
  var_pop?: Maybe<Dedicated_Cloud_Bills_Details_Var_Pop_Fields>;
  var_samp?: Maybe<Dedicated_Cloud_Bills_Details_Var_Samp_Fields>;
  variance?: Maybe<Dedicated_Cloud_Bills_Details_Variance_Fields>;
};

/** aggregate fields of "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Dedicated_Cloud_Bills_Details_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Aggregate_Order_By = {
  avg?: Maybe<Dedicated_Cloud_Bills_Details_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Dedicated_Cloud_Bills_Details_Max_Order_By>;
  min?: Maybe<Dedicated_Cloud_Bills_Details_Min_Order_By>;
  stddev?: Maybe<Dedicated_Cloud_Bills_Details_Stddev_Order_By>;
  stddev_pop?: Maybe<Dedicated_Cloud_Bills_Details_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Dedicated_Cloud_Bills_Details_Stddev_Samp_Order_By>;
  sum?: Maybe<Dedicated_Cloud_Bills_Details_Sum_Order_By>;
  var_pop?: Maybe<Dedicated_Cloud_Bills_Details_Var_Pop_Order_By>;
  var_samp?: Maybe<Dedicated_Cloud_Bills_Details_Var_Samp_Order_By>;
  variance?: Maybe<Dedicated_Cloud_Bills_Details_Variance_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Dedicated_Cloud_Bills_Details_Append_Input = {
  details?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Arr_Rel_Insert_Input = {
  data: Array<Dedicated_Cloud_Bills_Details_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Dedicated_Cloud_Bills_Details_On_Conflict>;
};

/** aggregate avg on columns */
export type Dedicated_Cloud_Bills_Details_Avg_Fields = {
  __typename?: 'dedicated_cloud_bills_details_avg_fields';
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Avg_Order_By = {
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/**
 * Boolean expression to filter rows from the table
 * "dedicated_cloud_bills_details". All fields are combined with a logical 'AND'.
 */
export type Dedicated_Cloud_Bills_Details_Bool_Exp = {
  _and?: Maybe<Array<Dedicated_Cloud_Bills_Details_Bool_Exp>>;
  _not?: Maybe<Dedicated_Cloud_Bills_Details_Bool_Exp>;
  _or?: Maybe<Array<Dedicated_Cloud_Bills_Details_Bool_Exp>>;
  bill_id?: Maybe<Uuid_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  details?: Maybe<Jsonb_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  month?: Maybe<Int_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  year?: Maybe<Int_Comparison_Exp>;
};

/** unique or primary key constraints on table "dedicated_cloud_bills_details" */
export enum Dedicated_Cloud_Bills_Details_Constraint {
  /** unique or primary key constraint on columns "id" */
  DedicatedCloudBillsDetailsPkey = 'dedicated_cloud_bills_details_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Dedicated_Cloud_Bills_Details_Delete_At_Path_Input = {
  details?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Dedicated_Cloud_Bills_Details_Delete_Elem_Input = {
  details?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Dedicated_Cloud_Bills_Details_Delete_Key_Input = {
  details?: Maybe<Scalars['String']>;
};

/** input type for incrementing numeric columns in table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Inc_Input = {
  month?: Maybe<Scalars['Int']>;
  year?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Insert_Input = {
  bill_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  details?: Maybe<Scalars['jsonb']>;
  id?: Maybe<Scalars['uuid']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  year?: Maybe<Scalars['Int']>;
};

/** aggregate max on columns */
export type Dedicated_Cloud_Bills_Details_Max_Fields = {
  __typename?: 'dedicated_cloud_bills_details_max_fields';
  bill_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  year?: Maybe<Scalars['Int']>;
};

/** order by max() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Max_Order_By = {
  bill_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Dedicated_Cloud_Bills_Details_Min_Fields = {
  __typename?: 'dedicated_cloud_bills_details_min_fields';
  bill_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  year?: Maybe<Scalars['Int']>;
};

/** order by min() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Min_Order_By = {
  bill_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** response of any mutation on the table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Mutation_Response = {
  __typename?: 'dedicated_cloud_bills_details_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Dedicated_Cloud_Bills_Details>;
};

/** on_conflict condition type for table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_On_Conflict = {
  constraint: Dedicated_Cloud_Bills_Details_Constraint;
  update_columns?: Array<Dedicated_Cloud_Bills_Details_Update_Column>;
  where?: Maybe<Dedicated_Cloud_Bills_Details_Bool_Exp>;
};

/** Ordering options when selecting data from "dedicated_cloud_bills_details". */
export type Dedicated_Cloud_Bills_Details_Order_By = {
  bill_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  details?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** primary key columns input for table: dedicated_cloud_bills_details */
export type Dedicated_Cloud_Bills_Details_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Dedicated_Cloud_Bills_Details_Prepend_Input = {
  details?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "dedicated_cloud_bills_details" */
export enum Dedicated_Cloud_Bills_Details_Select_Column {
  /** column name */
  BillId = 'bill_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Details = 'details',
  /** column name */
  Id = 'id',
  /** column name */
  Month = 'month',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Year = 'year',
}

/** input type for updating data in table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Set_Input = {
  bill_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  details?: Maybe<Scalars['jsonb']>;
  id?: Maybe<Scalars['uuid']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  year?: Maybe<Scalars['Int']>;
};

/** aggregate stddev on columns */
export type Dedicated_Cloud_Bills_Details_Stddev_Fields = {
  __typename?: 'dedicated_cloud_bills_details_stddev_fields';
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Stddev_Order_By = {
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Dedicated_Cloud_Bills_Details_Stddev_Pop_Fields = {
  __typename?: 'dedicated_cloud_bills_details_stddev_pop_fields';
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Stddev_Pop_Order_By = {
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Dedicated_Cloud_Bills_Details_Stddev_Samp_Fields = {
  __typename?: 'dedicated_cloud_bills_details_stddev_samp_fields';
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Stddev_Samp_Order_By = {
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** Streaming cursor of the table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Dedicated_Cloud_Bills_Details_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Dedicated_Cloud_Bills_Details_Stream_Cursor_Value_Input = {
  bill_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  details?: Maybe<Scalars['jsonb']>;
  id?: Maybe<Scalars['uuid']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  year?: Maybe<Scalars['Int']>;
};

/** aggregate sum on columns */
export type Dedicated_Cloud_Bills_Details_Sum_Fields = {
  __typename?: 'dedicated_cloud_bills_details_sum_fields';
  month?: Maybe<Scalars['Int']>;
  year?: Maybe<Scalars['Int']>;
};

/** order by sum() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Sum_Order_By = {
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** update columns of table "dedicated_cloud_bills_details" */
export enum Dedicated_Cloud_Bills_Details_Update_Column {
  /** column name */
  BillId = 'bill_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Details = 'details',
  /** column name */
  Id = 'id',
  /** column name */
  Month = 'month',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Year = 'year',
}

export type Dedicated_Cloud_Bills_Details_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Dedicated_Cloud_Bills_Details_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Dedicated_Cloud_Bills_Details_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Dedicated_Cloud_Bills_Details_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Dedicated_Cloud_Bills_Details_Delete_Key_Input>;
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Dedicated_Cloud_Bills_Details_Inc_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Dedicated_Cloud_Bills_Details_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Dedicated_Cloud_Bills_Details_Set_Input>;
  /** filter the rows which have to be updated */
  where: Dedicated_Cloud_Bills_Details_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Dedicated_Cloud_Bills_Details_Var_Pop_Fields = {
  __typename?: 'dedicated_cloud_bills_details_var_pop_fields';
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Var_Pop_Order_By = {
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Dedicated_Cloud_Bills_Details_Var_Samp_Fields = {
  __typename?: 'dedicated_cloud_bills_details_var_samp_fields';
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Var_Samp_Order_By = {
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Dedicated_Cloud_Bills_Details_Variance_Fields = {
  __typename?: 'dedicated_cloud_bills_details_variance_fields';
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "dedicated_cloud_bills_details" */
export type Dedicated_Cloud_Bills_Details_Variance_Order_By = {
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** input type for incrementing numeric columns in table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Inc_Input = {
  cu_cost?: Maybe<Scalars['Int']>;
  data_passthrough_cost?: Maybe<Scalars['Int']>;
  month?: Maybe<Scalars['Int']>;
  year?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Insert_Input = {
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  cu_cost?: Maybe<Scalars['Int']>;
  data_passthrough_cost?: Maybe<Scalars['Int']>;
  details?: Maybe<Dedicated_Cloud_Bills_Details_Arr_Rel_Insert_Input>;
  id?: Maybe<Scalars['uuid']>;
  metadata?: Maybe<Scalars['jsonb']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  year?: Maybe<Scalars['Int']>;
};

/** aggregate max on columns */
export type Dedicated_Cloud_Bills_Max_Fields = {
  __typename?: 'dedicated_cloud_bills_max_fields';
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  cu_cost?: Maybe<Scalars['Int']>;
  data_passthrough_cost?: Maybe<Scalars['Int']>;
  id?: Maybe<Scalars['uuid']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  year?: Maybe<Scalars['Int']>;
};

/** order by max() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Max_Order_By = {
  compute_unit_config_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Dedicated_Cloud_Bills_Min_Fields = {
  __typename?: 'dedicated_cloud_bills_min_fields';
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  cu_cost?: Maybe<Scalars['Int']>;
  data_passthrough_cost?: Maybe<Scalars['Int']>;
  id?: Maybe<Scalars['uuid']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  year?: Maybe<Scalars['Int']>;
};

/** order by min() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Min_Order_By = {
  compute_unit_config_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** response of any mutation on the table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Mutation_Response = {
  __typename?: 'dedicated_cloud_bills_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Dedicated_Cloud_Bills>;
};

/** on_conflict condition type for table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_On_Conflict = {
  constraint: Dedicated_Cloud_Bills_Constraint;
  update_columns?: Array<Dedicated_Cloud_Bills_Update_Column>;
  where?: Maybe<Dedicated_Cloud_Bills_Bool_Exp>;
};

/** Ordering options when selecting data from "dedicated_cloud_bills". */
export type Dedicated_Cloud_Bills_Order_By = {
  compute_unit_config_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  details_aggregate?: Maybe<Dedicated_Cloud_Bills_Details_Aggregate_Order_By>;
  id?: Maybe<Order_By>;
  metadata?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** primary key columns input for table: dedicated_cloud_bills */
export type Dedicated_Cloud_Bills_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Dedicated_Cloud_Bills_Prepend_Input = {
  metadata?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "dedicated_cloud_bills" */
export enum Dedicated_Cloud_Bills_Select_Column {
  /** column name */
  ComputeUnitConfigId = 'compute_unit_config_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CuCost = 'cu_cost',
  /** column name */
  DataPassthroughCost = 'data_passthrough_cost',
  /** column name */
  Id = 'id',
  /** column name */
  Metadata = 'metadata',
  /** column name */
  Month = 'month',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
  /** column name */
  Year = 'year',
}

/** input type for updating data in table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Set_Input = {
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  cu_cost?: Maybe<Scalars['Int']>;
  data_passthrough_cost?: Maybe<Scalars['Int']>;
  id?: Maybe<Scalars['uuid']>;
  metadata?: Maybe<Scalars['jsonb']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  year?: Maybe<Scalars['Int']>;
};

/** aggregate stddev on columns */
export type Dedicated_Cloud_Bills_Stddev_Fields = {
  __typename?: 'dedicated_cloud_bills_stddev_fields';
  cu_cost?: Maybe<Scalars['Float']>;
  data_passthrough_cost?: Maybe<Scalars['Float']>;
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Stddev_Order_By = {
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Dedicated_Cloud_Bills_Stddev_Pop_Fields = {
  __typename?: 'dedicated_cloud_bills_stddev_pop_fields';
  cu_cost?: Maybe<Scalars['Float']>;
  data_passthrough_cost?: Maybe<Scalars['Float']>;
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Stddev_Pop_Order_By = {
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Dedicated_Cloud_Bills_Stddev_Samp_Fields = {
  __typename?: 'dedicated_cloud_bills_stddev_samp_fields';
  cu_cost?: Maybe<Scalars['Float']>;
  data_passthrough_cost?: Maybe<Scalars['Float']>;
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Stddev_Samp_Order_By = {
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** Streaming cursor of the table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Dedicated_Cloud_Bills_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Dedicated_Cloud_Bills_Stream_Cursor_Value_Input = {
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  cu_cost?: Maybe<Scalars['Int']>;
  data_passthrough_cost?: Maybe<Scalars['Int']>;
  id?: Maybe<Scalars['uuid']>;
  metadata?: Maybe<Scalars['jsonb']>;
  month?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  year?: Maybe<Scalars['Int']>;
};

/** aggregate sum on columns */
export type Dedicated_Cloud_Bills_Sum_Fields = {
  __typename?: 'dedicated_cloud_bills_sum_fields';
  cu_cost?: Maybe<Scalars['Int']>;
  data_passthrough_cost?: Maybe<Scalars['Int']>;
  month?: Maybe<Scalars['Int']>;
  year?: Maybe<Scalars['Int']>;
};

/** order by sum() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Sum_Order_By = {
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** update columns of table "dedicated_cloud_bills" */
export enum Dedicated_Cloud_Bills_Update_Column {
  /** column name */
  ComputeUnitConfigId = 'compute_unit_config_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CuCost = 'cu_cost',
  /** column name */
  DataPassthroughCost = 'data_passthrough_cost',
  /** column name */
  Id = 'id',
  /** column name */
  Metadata = 'metadata',
  /** column name */
  Month = 'month',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
  /** column name */
  Year = 'year',
}

export type Dedicated_Cloud_Bills_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Dedicated_Cloud_Bills_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Dedicated_Cloud_Bills_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Dedicated_Cloud_Bills_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Dedicated_Cloud_Bills_Delete_Key_Input>;
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Dedicated_Cloud_Bills_Inc_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Dedicated_Cloud_Bills_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Dedicated_Cloud_Bills_Set_Input>;
  /** filter the rows which have to be updated */
  where: Dedicated_Cloud_Bills_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Dedicated_Cloud_Bills_Var_Pop_Fields = {
  __typename?: 'dedicated_cloud_bills_var_pop_fields';
  cu_cost?: Maybe<Scalars['Float']>;
  data_passthrough_cost?: Maybe<Scalars['Float']>;
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Var_Pop_Order_By = {
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Dedicated_Cloud_Bills_Var_Samp_Fields = {
  __typename?: 'dedicated_cloud_bills_var_samp_fields';
  cu_cost?: Maybe<Scalars['Float']>;
  data_passthrough_cost?: Maybe<Scalars['Float']>;
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Var_Samp_Order_By = {
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Dedicated_Cloud_Bills_Variance_Fields = {
  __typename?: 'dedicated_cloud_bills_variance_fields';
  cu_cost?: Maybe<Scalars['Float']>;
  data_passthrough_cost?: Maybe<Scalars['Float']>;
  month?: Maybe<Scalars['Float']>;
  year?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "dedicated_cloud_bills" */
export type Dedicated_Cloud_Bills_Variance_Order_By = {
  cu_cost?: Maybe<Order_By>;
  data_passthrough_cost?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** This table records Dedicated Cloud Deals information (also available in Salesforce). */
export type Dedicated_Cloud_Commitments = {
  __typename?: 'dedicated_cloud_commitments';
  commitment_end?: Maybe<Scalars['date']>;
  commitment_start: Scalars['date'];
  created_at: Scalars['timestamptz'];
  id: Scalars['uuid'];
  /** An array relationship */
  monthly_usage: Array<Dedicated_Cloud_Bills>;
  /** An aggregate relationship */
  monthly_usage_aggregate: Dedicated_Cloud_Bills_Aggregate;
  support_plan: Support_Plan_Types_Enum;
  total_commitment: Scalars['Int'];
  updated_at: Scalars['timestamptz'];
  user_id: Scalars['uuid'];
  yearly_commitment: Scalars['Int'];
};

/** This table records Dedicated Cloud Deals information (also available in Salesforce). */
export type Dedicated_Cloud_CommitmentsMonthly_UsageArgs = {
  distinct_on?: Maybe<Array<Dedicated_Cloud_Bills_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Dedicated_Cloud_Bills_Order_By>>;
  where?: Maybe<Dedicated_Cloud_Bills_Bool_Exp>;
};

/** This table records Dedicated Cloud Deals information (also available in Salesforce). */
export type Dedicated_Cloud_CommitmentsMonthly_Usage_AggregateArgs = {
  distinct_on?: Maybe<Array<Dedicated_Cloud_Bills_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Dedicated_Cloud_Bills_Order_By>>;
  where?: Maybe<Dedicated_Cloud_Bills_Bool_Exp>;
};

/** aggregated selection of "dedicated_cloud_commitments" */
export type Dedicated_Cloud_Commitments_Aggregate = {
  __typename?: 'dedicated_cloud_commitments_aggregate';
  aggregate?: Maybe<Dedicated_Cloud_Commitments_Aggregate_Fields>;
  nodes: Array<Dedicated_Cloud_Commitments>;
};

/** aggregate fields of "dedicated_cloud_commitments" */
export type Dedicated_Cloud_Commitments_Aggregate_Fields = {
  __typename?: 'dedicated_cloud_commitments_aggregate_fields';
  avg?: Maybe<Dedicated_Cloud_Commitments_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Dedicated_Cloud_Commitments_Max_Fields>;
  min?: Maybe<Dedicated_Cloud_Commitments_Min_Fields>;
  stddev?: Maybe<Dedicated_Cloud_Commitments_Stddev_Fields>;
  stddev_pop?: Maybe<Dedicated_Cloud_Commitments_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Dedicated_Cloud_Commitments_Stddev_Samp_Fields>;
  sum?: Maybe<Dedicated_Cloud_Commitments_Sum_Fields>;
  var_pop?: Maybe<Dedicated_Cloud_Commitments_Var_Pop_Fields>;
  var_samp?: Maybe<Dedicated_Cloud_Commitments_Var_Samp_Fields>;
  variance?: Maybe<Dedicated_Cloud_Commitments_Variance_Fields>;
};

/** aggregate fields of "dedicated_cloud_commitments" */
export type Dedicated_Cloud_Commitments_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Dedicated_Cloud_Commitments_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Dedicated_Cloud_Commitments_Avg_Fields = {
  __typename?: 'dedicated_cloud_commitments_avg_fields';
  total_commitment?: Maybe<Scalars['Float']>;
  yearly_commitment?: Maybe<Scalars['Float']>;
};

/**
 * Boolean expression to filter rows from the table "dedicated_cloud_commitments".
 * All fields are combined with a logical 'AND'.
 */
export type Dedicated_Cloud_Commitments_Bool_Exp = {
  _and?: Maybe<Array<Dedicated_Cloud_Commitments_Bool_Exp>>;
  _not?: Maybe<Dedicated_Cloud_Commitments_Bool_Exp>;
  _or?: Maybe<Array<Dedicated_Cloud_Commitments_Bool_Exp>>;
  commitment_end?: Maybe<Date_Comparison_Exp>;
  commitment_start?: Maybe<Date_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  monthly_usage?: Maybe<Dedicated_Cloud_Bills_Bool_Exp>;
  monthly_usage_aggregate?: Maybe<Dedicated_Cloud_Bills_Aggregate_Bool_Exp>;
  support_plan?: Maybe<Support_Plan_Types_Enum_Comparison_Exp>;
  total_commitment?: Maybe<Int_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  user_id?: Maybe<Uuid_Comparison_Exp>;
  yearly_commitment?: Maybe<Int_Comparison_Exp>;
};

/** unique or primary key constraints on table "dedicated_cloud_commitments" */
export enum Dedicated_Cloud_Commitments_Constraint {
  /** unique or primary key constraint on columns "id" */
  DedicatedCloudCommitmentsPkey = 'dedicated_cloud_commitments_pkey',
}

/** input type for incrementing numeric columns in table "dedicated_cloud_commitments" */
export type Dedicated_Cloud_Commitments_Inc_Input = {
  total_commitment?: Maybe<Scalars['Int']>;
  yearly_commitment?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "dedicated_cloud_commitments" */
export type Dedicated_Cloud_Commitments_Insert_Input = {
  commitment_end?: Maybe<Scalars['date']>;
  commitment_start?: Maybe<Scalars['date']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  monthly_usage?: Maybe<Dedicated_Cloud_Bills_Arr_Rel_Insert_Input>;
  support_plan?: Maybe<Support_Plan_Types_Enum>;
  total_commitment?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  yearly_commitment?: Maybe<Scalars['Int']>;
};

/** aggregate max on columns */
export type Dedicated_Cloud_Commitments_Max_Fields = {
  __typename?: 'dedicated_cloud_commitments_max_fields';
  commitment_end?: Maybe<Scalars['date']>;
  commitment_start?: Maybe<Scalars['date']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  total_commitment?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  yearly_commitment?: Maybe<Scalars['Int']>;
};

/** aggregate min on columns */
export type Dedicated_Cloud_Commitments_Min_Fields = {
  __typename?: 'dedicated_cloud_commitments_min_fields';
  commitment_end?: Maybe<Scalars['date']>;
  commitment_start?: Maybe<Scalars['date']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  total_commitment?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  yearly_commitment?: Maybe<Scalars['Int']>;
};

/** response of any mutation on the table "dedicated_cloud_commitments" */
export type Dedicated_Cloud_Commitments_Mutation_Response = {
  __typename?: 'dedicated_cloud_commitments_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Dedicated_Cloud_Commitments>;
};

/** on_conflict condition type for table "dedicated_cloud_commitments" */
export type Dedicated_Cloud_Commitments_On_Conflict = {
  constraint: Dedicated_Cloud_Commitments_Constraint;
  update_columns?: Array<Dedicated_Cloud_Commitments_Update_Column>;
  where?: Maybe<Dedicated_Cloud_Commitments_Bool_Exp>;
};

/** Ordering options when selecting data from "dedicated_cloud_commitments". */
export type Dedicated_Cloud_Commitments_Order_By = {
  commitment_end?: Maybe<Order_By>;
  commitment_start?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  monthly_usage_aggregate?: Maybe<Dedicated_Cloud_Bills_Aggregate_Order_By>;
  support_plan?: Maybe<Order_By>;
  total_commitment?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
  yearly_commitment?: Maybe<Order_By>;
};

/** primary key columns input for table: dedicated_cloud_commitments */
export type Dedicated_Cloud_Commitments_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "dedicated_cloud_commitments" */
export enum Dedicated_Cloud_Commitments_Select_Column {
  /** column name */
  CommitmentEnd = 'commitment_end',
  /** column name */
  CommitmentStart = 'commitment_start',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  SupportPlan = 'support_plan',
  /** column name */
  TotalCommitment = 'total_commitment',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
  /** column name */
  YearlyCommitment = 'yearly_commitment',
}

/** input type for updating data in table "dedicated_cloud_commitments" */
export type Dedicated_Cloud_Commitments_Set_Input = {
  commitment_end?: Maybe<Scalars['date']>;
  commitment_start?: Maybe<Scalars['date']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  support_plan?: Maybe<Support_Plan_Types_Enum>;
  total_commitment?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  yearly_commitment?: Maybe<Scalars['Int']>;
};

/** aggregate stddev on columns */
export type Dedicated_Cloud_Commitments_Stddev_Fields = {
  __typename?: 'dedicated_cloud_commitments_stddev_fields';
  total_commitment?: Maybe<Scalars['Float']>;
  yearly_commitment?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Dedicated_Cloud_Commitments_Stddev_Pop_Fields = {
  __typename?: 'dedicated_cloud_commitments_stddev_pop_fields';
  total_commitment?: Maybe<Scalars['Float']>;
  yearly_commitment?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Dedicated_Cloud_Commitments_Stddev_Samp_Fields = {
  __typename?: 'dedicated_cloud_commitments_stddev_samp_fields';
  total_commitment?: Maybe<Scalars['Float']>;
  yearly_commitment?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "dedicated_cloud_commitments" */
export type Dedicated_Cloud_Commitments_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Dedicated_Cloud_Commitments_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Dedicated_Cloud_Commitments_Stream_Cursor_Value_Input = {
  commitment_end?: Maybe<Scalars['date']>;
  commitment_start?: Maybe<Scalars['date']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  support_plan?: Maybe<Support_Plan_Types_Enum>;
  total_commitment?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  yearly_commitment?: Maybe<Scalars['Int']>;
};

/** aggregate sum on columns */
export type Dedicated_Cloud_Commitments_Sum_Fields = {
  __typename?: 'dedicated_cloud_commitments_sum_fields';
  total_commitment?: Maybe<Scalars['Int']>;
  yearly_commitment?: Maybe<Scalars['Int']>;
};

/** update columns of table "dedicated_cloud_commitments" */
export enum Dedicated_Cloud_Commitments_Update_Column {
  /** column name */
  CommitmentEnd = 'commitment_end',
  /** column name */
  CommitmentStart = 'commitment_start',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  SupportPlan = 'support_plan',
  /** column name */
  TotalCommitment = 'total_commitment',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
  /** column name */
  YearlyCommitment = 'yearly_commitment',
}

export type Dedicated_Cloud_Commitments_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Dedicated_Cloud_Commitments_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Dedicated_Cloud_Commitments_Set_Input>;
  /** filter the rows which have to be updated */
  where: Dedicated_Cloud_Commitments_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Dedicated_Cloud_Commitments_Var_Pop_Fields = {
  __typename?: 'dedicated_cloud_commitments_var_pop_fields';
  total_commitment?: Maybe<Scalars['Float']>;
  yearly_commitment?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Dedicated_Cloud_Commitments_Var_Samp_Fields = {
  __typename?: 'dedicated_cloud_commitments_var_samp_fields';
  total_commitment?: Maybe<Scalars['Float']>;
  yearly_commitment?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Dedicated_Cloud_Commitments_Variance_Fields = {
  __typename?: 'dedicated_cloud_commitments_variance_fields';
  total_commitment?: Maybe<Scalars['Float']>;
  yearly_commitment?: Maybe<Scalars['Float']>;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_Vpc = {
  __typename?: 'dedicated_vpc';
  cidr?: Maybe<Scalars['String']>;
  cloud: Scalars['String'];
  comments?: Maybe<Scalars['String']>;
  create_with_dev_cluster: Scalars['Boolean'];
  created_at: Scalars['timestamptz'];
  /** An object relationship */
  dedicated_vpc?: Maybe<Dedicated_Vpc>;
  destroy_requested?: Maybe<Scalars['Boolean']>;
  disable_infra_auto_apply: Scalars['Boolean'];
  /** Returns the GCP network name of the VPC on Hasura Cloud */
  gcp_network_name?: Maybe<Scalars['String']>;
  /** Returns the security group to be associated with hasura workers inside dedicated VPC */
  hasura_worker_security_group_id?: Maybe<Scalars['String']>;
  id: Scalars['uuid'];
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  message?: Maybe<Scalars['String']>;
  name: Scalars['String'];
  nat_ip?: Maybe<Scalars['String']>;
  nat_ips?: Maybe<Scalars['json']>;
  our_asn?: Maybe<Scalars['Int']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  /** An object relationship */
  owner: Users;
  owner_id: Scalars['uuid'];
  parent_dedicated_vpc_id?: Maybe<Scalars['uuid']>;
  region: Scalars['String'];
  /** An object relationship */
  region_info?: Maybe<Region>;
  slug: Scalars['String'];
  status: Vpc_Status_Enum;
  /** An array relationship */
  tenant_groups: Array<Tenant_Group>;
  /** An aggregate relationship */
  tenant_groups_aggregate: Tenant_Group_Aggregate;
  /** An array relationship */
  tenants: Array<Tenant>;
  /** An aggregate relationship */
  tenants_aggregate: Tenant_Aggregate;
  their_asn?: Maybe<Scalars['Int']>;
  /** Get the VPC CIDR */
  vpc_cidr?: Maybe<Scalars['String']>;
  /** returns AWS VPC ID of the dedicated VPC */
  vpc_id?: Maybe<Scalars['String']>;
  /** An array relationship */
  vpc_peerings: Array<Vpc_Peering>;
  /** An aggregate relationship */
  vpc_peerings_aggregate: Vpc_Peering_Aggregate;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_VpcInput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_VpcNat_IpsArgs = {
  path?: Maybe<Scalars['String']>;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_VpcOutput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_VpcTenant_GroupsArgs = {
  distinct_on?: Maybe<Array<Tenant_Group_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Tenant_Group_Order_By>>;
  where?: Maybe<Tenant_Group_Bool_Exp>;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_VpcTenant_Groups_AggregateArgs = {
  distinct_on?: Maybe<Array<Tenant_Group_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Tenant_Group_Order_By>>;
  where?: Maybe<Tenant_Group_Bool_Exp>;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_VpcTenantsArgs = {
  distinct_on?: Maybe<Array<Tenant_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Tenant_Order_By>>;
  where?: Maybe<Tenant_Bool_Exp>;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_VpcTenants_AggregateArgs = {
  distinct_on?: Maybe<Array<Tenant_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Tenant_Order_By>>;
  where?: Maybe<Tenant_Bool_Exp>;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_VpcVpc_PeeringsArgs = {
  distinct_on?: Maybe<Array<Vpc_Peering_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Vpc_Peering_Order_By>>;
  where?: Maybe<Vpc_Peering_Bool_Exp>;
};

/** VPC to run dedicated hasura cloud  */
export type Dedicated_VpcVpc_Peerings_AggregateArgs = {
  distinct_on?: Maybe<Array<Vpc_Peering_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Vpc_Peering_Order_By>>;
  where?: Maybe<Vpc_Peering_Bool_Exp>;
};

/** aggregated selection of "dedicated_vpc" */
export type Dedicated_Vpc_Aggregate = {
  __typename?: 'dedicated_vpc_aggregate';
  aggregate?: Maybe<Dedicated_Vpc_Aggregate_Fields>;
  nodes: Array<Dedicated_Vpc>;
};

/** aggregate fields of "dedicated_vpc" */
export type Dedicated_Vpc_Aggregate_Fields = {
  __typename?: 'dedicated_vpc_aggregate_fields';
  avg?: Maybe<Dedicated_Vpc_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Dedicated_Vpc_Max_Fields>;
  min?: Maybe<Dedicated_Vpc_Min_Fields>;
  stddev?: Maybe<Dedicated_Vpc_Stddev_Fields>;
  stddev_pop?: Maybe<Dedicated_Vpc_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Dedicated_Vpc_Stddev_Samp_Fields>;
  sum?: Maybe<Dedicated_Vpc_Sum_Fields>;
  var_pop?: Maybe<Dedicated_Vpc_Var_Pop_Fields>;
  var_samp?: Maybe<Dedicated_Vpc_Var_Samp_Fields>;
  variance?: Maybe<Dedicated_Vpc_Variance_Fields>;
};

/** aggregate fields of "dedicated_vpc" */
export type Dedicated_Vpc_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Dedicated_Vpc_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Dedicated_Vpc_Append_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** aggregate avg on columns */
export type Dedicated_Vpc_Avg_Fields = {
  __typename?: 'dedicated_vpc_avg_fields';
  our_asn?: Maybe<Scalars['Float']>;
  their_asn?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "dedicated_vpc". All fields are combined with a logical 'AND'. */
export type Dedicated_Vpc_Bool_Exp = {
  _and?: Maybe<Array<Dedicated_Vpc_Bool_Exp>>;
  _not?: Maybe<Dedicated_Vpc_Bool_Exp>;
  _or?: Maybe<Array<Dedicated_Vpc_Bool_Exp>>;
  cidr?: Maybe<String_Comparison_Exp>;
  cloud?: Maybe<String_Comparison_Exp>;
  comments?: Maybe<String_Comparison_Exp>;
  create_with_dev_cluster?: Maybe<Boolean_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  dedicated_vpc?: Maybe<Dedicated_Vpc_Bool_Exp>;
  destroy_requested?: Maybe<Boolean_Comparison_Exp>;
  disable_infra_auto_apply?: Maybe<Boolean_Comparison_Exp>;
  gcp_network_name?: Maybe<String_Comparison_Exp>;
  hasura_worker_security_group_id?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  infra_status?: Maybe<Infra_Status_Enum_Comparison_Exp>;
  input_variables?: Maybe<Jsonb_Comparison_Exp>;
  message?: Maybe<String_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  nat_ip?: Maybe<String_Comparison_Exp>;
  nat_ips?: Maybe<Json_Comparison_Exp>;
  our_asn?: Maybe<Int_Comparison_Exp>;
  output_variables?: Maybe<Jsonb_Comparison_Exp>;
  owner?: Maybe<Users_Bool_Exp>;
  owner_id?: Maybe<Uuid_Comparison_Exp>;
  parent_dedicated_vpc_id?: Maybe<Uuid_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  region_info?: Maybe<Region_Bool_Exp>;
  slug?: Maybe<String_Comparison_Exp>;
  status?: Maybe<Vpc_Status_Enum_Comparison_Exp>;
  tenant_groups?: Maybe<Tenant_Group_Bool_Exp>;
  tenant_groups_aggregate?: Maybe<Tenant_Group_Aggregate_Bool_Exp>;
  tenants?: Maybe<Tenant_Bool_Exp>;
  tenants_aggregate?: Maybe<Tenant_Aggregate_Bool_Exp>;
  their_asn?: Maybe<Int_Comparison_Exp>;
  vpc_cidr?: Maybe<String_Comparison_Exp>;
  vpc_id?: Maybe<String_Comparison_Exp>;
  vpc_peerings?: Maybe<Vpc_Peering_Bool_Exp>;
  vpc_peerings_aggregate?: Maybe<Vpc_Peering_Aggregate_Bool_Exp>;
};

/** unique or primary key constraints on table "dedicated_vpc" */
export enum Dedicated_Vpc_Constraint {
  /** unique or primary key constraint on columns "id" */
  DedicatedVpcPkey = 'dedicated_vpc_pkey',
  /** unique or primary key constraint on columns "slug" */
  DedicatedVpcSlugKey = 'dedicated_vpc_slug_key',
  /** unique or primary key constraint on columns "our_asn", "their_asn" */
  UniqueAsns = 'unique_asns',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Dedicated_Vpc_Delete_At_Path_Input = {
  input_variables?: Maybe<Array<Scalars['String']>>;
  output_variables?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Dedicated_Vpc_Delete_Elem_Input = {
  input_variables?: Maybe<Scalars['Int']>;
  output_variables?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Dedicated_Vpc_Delete_Key_Input = {
  input_variables?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['String']>;
};

/** input type for incrementing numeric columns in table "dedicated_vpc" */
export type Dedicated_Vpc_Inc_Input = {
  our_asn?: Maybe<Scalars['Int']>;
  their_asn?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "dedicated_vpc" */
export type Dedicated_Vpc_Insert_Input = {
  cidr?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  create_with_dev_cluster?: Maybe<Scalars['Boolean']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  dedicated_vpc?: Maybe<Dedicated_Vpc_Obj_Rel_Insert_Input>;
  destroy_requested?: Maybe<Scalars['Boolean']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  message?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  nat_ip?: Maybe<Scalars['String']>;
  our_asn?: Maybe<Scalars['Int']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  owner?: Maybe<Users_Obj_Rel_Insert_Input>;
  owner_id?: Maybe<Scalars['uuid']>;
  parent_dedicated_vpc_id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  region_info?: Maybe<Region_Obj_Rel_Insert_Input>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Vpc_Status_Enum>;
  tenant_groups?: Maybe<Tenant_Group_Arr_Rel_Insert_Input>;
  tenants?: Maybe<Tenant_Arr_Rel_Insert_Input>;
  their_asn?: Maybe<Scalars['Int']>;
  vpc_peerings?: Maybe<Vpc_Peering_Arr_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Dedicated_Vpc_Max_Fields = {
  __typename?: 'dedicated_vpc_max_fields';
  cidr?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  nat_ip?: Maybe<Scalars['String']>;
  our_asn?: Maybe<Scalars['Int']>;
  owner_id?: Maybe<Scalars['uuid']>;
  parent_dedicated_vpc_id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  their_asn?: Maybe<Scalars['Int']>;
};

/** aggregate min on columns */
export type Dedicated_Vpc_Min_Fields = {
  __typename?: 'dedicated_vpc_min_fields';
  cidr?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  message?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  nat_ip?: Maybe<Scalars['String']>;
  our_asn?: Maybe<Scalars['Int']>;
  owner_id?: Maybe<Scalars['uuid']>;
  parent_dedicated_vpc_id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  their_asn?: Maybe<Scalars['Int']>;
};

/** response of any mutation on the table "dedicated_vpc" */
export type Dedicated_Vpc_Mutation_Response = {
  __typename?: 'dedicated_vpc_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Dedicated_Vpc>;
};

/** input type for inserting object relation for remote table "dedicated_vpc" */
export type Dedicated_Vpc_Obj_Rel_Insert_Input = {
  data: Dedicated_Vpc_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Dedicated_Vpc_On_Conflict>;
};

/** on_conflict condition type for table "dedicated_vpc" */
export type Dedicated_Vpc_On_Conflict = {
  constraint: Dedicated_Vpc_Constraint;
  update_columns?: Array<Dedicated_Vpc_Update_Column>;
  where?: Maybe<Dedicated_Vpc_Bool_Exp>;
};

/** Ordering options when selecting data from "dedicated_vpc". */
export type Dedicated_Vpc_Order_By = {
  cidr?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  comments?: Maybe<Order_By>;
  create_with_dev_cluster?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  dedicated_vpc?: Maybe<Dedicated_Vpc_Order_By>;
  destroy_requested?: Maybe<Order_By>;
  disable_infra_auto_apply?: Maybe<Order_By>;
  gcp_network_name?: Maybe<Order_By>;
  hasura_worker_security_group_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  infra_status?: Maybe<Order_By>;
  input_variables?: Maybe<Order_By>;
  message?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  nat_ip?: Maybe<Order_By>;
  nat_ips?: Maybe<Order_By>;
  our_asn?: Maybe<Order_By>;
  output_variables?: Maybe<Order_By>;
  owner?: Maybe<Users_Order_By>;
  owner_id?: Maybe<Order_By>;
  parent_dedicated_vpc_id?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  region_info?: Maybe<Region_Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  tenant_groups_aggregate?: Maybe<Tenant_Group_Aggregate_Order_By>;
  tenants_aggregate?: Maybe<Tenant_Aggregate_Order_By>;
  their_asn?: Maybe<Order_By>;
  vpc_cidr?: Maybe<Order_By>;
  vpc_id?: Maybe<Order_By>;
  vpc_peerings_aggregate?: Maybe<Vpc_Peering_Aggregate_Order_By>;
};

/** primary key columns input for table: dedicated_vpc */
export type Dedicated_Vpc_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Dedicated_Vpc_Prepend_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "dedicated_vpc" */
export enum Dedicated_Vpc_Select_Column {
  /** column name */
  Cidr = 'cidr',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  Comments = 'comments',
  /** column name */
  CreateWithDevCluster = 'create_with_dev_cluster',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DestroyRequested = 'destroy_requested',
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
  /** column name */
  Id = 'id',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  Message = 'message',
  /** column name */
  Name = 'name',
  /** column name */
  NatIp = 'nat_ip',
  /** column name */
  OurAsn = 'our_asn',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  OwnerId = 'owner_id',
  /** column name */
  ParentDedicatedVpcId = 'parent_dedicated_vpc_id',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
  /** column name */
  TheirAsn = 'their_asn',
}

/** input type for updating data in table "dedicated_vpc" */
export type Dedicated_Vpc_Set_Input = {
  cidr?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  create_with_dev_cluster?: Maybe<Scalars['Boolean']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  destroy_requested?: Maybe<Scalars['Boolean']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  message?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  nat_ip?: Maybe<Scalars['String']>;
  our_asn?: Maybe<Scalars['Int']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  owner_id?: Maybe<Scalars['uuid']>;
  parent_dedicated_vpc_id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Vpc_Status_Enum>;
  their_asn?: Maybe<Scalars['Int']>;
};

/** aggregate stddev on columns */
export type Dedicated_Vpc_Stddev_Fields = {
  __typename?: 'dedicated_vpc_stddev_fields';
  our_asn?: Maybe<Scalars['Float']>;
  their_asn?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Dedicated_Vpc_Stddev_Pop_Fields = {
  __typename?: 'dedicated_vpc_stddev_pop_fields';
  our_asn?: Maybe<Scalars['Float']>;
  their_asn?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Dedicated_Vpc_Stddev_Samp_Fields = {
  __typename?: 'dedicated_vpc_stddev_samp_fields';
  our_asn?: Maybe<Scalars['Float']>;
  their_asn?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "dedicated_vpc" */
export type Dedicated_Vpc_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Dedicated_Vpc_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Dedicated_Vpc_Stream_Cursor_Value_Input = {
  cidr?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  create_with_dev_cluster?: Maybe<Scalars['Boolean']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  destroy_requested?: Maybe<Scalars['Boolean']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  message?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  nat_ip?: Maybe<Scalars['String']>;
  our_asn?: Maybe<Scalars['Int']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  owner_id?: Maybe<Scalars['uuid']>;
  parent_dedicated_vpc_id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Vpc_Status_Enum>;
  their_asn?: Maybe<Scalars['Int']>;
};

/** aggregate sum on columns */
export type Dedicated_Vpc_Sum_Fields = {
  __typename?: 'dedicated_vpc_sum_fields';
  our_asn?: Maybe<Scalars['Int']>;
  their_asn?: Maybe<Scalars['Int']>;
};

/** update columns of table "dedicated_vpc" */
export enum Dedicated_Vpc_Update_Column {
  /** column name */
  Cidr = 'cidr',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  Comments = 'comments',
  /** column name */
  CreateWithDevCluster = 'create_with_dev_cluster',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DestroyRequested = 'destroy_requested',
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
  /** column name */
  Id = 'id',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  Message = 'message',
  /** column name */
  Name = 'name',
  /** column name */
  NatIp = 'nat_ip',
  /** column name */
  OurAsn = 'our_asn',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  OwnerId = 'owner_id',
  /** column name */
  ParentDedicatedVpcId = 'parent_dedicated_vpc_id',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
  /** column name */
  TheirAsn = 'their_asn',
}

export type Dedicated_Vpc_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Dedicated_Vpc_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Dedicated_Vpc_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Dedicated_Vpc_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Dedicated_Vpc_Delete_Key_Input>;
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Dedicated_Vpc_Inc_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Dedicated_Vpc_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Dedicated_Vpc_Set_Input>;
  /** filter the rows which have to be updated */
  where: Dedicated_Vpc_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Dedicated_Vpc_Var_Pop_Fields = {
  __typename?: 'dedicated_vpc_var_pop_fields';
  our_asn?: Maybe<Scalars['Float']>;
  their_asn?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Dedicated_Vpc_Var_Samp_Fields = {
  __typename?: 'dedicated_vpc_var_samp_fields';
  our_asn?: Maybe<Scalars['Float']>;
  their_asn?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Dedicated_Vpc_Variance_Fields = {
  __typename?: 'dedicated_vpc_variance_fields';
  our_asn?: Maybe<Scalars['Float']>;
  their_asn?: Maybe<Scalars['Float']>;
};

export type DedicatedCloudClusterBillsOutput = {
  __typename?: 'DedicatedCloudClusterBillsOutput';
  compute_unit_config_id: Scalars['uuid'];
  cu_usage_amount: Scalars['Int'];
  data_usage_amount: Scalars['Int'];
  month: Scalars['Int'];
  year: Scalars['Int'];
};

export type DefaultPaymentResponse = {
  __typename?: 'DefaultPaymentResponse';
  status: Scalars['String'];
};

/** Table to record user deletion */
export type Delete_User = {
  __typename?: 'delete_user';
  created_at: Scalars['timestamptz'];
  /** An array relationship */
  delete_tasks: Array<Delete_User_Tasks>;
  /** An aggregate relationship */
  delete_tasks_aggregate: Delete_User_Tasks_Aggregate;
  status?: Maybe<Scalars['String']>;
  stripe_customer_id?: Maybe<Scalars['String']>;
  user_id: Scalars['uuid'];
};

/** Table to record user deletion */
export type Delete_UserDelete_TasksArgs = {
  distinct_on?: Maybe<Array<Delete_User_Tasks_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Delete_User_Tasks_Order_By>>;
  where?: Maybe<Delete_User_Tasks_Bool_Exp>;
};

/** Table to record user deletion */
export type Delete_UserDelete_Tasks_AggregateArgs = {
  distinct_on?: Maybe<Array<Delete_User_Tasks_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Delete_User_Tasks_Order_By>>;
  where?: Maybe<Delete_User_Tasks_Bool_Exp>;
};

/** aggregated selection of "delete_user" */
export type Delete_User_Aggregate = {
  __typename?: 'delete_user_aggregate';
  aggregate?: Maybe<Delete_User_Aggregate_Fields>;
  nodes: Array<Delete_User>;
};

/** aggregate fields of "delete_user" */
export type Delete_User_Aggregate_Fields = {
  __typename?: 'delete_user_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Delete_User_Max_Fields>;
  min?: Maybe<Delete_User_Min_Fields>;
};

/** aggregate fields of "delete_user" */
export type Delete_User_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Delete_User_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "delete_user". All fields are combined with a logical 'AND'. */
export type Delete_User_Bool_Exp = {
  _and?: Maybe<Array<Delete_User_Bool_Exp>>;
  _not?: Maybe<Delete_User_Bool_Exp>;
  _or?: Maybe<Array<Delete_User_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  delete_tasks?: Maybe<Delete_User_Tasks_Bool_Exp>;
  delete_tasks_aggregate?: Maybe<Delete_User_Tasks_Aggregate_Bool_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  stripe_customer_id?: Maybe<String_Comparison_Exp>;
  user_id?: Maybe<Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "delete_user" */
export enum Delete_User_Constraint {
  /** unique or primary key constraint on columns "user_id" */
  DeleteUserPkey = 'delete_user_pkey',
  /** unique or primary key constraint on columns "stripe_customer_id" */
  DeleteUserStripeCustomerIdKey = 'delete_user_stripe_customer_id_key',
}

/** input type for inserting data into table "delete_user" */
export type Delete_User_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  delete_tasks?: Maybe<Delete_User_Tasks_Arr_Rel_Insert_Input>;
  stripe_customer_id?: Maybe<Scalars['String']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Delete_User_Max_Fields = {
  __typename?: 'delete_user_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  stripe_customer_id?: Maybe<Scalars['String']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate min on columns */
export type Delete_User_Min_Fields = {
  __typename?: 'delete_user_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  stripe_customer_id?: Maybe<Scalars['String']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** response of any mutation on the table "delete_user" */
export type Delete_User_Mutation_Response = {
  __typename?: 'delete_user_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Delete_User>;
};

/** on_conflict condition type for table "delete_user" */
export type Delete_User_On_Conflict = {
  constraint: Delete_User_Constraint;
  update_columns?: Array<Delete_User_Update_Column>;
  where?: Maybe<Delete_User_Bool_Exp>;
};

/** Ordering options when selecting data from "delete_user". */
export type Delete_User_Order_By = {
  created_at?: Maybe<Order_By>;
  delete_tasks_aggregate?: Maybe<Delete_User_Tasks_Aggregate_Order_By>;
  status?: Maybe<Order_By>;
  stripe_customer_id?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
};

/** primary key columns input for table: delete_user */
export type Delete_User_Pk_Columns_Input = {
  user_id: Scalars['uuid'];
};

/** select columns of table "delete_user" */
export enum Delete_User_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  StripeCustomerId = 'stripe_customer_id',
  /** column name */
  UserId = 'user_id',
}

/** input type for updating data in table "delete_user" */
export type Delete_User_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  stripe_customer_id?: Maybe<Scalars['String']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** Hasura enum to capture the status of user deletion */
export type Delete_User_Status = {
  __typename?: 'delete_user_status';
  comment: Scalars['String'];
  status: Scalars['String'];
};

/** aggregated selection of "delete_user_status" */
export type Delete_User_Status_Aggregate = {
  __typename?: 'delete_user_status_aggregate';
  aggregate?: Maybe<Delete_User_Status_Aggregate_Fields>;
  nodes: Array<Delete_User_Status>;
};

/** aggregate fields of "delete_user_status" */
export type Delete_User_Status_Aggregate_Fields = {
  __typename?: 'delete_user_status_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Delete_User_Status_Max_Fields>;
  min?: Maybe<Delete_User_Status_Min_Fields>;
};

/** aggregate fields of "delete_user_status" */
export type Delete_User_Status_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Delete_User_Status_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "delete_user_status". All fields are combined with a logical 'AND'. */
export type Delete_User_Status_Bool_Exp = {
  _and?: Maybe<Array<Delete_User_Status_Bool_Exp>>;
  _not?: Maybe<Delete_User_Status_Bool_Exp>;
  _or?: Maybe<Array<Delete_User_Status_Bool_Exp>>;
  comment?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "delete_user_status" */
export enum Delete_User_Status_Constraint {
  /** unique or primary key constraint on columns "status" */
  DeleteUserStatusPkey = 'delete_user_status_pkey',
}

export enum Delete_User_Status_Enum {
  /** the task is completed */
  Completed = 'completed',
  /** the task is failed */
  Failed = 'failed',
  /** the task is in progress */
  InProgress = 'in_progress',
  /** the task is pending */
  Pending = 'pending',
}

/** Boolean expression to compare columns of type "delete_user_status_enum". All fields are combined with logical 'AND'. */
export type Delete_User_Status_Enum_Comparison_Exp = {
  _eq?: Maybe<Delete_User_Status_Enum>;
  _in?: Maybe<Array<Delete_User_Status_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Delete_User_Status_Enum>;
  _nin?: Maybe<Array<Delete_User_Status_Enum>>;
};

/** input type for inserting data into table "delete_user_status" */
export type Delete_User_Status_Insert_Input = {
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Delete_User_Status_Max_Fields = {
  __typename?: 'delete_user_status_max_fields';
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Delete_User_Status_Min_Fields = {
  __typename?: 'delete_user_status_min_fields';
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "delete_user_status" */
export type Delete_User_Status_Mutation_Response = {
  __typename?: 'delete_user_status_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Delete_User_Status>;
};

/** on_conflict condition type for table "delete_user_status" */
export type Delete_User_Status_On_Conflict = {
  constraint: Delete_User_Status_Constraint;
  update_columns?: Array<Delete_User_Status_Update_Column>;
  where?: Maybe<Delete_User_Status_Bool_Exp>;
};

/** Ordering options when selecting data from "delete_user_status". */
export type Delete_User_Status_Order_By = {
  comment?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
};

/** primary key columns input for table: delete_user_status */
export type Delete_User_Status_Pk_Columns_Input = {
  status: Scalars['String'];
};

/** select columns of table "delete_user_status" */
export enum Delete_User_Status_Select_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Status = 'status',
}

/** input type for updating data in table "delete_user_status" */
export type Delete_User_Status_Set_Input = {
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "delete_user_status" */
export type Delete_User_Status_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Delete_User_Status_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Delete_User_Status_Stream_Cursor_Value_Input = {
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** update columns of table "delete_user_status" */
export enum Delete_User_Status_Update_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Status = 'status',
}

export type Delete_User_Status_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Delete_User_Status_Set_Input>;
  /** filter the rows which have to be updated */
  where: Delete_User_Status_Bool_Exp;
};

/** Streaming cursor of the table "delete_user" */
export type Delete_User_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Delete_User_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Delete_User_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  stripe_customer_id?: Maybe<Scalars['String']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** User tasks to be deleted */
export type Delete_User_Tasks = {
  __typename?: 'delete_user_tasks';
  additional_info?: Maybe<Scalars['jsonb']>;
  remarks?: Maybe<Scalars['String']>;
  status: Delete_User_Status_Enum;
  task_name: Scalars['String'];
  task_order: Scalars['Int'];
  user_id: Scalars['uuid'];
  /** An object relationship */
  users?: Maybe<Users>;
};

/** User tasks to be deleted */
export type Delete_User_TasksAdditional_InfoArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "delete_user_tasks" */
export type Delete_User_Tasks_Aggregate = {
  __typename?: 'delete_user_tasks_aggregate';
  aggregate?: Maybe<Delete_User_Tasks_Aggregate_Fields>;
  nodes: Array<Delete_User_Tasks>;
};

export type Delete_User_Tasks_Aggregate_Bool_Exp = {
  count?: Maybe<Delete_User_Tasks_Aggregate_Bool_Exp_Count>;
};

export type Delete_User_Tasks_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Delete_User_Tasks_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Delete_User_Tasks_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "delete_user_tasks" */
export type Delete_User_Tasks_Aggregate_Fields = {
  __typename?: 'delete_user_tasks_aggregate_fields';
  avg?: Maybe<Delete_User_Tasks_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Delete_User_Tasks_Max_Fields>;
  min?: Maybe<Delete_User_Tasks_Min_Fields>;
  stddev?: Maybe<Delete_User_Tasks_Stddev_Fields>;
  stddev_pop?: Maybe<Delete_User_Tasks_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Delete_User_Tasks_Stddev_Samp_Fields>;
  sum?: Maybe<Delete_User_Tasks_Sum_Fields>;
  var_pop?: Maybe<Delete_User_Tasks_Var_Pop_Fields>;
  var_samp?: Maybe<Delete_User_Tasks_Var_Samp_Fields>;
  variance?: Maybe<Delete_User_Tasks_Variance_Fields>;
};

/** aggregate fields of "delete_user_tasks" */
export type Delete_User_Tasks_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Delete_User_Tasks_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "delete_user_tasks" */
export type Delete_User_Tasks_Aggregate_Order_By = {
  avg?: Maybe<Delete_User_Tasks_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Delete_User_Tasks_Max_Order_By>;
  min?: Maybe<Delete_User_Tasks_Min_Order_By>;
  stddev?: Maybe<Delete_User_Tasks_Stddev_Order_By>;
  stddev_pop?: Maybe<Delete_User_Tasks_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Delete_User_Tasks_Stddev_Samp_Order_By>;
  sum?: Maybe<Delete_User_Tasks_Sum_Order_By>;
  var_pop?: Maybe<Delete_User_Tasks_Var_Pop_Order_By>;
  var_samp?: Maybe<Delete_User_Tasks_Var_Samp_Order_By>;
  variance?: Maybe<Delete_User_Tasks_Variance_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Delete_User_Tasks_Append_Input = {
  additional_info?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "delete_user_tasks" */
export type Delete_User_Tasks_Arr_Rel_Insert_Input = {
  data: Array<Delete_User_Tasks_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Delete_User_Tasks_On_Conflict>;
};

/** aggregate avg on columns */
export type Delete_User_Tasks_Avg_Fields = {
  __typename?: 'delete_user_tasks_avg_fields';
  task_order?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Avg_Order_By = {
  task_order?: Maybe<Order_By>;
};

/** Boolean expression to filter rows from the table "delete_user_tasks". All fields are combined with a logical 'AND'. */
export type Delete_User_Tasks_Bool_Exp = {
  _and?: Maybe<Array<Delete_User_Tasks_Bool_Exp>>;
  _not?: Maybe<Delete_User_Tasks_Bool_Exp>;
  _or?: Maybe<Array<Delete_User_Tasks_Bool_Exp>>;
  additional_info?: Maybe<Jsonb_Comparison_Exp>;
  remarks?: Maybe<String_Comparison_Exp>;
  status?: Maybe<Delete_User_Status_Enum_Comparison_Exp>;
  task_name?: Maybe<String_Comparison_Exp>;
  task_order?: Maybe<Int_Comparison_Exp>;
  user_id?: Maybe<Uuid_Comparison_Exp>;
  users?: Maybe<Users_Bool_Exp>;
};

/** unique or primary key constraints on table "delete_user_tasks" */
export enum Delete_User_Tasks_Constraint {
  /** unique or primary key constraint on columns "user_id", "task_name" */
  DeleteUserTasksPkey = 'delete_user_tasks_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Delete_User_Tasks_Delete_At_Path_Input = {
  additional_info?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Delete_User_Tasks_Delete_Elem_Input = {
  additional_info?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Delete_User_Tasks_Delete_Key_Input = {
  additional_info?: Maybe<Scalars['String']>;
};

/** input type for incrementing numeric columns in table "delete_user_tasks" */
export type Delete_User_Tasks_Inc_Input = {
  task_order?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "delete_user_tasks" */
export type Delete_User_Tasks_Insert_Input = {
  additional_info?: Maybe<Scalars['jsonb']>;
  remarks?: Maybe<Scalars['String']>;
  status?: Maybe<Delete_User_Status_Enum>;
  task_name?: Maybe<Scalars['String']>;
  task_order?: Maybe<Scalars['Int']>;
  user_id?: Maybe<Scalars['uuid']>;
  users?: Maybe<Users_Obj_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Delete_User_Tasks_Max_Fields = {
  __typename?: 'delete_user_tasks_max_fields';
  remarks?: Maybe<Scalars['String']>;
  task_name?: Maybe<Scalars['String']>;
  task_order?: Maybe<Scalars['Int']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** order by max() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Max_Order_By = {
  remarks?: Maybe<Order_By>;
  task_name?: Maybe<Order_By>;
  task_order?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Delete_User_Tasks_Min_Fields = {
  __typename?: 'delete_user_tasks_min_fields';
  remarks?: Maybe<Scalars['String']>;
  task_name?: Maybe<Scalars['String']>;
  task_order?: Maybe<Scalars['Int']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** order by min() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Min_Order_By = {
  remarks?: Maybe<Order_By>;
  task_name?: Maybe<Order_By>;
  task_order?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "delete_user_tasks" */
export type Delete_User_Tasks_Mutation_Response = {
  __typename?: 'delete_user_tasks_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Delete_User_Tasks>;
};

/** on_conflict condition type for table "delete_user_tasks" */
export type Delete_User_Tasks_On_Conflict = {
  constraint: Delete_User_Tasks_Constraint;
  update_columns?: Array<Delete_User_Tasks_Update_Column>;
  where?: Maybe<Delete_User_Tasks_Bool_Exp>;
};

/** Ordering options when selecting data from "delete_user_tasks". */
export type Delete_User_Tasks_Order_By = {
  additional_info?: Maybe<Order_By>;
  remarks?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  task_name?: Maybe<Order_By>;
  task_order?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
  users?: Maybe<Users_Order_By>;
};

/** primary key columns input for table: delete_user_tasks */
export type Delete_User_Tasks_Pk_Columns_Input = {
  task_name: Scalars['String'];
  user_id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Delete_User_Tasks_Prepend_Input = {
  additional_info?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "delete_user_tasks" */
export enum Delete_User_Tasks_Select_Column {
  /** column name */
  AdditionalInfo = 'additional_info',
  /** column name */
  Remarks = 'remarks',
  /** column name */
  Status = 'status',
  /** column name */
  TaskName = 'task_name',
  /** column name */
  TaskOrder = 'task_order',
  /** column name */
  UserId = 'user_id',
}

/** input type for updating data in table "delete_user_tasks" */
export type Delete_User_Tasks_Set_Input = {
  additional_info?: Maybe<Scalars['jsonb']>;
  remarks?: Maybe<Scalars['String']>;
  status?: Maybe<Delete_User_Status_Enum>;
  task_name?: Maybe<Scalars['String']>;
  task_order?: Maybe<Scalars['Int']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate stddev on columns */
export type Delete_User_Tasks_Stddev_Fields = {
  __typename?: 'delete_user_tasks_stddev_fields';
  task_order?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Stddev_Order_By = {
  task_order?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Delete_User_Tasks_Stddev_Pop_Fields = {
  __typename?: 'delete_user_tasks_stddev_pop_fields';
  task_order?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Stddev_Pop_Order_By = {
  task_order?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Delete_User_Tasks_Stddev_Samp_Fields = {
  __typename?: 'delete_user_tasks_stddev_samp_fields';
  task_order?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Stddev_Samp_Order_By = {
  task_order?: Maybe<Order_By>;
};

/** Streaming cursor of the table "delete_user_tasks" */
export type Delete_User_Tasks_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Delete_User_Tasks_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Delete_User_Tasks_Stream_Cursor_Value_Input = {
  additional_info?: Maybe<Scalars['jsonb']>;
  remarks?: Maybe<Scalars['String']>;
  status?: Maybe<Delete_User_Status_Enum>;
  task_name?: Maybe<Scalars['String']>;
  task_order?: Maybe<Scalars['Int']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate sum on columns */
export type Delete_User_Tasks_Sum_Fields = {
  __typename?: 'delete_user_tasks_sum_fields';
  task_order?: Maybe<Scalars['Int']>;
};

/** order by sum() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Sum_Order_By = {
  task_order?: Maybe<Order_By>;
};

/** update columns of table "delete_user_tasks" */
export enum Delete_User_Tasks_Update_Column {
  /** column name */
  AdditionalInfo = 'additional_info',
  /** column name */
  Remarks = 'remarks',
  /** column name */
  Status = 'status',
  /** column name */
  TaskName = 'task_name',
  /** column name */
  TaskOrder = 'task_order',
  /** column name */
  UserId = 'user_id',
}

export type Delete_User_Tasks_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Delete_User_Tasks_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Delete_User_Tasks_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Delete_User_Tasks_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Delete_User_Tasks_Delete_Key_Input>;
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Delete_User_Tasks_Inc_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Delete_User_Tasks_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Delete_User_Tasks_Set_Input>;
  /** filter the rows which have to be updated */
  where: Delete_User_Tasks_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Delete_User_Tasks_Var_Pop_Fields = {
  __typename?: 'delete_user_tasks_var_pop_fields';
  task_order?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Var_Pop_Order_By = {
  task_order?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Delete_User_Tasks_Var_Samp_Fields = {
  __typename?: 'delete_user_tasks_var_samp_fields';
  task_order?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Var_Samp_Order_By = {
  task_order?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Delete_User_Tasks_Variance_Fields = {
  __typename?: 'delete_user_tasks_variance_fields';
  task_order?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "delete_user_tasks" */
export type Delete_User_Tasks_Variance_Order_By = {
  task_order?: Maybe<Order_By>;
};

/** update columns of table "delete_user" */
export enum Delete_User_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  StripeCustomerId = 'stripe_customer_id',
  /** column name */
  UserId = 'user_id',
}

export type Delete_User_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Delete_User_Set_Input>;
  /** filter the rows which have to be updated */
  where: Delete_User_Bool_Exp;
};

export type DeleteCardResponse = {
  __typename?: 'DeleteCardResponse';
  msg: Scalars['String'];
};

export type DeleteGithubIntegrationInput = {
  integration_id: Scalars['String'];
};

export type DeleteGithubIntegrationStatus = {
  __typename?: 'DeleteGithubIntegrationStatus';
  status: Scalars['String'];
};

export type DeleteProjectInput = {
  id: Scalars['uuid'];
};

export type DeleteProjectResponse = {
  __typename?: 'DeleteProjectResponse';
  id: Scalars['uuid'];
};

export type DeleteSlackAppOutput = {
  __typename?: 'DeleteSlackAppOutput';
  status: Scalars['String'];
};

export type DeleteUserResponse = {
  __typename?: 'deleteUserResponse';
  status: Scalars['String'];
};

export type DelteSlackAppPayload = {
  projectID: Scalars['uuid'];
};

export type DeployLatestCommitStatus = {
  __typename?: 'DeployLatestCommitStatus';
  status: Scalars['String'];
};

export type DeployLatestGithubCommitInput = {
  github_intergation_config_id: Scalars['String'];
};

/** columns and relationships of "email_log" */
export type Email_Log = {
  __typename?: 'email_log';
  created_at: Scalars['timestamptz'];
  created_by_service: Scalars['String'];
  from: Scalars['String'];
  from_name: Scalars['String'];
  id: Scalars['uuid'];
  is_sent: Scalars['Boolean'];
  sent_at?: Maybe<Scalars['timestamptz']>;
  template_metadata?: Maybe<Scalars['jsonb']>;
  template_name: Scalars['String'];
  to: Scalars['String'];
};

/** columns and relationships of "email_log" */
export type Email_LogTemplate_MetadataArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "email_log" */
export type Email_Log_Aggregate = {
  __typename?: 'email_log_aggregate';
  aggregate?: Maybe<Email_Log_Aggregate_Fields>;
  nodes: Array<Email_Log>;
};

/** aggregate fields of "email_log" */
export type Email_Log_Aggregate_Fields = {
  __typename?: 'email_log_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Email_Log_Max_Fields>;
  min?: Maybe<Email_Log_Min_Fields>;
};

/** aggregate fields of "email_log" */
export type Email_Log_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Email_Log_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Email_Log_Append_Input = {
  template_metadata?: Maybe<Scalars['jsonb']>;
};

/** Boolean expression to filter rows from the table "email_log". All fields are combined with a logical 'AND'. */
export type Email_Log_Bool_Exp = {
  _and?: Maybe<Array<Email_Log_Bool_Exp>>;
  _not?: Maybe<Email_Log_Bool_Exp>;
  _or?: Maybe<Array<Email_Log_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  created_by_service?: Maybe<String_Comparison_Exp>;
  from?: Maybe<String_Comparison_Exp>;
  from_name?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  is_sent?: Maybe<Boolean_Comparison_Exp>;
  sent_at?: Maybe<Timestamptz_Comparison_Exp>;
  template_metadata?: Maybe<Jsonb_Comparison_Exp>;
  template_name?: Maybe<String_Comparison_Exp>;
  to?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "email_log" */
export enum Email_Log_Constraint {
  /** unique or primary key constraint on columns "id" */
  EmailLogPkey = 'email_log_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Email_Log_Delete_At_Path_Input = {
  template_metadata?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Email_Log_Delete_Elem_Input = {
  template_metadata?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Email_Log_Delete_Key_Input = {
  template_metadata?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "email_log" */
export type Email_Log_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by_service?: Maybe<Scalars['String']>;
  from?: Maybe<Scalars['String']>;
  from_name?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  is_sent?: Maybe<Scalars['Boolean']>;
  sent_at?: Maybe<Scalars['timestamptz']>;
  template_metadata?: Maybe<Scalars['jsonb']>;
  template_name?: Maybe<Scalars['String']>;
  to?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Email_Log_Max_Fields = {
  __typename?: 'email_log_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by_service?: Maybe<Scalars['String']>;
  from?: Maybe<Scalars['String']>;
  from_name?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  sent_at?: Maybe<Scalars['timestamptz']>;
  template_name?: Maybe<Scalars['String']>;
  to?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Email_Log_Min_Fields = {
  __typename?: 'email_log_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by_service?: Maybe<Scalars['String']>;
  from?: Maybe<Scalars['String']>;
  from_name?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  sent_at?: Maybe<Scalars['timestamptz']>;
  template_name?: Maybe<Scalars['String']>;
  to?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "email_log" */
export type Email_Log_Mutation_Response = {
  __typename?: 'email_log_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Email_Log>;
};

/** on_conflict condition type for table "email_log" */
export type Email_Log_On_Conflict = {
  constraint: Email_Log_Constraint;
  update_columns?: Array<Email_Log_Update_Column>;
  where?: Maybe<Email_Log_Bool_Exp>;
};

/** Ordering options when selecting data from "email_log". */
export type Email_Log_Order_By = {
  created_at?: Maybe<Order_By>;
  created_by_service?: Maybe<Order_By>;
  from?: Maybe<Order_By>;
  from_name?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  is_sent?: Maybe<Order_By>;
  sent_at?: Maybe<Order_By>;
  template_metadata?: Maybe<Order_By>;
  template_name?: Maybe<Order_By>;
  to?: Maybe<Order_By>;
};

/** primary key columns input for table: email_log */
export type Email_Log_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Email_Log_Prepend_Input = {
  template_metadata?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "email_log" */
export enum Email_Log_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedByService = 'created_by_service',
  /** column name */
  From = 'from',
  /** column name */
  FromName = 'from_name',
  /** column name */
  Id = 'id',
  /** column name */
  IsSent = 'is_sent',
  /** column name */
  SentAt = 'sent_at',
  /** column name */
  TemplateMetadata = 'template_metadata',
  /** column name */
  TemplateName = 'template_name',
  /** column name */
  To = 'to',
}

/** input type for updating data in table "email_log" */
export type Email_Log_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by_service?: Maybe<Scalars['String']>;
  from?: Maybe<Scalars['String']>;
  from_name?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  is_sent?: Maybe<Scalars['Boolean']>;
  sent_at?: Maybe<Scalars['timestamptz']>;
  template_metadata?: Maybe<Scalars['jsonb']>;
  template_name?: Maybe<Scalars['String']>;
  to?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "email_log" */
export type Email_Log_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Email_Log_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Email_Log_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  created_by_service?: Maybe<Scalars['String']>;
  from?: Maybe<Scalars['String']>;
  from_name?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  is_sent?: Maybe<Scalars['Boolean']>;
  sent_at?: Maybe<Scalars['timestamptz']>;
  template_metadata?: Maybe<Scalars['jsonb']>;
  template_name?: Maybe<Scalars['String']>;
  to?: Maybe<Scalars['String']>;
};

/** update columns of table "email_log" */
export enum Email_Log_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedByService = 'created_by_service',
  /** column name */
  From = 'from',
  /** column name */
  FromName = 'from_name',
  /** column name */
  Id = 'id',
  /** column name */
  IsSent = 'is_sent',
  /** column name */
  SentAt = 'sent_at',
  /** column name */
  TemplateMetadata = 'template_metadata',
  /** column name */
  TemplateName = 'template_name',
  /** column name */
  To = 'to',
}

export type Email_Log_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Email_Log_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Email_Log_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Email_Log_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Email_Log_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Email_Log_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Email_Log_Set_Input>;
  /** filter the rows which have to be updated */
  where: Email_Log_Bool_Exp;
};

export type EnableCloudflareProxyResponse = {
  __typename?: 'EnableCloudflareProxyResponse';
  tenant_id: Scalars['uuid'];
};

/** list of users on Hasura enterprise edition */
export type Enterprise_Users = {
  __typename?: 'enterprise_users';
  created_at: Scalars['timestamptz'];
  customer_email: Scalars['citext'];
  id: Scalars['Int'];
  is_active: Scalars['Boolean'];
  is_exempt_from_billing: Scalars['Boolean'];
  updated_at: Scalars['timestamptz'];
  user_id?: Maybe<Scalars['uuid']>;
  /** An object relationship */
  users?: Maybe<Users>;
};

/** aggregated selection of "enterprise_users" */
export type Enterprise_Users_Aggregate = {
  __typename?: 'enterprise_users_aggregate';
  aggregate?: Maybe<Enterprise_Users_Aggregate_Fields>;
  nodes: Array<Enterprise_Users>;
};

/** aggregate fields of "enterprise_users" */
export type Enterprise_Users_Aggregate_Fields = {
  __typename?: 'enterprise_users_aggregate_fields';
  avg?: Maybe<Enterprise_Users_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Enterprise_Users_Max_Fields>;
  min?: Maybe<Enterprise_Users_Min_Fields>;
  stddev?: Maybe<Enterprise_Users_Stddev_Fields>;
  stddev_pop?: Maybe<Enterprise_Users_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Enterprise_Users_Stddev_Samp_Fields>;
  sum?: Maybe<Enterprise_Users_Sum_Fields>;
  var_pop?: Maybe<Enterprise_Users_Var_Pop_Fields>;
  var_samp?: Maybe<Enterprise_Users_Var_Samp_Fields>;
  variance?: Maybe<Enterprise_Users_Variance_Fields>;
};

/** aggregate fields of "enterprise_users" */
export type Enterprise_Users_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Enterprise_Users_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Enterprise_Users_Avg_Fields = {
  __typename?: 'enterprise_users_avg_fields';
  id?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "enterprise_users". All fields are combined with a logical 'AND'. */
export type Enterprise_Users_Bool_Exp = {
  _and?: Maybe<Array<Enterprise_Users_Bool_Exp>>;
  _not?: Maybe<Enterprise_Users_Bool_Exp>;
  _or?: Maybe<Array<Enterprise_Users_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  customer_email?: Maybe<Citext_Comparison_Exp>;
  id?: Maybe<Int_Comparison_Exp>;
  is_active?: Maybe<Boolean_Comparison_Exp>;
  is_exempt_from_billing?: Maybe<Boolean_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  user_id?: Maybe<Uuid_Comparison_Exp>;
  users?: Maybe<Users_Bool_Exp>;
};

/** unique or primary key constraints on table "enterprise_users" */
export enum Enterprise_Users_Constraint {
  /** unique or primary key constraint on columns "customer_email" */
  EnterpriseUsersCustomerEmailKey = 'enterprise_users_customer_email_key',
  /** unique or primary key constraint on columns "customer_email" */
  EnterpriseUsersPkey = 'enterprise_users_pkey',
}

/** input type for incrementing numeric columns in table "enterprise_users" */
export type Enterprise_Users_Inc_Input = {
  id?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "enterprise_users" */
export type Enterprise_Users_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_email?: Maybe<Scalars['citext']>;
  id?: Maybe<Scalars['Int']>;
  is_active?: Maybe<Scalars['Boolean']>;
  is_exempt_from_billing?: Maybe<Scalars['Boolean']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
  users?: Maybe<Users_Obj_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Enterprise_Users_Max_Fields = {
  __typename?: 'enterprise_users_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_email?: Maybe<Scalars['citext']>;
  id?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate min on columns */
export type Enterprise_Users_Min_Fields = {
  __typename?: 'enterprise_users_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_email?: Maybe<Scalars['citext']>;
  id?: Maybe<Scalars['Int']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** response of any mutation on the table "enterprise_users" */
export type Enterprise_Users_Mutation_Response = {
  __typename?: 'enterprise_users_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Enterprise_Users>;
};

/** input type for inserting object relation for remote table "enterprise_users" */
export type Enterprise_Users_Obj_Rel_Insert_Input = {
  data: Enterprise_Users_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Enterprise_Users_On_Conflict>;
};

/** on_conflict condition type for table "enterprise_users" */
export type Enterprise_Users_On_Conflict = {
  constraint: Enterprise_Users_Constraint;
  update_columns?: Array<Enterprise_Users_Update_Column>;
  where?: Maybe<Enterprise_Users_Bool_Exp>;
};

/** Ordering options when selecting data from "enterprise_users". */
export type Enterprise_Users_Order_By = {
  created_at?: Maybe<Order_By>;
  customer_email?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  is_active?: Maybe<Order_By>;
  is_exempt_from_billing?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
  users?: Maybe<Users_Order_By>;
};

/** primary key columns input for table: enterprise_users */
export type Enterprise_Users_Pk_Columns_Input = {
  customer_email: Scalars['citext'];
};

/** select columns of table "enterprise_users" */
export enum Enterprise_Users_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomerEmail = 'customer_email',
  /** column name */
  Id = 'id',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  IsExemptFromBilling = 'is_exempt_from_billing',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
}

/** input type for updating data in table "enterprise_users" */
export type Enterprise_Users_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_email?: Maybe<Scalars['citext']>;
  id?: Maybe<Scalars['Int']>;
  is_active?: Maybe<Scalars['Boolean']>;
  is_exempt_from_billing?: Maybe<Scalars['Boolean']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate stddev on columns */
export type Enterprise_Users_Stddev_Fields = {
  __typename?: 'enterprise_users_stddev_fields';
  id?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Enterprise_Users_Stddev_Pop_Fields = {
  __typename?: 'enterprise_users_stddev_pop_fields';
  id?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Enterprise_Users_Stddev_Samp_Fields = {
  __typename?: 'enterprise_users_stddev_samp_fields';
  id?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "enterprise_users" */
export type Enterprise_Users_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Enterprise_Users_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Enterprise_Users_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  customer_email?: Maybe<Scalars['citext']>;
  id?: Maybe<Scalars['Int']>;
  is_active?: Maybe<Scalars['Boolean']>;
  is_exempt_from_billing?: Maybe<Scalars['Boolean']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate sum on columns */
export type Enterprise_Users_Sum_Fields = {
  __typename?: 'enterprise_users_sum_fields';
  id?: Maybe<Scalars['Int']>;
};

/** update columns of table "enterprise_users" */
export enum Enterprise_Users_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomerEmail = 'customer_email',
  /** column name */
  Id = 'id',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  IsExemptFromBilling = 'is_exempt_from_billing',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
}

export type Enterprise_Users_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Enterprise_Users_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Enterprise_Users_Set_Input>;
  /** filter the rows which have to be updated */
  where: Enterprise_Users_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Enterprise_Users_Var_Pop_Fields = {
  __typename?: 'enterprise_users_var_pop_fields';
  id?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Enterprise_Users_Var_Samp_Fields = {
  __typename?: 'enterprise_users_var_samp_fields';
  id?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Enterprise_Users_Variance_Fields = {
  __typename?: 'enterprise_users_variance_fields';
  id?: Maybe<Scalars['Float']>;
};

/** This enum represents the growth experiments for Hasura. */
export type Experiments = {
  __typename?: 'experiments';
  comment: Scalars['String'];
  experiment: Scalars['String'];
};

/** aggregated selection of "experiments" */
export type Experiments_Aggregate = {
  __typename?: 'experiments_aggregate';
  aggregate?: Maybe<Experiments_Aggregate_Fields>;
  nodes: Array<Experiments>;
};

/** aggregate fields of "experiments" */
export type Experiments_Aggregate_Fields = {
  __typename?: 'experiments_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Experiments_Max_Fields>;
  min?: Maybe<Experiments_Min_Fields>;
};

/** aggregate fields of "experiments" */
export type Experiments_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Experiments_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "experiments". All fields are combined with a logical 'AND'. */
export type Experiments_Bool_Exp = {
  _and?: Maybe<Array<Experiments_Bool_Exp>>;
  _not?: Maybe<Experiments_Bool_Exp>;
  _or?: Maybe<Array<Experiments_Bool_Exp>>;
  comment?: Maybe<String_Comparison_Exp>;
  experiment?: Maybe<String_Comparison_Exp>;
};

/** Cohort of users for the specific experiment. */
export type Experiments_Cohort = {
  __typename?: 'experiments_cohort';
  activity?: Maybe<Scalars['jsonb']>;
  created_at: Scalars['timestamptz'];
  experiment: Experiments_Enum;
  /** An object relationship */
  parent_experiment: Experiments;
  updated_at: Scalars['timestamptz'];
  /** An object relationship */
  user: Users;
  user_id: Scalars['uuid'];
};

/** Cohort of users for the specific experiment. */
export type Experiments_CohortActivityArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "experiments_cohort" */
export type Experiments_Cohort_Aggregate = {
  __typename?: 'experiments_cohort_aggregate';
  aggregate?: Maybe<Experiments_Cohort_Aggregate_Fields>;
  nodes: Array<Experiments_Cohort>;
};

export type Experiments_Cohort_Aggregate_Bool_Exp = {
  count?: Maybe<Experiments_Cohort_Aggregate_Bool_Exp_Count>;
};

export type Experiments_Cohort_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Experiments_Cohort_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Experiments_Cohort_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "experiments_cohort" */
export type Experiments_Cohort_Aggregate_Fields = {
  __typename?: 'experiments_cohort_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Experiments_Cohort_Max_Fields>;
  min?: Maybe<Experiments_Cohort_Min_Fields>;
};

/** aggregate fields of "experiments_cohort" */
export type Experiments_Cohort_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Experiments_Cohort_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "experiments_cohort" */
export type Experiments_Cohort_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Experiments_Cohort_Max_Order_By>;
  min?: Maybe<Experiments_Cohort_Min_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Experiments_Cohort_Append_Input = {
  activity?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "experiments_cohort" */
export type Experiments_Cohort_Arr_Rel_Insert_Input = {
  data: Array<Experiments_Cohort_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Experiments_Cohort_On_Conflict>;
};

/** Boolean expression to filter rows from the table "experiments_cohort". All fields are combined with a logical 'AND'. */
export type Experiments_Cohort_Bool_Exp = {
  _and?: Maybe<Array<Experiments_Cohort_Bool_Exp>>;
  _not?: Maybe<Experiments_Cohort_Bool_Exp>;
  _or?: Maybe<Array<Experiments_Cohort_Bool_Exp>>;
  activity?: Maybe<Jsonb_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  experiment?: Maybe<Experiments_Enum_Comparison_Exp>;
  parent_experiment?: Maybe<Experiments_Bool_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  user?: Maybe<Users_Bool_Exp>;
  user_id?: Maybe<Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "experiments_cohort" */
export enum Experiments_Cohort_Constraint {
  /** unique or primary key constraint on columns "user_id", "experiment" */
  ExperimentsCohortPkey = 'experiments_cohort_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Experiments_Cohort_Delete_At_Path_Input = {
  activity?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Experiments_Cohort_Delete_Elem_Input = {
  activity?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Experiments_Cohort_Delete_Key_Input = {
  activity?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "experiments_cohort" */
export type Experiments_Cohort_Insert_Input = {
  activity?: Maybe<Scalars['jsonb']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  experiment?: Maybe<Experiments_Enum>;
  parent_experiment?: Maybe<Experiments_Obj_Rel_Insert_Input>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Experiments_Cohort_Max_Fields = {
  __typename?: 'experiments_cohort_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** order by max() on columns of table "experiments_cohort" */
export type Experiments_Cohort_Max_Order_By = {
  created_at?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Experiments_Cohort_Min_Fields = {
  __typename?: 'experiments_cohort_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** order by min() on columns of table "experiments_cohort" */
export type Experiments_Cohort_Min_Order_By = {
  created_at?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "experiments_cohort" */
export type Experiments_Cohort_Mutation_Response = {
  __typename?: 'experiments_cohort_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Experiments_Cohort>;
};

/** on_conflict condition type for table "experiments_cohort" */
export type Experiments_Cohort_On_Conflict = {
  constraint: Experiments_Cohort_Constraint;
  update_columns?: Array<Experiments_Cohort_Update_Column>;
  where?: Maybe<Experiments_Cohort_Bool_Exp>;
};

/** Ordering options when selecting data from "experiments_cohort". */
export type Experiments_Cohort_Order_By = {
  activity?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  experiment?: Maybe<Order_By>;
  parent_experiment?: Maybe<Experiments_Order_By>;
  updated_at?: Maybe<Order_By>;
  user?: Maybe<Users_Order_By>;
  user_id?: Maybe<Order_By>;
};

/** primary key columns input for table: experiments_cohort */
export type Experiments_Cohort_Pk_Columns_Input = {
  experiment: Experiments_Enum;
  user_id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Experiments_Cohort_Prepend_Input = {
  activity?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "experiments_cohort" */
export enum Experiments_Cohort_Select_Column {
  /** column name */
  Activity = 'activity',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Experiment = 'experiment',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
}

/** input type for updating data in table "experiments_cohort" */
export type Experiments_Cohort_Set_Input = {
  activity?: Maybe<Scalars['jsonb']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  experiment?: Maybe<Experiments_Enum>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** Streaming cursor of the table "experiments_cohort" */
export type Experiments_Cohort_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Experiments_Cohort_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Experiments_Cohort_Stream_Cursor_Value_Input = {
  activity?: Maybe<Scalars['jsonb']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  experiment?: Maybe<Experiments_Enum>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** update columns of table "experiments_cohort" */
export enum Experiments_Cohort_Update_Column {
  /** column name */
  Activity = 'activity',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Experiment = 'experiment',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
}

export type Experiments_Cohort_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Experiments_Cohort_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Experiments_Cohort_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Experiments_Cohort_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Experiments_Cohort_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Experiments_Cohort_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Experiments_Cohort_Set_Input>;
  /** filter the rows which have to be updated */
  where: Experiments_Cohort_Bool_Exp;
};

/** Configuration settings for growth experiments. */
export type Experiments_Config = {
  __typename?: 'experiments_config';
  /** An array relationship */
  config_cohort_users: Array<Experiments_Cohort>;
  /** An aggregate relationship */
  config_cohort_users_aggregate: Experiments_Cohort_Aggregate;
  created_at: Scalars['timestamptz'];
  experiment: Experiments_Enum;
  metadata?: Maybe<Scalars['jsonb']>;
  /** An object relationship */
  parent_experiment: Experiments;
  rollout_percentage: Scalars['Int'];
  status: Scalars['String'];
  updated_at: Scalars['timestamptz'];
};

/** Configuration settings for growth experiments. */
export type Experiments_ConfigConfig_Cohort_UsersArgs = {
  distinct_on?: Maybe<Array<Experiments_Cohort_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Experiments_Cohort_Order_By>>;
  where?: Maybe<Experiments_Cohort_Bool_Exp>;
};

/** Configuration settings for growth experiments. */
export type Experiments_ConfigConfig_Cohort_Users_AggregateArgs = {
  distinct_on?: Maybe<Array<Experiments_Cohort_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Experiments_Cohort_Order_By>>;
  where?: Maybe<Experiments_Cohort_Bool_Exp>;
};

/** Configuration settings for growth experiments. */
export type Experiments_ConfigMetadataArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "experiments_config" */
export type Experiments_Config_Aggregate = {
  __typename?: 'experiments_config_aggregate';
  aggregate?: Maybe<Experiments_Config_Aggregate_Fields>;
  nodes: Array<Experiments_Config>;
};

/** aggregate fields of "experiments_config" */
export type Experiments_Config_Aggregate_Fields = {
  __typename?: 'experiments_config_aggregate_fields';
  avg?: Maybe<Experiments_Config_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Experiments_Config_Max_Fields>;
  min?: Maybe<Experiments_Config_Min_Fields>;
  stddev?: Maybe<Experiments_Config_Stddev_Fields>;
  stddev_pop?: Maybe<Experiments_Config_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Experiments_Config_Stddev_Samp_Fields>;
  sum?: Maybe<Experiments_Config_Sum_Fields>;
  var_pop?: Maybe<Experiments_Config_Var_Pop_Fields>;
  var_samp?: Maybe<Experiments_Config_Var_Samp_Fields>;
  variance?: Maybe<Experiments_Config_Variance_Fields>;
};

/** aggregate fields of "experiments_config" */
export type Experiments_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Experiments_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Experiments_Config_Append_Input = {
  metadata?: Maybe<Scalars['jsonb']>;
};

/** aggregate avg on columns */
export type Experiments_Config_Avg_Fields = {
  __typename?: 'experiments_config_avg_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "experiments_config". All fields are combined with a logical 'AND'. */
export type Experiments_Config_Bool_Exp = {
  _and?: Maybe<Array<Experiments_Config_Bool_Exp>>;
  _not?: Maybe<Experiments_Config_Bool_Exp>;
  _or?: Maybe<Array<Experiments_Config_Bool_Exp>>;
  config_cohort_users?: Maybe<Experiments_Cohort_Bool_Exp>;
  config_cohort_users_aggregate?: Maybe<Experiments_Cohort_Aggregate_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  experiment?: Maybe<Experiments_Enum_Comparison_Exp>;
  metadata?: Maybe<Jsonb_Comparison_Exp>;
  parent_experiment?: Maybe<Experiments_Bool_Exp>;
  rollout_percentage?: Maybe<Int_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "experiments_config" */
export enum Experiments_Config_Constraint {
  /** unique or primary key constraint on columns "experiment" */
  ExperimentsConfigPkey = 'experiments_config_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Experiments_Config_Delete_At_Path_Input = {
  metadata?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Experiments_Config_Delete_Elem_Input = {
  metadata?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Experiments_Config_Delete_Key_Input = {
  metadata?: Maybe<Scalars['String']>;
};

/** input type for incrementing numeric columns in table "experiments_config" */
export type Experiments_Config_Inc_Input = {
  rollout_percentage?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "experiments_config" */
export type Experiments_Config_Insert_Input = {
  config_cohort_users?: Maybe<Experiments_Cohort_Arr_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  experiment?: Maybe<Experiments_Enum>;
  metadata?: Maybe<Scalars['jsonb']>;
  parent_experiment?: Maybe<Experiments_Obj_Rel_Insert_Input>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Experiments_Config_Max_Fields = {
  __typename?: 'experiments_config_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Experiments_Config_Min_Fields = {
  __typename?: 'experiments_config_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "experiments_config" */
export type Experiments_Config_Mutation_Response = {
  __typename?: 'experiments_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Experiments_Config>;
};

/** on_conflict condition type for table "experiments_config" */
export type Experiments_Config_On_Conflict = {
  constraint: Experiments_Config_Constraint;
  update_columns?: Array<Experiments_Config_Update_Column>;
  where?: Maybe<Experiments_Config_Bool_Exp>;
};

/** Ordering options when selecting data from "experiments_config". */
export type Experiments_Config_Order_By = {
  config_cohort_users_aggregate?: Maybe<Experiments_Cohort_Aggregate_Order_By>;
  created_at?: Maybe<Order_By>;
  experiment?: Maybe<Order_By>;
  metadata?: Maybe<Order_By>;
  parent_experiment?: Maybe<Experiments_Order_By>;
  rollout_percentage?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: experiments_config */
export type Experiments_Config_Pk_Columns_Input = {
  experiment: Experiments_Enum;
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Experiments_Config_Prepend_Input = {
  metadata?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "experiments_config" */
export enum Experiments_Config_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Experiment = 'experiment',
  /** column name */
  Metadata = 'metadata',
  /** column name */
  RolloutPercentage = 'rollout_percentage',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "experiments_config" */
export type Experiments_Config_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  experiment?: Maybe<Experiments_Enum>;
  metadata?: Maybe<Scalars['jsonb']>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate stddev on columns */
export type Experiments_Config_Stddev_Fields = {
  __typename?: 'experiments_config_stddev_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Experiments_Config_Stddev_Pop_Fields = {
  __typename?: 'experiments_config_stddev_pop_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Experiments_Config_Stddev_Samp_Fields = {
  __typename?: 'experiments_config_stddev_samp_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "experiments_config" */
export type Experiments_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Experiments_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Experiments_Config_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  experiment?: Maybe<Experiments_Enum>;
  metadata?: Maybe<Scalars['jsonb']>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate sum on columns */
export type Experiments_Config_Sum_Fields = {
  __typename?: 'experiments_config_sum_fields';
  rollout_percentage?: Maybe<Scalars['Int']>;
};

/** update columns of table "experiments_config" */
export enum Experiments_Config_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Experiment = 'experiment',
  /** column name */
  Metadata = 'metadata',
  /** column name */
  RolloutPercentage = 'rollout_percentage',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Experiments_Config_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Experiments_Config_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Experiments_Config_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Experiments_Config_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Experiments_Config_Delete_Key_Input>;
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Experiments_Config_Inc_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Experiments_Config_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Experiments_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Experiments_Config_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Experiments_Config_Var_Pop_Fields = {
  __typename?: 'experiments_config_var_pop_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Experiments_Config_Var_Samp_Fields = {
  __typename?: 'experiments_config_var_samp_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Experiments_Config_Variance_Fields = {
  __typename?: 'experiments_config_variance_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** unique or primary key constraints on table "experiments" */
export enum Experiments_Constraint {
  /** unique or primary key constraint on columns "experiment" */
  ExperimentsPkey = 'experiments_pkey',
}

export enum Experiments_Enum {
  /** Console Onboarding Wizard v1 for new users */
  ConsoleOnboardingWizardV1 = 'console_onboarding_wizard_v1',
}

/** Boolean expression to compare columns of type "experiments_enum". All fields are combined with logical 'AND'. */
export type Experiments_Enum_Comparison_Exp = {
  _eq?: Maybe<Experiments_Enum>;
  _in?: Maybe<Array<Experiments_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Experiments_Enum>;
  _nin?: Maybe<Array<Experiments_Enum>>;
};

/** input type for inserting data into table "experiments" */
export type Experiments_Insert_Input = {
  comment?: Maybe<Scalars['String']>;
  experiment?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Experiments_Max_Fields = {
  __typename?: 'experiments_max_fields';
  comment?: Maybe<Scalars['String']>;
  experiment?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Experiments_Min_Fields = {
  __typename?: 'experiments_min_fields';
  comment?: Maybe<Scalars['String']>;
  experiment?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "experiments" */
export type Experiments_Mutation_Response = {
  __typename?: 'experiments_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Experiments>;
};

/** input type for inserting object relation for remote table "experiments" */
export type Experiments_Obj_Rel_Insert_Input = {
  data: Experiments_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Experiments_On_Conflict>;
};

/** on_conflict condition type for table "experiments" */
export type Experiments_On_Conflict = {
  constraint: Experiments_Constraint;
  update_columns?: Array<Experiments_Update_Column>;
  where?: Maybe<Experiments_Bool_Exp>;
};

/** Ordering options when selecting data from "experiments". */
export type Experiments_Order_By = {
  comment?: Maybe<Order_By>;
  experiment?: Maybe<Order_By>;
};

/** primary key columns input for table: experiments */
export type Experiments_Pk_Columns_Input = {
  experiment: Scalars['String'];
};

/** select columns of table "experiments" */
export enum Experiments_Select_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Experiment = 'experiment',
}

/** input type for updating data in table "experiments" */
export type Experiments_Set_Input = {
  comment?: Maybe<Scalars['String']>;
  experiment?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "experiments" */
export type Experiments_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Experiments_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Experiments_Stream_Cursor_Value_Input = {
  comment?: Maybe<Scalars['String']>;
  experiment?: Maybe<Scalars['String']>;
};

/** update columns of table "experiments" */
export enum Experiments_Update_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Experiment = 'experiment',
}

export type Experiments_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Experiments_Set_Input>;
  /** filter the rows which have to be updated */
  where: Experiments_Bool_Exp;
};

export type ExperimentsCohortActivityPayload = {
  error_code?: Maybe<Scalars['String']>;
  kind: Scalars['String'];
  project_id: Scalars['uuid'];
};

/** Enums representing features for access control */
export type Feature = {
  __typename?: 'feature';
  description: Scalars['String'];
  name: Scalars['String'];
};

/** Table defining what features a user has access to */
export type Feature_Access = {
  __typename?: 'feature_access';
  email: Scalars['String'];
  feature: Feature_Enum;
  granted_at: Scalars['timestamptz'];
  /** An object relationship */
  user: Users;
};

/** aggregated selection of "feature_access" */
export type Feature_Access_Aggregate = {
  __typename?: 'feature_access_aggregate';
  aggregate?: Maybe<Feature_Access_Aggregate_Fields>;
  nodes: Array<Feature_Access>;
};

export type Feature_Access_Aggregate_Bool_Exp = {
  count?: Maybe<Feature_Access_Aggregate_Bool_Exp_Count>;
};

export type Feature_Access_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Feature_Access_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Feature_Access_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "feature_access" */
export type Feature_Access_Aggregate_Fields = {
  __typename?: 'feature_access_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Feature_Access_Max_Fields>;
  min?: Maybe<Feature_Access_Min_Fields>;
};

/** aggregate fields of "feature_access" */
export type Feature_Access_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Feature_Access_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "feature_access" */
export type Feature_Access_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Feature_Access_Max_Order_By>;
  min?: Maybe<Feature_Access_Min_Order_By>;
};

/** input type for inserting array relation for remote table "feature_access" */
export type Feature_Access_Arr_Rel_Insert_Input = {
  data: Array<Feature_Access_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Feature_Access_On_Conflict>;
};

/** Boolean expression to filter rows from the table "feature_access". All fields are combined with a logical 'AND'. */
export type Feature_Access_Bool_Exp = {
  _and?: Maybe<Array<Feature_Access_Bool_Exp>>;
  _not?: Maybe<Feature_Access_Bool_Exp>;
  _or?: Maybe<Array<Feature_Access_Bool_Exp>>;
  email?: Maybe<String_Comparison_Exp>;
  feature?: Maybe<Feature_Enum_Comparison_Exp>;
  granted_at?: Maybe<Timestamptz_Comparison_Exp>;
  user?: Maybe<Users_Bool_Exp>;
};

/** unique or primary key constraints on table "feature_access" */
export enum Feature_Access_Constraint {
  /** unique or primary key constraint on columns "email", "feature" */
  FeatureAccessPkey = 'feature_access_pkey',
}

/** input type for inserting data into table "feature_access" */
export type Feature_Access_Insert_Input = {
  email?: Maybe<Scalars['String']>;
  feature?: Maybe<Feature_Enum>;
  granted_at?: Maybe<Scalars['timestamptz']>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Feature_Access_Max_Fields = {
  __typename?: 'feature_access_max_fields';
  email?: Maybe<Scalars['String']>;
  granted_at?: Maybe<Scalars['timestamptz']>;
};

/** order by max() on columns of table "feature_access" */
export type Feature_Access_Max_Order_By = {
  email?: Maybe<Order_By>;
  granted_at?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Feature_Access_Min_Fields = {
  __typename?: 'feature_access_min_fields';
  email?: Maybe<Scalars['String']>;
  granted_at?: Maybe<Scalars['timestamptz']>;
};

/** order by min() on columns of table "feature_access" */
export type Feature_Access_Min_Order_By = {
  email?: Maybe<Order_By>;
  granted_at?: Maybe<Order_By>;
};

/** response of any mutation on the table "feature_access" */
export type Feature_Access_Mutation_Response = {
  __typename?: 'feature_access_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Feature_Access>;
};

/** on_conflict condition type for table "feature_access" */
export type Feature_Access_On_Conflict = {
  constraint: Feature_Access_Constraint;
  update_columns?: Array<Feature_Access_Update_Column>;
  where?: Maybe<Feature_Access_Bool_Exp>;
};

/** Ordering options when selecting data from "feature_access". */
export type Feature_Access_Order_By = {
  email?: Maybe<Order_By>;
  feature?: Maybe<Order_By>;
  granted_at?: Maybe<Order_By>;
  user?: Maybe<Users_Order_By>;
};

/** primary key columns input for table: feature_access */
export type Feature_Access_Pk_Columns_Input = {
  email: Scalars['String'];
  feature: Feature_Enum;
};

/** select columns of table "feature_access" */
export enum Feature_Access_Select_Column {
  /** column name */
  Email = 'email',
  /** column name */
  Feature = 'feature',
  /** column name */
  GrantedAt = 'granted_at',
}

/** input type for updating data in table "feature_access" */
export type Feature_Access_Set_Input = {
  email?: Maybe<Scalars['String']>;
  feature?: Maybe<Feature_Enum>;
  granted_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "feature_access" */
export type Feature_Access_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Feature_Access_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Feature_Access_Stream_Cursor_Value_Input = {
  email?: Maybe<Scalars['String']>;
  feature?: Maybe<Feature_Enum>;
  granted_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "feature_access" */
export enum Feature_Access_Update_Column {
  /** column name */
  Email = 'email',
  /** column name */
  Feature = 'feature',
  /** column name */
  GrantedAt = 'granted_at',
}

export type Feature_Access_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Feature_Access_Set_Input>;
  /** filter the rows which have to be updated */
  where: Feature_Access_Bool_Exp;
};

/** aggregated selection of "feature" */
export type Feature_Aggregate = {
  __typename?: 'feature_aggregate';
  aggregate?: Maybe<Feature_Aggregate_Fields>;
  nodes: Array<Feature>;
};

/** aggregate fields of "feature" */
export type Feature_Aggregate_Fields = {
  __typename?: 'feature_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Feature_Max_Fields>;
  min?: Maybe<Feature_Min_Fields>;
};

/** aggregate fields of "feature" */
export type Feature_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Feature_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "feature". All fields are combined with a logical 'AND'. */
export type Feature_Bool_Exp = {
  _and?: Maybe<Array<Feature_Bool_Exp>>;
  _not?: Maybe<Feature_Bool_Exp>;
  _or?: Maybe<Array<Feature_Bool_Exp>>;
  description?: Maybe<String_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
};

/** Configuration settings for feature */
export type Feature_Config = {
  __typename?: 'feature_config';
  created_at: Scalars['timestamptz'];
  feature: Feature_Enum;
  metadata?: Maybe<Scalars['jsonb']>;
  /** An object relationship */
  parent_feature: Feature;
  rollout_percentage: Scalars['Int'];
  status: Scalars['String'];
  updated_at: Scalars['timestamptz'];
};

/** Configuration settings for feature */
export type Feature_ConfigMetadataArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "feature_config" */
export type Feature_Config_Aggregate = {
  __typename?: 'feature_config_aggregate';
  aggregate?: Maybe<Feature_Config_Aggregate_Fields>;
  nodes: Array<Feature_Config>;
};

/** aggregate fields of "feature_config" */
export type Feature_Config_Aggregate_Fields = {
  __typename?: 'feature_config_aggregate_fields';
  avg?: Maybe<Feature_Config_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Feature_Config_Max_Fields>;
  min?: Maybe<Feature_Config_Min_Fields>;
  stddev?: Maybe<Feature_Config_Stddev_Fields>;
  stddev_pop?: Maybe<Feature_Config_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Feature_Config_Stddev_Samp_Fields>;
  sum?: Maybe<Feature_Config_Sum_Fields>;
  var_pop?: Maybe<Feature_Config_Var_Pop_Fields>;
  var_samp?: Maybe<Feature_Config_Var_Samp_Fields>;
  variance?: Maybe<Feature_Config_Variance_Fields>;
};

/** aggregate fields of "feature_config" */
export type Feature_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Feature_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Feature_Config_Append_Input = {
  metadata?: Maybe<Scalars['jsonb']>;
};

/** aggregate avg on columns */
export type Feature_Config_Avg_Fields = {
  __typename?: 'feature_config_avg_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "feature_config". All fields are combined with a logical 'AND'. */
export type Feature_Config_Bool_Exp = {
  _and?: Maybe<Array<Feature_Config_Bool_Exp>>;
  _not?: Maybe<Feature_Config_Bool_Exp>;
  _or?: Maybe<Array<Feature_Config_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  feature?: Maybe<Feature_Enum_Comparison_Exp>;
  metadata?: Maybe<Jsonb_Comparison_Exp>;
  parent_feature?: Maybe<Feature_Bool_Exp>;
  rollout_percentage?: Maybe<Int_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "feature_config" */
export enum Feature_Config_Constraint {
  /** unique or primary key constraint on columns "feature" */
  FeatureConfigPkey = 'feature_config_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Feature_Config_Delete_At_Path_Input = {
  metadata?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Feature_Config_Delete_Elem_Input = {
  metadata?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Feature_Config_Delete_Key_Input = {
  metadata?: Maybe<Scalars['String']>;
};

/** input type for incrementing numeric columns in table "feature_config" */
export type Feature_Config_Inc_Input = {
  rollout_percentage?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "feature_config" */
export type Feature_Config_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  feature?: Maybe<Feature_Enum>;
  metadata?: Maybe<Scalars['jsonb']>;
  parent_feature?: Maybe<Feature_Obj_Rel_Insert_Input>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Feature_Config_Max_Fields = {
  __typename?: 'feature_config_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Feature_Config_Min_Fields = {
  __typename?: 'feature_config_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "feature_config" */
export type Feature_Config_Mutation_Response = {
  __typename?: 'feature_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Feature_Config>;
};

/** on_conflict condition type for table "feature_config" */
export type Feature_Config_On_Conflict = {
  constraint: Feature_Config_Constraint;
  update_columns?: Array<Feature_Config_Update_Column>;
  where?: Maybe<Feature_Config_Bool_Exp>;
};

/** Ordering options when selecting data from "feature_config". */
export type Feature_Config_Order_By = {
  created_at?: Maybe<Order_By>;
  feature?: Maybe<Order_By>;
  metadata?: Maybe<Order_By>;
  parent_feature?: Maybe<Feature_Order_By>;
  rollout_percentage?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: feature_config */
export type Feature_Config_Pk_Columns_Input = {
  feature: Feature_Enum;
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Feature_Config_Prepend_Input = {
  metadata?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "feature_config" */
export enum Feature_Config_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Feature = 'feature',
  /** column name */
  Metadata = 'metadata',
  /** column name */
  RolloutPercentage = 'rollout_percentage',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "feature_config" */
export type Feature_Config_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  feature?: Maybe<Feature_Enum>;
  metadata?: Maybe<Scalars['jsonb']>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate stddev on columns */
export type Feature_Config_Stddev_Fields = {
  __typename?: 'feature_config_stddev_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Feature_Config_Stddev_Pop_Fields = {
  __typename?: 'feature_config_stddev_pop_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Feature_Config_Stddev_Samp_Fields = {
  __typename?: 'feature_config_stddev_samp_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "feature_config" */
export type Feature_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Feature_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Feature_Config_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  feature?: Maybe<Feature_Enum>;
  metadata?: Maybe<Scalars['jsonb']>;
  rollout_percentage?: Maybe<Scalars['Int']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate sum on columns */
export type Feature_Config_Sum_Fields = {
  __typename?: 'feature_config_sum_fields';
  rollout_percentage?: Maybe<Scalars['Int']>;
};

/** update columns of table "feature_config" */
export enum Feature_Config_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Feature = 'feature',
  /** column name */
  Metadata = 'metadata',
  /** column name */
  RolloutPercentage = 'rollout_percentage',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Feature_Config_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Feature_Config_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Feature_Config_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Feature_Config_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Feature_Config_Delete_Key_Input>;
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Feature_Config_Inc_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Feature_Config_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Feature_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Feature_Config_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Feature_Config_Var_Pop_Fields = {
  __typename?: 'feature_config_var_pop_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Feature_Config_Var_Samp_Fields = {
  __typename?: 'feature_config_var_samp_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Feature_Config_Variance_Fields = {
  __typename?: 'feature_config_variance_fields';
  rollout_percentage?: Maybe<Scalars['Float']>;
};

/** unique or primary key constraints on table "feature" */
export enum Feature_Constraint {
  /** unique or primary key constraint on columns "name" */
  FeaturePkey = 'feature_pkey',
}

export enum Feature_Enum {
  /** Collect additional billing information to enable tax calculation */
  Avalara = 'Avalara',
  /** Allows user to create Cloud Dedicated VPC */
  CloudDedicatedVpc = 'CloudDedicatedVPC',
  /** Allows user to create projects with plans: cloud_free_v2, cloud_shared */
  CloudNewPlans = 'CloudNewPlans',
  /** Allows user to create projects with plans: cloud_free, cloud_payg */
  CloudUser = 'CloudUser',
  /** Console Onboarding Wizard for new users */
  ConsoleOnboardingWizard = 'ConsoleOnboardingWizard',
  /** Allows user to configure Datadog api key per project */
  DatadogIntegration = 'DatadogIntegration',
  /** Allows users to create projects on Google Cloud Platform */
  GcpSupport = 'GCPSupport',
  /** Allows user to automatically deploy metadata/migrations to the project from github repo */
  GithubIntegration = 'GithubIntegration',
  /** Allows users to have access to GraphQL Schema Registry */
  GraphQlSchemaRegistry = 'GraphQLSchemaRegistry',
  /** Neon DB Integration through Hasura Console */
  NeonDatabaseIntegration = 'NeonDatabaseIntegration',
  /** Allows user to create Hasura Pro Project */
  ProUser = 'ProUser',
  /** Allows user to configure schema/table access control */
  SchemaTableAcl = 'SchemaTableACL',
  /** Allows user to update Hasura Project to v2.0 */
  V1V2Migration = 'V1V2Migration',
}

/** Boolean expression to compare columns of type "feature_enum". All fields are combined with logical 'AND'. */
export type Feature_Enum_Comparison_Exp = {
  _eq?: Maybe<Feature_Enum>;
  _in?: Maybe<Array<Feature_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Feature_Enum>;
  _nin?: Maybe<Array<Feature_Enum>>;
};

/** input type for inserting data into table "feature" */
export type Feature_Insert_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Feature_Max_Fields = {
  __typename?: 'feature_max_fields';
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Feature_Min_Fields = {
  __typename?: 'feature_min_fields';
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "feature" */
export type Feature_Mutation_Response = {
  __typename?: 'feature_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Feature>;
};

/** input type for inserting object relation for remote table "feature" */
export type Feature_Obj_Rel_Insert_Input = {
  data: Feature_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Feature_On_Conflict>;
};

/** on_conflict condition type for table "feature" */
export type Feature_On_Conflict = {
  constraint: Feature_Constraint;
  update_columns?: Array<Feature_Update_Column>;
  where?: Maybe<Feature_Bool_Exp>;
};

/** Ordering options when selecting data from "feature". */
export type Feature_Order_By = {
  description?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
};

/** primary key columns input for table: feature */
export type Feature_Pk_Columns_Input = {
  name: Scalars['String'];
};

/** select columns of table "feature" */
export enum Feature_Select_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Name = 'name',
}

/** input type for updating data in table "feature" */
export type Feature_Set_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "feature" */
export type Feature_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Feature_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Feature_Stream_Cursor_Value_Input = {
  description?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** update columns of table "feature" */
export enum Feature_Update_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Name = 'name',
}

export type Feature_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Feature_Set_Input>;
  /** filter the rows which have to be updated */
  where: Feature_Bool_Exp;
};

export type FeatureRequest = {
  details: Scalars['jsonb'];
  type: Scalars['String'];
};

export type FeatureRequestResponse = {
  __typename?: 'FeatureRequestResponse';
  status: Scalars['String'];
};

/** Boolean expression to compare columns of type "float8". All fields are combined with logical 'AND'. */
export type Float8_Comparison_Exp = {
  _eq?: Maybe<Scalars['float8']>;
  _gt?: Maybe<Scalars['float8']>;
  _gte?: Maybe<Scalars['float8']>;
  _in?: Maybe<Array<Scalars['float8']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['float8']>;
  _lte?: Maybe<Scalars['float8']>;
  _neq?: Maybe<Scalars['float8']>;
  _nin?: Maybe<Array<Scalars['float8']>>;
};

/** Represents ami's generated for gateway service */
export type Gateway_Ami = {
  __typename?: 'gateway_ami';
  ami_id: Scalars['String'];
  cloud: Scalars['String'];
  commit_hash: Scalars['String'];
  created_at: Scalars['timestamptz'];
  region: Scalars['String'];
  remarks: Scalars['String'];
};

/** aggregated selection of "gateway_ami" */
export type Gateway_Ami_Aggregate = {
  __typename?: 'gateway_ami_aggregate';
  aggregate?: Maybe<Gateway_Ami_Aggregate_Fields>;
  nodes: Array<Gateway_Ami>;
};

/** aggregate fields of "gateway_ami" */
export type Gateway_Ami_Aggregate_Fields = {
  __typename?: 'gateway_ami_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Gateway_Ami_Max_Fields>;
  min?: Maybe<Gateway_Ami_Min_Fields>;
};

/** aggregate fields of "gateway_ami" */
export type Gateway_Ami_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Gateway_Ami_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "gateway_ami". All fields are combined with a logical 'AND'. */
export type Gateway_Ami_Bool_Exp = {
  _and?: Maybe<Array<Gateway_Ami_Bool_Exp>>;
  _not?: Maybe<Gateway_Ami_Bool_Exp>;
  _or?: Maybe<Array<Gateway_Ami_Bool_Exp>>;
  ami_id?: Maybe<String_Comparison_Exp>;
  cloud?: Maybe<String_Comparison_Exp>;
  commit_hash?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  remarks?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "gateway_ami" */
export enum Gateway_Ami_Constraint {
  /** unique or primary key constraint on columns "ami_id", "cloud", "region" */
  GatewayAmiPkey = 'gateway_ami_pkey',
}

/** input type for inserting data into table "gateway_ami" */
export type Gateway_Ami_Insert_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Gateway_Ami_Max_Fields = {
  __typename?: 'gateway_ami_max_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Gateway_Ami_Min_Fields = {
  __typename?: 'gateway_ami_min_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "gateway_ami" */
export type Gateway_Ami_Mutation_Response = {
  __typename?: 'gateway_ami_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Gateway_Ami>;
};

/** on_conflict condition type for table "gateway_ami" */
export type Gateway_Ami_On_Conflict = {
  constraint: Gateway_Ami_Constraint;
  update_columns?: Array<Gateway_Ami_Update_Column>;
  where?: Maybe<Gateway_Ami_Bool_Exp>;
};

/** Ordering options when selecting data from "gateway_ami". */
export type Gateway_Ami_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  commit_hash?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  remarks?: Maybe<Order_By>;
};

/** primary key columns input for table: gateway_ami */
export type Gateway_Ami_Pk_Columns_Input = {
  ami_id: Scalars['String'];
  cloud: Scalars['String'];
  region: Scalars['String'];
};

/** select columns of table "gateway_ami" */
export enum Gateway_Ami_Select_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CommitHash = 'commit_hash',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Region = 'region',
  /** column name */
  Remarks = 'remarks',
}

/** input type for updating data in table "gateway_ami" */
export type Gateway_Ami_Set_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "gateway_ami" */
export type Gateway_Ami_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Gateway_Ami_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Gateway_Ami_Stream_Cursor_Value_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** update columns of table "gateway_ami" */
export enum Gateway_Ami_Update_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CommitHash = 'commit_hash',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Region = 'region',
  /** column name */
  Remarks = 'remarks',
}

export type Gateway_Ami_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Gateway_Ami_Set_Input>;
  /** filter the rows which have to be updated */
  where: Gateway_Ami_Bool_Exp;
};

/** Set of gateway workers in a specific region */
export type Gateway_Cluster = {
  __typename?: 'gateway_cluster';
  ami_id?: Maybe<Scalars['String']>;
  cloud: Scalars['String'];
  created_at: Scalars['timestamptz'];
  disable_infra_auto_apply: Scalars['Boolean'];
  fqdn?: Maybe<Scalars['String']>;
  id: Scalars['uuid'];
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  region: Scalars['String'];
  /** An object relationship */
  region_info?: Maybe<Region>;
  slug: Scalars['String'];
  status: Scalars['String'];
  /** An array relationship */
  workers: Array<Gateway_Worker>;
  /** An aggregate relationship */
  workers_aggregate: Gateway_Worker_Aggregate;
};

/** Set of gateway workers in a specific region */
export type Gateway_ClusterInput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** Set of gateway workers in a specific region */
export type Gateway_ClusterOutput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** Set of gateway workers in a specific region */
export type Gateway_ClusterWorkersArgs = {
  distinct_on?: Maybe<Array<Gateway_Worker_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Gateway_Worker_Order_By>>;
  where?: Maybe<Gateway_Worker_Bool_Exp>;
};

/** Set of gateway workers in a specific region */
export type Gateway_ClusterWorkers_AggregateArgs = {
  distinct_on?: Maybe<Array<Gateway_Worker_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Gateway_Worker_Order_By>>;
  where?: Maybe<Gateway_Worker_Bool_Exp>;
};

/** aggregated selection of "gateway_cluster" */
export type Gateway_Cluster_Aggregate = {
  __typename?: 'gateway_cluster_aggregate';
  aggregate?: Maybe<Gateway_Cluster_Aggregate_Fields>;
  nodes: Array<Gateway_Cluster>;
};

/** aggregate fields of "gateway_cluster" */
export type Gateway_Cluster_Aggregate_Fields = {
  __typename?: 'gateway_cluster_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Gateway_Cluster_Max_Fields>;
  min?: Maybe<Gateway_Cluster_Min_Fields>;
};

/** aggregate fields of "gateway_cluster" */
export type Gateway_Cluster_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Gateway_Cluster_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Gateway_Cluster_Append_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** Boolean expression to filter rows from the table "gateway_cluster". All fields are combined with a logical 'AND'. */
export type Gateway_Cluster_Bool_Exp = {
  _and?: Maybe<Array<Gateway_Cluster_Bool_Exp>>;
  _not?: Maybe<Gateway_Cluster_Bool_Exp>;
  _or?: Maybe<Array<Gateway_Cluster_Bool_Exp>>;
  ami_id?: Maybe<String_Comparison_Exp>;
  cloud?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  disable_infra_auto_apply?: Maybe<Boolean_Comparison_Exp>;
  fqdn?: Maybe<String_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  infra_status?: Maybe<Infra_Status_Enum_Comparison_Exp>;
  input_variables?: Maybe<Jsonb_Comparison_Exp>;
  output_variables?: Maybe<Jsonb_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  region_info?: Maybe<Region_Bool_Exp>;
  slug?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  workers?: Maybe<Gateway_Worker_Bool_Exp>;
  workers_aggregate?: Maybe<Gateway_Worker_Aggregate_Bool_Exp>;
};

/** unique or primary key constraints on table "gateway_cluster" */
export enum Gateway_Cluster_Constraint {
  /** unique or primary key constraint on columns "id" */
  GatewayClusterPkey = 'gateway_cluster_pkey',
  /** unique or primary key constraint on columns "slug" */
  GatewayClusterSlugKey = 'gateway_cluster_slug_key',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Gateway_Cluster_Delete_At_Path_Input = {
  input_variables?: Maybe<Array<Scalars['String']>>;
  output_variables?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Gateway_Cluster_Delete_Elem_Input = {
  input_variables?: Maybe<Scalars['Int']>;
  output_variables?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Gateway_Cluster_Delete_Key_Input = {
  input_variables?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "gateway_cluster" */
export type Gateway_Cluster_Insert_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  region?: Maybe<Scalars['String']>;
  region_info?: Maybe<Region_Obj_Rel_Insert_Input>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  workers?: Maybe<Gateway_Worker_Arr_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Gateway_Cluster_Max_Fields = {
  __typename?: 'gateway_cluster_max_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Gateway_Cluster_Min_Fields = {
  __typename?: 'gateway_cluster_min_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "gateway_cluster" */
export type Gateway_Cluster_Mutation_Response = {
  __typename?: 'gateway_cluster_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Gateway_Cluster>;
};

/** input type for inserting object relation for remote table "gateway_cluster" */
export type Gateway_Cluster_Obj_Rel_Insert_Input = {
  data: Gateway_Cluster_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Gateway_Cluster_On_Conflict>;
};

/** on_conflict condition type for table "gateway_cluster" */
export type Gateway_Cluster_On_Conflict = {
  constraint: Gateway_Cluster_Constraint;
  update_columns?: Array<Gateway_Cluster_Update_Column>;
  where?: Maybe<Gateway_Cluster_Bool_Exp>;
};

/** Ordering options when selecting data from "gateway_cluster". */
export type Gateway_Cluster_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  disable_infra_auto_apply?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  infra_status?: Maybe<Order_By>;
  input_variables?: Maybe<Order_By>;
  output_variables?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  region_info?: Maybe<Region_Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  workers_aggregate?: Maybe<Gateway_Worker_Aggregate_Order_By>;
};

/** primary key columns input for table: gateway_cluster */
export type Gateway_Cluster_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Gateway_Cluster_Prepend_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "gateway_cluster" */
export enum Gateway_Cluster_Select_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
}

/** input type for updating data in table "gateway_cluster" */
export type Gateway_Cluster_Set_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "gateway_cluster" */
export type Gateway_Cluster_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Gateway_Cluster_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Gateway_Cluster_Stream_Cursor_Value_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  fqdn?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** columns and relationships of "gateway_cluster_tenants" */
export type Gateway_Cluster_Tenants = {
  __typename?: 'gateway_cluster_tenants';
  cert?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  gateway_cluster_id?: Maybe<Scalars['uuid']>;
  plan_name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  workers?: Maybe<Scalars['_json']>;
};

/** aggregated selection of "gateway_cluster_tenants" */
export type Gateway_Cluster_Tenants_Aggregate = {
  __typename?: 'gateway_cluster_tenants_aggregate';
  aggregate?: Maybe<Gateway_Cluster_Tenants_Aggregate_Fields>;
  nodes: Array<Gateway_Cluster_Tenants>;
};

/** aggregate fields of "gateway_cluster_tenants" */
export type Gateway_Cluster_Tenants_Aggregate_Fields = {
  __typename?: 'gateway_cluster_tenants_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Gateway_Cluster_Tenants_Max_Fields>;
  min?: Maybe<Gateway_Cluster_Tenants_Min_Fields>;
};

/** aggregate fields of "gateway_cluster_tenants" */
export type Gateway_Cluster_Tenants_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Gateway_Cluster_Tenants_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "gateway_cluster_tenants". All fields are combined with a logical 'AND'. */
export type Gateway_Cluster_Tenants_Bool_Exp = {
  _and?: Maybe<Array<Gateway_Cluster_Tenants_Bool_Exp>>;
  _not?: Maybe<Gateway_Cluster_Tenants_Bool_Exp>;
  _or?: Maybe<Array<Gateway_Cluster_Tenants_Bool_Exp>>;
  cert?: Maybe<String_Comparison_Exp>;
  fqdn?: Maybe<String_Comparison_Exp>;
  gateway_cluster_id?: Maybe<Uuid_Comparison_Exp>;
  plan_name?: Maybe<String_Comparison_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  project_name?: Maybe<String_Comparison_Exp>;
  tenant_id?: Maybe<Uuid_Comparison_Exp>;
  workers?: Maybe<_Json_Comparison_Exp>;
};

/** aggregate max on columns */
export type Gateway_Cluster_Tenants_Max_Fields = {
  __typename?: 'gateway_cluster_tenants_max_fields';
  cert?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  gateway_cluster_id?: Maybe<Scalars['uuid']>;
  plan_name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
};

/** aggregate min on columns */
export type Gateway_Cluster_Tenants_Min_Fields = {
  __typename?: 'gateway_cluster_tenants_min_fields';
  cert?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  gateway_cluster_id?: Maybe<Scalars['uuid']>;
  plan_name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
};

/** Ordering options when selecting data from "gateway_cluster_tenants". */
export type Gateway_Cluster_Tenants_Order_By = {
  cert?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  gateway_cluster_id?: Maybe<Order_By>;
  plan_name?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  project_name?: Maybe<Order_By>;
  tenant_id?: Maybe<Order_By>;
  workers?: Maybe<Order_By>;
};

/** select columns of table "gateway_cluster_tenants" */
export enum Gateway_Cluster_Tenants_Select_Column {
  /** column name */
  Cert = 'cert',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  GatewayClusterId = 'gateway_cluster_id',
  /** column name */
  PlanName = 'plan_name',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  ProjectName = 'project_name',
  /** column name */
  TenantId = 'tenant_id',
  /** column name */
  Workers = 'workers',
}

/** Streaming cursor of the table "gateway_cluster_tenants" */
export type Gateway_Cluster_Tenants_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Gateway_Cluster_Tenants_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Gateway_Cluster_Tenants_Stream_Cursor_Value_Input = {
  cert?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  gateway_cluster_id?: Maybe<Scalars['uuid']>;
  plan_name?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  workers?: Maybe<Scalars['_json']>;
};

/** update columns of table "gateway_cluster" */
export enum Gateway_Cluster_Update_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  Id = 'id',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
}

export type Gateway_Cluster_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Gateway_Cluster_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Gateway_Cluster_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Gateway_Cluster_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Gateway_Cluster_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Gateway_Cluster_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Gateway_Cluster_Set_Input>;
  /** filter the rows which have to be updated */
  where: Gateway_Cluster_Bool_Exp;
};

/** Gateway worker in a region that routes traffic to multiple Hasura Clusters */
export type Gateway_Worker = {
  __typename?: 'gateway_worker';
  cloud: Scalars['String'];
  /** An object relationship */
  cluster: Gateway_Cluster;
  cluster_id: Scalars['uuid'];
  created_at: Scalars['timestamptz'];
  id: Scalars['uuid'];
  region: Scalars['String'];
  /** An object relationship */
  region_info?: Maybe<Region>;
  slug: Scalars['String'];
  status: Scalars['String'];
  zone: Scalars['String'];
};

/** aggregated selection of "gateway_worker" */
export type Gateway_Worker_Aggregate = {
  __typename?: 'gateway_worker_aggregate';
  aggregate?: Maybe<Gateway_Worker_Aggregate_Fields>;
  nodes: Array<Gateway_Worker>;
};

export type Gateway_Worker_Aggregate_Bool_Exp = {
  count?: Maybe<Gateway_Worker_Aggregate_Bool_Exp_Count>;
};

export type Gateway_Worker_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Gateway_Worker_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Gateway_Worker_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "gateway_worker" */
export type Gateway_Worker_Aggregate_Fields = {
  __typename?: 'gateway_worker_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Gateway_Worker_Max_Fields>;
  min?: Maybe<Gateway_Worker_Min_Fields>;
};

/** aggregate fields of "gateway_worker" */
export type Gateway_Worker_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Gateway_Worker_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "gateway_worker" */
export type Gateway_Worker_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Gateway_Worker_Max_Order_By>;
  min?: Maybe<Gateway_Worker_Min_Order_By>;
};

/** input type for inserting array relation for remote table "gateway_worker" */
export type Gateway_Worker_Arr_Rel_Insert_Input = {
  data: Array<Gateway_Worker_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Gateway_Worker_On_Conflict>;
};

/** Boolean expression to filter rows from the table "gateway_worker". All fields are combined with a logical 'AND'. */
export type Gateway_Worker_Bool_Exp = {
  _and?: Maybe<Array<Gateway_Worker_Bool_Exp>>;
  _not?: Maybe<Gateway_Worker_Bool_Exp>;
  _or?: Maybe<Array<Gateway_Worker_Bool_Exp>>;
  cloud?: Maybe<String_Comparison_Exp>;
  cluster?: Maybe<Gateway_Cluster_Bool_Exp>;
  cluster_id?: Maybe<Uuid_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  region_info?: Maybe<Region_Bool_Exp>;
  slug?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  zone?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "gateway_worker" */
export enum Gateway_Worker_Constraint {
  /** unique or primary key constraint on columns "id" */
  GatewayWorkerPkey = 'gateway_worker_pkey',
  /** unique or primary key constraint on columns "slug" */
  GatewayWorkerSlugKey = 'gateway_worker_slug_key',
}

/** input type for inserting data into table "gateway_worker" */
export type Gateway_Worker_Insert_Input = {
  cloud?: Maybe<Scalars['String']>;
  cluster?: Maybe<Gateway_Cluster_Obj_Rel_Insert_Input>;
  cluster_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  region_info?: Maybe<Region_Obj_Rel_Insert_Input>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  zone?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Gateway_Worker_Max_Fields = {
  __typename?: 'gateway_worker_max_fields';
  cloud?: Maybe<Scalars['String']>;
  cluster_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  zone?: Maybe<Scalars['String']>;
};

/** order by max() on columns of table "gateway_worker" */
export type Gateway_Worker_Max_Order_By = {
  cloud?: Maybe<Order_By>;
  cluster_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  zone?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Gateway_Worker_Min_Fields = {
  __typename?: 'gateway_worker_min_fields';
  cloud?: Maybe<Scalars['String']>;
  cluster_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  zone?: Maybe<Scalars['String']>;
};

/** order by min() on columns of table "gateway_worker" */
export type Gateway_Worker_Min_Order_By = {
  cloud?: Maybe<Order_By>;
  cluster_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  zone?: Maybe<Order_By>;
};

/** response of any mutation on the table "gateway_worker" */
export type Gateway_Worker_Mutation_Response = {
  __typename?: 'gateway_worker_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Gateway_Worker>;
};

/** on_conflict condition type for table "gateway_worker" */
export type Gateway_Worker_On_Conflict = {
  constraint: Gateway_Worker_Constraint;
  update_columns?: Array<Gateway_Worker_Update_Column>;
  where?: Maybe<Gateway_Worker_Bool_Exp>;
};

/** Ordering options when selecting data from "gateway_worker". */
export type Gateway_Worker_Order_By = {
  cloud?: Maybe<Order_By>;
  cluster?: Maybe<Gateway_Cluster_Order_By>;
  cluster_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  region_info?: Maybe<Region_Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  zone?: Maybe<Order_By>;
};

/** primary key columns input for table: gateway_worker */
export type Gateway_Worker_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "gateway_worker" */
export enum Gateway_Worker_Select_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  ClusterId = 'cluster_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
  /** column name */
  Zone = 'zone',
}

/** input type for updating data in table "gateway_worker" */
export type Gateway_Worker_Set_Input = {
  cloud?: Maybe<Scalars['String']>;
  cluster_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  zone?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "gateway_worker" */
export type Gateway_Worker_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Gateway_Worker_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Gateway_Worker_Stream_Cursor_Value_Input = {
  cloud?: Maybe<Scalars['String']>;
  cluster_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  zone?: Maybe<Scalars['String']>;
};

/** update columns of table "gateway_worker" */
export enum Gateway_Worker_Update_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  ClusterId = 'cluster_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
  /** column name */
  Zone = 'zone',
}

export type Gateway_Worker_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Gateway_Worker_Set_Input>;
  /** filter the rows which have to be updated */
  where: Gateway_Worker_Bool_Exp;
};

export type Get_Aggregated_Cost_For_Project_On_Shared_Plan_Args = {
  fromdate?: Maybe<Scalars['date']>;
  projectid?: Maybe<Scalars['String']>;
  todate?: Maybe<Scalars['date']>;
};

export type GetReportUrlResponse = {
  __typename?: 'GetReportURLResponse';
  url: Scalars['String'];
};

/** Github Integration deploy commits status email types */
export type Github_Email_Type = {
  __typename?: 'github_email_type';
  description: Scalars['String'];
  email_type: Scalars['String'];
};

/** aggregated selection of "github_email_type" */
export type Github_Email_Type_Aggregate = {
  __typename?: 'github_email_type_aggregate';
  aggregate?: Maybe<Github_Email_Type_Aggregate_Fields>;
  nodes: Array<Github_Email_Type>;
};

/** aggregate fields of "github_email_type" */
export type Github_Email_Type_Aggregate_Fields = {
  __typename?: 'github_email_type_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Github_Email_Type_Max_Fields>;
  min?: Maybe<Github_Email_Type_Min_Fields>;
};

/** aggregate fields of "github_email_type" */
export type Github_Email_Type_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Github_Email_Type_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "github_email_type". All fields are combined with a logical 'AND'. */
export type Github_Email_Type_Bool_Exp = {
  _and?: Maybe<Array<Github_Email_Type_Bool_Exp>>;
  _not?: Maybe<Github_Email_Type_Bool_Exp>;
  _or?: Maybe<Array<Github_Email_Type_Bool_Exp>>;
  description?: Maybe<String_Comparison_Exp>;
  email_type?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "github_email_type" */
export enum Github_Email_Type_Constraint {
  /** unique or primary key constraint on columns "email_type" */
  GithubEmailTypePkey = 'github_email_type_pkey',
}

export enum Github_Email_Type_Enum {
  /** Both email types to be sent */
  Both = 'both',
  /** Github Integration deployment failure type */
  Failure = 'failure',
  /** No email types to be sent */
  None = 'none',
  /** Github Integration deployment success type */
  Success = 'success',
}

/** Boolean expression to compare columns of type "github_email_type_enum". All fields are combined with logical 'AND'. */
export type Github_Email_Type_Enum_Comparison_Exp = {
  _eq?: Maybe<Github_Email_Type_Enum>;
  _in?: Maybe<Array<Github_Email_Type_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Github_Email_Type_Enum>;
  _nin?: Maybe<Array<Github_Email_Type_Enum>>;
};

/** input type for inserting data into table "github_email_type" */
export type Github_Email_Type_Insert_Input = {
  description?: Maybe<Scalars['String']>;
  email_type?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Github_Email_Type_Max_Fields = {
  __typename?: 'github_email_type_max_fields';
  description?: Maybe<Scalars['String']>;
  email_type?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Github_Email_Type_Min_Fields = {
  __typename?: 'github_email_type_min_fields';
  description?: Maybe<Scalars['String']>;
  email_type?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "github_email_type" */
export type Github_Email_Type_Mutation_Response = {
  __typename?: 'github_email_type_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Github_Email_Type>;
};

/** on_conflict condition type for table "github_email_type" */
export type Github_Email_Type_On_Conflict = {
  constraint: Github_Email_Type_Constraint;
  update_columns?: Array<Github_Email_Type_Update_Column>;
  where?: Maybe<Github_Email_Type_Bool_Exp>;
};

/** Ordering options when selecting data from "github_email_type". */
export type Github_Email_Type_Order_By = {
  description?: Maybe<Order_By>;
  email_type?: Maybe<Order_By>;
};

/** primary key columns input for table: github_email_type */
export type Github_Email_Type_Pk_Columns_Input = {
  email_type: Scalars['String'];
};

/** select columns of table "github_email_type" */
export enum Github_Email_Type_Select_Column {
  /** column name */
  Description = 'description',
  /** column name */
  EmailType = 'email_type',
}

/** input type for updating data in table "github_email_type" */
export type Github_Email_Type_Set_Input = {
  description?: Maybe<Scalars['String']>;
  email_type?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "github_email_type" */
export type Github_Email_Type_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Github_Email_Type_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Github_Email_Type_Stream_Cursor_Value_Input = {
  description?: Maybe<Scalars['String']>;
  email_type?: Maybe<Scalars['String']>;
};

/** update columns of table "github_email_type" */
export enum Github_Email_Type_Update_Column {
  /** column name */
  Description = 'description',
  /** column name */
  EmailType = 'email_type',
}

export type Github_Email_Type_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Github_Email_Type_Set_Input>;
  /** filter the rows which have to be updated */
  where: Github_Email_Type_Bool_Exp;
};

/** columns and relationships of "github_integration_config" */
export type Github_Integration_Config = {
  __typename?: 'github_integration_config';
  app_installation_id?: Maybe<Scalars['Int']>;
  branch: Scalars['String'];
  created_at: Scalars['timestamptz'];
  directory: Scalars['String'];
  email_status: Github_Email_Type_Enum;
  /** An array relationship */
  github_push_events: Array<Github_Push_Event>;
  /** An aggregate relationship */
  github_push_events_aggregate: Github_Push_Event_Aggregate;
  id: Scalars['uuid'];
  mode: Github_Integration_Mode_Enum;
  organisation: Scalars['String'];
  /** An object relationship */
  project: Projects;
  project_id: Scalars['uuid'];
  repository: Scalars['String'];
  updated_at: Scalars['timestamptz'];
};

/** columns and relationships of "github_integration_config" */
export type Github_Integration_ConfigGithub_Push_EventsArgs = {
  distinct_on?: Maybe<Array<Github_Push_Event_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Github_Push_Event_Order_By>>;
  where?: Maybe<Github_Push_Event_Bool_Exp>;
};

/** columns and relationships of "github_integration_config" */
export type Github_Integration_ConfigGithub_Push_Events_AggregateArgs = {
  distinct_on?: Maybe<Array<Github_Push_Event_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Github_Push_Event_Order_By>>;
  where?: Maybe<Github_Push_Event_Bool_Exp>;
};

/** aggregated selection of "github_integration_config" */
export type Github_Integration_Config_Aggregate = {
  __typename?: 'github_integration_config_aggregate';
  aggregate?: Maybe<Github_Integration_Config_Aggregate_Fields>;
  nodes: Array<Github_Integration_Config>;
};

/** aggregate fields of "github_integration_config" */
export type Github_Integration_Config_Aggregate_Fields = {
  __typename?: 'github_integration_config_aggregate_fields';
  avg?: Maybe<Github_Integration_Config_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Github_Integration_Config_Max_Fields>;
  min?: Maybe<Github_Integration_Config_Min_Fields>;
  stddev?: Maybe<Github_Integration_Config_Stddev_Fields>;
  stddev_pop?: Maybe<Github_Integration_Config_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Github_Integration_Config_Stddev_Samp_Fields>;
  sum?: Maybe<Github_Integration_Config_Sum_Fields>;
  var_pop?: Maybe<Github_Integration_Config_Var_Pop_Fields>;
  var_samp?: Maybe<Github_Integration_Config_Var_Samp_Fields>;
  variance?: Maybe<Github_Integration_Config_Variance_Fields>;
};

/** aggregate fields of "github_integration_config" */
export type Github_Integration_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Github_Integration_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Github_Integration_Config_Avg_Fields = {
  __typename?: 'github_integration_config_avg_fields';
  app_installation_id?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "github_integration_config". All fields are combined with a logical 'AND'. */
export type Github_Integration_Config_Bool_Exp = {
  _and?: Maybe<Array<Github_Integration_Config_Bool_Exp>>;
  _not?: Maybe<Github_Integration_Config_Bool_Exp>;
  _or?: Maybe<Array<Github_Integration_Config_Bool_Exp>>;
  app_installation_id?: Maybe<Int_Comparison_Exp>;
  branch?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  directory?: Maybe<String_Comparison_Exp>;
  email_status?: Maybe<Github_Email_Type_Enum_Comparison_Exp>;
  github_push_events?: Maybe<Github_Push_Event_Bool_Exp>;
  github_push_events_aggregate?: Maybe<Github_Push_Event_Aggregate_Bool_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  mode?: Maybe<Github_Integration_Mode_Enum_Comparison_Exp>;
  organisation?: Maybe<String_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  repository?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "github_integration_config" */
export enum Github_Integration_Config_Constraint {
  /** unique or primary key constraint on columns "id" */
  GithubIntegrationConfigPkey = 'github_integration_config_pkey',
}

/** input type for incrementing numeric columns in table "github_integration_config" */
export type Github_Integration_Config_Inc_Input = {
  app_installation_id?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "github_integration_config" */
export type Github_Integration_Config_Insert_Input = {
  app_installation_id?: Maybe<Scalars['Int']>;
  branch?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  directory?: Maybe<Scalars['String']>;
  email_status?: Maybe<Github_Email_Type_Enum>;
  github_push_events?: Maybe<Github_Push_Event_Arr_Rel_Insert_Input>;
  id?: Maybe<Scalars['uuid']>;
  mode?: Maybe<Github_Integration_Mode_Enum>;
  organisation?: Maybe<Scalars['String']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  repository?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Github_Integration_Config_Max_Fields = {
  __typename?: 'github_integration_config_max_fields';
  app_installation_id?: Maybe<Scalars['Int']>;
  branch?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  directory?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  organisation?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  repository?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Github_Integration_Config_Min_Fields = {
  __typename?: 'github_integration_config_min_fields';
  app_installation_id?: Maybe<Scalars['Int']>;
  branch?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  directory?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  organisation?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  repository?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "github_integration_config" */
export type Github_Integration_Config_Mutation_Response = {
  __typename?: 'github_integration_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Github_Integration_Config>;
};

/** input type for inserting object relation for remote table "github_integration_config" */
export type Github_Integration_Config_Obj_Rel_Insert_Input = {
  data: Github_Integration_Config_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Github_Integration_Config_On_Conflict>;
};

/** on_conflict condition type for table "github_integration_config" */
export type Github_Integration_Config_On_Conflict = {
  constraint: Github_Integration_Config_Constraint;
  update_columns?: Array<Github_Integration_Config_Update_Column>;
  where?: Maybe<Github_Integration_Config_Bool_Exp>;
};

/** Ordering options when selecting data from "github_integration_config". */
export type Github_Integration_Config_Order_By = {
  app_installation_id?: Maybe<Order_By>;
  branch?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  directory?: Maybe<Order_By>;
  email_status?: Maybe<Order_By>;
  github_push_events_aggregate?: Maybe<Github_Push_Event_Aggregate_Order_By>;
  id?: Maybe<Order_By>;
  mode?: Maybe<Order_By>;
  organisation?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  repository?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: github_integration_config */
export type Github_Integration_Config_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "github_integration_config" */
export enum Github_Integration_Config_Select_Column {
  /** column name */
  AppInstallationId = 'app_installation_id',
  /** column name */
  Branch = 'branch',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Directory = 'directory',
  /** column name */
  EmailStatus = 'email_status',
  /** column name */
  Id = 'id',
  /** column name */
  Mode = 'mode',
  /** column name */
  Organisation = 'organisation',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  Repository = 'repository',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "github_integration_config" */
export type Github_Integration_Config_Set_Input = {
  app_installation_id?: Maybe<Scalars['Int']>;
  branch?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  directory?: Maybe<Scalars['String']>;
  email_status?: Maybe<Github_Email_Type_Enum>;
  id?: Maybe<Scalars['uuid']>;
  mode?: Maybe<Github_Integration_Mode_Enum>;
  organisation?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  repository?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate stddev on columns */
export type Github_Integration_Config_Stddev_Fields = {
  __typename?: 'github_integration_config_stddev_fields';
  app_installation_id?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Github_Integration_Config_Stddev_Pop_Fields = {
  __typename?: 'github_integration_config_stddev_pop_fields';
  app_installation_id?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Github_Integration_Config_Stddev_Samp_Fields = {
  __typename?: 'github_integration_config_stddev_samp_fields';
  app_installation_id?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "github_integration_config" */
export type Github_Integration_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Github_Integration_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Github_Integration_Config_Stream_Cursor_Value_Input = {
  app_installation_id?: Maybe<Scalars['Int']>;
  branch?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  directory?: Maybe<Scalars['String']>;
  email_status?: Maybe<Github_Email_Type_Enum>;
  id?: Maybe<Scalars['uuid']>;
  mode?: Maybe<Github_Integration_Mode_Enum>;
  organisation?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  repository?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate sum on columns */
export type Github_Integration_Config_Sum_Fields = {
  __typename?: 'github_integration_config_sum_fields';
  app_installation_id?: Maybe<Scalars['Int']>;
};

/** update columns of table "github_integration_config" */
export enum Github_Integration_Config_Update_Column {
  /** column name */
  AppInstallationId = 'app_installation_id',
  /** column name */
  Branch = 'branch',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Directory = 'directory',
  /** column name */
  EmailStatus = 'email_status',
  /** column name */
  Id = 'id',
  /** column name */
  Mode = 'mode',
  /** column name */
  Organisation = 'organisation',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  Repository = 'repository',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Github_Integration_Config_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Github_Integration_Config_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Github_Integration_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Github_Integration_Config_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Github_Integration_Config_Var_Pop_Fields = {
  __typename?: 'github_integration_config_var_pop_fields';
  app_installation_id?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Github_Integration_Config_Var_Samp_Fields = {
  __typename?: 'github_integration_config_var_samp_fields';
  app_installation_id?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Github_Integration_Config_Variance_Fields = {
  __typename?: 'github_integration_config_variance_fields';
  app_installation_id?: Maybe<Scalars['Float']>;
};

/** columns and relationships of "github_integration_mode" */
export type Github_Integration_Mode = {
  __typename?: 'github_integration_mode';
  description: Scalars['String'];
  mode: Scalars['String'];
};

/** aggregated selection of "github_integration_mode" */
export type Github_Integration_Mode_Aggregate = {
  __typename?: 'github_integration_mode_aggregate';
  aggregate?: Maybe<Github_Integration_Mode_Aggregate_Fields>;
  nodes: Array<Github_Integration_Mode>;
};

/** aggregate fields of "github_integration_mode" */
export type Github_Integration_Mode_Aggregate_Fields = {
  __typename?: 'github_integration_mode_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Github_Integration_Mode_Max_Fields>;
  min?: Maybe<Github_Integration_Mode_Min_Fields>;
};

/** aggregate fields of "github_integration_mode" */
export type Github_Integration_Mode_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Github_Integration_Mode_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "github_integration_mode". All fields are combined with a logical 'AND'. */
export type Github_Integration_Mode_Bool_Exp = {
  _and?: Maybe<Array<Github_Integration_Mode_Bool_Exp>>;
  _not?: Maybe<Github_Integration_Mode_Bool_Exp>;
  _or?: Maybe<Array<Github_Integration_Mode_Bool_Exp>>;
  description?: Maybe<String_Comparison_Exp>;
  mode?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "github_integration_mode" */
export enum Github_Integration_Mode_Constraint {
  /** unique or primary key constraint on columns "mode" */
  GithubIntegrationModePkey = 'github_integration_mode_pkey',
}

export enum Github_Integration_Mode_Enum {
  /** deploy github automatically */
  Automatic = 'automatic',
  /** deploy github manually */
  Manual = 'manual',
  /** deploy github as preview app */
  PreviewApp = 'previewApp',
}

/** Boolean expression to compare columns of type "github_integration_mode_enum". All fields are combined with logical 'AND'. */
export type Github_Integration_Mode_Enum_Comparison_Exp = {
  _eq?: Maybe<Github_Integration_Mode_Enum>;
  _in?: Maybe<Array<Github_Integration_Mode_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Github_Integration_Mode_Enum>;
  _nin?: Maybe<Array<Github_Integration_Mode_Enum>>;
};

/** input type for inserting data into table "github_integration_mode" */
export type Github_Integration_Mode_Insert_Input = {
  description?: Maybe<Scalars['String']>;
  mode?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Github_Integration_Mode_Max_Fields = {
  __typename?: 'github_integration_mode_max_fields';
  description?: Maybe<Scalars['String']>;
  mode?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Github_Integration_Mode_Min_Fields = {
  __typename?: 'github_integration_mode_min_fields';
  description?: Maybe<Scalars['String']>;
  mode?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "github_integration_mode" */
export type Github_Integration_Mode_Mutation_Response = {
  __typename?: 'github_integration_mode_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Github_Integration_Mode>;
};

/** on_conflict condition type for table "github_integration_mode" */
export type Github_Integration_Mode_On_Conflict = {
  constraint: Github_Integration_Mode_Constraint;
  update_columns?: Array<Github_Integration_Mode_Update_Column>;
  where?: Maybe<Github_Integration_Mode_Bool_Exp>;
};

/** Ordering options when selecting data from "github_integration_mode". */
export type Github_Integration_Mode_Order_By = {
  description?: Maybe<Order_By>;
  mode?: Maybe<Order_By>;
};

/** primary key columns input for table: github_integration_mode */
export type Github_Integration_Mode_Pk_Columns_Input = {
  mode: Scalars['String'];
};

/** select columns of table "github_integration_mode" */
export enum Github_Integration_Mode_Select_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Mode = 'mode',
}

/** input type for updating data in table "github_integration_mode" */
export type Github_Integration_Mode_Set_Input = {
  description?: Maybe<Scalars['String']>;
  mode?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "github_integration_mode" */
export type Github_Integration_Mode_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Github_Integration_Mode_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Github_Integration_Mode_Stream_Cursor_Value_Input = {
  description?: Maybe<Scalars['String']>;
  mode?: Maybe<Scalars['String']>;
};

/** update columns of table "github_integration_mode" */
export enum Github_Integration_Mode_Update_Column {
  /** column name */
  Description = 'description',
  /** column name */
  Mode = 'mode',
}

export type Github_Integration_Mode_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Github_Integration_Mode_Set_Input>;
  /** filter the rows which have to be updated */
  where: Github_Integration_Mode_Bool_Exp;
};

/** columns and relationships of "github_push_event" */
export type Github_Push_Event = {
  __typename?: 'github_push_event';
  archive_url: Scalars['String'];
  commit: Scalars['String'];
  commit_message: Scalars['String'];
  commit_timestamp: Scalars['timestamptz'];
  /** An object relationship */
  github_integration_config: Github_Integration_Config;
  github_integration_config_id: Scalars['uuid'];
  /** An array relationship */
  github_push_event_jobs: Array<Github_Push_Event_Job>;
  /** An aggregate relationship */
  github_push_event_jobs_aggregate: Github_Push_Event_Job_Aggregate;
  id: Scalars['uuid'];
  push_metadata: Scalars['jsonb'];
  received_at: Scalars['timestamptz'];
};

/** columns and relationships of "github_push_event" */
export type Github_Push_EventGithub_Push_Event_JobsArgs = {
  distinct_on?: Maybe<Array<Github_Push_Event_Job_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Github_Push_Event_Job_Order_By>>;
  where?: Maybe<Github_Push_Event_Job_Bool_Exp>;
};

/** columns and relationships of "github_push_event" */
export type Github_Push_EventGithub_Push_Event_Jobs_AggregateArgs = {
  distinct_on?: Maybe<Array<Github_Push_Event_Job_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Github_Push_Event_Job_Order_By>>;
  where?: Maybe<Github_Push_Event_Job_Bool_Exp>;
};

/** columns and relationships of "github_push_event" */
export type Github_Push_EventPush_MetadataArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "github_push_event" */
export type Github_Push_Event_Aggregate = {
  __typename?: 'github_push_event_aggregate';
  aggregate?: Maybe<Github_Push_Event_Aggregate_Fields>;
  nodes: Array<Github_Push_Event>;
};

export type Github_Push_Event_Aggregate_Bool_Exp = {
  count?: Maybe<Github_Push_Event_Aggregate_Bool_Exp_Count>;
};

export type Github_Push_Event_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Github_Push_Event_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Github_Push_Event_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "github_push_event" */
export type Github_Push_Event_Aggregate_Fields = {
  __typename?: 'github_push_event_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Github_Push_Event_Max_Fields>;
  min?: Maybe<Github_Push_Event_Min_Fields>;
};

/** aggregate fields of "github_push_event" */
export type Github_Push_Event_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Github_Push_Event_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "github_push_event" */
export type Github_Push_Event_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Github_Push_Event_Max_Order_By>;
  min?: Maybe<Github_Push_Event_Min_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Github_Push_Event_Append_Input = {
  push_metadata?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "github_push_event" */
export type Github_Push_Event_Arr_Rel_Insert_Input = {
  data: Array<Github_Push_Event_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Github_Push_Event_On_Conflict>;
};

/** Boolean expression to filter rows from the table "github_push_event". All fields are combined with a logical 'AND'. */
export type Github_Push_Event_Bool_Exp = {
  _and?: Maybe<Array<Github_Push_Event_Bool_Exp>>;
  _not?: Maybe<Github_Push_Event_Bool_Exp>;
  _or?: Maybe<Array<Github_Push_Event_Bool_Exp>>;
  archive_url?: Maybe<String_Comparison_Exp>;
  commit?: Maybe<String_Comparison_Exp>;
  commit_message?: Maybe<String_Comparison_Exp>;
  commit_timestamp?: Maybe<Timestamptz_Comparison_Exp>;
  github_integration_config?: Maybe<Github_Integration_Config_Bool_Exp>;
  github_integration_config_id?: Maybe<Uuid_Comparison_Exp>;
  github_push_event_jobs?: Maybe<Github_Push_Event_Job_Bool_Exp>;
  github_push_event_jobs_aggregate?: Maybe<Github_Push_Event_Job_Aggregate_Bool_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  push_metadata?: Maybe<Jsonb_Comparison_Exp>;
  received_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "github_push_event" */
export enum Github_Push_Event_Constraint {
  /** unique or primary key constraint on columns "id" */
  GithubPushEventPkey = 'github_push_event_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Github_Push_Event_Delete_At_Path_Input = {
  push_metadata?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Github_Push_Event_Delete_Elem_Input = {
  push_metadata?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Github_Push_Event_Delete_Key_Input = {
  push_metadata?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "github_push_event" */
export type Github_Push_Event_Insert_Input = {
  archive_url?: Maybe<Scalars['String']>;
  commit?: Maybe<Scalars['String']>;
  commit_message?: Maybe<Scalars['String']>;
  commit_timestamp?: Maybe<Scalars['timestamptz']>;
  github_integration_config?: Maybe<Github_Integration_Config_Obj_Rel_Insert_Input>;
  github_integration_config_id?: Maybe<Scalars['uuid']>;
  github_push_event_jobs?: Maybe<Github_Push_Event_Job_Arr_Rel_Insert_Input>;
  id?: Maybe<Scalars['uuid']>;
  push_metadata?: Maybe<Scalars['jsonb']>;
  received_at?: Maybe<Scalars['timestamptz']>;
};

/** columns and relationships of "github_push_event_job" */
export type Github_Push_Event_Job = {
  __typename?: 'github_push_event_job';
  /** An object relationship */
  github_push_event: Github_Push_Event;
  github_push_event_id: Scalars['uuid'];
  id: Scalars['uuid'];
  /** An object relationship */
  job: Jobs;
  job_id: Scalars['uuid'];
};

/** aggregated selection of "github_push_event_job" */
export type Github_Push_Event_Job_Aggregate = {
  __typename?: 'github_push_event_job_aggregate';
  aggregate?: Maybe<Github_Push_Event_Job_Aggregate_Fields>;
  nodes: Array<Github_Push_Event_Job>;
};

export type Github_Push_Event_Job_Aggregate_Bool_Exp = {
  count?: Maybe<Github_Push_Event_Job_Aggregate_Bool_Exp_Count>;
};

export type Github_Push_Event_Job_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Github_Push_Event_Job_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Github_Push_Event_Job_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "github_push_event_job" */
export type Github_Push_Event_Job_Aggregate_Fields = {
  __typename?: 'github_push_event_job_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Github_Push_Event_Job_Max_Fields>;
  min?: Maybe<Github_Push_Event_Job_Min_Fields>;
};

/** aggregate fields of "github_push_event_job" */
export type Github_Push_Event_Job_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Github_Push_Event_Job_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "github_push_event_job" */
export type Github_Push_Event_Job_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Github_Push_Event_Job_Max_Order_By>;
  min?: Maybe<Github_Push_Event_Job_Min_Order_By>;
};

/** input type for inserting array relation for remote table "github_push_event_job" */
export type Github_Push_Event_Job_Arr_Rel_Insert_Input = {
  data: Array<Github_Push_Event_Job_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Github_Push_Event_Job_On_Conflict>;
};

/** Boolean expression to filter rows from the table "github_push_event_job". All fields are combined with a logical 'AND'. */
export type Github_Push_Event_Job_Bool_Exp = {
  _and?: Maybe<Array<Github_Push_Event_Job_Bool_Exp>>;
  _not?: Maybe<Github_Push_Event_Job_Bool_Exp>;
  _or?: Maybe<Array<Github_Push_Event_Job_Bool_Exp>>;
  github_push_event?: Maybe<Github_Push_Event_Bool_Exp>;
  github_push_event_id?: Maybe<Uuid_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  job?: Maybe<Jobs_Bool_Exp>;
  job_id?: Maybe<Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "github_push_event_job" */
export enum Github_Push_Event_Job_Constraint {
  /** unique or primary key constraint on columns "id" */
  GithubPushEventJobPkey = 'github_push_event_job_pkey',
}

/** input type for inserting data into table "github_push_event_job" */
export type Github_Push_Event_Job_Insert_Input = {
  github_push_event?: Maybe<Github_Push_Event_Obj_Rel_Insert_Input>;
  github_push_event_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  job?: Maybe<Jobs_Obj_Rel_Insert_Input>;
  job_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Github_Push_Event_Job_Max_Fields = {
  __typename?: 'github_push_event_job_max_fields';
  github_push_event_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  job_id?: Maybe<Scalars['uuid']>;
};

/** order by max() on columns of table "github_push_event_job" */
export type Github_Push_Event_Job_Max_Order_By = {
  github_push_event_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  job_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Github_Push_Event_Job_Min_Fields = {
  __typename?: 'github_push_event_job_min_fields';
  github_push_event_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  job_id?: Maybe<Scalars['uuid']>;
};

/** order by min() on columns of table "github_push_event_job" */
export type Github_Push_Event_Job_Min_Order_By = {
  github_push_event_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  job_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "github_push_event_job" */
export type Github_Push_Event_Job_Mutation_Response = {
  __typename?: 'github_push_event_job_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Github_Push_Event_Job>;
};

/** on_conflict condition type for table "github_push_event_job" */
export type Github_Push_Event_Job_On_Conflict = {
  constraint: Github_Push_Event_Job_Constraint;
  update_columns?: Array<Github_Push_Event_Job_Update_Column>;
  where?: Maybe<Github_Push_Event_Job_Bool_Exp>;
};

/** Ordering options when selecting data from "github_push_event_job". */
export type Github_Push_Event_Job_Order_By = {
  github_push_event?: Maybe<Github_Push_Event_Order_By>;
  github_push_event_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  job?: Maybe<Jobs_Order_By>;
  job_id?: Maybe<Order_By>;
};

/** primary key columns input for table: github_push_event_job */
export type Github_Push_Event_Job_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "github_push_event_job" */
export enum Github_Push_Event_Job_Select_Column {
  /** column name */
  GithubPushEventId = 'github_push_event_id',
  /** column name */
  Id = 'id',
  /** column name */
  JobId = 'job_id',
}

/** input type for updating data in table "github_push_event_job" */
export type Github_Push_Event_Job_Set_Input = {
  github_push_event_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  job_id?: Maybe<Scalars['uuid']>;
};

/** Streaming cursor of the table "github_push_event_job" */
export type Github_Push_Event_Job_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Github_Push_Event_Job_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Github_Push_Event_Job_Stream_Cursor_Value_Input = {
  github_push_event_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  job_id?: Maybe<Scalars['uuid']>;
};

/** update columns of table "github_push_event_job" */
export enum Github_Push_Event_Job_Update_Column {
  /** column name */
  GithubPushEventId = 'github_push_event_id',
  /** column name */
  Id = 'id',
  /** column name */
  JobId = 'job_id',
}

export type Github_Push_Event_Job_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Github_Push_Event_Job_Set_Input>;
  /** filter the rows which have to be updated */
  where: Github_Push_Event_Job_Bool_Exp;
};

/** aggregate max on columns */
export type Github_Push_Event_Max_Fields = {
  __typename?: 'github_push_event_max_fields';
  archive_url?: Maybe<Scalars['String']>;
  commit?: Maybe<Scalars['String']>;
  commit_message?: Maybe<Scalars['String']>;
  commit_timestamp?: Maybe<Scalars['timestamptz']>;
  github_integration_config_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  received_at?: Maybe<Scalars['timestamptz']>;
};

/** order by max() on columns of table "github_push_event" */
export type Github_Push_Event_Max_Order_By = {
  archive_url?: Maybe<Order_By>;
  commit?: Maybe<Order_By>;
  commit_message?: Maybe<Order_By>;
  commit_timestamp?: Maybe<Order_By>;
  github_integration_config_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  received_at?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Github_Push_Event_Min_Fields = {
  __typename?: 'github_push_event_min_fields';
  archive_url?: Maybe<Scalars['String']>;
  commit?: Maybe<Scalars['String']>;
  commit_message?: Maybe<Scalars['String']>;
  commit_timestamp?: Maybe<Scalars['timestamptz']>;
  github_integration_config_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  received_at?: Maybe<Scalars['timestamptz']>;
};

/** order by min() on columns of table "github_push_event" */
export type Github_Push_Event_Min_Order_By = {
  archive_url?: Maybe<Order_By>;
  commit?: Maybe<Order_By>;
  commit_message?: Maybe<Order_By>;
  commit_timestamp?: Maybe<Order_By>;
  github_integration_config_id?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  received_at?: Maybe<Order_By>;
};

/** response of any mutation on the table "github_push_event" */
export type Github_Push_Event_Mutation_Response = {
  __typename?: 'github_push_event_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Github_Push_Event>;
};

/** input type for inserting object relation for remote table "github_push_event" */
export type Github_Push_Event_Obj_Rel_Insert_Input = {
  data: Github_Push_Event_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Github_Push_Event_On_Conflict>;
};

/** on_conflict condition type for table "github_push_event" */
export type Github_Push_Event_On_Conflict = {
  constraint: Github_Push_Event_Constraint;
  update_columns?: Array<Github_Push_Event_Update_Column>;
  where?: Maybe<Github_Push_Event_Bool_Exp>;
};

/** Ordering options when selecting data from "github_push_event". */
export type Github_Push_Event_Order_By = {
  archive_url?: Maybe<Order_By>;
  commit?: Maybe<Order_By>;
  commit_message?: Maybe<Order_By>;
  commit_timestamp?: Maybe<Order_By>;
  github_integration_config?: Maybe<Github_Integration_Config_Order_By>;
  github_integration_config_id?: Maybe<Order_By>;
  github_push_event_jobs_aggregate?: Maybe<Github_Push_Event_Job_Aggregate_Order_By>;
  id?: Maybe<Order_By>;
  push_metadata?: Maybe<Order_By>;
  received_at?: Maybe<Order_By>;
};

/** primary key columns input for table: github_push_event */
export type Github_Push_Event_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Github_Push_Event_Prepend_Input = {
  push_metadata?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "github_push_event" */
export enum Github_Push_Event_Select_Column {
  /** column name */
  ArchiveUrl = 'archive_url',
  /** column name */
  Commit = 'commit',
  /** column name */
  CommitMessage = 'commit_message',
  /** column name */
  CommitTimestamp = 'commit_timestamp',
  /** column name */
  GithubIntegrationConfigId = 'github_integration_config_id',
  /** column name */
  Id = 'id',
  /** column name */
  PushMetadata = 'push_metadata',
  /** column name */
  ReceivedAt = 'received_at',
}

/** input type for updating data in table "github_push_event" */
export type Github_Push_Event_Set_Input = {
  archive_url?: Maybe<Scalars['String']>;
  commit?: Maybe<Scalars['String']>;
  commit_message?: Maybe<Scalars['String']>;
  commit_timestamp?: Maybe<Scalars['timestamptz']>;
  github_integration_config_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  push_metadata?: Maybe<Scalars['jsonb']>;
  received_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "github_push_event" */
export type Github_Push_Event_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Github_Push_Event_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Github_Push_Event_Stream_Cursor_Value_Input = {
  archive_url?: Maybe<Scalars['String']>;
  commit?: Maybe<Scalars['String']>;
  commit_message?: Maybe<Scalars['String']>;
  commit_timestamp?: Maybe<Scalars['timestamptz']>;
  github_integration_config_id?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  push_metadata?: Maybe<Scalars['jsonb']>;
  received_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "github_push_event" */
export enum Github_Push_Event_Update_Column {
  /** column name */
  ArchiveUrl = 'archive_url',
  /** column name */
  Commit = 'commit',
  /** column name */
  CommitMessage = 'commit_message',
  /** column name */
  CommitTimestamp = 'commit_timestamp',
  /** column name */
  GithubIntegrationConfigId = 'github_integration_config_id',
  /** column name */
  Id = 'id',
  /** column name */
  PushMetadata = 'push_metadata',
  /** column name */
  ReceivedAt = 'received_at',
}

export type Github_Push_Event_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Github_Push_Event_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Github_Push_Event_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Github_Push_Event_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Github_Push_Event_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Github_Push_Event_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Github_Push_Event_Set_Input>;
  /** filter the rows which have to be updated */
  where: Github_Push_Event_Bool_Exp;
};

export type GithubIntegrationInput = {
  branch: Scalars['String'];
  directory?: Maybe<Scalars['String']>;
  email_status: Scalars['String'];
  installation_id?: Maybe<Scalars['Int']>;
  mode?: Maybe<ModeEnum>;
  org: Scalars['String'];
  project_id: Scalars['String'];
  repo: Scalars['String'];
};

export type GithubIntegrationStatus = {
  __typename?: 'GithubIntegrationStatus';
  status: Scalars['String'];
};

export type GithubRepoDetails = {
  branch: Scalars['String'];
  directory: Scalars['String'];
  owner: Scalars['String'];
  repo: Scalars['String'];
};

export type GithubSession = {
  __typename?: 'GithubSession';
  access_token: Scalars['String'];
  token_type: Scalars['String'];
};

export type GranularComputeUnitCount = {
  __typename?: 'GranularComputeUnitCount';
  count: Scalars['Int'];
  epoch: Scalars['Int'];
};

export type GranularComputeUnitUsagePercentage = {
  __typename?: 'GranularComputeUnitUsagePercentage';
  epoch: Scalars['Int'];
  usage: Scalars['Float'];
};

export type HandleInactiveProjectsResult = {
  __typename?: 'HandleInactiveProjectsResult';
  done?: Maybe<Scalars['Boolean']>;
};

/** columns and relationships of "hasura_ami" */
export type Hasura_Ami = {
  __typename?: 'hasura_ami';
  ami_id: Scalars['String'];
  cloud: Scalars['String'];
  cloud_version: Scalars['String'];
  commit_hash: Scalars['String'];
  created_at: Scalars['timestamptz'];
  major_version: Scalars['smallint'];
  region: Scalars['String'];
  remarks: Scalars['String'];
  super_connector_metadata_defaults?: Maybe<Scalars['jsonb']>;
};

/** columns and relationships of "hasura_ami" */
export type Hasura_AmiSuper_Connector_Metadata_DefaultsArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "hasura_ami" */
export type Hasura_Ami_Aggregate = {
  __typename?: 'hasura_ami_aggregate';
  aggregate?: Maybe<Hasura_Ami_Aggregate_Fields>;
  nodes: Array<Hasura_Ami>;
};

/** aggregate fields of "hasura_ami" */
export type Hasura_Ami_Aggregate_Fields = {
  __typename?: 'hasura_ami_aggregate_fields';
  avg?: Maybe<Hasura_Ami_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Hasura_Ami_Max_Fields>;
  min?: Maybe<Hasura_Ami_Min_Fields>;
  stddev?: Maybe<Hasura_Ami_Stddev_Fields>;
  stddev_pop?: Maybe<Hasura_Ami_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Hasura_Ami_Stddev_Samp_Fields>;
  sum?: Maybe<Hasura_Ami_Sum_Fields>;
  var_pop?: Maybe<Hasura_Ami_Var_Pop_Fields>;
  var_samp?: Maybe<Hasura_Ami_Var_Samp_Fields>;
  variance?: Maybe<Hasura_Ami_Variance_Fields>;
};

/** aggregate fields of "hasura_ami" */
export type Hasura_Ami_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Hasura_Ami_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Hasura_Ami_Append_Input = {
  super_connector_metadata_defaults?: Maybe<Scalars['jsonb']>;
};

/** aggregate avg on columns */
export type Hasura_Ami_Avg_Fields = {
  __typename?: 'hasura_ami_avg_fields';
  major_version?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "hasura_ami". All fields are combined with a logical 'AND'. */
export type Hasura_Ami_Bool_Exp = {
  _and?: Maybe<Array<Hasura_Ami_Bool_Exp>>;
  _not?: Maybe<Hasura_Ami_Bool_Exp>;
  _or?: Maybe<Array<Hasura_Ami_Bool_Exp>>;
  ami_id?: Maybe<String_Comparison_Exp>;
  cloud?: Maybe<String_Comparison_Exp>;
  cloud_version?: Maybe<String_Comparison_Exp>;
  commit_hash?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  major_version?: Maybe<Smallint_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  remarks?: Maybe<String_Comparison_Exp>;
  super_connector_metadata_defaults?: Maybe<Jsonb_Comparison_Exp>;
};

/** unique or primary key constraints on table "hasura_ami" */
export enum Hasura_Ami_Constraint {
  /** unique or primary key constraint on columns "ami_id", "cloud", "cloud_version", "region" */
  HasuraAmiAmiIdCloudRegionCloudVersionKey = 'hasura_ami_ami_id_cloud_region_cloud_version_key',
  /** unique or primary key constraint on columns "ami_id" */
  HasuraAmiAmiIdKey = 'hasura_ami_ami_id_key',
  /** unique or primary key constraint on columns "ami_id", "cloud", "region" */
  HasuraAmiPkey = 'hasura_ami_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Hasura_Ami_Delete_At_Path_Input = {
  super_connector_metadata_defaults?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Hasura_Ami_Delete_Elem_Input = {
  super_connector_metadata_defaults?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Hasura_Ami_Delete_Key_Input = {
  super_connector_metadata_defaults?: Maybe<Scalars['String']>;
};

/** input type for incrementing numeric columns in table "hasura_ami" */
export type Hasura_Ami_Inc_Input = {
  major_version?: Maybe<Scalars['smallint']>;
};

/** input type for inserting data into table "hasura_ami" */
export type Hasura_Ami_Insert_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  cloud_version?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  major_version?: Maybe<Scalars['smallint']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
  super_connector_metadata_defaults?: Maybe<Scalars['jsonb']>;
};

/** aggregate max on columns */
export type Hasura_Ami_Max_Fields = {
  __typename?: 'hasura_ami_max_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  cloud_version?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  major_version?: Maybe<Scalars['smallint']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Hasura_Ami_Min_Fields = {
  __typename?: 'hasura_ami_min_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  cloud_version?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  major_version?: Maybe<Scalars['smallint']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "hasura_ami" */
export type Hasura_Ami_Mutation_Response = {
  __typename?: 'hasura_ami_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Hasura_Ami>;
};

/** on_conflict condition type for table "hasura_ami" */
export type Hasura_Ami_On_Conflict = {
  constraint: Hasura_Ami_Constraint;
  update_columns?: Array<Hasura_Ami_Update_Column>;
  where?: Maybe<Hasura_Ami_Bool_Exp>;
};

/** Ordering options when selecting data from "hasura_ami". */
export type Hasura_Ami_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  cloud_version?: Maybe<Order_By>;
  commit_hash?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  major_version?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  remarks?: Maybe<Order_By>;
  super_connector_metadata_defaults?: Maybe<Order_By>;
};

/** primary key columns input for table: hasura_ami */
export type Hasura_Ami_Pk_Columns_Input = {
  ami_id: Scalars['String'];
  cloud: Scalars['String'];
  region: Scalars['String'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Hasura_Ami_Prepend_Input = {
  super_connector_metadata_defaults?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "hasura_ami" */
export enum Hasura_Ami_Select_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CloudVersion = 'cloud_version',
  /** column name */
  CommitHash = 'commit_hash',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  MajorVersion = 'major_version',
  /** column name */
  Region = 'region',
  /** column name */
  Remarks = 'remarks',
  /** column name */
  SuperConnectorMetadataDefaults = 'super_connector_metadata_defaults',
}

/** input type for updating data in table "hasura_ami" */
export type Hasura_Ami_Set_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  cloud_version?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  major_version?: Maybe<Scalars['smallint']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
  super_connector_metadata_defaults?: Maybe<Scalars['jsonb']>;
};

/** aggregate stddev on columns */
export type Hasura_Ami_Stddev_Fields = {
  __typename?: 'hasura_ami_stddev_fields';
  major_version?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Hasura_Ami_Stddev_Pop_Fields = {
  __typename?: 'hasura_ami_stddev_pop_fields';
  major_version?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Hasura_Ami_Stddev_Samp_Fields = {
  __typename?: 'hasura_ami_stddev_samp_fields';
  major_version?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "hasura_ami" */
export type Hasura_Ami_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Hasura_Ami_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Hasura_Ami_Stream_Cursor_Value_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  cloud_version?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  major_version?: Maybe<Scalars['smallint']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
  super_connector_metadata_defaults?: Maybe<Scalars['jsonb']>;
};

/** aggregate sum on columns */
export type Hasura_Ami_Sum_Fields = {
  __typename?: 'hasura_ami_sum_fields';
  major_version?: Maybe<Scalars['smallint']>;
};

/** update columns of table "hasura_ami" */
export enum Hasura_Ami_Update_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CloudVersion = 'cloud_version',
  /** column name */
  CommitHash = 'commit_hash',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  MajorVersion = 'major_version',
  /** column name */
  Region = 'region',
  /** column name */
  Remarks = 'remarks',
  /** column name */
  SuperConnectorMetadataDefaults = 'super_connector_metadata_defaults',
}

export type Hasura_Ami_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Hasura_Ami_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Hasura_Ami_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Hasura_Ami_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Hasura_Ami_Delete_Key_Input>;
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Hasura_Ami_Inc_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Hasura_Ami_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Hasura_Ami_Set_Input>;
  /** filter the rows which have to be updated */
  where: Hasura_Ami_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Hasura_Ami_Var_Pop_Fields = {
  __typename?: 'hasura_ami_var_pop_fields';
  major_version?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Hasura_Ami_Var_Samp_Fields = {
  __typename?: 'hasura_ami_var_samp_fields';
  major_version?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Hasura_Ami_Variance_Fields = {
  __typename?: 'hasura_ami_variance_fields';
  major_version?: Maybe<Scalars['Float']>;
};

/** Set of Hasura workers in a specific region */
export type Hasura_Cluster = {
  __typename?: 'hasura_cluster';
  ami_id?: Maybe<Scalars['String']>;
  cloud: Scalars['String'];
  comments?: Maybe<Scalars['String']>;
  /** An object relationship */
  compute_unit_config?: Maybe<Compute_Unit_Config>;
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  configured_super_connector?: Maybe<Super_Connector_Types_Enum>;
  created_at: Scalars['timestamptz'];
  disable_infra_auto_apply: Scalars['Boolean'];
  id: Scalars['uuid'];
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  /** An object relationship */
  node_pool?: Maybe<Node_Pools>;
  node_pool_id?: Maybe<Scalars['uuid']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  pinned_version?: Maybe<Scalars['String']>;
  region: Scalars['String'];
  /** An object relationship */
  region_info?: Maybe<Region>;
  slug: Scalars['String'];
  status: Scalars['String'];
  /** metadata defaults that will be used by the hasura cluster */
  super_connector_metadata_defaults?: Maybe<Scalars['jsonb']>;
  /** An object relationship */
  tenant_group?: Maybe<Tenant_Group>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
  /** An array relationship */
  workers: Array<Hasura_Worker>;
  /** An aggregate relationship */
  workers_aggregate: Hasura_Worker_Aggregate;
};

/** Set of Hasura workers in a specific region */
export type Hasura_ClusterInput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** Set of Hasura workers in a specific region */
export type Hasura_ClusterOutput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** Set of Hasura workers in a specific region */
export type Hasura_ClusterSuper_Connector_Metadata_DefaultsArgs = {
  path?: Maybe<Scalars['String']>;
};

/** Set of Hasura workers in a specific region */
export type Hasura_ClusterWorkersArgs = {
  distinct_on?: Maybe<Array<Hasura_Worker_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Hasura_Worker_Order_By>>;
  where?: Maybe<Hasura_Worker_Bool_Exp>;
};

/** Set of Hasura workers in a specific region */
export type Hasura_ClusterWorkers_AggregateArgs = {
  distinct_on?: Maybe<Array<Hasura_Worker_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Hasura_Worker_Order_By>>;
  where?: Maybe<Hasura_Worker_Bool_Exp>;
};

/** aggregated selection of "hasura_cluster" */
export type Hasura_Cluster_Aggregate = {
  __typename?: 'hasura_cluster_aggregate';
  aggregate?: Maybe<Hasura_Cluster_Aggregate_Fields>;
  nodes: Array<Hasura_Cluster>;
};

export type Hasura_Cluster_Aggregate_Bool_Exp = {
  bool_and?: Maybe<Hasura_Cluster_Aggregate_Bool_Exp_Bool_And>;
  bool_or?: Maybe<Hasura_Cluster_Aggregate_Bool_Exp_Bool_Or>;
  count?: Maybe<Hasura_Cluster_Aggregate_Bool_Exp_Count>;
};

export type Hasura_Cluster_Aggregate_Bool_Exp_Bool_And = {
  arguments: Hasura_Cluster_Select_Column_Hasura_Cluster_Aggregate_Bool_Exp_Bool_And_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Hasura_Cluster_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Hasura_Cluster_Aggregate_Bool_Exp_Bool_Or = {
  arguments: Hasura_Cluster_Select_Column_Hasura_Cluster_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Hasura_Cluster_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Hasura_Cluster_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Hasura_Cluster_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Hasura_Cluster_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "hasura_cluster" */
export type Hasura_Cluster_Aggregate_Fields = {
  __typename?: 'hasura_cluster_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Hasura_Cluster_Max_Fields>;
  min?: Maybe<Hasura_Cluster_Min_Fields>;
};

/** aggregate fields of "hasura_cluster" */
export type Hasura_Cluster_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Hasura_Cluster_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "hasura_cluster" */
export type Hasura_Cluster_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Hasura_Cluster_Max_Order_By>;
  min?: Maybe<Hasura_Cluster_Min_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Hasura_Cluster_Append_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "hasura_cluster" */
export type Hasura_Cluster_Arr_Rel_Insert_Input = {
  data: Array<Hasura_Cluster_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Hasura_Cluster_On_Conflict>;
};

/** Boolean expression to filter rows from the table "hasura_cluster". All fields are combined with a logical 'AND'. */
export type Hasura_Cluster_Bool_Exp = {
  _and?: Maybe<Array<Hasura_Cluster_Bool_Exp>>;
  _not?: Maybe<Hasura_Cluster_Bool_Exp>;
  _or?: Maybe<Array<Hasura_Cluster_Bool_Exp>>;
  ami_id?: Maybe<String_Comparison_Exp>;
  cloud?: Maybe<String_Comparison_Exp>;
  comments?: Maybe<String_Comparison_Exp>;
  compute_unit_config?: Maybe<Compute_Unit_Config_Bool_Exp>;
  compute_unit_config_id?: Maybe<Uuid_Comparison_Exp>;
  configured_super_connector?: Maybe<Super_Connector_Types_Enum_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  disable_infra_auto_apply?: Maybe<Boolean_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  infra_status?: Maybe<Infra_Status_Enum_Comparison_Exp>;
  input_variables?: Maybe<Jsonb_Comparison_Exp>;
  node_pool?: Maybe<Node_Pools_Bool_Exp>;
  node_pool_id?: Maybe<Uuid_Comparison_Exp>;
  output_variables?: Maybe<Jsonb_Comparison_Exp>;
  pinned_version?: Maybe<String_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  region_info?: Maybe<Region_Bool_Exp>;
  slug?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  super_connector_metadata_defaults?: Maybe<Jsonb_Comparison_Exp>;
  tenant_group?: Maybe<Tenant_Group_Bool_Exp>;
  tenant_group_id?: Maybe<Uuid_Comparison_Exp>;
  workers?: Maybe<Hasura_Worker_Bool_Exp>;
  workers_aggregate?: Maybe<Hasura_Worker_Aggregate_Bool_Exp>;
};

/** unique or primary key constraints on table "hasura_cluster" */
export enum Hasura_Cluster_Constraint {
  /** unique or primary key constraint on columns "node_pool_id", "compute_unit_config_id" */
  HasuraClusterComputeUnitConfigIdUniqueKey = 'hasura_cluster_compute_unit_config_id_unique_key',
  /** unique or primary key constraint on columns "id" */
  HasuraClusterPkey = 'hasura_cluster_pkey',
  /** unique or primary key constraint on columns "slug" */
  HasuraClusterSlugKey = 'hasura_cluster_slug_key',
  /** unique or primary key constraint on columns "tenant_group_id" */
  HasuraClusterTenantGroupIdKey = 'hasura_cluster_tenant_group_id_key',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Hasura_Cluster_Delete_At_Path_Input = {
  input_variables?: Maybe<Array<Scalars['String']>>;
  output_variables?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Hasura_Cluster_Delete_Elem_Input = {
  input_variables?: Maybe<Scalars['Int']>;
  output_variables?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Hasura_Cluster_Delete_Key_Input = {
  input_variables?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "hasura_cluster" */
export type Hasura_Cluster_Insert_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  compute_unit_config?: Maybe<Compute_Unit_Config_Obj_Rel_Insert_Input>;
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  configured_super_connector?: Maybe<Super_Connector_Types_Enum>;
  created_at?: Maybe<Scalars['timestamptz']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  node_pool?: Maybe<Node_Pools_Obj_Rel_Insert_Input>;
  node_pool_id?: Maybe<Scalars['uuid']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  pinned_version?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  region_info?: Maybe<Region_Obj_Rel_Insert_Input>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  tenant_group?: Maybe<Tenant_Group_Obj_Rel_Insert_Input>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
  workers?: Maybe<Hasura_Worker_Arr_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Hasura_Cluster_Max_Fields = {
  __typename?: 'hasura_cluster_max_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  node_pool_id?: Maybe<Scalars['uuid']>;
  pinned_version?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
};

/** order by max() on columns of table "hasura_cluster" */
export type Hasura_Cluster_Max_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  comments?: Maybe<Order_By>;
  compute_unit_config_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  node_pool_id?: Maybe<Order_By>;
  pinned_version?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  tenant_group_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Hasura_Cluster_Min_Fields = {
  __typename?: 'hasura_cluster_min_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  node_pool_id?: Maybe<Scalars['uuid']>;
  pinned_version?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
};

/** order by min() on columns of table "hasura_cluster" */
export type Hasura_Cluster_Min_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  comments?: Maybe<Order_By>;
  compute_unit_config_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  node_pool_id?: Maybe<Order_By>;
  pinned_version?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  tenant_group_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "hasura_cluster" */
export type Hasura_Cluster_Mutation_Response = {
  __typename?: 'hasura_cluster_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Hasura_Cluster>;
};

/** input type for inserting object relation for remote table "hasura_cluster" */
export type Hasura_Cluster_Obj_Rel_Insert_Input = {
  data: Hasura_Cluster_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Hasura_Cluster_On_Conflict>;
};

/** on_conflict condition type for table "hasura_cluster" */
export type Hasura_Cluster_On_Conflict = {
  constraint: Hasura_Cluster_Constraint;
  update_columns?: Array<Hasura_Cluster_Update_Column>;
  where?: Maybe<Hasura_Cluster_Bool_Exp>;
};

/** Ordering options when selecting data from "hasura_cluster". */
export type Hasura_Cluster_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  comments?: Maybe<Order_By>;
  compute_unit_config?: Maybe<Compute_Unit_Config_Order_By>;
  compute_unit_config_id?: Maybe<Order_By>;
  configured_super_connector?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  disable_infra_auto_apply?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  infra_status?: Maybe<Order_By>;
  input_variables?: Maybe<Order_By>;
  node_pool?: Maybe<Node_Pools_Order_By>;
  node_pool_id?: Maybe<Order_By>;
  output_variables?: Maybe<Order_By>;
  pinned_version?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  region_info?: Maybe<Region_Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  super_connector_metadata_defaults?: Maybe<Order_By>;
  tenant_group?: Maybe<Tenant_Group_Order_By>;
  tenant_group_id?: Maybe<Order_By>;
  workers_aggregate?: Maybe<Hasura_Worker_Aggregate_Order_By>;
};

/** primary key columns input for table: hasura_cluster */
export type Hasura_Cluster_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Hasura_Cluster_Prepend_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "hasura_cluster" */
export enum Hasura_Cluster_Select_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  Comments = 'comments',
  /** column name */
  ComputeUnitConfigId = 'compute_unit_config_id',
  /** column name */
  ConfiguredSuperConnector = 'configured_super_connector',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
  /** column name */
  Id = 'id',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  NodePoolId = 'node_pool_id',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  PinnedVersion = 'pinned_version',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
  /** column name */
  TenantGroupId = 'tenant_group_id',
}

/** select "hasura_cluster_aggregate_bool_exp_bool_and_arguments_columns" columns of table "hasura_cluster" */
export enum Hasura_Cluster_Select_Column_Hasura_Cluster_Aggregate_Bool_Exp_Bool_And_Arguments_Columns {
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
}

/** select "hasura_cluster_aggregate_bool_exp_bool_or_arguments_columns" columns of table "hasura_cluster" */
export enum Hasura_Cluster_Select_Column_Hasura_Cluster_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns {
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
}

/** input type for updating data in table "hasura_cluster" */
export type Hasura_Cluster_Set_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  configured_super_connector?: Maybe<Super_Connector_Types_Enum>;
  created_at?: Maybe<Scalars['timestamptz']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  node_pool_id?: Maybe<Scalars['uuid']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  pinned_version?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
};

/** Streaming cursor of the table "hasura_cluster" */
export type Hasura_Cluster_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Hasura_Cluster_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Hasura_Cluster_Stream_Cursor_Value_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  compute_unit_config_id?: Maybe<Scalars['uuid']>;
  configured_super_connector?: Maybe<Super_Connector_Types_Enum>;
  created_at?: Maybe<Scalars['timestamptz']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  node_pool_id?: Maybe<Scalars['uuid']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  pinned_version?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  tenant_group_id?: Maybe<Scalars['uuid']>;
};

/** update columns of table "hasura_cluster" */
export enum Hasura_Cluster_Update_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  Comments = 'comments',
  /** column name */
  ComputeUnitConfigId = 'compute_unit_config_id',
  /** column name */
  ConfiguredSuperConnector = 'configured_super_connector',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
  /** column name */
  Id = 'id',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  NodePoolId = 'node_pool_id',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  PinnedVersion = 'pinned_version',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
  /** column name */
  TenantGroupId = 'tenant_group_id',
}

export type Hasura_Cluster_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Hasura_Cluster_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Hasura_Cluster_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Hasura_Cluster_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Hasura_Cluster_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Hasura_Cluster_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Hasura_Cluster_Set_Input>;
  /** filter the rows which have to be updated */
  where: Hasura_Cluster_Bool_Exp;
};

/** Multi-tenant Hasura process capable of providing GraphQL APIs */
export type Hasura_Worker = {
  __typename?: 'hasura_worker';
  cloud: Scalars['String'];
  /** An object relationship */
  cluster: Hasura_Cluster;
  cluster_id: Scalars['uuid'];
  /** An array relationship */
  config_statuses: Array<Config_Status>;
  /** An aggregate relationship */
  config_statuses_aggregate: Config_Status_Aggregate;
  created_at: Scalars['timestamptz'];
  id: Scalars['uuid'];
  ip: Scalars['String'];
  region: Scalars['String'];
  slug: Scalars['String'];
  status: Scalars['String'];
  /** An array relationship */
  tenant_statuses: Array<Tenant_Status>;
  /** An aggregate relationship */
  tenant_statuses_aggregate: Tenant_Status_Aggregate;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone: Scalars['String'];
};

/** Multi-tenant Hasura process capable of providing GraphQL APIs */
export type Hasura_WorkerConfig_StatusesArgs = {
  distinct_on?: Maybe<Array<Config_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Config_Status_Order_By>>;
  where?: Maybe<Config_Status_Bool_Exp>;
};

/** Multi-tenant Hasura process capable of providing GraphQL APIs */
export type Hasura_WorkerConfig_Statuses_AggregateArgs = {
  distinct_on?: Maybe<Array<Config_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Config_Status_Order_By>>;
  where?: Maybe<Config_Status_Bool_Exp>;
};

/** Multi-tenant Hasura process capable of providing GraphQL APIs */
export type Hasura_WorkerTenant_StatusesArgs = {
  distinct_on?: Maybe<Array<Tenant_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Tenant_Status_Order_By>>;
  where?: Maybe<Tenant_Status_Bool_Exp>;
};

/** Multi-tenant Hasura process capable of providing GraphQL APIs */
export type Hasura_WorkerTenant_Statuses_AggregateArgs = {
  distinct_on?: Maybe<Array<Tenant_Status_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Tenant_Status_Order_By>>;
  where?: Maybe<Tenant_Status_Bool_Exp>;
};

/** aggregated selection of "hasura_worker" */
export type Hasura_Worker_Aggregate = {
  __typename?: 'hasura_worker_aggregate';
  aggregate?: Maybe<Hasura_Worker_Aggregate_Fields>;
  nodes: Array<Hasura_Worker>;
};

export type Hasura_Worker_Aggregate_Bool_Exp = {
  count?: Maybe<Hasura_Worker_Aggregate_Bool_Exp_Count>;
};

export type Hasura_Worker_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Hasura_Worker_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Hasura_Worker_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "hasura_worker" */
export type Hasura_Worker_Aggregate_Fields = {
  __typename?: 'hasura_worker_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Hasura_Worker_Max_Fields>;
  min?: Maybe<Hasura_Worker_Min_Fields>;
};

/** aggregate fields of "hasura_worker" */
export type Hasura_Worker_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Hasura_Worker_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "hasura_worker" */
export type Hasura_Worker_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Hasura_Worker_Max_Order_By>;
  min?: Maybe<Hasura_Worker_Min_Order_By>;
};

/** input type for inserting array relation for remote table "hasura_worker" */
export type Hasura_Worker_Arr_Rel_Insert_Input = {
  data: Array<Hasura_Worker_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Hasura_Worker_On_Conflict>;
};

/** Boolean expression to filter rows from the table "hasura_worker". All fields are combined with a logical 'AND'. */
export type Hasura_Worker_Bool_Exp = {
  _and?: Maybe<Array<Hasura_Worker_Bool_Exp>>;
  _not?: Maybe<Hasura_Worker_Bool_Exp>;
  _or?: Maybe<Array<Hasura_Worker_Bool_Exp>>;
  cloud?: Maybe<String_Comparison_Exp>;
  cluster?: Maybe<Hasura_Cluster_Bool_Exp>;
  cluster_id?: Maybe<Uuid_Comparison_Exp>;
  config_statuses?: Maybe<Config_Status_Bool_Exp>;
  config_statuses_aggregate?: Maybe<Config_Status_Aggregate_Bool_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  ip?: Maybe<String_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  slug?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  tenant_statuses?: Maybe<Tenant_Status_Bool_Exp>;
  tenant_statuses_aggregate?: Maybe<Tenant_Status_Aggregate_Bool_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  zone?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "hasura_worker" */
export enum Hasura_Worker_Constraint {
  /** unique or primary key constraint on columns "slug" */
  HasuraWorkerSlugKey = 'hasura_worker_slug_key',
  /** unique or primary key constraint on columns "id" */
  HasuraWorkersPkey = 'hasura_workers_pkey',
}

/** input type for inserting data into table "hasura_worker" */
export type Hasura_Worker_Insert_Input = {
  cloud?: Maybe<Scalars['String']>;
  cluster?: Maybe<Hasura_Cluster_Obj_Rel_Insert_Input>;
  cluster_id?: Maybe<Scalars['uuid']>;
  config_statuses?: Maybe<Config_Status_Arr_Rel_Insert_Input>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  ip?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  tenant_statuses?: Maybe<Tenant_Status_Arr_Rel_Insert_Input>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Hasura_Worker_Max_Fields = {
  __typename?: 'hasura_worker_max_fields';
  cloud?: Maybe<Scalars['String']>;
  cluster_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  ip?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** order by max() on columns of table "hasura_worker" */
export type Hasura_Worker_Max_Order_By = {
  cloud?: Maybe<Order_By>;
  cluster_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  ip?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  zone?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Hasura_Worker_Min_Fields = {
  __typename?: 'hasura_worker_min_fields';
  cloud?: Maybe<Scalars['String']>;
  cluster_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  ip?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** order by min() on columns of table "hasura_worker" */
export type Hasura_Worker_Min_Order_By = {
  cloud?: Maybe<Order_By>;
  cluster_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  ip?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  zone?: Maybe<Order_By>;
};

/** response of any mutation on the table "hasura_worker" */
export type Hasura_Worker_Mutation_Response = {
  __typename?: 'hasura_worker_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Hasura_Worker>;
};

/** on_conflict condition type for table "hasura_worker" */
export type Hasura_Worker_On_Conflict = {
  constraint: Hasura_Worker_Constraint;
  update_columns?: Array<Hasura_Worker_Update_Column>;
  where?: Maybe<Hasura_Worker_Bool_Exp>;
};

/** Ordering options when selecting data from "hasura_worker". */
export type Hasura_Worker_Order_By = {
  cloud?: Maybe<Order_By>;
  cluster?: Maybe<Hasura_Cluster_Order_By>;
  cluster_id?: Maybe<Order_By>;
  config_statuses_aggregate?: Maybe<Config_Status_Aggregate_Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  ip?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  slug?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  tenant_statuses_aggregate?: Maybe<Tenant_Status_Aggregate_Order_By>;
  updated_at?: Maybe<Order_By>;
  zone?: Maybe<Order_By>;
};

/** primary key columns input for table: hasura_worker */
export type Hasura_Worker_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "hasura_worker" */
export enum Hasura_Worker_Select_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  ClusterId = 'cluster_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Ip = 'ip',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Zone = 'zone',
}

/** input type for updating data in table "hasura_worker" */
export type Hasura_Worker_Set_Input = {
  cloud?: Maybe<Scalars['String']>;
  cluster_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  ip?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "hasura_worker" */
export type Hasura_Worker_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Hasura_Worker_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Hasura_Worker_Stream_Cursor_Value_Input = {
  cloud?: Maybe<Scalars['String']>;
  cluster_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  ip?: Maybe<Scalars['String']>;
  region?: Maybe<Scalars['String']>;
  slug?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  zone?: Maybe<Scalars['String']>;
};

/** View to visualize hasura workers and corresponding tenants */
export type Hasura_Worker_Tenants = {
  __typename?: 'hasura_worker_tenants';
  group_id?: Maybe<Scalars['uuid']>;
  hash?: Maybe<Scalars['String']>;
  policies?: Maybe<Scalars['json']>;
  port?: Maybe<Scalars['Int']>;
  /** An object relationship */
  tenant?: Maybe<Tenant>;
  tenant_id?: Maybe<Scalars['uuid']>;
  vault_path?: Maybe<Scalars['String']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** View to visualize hasura workers and corresponding tenants */
export type Hasura_Worker_TenantsPoliciesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Aggregate = {
  __typename?: 'hasura_worker_tenants_aggregate';
  aggregate?: Maybe<Hasura_Worker_Tenants_Aggregate_Fields>;
  nodes: Array<Hasura_Worker_Tenants>;
};

export type Hasura_Worker_Tenants_Aggregate_Bool_Exp = {
  count?: Maybe<Hasura_Worker_Tenants_Aggregate_Bool_Exp_Count>;
};

export type Hasura_Worker_Tenants_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Hasura_Worker_Tenants_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Hasura_Worker_Tenants_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Aggregate_Fields = {
  __typename?: 'hasura_worker_tenants_aggregate_fields';
  avg?: Maybe<Hasura_Worker_Tenants_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Hasura_Worker_Tenants_Max_Fields>;
  min?: Maybe<Hasura_Worker_Tenants_Min_Fields>;
  stddev?: Maybe<Hasura_Worker_Tenants_Stddev_Fields>;
  stddev_pop?: Maybe<Hasura_Worker_Tenants_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Hasura_Worker_Tenants_Stddev_Samp_Fields>;
  sum?: Maybe<Hasura_Worker_Tenants_Sum_Fields>;
  var_pop?: Maybe<Hasura_Worker_Tenants_Var_Pop_Fields>;
  var_samp?: Maybe<Hasura_Worker_Tenants_Var_Samp_Fields>;
  variance?: Maybe<Hasura_Worker_Tenants_Variance_Fields>;
};

/** aggregate fields of "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Hasura_Worker_Tenants_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Aggregate_Order_By = {
  avg?: Maybe<Hasura_Worker_Tenants_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Hasura_Worker_Tenants_Max_Order_By>;
  min?: Maybe<Hasura_Worker_Tenants_Min_Order_By>;
  stddev?: Maybe<Hasura_Worker_Tenants_Stddev_Order_By>;
  stddev_pop?: Maybe<Hasura_Worker_Tenants_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Hasura_Worker_Tenants_Stddev_Samp_Order_By>;
  sum?: Maybe<Hasura_Worker_Tenants_Sum_Order_By>;
  var_pop?: Maybe<Hasura_Worker_Tenants_Var_Pop_Order_By>;
  var_samp?: Maybe<Hasura_Worker_Tenants_Var_Samp_Order_By>;
  variance?: Maybe<Hasura_Worker_Tenants_Variance_Order_By>;
};

/** input type for inserting array relation for remote table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Arr_Rel_Insert_Input = {
  data: Array<Hasura_Worker_Tenants_Insert_Input>;
};

/** aggregate avg on columns */
export type Hasura_Worker_Tenants_Avg_Fields = {
  __typename?: 'hasura_worker_tenants_avg_fields';
  port?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Avg_Order_By = {
  port?: Maybe<Order_By>;
};

/** Boolean expression to filter rows from the table "hasura_worker_tenants". All fields are combined with a logical 'AND'. */
export type Hasura_Worker_Tenants_Bool_Exp = {
  _and?: Maybe<Array<Hasura_Worker_Tenants_Bool_Exp>>;
  _not?: Maybe<Hasura_Worker_Tenants_Bool_Exp>;
  _or?: Maybe<Array<Hasura_Worker_Tenants_Bool_Exp>>;
  group_id?: Maybe<Uuid_Comparison_Exp>;
  hash?: Maybe<String_Comparison_Exp>;
  policies?: Maybe<Json_Comparison_Exp>;
  port?: Maybe<Int_Comparison_Exp>;
  tenant?: Maybe<Tenant_Bool_Exp>;
  tenant_id?: Maybe<Uuid_Comparison_Exp>;
  vault_path?: Maybe<String_Comparison_Exp>;
  worker_id?: Maybe<Uuid_Comparison_Exp>;
};

/** input type for inserting data into table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Insert_Input = {
  group_id?: Maybe<Scalars['uuid']>;
  hash?: Maybe<Scalars['String']>;
  policies?: Maybe<Scalars['json']>;
  port?: Maybe<Scalars['Int']>;
  tenant?: Maybe<Tenant_Obj_Rel_Insert_Input>;
  tenant_id?: Maybe<Scalars['uuid']>;
  vault_path?: Maybe<Scalars['String']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Hasura_Worker_Tenants_Max_Fields = {
  __typename?: 'hasura_worker_tenants_max_fields';
  group_id?: Maybe<Scalars['uuid']>;
  hash?: Maybe<Scalars['String']>;
  port?: Maybe<Scalars['Int']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  vault_path?: Maybe<Scalars['String']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** order by max() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Max_Order_By = {
  group_id?: Maybe<Order_By>;
  hash?: Maybe<Order_By>;
  port?: Maybe<Order_By>;
  tenant_id?: Maybe<Order_By>;
  vault_path?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Hasura_Worker_Tenants_Min_Fields = {
  __typename?: 'hasura_worker_tenants_min_fields';
  group_id?: Maybe<Scalars['uuid']>;
  hash?: Maybe<Scalars['String']>;
  port?: Maybe<Scalars['Int']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  vault_path?: Maybe<Scalars['String']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** order by min() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Min_Order_By = {
  group_id?: Maybe<Order_By>;
  hash?: Maybe<Order_By>;
  port?: Maybe<Order_By>;
  tenant_id?: Maybe<Order_By>;
  vault_path?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** Ordering options when selecting data from "hasura_worker_tenants". */
export type Hasura_Worker_Tenants_Order_By = {
  group_id?: Maybe<Order_By>;
  hash?: Maybe<Order_By>;
  policies?: Maybe<Order_By>;
  port?: Maybe<Order_By>;
  tenant?: Maybe<Tenant_Order_By>;
  tenant_id?: Maybe<Order_By>;
  vault_path?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** select columns of table "hasura_worker_tenants" */
export enum Hasura_Worker_Tenants_Select_Column {
  /** column name */
  GroupId = 'group_id',
  /** column name */
  Hash = 'hash',
  /** column name */
  Policies = 'policies',
  /** column name */
  Port = 'port',
  /** column name */
  TenantId = 'tenant_id',
  /** column name */
  VaultPath = 'vault_path',
  /** column name */
  WorkerId = 'worker_id',
}

/** aggregate stddev on columns */
export type Hasura_Worker_Tenants_Stddev_Fields = {
  __typename?: 'hasura_worker_tenants_stddev_fields';
  port?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Stddev_Order_By = {
  port?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Hasura_Worker_Tenants_Stddev_Pop_Fields = {
  __typename?: 'hasura_worker_tenants_stddev_pop_fields';
  port?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Stddev_Pop_Order_By = {
  port?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Hasura_Worker_Tenants_Stddev_Samp_Fields = {
  __typename?: 'hasura_worker_tenants_stddev_samp_fields';
  port?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Stddev_Samp_Order_By = {
  port?: Maybe<Order_By>;
};

/** Streaming cursor of the table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Hasura_Worker_Tenants_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Hasura_Worker_Tenants_Stream_Cursor_Value_Input = {
  group_id?: Maybe<Scalars['uuid']>;
  hash?: Maybe<Scalars['String']>;
  policies?: Maybe<Scalars['json']>;
  port?: Maybe<Scalars['Int']>;
  tenant_id?: Maybe<Scalars['uuid']>;
  vault_path?: Maybe<Scalars['String']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** aggregate sum on columns */
export type Hasura_Worker_Tenants_Sum_Fields = {
  __typename?: 'hasura_worker_tenants_sum_fields';
  port?: Maybe<Scalars['Int']>;
};

/** order by sum() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Sum_Order_By = {
  port?: Maybe<Order_By>;
};

/** aggregate var_pop on columns */
export type Hasura_Worker_Tenants_Var_Pop_Fields = {
  __typename?: 'hasura_worker_tenants_var_pop_fields';
  port?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Var_Pop_Order_By = {
  port?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Hasura_Worker_Tenants_Var_Samp_Fields = {
  __typename?: 'hasura_worker_tenants_var_samp_fields';
  port?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Var_Samp_Order_By = {
  port?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Hasura_Worker_Tenants_Variance_Fields = {
  __typename?: 'hasura_worker_tenants_variance_fields';
  port?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "hasura_worker_tenants" */
export type Hasura_Worker_Tenants_Variance_Order_By = {
  port?: Maybe<Order_By>;
};

/** update columns of table "hasura_worker" */
export enum Hasura_Worker_Update_Column {
  /** column name */
  Cloud = 'cloud',
  /** column name */
  ClusterId = 'cluster_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Ip = 'ip',
  /** column name */
  Region = 'region',
  /** column name */
  Slug = 'slug',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Zone = 'zone',
}

export type Hasura_Worker_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Hasura_Worker_Set_Input>;
  /** filter the rows which have to be updated */
  where: Hasura_Worker_Bool_Exp;
};

/** heroku integration metadata (1.4+) */
export type Heroku_Integrations = {
  __typename?: 'heroku_integrations';
  /** The agent through which the integration is created */
  agent: Scalars['String'];
  app_id: Scalars['String'];
  app_name: Scalars['String'];
  created_at: Scalars['timestamptz'];
  /** An object relationship */
  project: Projects;
  project_id: Scalars['uuid'];
  updated_at: Scalars['timestamptz'];
  var_name: Scalars['String'];
  webhook_id?: Maybe<Scalars['String']>;
};

/** aggregated selection of "heroku_integrations" */
export type Heroku_Integrations_Aggregate = {
  __typename?: 'heroku_integrations_aggregate';
  aggregate?: Maybe<Heroku_Integrations_Aggregate_Fields>;
  nodes: Array<Heroku_Integrations>;
};

export type Heroku_Integrations_Aggregate_Bool_Exp = {
  count?: Maybe<Heroku_Integrations_Aggregate_Bool_Exp_Count>;
};

export type Heroku_Integrations_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Heroku_Integrations_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Heroku_Integrations_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "heroku_integrations" */
export type Heroku_Integrations_Aggregate_Fields = {
  __typename?: 'heroku_integrations_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Heroku_Integrations_Max_Fields>;
  min?: Maybe<Heroku_Integrations_Min_Fields>;
};

/** aggregate fields of "heroku_integrations" */
export type Heroku_Integrations_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Heroku_Integrations_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "heroku_integrations" */
export type Heroku_Integrations_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Heroku_Integrations_Max_Order_By>;
  min?: Maybe<Heroku_Integrations_Min_Order_By>;
};

/** input type for inserting array relation for remote table "heroku_integrations" */
export type Heroku_Integrations_Arr_Rel_Insert_Input = {
  data: Array<Heroku_Integrations_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Heroku_Integrations_On_Conflict>;
};

/** Boolean expression to filter rows from the table "heroku_integrations". All fields are combined with a logical 'AND'. */
export type Heroku_Integrations_Bool_Exp = {
  _and?: Maybe<Array<Heroku_Integrations_Bool_Exp>>;
  _not?: Maybe<Heroku_Integrations_Bool_Exp>;
  _or?: Maybe<Array<Heroku_Integrations_Bool_Exp>>;
  agent?: Maybe<String_Comparison_Exp>;
  app_id?: Maybe<String_Comparison_Exp>;
  app_name?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  var_name?: Maybe<String_Comparison_Exp>;
  webhook_id?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "heroku_integrations" */
export enum Heroku_Integrations_Constraint {
  /** unique or primary key constraint on columns "project_id", "var_name" */
  HerokuIntegrationsPkey = 'heroku_integrations_pkey',
}

/** input type for inserting data into table "heroku_integrations" */
export type Heroku_Integrations_Insert_Input = {
  /** The agent through which the integration is created */
  agent?: Maybe<Scalars['String']>;
  app_id?: Maybe<Scalars['String']>;
  app_name?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  var_name?: Maybe<Scalars['String']>;
  webhook_id?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Heroku_Integrations_Max_Fields = {
  __typename?: 'heroku_integrations_max_fields';
  /** The agent through which the integration is created */
  agent?: Maybe<Scalars['String']>;
  app_id?: Maybe<Scalars['String']>;
  app_name?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  var_name?: Maybe<Scalars['String']>;
  webhook_id?: Maybe<Scalars['String']>;
};

/** order by max() on columns of table "heroku_integrations" */
export type Heroku_Integrations_Max_Order_By = {
  /** The agent through which the integration is created */
  agent?: Maybe<Order_By>;
  app_id?: Maybe<Order_By>;
  app_name?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  var_name?: Maybe<Order_By>;
  webhook_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Heroku_Integrations_Min_Fields = {
  __typename?: 'heroku_integrations_min_fields';
  /** The agent through which the integration is created */
  agent?: Maybe<Scalars['String']>;
  app_id?: Maybe<Scalars['String']>;
  app_name?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  var_name?: Maybe<Scalars['String']>;
  webhook_id?: Maybe<Scalars['String']>;
};

/** order by min() on columns of table "heroku_integrations" */
export type Heroku_Integrations_Min_Order_By = {
  /** The agent through which the integration is created */
  agent?: Maybe<Order_By>;
  app_id?: Maybe<Order_By>;
  app_name?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  var_name?: Maybe<Order_By>;
  webhook_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "heroku_integrations" */
export type Heroku_Integrations_Mutation_Response = {
  __typename?: 'heroku_integrations_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Heroku_Integrations>;
};

/** on_conflict condition type for table "heroku_integrations" */
export type Heroku_Integrations_On_Conflict = {
  constraint: Heroku_Integrations_Constraint;
  update_columns?: Array<Heroku_Integrations_Update_Column>;
  where?: Maybe<Heroku_Integrations_Bool_Exp>;
};

/** Ordering options when selecting data from "heroku_integrations". */
export type Heroku_Integrations_Order_By = {
  agent?: Maybe<Order_By>;
  app_id?: Maybe<Order_By>;
  app_name?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  var_name?: Maybe<Order_By>;
  webhook_id?: Maybe<Order_By>;
};

/** primary key columns input for table: heroku_integrations */
export type Heroku_Integrations_Pk_Columns_Input = {
  project_id: Scalars['uuid'];
  var_name: Scalars['String'];
};

/** select columns of table "heroku_integrations" */
export enum Heroku_Integrations_Select_Column {
  /** column name */
  Agent = 'agent',
  /** column name */
  AppId = 'app_id',
  /** column name */
  AppName = 'app_name',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  VarName = 'var_name',
  /** column name */
  WebhookId = 'webhook_id',
}

/** input type for updating data in table "heroku_integrations" */
export type Heroku_Integrations_Set_Input = {
  /** The agent through which the integration is created */
  agent?: Maybe<Scalars['String']>;
  app_id?: Maybe<Scalars['String']>;
  app_name?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  var_name?: Maybe<Scalars['String']>;
  webhook_id?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "heroku_integrations" */
export type Heroku_Integrations_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Heroku_Integrations_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Heroku_Integrations_Stream_Cursor_Value_Input = {
  /** The agent through which the integration is created */
  agent?: Maybe<Scalars['String']>;
  app_id?: Maybe<Scalars['String']>;
  app_name?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  var_name?: Maybe<Scalars['String']>;
  webhook_id?: Maybe<Scalars['String']>;
};

/** update columns of table "heroku_integrations" */
export enum Heroku_Integrations_Update_Column {
  /** column name */
  Agent = 'agent',
  /** column name */
  AppId = 'app_id',
  /** column name */
  AppName = 'app_name',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  VarName = 'var_name',
  /** column name */
  WebhookId = 'webhook_id',
}

export type Heroku_Integrations_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Heroku_Integrations_Set_Input>;
  /** filter the rows which have to be updated */
  where: Heroku_Integrations_Bool_Exp;
};

export type HerokuSession = {
  __typename?: 'HerokuSession';
  access_token: Scalars['String'];
  expires_in: Scalars['Int'];
  refresh_token: Scalars['String'];
  token_type: Scalars['String'];
};

export type HerokuSessionStatus = {
  __typename?: 'HerokuSessionStatus';
  status: Scalars['String'];
};

export type HerokuTokenExchangeInput = {
  type: HerokuTokenExchangeType;
  value: Scalars['String'];
};

export enum HerokuTokenExchangeType {
  Code = 'code',
  Refresh = 'refresh',
}

/** Records projects that are excluded from suspension */
export type Inactive_Project_Exclusions = {
  __typename?: 'inactive_project_exclusions';
  /** An object relationship */
  project: Projects;
  project_id: Scalars['uuid'];
};

/** aggregated selection of "inactive_project_exclusions" */
export type Inactive_Project_Exclusions_Aggregate = {
  __typename?: 'inactive_project_exclusions_aggregate';
  aggregate?: Maybe<Inactive_Project_Exclusions_Aggregate_Fields>;
  nodes: Array<Inactive_Project_Exclusions>;
};

/** aggregate fields of "inactive_project_exclusions" */
export type Inactive_Project_Exclusions_Aggregate_Fields = {
  __typename?: 'inactive_project_exclusions_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Inactive_Project_Exclusions_Max_Fields>;
  min?: Maybe<Inactive_Project_Exclusions_Min_Fields>;
};

/** aggregate fields of "inactive_project_exclusions" */
export type Inactive_Project_Exclusions_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Inactive_Project_Exclusions_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/**
 * Boolean expression to filter rows from the table "inactive_project_exclusions".
 * All fields are combined with a logical 'AND'.
 */
export type Inactive_Project_Exclusions_Bool_Exp = {
  _and?: Maybe<Array<Inactive_Project_Exclusions_Bool_Exp>>;
  _not?: Maybe<Inactive_Project_Exclusions_Bool_Exp>;
  _or?: Maybe<Array<Inactive_Project_Exclusions_Bool_Exp>>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "inactive_project_exclusions" */
export enum Inactive_Project_Exclusions_Constraint {
  /** unique or primary key constraint on columns "project_id" */
  InactiveProjectExclusionsPkey = 'inactive_project_exclusions_pkey',
}

/** input type for inserting data into table "inactive_project_exclusions" */
export type Inactive_Project_Exclusions_Insert_Input = {
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Inactive_Project_Exclusions_Max_Fields = {
  __typename?: 'inactive_project_exclusions_max_fields';
  project_id?: Maybe<Scalars['uuid']>;
};

/** aggregate min on columns */
export type Inactive_Project_Exclusions_Min_Fields = {
  __typename?: 'inactive_project_exclusions_min_fields';
  project_id?: Maybe<Scalars['uuid']>;
};

/** response of any mutation on the table "inactive_project_exclusions" */
export type Inactive_Project_Exclusions_Mutation_Response = {
  __typename?: 'inactive_project_exclusions_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Inactive_Project_Exclusions>;
};

/** on_conflict condition type for table "inactive_project_exclusions" */
export type Inactive_Project_Exclusions_On_Conflict = {
  constraint: Inactive_Project_Exclusions_Constraint;
  update_columns?: Array<Inactive_Project_Exclusions_Update_Column>;
  where?: Maybe<Inactive_Project_Exclusions_Bool_Exp>;
};

/** Ordering options when selecting data from "inactive_project_exclusions". */
export type Inactive_Project_Exclusions_Order_By = {
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
};

/** primary key columns input for table: inactive_project_exclusions */
export type Inactive_Project_Exclusions_Pk_Columns_Input = {
  project_id: Scalars['uuid'];
};

/** select columns of table "inactive_project_exclusions" */
export enum Inactive_Project_Exclusions_Select_Column {
  /** column name */
  ProjectId = 'project_id',
}

/** input type for updating data in table "inactive_project_exclusions" */
export type Inactive_Project_Exclusions_Set_Input = {
  project_id?: Maybe<Scalars['uuid']>;
};

/** Streaming cursor of the table "inactive_project_exclusions" */
export type Inactive_Project_Exclusions_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Inactive_Project_Exclusions_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Inactive_Project_Exclusions_Stream_Cursor_Value_Input = {
  project_id?: Maybe<Scalars['uuid']>;
};

/** update columns of table "inactive_project_exclusions" */
export enum Inactive_Project_Exclusions_Update_Column {
  /** column name */
  ProjectId = 'project_id',
}

export type Inactive_Project_Exclusions_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Inactive_Project_Exclusions_Set_Input>;
  /** filter the rows which have to be updated */
  where: Inactive_Project_Exclusions_Bool_Exp;
};

/** Records when the user has been notified about their projects being inactive */
export type Inactive_Project_Notifications = {
  __typename?: 'inactive_project_notifications';
  active: Scalars['Boolean'];
  id: Scalars['Int'];
  is_legacy_schedule: Scalars['Boolean'];
  /** An object relationship */
  owner: Users;
  owner_id: Scalars['uuid'];
  /** An object relationship */
  project: Projects;
  project_id: Scalars['uuid'];
  sent_at: Scalars['timestamp'];
};

/** aggregated selection of "inactive_project_notifications" */
export type Inactive_Project_Notifications_Aggregate = {
  __typename?: 'inactive_project_notifications_aggregate';
  aggregate?: Maybe<Inactive_Project_Notifications_Aggregate_Fields>;
  nodes: Array<Inactive_Project_Notifications>;
};

/** aggregate fields of "inactive_project_notifications" */
export type Inactive_Project_Notifications_Aggregate_Fields = {
  __typename?: 'inactive_project_notifications_aggregate_fields';
  avg?: Maybe<Inactive_Project_Notifications_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Inactive_Project_Notifications_Max_Fields>;
  min?: Maybe<Inactive_Project_Notifications_Min_Fields>;
  stddev?: Maybe<Inactive_Project_Notifications_Stddev_Fields>;
  stddev_pop?: Maybe<Inactive_Project_Notifications_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Inactive_Project_Notifications_Stddev_Samp_Fields>;
  sum?: Maybe<Inactive_Project_Notifications_Sum_Fields>;
  var_pop?: Maybe<Inactive_Project_Notifications_Var_Pop_Fields>;
  var_samp?: Maybe<Inactive_Project_Notifications_Var_Samp_Fields>;
  variance?: Maybe<Inactive_Project_Notifications_Variance_Fields>;
};

/** aggregate fields of "inactive_project_notifications" */
export type Inactive_Project_Notifications_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Inactive_Project_Notifications_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Inactive_Project_Notifications_Avg_Fields = {
  __typename?: 'inactive_project_notifications_avg_fields';
  id?: Maybe<Scalars['Float']>;
};

/**
 * Boolean expression to filter rows from the table
 * "inactive_project_notifications". All fields are combined with a logical 'AND'.
 */
export type Inactive_Project_Notifications_Bool_Exp = {
  _and?: Maybe<Array<Inactive_Project_Notifications_Bool_Exp>>;
  _not?: Maybe<Inactive_Project_Notifications_Bool_Exp>;
  _or?: Maybe<Array<Inactive_Project_Notifications_Bool_Exp>>;
  active?: Maybe<Boolean_Comparison_Exp>;
  id?: Maybe<Int_Comparison_Exp>;
  is_legacy_schedule?: Maybe<Boolean_Comparison_Exp>;
  owner?: Maybe<Users_Bool_Exp>;
  owner_id?: Maybe<Uuid_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  sent_at?: Maybe<Timestamp_Comparison_Exp>;
};

/** unique or primary key constraints on table "inactive_project_notifications" */
export enum Inactive_Project_Notifications_Constraint {
  /** unique or primary key constraint on columns "id" */
  InactiveProjectNotificationsPkey = 'inactive_project_notifications_pkey',
}

/** input type for incrementing numeric columns in table "inactive_project_notifications" */
export type Inactive_Project_Notifications_Inc_Input = {
  id?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "inactive_project_notifications" */
export type Inactive_Project_Notifications_Insert_Input = {
  active?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['Int']>;
  is_legacy_schedule?: Maybe<Scalars['Boolean']>;
  owner?: Maybe<Users_Obj_Rel_Insert_Input>;
  owner_id?: Maybe<Scalars['uuid']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  sent_at?: Maybe<Scalars['timestamp']>;
};

/** aggregate max on columns */
export type Inactive_Project_Notifications_Max_Fields = {
  __typename?: 'inactive_project_notifications_max_fields';
  id?: Maybe<Scalars['Int']>;
  owner_id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
  sent_at?: Maybe<Scalars['timestamp']>;
};

/** aggregate min on columns */
export type Inactive_Project_Notifications_Min_Fields = {
  __typename?: 'inactive_project_notifications_min_fields';
  id?: Maybe<Scalars['Int']>;
  owner_id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
  sent_at?: Maybe<Scalars['timestamp']>;
};

/** response of any mutation on the table "inactive_project_notifications" */
export type Inactive_Project_Notifications_Mutation_Response = {
  __typename?: 'inactive_project_notifications_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Inactive_Project_Notifications>;
};

/** on_conflict condition type for table "inactive_project_notifications" */
export type Inactive_Project_Notifications_On_Conflict = {
  constraint: Inactive_Project_Notifications_Constraint;
  update_columns?: Array<Inactive_Project_Notifications_Update_Column>;
  where?: Maybe<Inactive_Project_Notifications_Bool_Exp>;
};

/** Ordering options when selecting data from "inactive_project_notifications". */
export type Inactive_Project_Notifications_Order_By = {
  active?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  is_legacy_schedule?: Maybe<Order_By>;
  owner?: Maybe<Users_Order_By>;
  owner_id?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  sent_at?: Maybe<Order_By>;
};

/** primary key columns input for table: inactive_project_notifications */
export type Inactive_Project_Notifications_Pk_Columns_Input = {
  id: Scalars['Int'];
};

/** select columns of table "inactive_project_notifications" */
export enum Inactive_Project_Notifications_Select_Column {
  /** column name */
  Active = 'active',
  /** column name */
  Id = 'id',
  /** column name */
  IsLegacySchedule = 'is_legacy_schedule',
  /** column name */
  OwnerId = 'owner_id',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  SentAt = 'sent_at',
}

/** input type for updating data in table "inactive_project_notifications" */
export type Inactive_Project_Notifications_Set_Input = {
  active?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['Int']>;
  is_legacy_schedule?: Maybe<Scalars['Boolean']>;
  owner_id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
  sent_at?: Maybe<Scalars['timestamp']>;
};

/** aggregate stddev on columns */
export type Inactive_Project_Notifications_Stddev_Fields = {
  __typename?: 'inactive_project_notifications_stddev_fields';
  id?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Inactive_Project_Notifications_Stddev_Pop_Fields = {
  __typename?: 'inactive_project_notifications_stddev_pop_fields';
  id?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Inactive_Project_Notifications_Stddev_Samp_Fields = {
  __typename?: 'inactive_project_notifications_stddev_samp_fields';
  id?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "inactive_project_notifications" */
export type Inactive_Project_Notifications_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Inactive_Project_Notifications_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Inactive_Project_Notifications_Stream_Cursor_Value_Input = {
  active?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['Int']>;
  is_legacy_schedule?: Maybe<Scalars['Boolean']>;
  owner_id?: Maybe<Scalars['uuid']>;
  project_id?: Maybe<Scalars['uuid']>;
  sent_at?: Maybe<Scalars['timestamp']>;
};

/** aggregate sum on columns */
export type Inactive_Project_Notifications_Sum_Fields = {
  __typename?: 'inactive_project_notifications_sum_fields';
  id?: Maybe<Scalars['Int']>;
};

/** update columns of table "inactive_project_notifications" */
export enum Inactive_Project_Notifications_Update_Column {
  /** column name */
  Active = 'active',
  /** column name */
  Id = 'id',
  /** column name */
  IsLegacySchedule = 'is_legacy_schedule',
  /** column name */
  OwnerId = 'owner_id',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  SentAt = 'sent_at',
}

export type Inactive_Project_Notifications_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Inactive_Project_Notifications_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Inactive_Project_Notifications_Set_Input>;
  /** filter the rows which have to be updated */
  where: Inactive_Project_Notifications_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Inactive_Project_Notifications_Var_Pop_Fields = {
  __typename?: 'inactive_project_notifications_var_pop_fields';
  id?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Inactive_Project_Notifications_Var_Samp_Fields = {
  __typename?: 'inactive_project_notifications_var_samp_fields';
  id?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Inactive_Project_Notifications_Variance_Fields = {
  __typename?: 'inactive_project_notifications_variance_fields';
  id?: Maybe<Scalars['Float']>;
};

/** Allows for progressive rollout of inactive_project_suspension. App code will take latest record to base their decisions */
export type Inactive_Project_Suspension_Config = {
  __typename?: 'inactive_project_suspension_config';
  created_at: Scalars['timestamp'];
  enabled_per_thousand?: Maybe<Scalars['Int']>;
};

/** aggregated selection of "inactive_project_suspension_config" */
export type Inactive_Project_Suspension_Config_Aggregate = {
  __typename?: 'inactive_project_suspension_config_aggregate';
  aggregate?: Maybe<Inactive_Project_Suspension_Config_Aggregate_Fields>;
  nodes: Array<Inactive_Project_Suspension_Config>;
};

/** aggregate fields of "inactive_project_suspension_config" */
export type Inactive_Project_Suspension_Config_Aggregate_Fields = {
  __typename?: 'inactive_project_suspension_config_aggregate_fields';
  avg?: Maybe<Inactive_Project_Suspension_Config_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Inactive_Project_Suspension_Config_Max_Fields>;
  min?: Maybe<Inactive_Project_Suspension_Config_Min_Fields>;
  stddev?: Maybe<Inactive_Project_Suspension_Config_Stddev_Fields>;
  stddev_pop?: Maybe<Inactive_Project_Suspension_Config_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Inactive_Project_Suspension_Config_Stddev_Samp_Fields>;
  sum?: Maybe<Inactive_Project_Suspension_Config_Sum_Fields>;
  var_pop?: Maybe<Inactive_Project_Suspension_Config_Var_Pop_Fields>;
  var_samp?: Maybe<Inactive_Project_Suspension_Config_Var_Samp_Fields>;
  variance?: Maybe<Inactive_Project_Suspension_Config_Variance_Fields>;
};

/** aggregate fields of "inactive_project_suspension_config" */
export type Inactive_Project_Suspension_Config_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Inactive_Project_Suspension_Config_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Inactive_Project_Suspension_Config_Avg_Fields = {
  __typename?: 'inactive_project_suspension_config_avg_fields';
  enabled_per_thousand?: Maybe<Scalars['Float']>;
};

/**
 * Boolean expression to filter rows from the table
 * "inactive_project_suspension_config". All fields are combined with a logical 'AND'.
 */
export type Inactive_Project_Suspension_Config_Bool_Exp = {
  _and?: Maybe<Array<Inactive_Project_Suspension_Config_Bool_Exp>>;
  _not?: Maybe<Inactive_Project_Suspension_Config_Bool_Exp>;
  _or?: Maybe<Array<Inactive_Project_Suspension_Config_Bool_Exp>>;
  created_at?: Maybe<Timestamp_Comparison_Exp>;
  enabled_per_thousand?: Maybe<Int_Comparison_Exp>;
};

/** input type for incrementing numeric columns in table "inactive_project_suspension_config" */
export type Inactive_Project_Suspension_Config_Inc_Input = {
  enabled_per_thousand?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "inactive_project_suspension_config" */
export type Inactive_Project_Suspension_Config_Insert_Input = {
  created_at?: Maybe<Scalars['timestamp']>;
  enabled_per_thousand?: Maybe<Scalars['Int']>;
};

/** aggregate max on columns */
export type Inactive_Project_Suspension_Config_Max_Fields = {
  __typename?: 'inactive_project_suspension_config_max_fields';
  created_at?: Maybe<Scalars['timestamp']>;
  enabled_per_thousand?: Maybe<Scalars['Int']>;
};

/** aggregate min on columns */
export type Inactive_Project_Suspension_Config_Min_Fields = {
  __typename?: 'inactive_project_suspension_config_min_fields';
  created_at?: Maybe<Scalars['timestamp']>;
  enabled_per_thousand?: Maybe<Scalars['Int']>;
};

/** response of any mutation on the table "inactive_project_suspension_config" */
export type Inactive_Project_Suspension_Config_Mutation_Response = {
  __typename?: 'inactive_project_suspension_config_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Inactive_Project_Suspension_Config>;
};

/** Ordering options when selecting data from "inactive_project_suspension_config". */
export type Inactive_Project_Suspension_Config_Order_By = {
  created_at?: Maybe<Order_By>;
  enabled_per_thousand?: Maybe<Order_By>;
};

/** select columns of table "inactive_project_suspension_config" */
export enum Inactive_Project_Suspension_Config_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  EnabledPerThousand = 'enabled_per_thousand',
}

/** input type for updating data in table "inactive_project_suspension_config" */
export type Inactive_Project_Suspension_Config_Set_Input = {
  created_at?: Maybe<Scalars['timestamp']>;
  enabled_per_thousand?: Maybe<Scalars['Int']>;
};

/** aggregate stddev on columns */
export type Inactive_Project_Suspension_Config_Stddev_Fields = {
  __typename?: 'inactive_project_suspension_config_stddev_fields';
  enabled_per_thousand?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Inactive_Project_Suspension_Config_Stddev_Pop_Fields = {
  __typename?: 'inactive_project_suspension_config_stddev_pop_fields';
  enabled_per_thousand?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Inactive_Project_Suspension_Config_Stddev_Samp_Fields = {
  __typename?: 'inactive_project_suspension_config_stddev_samp_fields';
  enabled_per_thousand?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "inactive_project_suspension_config" */
export type Inactive_Project_Suspension_Config_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Inactive_Project_Suspension_Config_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Inactive_Project_Suspension_Config_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamp']>;
  enabled_per_thousand?: Maybe<Scalars['Int']>;
};

/** aggregate sum on columns */
export type Inactive_Project_Suspension_Config_Sum_Fields = {
  __typename?: 'inactive_project_suspension_config_sum_fields';
  enabled_per_thousand?: Maybe<Scalars['Int']>;
};

export type Inactive_Project_Suspension_Config_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Inactive_Project_Suspension_Config_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Inactive_Project_Suspension_Config_Set_Input>;
  /** filter the rows which have to be updated */
  where: Inactive_Project_Suspension_Config_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Inactive_Project_Suspension_Config_Var_Pop_Fields = {
  __typename?: 'inactive_project_suspension_config_var_pop_fields';
  enabled_per_thousand?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Inactive_Project_Suspension_Config_Var_Samp_Fields = {
  __typename?: 'inactive_project_suspension_config_var_samp_fields';
  enabled_per_thousand?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Inactive_Project_Suspension_Config_Variance_Fields = {
  __typename?: 'inactive_project_suspension_config_variance_fields';
  enabled_per_thousand?: Maybe<Scalars['Float']>;
};

/** Free Projects with at least 25 days of continuous inactivity without a notification in at least 7 days */
export type Inactive_Projects = {
  __typename?: 'inactive_projects';
  inactive_since?: Maybe<Scalars['timestamptz']>;
  is_legacy_schedule?: Maybe<Scalars['Boolean']>;
  latest_notified?: Maybe<Scalars['timestamptz']>;
  /** An object relationship */
  project?: Maybe<Projects>;
  project_created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  times_notified?: Maybe<Scalars['bigint']>;
};

/** aggregated selection of "inactive_projects" */
export type Inactive_Projects_Aggregate = {
  __typename?: 'inactive_projects_aggregate';
  aggregate?: Maybe<Inactive_Projects_Aggregate_Fields>;
  nodes: Array<Inactive_Projects>;
};

/** aggregate fields of "inactive_projects" */
export type Inactive_Projects_Aggregate_Fields = {
  __typename?: 'inactive_projects_aggregate_fields';
  avg?: Maybe<Inactive_Projects_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Inactive_Projects_Max_Fields>;
  min?: Maybe<Inactive_Projects_Min_Fields>;
  stddev?: Maybe<Inactive_Projects_Stddev_Fields>;
  stddev_pop?: Maybe<Inactive_Projects_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Inactive_Projects_Stddev_Samp_Fields>;
  sum?: Maybe<Inactive_Projects_Sum_Fields>;
  var_pop?: Maybe<Inactive_Projects_Var_Pop_Fields>;
  var_samp?: Maybe<Inactive_Projects_Var_Samp_Fields>;
  variance?: Maybe<Inactive_Projects_Variance_Fields>;
};

/** aggregate fields of "inactive_projects" */
export type Inactive_Projects_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Inactive_Projects_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** aggregate avg on columns */
export type Inactive_Projects_Avg_Fields = {
  __typename?: 'inactive_projects_avg_fields';
  times_notified?: Maybe<Scalars['Float']>;
};

/** Boolean expression to filter rows from the table "inactive_projects". All fields are combined with a logical 'AND'. */
export type Inactive_Projects_Bool_Exp = {
  _and?: Maybe<Array<Inactive_Projects_Bool_Exp>>;
  _not?: Maybe<Inactive_Projects_Bool_Exp>;
  _or?: Maybe<Array<Inactive_Projects_Bool_Exp>>;
  inactive_since?: Maybe<Timestamptz_Comparison_Exp>;
  is_legacy_schedule?: Maybe<Boolean_Comparison_Exp>;
  latest_notified?: Maybe<Timestamptz_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_created_at?: Maybe<Timestamptz_Comparison_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  times_notified?: Maybe<Bigint_Comparison_Exp>;
};

/** aggregate max on columns */
export type Inactive_Projects_Max_Fields = {
  __typename?: 'inactive_projects_max_fields';
  inactive_since?: Maybe<Scalars['timestamptz']>;
  latest_notified?: Maybe<Scalars['timestamptz']>;
  project_created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  times_notified?: Maybe<Scalars['bigint']>;
};

/** aggregate min on columns */
export type Inactive_Projects_Min_Fields = {
  __typename?: 'inactive_projects_min_fields';
  inactive_since?: Maybe<Scalars['timestamptz']>;
  latest_notified?: Maybe<Scalars['timestamptz']>;
  project_created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  times_notified?: Maybe<Scalars['bigint']>;
};

/** Ordering options when selecting data from "inactive_projects". */
export type Inactive_Projects_Order_By = {
  inactive_since?: Maybe<Order_By>;
  is_legacy_schedule?: Maybe<Order_By>;
  latest_notified?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_created_at?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  times_notified?: Maybe<Order_By>;
};

/** select columns of table "inactive_projects" */
export enum Inactive_Projects_Select_Column {
  /** column name */
  InactiveSince = 'inactive_since',
  /** column name */
  IsLegacySchedule = 'is_legacy_schedule',
  /** column name */
  LatestNotified = 'latest_notified',
  /** column name */
  ProjectCreatedAt = 'project_created_at',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  TimesNotified = 'times_notified',
}

/** aggregate stddev on columns */
export type Inactive_Projects_Stddev_Fields = {
  __typename?: 'inactive_projects_stddev_fields';
  times_notified?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_pop on columns */
export type Inactive_Projects_Stddev_Pop_Fields = {
  __typename?: 'inactive_projects_stddev_pop_fields';
  times_notified?: Maybe<Scalars['Float']>;
};

/** aggregate stddev_samp on columns */
export type Inactive_Projects_Stddev_Samp_Fields = {
  __typename?: 'inactive_projects_stddev_samp_fields';
  times_notified?: Maybe<Scalars['Float']>;
};

/** Streaming cursor of the table "inactive_projects" */
export type Inactive_Projects_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Inactive_Projects_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Inactive_Projects_Stream_Cursor_Value_Input = {
  inactive_since?: Maybe<Scalars['timestamptz']>;
  is_legacy_schedule?: Maybe<Scalars['Boolean']>;
  latest_notified?: Maybe<Scalars['timestamptz']>;
  project_created_at?: Maybe<Scalars['timestamptz']>;
  project_id?: Maybe<Scalars['uuid']>;
  times_notified?: Maybe<Scalars['bigint']>;
};

/** aggregate sum on columns */
export type Inactive_Projects_Sum_Fields = {
  __typename?: 'inactive_projects_sum_fields';
  times_notified?: Maybe<Scalars['bigint']>;
};

/** aggregate var_pop on columns */
export type Inactive_Projects_Var_Pop_Fields = {
  __typename?: 'inactive_projects_var_pop_fields';
  times_notified?: Maybe<Scalars['Float']>;
};

/** aggregate var_samp on columns */
export type Inactive_Projects_Var_Samp_Fields = {
  __typename?: 'inactive_projects_var_samp_fields';
  times_notified?: Maybe<Scalars['Float']>;
};

/** aggregate variance on columns */
export type Inactive_Projects_Variance_Fields = {
  __typename?: 'inactive_projects_variance_fields';
  times_notified?: Maybe<Scalars['Float']>;
};

/** Hasura enum capturing the Terraform status of infra */
export type Infra_Status = {
  __typename?: 'infra_status';
  comment?: Maybe<Scalars['String']>;
  status: Scalars['String'];
};

/** aggregated selection of "infra_status" */
export type Infra_Status_Aggregate = {
  __typename?: 'infra_status_aggregate';
  aggregate?: Maybe<Infra_Status_Aggregate_Fields>;
  nodes: Array<Infra_Status>;
};

/** aggregate fields of "infra_status" */
export type Infra_Status_Aggregate_Fields = {
  __typename?: 'infra_status_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Infra_Status_Max_Fields>;
  min?: Maybe<Infra_Status_Min_Fields>;
};

/** aggregate fields of "infra_status" */
export type Infra_Status_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Infra_Status_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "infra_status". All fields are combined with a logical 'AND'. */
export type Infra_Status_Bool_Exp = {
  _and?: Maybe<Array<Infra_Status_Bool_Exp>>;
  _not?: Maybe<Infra_Status_Bool_Exp>;
  _or?: Maybe<Array<Infra_Status_Bool_Exp>>;
  comment?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "infra_status" */
export enum Infra_Status_Constraint {
  /** unique or primary key constraint on columns "status" */
  InfraStatusPkey = 'infra_status_pkey',
}

export enum Infra_Status_Enum {
  /** Changes have been applied */
  Applied = 'applied',
  /** Failed to apply changes to infra */
  ApplyFailed = 'apply_failed',
  /** Destroying infra failed */
  DestroyFailed = 'destroy_failed',
  /** Infra has been destroyed */
  Destroyed = 'destroyed',
  /** Waiting for the terraform apply */
  PendingApply = 'pending_apply',
  /** Waiting for the terraform destroy */
  PendingDestroy = 'pending_destroy',
}

/** Boolean expression to compare columns of type "infra_status_enum". All fields are combined with logical 'AND'. */
export type Infra_Status_Enum_Comparison_Exp = {
  _eq?: Maybe<Infra_Status_Enum>;
  _in?: Maybe<Array<Infra_Status_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<Infra_Status_Enum>;
  _nin?: Maybe<Array<Infra_Status_Enum>>;
};

/** input type for inserting data into table "infra_status" */
export type Infra_Status_Insert_Input = {
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Infra_Status_Max_Fields = {
  __typename?: 'infra_status_max_fields';
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Infra_Status_Min_Fields = {
  __typename?: 'infra_status_min_fields';
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "infra_status" */
export type Infra_Status_Mutation_Response = {
  __typename?: 'infra_status_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Infra_Status>;
};

/** on_conflict condition type for table "infra_status" */
export type Infra_Status_On_Conflict = {
  constraint: Infra_Status_Constraint;
  update_columns?: Array<Infra_Status_Update_Column>;
  where?: Maybe<Infra_Status_Bool_Exp>;
};

/** Ordering options when selecting data from "infra_status". */
export type Infra_Status_Order_By = {
  comment?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
};

/** primary key columns input for table: infra_status */
export type Infra_Status_Pk_Columns_Input = {
  status: Scalars['String'];
};

/** select columns of table "infra_status" */
export enum Infra_Status_Select_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Status = 'status',
}

/** input type for updating data in table "infra_status" */
export type Infra_Status_Set_Input = {
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "infra_status" */
export type Infra_Status_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Infra_Status_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Infra_Status_Stream_Cursor_Value_Input = {
  comment?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
};

/** update columns of table "infra_status" */
export enum Infra_Status_Update_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Status = 'status',
}

export type Infra_Status_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Infra_Status_Set_Input>;
  /** filter the rows which have to be updated */
  where: Infra_Status_Bool_Exp;
};

export type Insert_Db_Usage_Args = {
  created_ats?: Maybe<Scalars['_date']>;
  no_db_usages?: Maybe<Scalars['_int4']>;
  non_pg_usages?: Maybe<Scalars['_int4']>;
  pg_usages?: Maybe<Scalars['_int4']>;
  prices?: Maybe<Scalars['_int8']>;
  project_ids?: Maybe<Scalars['_uuid']>;
};

/** Boolean expression to compare columns of type "Int". All fields are combined with logical 'AND'. */
export type Int_Comparison_Exp = {
  _eq?: Maybe<Scalars['Int']>;
  _gt?: Maybe<Scalars['Int']>;
  _gte?: Maybe<Scalars['Int']>;
  _in?: Maybe<Array<Scalars['Int']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['Int']>;
  _lte?: Maybe<Scalars['Int']>;
  _neq?: Maybe<Scalars['Int']>;
  _nin?: Maybe<Array<Scalars['Int']>>;
};

export type IntercomHashResponse = {
  __typename?: 'intercomHashResponse';
  hash: Scalars['String'];
};

export type InviteColloboratorRequest = {
  collaborator_email: Scalars['String'];
  privileges: Array<Scalars['String']>;
  project_id: Scalars['uuid'];
};

/** Customer invoice for Hasura Cloud services */
export type Invoice = {
  __typename?: 'invoice';
  attempt_count?: Maybe<Scalars['Int']>;
  collection_method: Scalars['String'];
  created_at?: Maybe<Scalars['timestamptz']>;
  /** customer id that represents unique customer at stripe */
  customer_id: Scalars['String'];
  /** any additional appropriate description for this invoice. This will be used on the UI */
  description: Scalars['String'];
  /** due amount of the invoice without coupons and credit applied */
  due_amount?: Maybe<Scalars['numeric']>;
  /** An array relationship */
  invoice_coupon_discounts: Array<Invoice_Coupon_Discount>;
  /** An aggregate relationship */
  invoice_coupon_discounts_aggregate: Invoice_Coupon_Discount_Aggregate;
  /** An array relationship */
  invoice_credit_usages: Array<Customer_Usage>;
  /** An aggregate relationship */
  invoice_credit_usages_aggregate: Customer_Usage_Aggregate;
  invoice_url?: Maybe<Scalars['String']>;
  /** An array relationship */
  items: Array<Invoice_Item>;
  /** An aggregate relationship */
  items_aggregate: Invoice_Item_Aggregate;
  /** represents month for which this invoice is for */
  month: Scalars['Int'];
  /** An object relationship */
  payment_method?: Maybe<Payment_Method>;
  payment_method_id?: Maybe<Scalars['String']>;
  receipt_url?: Maybe<Scalars['String']>;
  /** represents status of this invoice. It can be either `paid`, `failed`, `unpaid` */
  status: Scalars['String'];
  /** unique invoice id, represents invoice id at stripe */
  stripe_invoice_id: Scalars['String'];
  /** subscription for which the current invoice is generated for */
  subscription_id: Scalars['String'];
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** An object relationship */
  user?: Maybe<Users>;
  /** represents year for which this invoice is for */
  year: Scalars['Int'];
};

/** Customer invoice for Hasura Cloud services */
export type InvoiceInvoice_Coupon_DiscountsArgs = {
  distinct_on?: Maybe<Array<Invoice_Coupon_Discount_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Invoice_Coupon_Discount_Order_By>>;
  where?: Maybe<Invoice_Coupon_Discount_Bool_Exp>;
};

/** Customer invoice for Hasura Cloud services */
export type InvoiceInvoice_Coupon_Discounts_AggregateArgs = {
  distinct_on?: Maybe<Array<Invoice_Coupon_Discount_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Invoice_Coupon_Discount_Order_By>>;
  where?: Maybe<Invoice_Coupon_Discount_Bool_Exp>;
};

/** Customer invoice for Hasura Cloud services */
export type InvoiceInvoice_Credit_UsagesArgs = {
  distinct_on?: Maybe<Array<Customer_Usage_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Customer_Usage_Order_By>>;
  where?: Maybe<Customer_Usage_Bool_Exp>;
};

/** Customer invoice for Hasura Cloud services */
export type InvoiceInvoice_Credit_Usages_AggregateArgs = {
  distinct_on?: Maybe<Array<Customer_Usage_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Customer_Usage_Order_By>>;
  where?: Maybe<Customer_Usage_Bool_Exp>;
};

/** Customer invoice for Hasura Cloud services */
export type InvoiceItemsArgs = {
  distinct_on?: Maybe<Array<Invoice_Item_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Invoice_Item_Order_By>>;
  where?: Maybe<Invoice_Item_Bool_Exp>;
};

/** Customer invoice for Hasura Cloud services */
export type InvoiceItems_AggregateArgs = {
  distinct_on?: Maybe<Array<Invoice_Item_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Invoice_Item_Order_By>>;
  where?: Maybe<Invoice_Item_Bool_Exp>;
};

/** aggregated selection of "invoice" */
export type Invoice_Aggregate = {
  __typename?: 'invoice_aggregate';
  aggregate?: Maybe<Invoice_Aggregate_Fields>;
  nodes: Array<Invoice>;
};

export type Invoice_Aggregate_Bool_Exp = {
  count?: Maybe<Invoice_Aggregate_Bool_Exp_Count>;
};

export type Invoice_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Invoice_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Invoice_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "invoice" */
export type Invoice_Aggregate_Fields = {
  __typename?: 'invoice_aggregate_fields';
  avg?: Maybe<Invoice_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Invoice_Max_Fields>;
  min?: Maybe<Invoice_Min_Fields>;
  stddev?: Maybe<Invoice_Stddev_Fields>;
  stddev_pop?: Maybe<Invoice_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Invoice_Stddev_Samp_Fields>;
  sum?: Maybe<Invoice_Sum_Fields>;
  var_pop?: Maybe<Invoice_Var_Pop_Fields>;
  var_samp?: Maybe<Invoice_Var_Samp_Fields>;
  variance?: Maybe<Invoice_Variance_Fields>;
};

/** aggregate fields of "invoice" */
export type Invoice_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Invoice_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "invoice" */
export type Invoice_Aggregate_Order_By = {
  avg?: Maybe<Invoice_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Invoice_Max_Order_By>;
  min?: Maybe<Invoice_Min_Order_By>;
  stddev?: Maybe<Invoice_Stddev_Order_By>;
  stddev_pop?: Maybe<Invoice_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Invoice_Stddev_Samp_Order_By>;
  sum?: Maybe<Invoice_Sum_Order_By>;
  var_pop?: Maybe<Invoice_Var_Pop_Order_By>;
  var_samp?: Maybe<Invoice_Var_Samp_Order_By>;
  variance?: Maybe<Invoice_Variance_Order_By>;
};

/** input type for inserting array relation for remote table "invoice" */
export type Invoice_Arr_Rel_Insert_Input = {
  data: Array<Invoice_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Invoice_On_Conflict>;
};

/** aggregate avg on columns */
export type Invoice_Avg_Fields = {
  __typename?: 'invoice_avg_fields';
  attempt_count?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "invoice" */
export type Invoice_Avg_Order_By = {
  attempt_count?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

/** Boolean expression to filter rows from the table "invoice". All fields are combined with a logical 'AND'. */
export type Invoice_Bool_Exp = {
  _and?: Maybe<Array<Invoice_Bool_Exp>>;
  _not?: Maybe<Invoice_Bool_Exp>;
  _or?: Maybe<Array<Invoice_Bool_Exp>>;
  attempt_count?: Maybe<Int_Comparison_Exp>;
  collection_method?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  customer_id?: Maybe<String_Comparison_Exp>;
  description?: Maybe<String_Comparison_Exp>;
  due_amount?: Maybe<Numeric_Comparison_Exp>;
  invoice_coupon_discounts?: Maybe<Invoice_Coupon_Discount_Bool_Exp>;
  invoice_coupon_discounts_aggregate?: Maybe<Invoice_Coupon_Discount_Aggregate_Bool_Exp>;
  invoice_credit_usages?: Maybe<Customer_Usage_Bool_Exp>;
  invoice_credit_usages_aggregate?: Maybe<Customer_Usage_Aggregate_Bool_Exp>;
  invoice_url?: Maybe<String_Comparison_Exp>;
  items?: Maybe<Invoice_Item_Bool_Exp>;
  items_aggregate?: Maybe<Invoice_Item_Aggregate_Bool_Exp>;
  month?: Maybe<Int_Comparison_Exp>;
  payment_method?: Maybe<Payment_Method_Bool_Exp>;
  payment_method_id?: Maybe<String_Comparison_Exp>;
  receipt_url?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  stripe_invoice_id?: Maybe<String_Comparison_Exp>;
  subscription_id?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  user?: Maybe<Users_Bool_Exp>;
  year?: Maybe<Int_Comparison_Exp>;
};

/** unique or primary key constraints on table "invoice" */
export enum Invoice_Constraint {
  /** unique or primary key constraint on columns "stripe_invoice_id" */
  InvoicePkey = 'invoice_pkey',
}

/** Discount coupon used on an invoice */
export type Invoice_Coupon_Discount = {
  __typename?: 'invoice_coupon_discount';
  amount: Scalars['numeric'];
  coupon_code: Scalars['String'];
  created_at: Scalars['timestamptz'];
  discount_type: Scalars['String'];
  inv_id: Scalars['String'];
  /** An object relationship */
  invoice?: Maybe<Invoice>;
};

/** aggregated selection of "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Aggregate = {
  __typename?: 'invoice_coupon_discount_aggregate';
  aggregate?: Maybe<Invoice_Coupon_Discount_Aggregate_Fields>;
  nodes: Array<Invoice_Coupon_Discount>;
};

export type Invoice_Coupon_Discount_Aggregate_Bool_Exp = {
  count?: Maybe<Invoice_Coupon_Discount_Aggregate_Bool_Exp_Count>;
};

export type Invoice_Coupon_Discount_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Invoice_Coupon_Discount_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Invoice_Coupon_Discount_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Aggregate_Fields = {
  __typename?: 'invoice_coupon_discount_aggregate_fields';
  avg?: Maybe<Invoice_Coupon_Discount_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Invoice_Coupon_Discount_Max_Fields>;
  min?: Maybe<Invoice_Coupon_Discount_Min_Fields>;
  stddev?: Maybe<Invoice_Coupon_Discount_Stddev_Fields>;
  stddev_pop?: Maybe<Invoice_Coupon_Discount_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Invoice_Coupon_Discount_Stddev_Samp_Fields>;
  sum?: Maybe<Invoice_Coupon_Discount_Sum_Fields>;
  var_pop?: Maybe<Invoice_Coupon_Discount_Var_Pop_Fields>;
  var_samp?: Maybe<Invoice_Coupon_Discount_Var_Samp_Fields>;
  variance?: Maybe<Invoice_Coupon_Discount_Variance_Fields>;
};

/** aggregate fields of "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Invoice_Coupon_Discount_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Aggregate_Order_By = {
  avg?: Maybe<Invoice_Coupon_Discount_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Invoice_Coupon_Discount_Max_Order_By>;
  min?: Maybe<Invoice_Coupon_Discount_Min_Order_By>;
  stddev?: Maybe<Invoice_Coupon_Discount_Stddev_Order_By>;
  stddev_pop?: Maybe<Invoice_Coupon_Discount_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Invoice_Coupon_Discount_Stddev_Samp_Order_By>;
  sum?: Maybe<Invoice_Coupon_Discount_Sum_Order_By>;
  var_pop?: Maybe<Invoice_Coupon_Discount_Var_Pop_Order_By>;
  var_samp?: Maybe<Invoice_Coupon_Discount_Var_Samp_Order_By>;
  variance?: Maybe<Invoice_Coupon_Discount_Variance_Order_By>;
};

/** input type for inserting array relation for remote table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Arr_Rel_Insert_Input = {
  data: Array<Invoice_Coupon_Discount_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Invoice_Coupon_Discount_On_Conflict>;
};

/** aggregate avg on columns */
export type Invoice_Coupon_Discount_Avg_Fields = {
  __typename?: 'invoice_coupon_discount_avg_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Avg_Order_By = {
  amount?: Maybe<Order_By>;
};

/** Boolean expression to filter rows from the table "invoice_coupon_discount". All fields are combined with a logical 'AND'. */
export type Invoice_Coupon_Discount_Bool_Exp = {
  _and?: Maybe<Array<Invoice_Coupon_Discount_Bool_Exp>>;
  _not?: Maybe<Invoice_Coupon_Discount_Bool_Exp>;
  _or?: Maybe<Array<Invoice_Coupon_Discount_Bool_Exp>>;
  amount?: Maybe<Numeric_Comparison_Exp>;
  coupon_code?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  discount_type?: Maybe<String_Comparison_Exp>;
  inv_id?: Maybe<String_Comparison_Exp>;
  invoice?: Maybe<Invoice_Bool_Exp>;
};

/** unique or primary key constraints on table "invoice_coupon_discount" */
export enum Invoice_Coupon_Discount_Constraint {
  /** unique or primary key constraint on columns "inv_id" */
  InvoiceCouponDiscountPkey = 'invoice_coupon_discount_pkey',
}

/** input type for incrementing numeric columns in table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Inc_Input = {
  amount?: Maybe<Scalars['numeric']>;
};

/** input type for inserting data into table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Insert_Input = {
  amount?: Maybe<Scalars['numeric']>;
  coupon_code?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  discount_type?: Maybe<Scalars['String']>;
  inv_id?: Maybe<Scalars['String']>;
  invoice?: Maybe<Invoice_Obj_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Invoice_Coupon_Discount_Max_Fields = {
  __typename?: 'invoice_coupon_discount_max_fields';
  amount?: Maybe<Scalars['numeric']>;
  coupon_code?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  discount_type?: Maybe<Scalars['String']>;
  inv_id?: Maybe<Scalars['String']>;
};

/** order by max() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Max_Order_By = {
  amount?: Maybe<Order_By>;
  coupon_code?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  discount_type?: Maybe<Order_By>;
  inv_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Invoice_Coupon_Discount_Min_Fields = {
  __typename?: 'invoice_coupon_discount_min_fields';
  amount?: Maybe<Scalars['numeric']>;
  coupon_code?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  discount_type?: Maybe<Scalars['String']>;
  inv_id?: Maybe<Scalars['String']>;
};

/** order by min() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Min_Order_By = {
  amount?: Maybe<Order_By>;
  coupon_code?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  discount_type?: Maybe<Order_By>;
  inv_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Mutation_Response = {
  __typename?: 'invoice_coupon_discount_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Invoice_Coupon_Discount>;
};

/** on_conflict condition type for table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_On_Conflict = {
  constraint: Invoice_Coupon_Discount_Constraint;
  update_columns?: Array<Invoice_Coupon_Discount_Update_Column>;
  where?: Maybe<Invoice_Coupon_Discount_Bool_Exp>;
};

/** Ordering options when selecting data from "invoice_coupon_discount". */
export type Invoice_Coupon_Discount_Order_By = {
  amount?: Maybe<Order_By>;
  coupon_code?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  discount_type?: Maybe<Order_By>;
  inv_id?: Maybe<Order_By>;
  invoice?: Maybe<Invoice_Order_By>;
};

/** primary key columns input for table: invoice_coupon_discount */
export type Invoice_Coupon_Discount_Pk_Columns_Input = {
  inv_id: Scalars['String'];
};

/** select columns of table "invoice_coupon_discount" */
export enum Invoice_Coupon_Discount_Select_Column {
  /** column name */
  Amount = 'amount',
  /** column name */
  CouponCode = 'coupon_code',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DiscountType = 'discount_type',
  /** column name */
  InvId = 'inv_id',
}

/** input type for updating data in table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Set_Input = {
  amount?: Maybe<Scalars['numeric']>;
  coupon_code?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  discount_type?: Maybe<Scalars['String']>;
  inv_id?: Maybe<Scalars['String']>;
};

/** aggregate stddev on columns */
export type Invoice_Coupon_Discount_Stddev_Fields = {
  __typename?: 'invoice_coupon_discount_stddev_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Stddev_Order_By = {
  amount?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Invoice_Coupon_Discount_Stddev_Pop_Fields = {
  __typename?: 'invoice_coupon_discount_stddev_pop_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Stddev_Pop_Order_By = {
  amount?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Invoice_Coupon_Discount_Stddev_Samp_Fields = {
  __typename?: 'invoice_coupon_discount_stddev_samp_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Stddev_Samp_Order_By = {
  amount?: Maybe<Order_By>;
};

/** Streaming cursor of the table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Invoice_Coupon_Discount_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Invoice_Coupon_Discount_Stream_Cursor_Value_Input = {
  amount?: Maybe<Scalars['numeric']>;
  coupon_code?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  discount_type?: Maybe<Scalars['String']>;
  inv_id?: Maybe<Scalars['String']>;
};

/** aggregate sum on columns */
export type Invoice_Coupon_Discount_Sum_Fields = {
  __typename?: 'invoice_coupon_discount_sum_fields';
  amount?: Maybe<Scalars['numeric']>;
};

/** order by sum() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Sum_Order_By = {
  amount?: Maybe<Order_By>;
};

/** update columns of table "invoice_coupon_discount" */
export enum Invoice_Coupon_Discount_Update_Column {
  /** column name */
  Amount = 'amount',
  /** column name */
  CouponCode = 'coupon_code',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DiscountType = 'discount_type',
  /** column name */
  InvId = 'inv_id',
}

export type Invoice_Coupon_Discount_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Invoice_Coupon_Discount_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Invoice_Coupon_Discount_Set_Input>;
  /** filter the rows which have to be updated */
  where: Invoice_Coupon_Discount_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Invoice_Coupon_Discount_Var_Pop_Fields = {
  __typename?: 'invoice_coupon_discount_var_pop_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Var_Pop_Order_By = {
  amount?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Invoice_Coupon_Discount_Var_Samp_Fields = {
  __typename?: 'invoice_coupon_discount_var_samp_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Var_Samp_Order_By = {
  amount?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Invoice_Coupon_Discount_Variance_Fields = {
  __typename?: 'invoice_coupon_discount_variance_fields';
  amount?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "invoice_coupon_discount" */
export type Invoice_Coupon_Discount_Variance_Order_By = {
  amount?: Maybe<Order_By>;
};

/** input type for incrementing numeric columns in table "invoice" */
export type Invoice_Inc_Input = {
  attempt_count?: Maybe<Scalars['Int']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Int']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "invoice" */
export type Invoice_Insert_Input = {
  attempt_count?: Maybe<Scalars['Int']>;
  collection_method?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** customer id that represents unique customer at stripe */
  customer_id?: Maybe<Scalars['String']>;
  /** any additional appropriate description for this invoice. This will be used on the UI */
  description?: Maybe<Scalars['String']>;
  invoice_coupon_discounts?: Maybe<Invoice_Coupon_Discount_Arr_Rel_Insert_Input>;
  invoice_credit_usages?: Maybe<Customer_Usage_Arr_Rel_Insert_Input>;
  invoice_url?: Maybe<Scalars['String']>;
  items?: Maybe<Invoice_Item_Arr_Rel_Insert_Input>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Int']>;
  payment_method?: Maybe<Payment_Method_Obj_Rel_Insert_Input>;
  payment_method_id?: Maybe<Scalars['String']>;
  receipt_url?: Maybe<Scalars['String']>;
  /** represents status of this invoice. It can be either `paid`, `failed`, `unpaid` */
  status?: Maybe<Scalars['String']>;
  /** unique invoice id, represents invoice id at stripe */
  stripe_invoice_id?: Maybe<Scalars['String']>;
  /** subscription for which the current invoice is generated for */
  subscription_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Int']>;
};

/** Item that is part of an invoice */
export type Invoice_Item = {
  __typename?: 'invoice_item';
  amount: Scalars['numeric'];
  created_at?: Maybe<Scalars['timestamptz']>;
  /** represents understandable invoice item description which will reflect in the actual invoice */
  description: Scalars['String'];
  /** contain error when adding invoice item to stripe fails */
  error?: Maybe<Scalars['String']>;
  /** if true, the stripe is updated successfully, otherwise not */
  has_updated_to_stripe: Scalars['Boolean'];
  id: Scalars['uuid'];
  /** An object relationship */
  invoice: Invoice;
  /** represents invoice_id for which this invoice_item is for */
  invoice_id: Scalars['String'];
  /** represents month for which this invoice_item is for */
  month: Scalars['Int'];
  /** represents project_id for which this invoice_item is for */
  project_id: Scalars['uuid'];
  /**
   * represents type for which this invoice_item is for. It can take up values such
   * as `pay_as_you_go`, `additional_data_usage`, `shared_data_passthrough`,
   * `shared_pg_usage`, `shared_no_db_usage`, `shared_non_pg_usage` or `sales_tax`
   */
  type: Scalars['invoice_item_type'];
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice_item is for */
  year: Scalars['Int'];
};

/** aggregated selection of "invoice_item" */
export type Invoice_Item_Aggregate = {
  __typename?: 'invoice_item_aggregate';
  aggregate?: Maybe<Invoice_Item_Aggregate_Fields>;
  nodes: Array<Invoice_Item>;
};

export type Invoice_Item_Aggregate_Bool_Exp = {
  bool_and?: Maybe<Invoice_Item_Aggregate_Bool_Exp_Bool_And>;
  bool_or?: Maybe<Invoice_Item_Aggregate_Bool_Exp_Bool_Or>;
  count?: Maybe<Invoice_Item_Aggregate_Bool_Exp_Count>;
};

export type Invoice_Item_Aggregate_Bool_Exp_Bool_And = {
  arguments: Invoice_Item_Select_Column_Invoice_Item_Aggregate_Bool_Exp_Bool_And_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Invoice_Item_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Invoice_Item_Aggregate_Bool_Exp_Bool_Or = {
  arguments: Invoice_Item_Select_Column_Invoice_Item_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Invoice_Item_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Invoice_Item_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Invoice_Item_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Invoice_Item_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "invoice_item" */
export type Invoice_Item_Aggregate_Fields = {
  __typename?: 'invoice_item_aggregate_fields';
  avg?: Maybe<Invoice_Item_Avg_Fields>;
  count: Scalars['Int'];
  max?: Maybe<Invoice_Item_Max_Fields>;
  min?: Maybe<Invoice_Item_Min_Fields>;
  stddev?: Maybe<Invoice_Item_Stddev_Fields>;
  stddev_pop?: Maybe<Invoice_Item_Stddev_Pop_Fields>;
  stddev_samp?: Maybe<Invoice_Item_Stddev_Samp_Fields>;
  sum?: Maybe<Invoice_Item_Sum_Fields>;
  var_pop?: Maybe<Invoice_Item_Var_Pop_Fields>;
  var_samp?: Maybe<Invoice_Item_Var_Samp_Fields>;
  variance?: Maybe<Invoice_Item_Variance_Fields>;
};

/** aggregate fields of "invoice_item" */
export type Invoice_Item_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Invoice_Item_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "invoice_item" */
export type Invoice_Item_Aggregate_Order_By = {
  avg?: Maybe<Invoice_Item_Avg_Order_By>;
  count?: Maybe<Order_By>;
  max?: Maybe<Invoice_Item_Max_Order_By>;
  min?: Maybe<Invoice_Item_Min_Order_By>;
  stddev?: Maybe<Invoice_Item_Stddev_Order_By>;
  stddev_pop?: Maybe<Invoice_Item_Stddev_Pop_Order_By>;
  stddev_samp?: Maybe<Invoice_Item_Stddev_Samp_Order_By>;
  sum?: Maybe<Invoice_Item_Sum_Order_By>;
  var_pop?: Maybe<Invoice_Item_Var_Pop_Order_By>;
  var_samp?: Maybe<Invoice_Item_Var_Samp_Order_By>;
  variance?: Maybe<Invoice_Item_Variance_Order_By>;
};

/** input type for inserting array relation for remote table "invoice_item" */
export type Invoice_Item_Arr_Rel_Insert_Input = {
  data: Array<Invoice_Item_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Invoice_Item_On_Conflict>;
};

/** aggregate avg on columns */
export type Invoice_Item_Avg_Fields = {
  __typename?: 'invoice_item_avg_fields';
  amount?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by avg() on columns of table "invoice_item" */
export type Invoice_Item_Avg_Order_By = {
  amount?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** Boolean expression to filter rows from the table "invoice_item". All fields are combined with a logical 'AND'. */
export type Invoice_Item_Bool_Exp = {
  _and?: Maybe<Array<Invoice_Item_Bool_Exp>>;
  _not?: Maybe<Invoice_Item_Bool_Exp>;
  _or?: Maybe<Array<Invoice_Item_Bool_Exp>>;
  amount?: Maybe<Numeric_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  description?: Maybe<String_Comparison_Exp>;
  error?: Maybe<String_Comparison_Exp>;
  has_updated_to_stripe?: Maybe<Boolean_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  invoice?: Maybe<Invoice_Bool_Exp>;
  invoice_id?: Maybe<String_Comparison_Exp>;
  month?: Maybe<Int_Comparison_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  type?: Maybe<Invoice_Item_Type_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  year?: Maybe<Int_Comparison_Exp>;
};

/** unique or primary key constraints on table "invoice_item" */
export enum Invoice_Item_Constraint {
  /** unique or primary key constraint on columns "id" */
  InvoiceItemPkey = 'invoice_item_pkey',
  /** unique or primary key constraint on columns "year", "type", "project_id", "month" */
  InvoiceItemUnique = 'invoice_item_unique',
}

/** input type for incrementing numeric columns in table "invoice_item" */
export type Invoice_Item_Inc_Input = {
  amount?: Maybe<Scalars['numeric']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Int']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Int']>;
};

/** input type for inserting data into table "invoice_item" */
export type Invoice_Item_Insert_Input = {
  amount?: Maybe<Scalars['numeric']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** represents understandable invoice item description which will reflect in the actual invoice */
  description?: Maybe<Scalars['String']>;
  /** contain error when adding invoice item to stripe fails */
  error?: Maybe<Scalars['String']>;
  /** if true, the stripe is updated successfully, otherwise not */
  has_updated_to_stripe?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  invoice?: Maybe<Invoice_Obj_Rel_Insert_Input>;
  /** represents invoice_id for which this invoice_item is for */
  invoice_id?: Maybe<Scalars['String']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Int']>;
  /** represents project_id for which this invoice_item is for */
  project_id?: Maybe<Scalars['uuid']>;
  /**
   * represents type for which this invoice_item is for. It can take up values such
   * as `pay_as_you_go`, `additional_data_usage`, `shared_data_passthrough`,
   * `shared_pg_usage`, `shared_no_db_usage`, `shared_non_pg_usage` or `sales_tax`
   */
  type?: Maybe<Scalars['invoice_item_type']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Int']>;
};

/** aggregate max on columns */
export type Invoice_Item_Max_Fields = {
  __typename?: 'invoice_item_max_fields';
  amount?: Maybe<Scalars['numeric']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** represents understandable invoice item description which will reflect in the actual invoice */
  description?: Maybe<Scalars['String']>;
  /** contain error when adding invoice item to stripe fails */
  error?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  /** represents invoice_id for which this invoice_item is for */
  invoice_id?: Maybe<Scalars['String']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Int']>;
  /** represents project_id for which this invoice_item is for */
  project_id?: Maybe<Scalars['uuid']>;
  /**
   * represents type for which this invoice_item is for. It can take up values such
   * as `pay_as_you_go`, `additional_data_usage`, `shared_data_passthrough`,
   * `shared_pg_usage`, `shared_no_db_usage`, `shared_non_pg_usage` or `sales_tax`
   */
  type?: Maybe<Scalars['invoice_item_type']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Int']>;
};

/** order by max() on columns of table "invoice_item" */
export type Invoice_Item_Max_Order_By = {
  amount?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  /** represents understandable invoice item description which will reflect in the actual invoice */
  description?: Maybe<Order_By>;
  /** contain error when adding invoice item to stripe fails */
  error?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  /** represents invoice_id for which this invoice_item is for */
  invoice_id?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents project_id for which this invoice_item is for */
  project_id?: Maybe<Order_By>;
  /**
   * represents type for which this invoice_item is for. It can take up values such
   * as `pay_as_you_go`, `additional_data_usage`, `shared_data_passthrough`,
   * `shared_pg_usage`, `shared_no_db_usage`, `shared_non_pg_usage` or `sales_tax`
   */
  type?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Invoice_Item_Min_Fields = {
  __typename?: 'invoice_item_min_fields';
  amount?: Maybe<Scalars['numeric']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** represents understandable invoice item description which will reflect in the actual invoice */
  description?: Maybe<Scalars['String']>;
  /** contain error when adding invoice item to stripe fails */
  error?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['uuid']>;
  /** represents invoice_id for which this invoice_item is for */
  invoice_id?: Maybe<Scalars['String']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Int']>;
  /** represents project_id for which this invoice_item is for */
  project_id?: Maybe<Scalars['uuid']>;
  /**
   * represents type for which this invoice_item is for. It can take up values such
   * as `pay_as_you_go`, `additional_data_usage`, `shared_data_passthrough`,
   * `shared_pg_usage`, `shared_no_db_usage`, `shared_non_pg_usage` or `sales_tax`
   */
  type?: Maybe<Scalars['invoice_item_type']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Int']>;
};

/** order by min() on columns of table "invoice_item" */
export type Invoice_Item_Min_Order_By = {
  amount?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  /** represents understandable invoice item description which will reflect in the actual invoice */
  description?: Maybe<Order_By>;
  /** contain error when adding invoice item to stripe fails */
  error?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  /** represents invoice_id for which this invoice_item is for */
  invoice_id?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents project_id for which this invoice_item is for */
  project_id?: Maybe<Order_By>;
  /**
   * represents type for which this invoice_item is for. It can take up values such
   * as `pay_as_you_go`, `additional_data_usage`, `shared_data_passthrough`,
   * `shared_pg_usage`, `shared_no_db_usage`, `shared_non_pg_usage` or `sales_tax`
   */
  type?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** response of any mutation on the table "invoice_item" */
export type Invoice_Item_Mutation_Response = {
  __typename?: 'invoice_item_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Invoice_Item>;
};

/** on_conflict condition type for table "invoice_item" */
export type Invoice_Item_On_Conflict = {
  constraint: Invoice_Item_Constraint;
  update_columns?: Array<Invoice_Item_Update_Column>;
  where?: Maybe<Invoice_Item_Bool_Exp>;
};

/** Ordering options when selecting data from "invoice_item". */
export type Invoice_Item_Order_By = {
  amount?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  description?: Maybe<Order_By>;
  error?: Maybe<Order_By>;
  has_updated_to_stripe?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  invoice?: Maybe<Invoice_Order_By>;
  invoice_id?: Maybe<Order_By>;
  month?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  type?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  year?: Maybe<Order_By>;
};

/** primary key columns input for table: invoice_item */
export type Invoice_Item_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "invoice_item" */
export enum Invoice_Item_Select_Column {
  /** column name */
  Amount = 'amount',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Description = 'description',
  /** column name */
  Error = 'error',
  /** column name */
  HasUpdatedToStripe = 'has_updated_to_stripe',
  /** column name */
  Id = 'id',
  /** column name */
  InvoiceId = 'invoice_id',
  /** column name */
  Month = 'month',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  Type = 'type',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Year = 'year',
}

/** select "invoice_item_aggregate_bool_exp_bool_and_arguments_columns" columns of table "invoice_item" */
export enum Invoice_Item_Select_Column_Invoice_Item_Aggregate_Bool_Exp_Bool_And_Arguments_Columns {
  /** column name */
  HasUpdatedToStripe = 'has_updated_to_stripe',
}

/** select "invoice_item_aggregate_bool_exp_bool_or_arguments_columns" columns of table "invoice_item" */
export enum Invoice_Item_Select_Column_Invoice_Item_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns {
  /** column name */
  HasUpdatedToStripe = 'has_updated_to_stripe',
}

/** input type for updating data in table "invoice_item" */
export type Invoice_Item_Set_Input = {
  amount?: Maybe<Scalars['numeric']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** represents understandable invoice item description which will reflect in the actual invoice */
  description?: Maybe<Scalars['String']>;
  /** contain error when adding invoice item to stripe fails */
  error?: Maybe<Scalars['String']>;
  /** if true, the stripe is updated successfully, otherwise not */
  has_updated_to_stripe?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  /** represents invoice_id for which this invoice_item is for */
  invoice_id?: Maybe<Scalars['String']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Int']>;
  /** represents project_id for which this invoice_item is for */
  project_id?: Maybe<Scalars['uuid']>;
  /**
   * represents type for which this invoice_item is for. It can take up values such
   * as `pay_as_you_go`, `additional_data_usage`, `shared_data_passthrough`,
   * `shared_pg_usage`, `shared_no_db_usage`, `shared_non_pg_usage` or `sales_tax`
   */
  type?: Maybe<Scalars['invoice_item_type']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Int']>;
};

/** aggregate stddev on columns */
export type Invoice_Item_Stddev_Fields = {
  __typename?: 'invoice_item_stddev_fields';
  amount?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "invoice_item" */
export type Invoice_Item_Stddev_Order_By = {
  amount?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Invoice_Item_Stddev_Pop_Fields = {
  __typename?: 'invoice_item_stddev_pop_fields';
  amount?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "invoice_item" */
export type Invoice_Item_Stddev_Pop_Order_By = {
  amount?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Invoice_Item_Stddev_Samp_Fields = {
  __typename?: 'invoice_item_stddev_samp_fields';
  amount?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "invoice_item" */
export type Invoice_Item_Stddev_Samp_Order_By = {
  amount?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** Streaming cursor of the table "invoice_item" */
export type Invoice_Item_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Invoice_Item_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Invoice_Item_Stream_Cursor_Value_Input = {
  amount?: Maybe<Scalars['numeric']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** represents understandable invoice item description which will reflect in the actual invoice */
  description?: Maybe<Scalars['String']>;
  /** contain error when adding invoice item to stripe fails */
  error?: Maybe<Scalars['String']>;
  /** if true, the stripe is updated successfully, otherwise not */
  has_updated_to_stripe?: Maybe<Scalars['Boolean']>;
  id?: Maybe<Scalars['uuid']>;
  /** represents invoice_id for which this invoice_item is for */
  invoice_id?: Maybe<Scalars['String']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Int']>;
  /** represents project_id for which this invoice_item is for */
  project_id?: Maybe<Scalars['uuid']>;
  /**
   * represents type for which this invoice_item is for. It can take up values such
   * as `pay_as_you_go`, `additional_data_usage`, `shared_data_passthrough`,
   * `shared_pg_usage`, `shared_no_db_usage`, `shared_non_pg_usage` or `sales_tax`
   */
  type?: Maybe<Scalars['invoice_item_type']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Int']>;
};

/** aggregate sum on columns */
export type Invoice_Item_Sum_Fields = {
  __typename?: 'invoice_item_sum_fields';
  amount?: Maybe<Scalars['numeric']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Int']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Int']>;
};

/** order by sum() on columns of table "invoice_item" */
export type Invoice_Item_Sum_Order_By = {
  amount?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** Boolean expression to compare columns of type "invoice_item_type". All fields are combined with logical 'AND'. */
export type Invoice_Item_Type_Comparison_Exp = {
  _eq?: Maybe<Scalars['invoice_item_type']>;
  _gt?: Maybe<Scalars['invoice_item_type']>;
  _gte?: Maybe<Scalars['invoice_item_type']>;
  _in?: Maybe<Array<Scalars['invoice_item_type']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['invoice_item_type']>;
  _lte?: Maybe<Scalars['invoice_item_type']>;
  _neq?: Maybe<Scalars['invoice_item_type']>;
  _nin?: Maybe<Array<Scalars['invoice_item_type']>>;
};

/** update columns of table "invoice_item" */
export enum Invoice_Item_Update_Column {
  /** column name */
  Amount = 'amount',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Description = 'description',
  /** column name */
  Error = 'error',
  /** column name */
  HasUpdatedToStripe = 'has_updated_to_stripe',
  /** column name */
  Id = 'id',
  /** column name */
  InvoiceId = 'invoice_id',
  /** column name */
  Month = 'month',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  Type = 'type',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Year = 'year',
}

export type Invoice_Item_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Invoice_Item_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Invoice_Item_Set_Input>;
  /** filter the rows which have to be updated */
  where: Invoice_Item_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Invoice_Item_Var_Pop_Fields = {
  __typename?: 'invoice_item_var_pop_fields';
  amount?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "invoice_item" */
export type Invoice_Item_Var_Pop_Order_By = {
  amount?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Invoice_Item_Var_Samp_Fields = {
  __typename?: 'invoice_item_var_samp_fields';
  amount?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "invoice_item" */
export type Invoice_Item_Var_Samp_Order_By = {
  amount?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Invoice_Item_Variance_Fields = {
  __typename?: 'invoice_item_variance_fields';
  amount?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "invoice_item" */
export type Invoice_Item_Variance_Order_By = {
  amount?: Maybe<Order_By>;
  /** represents month for which this invoice_item is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice_item is for */
  year?: Maybe<Order_By>;
};

/** aggregate max on columns */
export type Invoice_Max_Fields = {
  __typename?: 'invoice_max_fields';
  attempt_count?: Maybe<Scalars['Int']>;
  collection_method?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** customer id that represents unique customer at stripe */
  customer_id?: Maybe<Scalars['String']>;
  /** any additional appropriate description for this invoice. This will be used on the UI */
  description?: Maybe<Scalars['String']>;
  invoice_url?: Maybe<Scalars['String']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Int']>;
  payment_method_id?: Maybe<Scalars['String']>;
  receipt_url?: Maybe<Scalars['String']>;
  /** represents status of this invoice. It can be either `paid`, `failed`, `unpaid` */
  status?: Maybe<Scalars['String']>;
  /** unique invoice id, represents invoice id at stripe */
  stripe_invoice_id?: Maybe<Scalars['String']>;
  /** subscription for which the current invoice is generated for */
  subscription_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Int']>;
};

/** order by max() on columns of table "invoice" */
export type Invoice_Max_Order_By = {
  attempt_count?: Maybe<Order_By>;
  collection_method?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  /** customer id that represents unique customer at stripe */
  customer_id?: Maybe<Order_By>;
  /** any additional appropriate description for this invoice. This will be used on the UI */
  description?: Maybe<Order_By>;
  invoice_url?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  payment_method_id?: Maybe<Order_By>;
  receipt_url?: Maybe<Order_By>;
  /** represents status of this invoice. It can be either `paid`, `failed`, `unpaid` */
  status?: Maybe<Order_By>;
  /** unique invoice id, represents invoice id at stripe */
  stripe_invoice_id?: Maybe<Order_By>;
  /** subscription for which the current invoice is generated for */
  subscription_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Invoice_Min_Fields = {
  __typename?: 'invoice_min_fields';
  attempt_count?: Maybe<Scalars['Int']>;
  collection_method?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** customer id that represents unique customer at stripe */
  customer_id?: Maybe<Scalars['String']>;
  /** any additional appropriate description for this invoice. This will be used on the UI */
  description?: Maybe<Scalars['String']>;
  invoice_url?: Maybe<Scalars['String']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Int']>;
  payment_method_id?: Maybe<Scalars['String']>;
  receipt_url?: Maybe<Scalars['String']>;
  /** represents status of this invoice. It can be either `paid`, `failed`, `unpaid` */
  status?: Maybe<Scalars['String']>;
  /** unique invoice id, represents invoice id at stripe */
  stripe_invoice_id?: Maybe<Scalars['String']>;
  /** subscription for which the current invoice is generated for */
  subscription_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Int']>;
};

/** order by min() on columns of table "invoice" */
export type Invoice_Min_Order_By = {
  attempt_count?: Maybe<Order_By>;
  collection_method?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  /** customer id that represents unique customer at stripe */
  customer_id?: Maybe<Order_By>;
  /** any additional appropriate description for this invoice. This will be used on the UI */
  description?: Maybe<Order_By>;
  invoice_url?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  payment_method_id?: Maybe<Order_By>;
  receipt_url?: Maybe<Order_By>;
  /** represents status of this invoice. It can be either `paid`, `failed`, `unpaid` */
  status?: Maybe<Order_By>;
  /** unique invoice id, represents invoice id at stripe */
  stripe_invoice_id?: Maybe<Order_By>;
  /** subscription for which the current invoice is generated for */
  subscription_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

/** response of any mutation on the table "invoice" */
export type Invoice_Mutation_Response = {
  __typename?: 'invoice_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Invoice>;
};

/** input type for inserting object relation for remote table "invoice" */
export type Invoice_Obj_Rel_Insert_Input = {
  data: Invoice_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Invoice_On_Conflict>;
};

/** on_conflict condition type for table "invoice" */
export type Invoice_On_Conflict = {
  constraint: Invoice_Constraint;
  update_columns?: Array<Invoice_Update_Column>;
  where?: Maybe<Invoice_Bool_Exp>;
};

/** Ordering options when selecting data from "invoice". */
export type Invoice_Order_By = {
  attempt_count?: Maybe<Order_By>;
  collection_method?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  customer_id?: Maybe<Order_By>;
  description?: Maybe<Order_By>;
  due_amount?: Maybe<Order_By>;
  invoice_coupon_discounts_aggregate?: Maybe<Invoice_Coupon_Discount_Aggregate_Order_By>;
  invoice_credit_usages_aggregate?: Maybe<Customer_Usage_Aggregate_Order_By>;
  invoice_url?: Maybe<Order_By>;
  items_aggregate?: Maybe<Invoice_Item_Aggregate_Order_By>;
  month?: Maybe<Order_By>;
  payment_method?: Maybe<Payment_Method_Order_By>;
  payment_method_id?: Maybe<Order_By>;
  receipt_url?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  stripe_invoice_id?: Maybe<Order_By>;
  subscription_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user?: Maybe<Users_Order_By>;
  year?: Maybe<Order_By>;
};

/** primary key columns input for table: invoice */
export type Invoice_Pk_Columns_Input = {
  /** unique invoice id, represents invoice id at stripe */
  stripe_invoice_id: Scalars['String'];
};

/** select columns of table "invoice" */
export enum Invoice_Select_Column {
  /** column name */
  AttemptCount = 'attempt_count',
  /** column name */
  CollectionMethod = 'collection_method',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomerId = 'customer_id',
  /** column name */
  Description = 'description',
  /** column name */
  InvoiceUrl = 'invoice_url',
  /** column name */
  Month = 'month',
  /** column name */
  PaymentMethodId = 'payment_method_id',
  /** column name */
  ReceiptUrl = 'receipt_url',
  /** column name */
  Status = 'status',
  /** column name */
  StripeInvoiceId = 'stripe_invoice_id',
  /** column name */
  SubscriptionId = 'subscription_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Year = 'year',
}

/** input type for updating data in table "invoice" */
export type Invoice_Set_Input = {
  attempt_count?: Maybe<Scalars['Int']>;
  collection_method?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** customer id that represents unique customer at stripe */
  customer_id?: Maybe<Scalars['String']>;
  /** any additional appropriate description for this invoice. This will be used on the UI */
  description?: Maybe<Scalars['String']>;
  invoice_url?: Maybe<Scalars['String']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Int']>;
  payment_method_id?: Maybe<Scalars['String']>;
  receipt_url?: Maybe<Scalars['String']>;
  /** represents status of this invoice. It can be either `paid`, `failed`, `unpaid` */
  status?: Maybe<Scalars['String']>;
  /** unique invoice id, represents invoice id at stripe */
  stripe_invoice_id?: Maybe<Scalars['String']>;
  /** subscription for which the current invoice is generated for */
  subscription_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Int']>;
};

/** aggregate stddev on columns */
export type Invoice_Stddev_Fields = {
  __typename?: 'invoice_stddev_fields';
  attempt_count?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev() on columns of table "invoice" */
export type Invoice_Stddev_Order_By = {
  attempt_count?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

/** aggregate stddev_pop on columns */
export type Invoice_Stddev_Pop_Fields = {
  __typename?: 'invoice_stddev_pop_fields';
  attempt_count?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev_pop() on columns of table "invoice" */
export type Invoice_Stddev_Pop_Order_By = {
  attempt_count?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

/** aggregate stddev_samp on columns */
export type Invoice_Stddev_Samp_Fields = {
  __typename?: 'invoice_stddev_samp_fields';
  attempt_count?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by stddev_samp() on columns of table "invoice" */
export type Invoice_Stddev_Samp_Order_By = {
  attempt_count?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

/** Streaming cursor of the table "invoice" */
export type Invoice_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Invoice_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Invoice_Stream_Cursor_Value_Input = {
  attempt_count?: Maybe<Scalars['Int']>;
  collection_method?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  /** customer id that represents unique customer at stripe */
  customer_id?: Maybe<Scalars['String']>;
  /** any additional appropriate description for this invoice. This will be used on the UI */
  description?: Maybe<Scalars['String']>;
  invoice_url?: Maybe<Scalars['String']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Int']>;
  payment_method_id?: Maybe<Scalars['String']>;
  receipt_url?: Maybe<Scalars['String']>;
  /** represents status of this invoice. It can be either `paid`, `failed`, `unpaid` */
  status?: Maybe<Scalars['String']>;
  /** unique invoice id, represents invoice id at stripe */
  stripe_invoice_id?: Maybe<Scalars['String']>;
  /** subscription for which the current invoice is generated for */
  subscription_id?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Int']>;
};

/** aggregate sum on columns */
export type Invoice_Sum_Fields = {
  __typename?: 'invoice_sum_fields';
  attempt_count?: Maybe<Scalars['Int']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Int']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Int']>;
};

/** order by sum() on columns of table "invoice" */
export type Invoice_Sum_Order_By = {
  attempt_count?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

/** update columns of table "invoice" */
export enum Invoice_Update_Column {
  /** column name */
  AttemptCount = 'attempt_count',
  /** column name */
  CollectionMethod = 'collection_method',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CustomerId = 'customer_id',
  /** column name */
  Description = 'description',
  /** column name */
  InvoiceUrl = 'invoice_url',
  /** column name */
  Month = 'month',
  /** column name */
  PaymentMethodId = 'payment_method_id',
  /** column name */
  ReceiptUrl = 'receipt_url',
  /** column name */
  Status = 'status',
  /** column name */
  StripeInvoiceId = 'stripe_invoice_id',
  /** column name */
  SubscriptionId = 'subscription_id',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  Year = 'year',
}

export type Invoice_Updates = {
  /** increments the numeric columns with given value of the filtered values */
  _inc?: Maybe<Invoice_Inc_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Invoice_Set_Input>;
  /** filter the rows which have to be updated */
  where: Invoice_Bool_Exp;
};

/** aggregate var_pop on columns */
export type Invoice_Var_Pop_Fields = {
  __typename?: 'invoice_var_pop_fields';
  attempt_count?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by var_pop() on columns of table "invoice" */
export type Invoice_Var_Pop_Order_By = {
  attempt_count?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

/** aggregate var_samp on columns */
export type Invoice_Var_Samp_Fields = {
  __typename?: 'invoice_var_samp_fields';
  attempt_count?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by var_samp() on columns of table "invoice" */
export type Invoice_Var_Samp_Order_By = {
  attempt_count?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

/** aggregate variance on columns */
export type Invoice_Variance_Fields = {
  __typename?: 'invoice_variance_fields';
  attempt_count?: Maybe<Scalars['Float']>;
  /** represents month for which this invoice is for */
  month?: Maybe<Scalars['Float']>;
  /** represents year for which this invoice is for */
  year?: Maybe<Scalars['Float']>;
};

/** order by variance() on columns of table "invoice" */
export type Invoice_Variance_Order_By = {
  attempt_count?: Maybe<Order_By>;
  /** represents month for which this invoice is for */
  month?: Maybe<Order_By>;
  /** represents year for which this invoice is for */
  year?: Maybe<Order_By>;
};

export type InvoiceAndReceiptUrLsResponse = {
  __typename?: 'invoiceAndReceiptURLsResponse';
  invoice_url?: Maybe<Scalars['String']>;
  receipt_url?: Maybe<Scalars['String']>;
};

export enum InvoiceCreateStatus {
  Failed = 'failed',
  Success = 'success',
}

/** columns and relationships of "jobs" */
export type Jobs = {
  __typename?: 'jobs';
  created_at: Scalars['timestamptz'];
  /** An array relationship */
  github_push_event_jobs: Array<Github_Push_Event_Job>;
  /** An aggregate relationship */
  github_push_event_jobs_aggregate: Github_Push_Event_Job_Aggregate;
  id: Scalars['uuid'];
  input: Scalars['jsonb'];
  job_type: Scalars['String'];
  /** An object relationship */
  project?: Maybe<Projects>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  status: Scalars['String'];
  /** An array relationship */
  tasks: Array<Tasks>;
  /** An aggregate relationship */
  tasks_aggregate: Tasks_Aggregate;
  updated_at: Scalars['timestamptz'];
  /** An object relationship */
  user?: Maybe<Users>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** columns and relationships of "jobs" */
export type JobsGithub_Push_Event_JobsArgs = {
  distinct_on?: Maybe<Array<Github_Push_Event_Job_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Github_Push_Event_Job_Order_By>>;
  where?: Maybe<Github_Push_Event_Job_Bool_Exp>;
};

/** columns and relationships of "jobs" */
export type JobsGithub_Push_Event_Jobs_AggregateArgs = {
  distinct_on?: Maybe<Array<Github_Push_Event_Job_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Github_Push_Event_Job_Order_By>>;
  where?: Maybe<Github_Push_Event_Job_Bool_Exp>;
};

/** columns and relationships of "jobs" */
export type JobsInputArgs = {
  path?: Maybe<Scalars['String']>;
};

/** columns and relationships of "jobs" */
export type JobsTasksArgs = {
  distinct_on?: Maybe<Array<Tasks_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Tasks_Order_By>>;
  where?: Maybe<Tasks_Bool_Exp>;
};

/** columns and relationships of "jobs" */
export type JobsTasks_AggregateArgs = {
  distinct_on?: Maybe<Array<Tasks_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Tasks_Order_By>>;
  where?: Maybe<Tasks_Bool_Exp>;
};

/** aggregated selection of "jobs" */
export type Jobs_Aggregate = {
  __typename?: 'jobs_aggregate';
  aggregate?: Maybe<Jobs_Aggregate_Fields>;
  nodes: Array<Jobs>;
};

export type Jobs_Aggregate_Bool_Exp = {
  count?: Maybe<Jobs_Aggregate_Bool_Exp_Count>;
};

export type Jobs_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Jobs_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Jobs_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "jobs" */
export type Jobs_Aggregate_Fields = {
  __typename?: 'jobs_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Jobs_Max_Fields>;
  min?: Maybe<Jobs_Min_Fields>;
};

/** aggregate fields of "jobs" */
export type Jobs_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Jobs_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "jobs" */
export type Jobs_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Jobs_Max_Order_By>;
  min?: Maybe<Jobs_Min_Order_By>;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Jobs_Append_Input = {
  input?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "jobs" */
export type Jobs_Arr_Rel_Insert_Input = {
  data: Array<Jobs_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Jobs_On_Conflict>;
};

/** Boolean expression to filter rows from the table "jobs". All fields are combined with a logical 'AND'. */
export type Jobs_Bool_Exp = {
  _and?: Maybe<Array<Jobs_Bool_Exp>>;
  _not?: Maybe<Jobs_Bool_Exp>;
  _or?: Maybe<Array<Jobs_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  github_push_event_jobs?: Maybe<Github_Push_Event_Job_Bool_Exp>;
  github_push_event_jobs_aggregate?: Maybe<Github_Push_Event_Job_Aggregate_Bool_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  input?: Maybe<Jsonb_Comparison_Exp>;
  job_type?: Maybe<String_Comparison_Exp>;
  project?: Maybe<Projects_Bool_Exp>;
  project_id?: Maybe<Uuid_Comparison_Exp>;
  project_name?: Maybe<String_Comparison_Exp>;
  status?: Maybe<String_Comparison_Exp>;
  tasks?: Maybe<Tasks_Bool_Exp>;
  tasks_aggregate?: Maybe<Tasks_Aggregate_Bool_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  user?: Maybe<Users_Bool_Exp>;
  user_id?: Maybe<Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "jobs" */
export enum Jobs_Constraint {
  /** unique or primary key constraint on columns "id" */
  JobsPkey = 'jobs_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Jobs_Delete_At_Path_Input = {
  input?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Jobs_Delete_Elem_Input = {
  input?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Jobs_Delete_Key_Input = {
  input?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "jobs" */
export type Jobs_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  github_push_event_jobs?: Maybe<Github_Push_Event_Job_Arr_Rel_Insert_Input>;
  id?: Maybe<Scalars['uuid']>;
  input?: Maybe<Scalars['jsonb']>;
  job_type?: Maybe<Scalars['String']>;
  project?: Maybe<Projects_Obj_Rel_Insert_Input>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  tasks?: Maybe<Tasks_Arr_Rel_Insert_Input>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user?: Maybe<Users_Obj_Rel_Insert_Input>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Jobs_Max_Fields = {
  __typename?: 'jobs_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  job_type?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** order by max() on columns of table "jobs" */
export type Jobs_Max_Order_By = {
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  job_type?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  project_name?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Jobs_Min_Fields = {
  __typename?: 'jobs_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  job_type?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** order by min() on columns of table "jobs" */
export type Jobs_Min_Order_By = {
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  job_type?: Maybe<Order_By>;
  project_id?: Maybe<Order_By>;
  project_name?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  user_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "jobs" */
export type Jobs_Mutation_Response = {
  __typename?: 'jobs_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Jobs>;
};

/** input type for inserting object relation for remote table "jobs" */
export type Jobs_Obj_Rel_Insert_Input = {
  data: Jobs_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Jobs_On_Conflict>;
};

/** on_conflict condition type for table "jobs" */
export type Jobs_On_Conflict = {
  constraint: Jobs_Constraint;
  update_columns?: Array<Jobs_Update_Column>;
  where?: Maybe<Jobs_Bool_Exp>;
};

/** Ordering options when selecting data from "jobs". */
export type Jobs_Order_By = {
  created_at?: Maybe<Order_By>;
  github_push_event_jobs_aggregate?: Maybe<Github_Push_Event_Job_Aggregate_Order_By>;
  id?: Maybe<Order_By>;
  input?: Maybe<Order_By>;
  job_type?: Maybe<Order_By>;
  project?: Maybe<Projects_Order_By>;
  project_id?: Maybe<Order_By>;
  project_name?: Maybe<Order_By>;
  status?: Maybe<Order_By>;
  tasks_aggregate?: Maybe<Tasks_Aggregate_Order_By>;
  updated_at?: Maybe<Order_By>;
  user?: Maybe<Users_Order_By>;
  user_id?: Maybe<Order_By>;
};

/** primary key columns input for table: jobs */
export type Jobs_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Jobs_Prepend_Input = {
  input?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "jobs" */
export enum Jobs_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Input = 'input',
  /** column name */
  JobType = 'job_type',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  ProjectName = 'project_name',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
}

/** input type for updating data in table "jobs" */
export type Jobs_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  input?: Maybe<Scalars['jsonb']>;
  job_type?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** Streaming cursor of the table "jobs" */
export type Jobs_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Jobs_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Jobs_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  input?: Maybe<Scalars['jsonb']>;
  job_type?: Maybe<Scalars['String']>;
  project_id?: Maybe<Scalars['uuid']>;
  project_name?: Maybe<Scalars['String']>;
  status?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  user_id?: Maybe<Scalars['uuid']>;
};

/** update columns of table "jobs" */
export enum Jobs_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  Input = 'input',
  /** column name */
  JobType = 'job_type',
  /** column name */
  ProjectId = 'project_id',
  /** column name */
  ProjectName = 'project_name',
  /** column name */
  Status = 'status',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  UserId = 'user_id',
}

export type Jobs_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Jobs_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Jobs_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Jobs_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Jobs_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Jobs_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Jobs_Set_Input>;
  /** filter the rows which have to be updated */
  where: Jobs_Bool_Exp;
};

export enum JobTypeEnum {
  PreviewApp = 'preview_app',
  RegionMigration = 'region_migration',
  V1ToV2Upgrade = 'v1_to_v2_upgrade',
}

/** Boolean expression to compare columns of type "json". All fields are combined with logical 'AND'. */
export type Json_Comparison_Exp = {
  _eq?: Maybe<Scalars['json']>;
  _gt?: Maybe<Scalars['json']>;
  _gte?: Maybe<Scalars['json']>;
  _in?: Maybe<Array<Scalars['json']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['json']>;
  _lte?: Maybe<Scalars['json']>;
  _neq?: Maybe<Scalars['json']>;
  _nin?: Maybe<Array<Scalars['json']>>;
};

export type Jsonb_Cast_Exp = {
  String?: Maybe<String_Comparison_Exp>;
};

/** Boolean expression to compare columns of type "jsonb". All fields are combined with logical 'AND'. */
export type Jsonb_Comparison_Exp = {
  _cast?: Maybe<Jsonb_Cast_Exp>;
  /** is the column contained in the given json value */
  _contained_in?: Maybe<Scalars['jsonb']>;
  /** does the column contain the given json value at the top level */
  _contains?: Maybe<Scalars['jsonb']>;
  _eq?: Maybe<Scalars['jsonb']>;
  _gt?: Maybe<Scalars['jsonb']>;
  _gte?: Maybe<Scalars['jsonb']>;
  /** does the string exist as a top-level key in the column */
  _has_key?: Maybe<Scalars['String']>;
  /** do all of these strings exist as top-level keys in the column */
  _has_keys_all?: Maybe<Array<Scalars['String']>>;
  /** do any of these strings exist as top-level keys in the column */
  _has_keys_any?: Maybe<Array<Scalars['String']>>;
  _in?: Maybe<Array<Scalars['jsonb']>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _lt?: Maybe<Scalars['jsonb']>;
  _lte?: Maybe<Scalars['jsonb']>;
  _neq?: Maybe<Scalars['jsonb']>;
  _nin?: Maybe<Array<Scalars['jsonb']>>;
};

/** Labels that can be created per user */
export type Label = {
  __typename?: 'label';
  color?: Maybe<Scalars['String']>;
  created_at: Scalars['timetz'];
  created_by: Scalars['uuid'];
  id: Scalars['uuid'];
  name: Scalars['String'];
  /** An array relationship */
  project_labels: Array<Project_Labels>;
  /** An aggregate relationship */
  project_labels_aggregate: Project_Labels_Aggregate;
};

/** Labels that can be created per user */
export type LabelProject_LabelsArgs = {
  distinct_on?: Maybe<Array<Project_Labels_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Project_Labels_Order_By>>;
  where?: Maybe<Project_Labels_Bool_Exp>;
};

/** Labels that can be created per user */
export type LabelProject_Labels_AggregateArgs = {
  distinct_on?: Maybe<Array<Project_Labels_Select_Column>>;
  limit?: Maybe<Scalars['Int']>;
  offset?: Maybe<Scalars['Int']>;
  order_by?: Maybe<Array<Project_Labels_Order_By>>;
  where?: Maybe<Project_Labels_Bool_Exp>;
};

/** aggregated selection of "label" */
export type Label_Aggregate = {
  __typename?: 'label_aggregate';
  aggregate?: Maybe<Label_Aggregate_Fields>;
  nodes: Array<Label>;
};

/** aggregate fields of "label" */
export type Label_Aggregate_Fields = {
  __typename?: 'label_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Label_Max_Fields>;
  min?: Maybe<Label_Min_Fields>;
};

/** aggregate fields of "label" */
export type Label_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Label_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "label". All fields are combined with a logical 'AND'. */
export type Label_Bool_Exp = {
  _and?: Maybe<Array<Label_Bool_Exp>>;
  _not?: Maybe<Label_Bool_Exp>;
  _or?: Maybe<Array<Label_Bool_Exp>>;
  color?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timetz_Comparison_Exp>;
  created_by?: Maybe<Uuid_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
  project_labels?: Maybe<Project_Labels_Bool_Exp>;
  project_labels_aggregate?: Maybe<Project_Labels_Aggregate_Bool_Exp>;
};

/** unique or primary key constraints on table "label" */
export enum Label_Constraint {
  /** unique or primary key constraint on columns "name", "created_by" */
  LabelNameCreatedByKey = 'label_name_created_by_key',
  /** unique or primary key constraint on columns "id" */
  TagPkey = 'tag_pkey',
}

/** input type for inserting data into table "label" */
export type Label_Insert_Input = {
  color?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timetz']>;
  created_by?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
  project_labels?: Maybe<Project_Labels_Arr_Rel_Insert_Input>;
};

/** aggregate max on columns */
export type Label_Max_Fields = {
  __typename?: 'label_max_fields';
  color?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timetz']>;
  created_by?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Label_Min_Fields = {
  __typename?: 'label_min_fields';
  color?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timetz']>;
  created_by?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "label" */
export type Label_Mutation_Response = {
  __typename?: 'label_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Label>;
};

/** input type for inserting object relation for remote table "label" */
export type Label_Obj_Rel_Insert_Input = {
  data: Label_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Label_On_Conflict>;
};

/** on_conflict condition type for table "label" */
export type Label_On_Conflict = {
  constraint: Label_Constraint;
  update_columns?: Array<Label_Update_Column>;
  where?: Maybe<Label_Bool_Exp>;
};

/** Ordering options when selecting data from "label". */
export type Label_Order_By = {
  color?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  created_by?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
  project_labels_aggregate?: Maybe<Project_Labels_Aggregate_Order_By>;
};

/** primary key columns input for table: label */
export type Label_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "label" */
export enum Label_Select_Column {
  /** column name */
  Color = 'color',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedBy = 'created_by',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
}

/** input type for updating data in table "label" */
export type Label_Set_Input = {
  color?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timetz']>;
  created_by?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "label" */
export type Label_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Label_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Label_Stream_Cursor_Value_Input = {
  color?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timetz']>;
  created_by?: Maybe<Scalars['uuid']>;
  id?: Maybe<Scalars['uuid']>;
  name?: Maybe<Scalars['String']>;
};

/** update columns of table "label" */
export enum Label_Update_Column {
  /** column name */
  Color = 'color',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  CreatedBy = 'created_by',
  /** column name */
  Id = 'id',
  /** column name */
  Name = 'name',
}

export type Label_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Label_Set_Input>;
  /** filter the rows which have to be updated */
  where: Label_Bool_Exp;
};

/** letsencrypt status of a gateway worker */
export type Letsencrypt_Status = {
  __typename?: 'letsencrypt_status';
  cert_id: Scalars['String'];
  /** An object relationship */
  custom_domain: Custom_Domain;
  fqdn: Scalars['String'];
  is_active: Scalars['Boolean'];
  message?: Maybe<Scalars['String']>;
  updated_at: Scalars['timestamptz'];
  worker_id: Scalars['uuid'];
};

/** aggregated selection of "letsencrypt_status" */
export type Letsencrypt_Status_Aggregate = {
  __typename?: 'letsencrypt_status_aggregate';
  aggregate?: Maybe<Letsencrypt_Status_Aggregate_Fields>;
  nodes: Array<Letsencrypt_Status>;
};

export type Letsencrypt_Status_Aggregate_Bool_Exp = {
  bool_and?: Maybe<Letsencrypt_Status_Aggregate_Bool_Exp_Bool_And>;
  bool_or?: Maybe<Letsencrypt_Status_Aggregate_Bool_Exp_Bool_Or>;
  count?: Maybe<Letsencrypt_Status_Aggregate_Bool_Exp_Count>;
};

export type Letsencrypt_Status_Aggregate_Bool_Exp_Bool_And = {
  arguments: Letsencrypt_Status_Select_Column_Letsencrypt_Status_Aggregate_Bool_Exp_Bool_And_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Letsencrypt_Status_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Letsencrypt_Status_Aggregate_Bool_Exp_Bool_Or = {
  arguments: Letsencrypt_Status_Select_Column_Letsencrypt_Status_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Letsencrypt_Status_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Letsencrypt_Status_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Letsencrypt_Status_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Letsencrypt_Status_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "letsencrypt_status" */
export type Letsencrypt_Status_Aggregate_Fields = {
  __typename?: 'letsencrypt_status_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Letsencrypt_Status_Max_Fields>;
  min?: Maybe<Letsencrypt_Status_Min_Fields>;
};

/** aggregate fields of "letsencrypt_status" */
export type Letsencrypt_Status_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Letsencrypt_Status_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "letsencrypt_status" */
export type Letsencrypt_Status_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Letsencrypt_Status_Max_Order_By>;
  min?: Maybe<Letsencrypt_Status_Min_Order_By>;
};

/** input type for inserting array relation for remote table "letsencrypt_status" */
export type Letsencrypt_Status_Arr_Rel_Insert_Input = {
  data: Array<Letsencrypt_Status_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Letsencrypt_Status_On_Conflict>;
};

/** Boolean expression to filter rows from the table "letsencrypt_status". All fields are combined with a logical 'AND'. */
export type Letsencrypt_Status_Bool_Exp = {
  _and?: Maybe<Array<Letsencrypt_Status_Bool_Exp>>;
  _not?: Maybe<Letsencrypt_Status_Bool_Exp>;
  _or?: Maybe<Array<Letsencrypt_Status_Bool_Exp>>;
  cert_id?: Maybe<String_Comparison_Exp>;
  custom_domain?: Maybe<Custom_Domain_Bool_Exp>;
  fqdn?: Maybe<String_Comparison_Exp>;
  is_active?: Maybe<Boolean_Comparison_Exp>;
  message?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
  worker_id?: Maybe<Uuid_Comparison_Exp>;
};

/** unique or primary key constraints on table "letsencrypt_status" */
export enum Letsencrypt_Status_Constraint {
  /** unique or primary key constraint on columns "fqdn" */
  LetsencryptStatusPkey = 'letsencrypt_status_pkey',
}

/** input type for inserting data into table "letsencrypt_status" */
export type Letsencrypt_Status_Insert_Input = {
  cert_id?: Maybe<Scalars['String']>;
  custom_domain?: Maybe<Custom_Domain_Obj_Rel_Insert_Input>;
  fqdn?: Maybe<Scalars['String']>;
  is_active?: Maybe<Scalars['Boolean']>;
  message?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** aggregate max on columns */
export type Letsencrypt_Status_Max_Fields = {
  __typename?: 'letsencrypt_status_max_fields';
  cert_id?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  message?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** order by max() on columns of table "letsencrypt_status" */
export type Letsencrypt_Status_Max_Order_By = {
  cert_id?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  message?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Letsencrypt_Status_Min_Fields = {
  __typename?: 'letsencrypt_status_min_fields';
  cert_id?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  message?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** order by min() on columns of table "letsencrypt_status" */
export type Letsencrypt_Status_Min_Order_By = {
  cert_id?: Maybe<Order_By>;
  fqdn?: Maybe<Order_By>;
  message?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** response of any mutation on the table "letsencrypt_status" */
export type Letsencrypt_Status_Mutation_Response = {
  __typename?: 'letsencrypt_status_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Letsencrypt_Status>;
};

/** on_conflict condition type for table "letsencrypt_status" */
export type Letsencrypt_Status_On_Conflict = {
  constraint: Letsencrypt_Status_Constraint;
  update_columns?: Array<Letsencrypt_Status_Update_Column>;
  where?: Maybe<Letsencrypt_Status_Bool_Exp>;
};

/** Ordering options when selecting data from "letsencrypt_status". */
export type Letsencrypt_Status_Order_By = {
  cert_id?: Maybe<Order_By>;
  custom_domain?: Maybe<Custom_Domain_Order_By>;
  fqdn?: Maybe<Order_By>;
  is_active?: Maybe<Order_By>;
  message?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
  worker_id?: Maybe<Order_By>;
};

/** primary key columns input for table: letsencrypt_status */
export type Letsencrypt_Status_Pk_Columns_Input = {
  fqdn: Scalars['String'];
};

/** select columns of table "letsencrypt_status" */
export enum Letsencrypt_Status_Select_Column {
  /** column name */
  CertId = 'cert_id',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  Message = 'message',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  WorkerId = 'worker_id',
}

/** select "letsencrypt_status_aggregate_bool_exp_bool_and_arguments_columns" columns of table "letsencrypt_status" */
export enum Letsencrypt_Status_Select_Column_Letsencrypt_Status_Aggregate_Bool_Exp_Bool_And_Arguments_Columns {
  /** column name */
  IsActive = 'is_active',
}

/** select "letsencrypt_status_aggregate_bool_exp_bool_or_arguments_columns" columns of table "letsencrypt_status" */
export enum Letsencrypt_Status_Select_Column_Letsencrypt_Status_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns {
  /** column name */
  IsActive = 'is_active',
}

/** input type for updating data in table "letsencrypt_status" */
export type Letsencrypt_Status_Set_Input = {
  cert_id?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  is_active?: Maybe<Scalars['Boolean']>;
  message?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** Streaming cursor of the table "letsencrypt_status" */
export type Letsencrypt_Status_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Letsencrypt_Status_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Letsencrypt_Status_Stream_Cursor_Value_Input = {
  cert_id?: Maybe<Scalars['String']>;
  fqdn?: Maybe<Scalars['String']>;
  is_active?: Maybe<Scalars['Boolean']>;
  message?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
  worker_id?: Maybe<Scalars['uuid']>;
};

/** update columns of table "letsencrypt_status" */
export enum Letsencrypt_Status_Update_Column {
  /** column name */
  CertId = 'cert_id',
  /** column name */
  Fqdn = 'fqdn',
  /** column name */
  IsActive = 'is_active',
  /** column name */
  Message = 'message',
  /** column name */
  UpdatedAt = 'updated_at',
  /** column name */
  WorkerId = 'worker_id',
}

export type Letsencrypt_Status_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Letsencrypt_Status_Set_Input>;
  /** filter the rows which have to be updated */
  where: Letsencrypt_Status_Bool_Exp;
};

export type LetsEncryptStatus = {
  __typename?: 'LetsEncryptStatus';
  is_active: Scalars['Boolean'];
  message?: Maybe<Scalars['String']>;
};

/** Record of all manual and automated actions performed on a license.  */
export type License_Activity = {
  __typename?: 'license_activity';
  action: Scalars['String'];
  activity_performed_by: Scalars['String'];
  activity_type: Scalars['String'];
  created_at: Scalars['timestamptz'];
  id: Scalars['uuid'];
  /** An object relationship */
  license?: Maybe<Licenses>;
  license_email: Scalars['String'];
  note?: Maybe<Scalars['String']>;
  updated_at: Scalars['timestamptz'];
};

/** aggregated selection of "license_activity" */
export type License_Activity_Aggregate = {
  __typename?: 'license_activity_aggregate';
  aggregate?: Maybe<License_Activity_Aggregate_Fields>;
  nodes: Array<License_Activity>;
};

/** aggregate fields of "license_activity" */
export type License_Activity_Aggregate_Fields = {
  __typename?: 'license_activity_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<License_Activity_Max_Fields>;
  min?: Maybe<License_Activity_Min_Fields>;
};

/** aggregate fields of "license_activity" */
export type License_Activity_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<License_Activity_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "license_activity". All fields are combined with a logical 'AND'. */
export type License_Activity_Bool_Exp = {
  _and?: Maybe<Array<License_Activity_Bool_Exp>>;
  _not?: Maybe<License_Activity_Bool_Exp>;
  _or?: Maybe<Array<License_Activity_Bool_Exp>>;
  action?: Maybe<String_Comparison_Exp>;
  activity_performed_by?: Maybe<String_Comparison_Exp>;
  activity_type?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  id?: Maybe<Uuid_Comparison_Exp>;
  license?: Maybe<Licenses_Bool_Exp>;
  license_email?: Maybe<String_Comparison_Exp>;
  note?: Maybe<String_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "license_activity" */
export enum License_Activity_Constraint {
  /** unique or primary key constraint on columns "id" */
  LicenseActivityPkey = 'license_activity_pkey',
}

/** input type for inserting data into table "license_activity" */
export type License_Activity_Insert_Input = {
  action?: Maybe<Scalars['String']>;
  activity_performed_by?: Maybe<Scalars['String']>;
  activity_type?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  license?: Maybe<Licenses_Obj_Rel_Insert_Input>;
  license_email?: Maybe<Scalars['String']>;
  note?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type License_Activity_Max_Fields = {
  __typename?: 'license_activity_max_fields';
  action?: Maybe<Scalars['String']>;
  activity_performed_by?: Maybe<Scalars['String']>;
  activity_type?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  license_email?: Maybe<Scalars['String']>;
  note?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type License_Activity_Min_Fields = {
  __typename?: 'license_activity_min_fields';
  action?: Maybe<Scalars['String']>;
  activity_performed_by?: Maybe<Scalars['String']>;
  activity_type?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  license_email?: Maybe<Scalars['String']>;
  note?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "license_activity" */
export type License_Activity_Mutation_Response = {
  __typename?: 'license_activity_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<License_Activity>;
};

/** on_conflict condition type for table "license_activity" */
export type License_Activity_On_Conflict = {
  constraint: License_Activity_Constraint;
  update_columns?: Array<License_Activity_Update_Column>;
  where?: Maybe<License_Activity_Bool_Exp>;
};

/** Ordering options when selecting data from "license_activity". */
export type License_Activity_Order_By = {
  action?: Maybe<Order_By>;
  activity_performed_by?: Maybe<Order_By>;
  activity_type?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  id?: Maybe<Order_By>;
  license?: Maybe<Licenses_Order_By>;
  license_email?: Maybe<Order_By>;
  note?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: license_activity */
export type License_Activity_Pk_Columns_Input = {
  id: Scalars['uuid'];
};

/** select columns of table "license_activity" */
export enum License_Activity_Select_Column {
  /** column name */
  Action = 'action',
  /** column name */
  ActivityPerformedBy = 'activity_performed_by',
  /** column name */
  ActivityType = 'activity_type',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  LicenseEmail = 'license_email',
  /** column name */
  Note = 'note',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "license_activity" */
export type License_Activity_Set_Input = {
  action?: Maybe<Scalars['String']>;
  activity_performed_by?: Maybe<Scalars['String']>;
  activity_type?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  license_email?: Maybe<Scalars['String']>;
  note?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "license_activity" */
export type License_Activity_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: License_Activity_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type License_Activity_Stream_Cursor_Value_Input = {
  action?: Maybe<Scalars['String']>;
  activity_performed_by?: Maybe<Scalars['String']>;
  activity_type?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  id?: Maybe<Scalars['uuid']>;
  license_email?: Maybe<Scalars['String']>;
  note?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "license_activity" */
export enum License_Activity_Update_Column {
  /** column name */
  Action = 'action',
  /** column name */
  ActivityPerformedBy = 'activity_performed_by',
  /** column name */
  ActivityType = 'activity_type',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Id = 'id',
  /** column name */
  LicenseEmail = 'license_email',
  /** column name */
  Note = 'note',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type License_Activity_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<License_Activity_Set_Input>;
  /** filter the rows which have to be updated */
  where: License_Activity_Bool_Exp;
};

/** columns and relationships of "license_instance" */
export type License_Instance = {
  __typename?: 'license_instance';
  created_at: Scalars['timestamptz'];
  email: Scalars['String'];
  metadata_db_id: Scalars['uuid'];
  updated_at: Scalars['timestamptz'];
};

/** aggregated selection of "license_instance" */
export type License_Instance_Aggregate = {
  __typename?: 'license_instance_aggregate';
  aggregate?: Maybe<License_Instance_Aggregate_Fields>;
  nodes: Array<License_Instance>;
};

/** aggregate fields of "license_instance" */
export type License_Instance_Aggregate_Fields = {
  __typename?: 'license_instance_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<License_Instance_Max_Fields>;
  min?: Maybe<License_Instance_Min_Fields>;
};

/** aggregate fields of "license_instance" */
export type License_Instance_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<License_Instance_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "license_instance". All fields are combined with a logical 'AND'. */
export type License_Instance_Bool_Exp = {
  _and?: Maybe<Array<License_Instance_Bool_Exp>>;
  _not?: Maybe<License_Instance_Bool_Exp>;
  _or?: Maybe<Array<License_Instance_Bool_Exp>>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  email?: Maybe<String_Comparison_Exp>;
  metadata_db_id?: Maybe<Uuid_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "license_instance" */
export enum License_Instance_Constraint {
  /** unique or primary key constraint on columns "metadata_db_id" */
  LicenseInstancePkey = 'license_instance_pkey',
}

/** input type for inserting data into table "license_instance" */
export type License_Instance_Insert_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  metadata_db_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type License_Instance_Max_Fields = {
  __typename?: 'license_instance_max_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  metadata_db_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type License_Instance_Min_Fields = {
  __typename?: 'license_instance_min_fields';
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  metadata_db_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "license_instance" */
export type License_Instance_Mutation_Response = {
  __typename?: 'license_instance_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<License_Instance>;
};

/** on_conflict condition type for table "license_instance" */
export type License_Instance_On_Conflict = {
  constraint: License_Instance_Constraint;
  update_columns?: Array<License_Instance_Update_Column>;
  where?: Maybe<License_Instance_Bool_Exp>;
};

/** Ordering options when selecting data from "license_instance". */
export type License_Instance_Order_By = {
  created_at?: Maybe<Order_By>;
  email?: Maybe<Order_By>;
  metadata_db_id?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: license_instance */
export type License_Instance_Pk_Columns_Input = {
  metadata_db_id: Scalars['uuid'];
};

/** select columns of table "license_instance" */
export enum License_Instance_Select_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Email = 'email',
  /** column name */
  MetadataDbId = 'metadata_db_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "license_instance" */
export type License_Instance_Set_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  metadata_db_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "license_instance" */
export type License_Instance_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: License_Instance_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type License_Instance_Stream_Cursor_Value_Input = {
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  metadata_db_id?: Maybe<Scalars['uuid']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "license_instance" */
export enum License_Instance_Update_Column {
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Email = 'email',
  /** column name */
  MetadataDbId = 'metadata_db_id',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type License_Instance_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<License_Instance_Set_Input>;
  /** filter the rows which have to be updated */
  where: License_Instance_Bool_Exp;
};

/** columns and relationships of "license_type" */
export type License_Type = {
  __typename?: 'license_type';
  comment?: Maybe<Scalars['String']>;
  name: Scalars['String'];
};

/** aggregated selection of "license_type" */
export type License_Type_Aggregate = {
  __typename?: 'license_type_aggregate';
  aggregate?: Maybe<License_Type_Aggregate_Fields>;
  nodes: Array<License_Type>;
};

/** aggregate fields of "license_type" */
export type License_Type_Aggregate_Fields = {
  __typename?: 'license_type_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<License_Type_Max_Fields>;
  min?: Maybe<License_Type_Min_Fields>;
};

/** aggregate fields of "license_type" */
export type License_Type_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<License_Type_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "license_type". All fields are combined with a logical 'AND'. */
export type License_Type_Bool_Exp = {
  _and?: Maybe<Array<License_Type_Bool_Exp>>;
  _not?: Maybe<License_Type_Bool_Exp>;
  _or?: Maybe<Array<License_Type_Bool_Exp>>;
  comment?: Maybe<String_Comparison_Exp>;
  name?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "license_type" */
export enum License_Type_Constraint {
  /** unique or primary key constraint on columns "name" */
  LicenseTypePkey = 'license_type_pkey',
}

export enum License_Type_Enum {
  /** A long-lived EE license requested internally */
  Offline = 'offline',
  /** An EE license which has been paid for */
  Paid = 'paid',
  /** An EE license issued for free with a limited validity timespan */
  Trial = 'trial',
}

/** Boolean expression to compare columns of type "license_type_enum". All fields are combined with logical 'AND'. */
export type License_Type_Enum_Comparison_Exp = {
  _eq?: Maybe<License_Type_Enum>;
  _in?: Maybe<Array<License_Type_Enum>>;
  _is_null?: Maybe<Scalars['Boolean']>;
  _neq?: Maybe<License_Type_Enum>;
  _nin?: Maybe<Array<License_Type_Enum>>;
};

/** input type for inserting data into table "license_type" */
export type License_Type_Insert_Input = {
  comment?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type License_Type_Max_Fields = {
  __typename?: 'license_type_max_fields';
  comment?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type License_Type_Min_Fields = {
  __typename?: 'license_type_min_fields';
  comment?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "license_type" */
export type License_Type_Mutation_Response = {
  __typename?: 'license_type_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<License_Type>;
};

/** on_conflict condition type for table "license_type" */
export type License_Type_On_Conflict = {
  constraint: License_Type_Constraint;
  update_columns?: Array<License_Type_Update_Column>;
  where?: Maybe<License_Type_Bool_Exp>;
};

/** Ordering options when selecting data from "license_type". */
export type License_Type_Order_By = {
  comment?: Maybe<Order_By>;
  name?: Maybe<Order_By>;
};

/** primary key columns input for table: license_type */
export type License_Type_Pk_Columns_Input = {
  name: Scalars['String'];
};

/** select columns of table "license_type" */
export enum License_Type_Select_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Name = 'name',
}

/** input type for updating data in table "license_type" */
export type License_Type_Set_Input = {
  comment?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "license_type" */
export type License_Type_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: License_Type_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type License_Type_Stream_Cursor_Value_Input = {
  comment?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

/** update columns of table "license_type" */
export enum License_Type_Update_Column {
  /** column name */
  Comment = 'comment',
  /** column name */
  Name = 'name',
}

export type License_Type_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<License_Type_Set_Input>;
  /** filter the rows which have to be updated */
  where: License_Type_Bool_Exp;
};

/** columns and relationships of "licenses" */
export type Licenses = {
  __typename?: 'licenses';
  client_id: Scalars['uuid'];
  created_at: Scalars['timestamptz'];
  email: Scalars['String'];
  expiry_at: Scalars['timestamptz'];
  grace_at: Scalars['timestamptz'];
  license_type: License_Type_Enum;
  updated_at: Scalars['timestamptz'];
};

/** aggregated selection of "licenses" */
export type Licenses_Aggregate = {
  __typename?: 'licenses_aggregate';
  aggregate?: Maybe<Licenses_Aggregate_Fields>;
  nodes: Array<Licenses>;
};

/** aggregate fields of "licenses" */
export type Licenses_Aggregate_Fields = {
  __typename?: 'licenses_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Licenses_Max_Fields>;
  min?: Maybe<Licenses_Min_Fields>;
};

/** aggregate fields of "licenses" */
export type Licenses_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Licenses_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "licenses". All fields are combined with a logical 'AND'. */
export type Licenses_Bool_Exp = {
  _and?: Maybe<Array<Licenses_Bool_Exp>>;
  _not?: Maybe<Licenses_Bool_Exp>;
  _or?: Maybe<Array<Licenses_Bool_Exp>>;
  client_id?: Maybe<Uuid_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  email?: Maybe<String_Comparison_Exp>;
  expiry_at?: Maybe<Timestamptz_Comparison_Exp>;
  grace_at?: Maybe<Timestamptz_Comparison_Exp>;
  license_type?: Maybe<License_Type_Enum_Comparison_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "licenses" */
export enum Licenses_Constraint {
  /** unique or primary key constraint on columns "email" */
  LicensesPkey = 'licenses_pkey',
}

/** input type for inserting data into table "licenses" */
export type Licenses_Insert_Input = {
  client_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  expiry_at?: Maybe<Scalars['timestamptz']>;
  grace_at?: Maybe<Scalars['timestamptz']>;
  license_type?: Maybe<License_Type_Enum>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Licenses_Max_Fields = {
  __typename?: 'licenses_max_fields';
  client_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  expiry_at?: Maybe<Scalars['timestamptz']>;
  grace_at?: Maybe<Scalars['timestamptz']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate min on columns */
export type Licenses_Min_Fields = {
  __typename?: 'licenses_min_fields';
  client_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  expiry_at?: Maybe<Scalars['timestamptz']>;
  grace_at?: Maybe<Scalars['timestamptz']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** response of any mutation on the table "licenses" */
export type Licenses_Mutation_Response = {
  __typename?: 'licenses_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Licenses>;
};

/** input type for inserting object relation for remote table "licenses" */
export type Licenses_Obj_Rel_Insert_Input = {
  data: Licenses_Insert_Input;
  /** upsert condition */
  on_conflict?: Maybe<Licenses_On_Conflict>;
};

/** on_conflict condition type for table "licenses" */
export type Licenses_On_Conflict = {
  constraint: Licenses_Constraint;
  update_columns?: Array<Licenses_Update_Column>;
  where?: Maybe<Licenses_Bool_Exp>;
};

/** Ordering options when selecting data from "licenses". */
export type Licenses_Order_By = {
  client_id?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  email?: Maybe<Order_By>;
  expiry_at?: Maybe<Order_By>;
  grace_at?: Maybe<Order_By>;
  license_type?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: licenses */
export type Licenses_Pk_Columns_Input = {
  email: Scalars['String'];
};

/** select columns of table "licenses" */
export enum Licenses_Select_Column {
  /** column name */
  ClientId = 'client_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Email = 'email',
  /** column name */
  ExpiryAt = 'expiry_at',
  /** column name */
  GraceAt = 'grace_at',
  /** column name */
  LicenseType = 'license_type',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** input type for updating data in table "licenses" */
export type Licenses_Set_Input = {
  client_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  expiry_at?: Maybe<Scalars['timestamptz']>;
  grace_at?: Maybe<Scalars['timestamptz']>;
  license_type?: Maybe<License_Type_Enum>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "licenses" */
export type Licenses_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Licenses_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Licenses_Stream_Cursor_Value_Input = {
  client_id?: Maybe<Scalars['uuid']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  email?: Maybe<Scalars['String']>;
  expiry_at?: Maybe<Scalars['timestamptz']>;
  grace_at?: Maybe<Scalars['timestamptz']>;
  license_type?: Maybe<License_Type_Enum>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "licenses" */
export enum Licenses_Update_Column {
  /** column name */
  ClientId = 'client_id',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Email = 'email',
  /** column name */
  ExpiryAt = 'expiry_at',
  /** column name */
  GraceAt = 'grace_at',
  /** column name */
  LicenseType = 'license_type',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Licenses_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Licenses_Set_Input>;
  /** filter the rows which have to be updated */
  where: Licenses_Bool_Exp;
};

/** Proxy service used by dedicated VPCs to connect to Lux and other regional resources */
export type Lux_Proxy = {
  __typename?: 'lux_proxy';
  ami_id?: Maybe<Scalars['String']>;
  cloud: Scalars['String'];
  comments?: Maybe<Scalars['String']>;
  created_at: Scalars['timestamptz'];
  disable_infra_auto_apply: Scalars['Boolean'];
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  region: Scalars['String'];
  /** An object relationship */
  region_info?: Maybe<Region>;
  updated_at: Scalars['timestamptz'];
};

/** Proxy service used by dedicated VPCs to connect to Lux and other regional resources */
export type Lux_ProxyInput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** Proxy service used by dedicated VPCs to connect to Lux and other regional resources */
export type Lux_ProxyOutput_VariablesArgs = {
  path?: Maybe<Scalars['String']>;
};

/** aggregated selection of "lux_proxy" */
export type Lux_Proxy_Aggregate = {
  __typename?: 'lux_proxy_aggregate';
  aggregate?: Maybe<Lux_Proxy_Aggregate_Fields>;
  nodes: Array<Lux_Proxy>;
};

export type Lux_Proxy_Aggregate_Bool_Exp = {
  bool_and?: Maybe<Lux_Proxy_Aggregate_Bool_Exp_Bool_And>;
  bool_or?: Maybe<Lux_Proxy_Aggregate_Bool_Exp_Bool_Or>;
  count?: Maybe<Lux_Proxy_Aggregate_Bool_Exp_Count>;
};

export type Lux_Proxy_Aggregate_Bool_Exp_Bool_And = {
  arguments: Lux_Proxy_Select_Column_Lux_Proxy_Aggregate_Bool_Exp_Bool_And_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Lux_Proxy_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Lux_Proxy_Aggregate_Bool_Exp_Bool_Or = {
  arguments: Lux_Proxy_Select_Column_Lux_Proxy_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Lux_Proxy_Bool_Exp>;
  predicate: Boolean_Comparison_Exp;
};

export type Lux_Proxy_Aggregate_Bool_Exp_Count = {
  arguments?: Maybe<Array<Lux_Proxy_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
  filter?: Maybe<Lux_Proxy_Bool_Exp>;
  predicate: Int_Comparison_Exp;
};

/** aggregate fields of "lux_proxy" */
export type Lux_Proxy_Aggregate_Fields = {
  __typename?: 'lux_proxy_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Lux_Proxy_Max_Fields>;
  min?: Maybe<Lux_Proxy_Min_Fields>;
};

/** aggregate fields of "lux_proxy" */
export type Lux_Proxy_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Lux_Proxy_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** order by aggregate values of table "lux_proxy" */
export type Lux_Proxy_Aggregate_Order_By = {
  count?: Maybe<Order_By>;
  max?: Maybe<Lux_Proxy_Max_Order_By>;
  min?: Maybe<Lux_Proxy_Min_Order_By>;
};

/** Represents AMIs generated for lux proxy service */
export type Lux_Proxy_Ami = {
  __typename?: 'lux_proxy_ami';
  ami_id: Scalars['String'];
  cloud: Scalars['String'];
  commit_hash: Scalars['String'];
  created_at: Scalars['timestamptz'];
  region: Scalars['String'];
  remarks: Scalars['String'];
};

/** aggregated selection of "lux_proxy_ami" */
export type Lux_Proxy_Ami_Aggregate = {
  __typename?: 'lux_proxy_ami_aggregate';
  aggregate?: Maybe<Lux_Proxy_Ami_Aggregate_Fields>;
  nodes: Array<Lux_Proxy_Ami>;
};

/** aggregate fields of "lux_proxy_ami" */
export type Lux_Proxy_Ami_Aggregate_Fields = {
  __typename?: 'lux_proxy_ami_aggregate_fields';
  count: Scalars['Int'];
  max?: Maybe<Lux_Proxy_Ami_Max_Fields>;
  min?: Maybe<Lux_Proxy_Ami_Min_Fields>;
};

/** aggregate fields of "lux_proxy_ami" */
export type Lux_Proxy_Ami_Aggregate_FieldsCountArgs = {
  columns?: Maybe<Array<Lux_Proxy_Ami_Select_Column>>;
  distinct?: Maybe<Scalars['Boolean']>;
};

/** Boolean expression to filter rows from the table "lux_proxy_ami". All fields are combined with a logical 'AND'. */
export type Lux_Proxy_Ami_Bool_Exp = {
  _and?: Maybe<Array<Lux_Proxy_Ami_Bool_Exp>>;
  _not?: Maybe<Lux_Proxy_Ami_Bool_Exp>;
  _or?: Maybe<Array<Lux_Proxy_Ami_Bool_Exp>>;
  ami_id?: Maybe<String_Comparison_Exp>;
  cloud?: Maybe<String_Comparison_Exp>;
  commit_hash?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  remarks?: Maybe<String_Comparison_Exp>;
};

/** unique or primary key constraints on table "lux_proxy_ami" */
export enum Lux_Proxy_Ami_Constraint {
  /** unique or primary key constraint on columns "ami_id", "cloud", "region" */
  LuxProxyAmiPkey = 'lux_proxy_ami_pkey',
}

/** input type for inserting data into table "lux_proxy_ami" */
export type Lux_Proxy_Ami_Insert_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** aggregate max on columns */
export type Lux_Proxy_Ami_Max_Fields = {
  __typename?: 'lux_proxy_ami_max_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** aggregate min on columns */
export type Lux_Proxy_Ami_Min_Fields = {
  __typename?: 'lux_proxy_ami_min_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** response of any mutation on the table "lux_proxy_ami" */
export type Lux_Proxy_Ami_Mutation_Response = {
  __typename?: 'lux_proxy_ami_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Lux_Proxy_Ami>;
};

/** on_conflict condition type for table "lux_proxy_ami" */
export type Lux_Proxy_Ami_On_Conflict = {
  constraint: Lux_Proxy_Ami_Constraint;
  update_columns?: Array<Lux_Proxy_Ami_Update_Column>;
  where?: Maybe<Lux_Proxy_Ami_Bool_Exp>;
};

/** Ordering options when selecting data from "lux_proxy_ami". */
export type Lux_Proxy_Ami_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  commit_hash?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  remarks?: Maybe<Order_By>;
};

/** primary key columns input for table: lux_proxy_ami */
export type Lux_Proxy_Ami_Pk_Columns_Input = {
  ami_id: Scalars['String'];
  cloud: Scalars['String'];
  region: Scalars['String'];
};

/** select columns of table "lux_proxy_ami" */
export enum Lux_Proxy_Ami_Select_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CommitHash = 'commit_hash',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Region = 'region',
  /** column name */
  Remarks = 'remarks',
}

/** input type for updating data in table "lux_proxy_ami" */
export type Lux_Proxy_Ami_Set_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** Streaming cursor of the table "lux_proxy_ami" */
export type Lux_Proxy_Ami_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Lux_Proxy_Ami_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Lux_Proxy_Ami_Stream_Cursor_Value_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  commit_hash?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  remarks?: Maybe<Scalars['String']>;
};

/** update columns of table "lux_proxy_ami" */
export enum Lux_Proxy_Ami_Update_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  CommitHash = 'commit_hash',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  Region = 'region',
  /** column name */
  Remarks = 'remarks',
}

export type Lux_Proxy_Ami_Updates = {
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Lux_Proxy_Ami_Set_Input>;
  /** filter the rows which have to be updated */
  where: Lux_Proxy_Ami_Bool_Exp;
};

/** append existing jsonb value of filtered columns with new jsonb value */
export type Lux_Proxy_Append_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** input type for inserting array relation for remote table "lux_proxy" */
export type Lux_Proxy_Arr_Rel_Insert_Input = {
  data: Array<Lux_Proxy_Insert_Input>;
  /** upsert condition */
  on_conflict?: Maybe<Lux_Proxy_On_Conflict>;
};

/** Boolean expression to filter rows from the table "lux_proxy". All fields are combined with a logical 'AND'. */
export type Lux_Proxy_Bool_Exp = {
  _and?: Maybe<Array<Lux_Proxy_Bool_Exp>>;
  _not?: Maybe<Lux_Proxy_Bool_Exp>;
  _or?: Maybe<Array<Lux_Proxy_Bool_Exp>>;
  ami_id?: Maybe<String_Comparison_Exp>;
  cloud?: Maybe<String_Comparison_Exp>;
  comments?: Maybe<String_Comparison_Exp>;
  created_at?: Maybe<Timestamptz_Comparison_Exp>;
  disable_infra_auto_apply?: Maybe<Boolean_Comparison_Exp>;
  infra_status?: Maybe<Infra_Status_Enum_Comparison_Exp>;
  input_variables?: Maybe<Jsonb_Comparison_Exp>;
  output_variables?: Maybe<Jsonb_Comparison_Exp>;
  region?: Maybe<String_Comparison_Exp>;
  region_info?: Maybe<Region_Bool_Exp>;
  updated_at?: Maybe<Timestamptz_Comparison_Exp>;
};

/** unique or primary key constraints on table "lux_proxy" */
export enum Lux_Proxy_Constraint {
  /** unique or primary key constraint on columns "cloud", "region" */
  LuxProxyPkey = 'lux_proxy_pkey',
}

/** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
export type Lux_Proxy_Delete_At_Path_Input = {
  input_variables?: Maybe<Array<Scalars['String']>>;
  output_variables?: Maybe<Array<Scalars['String']>>;
};

/**
 * delete the array element with specified index (negative integers count from the
 * end). throws an error if top level container is not an array
 */
export type Lux_Proxy_Delete_Elem_Input = {
  input_variables?: Maybe<Scalars['Int']>;
  output_variables?: Maybe<Scalars['Int']>;
};

/** delete key/value pair or string element. key/value pairs are matched based on their key value */
export type Lux_Proxy_Delete_Key_Input = {
  input_variables?: Maybe<Scalars['String']>;
  output_variables?: Maybe<Scalars['String']>;
};

/** input type for inserting data into table "lux_proxy" */
export type Lux_Proxy_Insert_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  region?: Maybe<Scalars['String']>;
  region_info?: Maybe<Region_Obj_Rel_Insert_Input>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** aggregate max on columns */
export type Lux_Proxy_Max_Fields = {
  __typename?: 'lux_proxy_max_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by max() on columns of table "lux_proxy" */
export type Lux_Proxy_Max_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  comments?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** aggregate min on columns */
export type Lux_Proxy_Min_Fields = {
  __typename?: 'lux_proxy_min_fields';
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** order by min() on columns of table "lux_proxy" */
export type Lux_Proxy_Min_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  comments?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** response of any mutation on the table "lux_proxy" */
export type Lux_Proxy_Mutation_Response = {
  __typename?: 'lux_proxy_mutation_response';
  /** number of rows affected by the mutation */
  affected_rows: Scalars['Int'];
  /** data from the rows affected by the mutation */
  returning: Array<Lux_Proxy>;
};

/** on_conflict condition type for table "lux_proxy" */
export type Lux_Proxy_On_Conflict = {
  constraint: Lux_Proxy_Constraint;
  update_columns?: Array<Lux_Proxy_Update_Column>;
  where?: Maybe<Lux_Proxy_Bool_Exp>;
};

/** Ordering options when selecting data from "lux_proxy". */
export type Lux_Proxy_Order_By = {
  ami_id?: Maybe<Order_By>;
  cloud?: Maybe<Order_By>;
  comments?: Maybe<Order_By>;
  created_at?: Maybe<Order_By>;
  disable_infra_auto_apply?: Maybe<Order_By>;
  infra_status?: Maybe<Order_By>;
  input_variables?: Maybe<Order_By>;
  output_variables?: Maybe<Order_By>;
  region?: Maybe<Order_By>;
  region_info?: Maybe<Region_Order_By>;
  updated_at?: Maybe<Order_By>;
};

/** primary key columns input for table: lux_proxy */
export type Lux_Proxy_Pk_Columns_Input = {
  cloud: Scalars['String'];
  region: Scalars['String'];
};

/** prepend existing jsonb value of filtered columns with new jsonb value */
export type Lux_Proxy_Prepend_Input = {
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
};

/** select columns of table "lux_proxy" */
export enum Lux_Proxy_Select_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  Comments = 'comments',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  Region = 'region',
  /** column name */
  UpdatedAt = 'updated_at',
}

/** select "lux_proxy_aggregate_bool_exp_bool_and_arguments_columns" columns of table "lux_proxy" */
export enum Lux_Proxy_Select_Column_Lux_Proxy_Aggregate_Bool_Exp_Bool_And_Arguments_Columns {
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
}

/** select "lux_proxy_aggregate_bool_exp_bool_or_arguments_columns" columns of table "lux_proxy" */
export enum Lux_Proxy_Select_Column_Lux_Proxy_Aggregate_Bool_Exp_Bool_Or_Arguments_Columns {
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
}

/** input type for updating data in table "lux_proxy" */
export type Lux_Proxy_Set_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** Streaming cursor of the table "lux_proxy" */
export type Lux_Proxy_Stream_Cursor_Input = {
  /** Stream column input with initial value */
  initial_value: Lux_Proxy_Stream_Cursor_Value_Input;
  /** cursor ordering */
  ordering?: Maybe<Cursor_Ordering>;
};

/** Initial value of the column from where the streaming should start */
export type Lux_Proxy_Stream_Cursor_Value_Input = {
  ami_id?: Maybe<Scalars['String']>;
  cloud?: Maybe<Scalars['String']>;
  comments?: Maybe<Scalars['String']>;
  created_at?: Maybe<Scalars['timestamptz']>;
  disable_infra_auto_apply?: Maybe<Scalars['Boolean']>;
  infra_status?: Maybe<Infra_Status_Enum>;
  input_variables?: Maybe<Scalars['jsonb']>;
  output_variables?: Maybe<Scalars['jsonb']>;
  region?: Maybe<Scalars['String']>;
  updated_at?: Maybe<Scalars['timestamptz']>;
};

/** update columns of table "lux_proxy" */
export enum Lux_Proxy_Update_Column {
  /** column name */
  AmiId = 'ami_id',
  /** column name */
  Cloud = 'cloud',
  /** column name */
  Comments = 'comments',
  /** column name */
  CreatedAt = 'created_at',
  /** column name */
  DisableInfraAutoApply = 'disable_infra_auto_apply',
  /** column name */
  InfraStatus = 'infra_status',
  /** column name */
  InputVariables = 'input_variables',
  /** column name */
  OutputVariables = 'output_variables',
  /** column name */
  Region = 'region',
  /** column name */
  UpdatedAt = 'updated_at',
}

export type Lux_Proxy_Updates = {
  /** append existing jsonb value of filtered columns with new jsonb value */
  _append?: Maybe<Lux_Proxy_Append_Input>;
  /** delete the field or element with specified path (for JSON arrays, negative integers count from the end) */
  _delete_at_path?: Maybe<Lux_Proxy_Delete_At_Path_Input>;
  /**
   * delete the array element with specified index (negative integers count from
   * the end). throws an error if top level container is not an array
   */
  _delete_elem?: Maybe<Lux_Proxy_Delete_Elem_Input>;
  /** delete key/value pair or string element. key/value pairs are matched based on their key value */
  _delete_key?: Maybe<Lux_Proxy_Delete_Key_Input>;
  /** prepend existing jsonb value of filtered columns with new jsonb value */
  _prepend?: Maybe<Lux_Proxy_Prepend_Input>;
  /** sets the columns of the filtered rows to the given values */
  _set?: Maybe<Lux_Proxy_Set_Input>;
  /** filter the rows which have to be updated */
  where: Lux_Proxy_Bool_Exp;
};

export enum ModeEnum {
  Automatic = 'automatic',
  Manual = 'manual',
  PreviewApp = 'previewApp',
}

export type MoveProjectRegionResponse = {
  __typename?: 'MoveProjectRegionResponse';
  project?: Maybe<Projects>;
  projectId: Scalars['uuid'];
};

/** mutation root */
export type Mutation_Root = {
  __typename?: 'mutation_root';
  acceptBillingManagerInvite?: Maybe<BillingManagerInvitation>;
  acceptInvite: ProjectCollaboratorInvitation;
  acceptTransferOwnershipInvite: ProjectOwnershipTransferInvitation;
  addAzureMonitorConfig?: Maybe<AzureMonitorConfigResponse>;
  addCard?: Maybe<StripeCardResponse>;
  addCustomDomain?: Maybe<AddCustomDomainOutput>;
  addDatadogConfig?: Maybe<DatadogConfigResponse>;
  addFeatureRequest?: Maybe<FeatureRequestResponse>;
  addNewrelicConfig?: Maybe<NewrelicConfigResponse>;
  /** Add openTelemetry Integration to a project */
  addOpentelemetryConfig?: Maybe<OpentelemetryConfigResponse>;
  addProject: AddProjectResponse;
  /** Add Prometheus Integration to a project */
  addPrometheusConfig: PrometheusConfigResponse;
  applyCouponCode?: Maybe<CouponStatus>;
  changePlan?: Maybe<PlanResponse>;
  changeUserEmail: ChangeUserEmailRequest;
  checkDBLatency?: Maybe<CheckDbLatencyOutput>;
  completeChangeUserEmailRequest: ChangeUserEmailRequest;
  /** delete data from the table: "connector_deployment" */
  connector_delete_connector_deployment?: Maybe<Connector_Connector_Deployment_Mutation_Response>;
  /** delete single row from the table: "connector_deployment" */
  connector_delete_connector_deployment_by_pk?: Maybe<Connector_Connector_Deployment>;
  /** insert data into the table: "connector_deployment" */
  connector_insert_connector_deployment?: Maybe<Connector_Connector_Deployment_Mutation_Response>;
  /** insert a single row into the table: "connector_deployment" */
  connector_insert_connector_deployment_one?: Maybe<Connector_Connector_Deployment>;
  /** update data of the table: "connector_deployment" */
  connector_update_connector_deployment?: Maybe<Connector_Connector_Deployment_Mutation_Response>;
  /** update single row of the table: "connector_deployment" */
  connector_update_connector_deployment_by_pk?: Maybe<Connector_Connector_Deployment>;
  /** update multiples rows of table: "connector_deployment" */
  connector_update_connector_deployment_many?: Maybe<
    Array<Maybe<Connector_Connector_Deployment_Mutation_Response>>
  >;
  /** Internal utility action to convert a project's entitlements and plan to dedicated_cloud */
  convertToDedicatedCloud?: Maybe<ConvertPlanResponse>;
  createDedicatedVPC?: Maybe<CreateDedicatedVpcResponse>;
  createGithubIntegration?: Maybe<GithubIntegrationStatus>;
  createGitHubPreviewApp?: Maybe<PreviewAppResponse>;
  createInvoice: CreateInvoiceResponse;
  createJob: CreateJobResponse;
  createOneClickDeployment: CreateOneClickDeploymentOutput;
  createPersonalAccessToken: PersonalAccessToken;
  createTenant?: Maybe<CreateTenantResponse>;
  createZendeskSupportTicket: SuccessOrError;
  declineBillingManagerInvite?: Maybe<BillingManagerInvitation>;
  declineInvite: ProjectCollaboratorInvitation;
  declineTransferOwnershipInvite: ProjectOwnershipTransferInvitation;
  /** delete data from the table: "alert_config" */
  delete_alert_config?: Maybe<Alert_Config_Mutation_Response>;
  /** delete data from the table: "alert_config_alert_type" */
  delete_alert_config_alert_type?: Maybe<Alert_Config_Alert_Type_Mutation_Response>;
  /** delete single row from the table: "alert_config_alert_type" */
  delete_alert_config_alert_type_by_pk?: Maybe<Alert_Config_Alert_Type>;
  /** delete single row from the table: "alert_config" */
  delete_alert_config_by_pk?: Maybe<Alert_Config>;
  /** delete data from the table: "alert_config_service" */
  delete_alert_config_service?: Maybe<Alert_Config_Service_Mutation_Response>;
  /** delete single row from the table: "alert_config_service" */
  delete_alert_config_service_by_pk?: Maybe<Alert_Config_Service>;
  /** delete data from the table: "alert_service_type" */
  delete_alert_service_type?: Maybe<Alert_Service_Type_Mutation_Response>;
  /** delete single row from the table: "alert_service_type" */
  delete_alert_service_type_by_pk?: Maybe<Alert_Service_Type>;
  /** delete data from the table: "alert_type" */
  delete_alert_type?: Maybe<Alert_Type_Mutation_Response>;
  /** delete single row from the table: "alert_type" */
  delete_alert_type_by_pk?: Maybe<Alert_Type>;
  /** delete data from the table: "azuremonitor_config" */
  delete_azuremonitor_config?: Maybe<Azuremonitor_Config_Mutation_Response>;
  /** delete single row from the table: "azuremonitor_config" */
  delete_azuremonitor_config_by_pk?: Maybe<Azuremonitor_Config>;
  /** delete data from the table: "billing_address" */
  delete_billing_address?: Maybe<Billing_Address_Mutation_Response>;
  /** delete single row from the table: "billing_address" */
  delete_billing_address_by_pk?: Maybe<Billing_Address>;
  /** delete data from the table: "central_cloud" */
  delete_central_cloud?: Maybe<Central_Cloud_Mutation_Response>;
  /** delete single row from the table: "central_cloud" */
  delete_central_cloud_by_pk?: Maybe<Central_Cloud>;
  /** delete data from the table: "change_email_request" */
  delete_change_email_request?: Maybe<Change_Email_Request_Mutation_Response>;
  /** delete single row from the table: "change_email_request" */
  delete_change_email_request_by_pk?: Maybe<Change_Email_Request>;
  /** delete data from the table: "cicd.deployment_pipeline_config" */
  delete_cicd_deployment_pipeline_config?: Maybe<Cicd_Deployment_Pipeline_Config_Mutation_Response>;
  /** delete single row from the table: "cicd.deployment_pipeline_config" */
  delete_cicd_deployment_pipeline_config_by_pk?: Maybe<Cicd_Deployment_Pipeline_Config>;
  /** delete data from the table: "cicd.deployment_pool" */
  delete_cicd_deployment_pool?: Maybe<Cicd_Deployment_Pool_Mutation_Response>;
  /** delete data from the table: "cicd.deployment_pool_member" */
  delete_cicd_deployment_pool_member?: Maybe<Cicd_Deployment_Pool_Member_Mutation_Response>;
  /** delete data from the table: "cloud" */
  delete_cloud?: Maybe<Cloud_Mutation_Response>;
  /** delete single row from the table: "cloud" */
  delete_cloud_by_pk?: Maybe<Cloud>;
  /** delete data from the table: "cloud_metadata" */
  delete_cloud_metadata?: Maybe<Cloud_Metadata_Mutation_Response>;
  /** delete single row from the table: "cloud_metadata" */
  delete_cloud_metadata_by_pk?: Maybe<Cloud_Metadata>;
  /** delete data from the table: "compute_unit_config" */
  delete_compute_unit_config?: Maybe<Compute_Unit_Config_Mutation_Response>;
  /** delete single row from the table: "compute_unit_config" */
  delete_compute_unit_config_by_pk?: Maybe<Compute_Unit_Config>;
  /** delete data from the table: "config" */
  delete_config?: Maybe<Config_Mutation_Response>;
  /** delete single row from the table: "config" */
  delete_config_by_pk?: Maybe<Config>;
  /** delete data from the table: "config_status" */
  delete_config_status?: Maybe<Config_Status_Mutation_Response>;
  /** delete single row from the table: "config_status" */
  delete_config_status_by_pk?: Maybe<Config_Status>;
  /** delete data from the table: "connector_config" */
  delete_connector_config?: Maybe<Connector_Config_Mutation_Response>;
  /** delete single row from the table: "connector_config" */
  delete_connector_config_by_pk?: Maybe<Connector_Config>;
  /** delete data from the table: "connector_deployments" */
  delete_connector_deployments?: Maybe<Connector_Deployments_Mutation_Response>;
  /** delete single row from the table: "connector_deployments" */
  delete_connector_deployments_by_pk?: Maybe<Connector_Deployments>;
  /** delete data from the table: "coupon" */
  delete_coupon?: Maybe<Coupon_Mutation_Response>;
  /** delete single row from the table: "coupon" */
  delete_coupon_by_pk?: Maybe<Coupon>;
  /** delete data from the table: "coupon_duration" */
  delete_coupon_duration?: Maybe<Coupon_Duration_Mutation_Response>;
  /** delete single row from the table: "coupon_duration" */
  delete_coupon_duration_by_pk?: Maybe<Coupon_Duration>;
  /** delete data from the table: "coupon_type" */
  delete_coupon_type?: Maybe<Coupon_Type_Mutation_Response>;
  /** delete single row from the table: "coupon_type" */
  delete_coupon_type_by_pk?: Maybe<Coupon_Type>;
  /** delete data from the table: "custom_domain" */
  delete_custom_domain?: Maybe<Custom_Domain_Mutation_Response>;
  /** delete single row from the table: "custom_domain" */
  delete_custom_domain_by_pk?: Maybe<Custom_Domain>;
  /** delete data from the table: "custom_domain_cloudflare" */
  delete_custom_domain_cloudflare?: Maybe<Custom_Domain_Cloudflare_Mutation_Response>;
  /** delete single row from the table: "custom_domain_cloudflare" */
  delete_custom_domain_cloudflare_by_pk?: Maybe<Custom_Domain_Cloudflare>;
  /** delete data from the table: "custom_domain_cloudflare_dns" */
  delete_custom_domain_cloudflare_dns?: Maybe<Custom_Domain_Cloudflare_Dns_Mutation_Response>;
  /** delete single row from the table: "custom_domain_cloudflare_dns" */
  delete_custom_domain_cloudflare_dns_by_pk?: Maybe<Custom_Domain_Cloudflare_Dns>;
  /** delete data from the table: "customer_usage" */
  delete_customer_usage?: Maybe<Customer_Usage_Mutation_Response>;
  /** delete single row from the table: "customer_usage" */
  delete_customer_usage_by_pk?: Maybe<Customer_Usage>;
  /** delete data from the table: "data_connector_type" */
  delete_data_connector_type?: Maybe<Data_Connector_Type_Mutation_Response>;
  /** delete single row from the table: "data_connector_type" */
  delete_data_connector_type_by_pk?: Maybe<Data_Connector_Type>;
  /** delete data from the table: "datadog_config" */
  delete_datadog_config?: Maybe<Datadog_Config_Mutation_Response>;
  /** delete single row from the table: "datadog_config" */
  delete_datadog_config_by_pk?: Maybe<Datadog_Config>;
  /** delete data from the table: "db_latency" */
  delete_db_latency?: Maybe<Db_Latency_Mutation_Response>;
  /** delete single row from the table: "db_latency" */
  delete_db_latency_by_pk?: Maybe<Db_Latency>;
  /** delete data from the table: "ddn.build" */
  delete_ddn_build?: Maybe<Ddn_Build_Mutation_Response>;
  /** delete single row from the table: "ddn.build" */
  delete_ddn_build_by_pk?: Maybe<Ddn_Build>;
  /** delete data from the table: "ddn.build_sync_status" */
  delete_ddn_build_sync_status?: Maybe<Ddn_Build_Sync_Status_Mutation_Response>;
  /** delete single row from the table: "ddn.build_sync_status" */
  delete_ddn_build_sync_status_by_pk?: Maybe<Ddn_Build_Sync_Status>;
  /** delete data from the table: "ddn.build_sync_worker" */
  delete_ddn_build_sync_worker?: Maybe<Ddn_Build_Sync_Worker_Mutation_Response>;
  /** delete single row from the table: "ddn.build_sync_worker" */
  delete_ddn_build_sync_worker_by_pk?: Maybe<Ddn_Build_Sync_Worker>;
  /** delete data from the table: "ddn.environment" */
  delete_ddn_environment?: Maybe<Ddn_Environment_Mutation_Response>;
  /** delete single row from the table: "ddn.environment" */
  delete_ddn_environment_by_pk?: Maybe<Ddn_Environment>;
  /** delete data from the table: "ddn.project_entitlement_access" */
  delete_ddn_project_entitlement_access?: Maybe<Ddn_Project_Entitlement_Access_Mutation_Response>;
  /** delete single row from the table: "ddn.project_entitlement_access" */
  delete_ddn_project_entitlement_access_by_pk?: Maybe<Ddn_Project_Entitlement_Access>;
  /** delete data from the table: "ddn.project_entitlement_catalogue" */
  delete_ddn_project_entitlement_catalogue?: Maybe<Ddn_Project_Entitlement_Catalogue_Mutation_Response>;
  /** delete single row from the table: "ddn.project_entitlement_catalogue" */
  delete_ddn_project_entitlement_catalogue_by_pk?: Maybe<Ddn_Project_Entitlement_Catalogue>;
  /** delete data from the table: "ddn.project_entitlement_types" */
  delete_ddn_project_entitlement_types?: Maybe<Ddn_Project_Entitlement_Types_Mutation_Response>;
  /** delete single row from the table: "ddn.project_entitlement_types" */
  delete_ddn_project_entitlement_types_by_pk?: Maybe<Ddn_Project_Entitlement_Types>;
  /** delete data from the table: "ddn.projects" */
  delete_ddn_projects?: Maybe<Ddn_Projects_Mutation_Response>;
  /** delete single row from the table: "ddn.projects" */
  delete_ddn_projects_by_pk?: Maybe<Ddn_Projects>;
  /** delete data from the table: "ddn.tunnel" */
  delete_ddn_tunnel?: Maybe<Ddn_Tunnel_Mutation_Response>;
  /** delete single row from the table: "ddn.tunnel" */
  delete_ddn_tunnel_by_pk?: Maybe<Ddn_Tunnel>;
  /** delete data from the table: "ddn.tunnel_cluster" */
  delete_ddn_tunnel_cluster?: Maybe<Ddn_Tunnel_Cluster_Mutation_Response>;
  /** delete single row from the table: "ddn.tunnel_cluster" */
  delete_ddn_tunnel_cluster_by_pk?: Maybe<Ddn_Tunnel_Cluster>;
  /** delete data from the table: "dedicated_cloud_bills" */
  delete_dedicated_cloud_bills?: Maybe<Dedicated_Cloud_Bills_Mutation_Response>;
  /** delete single row from the table: "dedicated_cloud_bills" */
  delete_dedicated_cloud_bills_by_pk?: Maybe<Dedicated_Cloud_Bills>;
  /** delete data from the table: "dedicated_cloud_bills_details" */
  delete_dedicated_cloud_bills_details?: Maybe<Dedicated_Cloud_Bills_Details_Mutation_Response>;
  /** delete single row from the table: "dedicated_cloud_bills_details" */
  delete_dedicated_cloud_bills_details_by_pk?: Maybe<Dedicated_Cloud_Bills_Details>;
  /** delete data from the table: "dedicated_cloud_commitments" */
  delete_dedicated_cloud_commitments?: Maybe<Dedicated_Cloud_Commitments_Mutation_Response>;
  /** delete single row from the table: "dedicated_cloud_commitments" */
  delete_dedicated_cloud_commitments_by_pk?: Maybe<Dedicated_Cloud_Commitments>;
  /** delete data from the table: "dedicated_vpc" */
  delete_dedicated_vpc?: Maybe<Dedicated_Vpc_Mutation_Response>;
  /** delete single row from the table: "dedicated_vpc" */
  delete_dedicated_vpc_by_pk?: Maybe<Dedicated_Vpc>;
  /** delete data from the table: "delete_user" */
  delete_delete_user?: Maybe<Delete_User_Mutation_Response>;
  /** delete single row from the table: "delete_user" */
  delete_delete_user_by_pk?: Maybe<Delete_User>;
  /** delete data from the table: "delete_user_status" */
  delete_delete_user_status?: Maybe<Delete_User_Status_Mutation_Response>;
  /** delete single row from the table: "delete_user_status" */
  delete_delete_user_status_by_pk?: Maybe<Delete_User_Status>;
  /** delete data from the table: "delete_user_tasks" */
  delete_delete_user_tasks?: Maybe<Delete_User_Tasks_Mutation_Response>;
  /** delete single row from the table: "delete_user_tasks" */
  delete_delete_user_tasks_by_pk?: Maybe<Delete_User_Tasks>;
  /** delete data from the table: "email_log" */
  delete_email_log?: Maybe<Email_Log_Mutation_Response>;
  /** delete single row from the table: "email_log" */
  delete_email_log_by_pk?: Maybe<Email_Log>;
  /** delete data from the table: "enterprise_users" */
  delete_enterprise_users?: Maybe<Enterprise_Users_Mutation_Response>;
  /** delete single row from the table: "enterprise_users" */
  delete_enterprise_users_by_pk?: Maybe<Enterprise_Users>;
  /** delete data from the table: "experiments" */
  delete_experiments?: Maybe<Experiments_Mutation_Response>;
  /** delete single row from the table: "experiments" */
  delete_experiments_by_pk?: Maybe<Experiments>;
  /** delete data from the table: "experiments_cohort" */
  delete_experiments_cohort?: Maybe<Experiments_Cohort_Mutation_Response>;
  /** delete single row from the table: "experiments_cohort" */
  delete_experiments_cohort_by_pk?: Maybe<Experiments_Cohort>;
  /** delete data from the table: "experiments_config" */
  delete_experiments_config?: Maybe<Experiments_Config_Mutation_Response>;
  /** delete single row from the table: "experiments_config" */
  delete_experiments_config_by_pk?: Maybe<Experiments_Config>;
  /** delete data from the table: "feature" */
  delete_feature?: Maybe<Feature_Mutation_Response>;
  /** delete data from the table: "feature_access" */
  delete_feature_access?: Maybe<Feature_Access_Mutation_Response>;
  /** delete single row from the table: "feature_access" */
  delete_feature_access_by_pk?: Maybe<Feature_Access>;
  /** delete single row from the table: "feature" */
  delete_feature_by_pk?: Maybe<Feature>;
  /** delete data from the table: "feature_config" */
  delete_feature_config?: Maybe<Feature_Config_Mutation_Response>;
  /** delete single row from the table: "feature_config" */
  delete_feature_config_by_pk?: Maybe<Feature_Config>;
  /** delete data from the table: "gateway_ami" */
  delete_gateway_ami?: Maybe<Gateway_Ami_Mutation_Response>;
  /** delete single row from the table: "gateway_ami" */
  delete_gateway_ami_by_pk?: Maybe<Gateway_Ami>;
  /** delete data from the table: "gateway_cluster" */
  delete_gateway_cluster?: Maybe<Gateway_Cluster_Mutation_Response>;
  /** delete single row from the table: "gateway_cluster" */
  delete_gateway_cluster_by_pk?: Maybe<Gateway_Cluster>;
  /** delete data from the table: "gateway_worker" */
  delete_gateway_worker?: Maybe<Gateway_Worker_Mutation_Response>;
  /** delete single row from the table: "gateway_worker" */
  delete_gateway_worker_by_pk?: Maybe<Gateway_Worker>;
  /** delete data from the table: "github_email_type" */
  delete_github_email_type?: Maybe<Github_Email_Type_Mutation_Response>;
  /** delete single row from the table: "github_email_type" */
  delete_github_email_type_by_pk?: Maybe<Github_Email_Type>;
  /** delete data from the table: "github_integration_config" */
  delete_github_integration_config?: Maybe<Github_Integration_Config_Mutation_Response>;
  /** delete single row from the table: "github_integration_config" */
  delete_github_integration_config_by_pk?: Maybe<Github_Integration_Config>;
  /** delete data from the table: "github_integration_mode" */
  delete_github_integration_mode?: Maybe<Github_Integration_Mode_Mutation_Response>;
  /** delete single row from the table: "github_integration_mode" */
  delete_github_integration_mode_by_pk?: Maybe<Github_Integration_Mode>;
  /** delete data from the table: "github_push_event" */
  delete_github_push_event?: Maybe<Github_Push_Event_Mutation_Response>;
  /** delete single row from the table: "github_push_event" */
  delete_github_push_event_by_pk?: Maybe<Github_Push_Event>;
  /** delete data from the table: "github_push_event_job" */
  delete_github_push_event_job?: Maybe<Github_Push_Event_Job_Mutation_Response>;
  /** delete single row from the table: "github_push_event_job" */
  delete_github_push_event_job_by_pk?: Maybe<Github_Push_Event_Job>;
  /** delete data from the table: "hasura_ami" */
  delete_hasura_ami?: Maybe<Hasura_Ami_Mutation_Response>;
  /** delete single row from the table: "hasura_ami" */
  delete_hasura_ami_by_pk?: Maybe<Hasura_Ami>;
  /** delete data from the table: "hasura_cluster" */
  delete_hasura_cluster?: Maybe<Hasura_Cluster_Mutation_Response>;
  /** delete single row from the table: "hasura_cluster" */
  delete_hasura_cluster_by_pk?: Maybe<Hasura_Cluster>;
  /** delete data from the table: "hasura_worker" */
  delete_hasura_worker?: Maybe<Hasura_Worker_Mutation_Response>;
  /** delete single row from the table: "hasura_worker" */
  delete_hasura_worker_by_pk?: Maybe<Hasura_Worker>;
  /** delete data from the table: "heroku_integrations" */
  delete_heroku_integrations?: Maybe<Heroku_Integrations_Mutation_Response>;
  /** delete single row from the table: "heroku_integrations" */
  delete_heroku_integrations_by_pk?: Maybe<Heroku_Integrations>;
  /** delete data from the table: "inactive_project_exclusions" */
  delete_inactive_project_exclusions?: Maybe<Inactive_Project_Exclusions_Mutation_Response>;
  /** delete single row from the table: "inactive_project_exclusions" */
  delete_inactive_project_exclusions_by_pk?: Maybe<Inactive_Project_Exclusions>;
  /** delete data from the table: "inactive_project_notifications" */
  delete_inactive_project_notifications?: Maybe<Inactive_Project_Notifications_Mutation_Response>;
  /** delete single row from the table: "inactive_project_notifications" */
  delete_inactive_project_notifications_by_pk?: Maybe<Inactive_Project_Notifications>;
  /** delete data from the table: "inactive_project_suspension_config" */
  delete_inactive_project_suspension_config?: Maybe<Inactive_Project_Suspension_Config_Mutation_Response>;
  /** delete data from the table: "infra_status" */
  delete_infra_status?: Maybe<Infra_Status_Mutation_Response>;
  /** delete single row from the table: "infra_status" */
  delete_infra_status_by_pk?: Maybe<Infra_Status>;
  /** delete data from the table: "invoice" */
  delete_invoice?: Maybe<Invoice_Mutation_Response>;
  /** delete single row from the table: "invoice" */
  delete_invoice_by_pk?: Maybe<Invoice>;
  /** delete data from the table: "invoice_coupon_discount" */
  delete_invoice_coupon_discount?: Maybe<Invoice_Coupon_Discount_Mutation_Response>;
  /** delete single row from the table: "invoice_coupon_discount" */
  delete_invoice_coupon_discount_by_pk?: Maybe<Invoice_Coupon_Discount>;
  /** delete data from the table: "invoice_item" */
  delete_invoice_item?: Maybe<Invoice_Item_Mutation_Response>;
  /** delete single row from the table: "invoice_item" */
  delete_invoice_item_by_pk?: Maybe<Invoice_Item>;
  /** delete data from the table: "jobs" */
  delete_jobs?: Maybe<Jobs_Mutation_Response>;
  /** delete single row from the table: "jobs" */
  delete_jobs_by_pk?: Maybe<Jobs>;
  /** delete data from the table: "label" */
  delete_label?: Maybe<Label_Mutation_Response>;
  /** delete single row from the table: "label" */
  delete_label_by_pk?: Maybe<Label>;
  /** delete data from the table: "letsencrypt_status" */
  delete_letsencrypt_status?: Maybe<Letsencrypt_Status_Mutation_Response>;
  /** delete single row from the table: "letsencrypt_status" */
  delete_letsencrypt_status_by_pk?: Maybe<Letsencrypt_Status>;
  /** delete data from the table: "license_activity" */
  delete_license_activity?: Maybe<License_Activity_Mutation_Response>;
  /** delete single row from the table: "license_activity" */
  delete_license_activity_by_pk?: Maybe<License_Activity>;
  /** delete data from the table: "license_instance" */
  delete_license_instance?: Maybe<License_Instance_Mutation_Response>;
  /** delete single row from the table: "license_instance" */
  delete_license_instance_by_pk?: Maybe<License_Instance>;
  /** delete data from the table: "license_type" */
  delete_license_type?: Maybe<License_Type_Mutation_Response>;
  /** delete single row from the table: "license_type" */
  delete_license_type_by_pk?: Maybe<License_Type>;
  /** delete data from the table: "licenses" */
  delete_licenses?: Maybe<Licenses_Mutation_Response>;
  /** delete single row from the table: "licenses" */
  delete_licenses_by_pk?: Maybe<Licenses>;
  /** delete data from the table: "lux_proxy" */
  delete_lux_proxy?: Maybe<Lux_Proxy_Mutation_Response>;
  /** delete data from the table: "lux_proxy_ami" */
  delete_lux_proxy_ami?: Maybe<Lux_Proxy_Ami_Mutation_Response>;
  /** delete single row from the table: "lux_proxy_ami" */
  delete_lux_proxy_ami_by_pk?: Maybe<Lux_Proxy_Ami>;
  /** delete single row from the table: "lux_proxy" */
  delete_lux_proxy_by_pk?: Maybe<Lux_Proxy>;
  /** delete data from the table: "neon_db_integration" */
  delete_neon_db_integration?: Maybe<Neon_Db_Integration_Mutation_Response>;
  /** delete single row from the table: "neon_db_integration" */
  delete_neon_db_integration_by_pk?: Maybe<Neon_Db_Integration>;
  /** delete data from the table: "newrelic_config" */
  delete_newrelic_config?: Maybe<Newrelic_Config_Mutation_Response>;
  /** delete single row from the table: "newrelic_config" */
  delete_newrelic_config_by_pk?: Maybe<Newrelic_Config>;
  /** delete data from the table: "node_pool_type" */
  delete_node_pool_type?: Maybe<Node_Pool_Type_Mutation_Response>;
  /** delete single row from the table: "node_pool_type" */
  delete_node_pool_type_by_pk?: Maybe<Node_Pool_Type>;
  /** delete data from the table: "node_pools" */
  delete_node_pools?: Maybe<Node_Pools_Mutation_Response>;
  /** delete single row from the table: "node_pools" */
  delete_node_pools_by_pk?: Maybe<Node_Pools>;
  /** delete data from the table: "notification" */
  delete_notification?: Maybe<Notification_Mutation_Response>;
  /** delete single row from the table: "notification" */
  delete_notification_by_pk?: Maybe<Notification>;
  /** delete data from the table: "notification_type" */
  delete_notification_type?: Maybe<Notification_Type_Mutation_Response>;
  /** delete single row from the table: "notification_type" */
  delete_notification_type_by_pk?: Maybe<Notification_Type>;
  /** delete data from the table: "onboarding_sample_db_cohort" */
  delete_onboarding_sample_db_cohort?: Maybe<Onboarding_Sample_Db_Cohort_Mutation_Response>;
  /** delete single row from the table: "onboarding_sample_db_cohort" */
  delete_onboarding_sample_db_cohort_by_pk?: Maybe<Onboarding_Sample_Db_Cohort>;
  /** delete data from the table: "onboarding_sample_db_config" */
  delete_onboarding_sample_db_config?: Maybe<Onboarding_Sample_Db_Config_Mutation_Response>;
  /** delete single row from the table: "onboarding_sample_db_config" */
  delete_onboarding_sample_db_config_by_pk?: Maybe<Onboarding_Sample_Db_Config>;
  /** delete data from the table: "one_click_deployment" */
  delete_one_click_deployment?: Maybe<One_Click_Deployment_Mutation_Response>;
  /** delete single row from the table: "one_click_deployment" */
  delete_one_click_deployment_by_pk?: Maybe<One_Click_Deployment>;
  /** delete data from the table: "one_click_deployment_sample_apps" */
  delete_one_click_deployment_sample_apps?: Maybe<One_Click_Deployment_Sample_Apps_Mutation_Response>;
  /** delete single row from the table: "one_click_deployment_sample_apps" */
  delete_one_click_deployment_sample_apps_by_pk?: Maybe<One_Click_Deployment_Sample_Apps>;
  /** delete data from the table: "one_click_deployment_state_log" */
  delete_one_click_deployment_state_log?: Maybe<One_Click_Deployment_State_Log_Mutation_Response>;
  /** delete single row from the table: "one_click_deployment_state_log" */
  delete_one_click_deployment_state_log_by_pk?: Maybe<One_Click_Deployment_State_Log>;
  /** delete data from the table: "one_click_deployment_states" */
  delete_one_click_deployment_states?: Maybe<One_Click_Deployment_States_Mutation_Response>;
  /** delete single row from the table: "one_click_deployment_states" */
  delete_one_click_deployment_states_by_pk?: Maybe<One_Click_Deployment_States>;
  /** delete data from the table: "opentelemetry_config" */
  delete_opentelemetry_config?: Maybe<Opentelemetry_Config_Mutation_Response>;
  /** delete single row from the table: "opentelemetry_config" */
  delete_opentelemetry_config_by_pk?: Maybe<Opentelemetry_Config>;
  /** delete data from the table: "operations.delete_free_plan_dns_records_nov_2021" */
  delete_operations_delete_free_plan_dns_records_nov_2021?: Maybe<Operations_Delete_Free_Plan_Dns_Records_Nov_2021_Mutation_Response>;
  /** delete single row from the table: "operations.delete_free_plan_dns_records_nov_2021" */
  delete_operations_delete_free_plan_dns_records_nov_2021_by_pk?: Maybe<Operations_Delete_Free_Plan_Dns_Records_Nov_2021>;
  /** delete data from the table: "operations.tenant" */
  delete_operations_tenant?: Maybe<Operations_Tenant_Mutation_Response>;
  /** delete data from the table: "payment_method" */
  delete_payment_method?: Maybe<Payment_Method_Mutation_Response>;
  /** delete single row from the table: "payment_method" */
  delete_payment_method_by_pk?: Maybe<Payment_Method>;
  /** delete data from the table: "plan_entitlements" */
  delete_plan_entitlements?: Maybe<Plan_Entitlements_Mutation_Response>;
  /** delete single row from the table: "plan_entitlements" */
  delete_plan_entitlements_by_pk?: Maybe<Plan_Entitlements>;
  /** delete data from the table: "plans" */
  delete_plans?: Maybe<Plans_Mutation_Response>;
  /** delete single row from the table: "plans" */
  delete_plans_by_pk?: Maybe<Plans>;
  /** delete data from the table: "policies" */
  delete_policies?: Maybe<Policies_Mutation_Response>;
  /** delete single row from the table: "policies" */
  delete_policies_by_pk?: Maybe<Policies>;
  /** delete data from the table: "privileges" */
  delete_privileges?: Maybe<Privileges_Mutation_Response>;
  /** delete single row from the table: "privileges" */
  delete_privileges_by_pk?: Maybe<Privileges>;
  /** delete data from the table: "pro_license_keys" */
  delete_pro_license_keys?: Maybe<Pro_License_Keys_Mutation_Response>;
  /** delete single row from the table: "pro_license_keys" */
  delete_pro_license_keys_by_pk?: Maybe<Pro_License_Keys>;
  /** delete data from the table: "project_activity" */
  delete_project_activity?: Maybe<Project_Activity_Mutation_Response>;
  /** delete single row from the table: "project_activity" */
  delete_project_activity_by_pk?: Maybe<Project_Activity>;
  /** delete data from the table: "project_billing_manager_invitations" */
  delete_project_billing_manager_invitations?: Maybe<Project_Billing_Manager_Invitations_Mutation_Response>;
  /** delete single row from the table: "project_billing_manager_invitations" */
  delete_project_billing_manager_invitations_by_pk?: Maybe<Project_Billing_Manager_Invitations>;
  /** delete data from the table: "project_collaborator_allowed_schema_tables" */
  delete_project_collaborator_allowed_schema_tables?: Maybe<Project_Collaborator_Allowed_Schema_Tables_Mutation_Response>;
  /** delete single row from the table: "project_collaborator_allowed_schema_tables" */
  delete_project_collaborator_allowed_schema_tables_by_pk?: Maybe<Project_Collaborator_Allowed_Schema_Tables>;
  /** delete data from the table: "project_collaborator_allowed_schemas" */
  delete_project_collaborator_allowed_schemas?: Maybe<Project_Collaborator_Allowed_Schemas_Mutation_Response>;
  /** delete single row from the table: "project_collaborator_allowed_schemas" */
  delete_project_collaborator_allowed_schemas_by_pk?: Maybe<Project_Collaborator_Allowed_Schemas>;
  /** delete data from the table: "project_collaborator_invitations" */
  delete_project_collaborator_invitations?: Maybe<Project_Collaborator_Invitations_Mutation_Response>;
  /** delete single row from the table: "project_collaborator_invitations" */
  delete_project_collaborator_invitations_by_pk?: Maybe<Project_Collaborator_Invitations>;
  /** delete data from the table: "project_collaborator_privileges" */
  delete_project_collaborator_privileges?: Maybe<Project_Collaborator_Privileges_Mutation_Response>;
  /** delete single row from the table: "project_collaborator_privileges" */
  delete_project_collaborator_privileges_by_pk?: Maybe<Project_Collaborator_Privileges>;
  /** delete data from the table: "project_collaborators" */
  delete_project_collaborators?: Maybe<Project_Collaborators_Mutation_Response>;
  /** delete single row from the table: "project_collaborators" */
  delete_project_collaborators_by_pk?: Maybe<Project_Collaborators>;
  /** delete data from the table: "project_data_usage" */
  delete_project_data_usage?: Maybe<Project_Data_Usage_Mutation_Response>;
  /** delete data from the table: "project_data_usage_agg" */
  delete_project_data_usage_agg?: Maybe<Project_Data_Usage_Agg_Mutation_Response>;
  /** delete data from the table: "project_data_usage_agg_user" */
  delete_project_data_usage_agg_user?: Maybe<Project_Data_Usage_Agg_User_Mutation_Response>;
  /** delete single row from the table: "project_data_usage" */
  delete_project_data_usage_by_pk?: Maybe<Project_Data_Usage>;
  /** delete data from the table: "project_data_usage_components" */
  delete_project_data_usage_components?: Maybe<Project_Data_Usage_Components_Mutation_Response>;
  /** delete data from the table: "project_data_usage_prometheus" */
  delete_project_data_usage_prometheus?: Maybe<Project_Data_Usage_Prometheus_Mutation_Response>;
  /** delete data from the table: "project_data_usage_prometheus_agg_user" */
  delete_project_data_usage_prometheus_agg_user?: Maybe<Project_Data_Usage_Prometheus_Agg_User_Mutation_Response>;
  /** delete single row from the table: "project_data_usage_prometheus" */
  delete_project_data_usage_prometheus_by_pk?: Maybe<Project_Data_Usage_Prometheus>;
  /** delete data from the table: "project_data_usage_report" */
  delete_project_data_usage_report?: Maybe<Project_Data_Usage_Report_Mutation_Response>;
  /** delete single row from the table: "project_data_usage_report" */
  delete_project_data_usage_report_by_pk?: Maybe<Project_Data_Usage_Report>;
  /** delete data from the table: "project_db_usage" */
  delete_project_db_usage?: Maybe<Project_Db_Usage_Mutation_Response>;
  /** delete data from the table: "project_db_usage_agg_user" */
  delete_project_db_usage_agg_user?: Maybe<Project_Db_Usage_Agg_User_Mutation_Response>;
  /** delete single row from the table: "project_db_usage" */
  delete_project_db_usage_by_pk?: Maybe<Project_Db_Usage>;
  /** delete data from the table: "project_entitlement_access" */
  delete_project_entitlement_access?: Maybe<Project_Entitlement_Access_Mutation_Response>;
  /** delete single row from the table: "project_entitlement_access" */
  delete_project_entitlement_access_by_pk?: Maybe<Project_Entitlement_Access>;
  /** delete data from the table: "project_entitlement_catalogue" */
  delete_project_entitlement_catalogue?: Maybe<Project_Entitlement_Catalogue_Mutation_Response>;
  /** delete single row from the table: "project_entitlement_catalogue" */
  delete_project_entitlement_catalogue_by_pk?: Maybe<Project_Entitlement_Catalogue>;
  /** delete data from the table: "project_entitlement_types" */
  delete_project_entitlement_types?: Maybe<Project_Entitlement_Types_Mutation_Response>;
  /** delete single row from the table: "project_entitlement_types" */
  delete_project_entitlement_types_by_pk?: Maybe<Project_Entitlement_Types>;
  /** delete data from the table: "project_labels" */
  delete_project_labels?: Maybe<Project_Labels_Mutation_Response>;
  /** delete single row from the table: "project_labels" */
  delete_project_labels_by_pk?: Maybe<Project_Labels>;
  /** delete data from the table: "project_metadata" */
  delete_project_metadata?: Maybe<Project_Metadata_Mutation_Response>;
  /** delete single row from the table: "project_metadata" */
  delete_project_metadata_by_pk?: Maybe<Project_Metadata>;
  /** delete data from the table: "project_notification" */
  delete_project_notification?: Maybe<Project_Notification_Mutation_Response>;
  /** delete single row from the table: "project_notification" */
  delete_project_notification_by_pk?: Maybe<Project_Notification>;
  /** delete data from the table: "project_ownership_transfer_invitations" */
  delete_project_ownership_transfer_invitations?: Maybe<Project_Ownership_Transfer_Invitations_Mutation_Response>;
  /** delete single row from the table: "project_ownership_transfer_invitations" */
  delete_project_ownership_transfer_invitations_by_pk?: Maybe<Project_Ownership_Transfer_Invitations>;
  /** delete data from the table: "project_requests_count" */
  delete_project_requests_count?: Maybe<Project_Requests_Count_Mutation_Response>;
  /** delete single row from the table: "project_requests_count" */
  delete_project_requests_count_by_pk?: Maybe<Project_Requests_Count>;
  /** delete data from the table: "project_stats" */
  delete_project_stats?: Maybe<Project_Stats_Mutation_Response>;
  /** delete single row from the table: "project_stats" */
  delete_project_stats_by_pk?: Maybe<Project_Stats>;
  /** delete data from the table: "project_total_db_usage_agg" */
  delete_project_total_db_usage_agg?: Maybe<Project_Total_Db_Usage_Agg_Mutation_Response>;
  /** delete data from the table: "projects" */
  delete_projects?: Maybe<Projects_Mutation_Response>;
  /** delete single row from the table: "projects" */
  delete_projects_by_pk?: Maybe<Projects>;
  /** delete data from the table: "projects_pool_config" */
  delete_projects_pool_config?: Maybe<Projects_Pool_Config_Mutation_Response>;
  /** delete single row from the table: "projects_pool_config" */
  delete_projects_pool_config_by_pk?: Maybe<Projects_Pool_Config>;
  /** delete data from the table: "projects_pro_key_generations" */
  delete_projects_pro_key_generations?: Maybe<Projects_Pro_Key_Generations_Mutation_Response>;
  /** delete single row from the table: "projects_pro_key_generations" */
  delete_projects_pro_key_generations_by_pk?: Maybe<Projects_Pro_Key_Generations>;
  /** delete data from the table: "prometheus_config" */
  delete_prometheus_config?: Maybe<Prometheus_Config_Mutation_Response>;
  /** delete single row from the table: "prometheus_config" */
  delete_prometheus_config_by_pk?: Maybe<Prometheus_Config>;
  /** delete data from the table: "providers" */
  delete_providers?: Maybe<Providers_Mutation_Response>;
  /** delete single row from the table: "providers" */
  delete_providers_by_pk?: Maybe<Providers>;
  /** delete data from the table: "provisioning" */
  delete_provisioning?: Maybe<Provisioning_Mutation_Response>;
  /** delete single row from the table: "provisioning" */
  delete_provisioning_by_pk?: Maybe<Provisioning>;
  /** delete data from the table: "region" */
  delete_region?: Maybe<Region_Mutation_Response>;
  /** delete single row from the table: "region" */
  delete_region_by_pk?: Maybe<Region>;
  /** delete data from the table: "region_v2" */
  delete_region_v2?: Maybe<Region_V2_Mutation_Response>;
  /** delete data from the table: "regional_data_connectors" */
  delete_regional_data_connectors?: Maybe<Regional_Data_Connectors_Mutation_Response>;
  /** delete single row from the table: "regional_data_connectors" */
  delete_regional_data_connectors_by_pk?: Maybe<Regional_Data_Connectors>;
  /** delete data from the table: "regional_metrics" */
  delete_regional_metrics?: Maybe<Regional_Metrics_Mutation_Response>;
  /** delete single row from the table: "regional_metrics" */
  delete_regional_metrics_by_pk?: Maybe<Regional_Metrics>;
  /** delete data from the table: "saml_idp" */
  delete_saml_idp?: Maybe<Saml_Idp_Mutation_Response>;
  /** delete single row from the table: "saml_idp" */
  delete_saml_idp_by_pk?: Maybe<Saml_Idp>;
  /** delete data from the table: "search_project_login_status_results" */
  delete_search_project_login_status_results?: Maybe<Search_Project_Login_Status_Results_Mutation_Response>;
  /** delete data from the table: "slack_config" */
  delete_slack_config?: Maybe<Slack_Config_Mutation_Response>;
  /** delete single row from the table: "slack_config" */
  delete_slack_config_by_pk?: Maybe<Slack_Config>;
  /** delete data from the table: "stripe_subscription" */
  delete_stripe_subscription?: Maybe<Stripe_Subscription_Mutation_Response>;
  /** delete single row from the table: "stripe_subscription" */
  delete_stripe_subscription_by_pk?: Maybe<Stripe_Subscription>;
  /** delete data from the table: "stripe_webhook_events" */
  delete_stripe_webhook_events?: Maybe<Stripe_Webhook_Events_Mutation_Response>;
  /** delete single row from the table: "stripe_webhook_events" */
  delete_stripe_webhook_events_by_pk?: Maybe<Stripe_Webhook_Events>;
  /** delete data from the table: "super_connector_types" */
  delete_super_connector_types?: Maybe<Super_Connector_Types_Mutation_Response>;
  /** delete single row from the table: "super_connector_types" */
  delete_super_connector_types_by_pk?: Maybe<Super_Connector_Types>;
  /** delete data from the table: "support_plan_types" */
  delete_support_plan_types?: Maybe<Support_Plan_Types_Mutation_Response>;
  /** delete single row from the table: "support_plan_types" */
  delete_support_plan_types_by_pk?: Maybe<Support_Plan_Types>;
  /** delete data from the table: "survey" */
  delete_survey?: Maybe<Survey_Mutation_Response>;
  /** delete single row from the table: "survey" */
  delete_survey_by_pk?: Maybe<Survey>;
  /** delete data from the table: "survey_question" */
  delete_survey_question?: Maybe<Survey_Question_Mutation_Response>;
  /** delete data from the table: "survey_question_answer_option" */
  delete_survey_question_answer_option?: Maybe<Survey_Question_Answer_Option_Mutation_Response>;
  /** delete single row from the table: "survey_question_answer_option" */
  delete_survey_question_answer_option_by_pk?: Maybe<Survey_Question_Answer_Option>;
  /** delete data from the table: "survey_question_answers" */
  delete_survey_question_answers?: Maybe<Survey_Question_Answers_Mutation_Response>;
  /** delete single row from the table: "survey_question_answers" */
  delete_survey_question_answers_by_pk?: Maybe<Survey_Question_Answers>;
  /** delete single row from the table: "survey_question" */
  delete_survey_question_by_pk?: Maybe<Survey_Question>;
  /** delete data from the table: "survey_question_kind" */
  delete_survey_question_kind?: Maybe<Survey_Question_Kind_Mutation_Response>;
  /** delete single row from the table: "survey_question_kind" */
  delete_survey_question_kind_by_pk?: Maybe<Survey_Question_Kind>;
  /** delete data from the table: "survey_question_options" */
  delete_survey_question_options?: Maybe<Survey_Question_Options_Mutation_Response>;
  /** delete single row from the table: "survey_question_options" */
  delete_survey_question_options_by_pk?: Maybe<Survey_Question_Options>;
  /** delete data from the table: "survey_v2" */
  delete_survey_v2?: Maybe<Survey_V2_Mutation_Response>;
  /** delete single row from the table: "survey_v2" */
  delete_survey_v2_by_pk?: Maybe<Survey_V2>;
  /** delete data from the table: "survey_v2_question" */
  delete_survey_v2_question?: Maybe<Survey_V2_Question_Mutation_Response>;
  /** delete single row from the table: "survey_v2_question" */
  delete_survey_v2_question_by_pk?: Maybe<Survey_V2_Question>;
  /** delete data from the table: "survey_v2_question_kind" */
  delete_survey_v2_question_kind?: Maybe<Survey_V2_Question_Kind_Mutation_Response>;
  /** delete single row from the table: "survey_v2_question_kind" */
  delete_survey_v2_question_kind_by_pk?: Maybe<Survey_V2_Question_Kind>;
  /** delete data from the table: "survey_v2_question_option" */
  delete_survey_v2_question_option?: Maybe<Survey_V2_Question_Option_Mutation_Response>;
  /** delete data from the table: "survey_v2_question_option_additional_info_config" */
  delete_survey_v2_question_option_additional_info_config?: Maybe<Survey_V2_Question_Option_Additional_Info_Config_Mutation_Response>;
  /** delete single row from the table: "survey_v2_question_option_additional_info_config" */
  delete_survey_v2_question_option_additional_info_config_by_pk?: Maybe<Survey_V2_Question_Option_Additional_Info_Config>;
  /** delete single row from the table: "survey_v2_question_option" */
  delete_survey_v2_question_option_by_pk?: Maybe<Survey_V2_Question_Option>;
  /** delete data from the table: "survey_v2_response" */
  delete_survey_v2_response?: Maybe<Survey_V2_Response_Mutation_Response>;
  /** delete data from the table: "survey_v2_response_answer" */
  delete_survey_v2_response_answer?: Maybe<Survey_V2_Response_Answer_Mutation_Response>;
  /** delete single row from the table: "survey_v2_response_answer" */
  delete_survey_v2_response_answer_by_pk?: Maybe<Survey_V2_Response_Answer>;
  /** delete data from the table: "survey_v2_response_answer_option" */
  delete_survey_v2_response_answer_option?: Maybe<Survey_V2_Response_Answer_Option_Mutation_Response>;
  /** delete single row from the table: "survey_v2_response_answer_option" */
  delete_survey_v2_response_answer_option_by_pk?: Maybe<Survey_V2_Response_Answer_Option>;
  /** delete single row from the table: "survey_v2_response" */
  delete_survey_v2_response_by_pk?: Maybe<Survey_V2_Response>;
  /** delete data from the table: "task_event" */
  delete_task_event?: Maybe<Task_Event_Mutation_Response>;
  /** delete single row from the table: "task_event" */
  delete_task_event_by_pk?: Maybe<Task_Event>;
  /** delete data from the table: "tasks" */
  delete_tasks?: Maybe<Tasks_Mutation_Response>;
  /** delete single row from the table: "tasks" */
  delete_tasks_by_pk?: Maybe<Tasks>;
  /** delete data from the table: "tenant" */
  delete_tenant?: Maybe<Tenant_Mutation_Response>;
  /** delete data from the table: "tenant_active_status_reason" */
  delete_tenant_active_status_reason?: Maybe<Tenant_Active_Status_Reason_Mutation_Response>;
  /** delete single row from the table: "tenant_active_status_reason" */
  delete_tenant_active_status_reason_by_pk?: Maybe<Tenant_Active_Status_Reason>;
  /** delete single row from the table: "tenant" */
  delete_tenant_by_pk?: Maybe<Tenant>;
  /** delete data from the table: "tenant_group" */
  delete_tenant_group?: Maybe<Tenant_Group_Mutation_Response>;
  /** delete single row from the table: "tenant_group" */
  delete_tenant_group_by_pk?: Maybe<Tenant_Group>;
  /** delete data from the table: "tenant_group_member" */
  delete_tenant_group_member?: Maybe<Tenant_Group_Member_Mutation_Response>;
  /** delete single row from the table: "tenant_group_member" */
  delete_tenant_group_member_by_pk?: Maybe<Tenant_Group_Member>;
  /** delete data from the table: "tenant_public_status" */
  delete_tenant_public_status?: Maybe<Tenant_Public_Status_Mutation_Response>;
  /** delete single row from the table: "tenant_public_status" */
  delete_tenant_public_status_by_pk?: Maybe<Tenant_Public_Status>;
  /** delete data from the table: "tenant_status" */
  delete_tenant_status?: Maybe<Tenant_Status_Mutation_Response>;
  /** delete single row from the table: "tenant_status" */
  delete_tenant_status_by_pk?: Maybe<Tenant_Status>;
  /** delete data from the table: "trial_leads" */
  delete_trial_leads?: Maybe<Trial_Leads_Mutation_Response>;
  /** delete single row from the table: "trial_leads" */
  delete_trial_leads_by_pk?: Maybe<Trial_Leads>;
  /** delete data from the table: "ua_audit_logs" */
  delete_ua_audit_logs?: Maybe<Ua_Audit_Logs_Mutation_Response>;
  /** delete single row from the table: "ua_audit_logs" */
  delete_ua_audit_logs_by_pk?: Maybe<Ua_Audit_Logs>;
  /** delete data from the table: "user_activity" */
  delete_user_activity?: Maybe<User_Activity_Mutation_Response>;
  /** delete single row from the table: "user_activity" */
  delete_user_activity_by_pk?: Maybe<User_Activity>;
  /** delete data from the table: "user_coupon" */
  delete_user_coupon?: Maybe<User_Coupon_Mutation_Response>;
  /** delete single row from the table: "user_coupon" */
  delete_user_coupon_by_pk?: Maybe<User_Coupon>;
  /** delete data from the table: "user_entitlement_access" */
  delete_user_entitlement_access?: Maybe<User_Entitlement_Access_Mutation_Response>;
  /** delete single row from the table: "user_entitlement_access" */
  delete_user_entitlement_access_by_pk?: Maybe<User_Entitlement_Access>;
  /** delete data from the table: "user_entitlement_catalogue" */
  delete_user_entitlement_catalogue?: Maybe<User_Entitlement_Catalogue_Mutation_Response>;
  /** delete single row from the table: "user_entitlement_catalogue" */
  delete_user_entitlement_catalogue_by_pk?: Maybe<User_Entitlement_Catalogue>;
  /** delete data from the table: "user_entitlement_types" */
  delete_user_entitlement_types?: Maybe<User_Entitlement_Types_Mutation_Response>;
  /** delete single row from the table: "user_entitlement_types" */
  delete_user_entitlement_types_by_pk?: Maybe<User_Entitlement_Types>;
  /** delete data from the table: "user_onboarding" */
  delete_user_onboarding?: Maybe<User_Onboarding_Mutation_Response>;
  /** delete single row from the table: "user_onboarding" */
  delete_user_onboarding_by_pk?: Maybe<User_Onboarding>;
  /** delete data from the table: "user_personal_access_tokens" */
  delete_user_personal_access_tokens?: Maybe<User_Personal_Access_Tokens_Mutation_Response>;
  /** delete single row from the table: "user_personal_access_tokens" */
  delete_user_personal_access_tokens_by_pk?: Maybe<User_Personal_Access_Tokens>;
  /** delete data from the table: "user_profile" */
  delete_user_profile?: Maybe<User_Profile_Mutation_Response>;
  /** delete single row from the table: "user_profile" */
  delete_user_profile_by_pk?: Maybe<User_Profile>;
  /** delete data from the table: "user_roles" */
  delete_user_roles?: Maybe<User_Roles_Mutation_Response>;
  /** delete single row from the table: "user_roles" */
  delete_user_roles_by_pk?: Maybe<User_Roles>;
  /** delete data from the table: "user_vpc_policy" */
  delete_user_vpc_policy?: Maybe<User_Vpc_Policy_Mutation_Response>;
  /** delete single row from the table: "user_vpc_policy" */
  delete_user_vpc_policy_by_pk?: Maybe<User_Vpc_Policy>;
  /** delete data from the table: "users" */
  delete_users?: Maybe<Users_Mutation_Response>;
  /** delete single row from the table: "users" */
  delete_users_by_pk?: Maybe<Users>;
  /** delete data from the table: "users_public" */
  delete_users_public?: Maybe<Users_Public_Mutation_Response>;
  /** delete data from the table: "vercel_integration" */
  delete_vercel_integration?: Maybe<Vercel_Integration_Mutation_Response>;
  /** delete single row from the table: "vercel_integration" */
  delete_vercel_integration_by_pk?: Maybe<Vercel_Integration>;
  /** delete data from the table: "vercel_integration_connections" */
  delete_vercel_integration_connections?: Maybe<Vercel_Integration_Connections_Mutation_Response>;
  /** delete single row from the table: "vercel_integration_connections" */
  delete_vercel_integration_connections_by_pk?: Maybe<Vercel_Integration_Connections>;
  /** delete data from the table: "vpc_peering" */
  delete_vpc_peering?: Maybe<Vpc_Peering_Mutation_Response>;
  /** delete single row from the table: "vpc_peering" */
  delete_vpc_peering_by_pk?: Maybe<Vpc_Peering>;
  /** delete data from the table: "vpc_peering_direction" */
  delete_vpc_peering_direction?: Maybe<Vpc_Peering_Direction_Mutation_Response>;
  /** delete single row from the table: "vpc_peering_direction" */
  delete_vpc_peering_direction_by_pk?: Maybe<Vpc_Peering_Direction>;
  /** delete data from the table: "vpc_status" */
  delete_vpc_status?: Maybe<Vpc_Status_Mutation_Response>;
  /** delete single row from the table: "vpc_status" */
  delete_vpc_status_by_pk?: Maybe<Vpc_Status>;
  /** delete data from the table: "zendesk_support_category" */
  delete_zendesk_support_category?: Maybe<Zendesk_Support_Category_Mutation_Response>;
  /** delete single row from the table: "zendesk_support_category" */
  delete_zendesk_support_category_by_pk?: Maybe<Zendesk_Support_Category>;
  /** delete data from the table: "zendesk_support_tickets" */
  delete_zendesk_support_tickets?: Maybe<Zendesk_Support_Tickets_Mutation_Response>;
  /** delete single row from the table: "zendesk_support_tickets" */
  delete_zendesk_support_tickets_by_pk?: Maybe<Zendesk_Support_Tickets>;
  deleteCard?: Maybe<DeleteCardResponse>;
  deleteProject: DeleteProjectResponse;
  /** deletes the slack app integrated with the project ID. */
  deleteSlackApp?: Maybe<DeleteSlackAppOutput>;
  deleteTenant?: Maybe<TenantDeleteResponse>;
  deleteTenantEnv?: Maybe<TenantEnv>;
  deleteUser?: Maybe<DeleteUserResponse>;
  deployLatestGithubCommit?: Maybe<DeployLatestCommitStatus>;
  enableCloudflareProxy?: Maybe<EnableCloudflareProxyResponse>;
  getGithubSession?: Maybe<GithubSession>;
  getHerokuSession?: Maybe<HerokuSession>;
  githubTokenExchange?: Maybe<GithubSession>;
  handleInactiveProjects?: Maybe<HandleInactiveProjectsResult>;
  herokuRegisterWebhook: WebhookRegisterStatus;
  herokuRegisterWebhookVar: WebhookRegisterStatus;
  herokuTokenExchange?: Maybe<HerokuSession>;
  herokuUnregisterWebhook: WebhookUnregisterStatus;
  herokuUnregisterWebhookVar: WebhookUnregisterStatus;
  initiateStripeAddCardProcess: ClientSecretInfo;
  /** insert data into the table: "alert_config" */
  insert_alert_config?: Maybe<Alert_Config_Mutation_Response>;
  /** insert data into the table: "alert_config_alert_type" */
  insert_alert_config_alert_type?: Maybe<Alert_Config_Alert_Type_Mutation_Response>;
  /** insert a single row into the table: "alert_config_alert_type" */
  insert_alert_config_alert_type_one?: Maybe<Alert_Config_Alert_Type>;
  /** insert a single row into the table: "alert_config" */
  insert_alert_config_one?: Maybe<Alert_Config>;
  /** insert data into the table: "alert_config_service" */
  insert_alert_config_service?: Maybe<Alert_Config_Service_Mutation_Response>;
  /** insert a single row into the table: "alert_config_service" */
  insert_alert_config_service_one?: Maybe<Alert_Config_Service>;
  /** insert data into the table: "alert_service_type" */
  insert_alert_service_type?: Maybe<Alert_Service_Type_Mutation_Response>;
  /** insert a single row into the table: "alert_service_type" */
  insert_alert_service_type_one?: Maybe<Alert_Service_Type>;
  /** insert data into the table: "alert_type" */
  insert_alert_type?: Maybe<Alert_Type_Mutation_Response>;
  /** insert a single row into the table: "alert_type" */
  insert_alert_type_one?: Maybe<Alert_Type>;
  /** insert data into the table: "azuremonitor_config" */
  insert_azuremonitor_config?: Maybe<Azuremonitor_Config_Mutation_Response>;
  /** insert a single row into the table: "azuremonitor_config" */
  insert_azuremonitor_config_one?: Maybe<Azuremonitor_Config>;
  /** insert data into the table: "billing_address" */
  insert_billing_address?: Maybe<Billing_Address_Mutation_Response>;
  /** insert a single row into the table: "billing_address" */
  insert_billing_address_one?: Maybe<Billing_Address>;
  /** insert data into the table: "central_cloud" */
  insert_central_cloud?: Maybe<Central_Cloud_Mutation_Response>;
  /** insert a single row into the table: "central_cloud" */
  insert_central_cloud_one?: Maybe<Central_Cloud>;
  /** insert data into the table: "change_email_request" */
  insert_change_email_request?: Maybe<Change_Email_Request_Mutation_Response>;
  /** insert a single row into the table: "change_email_request" */
  insert_change_email_request_one?: Maybe<Change_Email_Request>;
  /** insert data into the table: "cicd.deployment_pipeline_config" */
  insert_cicd_deployment_pipeline_config?: Maybe<Cicd_Deployment_Pipeline_Config_Mutation_Response>;
  /** insert a single row into the table: "cicd.deployment_pipeline_config" */
  insert_cicd_deployment_pipeline_config_one?: Maybe<Cicd_Deployment_Pipeline_Config>;
  /** insert data into the table: "cicd.deployment_pool" */
  insert_cicd_deployment_pool?: Maybe<Cicd_Deployment_Pool_Mutation_Response>;
  /** insert data into the table: "cicd.deployment_pool_member" */
  insert_cicd_deployment_pool_member?: Maybe<Cicd_Deployment_Pool_Member_Mutation_Response>;
  /** insert a single row into the table: "cicd.deployment_pool_member" */
  insert_cicd_deployment_pool_member_one?: Maybe<Cicd_Deployment_Pool_Member>;
  /** insert a single row into the table: "cicd.deployment_pool" */
  insert_cicd_deployment_pool_one?: Maybe<Cicd_Deployment_Pool>;
  /** insert data into the table: "cloud" */
  insert_cloud?: Maybe<Cloud_Mutation_Response>;
  /** insert data into the table: "cloud_metadata" */
  insert_cloud_metadata?: Maybe<Cloud_Metadata_Mutation_Response>;
  /** insert a single row into the table: "cloud_metadata" */
  insert_cloud_metadata_one?: Maybe<Cloud_Metadata>;
  /** insert a single row into the table: "cloud" */
  insert_cloud_one?: Maybe<Cloud>;
  /** insert data into the table: "compute_unit_config" */
  insert_compute_unit_config?: Maybe<Compute_Unit_Config_Mutation_Response>;
  /** insert a single row into the table: "compute_unit_config" */
  insert_compute_unit_config_one?: Maybe<Compute_Unit_Config>;
  /** insert data into the table: "config" */
  insert_config?: Maybe<Config_Mutation_Response>;
  /** insert a single row into the table: "config" */
  insert_config_one?: Maybe<Config>;
  /** insert data into the table: "config_status" */
  insert_config_status?: Maybe<Config_Status_Mutation_Response>;
  /** insert a single row into the table: "config_status" */
  insert_config_status_one?: Maybe<Config_Status>;
  /** insert data into the table: "connector_config" */
  insert_connector_config?: Maybe<Connector_Config_Mutation_Response>;
  /** insert a single row into the table: "connector_config" */
  insert_connector_config_one?: Maybe<Connector_Config>;
  /** insert data into the table: "connector_deployments" */
  insert_connector_deployments?: Maybe<Connector_Deployments_Mutation_Response>;
  /** insert a single row into the table: "connector_deployments" */
  insert_connector_deployments_one?: Maybe<Connector_Deployments>;
  /** insert data into the table: "coupon" */
  insert_coupon?: Maybe<Coupon_Mutation_Response>;
  /** insert data into the table: "coupon_duration" */
  insert_coupon_duration?: Maybe<Coupon_Duration_Mutation_Response>;
  /** insert a single row into the table: "coupon_duration" */
  insert_coupon_duration_one?: Maybe<Coupon_Duration>;
  /** insert a single row into the table: "coupon" */
  insert_coupon_one?: Maybe<Coupon>;
  /** insert data into the table: "coupon_type" */
  insert_coupon_type?: Maybe<Coupon_Type_Mutation_Response>;
  /** insert a single row into the table: "coupon_type" */
  insert_coupon_type_one?: Maybe<Coupon_Type>;
  /** insert data into the table: "custom_domain" */
  insert_custom_domain?: Maybe<Custom_Domain_Mutation_Response>;
  /** insert data into the table: "custom_domain_cloudflare" */
  insert_custom_domain_cloudflare?: Maybe<Custom_Domain_Cloudflare_Mutation_Response>;
  /** insert data into the table: "custom_domain_cloudflare_dns" */
  insert_custom_domain_cloudflare_dns?: Maybe<Custom_Domain_Cloudflare_Dns_Mutation_Response>;
  /** insert a single row into the table: "custom_domain_cloudflare_dns" */
  insert_custom_domain_cloudflare_dns_one?: Maybe<Custom_Domain_Cloudflare_Dns>;
  /** insert a single row into the table: "custom_domain_cloudflare" */
  insert_custom_domain_cloudflare_one?: Maybe<Custom_Domain_Cloudflare>;
  /** insert a single row into the table: "custom_domain" */
  insert_custom_domain_one?: Maybe<Custom_Domain>;
  /** insert data into the table: "customer_usage" */
  insert_customer_usage?: Maybe<Customer_Usage_Mutation_Response>;
  /** insert a single row into the table: "customer_usage" */
  insert_customer_usage_one?: Maybe<Customer_Usage>;
  /** insert data into the table: "data_connector_type" */
  insert_data_connector_type?: Maybe<Data_Connector_Type_Mutation_Response>;
  /** insert a single row into the table: "data_connector_type" */
  insert_data_connector_type_one?: Maybe<Data_Connector_Type>;
  /** insert data into the table: "datadog_config" */
  insert_datadog_config?: Maybe<Datadog_Config_Mutation_Response>;
  /** insert a single row into the table: "datadog_config" */
  insert_datadog_config_one?: Maybe<Datadog_Config>;
  /** insert data into the table: "db_latency" */
  insert_db_latency?: Maybe<Db_Latency_Mutation_Response>;
  /** insert a single row into the table: "db_latency" */
  insert_db_latency_one?: Maybe<Db_Latency>;
  /** execute VOLATILE function "insert_db_usage" which returns "project_db_usage" */
  insert_db_usage: Array<Project_Db_Usage>;
  /** insert data into the table: "ddn.build" */
  insert_ddn_build?: Maybe<Ddn_Build_Mutation_Response>;
  /** insert a single row into the table: "ddn.build" */
  insert_ddn_build_one?: Maybe<Ddn_Build>;
  /** insert data into the table: "ddn.build_sync_status" */
  insert_ddn_build_sync_status?: Maybe<Ddn_Build_Sync_Status_Mutation_Response>;
  /** insert a single row into the table: "ddn.build_sync_status" */
  insert_ddn_build_sync_status_one?: Maybe<Ddn_Build_Sync_Status>;
  /** insert data into the table: "ddn.build_sync_worker" */
  insert_ddn_build_sync_worker?: Maybe<Ddn_Build_Sync_Worker_Mutation_Response>;
  /** insert a single row into the table: "ddn.build_sync_worker" */
  insert_ddn_build_sync_worker_one?: Maybe<Ddn_Build_Sync_Worker>;
  /** insert data into the table: "ddn.environment" */
  insert_ddn_environment?: Maybe<Ddn_Environment_Mutation_Response>;
  /** insert a single row into the table: "ddn.environment" */
  insert_ddn_environment_one?: Maybe<Ddn_Environment>;
  /** insert data into the table: "ddn.project_entitlement_access" */
  insert_ddn_project_entitlement_access?: Maybe<Ddn_Project_Entitlement_Access_Mutation_Response>;
  /** insert a single row into the table: "ddn.project_entitlement_access" */
  insert_ddn_project_entitlement_access_one?: Maybe<Ddn_Project_Entitlement_Access>;
  /** insert data into the table: "ddn.project_entitlement_catalogue" */
  insert_ddn_project_entitlement_catalogue?: Maybe<Ddn_Project_Entitlement_Catalogue_Mutation_Response>;
  /** insert a single row into the table: "ddn.project_entitlement_catalogue" */
  insert_ddn_project_entitlement_catalogue_one?: Maybe<Ddn_Project_Entitlement_Catalogue>;
  /** insert data into the table: "ddn.project_entitlement_types" */
  insert_ddn_project_entitlement_types?: Maybe<Ddn_Project_Entitlement_Types_Mutation_Response>;
  /** insert a single row into the table: "ddn.project_entitlement_types" */
  insert_ddn_project_entitlement_types_one?: Maybe<Ddn_Project_Entitlement_Types>;
  /** insert data into the table: "ddn.projects" */
  insert_ddn_projects?: Maybe<Ddn_Projects_Mutation_Response>;
  /** insert a single row into the table: "ddn.projects" */
  insert_ddn_projects_one?: Maybe<Ddn_Projects>;
  /** insert data into the table: "ddn.tunnel" */
  insert_ddn_tunnel?: Maybe<Ddn_Tunnel_Mutation_Response>;
  /** insert data into the table: "ddn.tunnel_cluster" */
  insert_ddn_tunnel_cluster?: Maybe<Ddn_Tunnel_Cluster_Mutation_Response>;
  /** insert a single row into the table: "ddn.tunnel_cluster" */
  insert_ddn_tunnel_cluster_one?: Maybe<Ddn_Tunnel_Cluster>;
  /** insert a single row into the table: "ddn.tunnel" */
  insert_ddn_tunnel_one?: Maybe<Ddn_Tunnel>;
  /** insert data into the table: "dedicated_cloud_bills" */
  insert_dedicated_cloud_bills?: Maybe<Dedicated_Cloud_Bills_Mutation_Response>;
  /** insert data into the table: "dedicated_cloud_bills_details" */
  insert_dedicated_cloud_bills_details?: Maybe<Dedicated_Cloud_Bills_Details_Mutation_Response>;
  /** insert a single row into the table: "dedicated_cloud_bills_details" */
  insert_dedicated_cloud_bills_details_one?: Maybe<Dedicated_Cloud_Bills_Details>;
  /** insert a single row into the table: "dedicated_cloud_bills" */
  insert_dedicated_cloud_bills_one?: Maybe<Dedicated_Cloud_Bills>;
  /** insert data into the table: "dedicated_cloud_commitments" */
  insert_dedicated_cloud_commitments?: Maybe<Dedicated_Cloud_Commitments_Mutation_Response>;
  /** insert a single row into the table: "dedicated_cloud_commitments" */
  insert_dedicated_cloud_commitments_one?: Maybe<Dedicated_Cloud_Commitments>;
  /** insert data into the table: "dedicated_vpc" */
  insert_dedicated_vpc?: Maybe<Dedicated_Vpc_Mutation_Response>;
  /** insert a single row into the table: "dedicated_vpc" */
  insert_dedicated_vpc_one?: Maybe<Dedicated_Vpc>;
  /** insert data into the table: "delete_user" */
  insert_delete_user?: Maybe<Delete_User_Mutation_Response>;
  /** insert a single row into the table: "delete_user" */
  insert_delete_user_one?: Maybe<Delete_User>;
  /** insert data into the table: "delete_user_status" */
  insert_delete_user_status?: Maybe<Delete_User_Status_Mutation_Response>;
  /** insert a single row into the table: "delete_user_status" */
  insert_delete_user_status_one?: Maybe<Delete_User_Status>;
  /** insert data into the table: "delete_user_tasks" */
  insert_delete_user_tasks?: Maybe<Delete_User_Tasks_Mutation_Response>;
  /** insert a single row into the table: "delete_user_tasks" */
  insert_delete_user_tasks_one?: Maybe<Delete_User_Tasks>;
  /** insert data into the table: "email_log" */
  insert_email_log?: Maybe<Email_Log_Mutation_Response>;
  /** insert a single row into the table: "email_log" */
  insert_email_log_one?: Maybe<Email_Log>;
  /** insert data into the table: "enterprise_users" */
  insert_enterprise_users?: Maybe<Enterprise_Users_Mutation_Response>;
  /** insert a single row into the table: "enterprise_users" */
  insert_enterprise_users_one?: Maybe<Enterprise_Users>;
  /** insert data into the table: "experiments" */
  insert_experiments?: Maybe<Experiments_Mutation_Response>;
  /** insert data into the table: "experiments_cohort" */
  insert_experiments_cohort?: Maybe<Experiments_Cohort_Mutation_Response>;
  /** insert a single row into the table: "experiments_cohort" */
  insert_experiments_cohort_one?: Maybe<Experiments_Cohort>;
  /** insert data into the table: "experiments_config" */
  insert_experiments_config?: Maybe<Experiments_Config_Mutation_Response>;
  /** insert a single row into the table: "experiments_config" */
  insert_experiments_config_one?: Maybe<Experiments_Config>;
  /** insert a single row into the table: "experiments" */
  insert_experiments_one?: Maybe<Experiments>;
  /** insert data into the table: "feature" */
  insert_feature?: Maybe<Feature_Mutation_Response>;
  /** insert data into the table: "feature_access" */
  insert_feature_access?: Maybe<Feature_Access_Mutation_Response>;
  /** insert a single row into the table: "feature_access" */
  insert_feature_access_one?: Maybe<Feature_Access>;
  /** insert data into the table: "feature_config" */
  insert_feature_config?: Maybe<Feature_Config_Mutation_Response>;
  /** insert a single row into the table: "feature_config" */
  insert_feature_config_one?: Maybe<Feature_Config>;
  /** insert a single row into the table: "feature" */
  insert_feature_one?: Maybe<Feature>;
  /** insert data into the table: "gateway_ami" */
  insert_gateway_ami?: Maybe<Gateway_Ami_Mutation_Response>;
  /** insert a single row into the table: "gateway_ami" */
  insert_gateway_ami_one?: Maybe<Gateway_Ami>;
  /** insert data into the table: "gateway_cluster" */
  insert_gateway_cluster?: Maybe<Gateway_Cluster_Mutation_Response>;
  /** insert a single row into the table: "gateway_cluster" */
  insert_gateway_cluster_one?: Maybe<Gateway_Cluster>;
  /** insert data into the table: "gateway_worker" */
  insert_gateway_worker?: Maybe<Gateway_Worker_Mutation_Response>;
  /** insert a single row into the table: "gateway_worker" */
  insert_gateway_worker_one?: Maybe<Gateway_Worker>;
  /** insert data into the table: "github_email_type" */
  insert_github_email_type?: Maybe<Github_Email_Type_Mutation_Response>;
  /** insert a single row into the table: "github_email_type" */
  insert_github_email_type_one?: Maybe<Github_Email_Type>;
  /** insert data into the table: "github_integration_config" */
  insert_github_integration_config?: Maybe<Github_Integration_Config_Mutation_Response>;
  /** insert a single row into the table: "github_integration_config" */
  insert_github_integration_config_one?: Maybe<Github_Integration_Config>;
  /** insert data into the table: "github_integration_mode" */
  insert_github_integration_mode?: Maybe<Github_Integration_Mode_Mutation_Response>;
  /** insert a single row into the table: "github_integration_mode" */
  insert_github_integration_mode_one?: Maybe<Github_Integration_Mode>;
  /** insert data into the table: "github_push_event" */
  insert_github_push_event?: Maybe<Github_Push_Event_Mutation_Response>;
  /** insert data into the table: "github_push_event_job" */
  insert_github_push_event_job?: Maybe<Github_Push_Event_Job_Mutation_Response>;
  /** insert a single row into the table: "github_push_event_job" */
  insert_github_push_event_job_one?: Maybe<Github_Push_Event_Job>;
  /** insert a single row into the table: "github_push_event" */
  insert_github_push_event_one?: Maybe<Github_Push_Event>;
  /** insert data into the table: "hasura_ami" */
  insert_hasura_ami?: Maybe<Hasura_Ami_Mutation_Response>;
  /** insert a single row into the table: "hasura_ami" */
  insert_hasura_ami_one?: Maybe<Hasura_Ami>;
  /** insert data into the table: "hasura_cluster" */
  insert_hasura_cluster?: Maybe<Hasura_Cluster_Mutation_Response>;
  /** insert a single row into the table: "hasura_cluster" */
  insert_hasura_cluster_one?: Maybe<Hasura_Cluster>;
  /** insert data into the table: "hasura_worker" */
  insert_hasura_worker?: Maybe<Hasura_Worker_Mutation_Response>;
  /** insert a single row into the table: "hasura_worker" */
  insert_hasura_worker_one?: Maybe<Hasura_Worker>;
  /** insert data into the table: "heroku_integrations" */
  insert_heroku_integrations?: Maybe<Heroku_Integrations_Mutation_Response>;
  /** insert a single row into the table: "heroku_integrations" */
  insert_heroku_integrations_one?: Maybe<Heroku_Integrations>;
  /** insert data into the table: "inactive_project_exclusions" */
  insert_inactive_project_exclusions?: Maybe<Inactive_Project_Exclusions_Mutation_Response>;
  /** insert a single row into the table: "inactive_project_exclusions" */
  insert_inactive_project_exclusions_one?: Maybe<Inactive_Project_Exclusions>;
  /** insert data into the table: "inactive_project_notifications" */
  insert_inactive_project_notifications?: Maybe<Inactive_Project_Notifications_Mutation_Response>;
  /** insert a single row into the table: "inactive_project_notifications" */
  insert_inactive_project_notifications_one?: Maybe<Inactive_Project_Notifications>;
  /** insert data into the table: "inactive_project_suspension_config" */
  insert_inactive_project_suspension_config?: Maybe<Inactive_Project_Suspension_Config_Mutation_Response>;
  /** insert a single row into the table: "inactive_project_suspension_config" */
  insert_inactive_project_suspension_config_one?: Maybe<Inactive_Project_Suspension_Config>;
  /** insert data into the table: "infra_status" */
  insert_infra_status?: Maybe<Infra_Status_Mutation_Response>;
  /** insert a single row into the table: "infra_status" */
  insert_infra_status_one?: Maybe<Infra_Status>;
  /** insert data into the table: "invoice" */
  insert_invoice?: Maybe<Invoice_Mutation_Response>;
  /** insert data into the table: "invoice_coupon_discount" */
  insert_invoice_coupon_discount?: Maybe<Invoice_Coupon_Discount_Mutation_Response>;
  /** insert a single row into the table: "invoice_coupon_discount" */
  insert_invoice_coupon_discount_one?: Maybe<Invoice_Coupon_Discount>;
  /** insert data into the table: "invoice_item" */
  insert_invoice_item?: Maybe<Invoice_Item_Mutation_Response>;
  /** insert a single row into the table: "invoice_item" */
  insert_invoice_item_one?: Maybe<Invoice_Item>;
  /** insert a single row into the table: "invoice" */
  insert_invoice_one?: Maybe<Invoice>;
  /** insert data into the table: "jobs" */
  insert_jobs?: Maybe<Jobs_Mutation_Response>;
  /** insert a single row into the table: "jobs" */
  insert_jobs_one?: Maybe<Jobs>;
  /** insert data into the table: "label" */
  insert_label?: Maybe<Label_Mutation_Response>;
  /** insert a single row into the table: "label" */
  insert_label_one?: Maybe<Label>;
  /** insert data into the table: "letsencrypt_status" */
  insert_letsencrypt_status?: Maybe<Letsencrypt_Status_Mutation_Response>;
  /** insert a single row into the table: "letsencrypt_status" */
  insert_letsencrypt_status_one?: Maybe<Letsencrypt_Status>;
  /** insert data into the table: "license_activity" */
  insert_license_activity?: Maybe<License_Activity_Mutation_Response>;
  /** insert a single row into the table: "license_activity" */
  insert_license_activity_one?: Maybe<License_Activity>;
  /** insert data into the table: "license_instance" */
  insert_license_instance?: Maybe<License_Instance_Mutation_Response>;
  /** insert a single row into the table: "license_instance" */
  insert_license_instance_one?: Maybe<License_Instance>;
  /** insert data into the table: "license_type" */
  insert_license_type?: Maybe<License_Type_Mutation_Response>;
  /** insert a single row into the table: "license_type" */
  insert_license_type_one?: Maybe<License_Type>;
  /** insert data into the table: "licenses" */
  insert_licenses?: Maybe<Licenses_Mutation_Response>;
  /** insert a single row into the table: "licenses" */
  insert_licenses_one?: Maybe<Licenses>;
  /** insert data into the table: "lux_proxy" */
  insert_lux_proxy?: Maybe<Lux_Proxy_Mutation_Response>;
  /** insert data into the table: "lux_proxy_ami" */
  insert_lux_proxy_ami?: Maybe<Lux_Proxy_Ami_Mutation_Response>;
  /** insert a single row into the table: "lux_proxy_ami" */
  insert_lux_proxy_ami_one?: Maybe<Lux_Proxy_Ami>;
  /** insert a single row into the table: "lux_proxy" */
  insert_lux_proxy_one?: Maybe<Lux_Proxy>;
  /** insert data into the table: "neon_db_integration" */
  insert_neon_db_integration?: Maybe<Neon_Db_Integration_Mutation_Response>;
  /** insert a single row into the table: "neon_db_integration" */
  insert_neon_db_integration_one?: Maybe<Neon_Db_Integration>;
  /** insert data into the table: "newrelic_config" */
  insert_newrelic_config?: Maybe<Newrelic_Config_Mutation_Response>;
  /** insert a single row into the table: "newrelic_config" */
  insert_newrelic_config_one?: Maybe<Newrelic_Config>;
  /** insert data into the table: "node_pool_type" */
  insert_node_pool_type?: Maybe<Node_Pool_Type_Mutation_Response>;
  /** insert a single row into the table: "node_pool_type" */
  insert_node_pool_type_one?: Maybe<Node_Pool_Type>;
  /** insert data into the table: "node_pools" */
  insert_node_pools?: Maybe<Node_Pools_Mutation_Response>;
  /** insert a single row into the table: "node_pools" */
  insert_node_pools_one?: Maybe<Node_Pools>;
  /** insert data into the table: "notification" */
  insert_notification?: Maybe<Notification_Mutation_Response>;
  /** insert a single row into the table: "notification" */
  insert_notification_one?: Maybe<Notification>;
  /** insert data into the table: "notification_type" */
  insert_notification_type?: Maybe<Notification_Type_Mutation_Response>;
  /** insert a single row into the table: "notification_type" */
  insert_notification_type_one?: Maybe<Notification_Type>;
  /** insert data into the table: "onboarding_sample_db_cohort" */
  insert_onboarding_sample_db_cohort?: Maybe<Onboarding_Sample_Db_Cohort_Mutation_Response>;
  /** insert a single row into the table: "onboarding_sample_db_cohort" */
  insert_onboarding_sample_db_cohort_one?: Maybe<Onboarding_Sample_Db_Cohort>;
  /** insert data into the table: "onboarding_sample_db_config" */
  insert_onboarding_sample_db_config?: Maybe<Onboarding_Sample_Db_Config_Mutation_Response>;
  /** insert a single row into the table: "onboarding_sample_db_config" */
  insert_onboarding_sample_db_config_one?: Maybe<Onboarding_Sample_Db_Config>;
  /** insert data into the table: "one_click_deployment" */
  insert_one_click_deployment?: Maybe<One_Click_Deployment_Mutation_Response>;
  /** insert a single row into the table: "one_click_deployment" */
  insert_one_click_deployment_one?: Maybe<One_Click_Deployment>;
  /** insert data into the table: "one_click_deployment_sample_apps" */
  insert_one_click_deployment_sample_apps?: Maybe<One_Click_Deployment_Sample_Apps_Mutation_Response>;
  /** insert a single row into the table: "one_click_deployment_sample_apps" */
  insert_one_click_deployment_sample_apps_one?: Maybe<One_Click_Deployment_Sample_Apps>;
  /** insert data into the table: "one_click_deployment_state_log" */
  insert_one_click_deployment_state_log?: Maybe<One_Click_Deployment_State_Log_Mutation_Response>;
  /** insert a single row into the table: "one_click_deployment_state_log" */
  insert_one_click_deployment_state_log_one?: Maybe<One_Click_Deployment_State_Log>;
  /** insert data into the table: "one_click_deployment_states" */
  insert_one_click_deployment_states?: Maybe<One_Click_Deployment_States_Mutation_Response>;
  /** insert a single row into the table: "one_click_deployment_states" */
  insert_one_click_deployment_states_one?: Maybe<One_Click_Deployment_States>;
  /** insert data into the table: "opentelemetry_config" */
  insert_opentelemetry_config?: Maybe<Opentelemetry_Config_Mutation_Response>;
  /** insert a single row into the table: "opentelemetry_config" */
  insert_opentelemetry_config_one?: Maybe<Opentelemetry_Config>;
  /** insert data into the table: "operations.delete_free_plan_dns_records_nov_2021" */
  insert_operations_delete_free_plan_dns_records_nov_2021?: Maybe<Operations_Delete_Free_Plan_Dns_Records_Nov_2021_Mutation_Response>;
  /** insert a single row into the table: "operations.delete_free_plan_dns_records_nov_2021" */
  insert_operations_delete_free_plan_dns_records_nov_2021_one?: Maybe<Operations_Delete_Free_Plan_Dns_Records_Nov_2021>;
  /** insert data into the table: "operations.tenant" */
  insert_operations_tenant?: Maybe<Operations_Tenant_Mutation_Response>;
  /** insert a single row into the table: "operations.tenant" */
  insert_operations_tenant_one?: Maybe<Operations_Tenant>;
  /** insert data into the table: "payment_method" */
  insert_payment_method?: Maybe<Payment_Method_Mutation_Response>;
  /** insert a single row into the table: "payment_method" */
  insert_payment_method_one?: Maybe<Payment_Method>;
  /** insert data into the table: "plan_entitlements" */
  insert_plan_entitlements?: Maybe<Plan_Entitlements_Mutation_Response>;
  /** insert a single row into the table: "plan_entitlements" */
  insert_plan_entitlements_one?: Maybe<Plan_Entitlements>;
  /** insert data into the table: "plans" */
  insert_plans?: Maybe<Plans_Mutation_Response>;
  /** insert a single row into the table: "plans" */
  insert_plans_one?: Maybe<Plans>;
  /** insert data into the table: "policies" */
  insert_policies?: Maybe<Policies_Mutation_Response>;
  /** insert a single row into the table: "policies" */
  insert_policies_one?: Maybe<Policies>;
  /** insert data into the table: "privileges" */
  insert_privileges?: Maybe<Privileges_Mutation_Response>;
  /** insert a single row into the table: "privileges" */
  insert_privileges_one?: Maybe<Privileges>;
  /** insert data into the table: "pro_license_keys" */
  insert_pro_license_keys?: Maybe<Pro_License_Keys_Mutation_Response>;
  /** insert a single row into the table: "pro_license_keys" */
  insert_pro_license_keys_one?: Maybe<Pro_License_Keys>;
  /** insert data into the table: "project_activity" */
  insert_project_activity?: Maybe<Project_Activity_Mutation_Response>;
  /** insert a single row into the table: "project_activity" */
  insert_project_activity_one?: Maybe<Project_Activity>;
  /** insert data into the table: "project_billing_manager_invitations" */
  insert_project_billing_manager_invitations?: Maybe<Project_Billing_Manager_Invitations_Mutation_Response>;
  /** insert a single row into the table: "project_billing_manager_invitations" */
  insert_project_billing_manager_invitations_one?: Maybe<Project_Billing_Manager_Invitations>;
  /** insert data into the table: "project_collaborator_allowed_schema_tables" */
  insert_project_collaborator_allowed_schema_tables?: Maybe<Project_Collaborator_Allowed_Schema_Tables_Mutation_Response>;
  /** insert a single row into the table: "project_collaborator_allowed_schema_tables" */
  insert_project_collaborator_allowed_schema_tables_one?: Maybe<Project_Collaborator_Allowed_Schema_Tables>;
  /** insert data into the table: "project_collaborator_allowed_schemas" */
  insert_project_collaborator_allowed_schemas?: Maybe<Project_Collaborator_Allowed_Schemas_Mutation_Response>;
  /** insert a single row into the table: "project_collaborator_allowed_schemas" */
  insert_project_collaborator_allowed_schemas_one?: Maybe<Project_Collaborator_Allowed_Schemas>;
  /** insert data into the table: "project_collaborator_invitations" */
  insert_project_collaborator_invitations?: Maybe<Project_Collaborator_Invitations_Mutation_Response>;
  /** insert a single row into the table: "project_collaborator_invitations" */
  insert_project_collaborator_invitations_one?: Maybe<Project_Collaborator_Invitations>;
  /** insert data into the table: "project_collaborator_privileges" */
  insert_project_collaborator_privileges?: Maybe<Project_Collaborator_Privileges_Mutation_Response>;
  /** insert a single row into the table: "project_collaborator_privileges" */
  insert_project_collaborator_privileges_one?: Maybe<Project_Collaborator_Privileges>;
  /** insert data into the table: "project_collaborators" */
  insert_project_collaborators?: Maybe<Project_Collaborators_Mutation_Response>;
  /** insert a single row into the table: "project_collaborators" */
  insert_project_collaborators_one?: Maybe<Project_Collaborators>;
  /** insert data into the table: "project_data_usage" */
  insert_project_data_usage?: Maybe<Project_Data_Usage_Mutation_Response>;
  /** insert data into the table: "project_data_usage_agg" */
  insert_project_data_usage_agg?: Maybe<Project_Data_Usage_Agg_Mutation_Response>;
  /** insert a single row into the table: "project_data_usage_agg" */
  insert_project_data_usage_agg_one?: Maybe<Project_Data_Usage_Agg>;
  /** insert data into the table: "project_data_usage_agg_user" */
  insert_project_data_usage_agg_user?: Maybe<Project_Data_Usage_Agg_User_Mutation_Response>;
  /** insert a single row into the table: "project_data_usage_agg_user" */
  insert_project_data_usage_agg_user_one?: Maybe<Project_Data_Usage_Agg_User>;
  /** insert data into the table: "project_data_usage_components" */
  insert_project_data_usage_components?: Maybe<Project_Data_Usage_Components_Mutation_Response>;
  /** insert a single row into the table: "project_data_usage_components" */
  insert_project_data_usage_components_one?: Maybe<Project_Data_Usage_Components>;
  /** insert a single row into the table: "project_data_usage" */
  insert_project_data_usage_one?: Maybe<Project_Data_Usage>;
  /** insert data into the table: "project_data_usage_prometheus" */
  insert_project_data_usage_prometheus?: Maybe<Project_Data_Usage_Prometheus_Mutation_Response>;
  /** insert data into the table: "project_data_usage_prometheus_agg_user" */
  insert_project_data_usage_prometheus_agg_user?: Maybe<Project_Data_Usage_Prometheus_Agg_User_Mutation_Response>;
  /** insert a single row into the table: "project_data_usage_prometheus_agg_user" */
  insert_project_data_usage_prometheus_agg_user_one?: Maybe<Project_Data_Usage_Prometheus_Agg_User>;
  /** insert a single row into the table: "project_data_usage_prometheus" */
  insert_project_data_usage_prometheus_one?: Maybe<Project_Data_Usage_Prometheus>;
  /** insert data into the table: "project_data_usage_report" */
  insert_project_data_usage_report?: Maybe<Project_Data_Usage_Report_Mutation_Response>;
  /** insert a single row into the table: "project_data_usage_report" */
  insert_project_data_usage_report_one?: Maybe<Project_Data_Usage_Report>;
  /** insert data into the table: "project_db_usage" */
  insert_project_db_usage?: Maybe<Project_Db_Usage_Mutation_Response>;
  /** insert data into the table: "project_db_usage_agg_user" */
  insert_project_db_usage_agg_user?: Maybe<Project_Db_Usage_Agg_User_Mutation_Response>;
  /** insert a single row into the table: "project_db_usage_agg_user" */
  insert_project_db_usage_agg_user_one?: Maybe<Project_Db_Usage_Agg_User>;
  /** insert a single row into the table: "project_db_usage" */
  insert_project_db_usage_one?: Maybe<Project_Db_Usage>;
  /** insert data into the table: "project_entitlement_access" */
  insert_project_entitlement_access?: Maybe<Project_Entitlement_Access_Mutation_Response>;
  /** insert a single row into the table: "project_entitlement_access" */
  insert_project_entitlement_access_one?: Maybe<Project_Entitlement_Access>;
  /** insert data into the table: "project_entitlement_catalogue" */
  insert_project_entitlement_catalogue?: Maybe<Project_Entitlement_Catalogue_Mutation_Response>;
  /** insert a single row into the table: "project_entitlement_catalogue" */
  insert_project_entitlement_catalogue_one?: Maybe<Project_Entitlement_Catalogue>;
  /** insert data into the table: "project_entitlement_types" */
  insert_project_entitlement_types?: Maybe<Project_Entitlement_Types_Mutation_Response>;
  /** insert a single row into the table: "project_entitlement_types" */
  insert_project_entitlement_types_one?: Maybe<Project_Entitlement_Types>;
  /** insert data into the table: "project_labels" */
  insert_project_labels?: Maybe<Project_Labels_Mutation_Response>;
  /** insert a single row into the table: "project_labels" */
  insert_project_labels_one?: Maybe<Project_Labels>;
  /** insert data into the table: "project_metadata" */
  insert_project_metadata?: Maybe<Project_Metadata_Mutation_Response>;
  /** insert a single row into the table: "project_metadata" */
  insert_project_metadata_one?: Maybe<Project_Metadata>;
  /** insert data into the table: "project_notification" */
  insert_project_notification?: Maybe<Project_Notification_Mutation_Response>;
  /** insert a single row into the table: "project_notification" */
  insert_project_notification_one?: Maybe<Project_Notification>;
  /** insert data into the table: "project_ownership_transfer_invitations" */
  insert_project_ownership_transfer_invitations?: Maybe<Project_Ownership_Transfer_Invitations_Mutation_Response>;
  /** insert a single row into the table: "project_ownership_transfer_invitations" */
  insert_project_ownership_transfer_invitations_one?: Maybe<Project_Ownership_Transfer_Invitations>;
  /** insert data into the table: "project_requests_count" */
  insert_project_requests_count?: Maybe<Project_Requests_Count_Mutation_Response>;
  /** insert a single row into the table: "project_requests_count" */
  insert_project_requests_count_one?: Maybe<Project_Requests_Count>;
  /** insert data into the table: "project_stats" */
  insert_project_stats?: Maybe<Project_Stats_Mutation_Response>;
  /** insert a single row into the table: "project_stats" */
  insert_project_stats_one?: Maybe<Project_Stats>;
  /** insert data into the table: "project_total_db_usage_agg" */
  insert_project_total_db_usage_agg?: Maybe<Project_Total_Db_Usage_Agg_Mutation_Response>;
  /** insert a single row into the table: "project_total_db_usage_agg" */
  insert_project_total_db_usage_agg_one?: Maybe<Project_Total_Db_Usage_Agg>;
  /** insert data into the table: "projects" */
  insert_projects?: Maybe<Projects_Mutation_Response>;
  /** insert a single row into the table: "projects" */
  insert_projects_one?: Maybe<Projects>;
  /** insert data into the table: "projects_pool_config" */
  insert_projects_pool_config?: Maybe<Projects_Pool_Config_Mutation_Response>;
  /** insert a single row into the table: "projects_pool_config" */
  insert_projects_pool_config_one?: Maybe<Projects_Pool_Config>;
  /** insert data into the table: "projects_pro_key_generations" */
  insert_projects_pro_key_generations?: Maybe<Projects_Pro_Key_Generations_Mutation_Response>;
  /** insert a single row into the table: "projects_pro_key_generations" */
  insert_projects_pro_key_generations_one?: Maybe<Projects_Pro_Key_Generations>;
  /** insert data into the table: "prometheus_config" */
  insert_prometheus_config?: Maybe<Prometheus_Config_Mutation_Response>;
  /** insert a single row into the table: "prometheus_config" */
  insert_prometheus_config_one?: Maybe<Prometheus_Config>;
  /** insert data into the table: "providers" */
  insert_providers?: Maybe<Providers_Mutation_Response>;
  /** insert a single row into the table: "providers" */
  insert_providers_one?: Maybe<Providers>;
  /** insert data into the table: "provisioning" */
  insert_provisioning?: Maybe<Provisioning_Mutation_Response>;
  /** insert a single row into the table: "provisioning" */
  insert_provisioning_one?: Maybe<Provisioning>;
  /** insert data into the table: "region" */
  insert_region?: Maybe<Region_Mutation_Response>;
  /** insert a single row into the table: "region" */
  insert_region_one?: Maybe<Region>;
  /** insert data into the table: "region_v2" */
  insert_region_v2?: Maybe<Region_V2_Mutation_Response>;
  /** insert a single row into the table: "region_v2" */
  insert_region_v2_one?: Maybe<Region_V2>;
  /** insert data into the table: "regional_data_connectors" */
  insert_regional_data_connectors?: Maybe<Regional_Data_Connectors_Mutation_Response>;
  /** insert a single row into the table: "regional_data_connectors" */
  insert_regional_data_connectors_one?: Maybe<Regional_Data_Connectors>;
  /** insert data into the table: "regional_metrics" */
  insert_regional_metrics?: Maybe<Regional_Metrics_Mutation_Response>;
  /** insert a single row into the table: "regional_metrics" */
  insert_regional_metrics_one?: Maybe<Regional_Metrics>;
  /** insert data into the table: "saml_idp" */
  insert_saml_idp?: Maybe<Saml_Idp_Mutation_Response>;
  /** insert a single row into the table: "saml_idp" */
  insert_saml_idp_one?: Maybe<Saml_Idp>;
  /** insert data into the table: "search_project_login_status_results" */
  insert_search_project_login_status_results?: Maybe<Search_Project_Login_Status_Results_Mutation_Response>;
  /** insert a single row into the table: "search_project_login_status_results" */
  insert_search_project_login_status_results_one?: Maybe<Search_Project_Login_Status_Results>;
  /** insert data into the table: "slack_config" */
  insert_slack_config?: Maybe<Slack_Config_Mutation_Response>;
  /** insert a single row into the table: "slack_config" */
  insert_slack_config_one?: Maybe<Slack_Config>;
  /** insert data into the table: "stripe_subscription" */
  insert_stripe_subscription?: Maybe<Stripe_Subscription_Mutation_Response>;
  /** insert a single row into the table: "stripe_subscription" */
  insert_stripe_subscription_one?: Maybe<Stripe_Subscription>;
  /** insert data into the table: "stripe_webhook_events" */
  insert_stripe_webhook_events?: Maybe<Stripe_Webhook_Events_Mutation_Response>;
  /** insert a single row into the table: "stripe_webhook_events" */
  insert_stripe_webhook_events_one?: Maybe<Stripe_Webhook_Events>;
  /** insert data into the table: "super_connector_types" */
  insert_super_connector_types?: Maybe<Super_Connector_Types_Mutation_Response>;
  /** insert a single row into the table: "super_connector_types" */
  insert_super_connector_types_one?: Maybe<Super_Connector_Types>;
  /** insert data into the table: "support_plan_types" */
  insert_support_plan_types?: Maybe<Support_Plan_Types_Mutation_Response>;
  /** insert a single row into the table: "support_plan_types" */
  insert_support_plan_types_one?: Maybe<Support_Plan_Types>;
  /** insert data into the table: "survey" */
  insert_survey?: Maybe<Survey_Mutation_Response>;
  /** insert a single row into the table: "survey" */
  insert_survey_one?: Maybe<Survey>;
  /** insert data into the table: "survey_question" */
  insert_survey_question?: Maybe<Survey_Question_Mutation_Response>;
  /** insert data into the table: "survey_question_answer_option" */
  insert_survey_question_answer_option?: Maybe<Survey_Question_Answer_Option_Mutation_Response>;
  /** insert a single row into the table: "survey_question_answer_option" */
  insert_survey_question_answer_option_one?: Maybe<Survey_Question_Answer_Option>;
  /** insert data into the table: "survey_question_answers" */
  insert_survey_question_answers?: Maybe<Survey_Question_Answers_Mutation_Response>;
  /** insert a single row into the table: "survey_question_answers" */
  insert_survey_question_answers_one?: Maybe<Survey_Question_Answers>;
  /** insert data into the table: "survey_question_kind" */
  insert_survey_question_kind?: Maybe<Survey_Question_Kind_Mutation_Response>;
  /** insert a single row into the table: "survey_question_kind" */
  insert_survey_question_kind_one?: Maybe<Survey_Question_Kind>;
  /** insert a single row into the table: "survey_question" */
  insert_survey_question_one?: Maybe<Survey_Question>;
  /** insert data into the table: "survey_question_options" */
  insert_survey_question_options?: Maybe<Survey_Question_Options_Mutation_Response>;
  /** insert a single row into the table: "survey_question_options" */
  insert_survey_question_options_one?: Maybe<Survey_Question_Options>;
  /** insert data into the table: "survey_v2" */
  insert_survey_v2?: Maybe<Survey_V2_Mutation_Response>;
  /** insert a single row into the table: "survey_v2" */
  insert_survey_v2_one?: Maybe<Survey_V2>;
  /** insert data into the table: "survey_v2_question" */
  insert_survey_v2_question?: Maybe<Survey_V2_Question_Mutation_Response>;
  /** insert data into the table: "survey_v2_question_kind" */
  insert_survey_v2_question_kind?: Maybe<Survey_V2_Question_Kind_Mutation_Response>;
  /** insert a single row into the table: "survey_v2_question_kind" */
  insert_survey_v2_question_kind_one?: Maybe<Survey_V2_Question_Kind>;
  /** insert a single row into the table: "survey_v2_question" */
  insert_survey_v2_question_one?: Maybe<Survey_V2_Question>;
  /** insert data into the table: "survey_v2_question_option" */
  insert_survey_v2_question_option?: Maybe<Survey_V2_Question_Option_Mutation_Response>;
  /** insert data into the table: "survey_v2_question_option_additional_info_config" */
  insert_survey_v2_question_option_additional_info_config?: Maybe<Survey_V2_Question_Option_Additional_Info_Config_Mutation_Response>;
  /** insert a single row into the table: "survey_v2_question_option_additional_info_config" */
  insert_survey_v2_question_option_additional_info_config_one?: Maybe<Survey_V2_Question_Option_Additional_Info_Config>;
  /** insert a single row into the table: "survey_v2_question_option" */
  insert_survey_v2_question_option_one?: Maybe<Survey_V2_Question_Option>;
  /** insert data into the table: "survey_v2_response" */
  insert_survey_v2_response?: Maybe<Survey_V2_Response_Mutation_Response>;
  /** insert data into the table: "survey_v2_response_answer" */
  insert_survey_v2_response_answer?: Maybe<Survey_V2_Response_Answer_Mutation_Response>;
  /** insert a single row into the table: "survey_v2_response_answer" */
  insert_survey_v2_response_answer_one?: Maybe<Survey_V2_Response_Answer>;
  /** insert data into the table: "survey_v2_response_answer_option" */
  insert_survey_v2_response_answer_option?: Maybe<Survey_V2_Response_Answer_Option_Mutation_Response>;
  /** insert a single row into the table: "survey_v2_response_answer_option" */
  insert_survey_v2_response_answer_option_one?: Maybe<Survey_V2_Response_Answer_Option>;
  /** insert a single row into the table: "survey_v2_response" */
  insert_survey_v2_response_one?: Maybe<Survey_V2_Response>;
  /** insert data into the table: "task_event" */
  insert_task_event?: Maybe<Task_Event_Mutation_Response>;
  /** insert a single row into the table: "task_event" */
  insert_task_event_one?: Maybe<Task_Event>;
  /** insert data into the table: "tasks" */
  insert_tasks?: Maybe<Tasks_Mutation_Response>;
  /** insert a single row into the table: "tasks" */
  insert_tasks_one?: Maybe<Tasks>;
  /** insert data into the table: "tenant" */
  insert_tenant?: Maybe<Tenant_Mutation_Response>;
  /** insert data into the table: "tenant_active_status_reason" */
  insert_tenant_active_status_reason?: Maybe<Tenant_Active_Status_Reason_Mutation_Response>;
  /** insert a single row into the table: "tenant_active_status_reason" */
  insert_tenant_active_status_reason_one?: Maybe<Tenant_Active_Status_Reason>;
  /** insert data into the table: "tenant_group" */
  insert_tenant_group?: Maybe<Tenant_Group_Mutation_Response>;
  /** insert data into the table: "tenant_group_member" */
  insert_tenant_group_member?: Maybe<Tenant_Group_Member_Mutation_Response>;
  /** insert a single row into the table: "tenant_group_member" */
  insert_tenant_group_member_one?: Maybe<Tenant_Group_Member>;
  /** insert a single row into the table: "tenant_group" */
  insert_tenant_group_one?: Maybe<Tenant_Group>;
  /** insert a single row into the table: "tenant" */
  insert_tenant_one?: Maybe<Tenant>;
  /** insert data into the table: "tenant_public_status" */
  insert_tenant_public_status?: Maybe<Tenant_Public_Status_Mutation_Response>;
  /** insert a single row into the table: "tenant_public_status" */
  insert_tenant_public_status_one?: Maybe<Tenant_Public_Status>;
  /** insert data into the table: "tenant_status" */
  insert_tenant_status?: Maybe<Tenant_Status_Mutation_Response>;
  /** insert a single row into the table: "tenant_status" */
  insert_tenant_status_one?: Maybe<Tenant_Status>;
  /** insert data into the table: "trial_leads" */
  insert_trial_leads?: Maybe<Trial_Leads_Mutation_Response>;
  /** insert a single row into the table: "trial_leads" */
  insert_trial_leads_one?: Maybe<Trial_Leads>;
  /** insert data into the table: "ua_audit_logs" */
  insert_ua_audit_logs?: Maybe<Ua_Audit_Logs_Mutation_Response>;
  /** insert a single row into the table: "ua_audit_logs" */
  insert_ua_audit_logs_one?: Maybe<Ua_Audit_Logs>;
  /** insert data into the table: "user_activity" */
  insert_user_activity?: Maybe<User_Activity_Mutation_Response>;
  /** insert a single row into the table: "user_activity" */
  insert_user_activity_one?: Maybe<User_Activity>;
  /** insert data into the table: "user_coupon" */
  insert_user_coupon?: Maybe<User_Coupon_Mutation_Response>;
  /** insert a single row into the table: "user_coupon" */
  insert_user_coupon_one?: Maybe<User_Coupon>;
  /** insert data into the table: "user_entitlement_access" */
  insert_user_entitlement_access?: Maybe<User_Entitlement_Access_Mutation_Response>;
  /** insert a single row into the table: "user_entitlement_access" */
  insert_user_entitlement_access_one?: Maybe<User_Entitlement_Access>;
  /** insert data into the table: "user_entitlement_catalogue" */
  insert_user_entitlement_catalogue?: Maybe<User_Entitlement_Catalogue_Mutation_Response>;
  /** insert a single row into the table: "user_entitlement_catalogue" */
  insert_user_entitlement_catalogue_one?: Maybe<User_Entitlement_Catalogue>;
  /** insert data into the table: "user_entitlement_types" */
  insert_user_entitlement_types?: Maybe<User_Entitlement_Types_Mutation_Response>;
  /** insert a single row into the table: "user_entitlement_types" */
  insert_user_entitlement_types_one?: Maybe<User_Entitlement_Types>;
  /** insert data into the table: "user_onboarding" */
  insert_user_onboarding?: Maybe<User_Onboarding_Mutation_Response>;
  /** insert a single row into the table: "user_onboarding" */
  insert_user_onboarding_one?: Maybe<User_Onboarding>;
  /** insert data into the table: "user_personal_access_tokens" */
  insert_user_personal_access_tokens?: Maybe<User_Personal_Access_Tokens_Mutation_Response>;
  /** insert a single row into the table: "user_personal_access_tokens" */
  insert_user_personal_access_tokens_one?: Maybe<User_Personal_Access_Tokens>;
  /** insert data into the table: "user_profile" */
  insert_user_profile?: Maybe<User_Profile_Mutation_Response>;
  /** insert a single row into the table: "user_profile" */
  insert_user_profile_one?: Maybe<User_Profile>;
  /** insert data into the table: "user_roles" */
  insert_user_roles?: Maybe<User_Roles_Mutation_Response>;
  /** insert a single row into the table: "user_roles" */
  insert_user_roles_one?: Maybe<User_Roles>;
  /** insert data into the table: "user_vpc_policy" */
  insert_user_vpc_policy?: Maybe<User_Vpc_Policy_Mutation_Response>;
  /** insert a single row into the table: "user_vpc_policy" */
  insert_user_vpc_policy_one?: Maybe<User_Vpc_Policy>;
  /** insert data into the table: "users" */
  insert_users?: Maybe<Users_Mutation_Response>;
  /** insert a single row into the table: "users" */
  insert_users_one?: Maybe<Users>;
  /** insert data into the table: "users_public" */
  insert_users_public?: Maybe<Users_Public_Mutation_Response>;
  /** insert a single row into the table: "users_public" */
  insert_users_public_one?: Maybe<Users_Public>;
  /** insert data into the table: "vercel_integration" */
  insert_vercel_integration?: Maybe<Vercel_Integration_Mutation_Response>;
  /** insert data into the table: "vercel_integration_connections" */
  insert_vercel_integration_connections?: Maybe<Vercel_Integration_Connections_Mutation_Response>;
  /** insert a single row into the table: "vercel_integration_connections" */
  insert_vercel_integration_connections_one?: Maybe<Vercel_Integration_Connections>;
  /** insert a single row into the table: "vercel_integration" */
  insert_vercel_integration_one?: Maybe<Vercel_Integration>;
  /** insert data into the table: "vpc_peering" */
  insert_vpc_peering?: Maybe<Vpc_Peering_Mutation_Response>;
  /** insert data into the table: "vpc_peering_direction" */
  insert_vpc_peering_direction?: Maybe<Vpc_Peering_Direction_Mutation_Response>;
  /** insert a single row into the table: "vpc_peering_direction" */
  insert_vpc_peering_direction_one?: Maybe<Vpc_Peering_Direction>;
  /** insert a single row into the table: "vpc_peering" */
  insert_vpc_peering_one?: Maybe<Vpc_Peering>;
  /** insert data into the table: "vpc_status" */
  insert_vpc_status?: Maybe<Vpc_Status_Mutation_Response>;
  /** insert a single row into the table: "vpc_status" */
  insert_vpc_status_one?: Maybe<Vpc_Status>;
  /** insert data into the table: "zendesk_support_category" */
  insert_zendesk_support_category?: Maybe<Zendesk_Support_Category_Mutation_Response>;
  /** insert a single row into the table: "zendesk_support_category" */
  insert_zendesk_support_category_one?: Maybe<Zendesk_Support_Category>;
  /** insert data into the table: "zendesk_support_tickets" */
  insert_zendesk_support_tickets?: Maybe<Zendesk_Support_Tickets_Mutation_Response>;
  /** insert a single row into the table: "zendesk_support_tickets" */
  insert_zendesk_support_tickets_one?: Maybe<Zendesk_Support_Tickets>;
  inviteBillingManager?: Maybe<BillingManagerInvitation>;
  inviteCollaborator?: Maybe<ProjectCollaboratorInvitation>;
  lastMonthProjectUsage: Array<ProjectUsage>;
  moveProjectRegion: MoveProjectRegionResponse;
  /** Creates a project with a database on Neon */
  neonCreateDatabase?: Maybe<NeonCreateDatabaseResponse>;
  /** Action to exchange granted code for access token */
  neonExchangeOAuthToken: NeonExchangeTokenResponse;
  /** Removes the persisted Neon session from Hasura Cloud */
  neonRemoveSession?: Maybe<SuccessOrError>;
  /** Fetches the bills accured by a project in a month for projects on the new plans */
  newPlansProjectUsage?: Maybe<NewPlansProjectOutput>;
  /** Fetches the bills accured by a user in a month for projects on the new plans, grouped by project */
  newPlansProjectUsagePerMonth: Array<NewPlansProjectUsageOutput>;
  payInvoice?: Maybe<PayInvoiceStatus>;
  /** Allows users to reactivate their suspended projects */
  reactivateSuspendedProject: ProjectReactivationResponse;
  regenerateKey: AddProjectResponse;
  removeGithubIntegration?: Maybe<DeleteGithubIntegrationStatus>;
  removeGithubSession?: Maybe<GithubIntegrationStatus>;
  removeHerokuSession: HerokuSessionStatus;
  resendBillingManagerInvite?: Maybe<BillingManagerInvitation>;
  resendChangeUserEmailVerification: ChangeUserEmailRequest;
  resendInvite: ProjectCollaboratorInvitation;
  resendTransferOwnershipInvite: ProjectOwnershipTransferInvitation;
  revokeChangeUserEmailRequest: ChangeUserEmailRequest;
  /** Action to save survey question's answer */
  saveSurveyAnswer?: Maybe<SuccessOrError>;
  /** Action to save survey question's answer */
  saveSurveyAnswerV2?: Maybe<SuccessOrError>;
  setDefaultPaymentMethod?: Maybe<DefaultPaymentResponse>;
  /** Action to exchange granted code for access token */
  slackExchangeOAuthToken: SlackExchangeTokenResponse;
  /** Action to track activity of experiments cohort users */
  trackExperimentsCohortActivity?: Maybe<SuccessOrError>;
  /** Action to track the onboarding activity */
  trackOnboardingActivity?: Maybe<SuccessOrError>;
  trackOnboardingSampleDbCohortActivity?: Maybe<TrackOnboardingSampleDbCohortActivityResponse>;
  transferOwnershipInvite: ProjectOwnershipTransferInvitation;
  triggerAnalyticsInfraModule?: Maybe<BuildKiteBuild>;
  triggerCentralModule?: Maybe<BuildKiteBuild>;
  triggerCentralMonitoringModule?: Maybe<BuildKiteBuild>;
  triggerDataConnectorModule?: Maybe<BuildKiteBuild>;
  triggerDvpcInfraModule?: Maybe<BuildKiteBuild>;
  triggerDvpcLogsModule?: Maybe<BuildKiteBuild>;
  triggerDvpcMonitoringModule?: Maybe<BuildKiteBuild>;
  triggerDvpcOperatorModule?: Maybe<BuildKiteBuild>;
  triggerDvpcPeeringModule?: Maybe<BuildKiteBuild>;
  triggerGatewayClusterModule?: Maybe<BuildKiteBuild>;
  triggerHasuraClusterModule?: Maybe<BuildKiteBuild>;
  triggerHealthcheckModule?: Maybe<BuildKiteBuild>;
  triggerLogsModule?: Maybe<BuildKiteBuild>;
  triggerLuxProxyModule?: Maybe<BuildKiteBuild>;
  triggerMetricsModule?: Maybe<BuildKiteBuild>;
  triggerNodePoolModule?: Maybe<BuildKiteBuild>;
  /** execute one-click-deploy workflow configured for a project idempotently */
  triggerOneClickDeployment?: Maybe<OneClickDeployResponse>;
  triggerOperatorModule?: Maybe<BuildKiteBuild>;
  triggerRegionModule?: Maybe<BuildKiteBuild>;
  triggerRegionMonitoringModule?: Maybe<BuildKiteBuild>;
  triggerTaskqModule?: Maybe<BuildKiteBuild>;
  triggerV3CentralModule?: Maybe<BuildKiteBuild>;
  triggerV3ServerModule?: Maybe<BuildKiteBuild>;
  triggerV3SyncModule?: Maybe<BuildKiteBuild>;
  /** update data of the table: "alert_config" */
  update_alert_config?: Maybe<Alert_Config_Mutation_Response>;
  /** update data of the table: "alert_config_alert_type" */
  update_alert_config_alert_type?: Maybe<Alert_Config_Alert_Type_Mutation_Response>;
  /** update single row of the table: "alert_config_alert_type" */
  update_alert_config_alert_type_by_pk?: Maybe<Alert_Config_Alert_Type>;
  /** update multiples rows of table: "alert_config_alert_type" */
  update_alert_config_alert_type_many?: Maybe<
    Array<Maybe<Alert_Config_Alert_Type_Mutation_Response>>
  >;
  /** update single row of the table: "alert_config" */
  update_alert_config_by_pk?: Maybe<Alert_Config>;
  /** update multiples rows of table: "alert_config" */
  update_alert_config_many?: Maybe<
    Array<Maybe<Alert_Config_Mutation_Response>>
  >;
  /** update data of the table: "alert_config_service" */
  update_alert_config_service?: Maybe<Alert_Config_Service_Mutation_Response>;
  /** update single row of the table: "alert_config_service" */
  update_alert_config_service_by_pk?: Maybe<Alert_Config_Service>;
  /** update multiples rows of table: "alert_config_service" */
  update_alert_config_service_many?: Maybe<
    Array<Maybe<Alert_Config_Service_Mutation_Response>>
  >;
  /** update data of the table: "alert_service_type" */
  update_alert_service_type?: Maybe<Alert_Service_Type_Mutation_Response>;
  /** update single row of the table: "alert_service_type" */
  update_alert_service_type_by_pk?: Maybe<Alert_Service_Type>;
  /** update multiples rows of table: "alert_service_type" */
  update_alert_service_type_many?: Maybe<
    Array<Maybe<Alert_Service_Type_Mutation_Response>>
  >;
  /** update data of the table: "alert_type" */
  update_alert_type?: Maybe<Alert_Type_Mutation_Response>;
  /** update single row of the table: "alert_type" */
  update_alert_type_by_pk?: Maybe<Alert_Type>;
  /** update multiples rows of table: "alert_type" */
  update_alert_type_many?: Maybe<Array<Maybe<Alert_Type_Mutation_Response>>>;
  /** update data of the table: "azuremonitor_config" */
  update_azuremonitor_config?: Maybe<Azuremonitor_Config_Mutation_Response>;
  /** update single row of the table: "azuremonitor_config" */
  update_azuremonitor_config_by_pk?: Maybe<Azuremonitor_Config>;
  /** update multiples rows of table: "azuremonitor_config" */
  update_azuremonitor_config_many?: Maybe<
    Array<Maybe<Azuremonitor_Config_Mutation_Response>>
  >;
  /** update data of the table: "billing_address" */
  update_billing_address?: Maybe<Billing_Address_Mutation_Response>;
  /** update single row of the table: "billing_address" */
  update_billing_address_by_pk?: Maybe<Billing_Address>;
  /** update multiples rows of table: "billing_address" */
  update_billing_address_many?: Maybe<
    Array<Maybe<Billing_Address_Mutation_Response>>
  >;
  /** update data of the table: "central_cloud" */
  update_central_cloud?: Maybe<Central_Cloud_Mutation_Response>;
  /** update single row of the table: "central_cloud" */
  update_central_cloud_by_pk?: Maybe<Central_Cloud>;
  /** update multiples rows of table: "central_cloud" */
  update_central_cloud_many?: Maybe<
    Array<Maybe<Central_Cloud_Mutation_Response>>
  >;
  /** update data of the table: "change_email_request" */
  update_change_email_request?: Maybe<Change_Email_Request_Mutation_Response>;
  /** update single row of the table: "change_email_request" */
  update_change_email_request_by_pk?: Maybe<Change_Email_Request>;
  /** update multiples rows of table: "change_email_request" */
  update_change_email_request_many?: Maybe<
    Array<Maybe<Change_Email_Request_Mutation_Response>>
  >;
  /** update data of the table: "cicd.deployment_pipeline_config" */
  update_cicd_deployment_pipeline_config?: Maybe<Cicd_Deployment_Pipeline_Config_Mutation_Response>;
  /** update single row of the table: "cicd.deployment_pipeline_config" */
  update_cicd_deployment_pipeline_config_by_pk?: Maybe<Cicd_Deployment_Pipeline_Config>;
  /** update multiples rows of table: "cicd.deployment_pipeline_config" */
  update_cicd_deployment_pipeline_config_many?: Maybe<
    Array<Maybe<Cicd_Deployment_Pipeline_Config_Mutation_Response>>
  >;
  /** update data of the table: "cicd.deployment_pool" */
  update_cicd_deployment_pool?: Maybe<Cicd_Deployment_Pool_Mutation_Response>;
  /** update multiples rows of table: "cicd.deployment_pool" */
  update_cicd_deployment_pool_many?: Maybe<
    Array<Maybe<Cicd_Deployment_Pool_Mutation_Response>>
  >;
  /** update data of the table: "cicd.deployment_pool_member" */
  update_cicd_deployment_pool_member?: Maybe<Cicd_Deployment_Pool_Member_Mutation_Response>;
  /** update multiples rows of table: "cicd.deployment_pool_member" */
  update_cicd_deployment_pool_member_many?: Maybe<
    Array<Maybe<Cicd_Deployment_Pool_Member_Mutation_Response>>
  >;
  /** update data of the table: "cloud" */
  update_cloud?: Maybe<Cloud_Mutation_Response>;
  /** update single row of the table: "cloud" */
  update_cloud_by_pk?: Maybe<Cloud>;
  /** update multiples rows of table: "cloud" */
  update_cloud_many?: Maybe<Array<Maybe<Cloud_Mutation_Response>>>;
  /** update data of the table: "cloud_metadata" */
  update_cloud_metadata?: Maybe<Cloud_Metadata_Mutation_Response>;
  /** update single row of the table: "cloud_metadata" */
  update_cloud_metadata_by_pk?: Maybe<Cloud_Metadata>;
  /** update multiples rows of table: "cloud_metadata" */
  update_cloud_metadata_many?: Maybe<
    Array<Maybe<Cloud_Metadata_Mutation_Response>>
  >;
  /** update data of the table: "compute_unit_config" */
  update_compute_unit_config?: Maybe<Compute_Unit_Config_Mutation_Response>;
  /** update single row of the table: "compute_unit_config" */
  update_compute_unit_config_by_pk?: Maybe<Compute_Unit_Config>;
  /** update multiples rows of table: "compute_unit_config" */
  update_compute_unit_config_many?: Maybe<
    Array<Maybe<Compute_Unit_Config_Mutation_Response>>
  >;
  /** update data of the table: "config" */
  update_config?: Maybe<Config_Mutation_Response>;
  /** update single row of the table: "config" */
  update_config_by_pk?: Maybe<Config>;
  /** update multiples rows of table: "config" */
  update_config_many?: Maybe<Array<Maybe<Config_Mutation_Response>>>;
  /** update data of the table: "config_status" */
  update_config_status?: Maybe<Config_Status_Mutation_Response>;
  /** update single row of the table: "config_status" */
  update_config_status_by_pk?: Maybe<Config_Status>;
  /** update multiples rows of table: "config_status" */
  update_config_status_many?: Maybe<
    Array<Maybe<Config_Status_Mutation_Response>>
  >;
  /** update data of the table: "connector_config" */
  update_connector_config?: Maybe<Connector_Config_Mutation_Response>;
  /** update single row of the table: "connector_config" */
  update_connector_config_by_pk?: Maybe<Connector_Config>;
  /** update multiples rows of table: "connector_config" */
  update_connector_config_many?: Maybe<
    Array<Maybe<Connector_Config_Mutation_Response>>
  >;
  /** update data of the table: "connector_deployments" */
  update_connector_deployments?: Maybe<Connector_Deployments_Mutation_Response>;
  /** update single row of the table: "connector_deployments" */
  update_connector_deployments_by_pk?: Maybe<Connector_Deployments>;
  /** update multiples rows of table: "connector_deployments" */
  update_connector_deployments_many?: Maybe<
    Array<Maybe<Connector_Deployments_Mutation_Response>>
  >;
  /** update data of the table: "coupon" */
  update_coupon?: Maybe<Coupon_Mutation_Response>;
  /** update single row of the table: "coupon" */
  update_coupon_by_pk?: Maybe<Coupon>;
  /** update data of the table: "coupon_duration" */
  update_coupon_duration?: Maybe<Coupon_Duration_Mutation_Response>;
  /** update single row of the table: "coupon_duration" */
  update_coupon_duration_by_pk?: Maybe<Coupon_Duration>;
  /** update multiples rows of table: "coupon_duration" */
  update_coupon_duration_many?: Maybe<
    Array<Maybe<Coupon_Duration_Mutation_Response>>
  >;
  /** update multiples rows of table: "coupon" */
  update_coupon_many?: Maybe<Array<Maybe<Coupon_Mutation_Response>>>;
  /** update data of the table: "coupon_type" */
  update_coupon_type?: Maybe<Coupon_Type_Mutation_Response>;
  /** update single row of the table: "coupon_type" */
  update_coupon_type_by_pk?: Maybe<Coupon_Type>;
  /** update multiples rows of table: "coupon_type" */
  update_coupon_type_many?: Maybe<Array<Maybe<Coupon_Type_Mutation_Response>>>;
  /** update data of the table: "custom_domain" */
  update_custom_domain?: Maybe<Custom_Domain_Mutation_Response>;
  /** update single row of the table: "custom_domain" */
  update_custom_domain_by_pk?: Maybe<Custom_Domain>;
  /** update data of the table: "custom_domain_cloudflare" */
  update_custom_domain_cloudflare?: Maybe<Custom_Domain_Cloudflare_Mutation_Response>;
  /** update single row of the table: "custom_domain_cloudflare" */
  update_custom_domain_cloudflare_by_pk?: Maybe<Custom_Domain_Cloudflare>;
  /** update data of the table: "custom_domain_cloudflare_dns" */
  update_custom_domain_cloudflare_dns?: Maybe<Custom_Domain_Cloudflare_Dns_Mutation_Response>;
  /** update single row of the table: "custom_domain_cloudflare_dns" */
  update_custom_domain_cloudflare_dns_by_pk?: Maybe<Custom_Domain_Cloudflare_Dns>;
  /** update multiples rows of table: "custom_domain_cloudflare_dns" */
  update_custom_domain_cloudflare_dns_many?: Maybe<
    Array<Maybe<Custom_Domain_Cloudflare_Dns_Mutation_Response>>
  >;
  /** update multiples rows of table: "custom_domain_cloudflare" */
  update_custom_domain_cloudflare_many?: Maybe<
    Array<Maybe<Custom_Domain_Cloudflare_Mutation_Response>>
  >;
  /** update multiples rows of table: "custom_domain" */
  update_custom_domain_many?: Maybe<
    Array<Maybe<Custom_Domain_Mutation_Response>>
  >;
  /** update data of the table: "customer_usage" */
  update_customer_usage?: Maybe<Customer_Usage_Mutation_Response>;
  /** update single row of the table: "customer_usage" */
  update_customer_usage_by_pk?: Maybe<Customer_Usage>;
  /** update multiples rows of table: "customer_usage" */
  update_customer_usage_many?: Maybe<
    Array<Maybe<Customer_Usage_Mutation_Response>>
  >;
  /** update data of the table: "data_connector_type" */
  update_data_connector_type?: Maybe<Data_Connector_Type_Mutation_Response>;
  /** update single row of the table: "data_connector_type" */
  update_data_connector_type_by_pk?: Maybe<Data_Connector_Type>;
  /** update multiples rows of table: "data_connector_type" */
  update_data_connector_type_many?: Maybe<
    Array<Maybe<Data_Connector_Type_Mutation_Response>>
  >;
  /** update data of the table: "datadog_config" */
  update_datadog_config?: Maybe<Datadog_Config_Mutation_Response>;
  /** update single row of the table: "datadog_config" */
  update_datadog_config_by_pk?: Maybe<Datadog_Config>;
  /** update multiples rows of table: "datadog_config" */
  update_datadog_config_many?: Maybe<
    Array<Maybe<Datadog_Config_Mutation_Response>>
  >;
  /** update data of the table: "db_latency" */
  update_db_latency?: Maybe<Db_Latency_Mutation_Response>;
  /** update single row of the table: "db_latency" */
  update_db_latency_by_pk?: Maybe<Db_Latency>;
  /** update multiples rows of table: "db_latency" */
  update_db_latency_many?: Maybe<Array<Maybe<Db_Latency_Mutation_Response>>>;
  /** update data of the table: "ddn.build" */
  update_ddn_build?: Maybe<Ddn_Build_Mutation_Response>;
  /** update single row of the table: "ddn.build" */
  update_ddn_build_by_pk?: Maybe<Ddn_Build>;
  /** update multiples rows of table: "ddn.build" */
  update_ddn_build_many?: Maybe<Array<Maybe<Ddn_Build_Mutation_Response>>>;
  /** update data of the table: "ddn.build_sync_status" */
  update_ddn_build_sync_status?: Maybe<Ddn_Build_Sync_Status_Mutation_Response>;
  /** update single row of the table: "ddn.build_sync_status" */
  update_ddn_build_sync_status_by_pk?: Maybe<Ddn_Build_Sync_Status>;
  /** update multiples rows of table: "ddn.build_sync_status" */
  update_ddn_build_sync_status_many?: Maybe<
    Array<Maybe<Ddn_Build_Sync_Status_Mutation_Response>>
  >;
  /** update data of the table: "ddn.build_sync_worker" */
  update_ddn_build_sync_worker?: Maybe<Ddn_Build_Sync_Worker_Mutation_Response>;
  /** update single row of the table: "ddn.build_sync_worker" */
  update_ddn_build_sync_worker_by_pk?: Maybe<Ddn_Build_Sync_Worker>;
  /** update multiples rows of table: "ddn.build_sync_worker" */
  update_ddn_build_sync_worker_many?: Maybe<
    Array<Maybe<Ddn_Build_Sync_Worker_Mutation_Response>>
  >;
  /** update data of the table: "ddn.environment" */
  update_ddn_environment?: Maybe<Ddn_Environment_Mutation_Response>;
  /** update single row of the table: "ddn.environment" */
  update_ddn_environment_by_pk?: Maybe<Ddn_Environment>;
  /** update multiples rows of table: "ddn.environment" */
  update_ddn_environment_many?: Maybe<
    Array<Maybe<Ddn_Environment_Mutation_Response>>
  >;
  /** update data of the table: "ddn.project_entitlement_access" */
  update_ddn_project_entitlement_access?: Maybe<Ddn_Project_Entitlement_Access_Mutation_Response>;
  /** update single row of the table: "ddn.project_entitlement_access" */
  update_ddn_project_entitlement_access_by_pk?: Maybe<Ddn_Project_Entitlement_Access>;
  /** update multiples rows of table: "ddn.project_entitlement_access" */
  update_ddn_project_entitlement_access_many?: Maybe<
    Array<Maybe<Ddn_Project_Entitlement_Access_Mutation_Response>>
  >;
  /** update data of the table: "ddn.project_entitlement_catalogue" */
  update_ddn_project_entitlement_catalogue?: Maybe<Ddn_Project_Entitlement_Catalogue_Mutation_Response>;
  /** update single row of the table: "ddn.project_entitlement_catalogue" */
  update_ddn_project_entitlement_catalogue_by_pk?: Maybe<Ddn_Project_Entitlement_Catalogue>;
  /** update multiples rows of table: "ddn.project_entitlement_catalogue" */
  update_ddn_project_entitlement_catalogue_many?: Maybe<
    Array<Maybe<Ddn_Project_Entitlement_Catalogue_Mutation_Response>>
  >;
  /** update data of the table: "ddn.project_entitlement_types" */
  update_ddn_project_entitlement_types?: Maybe<Ddn_Project_Entitlement_Types_Mutation_Response>;
  /** update single row of the table: "ddn.project_entitlement_types" */
  update_ddn_project_entitlement_types_by_pk?: Maybe<Ddn_Project_Entitlement_Types>;
  /** update multiples rows of table: "ddn.project_entitlement_types" */
  update_ddn_project_entitlement_types_many?: Maybe<
    Array<Maybe<Ddn_Project_Entitlement_Types_Mutation_Response>>
  >;
  /** update data of the table: "ddn.projects" */
  update_ddn_projects?: Maybe<Ddn_Projects_Mutation_Response>;
  /** update single row of the table: "ddn.projects" */
  update_ddn_projects_by_pk?: Maybe<Ddn_Projects>;
  /** update multiples rows of table: "ddn.projects" */
  update_ddn_projects_many?: Maybe<
    Array<Maybe<Ddn_Projects_Mutation_Response>>
  >;
  /** update data of the table: "ddn.tunnel" */
  update_ddn_tunnel?: Maybe<Ddn_Tunnel_Mutation_Response>;
  /** update single row of the table: "ddn.tunnel" */
  update_ddn_tunnel_by_pk?: Maybe<Ddn_Tunnel>;
  /** update data of the table: "ddn.tunnel_cluster" */
  update_ddn_tunnel_cluster?: Maybe<Ddn_Tunnel_Cluster_Mutation_Response>;
  /** update single row of the table: "ddn.tunnel_cluster" */
  update_ddn_tunnel_cluster_by_pk?: Maybe<Ddn_Tunnel_Cluster>;
  /** update multiples rows of table: "ddn.tunnel_cluster" */
  update_ddn_tunnel_cluster_many?: Maybe<
    Array<Maybe<Ddn_Tunnel_Cluster_Mutation_Response>>
  >;
  /** update multiples rows of table: "ddn.tunnel" */
  update_ddn_tunnel_many?: Maybe<Array<Maybe<Ddn_Tunnel_Mutation_Response>>>;
  /** update data of the table: "dedicated_cloud_bills" */
  update_dedicated_cloud_bills?: Maybe<Dedicated_Cloud_Bills_Mutation_Response>;
  /** update single row of the table: "dedicated_cloud_bills" */
  update_dedicated_cloud_bills_by_pk?: Maybe<Dedicated_Cloud_Bills>;
  /** update data of the table: "dedicated_cloud_bills_details" */
  update_dedicated_cloud_bills_details?: Maybe<Dedicated_Cloud_Bills_Details_Mutation_Response>;
  /** update single row of the table: "dedicated_cloud_bills_details" */
  update_dedicated_cloud_bills_details_by_pk?: Maybe<Dedicated_Cloud_Bills_Details>;
  /** update multiples rows of table: "dedicated_cloud_bills_details" */
  update_dedicated_cloud_bills_details_many?: Maybe<
    Array<Maybe<Dedicated_Cloud_Bills_Details_Mutation_Response>>
  >;
  /** update multiples rows of table: "dedicated_cloud_bills" */
  update_dedicated_cloud_bills_many?: Maybe<
    Array<Maybe<Dedicated_Cloud_Bills_Mutation_Response>>
  >;
  /** update data of the table: "dedicated_cloud_commitments" */
  update_dedicated_cloud_commitments?: Maybe<Dedicated_Cloud_Commitments_Mutation_Response>;
  /** update single row of the table: "dedicated_cloud_commitments" */
  update_dedicated_cloud_commitments_by_pk?: Maybe<Dedicated_Cloud_Commitments>;
  /** update multiples rows of table: "dedicated_cloud_commitments" */
  update_dedicated_cloud_commitments_many?: Maybe<
    Array<Maybe<Dedicated_Cloud_Commitments_Mutation_Response>>
  >;
  /** update data of the table: "dedicated_vpc" */
  update_dedicated_vpc?: Maybe<Dedicated_Vpc_Mutation_Response>;
  /** update single row of the table: "dedicated_vpc" */
  update_dedicated_vpc_by_pk?: Maybe<Dedicated_Vpc>;
  /** update multiples rows of table: "dedicated_vpc" */
  update_dedicated_vpc_many?: Maybe<
    Array<Maybe<Dedicated_Vpc_Mutation_Response>>
  >;
  /** update data of the table: "delete_user" */
  update_delete_user?: Maybe<Delete_User_Mutation_Response>;
  /** update single row of the table: "delete_user" */
  update_delete_user_by_pk?: Maybe<Delete_User>;
  /** update multiples rows of table: "delete_user" */
  update_delete_user_many?: Maybe<Array<Maybe<Delete_User_Mutation_Response>>>;
  /** update data of the table: "delete_user_status" */
  update_delete_user_status?: Maybe<Delete_User_Status_Mutation_Response>;
  /** update single row of the table: "delete_user_status" */
  update_delete_user_status_by_pk?: Maybe<Delete_User_Status>;
  /** update mul