import clsx from 'clsx';
import React from 'react';

type LogoModes = 'default' | 'primary' | 'secondary';
type LogoSize = 'sm' | 'md' | 'lg';

type Props = {
  /**
   * The logo size
   */
  size?: LogoSize;
  /**
   * The logo mode
   */
  mode?: LogoModes;
  /**
   * The logo className
   */
  className?: string;
};

const logoSizing: Record<LogoSize, string> = {
  sm: 'w-4 h-4 mr-1.5',
  md: 'w-10 h-10 mr-2',
  lg: 'w-14 h-14 mr-2',
};

const logoModesStyles: Record<LogoModes, string> = {
  default: 'black',
  primary: 'white',
  secondary: '#14394a',
};

export function HasuraLogoIcon(props: Props) {
  const { size = 'md', mode = 'default' } = props;

  return (
    <svg
      className={clsx(logoSizing[size], props.className)}
      viewBox="0 0 81 84"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_5273_22557)">
        <path
          d="M79.7186 28.6019C82.1218 21.0731 80.6778 6.03602 76.0158 0.487869C75.4073 -0.238057 74.2624 -0.134353 73.757 0.664165L68.0121 9.72787C66.5887 11.5427 64.0308 11.9575 62.1124 10.6923C55.8827 6.59602 48.4359 4.21083 40.4322 4.21083C32.4285 4.21083 24.9817 6.59602 18.752 10.6923C16.8336 11.9575 14.2757 11.5323 12.8523 9.72787L7.10738 0.664165C6.60199 -0.134353 5.45712 -0.238057 4.84859 0.487869C0.186621 6.03602 -1.25735 21.0731 1.14583 28.6019C1.94002 31.1012 2.16693 33.7456 1.69248 36.3279C1.22834 38.879 0.753897 41.9693 0.753897 44.1056C0.753897 66.1323 18.5251 84.0005 40.4322 84.0005C62.3497 84.0005 80.1105 66.1427 80.1105 44.1056C80.1105 41.959 79.6464 38.879 79.1719 36.3279C78.6975 33.7456 78.9244 31.1012 79.7186 28.6019ZM40.4322 75.0819C23.4965 75.0819 9.71684 61.2271 9.71684 44.199C9.71684 43.639 9.73747 43.0893 9.7581 42.5397C10.3769 30.9353 17.3802 21.0108 27.3024 16.2819C31.2836 14.3738 35.7393 13.316 40.4322 13.316C45.1251 13.316 49.5808 14.3842 53.5724 16.2923C63.4945 21.0212 70.4978 30.9456 71.1166 42.5397C71.1476 43.0893 71.1579 43.639 71.1579 44.199C71.1476 61.2271 57.3679 75.0819 40.4322 75.0819Z"
          fill={logoModesStyles[mode]}
        />
        <path
          d="M53.7371 56.083L45.8881 42.4045L39.153 30.997C38.9983 30.7274 38.7095 30.5615 38.3898 30.5615H31.9538C31.634 30.5615 31.3452 30.7378 31.1905 31.0074C31.0358 31.2874 31.0358 31.6296 31.2008 31.8993L37.6368 42.7882L28.9936 56.0415C28.8183 56.3111 28.7977 56.6637 28.9524 56.9541C29.1071 57.2445 29.4062 57.4208 29.7259 57.4208H36.2032C36.5023 57.4208 36.7808 57.2652 36.9458 57.0163L41.6181 49.6741L45.8056 56.9748C45.9603 57.2548 46.2594 57.4208 46.5688 57.4208H52.9533C53.273 57.4208 53.5618 57.2548 53.7165 56.9748C53.9022 56.6948 53.9022 56.363 53.7371 56.083Z"
          fill={logoModesStyles[mode]}
        />
      </g>
      <defs>
        <clipPath id="clip0_5273_22557">
          <rect width="81" height="84" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}
