import React from 'react';
import clsx from 'clsx';

type PrometheusAnimationProps = {
  /**
   * The class name of the root element
   */
  className?: string;
  /**
   * Flag indicating wheter the form is enabled
   */
  enabled?: boolean;
  /**
   * Flag indicating wheter the animation should display error mode
   */
  errorMode?: boolean;
};

export const PrometheusAnimation: React.FC<PrometheusAnimationProps> = ({
  className,
  enabled = false,
  errorMode = false,
}: PrometheusAnimationProps) => (
  <>
    {errorMode ? (
      <svg
        width="100%"
        height="100%"
        viewBox="0 0 823 258"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        className={clsx('w-full', className)}
      >
        <g id="Variant=Error">
          <rect
            x="0.5"
            y="1"
            width="823"
            height="256"
            rx="3.5"
            fill="#E2E8F0"
          />
          <g id="Left">
            <g id="Col1">
              <g id="Cards">
                <g id="SchemaTitle">
                  <path
                    id="Title"
                    d="M25.556 69.4L25.268 70.804L24.524 70.6C23.996 70.48 23.536 70.42 23.144 70.42C22.6 70.42 22.328 70.68 22.328 71.2C22.328 71.4 22.42 71.584 22.604 71.752C22.796 71.912 23.036 72.048 23.324 72.16C23.612 72.264 23.92 72.396 24.248 72.556C24.576 72.716 24.884 72.888 25.172 73.072C25.46 73.256 25.696 73.508 25.88 73.828C26.072 74.148 26.168 74.516 26.168 74.932C26.168 75.756 25.9 76.404 25.364 76.876C24.836 77.34 24.088 77.572 23.12 77.572C22.624 77.572 22.128 77.508 21.632 77.38C21.144 77.244 20.74 77.088 20.42 76.912L20.936 75.628C21.672 75.964 22.4 76.132 23.12 76.132C23.528 76.132 23.848 76.04 24.08 75.856C24.312 75.664 24.428 75.42 24.428 75.124C24.428 74.828 24.296 74.584 24.032 74.392C23.768 74.192 23.448 74.016 23.072 73.864C22.696 73.704 22.32 73.528 21.944 73.336C21.568 73.136 21.248 72.86 20.984 72.508C20.72 72.148 20.588 71.724 20.588 71.236C20.588 70.508 20.816 69.952 21.272 69.568C21.728 69.176 22.34 68.98 23.108 68.98C23.884 68.98 24.7 69.12 25.556 69.4ZM30.4854 77.56C29.3094 77.56 28.4214 77.156 27.8214 76.348C27.2214 75.532 26.9214 74.496 26.9214 73.24C26.9214 71.984 27.2214 70.96 27.8214 70.168C28.4294 69.376 29.3174 68.98 30.4854 68.98C31.6614 68.98 32.5534 69.376 33.1614 70.168C33.7694 70.96 34.0734 71.984 34.0734 73.24C34.0734 74.96 33.5494 76.2 32.5014 76.96C31.9494 77.36 31.2774 77.56 30.4854 77.56ZM30.5094 70.36C30.0854 70.36 29.7294 70.508 29.4414 70.804C28.9294 71.316 28.6734 72.128 28.6734 73.24C28.6734 74.08 28.8294 74.78 29.1414 75.34C29.4534 75.892 29.9094 76.168 30.5094 76.168C31.1174 76.168 31.5734 75.888 31.8774 75.328C32.1814 74.76 32.3334 74.072 32.3334 73.264C32.3334 72.448 32.1694 71.76 31.8414 71.2C31.5214 70.64 31.0774 70.36 30.5094 70.36ZM40.7026 76.78C40.1666 77.308 39.3906 77.572 38.3746 77.572C37.3586 77.572 36.5826 77.308 36.0466 76.78C35.5106 76.244 35.2426 75.452 35.2426 74.404V69.1H36.9946V74.548C36.9946 75.076 37.1106 75.484 37.3426 75.772C37.5826 76.052 37.9226 76.192 38.3626 76.192C38.8026 76.192 39.1426 76.052 39.3826 75.772C39.6306 75.484 39.7546 75.076 39.7546 74.548V69.1H41.5066V74.404C41.5066 75.452 41.2386 76.244 40.7026 76.78ZM45.0954 73.852H44.9514V77.488H43.2114V69.088H45.8754C46.7794 69.088 47.4554 69.288 47.9034 69.688C48.3514 70.08 48.5754 70.644 48.5754 71.38C48.5754 71.828 48.4194 72.24 48.1074 72.616C47.7954 72.984 47.4154 73.196 46.9674 73.252C47.2874 73.34 47.5354 73.488 47.7114 73.696C47.8874 73.896 48.0714 74.224 48.2634 74.68L49.4514 77.488H47.6634L46.4994 74.8C46.3314 74.416 46.1514 74.164 45.9594 74.044C45.7754 73.916 45.4874 73.852 45.0954 73.852ZM45.8274 70.456H44.9514V72.484H45.7074C46.0274 72.484 46.2754 72.38 46.4514 72.172C46.6354 71.964 46.7274 71.708 46.7274 71.404C46.7274 70.772 46.4274 70.456 45.8274 70.456ZM53.7418 77.572C52.5178 77.572 51.5778 77.188 50.9218 76.42C50.2738 75.644 49.9498 74.596 49.9498 73.276C49.9498 71.956 50.2938 70.912 50.9818 70.144C51.6778 69.376 52.6418 68.992 53.8738 68.992C54.5458 68.992 55.2138 69.108 55.8778 69.34L55.5418 70.684C55.0538 70.476 54.4778 70.372 53.8138 70.372C53.1498 70.372 52.6298 70.624 52.2538 71.128C51.8778 71.632 51.6898 72.328 51.6898 73.216C51.6898 74.104 51.8658 74.824 52.2178 75.376C52.5698 75.92 53.0658 76.192 53.7058 76.192C54.1858 76.192 54.8698 76.036 55.7578 75.724L56.1178 76.948C55.3898 77.364 54.5978 77.572 53.7418 77.572ZM62.4537 77.5H57.4497V69.1H62.4537V70.48H59.1897V72.244H62.1537V73.648H59.1897V76.12H62.4537V77.5ZM68.6576 69.4L68.3696 70.804L67.6256 70.6C67.0976 70.48 66.6376 70.42 66.2456 70.42C65.7016 70.42 65.4296 70.68 65.4296 71.2C65.4296 71.4 65.5216 71.584 65.7056 71.752C65.8976 71.912 66.1376 72.048 66.4256 72.16C66.7136 72.264 67.0216 72.396 67.3496 72.556C67.6776 72.716 67.9856 72.888 68.2736 73.072C68.5616 73.256 68.7976 73.508 68.9816 73.828C69.1736 74.148 69.2696 74.516 69.2696 74.932C69.2696 75.756 69.0016 76.404 68.4656 76.876C67.9376 77.34 67.1896 77.572 66.2216 77.572C65.7256 77.572 65.2296 77.508 64.7336 77.38C64.2456 77.244 63.8416 77.088 63.5216 76.912L64.0376 75.628C64.7736 75.964 65.5016 76.132 66.2216 76.132C66.6296 76.132 66.9496 76.04 67.1816 75.856C67.4136 75.664 67.5296 75.42 67.5296 75.124C67.5296 74.828 67.3976 74.584 67.1336 74.392C66.8696 74.192 66.5496 74.016 66.1736 73.864C65.7976 73.704 65.4216 73.528 65.0456 73.336C64.6696 73.136 64.3496 72.86 64.0856 72.508C63.8216 72.148 63.6896 71.724 63.6896 71.236C63.6896 70.508 63.9176 69.952 64.3736 69.568C64.8296 69.176 65.4416 68.98 66.2096 68.98C66.9856 68.98 67.8016 69.12 68.6576 69.4Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="SchemaCard">
                  <g id="Container">
                    <g id="Icon">
                      <path
                        id="Vector"
                        d="M42.6025 110.295L42.4488 110.563C42.3925 110.663 42.2725 110.704 42.1657 110.665C41.9444 110.582 41.7419 110.464 41.5638 110.316C41.4775 110.245 41.455 110.119 41.5113 110.022L41.665 109.753C41.5357 109.603 41.4344 109.429 41.3669 109.24H41.0575C40.945 109.24 40.8475 109.159 40.8288 109.047C40.7913 108.822 40.7894 108.585 40.8288 108.351C40.8475 108.238 40.945 108.156 41.0575 108.156H41.3669C41.4344 107.967 41.5357 107.792 41.665 107.642L41.5113 107.374C41.455 107.277 41.4757 107.151 41.5638 107.08C41.7419 106.932 41.9463 106.813 42.1657 106.731C42.2725 106.692 42.3925 106.733 42.4488 106.832L42.6025 107.1C42.7994 107.065 43 107.065 43.1969 107.1L43.3507 106.832C43.4069 106.733 43.5269 106.692 43.6338 106.731C43.855 106.813 44.0575 106.932 44.2357 107.08C44.3219 107.151 44.3444 107.277 44.2882 107.374L44.1344 107.642C44.2638 107.792 44.365 107.967 44.4325 108.156H44.7419C44.8544 108.156 44.9519 108.237 44.9707 108.349C45.0082 108.574 45.01 108.81 44.9707 109.045C44.9519 109.157 44.8544 109.24 44.7419 109.24H44.4325C44.365 109.429 44.2638 109.603 44.1344 109.753L44.2882 110.022C44.3444 110.119 44.3238 110.245 44.2357 110.316C44.0575 110.464 43.8532 110.582 43.6338 110.665C43.5269 110.704 43.4069 110.663 43.3507 110.563L43.1969 110.295C43.0019 110.331 42.7994 110.331 42.6025 110.295ZM42.4057 109.193C43.1275 109.748 43.9507 108.925 43.3957 108.203C42.6738 107.646 41.8507 108.471 42.4057 109.193ZM40.2438 112.078L40.8757 112.393C41.065 112.502 41.1475 112.733 41.0725 112.939C40.9057 113.393 40.5775 113.809 40.2738 114.173C40.135 114.34 39.895 114.381 39.7057 114.272L39.16 113.957C38.86 114.214 38.5113 114.418 38.1307 114.552V115.182C38.1307 115.399 37.975 115.587 37.7613 115.624C37.3 115.703 36.8163 115.707 36.3382 115.624C36.1225 115.587 35.9632 115.401 35.9632 115.182V114.552C35.5825 114.417 35.2338 114.214 34.9338 113.957L34.3882 114.27C34.2007 114.379 33.9588 114.338 33.82 114.171C33.5163 113.807 33.1957 113.391 33.0288 112.939C32.9538 112.735 33.0363 112.504 33.2257 112.393L33.85 112.078C33.7769 111.687 33.7769 111.283 33.85 110.89L33.2257 110.573C33.0363 110.464 32.9519 110.233 33.0288 110.029C33.1957 109.575 33.5163 109.159 33.82 108.795C33.9588 108.628 34.1988 108.587 34.3882 108.696L34.9338 109.011C35.2338 108.754 35.5825 108.55 35.9632 108.417V107.785C35.9632 107.569 36.1169 107.382 36.3307 107.344C36.7919 107.265 37.2775 107.262 37.7557 107.342C37.9713 107.38 38.1307 107.565 38.1307 107.785V108.415C38.5113 108.55 38.86 108.752 39.16 109.009L39.7057 108.694C39.8932 108.585 40.135 108.627 40.2738 108.793C40.5775 109.157 40.8963 109.573 41.0632 110.027C41.1382 110.232 41.065 110.462 40.8757 110.573L40.2438 110.888C40.3169 111.282 40.3169 111.685 40.2438 112.078ZM38.0388 112.474C39.1488 111.03 37.5007 109.382 36.0569 110.492C34.9469 111.936 36.595 113.584 38.0388 112.474ZM42.6025 115.9L42.4488 116.168C42.3925 116.267 42.2725 116.308 42.1657 116.269C41.9444 116.187 41.7419 116.068 41.5638 115.92C41.4775 115.849 41.455 115.723 41.5113 115.626L41.665 115.358C41.5357 115.208 41.4344 115.033 41.3669 114.844H41.0575C40.945 114.844 40.8475 114.763 40.8288 114.651C40.7913 114.426 40.7894 114.19 40.8288 113.955C40.8475 113.843 40.945 113.76 41.0575 113.76H41.3669C41.4344 113.571 41.5357 113.397 41.665 113.247L41.5113 112.978C41.455 112.881 41.4757 112.755 41.5638 112.684C41.7419 112.536 41.9463 112.418 42.1657 112.335C42.2725 112.296 42.3925 112.337 42.4488 112.437L42.6025 112.705C42.7994 112.669 43 112.669 43.1969 112.705L43.3507 112.437C43.4069 112.337 43.5269 112.296 43.6338 112.335C43.855 112.418 44.0575 112.536 44.2357 112.684C44.3219 112.755 44.3444 112.881 44.2882 112.978L44.1344 113.247C44.2638 113.397 44.365 113.571 44.4325 113.76H44.7419C44.8544 113.76 44.9519 113.841 44.9707 113.953C45.0082 114.178 45.01 114.415 44.9707 114.649C44.9519 114.762 44.8544 114.844 44.7419 114.844H44.4325C44.365 115.033 44.2638 115.208 44.1344 115.358L44.2882 115.626C44.3444 115.723 44.3238 115.849 44.2357 115.92C44.0575 116.068 43.8532 116.187 43.6338 116.269C43.5269 116.308 43.4069 116.267 43.3507 116.168L43.1969 115.9C43.0019 115.935 42.7994 115.935 42.6025 115.9ZM42.4057 114.795C43.1275 115.35 43.9507 114.527 43.3957 113.805C42.6738 113.25 41.8507 114.073 42.4057 114.795Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label"
                      d="M53.192 111.894H52.324V116.486H51.274V106.686H54.102C55.054 106.686 55.768 106.905 56.244 107.344C56.7293 107.773 56.972 108.389 56.972 109.192C56.972 109.752 56.776 110.265 56.384 110.732C56.0013 111.199 55.5253 111.469 54.956 111.544C55.4133 111.647 55.7353 111.796 55.922 111.992C56.118 112.179 56.3467 112.585 56.608 113.21L57.994 116.486H56.888L55.53 113.35C55.278 112.762 54.9933 112.375 54.676 112.188C54.368 111.992 53.8733 111.894 53.192 111.894ZM54.046 107.582H52.324V110.998H53.906C54.4847 110.998 54.942 110.83 55.278 110.494C55.6233 110.149 55.796 109.715 55.796 109.192C55.796 108.669 55.642 108.273 55.334 108.002C55.026 107.722 54.5967 107.582 54.046 107.582ZM64.9875 116.5H59.7095V106.7H64.9875V107.61H60.7595V110.718H64.6375V111.656H60.7595V115.59H64.9875V116.5ZM72.2254 107.05L72.0014 107.988L71.1894 107.75C70.6108 107.61 70.1114 107.54 69.6914 107.54C68.5901 107.54 68.0394 108.03 68.0394 109.01C68.0394 109.439 68.2074 109.794 68.5434 110.074C68.8794 110.345 69.2854 110.564 69.7614 110.732C70.2468 110.891 70.7274 111.068 71.2034 111.264C71.6888 111.451 72.0994 111.745 72.4354 112.146C72.7714 112.538 72.9394 113.037 72.9394 113.644C72.9394 114.568 72.6548 115.291 72.0854 115.814C71.5161 116.327 70.7088 116.584 69.6634 116.584C69.1408 116.584 68.6134 116.509 68.0814 116.36C67.5588 116.201 67.1294 116.019 66.7934 115.814L67.1434 115.016C67.9928 115.408 68.7954 115.604 69.5514 115.604C70.3168 115.604 70.8954 115.45 71.2874 115.142C71.6888 114.834 71.8894 114.386 71.8894 113.798C71.8894 113.201 71.5674 112.734 70.9234 112.398C70.6341 112.249 70.3121 112.109 69.9574 111.978C69.6121 111.847 69.2621 111.707 68.9074 111.558C68.5621 111.399 68.2448 111.222 67.9554 111.026C67.6754 110.83 67.4421 110.564 67.2554 110.228C67.0781 109.892 66.9894 109.5 66.9894 109.052C66.9894 108.249 67.2274 107.633 67.7034 107.204C68.1888 106.775 68.8374 106.56 69.6494 106.56C70.4614 106.56 71.3201 106.723 72.2254 107.05ZM76.7584 116.5V107.638H74.0144V106.7H80.5104V107.638H77.7944V116.5H76.7584ZM90.8411 116.5H85.5631V106.7H90.8411V107.61H86.6131V110.718H90.4911V111.656H86.6131V115.59H90.8411V116.5ZM94.201 110.942V116.5H93.151V109.5H93.823L93.991 110.186C94.2056 110.018 94.3783 109.887 94.509 109.794C94.649 109.701 94.8683 109.607 95.167 109.514C95.4656 109.411 95.783 109.36 96.119 109.36C96.763 109.36 97.295 109.561 97.715 109.962C98.1443 110.354 98.359 110.914 98.359 111.642V116.5H97.309V111.95C97.309 110.821 96.8376 110.256 95.895 110.256C95.223 110.256 94.6583 110.485 94.201 110.942ZM104.893 106.7H105.943V116.5H105.327L104.977 115.702C104.118 116.309 103.372 116.612 102.737 116.612C101.057 116.612 100.217 115.403 100.217 112.986C100.217 111.614 100.516 110.657 101.113 110.116C101.645 109.621 102.247 109.374 102.919 109.374C103.591 109.374 104.249 109.603 104.893 110.06V106.7ZM104.893 114.764V111.124C104.697 110.891 104.436 110.69 104.109 110.522C103.792 110.354 103.498 110.27 103.227 110.27C102.499 110.27 101.99 110.485 101.701 110.914C101.412 111.343 101.267 112.015 101.267 112.93C101.267 113.845 101.412 114.535 101.701 115.002C101.99 115.469 102.359 115.702 102.807 115.702C103.479 115.702 104.174 115.389 104.893 114.764ZM109.541 119.832H108.491V109.514H109.107L109.471 110.298C109.863 109.999 110.227 109.771 110.563 109.612C110.908 109.444 111.286 109.36 111.697 109.36C113.377 109.36 114.217 110.569 114.217 112.986C114.217 114.358 113.918 115.315 113.321 115.856C112.789 116.351 112.182 116.598 111.501 116.598C110.829 116.598 110.175 116.374 109.541 115.926V119.832ZM109.541 111.236V114.974C109.727 115.198 109.979 115.375 110.297 115.506C110.614 115.637 110.917 115.702 111.207 115.702C111.935 115.702 112.443 115.487 112.733 115.058C113.022 114.629 113.167 113.957 113.167 113.042C113.167 112.127 113.022 111.437 112.733 110.97C112.443 110.503 112.075 110.27 111.627 110.27C111.328 110.27 111.029 110.331 110.731 110.452C110.441 110.573 110.222 110.69 110.073 110.802C109.933 110.905 109.755 111.049 109.541 111.236ZM120.459 113.056C120.459 112.151 120.282 111.46 119.927 110.984C119.573 110.508 119.055 110.27 118.373 110.27C117.692 110.27 117.207 110.499 116.917 110.956C116.637 111.404 116.497 112.095 116.497 113.028C116.497 114.792 117.146 115.674 118.443 115.674C119.125 115.674 119.629 115.464 119.955 115.044C120.291 114.615 120.459 113.952 120.459 113.056ZM120.711 115.632C120.179 116.267 119.428 116.584 118.457 116.584C117.487 116.584 116.74 116.271 116.217 115.646C115.704 115.011 115.447 114.129 115.447 113C115.447 111.861 115.695 110.97 116.189 110.326C116.693 109.682 117.426 109.36 118.387 109.36C119.358 109.36 120.119 109.687 120.669 110.34C121.229 110.993 121.509 111.88 121.509 113C121.509 114.12 121.243 114.997 120.711 115.632ZM123.183 116.5V109.5H124.233V116.5H123.183ZM124.233 106.7V107.946H123.183V106.7H124.233ZM127.615 110.942V116.5H126.565V109.5H127.237L127.405 110.186C127.62 110.018 127.792 109.887 127.923 109.794C128.063 109.701 128.282 109.607 128.581 109.514C128.88 109.411 129.197 109.36 129.533 109.36C130.177 109.36 130.709 109.561 131.129 109.962C131.558 110.354 131.773 110.914 131.773 111.642V116.5H130.723V111.95C130.723 110.821 130.252 110.256 129.309 110.256C128.637 110.256 128.072 110.485 127.615 110.942ZM134.485 114.988V110.34H133.533V109.5H134.499V107.498H135.549V109.5H137.257V110.34H135.535V114.792C135.535 115.417 135.852 115.73 136.487 115.73C136.636 115.73 136.865 115.702 137.173 115.646L137.327 116.402C136.944 116.523 136.548 116.584 136.137 116.584C135.736 116.584 135.358 116.463 135.003 116.22C134.658 115.968 134.485 115.557 134.485 114.988ZM138.891 115.254C139.497 115.534 140.076 115.674 140.627 115.674C141.177 115.674 141.593 115.567 141.873 115.352C142.162 115.128 142.307 114.834 142.307 114.47C142.307 114.106 142.185 113.826 141.943 113.63C141.7 113.425 141.401 113.266 141.047 113.154C140.701 113.042 140.351 112.921 139.997 112.79C139.651 112.659 139.357 112.463 139.115 112.202C138.872 111.941 138.751 111.609 138.751 111.208C138.751 110.62 138.942 110.167 139.325 109.85C139.707 109.523 140.225 109.36 140.879 109.36C141.532 109.36 142.139 109.458 142.699 109.654L142.797 109.696L142.615 110.592C142.055 110.377 141.532 110.27 141.047 110.27C140.571 110.27 140.244 110.345 140.067 110.494C139.889 110.643 139.801 110.895 139.801 111.25C139.801 111.474 139.922 111.665 140.165 111.824C140.407 111.983 140.701 112.123 141.047 112.244C141.401 112.356 141.751 112.491 142.097 112.65C142.451 112.799 142.75 113.028 142.993 113.336C143.235 113.644 143.357 114.022 143.357 114.47C143.357 115.123 143.128 115.641 142.671 116.024C142.213 116.397 141.583 116.584 140.781 116.584C139.978 116.584 139.264 116.402 138.639 116.038L138.891 115.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="20.5"
                    y="90"
                    width="146"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_2">
                  <g id="Container_2">
                    <g id="Icon_2">
                      <path
                        id="Vector_2"
                        d="M44.25 159.214V160.286C44.25 161.23 41.8984 162 39 162C36.1016 162 33.75 161.23 33.75 160.286V159.214C33.75 158.27 36.1016 157.5 39 157.5C41.8984 157.5 44.25 158.27 44.25 159.214ZM44.25 161.625V164.036C44.25 164.98 41.8984 165.75 39 165.75C36.1016 165.75 33.75 164.98 33.75 164.036V161.625C34.8779 162.402 36.9424 162.763 39 162.763C41.0576 162.763 43.122 162.402 44.25 161.625ZM44.25 165.375V167.786C44.25 168.73 41.8984 169.5 39 169.5C36.1016 169.5 33.75 168.73 33.75 167.786V165.375C34.8779 166.152 36.9424 166.513 39 166.513C41.0576 166.513 43.122 166.152 44.25 165.375Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_2"
                      d="M58.358 163.25C58.358 164.827 57.9007 166.097 56.986 167.058C56.0713 168.019 54.8487 168.5 53.318 168.5H51.274V158.7H53.752C55.1427 158.7 56.258 159.125 57.098 159.974C57.938 160.823 58.358 161.915 58.358 163.25ZM57.224 163.138C57.224 162.037 56.888 161.173 56.216 160.548C55.544 159.923 54.7413 159.61 53.808 159.61H52.408V167.59H53.444C54.4987 167.59 55.39 167.193 56.118 166.4C56.8553 165.607 57.224 164.519 57.224 163.138ZM63.3625 164.314H63.9365C63.9365 163.465 63.8291 162.914 63.6145 162.662C63.3998 162.401 62.9238 162.27 62.1865 162.27C61.4491 162.27 60.8238 162.368 60.3105 162.564L60.1145 161.752C60.8985 161.491 61.7105 161.36 62.5505 161.36C64.1931 161.36 65.0145 162.181 65.0145 163.824V168.5H64.3985L64.0345 167.674C63.6051 168.029 63.2318 168.271 62.9145 168.402C62.6065 168.523 62.2471 168.584 61.8365 168.584C61.1831 168.584 60.6745 168.393 60.3105 168.01C59.9465 167.618 59.7645 167.105 59.7645 166.47C59.7645 165.033 60.9638 164.314 63.3625 164.314ZM63.9505 165.196H63.3205C62.3685 165.196 61.7105 165.289 61.3465 165.476C60.9918 165.663 60.8145 165.957 60.8145 166.358C60.8145 166.75 60.9171 167.072 61.1225 167.324C61.3278 167.576 61.5938 167.702 61.9205 167.702C62.2565 167.702 62.5738 167.627 62.8725 167.478C63.1805 167.319 63.5398 167.049 63.9505 166.666V165.196ZM67.7252 166.988V162.34H66.7732V161.5H67.7392V159.498H68.7892V161.5H70.4972V162.34H68.7752V166.792C68.7752 167.417 69.0925 167.73 69.7272 167.73C69.8765 167.73 70.1052 167.702 70.4132 167.646L70.5672 168.402C70.1845 168.523 69.7879 168.584 69.3772 168.584C68.9759 168.584 68.5979 168.463 68.2432 168.22C67.8979 167.968 67.7252 167.557 67.7252 166.988ZM75.421 164.314H75.995C75.995 163.465 75.8877 162.914 75.673 162.662C75.4584 162.401 74.9824 162.27 74.245 162.27C73.5077 162.27 72.8824 162.368 72.369 162.564L72.173 161.752C72.957 161.491 73.769 161.36 74.609 161.36C76.2517 161.36 77.073 162.181 77.073 163.824V168.5H76.457L76.093 167.674C75.6637 168.029 75.2904 168.271 74.973 168.402C74.665 168.523 74.3057 168.584 73.895 168.584C73.2417 168.584 72.733 168.393 72.369 168.01C72.005 167.618 71.823 167.105 71.823 166.47C71.823 165.033 73.0224 164.314 75.421 164.314ZM76.009 165.196H75.379C74.427 165.196 73.769 165.289 73.405 165.476C73.0504 165.663 72.873 165.957 72.873 166.358C72.873 166.75 72.9757 167.072 73.181 167.324C73.3864 167.576 73.6524 167.702 73.979 167.702C74.315 167.702 74.6324 167.627 74.931 167.478C75.239 167.319 75.5984 167.049 76.009 166.666V165.196ZM79.6158 158.7H80.6658V162.2C81.4685 161.631 82.1871 161.346 82.8218 161.346C84.5018 161.346 85.3418 162.555 85.3418 164.972C85.3418 166.344 85.0431 167.305 84.4458 167.856C83.9138 168.341 83.2885 168.584 82.5698 168.584C82.2058 168.584 81.8371 168.505 81.4638 168.346C81.0905 168.178 80.7825 168.001 80.5398 167.814L80.2318 168.5H79.6158V158.7ZM80.6658 163.194V167.002C80.8525 167.217 81.0998 167.385 81.4078 167.506C81.7251 167.627 82.0331 167.688 82.3318 167.688C83.0598 167.688 83.5685 167.473 83.8578 167.044C84.1471 166.615 84.2918 165.943 84.2918 165.028C84.2918 164.113 84.1471 163.423 83.8578 162.956C83.5685 162.489 83.1998 162.256 82.7518 162.256C82.0798 162.256 81.3845 162.569 80.6658 163.194ZM90.2824 164.314H90.8564C90.8564 163.465 90.749 162.914 90.5344 162.662C90.3197 162.401 89.8437 162.27 89.1064 162.27C88.369 162.27 87.7437 162.368 87.2304 162.564L87.0344 161.752C87.8184 161.491 88.6304 161.36 89.4704 161.36C91.113 161.36 91.9344 162.181 91.9344 163.824V168.5H91.3184L90.9544 167.674C90.525 168.029 90.1517 168.271 89.8344 168.402C89.5264 168.523 89.167 168.584 88.7564 168.584C88.103 168.584 87.5944 168.393 87.2304 168.01C86.8664 167.618 86.6844 167.105 86.6844 166.47C86.6844 165.033 87.8837 164.314 90.2824 164.314ZM90.8704 165.196H90.2404C89.2884 165.196 88.6304 165.289 88.2664 165.476C87.9117 165.663 87.7344 165.957 87.7344 166.358C87.7344 166.75 87.837 167.072 88.0424 167.324C88.2477 167.576 88.5137 167.702 88.8404 167.702C89.1764 167.702 89.4937 167.627 89.7924 167.478C90.1004 167.319 90.4597 167.049 90.8704 166.666V165.196ZM94.2111 167.254C94.8178 167.534 95.3965 167.674 95.9471 167.674C96.4978 167.674 96.9131 167.567 97.1931 167.352C97.4825 167.128 97.6271 166.834 97.6271 166.47C97.6271 166.106 97.5058 165.826 97.2631 165.63C97.0205 165.425 96.7218 165.266 96.3671 165.154C96.0218 165.042 95.6718 164.921 95.3171 164.79C94.9718 164.659 94.6778 164.463 94.4351 164.202C94.1925 163.941 94.0711 163.609 94.0711 163.208C94.0711 162.62 94.2625 162.167 94.6451 161.85C95.0278 161.523 95.5458 161.36 96.1991 161.36C96.8525 161.36 97.4591 161.458 98.0191 161.654L98.1171 161.696L97.9351 162.592C97.3751 162.377 96.8525 162.27 96.3671 162.27C95.8911 162.27 95.5645 162.345 95.3871 162.494C95.2098 162.643 95.1211 162.895 95.1211 163.25C95.1211 163.474 95.2425 163.665 95.4851 163.824C95.7278 163.983 96.0218 164.123 96.3671 164.244C96.7218 164.356 97.0718 164.491 97.4171 164.65C97.7718 164.799 98.0705 165.028 98.3131 165.336C98.5558 165.644 98.6771 166.022 98.6771 166.47C98.6771 167.123 98.4485 167.641 97.9911 168.024C97.5338 168.397 96.9038 168.584 96.1011 168.584C95.2985 168.584 94.5845 168.402 93.9591 168.038L94.2111 167.254ZM105.433 165.224H100.967C100.967 166.12 101.177 166.755 101.597 167.128C102.026 167.501 102.563 167.688 103.207 167.688C103.533 167.688 103.762 167.674 103.893 167.646C104.023 167.609 104.145 167.576 104.257 167.548C104.378 167.511 104.462 167.483 104.509 167.464C104.742 167.399 104.943 167.338 105.111 167.282L105.279 168.094C104.345 168.421 103.617 168.584 103.095 168.584C102.133 168.584 101.363 168.295 100.785 167.716C100.206 167.128 99.9168 166.251 99.9168 165.084C99.9168 163.908 100.187 162.993 100.729 162.34C101.279 161.687 101.97 161.36 102.801 161.36C103.641 161.36 104.294 161.631 104.761 162.172C105.227 162.713 105.461 163.446 105.461 164.37C105.461 164.622 105.451 164.907 105.433 165.224ZM101.037 164.426H104.453C104.453 163.735 104.331 163.203 104.089 162.83C103.846 162.457 103.421 162.27 102.815 162.27C102.217 162.27 101.779 162.471 101.499 162.872C101.219 163.273 101.065 163.791 101.037 164.426Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="20.5"
                    y="142"
                    width="146"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_3">
                  <g id="Container_3">
                    <g id="Icon_3">
                      <path
                        id="Vector_3"
                        d="M42 210.25C42 210.051 41.921 209.86 41.7803 209.72C41.6397 209.579 41.4489 209.5 41.25 209.5C41.0511 209.5 40.8603 209.579 40.7197 209.72C40.579 209.86 40.5 210.051 40.5 210.25V212.5H42V210.25ZM43.125 213.25H34.875C34.7755 213.25 34.6802 213.29 34.6098 213.36C34.5395 213.43 34.5 213.526 34.5 213.625V214.375C34.5 214.474 34.5395 214.57 34.6098 214.64C34.6802 214.71 34.7755 214.75 34.875 214.75H35.25V215.5C35.2501 216.364 35.5488 217.202 36.0954 217.872C36.642 218.541 37.4031 219.002 38.25 219.175V221.5H39.75V219.175C40.5969 219.002 41.358 218.541 41.9046 217.872C42.4512 217.202 42.7499 216.364 42.75 215.5V214.75H43.125C43.2245 214.75 43.3198 214.71 43.3902 214.64C43.4605 214.57 43.5 214.474 43.5 214.375V213.625C43.5 213.526 43.4605 213.43 43.3902 213.36C43.3198 213.29 43.2245 213.25 43.125 213.25ZM37.5 210.25C37.5 210.051 37.421 209.86 37.2803 209.72C37.1397 209.579 36.9489 209.5 36.75 209.5C36.5511 209.5 36.3603 209.579 36.2197 209.72C36.079 209.86 36 210.051 36 210.25V212.5H37.5V210.25Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_3"
                      d="M55.068 220.584C53.7147 220.584 52.6367 220.127 51.834 219.212C51.0407 218.297 50.644 217.079 50.644 215.558C50.644 214.027 51.022 212.814 51.778 211.918C52.534 211.013 53.5887 210.56 54.942 210.56C55.8007 210.56 56.6733 210.728 57.56 211.064L57.308 211.932C56.9907 211.801 56.5753 211.694 56.062 211.61C55.5487 211.517 55.152 211.47 54.872 211.47C53.892 211.47 53.1173 211.829 52.548 212.548C51.9787 213.267 51.694 214.237 51.694 215.46C51.694 216.683 51.9927 217.691 52.59 218.484C53.1967 219.277 53.9713 219.674 54.914 219.674C55.5767 219.674 56.202 219.581 56.79 219.394V216.44H54.746V215.53H57.84V219.828C56.9627 220.332 56.0387 220.584 55.068 220.584ZM61.3748 215.152V220.5H60.3248V213.5H60.9968L61.1648 214.326C61.6128 213.971 61.9861 213.724 62.2848 213.584C62.5834 213.435 62.9241 213.36 63.3068 213.36C63.4934 213.36 63.6334 213.369 63.7268 213.388L63.9228 213.444L63.7548 214.41C63.5868 214.354 63.3581 214.326 63.0688 214.326C62.5088 214.326 61.9441 214.601 61.3748 215.152ZM68.5441 216.314H69.1181C69.1181 215.465 69.0108 214.914 68.7961 214.662C68.5814 214.401 68.1054 214.27 67.3681 214.27C66.6308 214.27 66.0054 214.368 65.4921 214.564L65.2961 213.752C66.0801 213.491 66.8921 213.36 67.7321 213.36C69.3748 213.36 70.1961 214.181 70.1961 215.824V220.5H69.5801L69.2161 219.674C68.7868 220.029 68.4134 220.271 68.0961 220.402C67.7881 220.523 67.4288 220.584 67.0181 220.584C66.3648 220.584 65.8561 220.393 65.4921 220.01C65.1281 219.618 64.9461 219.105 64.9461 218.47C64.9461 217.033 66.1454 216.314 68.5441 216.314ZM69.1321 217.196H68.5021C67.5501 217.196 66.8921 217.289 66.5281 217.476C66.1734 217.663 65.9961 217.957 65.9961 218.358C65.9961 218.75 66.0988 219.072 66.3041 219.324C66.5094 219.576 66.7754 219.702 67.1021 219.702C67.4381 219.702 67.7554 219.627 68.0541 219.478C68.3621 219.319 68.7214 219.049 69.1321 218.666V217.196ZM73.7888 223.832H72.7388V213.514H73.3548L73.7188 214.298C74.1108 213.999 74.4748 213.771 74.8108 213.612C75.1562 213.444 75.5342 213.36 75.9448 213.36C77.6248 213.36 78.4648 214.569 78.4648 216.986C78.4648 218.358 78.1662 219.315 77.5688 219.856C77.0368 220.351 76.4302 220.598 75.7488 220.598C75.0768 220.598 74.4235 220.374 73.7888 219.926V223.832ZM73.7888 215.236V218.974C73.9755 219.198 74.2275 219.375 74.5448 219.506C74.8622 219.637 75.1655 219.702 75.4548 219.702C76.1828 219.702 76.6915 219.487 76.9808 219.058C77.2702 218.629 77.4148 217.957 77.4148 217.042C77.4148 216.127 77.2702 215.437 76.9808 214.97C76.6915 214.503 76.3228 214.27 75.8748 214.27C75.5762 214.27 75.2775 214.331 74.9788 214.452C74.6895 214.573 74.4702 214.69 74.3208 214.802C74.1808 214.905 74.0035 215.049 73.7888 215.236ZM85.6174 220.5H84.5674V215.894C84.5674 214.765 84.0961 214.2 83.1534 214.2C82.4534 214.2 81.8794 214.424 81.4314 214.872V220.5H80.3814V210.7H81.4174V214.018C81.6228 213.85 81.7814 213.729 81.8934 213.654C82.0148 213.579 82.2061 213.505 82.4674 213.43C82.7381 213.355 83.0414 213.318 83.3774 213.318C84.0214 213.318 84.5534 213.514 84.9734 213.906C85.4028 214.298 85.6174 214.858 85.6174 215.586V220.5ZM94.3487 219.156L95.7207 220.57L95.0347 221.256L93.7047 219.842C93.0794 220.346 92.3234 220.598 91.4367 220.598C90.5594 220.598 89.8221 220.36 89.2247 219.884C88.0954 218.997 87.5307 217.546 87.5307 215.53C87.5307 214.065 87.8574 212.87 88.5107 211.946C89.1734 211.022 90.1394 210.56 91.4087 210.56C92.6874 210.56 93.6581 211.022 94.3207 211.946C94.9834 212.87 95.3147 214.079 95.3147 215.572C95.3147 217.065 94.9927 218.26 94.3487 219.156ZM92.4727 217.168L93.6207 218.414C94.0501 217.705 94.2647 216.767 94.2647 215.6C94.2647 214.424 94.0127 213.439 93.5087 212.646C93.0141 211.853 92.3187 211.456 91.4227 211.456C90.9281 211.456 90.4894 211.573 90.1067 211.806C89.7334 212.039 89.4394 212.352 89.2247 212.744C88.8047 213.528 88.5947 214.485 88.5947 215.614C88.5947 216.734 88.8327 217.691 89.3087 218.484C89.7941 219.277 90.4987 219.674 91.4227 219.674C92.0387 219.674 92.5661 219.497 93.0047 219.142L91.7727 217.854L92.4727 217.168ZM102.53 220.5H97.2799V210.7H98.3299V219.59H102.53V220.5ZM112.325 211.05L112.101 211.988L111.289 211.75C110.71 211.61 110.211 211.54 109.791 211.54C108.69 211.54 108.139 212.03 108.139 213.01C108.139 213.439 108.307 213.794 108.643 214.074C108.979 214.345 109.385 214.564 109.861 214.732C110.346 214.891 110.827 215.068 111.303 215.264C111.788 215.451 112.199 215.745 112.535 216.146C112.871 216.538 113.039 217.037 113.039 217.644C113.039 218.568 112.754 219.291 112.185 219.814C111.616 220.327 110.808 220.584 109.763 220.584C109.24 220.584 108.713 220.509 108.181 220.36C107.658 220.201 107.229 220.019 106.893 219.814L107.243 219.016C108.092 219.408 108.895 219.604 109.651 219.604C110.416 219.604 110.995 219.45 111.387 219.142C111.788 218.834 111.989 218.386 111.989 217.798C111.989 217.201 111.667 216.734 111.023 216.398C110.734 216.249 110.412 216.109 110.057 215.978C109.712 215.847 109.362 215.707 109.007 215.558C108.662 215.399 108.344 215.222 108.055 215.026C107.775 214.83 107.542 214.564 107.355 214.228C107.178 213.892 107.089 213.5 107.089 213.052C107.089 212.249 107.327 211.633 107.803 211.204C108.288 210.775 108.937 210.56 109.749 210.56C110.561 210.56 111.42 210.723 112.325 211.05ZM119.966 217.224H115.5C115.5 218.12 115.71 218.755 116.13 219.128C116.559 219.501 117.096 219.688 117.74 219.688C118.067 219.688 118.295 219.674 118.426 219.646C118.557 219.609 118.678 219.576 118.79 219.548C118.911 219.511 118.995 219.483 119.042 219.464C119.275 219.399 119.476 219.338 119.644 219.282L119.812 220.094C118.879 220.421 118.151 220.584 117.628 220.584C116.667 220.584 115.897 220.295 115.318 219.716C114.739 219.128 114.45 218.251 114.45 217.084C114.45 215.908 114.721 214.993 115.262 214.34C115.813 213.687 116.503 213.36 117.334 213.36C118.174 213.36 118.827 213.631 119.294 214.172C119.761 214.713 119.994 215.446 119.994 216.37C119.994 216.622 119.985 216.907 119.966 217.224ZM115.57 216.426H118.986C118.986 215.735 118.865 215.203 118.622 214.83C118.379 214.457 117.955 214.27 117.348 214.27C116.751 214.27 116.312 214.471 116.032 214.872C115.752 215.273 115.598 215.791 115.57 216.426ZM123.008 215.152V220.5H121.958V213.5H122.63L122.798 214.326C123.246 213.971 123.619 213.724 123.918 213.584C124.216 213.435 124.557 213.36 124.94 213.36C125.126 213.36 125.266 213.369 125.36 213.388L125.556 213.444L125.388 214.41C125.22 214.354 124.991 214.326 124.702 214.326C124.142 214.326 123.577 214.601 123.008 215.152ZM131.955 213.486L129.589 220.5H128.385L126.033 213.486H127.223L129.001 219.38L130.793 213.486H131.955ZM133.191 220.5V213.5H134.241V220.5H133.191ZM134.241 210.7V211.946H133.191V210.7H134.241ZM140.689 219.408L140.899 220.234C140.152 220.458 139.494 220.57 138.925 220.57C137.926 220.57 137.175 220.243 136.671 219.59C136.167 218.937 135.915 218.036 135.915 216.888C135.915 215.74 136.176 214.867 136.699 214.27C137.221 213.663 137.991 213.36 139.009 213.36C139.447 213.36 140.063 213.472 140.857 213.696L140.437 214.508C139.923 214.359 139.461 214.284 139.051 214.284C138.341 214.284 137.828 214.494 137.511 214.914C137.203 215.334 137.049 215.997 137.049 216.902C137.049 218.741 137.707 219.66 139.023 219.66C139.545 219.66 140.101 219.576 140.689 219.408ZM147.487 217.224H143.021C143.021 218.12 143.231 218.755 143.651 219.128C144.081 219.501 144.617 219.688 145.261 219.688C145.588 219.688 145.817 219.674 145.947 219.646C146.078 219.609 146.199 219.576 146.311 219.548C146.433 219.511 146.517 219.483 146.563 219.464C146.797 219.399 146.997 219.338 147.165 219.282L147.333 220.094C146.4 220.421 145.672 220.584 145.149 220.584C144.188 220.584 143.418 220.295 142.839 219.716C142.261 219.128 141.971 218.251 141.971 217.084C141.971 215.908 142.242 214.993 142.783 214.34C143.334 213.687 144.025 213.36 144.855 213.36C145.695 213.36 146.349 213.631 146.815 214.172C147.282 214.713 147.515 215.446 147.515 216.37C147.515 216.622 147.506 216.907 147.487 217.224ZM143.091 216.426H146.507C146.507 215.735 146.386 215.203 146.143 214.83C145.901 214.457 145.476 214.27 144.869 214.27C144.272 214.27 143.833 214.471 143.553 214.872C143.273 215.273 143.119 215.791 143.091 216.426ZM149.213 219.254C149.82 219.534 150.398 219.674 150.949 219.674C151.5 219.674 151.915 219.567 152.195 219.352C152.484 219.128 152.629 218.834 152.629 218.47C152.629 218.106 152.508 217.826 152.265 217.63C152.022 217.425 151.724 217.266 151.369 217.154C151.024 217.042 150.674 216.921 150.319 216.79C149.974 216.659 149.68 216.463 149.437 216.202C149.194 215.941 149.073 215.609 149.073 215.208C149.073 214.62 149.264 214.167 149.647 213.85C150.03 213.523 150.548 213.36 151.201 213.36C151.854 213.36 152.461 213.458 153.021 213.654L153.119 213.696L152.937 214.592C152.377 214.377 151.854 214.27 151.369 214.27C150.893 214.27 150.566 214.345 150.389 214.494C150.212 214.643 150.123 214.895 150.123 215.25C150.123 215.474 150.244 215.665 150.487 215.824C150.73 215.983 151.024 216.123 151.369 216.244C151.724 216.356 152.074 216.491 152.419 216.65C152.774 216.799 153.072 217.028 153.315 217.336C153.558 217.644 153.679 218.022 153.679 218.47C153.679 219.123 153.45 219.641 152.993 220.024C152.536 220.397 151.906 220.584 151.103 220.584C150.3 220.584 149.586 220.402 148.961 220.038L149.213 219.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="20.5"
                    y="194"
                    width="146"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
              </g>
              <g id="SchemaGrouper">
                <g id="Borders">
                  <mask id="path-12-inside-1_264_17165" fill="white">
                    <path d="M179 65.5H195V237.5H179V65.5Z" />
                  </mask>
                  <path
                    d="M195 65.5H196V64.5H195V65.5ZM195 237.5V238.5H196V237.5H195ZM179 66.5H195V64.5H179V66.5ZM194 65.5V237.5H196V65.5H194ZM195 236.5H179V238.5H195V236.5Z"
                    fill="#94A3B8"
                    mask="url(#path-12-inside-1_264_17165)"
                  />
                </g>
              </g>
            </g>
            <g id="SchemaArrowWithLabel">
              <g id="Horizontal">
                <g id="Arrow left">
                  <g id="SchemaArrow">
                    <rect
                      id="Line"
                      x="195"
                      y="169"
                      width="15"
                      height="1"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
                <g id="SchemaArrowLabel">
                  <g id="Icon_4">
                    <path
                      id="Vector_4"
                      d="M225.655 167.845C227.055 169.247 227.036 171.494 225.663 172.875C225.661 172.877 225.658 172.88 225.655 172.883L224.08 174.458C222.691 175.847 220.431 175.847 219.042 174.458C217.653 173.069 217.653 170.809 219.042 169.42L219.912 168.55C220.142 168.32 220.539 168.473 220.551 168.799C220.566 169.214 220.641 169.632 220.778 170.035C220.825 170.171 220.792 170.322 220.69 170.424L220.383 170.731C219.726 171.388 219.705 172.457 220.356 173.12C221.013 173.79 222.092 173.794 222.754 173.132L224.329 171.558C224.99 170.897 224.987 169.829 224.329 169.171C224.242 169.084 224.155 169.017 224.087 168.97C224.038 168.937 223.999 168.893 223.97 168.842C223.942 168.79 223.926 168.733 223.924 168.675C223.915 168.427 224.002 168.172 224.198 167.976L224.692 167.483C224.821 167.353 225.024 167.337 225.174 167.442C225.346 167.562 225.507 167.697 225.655 167.845ZM228.958 164.542C227.569 163.153 225.309 163.153 223.92 164.542L222.345 166.117C222.342 166.12 222.339 166.123 222.337 166.125C220.964 167.506 220.945 169.753 222.345 171.155C222.493 171.303 222.654 171.438 222.826 171.558C222.976 171.663 223.179 171.647 223.308 171.517L223.802 171.024C223.998 170.828 224.085 170.573 224.076 170.325C224.074 170.267 224.058 170.21 224.03 170.158C224.001 170.107 223.962 170.063 223.913 170.03C223.845 169.983 223.758 169.916 223.671 169.829C223.013 169.171 223.01 168.103 223.671 167.442L225.246 165.868C225.908 165.206 226.987 165.21 227.644 165.88C228.294 166.543 228.274 167.612 227.617 168.269L227.31 168.576C227.208 168.678 227.175 168.829 227.222 168.965C227.359 169.368 227.434 169.786 227.449 170.201C227.461 170.527 227.858 170.68 228.088 170.45L228.958 169.58C230.347 168.191 230.347 165.931 228.958 164.542Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_4"
                    d="M238.152 173.572C237.008 173.572 236.128 173.188 235.512 172.42C234.904 171.644 234.6 170.596 234.6 169.276C234.6 167.956 234.924 166.912 235.572 166.144C236.22 165.376 237.124 164.992 238.284 164.992C238.924 164.992 239.552 165.108 240.168 165.34L239.952 166.084C239.464 165.876 238.888 165.772 238.224 165.772C237.384 165.772 236.72 166.08 236.232 166.696C235.744 167.304 235.5 168.144 235.5 169.216C235.5 170.28 235.728 171.144 236.184 171.808C236.648 172.464 237.292 172.792 238.116 172.792C238.66 172.792 239.344 172.636 240.168 172.324L240.408 172.948C239.72 173.364 238.968 173.572 238.152 173.572ZM245.808 170.548C245.808 169.772 245.656 169.18 245.352 168.772C245.048 168.364 244.604 168.16 244.02 168.16C243.436 168.16 243.02 168.356 242.772 168.748C242.532 169.132 242.412 169.724 242.412 170.524C242.412 172.036 242.968 172.792 244.08 172.792C244.664 172.792 245.096 172.612 245.376 172.252C245.664 171.884 245.808 171.316 245.808 170.548ZM246.024 172.756C245.568 173.3 244.924 173.572 244.092 173.572C243.26 173.572 242.62 173.304 242.172 172.768C241.732 172.224 241.512 171.468 241.512 170.5C241.512 169.524 241.724 168.76 242.148 168.208C242.58 167.656 243.208 167.38 244.032 167.38C244.864 167.38 245.516 167.66 245.988 168.22C246.468 168.78 246.708 169.54 246.708 170.5C246.708 171.46 246.48 172.212 246.024 172.756ZM249.211 168.736V173.5H248.311V167.5H248.887L249.031 168.088C249.215 167.944 249.363 167.832 249.475 167.752C249.595 167.672 249.783 167.592 250.039 167.512C250.295 167.424 250.567 167.38 250.855 167.38C251.407 167.38 251.863 167.552 252.223 167.896C252.591 168.232 252.775 168.712 252.775 169.336V173.5H251.875V169.6C251.875 168.632 251.471 168.148 250.663 168.148C250.087 168.148 249.603 168.344 249.211 168.736ZM255.855 168.736V173.5H254.955V167.5H255.531L255.675 168.088C255.859 167.944 256.007 167.832 256.119 167.752C256.239 167.672 256.427 167.592 256.683 167.512C256.939 167.424 257.211 167.38 257.499 167.38C258.051 167.38 258.507 167.552 258.867 167.896C259.235 168.232 259.419 168.712 259.419 169.336V173.5H258.519V169.6C258.519 168.632 258.115 168.148 257.307 168.148C256.731 168.148 256.247 168.344 255.855 168.736ZM265.764 170.692H261.936C261.936 171.46 262.116 172.004 262.476 172.324C262.844 172.644 263.304 172.804 263.856 172.804C264.136 172.804 264.332 172.792 264.444 172.768C264.556 172.736 264.66 172.708 264.756 172.684C264.86 172.652 264.932 172.628 264.972 172.612C265.172 172.556 265.344 172.504 265.488 172.456L265.632 173.152C264.832 173.432 264.208 173.572 263.76 173.572C262.936 173.572 262.276 173.324 261.78 172.828C261.284 172.324 261.036 171.572 261.036 170.572C261.036 169.564 261.268 168.78 261.732 168.22C262.204 167.66 262.796 167.38 263.508 167.38C264.228 167.38 264.788 167.612 265.188 168.076C265.588 168.54 265.788 169.168 265.788 169.96C265.788 170.176 265.78 170.42 265.764 170.692ZM261.996 170.008H264.924C264.924 169.416 264.82 168.96 264.612 168.64C264.404 168.32 264.04 168.16 263.52 168.16C263.008 168.16 262.632 168.332 262.392 168.676C262.152 169.02 262.02 169.464 261.996 170.008ZM270.999 172.564L271.179 173.272C270.539 173.464 269.975 173.56 269.487 173.56C268.631 173.56 267.987 173.28 267.555 172.72C267.123 172.16 266.907 171.388 266.907 170.404C266.907 169.42 267.131 168.672 267.579 168.16C268.027 167.64 268.687 167.38 269.559 167.38C269.935 167.38 270.463 167.476 271.143 167.668L270.783 168.364C270.343 168.236 269.947 168.172 269.595 168.172C268.987 168.172 268.547 168.352 268.275 168.712C268.011 169.072 267.879 169.64 267.879 170.416C267.879 171.992 268.443 172.78 269.571 172.78C270.019 172.78 270.495 172.708 270.999 172.564ZM272.806 172.204V168.22H271.99V167.5H272.818V165.784H273.718V167.5H275.182V168.22H273.706V172.036C273.706 172.572 273.978 172.84 274.522 172.84C274.65 172.84 274.846 172.816 275.11 172.768L275.242 173.416C274.914 173.52 274.574 173.572 274.222 173.572C273.878 173.572 273.554 173.468 273.25 173.26C272.954 173.044 272.806 172.692 272.806 172.204ZM280.975 170.692H277.147C277.147 171.46 277.327 172.004 277.687 172.324C278.055 172.644 278.515 172.804 279.067 172.804C279.347 172.804 279.543 172.792 279.655 172.768C279.767 172.736 279.871 172.708 279.967 172.684C280.071 172.652 280.143 172.628 280.183 172.612C280.383 172.556 280.555 172.504 280.699 172.456L280.843 173.152C280.043 173.432 279.419 173.572 278.971 173.572C278.147 173.572 277.487 173.324 276.991 172.828C276.495 172.324 276.247 171.572 276.247 170.572C276.247 169.564 276.479 168.78 276.943 168.22C277.415 167.66 278.007 167.38 278.719 167.38C279.439 167.38 279.999 167.612 280.399 168.076C280.799 168.54 280.999 169.168 280.999 169.96C280.999 170.176 280.991 170.42 280.975 170.692ZM277.207 170.008H280.135C280.135 169.416 280.031 168.96 279.823 168.64C279.615 168.32 279.251 168.16 278.731 168.16C278.219 168.16 277.843 168.332 277.603 168.676C277.363 169.02 277.231 169.464 277.207 170.008ZM286.102 165.1H287.002V173.5H286.474L286.174 172.816C285.438 173.336 284.798 173.596 284.254 173.596C282.814 173.596 282.094 172.56 282.094 170.488C282.094 169.312 282.35 168.492 282.862 168.028C283.318 167.604 283.834 167.392 284.41 167.392C284.986 167.392 285.55 167.588 286.102 167.98V165.1ZM286.102 172.012V168.892C285.934 168.692 285.71 168.52 285.43 168.376C285.158 168.232 284.906 168.16 284.674 168.16C284.05 168.16 283.614 168.344 283.366 168.712C283.118 169.08 282.994 169.656 282.994 170.44C282.994 171.224 283.118 171.816 283.366 172.216C283.614 172.616 283.93 172.816 284.314 172.816C284.89 172.816 285.486 172.548 286.102 172.012Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="Arrow right">
                  <g id="SchemaArrow_2">
                    <rect
                      id="Line_2"
                      x="297"
                      y="169"
                      width="10.5"
                      height="1"
                      fill="#94A3B8"
                    />
                    <path
                      id="Vector_5"
                      d="M307.92 174L307.5 173.69V165.295L307.905 165L312 169.22V169.841L307.92 174Z"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
          <g id="Col3">
            <g id="SchemaCard_4" filter="url(#filter0_d_264_17165)">
              <g clipPath="url(#clip0_264_17165)">
                <rect
                  x="312"
                  y="21.5"
                  width="200"
                  height="44"
                  rx="4"
                  fill="white"
                />
                <g id="Container_4">
                  <g id="Icon_5">
                    <path
                      id="Vector_6"
                      d="M331 37.5C327.686 37.5 325 40.1862 325 43.4999C325 46.8136 327.686 49.5 331 49.5C334.314 49.5 337 46.8136 337 43.4999C337 40.1862 334.314 37.5 331 37.5ZM331 48.7296C330.057 48.7296 329.293 48.0998 329.293 47.3231H332.707C332.707 48.0997 331.943 48.7296 331 48.7296ZM333.82 46.8573H328.18V45.8347H333.82V46.8573H333.82ZM333.799 45.3083H328.196C328.178 45.2869 328.158 45.2657 328.14 45.2439C327.563 44.5429 327.427 44.177 327.295 43.804C327.293 43.7918 327.995 43.9475 328.493 44.0595C328.493 44.0595 328.749 44.1188 329.124 44.1871C328.764 43.7655 328.551 43.2295 328.551 42.6817C328.551 41.4789 329.473 40.4279 329.14 39.5784C329.464 39.6048 329.811 40.262 329.834 41.2896C330.179 40.8138 330.323 39.9448 330.323 39.412C330.323 38.8603 330.686 38.2195 331.05 38.1976C330.726 38.7318 331.134 39.1897 331.496 40.3257C331.632 40.7525 331.615 41.4706 331.72 41.926C331.755 40.9801 331.918 39.6 332.518 39.1235C332.253 39.7236 332.557 40.4744 332.765 40.8354C333.1 41.4177 333.303 41.8589 333.303 42.6934C333.303 43.2529 333.097 43.7797 332.748 44.1915C333.144 44.1171 333.418 44.0501 333.418 44.0501L334.705 43.7991C334.705 43.799 334.518 44.5679 333.799 45.3083Z"
                      fill="#EA580C"
                    />
                  </g>
                  <path
                    id="Card label_5"
                    d="M345.752 44.734H345.024V48.5H342.994V38.7H346.074C347.222 38.7 348.053 38.9473 348.566 39.442C349.079 39.9273 349.336 40.6833 349.336 41.71C349.336 42.7273 349.019 43.488 348.384 43.992C347.759 44.4867 346.881 44.734 345.752 44.734ZM345.598 40.296H345.024V43.138H345.248C345.957 43.138 346.475 43.0307 346.802 42.816C347.138 42.6013 347.306 42.242 347.306 41.738C347.306 41.2247 347.171 40.856 346.9 40.632C346.629 40.408 346.195 40.296 345.598 40.296ZM352.542 43.852V48.5H350.708V41.5H352.164L352.332 42.186C352.706 41.8873 353.018 41.6773 353.27 41.556C353.522 41.4253 353.742 41.36 353.928 41.36C354.124 41.36 354.255 41.3647 354.32 41.374C354.386 41.374 354.442 41.3787 354.488 41.388C354.535 41.3973 354.614 41.416 354.726 41.444L354.558 43.11C354.39 43.054 354.162 43.026 353.872 43.026C353.48 43.026 353.037 43.3013 352.542 43.852ZM361.959 45.014C361.959 46.134 361.674 47.0113 361.105 47.646C360.536 48.2807 359.728 48.598 358.683 48.598C357.638 48.598 356.844 48.2807 356.303 47.646C355.762 47.0113 355.491 46.1293 355.491 45C355.491 43.8707 355.762 42.984 356.303 42.34C356.844 41.6867 357.624 41.36 358.641 41.36C359.658 41.36 360.466 41.6913 361.063 42.354C361.66 43.0073 361.959 43.894 361.959 45.014ZM360.097 44.986C360.097 43.558 359.64 42.844 358.725 42.844C357.792 42.844 357.325 43.5533 357.325 44.972C357.325 46.3907 357.796 47.1 358.739 47.1C359.243 47.1 359.593 46.9227 359.789 46.568C359.994 46.204 360.097 45.6767 360.097 44.986ZM365.394 48.5H363.56V41.5H365.1L365.338 42.13C365.739 41.8313 366.084 41.6307 366.374 41.528C366.672 41.416 367.018 41.36 367.41 41.36C368.119 41.36 368.637 41.682 368.964 42.326C369.486 41.9433 369.906 41.6867 370.224 41.556C370.55 41.4253 370.905 41.36 371.288 41.36C371.866 41.36 372.324 41.5747 372.66 42.004C372.996 42.424 373.164 43.0447 373.164 43.866V48.5H371.33V44.356C371.33 43.4973 371.073 43.068 370.56 43.068C370.177 43.068 369.738 43.2827 369.244 43.712V48.5H367.424V44.356C367.424 43.4973 367.172 43.068 366.668 43.068C366.294 43.068 365.87 43.2687 365.394 43.67V48.5ZM380.523 48.066C379.636 48.4113 378.815 48.584 378.059 48.584C375.866 48.584 374.769 47.3987 374.769 45.028C374.769 43.824 375.035 42.914 375.567 42.298C376.099 41.6727 376.874 41.36 377.891 41.36C378.731 41.36 379.403 41.6213 379.907 42.144C380.411 42.6667 380.663 43.4413 380.663 44.468C380.663 44.8787 380.644 45.238 380.607 45.546H376.561C376.561 46.0967 376.71 46.5027 377.009 46.764C377.308 47.0253 377.709 47.156 378.213 47.156C378.717 47.156 379.384 47.044 380.215 46.82L380.523 48.066ZM378.913 44.258V44.16C378.913 43.7307 378.82 43.3853 378.633 43.124C378.446 42.8627 378.152 42.732 377.751 42.732C377.35 42.732 377.051 42.8767 376.855 43.166C376.659 43.4553 376.556 43.8193 376.547 44.258H378.913ZM382.289 46.988V43.04H381.575V41.5H382.303V39.498H384.109V41.5H385.579V43.04H384.095V46.092C384.095 46.7173 384.286 47.03 384.669 47.03C384.883 47.03 385.112 47.002 385.355 46.946L385.649 48.402C385.219 48.5233 384.762 48.584 384.277 48.584C383.801 48.584 383.348 48.4627 382.919 48.22C382.499 47.968 382.289 47.5573 382.289 46.988ZM393.12 48.5H391.3V44.314C391.3 43.9313 391.226 43.6233 391.076 43.39C390.927 43.1473 390.675 43.026 390.32 43.026C389.966 43.026 389.532 43.2407 389.018 43.67V48.5H387.198V38.7H389.018V42.13C389.42 41.8313 389.765 41.6307 390.054 41.528C390.353 41.416 390.698 41.36 391.09 41.36C391.716 41.36 392.21 41.57 392.574 41.99C392.938 42.4007 393.12 43.012 393.12 43.824V48.5ZM400.484 48.066C399.597 48.4113 398.776 48.584 398.02 48.584C395.827 48.584 394.73 47.3987 394.73 45.028C394.73 43.824 394.996 42.914 395.528 42.298C396.06 41.6727 396.835 41.36 397.852 41.36C398.692 41.36 399.364 41.6213 399.868 42.144C400.372 42.6667 400.624 43.4413 400.624 44.468C400.624 44.8787 400.605 45.238 400.568 45.546H396.522C396.522 46.0967 396.671 46.5027 396.97 46.764C397.269 47.0253 397.67 47.156 398.174 47.156C398.678 47.156 399.345 47.044 400.176 46.82L400.484 48.066ZM398.874 44.258V44.16C398.874 43.7307 398.781 43.3853 398.594 43.124C398.407 42.8627 398.113 42.732 397.712 42.732C397.311 42.732 397.012 42.8767 396.816 43.166C396.62 43.4553 396.517 43.8193 396.508 44.258H398.874ZM402.18 41.5H404.028V45.784C404.028 46.1667 404.102 46.4793 404.252 46.722C404.401 46.9553 404.648 47.072 404.994 47.072C405.339 47.072 405.768 46.8573 406.282 46.428V41.5H408.116V48.5H406.576L406.282 47.828C405.88 48.1267 405.53 48.3273 405.232 48.43C404.942 48.5327 404.602 48.584 404.21 48.584C403.584 48.584 403.09 48.3787 402.726 47.968C402.362 47.5573 402.18 46.946 402.18 46.134V41.5ZM410.26 46.638C410.885 46.9553 411.525 47.114 412.178 47.114C412.841 47.114 413.172 46.8713 413.172 46.386C413.172 45.938 412.799 45.6067 412.052 45.392C411.735 45.308 411.417 45.21 411.1 45.098C410.792 44.9767 410.526 44.7853 410.302 44.524C410.087 44.2533 409.98 43.908 409.98 43.488C409.98 42.8067 410.19 42.284 410.61 41.92C411.03 41.5467 411.613 41.36 412.36 41.36C413.116 41.36 413.83 41.4907 414.502 41.752L414.208 43.208C413.592 42.956 412.99 42.83 412.402 42.83C411.991 42.83 411.786 42.97 411.786 43.25C411.786 43.5393 412.061 43.7587 412.612 43.908C413.191 44.0573 413.704 44.272 414.152 44.552C414.385 44.692 414.581 44.902 414.74 45.182C414.899 45.462 414.978 45.798 414.978 46.19C414.978 46.9273 414.731 47.5107 414.236 47.94C413.741 48.3693 413.06 48.584 412.192 48.584C411.324 48.584 410.549 48.3833 409.868 47.982L410.26 46.638Z"
                    fill="#0F172A"
                  />
                </g>
              </g>
              <rect
                x="312.5"
                y="22"
                width="199"
                height="43"
                rx="3.5"
                stroke="#FBBF24"
              />
            </g>
            <g id="SchemaArrowWithLabel_2">
              <g id="Arrow top">
                <g id="SchemaArrow_3">
                  <path
                    id="Vector_7"
                    d="M416.5 69.58L416.19 70H407.795L407.5 69.595L411.72 65.5H412.341L416.5 69.58Z"
                    fill="#94A3B8"
                  />
                  <rect
                    id="Line_3"
                    x="412.5"
                    y="70"
                    width="19.5"
                    height="1"
                    transform="rotate(90 412.5 70)"
                    fill="#94A3B8"
                  />
                </g>
              </g>
              <g id="Horizontal_2">
                <g id="SchemaArrowLabel_2">
                  <g id="Icon_6">
                    <path
                      id="Vector_8"
                      d="M376.75 102.688V99.5H372.062C371.751 99.5 371.5 99.7508 371.5 100.062V110.938C371.5 111.249 371.751 111.5 372.062 111.5H379.938C380.249 111.5 380.5 111.249 380.5 110.938V103.25H377.312C377.003 103.25 376.75 102.997 376.75 102.688ZM378.542 107.641L376.282 109.884C376.126 110.039 375.874 110.039 375.719 109.884L373.459 107.641C373.221 107.405 373.388 107 373.722 107H375.25V105.125C375.25 104.918 375.418 104.75 375.625 104.75H376.375C376.582 104.75 376.75 104.918 376.75 105.125V107H378.278C378.612 107 378.779 107.405 378.542 107.641ZM380.336 101.961L378.041 99.6641C377.936 99.5586 377.793 99.5 377.643 99.5H377.5V102.5H380.5V102.357C380.5 102.209 380.441 102.066 380.336 101.961Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_6"
                    d="M387.992 109.5H387.092V101.1H387.992V109.5ZM391.074 104.736V109.5H390.174V103.5H390.75L390.894 104.088C391.078 103.944 391.226 103.832 391.338 103.752C391.458 103.672 391.646 103.592 391.902 103.512C392.158 103.424 392.43 103.38 392.718 103.38C393.27 103.38 393.726 103.552 394.086 103.896C394.454 104.232 394.638 104.712 394.638 105.336V109.5H393.738V105.6C393.738 104.632 393.334 104.148 392.526 104.148C391.95 104.148 391.466 104.344 391.074 104.736ZM397.479 101.1V102.156H396.579V101.1H397.479ZM396.087 111.948C396.415 111.524 396.579 110.844 396.579 109.908V103.5H397.479V109.62C397.479 110.308 397.411 110.856 397.275 111.264C397.147 111.672 396.927 112.04 396.615 112.368L396.087 111.948ZM403.643 106.692H399.815C399.815 107.46 399.995 108.004 400.355 108.324C400.723 108.644 401.183 108.804 401.735 108.804C402.015 108.804 402.211 108.792 402.323 108.768C402.435 108.736 402.539 108.708 402.635 108.684C402.739 108.652 402.811 108.628 402.851 108.612C403.051 108.556 403.223 108.504 403.367 108.456L403.511 109.152C402.711 109.432 402.087 109.572 401.639 109.572C400.815 109.572 400.155 109.324 399.659 108.828C399.163 108.324 398.915 107.572 398.915 106.572C398.915 105.564 399.147 104.78 399.611 104.22C400.083 103.66 400.675 103.38 401.387 103.38C402.107 103.38 402.667 103.612 403.067 104.076C403.467 104.54 403.667 105.168 403.667 105.96C403.667 106.176 403.659 106.42 403.643 106.692ZM399.875 106.008H402.803C402.803 105.416 402.699 104.96 402.491 104.64C402.283 104.32 401.919 104.16 401.399 104.16C400.887 104.16 400.511 104.332 400.271 104.676C400.031 105.02 399.899 105.464 399.875 106.008ZM408.878 108.564L409.058 109.272C408.418 109.464 407.854 109.56 407.366 109.56C406.51 109.56 405.866 109.28 405.434 108.72C405.002 108.16 404.786 107.388 404.786 106.404C404.786 105.42 405.01 104.672 405.458 104.16C405.906 103.64 406.566 103.38 407.438 103.38C407.814 103.38 408.342 103.476 409.022 103.668L408.662 104.364C408.222 104.236 407.826 104.172 407.474 104.172C406.866 104.172 406.426 104.352 406.154 104.712C405.89 105.072 405.758 105.64 405.758 106.416C405.758 107.992 406.322 108.78 407.45 108.78C407.898 108.78 408.374 108.708 408.878 108.564ZM410.685 108.204V104.22H409.869V103.5H410.697V101.784H411.597V103.5H413.061V104.22H411.585V108.036C411.585 108.572 411.857 108.84 412.401 108.84C412.529 108.84 412.725 108.816 412.989 108.768L413.121 109.416C412.793 109.52 412.453 109.572 412.101 109.572C411.757 109.572 411.433 109.468 411.129 109.26C410.833 109.044 410.685 108.692 410.685 108.204ZM424.77 109.5H423.87V102.612L421.17 107.292L420.858 107.28L418.158 102.624V109.5H417.27V101.1H418.278L421.026 105.72L423.87 101.1H424.77V109.5ZM430.701 106.692H426.873C426.873 107.46 427.053 108.004 427.413 108.324C427.781 108.644 428.241 108.804 428.793 108.804C429.073 108.804 429.269 108.792 429.381 108.768C429.493 108.736 429.597 108.708 429.693 108.684C429.797 108.652 429.869 108.628 429.909 108.612C430.109 108.556 430.281 108.504 430.425 108.456L430.569 109.152C429.769 109.432 429.145 109.572 428.697 109.572C427.873 109.572 427.213 109.324 426.717 108.828C426.221 108.324 425.973 107.572 425.973 106.572C425.973 105.564 426.205 104.78 426.669 104.22C427.141 103.66 427.733 103.38 428.445 103.38C429.165 103.38 429.725 103.612 430.125 104.076C430.525 104.54 430.725 105.168 430.725 105.96C430.725 106.176 430.717 106.42 430.701 106.692ZM426.933 106.008H429.861C429.861 105.416 429.757 104.96 429.549 104.64C429.341 104.32 428.977 104.16 428.457 104.16C427.945 104.16 427.569 104.332 427.329 104.676C427.089 105.02 426.957 105.464 426.933 106.008ZM432.552 108.204V104.22H431.736V103.5H432.564V101.784H433.464V103.5H434.928V104.22H433.452V108.036C433.452 108.572 433.724 108.84 434.268 108.84C434.396 108.84 434.592 108.816 434.856 108.768L434.988 109.416C434.66 109.52 434.32 109.572 433.968 109.572C433.624 109.572 433.3 109.468 432.996 109.26C432.7 109.044 432.552 108.692 432.552 108.204ZM437.457 104.916V109.5H436.557V103.5H437.133L437.277 104.208C437.661 103.904 437.981 103.692 438.237 103.572C438.493 103.444 438.785 103.38 439.113 103.38C439.273 103.38 439.393 103.388 439.473 103.404L439.641 103.452L439.497 104.28C439.353 104.232 439.157 104.208 438.909 104.208C438.429 104.208 437.945 104.444 437.457 104.916ZM440.842 109.5V103.5H441.742V109.5H440.842ZM441.742 101.1V102.168H440.842V101.1H441.742ZM447.268 108.564L447.448 109.272C446.808 109.464 446.244 109.56 445.756 109.56C444.9 109.56 444.256 109.28 443.824 108.72C443.392 108.16 443.176 107.388 443.176 106.404C443.176 105.42 443.4 104.672 443.848 104.16C444.296 103.64 444.956 103.38 445.828 103.38C446.204 103.38 446.732 103.476 447.412 103.668L447.052 104.364C446.612 104.236 446.216 104.172 445.864 104.172C445.256 104.172 444.816 104.352 444.544 104.712C444.28 105.072 444.148 105.64 444.148 106.416C444.148 107.992 444.712 108.78 445.84 108.78C446.288 108.78 446.764 108.708 447.268 108.564ZM448.704 108.432C449.224 108.672 449.72 108.792 450.192 108.792C450.664 108.792 451.02 108.7 451.26 108.516C451.508 108.324 451.632 108.072 451.632 107.76C451.632 107.448 451.528 107.208 451.32 107.04C451.112 106.864 450.856 106.728 450.552 106.632C450.256 106.536 449.956 106.432 449.652 106.32C449.356 106.208 449.104 106.04 448.896 105.816C448.688 105.592 448.584 105.308 448.584 104.964C448.584 104.46 448.748 104.072 449.076 103.8C449.404 103.52 449.848 103.38 450.408 103.38C450.968 103.38 451.488 103.464 451.968 103.632L452.052 103.668L451.896 104.436C451.416 104.252 450.968 104.16 450.552 104.16C450.144 104.16 449.864 104.224 449.712 104.352C449.56 104.48 449.484 104.696 449.484 105C449.484 105.192 449.588 105.356 449.796 105.492C450.004 105.628 450.256 105.748 450.552 105.852C450.856 105.948 451.156 106.064 451.452 106.2C451.756 106.328 452.012 106.524 452.22 106.788C452.428 107.052 452.532 107.376 452.532 107.76C452.532 108.32 452.336 108.764 451.944 109.092C451.552 109.412 451.012 109.572 450.324 109.572C449.636 109.572 449.024 109.416 448.488 109.104L448.704 108.432Z"
                    fill="#94A3B8"
                  />
                </g>
              </g>
              <g id="Arrow bottom">
                <g id="SchemaArrow_4">
                  <rect
                    id="Line_4"
                    x="412.5"
                    y="121.5"
                    width="24"
                    height="1"
                    transform="rotate(90 412.5 121.5)"
                    fill="#94A3B8"
                  />
                </g>
              </g>
            </g>
            <g id="SchemaCard_5" filter="url(#filter1_d_264_17165)">
              <rect
                x="312"
                y="145.5"
                width="200"
                height="92"
                rx="4"
                fill="white"
              />
              <g id="Container_5">
                <g id="Icon_7">
                  <g id="Group">
                    <path
                      id="Vector_9"
                      d="M336.83 165.512C337.187 164.395 336.972 162.163 336.28 161.34C336.19 161.232 336.02 161.247 335.945 161.366L335.093 162.711C334.882 162.98 334.502 163.042 334.217 162.854C333.293 162.246 332.188 161.892 331 161.892C329.812 161.892 328.707 162.246 327.783 162.854C327.498 163.042 327.118 162.979 326.907 162.711L326.055 161.366C325.98 161.247 325.81 161.232 325.72 161.34C325.028 162.163 324.813 164.395 325.17 165.512C325.288 165.883 325.322 166.275 325.251 166.658C325.182 167.037 325.112 167.495 325.112 167.813C325.112 171.081 327.749 173.733 331 173.733C334.252 173.733 336.888 171.083 336.888 167.813C336.888 167.494 336.819 167.037 336.749 166.658C336.678 166.275 336.712 165.883 336.83 165.512ZM331 172.409C328.487 172.409 326.442 170.353 326.442 167.826C326.442 167.743 326.445 167.662 326.448 167.58C326.54 165.858 327.579 164.385 329.052 163.684C329.642 163.4 330.304 163.243 331 163.243C331.696 163.243 332.358 163.402 332.95 163.685C334.422 164.387 335.462 165.86 335.553 167.58C335.558 167.662 335.56 167.743 335.56 167.826C335.558 170.353 333.513 172.409 331 172.409Z"
                      fill="black"
                    />
                    <path
                      id="Vector_10"
                      d="M332.974 169.59L331.81 167.56L330.81 165.867C330.787 165.827 330.744 165.803 330.697 165.803H329.742C329.694 165.803 329.652 165.829 329.629 165.869C329.606 165.91 329.606 165.961 329.63 166.001L330.585 167.617L329.303 169.584C329.277 169.624 329.273 169.676 329.296 169.719C329.319 169.762 329.364 169.788 329.411 169.788H330.372C330.417 169.788 330.458 169.765 330.483 169.728L331.176 168.639L331.797 169.722C331.82 169.764 331.865 169.788 331.911 169.788H332.858C332.906 169.788 332.948 169.764 332.971 169.722C332.999 169.681 332.999 169.631 332.974 169.59Z"
                      fill="black"
                    />
                  </g>
                </g>
                <path
                  id="Card label_7"
                  d="M350.302 172.5H348.272V168.216H345.024V172.5H342.994V162.7H345.024V166.606H348.272V162.7H350.302V172.5ZM356.141 172.5L355.861 171.8C355.534 172.099 355.245 172.309 354.993 172.43C354.741 172.542 354.438 172.598 354.083 172.598C353.486 172.598 352.963 172.393 352.515 171.982C352.076 171.562 351.857 171.007 351.857 170.316C351.857 169.625 352.128 169.084 352.669 168.692C353.21 168.291 354.027 168.09 355.119 168.09H355.693C355.693 167.689 355.595 167.367 355.399 167.124C355.212 166.881 354.923 166.76 354.531 166.76C353.85 166.76 353.159 166.853 352.459 167.04L352.151 165.808C353.075 165.509 354.004 165.36 354.937 165.36C356.636 165.36 357.485 166.153 357.485 167.74V172.5H356.141ZM355.665 169.434H355.063C354.54 169.434 354.186 169.504 353.999 169.644C353.812 169.784 353.719 169.989 353.719 170.26C353.719 170.521 353.789 170.736 353.929 170.904C354.069 171.072 354.251 171.156 354.475 171.156C354.792 171.156 355.189 170.904 355.665 170.4V169.434ZM359.346 170.638C359.971 170.955 360.611 171.114 361.264 171.114C361.927 171.114 362.258 170.871 362.258 170.386C362.258 169.938 361.885 169.607 361.138 169.392C360.821 169.308 360.503 169.21 360.186 169.098C359.878 168.977 359.612 168.785 359.388 168.524C359.173 168.253 359.066 167.908 359.066 167.488C359.066 166.807 359.276 166.284 359.696 165.92C360.116 165.547 360.699 165.36 361.446 165.36C362.202 165.36 362.916 165.491 363.588 165.752L363.294 167.208C362.678 166.956 362.076 166.83 361.488 166.83C361.077 166.83 360.872 166.97 360.872 167.25C360.872 167.539 361.147 167.759 361.698 167.908C362.277 168.057 362.79 168.272 363.238 168.552C363.471 168.692 363.667 168.902 363.826 169.182C363.985 169.462 364.064 169.798 364.064 170.19C364.064 170.927 363.817 171.511 363.322 171.94C362.827 172.369 362.146 172.584 361.278 172.584C360.41 172.584 359.635 172.383 358.954 171.982L359.346 170.638ZM365.553 165.5H367.401V169.784C367.401 170.167 367.475 170.479 367.625 170.722C367.774 170.955 368.021 171.072 368.367 171.072C368.712 171.072 369.141 170.857 369.655 170.428V165.5H371.489V172.5H369.949L369.655 171.828C369.253 172.127 368.903 172.327 368.605 172.43C368.315 172.533 367.975 172.584 367.583 172.584C366.957 172.584 366.463 172.379 366.099 171.968C365.735 171.557 365.553 170.946 365.553 170.134V165.5ZM375.593 167.852V172.5H373.759V165.5H375.215L375.383 166.186C375.756 165.887 376.069 165.677 376.321 165.556C376.573 165.425 376.792 165.36 376.979 165.36C377.175 165.36 377.306 165.365 377.371 165.374C377.436 165.374 377.492 165.379 377.539 165.388C377.586 165.397 377.665 165.416 377.777 165.444L377.609 167.11C377.441 167.054 377.212 167.026 376.923 167.026C376.531 167.026 376.088 167.301 375.593 167.852ZM382.938 172.5L382.658 171.8C382.331 172.099 382.042 172.309 381.79 172.43C381.538 172.542 381.234 172.598 380.88 172.598C380.282 172.598 379.76 172.393 379.312 171.982C378.873 171.562 378.654 171.007 378.654 170.316C378.654 169.625 378.924 169.084 379.466 168.692C380.007 168.291 380.824 168.09 381.916 168.09H382.49C382.49 167.689 382.392 167.367 382.196 167.124C382.009 166.881 381.72 166.76 381.328 166.76C380.646 166.76 379.956 166.853 379.256 167.04L378.948 165.808C379.872 165.509 380.8 165.36 381.734 165.36C383.432 165.36 384.282 166.153 384.282 167.74V172.5H382.938ZM382.462 169.434H381.86C381.337 169.434 380.982 169.504 380.796 169.644C380.609 169.784 380.516 169.989 380.516 170.26C380.516 170.521 380.586 170.736 380.726 170.904C380.866 171.072 381.048 171.156 381.272 171.156C381.589 171.156 381.986 170.904 382.462 170.4V169.434Z"
                  fill="#0F172A"
                />
              </g>
              <a
                href="https://hasura.io/docs/latest/enterprise/metrics/#metrics-exported"
                className="hover:cursor-pointer"
              >
                <g id="Items">
                  <path
                    d="M312 189.5H512V234C512 235.933 510.433 237.5 508.5 237.5H315.5C313.567 237.5 312 235.933 312 234V189.5Z"
                    fill="#F1F5F9"
                  />
                  <g id="SchemaCardItem">
                    <g id="Content">
                      <g id="SchemaCardItemText">
                        <g id="Icon_8">
                          <path
                            id="Vector_11"
                            d="M335.487 204.923C335.83 205.518 335.399 206.262 334.713 206.262H325.787C325.1 206.262 324.671 205.517 325.013 204.923L329.477 197.184C329.82 196.589 330.68 196.59 331.023 197.184L335.487 204.923ZM330.25 203.323C329.777 203.323 329.394 203.706 329.394 204.179C329.394 204.651 329.777 205.034 330.25 205.034C330.723 205.034 331.106 204.651 331.106 204.179C331.106 203.706 330.723 203.323 330.25 203.323ZM329.438 200.247L329.576 202.777C329.582 202.895 329.68 202.988 329.798 202.988H330.702C330.82 202.988 330.918 202.895 330.924 202.777L331.062 200.247C331.069 200.119 330.968 200.012 330.839 200.012H329.66C329.532 200.012 329.431 200.119 329.438 200.247Z"
                            fill="#DC2626"
                          />
                        </g>
                        <path
                          id="Card item label"
                          d="M346.116 205.5H341.592V197.1H346.116V197.88H342.492V200.544H345.816V201.348H342.492V204.72H346.116V205.5ZM348.996 200.916V205.5H348.096V199.5H348.672L348.816 200.208C349.2 199.904 349.52 199.692 349.776 199.572C350.032 199.444 350.324 199.38 350.652 199.38C350.812 199.38 350.932 199.388 351.012 199.404L351.18 199.452L351.036 200.28C350.892 200.232 350.696 200.208 350.448 200.208C349.968 200.208 349.484 200.444 348.996 200.916ZM353.449 200.916V205.5H352.549V199.5H353.125L353.269 200.208C353.653 199.904 353.973 199.692 354.229 199.572C354.485 199.444 354.777 199.38 355.105 199.38C355.265 199.38 355.385 199.388 355.465 199.404L355.633 199.452L355.489 200.28C355.345 200.232 355.149 200.208 354.901 200.208C354.421 200.208 353.937 200.444 353.449 200.916ZM360.71 202.548C360.71 201.772 360.558 201.18 360.254 200.772C359.95 200.364 359.506 200.16 358.922 200.16C358.338 200.16 357.922 200.356 357.674 200.748C357.434 201.132 357.314 201.724 357.314 202.524C357.314 204.036 357.87 204.792 358.982 204.792C359.566 204.792 359.998 204.612 360.278 204.252C360.566 203.884 360.71 203.316 360.71 202.548ZM360.926 204.756C360.47 205.3 359.826 205.572 358.994 205.572C358.162 205.572 357.522 205.304 357.074 204.768C356.634 204.224 356.414 203.468 356.414 202.5C356.414 201.524 356.626 200.76 357.05 200.208C357.482 199.656 358.11 199.38 358.934 199.38C359.766 199.38 360.418 199.66 360.89 200.22C361.37 200.78 361.61 201.54 361.61 202.5C361.61 203.46 361.382 204.212 360.926 204.756ZM364.113 200.916V205.5H363.213V199.5H363.789L363.933 200.208C364.317 199.904 364.637 199.692 364.893 199.572C365.149 199.444 365.441 199.38 365.769 199.38C365.929 199.38 366.049 199.388 366.129 199.404L366.297 199.452L366.153 200.28C366.009 200.232 365.813 200.208 365.565 200.208C365.085 200.208 364.601 200.444 364.113 200.916ZM372.31 201.552H371.566V205.488H370.666V197.088H373.09C373.906 197.088 374.518 197.276 374.926 197.652C375.342 198.02 375.55 198.548 375.55 199.236C375.55 199.716 375.382 200.156 375.046 200.556C374.718 200.956 374.31 201.188 373.822 201.252C374.214 201.34 374.49 201.468 374.65 201.636C374.818 201.796 375.014 202.144 375.238 202.68L376.426 205.488H375.478L374.314 202.8C374.098 202.296 373.854 201.964 373.582 201.804C373.318 201.636 372.894 201.552 372.31 201.552ZM373.042 197.856H371.566V200.784H372.922C373.418 200.784 373.81 200.64 374.098 200.352C374.394 200.056 374.542 199.684 374.542 199.236C374.542 198.788 374.41 198.448 374.146 198.216C373.882 197.976 373.514 197.856 373.042 197.856ZM382.061 202.692H378.233C378.233 203.46 378.413 204.004 378.773 204.324C379.141 204.644 379.601 204.804 380.153 204.804C380.433 204.804 380.629 204.792 380.741 204.768C380.853 204.736 380.957 204.708 381.053 204.684C381.157 204.652 381.229 204.628 381.269 204.612C381.469 204.556 381.641 204.504 381.785 204.456L381.929 205.152C381.129 205.432 380.505 205.572 380.057 205.572C379.233 205.572 378.573 205.324 378.077 204.828C377.581 204.324 377.333 203.572 377.333 202.572C377.333 201.564 377.565 200.78 378.029 200.22C378.501 199.66 379.093 199.38 379.805 199.38C380.525 199.38 381.085 199.612 381.485 200.076C381.885 200.54 382.085 201.168 382.085 201.96C382.085 202.176 382.077 202.42 382.061 202.692ZM378.293 202.008H381.221C381.221 201.416 381.117 200.96 380.909 200.64C380.701 200.32 380.337 200.16 379.817 200.16C379.305 200.16 378.929 200.332 378.689 200.676C378.449 201.02 378.317 201.464 378.293 202.008ZM383.912 204.204V200.22H383.096V199.5H383.924V197.784H384.824V199.5H386.288V200.22H384.812V204.036C384.812 204.572 385.084 204.84 385.628 204.84C385.756 204.84 385.952 204.816 386.216 204.768L386.348 205.416C386.02 205.52 385.68 205.572 385.328 205.572C384.984 205.572 384.66 205.468 384.356 205.26C384.06 205.044 383.912 204.692 383.912 204.204ZM388.816 200.916V205.5H387.916V199.5H388.492L388.636 200.208C389.02 199.904 389.34 199.692 389.596 199.572C389.852 199.444 390.144 199.38 390.472 199.38C390.632 199.38 390.752 199.388 390.832 199.404L391 199.452L390.856 200.28C390.712 200.232 390.516 200.208 390.268 200.208C389.788 200.208 389.304 200.444 388.816 200.916ZM392.201 205.5V199.5H393.101V205.5H392.201ZM393.101 197.1V198.168H392.201V197.1H393.101ZM399.264 202.692H395.436C395.436 203.46 395.616 204.004 395.976 204.324C396.344 204.644 396.804 204.804 397.356 204.804C397.636 204.804 397.832 204.792 397.944 204.768C398.056 204.736 398.16 204.708 398.256 204.684C398.36 204.652 398.432 204.628 398.472 204.612C398.672 204.556 398.844 204.504 398.988 204.456L399.132 205.152C398.332 205.432 397.708 205.572 397.26 205.572C396.436 205.572 395.776 205.324 395.28 204.828C394.784 204.324 394.536 203.572 394.536 202.572C394.536 201.564 394.768 200.78 395.232 200.22C395.704 199.66 396.296 199.38 397.008 199.38C397.728 199.38 398.288 199.612 398.688 200.076C399.088 200.54 399.288 201.168 399.288 201.96C399.288 202.176 399.28 202.42 399.264 202.692ZM395.496 202.008H398.424C398.424 201.416 398.32 200.96 398.112 200.64C397.904 200.32 397.54 200.16 397.02 200.16C396.508 200.16 396.132 200.332 395.892 200.676C395.652 201.02 395.52 201.464 395.496 202.008ZM405.087 199.488L403.059 205.5H402.027L400.011 199.488H401.031L402.555 204.54L404.091 199.488H405.087ZM406.147 205.5V199.5H407.047V205.5H406.147ZM407.047 197.1V198.168H406.147V197.1H407.047ZM409.945 200.736V205.5H409.045V199.5H409.621L409.765 200.088C409.949 199.944 410.097 199.832 410.209 199.752C410.329 199.672 410.517 199.592 410.773 199.512C411.029 199.424 411.301 199.38 411.589 199.38C412.141 199.38 412.597 199.552 412.957 199.896C413.325 200.232 413.509 200.712 413.509 201.336V205.5H412.609V201.6C412.609 200.632 412.205 200.148 411.397 200.148C410.821 200.148 410.337 200.344 409.945 200.736ZM419.098 204.864C418.426 205.344 417.814 205.584 417.262 205.584C415.822 205.584 415.102 204.548 415.102 202.476C415.102 201.3 415.358 200.476 415.87 200.004C416.326 199.588 416.878 199.38 417.526 199.38C418.182 199.38 418.73 199.676 419.17 200.268L419.482 199.488H420.01V205.8C420.01 206.672 419.794 207.32 419.362 207.744C418.93 208.168 418.346 208.38 417.61 208.38C417.234 208.38 416.898 208.332 416.602 208.236C416.306 208.14 415.998 208.032 415.678 207.912L415.846 207.276C416.518 207.492 417.078 207.6 417.526 207.6C417.982 207.6 418.358 207.46 418.654 207.18C418.95 206.9 419.098 206.476 419.098 205.908V204.864ZM419.098 204V201.756C419.098 201.284 418.942 200.9 418.63 200.604C418.318 200.308 417.998 200.16 417.67 200.16C417.046 200.16 416.61 200.344 416.362 200.712C416.114 201.072 415.99 201.652 415.99 202.452C415.99 204.02 416.43 204.804 417.31 204.804C417.886 204.804 418.482 204.536 419.098 204ZM429.418 197.4L429.226 198.204L428.53 198C428.034 197.88 427.606 197.82 427.246 197.82C426.302 197.82 425.83 198.24 425.83 199.08C425.83 199.448 425.974 199.752 426.262 199.992C426.55 200.224 426.898 200.412 427.306 200.556C427.722 200.692 428.134 200.844 428.542 201.012C428.958 201.172 429.31 201.424 429.598 201.768C429.886 202.104 430.03 202.532 430.03 203.052C430.03 203.844 429.786 204.464 429.298 204.912C428.81 205.352 428.118 205.572 427.222 205.572C426.774 205.572 426.322 205.508 425.866 205.38C425.418 205.244 425.05 205.088 424.762 204.912L425.062 204.228C425.79 204.564 426.478 204.732 427.126 204.732C427.782 204.732 428.278 204.6 428.614 204.336C428.958 204.072 429.13 203.688 429.13 203.184C429.13 202.672 428.854 202.272 428.302 201.984C428.054 201.856 427.778 201.736 427.474 201.624C427.178 201.512 426.878 201.392 426.574 201.264C426.278 201.128 426.006 200.976 425.758 200.808C425.518 200.64 425.318 200.412 425.158 200.124C425.006 199.836 424.93 199.5 424.93 199.116C424.93 198.428 425.134 197.9 425.542 197.532C425.958 197.164 426.514 196.98 427.21 196.98C427.906 196.98 428.642 197.12 429.418 197.4ZM431.947 204.204V200.22H431.131V199.5H431.959V197.784H432.859V199.5H434.323V200.22H432.847V204.036C432.847 204.572 433.119 204.84 433.663 204.84C433.791 204.84 433.987 204.816 434.251 204.768L434.383 205.416C434.055 205.52 433.715 205.572 433.363 205.572C433.019 205.572 432.695 205.468 432.391 205.26C432.095 205.044 431.947 204.692 431.947 204.204ZM438.543 201.912H439.035C439.035 201.184 438.943 200.712 438.759 200.496C438.575 200.272 438.167 200.16 437.535 200.16C436.903 200.16 436.367 200.244 435.927 200.412L435.759 199.716C436.431 199.492 437.127 199.38 437.847 199.38C439.255 199.38 439.959 200.084 439.959 201.492V205.5H439.431L439.119 204.792C438.751 205.096 438.431 205.304 438.159 205.416C437.895 205.52 437.587 205.572 437.235 205.572C436.675 205.572 436.239 205.408 435.927 205.08C435.615 204.744 435.459 204.304 435.459 203.76C435.459 202.528 436.487 201.912 438.543 201.912ZM439.047 202.668H438.507C437.691 202.668 437.127 202.748 436.815 202.908C436.511 203.068 436.359 203.32 436.359 203.664C436.359 204 436.447 204.276 436.623 204.492C436.799 204.708 437.027 204.816 437.307 204.816C437.595 204.816 437.867 204.752 438.123 204.624C438.387 204.488 438.695 204.256 439.047 203.928V202.668ZM442.283 204.204V200.22H441.467V199.5H442.295V197.784H443.195V199.5H444.659V200.22H443.183V204.036C443.183 204.572 443.455 204.84 443.999 204.84C444.127 204.84 444.323 204.816 444.587 204.768L444.719 205.416C444.391 205.52 444.051 205.572 443.699 205.572C443.355 205.572 443.031 205.468 442.727 205.26C442.431 205.044 442.283 204.692 442.283 204.204ZM449.719 203.976V199.5H450.631V205.5H450.103L449.803 204.792C449.163 205.312 448.551 205.572 447.967 205.572C447.383 205.572 446.935 205.404 446.623 205.068C446.319 204.724 446.167 204.24 446.167 203.616V199.5H447.067V203.472C447.067 203.944 447.135 204.284 447.271 204.492C447.415 204.7 447.647 204.804 447.967 204.804C448.295 204.804 448.627 204.716 448.963 204.54C449.299 204.364 449.551 204.176 449.719 203.976ZM452.587 204.432C453.107 204.672 453.603 204.792 454.075 204.792C454.547 204.792 454.903 204.7 455.143 204.516C455.391 204.324 455.515 204.072 455.515 203.76C455.515 203.448 455.411 203.208 455.203 203.04C454.995 202.864 454.739 202.728 454.435 202.632C454.139 202.536 453.839 202.432 453.535 202.32C453.239 202.208 452.987 202.04 452.779 201.816C452.571 201.592 452.467 201.308 452.467 200.964C452.467 200.46 452.631 200.072 452.959 199.8C453.287 199.52 453.731 199.38 454.291 199.38C454.851 199.38 455.371 199.464 455.851 199.632L455.935 199.668L455.779 200.436C455.299 200.252 454.851 200.16 454.435 200.16C454.027 200.16 453.747 200.224 453.595 200.352C453.443 200.48 453.367 200.696 453.367 201C453.367 201.192 453.471 201.356 453.679 201.492C453.887 201.628 454.139 201.748 454.435 201.852C454.739 201.948 455.039 202.064 455.335 202.2C455.639 202.328 455.895 202.524 456.103 202.788C456.311 203.052 456.415 203.376 456.415 203.76C456.415 204.32 456.219 204.764 455.827 205.092C455.435 205.412 454.895 205.572 454.207 205.572C453.519 205.572 452.907 205.416 452.371 205.104L452.587 204.432Z"
                          fill="#0F172A"
                        />
                      </g>
                    </g>
                    <path
                      d="M312 190.5H512V188.5H312V190.5Z"
                      fill="#E2E8F0"
                      mask="url(#path-33-inside-2_264_17165)"
                    />
                  </g>
                  <g id="SchemaCardItem_2">
                    <g id="Content_2">
                      <g id="SchemaCardItemText_2">
                        <g id="Content_3">
                          <g id="Icon_9">
                            <path
                              id="Vector_12"
                              d="M332.05 227H332.95C333.1 227 333.25 226.85 333.25 226.7V223.55C333.25 223.4 333.1 223.25 332.95 223.25H332.05C331.9 223.25 331.75 223.4 331.75 223.55V226.7C331.75 226.85 331.9 227 332.05 227ZM334.3 227H335.2C335.35 227 335.5 226.85 335.5 226.7V221.3C335.5 221.15 335.35 221 335.2 221H334.3C334.15 221 334 221.15 334 221.3V226.7C334 226.85 334.15 227 334.3 227ZM327.55 227H328.45C328.6 227 328.75 226.85 328.75 226.7V225.05C328.75 224.9 328.6 224.75 328.45 224.75H327.55C327.4 224.75 327.25 224.9 327.25 225.05V226.7C327.25 226.85 327.4 227 327.55 227ZM329.8 227H330.7C330.85 227 331 226.85 331 226.7V222.05C331 221.9 330.85 221.75 330.7 221.75H329.8C329.65 221.75 329.5 221.9 329.5 222.05V226.7C329.5 226.85 329.65 227 329.8 227ZM335.875 228.5H325.75V221.375C325.75 221.168 325.582 221 325.375 221H324.625C324.418 221 324.25 221.168 324.25 221.375V229.25C324.25 229.664 324.586 230 325 230H335.875C336.082 230 336.25 229.832 336.25 229.625V228.875C336.25 228.668 336.082 228.5 335.875 228.5Z"
                              fill="#297393"
                            />
                          </g>
                          <path
                            id="Card item label_2"
                            d="M347.292 229.5H346.284L345.444 226.848H342.432L341.604 229.5H340.656L343.416 221.1H344.508L347.292 229.5ZM345.24 226.068L343.956 222.012L342.66 226.068H345.24ZM352.657 223.488L350.629 229.5H349.597L347.581 223.488H348.601L350.125 228.54L351.661 223.488H352.657ZM356.477 225.912H356.969C356.969 225.184 356.877 224.712 356.693 224.496C356.509 224.272 356.101 224.16 355.469 224.16C354.837 224.16 354.301 224.244 353.861 224.412L353.693 223.716C354.365 223.492 355.061 223.38 355.781 223.38C357.189 223.38 357.893 224.084 357.893 225.492V229.5H357.365L357.053 228.792C356.685 229.096 356.365 229.304 356.093 229.416C355.829 229.52 355.521 229.572 355.169 229.572C354.609 229.572 354.173 229.408 353.861 229.08C353.549 228.744 353.393 228.304 353.393 227.76C353.393 226.528 354.421 225.912 356.477 225.912ZM356.981 226.668H356.441C355.625 226.668 355.061 226.748 354.749 226.908C354.445 227.068 354.293 227.32 354.293 227.664C354.293 228 354.381 228.276 354.557 228.492C354.733 228.708 354.961 228.816 355.241 228.816C355.529 228.816 355.801 228.752 356.057 228.624C356.321 228.488 356.629 228.256 356.981 227.928V226.668ZM359.904 229.5V223.5H360.804V229.5H359.904ZM360.804 221.1V222.168H359.904V221.1H360.804ZM362.803 229.5V221.1H363.703V229.5H362.803ZM368.477 225.912H368.969C368.969 225.184 368.877 224.712 368.693 224.496C368.509 224.272 368.101 224.16 367.469 224.16C366.837 224.16 366.301 224.244 365.861 224.412L365.693 223.716C366.365 223.492 367.061 223.38 367.781 223.38C369.189 223.38 369.893 224.084 369.893 225.492V229.5H369.365L369.053 228.792C368.685 229.096 368.365 229.304 368.093 229.416C367.829 229.52 367.521 229.572 367.169 229.572C366.609 229.572 366.173 229.408 365.861 229.08C365.549 228.744 365.393 228.304 365.393 227.76C365.393 226.528 366.421 225.912 368.477 225.912ZM368.981 226.668H368.441C367.625 226.668 367.061 226.748 366.749 226.908C366.445 227.068 366.293 227.32 366.293 227.664C366.293 228 366.381 228.276 366.557 228.492C366.733 228.708 366.961 228.816 367.241 228.816C367.529 228.816 367.801 228.752 368.057 228.624C368.321 228.488 368.629 228.256 368.981 227.928V226.668ZM372.072 221.1H372.972V224.1C373.66 223.612 374.276 223.368 374.82 223.368C376.26 223.368 376.98 224.404 376.98 226.476C376.98 227.652 376.724 228.476 376.212 228.948C375.756 229.364 375.22 229.572 374.604 229.572C374.292 229.572 373.976 229.504 373.656 229.368C373.336 229.224 373.072 229.072 372.864 228.912L372.6 229.5H372.072V221.1ZM372.972 224.952V228.216C373.132 228.4 373.344 228.544 373.608 228.648C373.88 228.752 374.144 228.804 374.4 228.804C375.024 228.804 375.46 228.62 375.708 228.252C375.956 227.884 376.08 227.308 376.08 226.524C376.08 225.74 375.956 225.148 375.708 224.748C375.46 224.348 375.144 224.148 374.76 224.148C374.184 224.148 373.588 224.416 372.972 224.952ZM378.623 229.5V221.1H379.523V229.5H378.623ZM385.869 226.692H382.041C382.041 227.46 382.221 228.004 382.581 228.324C382.949 228.644 383.409 228.804 383.961 228.804C384.241 228.804 384.437 228.792 384.549 228.768C384.661 228.736 384.765 228.708 384.861 228.684C384.965 228.652 385.037 228.628 385.077 228.612C385.277 228.556 385.449 228.504 385.593 228.456L385.737 229.152C384.937 229.432 384.313 229.572 383.865 229.572C383.041 229.572 382.381 229.324 381.885 228.828C381.389 228.324 381.141 227.572 381.141 226.572C381.141 225.564 381.373 224.78 381.837 224.22C382.309 223.66 382.901 223.38 383.613 223.38C384.333 223.38 384.893 223.612 385.293 224.076C385.693 224.54 385.893 225.168 385.893 225.96C385.893 226.176 385.885 226.42 385.869 226.692ZM382.101 226.008H385.029C385.029 225.416 384.925 224.96 384.717 224.64C384.509 224.32 384.145 224.16 383.625 224.16C383.113 224.16 382.737 224.332 382.497 224.676C382.257 225.02 382.125 225.464 382.101 226.008ZM393.108 223.368C393.876 223.368 394.424 223.64 394.752 224.184C395.432 223.64 396.06 223.368 396.636 223.368C397.212 223.368 397.68 223.532 398.04 223.86C398.408 224.18 398.592 224.648 398.592 225.264V229.5H397.716V225.636C397.716 225.148 397.604 224.78 397.38 224.532C397.164 224.276 396.872 224.148 396.504 224.148C396 224.148 395.492 224.348 394.98 224.748C395.02 224.924 395.04 225.096 395.04 225.264V229.5H394.164V225.636C394.164 225.148 394.052 224.78 393.828 224.532C393.612 224.276 393.32 224.148 392.952 224.148C392.712 224.148 392.492 224.18 392.292 224.244C392.092 224.308 391.944 224.372 391.848 224.436C391.752 224.5 391.628 224.596 391.476 224.724V229.5H390.576V223.5H391.152L391.308 224.112C391.508 223.944 391.66 223.824 391.764 223.752C391.876 223.672 392.056 223.588 392.304 223.5C392.552 223.412 392.82 223.368 393.108 223.368ZM404.936 226.692H401.108C401.108 227.46 401.288 228.004 401.648 228.324C402.016 228.644 402.476 228.804 403.028 228.804C403.308 228.804 403.504 228.792 403.616 228.768C403.728 228.736 403.832 228.708 403.928 228.684C404.032 228.652 404.104 228.628 404.144 228.612C404.344 228.556 404.516 228.504 404.66 228.456L404.804 229.152C404.004 229.432 403.38 229.572 402.932 229.572C402.108 229.572 401.448 229.324 400.952 228.828C400.456 228.324 400.208 227.572 400.208 226.572C400.208 225.564 400.44 224.78 400.904 224.22C401.376 223.66 401.968 223.38 402.68 223.38C403.4 223.38 403.96 223.612 404.36 224.076C404.76 224.54 404.96 225.168 404.96 225.96C404.96 226.176 404.952 226.42 404.936 226.692ZM401.168 226.008H404.096C404.096 225.416 403.992 224.96 403.784 224.64C403.576 224.32 403.212 224.16 402.692 224.16C402.18 224.16 401.804 224.332 401.564 224.676C401.324 225.02 401.192 225.464 401.168 226.008ZM406.787 228.204V224.22H405.971V223.5H406.799V221.784H407.699V223.5H409.163V224.22H407.687V228.036C407.687 228.572 407.959 228.84 408.503 228.84C408.631 228.84 408.827 228.816 409.091 228.768L409.223 229.416C408.895 229.52 408.555 229.572 408.203 229.572C407.859 229.572 407.535 229.468 407.231 229.26C406.935 229.044 406.787 228.692 406.787 228.204ZM411.691 224.916V229.5H410.791V223.5H411.367L411.511 224.208C411.895 223.904 412.215 223.692 412.471 223.572C412.727 223.444 413.019 223.38 413.347 223.38C413.507 223.38 413.627 223.388 413.707 223.404L413.875 223.452L413.731 224.28C413.587 224.232 413.391 224.208 413.143 224.208C412.663 224.208 412.179 224.444 411.691 224.916ZM415.076 229.5V223.5H415.976V229.5H415.076ZM415.976 221.1V222.168H415.076V221.1H415.976ZM421.503 228.564L421.683 229.272C421.043 229.464 420.479 229.56 419.991 229.56C419.135 229.56 418.491 229.28 418.059 228.72C417.627 228.16 417.411 227.388 417.411 226.404C417.411 225.42 417.635 224.672 418.083 224.16C418.531 223.64 419.191 223.38 420.063 223.38C420.439 223.38 420.967 223.476 421.647 223.668L421.287 224.364C420.847 224.236 420.451 224.172 420.099 224.172C419.491 224.172 419.051 224.352 418.779 224.712C418.515 225.072 418.383 225.64 418.383 226.416C418.383 227.992 418.947 228.78 420.075 228.78C420.523 228.78 420.999 228.708 421.503 228.564ZM422.938 228.432C423.458 228.672 423.954 228.792 424.426 228.792C424.898 228.792 425.254 228.7 425.494 228.516C425.742 228.324 425.866 228.072 425.866 227.76C425.866 227.448 425.762 227.208 425.554 227.04C425.346 226.864 425.09 226.728 424.786 226.632C424.49 226.536 424.19 226.432 423.886 226.32C423.59 226.208 423.338 226.04 423.13 225.816C422.922 225.592 422.818 225.308 422.818 224.964C422.818 224.46 422.982 224.072 423.31 223.8C423.638 223.52 424.082 223.38 424.642 223.38C425.202 223.38 425.722 223.464 426.202 223.632L426.286 223.668L426.13 224.436C425.65 224.252 425.202 224.16 424.786 224.16C424.378 224.16 424.098 224.224 423.946 224.352C423.794 224.48 423.718 224.696 423.718 225C423.718 225.192 423.822 225.356 424.03 225.492C424.238 225.628 424.49 225.748 424.786 225.852C425.09 225.948 425.39 226.064 425.686 226.2C425.99 226.328 426.246 226.524 426.454 226.788C426.662 227.052 426.766 227.376 426.766 227.76C426.766 228.32 426.57 228.764 426.178 229.092C425.786 229.412 425.246 229.572 424.558 229.572C423.87 229.572 423.258 229.416 422.722 229.104L422.938 228.432Z"
                            fill="#297393"
                          />
                        </g>
                        <g id="Icon_10">
                          <path
                            id="Vector_13"
                            d="M495.109 227.562H494.453C494.366 227.562 494.283 227.597 494.221 227.659C494.16 227.72 494.125 227.804 494.125 227.891V230.188H487.562V223.625H490.516C490.603 223.625 490.686 223.59 490.748 223.529C490.809 223.467 490.844 223.384 490.844 223.297V222.641C490.844 222.554 490.809 222.47 490.748 222.409C490.686 222.347 490.603 222.312 490.516 222.312H487.234C486.973 222.312 486.723 222.416 486.538 222.601C486.354 222.785 486.25 223.036 486.25 223.297V230.516C486.25 230.777 486.354 231.027 486.538 231.212C486.723 231.396 486.973 231.5 487.234 231.5H494.453C494.714 231.5 494.965 231.396 495.149 231.212C495.334 231.027 495.438 230.777 495.438 230.516V227.891C495.438 227.804 495.403 227.72 495.341 227.659C495.28 227.597 495.196 227.562 495.109 227.562ZM496.258 221H493.633C493.195 221 492.976 221.531 493.284 221.841L494.017 222.574L489.019 227.57C488.973 227.616 488.936 227.67 488.911 227.73C488.887 227.79 488.874 227.854 488.874 227.919C488.874 227.983 488.887 228.048 488.911 228.107C488.936 228.167 488.973 228.222 489.019 228.267L489.483 228.731C489.529 228.777 489.584 228.814 489.643 228.839C489.703 228.863 489.767 228.876 489.832 228.876C489.897 228.876 489.961 228.863 490.021 228.839C490.081 228.814 490.135 228.777 490.181 228.731L495.177 223.734L495.909 224.466C496.217 224.773 496.75 224.558 496.75 224.117V221.492C496.75 221.362 496.698 221.236 496.606 221.144C496.514 221.052 496.388 221 496.258 221V221Z"
                            fill="#94A3B8"
                          />
                        </g>
                      </g>
                    </g>
                    <path
                      d="M312 214.5H512V212.5H312V214.5Z"
                      fill="#E2E8F0"
                      mask="url(#path-37-inside-3_264_17165)"
                    />
                  </g>
                </g>
              </a>
            </g>
          </g>
          <g id="Right">
            <g id="SchemaArrowWithLabel_3">
              <g id="Horizontal_3">
                <g id="Arrow left_2">
                  <g id="SchemaArrow_5">
                    <rect
                      id="Line_5"
                      x="512"
                      y="169"
                      width="22"
                      height="1"
                      fill="#94A3B8"
                    />
                    <path
                      id="Vector_14"
                      d="M534.42 174L534 173.69V165.295L534.405 165L538.5 169.22V169.841L534.42 174Z"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
                <g id="SchemaArrowLabel_3">
                  <g id="Icon_11">
                    <path
                      id="Vector_15"
                      d="M555.688 167.25H552.983L553.981 164.208C554.075 163.852 553.806 163.5 553.438 163.5H550.063C549.781 163.5 549.542 163.709 549.505 163.987L548.755 169.612C548.71 169.95 548.973 170.25 549.313 170.25H552.095L551.014 174.809C550.93 175.165 551.202 175.5 551.56 175.5C551.757 175.5 551.945 175.397 552.048 175.219L556.173 168.094C556.391 167.721 556.121 167.25 555.688 167.25Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_8"
                    d="M565.716 169.972H564.492V173.5H563.592V165.1H565.992C566.888 165.1 567.536 165.296 567.936 165.688C568.344 166.08 568.548 166.692 568.548 167.524C568.548 168.348 568.3 168.964 567.804 169.372C567.308 169.772 566.612 169.972 565.716 169.972ZM565.584 165.868H564.492V169.204H565.284C566.108 169.204 566.708 169.08 567.084 168.832C567.46 168.584 567.648 168.16 567.648 167.56C567.648 166.952 567.484 166.52 567.156 166.264C566.828 166 566.304 165.868 565.584 165.868ZM573.675 170.548C573.675 169.772 573.523 169.18 573.219 168.772C572.915 168.364 572.471 168.16 571.887 168.16C571.303 168.16 570.887 168.356 570.639 168.748C570.399 169.132 570.279 169.724 570.279 170.524C570.279 172.036 570.835 172.792 571.947 172.792C572.531 172.792 572.963 172.612 573.243 172.252C573.531 171.884 573.675 171.316 573.675 170.548ZM573.891 172.756C573.435 173.3 572.791 173.572 571.959 173.572C571.127 173.572 570.487 173.304 570.039 172.768C569.599 172.224 569.379 171.468 569.379 170.5C569.379 169.524 569.591 168.76 570.015 168.208C570.447 167.656 571.075 167.38 571.899 167.38C572.731 167.38 573.383 167.66 573.855 168.22C574.335 168.78 574.575 169.54 574.575 170.5C574.575 171.46 574.347 172.212 573.891 172.756ZM576.97 173.5L575.218 167.5H576.154L577.486 172.552L578.722 167.5H579.61L580.942 172.6L582.166 167.5H583.102L581.458 173.5H580.402L579.166 168.76L578.002 173.5H576.97ZM588.486 170.692H584.658C584.658 171.46 584.838 172.004 585.198 172.324C585.566 172.644 586.026 172.804 586.578 172.804C586.858 172.804 587.054 172.792 587.166 172.768C587.278 172.736 587.382 172.708 587.478 172.684C587.582 172.652 587.654 172.628 587.694 172.612C587.894 172.556 588.066 172.504 588.21 172.456L588.354 173.152C587.554 173.432 586.93 173.572 586.482 173.572C585.658 173.572 584.998 173.324 584.502 172.828C584.006 172.324 583.758 171.572 583.758 170.572C583.758 169.564 583.99 168.78 584.454 168.22C584.926 167.66 585.518 167.38 586.23 167.38C586.95 167.38 587.51 167.612 587.91 168.076C588.31 168.54 588.51 169.168 588.51 169.96C588.51 170.176 588.502 170.42 588.486 170.692ZM584.718 170.008H587.646C587.646 169.416 587.542 168.96 587.334 168.64C587.126 168.32 586.762 168.16 586.242 168.16C585.73 168.16 585.354 168.332 585.114 168.676C584.874 169.02 584.742 169.464 584.718 170.008ZM591.094 168.916V173.5H590.194V167.5H590.77L590.914 168.208C591.298 167.904 591.618 167.692 591.874 167.572C592.13 167.444 592.422 167.38 592.75 167.38C592.91 167.38 593.03 167.388 593.11 167.404L593.278 167.452L593.134 168.28C592.99 168.232 592.794 168.208 592.546 168.208C592.066 168.208 591.582 168.444 591.094 168.916ZM594.479 173.5V167.5H595.379V173.5H594.479ZM595.379 165.1V166.168H594.479V165.1H595.379ZM598.277 168.736V173.5H597.377V167.5H597.953L598.097 168.088C598.281 167.944 598.429 167.832 598.541 167.752C598.661 167.672 598.849 167.592 599.105 167.512C599.361 167.424 599.633 167.38 599.921 167.38C600.473 167.38 600.929 167.552 601.289 167.896C601.657 168.232 601.841 168.712 601.841 169.336V173.5H600.941V169.6C600.941 168.632 600.537 168.148 599.729 168.148C599.153 168.148 598.669 168.344 598.277 168.736ZM607.43 172.864C606.758 173.344 606.146 173.584 605.594 173.584C604.154 173.584 603.434 172.548 603.434 170.476C603.434 169.3 603.69 168.476 604.202 168.004C604.658 167.588 605.21 167.38 605.858 167.38C606.514 167.38 607.062 167.676 607.502 168.268L607.814 167.488H608.342V173.8C608.342 174.672 608.126 175.32 607.694 175.744C607.262 176.168 606.678 176.38 605.942 176.38C605.566 176.38 605.23 176.332 604.934 176.236C604.638 176.14 604.33 176.032 604.01 175.912L604.178 175.276C604.85 175.492 605.41 175.6 605.858 175.6C606.314 175.6 606.69 175.46 606.986 175.18C607.282 174.9 607.43 174.476 607.43 173.908V172.864ZM607.43 172V169.756C607.43 169.284 607.274 168.9 606.962 168.604C606.65 168.308 606.33 168.16 606.002 168.16C605.378 168.16 604.942 168.344 604.694 168.712C604.446 169.072 604.322 169.652 604.322 170.452C604.322 172.02 604.762 172.804 605.642 172.804C606.218 172.804 606.814 172.536 607.43 172Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="Arrow right_2">
                  <g id="SchemaArrow_6">
                    <rect
                      id="Line_6"
                      x="617.5"
                      y="169"
                      width="26.5"
                      height="1"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
              </g>
            </g>
            <g id="Col5">
              <g id="SchemaGrouper_2">
                <g id="Borders_2">
                  <mask id="path-47-inside-4_264_17165" fill="white">
                    <path d="M660 237.5H644V65.5H660V237.5Z" />
                  </mask>
                  <path
                    d="M644 237.5H643V238.5H644V237.5ZM644 65.5V64.5H643V65.5H644ZM660 236.5H644V238.5H660V236.5ZM645 237.5V65.5H643V237.5H645ZM644 66.5H660V64.5H644V66.5Z"
                    fill="#94A3B8"
                    mask="url(#path-47-inside-4_264_17165)"
                  />
                </g>
              </g>
              <g id="Cards_2">
                <g id="SchemaTitle_2">
                  <path
                    id="Title_2"
                    d="M741.152 77.572C739.928 77.572 738.988 77.188 738.332 76.42C737.684 75.644 737.36 74.596 737.36 73.276C737.36 71.956 737.704 70.912 738.392 70.144C739.088 69.376 740.052 68.992 741.284 68.992C741.956 68.992 742.624 69.108 743.288 69.34L742.952 70.684C742.464 70.476 741.888 70.372 741.224 70.372C740.56 70.372 740.04 70.624 739.664 71.128C739.288 71.632 739.1 72.328 739.1 73.216C739.1 74.104 739.276 74.824 739.628 75.376C739.98 75.92 740.476 76.192 741.116 76.192C741.596 76.192 742.28 76.036 743.168 75.724L743.528 76.948C742.8 77.364 742.008 77.572 741.152 77.572ZM747.884 77.56C746.708 77.56 745.82 77.156 745.22 76.348C744.62 75.532 744.32 74.496 744.32 73.24C744.32 71.984 744.62 70.96 745.22 70.168C745.828 69.376 746.716 68.98 747.884 68.98C749.06 68.98 749.952 69.376 750.56 70.168C751.168 70.96 751.472 71.984 751.472 73.24C751.472 74.96 750.948 76.2 749.9 76.96C749.348 77.36 748.676 77.56 747.884 77.56ZM747.908 70.36C747.484 70.36 747.128 70.508 746.84 70.804C746.328 71.316 746.072 72.128 746.072 73.24C746.072 74.08 746.228 74.78 746.54 75.34C746.852 75.892 747.308 76.168 747.908 76.168C748.516 76.168 748.972 75.888 749.276 75.328C749.58 74.76 749.732 74.072 749.732 73.264C749.732 72.448 749.568 71.76 749.24 71.2C748.92 70.64 748.476 70.36 747.908 70.36ZM759.085 77.512H757.261L754.417 72.34V77.5H752.641V69.1H754.417L757.345 74.524V69.1H759.085V77.512ZM765.49 69.4L765.202 70.804L764.458 70.6C763.93 70.48 763.47 70.42 763.078 70.42C762.534 70.42 762.262 70.68 762.262 71.2C762.262 71.4 762.354 71.584 762.538 71.752C762.73 71.912 762.97 72.048 763.258 72.16C763.546 72.264 763.854 72.396 764.182 72.556C764.51 72.716 764.818 72.888 765.106 73.072C765.394 73.256 765.63 73.508 765.814 73.828C766.006 74.148 766.102 74.516 766.102 74.932C766.102 75.756 765.834 76.404 765.298 76.876C764.77 77.34 764.022 77.572 763.054 77.572C762.558 77.572 762.062 77.508 761.566 77.38C761.078 77.244 760.674 77.088 760.354 76.912L760.87 75.628C761.606 75.964 762.334 76.132 763.054 76.132C763.462 76.132 763.782 76.04 764.014 75.856C764.246 75.664 764.362 75.42 764.362 75.124C764.362 74.828 764.23 74.584 763.966 74.392C763.702 74.192 763.382 74.016 763.006 73.864C762.63 73.704 762.254 73.528 761.878 73.336C761.502 73.136 761.182 72.86 760.918 72.508C760.654 72.148 760.522 71.724 760.522 71.236C760.522 70.508 760.75 69.952 761.206 69.568C761.662 69.176 762.274 68.98 763.042 68.98C763.818 68.98 764.634 69.12 765.49 69.4ZM772.855 76.78C772.319 77.308 771.543 77.572 770.527 77.572C769.511 77.572 768.735 77.308 768.199 76.78C767.663 76.244 767.395 75.452 767.395 74.404V69.1H769.147V74.548C769.147 75.076 769.263 75.484 769.495 75.772C769.735 76.052 770.075 76.192 770.515 76.192C770.955 76.192 771.295 76.052 771.535 75.772C771.783 75.484 771.907 75.076 771.907 74.548V69.1H773.659V74.404C773.659 75.452 773.391 76.244 772.855 76.78ZM782.924 77.5H781.184V72.292L779.684 75.532H778.172L776.672 72.304V77.5H774.944V69.1H776.792L778.94 73.6L781.184 69.1H782.924V77.5ZM789.215 77.5H784.211V69.1H789.215V70.48H785.951V72.244H788.915V73.648H785.951V76.12H789.215V77.5ZM792.599 73.852H792.455V77.488H790.715V69.088H793.379C794.283 69.088 794.959 69.288 795.407 69.688C795.855 70.08 796.079 70.644 796.079 71.38C796.079 71.828 795.923 72.24 795.611 72.616C795.299 72.984 794.919 73.196 794.471 73.252C794.791 73.34 795.039 73.488 795.215 73.696C795.391 73.896 795.575 74.224 795.767 74.68L796.955 77.488H795.167L794.003 74.8C793.835 74.416 793.655 74.164 793.463 74.044C793.279 73.916 792.991 73.852 792.599 73.852ZM793.331 70.456H792.455V72.484H793.211C793.531 72.484 793.779 72.38 793.955 72.172C794.139 71.964 794.231 71.708 794.231 71.404C794.231 70.772 793.931 70.456 793.331 70.456ZM802.65 69.4L802.362 70.804L801.618 70.6C801.09 70.48 800.63 70.42 800.238 70.42C799.694 70.42 799.422 70.68 799.422 71.2C799.422 71.4 799.514 71.584 799.698 71.752C799.89 71.912 800.13 72.048 800.418 72.16C800.706 72.264 801.014 72.396 801.342 72.556C801.67 72.716 801.978 72.888 802.266 73.072C802.554 73.256 802.79 73.508 802.974 73.828C803.166 74.148 803.262 74.516 803.262 74.932C803.262 75.756 802.994 76.404 802.458 76.876C801.93 77.34 801.182 77.572 800.214 77.572C799.718 77.572 799.222 77.508 798.726 77.38C798.238 77.244 797.834 77.088 797.514 76.912L798.03 75.628C798.766 75.964 799.494 76.132 800.214 76.132C800.622 76.132 800.942 76.04 801.174 75.856C801.406 75.664 801.522 75.42 801.522 75.124C801.522 74.828 801.39 74.584 801.126 74.392C800.862 74.192 800.542 74.016 800.166 73.864C799.79 73.704 799.414 73.528 799.038 73.336C798.662 73.136 798.342 72.86 798.078 72.508C797.814 72.148 797.682 71.724 797.682 71.236C797.682 70.508 797.91 69.952 798.366 69.568C798.822 69.176 799.434 68.98 800.202 68.98C800.978 68.98 801.794 69.12 802.65 69.4Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_6">
                  <g id="Container_6">
                    <g id="Icon_12">
                      <path
                        id="Vector_16"
                        d="M693.625 105.5H688.375C687.754 105.5 687.25 106.004 687.25 106.625V116.375C687.25 116.996 687.754 117.5 688.375 117.5H693.625C694.246 117.5 694.75 116.996 694.75 116.375V106.625C694.75 106.004 694.246 105.5 693.625 105.5ZM691 116.75C690.585 116.75 690.25 116.415 690.25 116C690.25 115.585 690.585 115.25 691 115.25C691.415 115.25 691.75 115.585 691.75 116C691.75 116.415 691.415 116.75 691 116.75ZM693.625 114.219C693.625 114.373 693.498 114.5 693.344 114.5H688.656C688.502 114.5 688.375 114.373 688.375 114.219V106.906C688.375 106.752 688.502 106.625 688.656 106.625H693.344C693.498 106.625 693.625 106.752 693.625 106.906V114.219Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_9"
                      d="M709.924 116.5H708.748L707.768 113.406H704.254L703.288 116.5H702.182L705.402 106.7H706.676L709.924 116.5ZM707.53 112.496L706.032 107.764L704.52 112.496H707.53ZM712.431 119.832H711.381V109.514H711.997L712.361 110.298C712.753 109.999 713.117 109.771 713.453 109.612C713.799 109.444 714.177 109.36 714.587 109.36C716.267 109.36 717.107 110.569 717.107 112.986C717.107 114.358 716.809 115.315 716.211 115.856C715.679 116.351 715.073 116.598 714.391 116.598C713.719 116.598 713.066 116.374 712.431 115.926V119.832ZM712.431 111.236V114.974C712.618 115.198 712.87 115.375 713.187 115.506C713.505 115.637 713.808 115.702 714.097 115.702C714.825 115.702 715.334 115.487 715.623 115.058C715.913 114.629 716.057 113.957 716.057 113.042C716.057 112.127 715.913 111.437 715.623 110.97C715.334 110.503 714.965 110.27 714.517 110.27C714.219 110.27 713.92 110.331 713.621 110.452C713.332 110.573 713.113 110.69 712.963 110.802C712.823 110.905 712.646 111.049 712.431 111.236ZM720.074 119.832H719.024V109.514H719.64L720.004 110.298C720.396 109.999 720.76 109.771 721.096 109.612C721.441 109.444 721.819 109.36 722.23 109.36C723.91 109.36 724.75 110.569 724.75 112.986C724.75 114.358 724.451 115.315 723.854 115.856C723.322 116.351 722.715 116.598 722.034 116.598C721.362 116.598 720.709 116.374 720.074 115.926V119.832ZM720.074 111.236V114.974C720.261 115.198 720.513 115.375 720.83 115.506C721.147 115.637 721.451 115.702 721.74 115.702C722.468 115.702 722.977 115.487 723.266 115.058C723.555 114.629 723.7 113.957 723.7 113.042C723.7 112.127 723.555 111.437 723.266 110.97C722.977 110.503 722.608 110.27 722.16 110.27C721.861 110.27 721.563 110.331 721.264 110.452C720.975 110.573 720.755 110.69 720.606 110.802C720.466 110.905 720.289 111.049 720.074 111.236ZM726.401 115.254C727.007 115.534 727.586 115.674 728.137 115.674C728.687 115.674 729.103 115.567 729.383 115.352C729.672 115.128 729.817 114.834 729.817 114.47C729.817 114.106 729.695 113.826 729.453 113.63C729.21 113.425 728.911 113.266 728.557 113.154C728.211 113.042 727.861 112.921 727.507 112.79C727.161 112.659 726.867 112.463 726.625 112.202C726.382 111.941 726.261 111.609 726.261 111.208C726.261 110.62 726.452 110.167 726.835 109.85C727.217 109.523 727.735 109.36 728.389 109.36C729.042 109.36 729.649 109.458 730.209 109.654L730.307 109.696L730.125 110.592C729.565 110.377 729.042 110.27 728.557 110.27C728.081 110.27 727.754 110.345 727.577 110.494C727.399 110.643 727.311 110.895 727.311 111.25C727.311 111.474 727.432 111.665 727.675 111.824C727.917 111.983 728.211 112.123 728.557 112.244C728.911 112.356 729.261 112.491 729.607 112.65C729.961 112.799 730.26 113.028 730.503 113.336C730.745 113.644 730.867 114.022 730.867 114.47C730.867 115.123 730.638 115.641 730.181 116.024C729.723 116.397 729.093 116.584 728.291 116.584C727.488 116.584 726.774 116.402 726.149 116.038L726.401 115.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="672.5"
                    y="90"
                    width="131"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_7">
                  <g id="Container_7">
                    <g id="Icon_13">
                      <path
                        id="Vector_17"
                        d="M696.25 161.25H685.75C685.336 161.25 685 160.914 685 160.5V159C685 158.586 685.336 158.25 685.75 158.25H696.25C696.664 158.25 697 158.586 697 159V160.5C697 160.914 696.664 161.25 696.25 161.25ZM695.125 159.188C694.814 159.188 694.562 159.439 694.562 159.75C694.562 160.061 694.814 160.312 695.125 160.312C695.436 160.312 695.688 160.061 695.688 159.75C695.688 159.439 695.436 159.188 695.125 159.188ZM693.625 159.188C693.314 159.188 693.062 159.439 693.062 159.75C693.062 160.061 693.314 160.312 693.625 160.312C693.936 160.312 694.188 160.061 694.188 159.75C694.188 159.439 693.936 159.188 693.625 159.188ZM696.25 165H685.75C685.336 165 685 164.664 685 164.25V162.75C685 162.336 685.336 162 685.75 162H696.25C696.664 162 697 162.336 697 162.75V164.25C697 164.664 696.664 165 696.25 165ZM695.125 162.938C694.814 162.938 694.562 163.189 694.562 163.5C694.562 163.811 694.814 164.062 695.125 164.062C695.436 164.062 695.688 163.811 695.688 163.5C695.688 163.189 695.436 162.938 695.125 162.938ZM693.625 162.938C693.314 162.938 693.062 163.189 693.062 163.5C693.062 163.811 693.314 164.062 693.625 164.062C693.936 164.062 694.188 163.811 694.188 163.5C694.188 163.189 693.936 162.938 693.625 162.938ZM696.25 168.75H685.75C685.336 168.75 685 168.414 685 168V166.5C685 166.086 685.336 165.75 685.75 165.75H696.25C696.664 165.75 697 166.086 697 166.5V168C697 168.414 696.664 168.75 696.25 168.75ZM695.125 166.688C694.814 166.688 694.562 166.939 694.562 167.25C694.562 167.561 694.814 167.812 695.125 167.812C695.436 167.812 695.688 167.561 695.688 167.25C695.688 166.939 695.436 166.688 695.125 166.688ZM693.625 166.688C693.314 166.688 693.062 166.939 693.062 167.25C693.062 167.561 693.314 167.812 693.625 167.812C693.936 167.812 694.188 167.561 694.188 167.25C694.188 166.939 693.936 166.688 693.625 166.688Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_10"
                      d="M710.358 163.25C710.358 164.827 709.901 166.097 708.986 167.058C708.071 168.019 706.849 168.5 705.318 168.5H703.274V158.7H705.752C707.143 158.7 708.258 159.125 709.098 159.974C709.938 160.823 710.358 161.915 710.358 163.25ZM709.224 163.138C709.224 162.037 708.888 161.173 708.216 160.548C707.544 159.923 706.741 159.61 705.808 159.61H704.408V167.59H705.444C706.499 167.59 707.39 167.193 708.118 166.4C708.855 165.607 709.224 164.519 709.224 163.138ZM715.362 164.314H715.936C715.936 163.465 715.829 162.914 715.614 162.662C715.4 162.401 714.924 162.27 714.186 162.27C713.449 162.27 712.824 162.368 712.31 162.564L712.114 161.752C712.898 161.491 713.71 161.36 714.55 161.36C716.193 161.36 717.014 162.181 717.014 163.824V168.5H716.398L716.034 167.674C715.605 168.029 715.232 168.271 714.914 168.402C714.606 168.523 714.247 168.584 713.836 168.584C713.183 168.584 712.674 168.393 712.31 168.01C711.946 167.618 711.764 167.105 711.764 166.47C711.764 165.033 712.964 164.314 715.362 164.314ZM715.95 165.196H715.32C714.368 165.196 713.71 165.289 713.346 165.476C712.992 165.663 712.814 165.957 712.814 166.358C712.814 166.75 712.917 167.072 713.122 167.324C713.328 167.576 713.594 167.702 713.92 167.702C714.256 167.702 714.574 167.627 714.872 167.478C715.18 167.319 715.54 167.049 715.95 166.666V165.196ZM719.725 166.988V162.34H718.773V161.5H719.739V159.498H720.789V161.5H722.497V162.34H720.775V166.792C720.775 167.417 721.093 167.73 721.727 167.73C721.877 167.73 722.105 167.702 722.413 167.646L722.567 168.402C722.185 168.523 721.788 168.584 721.377 168.584C720.976 168.584 720.598 168.463 720.243 168.22C719.898 167.968 719.725 167.557 719.725 166.988ZM727.421 164.314H727.995C727.995 163.465 727.888 162.914 727.673 162.662C727.458 162.401 726.982 162.27 726.245 162.27C725.508 162.27 724.882 162.368 724.369 162.564L724.173 161.752C724.957 161.491 725.769 161.36 726.609 161.36C728.252 161.36 729.073 162.181 729.073 163.824V168.5H728.457L728.093 167.674C727.664 168.029 727.29 168.271 726.973 168.402C726.665 168.523 726.306 168.584 725.895 168.584C725.242 168.584 724.733 168.393 724.369 168.01C724.005 167.618 723.823 167.105 723.823 166.47C723.823 165.033 725.022 164.314 727.421 164.314ZM728.009 165.196H727.379C726.427 165.196 725.769 165.289 725.405 165.476C725.05 165.663 724.873 165.957 724.873 166.358C724.873 166.75 724.976 167.072 725.181 167.324C725.386 167.576 725.652 167.702 725.979 167.702C726.315 167.702 726.632 167.627 726.931 167.478C727.239 167.319 727.598 167.049 728.009 166.666V165.196ZM737.594 164.384H736.166V168.5H735.116V158.7H737.916C738.961 158.7 739.717 158.929 740.184 159.386C740.66 159.843 740.898 160.557 740.898 161.528C740.898 162.489 740.608 163.208 740.03 163.684C739.451 164.151 738.639 164.384 737.594 164.384ZM737.44 159.596H736.166V163.488H737.09C738.051 163.488 738.751 163.343 739.19 163.054C739.628 162.765 739.848 162.27 739.848 161.57C739.848 160.861 739.656 160.357 739.274 160.058C738.891 159.75 738.28 159.596 737.44 159.596ZM742.69 168.5V158.7H743.74V168.5H742.69ZM749.31 164.314H749.884C749.884 163.465 749.776 162.914 749.562 162.662C749.347 162.401 748.871 162.27 748.134 162.27C747.396 162.27 746.771 162.368 746.258 162.564L746.062 161.752C746.846 161.491 747.658 161.36 748.498 161.36C750.14 161.36 750.962 162.181 750.962 163.824V168.5H750.346L749.982 167.674C749.552 168.029 749.179 168.271 748.862 168.402C748.554 168.523 748.194 168.584 747.784 168.584C747.13 168.584 746.622 168.393 746.258 168.01C745.894 167.618 745.712 167.105 745.712 166.47C745.712 165.033 746.911 164.314 749.31 164.314ZM749.898 165.196H749.268C748.316 165.196 747.658 165.289 747.294 165.476C746.939 165.663 746.762 165.957 746.762 166.358C746.762 166.75 746.864 167.072 747.07 167.324C747.275 167.576 747.541 167.702 747.868 167.702C748.204 167.702 748.521 167.627 748.82 167.478C749.128 167.319 749.487 167.049 749.898 166.666V165.196ZM753.672 166.988V162.34H752.72V161.5H753.686V159.498H754.736V161.5H756.444V162.34H754.722V166.792C754.722 167.417 755.04 167.73 755.674 167.73C755.824 167.73 756.052 167.702 756.36 167.646L756.514 168.402C756.132 168.523 755.735 168.584 755.324 168.584C754.923 168.584 754.545 168.463 754.19 168.22C753.845 167.968 753.672 167.557 753.672 166.988ZM758.652 161.5V160.156C758.652 159.587 758.825 159.181 759.17 158.938C759.525 158.686 759.903 158.56 760.304 158.56C760.715 158.56 761.112 158.621 761.494 158.742L761.34 159.498C761.032 159.442 760.804 159.414 760.654 159.414C760.01 159.414 759.688 159.727 759.688 160.352V161.5H761.116V162.34H759.688V168.5H758.638V162.34H757.56V161.5H758.652ZM766.745 165.056C766.745 164.151 766.567 163.46 766.213 162.984C765.858 162.508 765.34 162.27 764.659 162.27C763.977 162.27 763.492 162.499 763.203 162.956C762.923 163.404 762.783 164.095 762.783 165.028C762.783 166.792 763.431 167.674 764.729 167.674C765.41 167.674 765.914 167.464 766.241 167.044C766.577 166.615 766.745 165.952 766.745 165.056ZM766.997 167.632C766.465 168.267 765.713 168.584 764.743 168.584C763.772 168.584 763.025 168.271 762.503 167.646C761.989 167.011 761.733 166.129 761.733 165C761.733 163.861 761.98 162.97 762.475 162.326C762.979 161.682 763.711 161.36 764.673 161.36C765.643 161.36 766.404 161.687 766.955 162.34C767.515 162.993 767.795 163.88 767.795 165C767.795 166.12 767.529 166.997 766.997 167.632ZM770.715 163.152V168.5H769.665V161.5H770.337L770.505 162.326C770.953 161.971 771.326 161.724 771.625 161.584C771.923 161.435 772.264 161.36 772.647 161.36C772.833 161.36 772.973 161.369 773.067 161.388L773.263 161.444L773.095 162.41C772.927 162.354 772.698 162.326 772.409 162.326C771.849 162.326 771.284 162.601 770.715 163.152ZM777.814 161.346C778.71 161.346 779.349 161.663 779.732 162.298C780.525 161.663 781.258 161.346 781.93 161.346C782.602 161.346 783.148 161.537 783.568 161.92C783.997 162.293 784.212 162.839 784.212 163.558V168.5H783.19V163.992C783.19 163.423 783.059 162.993 782.798 162.704C782.546 162.405 782.205 162.256 781.776 162.256C781.188 162.256 780.595 162.489 779.998 162.956C780.045 163.161 780.068 163.362 780.068 163.558V168.5H779.046V163.992C779.046 163.423 778.915 162.993 778.654 162.704C778.402 162.405 778.061 162.256 777.632 162.256C777.352 162.256 777.095 162.293 776.862 162.368C776.629 162.443 776.456 162.517 776.344 162.592C776.232 162.667 776.087 162.779 775.91 162.928V168.5H774.86V161.5H775.532L775.714 162.214C775.947 162.018 776.125 161.878 776.246 161.794C776.377 161.701 776.587 161.603 776.876 161.5C777.165 161.397 777.478 161.346 777.814 161.346ZM786.488 167.254C787.095 167.534 787.674 167.674 788.224 167.674C788.775 167.674 789.19 167.567 789.47 167.352C789.76 167.128 789.904 166.834 789.904 166.47C789.904 166.106 789.783 165.826 789.54 165.63C789.298 165.425 788.999 165.266 788.644 165.154C788.299 165.042 787.949 164.921 787.594 164.79C787.249 164.659 786.955 164.463 786.712 164.202C786.47 163.941 786.348 163.609 786.348 163.208C786.348 162.62 786.54 162.167 786.922 161.85C787.305 161.523 787.823 161.36 788.476 161.36C789.13 161.36 789.736 161.458 790.296 161.654L790.394 161.696L790.212 162.592C789.652 162.377 789.13 162.27 788.644 162.27C788.168 162.27 787.842 162.345 787.664 162.494C787.487 162.643 787.398 162.895 787.398 163.25C787.398 163.474 787.52 163.665 787.762 163.824C788.005 163.983 788.299 164.123 788.644 164.244C788.999 164.356 789.349 164.491 789.694 164.65C790.049 164.799 790.348 165.028 790.59 165.336C790.833 165.644 790.954 166.022 790.954 166.47C790.954 167.123 790.726 167.641 790.268 168.024C789.811 168.397 789.181 168.584 788.378 168.584C787.576 168.584 786.862 168.402 786.236 168.038L786.488 167.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="672.5"
                    y="142"
                    width="131"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_8">
                  <g id="Container_8">
                    <g id="Icon_14">
                      <path
                        id="Vector_18"
                        d="M692.2 216.7H689.8C689.469 216.7 689.2 216.969 689.2 217.3V219.7C689.2 220.031 689.469 220.3 689.8 220.3H692.2C692.531 220.3 692.8 220.031 692.8 219.7V217.3C692.8 216.969 692.531 216.7 692.2 216.7ZM688.6 211.3C688.6 210.969 688.331 210.7 688 210.7H685.6C685.269 210.7 685 210.969 685 211.3V213.7C685 214.031 685.269 214.3 685.6 214.3H687.395L688.767 216.701C688.975 216.343 689.358 216.1 689.8 216.1H689.805L688.6 213.991V213.1H692.8V211.9H688.6V211.3ZM696.4 210.7H694C693.669 210.7 693.4 210.969 693.4 211.3V213.7C693.4 214.031 693.669 214.3 694 214.3H696.4C696.731 214.3 697 214.031 697 213.7V211.3C697 210.969 696.731 210.7 696.4 210.7Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_11"
                      d="M706.522 220.57C705.243 220.57 704.277 220.099 703.624 219.156C702.971 218.204 702.644 216.995 702.644 215.53C702.644 214.065 702.971 212.87 703.624 211.946C704.287 211.022 705.253 210.56 706.522 210.56C707.801 210.56 708.771 211.022 709.434 211.946C710.097 212.87 710.428 214.065 710.428 215.53C710.428 217.537 709.859 218.983 708.72 219.87C708.113 220.337 707.381 220.57 706.522 220.57ZM706.55 211.47C705.598 211.47 704.884 211.867 704.408 212.66C703.941 213.453 703.708 214.424 703.708 215.572C703.708 216.72 703.946 217.686 704.422 218.47C704.907 219.254 705.617 219.646 706.55 219.646C707.483 219.646 708.188 219.249 708.664 218.456C709.14 217.663 709.378 216.664 709.378 215.46C709.378 213.948 708.953 212.819 708.104 212.072C707.665 211.671 707.147 211.47 706.55 211.47ZM712.52 218.988V214.34H711.568V213.5H712.534V211.498H713.584V213.5H715.292V214.34H713.57V218.792C713.57 219.417 713.887 219.73 714.522 219.73C714.671 219.73 714.9 219.702 715.208 219.646L715.362 220.402C714.979 220.523 714.583 220.584 714.172 220.584C713.771 220.584 713.393 220.463 713.038 220.22C712.693 219.968 712.52 219.557 712.52 218.988ZM722.428 220.5H721.378V215.894C721.378 214.765 720.907 214.2 719.964 214.2C719.264 214.2 718.69 214.424 718.242 214.872V220.5H717.192V210.7H718.228V214.018C718.433 213.85 718.592 213.729 718.704 213.654C718.825 213.579 719.017 213.505 719.278 213.43C719.549 213.355 719.852 213.318 720.188 213.318C720.832 213.318 721.364 213.514 721.784 213.906C722.213 214.298 722.428 214.858 722.428 215.586V220.5ZM729.829 217.224H725.363C725.363 218.12 725.573 218.755 725.993 219.128C726.423 219.501 726.959 219.688 727.603 219.688C727.93 219.688 728.159 219.674 728.289 219.646C728.42 219.609 728.541 219.576 728.653 219.548C728.775 219.511 728.859 219.483 728.905 219.464C729.139 219.399 729.339 219.338 729.507 219.282L729.675 220.094C728.742 220.421 728.014 220.584 727.491 220.584C726.53 220.584 725.76 220.295 725.181 219.716C724.603 219.128 724.313 218.251 724.313 217.084C724.313 215.908 724.584 214.993 725.125 214.34C725.676 213.687 726.367 213.36 727.197 213.36C728.037 213.36 728.691 213.631 729.157 214.172C729.624 214.713 729.857 215.446 729.857 216.37C729.857 216.622 729.848 216.907 729.829 217.224ZM725.433 216.426H728.849C728.849 215.735 728.728 215.203 728.485 214.83C728.243 214.457 727.818 214.27 727.211 214.27C726.614 214.27 726.175 214.471 725.895 214.872C725.615 215.273 725.461 215.791 725.433 216.426ZM732.871 215.152V220.5H731.821V213.5H732.493L732.661 214.326C733.109 213.971 733.482 213.724 733.781 213.584C734.08 213.435 734.42 213.36 734.803 213.36C734.99 213.36 735.13 213.369 735.223 213.388L735.419 213.444L735.251 214.41C735.083 214.354 734.854 214.326 734.565 214.326C734.005 214.326 733.44 214.601 732.871 215.152ZM745.444 211.05L745.22 211.988L744.408 211.75C743.83 211.61 743.33 211.54 742.91 211.54C741.809 211.54 741.258 212.03 741.258 213.01C741.258 213.439 741.426 213.794 741.762 214.074C742.098 214.345 742.504 214.564 742.98 214.732C743.466 214.891 743.946 215.068 744.422 215.264C744.908 215.451 745.318 215.745 745.654 216.146C745.99 216.538 746.158 217.037 746.158 217.644C746.158 218.568 745.874 219.291 745.304 219.814C744.735 220.327 743.928 220.584 742.882 220.584C742.36 220.584 741.832 220.509 741.3 220.36C740.778 220.201 740.348 220.019 740.012 219.814L740.362 219.016C741.212 219.408 742.014 219.604 742.77 219.604C743.536 219.604 744.114 219.45 744.506 219.142C744.908 218.834 745.108 218.386 745.108 217.798C745.108 217.201 744.786 216.734 744.142 216.398C743.853 216.249 743.531 216.109 743.176 215.978C742.831 215.847 742.481 215.707 742.126 215.558C741.781 215.399 741.464 215.222 741.174 215.026C740.894 214.83 740.661 214.564 740.474 214.228C740.297 213.892 740.208 213.5 740.208 213.052C740.208 212.249 740.446 211.633 740.922 211.204C741.408 210.775 742.056 210.56 742.868 210.56C743.68 210.56 744.539 210.723 745.444 211.05ZM753.085 217.224H748.619C748.619 218.12 748.829 218.755 749.249 219.128C749.678 219.501 750.215 219.688 750.859 219.688C751.186 219.688 751.414 219.674 751.545 219.646C751.676 219.609 751.797 219.576 751.909 219.548C752.03 219.511 752.114 219.483 752.161 219.464C752.394 219.399 752.595 219.338 752.763 219.282L752.931 220.094C751.998 220.421 751.27 220.584 750.747 220.584C749.786 220.584 749.016 220.295 748.437 219.716C747.858 219.128 747.569 218.251 747.569 217.084C747.569 215.908 747.84 214.993 748.381 214.34C748.932 213.687 749.622 213.36 750.453 213.36C751.293 213.36 751.946 213.631 752.413 214.172C752.88 214.713 753.113 215.446 753.113 216.37C753.113 216.622 753.104 216.907 753.085 217.224ZM748.689 216.426H752.105C752.105 215.735 751.984 215.203 751.741 214.83C751.498 214.457 751.074 214.27 750.467 214.27C749.87 214.27 749.431 214.471 749.151 214.872C748.871 215.273 748.717 215.791 748.689 216.426ZM756.127 215.152V220.5H755.077V213.5H755.749L755.917 214.326C756.365 213.971 756.738 213.724 757.037 213.584C757.335 213.435 757.676 213.36 758.059 213.36C758.245 213.36 758.385 213.369 758.479 213.388L758.675 213.444L758.507 214.41C758.339 214.354 758.11 214.326 757.821 214.326C757.261 214.326 756.696 214.601 756.127 215.152ZM765.074 213.486L762.708 220.5H761.504L759.152 213.486H760.342L762.12 219.38L763.912 213.486H765.074ZM766.31 220.5V213.5H767.36V220.5H766.31ZM767.36 210.7V211.946H766.31V210.7H767.36ZM773.808 219.408L774.018 220.234C773.271 220.458 772.613 220.57 772.044 220.57C771.045 220.57 770.294 220.243 769.79 219.59C769.286 218.937 769.034 218.036 769.034 216.888C769.034 215.74 769.295 214.867 769.818 214.27C770.341 213.663 771.111 213.36 772.128 213.36C772.567 213.36 773.183 213.472 773.976 213.696L773.556 214.508C773.043 214.359 772.581 214.284 772.17 214.284C771.461 214.284 770.947 214.494 770.63 214.914C770.322 215.334 770.168 215.997 770.168 216.902C770.168 218.741 770.826 219.66 772.142 219.66C772.665 219.66 773.22 219.576 773.808 219.408ZM780.607 217.224H776.141C776.141 218.12 776.351 218.755 776.771 219.128C777.2 219.501 777.737 219.688 778.381 219.688C778.707 219.688 778.936 219.674 779.067 219.646C779.197 219.609 779.319 219.576 779.431 219.548C779.552 219.511 779.636 219.483 779.683 219.464C779.916 219.399 780.117 219.338 780.285 219.282L780.453 220.094C779.519 220.421 778.791 220.584 778.269 220.584C777.307 220.584 776.537 220.295 775.959 219.716C775.38 219.128 775.091 218.251 775.091 217.084C775.091 215.908 775.361 214.993 775.903 214.34C776.453 213.687 777.144 213.36 777.975 213.36C778.815 213.36 779.468 213.631 779.935 214.172C780.401 214.713 780.635 215.446 780.635 216.37C780.635 216.622 780.625 216.907 780.607 217.224ZM776.211 216.426H779.627C779.627 215.735 779.505 215.203 779.263 214.83C779.02 214.457 778.595 214.27 777.989 214.27C777.391 214.27 776.953 214.471 776.673 214.872C776.393 215.273 776.239 215.791 776.211 216.426ZM782.332 219.254C782.939 219.534 783.518 219.674 784.068 219.674C784.619 219.674 785.034 219.567 785.314 219.352C785.604 219.128 785.748 218.834 785.748 218.47C785.748 218.106 785.627 217.826 785.384 217.63C785.142 217.425 784.843 217.266 784.488 217.154C784.143 217.042 783.793 216.921 783.438 216.79C783.093 216.659 782.799 216.463 782.556 216.202C782.314 215.941 782.192 215.609 782.192 215.208C782.192 214.62 782.384 214.167 782.766 213.85C783.149 213.523 783.667 213.36 784.32 213.36C784.974 213.36 785.58 213.458 786.14 213.654L786.238 213.696L786.056 214.592C785.496 214.377 784.974 214.27 784.488 214.27C784.012 214.27 783.686 214.345 783.508 214.494C783.331 214.643 783.242 214.895 783.242 215.25C783.242 215.474 783.364 215.665 783.606 215.824C783.849 215.983 784.143 216.123 784.488 216.244C784.843 216.356 785.193 216.491 785.538 216.65C785.893 216.799 786.192 217.028 786.434 217.336C786.677 217.644 786.798 218.022 786.798 218.47C786.798 219.123 786.57 219.641 786.112 220.024C785.655 220.397 785.025 220.584 784.222 220.584C783.42 220.584 782.706 220.402 782.08 220.038L782.332 219.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="672.5"
                    y="194"
                    width="131"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
              </g>
            </g>
          </g>
          <rect
            x="0.5"
            y="1"
            width="823"
            height="256"
            rx="3.5"
            stroke="#CBD5E1"
          />
        </g>
        <defs>
          <filter
            id="filter0_d_264_17165"
            x="310"
            y="19.5"
            width="204"
            height="48"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feMorphology
              radius="2"
              operator="dilate"
              in="SourceAlpha"
              result="effect1_dropShadow_264_17165"
            />
            <feOffset />
            <feComposite in2="hardAlpha" operator="out" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0.992157 0 0 0 0 0.901961 0 0 0 0 0.541176 0 0 0 1 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_264_17165"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_264_17165"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_264_17165"
            x="310"
            y="144.5"
            width="204"
            height="96"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_264_17165"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_264_17165"
              result="shape"
            />
          </filter>
          <clipPath id="clip0_264_17165">
            <rect
              x="312"
              y="21.5"
              width="200"
              height="44"
              rx="4"
              fill="white"
            />
          </clipPath>
        </defs>
      </svg>
    ) : enabled ? (
      <svg
        width="100%"
        height="100%"
        viewBox="0 0 823 258"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        className={clsx('w-full', className)}
      >
        <g id="Variant=Default">
          <rect
            x="0.5"
            y="1"
            width="823"
            height="256"
            rx="3.5"
            fill="#E2E8F0"
          />
          <g id="Left">
            <g id="Col1">
              <g id="Cards">
                <g id="SchemaTitle">
                  <path
                    id="Title"
                    d="M25.556 69.4L25.268 70.804L24.524 70.6C23.996 70.48 23.536 70.42 23.144 70.42C22.6 70.42 22.328 70.68 22.328 71.2C22.328 71.4 22.42 71.584 22.604 71.752C22.796 71.912 23.036 72.048 23.324 72.16C23.612 72.264 23.92 72.396 24.248 72.556C24.576 72.716 24.884 72.888 25.172 73.072C25.46 73.256 25.696 73.508 25.88 73.828C26.072 74.148 26.168 74.516 26.168 74.932C26.168 75.756 25.9 76.404 25.364 76.876C24.836 77.34 24.088 77.572 23.12 77.572C22.624 77.572 22.128 77.508 21.632 77.38C21.144 77.244 20.74 77.088 20.42 76.912L20.936 75.628C21.672 75.964 22.4 76.132 23.12 76.132C23.528 76.132 23.848 76.04 24.08 75.856C24.312 75.664 24.428 75.42 24.428 75.124C24.428 74.828 24.296 74.584 24.032 74.392C23.768 74.192 23.448 74.016 23.072 73.864C22.696 73.704 22.32 73.528 21.944 73.336C21.568 73.136 21.248 72.86 20.984 72.508C20.72 72.148 20.588 71.724 20.588 71.236C20.588 70.508 20.816 69.952 21.272 69.568C21.728 69.176 22.34 68.98 23.108 68.98C23.884 68.98 24.7 69.12 25.556 69.4ZM30.4854 77.56C29.3094 77.56 28.4214 77.156 27.8214 76.348C27.2214 75.532 26.9214 74.496 26.9214 73.24C26.9214 71.984 27.2214 70.96 27.8214 70.168C28.4294 69.376 29.3174 68.98 30.4854 68.98C31.6614 68.98 32.5534 69.376 33.1614 70.168C33.7694 70.96 34.0734 71.984 34.0734 73.24C34.0734 74.96 33.5494 76.2 32.5014 76.96C31.9494 77.36 31.2774 77.56 30.4854 77.56ZM30.5094 70.36C30.0854 70.36 29.7294 70.508 29.4414 70.804C28.9294 71.316 28.6734 72.128 28.6734 73.24C28.6734 74.08 28.8294 74.78 29.1414 75.34C29.4534 75.892 29.9094 76.168 30.5094 76.168C31.1174 76.168 31.5734 75.888 31.8774 75.328C32.1814 74.76 32.3334 74.072 32.3334 73.264C32.3334 72.448 32.1694 71.76 31.8414 71.2C31.5214 70.64 31.0774 70.36 30.5094 70.36ZM40.7026 76.78C40.1666 77.308 39.3906 77.572 38.3746 77.572C37.3586 77.572 36.5826 77.308 36.0466 76.78C35.5106 76.244 35.2426 75.452 35.2426 74.404V69.1H36.9946V74.548C36.9946 75.076 37.1106 75.484 37.3426 75.772C37.5826 76.052 37.9226 76.192 38.3626 76.192C38.8026 76.192 39.1426 76.052 39.3826 75.772C39.6306 75.484 39.7546 75.076 39.7546 74.548V69.1H41.5066V74.404C41.5066 75.452 41.2386 76.244 40.7026 76.78ZM45.0954 73.852H44.9514V77.488H43.2114V69.088H45.8754C46.7794 69.088 47.4554 69.288 47.9034 69.688C48.3514 70.08 48.5754 70.644 48.5754 71.38C48.5754 71.828 48.4194 72.24 48.1074 72.616C47.7954 72.984 47.4154 73.196 46.9674 73.252C47.2874 73.34 47.5354 73.488 47.7114 73.696C47.8874 73.896 48.0714 74.224 48.2634 74.68L49.4514 77.488H47.6634L46.4994 74.8C46.3314 74.416 46.1514 74.164 45.9594 74.044C45.7754 73.916 45.4874 73.852 45.0954 73.852ZM45.8274 70.456H44.9514V72.484H45.7074C46.0274 72.484 46.2754 72.38 46.4514 72.172C46.6354 71.964 46.7274 71.708 46.7274 71.404C46.7274 70.772 46.4274 70.456 45.8274 70.456ZM53.7418 77.572C52.5178 77.572 51.5778 77.188 50.9218 76.42C50.2738 75.644 49.9498 74.596 49.9498 73.276C49.9498 71.956 50.2938 70.912 50.9818 70.144C51.6778 69.376 52.6418 68.992 53.8738 68.992C54.5458 68.992 55.2138 69.108 55.8778 69.34L55.5418 70.684C55.0538 70.476 54.4778 70.372 53.8138 70.372C53.1498 70.372 52.6298 70.624 52.2538 71.128C51.8778 71.632 51.6898 72.328 51.6898 73.216C51.6898 74.104 51.8658 74.824 52.2178 75.376C52.5698 75.92 53.0658 76.192 53.7058 76.192C54.1858 76.192 54.8698 76.036 55.7578 75.724L56.1178 76.948C55.3898 77.364 54.5978 77.572 53.7418 77.572ZM62.4537 77.5H57.4497V69.1H62.4537V70.48H59.1897V72.244H62.1537V73.648H59.1897V76.12H62.4537V77.5ZM68.6576 69.4L68.3696 70.804L67.6256 70.6C67.0976 70.48 66.6376 70.42 66.2456 70.42C65.7016 70.42 65.4296 70.68 65.4296 71.2C65.4296 71.4 65.5216 71.584 65.7056 71.752C65.8976 71.912 66.1376 72.048 66.4256 72.16C66.7136 72.264 67.0216 72.396 67.3496 72.556C67.6776 72.716 67.9856 72.888 68.2736 73.072C68.5616 73.256 68.7976 73.508 68.9816 73.828C69.1736 74.148 69.2696 74.516 69.2696 74.932C69.2696 75.756 69.0016 76.404 68.4656 76.876C67.9376 77.34 67.1896 77.572 66.2216 77.572C65.7256 77.572 65.2296 77.508 64.7336 77.38C64.2456 77.244 63.8416 77.088 63.5216 76.912L64.0376 75.628C64.7736 75.964 65.5016 76.132 66.2216 76.132C66.6296 76.132 66.9496 76.04 67.1816 75.856C67.4136 75.664 67.5296 75.42 67.5296 75.124C67.5296 74.828 67.3976 74.584 67.1336 74.392C66.8696 74.192 66.5496 74.016 66.1736 73.864C65.7976 73.704 65.4216 73.528 65.0456 73.336C64.6696 73.136 64.3496 72.86 64.0856 72.508C63.8216 72.148 63.6896 71.724 63.6896 71.236C63.6896 70.508 63.9176 69.952 64.3736 69.568C64.8296 69.176 65.4416 68.98 66.2096 68.98C66.9856 68.98 67.8016 69.12 68.6576 69.4Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="SchemaCard">
                  <g id="Container">
                    <g id="Icon">
                      <path
                        id="Vector"
                        d="M42.6025 110.295L42.4488 110.563C42.3925 110.663 42.2725 110.704 42.1657 110.665C41.9444 110.582 41.7419 110.464 41.5638 110.316C41.4775 110.245 41.455 110.119 41.5113 110.022L41.665 109.753C41.5357 109.603 41.4344 109.429 41.3669 109.24H41.0575C40.945 109.24 40.8475 109.159 40.8288 109.047C40.7913 108.822 40.7894 108.585 40.8288 108.351C40.8475 108.238 40.945 108.156 41.0575 108.156H41.3669C41.4344 107.967 41.5357 107.792 41.665 107.642L41.5113 107.374C41.455 107.277 41.4757 107.151 41.5638 107.08C41.7419 106.932 41.9463 106.813 42.1657 106.731C42.2725 106.692 42.3925 106.733 42.4488 106.832L42.6025 107.1C42.7994 107.065 43 107.065 43.1969 107.1L43.3507 106.832C43.4069 106.733 43.5269 106.692 43.6338 106.731C43.855 106.813 44.0575 106.932 44.2357 107.08C44.3219 107.151 44.3444 107.277 44.2882 107.374L44.1344 107.642C44.2638 107.792 44.365 107.967 44.4325 108.156H44.7419C44.8544 108.156 44.9519 108.237 44.9707 108.349C45.0082 108.574 45.01 108.81 44.9707 109.045C44.9519 109.157 44.8544 109.24 44.7419 109.24H44.4325C44.365 109.429 44.2638 109.603 44.1344 109.753L44.2882 110.022C44.3444 110.119 44.3238 110.245 44.2357 110.316C44.0575 110.464 43.8532 110.582 43.6338 110.665C43.5269 110.704 43.4069 110.663 43.3507 110.563L43.1969 110.295C43.0019 110.331 42.7994 110.331 42.6025 110.295ZM42.4057 109.193C43.1275 109.748 43.9507 108.925 43.3957 108.203C42.6738 107.646 41.8507 108.471 42.4057 109.193ZM40.2438 112.078L40.8757 112.393C41.065 112.502 41.1475 112.733 41.0725 112.939C40.9057 113.393 40.5775 113.809 40.2738 114.173C40.135 114.34 39.895 114.381 39.7057 114.272L39.16 113.957C38.86 114.214 38.5113 114.418 38.1307 114.552V115.182C38.1307 115.399 37.975 115.587 37.7613 115.624C37.3 115.703 36.8163 115.707 36.3382 115.624C36.1225 115.587 35.9632 115.401 35.9632 115.182V114.552C35.5825 114.417 35.2338 114.214 34.9338 113.957L34.3882 114.27C34.2007 114.379 33.9588 114.338 33.82 114.171C33.5163 113.807 33.1957 113.391 33.0288 112.939C32.9538 112.735 33.0363 112.504 33.2257 112.393L33.85 112.078C33.7769 111.687 33.7769 111.283 33.85 110.89L33.2257 110.573C33.0363 110.464 32.9519 110.233 33.0288 110.029C33.1957 109.575 33.5163 109.159 33.82 108.795C33.9588 108.628 34.1988 108.587 34.3882 108.696L34.9338 109.011C35.2338 108.754 35.5825 108.55 35.9632 108.417V107.785C35.9632 107.569 36.1169 107.382 36.3307 107.344C36.7919 107.265 37.2775 107.262 37.7557 107.342C37.9713 107.38 38.1307 107.565 38.1307 107.785V108.415C38.5113 108.55 38.86 108.752 39.16 109.009L39.7057 108.694C39.8932 108.585 40.135 108.627 40.2738 108.793C40.5775 109.157 40.8963 109.573 41.0632 110.027C41.1382 110.232 41.065 110.462 40.8757 110.573L40.2438 110.888C40.3169 111.282 40.3169 111.685 40.2438 112.078ZM38.0388 112.474C39.1488 111.03 37.5007 109.382 36.0569 110.492C34.9469 111.936 36.595 113.584 38.0388 112.474ZM42.6025 115.9L42.4488 116.168C42.3925 116.267 42.2725 116.308 42.1657 116.269C41.9444 116.187 41.7419 116.068 41.5638 115.92C41.4775 115.849 41.455 115.723 41.5113 115.626L41.665 115.358C41.5357 115.208 41.4344 115.033 41.3669 114.844H41.0575C40.945 114.844 40.8475 114.763 40.8288 114.651C40.7913 114.426 40.7894 114.19 40.8288 113.955C40.8475 113.843 40.945 113.76 41.0575 113.76H41.3669C41.4344 113.571 41.5357 113.397 41.665 113.247L41.5113 112.978C41.455 112.881 41.4757 112.755 41.5638 112.684C41.7419 112.536 41.9463 112.418 42.1657 112.335C42.2725 112.296 42.3925 112.337 42.4488 112.437L42.6025 112.705C42.7994 112.669 43 112.669 43.1969 112.705L43.3507 112.437C43.4069 112.337 43.5269 112.296 43.6338 112.335C43.855 112.418 44.0575 112.536 44.2357 112.684C44.3219 112.755 44.3444 112.881 44.2882 112.978L44.1344 113.247C44.2638 113.397 44.365 113.571 44.4325 113.76H44.7419C44.8544 113.76 44.9519 113.841 44.9707 113.953C45.0082 114.178 45.01 114.415 44.9707 114.649C44.9519 114.762 44.8544 114.844 44.7419 114.844H44.4325C44.365 115.033 44.2638 115.208 44.1344 115.358L44.2882 115.626C44.3444 115.723 44.3238 115.849 44.2357 115.92C44.0575 116.068 43.8532 116.187 43.6338 116.269C43.5269 116.308 43.4069 116.267 43.3507 116.168L43.1969 115.9C43.0019 115.935 42.7994 115.935 42.6025 115.9ZM42.4057 114.795C43.1275 115.35 43.9507 114.527 43.3957 113.805C42.6738 113.25 41.8507 114.073 42.4057 114.795Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label"
                      d="M53.192 111.894H52.324V116.486H51.274V106.686H54.102C55.054 106.686 55.768 106.905 56.244 107.344C56.7293 107.773 56.972 108.389 56.972 109.192C56.972 109.752 56.776 110.265 56.384 110.732C56.0013 111.199 55.5253 111.469 54.956 111.544C55.4133 111.647 55.7353 111.796 55.922 111.992C56.118 112.179 56.3467 112.585 56.608 113.21L57.994 116.486H56.888L55.53 113.35C55.278 112.762 54.9933 112.375 54.676 112.188C54.368 111.992 53.8733 111.894 53.192 111.894ZM54.046 107.582H52.324V110.998H53.906C54.4847 110.998 54.942 110.83 55.278 110.494C55.6233 110.149 55.796 109.715 55.796 109.192C55.796 108.669 55.642 108.273 55.334 108.002C55.026 107.722 54.5967 107.582 54.046 107.582ZM64.9875 116.5H59.7095V106.7H64.9875V107.61H60.7595V110.718H64.6375V111.656H60.7595V115.59H64.9875V116.5ZM72.2254 107.05L72.0014 107.988L71.1894 107.75C70.6108 107.61 70.1114 107.54 69.6914 107.54C68.5901 107.54 68.0394 108.03 68.0394 109.01C68.0394 109.439 68.2074 109.794 68.5434 110.074C68.8794 110.345 69.2854 110.564 69.7614 110.732C70.2468 110.891 70.7274 111.068 71.2034 111.264C71.6888 111.451 72.0994 111.745 72.4354 112.146C72.7714 112.538 72.9394 113.037 72.9394 113.644C72.9394 114.568 72.6548 115.291 72.0854 115.814C71.5161 116.327 70.7088 116.584 69.6634 116.584C69.1408 116.584 68.6134 116.509 68.0814 116.36C67.5588 116.201 67.1294 116.019 66.7934 115.814L67.1434 115.016C67.9928 115.408 68.7954 115.604 69.5514 115.604C70.3168 115.604 70.8954 115.45 71.2874 115.142C71.6888 114.834 71.8894 114.386 71.8894 113.798C71.8894 113.201 71.5674 112.734 70.9234 112.398C70.6341 112.249 70.3121 112.109 69.9574 111.978C69.6121 111.847 69.2621 111.707 68.9074 111.558C68.5621 111.399 68.2448 111.222 67.9554 111.026C67.6754 110.83 67.4421 110.564 67.2554 110.228C67.0781 109.892 66.9894 109.5 66.9894 109.052C66.9894 108.249 67.2274 107.633 67.7034 107.204C68.1888 106.775 68.8374 106.56 69.6494 106.56C70.4614 106.56 71.3201 106.723 72.2254 107.05ZM76.7584 116.5V107.638H74.0144V106.7H80.5104V107.638H77.7944V116.5H76.7584ZM90.8411 116.5H85.5631V106.7H90.8411V107.61H86.6131V110.718H90.4911V111.656H86.6131V115.59H90.8411V116.5ZM94.201 110.942V116.5H93.151V109.5H93.823L93.991 110.186C94.2056 110.018 94.3783 109.887 94.509 109.794C94.649 109.701 94.8683 109.607 95.167 109.514C95.4656 109.411 95.783 109.36 96.119 109.36C96.763 109.36 97.295 109.561 97.715 109.962C98.1443 110.354 98.359 110.914 98.359 111.642V116.5H97.309V111.95C97.309 110.821 96.8376 110.256 95.895 110.256C95.223 110.256 94.6583 110.485 94.201 110.942ZM104.893 106.7H105.943V116.5H105.327L104.977 115.702C104.118 116.309 103.372 116.612 102.737 116.612C101.057 116.612 100.217 115.403 100.217 112.986C100.217 111.614 100.516 110.657 101.113 110.116C101.645 109.621 102.247 109.374 102.919 109.374C103.591 109.374 104.249 109.603 104.893 110.06V106.7ZM104.893 114.764V111.124C104.697 110.891 104.436 110.69 104.109 110.522C103.792 110.354 103.498 110.27 103.227 110.27C102.499 110.27 101.99 110.485 101.701 110.914C101.412 111.343 101.267 112.015 101.267 112.93C101.267 113.845 101.412 114.535 101.701 115.002C101.99 115.469 102.359 115.702 102.807 115.702C103.479 115.702 104.174 115.389 104.893 114.764ZM109.541 119.832H108.491V109.514H109.107L109.471 110.298C109.863 109.999 110.227 109.771 110.563 109.612C110.908 109.444 111.286 109.36 111.697 109.36C113.377 109.36 114.217 110.569 114.217 112.986C114.217 114.358 113.918 115.315 113.321 115.856C112.789 116.351 112.182 116.598 111.501 116.598C110.829 116.598 110.175 116.374 109.541 115.926V119.832ZM109.541 111.236V114.974C109.727 115.198 109.979 115.375 110.297 115.506C110.614 115.637 110.917 115.702 111.207 115.702C111.935 115.702 112.443 115.487 112.733 115.058C113.022 114.629 113.167 113.957 113.167 113.042C113.167 112.127 113.022 111.437 112.733 110.97C112.443 110.503 112.075 110.27 111.627 110.27C111.328 110.27 111.029 110.331 110.731 110.452C110.441 110.573 110.222 110.69 110.073 110.802C109.933 110.905 109.755 111.049 109.541 111.236ZM120.459 113.056C120.459 112.151 120.282 111.46 119.927 110.984C119.573 110.508 119.055 110.27 118.373 110.27C117.692 110.27 117.207 110.499 116.917 110.956C116.637 111.404 116.497 112.095 116.497 113.028C116.497 114.792 117.146 115.674 118.443 115.674C119.125 115.674 119.629 115.464 119.955 115.044C120.291 114.615 120.459 113.952 120.459 113.056ZM120.711 115.632C120.179 116.267 119.428 116.584 118.457 116.584C117.487 116.584 116.74 116.271 116.217 115.646C115.704 115.011 115.447 114.129 115.447 113C115.447 111.861 115.695 110.97 116.189 110.326C116.693 109.682 117.426 109.36 118.387 109.36C119.358 109.36 120.119 109.687 120.669 110.34C121.229 110.993 121.509 111.88 121.509 113C121.509 114.12 121.243 114.997 120.711 115.632ZM123.183 116.5V109.5H124.233V116.5H123.183ZM124.233 106.7V107.946H123.183V106.7H124.233ZM127.615 110.942V116.5H126.565V109.5H127.237L127.405 110.186C127.62 110.018 127.792 109.887 127.923 109.794C128.063 109.701 128.282 109.607 128.581 109.514C128.88 109.411 129.197 109.36 129.533 109.36C130.177 109.36 130.709 109.561 131.129 109.962C131.558 110.354 131.773 110.914 131.773 111.642V116.5H130.723V111.95C130.723 110.821 130.252 110.256 129.309 110.256C128.637 110.256 128.072 110.485 127.615 110.942ZM134.485 114.988V110.34H133.533V109.5H134.499V107.498H135.549V109.5H137.257V110.34H135.535V114.792C135.535 115.417 135.852 115.73 136.487 115.73C136.636 115.73 136.865 115.702 137.173 115.646L137.327 116.402C136.944 116.523 136.548 116.584 136.137 116.584C135.736 116.584 135.358 116.463 135.003 116.22C134.658 115.968 134.485 115.557 134.485 114.988ZM138.891 115.254C139.497 115.534 140.076 115.674 140.627 115.674C141.177 115.674 141.593 115.567 141.873 115.352C142.162 115.128 142.307 114.834 142.307 114.47C142.307 114.106 142.185 113.826 141.943 113.63C141.7 113.425 141.401 113.266 141.047 113.154C140.701 113.042 140.351 112.921 139.997 112.79C139.651 112.659 139.357 112.463 139.115 112.202C138.872 111.941 138.751 111.609 138.751 111.208C138.751 110.62 138.942 110.167 139.325 109.85C139.707 109.523 140.225 109.36 140.879 109.36C141.532 109.36 142.139 109.458 142.699 109.654L142.797 109.696L142.615 110.592C142.055 110.377 141.532 110.27 141.047 110.27C140.571 110.27 140.244 110.345 140.067 110.494C139.889 110.643 139.801 110.895 139.801 111.25C139.801 111.474 139.922 111.665 140.165 111.824C140.407 111.983 140.701 112.123 141.047 112.244C141.401 112.356 141.751 112.491 142.097 112.65C142.451 112.799 142.75 113.028 142.993 113.336C143.235 113.644 143.357 114.022 143.357 114.47C143.357 115.123 143.128 115.641 142.671 116.024C142.213 116.397 141.583 116.584 140.781 116.584C139.978 116.584 139.264 116.402 138.639 116.038L138.891 115.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="20.5"
                    y="90"
                    width="146"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_2">
                  <g id="Container_2">
                    <g id="Icon_2">
                      <path
                        id="Vector_2"
                        d="M44.25 159.214V160.286C44.25 161.23 41.8984 162 39 162C36.1016 162 33.75 161.23 33.75 160.286V159.214C33.75 158.27 36.1016 157.5 39 157.5C41.8984 157.5 44.25 158.27 44.25 159.214ZM44.25 161.625V164.036C44.25 164.98 41.8984 165.75 39 165.75C36.1016 165.75 33.75 164.98 33.75 164.036V161.625C34.8779 162.402 36.9424 162.763 39 162.763C41.0576 162.763 43.122 162.402 44.25 161.625ZM44.25 165.375V167.786C44.25 168.73 41.8984 169.5 39 169.5C36.1016 169.5 33.75 168.73 33.75 167.786V165.375C34.8779 166.152 36.9424 166.513 39 166.513C41.0576 166.513 43.122 166.152 44.25 165.375Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_2"
                      d="M58.358 163.25C58.358 164.827 57.9007 166.097 56.986 167.058C56.0713 168.019 54.8487 168.5 53.318 168.5H51.274V158.7H53.752C55.1427 158.7 56.258 159.125 57.098 159.974C57.938 160.823 58.358 161.915 58.358 163.25ZM57.224 163.138C57.224 162.037 56.888 161.173 56.216 160.548C55.544 159.923 54.7413 159.61 53.808 159.61H52.408V167.59H53.444C54.4987 167.59 55.39 167.193 56.118 166.4C56.8553 165.607 57.224 164.519 57.224 163.138ZM63.3625 164.314H63.9365C63.9365 163.465 63.8291 162.914 63.6145 162.662C63.3998 162.401 62.9238 162.27 62.1865 162.27C61.4491 162.27 60.8238 162.368 60.3105 162.564L60.1145 161.752C60.8985 161.491 61.7105 161.36 62.5505 161.36C64.1931 161.36 65.0145 162.181 65.0145 163.824V168.5H64.3985L64.0345 167.674C63.6051 168.029 63.2318 168.271 62.9145 168.402C62.6065 168.523 62.2471 168.584 61.8365 168.584C61.1831 168.584 60.6745 168.393 60.3105 168.01C59.9465 167.618 59.7645 167.105 59.7645 166.47C59.7645 165.033 60.9638 164.314 63.3625 164.314ZM63.9505 165.196H63.3205C62.3685 165.196 61.7105 165.289 61.3465 165.476C60.9918 165.663 60.8145 165.957 60.8145 166.358C60.8145 166.75 60.9171 167.072 61.1225 167.324C61.3278 167.576 61.5938 167.702 61.9205 167.702C62.2565 167.702 62.5738 167.627 62.8725 167.478C63.1805 167.319 63.5398 167.049 63.9505 166.666V165.196ZM67.7252 166.988V162.34H66.7732V161.5H67.7392V159.498H68.7892V161.5H70.4972V162.34H68.7752V166.792C68.7752 167.417 69.0925 167.73 69.7272 167.73C69.8765 167.73 70.1052 167.702 70.4132 167.646L70.5672 168.402C70.1845 168.523 69.7879 168.584 69.3772 168.584C68.9759 168.584 68.5979 168.463 68.2432 168.22C67.8979 167.968 67.7252 167.557 67.7252 166.988ZM75.421 164.314H75.995C75.995 163.465 75.8877 162.914 75.673 162.662C75.4584 162.401 74.9824 162.27 74.245 162.27C73.5077 162.27 72.8824 162.368 72.369 162.564L72.173 161.752C72.957 161.491 73.769 161.36 74.609 161.36C76.2517 161.36 77.073 162.181 77.073 163.824V168.5H76.457L76.093 167.674C75.6637 168.029 75.2904 168.271 74.973 168.402C74.665 168.523 74.3057 168.584 73.895 168.584C73.2417 168.584 72.733 168.393 72.369 168.01C72.005 167.618 71.823 167.105 71.823 166.47C71.823 165.033 73.0224 164.314 75.421 164.314ZM76.009 165.196H75.379C74.427 165.196 73.769 165.289 73.405 165.476C73.0504 165.663 72.873 165.957 72.873 166.358C72.873 166.75 72.9757 167.072 73.181 167.324C73.3864 167.576 73.6524 167.702 73.979 167.702C74.315 167.702 74.6324 167.627 74.931 167.478C75.239 167.319 75.5984 167.049 76.009 166.666V165.196ZM79.6158 158.7H80.6658V162.2C81.4685 161.631 82.1871 161.346 82.8218 161.346C84.5018 161.346 85.3418 162.555 85.3418 164.972C85.3418 166.344 85.0431 167.305 84.4458 167.856C83.9138 168.341 83.2885 168.584 82.5698 168.584C82.2058 168.584 81.8371 168.505 81.4638 168.346C81.0905 168.178 80.7825 168.001 80.5398 167.814L80.2318 168.5H79.6158V158.7ZM80.6658 163.194V167.002C80.8525 167.217 81.0998 167.385 81.4078 167.506C81.7251 167.627 82.0331 167.688 82.3318 167.688C83.0598 167.688 83.5685 167.473 83.8578 167.044C84.1471 166.615 84.2918 165.943 84.2918 165.028C84.2918 164.113 84.1471 163.423 83.8578 162.956C83.5685 162.489 83.1998 162.256 82.7518 162.256C82.0798 162.256 81.3845 162.569 80.6658 163.194ZM90.2824 164.314H90.8564C90.8564 163.465 90.749 162.914 90.5344 162.662C90.3197 162.401 89.8437 162.27 89.1064 162.27C88.369 162.27 87.7437 162.368 87.2304 162.564L87.0344 161.752C87.8184 161.491 88.6304 161.36 89.4704 161.36C91.113 161.36 91.9344 162.181 91.9344 163.824V168.5H91.3184L90.9544 167.674C90.525 168.029 90.1517 168.271 89.8344 168.402C89.5264 168.523 89.167 168.584 88.7564 168.584C88.103 168.584 87.5944 168.393 87.2304 168.01C86.8664 167.618 86.6844 167.105 86.6844 166.47C86.6844 165.033 87.8837 164.314 90.2824 164.314ZM90.8704 165.196H90.2404C89.2884 165.196 88.6304 165.289 88.2664 165.476C87.9117 165.663 87.7344 165.957 87.7344 166.358C87.7344 166.75 87.837 167.072 88.0424 167.324C88.2477 167.576 88.5137 167.702 88.8404 167.702C89.1764 167.702 89.4937 167.627 89.7924 167.478C90.1004 167.319 90.4597 167.049 90.8704 166.666V165.196ZM94.2111 167.254C94.8178 167.534 95.3965 167.674 95.9471 167.674C96.4978 167.674 96.9131 167.567 97.1931 167.352C97.4825 167.128 97.6271 166.834 97.6271 166.47C97.6271 166.106 97.5058 165.826 97.2631 165.63C97.0205 165.425 96.7218 165.266 96.3671 165.154C96.0218 165.042 95.6718 164.921 95.3171 164.79C94.9718 164.659 94.6778 164.463 94.4351 164.202C94.1925 163.941 94.0711 163.609 94.0711 163.208C94.0711 162.62 94.2625 162.167 94.6451 161.85C95.0278 161.523 95.5458 161.36 96.1991 161.36C96.8525 161.36 97.4591 161.458 98.0191 161.654L98.1171 161.696L97.9351 162.592C97.3751 162.377 96.8525 162.27 96.3671 162.27C95.8911 162.27 95.5645 162.345 95.3871 162.494C95.2098 162.643 95.1211 162.895 95.1211 163.25C95.1211 163.474 95.2425 163.665 95.4851 163.824C95.7278 163.983 96.0218 164.123 96.3671 164.244C96.7218 164.356 97.0718 164.491 97.4171 164.65C97.7718 164.799 98.0705 165.028 98.3131 165.336C98.5558 165.644 98.6771 166.022 98.6771 166.47C98.6771 167.123 98.4485 167.641 97.9911 168.024C97.5338 168.397 96.9038 168.584 96.1011 168.584C95.2985 168.584 94.5845 168.402 93.9591 168.038L94.2111 167.254ZM105.433 165.224H100.967C100.967 166.12 101.177 166.755 101.597 167.128C102.026 167.501 102.563 167.688 103.207 167.688C103.533 167.688 103.762 167.674 103.893 167.646C104.023 167.609 104.145 167.576 104.257 167.548C104.378 167.511 104.462 167.483 104.509 167.464C104.742 167.399 104.943 167.338 105.111 167.282L105.279 168.094C104.345 168.421 103.617 168.584 103.095 168.584C102.133 168.584 101.363 168.295 100.785 167.716C100.206 167.128 99.9168 166.251 99.9168 165.084C99.9168 163.908 100.187 162.993 100.729 162.34C101.279 161.687 101.97 161.36 102.801 161.36C103.641 161.36 104.294 161.631 104.761 162.172C105.227 162.713 105.461 163.446 105.461 164.37C105.461 164.622 105.451 164.907 105.433 165.224ZM101.037 164.426H104.453C104.453 163.735 104.331 163.203 104.089 162.83C103.846 162.457 103.421 162.27 102.815 162.27C102.217 162.27 101.779 162.471 101.499 162.872C101.219 163.273 101.065 163.791 101.037 164.426Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="20.5"
                    y="142"
                    width="146"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_3">
                  <g id="Container_3">
                    <g id="Icon_3">
                      <path
                        id="Vector_3"
                        d="M42 210.25C42 210.051 41.921 209.86 41.7803 209.72C41.6397 209.579 41.4489 209.5 41.25 209.5C41.0511 209.5 40.8603 209.579 40.7197 209.72C40.579 209.86 40.5 210.051 40.5 210.25V212.5H42V210.25ZM43.125 213.25H34.875C34.7755 213.25 34.6802 213.29 34.6098 213.36C34.5395 213.43 34.5 213.526 34.5 213.625V214.375C34.5 214.474 34.5395 214.57 34.6098 214.64C34.6802 214.71 34.7755 214.75 34.875 214.75H35.25V215.5C35.2501 216.364 35.5488 217.202 36.0954 217.872C36.642 218.541 37.4031 219.002 38.25 219.175V221.5H39.75V219.175C40.5969 219.002 41.358 218.541 41.9046 217.872C42.4512 217.202 42.7499 216.364 42.75 215.5V214.75H43.125C43.2245 214.75 43.3198 214.71 43.3902 214.64C43.4605 214.57 43.5 214.474 43.5 214.375V213.625C43.5 213.526 43.4605 213.43 43.3902 213.36C43.3198 213.29 43.2245 213.25 43.125 213.25ZM37.5 210.25C37.5 210.051 37.421 209.86 37.2803 209.72C37.1397 209.579 36.9489 209.5 36.75 209.5C36.5511 209.5 36.3603 209.579 36.2197 209.72C36.079 209.86 36 210.051 36 210.25V212.5H37.5V210.25Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_3"
                      d="M55.068 220.584C53.7147 220.584 52.6367 220.127 51.834 219.212C51.0407 218.297 50.644 217.079 50.644 215.558C50.644 214.027 51.022 212.814 51.778 211.918C52.534 211.013 53.5887 210.56 54.942 210.56C55.8007 210.56 56.6733 210.728 57.56 211.064L57.308 211.932C56.9907 211.801 56.5753 211.694 56.062 211.61C55.5487 211.517 55.152 211.47 54.872 211.47C53.892 211.47 53.1173 211.829 52.548 212.548C51.9787 213.267 51.694 214.237 51.694 215.46C51.694 216.683 51.9927 217.691 52.59 218.484C53.1967 219.277 53.9713 219.674 54.914 219.674C55.5767 219.674 56.202 219.581 56.79 219.394V216.44H54.746V215.53H57.84V219.828C56.9627 220.332 56.0387 220.584 55.068 220.584ZM61.3748 215.152V220.5H60.3248V213.5H60.9968L61.1648 214.326C61.6128 213.971 61.9861 213.724 62.2848 213.584C62.5834 213.435 62.9241 213.36 63.3068 213.36C63.4934 213.36 63.6334 213.369 63.7268 213.388L63.9228 213.444L63.7548 214.41C63.5868 214.354 63.3581 214.326 63.0688 214.326C62.5088 214.326 61.9441 214.601 61.3748 215.152ZM68.5441 216.314H69.1181C69.1181 215.465 69.0108 214.914 68.7961 214.662C68.5814 214.401 68.1054 214.27 67.3681 214.27C66.6308 214.27 66.0054 214.368 65.4921 214.564L65.2961 213.752C66.0801 213.491 66.8921 213.36 67.7321 213.36C69.3748 213.36 70.1961 214.181 70.1961 215.824V220.5H69.5801L69.2161 219.674C68.7868 220.029 68.4134 220.271 68.0961 220.402C67.7881 220.523 67.4288 220.584 67.0181 220.584C66.3648 220.584 65.8561 220.393 65.4921 220.01C65.1281 219.618 64.9461 219.105 64.9461 218.47C64.9461 217.033 66.1454 216.314 68.5441 216.314ZM69.1321 217.196H68.5021C67.5501 217.196 66.8921 217.289 66.5281 217.476C66.1734 217.663 65.9961 217.957 65.9961 218.358C65.9961 218.75 66.0988 219.072 66.3041 219.324C66.5094 219.576 66.7754 219.702 67.1021 219.702C67.4381 219.702 67.7554 219.627 68.0541 219.478C68.3621 219.319 68.7214 219.049 69.1321 218.666V217.196ZM73.7888 223.832H72.7388V213.514H73.3548L73.7188 214.298C74.1108 213.999 74.4748 213.771 74.8108 213.612C75.1562 213.444 75.5342 213.36 75.9448 213.36C77.6248 213.36 78.4648 214.569 78.4648 216.986C78.4648 218.358 78.1662 219.315 77.5688 219.856C77.0368 220.351 76.4302 220.598 75.7488 220.598C75.0768 220.598 74.4235 220.374 73.7888 219.926V223.832ZM73.7888 215.236V218.974C73.9755 219.198 74.2275 219.375 74.5448 219.506C74.8622 219.637 75.1655 219.702 75.4548 219.702C76.1828 219.702 76.6915 219.487 76.9808 219.058C77.2702 218.629 77.4148 217.957 77.4148 217.042C77.4148 216.127 77.2702 215.437 76.9808 214.97C76.6915 214.503 76.3228 214.27 75.8748 214.27C75.5762 214.27 75.2775 214.331 74.9788 214.452C74.6895 214.573 74.4702 214.69 74.3208 214.802C74.1808 214.905 74.0035 215.049 73.7888 215.236ZM85.6174 220.5H84.5674V215.894C84.5674 214.765 84.0961 214.2 83.1534 214.2C82.4534 214.2 81.8794 214.424 81.4314 214.872V220.5H80.3814V210.7H81.4174V214.018C81.6228 213.85 81.7814 213.729 81.8934 213.654C82.0148 213.579 82.2061 213.505 82.4674 213.43C82.7381 213.355 83.0414 213.318 83.3774 213.318C84.0214 213.318 84.5534 213.514 84.9734 213.906C85.4028 214.298 85.6174 214.858 85.6174 215.586V220.5ZM94.3487 219.156L95.7207 220.57L95.0347 221.256L93.7047 219.842C93.0794 220.346 92.3234 220.598 91.4367 220.598C90.5594 220.598 89.8221 220.36 89.2247 219.884C88.0954 218.997 87.5307 217.546 87.5307 215.53C87.5307 214.065 87.8574 212.87 88.5107 211.946C89.1734 211.022 90.1394 210.56 91.4087 210.56C92.6874 210.56 93.6581 211.022 94.3207 211.946C94.9834 212.87 95.3147 214.079 95.3147 215.572C95.3147 217.065 94.9927 218.26 94.3487 219.156ZM92.4727 217.168L93.6207 218.414C94.0501 217.705 94.2647 216.767 94.2647 215.6C94.2647 214.424 94.0127 213.439 93.5087 212.646C93.0141 211.853 92.3187 211.456 91.4227 211.456C90.9281 211.456 90.4894 211.573 90.1067 211.806C89.7334 212.039 89.4394 212.352 89.2247 212.744C88.8047 213.528 88.5947 214.485 88.5947 215.614C88.5947 216.734 88.8327 217.691 89.3087 218.484C89.7941 219.277 90.4987 219.674 91.4227 219.674C92.0387 219.674 92.5661 219.497 93.0047 219.142L91.7727 217.854L92.4727 217.168ZM102.53 220.5H97.2799V210.7H98.3299V219.59H102.53V220.5ZM112.325 211.05L112.101 211.988L111.289 211.75C110.71 211.61 110.211 211.54 109.791 211.54C108.69 211.54 108.139 212.03 108.139 213.01C108.139 213.439 108.307 213.794 108.643 214.074C108.979 214.345 109.385 214.564 109.861 214.732C110.346 214.891 110.827 215.068 111.303 215.264C111.788 215.451 112.199 215.745 112.535 216.146C112.871 216.538 113.039 217.037 113.039 217.644C113.039 218.568 112.754 219.291 112.185 219.814C111.616 220.327 110.808 220.584 109.763 220.584C109.24 220.584 108.713 220.509 108.181 220.36C107.658 220.201 107.229 220.019 106.893 219.814L107.243 219.016C108.092 219.408 108.895 219.604 109.651 219.604C110.416 219.604 110.995 219.45 111.387 219.142C111.788 218.834 111.989 218.386 111.989 217.798C111.989 217.201 111.667 216.734 111.023 216.398C110.734 216.249 110.412 216.109 110.057 215.978C109.712 215.847 109.362 215.707 109.007 215.558C108.662 215.399 108.344 215.222 108.055 215.026C107.775 214.83 107.542 214.564 107.355 214.228C107.178 213.892 107.089 213.5 107.089 213.052C107.089 212.249 107.327 211.633 107.803 211.204C108.288 210.775 108.937 210.56 109.749 210.56C110.561 210.56 111.42 210.723 112.325 211.05ZM119.966 217.224H115.5C115.5 218.12 115.71 218.755 116.13 219.128C116.559 219.501 117.096 219.688 117.74 219.688C118.067 219.688 118.295 219.674 118.426 219.646C118.557 219.609 118.678 219.576 118.79 219.548C118.911 219.511 118.995 219.483 119.042 219.464C119.275 219.399 119.476 219.338 119.644 219.282L119.812 220.094C118.879 220.421 118.151 220.584 117.628 220.584C116.667 220.584 115.897 220.295 115.318 219.716C114.739 219.128 114.45 218.251 114.45 217.084C114.45 215.908 114.721 214.993 115.262 214.34C115.813 213.687 116.503 213.36 117.334 213.36C118.174 213.36 118.827 213.631 119.294 214.172C119.761 214.713 119.994 215.446 119.994 216.37C119.994 216.622 119.985 216.907 119.966 217.224ZM115.57 216.426H118.986C118.986 215.735 118.865 215.203 118.622 214.83C118.379 214.457 117.955 214.27 117.348 214.27C116.751 214.27 116.312 214.471 116.032 214.872C115.752 215.273 115.598 215.791 115.57 216.426ZM123.008 215.152V220.5H121.958V213.5H122.63L122.798 214.326C123.246 213.971 123.619 213.724 123.918 213.584C124.216 213.435 124.557 213.36 124.94 213.36C125.126 213.36 125.266 213.369 125.36 213.388L125.556 213.444L125.388 214.41C125.22 214.354 124.991 214.326 124.702 214.326C124.142 214.326 123.577 214.601 123.008 215.152ZM131.955 213.486L129.589 220.5H128.385L126.033 213.486H127.223L129.001 219.38L130.793 213.486H131.955ZM133.191 220.5V213.5H134.241V220.5H133.191ZM134.241 210.7V211.946H133.191V210.7H134.241ZM140.689 219.408L140.899 220.234C140.152 220.458 139.494 220.57 138.925 220.57C137.926 220.57 137.175 220.243 136.671 219.59C136.167 218.937 135.915 218.036 135.915 216.888C135.915 215.74 136.176 214.867 136.699 214.27C137.221 213.663 137.991 213.36 139.009 213.36C139.447 213.36 140.063 213.472 140.857 213.696L140.437 214.508C139.923 214.359 139.461 214.284 139.051 214.284C138.341 214.284 137.828 214.494 137.511 214.914C137.203 215.334 137.049 215.997 137.049 216.902C137.049 218.741 137.707 219.66 139.023 219.66C139.545 219.66 140.101 219.576 140.689 219.408ZM147.487 217.224H143.021C143.021 218.12 143.231 218.755 143.651 219.128C144.081 219.501 144.617 219.688 145.261 219.688C145.588 219.688 145.817 219.674 145.947 219.646C146.078 219.609 146.199 219.576 146.311 219.548C146.433 219.511 146.517 219.483 146.563 219.464C146.797 219.399 146.997 219.338 147.165 219.282L147.333 220.094C146.4 220.421 145.672 220.584 145.149 220.584C144.188 220.584 143.418 220.295 142.839 219.716C142.261 219.128 141.971 218.251 141.971 217.084C141.971 215.908 142.242 214.993 142.783 214.34C143.334 213.687 144.025 213.36 144.855 213.36C145.695 213.36 146.349 213.631 146.815 214.172C147.282 214.713 147.515 215.446 147.515 216.37C147.515 216.622 147.506 216.907 147.487 217.224ZM143.091 216.426H146.507C146.507 215.735 146.386 215.203 146.143 214.83C145.901 214.457 145.476 214.27 144.869 214.27C144.272 214.27 143.833 214.471 143.553 214.872C143.273 215.273 143.119 215.791 143.091 216.426ZM149.213 219.254C149.82 219.534 150.398 219.674 150.949 219.674C151.5 219.674 151.915 219.567 152.195 219.352C152.484 219.128 152.629 218.834 152.629 218.47C152.629 218.106 152.508 217.826 152.265 217.63C152.022 217.425 151.724 217.266 151.369 217.154C151.024 217.042 150.674 216.921 150.319 216.79C149.974 216.659 149.68 216.463 149.437 216.202C149.194 215.941 149.073 215.609 149.073 215.208C149.073 214.62 149.264 214.167 149.647 213.85C150.03 213.523 150.548 213.36 151.201 213.36C151.854 213.36 152.461 213.458 153.021 213.654L153.119 213.696L152.937 214.592C152.377 214.377 151.854 214.27 151.369 214.27C150.893 214.27 150.566 214.345 150.389 214.494C150.212 214.643 150.123 214.895 150.123 215.25C150.123 215.474 150.244 215.665 150.487 215.824C150.73 215.983 151.024 216.123 151.369 216.244C151.724 216.356 152.074 216.491 152.419 216.65C152.774 216.799 153.072 217.028 153.315 217.336C153.558 217.644 153.679 218.022 153.679 218.47C153.679 219.123 153.45 219.641 152.993 220.024C152.536 220.397 151.906 220.584 151.103 220.584C150.3 220.584 149.586 220.402 148.961 220.038L149.213 219.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="20.5"
                    y="194"
                    width="146"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
              </g>
              <g id="SchemaGrouper">
                <g id="Borders">
                  <mask id="path-12-inside-1_190_9079" fill="white">
                    <path d="M179 65.5H195V237.5H179V65.5Z" />
                  </mask>
                  <path
                    d="M195 65.5H196V64.5H195V65.5ZM195 237.5V238.5H196V237.5H195ZM179 66.5H195V64.5H179V66.5ZM194 65.5V237.5H196V65.5H194ZM195 236.5H179V238.5H195V236.5Z"
                    fill="#94A3B8"
                    mask="url(#path-12-inside-1_190_9079)"
                  />
                </g>
              </g>
            </g>
            <g id="SchemaArrowWithLabel">
              <g id="Horizontal">
                <g id="Arrow left">
                  <g id="SchemaArrow">
                    <rect
                      id="Line"
                      x="195"
                      y="169"
                      width="15"
                      height="1"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
                <g id="SchemaArrowLabel">
                  <g id="Icon_4">
                    <path
                      id="Vector_4"
                      d="M225.655 167.845C227.055 169.247 227.036 171.494 225.663 172.875C225.661 172.877 225.658 172.88 225.655 172.883L224.08 174.458C222.691 175.847 220.431 175.847 219.042 174.458C217.653 173.069 217.653 170.809 219.042 169.42L219.912 168.55C220.142 168.32 220.539 168.473 220.551 168.799C220.566 169.214 220.641 169.632 220.778 170.035C220.825 170.171 220.792 170.322 220.69 170.424L220.383 170.731C219.726 171.388 219.705 172.457 220.356 173.12C221.013 173.79 222.092 173.794 222.754 173.132L224.329 171.558C224.99 170.897 224.987 169.829 224.329 169.171C224.242 169.084 224.155 169.017 224.087 168.97C224.038 168.937 223.999 168.893 223.97 168.842C223.942 168.79 223.926 168.733 223.924 168.675C223.915 168.427 224.002 168.172 224.198 167.976L224.692 167.483C224.821 167.353 225.024 167.337 225.174 167.442C225.346 167.562 225.507 167.697 225.655 167.845ZM228.958 164.542C227.569 163.153 225.309 163.153 223.92 164.542L222.345 166.117C222.342 166.12 222.339 166.123 222.337 166.125C220.964 167.506 220.945 169.753 222.345 171.155C222.493 171.303 222.654 171.438 222.826 171.558C222.976 171.663 223.179 171.647 223.308 171.517L223.802 171.024C223.998 170.828 224.085 170.573 224.076 170.325C224.074 170.267 224.058 170.21 224.03 170.158C224.001 170.107 223.962 170.063 223.913 170.03C223.845 169.983 223.758 169.916 223.671 169.829C223.013 169.171 223.01 168.103 223.671 167.442L225.246 165.868C225.908 165.206 226.987 165.21 227.644 165.88C228.294 166.543 228.274 167.612 227.617 168.269L227.31 168.576C227.208 168.678 227.175 168.829 227.222 168.965C227.359 169.368 227.434 169.786 227.449 170.201C227.461 170.527 227.858 170.68 228.088 170.45L228.958 169.58C230.347 168.191 230.347 165.931 228.958 164.542Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_4"
                    d="M238.152 173.572C237.008 173.572 236.128 173.188 235.512 172.42C234.904 171.644 234.6 170.596 234.6 169.276C234.6 167.956 234.924 166.912 235.572 166.144C236.22 165.376 237.124 164.992 238.284 164.992C238.924 164.992 239.552 165.108 240.168 165.34L239.952 166.084C239.464 165.876 238.888 165.772 238.224 165.772C237.384 165.772 236.72 166.08 236.232 166.696C235.744 167.304 235.5 168.144 235.5 169.216C235.5 170.28 235.728 171.144 236.184 171.808C236.648 172.464 237.292 172.792 238.116 172.792C238.66 172.792 239.344 172.636 240.168 172.324L240.408 172.948C239.72 173.364 238.968 173.572 238.152 173.572ZM245.808 170.548C245.808 169.772 245.656 169.18 245.352 168.772C245.048 168.364 244.604 168.16 244.02 168.16C243.436 168.16 243.02 168.356 242.772 168.748C242.532 169.132 242.412 169.724 242.412 170.524C242.412 172.036 242.968 172.792 244.08 172.792C244.664 172.792 245.096 172.612 245.376 172.252C245.664 171.884 245.808 171.316 245.808 170.548ZM246.024 172.756C245.568 173.3 244.924 173.572 244.092 173.572C243.26 173.572 242.62 173.304 242.172 172.768C241.732 172.224 241.512 171.468 241.512 170.5C241.512 169.524 241.724 168.76 242.148 168.208C242.58 167.656 243.208 167.38 244.032 167.38C244.864 167.38 245.516 167.66 245.988 168.22C246.468 168.78 246.708 169.54 246.708 170.5C246.708 171.46 246.48 172.212 246.024 172.756ZM249.211 168.736V173.5H248.311V167.5H248.887L249.031 168.088C249.215 167.944 249.363 167.832 249.475 167.752C249.595 167.672 249.783 167.592 250.039 167.512C250.295 167.424 250.567 167.38 250.855 167.38C251.407 167.38 251.863 167.552 252.223 167.896C252.591 168.232 252.775 168.712 252.775 169.336V173.5H251.875V169.6C251.875 168.632 251.471 168.148 250.663 168.148C250.087 168.148 249.603 168.344 249.211 168.736ZM255.855 168.736V173.5H254.955V167.5H255.531L255.675 168.088C255.859 167.944 256.007 167.832 256.119 167.752C256.239 167.672 256.427 167.592 256.683 167.512C256.939 167.424 257.211 167.38 257.499 167.38C258.051 167.38 258.507 167.552 258.867 167.896C259.235 168.232 259.419 168.712 259.419 169.336V173.5H258.519V169.6C258.519 168.632 258.115 168.148 257.307 168.148C256.731 168.148 256.247 168.344 255.855 168.736ZM265.764 170.692H261.936C261.936 171.46 262.116 172.004 262.476 172.324C262.844 172.644 263.304 172.804 263.856 172.804C264.136 172.804 264.332 172.792 264.444 172.768C264.556 172.736 264.66 172.708 264.756 172.684C264.86 172.652 264.932 172.628 264.972 172.612C265.172 172.556 265.344 172.504 265.488 172.456L265.632 173.152C264.832 173.432 264.208 173.572 263.76 173.572C262.936 173.572 262.276 173.324 261.78 172.828C261.284 172.324 261.036 171.572 261.036 170.572C261.036 169.564 261.268 168.78 261.732 168.22C262.204 167.66 262.796 167.38 263.508 167.38C264.228 167.38 264.788 167.612 265.188 168.076C265.588 168.54 265.788 169.168 265.788 169.96C265.788 170.176 265.78 170.42 265.764 170.692ZM261.996 170.008H264.924C264.924 169.416 264.82 168.96 264.612 168.64C264.404 168.32 264.04 168.16 263.52 168.16C263.008 168.16 262.632 168.332 262.392 168.676C262.152 169.02 262.02 169.464 261.996 170.008ZM270.999 172.564L271.179 173.272C270.539 173.464 269.975 173.56 269.487 173.56C268.631 173.56 267.987 173.28 267.555 172.72C267.123 172.16 266.907 171.388 266.907 170.404C266.907 169.42 267.131 168.672 267.579 168.16C268.027 167.64 268.687 167.38 269.559 167.38C269.935 167.38 270.463 167.476 271.143 167.668L270.783 168.364C270.343 168.236 269.947 168.172 269.595 168.172C268.987 168.172 268.547 168.352 268.275 168.712C268.011 169.072 267.879 169.64 267.879 170.416C267.879 171.992 268.443 172.78 269.571 172.78C270.019 172.78 270.495 172.708 270.999 172.564ZM272.806 172.204V168.22H271.99V167.5H272.818V165.784H273.718V167.5H275.182V168.22H273.706V172.036C273.706 172.572 273.978 172.84 274.522 172.84C274.65 172.84 274.846 172.816 275.11 172.768L275.242 173.416C274.914 173.52 274.574 173.572 274.222 173.572C273.878 173.572 273.554 173.468 273.25 173.26C272.954 173.044 272.806 172.692 272.806 172.204ZM280.975 170.692H277.147C277.147 171.46 277.327 172.004 277.687 172.324C278.055 172.644 278.515 172.804 279.067 172.804C279.347 172.804 279.543 172.792 279.655 172.768C279.767 172.736 279.871 172.708 279.967 172.684C280.071 172.652 280.143 172.628 280.183 172.612C280.383 172.556 280.555 172.504 280.699 172.456L280.843 173.152C280.043 173.432 279.419 173.572 278.971 173.572C278.147 173.572 277.487 173.324 276.991 172.828C276.495 172.324 276.247 171.572 276.247 170.572C276.247 169.564 276.479 168.78 276.943 168.22C277.415 167.66 278.007 167.38 278.719 167.38C279.439 167.38 279.999 167.612 280.399 168.076C280.799 168.54 280.999 169.168 280.999 169.96C280.999 170.176 280.991 170.42 280.975 170.692ZM277.207 170.008H280.135C280.135 169.416 280.031 168.96 279.823 168.64C279.615 168.32 279.251 168.16 278.731 168.16C278.219 168.16 277.843 168.332 277.603 168.676C277.363 169.02 277.231 169.464 277.207 170.008ZM286.102 165.1H287.002V173.5H286.474L286.174 172.816C285.438 173.336 284.798 173.596 284.254 173.596C282.814 173.596 282.094 172.56 282.094 170.488C282.094 169.312 282.35 168.492 282.862 168.028C283.318 167.604 283.834 167.392 284.41 167.392C284.986 167.392 285.55 167.588 286.102 167.98V165.1ZM286.102 172.012V168.892C285.934 168.692 285.71 168.52 285.43 168.376C285.158 168.232 284.906 168.16 284.674 168.16C284.05 168.16 283.614 168.344 283.366 168.712C283.118 169.08 282.994 169.656 282.994 170.44C282.994 171.224 283.118 171.816 283.366 172.216C283.614 172.616 283.93 172.816 284.314 172.816C284.89 172.816 285.486 172.548 286.102 172.012Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="Arrow right">
                  <g id="SchemaArrow_2">
                    <rect
                      id="Line_2"
                      x="297"
                      y="169"
                      width="10.5"
                      height="1"
                      fill="#94A3B8"
                    />
                    <path
                      id="Vector_5"
                      d="M307.92 174L307.5 173.69V165.295L307.905 165L312 169.22V169.841L307.92 174Z"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
          <g id="Col3">
            <g id="SchemaCard_4" filter="url(#filter0_d_190_9079)">
              <g clipPath="url(#clip0_190_9079)">
                <rect
                  x="312"
                  y="21.5"
                  width="200"
                  height="44"
                  rx="4"
                  fill="white"
                />
                <g id="Container_4">
                  <g id="Icon_5">
                    <path
                      id="Vector_6"
                      d="M331 37.5C327.686 37.5 325 40.1862 325 43.4999C325 46.8136 327.686 49.5 331 49.5C334.314 49.5 337 46.8136 337 43.4999C337 40.1862 334.314 37.5 331 37.5ZM331 48.7296C330.057 48.7296 329.293 48.0998 329.293 47.3231H332.707C332.707 48.0997 331.943 48.7296 331 48.7296ZM333.82 46.8573H328.18V45.8347H333.82V46.8573H333.82ZM333.799 45.3083H328.196C328.178 45.2869 328.158 45.2657 328.14 45.2439C327.563 44.5429 327.427 44.177 327.295 43.804C327.293 43.7918 327.995 43.9475 328.493 44.0595C328.493 44.0595 328.749 44.1188 329.124 44.1871C328.764 43.7655 328.551 43.2295 328.551 42.6817C328.551 41.4789 329.473 40.4279 329.14 39.5784C329.464 39.6048 329.811 40.262 329.834 41.2896C330.179 40.8138 330.323 39.9448 330.323 39.412C330.323 38.8603 330.686 38.2195 331.05 38.1976C330.726 38.7318 331.134 39.1897 331.496 40.3257C331.632 40.7525 331.615 41.4706 331.72 41.926C331.755 40.9801 331.918 39.6 332.518 39.1235C332.253 39.7236 332.557 40.4744 332.765 40.8354C333.1 41.4177 333.303 41.8589 333.303 42.6934C333.303 43.2529 333.097 43.7797 332.748 44.1915C333.144 44.1171 333.418 44.0501 333.418 44.0501L334.705 43.7991C334.705 43.799 334.518 44.5679 333.799 45.3083Z"
                      fill="#EA580C"
                    />
                  </g>
                  <path
                    id="Card label_5"
                    d="M345.752 44.734H345.024V48.5H342.994V38.7H346.074C347.222 38.7 348.053 38.9473 348.566 39.442C349.079 39.9273 349.336 40.6833 349.336 41.71C349.336 42.7273 349.019 43.488 348.384 43.992C347.759 44.4867 346.881 44.734 345.752 44.734ZM345.598 40.296H345.024V43.138H345.248C345.957 43.138 346.475 43.0307 346.802 42.816C347.138 42.6013 347.306 42.242 347.306 41.738C347.306 41.2247 347.171 40.856 346.9 40.632C346.629 40.408 346.195 40.296 345.598 40.296ZM352.542 43.852V48.5H350.708V41.5H352.164L352.332 42.186C352.706 41.8873 353.018 41.6773 353.27 41.556C353.522 41.4253 353.742 41.36 353.928 41.36C354.124 41.36 354.255 41.3647 354.32 41.374C354.386 41.374 354.442 41.3787 354.488 41.388C354.535 41.3973 354.614 41.416 354.726 41.444L354.558 43.11C354.39 43.054 354.162 43.026 353.872 43.026C353.48 43.026 353.037 43.3013 352.542 43.852ZM361.959 45.014C361.959 46.134 361.674 47.0113 361.105 47.646C360.536 48.2807 359.728 48.598 358.683 48.598C357.638 48.598 356.844 48.2807 356.303 47.646C355.762 47.0113 355.491 46.1293 355.491 45C355.491 43.8707 355.762 42.984 356.303 42.34C356.844 41.6867 357.624 41.36 358.641 41.36C359.658 41.36 360.466 41.6913 361.063 42.354C361.66 43.0073 361.959 43.894 361.959 45.014ZM360.097 44.986C360.097 43.558 359.64 42.844 358.725 42.844C357.792 42.844 357.325 43.5533 357.325 44.972C357.325 46.3907 357.796 47.1 358.739 47.1C359.243 47.1 359.593 46.9227 359.789 46.568C359.994 46.204 360.097 45.6767 360.097 44.986ZM365.394 48.5H363.56V41.5H365.1L365.338 42.13C365.739 41.8313 366.084 41.6307 366.374 41.528C366.672 41.416 367.018 41.36 367.41 41.36C368.119 41.36 368.637 41.682 368.964 42.326C369.486 41.9433 369.906 41.6867 370.224 41.556C370.55 41.4253 370.905 41.36 371.288 41.36C371.866 41.36 372.324 41.5747 372.66 42.004C372.996 42.424 373.164 43.0447 373.164 43.866V48.5H371.33V44.356C371.33 43.4973 371.073 43.068 370.56 43.068C370.177 43.068 369.738 43.2827 369.244 43.712V48.5H367.424V44.356C367.424 43.4973 367.172 43.068 366.668 43.068C366.294 43.068 365.87 43.2687 365.394 43.67V48.5ZM380.523 48.066C379.636 48.4113 378.815 48.584 378.059 48.584C375.866 48.584 374.769 47.3987 374.769 45.028C374.769 43.824 375.035 42.914 375.567 42.298C376.099 41.6727 376.874 41.36 377.891 41.36C378.731 41.36 379.403 41.6213 379.907 42.144C380.411 42.6667 380.663 43.4413 380.663 44.468C380.663 44.8787 380.644 45.238 380.607 45.546H376.561C376.561 46.0967 376.71 46.5027 377.009 46.764C377.308 47.0253 377.709 47.156 378.213 47.156C378.717 47.156 379.384 47.044 380.215 46.82L380.523 48.066ZM378.913 44.258V44.16C378.913 43.7307 378.82 43.3853 378.633 43.124C378.446 42.8627 378.152 42.732 377.751 42.732C377.35 42.732 377.051 42.8767 376.855 43.166C376.659 43.4553 376.556 43.8193 376.547 44.258H378.913ZM382.289 46.988V43.04H381.575V41.5H382.303V39.498H384.109V41.5H385.579V43.04H384.095V46.092C384.095 46.7173 384.286 47.03 384.669 47.03C384.883 47.03 385.112 47.002 385.355 46.946L385.649 48.402C385.219 48.5233 384.762 48.584 384.277 48.584C383.801 48.584 383.348 48.4627 382.919 48.22C382.499 47.968 382.289 47.5573 382.289 46.988ZM393.12 48.5H391.3V44.314C391.3 43.9313 391.226 43.6233 391.076 43.39C390.927 43.1473 390.675 43.026 390.32 43.026C389.966 43.026 389.532 43.2407 389.018 43.67V48.5H387.198V38.7H389.018V42.13C389.42 41.8313 389.765 41.6307 390.054 41.528C390.353 41.416 390.698 41.36 391.09 41.36C391.716 41.36 392.21 41.57 392.574 41.99C392.938 42.4007 393.12 43.012 393.12 43.824V48.5ZM400.484 48.066C399.597 48.4113 398.776 48.584 398.02 48.584C395.827 48.584 394.73 47.3987 394.73 45.028C394.73 43.824 394.996 42.914 395.528 42.298C396.06 41.6727 396.835 41.36 397.852 41.36C398.692 41.36 399.364 41.6213 399.868 42.144C400.372 42.6667 400.624 43.4413 400.624 44.468C400.624 44.8787 400.605 45.238 400.568 45.546H396.522C396.522 46.0967 396.671 46.5027 396.97 46.764C397.269 47.0253 397.67 47.156 398.174 47.156C398.678 47.156 399.345 47.044 400.176 46.82L400.484 48.066ZM398.874 44.258V44.16C398.874 43.7307 398.781 43.3853 398.594 43.124C398.407 42.8627 398.113 42.732 397.712 42.732C397.311 42.732 397.012 42.8767 396.816 43.166C396.62 43.4553 396.517 43.8193 396.508 44.258H398.874ZM402.18 41.5H404.028V45.784C404.028 46.1667 404.102 46.4793 404.252 46.722C404.401 46.9553 404.648 47.072 404.994 47.072C405.339 47.072 405.768 46.8573 406.282 46.428V41.5H408.116V48.5H406.576L406.282 47.828C405.88 48.1267 405.53 48.3273 405.232 48.43C404.942 48.5327 404.602 48.584 404.21 48.584C403.584 48.584 403.09 48.3787 402.726 47.968C402.362 47.5573 402.18 46.946 402.18 46.134V41.5ZM410.26 46.638C410.885 46.9553 411.525 47.114 412.178 47.114C412.841 47.114 413.172 46.8713 413.172 46.386C413.172 45.938 412.799 45.6067 412.052 45.392C411.735 45.308 411.417 45.21 411.1 45.098C410.792 44.9767 410.526 44.7853 410.302 44.524C410.087 44.2533 409.98 43.908 409.98 43.488C409.98 42.8067 410.19 42.284 410.61 41.92C411.03 41.5467 411.613 41.36 412.36 41.36C413.116 41.36 413.83 41.4907 414.502 41.752L414.208 43.208C413.592 42.956 412.99 42.83 412.402 42.83C411.991 42.83 411.786 42.97 411.786 43.25C411.786 43.5393 412.061 43.7587 412.612 43.908C413.191 44.0573 413.704 44.272 414.152 44.552C414.385 44.692 414.581 44.902 414.74 45.182C414.899 45.462 414.978 45.798 414.978 46.19C414.978 46.9273 414.731 47.5107 414.236 47.94C413.741 48.3693 413.06 48.584 412.192 48.584C411.324 48.584 410.549 48.3833 409.868 47.982L410.26 46.638Z"
                    fill="#0F172A"
                  />
                </g>
              </g>
              <rect
                x="312.5"
                y="22"
                width="199"
                height="43"
                rx="3.5"
                stroke="#FBBF24"
              />
            </g>
            <g id="SchemaArrowWithLabel_2">
              <g id="Arrow top">
                <g id="SchemaArrow_3">
                  <path
                    id="Vector_7"
                    d="M416.5 69.58L416.19 70H407.795L407.5 69.595L411.72 65.5H412.341L416.5 69.58Z"
                    fill="#94A3B8"
                  />
                  <rect
                    id="Line_3"
                    x="412.5"
                    y="70"
                    width="17.5"
                    height="1"
                    transform="rotate(90 412.5 70)"
                    fill="#94A3B8"
                  />
                </g>
              </g>
              <g id="Horizontal_2">
                <g id="SchemaArrowLabel_2">
                  <g id="Icon_6">
                    <path
                      id="Vector_8"
                      d="M376.75 100.688V97.5H372.062C371.751 97.5 371.5 97.7508 371.5 98.0625V108.938C371.5 109.249 371.751 109.5 372.062 109.5H379.938C380.249 109.5 380.5 109.249 380.5 108.938V101.25H377.312C377.003 101.25 376.75 100.997 376.75 100.688ZM378.542 105.641L376.282 107.884C376.126 108.039 375.874 108.039 375.719 107.884L373.459 105.641C373.221 105.405 373.388 105 373.722 105H375.25V103.125C375.25 102.918 375.418 102.75 375.625 102.75H376.375C376.582 102.75 376.75 102.918 376.75 103.125V105H378.278C378.612 105 378.779 105.405 378.542 105.641ZM380.336 99.9609L378.041 97.6641C377.936 97.5586 377.793 97.5 377.643 97.5H377.5V100.5H380.5V100.357C380.5 100.209 380.441 100.066 380.336 99.9609Z"
                      fill="#475569"
                    />
                  </g>
                  <path
                    id="Card label_6"
                    d="M387.992 107.5H387.092V99.1H387.992V107.5ZM391.074 102.736V107.5H390.174V101.5H390.75L390.894 102.088C391.078 101.944 391.226 101.832 391.338 101.752C391.458 101.672 391.646 101.592 391.902 101.512C392.158 101.424 392.43 101.38 392.718 101.38C393.27 101.38 393.726 101.552 394.086 101.896C394.454 102.232 394.638 102.712 394.638 103.336V107.5H393.738V103.6C393.738 102.632 393.334 102.148 392.526 102.148C391.95 102.148 391.466 102.344 391.074 102.736ZM397.479 99.1V100.156H396.579V99.1H397.479ZM396.087 109.948C396.415 109.524 396.579 108.844 396.579 107.908V101.5H397.479V107.62C397.479 108.308 397.411 108.856 397.275 109.264C397.147 109.672 396.927 110.04 396.615 110.368L396.087 109.948ZM403.643 104.692H399.815C399.815 105.46 399.995 106.004 400.355 106.324C400.723 106.644 401.183 106.804 401.735 106.804C402.015 106.804 402.211 106.792 402.323 106.768C402.435 106.736 402.539 106.708 402.635 106.684C402.739 106.652 402.811 106.628 402.851 106.612C403.051 106.556 403.223 106.504 403.367 106.456L403.511 107.152C402.711 107.432 402.087 107.572 401.639 107.572C400.815 107.572 400.155 107.324 399.659 106.828C399.163 106.324 398.915 105.572 398.915 104.572C398.915 103.564 399.147 102.78 399.611 102.22C400.083 101.66 400.675 101.38 401.387 101.38C402.107 101.38 402.667 101.612 403.067 102.076C403.467 102.54 403.667 103.168 403.667 103.96C403.667 104.176 403.659 104.42 403.643 104.692ZM399.875 104.008H402.803C402.803 103.416 402.699 102.96 402.491 102.64C402.283 102.32 401.919 102.16 401.399 102.16C400.887 102.16 400.511 102.332 400.271 102.676C400.031 103.02 399.899 103.464 399.875 104.008ZM408.878 106.564L409.058 107.272C408.418 107.464 407.854 107.56 407.366 107.56C406.51 107.56 405.866 107.28 405.434 106.72C405.002 106.16 404.786 105.388 404.786 104.404C404.786 103.42 405.01 102.672 405.458 102.16C405.906 101.64 406.566 101.38 407.438 101.38C407.814 101.38 408.342 101.476 409.022 101.668L408.662 102.364C408.222 102.236 407.826 102.172 407.474 102.172C406.866 102.172 406.426 102.352 406.154 102.712C405.89 103.072 405.758 103.64 405.758 104.416C405.758 105.992 406.322 106.78 407.45 106.78C407.898 106.78 408.374 106.708 408.878 106.564ZM410.685 106.204V102.22H409.869V101.5H410.697V99.784H411.597V101.5H413.061V102.22H411.585V106.036C411.585 106.572 411.857 106.84 412.401 106.84C412.529 106.84 412.725 106.816 412.989 106.768L413.121 107.416C412.793 107.52 412.453 107.572 412.101 107.572C411.757 107.572 411.433 107.468 411.129 107.26C410.833 107.044 410.685 106.692 410.685 106.204ZM424.77 107.5H423.87V100.612L421.17 105.292L420.858 105.28L418.158 100.624V107.5H417.27V99.1H418.278L421.026 103.72L423.87 99.1H424.77V107.5ZM430.701 104.692H426.873C426.873 105.46 427.053 106.004 427.413 106.324C427.781 106.644 428.241 106.804 428.793 106.804C429.073 106.804 429.269 106.792 429.381 106.768C429.493 106.736 429.597 106.708 429.693 106.684C429.797 106.652 429.869 106.628 429.909 106.612C430.109 106.556 430.281 106.504 430.425 106.456L430.569 107.152C429.769 107.432 429.145 107.572 428.697 107.572C427.873 107.572 427.213 107.324 426.717 106.828C426.221 106.324 425.973 105.572 425.973 104.572C425.973 103.564 426.205 102.78 426.669 102.22C427.141 101.66 427.733 101.38 428.445 101.38C429.165 101.38 429.725 101.612 430.125 102.076C430.525 102.54 430.725 103.168 430.725 103.96C430.725 104.176 430.717 104.42 430.701 104.692ZM426.933 104.008H429.861C429.861 103.416 429.757 102.96 429.549 102.64C429.341 102.32 428.977 102.16 428.457 102.16C427.945 102.16 427.569 102.332 427.329 102.676C427.089 103.02 426.957 103.464 426.933 104.008ZM432.552 106.204V102.22H431.736V101.5H432.564V99.784H433.464V101.5H434.928V102.22H433.452V106.036C433.452 106.572 433.724 106.84 434.268 106.84C434.396 106.84 434.592 106.816 434.856 106.768L434.988 107.416C434.66 107.52 434.32 107.572 433.968 107.572C433.624 107.572 433.3 107.468 432.996 107.26C432.7 107.044 432.552 106.692 432.552 106.204ZM437.457 102.916V107.5H436.557V101.5H437.133L437.277 102.208C437.661 101.904 437.981 101.692 438.237 101.572C438.493 101.444 438.785 101.38 439.113 101.38C439.273 101.38 439.393 101.388 439.473 101.404L439.641 101.452L439.497 102.28C439.353 102.232 439.157 102.208 438.909 102.208C438.429 102.208 437.945 102.444 437.457 102.916ZM440.842 107.5V101.5H441.742V107.5H440.842ZM441.742 99.1V100.168H440.842V99.1H441.742ZM447.268 106.564L447.448 107.272C446.808 107.464 446.244 107.56 445.756 107.56C444.9 107.56 444.256 107.28 443.824 106.72C443.392 106.16 443.176 105.388 443.176 104.404C443.176 103.42 443.4 102.672 443.848 102.16C444.296 101.64 444.956 101.38 445.828 101.38C446.204 101.38 446.732 101.476 447.412 101.668L447.052 102.364C446.612 102.236 446.216 102.172 445.864 102.172C445.256 102.172 444.816 102.352 444.544 102.712C444.28 103.072 444.148 103.64 444.148 104.416C444.148 105.992 444.712 106.78 445.84 106.78C446.288 106.78 446.764 106.708 447.268 106.564ZM448.704 106.432C449.224 106.672 449.72 106.792 450.192 106.792C450.664 106.792 451.02 106.7 451.26 106.516C451.508 106.324 451.632 106.072 451.632 105.76C451.632 105.448 451.528 105.208 451.32 105.04C451.112 104.864 450.856 104.728 450.552 104.632C450.256 104.536 449.956 104.432 449.652 104.32C449.356 104.208 449.104 104.04 448.896 103.816C448.688 103.592 448.584 103.308 448.584 102.964C448.584 102.46 448.748 102.072 449.076 101.8C449.404 101.52 449.848 101.38 450.408 101.38C450.968 101.38 451.488 101.464 451.968 101.632L452.052 101.668L451.896 102.436C451.416 102.252 450.968 102.16 450.552 102.16C450.144 102.16 449.864 102.224 449.712 102.352C449.56 102.48 449.484 102.696 449.484 103C449.484 103.192 449.588 103.356 449.796 103.492C450.004 103.628 450.256 103.748 450.552 103.852C450.856 103.948 451.156 104.064 451.452 104.2C451.756 104.328 452.012 104.524 452.22 104.788C452.428 105.052 452.532 105.376 452.532 105.76C452.532 106.32 452.336 106.764 451.944 107.092C451.552 107.412 451.012 107.572 450.324 107.572C449.636 107.572 449.024 107.416 448.488 107.104L448.704 106.432Z"
                    fill="#475569"
                  />
                </g>
              </g>
              <g id="Arrow bottom">
                <g id="SchemaArrow_4">
                  <rect
                    id="Line_4"
                    x="412.5"
                    y="119.5"
                    width="22"
                    height="1"
                    transform="rotate(90 412.5 119.5)"
                    fill="#94A3B8"
                  />
                </g>
              </g>
            </g>
            <g id="SchemaCard_5" filter="url(#filter1_d_190_9079)">
              <rect
                x="312"
                y="145.5"
                width="200"
                height="92"
                rx="4"
                fill="white"
              />
              <g id="Container_5">
                <g id="Icon_7">
                  <g id="Group">
                    <path
                      id="Vector_9"
                      d="M336.83 165.512C337.187 164.395 336.972 162.163 336.28 161.34C336.19 161.232 336.02 161.247 335.945 161.366L335.093 162.711C334.882 162.98 334.502 163.042 334.217 162.854C333.293 162.246 332.188 161.892 331 161.892C329.812 161.892 328.707 162.246 327.783 162.854C327.498 163.042 327.118 162.979 326.907 162.711L326.055 161.366C325.98 161.247 325.81 161.232 325.72 161.34C325.028 162.163 324.813 164.395 325.17 165.512C325.288 165.883 325.322 166.275 325.251 166.658C325.182 167.037 325.112 167.495 325.112 167.812C325.112 171.081 327.749 173.733 331 173.733C334.252 173.733 336.888 171.083 336.888 167.812C336.888 167.494 336.819 167.037 336.749 166.658C336.678 166.275 336.712 165.883 336.83 165.512ZM331 172.409C328.487 172.409 326.442 170.353 326.442 167.826C326.442 167.743 326.445 167.662 326.448 167.58C326.54 165.858 327.579 164.385 329.052 163.684C329.642 163.4 330.304 163.243 331 163.243C331.696 163.243 332.358 163.402 332.95 163.685C334.422 164.387 335.462 165.86 335.553 167.58C335.558 167.662 335.56 167.743 335.56 167.826C335.558 170.353 333.513 172.409 331 172.409Z"
                      fill="black"
                    />
                    <path
                      id="Vector_10"
                      d="M332.974 169.59L331.81 167.56L330.81 165.867C330.787 165.827 330.744 165.803 330.697 165.803H329.742C329.694 165.803 329.652 165.829 329.629 165.869C329.606 165.91 329.606 165.961 329.63 166.001L330.585 167.617L329.303 169.584C329.277 169.624 329.273 169.676 329.296 169.719C329.319 169.762 329.364 169.788 329.411 169.788H330.372C330.417 169.788 330.458 169.765 330.483 169.728L331.176 168.639L331.797 169.722C331.82 169.764 331.865 169.788 331.911 169.788H332.858C332.906 169.788 332.948 169.764 332.971 169.722C332.999 169.681 332.999 169.631 332.974 169.59Z"
                      fill="black"
                    />
                  </g>
                </g>
                <path
                  id="Card label_7"
                  d="M350.302 172.5H348.272V168.216H345.024V172.5H342.994V162.7H345.024V166.606H348.272V162.7H350.302V172.5ZM356.141 172.5L355.861 171.8C355.534 172.099 355.245 172.309 354.993 172.43C354.741 172.542 354.438 172.598 354.083 172.598C353.486 172.598 352.963 172.393 352.515 171.982C352.076 171.562 351.857 171.007 351.857 170.316C351.857 169.625 352.128 169.084 352.669 168.692C353.21 168.291 354.027 168.09 355.119 168.09H355.693C355.693 167.689 355.595 167.367 355.399 167.124C355.212 166.881 354.923 166.76 354.531 166.76C353.85 166.76 353.159 166.853 352.459 167.04L352.151 165.808C353.075 165.509 354.004 165.36 354.937 165.36C356.636 165.36 357.485 166.153 357.485 167.74V172.5H356.141ZM355.665 169.434H355.063C354.54 169.434 354.186 169.504 353.999 169.644C353.812 169.784 353.719 169.989 353.719 170.26C353.719 170.521 353.789 170.736 353.929 170.904C354.069 171.072 354.251 171.156 354.475 171.156C354.792 171.156 355.189 170.904 355.665 170.4V169.434ZM359.346 170.638C359.971 170.955 360.611 171.114 361.264 171.114C361.927 171.114 362.258 170.871 362.258 170.386C362.258 169.938 361.885 169.607 361.138 169.392C360.821 169.308 360.503 169.21 360.186 169.098C359.878 168.977 359.612 168.785 359.388 168.524C359.173 168.253 359.066 167.908 359.066 167.488C359.066 166.807 359.276 166.284 359.696 165.92C360.116 165.547 360.699 165.36 361.446 165.36C362.202 165.36 362.916 165.491 363.588 165.752L363.294 167.208C362.678 166.956 362.076 166.83 361.488 166.83C361.077 166.83 360.872 166.97 360.872 167.25C360.872 167.539 361.147 167.759 361.698 167.908C362.277 168.057 362.79 168.272 363.238 168.552C363.471 168.692 363.667 168.902 363.826 169.182C363.985 169.462 364.064 169.798 364.064 170.19C364.064 170.927 363.817 171.511 363.322 171.94C362.827 172.369 362.146 172.584 361.278 172.584C360.41 172.584 359.635 172.383 358.954 171.982L359.346 170.638ZM365.553 165.5H367.401V169.784C367.401 170.167 367.475 170.479 367.625 170.722C367.774 170.955 368.021 171.072 368.367 171.072C368.712 171.072 369.141 170.857 369.655 170.428V165.5H371.489V172.5H369.949L369.655 171.828C369.253 172.127 368.903 172.327 368.605 172.43C368.315 172.533 367.975 172.584 367.583 172.584C366.957 172.584 366.463 172.379 366.099 171.968C365.735 171.557 365.553 170.946 365.553 170.134V165.5ZM375.593 167.852V172.5H373.759V165.5H375.215L375.383 166.186C375.756 165.887 376.069 165.677 376.321 165.556C376.573 165.425 376.792 165.36 376.979 165.36C377.175 165.36 377.306 165.365 377.371 165.374C377.436 165.374 377.492 165.379 377.539 165.388C377.586 165.397 377.665 165.416 377.777 165.444L377.609 167.11C377.441 167.054 377.212 167.026 376.923 167.026C376.531 167.026 376.088 167.301 375.593 167.852ZM382.938 172.5L382.658 171.8C382.331 172.099 382.042 172.309 381.79 172.43C381.538 172.542 381.234 172.598 380.88 172.598C380.282 172.598 379.76 172.393 379.312 171.982C378.873 171.562 378.654 171.007 378.654 170.316C378.654 169.625 378.924 169.084 379.466 168.692C380.007 168.291 380.824 168.09 381.916 168.09H382.49C382.49 167.689 382.392 167.367 382.196 167.124C382.009 166.881 381.72 166.76 381.328 166.76C380.646 166.76 379.956 166.853 379.256 167.04L378.948 165.808C379.872 165.509 380.8 165.36 381.734 165.36C383.432 165.36 384.282 166.153 384.282 167.74V172.5H382.938ZM382.462 169.434H381.86C381.337 169.434 380.982 169.504 380.796 169.644C380.609 169.784 380.516 169.989 380.516 170.26C380.516 170.521 380.586 170.736 380.726 170.904C380.866 171.072 381.048 171.156 381.272 171.156C381.589 171.156 381.986 170.904 382.462 170.4V169.434Z"
                  fill="#0F172A"
                />
              </g>
              <a
                href="https://hasura.io/docs/latest/enterprise/metrics/#metrics-exported"
                className="hover:cursor-pointer"
              >
                <g id="Items">
                  <path
                    d="M312 189.5H512V234C512 235.933 510.433 237.5 508.5 237.5H315.5C313.567 237.5 312 235.933 312 234V189.5Z"
                    fill="#F1F5F9"
                  />
                  <g id="SchemaCardItem">
                    <g id="Content">
                      <g id="SchemaCardItemText">
                        <g id="Icon_8">
                          <path
                            id="Vector_11"
                            d="M335.44 201.5C335.44 204.366 333.116 206.69 330.25 206.69C327.384 206.69 325.06 204.366 325.06 201.5C325.06 198.634 327.384 196.31 330.25 196.31C333.116 196.31 335.44 198.634 335.44 201.5ZM329.65 204.248L333.5 200.397C333.631 200.267 333.631 200.055 333.5 199.924L333.027 199.45C332.896 199.32 332.684 199.32 332.553 199.45L329.413 202.591L327.947 201.125C327.816 200.994 327.604 200.994 327.473 201.125L327 201.598C326.869 201.729 326.869 201.941 327 202.072L329.176 204.248C329.307 204.379 329.519 204.379 329.65 204.248Z"
                            fill="#059669"
                          />
                        </g>
                        <path
                          id="Card item label"
                          d="M343.716 201.972H342.492V205.5H341.592V197.1H343.992C344.888 197.1 345.536 197.296 345.936 197.688C346.344 198.08 346.548 198.692 346.548 199.524C346.548 200.348 346.3 200.964 345.804 201.372C345.308 201.772 344.612 201.972 343.716 201.972ZM343.584 197.868H342.492V201.204H343.284C344.108 201.204 344.708 201.08 345.084 200.832C345.46 200.584 345.648 200.16 345.648 199.56C345.648 198.952 345.484 198.52 345.156 198.264C344.828 198 344.304 197.868 343.584 197.868ZM348.984 200.916V205.5H348.084V199.5H348.66L348.804 200.208C349.188 199.904 349.508 199.692 349.764 199.572C350.02 199.444 350.312 199.38 350.64 199.38C350.8 199.38 350.92 199.388 351 199.404L351.168 199.452L351.024 200.28C350.88 200.232 350.684 200.208 350.436 200.208C349.956 200.208 349.472 200.444 348.984 200.916ZM356.245 202.548C356.245 201.772 356.093 201.18 355.789 200.772C355.485 200.364 355.041 200.16 354.457 200.16C353.873 200.16 353.457 200.356 353.209 200.748C352.969 201.132 352.849 201.724 352.849 202.524C352.849 204.036 353.405 204.792 354.517 204.792C355.101 204.792 355.533 204.612 355.813 204.252C356.101 203.884 356.245 203.316 356.245 202.548ZM356.461 204.756C356.005 205.3 355.361 205.572 354.529 205.572C353.697 205.572 353.057 205.304 352.609 204.768C352.169 204.224 351.949 203.468 351.949 202.5C351.949 201.524 352.161 200.76 352.585 200.208C353.017 199.656 353.645 199.38 354.469 199.38C355.301 199.38 355.953 199.66 356.425 200.22C356.905 200.78 357.145 201.54 357.145 202.5C357.145 203.46 356.917 204.212 356.461 204.756ZM361.28 199.368C362.048 199.368 362.596 199.64 362.924 200.184C363.604 199.64 364.232 199.368 364.808 199.368C365.384 199.368 365.852 199.532 366.212 199.86C366.58 200.18 366.764 200.648 366.764 201.264V205.5H365.888V201.636C365.888 201.148 365.776 200.78 365.552 200.532C365.336 200.276 365.044 200.148 364.676 200.148C364.172 200.148 363.664 200.348 363.152 200.748C363.192 200.924 363.212 201.096 363.212 201.264V205.5H362.336V201.636C362.336 201.148 362.224 200.78 362 200.532C361.784 200.276 361.492 200.148 361.124 200.148C360.884 200.148 360.664 200.18 360.464 200.244C360.264 200.308 360.116 200.372 360.02 200.436C359.924 200.5 359.8 200.596 359.648 200.724V205.5H358.748V199.5H359.324L359.48 200.112C359.68 199.944 359.832 199.824 359.936 199.752C360.048 199.672 360.228 199.588 360.476 199.5C360.724 199.412 360.992 199.368 361.28 199.368ZM373.108 202.692H369.28C369.28 203.46 369.46 204.004 369.82 204.324C370.188 204.644 370.648 204.804 371.2 204.804C371.48 204.804 371.676 204.792 371.788 204.768C371.9 204.736 372.004 204.708 372.1 204.684C372.204 204.652 372.276 204.628 372.316 204.612C372.516 204.556 372.688 204.504 372.832 204.456L372.976 205.152C372.176 205.432 371.552 205.572 371.104 205.572C370.28 205.572 369.62 205.324 369.124 204.828C368.628 204.324 368.38 203.572 368.38 202.572C368.38 201.564 368.612 200.78 369.076 200.22C369.548 199.66 370.14 199.38 370.852 199.38C371.572 199.38 372.132 199.612 372.532 200.076C372.932 200.54 373.132 201.168 373.132 201.96C373.132 202.176 373.124 202.42 373.108 202.692ZM369.34 202.008H372.268C372.268 201.416 372.164 200.96 371.956 200.64C371.748 200.32 371.384 200.16 370.864 200.16C370.352 200.16 369.976 200.332 369.736 200.676C369.496 201.02 369.364 201.464 369.34 202.008ZM374.959 204.204V200.22H374.143V199.5H374.971V197.784H375.871V199.5H377.335V200.22H375.859V204.036C375.859 204.572 376.131 204.84 376.675 204.84C376.803 204.84 376.999 204.816 377.263 204.768L377.395 205.416C377.067 205.52 376.727 205.572 376.375 205.572C376.031 205.572 375.707 205.468 375.403 205.26C375.107 205.044 374.959 204.692 374.959 204.204ZM383.451 205.5H382.551V201.552C382.551 200.584 382.147 200.1 381.339 200.1C380.739 200.1 380.247 200.292 379.863 200.676V205.5H378.963V197.1H379.851V199.944C380.027 199.8 380.163 199.696 380.259 199.632C380.363 199.568 380.527 199.504 380.751 199.44C380.983 199.376 381.243 199.344 381.531 199.344C382.083 199.344 382.539 199.512 382.899 199.848C383.267 200.184 383.451 200.664 383.451 201.288V205.5ZM389.795 202.692H385.967C385.967 203.46 386.147 204.004 386.507 204.324C386.875 204.644 387.335 204.804 387.887 204.804C388.167 204.804 388.363 204.792 388.475 204.768C388.587 204.736 388.691 204.708 388.787 204.684C388.891 204.652 388.963 204.628 389.003 204.612C389.203 204.556 389.375 204.504 389.519 204.456L389.663 205.152C388.863 205.432 388.239 205.572 387.791 205.572C386.967 205.572 386.307 205.324 385.811 204.828C385.315 204.324 385.067 203.572 385.067 202.572C385.067 201.564 385.299 200.78 385.763 200.22C386.235 199.66 386.827 199.38 387.539 199.38C388.259 199.38 388.819 199.612 389.219 200.076C389.619 200.54 389.819 201.168 389.819 201.96C389.819 202.176 389.811 202.42 389.795 202.692ZM386.027 202.008H388.955C388.955 201.416 388.851 200.96 388.643 200.64C388.435 200.32 388.071 200.16 387.551 200.16C387.039 200.16 386.663 200.332 386.423 200.676C386.183 201.02 386.051 201.464 386.027 202.008ZM394.934 203.976V199.5H395.846V205.5H395.318L395.018 204.792C394.378 205.312 393.766 205.572 393.182 205.572C392.598 205.572 392.15 205.404 391.838 205.068C391.534 204.724 391.382 204.24 391.382 203.616V199.5H392.282V203.472C392.282 203.944 392.35 204.284 392.486 204.492C392.63 204.7 392.862 204.804 393.182 204.804C393.51 204.804 393.842 204.716 394.178 204.54C394.514 204.364 394.766 204.176 394.934 203.976ZM397.802 204.432C398.322 204.672 398.818 204.792 399.29 204.792C399.762 204.792 400.118 204.7 400.358 204.516C400.606 204.324 400.73 204.072 400.73 203.76C400.73 203.448 400.626 203.208 400.418 203.04C400.21 202.864 399.954 202.728 399.65 202.632C399.354 202.536 399.054 202.432 398.75 202.32C398.454 202.208 398.202 202.04 397.994 201.816C397.786 201.592 397.682 201.308 397.682 200.964C397.682 200.46 397.846 200.072 398.174 199.8C398.502 199.52 398.946 199.38 399.506 199.38C400.066 199.38 400.586 199.464 401.066 199.632L401.15 199.668L400.994 200.436C400.514 200.252 400.066 200.16 399.65 200.16C399.242 200.16 398.962 200.224 398.81 200.352C398.658 200.48 398.582 200.696 398.582 201C398.582 201.192 398.686 201.356 398.894 201.492C399.102 201.628 399.354 201.748 399.65 201.852C399.954 201.948 400.254 202.064 400.55 202.2C400.854 202.328 401.11 202.524 401.318 202.788C401.526 203.052 401.63 203.376 401.63 203.76C401.63 204.32 401.434 204.764 401.042 205.092C400.65 205.412 400.11 205.572 399.422 205.572C398.734 205.572 398.122 205.416 397.586 205.104L397.802 204.432ZM410.78 205.5H406.256V197.1H410.78V197.88H407.156V200.544H410.48V201.348H407.156V204.72H410.78V205.5ZM413.66 200.736V205.5H412.76V199.5H413.336L413.48 200.088C413.664 199.944 413.812 199.832 413.924 199.752C414.044 199.672 414.232 199.592 414.488 199.512C414.744 199.424 415.016 199.38 415.304 199.38C415.856 199.38 416.312 199.552 416.672 199.896C417.04 200.232 417.224 200.712 417.224 201.336V205.5H416.324V201.6C416.324 200.632 415.92 200.148 415.112 200.148C414.536 200.148 414.052 200.344 413.66 200.736ZM421.997 201.912H422.489C422.489 201.184 422.397 200.712 422.213 200.496C422.029 200.272 421.621 200.16 420.989 200.16C420.357 200.16 419.821 200.244 419.381 200.412L419.213 199.716C419.885 199.492 420.581 199.38 421.301 199.38C422.709 199.38 423.413 200.084 423.413 201.492V205.5H422.885L422.573 204.792C422.205 205.096 421.885 205.304 421.613 205.416C421.349 205.52 421.041 205.572 420.689 205.572C420.129 205.572 419.693 205.408 419.381 205.08C419.069 204.744 418.913 204.304 418.913 203.76C418.913 202.528 419.941 201.912 421.997 201.912ZM422.501 202.668H421.961C421.145 202.668 420.581 202.748 420.269 202.908C419.965 203.068 419.812 203.32 419.812 203.664C419.812 204 419.9 204.276 420.076 204.492C420.253 204.708 420.481 204.816 420.761 204.816C421.049 204.816 421.321 204.752 421.577 204.624C421.841 204.488 422.149 204.256 422.501 203.928V202.668ZM425.592 197.1H426.492V200.1C427.18 199.612 427.796 199.368 428.34 199.368C429.78 199.368 430.5 200.404 430.5 202.476C430.5 203.652 430.244 204.476 429.732 204.948C429.276 205.364 428.74 205.572 428.124 205.572C427.812 205.572 427.496 205.504 427.176 205.368C426.856 205.224 426.592 205.072 426.384 204.912L426.12 205.5H425.592V197.1ZM426.492 200.952V204.216C426.652 204.4 426.864 204.544 427.128 204.648C427.4 204.752 427.664 204.804 427.92 204.804C428.544 204.804 428.98 204.62 429.228 204.252C429.476 203.884 429.6 203.308 429.6 202.524C429.6 201.74 429.476 201.148 429.228 200.748C428.98 200.348 428.664 200.148 428.28 200.148C427.704 200.148 427.108 200.416 426.492 200.952ZM432.143 205.5V197.1H433.043V205.5H432.143ZM439.389 202.692H435.561C435.561 203.46 435.741 204.004 436.101 204.324C436.469 204.644 436.929 204.804 437.481 204.804C437.761 204.804 437.957 204.792 438.069 204.768C438.181 204.736 438.285 204.708 438.381 204.684C438.485 204.652 438.557 204.628 438.597 204.612C438.797 204.556 438.969 204.504 439.113 204.456L439.257 205.152C438.457 205.432 437.833 205.572 437.385 205.572C436.561 205.572 435.901 205.324 435.405 204.828C434.909 204.324 434.661 203.572 434.661 202.572C434.661 201.564 434.893 200.78 435.357 200.22C435.829 199.66 436.421 199.38 437.133 199.38C437.853 199.38 438.413 199.612 438.813 200.076C439.213 200.54 439.413 201.168 439.413 201.96C439.413 202.176 439.405 202.42 439.389 202.692ZM435.621 202.008H438.549C438.549 201.416 438.445 200.96 438.237 200.64C438.029 200.32 437.665 200.16 437.145 200.16C436.633 200.16 436.257 200.332 436.017 200.676C435.777 201.02 435.645 201.464 435.621 202.008ZM444.516 197.1H445.416V205.5H444.888L444.588 204.816C443.852 205.336 443.212 205.596 442.668 205.596C441.228 205.596 440.508 204.56 440.508 202.488C440.508 201.312 440.764 200.492 441.276 200.028C441.732 199.604 442.248 199.392 442.824 199.392C443.4 199.392 443.964 199.588 444.516 199.98V197.1ZM444.516 204.012V200.892C444.348 200.692 444.124 200.52 443.844 200.376C443.572 200.232 443.32 200.16 443.088 200.16C442.464 200.16 442.028 200.344 441.78 200.712C441.532 201.08 441.408 201.656 441.408 202.44C441.408 203.224 441.532 203.816 441.78 204.216C442.028 204.616 442.344 204.816 442.728 204.816C443.304 204.816 443.9 204.548 444.516 204.012Z"
                          fill="#0F172A"
                        />
                      </g>
                    </g>
                    <path
                      d="M312 190.5H512V188.5H312V190.5Z"
                      fill="#E2E8F0"
                      mask="url(#path-33-inside-2_190_9079)"
                    />
                  </g>
                  <g id="SchemaCardItem_2">
                    <g id="Content_2">
                      <g id="SchemaCardItemText_2">
                        <g id="Content_3">
                          <g id="Icon_9">
                            <path
                              id="Vector_12"
                              d="M332.05 227H332.95C333.1 227 333.25 226.85 333.25 226.7V223.55C333.25 223.4 333.1 223.25 332.95 223.25H332.05C331.9 223.25 331.75 223.4 331.75 223.55V226.7C331.75 226.85 331.9 227 332.05 227ZM334.3 227H335.2C335.35 227 335.5 226.85 335.5 226.7V221.3C335.5 221.15 335.35 221 335.2 221H334.3C334.15 221 334 221.15 334 221.3V226.7C334 226.85 334.15 227 334.3 227ZM327.55 227H328.45C328.6 227 328.75 226.85 328.75 226.7V225.05C328.75 224.9 328.6 224.75 328.45 224.75H327.55C327.4 224.75 327.25 224.9 327.25 225.05V226.7C327.25 226.85 327.4 227 327.55 227ZM329.8 227H330.7C330.85 227 331 226.85 331 226.7V222.05C331 221.9 330.85 221.75 330.7 221.75H329.8C329.65 221.75 329.5 221.9 329.5 222.05V226.7C329.5 226.85 329.65 227 329.8 227ZM335.875 228.5H325.75V221.375C325.75 221.168 325.582 221 325.375 221H324.625C324.418 221 324.25 221.168 324.25 221.375V229.25C324.25 229.664 324.586 230 325 230H335.875C336.082 230 336.25 229.832 336.25 229.625V228.875C336.25 228.668 336.082 228.5 335.875 228.5Z"
                              fill="#297393"
                            />
                          </g>
                          <path
                            id="Card item label_2"
                            d="M347.292 229.5H346.284L345.444 226.848H342.432L341.604 229.5H340.656L343.416 221.1H344.508L347.292 229.5ZM345.24 226.068L343.956 222.012L342.66 226.068H345.24ZM352.657 223.488L350.629 229.5H349.597L347.581 223.488H348.601L350.125 228.54L351.661 223.488H352.657ZM356.477 225.912H356.969C356.969 225.184 356.877 224.712 356.693 224.496C356.509 224.272 356.101 224.16 355.469 224.16C354.837 224.16 354.301 224.244 353.861 224.412L353.693 223.716C354.365 223.492 355.061 223.38 355.781 223.38C357.189 223.38 357.893 224.084 357.893 225.492V229.5H357.365L357.053 228.792C356.685 229.096 356.365 229.304 356.093 229.416C355.829 229.52 355.521 229.572 355.169 229.572C354.609 229.572 354.173 229.408 353.861 229.08C353.549 228.744 353.393 228.304 353.393 227.76C353.393 226.528 354.421 225.912 356.477 225.912ZM356.981 226.668H356.441C355.625 226.668 355.061 226.748 354.749 226.908C354.445 227.068 354.293 227.32 354.293 227.664C354.293 228 354.381 228.276 354.557 228.492C354.733 228.708 354.961 228.816 355.241 228.816C355.529 228.816 355.801 228.752 356.057 228.624C356.321 228.488 356.629 228.256 356.981 227.928V226.668ZM359.904 229.5V223.5H360.804V229.5H359.904ZM360.804 221.1V222.168H359.904V221.1H360.804ZM362.803 229.5V221.1H363.703V229.5H362.803ZM368.477 225.912H368.969C368.969 225.184 368.877 224.712 368.693 224.496C368.509 224.272 368.101 224.16 367.469 224.16C366.837 224.16 366.301 224.244 365.861 224.412L365.693 223.716C366.365 223.492 367.061 223.38 367.781 223.38C369.189 223.38 369.893 224.084 369.893 225.492V229.5H369.365L369.053 228.792C368.685 229.096 368.365 229.304 368.093 229.416C367.829 229.52 367.521 229.572 367.169 229.572C366.609 229.572 366.173 229.408 365.861 229.08C365.549 228.744 365.393 228.304 365.393 227.76C365.393 226.528 366.421 225.912 368.477 225.912ZM368.981 226.668H368.441C367.625 226.668 367.061 226.748 366.749 226.908C366.445 227.068 366.293 227.32 366.293 227.664C366.293 228 366.381 228.276 366.557 228.492C366.733 228.708 366.961 228.816 367.241 228.816C367.529 228.816 367.801 228.752 368.057 228.624C368.321 228.488 368.629 228.256 368.981 227.928V226.668ZM372.072 221.1H372.972V224.1C373.66 223.612 374.276 223.368 374.82 223.368C376.26 223.368 376.98 224.404 376.98 226.476C376.98 227.652 376.724 228.476 376.212 228.948C375.756 229.364 375.22 229.572 374.604 229.572C374.292 229.572 373.976 229.504 373.656 229.368C373.336 229.224 373.072 229.072 372.864 228.912L372.6 229.5H372.072V221.1ZM372.972 224.952V228.216C373.132 228.4 373.344 228.544 373.608 228.648C373.88 228.752 374.144 228.804 374.4 228.804C375.024 228.804 375.46 228.62 375.708 228.252C375.956 227.884 376.08 227.308 376.08 226.524C376.08 225.74 375.956 225.148 375.708 224.748C375.46 224.348 375.144 224.148 374.76 224.148C374.184 224.148 373.588 224.416 372.972 224.952ZM378.623 229.5V221.1H379.523V229.5H378.623ZM385.869 226.692H382.041C382.041 227.46 382.221 228.004 382.581 228.324C382.949 228.644 383.409 228.804 383.961 228.804C384.241 228.804 384.437 228.792 384.549 228.768C384.661 228.736 384.765 228.708 384.861 228.684C384.965 228.652 385.037 228.628 385.077 228.612C385.277 228.556 385.449 228.504 385.593 228.456L385.737 229.152C384.937 229.432 384.313 229.572 383.865 229.572C383.041 229.572 382.381 229.324 381.885 228.828C381.389 228.324 381.141 227.572 381.141 226.572C381.141 225.564 381.373 224.78 381.837 224.22C382.309 223.66 382.901 223.38 383.613 223.38C384.333 223.38 384.893 223.612 385.293 224.076C385.693 224.54 385.893 225.168 385.893 225.96C385.893 226.176 385.885 226.42 385.869 226.692ZM382.101 226.008H385.029C385.029 225.416 384.925 224.96 384.717 224.64C384.509 224.32 384.145 224.16 383.625 224.16C383.113 224.16 382.737 224.332 382.497 224.676C382.257 225.02 382.125 225.464 382.101 226.008ZM393.108 223.368C393.876 223.368 394.424 223.64 394.752 224.184C395.432 223.64 396.06 223.368 396.636 223.368C397.212 223.368 397.68 223.532 398.04 223.86C398.408 224.18 398.592 224.648 398.592 225.264V229.5H397.716V225.636C397.716 225.148 397.604 224.78 397.38 224.532C397.164 224.276 396.872 224.148 396.504 224.148C396 224.148 395.492 224.348 394.98 224.748C395.02 224.924 395.04 225.096 395.04 225.264V229.5H394.164V225.636C394.164 225.148 394.052 224.78 393.828 224.532C393.612 224.276 393.32 224.148 392.952 224.148C392.712 224.148 392.492 224.18 392.292 224.244C392.092 224.308 391.944 224.372 391.848 224.436C391.752 224.5 391.628 224.596 391.476 224.724V229.5H390.576V223.5H391.152L391.308 224.112C391.508 223.944 391.66 223.824 391.764 223.752C391.876 223.672 392.056 223.588 392.304 223.5C392.552 223.412 392.82 223.368 393.108 223.368ZM404.936 226.692H401.108C401.108 227.46 401.288 228.004 401.648 228.324C402.016 228.644 402.476 228.804 403.028 228.804C403.308 228.804 403.504 228.792 403.616 228.768C403.728 228.736 403.832 228.708 403.928 228.684C404.032 228.652 404.104 228.628 404.144 228.612C404.344 228.556 404.516 228.504 404.66 228.456L404.804 229.152C404.004 229.432 403.38 229.572 402.932 229.572C402.108 229.572 401.448 229.324 400.952 228.828C400.456 228.324 400.208 227.572 400.208 226.572C400.208 225.564 400.44 224.78 400.904 224.22C401.376 223.66 401.968 223.38 402.68 223.38C403.4 223.38 403.96 223.612 404.36 224.076C404.76 224.54 404.96 225.168 404.96 225.96C404.96 226.176 404.952 226.42 404.936 226.692ZM401.168 226.008H404.096C404.096 225.416 403.992 224.96 403.784 224.64C403.576 224.32 403.212 224.16 402.692 224.16C402.18 224.16 401.804 224.332 401.564 224.676C401.324 225.02 401.192 225.464 401.168 226.008ZM406.787 228.204V224.22H405.971V223.5H406.799V221.784H407.699V223.5H409.163V224.22H407.687V228.036C407.687 228.572 407.959 228.84 408.503 228.84C408.631 228.84 408.827 228.816 409.091 228.768L409.223 229.416C408.895 229.52 408.555 229.572 408.203 229.572C407.859 229.572 407.535 229.468 407.231 229.26C406.935 229.044 406.787 228.692 406.787 228.204ZM411.691 224.916V229.5H410.791V223.5H411.367L411.511 224.208C411.895 223.904 412.215 223.692 412.471 223.572C412.727 223.444 413.019 223.38 413.347 223.38C413.507 223.38 413.627 223.388 413.707 223.404L413.875 223.452L413.731 224.28C413.587 224.232 413.391 224.208 413.143 224.208C412.663 224.208 412.179 224.444 411.691 224.916ZM415.076 229.5V223.5H415.976V229.5H415.076ZM415.976 221.1V222.168H415.076V221.1H415.976ZM421.503 228.564L421.683 229.272C421.043 229.464 420.479 229.56 419.991 229.56C419.135 229.56 418.491 229.28 418.059 228.72C417.627 228.16 417.411 227.388 417.411 226.404C417.411 225.42 417.635 224.672 418.083 224.16C418.531 223.64 419.191 223.38 420.063 223.38C420.439 223.38 420.967 223.476 421.647 223.668L421.287 224.364C420.847 224.236 420.451 224.172 420.099 224.172C419.491 224.172 419.051 224.352 418.779 224.712C418.515 225.072 418.383 225.64 418.383 226.416C418.383 227.992 418.947 228.78 420.075 228.78C420.523 228.78 420.999 228.708 421.503 228.564ZM422.938 228.432C423.458 228.672 423.954 228.792 424.426 228.792C424.898 228.792 425.254 228.7 425.494 228.516C425.742 228.324 425.866 228.072 425.866 227.76C425.866 227.448 425.762 227.208 425.554 227.04C425.346 226.864 425.09 226.728 424.786 226.632C424.49 226.536 424.19 226.432 423.886 226.32C423.59 226.208 423.338 226.04 423.13 225.816C422.922 225.592 422.818 225.308 422.818 224.964C422.818 224.46 422.982 224.072 423.31 223.8C423.638 223.52 424.082 223.38 424.642 223.38C425.202 223.38 425.722 223.464 426.202 223.632L426.286 223.668L426.13 224.436C425.65 224.252 425.202 224.16 424.786 224.16C424.378 224.16 424.098 224.224 423.946 224.352C423.794 224.48 423.718 224.696 423.718 225C423.718 225.192 423.822 225.356 424.03 225.492C424.238 225.628 424.49 225.748 424.786 225.852C425.09 225.948 425.39 226.064 425.686 226.2C425.99 226.328 426.246 226.524 426.454 226.788C426.662 227.052 426.766 227.376 426.766 227.76C426.766 228.32 426.57 228.764 426.178 229.092C425.786 229.412 425.246 229.572 424.558 229.572C423.87 229.572 423.258 229.416 422.722 229.104L422.938 228.432Z"
                            fill="#297393"
                          />
                        </g>
                        <g id="Icon_10" opacity="0.9">
                          <path
                            id="Vector_13"
                            d="M495.109 227.562H494.453C494.366 227.562 494.283 227.597 494.221 227.659C494.16 227.72 494.125 227.804 494.125 227.891V230.188H487.562V223.625H490.516C490.603 223.625 490.686 223.59 490.748 223.529C490.809 223.467 490.844 223.384 490.844 223.297V222.641C490.844 222.554 490.809 222.47 490.748 222.409C490.686 222.347 490.603 222.312 490.516 222.312H487.234C486.973 222.312 486.723 222.416 486.538 222.601C486.354 222.785 486.25 223.036 486.25 223.297V230.516C486.25 230.777 486.354 231.027 486.538 231.212C486.723 231.396 486.973 231.5 487.234 231.5H494.453C494.714 231.5 494.965 231.396 495.149 231.212C495.334 231.027 495.438 230.777 495.438 230.516V227.891C495.438 227.804 495.403 227.72 495.341 227.659C495.28 227.597 495.196 227.562 495.109 227.562ZM496.258 221H493.633C493.195 221 492.976 221.531 493.284 221.841L494.017 222.574L489.019 227.57C488.973 227.616 488.936 227.67 488.911 227.73C488.887 227.79 488.874 227.854 488.874 227.919C488.874 227.983 488.887 228.048 488.911 228.107C488.936 228.167 488.973 228.222 489.019 228.267L489.483 228.731C489.529 228.777 489.584 228.814 489.643 228.839C489.703 228.863 489.767 228.876 489.832 228.876C489.897 228.876 489.961 228.863 490.021 228.839C490.081 228.814 490.135 228.777 490.181 228.731L495.177 223.734L495.909 224.466C496.217 224.773 496.75 224.558 496.75 224.117V221.492C496.75 221.362 496.698 221.236 496.606 221.144C496.514 221.052 496.388 221 496.258 221V221Z"
                            fill="#94A3B8"
                          />
                        </g>
                      </g>
                    </g>
                    <path
                      d="M312 214.5H512V212.5H312V214.5Z"
                      fill="#E2E8F0"
                      mask="url(#path-37-inside-3_190_9079)"
                    />
                  </g>
                </g>
              </a>
            </g>
            <g id="SchemaBlink">
              <circle
                id="SchemaBlink_2"
                cx="412"
                cy="146.75"
                r="5.25"
                fill="#FB923C"
                className="animate-ping"
                style={{
                  transformOrigin: 'unset',
                  transformBox: 'fill-box',
                }}
              />
            </g>
            <g id="SchemaBlink">
              <circle
                id="SchemaBlink_2"
                cx="411.5"
                cy="146.75"
                r="5.25"
                fill="#FB923C"
              />
            </g>
          </g>
          <g id="Right">
            <g id="SchemaArrowWithLabel_3">
              <g id="Horizontal_3">
                <g id="Arrow left_2">
                  <g id="SchemaArrow_5">
                    <rect
                      id="Line_5"
                      x="512"
                      y="169"
                      width="22"
                      height="1"
                      fill="#94A3B8"
                    />
                    <path
                      id="Vector_14"
                      d="M534.42 174L534 173.69V165.295L534.405 165L538.5 169.22V169.841L534.42 174Z"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
                <g id="SchemaArrowLabel_3">
                  <g id="Icon_11">
                    <path
                      id="Vector_15"
                      d="M555.688 167.25H552.983L553.981 164.208C554.075 163.852 553.806 163.5 553.438 163.5H550.063C549.781 163.5 549.542 163.709 549.505 163.987L548.755 169.612C548.71 169.95 548.973 170.25 549.313 170.25H552.095L551.014 174.809C550.93 175.165 551.202 175.5 551.56 175.5C551.757 175.5 551.945 175.397 552.048 175.219L556.173 168.094C556.391 167.721 556.121 167.25 555.688 167.25Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_8"
                    d="M565.716 169.972H564.492V173.5H563.592V165.1H565.992C566.888 165.1 567.536 165.296 567.936 165.688C568.344 166.08 568.548 166.692 568.548 167.524C568.548 168.348 568.3 168.964 567.804 169.372C567.308 169.772 566.612 169.972 565.716 169.972ZM565.584 165.868H564.492V169.204H565.284C566.108 169.204 566.708 169.08 567.084 168.832C567.46 168.584 567.648 168.16 567.648 167.56C567.648 166.952 567.484 166.52 567.156 166.264C566.828 166 566.304 165.868 565.584 165.868ZM573.675 170.548C573.675 169.772 573.523 169.18 573.219 168.772C572.915 168.364 572.471 168.16 571.887 168.16C571.303 168.16 570.887 168.356 570.639 168.748C570.399 169.132 570.279 169.724 570.279 170.524C570.279 172.036 570.835 172.792 571.947 172.792C572.531 172.792 572.963 172.612 573.243 172.252C573.531 171.884 573.675 171.316 573.675 170.548ZM573.891 172.756C573.435 173.3 572.791 173.572 571.959 173.572C571.127 173.572 570.487 173.304 570.039 172.768C569.599 172.224 569.379 171.468 569.379 170.5C569.379 169.524 569.591 168.76 570.015 168.208C570.447 167.656 571.075 167.38 571.899 167.38C572.731 167.38 573.383 167.66 573.855 168.22C574.335 168.78 574.575 169.54 574.575 170.5C574.575 171.46 574.347 172.212 573.891 172.756ZM576.97 173.5L575.218 167.5H576.154L577.486 172.552L578.722 167.5H579.61L580.942 172.6L582.166 167.5H583.102L581.458 173.5H580.402L579.166 168.76L578.002 173.5H576.97ZM588.486 170.692H584.658C584.658 171.46 584.838 172.004 585.198 172.324C585.566 172.644 586.026 172.804 586.578 172.804C586.858 172.804 587.054 172.792 587.166 172.768C587.278 172.736 587.382 172.708 587.478 172.684C587.582 172.652 587.654 172.628 587.694 172.612C587.894 172.556 588.066 172.504 588.21 172.456L588.354 173.152C587.554 173.432 586.93 173.572 586.482 173.572C585.658 173.572 584.998 173.324 584.502 172.828C584.006 172.324 583.758 171.572 583.758 170.572C583.758 169.564 583.99 168.78 584.454 168.22C584.926 167.66 585.518 167.38 586.23 167.38C586.95 167.38 587.51 167.612 587.91 168.076C588.31 168.54 588.51 169.168 588.51 169.96C588.51 170.176 588.502 170.42 588.486 170.692ZM584.718 170.008H587.646C587.646 169.416 587.542 168.96 587.334 168.64C587.126 168.32 586.762 168.16 586.242 168.16C585.73 168.16 585.354 168.332 585.114 168.676C584.874 169.02 584.742 169.464 584.718 170.008ZM591.094 168.916V173.5H590.194V167.5H590.77L590.914 168.208C591.298 167.904 591.618 167.692 591.874 167.572C592.13 167.444 592.422 167.38 592.75 167.38C592.91 167.38 593.03 167.388 593.11 167.404L593.278 167.452L593.134 168.28C592.99 168.232 592.794 168.208 592.546 168.208C592.066 168.208 591.582 168.444 591.094 168.916ZM594.479 173.5V167.5H595.379V173.5H594.479ZM595.379 165.1V166.168H594.479V165.1H595.379ZM598.277 168.736V173.5H597.377V167.5H597.953L598.097 168.088C598.281 167.944 598.429 167.832 598.541 167.752C598.661 167.672 598.849 167.592 599.105 167.512C599.361 167.424 599.633 167.38 599.921 167.38C600.473 167.38 600.929 167.552 601.289 167.896C601.657 168.232 601.841 168.712 601.841 169.336V173.5H600.941V169.6C600.941 168.632 600.537 168.148 599.729 168.148C599.153 168.148 598.669 168.344 598.277 168.736ZM607.43 172.864C606.758 173.344 606.146 173.584 605.594 173.584C604.154 173.584 603.434 172.548 603.434 170.476C603.434 169.3 603.69 168.476 604.202 168.004C604.658 167.588 605.21 167.38 605.858 167.38C606.514 167.38 607.062 167.676 607.502 168.268L607.814 167.488H608.342V173.8C608.342 174.672 608.126 175.32 607.694 175.744C607.262 176.168 606.678 176.38 605.942 176.38C605.566 176.38 605.23 176.332 604.934 176.236C604.638 176.14 604.33 176.032 604.01 175.912L604.178 175.276C604.85 175.492 605.41 175.6 605.858 175.6C606.314 175.6 606.69 175.46 606.986 175.18C607.282 174.9 607.43 174.476 607.43 173.908V172.864ZM607.43 172V169.756C607.43 169.284 607.274 168.9 606.962 168.604C606.65 168.308 606.33 168.16 606.002 168.16C605.378 168.16 604.942 168.344 604.694 168.712C604.446 169.072 604.322 169.652 604.322 170.452C604.322 172.02 604.762 172.804 605.642 172.804C606.218 172.804 606.814 172.536 607.43 172Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="Arrow right_2">
                  <g id="SchemaArrow_6">
                    <rect
                      id="Line_6"
                      x="617.5"
                      y="169"
                      width="26.5"
                      height="1"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
              </g>
            </g>
            <g id="Col5">
              <g id="SchemaGrouper_2">
                <g id="Borders_2">
                  <mask id="path-48-inside-4_190_9079" fill="white">
                    <path d="M660 237.5H644V65.5H660V237.5Z" />
                  </mask>
                  <path
                    d="M644 237.5H643V238.5H644V237.5ZM644 65.5V64.5H643V65.5H644ZM660 236.5H644V238.5H660V236.5ZM645 237.5V65.5H643V237.5H645ZM644 66.5H660V64.5H644V66.5Z"
                    fill="#94A3B8"
                    mask="url(#path-48-inside-4_190_9079)"
                  />
                </g>
              </g>
              <g id="Cards_2">
                <g id="SchemaTitle_2">
                  <path
                    id="Title_2"
                    d="M741.152 77.572C739.928 77.572 738.988 77.188 738.332 76.42C737.684 75.644 737.36 74.596 737.36 73.276C737.36 71.956 737.704 70.912 738.392 70.144C739.088 69.376 740.052 68.992 741.284 68.992C741.956 68.992 742.624 69.108 743.288 69.34L742.952 70.684C742.464 70.476 741.888 70.372 741.224 70.372C740.56 70.372 740.04 70.624 739.664 71.128C739.288 71.632 739.1 72.328 739.1 73.216C739.1 74.104 739.276 74.824 739.628 75.376C739.98 75.92 740.476 76.192 741.116 76.192C741.596 76.192 742.28 76.036 743.168 75.724L743.528 76.948C742.8 77.364 742.008 77.572 741.152 77.572ZM747.884 77.56C746.708 77.56 745.82 77.156 745.22 76.348C744.62 75.532 744.32 74.496 744.32 73.24C744.32 71.984 744.62 70.96 745.22 70.168C745.828 69.376 746.716 68.98 747.884 68.98C749.06 68.98 749.952 69.376 750.56 70.168C751.168 70.96 751.472 71.984 751.472 73.24C751.472 74.96 750.948 76.2 749.9 76.96C749.348 77.36 748.676 77.56 747.884 77.56ZM747.908 70.36C747.484 70.36 747.128 70.508 746.84 70.804C746.328 71.316 746.072 72.128 746.072 73.24C746.072 74.08 746.228 74.78 746.54 75.34C746.852 75.892 747.308 76.168 747.908 76.168C748.516 76.168 748.972 75.888 749.276 75.328C749.58 74.76 749.732 74.072 749.732 73.264C749.732 72.448 749.568 71.76 749.24 71.2C748.92 70.64 748.476 70.36 747.908 70.36ZM759.085 77.512H757.261L754.417 72.34V77.5H752.641V69.1H754.417L757.345 74.524V69.1H759.085V77.512ZM765.49 69.4L765.202 70.804L764.458 70.6C763.93 70.48 763.47 70.42 763.078 70.42C762.534 70.42 762.262 70.68 762.262 71.2C762.262 71.4 762.354 71.584 762.538 71.752C762.73 71.912 762.97 72.048 763.258 72.16C763.546 72.264 763.854 72.396 764.182 72.556C764.51 72.716 764.818 72.888 765.106 73.072C765.394 73.256 765.63 73.508 765.814 73.828C766.006 74.148 766.102 74.516 766.102 74.932C766.102 75.756 765.834 76.404 765.298 76.876C764.77 77.34 764.022 77.572 763.054 77.572C762.558 77.572 762.062 77.508 761.566 77.38C761.078 77.244 760.674 77.088 760.354 76.912L760.87 75.628C761.606 75.964 762.334 76.132 763.054 76.132C763.462 76.132 763.782 76.04 764.014 75.856C764.246 75.664 764.362 75.42 764.362 75.124C764.362 74.828 764.23 74.584 763.966 74.392C763.702 74.192 763.382 74.016 763.006 73.864C762.63 73.704 762.254 73.528 761.878 73.336C761.502 73.136 761.182 72.86 760.918 72.508C760.654 72.148 760.522 71.724 760.522 71.236C760.522 70.508 760.75 69.952 761.206 69.568C761.662 69.176 762.274 68.98 763.042 68.98C763.818 68.98 764.634 69.12 765.49 69.4ZM772.855 76.78C772.319 77.308 771.543 77.572 770.527 77.572C769.511 77.572 768.735 77.308 768.199 76.78C767.663 76.244 767.395 75.452 767.395 74.404V69.1H769.147V74.548C769.147 75.076 769.263 75.484 769.495 75.772C769.735 76.052 770.075 76.192 770.515 76.192C770.955 76.192 771.295 76.052 771.535 75.772C771.783 75.484 771.907 75.076 771.907 74.548V69.1H773.659V74.404C773.659 75.452 773.391 76.244 772.855 76.78ZM782.924 77.5H781.184V72.292L779.684 75.532H778.172L776.672 72.304V77.5H774.944V69.1H776.792L778.94 73.6L781.184 69.1H782.924V77.5ZM789.215 77.5H784.211V69.1H789.215V70.48H785.951V72.244H788.915V73.648H785.951V76.12H789.215V77.5ZM792.599 73.852H792.455V77.488H790.715V69.088H793.379C794.283 69.088 794.959 69.288 795.407 69.688C795.855 70.08 796.079 70.644 796.079 71.38C796.079 71.828 795.923 72.24 795.611 72.616C795.299 72.984 794.919 73.196 794.471 73.252C794.791 73.34 795.039 73.488 795.215 73.696C795.391 73.896 795.575 74.224 795.767 74.68L796.955 77.488H795.167L794.003 74.8C793.835 74.416 793.655 74.164 793.463 74.044C793.279 73.916 792.991 73.852 792.599 73.852ZM793.331 70.456H792.455V72.484H793.211C793.531 72.484 793.779 72.38 793.955 72.172C794.139 71.964 794.231 71.708 794.231 71.404C794.231 70.772 793.931 70.456 793.331 70.456ZM802.65 69.4L802.362 70.804L801.618 70.6C801.09 70.48 800.63 70.42 800.238 70.42C799.694 70.42 799.422 70.68 799.422 71.2C799.422 71.4 799.514 71.584 799.698 71.752C799.89 71.912 800.13 72.048 800.418 72.16C800.706 72.264 801.014 72.396 801.342 72.556C801.67 72.716 801.978 72.888 802.266 73.072C802.554 73.256 802.79 73.508 802.974 73.828C803.166 74.148 803.262 74.516 803.262 74.932C803.262 75.756 802.994 76.404 802.458 76.876C801.93 77.34 801.182 77.572 800.214 77.572C799.718 77.572 799.222 77.508 798.726 77.38C798.238 77.244 797.834 77.088 797.514 76.912L798.03 75.628C798.766 75.964 799.494 76.132 800.214 76.132C800.622 76.132 800.942 76.04 801.174 75.856C801.406 75.664 801.522 75.42 801.522 75.124C801.522 74.828 801.39 74.584 801.126 74.392C800.862 74.192 800.542 74.016 800.166 73.864C799.79 73.704 799.414 73.528 799.038 73.336C798.662 73.136 798.342 72.86 798.078 72.508C797.814 72.148 797.682 71.724 797.682 71.236C797.682 70.508 797.91 69.952 798.366 69.568C798.822 69.176 799.434 68.98 800.202 68.98C800.978 68.98 801.794 69.12 802.65 69.4Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_6">
                  <g id="Container_6">
                    <g id="Icon_12">
                      <path
                        id="Vector_16"
                        d="M693.625 105.5H688.375C687.754 105.5 687.25 106.004 687.25 106.625V116.375C687.25 116.996 687.754 117.5 688.375 117.5H693.625C694.246 117.5 694.75 116.996 694.75 116.375V106.625C694.75 106.004 694.246 105.5 693.625 105.5ZM691 116.75C690.585 116.75 690.25 116.415 690.25 116C690.25 115.585 690.585 115.25 691 115.25C691.415 115.25 691.75 115.585 691.75 116C691.75 116.415 691.415 116.75 691 116.75ZM693.625 114.219C693.625 114.373 693.498 114.5 693.344 114.5H688.656C688.502 114.5 688.375 114.373 688.375 114.219V106.906C688.375 106.752 688.502 106.625 688.656 106.625H693.344C693.498 106.625 693.625 106.752 693.625 106.906V114.219Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_9"
                      d="M709.924 116.5H708.748L707.768 113.406H704.254L703.288 116.5H702.182L705.402 106.7H706.676L709.924 116.5ZM707.53 112.496L706.032 107.764L704.52 112.496H707.53ZM712.431 119.832H711.381V109.514H711.997L712.361 110.298C712.753 109.999 713.117 109.771 713.453 109.612C713.799 109.444 714.177 109.36 714.587 109.36C716.267 109.36 717.107 110.569 717.107 112.986C717.107 114.358 716.809 115.315 716.211 115.856C715.679 116.351 715.073 116.598 714.391 116.598C713.719 116.598 713.066 116.374 712.431 115.926V119.832ZM712.431 111.236V114.974C712.618 115.198 712.87 115.375 713.187 115.506C713.505 115.637 713.808 115.702 714.097 115.702C714.825 115.702 715.334 115.487 715.623 115.058C715.913 114.629 716.057 113.957 716.057 113.042C716.057 112.127 715.913 111.437 715.623 110.97C715.334 110.503 714.965 110.27 714.517 110.27C714.219 110.27 713.92 110.331 713.621 110.452C713.332 110.573 713.113 110.69 712.963 110.802C712.823 110.905 712.646 111.049 712.431 111.236ZM720.074 119.832H719.024V109.514H719.64L720.004 110.298C720.396 109.999 720.76 109.771 721.096 109.612C721.441 109.444 721.819 109.36 722.23 109.36C723.91 109.36 724.75 110.569 724.75 112.986C724.75 114.358 724.451 115.315 723.854 115.856C723.322 116.351 722.715 116.598 722.034 116.598C721.362 116.598 720.709 116.374 720.074 115.926V119.832ZM720.074 111.236V114.974C720.261 115.198 720.513 115.375 720.83 115.506C721.147 115.637 721.451 115.702 721.74 115.702C722.468 115.702 722.977 115.487 723.266 115.058C723.555 114.629 723.7 113.957 723.7 113.042C723.7 112.127 723.555 111.437 723.266 110.97C722.977 110.503 722.608 110.27 722.16 110.27C721.861 110.27 721.563 110.331 721.264 110.452C720.975 110.573 720.755 110.69 720.606 110.802C720.466 110.905 720.289 111.049 720.074 111.236ZM726.401 115.254C727.007 115.534 727.586 115.674 728.137 115.674C728.687 115.674 729.103 115.567 729.383 115.352C729.672 115.128 729.817 114.834 729.817 114.47C729.817 114.106 729.695 113.826 729.453 113.63C729.21 113.425 728.911 113.266 728.557 113.154C728.211 113.042 727.861 112.921 727.507 112.79C727.161 112.659 726.867 112.463 726.625 112.202C726.382 111.941 726.261 111.609 726.261 111.208C726.261 110.62 726.452 110.167 726.835 109.85C727.217 109.523 727.735 109.36 728.389 109.36C729.042 109.36 729.649 109.458 730.209 109.654L730.307 109.696L730.125 110.592C729.565 110.377 729.042 110.27 728.557 110.27C728.081 110.27 727.754 110.345 727.577 110.494C727.399 110.643 727.311 110.895 727.311 111.25C727.311 111.474 727.432 111.665 727.675 111.824C727.917 111.983 728.211 112.123 728.557 112.244C728.911 112.356 729.261 112.491 729.607 112.65C729.961 112.799 730.26 113.028 730.503 113.336C730.745 113.644 730.867 114.022 730.867 114.47C730.867 115.123 730.638 115.641 730.181 116.024C729.723 116.397 729.093 116.584 728.291 116.584C727.488 116.584 726.774 116.402 726.149 116.038L726.401 115.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="672.5"
                    y="90"
                    width="131"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_7">
                  <g id="Container_7">
                    <g id="Icon_13">
                      <path
                        id="Vector_17"
                        d="M696.25 161.25H685.75C685.336 161.25 685 160.914 685 160.5V159C685 158.586 685.336 158.25 685.75 158.25H696.25C696.664 158.25 697 158.586 697 159V160.5C697 160.914 696.664 161.25 696.25 161.25ZM695.125 159.188C694.814 159.188 694.562 159.439 694.562 159.75C694.562 160.061 694.814 160.312 695.125 160.312C695.436 160.312 695.688 160.061 695.688 159.75C695.688 159.439 695.436 159.188 695.125 159.188ZM693.625 159.188C693.314 159.188 693.062 159.439 693.062 159.75C693.062 160.061 693.314 160.312 693.625 160.312C693.936 160.312 694.188 160.061 694.188 159.75C694.188 159.439 693.936 159.188 693.625 159.188ZM696.25 165H685.75C685.336 165 685 164.664 685 164.25V162.75C685 162.336 685.336 162 685.75 162H696.25C696.664 162 697 162.336 697 162.75V164.25C697 164.664 696.664 165 696.25 165ZM695.125 162.938C694.814 162.938 694.562 163.189 694.562 163.5C694.562 163.811 694.814 164.062 695.125 164.062C695.436 164.062 695.688 163.811 695.688 163.5C695.688 163.189 695.436 162.938 695.125 162.938ZM693.625 162.938C693.314 162.938 693.062 163.189 693.062 163.5C693.062 163.811 693.314 164.062 693.625 164.062C693.936 164.062 694.188 163.811 694.188 163.5C694.188 163.189 693.936 162.938 693.625 162.938ZM696.25 168.75H685.75C685.336 168.75 685 168.414 685 168V166.5C685 166.086 685.336 165.75 685.75 165.75H696.25C696.664 165.75 697 166.086 697 166.5V168C697 168.414 696.664 168.75 696.25 168.75ZM695.125 166.688C694.814 166.688 694.562 166.939 694.562 167.25C694.562 167.561 694.814 167.812 695.125 167.812C695.436 167.812 695.688 167.561 695.688 167.25C695.688 166.939 695.436 166.688 695.125 166.688ZM693.625 166.688C693.314 166.688 693.062 166.939 693.062 167.25C693.062 167.561 693.314 167.812 693.625 167.812C693.936 167.812 694.188 167.561 694.188 167.25C694.188 166.939 693.936 166.688 693.625 166.688Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_10"
                      d="M710.358 163.25C710.358 164.827 709.901 166.097 708.986 167.058C708.071 168.019 706.849 168.5 705.318 168.5H703.274V158.7H705.752C707.143 158.7 708.258 159.125 709.098 159.974C709.938 160.823 710.358 161.915 710.358 163.25ZM709.224 163.138C709.224 162.037 708.888 161.173 708.216 160.548C707.544 159.923 706.741 159.61 705.808 159.61H704.408V167.59H705.444C706.499 167.59 707.39 167.193 708.118 166.4C708.855 165.607 709.224 164.519 709.224 163.138ZM715.362 164.314H715.936C715.936 163.465 715.829 162.914 715.614 162.662C715.4 162.401 714.924 162.27 714.186 162.27C713.449 162.27 712.824 162.368 712.31 162.564L712.114 161.752C712.898 161.491 713.71 161.36 714.55 161.36C716.193 161.36 717.014 162.181 717.014 163.824V168.5H716.398L716.034 167.674C715.605 168.029 715.232 168.271 714.914 168.402C714.606 168.523 714.247 168.584 713.836 168.584C713.183 168.584 712.674 168.393 712.31 168.01C711.946 167.618 711.764 167.105 711.764 166.47C711.764 165.033 712.964 164.314 715.362 164.314ZM715.95 165.196H715.32C714.368 165.196 713.71 165.289 713.346 165.476C712.992 165.663 712.814 165.957 712.814 166.358C712.814 166.75 712.917 167.072 713.122 167.324C713.328 167.576 713.594 167.702 713.92 167.702C714.256 167.702 714.574 167.627 714.872 167.478C715.18 167.319 715.54 167.049 715.95 166.666V165.196ZM719.725 166.988V162.34H718.773V161.5H719.739V159.498H720.789V161.5H722.497V162.34H720.775V166.792C720.775 167.417 721.093 167.73 721.727 167.73C721.877 167.73 722.105 167.702 722.413 167.646L722.567 168.402C722.185 168.523 721.788 168.584 721.377 168.584C720.976 168.584 720.598 168.463 720.243 168.22C719.898 167.968 719.725 167.557 719.725 166.988ZM727.421 164.314H727.995C727.995 163.465 727.888 162.914 727.673 162.662C727.458 162.401 726.982 162.27 726.245 162.27C725.508 162.27 724.882 162.368 724.369 162.564L724.173 161.752C724.957 161.491 725.769 161.36 726.609 161.36C728.252 161.36 729.073 162.181 729.073 163.824V168.5H728.457L728.093 167.674C727.664 168.029 727.29 168.271 726.973 168.402C726.665 168.523 726.306 168.584 725.895 168.584C725.242 168.584 724.733 168.393 724.369 168.01C724.005 167.618 723.823 167.105 723.823 166.47C723.823 165.033 725.022 164.314 727.421 164.314ZM728.009 165.196H727.379C726.427 165.196 725.769 165.289 725.405 165.476C725.05 165.663 724.873 165.957 724.873 166.358C724.873 166.75 724.976 167.072 725.181 167.324C725.386 167.576 725.652 167.702 725.979 167.702C726.315 167.702 726.632 167.627 726.931 167.478C727.239 167.319 727.598 167.049 728.009 166.666V165.196ZM737.594 164.384H736.166V168.5H735.116V158.7H737.916C738.961 158.7 739.717 158.929 740.184 159.386C740.66 159.843 740.898 160.557 740.898 161.528C740.898 162.489 740.608 163.208 740.03 163.684C739.451 164.151 738.639 164.384 737.594 164.384ZM737.44 159.596H736.166V163.488H737.09C738.051 163.488 738.751 163.343 739.19 163.054C739.628 162.765 739.848 162.27 739.848 161.57C739.848 160.861 739.656 160.357 739.274 160.058C738.891 159.75 738.28 159.596 737.44 159.596ZM742.69 168.5V158.7H743.74V168.5H742.69ZM749.31 164.314H749.884C749.884 163.465 749.776 162.914 749.562 162.662C749.347 162.401 748.871 162.27 748.134 162.27C747.396 162.27 746.771 162.368 746.258 162.564L746.062 161.752C746.846 161.491 747.658 161.36 748.498 161.36C750.14 161.36 750.962 162.181 750.962 163.824V168.5H750.346L749.982 167.674C749.552 168.029 749.179 168.271 748.862 168.402C748.554 168.523 748.194 168.584 747.784 168.584C747.13 168.584 746.622 168.393 746.258 168.01C745.894 167.618 745.712 167.105 745.712 166.47C745.712 165.033 746.911 164.314 749.31 164.314ZM749.898 165.196H749.268C748.316 165.196 747.658 165.289 747.294 165.476C746.939 165.663 746.762 165.957 746.762 166.358C746.762 166.75 746.864 167.072 747.07 167.324C747.275 167.576 747.541 167.702 747.868 167.702C748.204 167.702 748.521 167.627 748.82 167.478C749.128 167.319 749.487 167.049 749.898 166.666V165.196ZM753.672 166.988V162.34H752.72V161.5H753.686V159.498H754.736V161.5H756.444V162.34H754.722V166.792C754.722 167.417 755.04 167.73 755.674 167.73C755.824 167.73 756.052 167.702 756.36 167.646L756.514 168.402C756.132 168.523 755.735 168.584 755.324 168.584C754.923 168.584 754.545 168.463 754.19 168.22C753.845 167.968 753.672 167.557 753.672 166.988ZM758.652 161.5V160.156C758.652 159.587 758.825 159.181 759.17 158.938C759.525 158.686 759.903 158.56 760.304 158.56C760.715 158.56 761.112 158.621 761.494 158.742L761.34 159.498C761.032 159.442 760.804 159.414 760.654 159.414C760.01 159.414 759.688 159.727 759.688 160.352V161.5H761.116V162.34H759.688V168.5H758.638V162.34H757.56V161.5H758.652ZM766.745 165.056C766.745 164.151 766.567 163.46 766.213 162.984C765.858 162.508 765.34 162.27 764.659 162.27C763.977 162.27 763.492 162.499 763.203 162.956C762.923 163.404 762.783 164.095 762.783 165.028C762.783 166.792 763.431 167.674 764.729 167.674C765.41 167.674 765.914 167.464 766.241 167.044C766.577 166.615 766.745 165.952 766.745 165.056ZM766.997 167.632C766.465 168.267 765.713 168.584 764.743 168.584C763.772 168.584 763.025 168.271 762.503 167.646C761.989 167.011 761.733 166.129 761.733 165C761.733 163.861 761.98 162.97 762.475 162.326C762.979 161.682 763.711 161.36 764.673 161.36C765.643 161.36 766.404 161.687 766.955 162.34C767.515 162.993 767.795 163.88 767.795 165C767.795 166.12 767.529 166.997 766.997 167.632ZM770.715 163.152V168.5H769.665V161.5H770.337L770.505 162.326C770.953 161.971 771.326 161.724 771.625 161.584C771.923 161.435 772.264 161.36 772.647 161.36C772.833 161.36 772.973 161.369 773.067 161.388L773.263 161.444L773.095 162.41C772.927 162.354 772.698 162.326 772.409 162.326C771.849 162.326 771.284 162.601 770.715 163.152ZM777.814 161.346C778.71 161.346 779.349 161.663 779.732 162.298C780.525 161.663 781.258 161.346 781.93 161.346C782.602 161.346 783.148 161.537 783.568 161.92C783.997 162.293 784.212 162.839 784.212 163.558V168.5H783.19V163.992C783.19 163.423 783.059 162.993 782.798 162.704C782.546 162.405 782.205 162.256 781.776 162.256C781.188 162.256 780.595 162.489 779.998 162.956C780.045 163.161 780.068 163.362 780.068 163.558V168.5H779.046V163.992C779.046 163.423 778.915 162.993 778.654 162.704C778.402 162.405 778.061 162.256 777.632 162.256C777.352 162.256 777.095 162.293 776.862 162.368C776.629 162.443 776.456 162.517 776.344 162.592C776.232 162.667 776.087 162.779 775.91 162.928V168.5H774.86V161.5H775.532L775.714 162.214C775.947 162.018 776.125 161.878 776.246 161.794C776.377 161.701 776.587 161.603 776.876 161.5C777.165 161.397 777.478 161.346 777.814 161.346ZM786.488 167.254C787.095 167.534 787.674 167.674 788.224 167.674C788.775 167.674 789.19 167.567 789.47 167.352C789.76 167.128 789.904 166.834 789.904 166.47C789.904 166.106 789.783 165.826 789.54 165.63C789.298 165.425 788.999 165.266 788.644 165.154C788.299 165.042 787.949 164.921 787.594 164.79C787.249 164.659 786.955 164.463 786.712 164.202C786.47 163.941 786.348 163.609 786.348 163.208C786.348 162.62 786.54 162.167 786.922 161.85C787.305 161.523 787.823 161.36 788.476 161.36C789.13 161.36 789.736 161.458 790.296 161.654L790.394 161.696L790.212 162.592C789.652 162.377 789.13 162.27 788.644 162.27C788.168 162.27 787.842 162.345 787.664 162.494C787.487 162.643 787.398 162.895 787.398 163.25C787.398 163.474 787.52 163.665 787.762 163.824C788.005 163.983 788.299 164.123 788.644 164.244C788.999 164.356 789.349 164.491 789.694 164.65C790.049 164.799 790.348 165.028 790.59 165.336C790.833 165.644 790.954 166.022 790.954 166.47C790.954 167.123 790.726 167.641 790.268 168.024C789.811 168.397 789.181 168.584 788.378 168.584C787.576 168.584 786.862 168.402 786.236 168.038L786.488 167.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="672.5"
                    y="142"
                    width="131"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_8">
                  <g id="Container_8">
                    <g id="Icon_14">
                      <path
                        id="Vector_18"
                        d="M692.2 216.7H689.8C689.469 216.7 689.2 216.969 689.2 217.3V219.7C689.2 220.031 689.469 220.3 689.8 220.3H692.2C692.531 220.3 692.8 220.031 692.8 219.7V217.3C692.8 216.969 692.531 216.7 692.2 216.7ZM688.6 211.3C688.6 210.969 688.331 210.7 688 210.7H685.6C685.269 210.7 685 210.969 685 211.3V213.7C685 214.031 685.269 214.3 685.6 214.3H687.395L688.767 216.701C688.975 216.343 689.358 216.1 689.8 216.1H689.805L688.6 213.991V213.1H692.8V211.9H688.6V211.3ZM696.4 210.7H694C693.669 210.7 693.4 210.969 693.4 211.3V213.7C693.4 214.031 693.669 214.3 694 214.3H696.4C696.731 214.3 697 214.031 697 213.7V211.3C697 210.969 696.731 210.7 696.4 210.7Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_11"
                      d="M706.522 220.57C705.243 220.57 704.277 220.099 703.624 219.156C702.971 218.204 702.644 216.995 702.644 215.53C702.644 214.065 702.971 212.87 703.624 211.946C704.287 211.022 705.253 210.56 706.522 210.56C707.801 210.56 708.771 211.022 709.434 211.946C710.097 212.87 710.428 214.065 710.428 215.53C710.428 217.537 709.859 218.983 708.72 219.87C708.113 220.337 707.381 220.57 706.522 220.57ZM706.55 211.47C705.598 211.47 704.884 211.867 704.408 212.66C703.941 213.453 703.708 214.424 703.708 215.572C703.708 216.72 703.946 217.686 704.422 218.47C704.907 219.254 705.617 219.646 706.55 219.646C707.483 219.646 708.188 219.249 708.664 218.456C709.14 217.663 709.378 216.664 709.378 215.46C709.378 213.948 708.953 212.819 708.104 212.072C707.665 211.671 707.147 211.47 706.55 211.47ZM712.52 218.988V214.34H711.568V213.5H712.534V211.498H713.584V213.5H715.292V214.34H713.57V218.792C713.57 219.417 713.887 219.73 714.522 219.73C714.671 219.73 714.9 219.702 715.208 219.646L715.362 220.402C714.979 220.523 714.583 220.584 714.172 220.584C713.771 220.584 713.393 220.463 713.038 220.22C712.693 219.968 712.52 219.557 712.52 218.988ZM722.428 220.5H721.378V215.894C721.378 214.765 720.907 214.2 719.964 214.2C719.264 214.2 718.69 214.424 718.242 214.872V220.5H717.192V210.7H718.228V214.018C718.433 213.85 718.592 213.729 718.704 213.654C718.825 213.579 719.017 213.505 719.278 213.43C719.549 213.355 719.852 213.318 720.188 213.318C720.832 213.318 721.364 213.514 721.784 213.906C722.213 214.298 722.428 214.858 722.428 215.586V220.5ZM729.829 217.224H725.363C725.363 218.12 725.573 218.755 725.993 219.128C726.423 219.501 726.959 219.688 727.603 219.688C727.93 219.688 728.159 219.674 728.289 219.646C728.42 219.609 728.541 219.576 728.653 219.548C728.775 219.511 728.859 219.483 728.905 219.464C729.139 219.399 729.339 219.338 729.507 219.282L729.675 220.094C728.742 220.421 728.014 220.584 727.491 220.584C726.53 220.584 725.76 220.295 725.181 219.716C724.603 219.128 724.313 218.251 724.313 217.084C724.313 215.908 724.584 214.993 725.125 214.34C725.676 213.687 726.367 213.36 727.197 213.36C728.037 213.36 728.691 213.631 729.157 214.172C729.624 214.713 729.857 215.446 729.857 216.37C729.857 216.622 729.848 216.907 729.829 217.224ZM725.433 216.426H728.849C728.849 215.735 728.728 215.203 728.485 214.83C728.243 214.457 727.818 214.27 727.211 214.27C726.614 214.27 726.175 214.471 725.895 214.872C725.615 215.273 725.461 215.791 725.433 216.426ZM732.871 215.152V220.5H731.821V213.5H732.493L732.661 214.326C733.109 213.971 733.482 213.724 733.781 213.584C734.08 213.435 734.42 213.36 734.803 213.36C734.99 213.36 735.13 213.369 735.223 213.388L735.419 213.444L735.251 214.41C735.083 214.354 734.854 214.326 734.565 214.326C734.005 214.326 733.44 214.601 732.871 215.152ZM745.444 211.05L745.22 211.988L744.408 211.75C743.83 211.61 743.33 211.54 742.91 211.54C741.809 211.54 741.258 212.03 741.258 213.01C741.258 213.439 741.426 213.794 741.762 214.074C742.098 214.345 742.504 214.564 742.98 214.732C743.466 214.891 743.946 215.068 744.422 215.264C744.908 215.451 745.318 215.745 745.654 216.146C745.99 216.538 746.158 217.037 746.158 217.644C746.158 218.568 745.874 219.291 745.304 219.814C744.735 220.327 743.928 220.584 742.882 220.584C742.36 220.584 741.832 220.509 741.3 220.36C740.778 220.201 740.348 220.019 740.012 219.814L740.362 219.016C741.212 219.408 742.014 219.604 742.77 219.604C743.536 219.604 744.114 219.45 744.506 219.142C744.908 218.834 745.108 218.386 745.108 217.798C745.108 217.201 744.786 216.734 744.142 216.398C743.853 216.249 743.531 216.109 743.176 215.978C742.831 215.847 742.481 215.707 742.126 215.558C741.781 215.399 741.464 215.222 741.174 215.026C740.894 214.83 740.661 214.564 740.474 214.228C740.297 213.892 740.208 213.5 740.208 213.052C740.208 212.249 740.446 211.633 740.922 211.204C741.408 210.775 742.056 210.56 742.868 210.56C743.68 210.56 744.539 210.723 745.444 211.05ZM753.085 217.224H748.619C748.619 218.12 748.829 218.755 749.249 219.128C749.678 219.501 750.215 219.688 750.859 219.688C751.186 219.688 751.414 219.674 751.545 219.646C751.676 219.609 751.797 219.576 751.909 219.548C752.03 219.511 752.114 219.483 752.161 219.464C752.394 219.399 752.595 219.338 752.763 219.282L752.931 220.094C751.998 220.421 751.27 220.584 750.747 220.584C749.786 220.584 749.016 220.295 748.437 219.716C747.858 219.128 747.569 218.251 747.569 217.084C747.569 215.908 747.84 214.993 748.381 214.34C748.932 213.687 749.622 213.36 750.453 213.36C751.293 213.36 751.946 213.631 752.413 214.172C752.88 214.713 753.113 215.446 753.113 216.37C753.113 216.622 753.104 216.907 753.085 217.224ZM748.689 216.426H752.105C752.105 215.735 751.984 215.203 751.741 214.83C751.498 214.457 751.074 214.27 750.467 214.27C749.87 214.27 749.431 214.471 749.151 214.872C748.871 215.273 748.717 215.791 748.689 216.426ZM756.127 215.152V220.5H755.077V213.5H755.749L755.917 214.326C756.365 213.971 756.738 213.724 757.037 213.584C757.335 213.435 757.676 213.36 758.059 213.36C758.245 213.36 758.385 213.369 758.479 213.388L758.675 213.444L758.507 214.41C758.339 214.354 758.11 214.326 757.821 214.326C757.261 214.326 756.696 214.601 756.127 215.152ZM765.074 213.486L762.708 220.5H761.504L759.152 213.486H760.342L762.12 219.38L763.912 213.486H765.074ZM766.31 220.5V213.5H767.36V220.5H766.31ZM767.36 210.7V211.946H766.31V210.7H767.36ZM773.808 219.408L774.018 220.234C773.271 220.458 772.613 220.57 772.044 220.57C771.045 220.57 770.294 220.243 769.79 219.59C769.286 218.937 769.034 218.036 769.034 216.888C769.034 215.74 769.295 214.867 769.818 214.27C770.341 213.663 771.111 213.36 772.128 213.36C772.567 213.36 773.183 213.472 773.976 213.696L773.556 214.508C773.043 214.359 772.581 214.284 772.17 214.284C771.461 214.284 770.947 214.494 770.63 214.914C770.322 215.334 770.168 215.997 770.168 216.902C770.168 218.741 770.826 219.66 772.142 219.66C772.665 219.66 773.22 219.576 773.808 219.408ZM780.607 217.224H776.141C776.141 218.12 776.351 218.755 776.771 219.128C777.2 219.501 777.737 219.688 778.381 219.688C778.707 219.688 778.936 219.674 779.067 219.646C779.197 219.609 779.319 219.576 779.431 219.548C779.552 219.511 779.636 219.483 779.683 219.464C779.916 219.399 780.117 219.338 780.285 219.282L780.453 220.094C779.519 220.421 778.791 220.584 778.269 220.584C777.307 220.584 776.537 220.295 775.959 219.716C775.38 219.128 775.091 218.251 775.091 217.084C775.091 215.908 775.361 214.993 775.903 214.34C776.453 213.687 777.144 213.36 777.975 213.36C778.815 213.36 779.468 213.631 779.935 214.172C780.401 214.713 780.635 215.446 780.635 216.37C780.635 216.622 780.625 216.907 780.607 217.224ZM776.211 216.426H779.627C779.627 215.735 779.505 215.203 779.263 214.83C779.02 214.457 778.595 214.27 777.989 214.27C777.391 214.27 776.953 214.471 776.673 214.872C776.393 215.273 776.239 215.791 776.211 216.426ZM782.332 219.254C782.939 219.534 783.518 219.674 784.068 219.674C784.619 219.674 785.034 219.567 785.314 219.352C785.604 219.128 785.748 218.834 785.748 218.47C785.748 218.106 785.627 217.826 785.384 217.63C785.142 217.425 784.843 217.266 784.488 217.154C784.143 217.042 783.793 216.921 783.438 216.79C783.093 216.659 782.799 216.463 782.556 216.202C782.314 215.941 782.192 215.609 782.192 215.208C782.192 214.62 782.384 214.167 782.766 213.85C783.149 213.523 783.667 213.36 784.32 213.36C784.974 213.36 785.58 213.458 786.14 213.654L786.238 213.696L786.056 214.592C785.496 214.377 784.974 214.27 784.488 214.27C784.012 214.27 783.686 214.345 783.508 214.494C783.331 214.643 783.242 214.895 783.242 215.25C783.242 215.474 783.364 215.665 783.606 215.824C783.849 215.983 784.143 216.123 784.488 216.244C784.843 216.356 785.193 216.491 785.538 216.65C785.893 216.799 786.192 217.028 786.434 217.336C786.677 217.644 786.798 218.022 786.798 218.47C786.798 219.123 786.57 219.641 786.112 220.024C785.655 220.397 785.025 220.584 784.222 220.584C783.42 220.584 782.706 220.402 782.08 220.038L782.332 219.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="672.5"
                    y="194"
                    width="131"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
              </g>
            </g>
          </g>
          <rect
            x="0.5"
            y="1"
            width="823"
            height="256"
            rx="3.5"
            stroke="#CBD5E1"
          />
        </g>
        <defs>
          <filter
            id="filter0_d_190_9079"
            x="310"
            y="19.5"
            width="204"
            height="48"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feMorphology
              radius="2"
              operator="dilate"
              in="SourceAlpha"
              result="effect1_dropShadow_190_9079"
            />
            <feOffset />
            <feComposite in2="hardAlpha" operator="out" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0.992157 0 0 0 0 0.901961 0 0 0 0 0.541176 0 0 0 1 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_190_9079"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_190_9079"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_190_9079"
            x="310"
            y="144.5"
            width="204"
            height="96"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_190_9079"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_190_9079"
              result="shape"
            />
          </filter>
          <clipPath id="clip0_190_9079">
            <rect
              x="312"
              y="21.5"
              width="200"
              height="44"
              rx="4"
              fill="white"
            />
          </clipPath>
        </defs>
      </svg>
    ) : (
      <svg
        width="100%"
        height="100%"
        viewBox="0 0 823 258"
        fill="none"
        className={clsx('w-full max-w-screen-md', className)}
        xmlns="http://www.w3.org/2000/svg"
      >
        <g id="Variant=Disabled">
          <rect
            x="0.5"
            y="1"
            width="823"
            height="256"
            rx="3.5"
            fill="#E2E8F0"
          />
          <g id="Left">
            <g id="Col1">
              <g id="Cards">
                <g id="SchemaTitle">
                  <path
                    id="Title"
                    d="M25.556 69.4L25.268 70.804L24.524 70.6C23.996 70.48 23.536 70.42 23.144 70.42C22.6 70.42 22.328 70.68 22.328 71.2C22.328 71.4 22.42 71.584 22.604 71.752C22.796 71.912 23.036 72.048 23.324 72.16C23.612 72.264 23.92 72.396 24.248 72.556C24.576 72.716 24.884 72.888 25.172 73.072C25.46 73.256 25.696 73.508 25.88 73.828C26.072 74.148 26.168 74.516 26.168 74.932C26.168 75.756 25.9 76.404 25.364 76.876C24.836 77.34 24.088 77.572 23.12 77.572C22.624 77.572 22.128 77.508 21.632 77.38C21.144 77.244 20.74 77.088 20.42 76.912L20.936 75.628C21.672 75.964 22.4 76.132 23.12 76.132C23.528 76.132 23.848 76.04 24.08 75.856C24.312 75.664 24.428 75.42 24.428 75.124C24.428 74.828 24.296 74.584 24.032 74.392C23.768 74.192 23.448 74.016 23.072 73.864C22.696 73.704 22.32 73.528 21.944 73.336C21.568 73.136 21.248 72.86 20.984 72.508C20.72 72.148 20.588 71.724 20.588 71.236C20.588 70.508 20.816 69.952 21.272 69.568C21.728 69.176 22.34 68.98 23.108 68.98C23.884 68.98 24.7 69.12 25.556 69.4ZM30.4854 77.56C29.3094 77.56 28.4214 77.156 27.8214 76.348C27.2214 75.532 26.9214 74.496 26.9214 73.24C26.9214 71.984 27.2214 70.96 27.8214 70.168C28.4294 69.376 29.3174 68.98 30.4854 68.98C31.6614 68.98 32.5534 69.376 33.1614 70.168C33.7694 70.96 34.0734 71.984 34.0734 73.24C34.0734 74.96 33.5494 76.2 32.5014 76.96C31.9494 77.36 31.2774 77.56 30.4854 77.56ZM30.5094 70.36C30.0854 70.36 29.7294 70.508 29.4414 70.804C28.9294 71.316 28.6734 72.128 28.6734 73.24C28.6734 74.08 28.8294 74.78 29.1414 75.34C29.4534 75.892 29.9094 76.168 30.5094 76.168C31.1174 76.168 31.5734 75.888 31.8774 75.328C32.1814 74.76 32.3334 74.072 32.3334 73.264C32.3334 72.448 32.1694 71.76 31.8414 71.2C31.5214 70.64 31.0774 70.36 30.5094 70.36ZM40.7026 76.78C40.1666 77.308 39.3906 77.572 38.3746 77.572C37.3586 77.572 36.5826 77.308 36.0466 76.78C35.5106 76.244 35.2426 75.452 35.2426 74.404V69.1H36.9946V74.548C36.9946 75.076 37.1106 75.484 37.3426 75.772C37.5826 76.052 37.9226 76.192 38.3626 76.192C38.8026 76.192 39.1426 76.052 39.3826 75.772C39.6306 75.484 39.7546 75.076 39.7546 74.548V69.1H41.5066V74.404C41.5066 75.452 41.2386 76.244 40.7026 76.78ZM45.0954 73.852H44.9514V77.488H43.2114V69.088H45.8754C46.7794 69.088 47.4554 69.288 47.9034 69.688C48.3514 70.08 48.5754 70.644 48.5754 71.38C48.5754 71.828 48.4194 72.24 48.1074 72.616C47.7954 72.984 47.4154 73.196 46.9674 73.252C47.2874 73.34 47.5354 73.488 47.7114 73.696C47.8874 73.896 48.0714 74.224 48.2634 74.68L49.4514 77.488H47.6634L46.4994 74.8C46.3314 74.416 46.1514 74.164 45.9594 74.044C45.7754 73.916 45.4874 73.852 45.0954 73.852ZM45.8274 70.456H44.9514V72.484H45.7074C46.0274 72.484 46.2754 72.38 46.4514 72.172C46.6354 71.964 46.7274 71.708 46.7274 71.404C46.7274 70.772 46.4274 70.456 45.8274 70.456ZM53.7418 77.572C52.5178 77.572 51.5778 77.188 50.9218 76.42C50.2738 75.644 49.9498 74.596 49.9498 73.276C49.9498 71.956 50.2938 70.912 50.9818 70.144C51.6778 69.376 52.6418 68.992 53.8738 68.992C54.5458 68.992 55.2138 69.108 55.8778 69.34L55.5418 70.684C55.0538 70.476 54.4778 70.372 53.8138 70.372C53.1498 70.372 52.6298 70.624 52.2538 71.128C51.8778 71.632 51.6898 72.328 51.6898 73.216C51.6898 74.104 51.8658 74.824 52.2178 75.376C52.5698 75.92 53.0658 76.192 53.7058 76.192C54.1858 76.192 54.8698 76.036 55.7578 75.724L56.1178 76.948C55.3898 77.364 54.5978 77.572 53.7418 77.572ZM62.4537 77.5H57.4497V69.1H62.4537V70.48H59.1897V72.244H62.1537V73.648H59.1897V76.12H62.4537V77.5ZM68.6576 69.4L68.3696 70.804L67.6256 70.6C67.0976 70.48 66.6376 70.42 66.2456 70.42C65.7016 70.42 65.4296 70.68 65.4296 71.2C65.4296 71.4 65.5216 71.584 65.7056 71.752C65.8976 71.912 66.1376 72.048 66.4256 72.16C66.7136 72.264 67.0216 72.396 67.3496 72.556C67.6776 72.716 67.9856 72.888 68.2736 73.072C68.5616 73.256 68.7976 73.508 68.9816 73.828C69.1736 74.148 69.2696 74.516 69.2696 74.932C69.2696 75.756 69.0016 76.404 68.4656 76.876C67.9376 77.34 67.1896 77.572 66.2216 77.572C65.7256 77.572 65.2296 77.508 64.7336 77.38C64.2456 77.244 63.8416 77.088 63.5216 76.912L64.0376 75.628C64.7736 75.964 65.5016 76.132 66.2216 76.132C66.6296 76.132 66.9496 76.04 67.1816 75.856C67.4136 75.664 67.5296 75.42 67.5296 75.124C67.5296 74.828 67.3976 74.584 67.1336 74.392C66.8696 74.192 66.5496 74.016 66.1736 73.864C65.7976 73.704 65.4216 73.528 65.0456 73.336C64.6696 73.136 64.3496 72.86 64.0856 72.508C63.8216 72.148 63.6896 71.724 63.6896 71.236C63.6896 70.508 63.9176 69.952 64.3736 69.568C64.8296 69.176 65.4416 68.98 66.2096 68.98C66.9856 68.98 67.8016 69.12 68.6576 69.4Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="SchemaCard">
                  <g id="Container">
                    <g id="Icon">
                      <path
                        id="Vector"
                        d="M42.6025 110.295L42.4488 110.563C42.3925 110.663 42.2725 110.704 42.1657 110.665C41.9444 110.582 41.7419 110.464 41.5638 110.316C41.4775 110.245 41.455 110.119 41.5113 110.022L41.665 109.753C41.5357 109.603 41.4344 109.429 41.3669 109.24H41.0575C40.945 109.24 40.8475 109.159 40.8288 109.047C40.7913 108.822 40.7894 108.585 40.8288 108.351C40.8475 108.238 40.945 108.156 41.0575 108.156H41.3669C41.4344 107.967 41.5357 107.792 41.665 107.642L41.5113 107.374C41.455 107.277 41.4757 107.151 41.5638 107.08C41.7419 106.932 41.9463 106.813 42.1657 106.731C42.2725 106.692 42.3925 106.733 42.4488 106.832L42.6025 107.1C42.7994 107.065 43 107.065 43.1969 107.1L43.3507 106.832C43.4069 106.733 43.5269 106.692 43.6338 106.731C43.855 106.813 44.0575 106.932 44.2357 107.08C44.3219 107.151 44.3444 107.277 44.2882 107.374L44.1344 107.642C44.2638 107.792 44.365 107.967 44.4325 108.156H44.7419C44.8544 108.156 44.9519 108.237 44.9707 108.349C45.0082 108.574 45.01 108.81 44.9707 109.045C44.9519 109.157 44.8544 109.24 44.7419 109.24H44.4325C44.365 109.429 44.2638 109.603 44.1344 109.753L44.2882 110.022C44.3444 110.119 44.3238 110.245 44.2357 110.316C44.0575 110.464 43.8532 110.582 43.6338 110.665C43.5269 110.704 43.4069 110.663 43.3507 110.563L43.1969 110.295C43.0019 110.331 42.7994 110.331 42.6025 110.295ZM42.4057 109.193C43.1275 109.748 43.9507 108.925 43.3957 108.203C42.6738 107.646 41.8507 108.471 42.4057 109.193ZM40.2438 112.078L40.8757 112.393C41.065 112.502 41.1475 112.733 41.0725 112.939C40.9057 113.393 40.5775 113.809 40.2738 114.173C40.135 114.34 39.895 114.381 39.7057 114.272L39.16 113.957C38.86 114.214 38.5113 114.418 38.1307 114.552V115.182C38.1307 115.399 37.975 115.587 37.7613 115.624C37.3 115.703 36.8163 115.707 36.3382 115.624C36.1225 115.587 35.9632 115.401 35.9632 115.182V114.552C35.5825 114.417 35.2338 114.214 34.9338 113.957L34.3882 114.27C34.2007 114.379 33.9588 114.338 33.82 114.171C33.5163 113.807 33.1957 113.391 33.0288 112.939C32.9538 112.735 33.0363 112.504 33.2257 112.393L33.85 112.078C33.7769 111.687 33.7769 111.283 33.85 110.89L33.2257 110.573C33.0363 110.464 32.9519 110.233 33.0288 110.029C33.1957 109.575 33.5163 109.159 33.82 108.795C33.9588 108.628 34.1988 108.587 34.3882 108.696L34.9338 109.011C35.2338 108.754 35.5825 108.55 35.9632 108.417V107.785C35.9632 107.569 36.1169 107.382 36.3307 107.344C36.7919 107.265 37.2775 107.262 37.7557 107.342C37.9713 107.38 38.1307 107.565 38.1307 107.785V108.415C38.5113 108.55 38.86 108.752 39.16 109.009L39.7057 108.694C39.8932 108.585 40.135 108.627 40.2738 108.793C40.5775 109.157 40.8963 109.573 41.0632 110.027C41.1382 110.232 41.065 110.462 40.8757 110.573L40.2438 110.888C40.3169 111.282 40.3169 111.685 40.2438 112.078ZM38.0388 112.474C39.1488 111.03 37.5007 109.382 36.0569 110.492C34.9469 111.936 36.595 113.584 38.0388 112.474ZM42.6025 115.9L42.4488 116.168C42.3925 116.267 42.2725 116.308 42.1657 116.269C41.9444 116.187 41.7419 116.068 41.5638 115.92C41.4775 115.849 41.455 115.723 41.5113 115.626L41.665 115.358C41.5357 115.208 41.4344 115.033 41.3669 114.844H41.0575C40.945 114.844 40.8475 114.763 40.8288 114.651C40.7913 114.426 40.7894 114.19 40.8288 113.955C40.8475 113.843 40.945 113.76 41.0575 113.76H41.3669C41.4344 113.571 41.5357 113.397 41.665 113.247L41.5113 112.978C41.455 112.881 41.4757 112.755 41.5638 112.684C41.7419 112.536 41.9463 112.418 42.1657 112.335C42.2725 112.296 42.3925 112.337 42.4488 112.437L42.6025 112.705C42.7994 112.669 43 112.669 43.1969 112.705L43.3507 112.437C43.4069 112.337 43.5269 112.296 43.6338 112.335C43.855 112.418 44.0575 112.536 44.2357 112.684C44.3219 112.755 44.3444 112.881 44.2882 112.978L44.1344 113.247C44.2638 113.397 44.365 113.571 44.4325 113.76H44.7419C44.8544 113.76 44.9519 113.841 44.9707 113.953C45.0082 114.178 45.01 114.415 44.9707 114.649C44.9519 114.762 44.8544 114.844 44.7419 114.844H44.4325C44.365 115.033 44.2638 115.208 44.1344 115.358L44.2882 115.626C44.3444 115.723 44.3238 115.849 44.2357 115.92C44.0575 116.068 43.8532 116.187 43.6338 116.269C43.5269 116.308 43.4069 116.267 43.3507 116.168L43.1969 115.9C43.0019 115.935 42.7994 115.935 42.6025 115.9ZM42.4057 114.795C43.1275 115.35 43.9507 114.527 43.3957 113.805C42.6738 113.25 41.8507 114.073 42.4057 114.795Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label"
                      d="M53.192 111.894H52.324V116.486H51.274V106.686H54.102C55.054 106.686 55.768 106.905 56.244 107.344C56.7293 107.773 56.972 108.389 56.972 109.192C56.972 109.752 56.776 110.265 56.384 110.732C56.0013 111.199 55.5253 111.469 54.956 111.544C55.4133 111.647 55.7353 111.796 55.922 111.992C56.118 112.179 56.3467 112.585 56.608 113.21L57.994 116.486H56.888L55.53 113.35C55.278 112.762 54.9933 112.375 54.676 112.188C54.368 111.992 53.8733 111.894 53.192 111.894ZM54.046 107.582H52.324V110.998H53.906C54.4847 110.998 54.942 110.83 55.278 110.494C55.6233 110.149 55.796 109.715 55.796 109.192C55.796 108.669 55.642 108.273 55.334 108.002C55.026 107.722 54.5967 107.582 54.046 107.582ZM64.9875 116.5H59.7095V106.7H64.9875V107.61H60.7595V110.718H64.6375V111.656H60.7595V115.59H64.9875V116.5ZM72.2254 107.05L72.0014 107.988L71.1894 107.75C70.6108 107.61 70.1114 107.54 69.6914 107.54C68.5901 107.54 68.0394 108.03 68.0394 109.01C68.0394 109.439 68.2074 109.794 68.5434 110.074C68.8794 110.345 69.2854 110.564 69.7614 110.732C70.2468 110.891 70.7274 111.068 71.2034 111.264C71.6888 111.451 72.0994 111.745 72.4354 112.146C72.7714 112.538 72.9394 113.037 72.9394 113.644C72.9394 114.568 72.6548 115.291 72.0854 115.814C71.5161 116.327 70.7088 116.584 69.6634 116.584C69.1408 116.584 68.6134 116.509 68.0814 116.36C67.5588 116.201 67.1294 116.019 66.7934 115.814L67.1434 115.016C67.9928 115.408 68.7954 115.604 69.5514 115.604C70.3168 115.604 70.8954 115.45 71.2874 115.142C71.6888 114.834 71.8894 114.386 71.8894 113.798C71.8894 113.201 71.5674 112.734 70.9234 112.398C70.6341 112.249 70.3121 112.109 69.9574 111.978C69.6121 111.847 69.2621 111.707 68.9074 111.558C68.5621 111.399 68.2448 111.222 67.9554 111.026C67.6754 110.83 67.4421 110.564 67.2554 110.228C67.0781 109.892 66.9894 109.5 66.9894 109.052C66.9894 108.249 67.2274 107.633 67.7034 107.204C68.1888 106.775 68.8374 106.56 69.6494 106.56C70.4614 106.56 71.3201 106.723 72.2254 107.05ZM76.7584 116.5V107.638H74.0144V106.7H80.5104V107.638H77.7944V116.5H76.7584ZM90.8411 116.5H85.5631V106.7H90.8411V107.61H86.6131V110.718H90.4911V111.656H86.6131V115.59H90.8411V116.5ZM94.201 110.942V116.5H93.151V109.5H93.823L93.991 110.186C94.2056 110.018 94.3783 109.887 94.509 109.794C94.649 109.701 94.8683 109.607 95.167 109.514C95.4656 109.411 95.783 109.36 96.119 109.36C96.763 109.36 97.295 109.561 97.715 109.962C98.1443 110.354 98.359 110.914 98.359 111.642V116.5H97.309V111.95C97.309 110.821 96.8376 110.256 95.895 110.256C95.223 110.256 94.6583 110.485 94.201 110.942ZM104.893 106.7H105.943V116.5H105.327L104.977 115.702C104.118 116.309 103.372 116.612 102.737 116.612C101.057 116.612 100.217 115.403 100.217 112.986C100.217 111.614 100.516 110.657 101.113 110.116C101.645 109.621 102.247 109.374 102.919 109.374C103.591 109.374 104.249 109.603 104.893 110.06V106.7ZM104.893 114.764V111.124C104.697 110.891 104.436 110.69 104.109 110.522C103.792 110.354 103.498 110.27 103.227 110.27C102.499 110.27 101.99 110.485 101.701 110.914C101.412 111.343 101.267 112.015 101.267 112.93C101.267 113.845 101.412 114.535 101.701 115.002C101.99 115.469 102.359 115.702 102.807 115.702C103.479 115.702 104.174 115.389 104.893 114.764ZM109.541 119.832H108.491V109.514H109.107L109.471 110.298C109.863 109.999 110.227 109.771 110.563 109.612C110.908 109.444 111.286 109.36 111.697 109.36C113.377 109.36 114.217 110.569 114.217 112.986C114.217 114.358 113.918 115.315 113.321 115.856C112.789 116.351 112.182 116.598 111.501 116.598C110.829 116.598 110.175 116.374 109.541 115.926V119.832ZM109.541 111.236V114.974C109.727 115.198 109.979 115.375 110.297 115.506C110.614 115.637 110.917 115.702 111.207 115.702C111.935 115.702 112.443 115.487 112.733 115.058C113.022 114.629 113.167 113.957 113.167 113.042C113.167 112.127 113.022 111.437 112.733 110.97C112.443 110.503 112.075 110.27 111.627 110.27C111.328 110.27 111.029 110.331 110.731 110.452C110.441 110.573 110.222 110.69 110.073 110.802C109.933 110.905 109.755 111.049 109.541 111.236ZM120.459 113.056C120.459 112.151 120.282 111.46 119.927 110.984C119.573 110.508 119.055 110.27 118.373 110.27C117.692 110.27 117.207 110.499 116.917 110.956C116.637 111.404 116.497 112.095 116.497 113.028C116.497 114.792 117.146 115.674 118.443 115.674C119.125 115.674 119.629 115.464 119.955 115.044C120.291 114.615 120.459 113.952 120.459 113.056ZM120.711 115.632C120.179 116.267 119.428 116.584 118.457 116.584C117.487 116.584 116.74 116.271 116.217 115.646C115.704 115.011 115.447 114.129 115.447 113C115.447 111.861 115.695 110.97 116.189 110.326C116.693 109.682 117.426 109.36 118.387 109.36C119.358 109.36 120.119 109.687 120.669 110.34C121.229 110.993 121.509 111.88 121.509 113C121.509 114.12 121.243 114.997 120.711 115.632ZM123.183 116.5V109.5H124.233V116.5H123.183ZM124.233 106.7V107.946H123.183V106.7H124.233ZM127.615 110.942V116.5H126.565V109.5H127.237L127.405 110.186C127.62 110.018 127.792 109.887 127.923 109.794C128.063 109.701 128.282 109.607 128.581 109.514C128.88 109.411 129.197 109.36 129.533 109.36C130.177 109.36 130.709 109.561 131.129 109.962C131.558 110.354 131.773 110.914 131.773 111.642V116.5H130.723V111.95C130.723 110.821 130.252 110.256 129.309 110.256C128.637 110.256 128.072 110.485 127.615 110.942ZM134.485 114.988V110.34H133.533V109.5H134.499V107.498H135.549V109.5H137.257V110.34H135.535V114.792C135.535 115.417 135.852 115.73 136.487 115.73C136.636 115.73 136.865 115.702 137.173 115.646L137.327 116.402C136.944 116.523 136.548 116.584 136.137 116.584C135.736 116.584 135.358 116.463 135.003 116.22C134.658 115.968 134.485 115.557 134.485 114.988ZM138.891 115.254C139.497 115.534 140.076 115.674 140.627 115.674C141.177 115.674 141.593 115.567 141.873 115.352C142.162 115.128 142.307 114.834 142.307 114.47C142.307 114.106 142.185 113.826 141.943 113.63C141.7 113.425 141.401 113.266 141.047 113.154C140.701 113.042 140.351 112.921 139.997 112.79C139.651 112.659 139.357 112.463 139.115 112.202C138.872 111.941 138.751 111.609 138.751 111.208C138.751 110.62 138.942 110.167 139.325 109.85C139.707 109.523 140.225 109.36 140.879 109.36C141.532 109.36 142.139 109.458 142.699 109.654L142.797 109.696L142.615 110.592C142.055 110.377 141.532 110.27 141.047 110.27C140.571 110.27 140.244 110.345 140.067 110.494C139.889 110.643 139.801 110.895 139.801 111.25C139.801 111.474 139.922 111.665 140.165 111.824C140.407 111.983 140.701 112.123 141.047 112.244C141.401 112.356 141.751 112.491 142.097 112.65C142.451 112.799 142.75 113.028 142.993 113.336C143.235 113.644 143.357 114.022 143.357 114.47C143.357 115.123 143.128 115.641 142.671 116.024C142.213 116.397 141.583 116.584 140.781 116.584C139.978 116.584 139.264 116.402 138.639 116.038L138.891 115.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="20.5"
                    y="90"
                    width="146"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_2">
                  <g id="Container_2">
                    <g id="Icon_2">
                      <path
                        id="Vector_2"
                        d="M44.25 159.214V160.286C44.25 161.23 41.8984 162 39 162C36.1016 162 33.75 161.23 33.75 160.286V159.214C33.75 158.27 36.1016 157.5 39 157.5C41.8984 157.5 44.25 158.27 44.25 159.214ZM44.25 161.625V164.036C44.25 164.98 41.8984 165.75 39 165.75C36.1016 165.75 33.75 164.98 33.75 164.036V161.625C34.8779 162.402 36.9424 162.763 39 162.763C41.0576 162.763 43.122 162.402 44.25 161.625ZM44.25 165.375V167.786C44.25 168.73 41.8984 169.5 39 169.5C36.1016 169.5 33.75 168.73 33.75 167.786V165.375C34.8779 166.152 36.9424 166.513 39 166.513C41.0576 166.513 43.122 166.152 44.25 165.375Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_2"
                      d="M58.358 163.25C58.358 164.827 57.9007 166.097 56.986 167.058C56.0713 168.019 54.8487 168.5 53.318 168.5H51.274V158.7H53.752C55.1427 158.7 56.258 159.125 57.098 159.974C57.938 160.823 58.358 161.915 58.358 163.25ZM57.224 163.138C57.224 162.037 56.888 161.173 56.216 160.548C55.544 159.923 54.7413 159.61 53.808 159.61H52.408V167.59H53.444C54.4987 167.59 55.39 167.193 56.118 166.4C56.8553 165.607 57.224 164.519 57.224 163.138ZM63.3625 164.314H63.9365C63.9365 163.465 63.8291 162.914 63.6145 162.662C63.3998 162.401 62.9238 162.27 62.1865 162.27C61.4491 162.27 60.8238 162.368 60.3105 162.564L60.1145 161.752C60.8985 161.491 61.7105 161.36 62.5505 161.36C64.1931 161.36 65.0145 162.181 65.0145 163.824V168.5H64.3985L64.0345 167.674C63.6051 168.029 63.2318 168.271 62.9145 168.402C62.6065 168.523 62.2471 168.584 61.8365 168.584C61.1831 168.584 60.6745 168.393 60.3105 168.01C59.9465 167.618 59.7645 167.105 59.7645 166.47C59.7645 165.033 60.9638 164.314 63.3625 164.314ZM63.9505 165.196H63.3205C62.3685 165.196 61.7105 165.289 61.3465 165.476C60.9918 165.663 60.8145 165.957 60.8145 166.358C60.8145 166.75 60.9171 167.072 61.1225 167.324C61.3278 167.576 61.5938 167.702 61.9205 167.702C62.2565 167.702 62.5738 167.627 62.8725 167.478C63.1805 167.319 63.5398 167.049 63.9505 166.666V165.196ZM67.7252 166.988V162.34H66.7732V161.5H67.7392V159.498H68.7892V161.5H70.4972V162.34H68.7752V166.792C68.7752 167.417 69.0925 167.73 69.7272 167.73C69.8765 167.73 70.1052 167.702 70.4132 167.646L70.5672 168.402C70.1845 168.523 69.7879 168.584 69.3772 168.584C68.9759 168.584 68.5979 168.463 68.2432 168.22C67.8979 167.968 67.7252 167.557 67.7252 166.988ZM75.421 164.314H75.995C75.995 163.465 75.8877 162.914 75.673 162.662C75.4584 162.401 74.9824 162.27 74.245 162.27C73.5077 162.27 72.8824 162.368 72.369 162.564L72.173 161.752C72.957 161.491 73.769 161.36 74.609 161.36C76.2517 161.36 77.073 162.181 77.073 163.824V168.5H76.457L76.093 167.674C75.6637 168.029 75.2904 168.271 74.973 168.402C74.665 168.523 74.3057 168.584 73.895 168.584C73.2417 168.584 72.733 168.393 72.369 168.01C72.005 167.618 71.823 167.105 71.823 166.47C71.823 165.033 73.0224 164.314 75.421 164.314ZM76.009 165.196H75.379C74.427 165.196 73.769 165.289 73.405 165.476C73.0504 165.663 72.873 165.957 72.873 166.358C72.873 166.75 72.9757 167.072 73.181 167.324C73.3864 167.576 73.6524 167.702 73.979 167.702C74.315 167.702 74.6324 167.627 74.931 167.478C75.239 167.319 75.5984 167.049 76.009 166.666V165.196ZM79.6158 158.7H80.6658V162.2C81.4685 161.631 82.1871 161.346 82.8218 161.346C84.5018 161.346 85.3418 162.555 85.3418 164.972C85.3418 166.344 85.0431 167.305 84.4458 167.856C83.9138 168.341 83.2885 168.584 82.5698 168.584C82.2058 168.584 81.8371 168.505 81.4638 168.346C81.0905 168.178 80.7825 168.001 80.5398 167.814L80.2318 168.5H79.6158V158.7ZM80.6658 163.194V167.002C80.8525 167.217 81.0998 167.385 81.4078 167.506C81.7251 167.627 82.0331 167.688 82.3318 167.688C83.0598 167.688 83.5685 167.473 83.8578 167.044C84.1471 166.615 84.2918 165.943 84.2918 165.028C84.2918 164.113 84.1471 163.423 83.8578 162.956C83.5685 162.489 83.1998 162.256 82.7518 162.256C82.0798 162.256 81.3845 162.569 80.6658 163.194ZM90.2824 164.314H90.8564C90.8564 163.465 90.749 162.914 90.5344 162.662C90.3197 162.401 89.8437 162.27 89.1064 162.27C88.369 162.27 87.7437 162.368 87.2304 162.564L87.0344 161.752C87.8184 161.491 88.6304 161.36 89.4704 161.36C91.113 161.36 91.9344 162.181 91.9344 163.824V168.5H91.3184L90.9544 167.674C90.525 168.029 90.1517 168.271 89.8344 168.402C89.5264 168.523 89.167 168.584 88.7564 168.584C88.103 168.584 87.5944 168.393 87.2304 168.01C86.8664 167.618 86.6844 167.105 86.6844 166.47C86.6844 165.033 87.8837 164.314 90.2824 164.314ZM90.8704 165.196H90.2404C89.2884 165.196 88.6304 165.289 88.2664 165.476C87.9117 165.663 87.7344 165.957 87.7344 166.358C87.7344 166.75 87.837 167.072 88.0424 167.324C88.2477 167.576 88.5137 167.702 88.8404 167.702C89.1764 167.702 89.4937 167.627 89.7924 167.478C90.1004 167.319 90.4597 167.049 90.8704 166.666V165.196ZM94.2111 167.254C94.8178 167.534 95.3965 167.674 95.9471 167.674C96.4978 167.674 96.9131 167.567 97.1931 167.352C97.4825 167.128 97.6271 166.834 97.6271 166.47C97.6271 166.106 97.5058 165.826 97.2631 165.63C97.0205 165.425 96.7218 165.266 96.3671 165.154C96.0218 165.042 95.6718 164.921 95.3171 164.79C94.9718 164.659 94.6778 164.463 94.4351 164.202C94.1925 163.941 94.0711 163.609 94.0711 163.208C94.0711 162.62 94.2625 162.167 94.6451 161.85C95.0278 161.523 95.5458 161.36 96.1991 161.36C96.8525 161.36 97.4591 161.458 98.0191 161.654L98.1171 161.696L97.9351 162.592C97.3751 162.377 96.8525 162.27 96.3671 162.27C95.8911 162.27 95.5645 162.345 95.3871 162.494C95.2098 162.643 95.1211 162.895 95.1211 163.25C95.1211 163.474 95.2425 163.665 95.4851 163.824C95.7278 163.983 96.0218 164.123 96.3671 164.244C96.7218 164.356 97.0718 164.491 97.4171 164.65C97.7718 164.799 98.0705 165.028 98.3131 165.336C98.5558 165.644 98.6771 166.022 98.6771 166.47C98.6771 167.123 98.4485 167.641 97.9911 168.024C97.5338 168.397 96.9038 168.584 96.1011 168.584C95.2985 168.584 94.5845 168.402 93.9591 168.038L94.2111 167.254ZM105.433 165.224H100.967C100.967 166.12 101.177 166.755 101.597 167.128C102.026 167.501 102.563 167.688 103.207 167.688C103.533 167.688 103.762 167.674 103.893 167.646C104.023 167.609 104.145 167.576 104.257 167.548C104.378 167.511 104.462 167.483 104.509 167.464C104.742 167.399 104.943 167.338 105.111 167.282L105.279 168.094C104.345 168.421 103.617 168.584 103.095 168.584C102.133 168.584 101.363 168.295 100.785 167.716C100.206 167.128 99.9168 166.251 99.9168 165.084C99.9168 163.908 100.187 162.993 100.729 162.34C101.279 161.687 101.97 161.36 102.801 161.36C103.641 161.36 104.294 161.631 104.761 162.172C105.227 162.713 105.461 163.446 105.461 164.37C105.461 164.622 105.451 164.907 105.433 165.224ZM101.037 164.426H104.453C104.453 163.735 104.331 163.203 104.089 162.83C103.846 162.457 103.421 162.27 102.815 162.27C102.217 162.27 101.779 162.471 101.499 162.872C101.219 163.273 101.065 163.791 101.037 164.426Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="20.5"
                    y="142"
                    width="146"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_3">
                  <g id="Container_3">
                    <g id="Icon_3">
                      <path
                        id="Vector_3"
                        d="M42 210.25C42 210.051 41.921 209.86 41.7803 209.72C41.6397 209.579 41.4489 209.5 41.25 209.5C41.0511 209.5 40.8603 209.579 40.7197 209.72C40.579 209.86 40.5 210.051 40.5 210.25V212.5H42V210.25ZM43.125 213.25H34.875C34.7755 213.25 34.6802 213.29 34.6098 213.36C34.5395 213.43 34.5 213.526 34.5 213.625V214.375C34.5 214.474 34.5395 214.57 34.6098 214.64C34.6802 214.71 34.7755 214.75 34.875 214.75H35.25V215.5C35.2501 216.364 35.5488 217.202 36.0954 217.872C36.642 218.541 37.4031 219.002 38.25 219.175V221.5H39.75V219.175C40.5969 219.002 41.358 218.541 41.9046 217.872C42.4512 217.202 42.7499 216.364 42.75 215.5V214.75H43.125C43.2245 214.75 43.3198 214.71 43.3902 214.64C43.4605 214.57 43.5 214.474 43.5 214.375V213.625C43.5 213.526 43.4605 213.43 43.3902 213.36C43.3198 213.29 43.2245 213.25 43.125 213.25ZM37.5 210.25C37.5 210.051 37.421 209.86 37.2803 209.72C37.1397 209.579 36.9489 209.5 36.75 209.5C36.5511 209.5 36.3603 209.579 36.2197 209.72C36.079 209.86 36 210.051 36 210.25V212.5H37.5V210.25Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_3"
                      d="M55.068 220.584C53.7147 220.584 52.6367 220.127 51.834 219.212C51.0407 218.297 50.644 217.079 50.644 215.558C50.644 214.027 51.022 212.814 51.778 211.918C52.534 211.013 53.5887 210.56 54.942 210.56C55.8007 210.56 56.6733 210.728 57.56 211.064L57.308 211.932C56.9907 211.801 56.5753 211.694 56.062 211.61C55.5487 211.517 55.152 211.47 54.872 211.47C53.892 211.47 53.1173 211.829 52.548 212.548C51.9787 213.267 51.694 214.237 51.694 215.46C51.694 216.683 51.9927 217.691 52.59 218.484C53.1967 219.277 53.9713 219.674 54.914 219.674C55.5767 219.674 56.202 219.581 56.79 219.394V216.44H54.746V215.53H57.84V219.828C56.9627 220.332 56.0387 220.584 55.068 220.584ZM61.3748 215.152V220.5H60.3248V213.5H60.9968L61.1648 214.326C61.6128 213.971 61.9861 213.724 62.2848 213.584C62.5834 213.435 62.9241 213.36 63.3068 213.36C63.4934 213.36 63.6334 213.369 63.7268 213.388L63.9228 213.444L63.7548 214.41C63.5868 214.354 63.3581 214.326 63.0688 214.326C62.5088 214.326 61.9441 214.601 61.3748 215.152ZM68.5441 216.314H69.1181C69.1181 215.465 69.0108 214.914 68.7961 214.662C68.5814 214.401 68.1054 214.27 67.3681 214.27C66.6308 214.27 66.0054 214.368 65.4921 214.564L65.2961 213.752C66.0801 213.491 66.8921 213.36 67.7321 213.36C69.3748 213.36 70.1961 214.181 70.1961 215.824V220.5H69.5801L69.2161 219.674C68.7868 220.029 68.4134 220.271 68.0961 220.402C67.7881 220.523 67.4288 220.584 67.0181 220.584C66.3648 220.584 65.8561 220.393 65.4921 220.01C65.1281 219.618 64.9461 219.105 64.9461 218.47C64.9461 217.033 66.1454 216.314 68.5441 216.314ZM69.1321 217.196H68.5021C67.5501 217.196 66.8921 217.289 66.5281 217.476C66.1734 217.663 65.9961 217.957 65.9961 218.358C65.9961 218.75 66.0988 219.072 66.3041 219.324C66.5094 219.576 66.7754 219.702 67.1021 219.702C67.4381 219.702 67.7554 219.627 68.0541 219.478C68.3621 219.319 68.7214 219.049 69.1321 218.666V217.196ZM73.7888 223.832H72.7388V213.514H73.3548L73.7188 214.298C74.1108 213.999 74.4748 213.771 74.8108 213.612C75.1562 213.444 75.5342 213.36 75.9448 213.36C77.6248 213.36 78.4648 214.569 78.4648 216.986C78.4648 218.358 78.1662 219.315 77.5688 219.856C77.0368 220.351 76.4302 220.598 75.7488 220.598C75.0768 220.598 74.4235 220.374 73.7888 219.926V223.832ZM73.7888 215.236V218.974C73.9755 219.198 74.2275 219.375 74.5448 219.506C74.8622 219.637 75.1655 219.702 75.4548 219.702C76.1828 219.702 76.6915 219.487 76.9808 219.058C77.2702 218.629 77.4148 217.957 77.4148 217.042C77.4148 216.127 77.2702 215.437 76.9808 214.97C76.6915 214.503 76.3228 214.27 75.8748 214.27C75.5762 214.27 75.2775 214.331 74.9788 214.452C74.6895 214.573 74.4702 214.69 74.3208 214.802C74.1808 214.905 74.0035 215.049 73.7888 215.236ZM85.6174 220.5H84.5674V215.894C84.5674 214.765 84.0961 214.2 83.1534 214.2C82.4534 214.2 81.8794 214.424 81.4314 214.872V220.5H80.3814V210.7H81.4174V214.018C81.6228 213.85 81.7814 213.729 81.8934 213.654C82.0148 213.579 82.2061 213.505 82.4674 213.43C82.7381 213.355 83.0414 213.318 83.3774 213.318C84.0214 213.318 84.5534 213.514 84.9734 213.906C85.4028 214.298 85.6174 214.858 85.6174 215.586V220.5ZM94.3487 219.156L95.7207 220.57L95.0347 221.256L93.7047 219.842C93.0794 220.346 92.3234 220.598 91.4367 220.598C90.5594 220.598 89.8221 220.36 89.2247 219.884C88.0954 218.997 87.5307 217.546 87.5307 215.53C87.5307 214.065 87.8574 212.87 88.5107 211.946C89.1734 211.022 90.1394 210.56 91.4087 210.56C92.6874 210.56 93.6581 211.022 94.3207 211.946C94.9834 212.87 95.3147 214.079 95.3147 215.572C95.3147 217.065 94.9927 218.26 94.3487 219.156ZM92.4727 217.168L93.6207 218.414C94.0501 217.705 94.2647 216.767 94.2647 215.6C94.2647 214.424 94.0127 213.439 93.5087 212.646C93.0141 211.853 92.3187 211.456 91.4227 211.456C90.9281 211.456 90.4894 211.573 90.1067 211.806C89.7334 212.039 89.4394 212.352 89.2247 212.744C88.8047 213.528 88.5947 214.485 88.5947 215.614C88.5947 216.734 88.8327 217.691 89.3087 218.484C89.7941 219.277 90.4987 219.674 91.4227 219.674C92.0387 219.674 92.5661 219.497 93.0047 219.142L91.7727 217.854L92.4727 217.168ZM102.53 220.5H97.2799V210.7H98.3299V219.59H102.53V220.5ZM112.325 211.05L112.101 211.988L111.289 211.75C110.71 211.61 110.211 211.54 109.791 211.54C108.69 211.54 108.139 212.03 108.139 213.01C108.139 213.439 108.307 213.794 108.643 214.074C108.979 214.345 109.385 214.564 109.861 214.732C110.346 214.891 110.827 215.068 111.303 215.264C111.788 215.451 112.199 215.745 112.535 216.146C112.871 216.538 113.039 217.037 113.039 217.644C113.039 218.568 112.754 219.291 112.185 219.814C111.616 220.327 110.808 220.584 109.763 220.584C109.24 220.584 108.713 220.509 108.181 220.36C107.658 220.201 107.229 220.019 106.893 219.814L107.243 219.016C108.092 219.408 108.895 219.604 109.651 219.604C110.416 219.604 110.995 219.45 111.387 219.142C111.788 218.834 111.989 218.386 111.989 217.798C111.989 217.201 111.667 216.734 111.023 216.398C110.734 216.249 110.412 216.109 110.057 215.978C109.712 215.847 109.362 215.707 109.007 215.558C108.662 215.399 108.344 215.222 108.055 215.026C107.775 214.83 107.542 214.564 107.355 214.228C107.178 213.892 107.089 213.5 107.089 213.052C107.089 212.249 107.327 211.633 107.803 211.204C108.288 210.775 108.937 210.56 109.749 210.56C110.561 210.56 111.42 210.723 112.325 211.05ZM119.966 217.224H115.5C115.5 218.12 115.71 218.755 116.13 219.128C116.559 219.501 117.096 219.688 117.74 219.688C118.067 219.688 118.295 219.674 118.426 219.646C118.557 219.609 118.678 219.576 118.79 219.548C118.911 219.511 118.995 219.483 119.042 219.464C119.275 219.399 119.476 219.338 119.644 219.282L119.812 220.094C118.879 220.421 118.151 220.584 117.628 220.584C116.667 220.584 115.897 220.295 115.318 219.716C114.739 219.128 114.45 218.251 114.45 217.084C114.45 215.908 114.721 214.993 115.262 214.34C115.813 213.687 116.503 213.36 117.334 213.36C118.174 213.36 118.827 213.631 119.294 214.172C119.761 214.713 119.994 215.446 119.994 216.37C119.994 216.622 119.985 216.907 119.966 217.224ZM115.57 216.426H118.986C118.986 215.735 118.865 215.203 118.622 214.83C118.379 214.457 117.955 214.27 117.348 214.27C116.751 214.27 116.312 214.471 116.032 214.872C115.752 215.273 115.598 215.791 115.57 216.426ZM123.008 215.152V220.5H121.958V213.5H122.63L122.798 214.326C123.246 213.971 123.619 213.724 123.918 213.584C124.216 213.435 124.557 213.36 124.94 213.36C125.126 213.36 125.266 213.369 125.36 213.388L125.556 213.444L125.388 214.41C125.22 214.354 124.991 214.326 124.702 214.326C124.142 214.326 123.577 214.601 123.008 215.152ZM131.955 213.486L129.589 220.5H128.385L126.033 213.486H127.223L129.001 219.38L130.793 213.486H131.955ZM133.191 220.5V213.5H134.241V220.5H133.191ZM134.241 210.7V211.946H133.191V210.7H134.241ZM140.689 219.408L140.899 220.234C140.152 220.458 139.494 220.57 138.925 220.57C137.926 220.57 137.175 220.243 136.671 219.59C136.167 218.937 135.915 218.036 135.915 216.888C135.915 215.74 136.176 214.867 136.699 214.27C137.221 213.663 137.991 213.36 139.009 213.36C139.447 213.36 140.063 213.472 140.857 213.696L140.437 214.508C139.923 214.359 139.461 214.284 139.051 214.284C138.341 214.284 137.828 214.494 137.511 214.914C137.203 215.334 137.049 215.997 137.049 216.902C137.049 218.741 137.707 219.66 139.023 219.66C139.545 219.66 140.101 219.576 140.689 219.408ZM147.487 217.224H143.021C143.021 218.12 143.231 218.755 143.651 219.128C144.081 219.501 144.617 219.688 145.261 219.688C145.588 219.688 145.817 219.674 145.947 219.646C146.078 219.609 146.199 219.576 146.311 219.548C146.433 219.511 146.517 219.483 146.563 219.464C146.797 219.399 146.997 219.338 147.165 219.282L147.333 220.094C146.4 220.421 145.672 220.584 145.149 220.584C144.188 220.584 143.418 220.295 142.839 219.716C142.261 219.128 141.971 218.251 141.971 217.084C141.971 215.908 142.242 214.993 142.783 214.34C143.334 213.687 144.025 213.36 144.855 213.36C145.695 213.36 146.349 213.631 146.815 214.172C147.282 214.713 147.515 215.446 147.515 216.37C147.515 216.622 147.506 216.907 147.487 217.224ZM143.091 216.426H146.507C146.507 215.735 146.386 215.203 146.143 214.83C145.901 214.457 145.476 214.27 144.869 214.27C144.272 214.27 143.833 214.471 143.553 214.872C143.273 215.273 143.119 215.791 143.091 216.426ZM149.213 219.254C149.82 219.534 150.398 219.674 150.949 219.674C151.5 219.674 151.915 219.567 152.195 219.352C152.484 219.128 152.629 218.834 152.629 218.47C152.629 218.106 152.508 217.826 152.265 217.63C152.022 217.425 151.724 217.266 151.369 217.154C151.024 217.042 150.674 216.921 150.319 216.79C149.974 216.659 149.68 216.463 149.437 216.202C149.194 215.941 149.073 215.609 149.073 215.208C149.073 214.62 149.264 214.167 149.647 213.85C150.03 213.523 150.548 213.36 151.201 213.36C151.854 213.36 152.461 213.458 153.021 213.654L153.119 213.696L152.937 214.592C152.377 214.377 151.854 214.27 151.369 214.27C150.893 214.27 150.566 214.345 150.389 214.494C150.212 214.643 150.123 214.895 150.123 215.25C150.123 215.474 150.244 215.665 150.487 215.824C150.73 215.983 151.024 216.123 151.369 216.244C151.724 216.356 152.074 216.491 152.419 216.65C152.774 216.799 153.072 217.028 153.315 217.336C153.558 217.644 153.679 218.022 153.679 218.47C153.679 219.123 153.45 219.641 152.993 220.024C152.536 220.397 151.906 220.584 151.103 220.584C150.3 220.584 149.586 220.402 148.961 220.038L149.213 219.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="20.5"
                    y="194"
                    width="146"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
              </g>
              <g id="SchemaGrouper">
                <g id="Borders">
                  <mask id="path-12-inside-1_190_9936" fill="white">
                    <path d="M179 65.5H195V237.5H179V65.5Z" />
                  </mask>
                  <path
                    d="M195 65.5H196V64.5H195V65.5ZM195 237.5V238.5H196V237.5H195ZM179 66.5H195V64.5H179V66.5ZM194 65.5V237.5H196V65.5H194ZM195 236.5H179V238.5H195V236.5Z"
                    fill="#94A3B8"
                    mask="url(#path-12-inside-1_190_9936)"
                  />
                </g>
              </g>
            </g>
            <g id="SchemaArrowWithLabel">
              <g id="Horizontal">
                <g id="Arrow left">
                  <g id="SchemaArrow">
                    <rect
                      id="Line"
                      x="195"
                      y="169"
                      width="15"
                      height="1"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
                <g id="SchemaArrowLabel">
                  <g id="Icon_4">
                    <path
                      id="Vector_4"
                      d="M225.655 167.845C227.055 169.247 227.036 171.494 225.663 172.875C225.661 172.877 225.658 172.88 225.655 172.883L224.08 174.458C222.691 175.847 220.431 175.847 219.042 174.458C217.653 173.069 217.653 170.809 219.042 169.42L219.912 168.55C220.142 168.32 220.539 168.473 220.551 168.799C220.566 169.214 220.641 169.632 220.778 170.035C220.825 170.171 220.792 170.322 220.69 170.424L220.383 170.731C219.726 171.388 219.705 172.457 220.356 173.12C221.013 173.79 222.092 173.794 222.754 173.132L224.329 171.558C224.99 170.897 224.987 169.829 224.329 169.171C224.242 169.084 224.155 169.017 224.087 168.97C224.038 168.937 223.999 168.893 223.97 168.842C223.942 168.79 223.926 168.733 223.924 168.675C223.915 168.427 224.002 168.172 224.198 167.976L224.692 167.483C224.821 167.353 225.024 167.337 225.174 167.442C225.346 167.562 225.507 167.697 225.655 167.845ZM228.958 164.542C227.569 163.153 225.309 163.153 223.92 164.542L222.345 166.117C222.342 166.12 222.339 166.123 222.337 166.125C220.964 167.506 220.945 169.753 222.345 171.155C222.493 171.303 222.654 171.438 222.826 171.558C222.976 171.663 223.179 171.647 223.308 171.517L223.802 171.024C223.998 170.828 224.085 170.573 224.076 170.325C224.074 170.267 224.058 170.21 224.03 170.158C224.001 170.107 223.962 170.063 223.913 170.03C223.845 169.983 223.758 169.916 223.671 169.829C223.013 169.171 223.01 168.103 223.671 167.442L225.246 165.868C225.908 165.206 226.987 165.21 227.644 165.88C228.294 166.543 228.274 167.612 227.617 168.269L227.31 168.576C227.208 168.678 227.175 168.829 227.222 168.965C227.359 169.368 227.434 169.786 227.449 170.201C227.461 170.527 227.858 170.68 228.088 170.45L228.958 169.58C230.347 168.191 230.347 165.931 228.958 164.542Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_4"
                    d="M238.152 173.572C237.008 173.572 236.128 173.188 235.512 172.42C234.904 171.644 234.6 170.596 234.6 169.276C234.6 167.956 234.924 166.912 235.572 166.144C236.22 165.376 237.124 164.992 238.284 164.992C238.924 164.992 239.552 165.108 240.168 165.34L239.952 166.084C239.464 165.876 238.888 165.772 238.224 165.772C237.384 165.772 236.72 166.08 236.232 166.696C235.744 167.304 235.5 168.144 235.5 169.216C235.5 170.28 235.728 171.144 236.184 171.808C236.648 172.464 237.292 172.792 238.116 172.792C238.66 172.792 239.344 172.636 240.168 172.324L240.408 172.948C239.72 173.364 238.968 173.572 238.152 173.572ZM245.808 170.548C245.808 169.772 245.656 169.18 245.352 168.772C245.048 168.364 244.604 168.16 244.02 168.16C243.436 168.16 243.02 168.356 242.772 168.748C242.532 169.132 242.412 169.724 242.412 170.524C242.412 172.036 242.968 172.792 244.08 172.792C244.664 172.792 245.096 172.612 245.376 172.252C245.664 171.884 245.808 171.316 245.808 170.548ZM246.024 172.756C245.568 173.3 244.924 173.572 244.092 173.572C243.26 173.572 242.62 173.304 242.172 172.768C241.732 172.224 241.512 171.468 241.512 170.5C241.512 169.524 241.724 168.76 242.148 168.208C242.58 167.656 243.208 167.38 244.032 167.38C244.864 167.38 245.516 167.66 245.988 168.22C246.468 168.78 246.708 169.54 246.708 170.5C246.708 171.46 246.48 172.212 246.024 172.756ZM249.211 168.736V173.5H248.311V167.5H248.887L249.031 168.088C249.215 167.944 249.363 167.832 249.475 167.752C249.595 167.672 249.783 167.592 250.039 167.512C250.295 167.424 250.567 167.38 250.855 167.38C251.407 167.38 251.863 167.552 252.223 167.896C252.591 168.232 252.775 168.712 252.775 169.336V173.5H251.875V169.6C251.875 168.632 251.471 168.148 250.663 168.148C250.087 168.148 249.603 168.344 249.211 168.736ZM255.855 168.736V173.5H254.955V167.5H255.531L255.675 168.088C255.859 167.944 256.007 167.832 256.119 167.752C256.239 167.672 256.427 167.592 256.683 167.512C256.939 167.424 257.211 167.38 257.499 167.38C258.051 167.38 258.507 167.552 258.867 167.896C259.235 168.232 259.419 168.712 259.419 169.336V173.5H258.519V169.6C258.519 168.632 258.115 168.148 257.307 168.148C256.731 168.148 256.247 168.344 255.855 168.736ZM265.764 170.692H261.936C261.936 171.46 262.116 172.004 262.476 172.324C262.844 172.644 263.304 172.804 263.856 172.804C264.136 172.804 264.332 172.792 264.444 172.768C264.556 172.736 264.66 172.708 264.756 172.684C264.86 172.652 264.932 172.628 264.972 172.612C265.172 172.556 265.344 172.504 265.488 172.456L265.632 173.152C264.832 173.432 264.208 173.572 263.76 173.572C262.936 173.572 262.276 173.324 261.78 172.828C261.284 172.324 261.036 171.572 261.036 170.572C261.036 169.564 261.268 168.78 261.732 168.22C262.204 167.66 262.796 167.38 263.508 167.38C264.228 167.38 264.788 167.612 265.188 168.076C265.588 168.54 265.788 169.168 265.788 169.96C265.788 170.176 265.78 170.42 265.764 170.692ZM261.996 170.008H264.924C264.924 169.416 264.82 168.96 264.612 168.64C264.404 168.32 264.04 168.16 263.52 168.16C263.008 168.16 262.632 168.332 262.392 168.676C262.152 169.02 262.02 169.464 261.996 170.008ZM270.999 172.564L271.179 173.272C270.539 173.464 269.975 173.56 269.487 173.56C268.631 173.56 267.987 173.28 267.555 172.72C267.123 172.16 266.907 171.388 266.907 170.404C266.907 169.42 267.131 168.672 267.579 168.16C268.027 167.64 268.687 167.38 269.559 167.38C269.935 167.38 270.463 167.476 271.143 167.668L270.783 168.364C270.343 168.236 269.947 168.172 269.595 168.172C268.987 168.172 268.547 168.352 268.275 168.712C268.011 169.072 267.879 169.64 267.879 170.416C267.879 171.992 268.443 172.78 269.571 172.78C270.019 172.78 270.495 172.708 270.999 172.564ZM272.806 172.204V168.22H271.99V167.5H272.818V165.784H273.718V167.5H275.182V168.22H273.706V172.036C273.706 172.572 273.978 172.84 274.522 172.84C274.65 172.84 274.846 172.816 275.11 172.768L275.242 173.416C274.914 173.52 274.574 173.572 274.222 173.572C273.878 173.572 273.554 173.468 273.25 173.26C272.954 173.044 272.806 172.692 272.806 172.204ZM280.975 170.692H277.147C277.147 171.46 277.327 172.004 277.687 172.324C278.055 172.644 278.515 172.804 279.067 172.804C279.347 172.804 279.543 172.792 279.655 172.768C279.767 172.736 279.871 172.708 279.967 172.684C280.071 172.652 280.143 172.628 280.183 172.612C280.383 172.556 280.555 172.504 280.699 172.456L280.843 173.152C280.043 173.432 279.419 173.572 278.971 173.572C278.147 173.572 277.487 173.324 276.991 172.828C276.495 172.324 276.247 171.572 276.247 170.572C276.247 169.564 276.479 168.78 276.943 168.22C277.415 167.66 278.007 167.38 278.719 167.38C279.439 167.38 279.999 167.612 280.399 168.076C280.799 168.54 280.999 169.168 280.999 169.96C280.999 170.176 280.991 170.42 280.975 170.692ZM277.207 170.008H280.135C280.135 169.416 280.031 168.96 279.823 168.64C279.615 168.32 279.251 168.16 278.731 168.16C278.219 168.16 277.843 168.332 277.603 168.676C277.363 169.02 277.231 169.464 277.207 170.008ZM286.102 165.1H287.002V173.5H286.474L286.174 172.816C285.438 173.336 284.798 173.596 284.254 173.596C282.814 173.596 282.094 172.56 282.094 170.488C282.094 169.312 282.35 168.492 282.862 168.028C283.318 167.604 283.834 167.392 284.41 167.392C284.986 167.392 285.55 167.588 286.102 167.98V165.1ZM286.102 172.012V168.892C285.934 168.692 285.71 168.52 285.43 168.376C285.158 168.232 284.906 168.16 284.674 168.16C284.05 168.16 283.614 168.344 283.366 168.712C283.118 169.08 282.994 169.656 282.994 170.44C282.994 171.224 283.118 171.816 283.366 172.216C283.614 172.616 283.93 172.816 284.314 172.816C284.89 172.816 285.486 172.548 286.102 172.012Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="Arrow right">
                  <g id="SchemaArrow_2">
                    <rect
                      id="Line_2"
                      x="297"
                      y="169"
                      width="10.5"
                      height="1"
                      fill="#94A3B8"
                    />
                    <path
                      id="Vector_5"
                      d="M307.92 174L307.5 173.69V165.295L307.905 165L312 169.22V169.841L307.92 174Z"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
          <g id="Col3">
            <g id="SchemaCard_4" filter="url(#filter0_d_190_9936)">
              <g clipPath="url(#clip0_190_9936)">
                <rect
                  x="312"
                  y="21.5"
                  width="200"
                  height="44"
                  rx="4"
                  fill="white"
                />
                <g id="Container_4">
                  <g id="Icon_5">
                    <path
                      id="Vector_6"
                      d="M331 37.5C327.686 37.5 325 40.1862 325 43.4999C325 46.8136 327.686 49.5 331 49.5C334.314 49.5 337 46.8136 337 43.4999C337 40.1862 334.314 37.5 331 37.5ZM331 48.7296C330.057 48.7296 329.293 48.0998 329.293 47.3231H332.707C332.707 48.0997 331.943 48.7296 331 48.7296ZM333.82 46.8573H328.18V45.8347H333.82V46.8573H333.82ZM333.799 45.3083H328.196C328.178 45.2869 328.158 45.2657 328.14 45.2439C327.563 44.5429 327.427 44.177 327.295 43.804C327.293 43.7918 327.995 43.9475 328.493 44.0595C328.493 44.0595 328.749 44.1188 329.124 44.1871C328.764 43.7655 328.551 43.2295 328.551 42.6817C328.551 41.4789 329.473 40.4279 329.14 39.5784C329.464 39.6048 329.811 40.262 329.834 41.2896C330.179 40.8138 330.323 39.9448 330.323 39.412C330.323 38.8603 330.686 38.2195 331.05 38.1976C330.726 38.7318 331.134 39.1897 331.496 40.3257C331.632 40.7525 331.615 41.4706 331.72 41.926C331.755 40.9801 331.918 39.6 332.518 39.1235C332.253 39.7236 332.557 40.4744 332.765 40.8354C333.1 41.4177 333.303 41.8589 333.303 42.6934C333.303 43.2529 333.097 43.7797 332.748 44.1915C333.144 44.1171 333.418 44.0501 333.418 44.0501L334.705 43.7991C334.705 43.799 334.518 44.5679 333.799 45.3083Z"
                      fill="#EA580C"
                    />
                  </g>
                  <path
                    id="Card label_5"
                    d="M345.752 44.734H345.024V48.5H342.994V38.7H346.074C347.222 38.7 348.053 38.9473 348.566 39.442C349.079 39.9273 349.336 40.6833 349.336 41.71C349.336 42.7273 349.019 43.488 348.384 43.992C347.759 44.4867 346.881 44.734 345.752 44.734ZM345.598 40.296H345.024V43.138H345.248C345.957 43.138 346.475 43.0307 346.802 42.816C347.138 42.6013 347.306 42.242 347.306 41.738C347.306 41.2247 347.171 40.856 346.9 40.632C346.629 40.408 346.195 40.296 345.598 40.296ZM352.542 43.852V48.5H350.708V41.5H352.164L352.332 42.186C352.706 41.8873 353.018 41.6773 353.27 41.556C353.522 41.4253 353.742 41.36 353.928 41.36C354.124 41.36 354.255 41.3647 354.32 41.374C354.386 41.374 354.442 41.3787 354.488 41.388C354.535 41.3973 354.614 41.416 354.726 41.444L354.558 43.11C354.39 43.054 354.162 43.026 353.872 43.026C353.48 43.026 353.037 43.3013 352.542 43.852ZM361.959 45.014C361.959 46.134 361.674 47.0113 361.105 47.646C360.536 48.2807 359.728 48.598 358.683 48.598C357.638 48.598 356.844 48.2807 356.303 47.646C355.762 47.0113 355.491 46.1293 355.491 45C355.491 43.8707 355.762 42.984 356.303 42.34C356.844 41.6867 357.624 41.36 358.641 41.36C359.658 41.36 360.466 41.6913 361.063 42.354C361.66 43.0073 361.959 43.894 361.959 45.014ZM360.097 44.986C360.097 43.558 359.64 42.844 358.725 42.844C357.792 42.844 357.325 43.5533 357.325 44.972C357.325 46.3907 357.796 47.1 358.739 47.1C359.243 47.1 359.593 46.9227 359.789 46.568C359.994 46.204 360.097 45.6767 360.097 44.986ZM365.394 48.5H363.56V41.5H365.1L365.338 42.13C365.739 41.8313 366.084 41.6307 366.374 41.528C366.672 41.416 367.018 41.36 367.41 41.36C368.119 41.36 368.637 41.682 368.964 42.326C369.486 41.9433 369.906 41.6867 370.224 41.556C370.55 41.4253 370.905 41.36 371.288 41.36C371.866 41.36 372.324 41.5747 372.66 42.004C372.996 42.424 373.164 43.0447 373.164 43.866V48.5H371.33V44.356C371.33 43.4973 371.073 43.068 370.56 43.068C370.177 43.068 369.738 43.2827 369.244 43.712V48.5H367.424V44.356C367.424 43.4973 367.172 43.068 366.668 43.068C366.294 43.068 365.87 43.2687 365.394 43.67V48.5ZM380.523 48.066C379.636 48.4113 378.815 48.584 378.059 48.584C375.866 48.584 374.769 47.3987 374.769 45.028C374.769 43.824 375.035 42.914 375.567 42.298C376.099 41.6727 376.874 41.36 377.891 41.36C378.731 41.36 379.403 41.6213 379.907 42.144C380.411 42.6667 380.663 43.4413 380.663 44.468C380.663 44.8787 380.644 45.238 380.607 45.546H376.561C376.561 46.0967 376.71 46.5027 377.009 46.764C377.308 47.0253 377.709 47.156 378.213 47.156C378.717 47.156 379.384 47.044 380.215 46.82L380.523 48.066ZM378.913 44.258V44.16C378.913 43.7307 378.82 43.3853 378.633 43.124C378.446 42.8627 378.152 42.732 377.751 42.732C377.35 42.732 377.051 42.8767 376.855 43.166C376.659 43.4553 376.556 43.8193 376.547 44.258H378.913ZM382.289 46.988V43.04H381.575V41.5H382.303V39.498H384.109V41.5H385.579V43.04H384.095V46.092C384.095 46.7173 384.286 47.03 384.669 47.03C384.883 47.03 385.112 47.002 385.355 46.946L385.649 48.402C385.219 48.5233 384.762 48.584 384.277 48.584C383.801 48.584 383.348 48.4627 382.919 48.22C382.499 47.968 382.289 47.5573 382.289 46.988ZM393.12 48.5H391.3V44.314C391.3 43.9313 391.226 43.6233 391.076 43.39C390.927 43.1473 390.675 43.026 390.32 43.026C389.966 43.026 389.532 43.2407 389.018 43.67V48.5H387.198V38.7H389.018V42.13C389.42 41.8313 389.765 41.6307 390.054 41.528C390.353 41.416 390.698 41.36 391.09 41.36C391.716 41.36 392.21 41.57 392.574 41.99C392.938 42.4007 393.12 43.012 393.12 43.824V48.5ZM400.484 48.066C399.597 48.4113 398.776 48.584 398.02 48.584C395.827 48.584 394.73 47.3987 394.73 45.028C394.73 43.824 394.996 42.914 395.528 42.298C396.06 41.6727 396.835 41.36 397.852 41.36C398.692 41.36 399.364 41.6213 399.868 42.144C400.372 42.6667 400.624 43.4413 400.624 44.468C400.624 44.8787 400.605 45.238 400.568 45.546H396.522C396.522 46.0967 396.671 46.5027 396.97 46.764C397.269 47.0253 397.67 47.156 398.174 47.156C398.678 47.156 399.345 47.044 400.176 46.82L400.484 48.066ZM398.874 44.258V44.16C398.874 43.7307 398.781 43.3853 398.594 43.124C398.407 42.8627 398.113 42.732 397.712 42.732C397.311 42.732 397.012 42.8767 396.816 43.166C396.62 43.4553 396.517 43.8193 396.508 44.258H398.874ZM402.18 41.5H404.028V45.784C404.028 46.1667 404.102 46.4793 404.252 46.722C404.401 46.9553 404.648 47.072 404.994 47.072C405.339 47.072 405.768 46.8573 406.282 46.428V41.5H408.116V48.5H406.576L406.282 47.828C405.88 48.1267 405.53 48.3273 405.232 48.43C404.942 48.5327 404.602 48.584 404.21 48.584C403.584 48.584 403.09 48.3787 402.726 47.968C402.362 47.5573 402.18 46.946 402.18 46.134V41.5ZM410.26 46.638C410.885 46.9553 411.525 47.114 412.178 47.114C412.841 47.114 413.172 46.8713 413.172 46.386C413.172 45.938 412.799 45.6067 412.052 45.392C411.735 45.308 411.417 45.21 411.1 45.098C410.792 44.9767 410.526 44.7853 410.302 44.524C410.087 44.2533 409.98 43.908 409.98 43.488C409.98 42.8067 410.19 42.284 410.61 41.92C411.03 41.5467 411.613 41.36 412.36 41.36C413.116 41.36 413.83 41.4907 414.502 41.752L414.208 43.208C413.592 42.956 412.99 42.83 412.402 42.83C411.991 42.83 411.786 42.97 411.786 43.25C411.786 43.5393 412.061 43.7587 412.612 43.908C413.191 44.0573 413.704 44.272 414.152 44.552C414.385 44.692 414.581 44.902 414.74 45.182C414.899 45.462 414.978 45.798 414.978 46.19C414.978 46.9273 414.731 47.5107 414.236 47.94C413.741 48.3693 413.06 48.584 412.192 48.584C411.324 48.584 410.549 48.3833 409.868 47.982L410.26 46.638Z"
                    fill="#0F172A"
                  />
                </g>
              </g>
              <rect
                x="312.5"
                y="22"
                width="199"
                height="43"
                rx="3.5"
                stroke="#FBBF24"
              />
            </g>
            <g id="SchemaArrowWithLabel_2">
              <g id="Arrow top">
                <g id="SchemaArrow_3">
                  <path
                    id="Vector_7"
                    d="M416.5 69.58L416.19 70H407.795L407.5 69.595L411.72 65.5H412.341L416.5 69.58Z"
                    fill="#94A3B8"
                  />
                  <rect
                    id="Line_3"
                    x="412.5"
                    y="70"
                    width="19.5"
                    height="1"
                    transform="rotate(90 412.5 70)"
                    fill="#94A3B8"
                  />
                </g>
              </g>
              <g id="Horizontal_2">
                <g id="SchemaArrowLabel_2">
                  <g id="Icon_6">
                    <path
                      id="Vector_8"
                      d="M376.75 102.688V99.5H372.062C371.751 99.5 371.5 99.7508 371.5 100.062V110.938C371.5 111.249 371.751 111.5 372.062 111.5H379.938C380.249 111.5 380.5 111.249 380.5 110.938V103.25H377.312C377.003 103.25 376.75 102.997 376.75 102.688ZM378.542 107.641L376.282 109.884C376.126 110.039 375.874 110.039 375.719 109.884L373.459 107.641C373.221 107.405 373.388 107 373.722 107H375.25V105.125C375.25 104.918 375.418 104.75 375.625 104.75H376.375C376.582 104.75 376.75 104.918 376.75 105.125V107H378.278C378.612 107 378.779 107.405 378.542 107.641ZM380.336 101.961L378.041 99.6641C377.936 99.5586 377.793 99.5 377.643 99.5H377.5V102.5H380.5V102.357C380.5 102.209 380.441 102.066 380.336 101.961Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_6"
                    d="M387.992 109.5H387.092V101.1H387.992V109.5ZM391.074 104.736V109.5H390.174V103.5H390.75L390.894 104.088C391.078 103.944 391.226 103.832 391.338 103.752C391.458 103.672 391.646 103.592 391.902 103.512C392.158 103.424 392.43 103.38 392.718 103.38C393.27 103.38 393.726 103.552 394.086 103.896C394.454 104.232 394.638 104.712 394.638 105.336V109.5H393.738V105.6C393.738 104.632 393.334 104.148 392.526 104.148C391.95 104.148 391.466 104.344 391.074 104.736ZM397.479 101.1V102.156H396.579V101.1H397.479ZM396.087 111.948C396.415 111.524 396.579 110.844 396.579 109.908V103.5H397.479V109.62C397.479 110.308 397.411 110.856 397.275 111.264C397.147 111.672 396.927 112.04 396.615 112.368L396.087 111.948ZM403.643 106.692H399.815C399.815 107.46 399.995 108.004 400.355 108.324C400.723 108.644 401.183 108.804 401.735 108.804C402.015 108.804 402.211 108.792 402.323 108.768C402.435 108.736 402.539 108.708 402.635 108.684C402.739 108.652 402.811 108.628 402.851 108.612C403.051 108.556 403.223 108.504 403.367 108.456L403.511 109.152C402.711 109.432 402.087 109.572 401.639 109.572C400.815 109.572 400.155 109.324 399.659 108.828C399.163 108.324 398.915 107.572 398.915 106.572C398.915 105.564 399.147 104.78 399.611 104.22C400.083 103.66 400.675 103.38 401.387 103.38C402.107 103.38 402.667 103.612 403.067 104.076C403.467 104.54 403.667 105.168 403.667 105.96C403.667 106.176 403.659 106.42 403.643 106.692ZM399.875 106.008H402.803C402.803 105.416 402.699 104.96 402.491 104.64C402.283 104.32 401.919 104.16 401.399 104.16C400.887 104.16 400.511 104.332 400.271 104.676C400.031 105.02 399.899 105.464 399.875 106.008ZM408.878 108.564L409.058 109.272C408.418 109.464 407.854 109.56 407.366 109.56C406.51 109.56 405.866 109.28 405.434 108.72C405.002 108.16 404.786 107.388 404.786 106.404C404.786 105.42 405.01 104.672 405.458 104.16C405.906 103.64 406.566 103.38 407.438 103.38C407.814 103.38 408.342 103.476 409.022 103.668L408.662 104.364C408.222 104.236 407.826 104.172 407.474 104.172C406.866 104.172 406.426 104.352 406.154 104.712C405.89 105.072 405.758 105.64 405.758 106.416C405.758 107.992 406.322 108.78 407.45 108.78C407.898 108.78 408.374 108.708 408.878 108.564ZM410.685 108.204V104.22H409.869V103.5H410.697V101.784H411.597V103.5H413.061V104.22H411.585V108.036C411.585 108.572 411.857 108.84 412.401 108.84C412.529 108.84 412.725 108.816 412.989 108.768L413.121 109.416C412.793 109.52 412.453 109.572 412.101 109.572C411.757 109.572 411.433 109.468 411.129 109.26C410.833 109.044 410.685 108.692 410.685 108.204ZM424.77 109.5H423.87V102.612L421.17 107.292L420.858 107.28L418.158 102.624V109.5H417.27V101.1H418.278L421.026 105.72L423.87 101.1H424.77V109.5ZM430.701 106.692H426.873C426.873 107.46 427.053 108.004 427.413 108.324C427.781 108.644 428.241 108.804 428.793 108.804C429.073 108.804 429.269 108.792 429.381 108.768C429.493 108.736 429.597 108.708 429.693 108.684C429.797 108.652 429.869 108.628 429.909 108.612C430.109 108.556 430.281 108.504 430.425 108.456L430.569 109.152C429.769 109.432 429.145 109.572 428.697 109.572C427.873 109.572 427.213 109.324 426.717 108.828C426.221 108.324 425.973 107.572 425.973 106.572C425.973 105.564 426.205 104.78 426.669 104.22C427.141 103.66 427.733 103.38 428.445 103.38C429.165 103.38 429.725 103.612 430.125 104.076C430.525 104.54 430.725 105.168 430.725 105.96C430.725 106.176 430.717 106.42 430.701 106.692ZM426.933 106.008H429.861C429.861 105.416 429.757 104.96 429.549 104.64C429.341 104.32 428.977 104.16 428.457 104.16C427.945 104.16 427.569 104.332 427.329 104.676C427.089 105.02 426.957 105.464 426.933 106.008ZM432.552 108.204V104.22H431.736V103.5H432.564V101.784H433.464V103.5H434.928V104.22H433.452V108.036C433.452 108.572 433.724 108.84 434.268 108.84C434.396 108.84 434.592 108.816 434.856 108.768L434.988 109.416C434.66 109.52 434.32 109.572 433.968 109.572C433.624 109.572 433.3 109.468 432.996 109.26C432.7 109.044 432.552 108.692 432.552 108.204ZM437.457 104.916V109.5H436.557V103.5H437.133L437.277 104.208C437.661 103.904 437.981 103.692 438.237 103.572C438.493 103.444 438.785 103.38 439.113 103.38C439.273 103.38 439.393 103.388 439.473 103.404L439.641 103.452L439.497 104.28C439.353 104.232 439.157 104.208 438.909 104.208C438.429 104.208 437.945 104.444 437.457 104.916ZM440.842 109.5V103.5H441.742V109.5H440.842ZM441.742 101.1V102.168H440.842V101.1H441.742ZM447.268 108.564L447.448 109.272C446.808 109.464 446.244 109.56 445.756 109.56C444.9 109.56 444.256 109.28 443.824 108.72C443.392 108.16 443.176 107.388 443.176 106.404C443.176 105.42 443.4 104.672 443.848 104.16C444.296 103.64 444.956 103.38 445.828 103.38C446.204 103.38 446.732 103.476 447.412 103.668L447.052 104.364C446.612 104.236 446.216 104.172 445.864 104.172C445.256 104.172 444.816 104.352 444.544 104.712C444.28 105.072 444.148 105.64 444.148 106.416C444.148 107.992 444.712 108.78 445.84 108.78C446.288 108.78 446.764 108.708 447.268 108.564ZM448.704 108.432C449.224 108.672 449.72 108.792 450.192 108.792C450.664 108.792 451.02 108.7 451.26 108.516C451.508 108.324 451.632 108.072 451.632 107.76C451.632 107.448 451.528 107.208 451.32 107.04C451.112 106.864 450.856 106.728 450.552 106.632C450.256 106.536 449.956 106.432 449.652 106.32C449.356 106.208 449.104 106.04 448.896 105.816C448.688 105.592 448.584 105.308 448.584 104.964C448.584 104.46 448.748 104.072 449.076 103.8C449.404 103.52 449.848 103.38 450.408 103.38C450.968 103.38 451.488 103.464 451.968 103.632L452.052 103.668L451.896 104.436C451.416 104.252 450.968 104.16 450.552 104.16C450.144 104.16 449.864 104.224 449.712 104.352C449.56 104.48 449.484 104.696 449.484 105C449.484 105.192 449.588 105.356 449.796 105.492C450.004 105.628 450.256 105.748 450.552 105.852C450.856 105.948 451.156 106.064 451.452 106.2C451.756 106.328 452.012 106.524 452.22 106.788C452.428 107.052 452.532 107.376 452.532 107.76C452.532 108.32 452.336 108.764 451.944 109.092C451.552 109.412 451.012 109.572 450.324 109.572C449.636 109.572 449.024 109.416 448.488 109.104L448.704 108.432Z"
                    fill="#94A3B8"
                  />
                </g>
              </g>
              <g id="Arrow bottom">
                <g id="SchemaArrow_4">
                  <rect
                    id="Line_4"
                    x="412.5"
                    y="121.5"
                    width="24"
                    height="1"
                    transform="rotate(90 412.5 121.5)"
                    fill="#94A3B8"
                  />
                </g>
              </g>
            </g>
            <g id="SchemaCard_5" filter="url(#filter1_d_190_9936)">
              <rect
                x="312"
                y="145.5"
                width="200"
                height="92"
                rx="4"
                fill="white"
              />
              <g id="Container_5">
                <g id="Icon_7">
                  <g id="Group">
                    <path
                      id="Vector_9"
                      d="M336.83 165.512C337.187 164.395 336.972 162.163 336.28 161.34C336.19 161.232 336.02 161.247 335.945 161.366L335.093 162.711C334.882 162.98 334.502 163.042 334.217 162.854C333.293 162.246 332.188 161.892 331 161.892C329.812 161.892 328.707 162.246 327.783 162.854C327.498 163.042 327.118 162.979 326.907 162.711L326.055 161.366C325.98 161.247 325.81 161.232 325.72 161.34C325.028 162.163 324.813 164.395 325.17 165.512C325.288 165.883 325.322 166.275 325.251 166.658C325.182 167.037 325.112 167.495 325.112 167.812C325.112 171.081 327.749 173.733 331 173.733C334.252 173.733 336.888 171.083 336.888 167.812C336.888 167.494 336.819 167.037 336.749 166.658C336.678 166.275 336.712 165.883 336.83 165.512ZM331 172.409C328.487 172.409 326.442 170.353 326.442 167.826C326.442 167.743 326.445 167.662 326.448 167.58C326.54 165.858 327.579 164.385 329.052 163.684C329.642 163.4 330.304 163.243 331 163.243C331.696 163.243 332.358 163.402 332.95 163.685C334.422 164.387 335.462 165.86 335.553 167.58C335.558 167.662 335.56 167.743 335.56 167.826C335.558 170.353 333.513 172.409 331 172.409Z"
                      fill="black"
                    />
                    <path
                      id="Vector_10"
                      d="M332.974 169.59L331.81 167.56L330.81 165.867C330.787 165.827 330.744 165.803 330.697 165.803H329.742C329.694 165.803 329.652 165.829 329.629 165.869C329.606 165.91 329.606 165.961 329.63 166.001L330.585 167.617L329.303 169.584C329.277 169.624 329.273 169.676 329.296 169.719C329.319 169.762 329.364 169.788 329.411 169.788H330.372C330.417 169.788 330.458 169.765 330.483 169.728L331.176 168.639L331.797 169.722C331.82 169.764 331.865 169.788 331.911 169.788H332.858C332.906 169.788 332.948 169.764 332.971 169.722C332.999 169.681 332.999 169.631 332.974 169.59Z"
                      fill="black"
                    />
                  </g>
                </g>
                <path
                  id="Card label_7"
                  d="M350.302 172.5H348.272V168.216H345.024V172.5H342.994V162.7H345.024V166.606H348.272V162.7H350.302V172.5ZM356.141 172.5L355.861 171.8C355.534 172.099 355.245 172.309 354.993 172.43C354.741 172.542 354.438 172.598 354.083 172.598C353.486 172.598 352.963 172.393 352.515 171.982C352.076 171.562 351.857 171.007 351.857 170.316C351.857 169.625 352.128 169.084 352.669 168.692C353.21 168.291 354.027 168.09 355.119 168.09H355.693C355.693 167.689 355.595 167.367 355.399 167.124C355.212 166.881 354.923 166.76 354.531 166.76C353.85 166.76 353.159 166.853 352.459 167.04L352.151 165.808C353.075 165.509 354.004 165.36 354.937 165.36C356.636 165.36 357.485 166.153 357.485 167.74V172.5H356.141ZM355.665 169.434H355.063C354.54 169.434 354.186 169.504 353.999 169.644C353.812 169.784 353.719 169.989 353.719 170.26C353.719 170.521 353.789 170.736 353.929 170.904C354.069 171.072 354.251 171.156 354.475 171.156C354.792 171.156 355.189 170.904 355.665 170.4V169.434ZM359.346 170.638C359.971 170.955 360.611 171.114 361.264 171.114C361.927 171.114 362.258 170.871 362.258 170.386C362.258 169.938 361.885 169.607 361.138 169.392C360.821 169.308 360.503 169.21 360.186 169.098C359.878 168.977 359.612 168.785 359.388 168.524C359.173 168.253 359.066 167.908 359.066 167.488C359.066 166.807 359.276 166.284 359.696 165.92C360.116 165.547 360.699 165.36 361.446 165.36C362.202 165.36 362.916 165.491 363.588 165.752L363.294 167.208C362.678 166.956 362.076 166.83 361.488 166.83C361.077 166.83 360.872 166.97 360.872 167.25C360.872 167.539 361.147 167.759 361.698 167.908C362.277 168.057 362.79 168.272 363.238 168.552C363.471 168.692 363.667 168.902 363.826 169.182C363.985 169.462 364.064 169.798 364.064 170.19C364.064 170.927 363.817 171.511 363.322 171.94C362.827 172.369 362.146 172.584 361.278 172.584C360.41 172.584 359.635 172.383 358.954 171.982L359.346 170.638ZM365.553 165.5H367.401V169.784C367.401 170.167 367.475 170.479 367.625 170.722C367.774 170.955 368.021 171.072 368.367 171.072C368.712 171.072 369.141 170.857 369.655 170.428V165.5H371.489V172.5H369.949L369.655 171.828C369.253 172.127 368.903 172.327 368.605 172.43C368.315 172.533 367.975 172.584 367.583 172.584C366.957 172.584 366.463 172.379 366.099 171.968C365.735 171.557 365.553 170.946 365.553 170.134V165.5ZM375.593 167.852V172.5H373.759V165.5H375.215L375.383 166.186C375.756 165.887 376.069 165.677 376.321 165.556C376.573 165.425 376.792 165.36 376.979 165.36C377.175 165.36 377.306 165.365 377.371 165.374C377.436 165.374 377.492 165.379 377.539 165.388C377.586 165.397 377.665 165.416 377.777 165.444L377.609 167.11C377.441 167.054 377.212 167.026 376.923 167.026C376.531 167.026 376.088 167.301 375.593 167.852ZM382.938 172.5L382.658 171.8C382.331 172.099 382.042 172.309 381.79 172.43C381.538 172.542 381.234 172.598 380.88 172.598C380.282 172.598 379.76 172.393 379.312 171.982C378.873 171.562 378.654 171.007 378.654 170.316C378.654 169.625 378.924 169.084 379.466 168.692C380.007 168.291 380.824 168.09 381.916 168.09H382.49C382.49 167.689 382.392 167.367 382.196 167.124C382.009 166.881 381.72 166.76 381.328 166.76C380.646 166.76 379.956 166.853 379.256 167.04L378.948 165.808C379.872 165.509 380.8 165.36 381.734 165.36C383.432 165.36 384.282 166.153 384.282 167.74V172.5H382.938ZM382.462 169.434H381.86C381.337 169.434 380.982 169.504 380.796 169.644C380.609 169.784 380.516 169.989 380.516 170.26C380.516 170.521 380.586 170.736 380.726 170.904C380.866 171.072 381.048 171.156 381.272 171.156C381.589 171.156 381.986 170.904 382.462 170.4V169.434Z"
                  fill="#0F172A"
                />
              </g>{' '}
              <a
                href="https://hasura.io/docs/latest/enterprise/metrics/#metrics-exported"
                className="hover:cursor-pointer"
              >
                <g id="Items">
                  <path
                    d="M312 189.5H512V234C512 235.933 510.433 237.5 508.5 237.5H315.5C313.567 237.5 312 235.933 312 234V189.5Z"
                    fill="#F1F5F9"
                  />
                  <g id="SchemaCardItem">
                    <g id="Content">
                      <g id="SchemaCardItemText">
                        <g id="Icon_8">
                          <path
                            id="Vector_11"
                            d="M330.25 196.31C327.383 196.31 325.06 198.633 325.06 201.5C325.06 204.367 327.383 206.69 330.25 206.69C333.117 206.69 335.44 204.367 335.44 201.5C335.44 198.633 333.117 196.31 330.25 196.31ZM332.795 202.862C332.893 202.961 332.893 203.12 332.795 203.218L331.966 204.045C331.868 204.143 331.709 204.143 331.61 204.045L330.25 202.672L328.888 204.045C328.789 204.143 328.63 204.143 328.532 204.045L327.705 203.216C327.607 203.118 327.607 202.959 327.705 202.86L329.078 201.5L327.705 200.138C327.607 200.039 327.607 199.88 327.705 199.782L328.534 198.953C328.632 198.855 328.791 198.855 328.89 198.953L330.25 200.328L331.612 198.955C331.711 198.857 331.87 198.857 331.968 198.955L332.797 199.784C332.895 199.882 332.895 200.041 332.797 200.14L331.422 201.5L332.795 202.862Z"
                            fill="#94A3B8"
                          />
                        </g>
                        <path
                          id="Card item label"
                          d="M343.716 201.972H342.492V205.5H341.592V197.1H343.992C344.888 197.1 345.536 197.296 345.936 197.688C346.344 198.08 346.548 198.692 346.548 199.524C346.548 200.348 346.3 200.964 345.804 201.372C345.308 201.772 344.612 201.972 343.716 201.972ZM343.584 197.868H342.492V201.204H343.284C344.108 201.204 344.708 201.08 345.084 200.832C345.46 200.584 345.648 200.16 345.648 199.56C345.648 198.952 345.484 198.52 345.156 198.264C344.828 198 344.304 197.868 343.584 197.868ZM348.984 200.916V205.5H348.084V199.5H348.66L348.804 200.208C349.188 199.904 349.508 199.692 349.764 199.572C350.02 199.444 350.312 199.38 350.64 199.38C350.8 199.38 350.92 199.388 351 199.404L351.168 199.452L351.024 200.28C350.88 200.232 350.684 200.208 350.436 200.208C349.956 200.208 349.472 200.444 348.984 200.916ZM356.245 202.548C356.245 201.772 356.093 201.18 355.789 200.772C355.485 200.364 355.041 200.16 354.457 200.16C353.873 200.16 353.457 200.356 353.209 200.748C352.969 201.132 352.849 201.724 352.849 202.524C352.849 204.036 353.405 204.792 354.517 204.792C355.101 204.792 355.533 204.612 355.813 204.252C356.101 203.884 356.245 203.316 356.245 202.548ZM356.461 204.756C356.005 205.3 355.361 205.572 354.529 205.572C353.697 205.572 353.057 205.304 352.609 204.768C352.169 204.224 351.949 203.468 351.949 202.5C351.949 201.524 352.161 200.76 352.585 200.208C353.017 199.656 353.645 199.38 354.469 199.38C355.301 199.38 355.953 199.66 356.425 200.22C356.905 200.78 357.145 201.54 357.145 202.5C357.145 203.46 356.917 204.212 356.461 204.756ZM361.28 199.368C362.048 199.368 362.596 199.64 362.924 200.184C363.604 199.64 364.232 199.368 364.808 199.368C365.384 199.368 365.852 199.532 366.212 199.86C366.58 200.18 366.764 200.648 366.764 201.264V205.5H365.888V201.636C365.888 201.148 365.776 200.78 365.552 200.532C365.336 200.276 365.044 200.148 364.676 200.148C364.172 200.148 363.664 200.348 363.152 200.748C363.192 200.924 363.212 201.096 363.212 201.264V205.5H362.336V201.636C362.336 201.148 362.224 200.78 362 200.532C361.784 200.276 361.492 200.148 361.124 200.148C360.884 200.148 360.664 200.18 360.464 200.244C360.264 200.308 360.116 200.372 360.02 200.436C359.924 200.5 359.8 200.596 359.648 200.724V205.5H358.748V199.5H359.324L359.48 200.112C359.68 199.944 359.832 199.824 359.936 199.752C360.048 199.672 360.228 199.588 360.476 199.5C360.724 199.412 360.992 199.368 361.28 199.368ZM373.108 202.692H369.28C369.28 203.46 369.46 204.004 369.82 204.324C370.188 204.644 370.648 204.804 371.2 204.804C371.48 204.804 371.676 204.792 371.788 204.768C371.9 204.736 372.004 204.708 372.1 204.684C372.204 204.652 372.276 204.628 372.316 204.612C372.516 204.556 372.688 204.504 372.832 204.456L372.976 205.152C372.176 205.432 371.552 205.572 371.104 205.572C370.28 205.572 369.62 205.324 369.124 204.828C368.628 204.324 368.38 203.572 368.38 202.572C368.38 201.564 368.612 200.78 369.076 200.22C369.548 199.66 370.14 199.38 370.852 199.38C371.572 199.38 372.132 199.612 372.532 200.076C372.932 200.54 373.132 201.168 373.132 201.96C373.132 202.176 373.124 202.42 373.108 202.692ZM369.34 202.008H372.268C372.268 201.416 372.164 200.96 371.956 200.64C371.748 200.32 371.384 200.16 370.864 200.16C370.352 200.16 369.976 200.332 369.736 200.676C369.496 201.02 369.364 201.464 369.34 202.008ZM374.959 204.204V200.22H374.143V199.5H374.971V197.784H375.871V199.5H377.335V200.22H375.859V204.036C375.859 204.572 376.131 204.84 376.675 204.84C376.803 204.84 376.999 204.816 377.263 204.768L377.395 205.416C377.067 205.52 376.727 205.572 376.375 205.572C376.031 205.572 375.707 205.468 375.403 205.26C375.107 205.044 374.959 204.692 374.959 204.204ZM383.451 205.5H382.551V201.552C382.551 200.584 382.147 200.1 381.339 200.1C380.739 200.1 380.247 200.292 379.863 200.676V205.5H378.963V197.1H379.851V199.944C380.027 199.8 380.163 199.696 380.259 199.632C380.363 199.568 380.527 199.504 380.751 199.44C380.983 199.376 381.243 199.344 381.531 199.344C382.083 199.344 382.539 199.512 382.899 199.848C383.267 200.184 383.451 200.664 383.451 201.288V205.5ZM389.795 202.692H385.967C385.967 203.46 386.147 204.004 386.507 204.324C386.875 204.644 387.335 204.804 387.887 204.804C388.167 204.804 388.363 204.792 388.475 204.768C388.587 204.736 388.691 204.708 388.787 204.684C388.891 204.652 388.963 204.628 389.003 204.612C389.203 204.556 389.375 204.504 389.519 204.456L389.663 205.152C388.863 205.432 388.239 205.572 387.791 205.572C386.967 205.572 386.307 205.324 385.811 204.828C385.315 204.324 385.067 203.572 385.067 202.572C385.067 201.564 385.299 200.78 385.763 200.22C386.235 199.66 386.827 199.38 387.539 199.38C388.259 199.38 388.819 199.612 389.219 200.076C389.619 200.54 389.819 201.168 389.819 201.96C389.819 202.176 389.811 202.42 389.795 202.692ZM386.027 202.008H388.955C388.955 201.416 388.851 200.96 388.643 200.64C388.435 200.32 388.071 200.16 387.551 200.16C387.039 200.16 386.663 200.332 386.423 200.676C386.183 201.02 386.051 201.464 386.027 202.008ZM394.934 203.976V199.5H395.846V205.5H395.318L395.018 204.792C394.378 205.312 393.766 205.572 393.182 205.572C392.598 205.572 392.15 205.404 391.838 205.068C391.534 204.724 391.382 204.24 391.382 203.616V199.5H392.282V203.472C392.282 203.944 392.35 204.284 392.486 204.492C392.63 204.7 392.862 204.804 393.182 204.804C393.51 204.804 393.842 204.716 394.178 204.54C394.514 204.364 394.766 204.176 394.934 203.976ZM397.802 204.432C398.322 204.672 398.818 204.792 399.29 204.792C399.762 204.792 400.118 204.7 400.358 204.516C400.606 204.324 400.73 204.072 400.73 203.76C400.73 203.448 400.626 203.208 400.418 203.04C400.21 202.864 399.954 202.728 399.65 202.632C399.354 202.536 399.054 202.432 398.75 202.32C398.454 202.208 398.202 202.04 397.994 201.816C397.786 201.592 397.682 201.308 397.682 200.964C397.682 200.46 397.846 200.072 398.174 199.8C398.502 199.52 398.946 199.38 399.506 199.38C400.066 199.38 400.586 199.464 401.066 199.632L401.15 199.668L400.994 200.436C400.514 200.252 400.066 200.16 399.65 200.16C399.242 200.16 398.962 200.224 398.81 200.352C398.658 200.48 398.582 200.696 398.582 201C398.582 201.192 398.686 201.356 398.894 201.492C399.102 201.628 399.354 201.748 399.65 201.852C399.954 201.948 400.254 202.064 400.55 202.2C400.854 202.328 401.11 202.524 401.318 202.788C401.526 203.052 401.63 203.376 401.63 203.76C401.63 204.32 401.434 204.764 401.042 205.092C400.65 205.412 400.11 205.572 399.422 205.572C398.734 205.572 398.122 205.416 397.586 205.104L397.802 204.432ZM412.328 201C412.328 202.352 411.936 203.44 411.152 204.264C410.368 205.088 409.32 205.5 408.008 205.5H406.256V197.1H408.38C409.572 197.1 410.528 197.464 411.248 198.192C411.968 198.92 412.328 199.856 412.328 201ZM411.356 200.904C411.356 199.96 411.068 199.22 410.492 198.684C409.916 198.148 409.228 197.88 408.428 197.88H407.228V204.72H408.116C409.02 204.72 409.784 204.38 410.408 203.7C411.04 203.02 411.356 202.088 411.356 200.904ZM413.858 205.5V199.5H414.758V205.5H413.858ZM414.758 197.1V198.168H413.858V197.1H414.758ZM416.528 204.432C417.048 204.672 417.544 204.792 418.016 204.792C418.488 204.792 418.844 204.7 419.084 204.516C419.332 204.324 419.456 204.072 419.456 203.76C419.456 203.448 419.352 203.208 419.144 203.04C418.936 202.864 418.68 202.728 418.376 202.632C418.08 202.536 417.78 202.432 417.476 202.32C417.18 202.208 416.928 202.04 416.72 201.816C416.512 201.592 416.408 201.308 416.408 200.964C416.408 200.46 416.572 200.072 416.9 199.8C417.228 199.52 417.672 199.38 418.232 199.38C418.792 199.38 419.312 199.464 419.792 199.632L419.876 199.668L419.72 200.436C419.24 200.252 418.792 200.16 418.376 200.16C417.968 200.16 417.688 200.224 417.536 200.352C417.384 200.48 417.308 200.696 417.308 201C417.308 201.192 417.412 201.356 417.62 201.492C417.828 201.628 418.08 201.748 418.376 201.852C418.68 201.948 418.98 202.064 419.276 202.2C419.58 202.328 419.836 202.524 420.044 202.788C420.252 203.052 420.356 203.376 420.356 203.76C420.356 204.32 420.16 204.764 419.768 205.092C419.376 205.412 418.836 205.572 418.148 205.572C417.46 205.572 416.848 205.416 416.312 205.104L416.528 204.432ZM424.575 201.912H425.067C425.067 201.184 424.975 200.712 424.791 200.496C424.607 200.272 424.199 200.16 423.567 200.16C422.935 200.16 422.399 200.244 421.959 200.412L421.791 199.716C422.463 199.492 423.159 199.38 423.879 199.38C425.287 199.38 425.991 200.084 425.991 201.492V205.5H425.463L425.151 204.792C424.783 205.096 424.463 205.304 424.191 205.416C423.927 205.52 423.619 205.572 423.267 205.572C422.707 205.572 422.271 205.408 421.959 205.08C421.647 204.744 421.491 204.304 421.491 203.76C421.491 202.528 422.519 201.912 424.575 201.912ZM425.079 202.668H424.539C423.723 202.668 423.159 202.748 422.847 202.908C422.543 203.068 422.391 203.32 422.391 203.664C422.391 204 422.479 204.276 422.655 204.492C422.831 204.708 423.059 204.816 423.339 204.816C423.627 204.816 423.899 204.752 424.155 204.624C424.419 204.488 424.727 204.256 425.079 203.928V202.668ZM428.17 197.1H429.07V200.1C429.758 199.612 430.374 199.368 430.918 199.368C432.358 199.368 433.078 200.404 433.078 202.476C433.078 203.652 432.822 204.476 432.31 204.948C431.854 205.364 431.318 205.572 430.702 205.572C430.39 205.572 430.074 205.504 429.754 205.368C429.434 205.224 429.17 205.072 428.962 204.912L428.698 205.5H428.17V197.1ZM429.07 200.952V204.216C429.23 204.4 429.442 204.544 429.706 204.648C429.978 204.752 430.242 204.804 430.498 204.804C431.122 204.804 431.558 204.62 431.806 204.252C432.054 203.884 432.178 203.308 432.178 202.524C432.178 201.74 432.054 201.148 431.806 200.748C431.558 200.348 431.242 200.148 430.858 200.148C430.282 200.148 429.686 200.416 429.07 200.952ZM434.721 205.5V197.1H435.621V205.5H434.721ZM441.967 202.692H438.139C438.139 203.46 438.319 204.004 438.679 204.324C439.047 204.644 439.507 204.804 440.059 204.804C440.339 204.804 440.535 204.792 440.647 204.768C440.759 204.736 440.863 204.708 440.959 204.684C441.063 204.652 441.135 204.628 441.175 204.612C441.375 204.556 441.547 204.504 441.691 204.456L441.835 205.152C441.035 205.432 440.411 205.572 439.963 205.572C439.139 205.572 438.479 205.324 437.983 204.828C437.487 204.324 437.239 203.572 437.239 202.572C437.239 201.564 437.471 200.78 437.935 200.22C438.407 199.66 438.999 199.38 439.711 199.38C440.431 199.38 440.991 199.612 441.391 200.076C441.791 200.54 441.991 201.168 441.991 201.96C441.991 202.176 441.983 202.42 441.967 202.692ZM438.199 202.008H441.127C441.127 201.416 441.023 200.96 440.815 200.64C440.607 200.32 440.243 200.16 439.723 200.16C439.211 200.16 438.835 200.332 438.595 200.676C438.355 201.02 438.223 201.464 438.199 202.008ZM447.094 197.1H447.994V205.5H447.466L447.166 204.816C446.43 205.336 445.79 205.596 445.246 205.596C443.806 205.596 443.086 204.56 443.086 202.488C443.086 201.312 443.342 200.492 443.854 200.028C444.31 199.604 444.826 199.392 445.402 199.392C445.978 199.392 446.542 199.588 447.094 199.98V197.1ZM447.094 204.012V200.892C446.926 200.692 446.702 200.52 446.422 200.376C446.15 200.232 445.898 200.16 445.666 200.16C445.042 200.16 444.606 200.344 444.358 200.712C444.11 201.08 443.986 201.656 443.986 202.44C443.986 203.224 444.11 203.816 444.358 204.216C444.606 204.616 444.922 204.816 445.306 204.816C445.882 204.816 446.478 204.548 447.094 204.012Z"
                          fill="#94A3B8"
                        />
                      </g>
                    </g>
                    <path
                      d="M312 190.5H512V188.5H312V190.5Z"
                      fill="#E2E8F0"
                      mask="url(#path-33-inside-2_190_9936)"
                    />
                  </g>
                  <g id="SchemaCardItem_2">
                    <g id="Content_2">
                      <g id="SchemaCardItemText_2">
                        <g id="Content_3">
                          <g id="Icon_9">
                            <path
                              id="Vector_12"
                              d="M332.05 227H332.95C333.1 227 333.25 226.85 333.25 226.7V223.55C333.25 223.4 333.1 223.25 332.95 223.25H332.05C331.9 223.25 331.75 223.4 331.75 223.55V226.7C331.75 226.85 331.9 227 332.05 227ZM334.3 227H335.2C335.35 227 335.5 226.85 335.5 226.7V221.3C335.5 221.15 335.35 221 335.2 221H334.3C334.15 221 334 221.15 334 221.3V226.7C334 226.85 334.15 227 334.3 227ZM327.55 227H328.45C328.6 227 328.75 226.85 328.75 226.7V225.05C328.75 224.9 328.6 224.75 328.45 224.75H327.55C327.4 224.75 327.25 224.9 327.25 225.05V226.7C327.25 226.85 327.4 227 327.55 227ZM329.8 227H330.7C330.85 227 331 226.85 331 226.7V222.05C331 221.9 330.85 221.75 330.7 221.75H329.8C329.65 221.75 329.5 221.9 329.5 222.05V226.7C329.5 226.85 329.65 227 329.8 227ZM335.875 228.5H325.75V221.375C325.75 221.168 325.582 221 325.375 221H324.625C324.418 221 324.25 221.168 324.25 221.375V229.25C324.25 229.664 324.586 230 325 230H335.875C336.082 230 336.25 229.832 336.25 229.625V228.875C336.25 228.668 336.082 228.5 335.875 228.5Z"
                              fill="#297393"
                            />
                          </g>
                          <path
                            id="Card item label_2"
                            d="M347.292 229.5H346.284L345.444 226.848H342.432L341.604 229.5H340.656L343.416 221.1H344.508L347.292 229.5ZM345.24 226.068L343.956 222.012L342.66 226.068H345.24ZM352.657 223.488L350.629 229.5H349.597L347.581 223.488H348.601L350.125 228.54L351.661 223.488H352.657ZM356.477 225.912H356.969C356.969 225.184 356.877 224.712 356.693 224.496C356.509 224.272 356.101 224.16 355.469 224.16C354.837 224.16 354.301 224.244 353.861 224.412L353.693 223.716C354.365 223.492 355.061 223.38 355.781 223.38C357.189 223.38 357.893 224.084 357.893 225.492V229.5H357.365L357.053 228.792C356.685 229.096 356.365 229.304 356.093 229.416C355.829 229.52 355.521 229.572 355.169 229.572C354.609 229.572 354.173 229.408 353.861 229.08C353.549 228.744 353.393 228.304 353.393 227.76C353.393 226.528 354.421 225.912 356.477 225.912ZM356.981 226.668H356.441C355.625 226.668 355.061 226.748 354.749 226.908C354.445 227.068 354.293 227.32 354.293 227.664C354.293 228 354.381 228.276 354.557 228.492C354.733 228.708 354.961 228.816 355.241 228.816C355.529 228.816 355.801 228.752 356.057 228.624C356.321 228.488 356.629 228.256 356.981 227.928V226.668ZM359.904 229.5V223.5H360.804V229.5H359.904ZM360.804 221.1V222.168H359.904V221.1H360.804ZM362.803 229.5V221.1H363.703V229.5H362.803ZM368.477 225.912H368.969C368.969 225.184 368.877 224.712 368.693 224.496C368.509 224.272 368.101 224.16 367.469 224.16C366.837 224.16 366.301 224.244 365.861 224.412L365.693 223.716C366.365 223.492 367.061 223.38 367.781 223.38C369.189 223.38 369.893 224.084 369.893 225.492V229.5H369.365L369.053 228.792C368.685 229.096 368.365 229.304 368.093 229.416C367.829 229.52 367.521 229.572 367.169 229.572C366.609 229.572 366.173 229.408 365.861 229.08C365.549 228.744 365.393 228.304 365.393 227.76C365.393 226.528 366.421 225.912 368.477 225.912ZM368.981 226.668H368.441C367.625 226.668 367.061 226.748 366.749 226.908C366.445 227.068 366.293 227.32 366.293 227.664C366.293 228 366.381 228.276 366.557 228.492C366.733 228.708 366.961 228.816 367.241 228.816C367.529 228.816 367.801 228.752 368.057 228.624C368.321 228.488 368.629 228.256 368.981 227.928V226.668ZM372.072 221.1H372.972V224.1C373.66 223.612 374.276 223.368 374.82 223.368C376.26 223.368 376.98 224.404 376.98 226.476C376.98 227.652 376.724 228.476 376.212 228.948C375.756 229.364 375.22 229.572 374.604 229.572C374.292 229.572 373.976 229.504 373.656 229.368C373.336 229.224 373.072 229.072 372.864 228.912L372.6 229.5H372.072V221.1ZM372.972 224.952V228.216C373.132 228.4 373.344 228.544 373.608 228.648C373.88 228.752 374.144 228.804 374.4 228.804C375.024 228.804 375.46 228.62 375.708 228.252C375.956 227.884 376.08 227.308 376.08 226.524C376.08 225.74 375.956 225.148 375.708 224.748C375.46 224.348 375.144 224.148 374.76 224.148C374.184 224.148 373.588 224.416 372.972 224.952ZM378.623 229.5V221.1H379.523V229.5H378.623ZM385.869 226.692H382.041C382.041 227.46 382.221 228.004 382.581 228.324C382.949 228.644 383.409 228.804 383.961 228.804C384.241 228.804 384.437 228.792 384.549 228.768C384.661 228.736 384.765 228.708 384.861 228.684C384.965 228.652 385.037 228.628 385.077 228.612C385.277 228.556 385.449 228.504 385.593 228.456L385.737 229.152C384.937 229.432 384.313 229.572 383.865 229.572C383.041 229.572 382.381 229.324 381.885 228.828C381.389 228.324 381.141 227.572 381.141 226.572C381.141 225.564 381.373 224.78 381.837 224.22C382.309 223.66 382.901 223.38 383.613 223.38C384.333 223.38 384.893 223.612 385.293 224.076C385.693 224.54 385.893 225.168 385.893 225.96C385.893 226.176 385.885 226.42 385.869 226.692ZM382.101 226.008H385.029C385.029 225.416 384.925 224.96 384.717 224.64C384.509 224.32 384.145 224.16 383.625 224.16C383.113 224.16 382.737 224.332 382.497 224.676C382.257 225.02 382.125 225.464 382.101 226.008ZM393.108 223.368C393.876 223.368 394.424 223.64 394.752 224.184C395.432 223.64 396.06 223.368 396.636 223.368C397.212 223.368 397.68 223.532 398.04 223.86C398.408 224.18 398.592 224.648 398.592 225.264V229.5H397.716V225.636C397.716 225.148 397.604 224.78 397.38 224.532C397.164 224.276 396.872 224.148 396.504 224.148C396 224.148 395.492 224.348 394.98 224.748C395.02 224.924 395.04 225.096 395.04 225.264V229.5H394.164V225.636C394.164 225.148 394.052 224.78 393.828 224.532C393.612 224.276 393.32 224.148 392.952 224.148C392.712 224.148 392.492 224.18 392.292 224.244C392.092 224.308 391.944 224.372 391.848 224.436C391.752 224.5 391.628 224.596 391.476 224.724V229.5H390.576V223.5H391.152L391.308 224.112C391.508 223.944 391.66 223.824 391.764 223.752C391.876 223.672 392.056 223.588 392.304 223.5C392.552 223.412 392.82 223.368 393.108 223.368ZM404.936 226.692H401.108C401.108 227.46 401.288 228.004 401.648 228.324C402.016 228.644 402.476 228.804 403.028 228.804C403.308 228.804 403.504 228.792 403.616 228.768C403.728 228.736 403.832 228.708 403.928 228.684C404.032 228.652 404.104 228.628 404.144 228.612C404.344 228.556 404.516 228.504 404.66 228.456L404.804 229.152C404.004 229.432 403.38 229.572 402.932 229.572C402.108 229.572 401.448 229.324 400.952 228.828C400.456 228.324 400.208 227.572 400.208 226.572C400.208 225.564 400.44 224.78 400.904 224.22C401.376 223.66 401.968 223.38 402.68 223.38C403.4 223.38 403.96 223.612 404.36 224.076C404.76 224.54 404.96 225.168 404.96 225.96C404.96 226.176 404.952 226.42 404.936 226.692ZM401.168 226.008H404.096C404.096 225.416 403.992 224.96 403.784 224.64C403.576 224.32 403.212 224.16 402.692 224.16C402.18 224.16 401.804 224.332 401.564 224.676C401.324 225.02 401.192 225.464 401.168 226.008ZM406.787 228.204V224.22H405.971V223.5H406.799V221.784H407.699V223.5H409.163V224.22H407.687V228.036C407.687 228.572 407.959 228.84 408.503 228.84C408.631 228.84 408.827 228.816 409.091 228.768L409.223 229.416C408.895 229.52 408.555 229.572 408.203 229.572C407.859 229.572 407.535 229.468 407.231 229.26C406.935 229.044 406.787 228.692 406.787 228.204ZM411.691 224.916V229.5H410.791V223.5H411.367L411.511 224.208C411.895 223.904 412.215 223.692 412.471 223.572C412.727 223.444 413.019 223.38 413.347 223.38C413.507 223.38 413.627 223.388 413.707 223.404L413.875 223.452L413.731 224.28C413.587 224.232 413.391 224.208 413.143 224.208C412.663 224.208 412.179 224.444 411.691 224.916ZM415.076 229.5V223.5H415.976V229.5H415.076ZM415.976 221.1V222.168H415.076V221.1H415.976ZM421.503 228.564L421.683 229.272C421.043 229.464 420.479 229.56 419.991 229.56C419.135 229.56 418.491 229.28 418.059 228.72C417.627 228.16 417.411 227.388 417.411 226.404C417.411 225.42 417.635 224.672 418.083 224.16C418.531 223.64 419.191 223.38 420.063 223.38C420.439 223.38 420.967 223.476 421.647 223.668L421.287 224.364C420.847 224.236 420.451 224.172 420.099 224.172C419.491 224.172 419.051 224.352 418.779 224.712C418.515 225.072 418.383 225.64 418.383 226.416C418.383 227.992 418.947 228.78 420.075 228.78C420.523 228.78 420.999 228.708 421.503 228.564ZM422.938 228.432C423.458 228.672 423.954 228.792 424.426 228.792C424.898 228.792 425.254 228.7 425.494 228.516C425.742 228.324 425.866 228.072 425.866 227.76C425.866 227.448 425.762 227.208 425.554 227.04C425.346 226.864 425.09 226.728 424.786 226.632C424.49 226.536 424.19 226.432 423.886 226.32C423.59 226.208 423.338 226.04 423.13 225.816C422.922 225.592 422.818 225.308 422.818 224.964C422.818 224.46 422.982 224.072 423.31 223.8C423.638 223.52 424.082 223.38 424.642 223.38C425.202 223.38 425.722 223.464 426.202 223.632L426.286 223.668L426.13 224.436C425.65 224.252 425.202 224.16 424.786 224.16C424.378 224.16 424.098 224.224 423.946 224.352C423.794 224.48 423.718 224.696 423.718 225C423.718 225.192 423.822 225.356 424.03 225.492C424.238 225.628 424.49 225.748 424.786 225.852C425.09 225.948 425.39 226.064 425.686 226.2C425.99 226.328 426.246 226.524 426.454 226.788C426.662 227.052 426.766 227.376 426.766 227.76C426.766 228.32 426.57 228.764 426.178 229.092C425.786 229.412 425.246 229.572 424.558 229.572C423.87 229.572 423.258 229.416 422.722 229.104L422.938 228.432Z"
                            fill="#297393"
                          />
                        </g>
                        <g id="Icon_10">
                          <path
                            id="Vector_13"
                            d="M495.109 227.562H494.453C494.366 227.562 494.283 227.597 494.221 227.659C494.16 227.72 494.125 227.804 494.125 227.891V230.188H487.562V223.625H490.516C490.603 223.625 490.686 223.59 490.748 223.529C490.809 223.467 490.844 223.384 490.844 223.297V222.641C490.844 222.554 490.809 222.47 490.748 222.409C490.686 222.347 490.603 222.312 490.516 222.312H487.234C486.973 222.312 486.723 222.416 486.538 222.601C486.354 222.785 486.25 223.036 486.25 223.297V230.516C486.25 230.777 486.354 231.027 486.538 231.212C486.723 231.396 486.973 231.5 487.234 231.5H494.453C494.714 231.5 494.965 231.396 495.149 231.212C495.334 231.027 495.438 230.777 495.438 230.516V227.891C495.438 227.804 495.403 227.72 495.341 227.659C495.28 227.597 495.196 227.562 495.109 227.562ZM496.258 221H493.633C493.195 221 492.976 221.531 493.284 221.841L494.017 222.574L489.019 227.57C488.973 227.616 488.936 227.67 488.911 227.73C488.887 227.79 488.874 227.854 488.874 227.919C488.874 227.983 488.887 228.048 488.911 228.107C488.936 228.167 488.973 228.222 489.019 228.267L489.483 228.731C489.529 228.777 489.584 228.814 489.643 228.839C489.703 228.863 489.767 228.876 489.832 228.876C489.897 228.876 489.961 228.863 490.021 228.839C490.081 228.814 490.135 228.777 490.181 228.731L495.177 223.734L495.909 224.466C496.217 224.773 496.75 224.558 496.75 224.117V221.492C496.75 221.362 496.698 221.236 496.606 221.144C496.514 221.052 496.388 221 496.258 221V221Z"
                            fill="#94A3B8"
                          />
                        </g>
                      </g>
                    </g>
                    <path
                      d="M312 214.5H512V212.5H312V214.5Z"
                      fill="#E2E8F0"
                      mask="url(#path-37-inside-3_190_9936)"
                    />
                  </g>
                </g>
              </a>
            </g>
          </g>
          <g id="Right">
            <g id="SchemaArrowWithLabel_3">
              <g id="Horizontal_3">
                <g id="Arrow left_2">
                  <g id="SchemaArrow_5">
                    <rect
                      id="Line_5"
                      x="512"
                      y="169"
                      width="22"
                      height="1"
                      fill="#94A3B8"
                    />
                    <path
                      id="Vector_14"
                      d="M534.42 174L534 173.69V165.295L534.405 165L538.5 169.22V169.841L534.42 174Z"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
                <g id="SchemaArrowLabel_3">
                  <g id="Icon_11">
                    <path
                      id="Vector_15"
                      d="M555.688 167.25H552.983L553.981 164.208C554.075 163.852 553.806 163.5 553.438 163.5H550.063C549.781 163.5 549.542 163.709 549.505 163.987L548.755 169.612C548.71 169.95 548.973 170.25 549.313 170.25H552.095L551.014 174.809C550.93 175.165 551.202 175.5 551.56 175.5C551.757 175.5 551.945 175.397 552.048 175.219L556.173 168.094C556.391 167.721 556.121 167.25 555.688 167.25Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <path
                    id="Card label_8"
                    d="M565.716 169.972H564.492V173.5H563.592V165.1H565.992C566.888 165.1 567.536 165.296 567.936 165.688C568.344 166.08 568.548 166.692 568.548 167.524C568.548 168.348 568.3 168.964 567.804 169.372C567.308 169.772 566.612 169.972 565.716 169.972ZM565.584 165.868H564.492V169.204H565.284C566.108 169.204 566.708 169.08 567.084 168.832C567.46 168.584 567.648 168.16 567.648 167.56C567.648 166.952 567.484 166.52 567.156 166.264C566.828 166 566.304 165.868 565.584 165.868ZM573.675 170.548C573.675 169.772 573.523 169.18 573.219 168.772C572.915 168.364 572.471 168.16 571.887 168.16C571.303 168.16 570.887 168.356 570.639 168.748C570.399 169.132 570.279 169.724 570.279 170.524C570.279 172.036 570.835 172.792 571.947 172.792C572.531 172.792 572.963 172.612 573.243 172.252C573.531 171.884 573.675 171.316 573.675 170.548ZM573.891 172.756C573.435 173.3 572.791 173.572 571.959 173.572C571.127 173.572 570.487 173.304 570.039 172.768C569.599 172.224 569.379 171.468 569.379 170.5C569.379 169.524 569.591 168.76 570.015 168.208C570.447 167.656 571.075 167.38 571.899 167.38C572.731 167.38 573.383 167.66 573.855 168.22C574.335 168.78 574.575 169.54 574.575 170.5C574.575 171.46 574.347 172.212 573.891 172.756ZM576.97 173.5L575.218 167.5H576.154L577.486 172.552L578.722 167.5H579.61L580.942 172.6L582.166 167.5H583.102L581.458 173.5H580.402L579.166 168.76L578.002 173.5H576.97ZM588.486 170.692H584.658C584.658 171.46 584.838 172.004 585.198 172.324C585.566 172.644 586.026 172.804 586.578 172.804C586.858 172.804 587.054 172.792 587.166 172.768C587.278 172.736 587.382 172.708 587.478 172.684C587.582 172.652 587.654 172.628 587.694 172.612C587.894 172.556 588.066 172.504 588.21 172.456L588.354 173.152C587.554 173.432 586.93 173.572 586.482 173.572C585.658 173.572 584.998 173.324 584.502 172.828C584.006 172.324 583.758 171.572 583.758 170.572C583.758 169.564 583.99 168.78 584.454 168.22C584.926 167.66 585.518 167.38 586.23 167.38C586.95 167.38 587.51 167.612 587.91 168.076C588.31 168.54 588.51 169.168 588.51 169.96C588.51 170.176 588.502 170.42 588.486 170.692ZM584.718 170.008H587.646C587.646 169.416 587.542 168.96 587.334 168.64C587.126 168.32 586.762 168.16 586.242 168.16C585.73 168.16 585.354 168.332 585.114 168.676C584.874 169.02 584.742 169.464 584.718 170.008ZM591.094 168.916V173.5H590.194V167.5H590.77L590.914 168.208C591.298 167.904 591.618 167.692 591.874 167.572C592.13 167.444 592.422 167.38 592.75 167.38C592.91 167.38 593.03 167.388 593.11 167.404L593.278 167.452L593.134 168.28C592.99 168.232 592.794 168.208 592.546 168.208C592.066 168.208 591.582 168.444 591.094 168.916ZM594.479 173.5V167.5H595.379V173.5H594.479ZM595.379 165.1V166.168H594.479V165.1H595.379ZM598.277 168.736V173.5H597.377V167.5H597.953L598.097 168.088C598.281 167.944 598.429 167.832 598.541 167.752C598.661 167.672 598.849 167.592 599.105 167.512C599.361 167.424 599.633 167.38 599.921 167.38C600.473 167.38 600.929 167.552 601.289 167.896C601.657 168.232 601.841 168.712 601.841 169.336V173.5H600.941V169.6C600.941 168.632 600.537 168.148 599.729 168.148C599.153 168.148 598.669 168.344 598.277 168.736ZM607.43 172.864C606.758 173.344 606.146 173.584 605.594 173.584C604.154 173.584 603.434 172.548 603.434 170.476C603.434 169.3 603.69 168.476 604.202 168.004C604.658 167.588 605.21 167.38 605.858 167.38C606.514 167.38 607.062 167.676 607.502 168.268L607.814 167.488H608.342V173.8C608.342 174.672 608.126 175.32 607.694 175.744C607.262 176.168 606.678 176.38 605.942 176.38C605.566 176.38 605.23 176.332 604.934 176.236C604.638 176.14 604.33 176.032 604.01 175.912L604.178 175.276C604.85 175.492 605.41 175.6 605.858 175.6C606.314 175.6 606.69 175.46 606.986 175.18C607.282 174.9 607.43 174.476 607.43 173.908V172.864ZM607.43 172V169.756C607.43 169.284 607.274 168.9 606.962 168.604C606.65 168.308 606.33 168.16 606.002 168.16C605.378 168.16 604.942 168.344 604.694 168.712C604.446 169.072 604.322 169.652 604.322 170.452C604.322 172.02 604.762 172.804 605.642 172.804C606.218 172.804 606.814 172.536 607.43 172Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="Arrow right_2">
                  <g id="SchemaArrow_6">
                    <rect
                      id="Line_6"
                      x="617.5"
                      y="169"
                      width="26.5"
                      height="1"
                      fill="#94A3B8"
                    />
                  </g>
                </g>
              </g>
            </g>
            <g id="Col5">
              <g id="SchemaGrouper_2">
                <g id="Borders_2">
                  <mask id="path-47-inside-4_190_9936" fill="white">
                    <path d="M660 237.5H644V65.5H660V237.5Z" />
                  </mask>
                  <path
                    d="M644 237.5H643V238.5H644V237.5ZM644 65.5V64.5H643V65.5H644ZM660 236.5H644V238.5H660V236.5ZM645 237.5V65.5H643V237.5H645ZM644 66.5H660V64.5H644V66.5Z"
                    fill="#94A3B8"
                    mask="url(#path-47-inside-4_190_9936)"
                  />
                </g>
              </g>
              <g id="Cards_2">
                <g id="SchemaTitle_2">
                  <path
                    id="Title_2"
                    d="M741.152 77.572C739.928 77.572 738.988 77.188 738.332 76.42C737.684 75.644 737.36 74.596 737.36 73.276C737.36 71.956 737.704 70.912 738.392 70.144C739.088 69.376 740.052 68.992 741.284 68.992C741.956 68.992 742.624 69.108 743.288 69.34L742.952 70.684C742.464 70.476 741.888 70.372 741.224 70.372C740.56 70.372 740.04 70.624 739.664 71.128C739.288 71.632 739.1 72.328 739.1 73.216C739.1 74.104 739.276 74.824 739.628 75.376C739.98 75.92 740.476 76.192 741.116 76.192C741.596 76.192 742.28 76.036 743.168 75.724L743.528 76.948C742.8 77.364 742.008 77.572 741.152 77.572ZM747.884 77.56C746.708 77.56 745.82 77.156 745.22 76.348C744.62 75.532 744.32 74.496 744.32 73.24C744.32 71.984 744.62 70.96 745.22 70.168C745.828 69.376 746.716 68.98 747.884 68.98C749.06 68.98 749.952 69.376 750.56 70.168C751.168 70.96 751.472 71.984 751.472 73.24C751.472 74.96 750.948 76.2 749.9 76.96C749.348 77.36 748.676 77.56 747.884 77.56ZM747.908 70.36C747.484 70.36 747.128 70.508 746.84 70.804C746.328 71.316 746.072 72.128 746.072 73.24C746.072 74.08 746.228 74.78 746.54 75.34C746.852 75.892 747.308 76.168 747.908 76.168C748.516 76.168 748.972 75.888 749.276 75.328C749.58 74.76 749.732 74.072 749.732 73.264C749.732 72.448 749.568 71.76 749.24 71.2C748.92 70.64 748.476 70.36 747.908 70.36ZM759.085 77.512H757.261L754.417 72.34V77.5H752.641V69.1H754.417L757.345 74.524V69.1H759.085V77.512ZM765.49 69.4L765.202 70.804L764.458 70.6C763.93 70.48 763.47 70.42 763.078 70.42C762.534 70.42 762.262 70.68 762.262 71.2C762.262 71.4 762.354 71.584 762.538 71.752C762.73 71.912 762.97 72.048 763.258 72.16C763.546 72.264 763.854 72.396 764.182 72.556C764.51 72.716 764.818 72.888 765.106 73.072C765.394 73.256 765.63 73.508 765.814 73.828C766.006 74.148 766.102 74.516 766.102 74.932C766.102 75.756 765.834 76.404 765.298 76.876C764.77 77.34 764.022 77.572 763.054 77.572C762.558 77.572 762.062 77.508 761.566 77.38C761.078 77.244 760.674 77.088 760.354 76.912L760.87 75.628C761.606 75.964 762.334 76.132 763.054 76.132C763.462 76.132 763.782 76.04 764.014 75.856C764.246 75.664 764.362 75.42 764.362 75.124C764.362 74.828 764.23 74.584 763.966 74.392C763.702 74.192 763.382 74.016 763.006 73.864C762.63 73.704 762.254 73.528 761.878 73.336C761.502 73.136 761.182 72.86 760.918 72.508C760.654 72.148 760.522 71.724 760.522 71.236C760.522 70.508 760.75 69.952 761.206 69.568C761.662 69.176 762.274 68.98 763.042 68.98C763.818 68.98 764.634 69.12 765.49 69.4ZM772.855 76.78C772.319 77.308 771.543 77.572 770.527 77.572C769.511 77.572 768.735 77.308 768.199 76.78C767.663 76.244 767.395 75.452 767.395 74.404V69.1H769.147V74.548C769.147 75.076 769.263 75.484 769.495 75.772C769.735 76.052 770.075 76.192 770.515 76.192C770.955 76.192 771.295 76.052 771.535 75.772C771.783 75.484 771.907 75.076 771.907 74.548V69.1H773.659V74.404C773.659 75.452 773.391 76.244 772.855 76.78ZM782.924 77.5H781.184V72.292L779.684 75.532H778.172L776.672 72.304V77.5H774.944V69.1H776.792L778.94 73.6L781.184 69.1H782.924V77.5ZM789.215 77.5H784.211V69.1H789.215V70.48H785.951V72.244H788.915V73.648H785.951V76.12H789.215V77.5ZM792.599 73.852H792.455V77.488H790.715V69.088H793.379C794.283 69.088 794.959 69.288 795.407 69.688C795.855 70.08 796.079 70.644 796.079 71.38C796.079 71.828 795.923 72.24 795.611 72.616C795.299 72.984 794.919 73.196 794.471 73.252C794.791 73.34 795.039 73.488 795.215 73.696C795.391 73.896 795.575 74.224 795.767 74.68L796.955 77.488H795.167L794.003 74.8C793.835 74.416 793.655 74.164 793.463 74.044C793.279 73.916 792.991 73.852 792.599 73.852ZM793.331 70.456H792.455V72.484H793.211C793.531 72.484 793.779 72.38 793.955 72.172C794.139 71.964 794.231 71.708 794.231 71.404C794.231 70.772 793.931 70.456 793.331 70.456ZM802.65 69.4L802.362 70.804L801.618 70.6C801.09 70.48 800.63 70.42 800.238 70.42C799.694 70.42 799.422 70.68 799.422 71.2C799.422 71.4 799.514 71.584 799.698 71.752C799.89 71.912 800.13 72.048 800.418 72.16C800.706 72.264 801.014 72.396 801.342 72.556C801.67 72.716 801.978 72.888 802.266 73.072C802.554 73.256 802.79 73.508 802.974 73.828C803.166 74.148 803.262 74.516 803.262 74.932C803.262 75.756 802.994 76.404 802.458 76.876C801.93 77.34 801.182 77.572 800.214 77.572C799.718 77.572 799.222 77.508 798.726 77.38C798.238 77.244 797.834 77.088 797.514 76.912L798.03 75.628C798.766 75.964 799.494 76.132 800.214 76.132C800.622 76.132 800.942 76.04 801.174 75.856C801.406 75.664 801.522 75.42 801.522 75.124C801.522 74.828 801.39 74.584 801.126 74.392C800.862 74.192 800.542 74.016 800.166 73.864C799.79 73.704 799.414 73.528 799.038 73.336C798.662 73.136 798.342 72.86 798.078 72.508C797.814 72.148 797.682 71.724 797.682 71.236C797.682 70.508 797.91 69.952 798.366 69.568C798.822 69.176 799.434 68.98 800.202 68.98C800.978 68.98 801.794 69.12 802.65 69.4Z"
                    fill="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_6">
                  <g id="Container_6">
                    <g id="Icon_12">
                      <path
                        id="Vector_16"
                        d="M693.625 105.5H688.375C687.754 105.5 687.25 106.004 687.25 106.625V116.375C687.25 116.996 687.754 117.5 688.375 117.5H693.625C694.246 117.5 694.75 116.996 694.75 116.375V106.625C694.75 106.004 694.246 105.5 693.625 105.5ZM691 116.75C690.585 116.75 690.25 116.415 690.25 116C690.25 115.585 690.585 115.25 691 115.25C691.415 115.25 691.75 115.585 691.75 116C691.75 116.415 691.415 116.75 691 116.75ZM693.625 114.219C693.625 114.373 693.498 114.5 693.344 114.5H688.656C688.502 114.5 688.375 114.373 688.375 114.219V106.906C688.375 106.752 688.502 106.625 688.656 106.625H693.344C693.498 106.625 693.625 106.752 693.625 106.906V114.219Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_9"
                      d="M709.924 116.5H708.748L707.768 113.406H704.254L703.288 116.5H702.182L705.402 106.7H706.676L709.924 116.5ZM707.53 112.496L706.032 107.764L704.52 112.496H707.53ZM712.431 119.832H711.381V109.514H711.997L712.361 110.298C712.753 109.999 713.117 109.771 713.453 109.612C713.799 109.444 714.177 109.36 714.587 109.36C716.267 109.36 717.107 110.569 717.107 112.986C717.107 114.358 716.809 115.315 716.211 115.856C715.679 116.351 715.073 116.598 714.391 116.598C713.719 116.598 713.066 116.374 712.431 115.926V119.832ZM712.431 111.236V114.974C712.618 115.198 712.87 115.375 713.187 115.506C713.505 115.637 713.808 115.702 714.097 115.702C714.825 115.702 715.334 115.487 715.623 115.058C715.913 114.629 716.057 113.957 716.057 113.042C716.057 112.127 715.913 111.437 715.623 110.97C715.334 110.503 714.965 110.27 714.517 110.27C714.219 110.27 713.92 110.331 713.621 110.452C713.332 110.573 713.113 110.69 712.963 110.802C712.823 110.905 712.646 111.049 712.431 111.236ZM720.074 119.832H719.024V109.514H719.64L720.004 110.298C720.396 109.999 720.76 109.771 721.096 109.612C721.441 109.444 721.819 109.36 722.23 109.36C723.91 109.36 724.75 110.569 724.75 112.986C724.75 114.358 724.451 115.315 723.854 115.856C723.322 116.351 722.715 116.598 722.034 116.598C721.362 116.598 720.709 116.374 720.074 115.926V119.832ZM720.074 111.236V114.974C720.261 115.198 720.513 115.375 720.83 115.506C721.147 115.637 721.451 115.702 721.74 115.702C722.468 115.702 722.977 115.487 723.266 115.058C723.555 114.629 723.7 113.957 723.7 113.042C723.7 112.127 723.555 111.437 723.266 110.97C722.977 110.503 722.608 110.27 722.16 110.27C721.861 110.27 721.563 110.331 721.264 110.452C720.975 110.573 720.755 110.69 720.606 110.802C720.466 110.905 720.289 111.049 720.074 111.236ZM726.401 115.254C727.007 115.534 727.586 115.674 728.137 115.674C728.687 115.674 729.103 115.567 729.383 115.352C729.672 115.128 729.817 114.834 729.817 114.47C729.817 114.106 729.695 113.826 729.453 113.63C729.21 113.425 728.911 113.266 728.557 113.154C728.211 113.042 727.861 112.921 727.507 112.79C727.161 112.659 726.867 112.463 726.625 112.202C726.382 111.941 726.261 111.609 726.261 111.208C726.261 110.62 726.452 110.167 726.835 109.85C727.217 109.523 727.735 109.36 728.389 109.36C729.042 109.36 729.649 109.458 730.209 109.654L730.307 109.696L730.125 110.592C729.565 110.377 729.042 110.27 728.557 110.27C728.081 110.27 727.754 110.345 727.577 110.494C727.399 110.643 727.311 110.895 727.311 111.25C727.311 111.474 727.432 111.665 727.675 111.824C727.917 111.983 728.211 112.123 728.557 112.244C728.911 112.356 729.261 112.491 729.607 112.65C729.961 112.799 730.26 113.028 730.503 113.336C730.745 113.644 730.867 114.022 730.867 114.47C730.867 115.123 730.638 115.641 730.181 116.024C729.723 116.397 729.093 116.584 728.291 116.584C727.488 116.584 726.774 116.402 726.149 116.038L726.401 115.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="672.5"
                    y="90"
                    width="131"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_7">
                  <g id="Container_7">
                    <g id="Icon_13">
                      <path
                        id="Vector_17"
                        d="M696.25 161.25H685.75C685.336 161.25 685 160.914 685 160.5V159C685 158.586 685.336 158.25 685.75 158.25H696.25C696.664 158.25 697 158.586 697 159V160.5C697 160.914 696.664 161.25 696.25 161.25ZM695.125 159.188C694.814 159.188 694.562 159.439 694.562 159.75C694.562 160.061 694.814 160.312 695.125 160.312C695.436 160.312 695.688 160.061 695.688 159.75C695.688 159.439 695.436 159.188 695.125 159.188ZM693.625 159.188C693.314 159.188 693.062 159.439 693.062 159.75C693.062 160.061 693.314 160.312 693.625 160.312C693.936 160.312 694.188 160.061 694.188 159.75C694.188 159.439 693.936 159.188 693.625 159.188ZM696.25 165H685.75C685.336 165 685 164.664 685 164.25V162.75C685 162.336 685.336 162 685.75 162H696.25C696.664 162 697 162.336 697 162.75V164.25C697 164.664 696.664 165 696.25 165ZM695.125 162.938C694.814 162.938 694.562 163.189 694.562 163.5C694.562 163.811 694.814 164.062 695.125 164.062C695.436 164.062 695.688 163.811 695.688 163.5C695.688 163.189 695.436 162.938 695.125 162.938ZM693.625 162.938C693.314 162.938 693.062 163.189 693.062 163.5C693.062 163.811 693.314 164.062 693.625 164.062C693.936 164.062 694.188 163.811 694.188 163.5C694.188 163.189 693.936 162.938 693.625 162.938ZM696.25 168.75H685.75C685.336 168.75 685 168.414 685 168V166.5C685 166.086 685.336 165.75 685.75 165.75H696.25C696.664 165.75 697 166.086 697 166.5V168C697 168.414 696.664 168.75 696.25 168.75ZM695.125 166.688C694.814 166.688 694.562 166.939 694.562 167.25C694.562 167.561 694.814 167.812 695.125 167.812C695.436 167.812 695.688 167.561 695.688 167.25C695.688 166.939 695.436 166.688 695.125 166.688ZM693.625 166.688C693.314 166.688 693.062 166.939 693.062 167.25C693.062 167.561 693.314 167.812 693.625 167.812C693.936 167.812 694.188 167.561 694.188 167.25C694.188 166.939 693.936 166.688 693.625 166.688Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_10"
                      d="M710.358 163.25C710.358 164.827 709.901 166.097 708.986 167.058C708.071 168.019 706.849 168.5 705.318 168.5H703.274V158.7H705.752C707.143 158.7 708.258 159.125 709.098 159.974C709.938 160.823 710.358 161.915 710.358 163.25ZM709.224 163.138C709.224 162.037 708.888 161.173 708.216 160.548C707.544 159.923 706.741 159.61 705.808 159.61H704.408V167.59H705.444C706.499 167.59 707.39 167.193 708.118 166.4C708.855 165.607 709.224 164.519 709.224 163.138ZM715.362 164.314H715.936C715.936 163.465 715.829 162.914 715.614 162.662C715.4 162.401 714.924 162.27 714.186 162.27C713.449 162.27 712.824 162.368 712.31 162.564L712.114 161.752C712.898 161.491 713.71 161.36 714.55 161.36C716.193 161.36 717.014 162.181 717.014 163.824V168.5H716.398L716.034 167.674C715.605 168.029 715.232 168.271 714.914 168.402C714.606 168.523 714.247 168.584 713.836 168.584C713.183 168.584 712.674 168.393 712.31 168.01C711.946 167.618 711.764 167.105 711.764 166.47C711.764 165.033 712.964 164.314 715.362 164.314ZM715.95 165.196H715.32C714.368 165.196 713.71 165.289 713.346 165.476C712.992 165.663 712.814 165.957 712.814 166.358C712.814 166.75 712.917 167.072 713.122 167.324C713.328 167.576 713.594 167.702 713.92 167.702C714.256 167.702 714.574 167.627 714.872 167.478C715.18 167.319 715.54 167.049 715.95 166.666V165.196ZM719.725 166.988V162.34H718.773V161.5H719.739V159.498H720.789V161.5H722.497V162.34H720.775V166.792C720.775 167.417 721.093 167.73 721.727 167.73C721.877 167.73 722.105 167.702 722.413 167.646L722.567 168.402C722.185 168.523 721.788 168.584 721.377 168.584C720.976 168.584 720.598 168.463 720.243 168.22C719.898 167.968 719.725 167.557 719.725 166.988ZM727.421 164.314H727.995C727.995 163.465 727.888 162.914 727.673 162.662C727.458 162.401 726.982 162.27 726.245 162.27C725.508 162.27 724.882 162.368 724.369 162.564L724.173 161.752C724.957 161.491 725.769 161.36 726.609 161.36C728.252 161.36 729.073 162.181 729.073 163.824V168.5H728.457L728.093 167.674C727.664 168.029 727.29 168.271 726.973 168.402C726.665 168.523 726.306 168.584 725.895 168.584C725.242 168.584 724.733 168.393 724.369 168.01C724.005 167.618 723.823 167.105 723.823 166.47C723.823 165.033 725.022 164.314 727.421 164.314ZM728.009 165.196H727.379C726.427 165.196 725.769 165.289 725.405 165.476C725.05 165.663 724.873 165.957 724.873 166.358C724.873 166.75 724.976 167.072 725.181 167.324C725.386 167.576 725.652 167.702 725.979 167.702C726.315 167.702 726.632 167.627 726.931 167.478C727.239 167.319 727.598 167.049 728.009 166.666V165.196ZM737.594 164.384H736.166V168.5H735.116V158.7H737.916C738.961 158.7 739.717 158.929 740.184 159.386C740.66 159.843 740.898 160.557 740.898 161.528C740.898 162.489 740.608 163.208 740.03 163.684C739.451 164.151 738.639 164.384 737.594 164.384ZM737.44 159.596H736.166V163.488H737.09C738.051 163.488 738.751 163.343 739.19 163.054C739.628 162.765 739.848 162.27 739.848 161.57C739.848 160.861 739.656 160.357 739.274 160.058C738.891 159.75 738.28 159.596 737.44 159.596ZM742.69 168.5V158.7H743.74V168.5H742.69ZM749.31 164.314H749.884C749.884 163.465 749.776 162.914 749.562 162.662C749.347 162.401 748.871 162.27 748.134 162.27C747.396 162.27 746.771 162.368 746.258 162.564L746.062 161.752C746.846 161.491 747.658 161.36 748.498 161.36C750.14 161.36 750.962 162.181 750.962 163.824V168.5H750.346L749.982 167.674C749.552 168.029 749.179 168.271 748.862 168.402C748.554 168.523 748.194 168.584 747.784 168.584C747.13 168.584 746.622 168.393 746.258 168.01C745.894 167.618 745.712 167.105 745.712 166.47C745.712 165.033 746.911 164.314 749.31 164.314ZM749.898 165.196H749.268C748.316 165.196 747.658 165.289 747.294 165.476C746.939 165.663 746.762 165.957 746.762 166.358C746.762 166.75 746.864 167.072 747.07 167.324C747.275 167.576 747.541 167.702 747.868 167.702C748.204 167.702 748.521 167.627 748.82 167.478C749.128 167.319 749.487 167.049 749.898 166.666V165.196ZM753.672 166.988V162.34H752.72V161.5H753.686V159.498H754.736V161.5H756.444V162.34H754.722V166.792C754.722 167.417 755.04 167.73 755.674 167.73C755.824 167.73 756.052 167.702 756.36 167.646L756.514 168.402C756.132 168.523 755.735 168.584 755.324 168.584C754.923 168.584 754.545 168.463 754.19 168.22C753.845 167.968 753.672 167.557 753.672 166.988ZM758.652 161.5V160.156C758.652 159.587 758.825 159.181 759.17 158.938C759.525 158.686 759.903 158.56 760.304 158.56C760.715 158.56 761.112 158.621 761.494 158.742L761.34 159.498C761.032 159.442 760.804 159.414 760.654 159.414C760.01 159.414 759.688 159.727 759.688 160.352V161.5H761.116V162.34H759.688V168.5H758.638V162.34H757.56V161.5H758.652ZM766.745 165.056C766.745 164.151 766.567 163.46 766.213 162.984C765.858 162.508 765.34 162.27 764.659 162.27C763.977 162.27 763.492 162.499 763.203 162.956C762.923 163.404 762.783 164.095 762.783 165.028C762.783 166.792 763.431 167.674 764.729 167.674C765.41 167.674 765.914 167.464 766.241 167.044C766.577 166.615 766.745 165.952 766.745 165.056ZM766.997 167.632C766.465 168.267 765.713 168.584 764.743 168.584C763.772 168.584 763.025 168.271 762.503 167.646C761.989 167.011 761.733 166.129 761.733 165C761.733 163.861 761.98 162.97 762.475 162.326C762.979 161.682 763.711 161.36 764.673 161.36C765.643 161.36 766.404 161.687 766.955 162.34C767.515 162.993 767.795 163.88 767.795 165C767.795 166.12 767.529 166.997 766.997 167.632ZM770.715 163.152V168.5H769.665V161.5H770.337L770.505 162.326C770.953 161.971 771.326 161.724 771.625 161.584C771.923 161.435 772.264 161.36 772.647 161.36C772.833 161.36 772.973 161.369 773.067 161.388L773.263 161.444L773.095 162.41C772.927 162.354 772.698 162.326 772.409 162.326C771.849 162.326 771.284 162.601 770.715 163.152ZM777.814 161.346C778.71 161.346 779.349 161.663 779.732 162.298C780.525 161.663 781.258 161.346 781.93 161.346C782.602 161.346 783.148 161.537 783.568 161.92C783.997 162.293 784.212 162.839 784.212 163.558V168.5H783.19V163.992C783.19 163.423 783.059 162.993 782.798 162.704C782.546 162.405 782.205 162.256 781.776 162.256C781.188 162.256 780.595 162.489 779.998 162.956C780.045 163.161 780.068 163.362 780.068 163.558V168.5H779.046V163.992C779.046 163.423 778.915 162.993 778.654 162.704C778.402 162.405 778.061 162.256 777.632 162.256C777.352 162.256 777.095 162.293 776.862 162.368C776.629 162.443 776.456 162.517 776.344 162.592C776.232 162.667 776.087 162.779 775.91 162.928V168.5H774.86V161.5H775.532L775.714 162.214C775.947 162.018 776.125 161.878 776.246 161.794C776.377 161.701 776.587 161.603 776.876 161.5C777.165 161.397 777.478 161.346 777.814 161.346ZM786.488 167.254C787.095 167.534 787.674 167.674 788.224 167.674C788.775 167.674 789.19 167.567 789.47 167.352C789.76 167.128 789.904 166.834 789.904 166.47C789.904 166.106 789.783 165.826 789.54 165.63C789.298 165.425 788.999 165.266 788.644 165.154C788.299 165.042 787.949 164.921 787.594 164.79C787.249 164.659 786.955 164.463 786.712 164.202C786.47 163.941 786.348 163.609 786.348 163.208C786.348 162.62 786.54 162.167 786.922 161.85C787.305 161.523 787.823 161.36 788.476 161.36C789.13 161.36 789.736 161.458 790.296 161.654L790.394 161.696L790.212 162.592C789.652 162.377 789.13 162.27 788.644 162.27C788.168 162.27 787.842 162.345 787.664 162.494C787.487 162.643 787.398 162.895 787.398 163.25C787.398 163.474 787.52 163.665 787.762 163.824C788.005 163.983 788.299 164.123 788.644 164.244C788.999 164.356 789.349 164.491 789.694 164.65C790.049 164.799 790.348 165.028 790.59 165.336C790.833 165.644 790.954 166.022 790.954 166.47C790.954 167.123 790.726 167.641 790.268 168.024C789.811 168.397 789.181 168.584 788.378 168.584C787.576 168.584 786.862 168.402 786.236 168.038L786.488 167.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="672.5"
                    y="142"
                    width="131"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
                <g id="SchemaCard_8">
                  <g id="Container_8">
                    <g id="Icon_14">
                      <path
                        id="Vector_18"
                        d="M692.2 216.7H689.8C689.469 216.7 689.2 216.969 689.2 217.3V219.7C689.2 220.031 689.469 220.3 689.8 220.3H692.2C692.531 220.3 692.8 220.031 692.8 219.7V217.3C692.8 216.969 692.531 216.7 692.2 216.7ZM688.6 211.3C688.6 210.969 688.331 210.7 688 210.7H685.6C685.269 210.7 685 210.969 685 211.3V213.7C685 214.031 685.269 214.3 685.6 214.3H687.395L688.767 216.701C688.975 216.343 689.358 216.1 689.8 216.1H689.805L688.6 213.991V213.1H692.8V211.9H688.6V211.3ZM696.4 210.7H694C693.669 210.7 693.4 210.969 693.4 211.3V213.7C693.4 214.031 693.669 214.3 694 214.3H696.4C696.731 214.3 697 214.031 697 213.7V211.3C697 210.969 696.731 210.7 696.4 210.7Z"
                        fill="#94A3B8"
                      />
                    </g>
                    <path
                      id="Card label_11"
                      d="M706.522 220.57C705.243 220.57 704.277 220.099 703.624 219.156C702.971 218.204 702.644 216.995 702.644 215.53C702.644 214.065 702.971 212.87 703.624 211.946C704.287 211.022 705.253 210.56 706.522 210.56C707.801 210.56 708.771 211.022 709.434 211.946C710.097 212.87 710.428 214.065 710.428 215.53C710.428 217.537 709.859 218.983 708.72 219.87C708.113 220.337 707.381 220.57 706.522 220.57ZM706.55 211.47C705.598 211.47 704.884 211.867 704.408 212.66C703.941 213.453 703.708 214.424 703.708 215.572C703.708 216.72 703.946 217.686 704.422 218.47C704.907 219.254 705.617 219.646 706.55 219.646C707.483 219.646 708.188 219.249 708.664 218.456C709.14 217.663 709.378 216.664 709.378 215.46C709.378 213.948 708.953 212.819 708.104 212.072C707.665 211.671 707.147 211.47 706.55 211.47ZM712.52 218.988V214.34H711.568V213.5H712.534V211.498H713.584V213.5H715.292V214.34H713.57V218.792C713.57 219.417 713.887 219.73 714.522 219.73C714.671 219.73 714.9 219.702 715.208 219.646L715.362 220.402C714.979 220.523 714.583 220.584 714.172 220.584C713.771 220.584 713.393 220.463 713.038 220.22C712.693 219.968 712.52 219.557 712.52 218.988ZM722.428 220.5H721.378V215.894C721.378 214.765 720.907 214.2 719.964 214.2C719.264 214.2 718.69 214.424 718.242 214.872V220.5H717.192V210.7H718.228V214.018C718.433 213.85 718.592 213.729 718.704 213.654C718.825 213.579 719.017 213.505 719.278 213.43C719.549 213.355 719.852 213.318 720.188 213.318C720.832 213.318 721.364 213.514 721.784 213.906C722.213 214.298 722.428 214.858 722.428 215.586V220.5ZM729.829 217.224H725.363C725.363 218.12 725.573 218.755 725.993 219.128C726.423 219.501 726.959 219.688 727.603 219.688C727.93 219.688 728.159 219.674 728.289 219.646C728.42 219.609 728.541 219.576 728.653 219.548C728.775 219.511 728.859 219.483 728.905 219.464C729.139 219.399 729.339 219.338 729.507 219.282L729.675 220.094C728.742 220.421 728.014 220.584 727.491 220.584C726.53 220.584 725.76 220.295 725.181 219.716C724.603 219.128 724.313 218.251 724.313 217.084C724.313 215.908 724.584 214.993 725.125 214.34C725.676 213.687 726.367 213.36 727.197 213.36C728.037 213.36 728.691 213.631 729.157 214.172C729.624 214.713 729.857 215.446 729.857 216.37C729.857 216.622 729.848 216.907 729.829 217.224ZM725.433 216.426H728.849C728.849 215.735 728.728 215.203 728.485 214.83C728.243 214.457 727.818 214.27 727.211 214.27C726.614 214.27 726.175 214.471 725.895 214.872C725.615 215.273 725.461 215.791 725.433 216.426ZM732.871 215.152V220.5H731.821V213.5H732.493L732.661 214.326C733.109 213.971 733.482 213.724 733.781 213.584C734.08 213.435 734.42 213.36 734.803 213.36C734.99 213.36 735.13 213.369 735.223 213.388L735.419 213.444L735.251 214.41C735.083 214.354 734.854 214.326 734.565 214.326C734.005 214.326 733.44 214.601 732.871 215.152ZM745.444 211.05L745.22 211.988L744.408 211.75C743.83 211.61 743.33 211.54 742.91 211.54C741.809 211.54 741.258 212.03 741.258 213.01C741.258 213.439 741.426 213.794 741.762 214.074C742.098 214.345 742.504 214.564 742.98 214.732C743.466 214.891 743.946 215.068 744.422 215.264C744.908 215.451 745.318 215.745 745.654 216.146C745.99 216.538 746.158 217.037 746.158 217.644C746.158 218.568 745.874 219.291 745.304 219.814C744.735 220.327 743.928 220.584 742.882 220.584C742.36 220.584 741.832 220.509 741.3 220.36C740.778 220.201 740.348 220.019 740.012 219.814L740.362 219.016C741.212 219.408 742.014 219.604 742.77 219.604C743.536 219.604 744.114 219.45 744.506 219.142C744.908 218.834 745.108 218.386 745.108 217.798C745.108 217.201 744.786 216.734 744.142 216.398C743.853 216.249 743.531 216.109 743.176 215.978C742.831 215.847 742.481 215.707 742.126 215.558C741.781 215.399 741.464 215.222 741.174 215.026C740.894 214.83 740.661 214.564 740.474 214.228C740.297 213.892 740.208 213.5 740.208 213.052C740.208 212.249 740.446 211.633 740.922 211.204C741.408 210.775 742.056 210.56 742.868 210.56C743.68 210.56 744.539 210.723 745.444 211.05ZM753.085 217.224H748.619C748.619 218.12 748.829 218.755 749.249 219.128C749.678 219.501 750.215 219.688 750.859 219.688C751.186 219.688 751.414 219.674 751.545 219.646C751.676 219.609 751.797 219.576 751.909 219.548C752.03 219.511 752.114 219.483 752.161 219.464C752.394 219.399 752.595 219.338 752.763 219.282L752.931 220.094C751.998 220.421 751.27 220.584 750.747 220.584C749.786 220.584 749.016 220.295 748.437 219.716C747.858 219.128 747.569 218.251 747.569 217.084C747.569 215.908 747.84 214.993 748.381 214.34C748.932 213.687 749.622 213.36 750.453 213.36C751.293 213.36 751.946 213.631 752.413 214.172C752.88 214.713 753.113 215.446 753.113 216.37C753.113 216.622 753.104 216.907 753.085 217.224ZM748.689 216.426H752.105C752.105 215.735 751.984 215.203 751.741 214.83C751.498 214.457 751.074 214.27 750.467 214.27C749.87 214.27 749.431 214.471 749.151 214.872C748.871 215.273 748.717 215.791 748.689 216.426ZM756.127 215.152V220.5H755.077V213.5H755.749L755.917 214.326C756.365 213.971 756.738 213.724 757.037 213.584C757.335 213.435 757.676 213.36 758.059 213.36C758.245 213.36 758.385 213.369 758.479 213.388L758.675 213.444L758.507 214.41C758.339 214.354 758.11 214.326 757.821 214.326C757.261 214.326 756.696 214.601 756.127 215.152ZM765.074 213.486L762.708 220.5H761.504L759.152 213.486H760.342L762.12 219.38L763.912 213.486H765.074ZM766.31 220.5V213.5H767.36V220.5H766.31ZM767.36 210.7V211.946H766.31V210.7H767.36ZM773.808 219.408L774.018 220.234C773.271 220.458 772.613 220.57 772.044 220.57C771.045 220.57 770.294 220.243 769.79 219.59C769.286 218.937 769.034 218.036 769.034 216.888C769.034 215.74 769.295 214.867 769.818 214.27C770.341 213.663 771.111 213.36 772.128 213.36C772.567 213.36 773.183 213.472 773.976 213.696L773.556 214.508C773.043 214.359 772.581 214.284 772.17 214.284C771.461 214.284 770.947 214.494 770.63 214.914C770.322 215.334 770.168 215.997 770.168 216.902C770.168 218.741 770.826 219.66 772.142 219.66C772.665 219.66 773.22 219.576 773.808 219.408ZM780.607 217.224H776.141C776.141 218.12 776.351 218.755 776.771 219.128C777.2 219.501 777.737 219.688 778.381 219.688C778.707 219.688 778.936 219.674 779.067 219.646C779.197 219.609 779.319 219.576 779.431 219.548C779.552 219.511 779.636 219.483 779.683 219.464C779.916 219.399 780.117 219.338 780.285 219.282L780.453 220.094C779.519 220.421 778.791 220.584 778.269 220.584C777.307 220.584 776.537 220.295 775.959 219.716C775.38 219.128 775.091 218.251 775.091 217.084C775.091 215.908 775.361 214.993 775.903 214.34C776.453 213.687 777.144 213.36 777.975 213.36C778.815 213.36 779.468 213.631 779.935 214.172C780.401 214.713 780.635 215.446 780.635 216.37C780.635 216.622 780.625 216.907 780.607 217.224ZM776.211 216.426H779.627C779.627 215.735 779.505 215.203 779.263 214.83C779.02 214.457 778.595 214.27 777.989 214.27C777.391 214.27 776.953 214.471 776.673 214.872C776.393 215.273 776.239 215.791 776.211 216.426ZM782.332 219.254C782.939 219.534 783.518 219.674 784.068 219.674C784.619 219.674 785.034 219.567 785.314 219.352C785.604 219.128 785.748 218.834 785.748 218.47C785.748 218.106 785.627 217.826 785.384 217.63C785.142 217.425 784.843 217.266 784.488 217.154C784.143 217.042 783.793 216.921 783.438 216.79C783.093 216.659 782.799 216.463 782.556 216.202C782.314 215.941 782.192 215.609 782.192 215.208C782.192 214.62 782.384 214.167 782.766 213.85C783.149 213.523 783.667 213.36 784.32 213.36C784.974 213.36 785.58 213.458 786.14 213.654L786.238 213.696L786.056 214.592C785.496 214.377 784.974 214.27 784.488 214.27C784.012 214.27 783.686 214.345 783.508 214.494C783.331 214.643 783.242 214.895 783.242 215.25C783.242 215.474 783.364 215.665 783.606 215.824C783.849 215.983 784.143 216.123 784.488 216.244C784.843 216.356 785.193 216.491 785.538 216.65C785.893 216.799 786.192 217.028 786.434 217.336C786.677 217.644 786.798 218.022 786.798 218.47C786.798 219.123 786.57 219.641 786.112 220.024C785.655 220.397 785.025 220.584 784.222 220.584C783.42 220.584 782.706 220.402 782.08 220.038L782.332 219.254Z"
                      fill="#94A3B8"
                    />
                  </g>
                  <rect
                    x="672.5"
                    y="194"
                    width="131"
                    height="43"
                    rx="3.5"
                    stroke="#94A3B8"
                  />
                </g>
              </g>
            </g>
          </g>
          <rect
            x="0.5"
            y="1"
            width="823"
            height="256"
            rx="3.5"
            stroke="#CBD5E1"
          />
        </g>
        <defs>
          <filter
            id="filter0_d_190_9936"
            x="310"
            y="19.5"
            width="204"
            height="48"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feMorphology
              radius="2"
              operator="dilate"
              in="SourceAlpha"
              result="effect1_dropShadow_190_9936"
            />
            <feOffset />
            <feComposite in2="hardAlpha" operator="out" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0.992157 0 0 0 0 0.901961 0 0 0 0 0.541176 0 0 0 1 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_190_9936"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_190_9936"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_190_9936"
            x="310"
            y="144.5"
            width="204"
            height="96"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_190_9936"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_190_9936"
              result="shape"
            />
          </filter>
          <clipPath id="clip0_190_9936">
            <rect
              x="312"
              y="21.5"
              width="200"
              height="44"
              rx="4"
              fill="white"
            />
          </clipPath>
        </defs>
      </svg>
    )}
  </>
);
