// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-nocheck
import {
  ArgType,
  PGFunction,
} from '../../../../dataSources/services/postgresql/types';
import { NormalizedTable } from '../../../../dataSources/types';

export const allSchemas: NormalizedTable[] = [
  {
    table_schema: 'public',
    table_name: 'users',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'users',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'int4',
        ordinal_position: 1,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'users',
        column_name: 'name',
        is_nullable: 'YES',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'users',
        column_name: 'location',
        is_nullable: 'YES',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 3,
      },
    ],
    // comment: null,
    // triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'users',
      constraint_name: 'users_pkey',
      columns: ['id'],
    },
    relationships: [],
    permissions: [
      {
        role_name: 'one',
        permissions: {
          insert: { check: {}, columns: [], backend_only: false },
        },
        table_name: 'users',
        table_schema: 'public',
      },
      {
        role_name: 'two',
        permissions: {
          insert: {
            check: {},
            set: { name: 'moo' },
            columns: [],
            backend_only: false,
          },
          update: {
            columns: [],
            filter: { name: { _eq: 'snarl' } },
            check: null,
          },
          select: { columns: ['name'], filter: { name: { _eq: 'moo' } } },
        },
        table_name: 'users',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    // configuration: {},
    computed_fields: [],
  },
];

export const allFunctions: PGFunction[] = [
  {
    function_name: 'justme',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'STABLE',
    function_definition:
      'CREATE OR REPLACE FUNCTION public.justme()\n RETURNS users\n LANGUAGE sql\n STABLE\nAS $function$\nselect *\nfrom public.users\nwhere id = 1;\n$function$\n',
    return_type_schema: 'public',
    return_type_name: 'users',
    return_type_type: 'c',
    returns_set: false,
    input_arg_types: [],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16537,
  },
  {
    function_name: 'me',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'STABLE',
    function_definition:
      'CREATE OR REPLACE FUNCTION public.me()\n RETURNS users\n LANGUAGE sql\n STABLE\nAS $function$\nselect *\nfrom public.users\nwhere id = 1;\n$function$\n',
    return_type_schema: 'public',
    return_type_name: 'users',
    return_type_type: 'c',
    returns_set: false,
    input_arg_types: [],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16536,
  },
  {
    function_name: 'armor',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.armor(bytea, text[], text[])\n RETURNS text\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_armor$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: '_text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: '_text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16419,
  },
  {
    function_name: 'armor',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.armor(bytea)\n RETURNS text\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_armor$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16418,
  },
  {
    function_name: 'crypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.crypt(text, text)\n RETURNS text\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_crypt$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16390,
  },
  {
    function_name: 'dearmor',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.dearmor(text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_dearmor$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16420,
  },
  {
    function_name: 'decrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.decrypt(bytea, bytea, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_decrypt$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16394,
  },
  {
    function_name: 'decrypt_iv',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.decrypt_iv(bytea, bytea, bytea, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_decrypt_iv$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16396,
  },
  {
    function_name: 'digest',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.digest(bytea, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_digest$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16387,
  },
  {
    function_name: 'digest',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.digest(text, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_digest$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16386,
  },
  {
    function_name: 'encrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.encrypt(bytea, bytea, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_encrypt$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16393,
  },
  {
    function_name: 'encrypt_iv',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.encrypt_iv(bytea, bytea, bytea, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_encrypt_iv$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16395,
  },
  {
    function_name: 'gen_random_bytes',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.gen_random_bytes(integer)\n RETURNS bytea\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_random_bytes$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'int4',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16397,
  },
  {
    function_name: 'gen_random_uuid',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.gen_random_uuid()\n RETURNS uuid\n LANGUAGE c\n PARALLEL SAFE\nAS '$libdir/pgcrypto', $function$pg_random_uuid$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'uuid',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16398,
  },
  {
    function_name: 'gen_salt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.gen_salt(text, integer)\n RETURNS text\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_gen_salt_rounds$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'int4',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16392,
  },
  {
    function_name: 'gen_salt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.gen_salt(text)\n RETURNS text\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_gen_salt$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16391,
  },
  {
    function_name: 'hmac',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.hmac(text, text, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_hmac$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16388,
  },
  {
    function_name: 'hmac',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.hmac(bytea, bytea, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pg_hmac$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16389,
  },
  {
    function_name: 'pgp_armor_headers',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_armor_headers(text, OUT key text, OUT value text)\n RETURNS SETOF record\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_armor_headers$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'record',
    return_type_type: 'p',
    returns_set: true,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: ['', 'key', 'value'],
    default_args: 0,
    function_oid: 16421,
  },
  {
    function_name: 'pgp_key_id',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_key_id(bytea)\n RETURNS text\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_key_id_w$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16417,
  },
  {
    function_name: 'pgp_pub_decrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_decrypt(bytea, bytea, text)\n RETURNS text\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_decrypt_text$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16413,
  },
  {
    function_name: 'pgp_pub_decrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_decrypt(bytea, bytea)\n RETURNS text\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_decrypt_text$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16411,
  },
  {
    function_name: 'pgp_pub_decrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_decrypt(bytea, bytea, text, text)\n RETURNS text\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_decrypt_text$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16415,
  },
  {
    function_name: 'pgp_pub_decrypt_bytea',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_decrypt_bytea(bytea, bytea, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_decrypt_bytea$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16414,
  },
  {
    function_name: 'pgp_pub_decrypt_bytea',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_decrypt_bytea(bytea, bytea, text, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_decrypt_bytea$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16416,
  },
  {
    function_name: 'pgp_pub_decrypt_bytea',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_decrypt_bytea(bytea, bytea)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_decrypt_bytea$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16412,
  },
  {
    function_name: 'pgp_pub_encrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_encrypt(text, bytea)\n RETURNS bytea\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_encrypt_text$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16407,
  },
  {
    function_name: 'pgp_pub_encrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_encrypt(text, bytea, text)\n RETURNS bytea\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_encrypt_text$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16409,
  },
  {
    function_name: 'pgp_pub_encrypt_bytea',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_encrypt_bytea(bytea, bytea, text)\n RETURNS bytea\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_encrypt_bytea$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16410,
  },
  {
    function_name: 'pgp_pub_encrypt_bytea',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_pub_encrypt_bytea(bytea, bytea)\n RETURNS bytea\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_pub_encrypt_bytea$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16408,
  },
  {
    function_name: 'pgp_sym_decrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_sym_decrypt(bytea, text, text)\n RETURNS text\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_sym_decrypt_text$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16405,
  },
  {
    function_name: 'pgp_sym_decrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_sym_decrypt(bytea, text)\n RETURNS text\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_sym_decrypt_text$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'text',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16403,
  },
  {
    function_name: 'pgp_sym_decrypt_bytea',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_sym_decrypt_bytea(bytea, text, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_sym_decrypt_bytea$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16406,
  },
  {
    function_name: 'pgp_sym_decrypt_bytea',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'IMMUTABLE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_sym_decrypt_bytea(bytea, text)\n RETURNS bytea\n LANGUAGE c\n IMMUTABLE PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_sym_decrypt_bytea$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16404,
  },
  {
    function_name: 'pgp_sym_encrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_sym_encrypt(text, text, text)\n RETURNS bytea\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_sym_encrypt_text$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16401,
  },
  {
    function_name: 'pgp_sym_encrypt',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_sym_encrypt(text, text)\n RETURNS bytea\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_sym_encrypt_text$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16399,
  },
  {
    function_name: 'pgp_sym_encrypt_bytea',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_sym_encrypt_bytea(bytea, text)\n RETURNS bytea\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_sym_encrypt_bytea$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16400,
  },
  {
    function_name: 'pgp_sym_encrypt_bytea',
    function_schema: 'public',
    description: null,
    has_variadic: false,
    function_type: 'VOLATILE',
    function_definition:
      "CREATE OR REPLACE FUNCTION public.pgp_sym_encrypt_bytea(bytea, text, text)\n RETURNS bytea\n LANGUAGE c\n PARALLEL SAFE STRICT\nAS '$libdir/pgcrypto', $function$pgp_sym_encrypt_bytea$function$\n",
    return_type_schema: 'pg_catalog',
    return_type_name: 'bytea',
    return_type_type: 'b' as ArgType,
    returns_set: false,
    input_arg_types: [
      {
        schema: 'pg_catalog',
        name: 'bytea',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
      {
        schema: 'pg_catalog',
        name: 'text',
        type: 'b' as ArgType,
      },
    ],
    input_arg_names: [],
    default_args: 0,
    function_oid: 16402,
  },
];
