/* eslint react/no-unknown-property: 0 */
import React from 'react';

type Props = {
  className?: string;
};

export function HasuraOnboarding(props: Props) {
  const { className } = props;
  return (
    <svg
      className={className}
      width="724"
      height="215"
      viewBox="0 0 724 215"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect x="3.5" y="23.5" width="167" height="53" rx="3" stroke="#94A3B8" />
      <g filter="url(#filter0_dd_443_23382)">
        <rect x="3" y="90" width="168" height="54" rx="3.5" fill="white" />
        <rect
          x="3.5"
          y="90.5"
          width="167"
          height="53"
          rx="3"
          stroke="#CBD5E1"
        />
      </g>
      <rect x="3.5" y="157.5" width="167" height="53" rx="3" stroke="#94A3B8" />
      <g filter="url(#filter1_dd_443_23382)">
        <rect x="553" y="23" width="168" height="54" rx="3.5" fill="white" />
        <rect
          x="553.5"
          y="23.5"
          width="167"
          height="53"
          rx="3"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter2_dd_443_23382)">
        <rect x="553" y="90" width="168" height="54" rx="3.5" fill="white" />
        <rect
          x="553.5"
          y="90.5"
          width="167"
          height="53"
          rx="3"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter3_dd_443_23382)">
        <rect x="553" y="157" width="168" height="54" rx="3.5" fill="white" />
        <rect
          x="553.5"
          y="157.5"
          width="167"
          height="53"
          rx="3"
          stroke="#F59E0B"
        />
      </g>
      <path
        d="M8.8615 3.9125L8.6095 5.141L7.9585 4.9625C7.4965 4.8575 7.094 4.805 6.751 4.805C6.275 4.805 6.037 5.0325 6.037 5.4875C6.037 5.6625 6.1175 5.8235 6.2785 5.9705C6.4465 6.1105 6.6565 6.2295 6.9085 6.3275C7.1605 6.4185 7.43 6.534 7.717 6.674C8.004 6.814 8.2735 6.9645 8.5255 7.1255C8.7775 7.2865 8.984 7.507 9.145 7.787C9.313 8.067 9.397 8.389 9.397 8.753C9.397 9.474 9.1625 10.041 8.6935 10.454C8.2315 10.86 7.577 11.063 6.73 11.063C6.296 11.063 5.862 11.007 5.428 10.895C5.001 10.776 4.6475 10.6395 4.3675 10.4855L4.819 9.362C5.463 9.656 6.1 9.803 6.73 9.803C7.087 9.803 7.367 9.7225 7.57 9.5615C7.773 9.3935 7.8745 9.18 7.8745 8.921C7.8745 8.662 7.759 8.4485 7.528 8.2805C7.297 8.1055 7.017 7.9515 6.688 7.8185C6.359 7.6785 6.03 7.5245 5.701 7.3565C5.372 7.1815 5.092 6.94 4.861 6.632C4.63 6.317 4.5145 5.946 4.5145 5.519C4.5145 4.882 4.714 4.3955 5.113 4.0595C5.512 3.7165 6.0475 3.545 6.7195 3.545C7.3985 3.545 8.1125 3.6675 8.8615 3.9125ZM13.6997 11.0525C12.6707 11.0525 11.8937 10.699 11.3687 9.992C10.8437 9.278 10.5812 8.3715 10.5812 7.2725C10.5812 6.1735 10.8437 5.2775 11.3687 4.5845C11.9007 3.8915 12.6777 3.545 13.6997 3.545C14.7287 3.545 15.5092 3.8915 16.0412 4.5845C16.5732 5.2775 16.8392 6.1735 16.8392 7.2725C16.8392 8.7775 16.3807 9.8625 15.4637 10.5275C14.9807 10.8775 14.3927 11.0525 13.6997 11.0525ZM13.7207 4.7525C13.3497 4.7525 13.0382 4.882 12.7862 5.141C12.3382 5.589 12.1142 6.2995 12.1142 7.2725C12.1142 8.0075 12.2507 8.62 12.5237 9.11C12.7967 9.593 13.1957 9.8345 13.7207 9.8345C14.2527 9.8345 14.6517 9.5895 14.9177 9.0995C15.1837 8.6025 15.3167 8.0005 15.3167 7.2935C15.3167 6.5795 15.1732 5.9775 14.8862 5.4875C14.6062 4.9975 14.2177 4.7525 13.7207 4.7525ZM23.1648 10.37C22.6958 10.832 22.0168 11.063 21.1278 11.063C20.2388 11.063 19.5598 10.832 19.0908 10.37C18.6218 9.901 18.3873 9.208 18.3873 8.291V3.65H19.9203V8.417C19.9203 8.879 20.0218 9.236 20.2248 9.488C20.4348 9.733 20.7323 9.8555 21.1173 9.8555C21.5023 9.8555 21.7998 9.733 22.0098 9.488C22.2268 9.236 22.3353 8.879 22.3353 8.417V3.65H23.8683V8.291C23.8683 9.208 23.6338 9.901 23.1648 10.37ZM27.5335 7.808H27.4075V10.9895H25.885V3.6395H28.216C29.007 3.6395 29.5985 3.8145 29.9905 4.1645C30.3825 4.5075 30.5785 5.001 30.5785 5.645C30.5785 6.037 30.442 6.3975 30.169 6.7265C29.896 7.0485 29.5635 7.234 29.1715 7.283C29.4515 7.36 29.6685 7.4895 29.8225 7.6715C29.9765 7.8465 30.1375 8.1335 30.3055 8.5325L31.345 10.9895H29.7805L28.762 8.6375C28.615 8.3015 28.4575 8.081 28.2895 7.976C28.1285 7.864 27.8765 7.808 27.5335 7.808ZM28.174 4.8365H27.4075V6.611H28.069C28.349 6.611 28.566 6.52 28.72 6.338C28.881 6.156 28.9615 5.932 28.9615 5.666C28.9615 5.113 28.699 4.8365 28.174 4.8365ZM35.6241 11.063C34.5531 11.063 33.7306 10.727 33.1566 10.055C32.5896 9.376 32.3061 8.459 32.3061 7.304C32.3061 6.149 32.6071 5.2355 33.2091 4.5635C33.8181 3.8915 34.6616 3.5555 35.7396 3.5555C36.3276 3.5555 36.9121 3.657 37.4931 3.86L37.1991 5.036C36.7721 4.854 36.2681 4.763 35.6871 4.763C35.1061 4.763 34.6511 4.9835 34.3221 5.4245C33.9931 5.8655 33.8286 6.4745 33.8286 7.2515C33.8286 8.0285 33.9826 8.6585 34.2906 9.1415C34.5986 9.6175 35.0326 9.8555 35.5926 9.8555C36.0126 9.8555 36.6111 9.719 37.3881 9.446L37.7031 10.517C37.0661 10.881 36.3731 11.063 35.6241 11.063ZM43.7719 11H39.3934V3.65H43.7719V4.8575H40.9159V6.401H43.5094V7.6295H40.9159V9.7925H43.7719V11ZM49.7254 3.9125L49.4734 5.141L48.8224 4.9625C48.3604 4.8575 47.9579 4.805 47.6149 4.805C47.1389 4.805 46.9009 5.0325 46.9009 5.4875C46.9009 5.6625 46.9814 5.8235 47.1424 5.9705C47.3104 6.1105 47.5204 6.2295 47.7724 6.3275C48.0244 6.4185 48.2939 6.534 48.5809 6.674C48.8679 6.814 49.1374 6.9645 49.3894 7.1255C49.6414 7.2865 49.8479 7.507 50.0089 7.787C50.1769 8.067 50.2609 8.389 50.2609 8.753C50.2609 9.474 50.0264 10.041 49.5574 10.454C49.0954 10.86 48.4409 11.063 47.5939 11.063C47.1599 11.063 46.7259 11.007 46.2919 10.895C45.8649 10.776 45.5114 10.6395 45.2314 10.4855L45.6829 9.362C46.3269 9.656 46.9639 9.803 47.5939 9.803C47.9509 9.803 48.2309 9.7225 48.4339 9.5615C48.6369 9.3935 48.7384 9.18 48.7384 8.921C48.7384 8.662 48.6229 8.4485 48.3919 8.2805C48.1609 8.1055 47.8809 7.9515 47.5519 7.8185C47.2229 7.6785 46.8939 7.5245 46.5649 7.3565C46.2359 7.1815 45.9559 6.94 45.7249 6.632C45.4939 6.317 45.3784 5.946 45.3784 5.519C45.3784 4.882 45.5779 4.3955 45.9769 4.0595C46.3759 3.7165 46.9114 3.545 47.5834 3.545C48.2624 3.545 48.9764 3.6675 49.7254 3.9125Z"
        fill="#94A3B8"
      />
      <path
        d="M44.793 50.276H44.646V53.9877H42.8698V45.4127H45.5893C46.5121 45.4127 47.2022 45.6169 47.6595 46.0252C48.1168 46.4254 48.3455 47.0012 48.3455 47.7525C48.3455 48.2098 48.1863 48.6304 47.8678 49.0142C47.5493 49.3899 47.1613 49.6063 46.704 49.6635C47.0307 49.7533 47.2838 49.9044 47.4635 50.1167C47.6432 50.3209 47.831 50.6557 48.027 51.1212L49.2398 53.9877H47.4145L46.2263 51.2437C46.0548 50.8517 45.871 50.5945 45.675 50.472C45.4872 50.3413 45.1932 50.276 44.793 50.276ZM45.5403 46.8092H44.646V48.8795H45.4178C45.7444 48.8795 45.9976 48.7733 46.1773 48.561C46.3651 48.3487 46.459 48.0873 46.459 47.777C46.459 47.1318 46.1528 46.8092 45.5403 46.8092ZM55.3591 54H50.2509V45.425H55.3591V46.8337H52.0271V48.6345H55.0529V50.0677H52.0271V52.5912H55.3591V54ZM61.6923 45.7312L61.3983 47.1645L60.6388 46.9562C60.0998 46.8337 59.6302 46.7725 59.23 46.7725C58.6747 46.7725 58.397 47.0379 58.397 47.5687C58.397 47.7729 58.4909 47.9607 58.6788 48.1322C58.8748 48.2956 59.1198 48.4344 59.4138 48.5487C59.7078 48.6549 60.0222 48.7897 60.357 48.953C60.6918 49.1163 61.0063 49.2919 61.3003 49.4797C61.5943 49.6676 61.8352 49.9248 62.023 50.2515C62.219 50.5782 62.317 50.9538 62.317 51.3785C62.317 52.2197 62.0434 52.8812 61.4963 53.363C60.9573 53.8367 60.1937 54.0735 59.2055 54.0735C58.6992 54.0735 58.1928 54.0082 57.6865 53.8775C57.1883 53.7387 56.7759 53.5794 56.4493 53.3997L56.976 52.089C57.7273 52.432 58.4705 52.6035 59.2055 52.6035C59.622 52.6035 59.9487 52.5096 60.1855 52.3217C60.4223 52.1257 60.5408 51.8767 60.5408 51.5745C60.5408 51.2723 60.406 51.0232 60.1365 50.8272C59.867 50.6231 59.5403 50.4434 59.1565 50.2882C58.7727 50.1249 58.3888 49.9452 58.005 49.7492C57.6212 49.5451 57.2945 49.2633 57.025 48.904C56.7555 48.5365 56.6208 48.1037 56.6208 47.6055C56.6208 46.8623 56.8535 46.2947 57.319 45.9027C57.7845 45.5026 58.4093 45.3025 59.1933 45.3025C59.9854 45.3025 60.8184 45.4454 61.6923 45.7312ZM64.9848 54V46.8582H63.0126V45.425H68.6966V46.8582H66.7488V54H64.9848ZM77.9809 54H72.8727V45.425H77.9809V46.8337H74.6489V48.6345H77.6747V50.0677H74.6489V52.5912H77.9809V54ZM84.8286 54H83.2116V50.3372C83.2116 50.0024 83.1463 49.7329 83.0156 49.5287C82.8849 49.3164 82.6685 49.2102 82.3663 49.2102C82.0642 49.2102 81.6885 49.3981 81.2393 49.7737V54H79.6346V47.875H80.9821L81.2393 48.4262C81.5905 48.1649 81.8927 47.9893 82.1458 47.8995C82.4072 47.8015 82.7093 47.7525 83.0523 47.7525C83.5995 47.7525 84.0323 47.9362 84.3508 48.3037C84.6693 48.6631 84.8286 49.198 84.8286 49.9085V54ZM91.4551 54H90.2546L90.0096 53.3017C89.3236 53.8162 88.6988 54.0735 88.1353 54.0735C87.58 54.0735 87.1186 53.8122 86.7511 53.2895C86.3917 52.7587 86.2121 51.9787 86.2121 50.9497C86.2121 49.9126 86.4162 49.1204 86.8246 48.5732C87.2411 48.0261 87.7842 47.7525 88.4538 47.7525C88.8948 47.7525 89.3685 47.9567 89.8748 48.365V45.425H91.4551V54ZM89.8626 52.1135V49.6757C89.4297 49.3164 89.0663 49.1367 88.7723 49.1367C88.4783 49.1367 88.2415 49.2878 88.0618 49.59C87.8903 49.8922 87.8046 50.3413 87.8046 50.9375C87.8046 52.0808 88.1149 52.6525 88.7356 52.6525C89.0541 52.6525 89.4297 52.4728 89.8626 52.1135ZM95.0442 56.9033H93.4517V47.875H94.6645L94.9585 48.5242C95.2606 48.2711 95.5342 48.0792 95.7792 47.9485C96.0324 47.8178 96.3141 47.7525 96.6245 47.7525C97.3023 47.7525 97.8168 48.0342 98.168 48.5977C98.5273 49.1612 98.707 49.9493 98.707 50.962C98.707 51.9747 98.4783 52.7505 98.021 53.2895C97.5636 53.8203 97.0246 54.0858 96.404 54.0858C95.9548 54.0858 95.5016 53.8897 95.0442 53.4977V56.9033ZM95.0442 49.7615V52.0032C95.3056 52.4279 95.6281 52.6402 96.012 52.6402C96.404 52.6402 96.6735 52.5014 96.8205 52.2237C96.9756 51.9461 97.0532 51.5214 97.0532 50.9497C97.0532 50.3781 96.9716 49.9371 96.8082 49.6267C96.6449 49.3164 96.4407 49.1612 96.1957 49.1612C95.8446 49.1612 95.4607 49.3613 95.0442 49.7615ZM105.198 50.9497C105.198 51.9297 104.949 52.6974 104.451 53.2527C103.953 53.8081 103.246 54.0858 102.332 54.0858C101.417 54.0858 100.723 53.8081 100.249 53.2527C99.7756 52.6974 99.5387 51.9257 99.5387 50.9375C99.5387 49.9493 99.7756 49.1735 100.249 48.61C100.723 48.0383 101.405 47.7525 102.295 47.7525C103.185 47.7525 103.892 48.0424 104.414 48.6222C104.937 49.1939 105.198 49.9697 105.198 50.9497ZM103.569 50.9252C103.569 49.6757 103.169 49.051 102.368 49.051C101.552 49.051 101.143 49.6717 101.143 50.913C101.143 52.1543 101.556 52.775 102.381 52.775C102.822 52.775 103.128 52.6198 103.299 52.3095C103.479 51.991 103.569 51.5296 103.569 50.9252ZM108.142 46.9562H106.55V45.425H108.142V46.9562ZM108.142 54H106.55V47.875H108.142V54ZM115.274 54H113.657V50.3372C113.657 50.0024 113.592 49.7329 113.461 49.5287C113.33 49.3164 113.114 49.2102 112.812 49.2102C112.51 49.2102 112.134 49.3981 111.685 49.7737V54H110.08V47.875H111.428L111.685 48.4262C112.036 48.1649 112.338 47.9893 112.591 47.8995C112.853 47.8015 113.155 47.7525 113.498 47.7525C114.045 47.7525 114.478 47.9362 114.796 48.3037C115.115 48.6631 115.274 49.198 115.274 49.9085V54ZM117.197 52.677V49.2225H116.572V47.875H117.209V46.1232H118.789V47.875H120.075V49.2225H118.777V51.893C118.777 52.4402 118.944 52.7137 119.279 52.7137C119.467 52.7137 119.667 52.6892 119.879 52.6402L120.137 53.9142C119.761 54.0204 119.361 54.0735 118.936 54.0735C118.52 54.0735 118.124 53.9673 117.748 53.755C117.38 53.5345 117.197 53.1752 117.197 52.677ZM121.382 52.3707C121.93 52.6484 122.489 52.7872 123.061 52.7872C123.641 52.7872 123.93 52.5749 123.93 52.1502C123.93 51.7582 123.604 51.4683 122.95 51.2805C122.673 51.207 122.395 51.1212 122.117 51.0232C121.848 50.9171 121.615 50.7497 121.419 50.521C121.231 50.2842 121.137 49.982 121.137 49.6145C121.137 49.0183 121.321 48.561 121.689 48.2425C122.056 47.9158 122.567 47.7525 123.22 47.7525C123.881 47.7525 124.506 47.8668 125.094 48.0955L124.837 49.3695C124.298 49.149 123.771 49.0387 123.257 49.0387C122.897 49.0387 122.718 49.1612 122.718 49.4062C122.718 49.6594 122.959 49.8513 123.44 49.982C123.947 50.1127 124.396 50.3005 124.788 50.5455C124.992 50.668 125.164 50.8517 125.302 51.0967C125.441 51.3417 125.511 51.6357 125.511 51.9787C125.511 52.6239 125.294 53.1343 124.861 53.51C124.429 53.8857 123.832 54.0735 123.073 54.0735C122.313 54.0735 121.636 53.8979 121.039 53.5467L121.382 52.3707Z"
        fill="#94A3B8"
      />
      <path
        d="M51.4345 188.074C50.1768 188.074 49.1764 187.673 48.4333 186.873C47.6901 186.073 47.3185 185.007 47.3185 183.676C47.3185 182.336 47.6697 181.275 48.372 180.491C49.0825 179.699 50.0666 179.302 51.3243 179.302C52.1573 179.302 53.0025 179.449 53.86 179.743L53.6395 181.115C53.3292 181.001 52.9249 180.907 52.4268 180.834C51.9286 180.752 51.5407 180.711 51.263 180.711C50.5852 180.711 50.0543 180.973 49.6705 181.495C49.2867 182.01 49.0948 182.708 49.0948 183.59C49.0948 184.472 49.2989 185.207 49.7073 185.795C50.1238 186.375 50.6546 186.665 51.2998 186.665C51.6754 186.665 52.0184 186.583 52.3288 186.42V184.754H50.9078V183.345H54.105V187.412C53.2475 187.853 52.3573 188.074 51.4345 188.074ZM57.5164 183.933V188H55.9117V181.875H57.1857L57.3327 182.475C57.6594 182.214 57.9329 182.03 58.1534 181.924C58.3739 181.81 58.5659 181.752 58.7292 181.752C58.9007 181.752 59.015 181.757 59.0722 181.765C59.1294 181.765 59.1784 181.769 59.2192 181.777C59.26 181.785 59.3294 181.801 59.4274 181.826L59.2804 183.284C59.1334 183.235 58.9334 183.21 58.6802 183.21C58.3372 183.21 57.9493 183.451 57.5164 183.933ZM63.9431 188L63.6981 187.387C63.4123 187.649 63.1591 187.833 62.9386 187.939C62.7181 188.037 62.4527 188.086 62.1423 188.086C61.6197 188.086 61.1623 187.906 60.7703 187.547C60.3865 187.179 60.1946 186.693 60.1946 186.089C60.1946 185.485 60.4314 185.011 60.9051 184.668C61.3788 184.317 62.0933 184.141 63.0488 184.141H63.5511C63.5511 183.79 63.4653 183.508 63.2938 183.296C63.1305 183.084 62.8773 182.977 62.5343 182.977C61.9382 182.977 61.3338 183.059 60.7213 183.222L60.4518 182.144C61.2603 181.883 62.0729 181.752 62.8896 181.752C64.3759 181.752 65.1191 182.447 65.1191 183.835V188H63.9431ZM63.5266 185.317H62.9998C62.5425 185.317 62.2322 185.378 62.0688 185.501C61.9055 185.623 61.8238 185.803 61.8238 186.04C61.8238 186.269 61.8851 186.456 62.0076 186.603C62.1301 186.75 62.2893 186.824 62.4853 186.824C62.763 186.824 63.1101 186.603 63.5266 186.162V185.317ZM68.4502 190.903H66.8577V181.875H68.0705L68.3645 182.524C68.6666 182.271 68.9402 182.079 69.1852 181.948C69.4384 181.818 69.7201 181.752 70.0305 181.752C70.7083 181.752 71.2228 182.034 71.574 182.598C71.9333 183.161 72.113 183.949 72.113 184.962C72.113 185.975 71.8843 186.75 71.427 187.289C70.9696 187.82 70.4306 188.086 69.81 188.086C69.3608 188.086 68.9076 187.89 68.4502 187.498V190.903ZM68.4502 183.761V186.003C68.7116 186.428 69.0341 186.64 69.418 186.64C69.81 186.64 70.0795 186.501 70.2265 186.224C70.3816 185.946 70.4592 185.521 70.4592 184.95C70.4592 184.378 70.3776 183.937 70.2142 183.627C70.0509 183.316 69.8467 183.161 69.6017 183.161C69.2506 183.161 68.8667 183.361 68.4502 183.761ZM78.7267 188H77.1342V184.337C77.1342 184.002 77.0689 183.733 76.9382 183.529C76.8076 183.316 76.5871 183.21 76.2767 183.21C75.9664 183.21 75.5867 183.398 75.1375 183.774V188H73.545V179.425H75.1375V182.426C75.4887 182.165 75.7908 181.989 76.044 181.899C76.3053 181.801 76.6075 181.752 76.9505 181.752C77.4977 181.752 77.9305 181.936 78.249 182.304C78.5675 182.663 78.7267 183.198 78.7267 183.908V188ZM86.554 186.64L87.6933 187.816L86.7255 188.784L85.5618 187.547C85.0636 187.906 84.4225 188.086 83.6385 188.086C82.8545 188.086 82.1848 187.877 81.6295 187.461C80.5678 186.685 80.037 185.415 80.037 183.651C80.037 182.369 80.3433 181.324 80.9558 180.515C81.5764 179.707 82.4829 179.302 83.6753 179.302C84.8758 179.302 85.7863 179.707 86.407 180.515C87.0277 181.324 87.338 182.357 87.338 183.614C87.338 184.864 87.0767 185.873 86.554 186.64ZM84.8513 184.839L85.2433 185.317C85.4556 184.901 85.5618 184.317 85.5618 183.565C85.5618 182.806 85.3943 182.14 85.0595 181.569C84.7328 180.989 84.2633 180.699 83.6508 180.699C83.0383 180.699 82.5809 180.985 82.2788 181.556C81.9766 182.128 81.8255 182.835 81.8255 183.676C81.8255 184.517 81.9848 185.227 82.3033 185.807C82.6218 186.379 83.0832 186.665 83.6875 186.665C84.006 186.665 84.2633 186.591 84.4593 186.444L83.8713 185.807L84.8513 184.839ZM93.6513 188H88.5675V179.425H90.3438V186.591H93.6513V188ZM102.222 179.731L101.928 181.164L101.169 180.956C100.63 180.834 100.16 180.772 99.7598 180.772C99.2045 180.772 98.9268 181.038 98.9268 181.569C98.9268 181.773 99.0207 181.961 99.2085 182.132C99.4045 182.296 99.6495 182.434 99.9435 182.549C100.238 182.655 100.552 182.79 100.887 182.953C101.222 183.116 101.536 183.292 101.83 183.48C102.124 183.668 102.365 183.925 102.553 184.251C102.749 184.578 102.847 184.954 102.847 185.378C102.847 186.22 102.573 186.881 102.026 187.363C101.487 187.837 100.723 188.074 99.7353 188.074C99.229 188.074 98.7226 188.008 98.2163 187.877C97.7181 187.739 97.3057 187.579 96.979 187.4L97.5058 186.089C98.2571 186.432 99.0003 186.603 99.7353 186.603C100.152 186.603 100.478 186.51 100.715 186.322C100.952 186.126 101.071 185.877 101.071 185.574C101.071 185.272 100.936 185.023 100.666 184.827C100.397 184.623 100.07 184.443 99.6863 184.288C99.3025 184.125 98.9186 183.945 98.5348 183.749C98.151 183.545 97.8243 183.263 97.5548 182.904C97.2853 182.536 97.1505 182.104 97.1505 181.605C97.1505 180.862 97.3833 180.295 97.8488 179.903C98.3143 179.503 98.939 179.302 99.723 179.302C100.515 179.302 101.348 179.445 102.222 179.731ZM108.749 187.62C107.973 187.922 107.254 188.074 106.593 188.074C104.673 188.074 103.714 187.036 103.714 184.962C103.714 183.908 103.947 183.112 104.412 182.573C104.878 182.026 105.555 181.752 106.446 181.752C107.181 181.752 107.769 181.981 108.21 182.438C108.651 182.896 108.871 183.574 108.871 184.472C108.871 184.831 108.855 185.146 108.822 185.415H105.282C105.282 185.897 105.413 186.252 105.674 186.481C105.935 186.71 106.286 186.824 106.727 186.824C107.168 186.824 107.752 186.726 108.479 186.53L108.749 187.62ZM107.34 184.288V184.202C107.34 183.827 107.258 183.525 107.095 183.296C106.932 183.067 106.674 182.953 106.323 182.953C105.972 182.953 105.711 183.08 105.539 183.333C105.368 183.586 105.278 183.904 105.27 184.288H107.34ZM111.96 183.933V188H110.355V181.875H111.629L111.776 182.475C112.102 182.214 112.376 182.03 112.597 181.924C112.817 181.81 113.009 181.752 113.172 181.752C113.344 181.752 113.458 181.757 113.515 181.765C113.572 181.765 113.621 181.769 113.662 181.777C113.703 181.785 113.773 181.801 113.871 181.826L113.724 183.284C113.577 183.235 113.376 183.21 113.123 183.21C112.78 183.21 112.392 183.451 111.96 183.933ZM119.832 181.875L117.884 188H116.095L114.16 181.875H115.814L117.002 186.407L118.202 181.875H119.832ZM125.293 187.62C124.517 187.922 123.799 188.074 123.137 188.074C121.218 188.074 120.259 187.036 120.259 184.962C120.259 183.908 120.491 183.112 120.957 182.573C121.422 182.026 122.1 181.752 122.99 181.752C123.725 181.752 124.313 181.981 124.754 182.438C125.195 182.896 125.416 183.574 125.416 184.472C125.416 184.831 125.399 185.146 125.367 185.415H121.827C121.827 185.897 121.957 186.252 122.219 186.481C122.48 186.71 122.831 186.824 123.272 186.824C123.713 186.824 124.297 186.726 125.024 186.53L125.293 187.62ZM123.885 184.288V184.202C123.885 183.827 123.803 183.525 123.64 183.296C123.476 183.067 123.219 182.953 122.868 182.953C122.517 182.953 122.255 183.08 122.084 183.333C121.912 183.586 121.822 183.904 121.814 184.288H123.885ZM128.504 183.933V188H126.899V181.875H128.173L128.32 182.475C128.647 182.214 128.921 182.03 129.141 181.924C129.362 181.81 129.554 181.752 129.717 181.752C129.888 181.752 130.003 181.757 130.06 181.765C130.117 181.765 130.166 181.769 130.207 181.777C130.248 181.785 130.317 181.801 130.415 181.826L130.268 183.284C130.121 183.235 129.921 183.21 129.668 183.21C129.325 183.21 128.937 183.451 128.504 183.933ZM131.574 186.371C132.122 186.648 132.681 186.787 133.253 186.787C133.832 186.787 134.122 186.575 134.122 186.15C134.122 185.758 133.796 185.468 133.142 185.28C132.865 185.207 132.587 185.121 132.309 185.023C132.04 184.917 131.807 184.75 131.611 184.521C131.423 184.284 131.329 183.982 131.329 183.614C131.329 183.018 131.513 182.561 131.881 182.242C132.248 181.916 132.759 181.752 133.412 181.752C134.073 181.752 134.698 181.867 135.286 182.095L135.029 183.369C134.49 183.149 133.963 183.039 133.449 183.039C133.089 183.039 132.91 183.161 132.91 183.406C132.91 183.659 133.151 183.851 133.632 183.982C134.139 184.113 134.588 184.3 134.98 184.545C135.184 184.668 135.356 184.852 135.494 185.097C135.633 185.342 135.703 185.636 135.703 185.979C135.703 186.624 135.486 187.134 135.053 187.51C134.621 187.886 134.024 188.074 133.265 188.074C132.505 188.074 131.828 187.898 131.231 187.547L131.574 186.371Z"
        fill="#94A3B8"
      />
      <path
        d="M49.5583 116.406C49.5583 117.786 49.1581 118.897 48.3578 119.738C47.5574 120.579 46.4876 121 45.1482 121H42.8698V112.425H45.528C46.7448 112.425 47.7208 112.797 48.4558 113.54C49.1908 114.283 49.5583 115.238 49.5583 116.406ZM47.7085 116.308C47.7085 115.541 47.5003 114.936 47.0838 114.495C46.6673 114.054 46.165 113.834 45.577 113.834H44.597V119.591H45.2585C45.9445 119.591 46.5243 119.301 46.998 118.721C47.4717 118.133 47.7085 117.329 47.7085 116.308ZM54.1699 121L53.9249 120.387C53.6391 120.649 53.3859 120.833 53.1654 120.939C52.9449 121.037 52.6795 121.086 52.3691 121.086C51.8465 121.086 51.3891 120.906 50.9971 120.547C50.6133 120.179 50.4214 119.693 50.4214 119.089C50.4214 118.485 50.6582 118.011 51.1319 117.668C51.6056 117.317 52.3201 117.141 53.2756 117.141H53.7779C53.7779 116.79 53.6921 116.508 53.5206 116.296C53.3573 116.084 53.1041 115.977 52.7611 115.977C52.165 115.977 51.5606 116.059 50.9481 116.222L50.6786 115.144C51.4871 114.883 52.2997 114.752 53.1164 114.752C54.6027 114.752 55.3459 115.447 55.3459 116.835V121H54.1699ZM53.7534 118.317H53.2266C52.7693 118.317 52.459 118.378 52.2956 118.501C52.1323 118.623 52.0506 118.803 52.0506 119.04C52.0506 119.269 52.1119 119.456 52.2344 119.603C52.3569 119.75 52.5161 119.824 52.7121 119.824C52.9898 119.824 53.3369 119.603 53.7534 119.162V118.317ZM57.0233 119.677V116.222H56.3985V114.875H57.0355V113.123H58.6158V114.875H59.902V116.222H58.6035V118.893C58.6035 119.44 58.771 119.714 59.1058 119.714C59.2936 119.714 59.4937 119.689 59.706 119.64L59.9633 120.914C59.5876 121.02 59.1875 121.074 58.7628 121.074C58.3463 121.074 57.9502 120.967 57.5745 120.755C57.207 120.534 57.0233 120.175 57.0233 119.677ZM64.5656 121L64.3206 120.387C64.0348 120.649 63.7816 120.833 63.5611 120.939C63.3406 121.037 63.0752 121.086 62.7649 121.086C62.2422 121.086 61.7849 120.906 61.3929 120.547C61.0091 120.179 60.8171 119.693 60.8171 119.089C60.8171 118.485 61.054 118.011 61.5276 117.668C62.0013 117.317 62.7159 117.141 63.6714 117.141H64.1736C64.1736 116.79 64.0879 116.508 63.9164 116.296C63.7531 116.084 63.4999 115.977 63.1569 115.977C62.5607 115.977 61.9564 116.059 61.3439 116.222L61.0744 115.144C61.8829 114.883 62.6955 114.752 63.5121 114.752C64.9985 114.752 65.7416 115.447 65.7416 116.835V121H64.5656ZM64.1491 118.317H63.6224C63.1651 118.317 62.8547 118.378 62.6914 118.501C62.5281 118.623 62.4464 118.803 62.4464 119.04C62.4464 119.269 62.5076 119.456 62.6301 119.603C62.7526 119.75 62.9119 119.824 63.1079 119.824C63.3856 119.824 63.7326 119.603 64.1491 119.162V118.317ZM70.702 114.752C71.3309 114.752 71.8331 115.022 72.2088 115.561C72.5926 116.092 72.7845 116.864 72.7845 117.876C72.7845 118.881 72.5681 119.653 72.1353 120.192C71.7025 120.731 71.1471 121 70.4693 121C69.9466 121 69.4321 120.771 68.9258 120.314L68.693 121H67.4803V112.425H69.0728V115.438C69.7016 114.981 70.2447 114.752 70.702 114.752ZM71.2165 117.876C71.2165 116.741 70.8735 116.173 70.1875 116.173C69.8772 116.173 69.5056 116.357 69.0728 116.725V119.089C69.5056 119.456 69.8731 119.64 70.1753 119.64C70.4856 119.64 70.7347 119.493 70.9225 119.199C71.1185 118.905 71.2165 118.464 71.2165 117.876ZM77.342 121L77.097 120.387C76.8112 120.649 76.558 120.833 76.3375 120.939C76.117 121.037 75.8516 121.086 75.5413 121.086C75.0186 121.086 74.5613 120.906 74.1693 120.547C73.7854 120.179 73.5935 119.693 73.5935 119.089C73.5935 118.485 73.8303 118.011 74.304 117.668C74.7777 117.317 75.4923 117.141 76.4478 117.141H76.95C76.95 116.79 76.8643 116.508 76.6928 116.296C76.5294 116.084 76.2763 115.977 75.9333 115.977C75.3371 115.977 74.7328 116.059 74.1203 116.222L73.8508 115.144C74.6593 114.883 75.4718 114.752 76.2885 114.752C77.7748 114.752 78.518 115.447 78.518 116.835V121H77.342ZM76.9255 118.317H76.3988C75.9414 118.317 75.6311 118.378 75.4678 118.501C75.3044 118.623 75.2228 118.803 75.2228 119.04C75.2228 119.269 75.284 119.456 75.4065 119.603C75.529 119.75 75.6883 119.824 75.8843 119.824C76.1619 119.824 76.509 119.603 76.9255 119.162V118.317ZM80.1464 119.371C80.6936 119.648 81.253 119.787 81.8247 119.787C82.4045 119.787 82.6944 119.575 82.6944 119.15C82.6944 118.758 82.3677 118.468 81.7144 118.28C81.4367 118.207 81.1591 118.121 80.8814 118.023C80.6119 117.917 80.3792 117.75 80.1832 117.521C79.9953 117.284 79.9014 116.982 79.9014 116.614C79.9014 116.018 80.0852 115.561 80.4527 115.242C80.8202 114.916 81.3306 114.752 81.9839 114.752C82.6454 114.752 83.2702 114.867 83.8582 115.095L83.6009 116.369C83.0619 116.149 82.5352 116.039 82.0207 116.039C81.6613 116.039 81.4817 116.161 81.4817 116.406C81.4817 116.659 81.7226 116.851 82.2044 116.982C82.7107 117.113 83.1599 117.3 83.5519 117.545C83.7561 117.668 83.9276 117.852 84.0664 118.097C84.2052 118.342 84.2747 118.636 84.2747 118.979C84.2747 119.624 84.0582 120.134 83.6254 120.51C83.1926 120.886 82.5964 121.074 81.8369 121.074C81.0774 121.074 80.3996 120.898 79.8034 120.547L80.1464 119.371ZM90.1588 120.62C89.3829 120.922 88.6643 121.074 88.0028 121.074C86.0836 121.074 85.124 120.036 85.124 117.962C85.124 116.908 85.3568 116.112 85.8223 115.573C86.2878 115.026 86.9656 114.752 87.8558 114.752C88.5908 114.752 89.1788 114.981 89.6198 115.438C90.0608 115.896 90.2813 116.574 90.2813 117.472C90.2813 117.831 90.2649 118.146 90.2323 118.415H86.692C86.692 118.897 86.8227 119.252 87.084 119.481C87.3454 119.71 87.6965 119.824 88.1375 119.824C88.5785 119.824 89.1624 119.726 89.8893 119.53L90.1588 120.62ZM88.75 117.288V117.202C88.75 116.827 88.6684 116.525 88.505 116.296C88.3417 116.067 88.0844 115.953 87.7333 115.953C87.3821 115.953 87.1208 116.08 86.9493 116.333C86.7778 116.586 86.6879 116.904 86.6798 117.288H88.75ZM91.6547 119.371C92.2019 119.648 92.7613 119.787 93.333 119.787C93.9128 119.787 94.2027 119.575 94.2027 119.15C94.2027 118.758 93.876 118.468 93.2227 118.28C92.945 118.207 92.6674 118.121 92.3897 118.023C92.1202 117.917 91.8875 117.75 91.6915 117.521C91.5036 117.284 91.4097 116.982 91.4097 116.614C91.4097 116.018 91.5935 115.561 91.961 115.242C92.3285 114.916 92.8389 114.752 93.4922 114.752C94.1537 114.752 94.7785 114.867 95.3665 115.095L95.1092 116.369C94.5702 116.149 94.0435 116.039 93.529 116.039C93.1696 116.039 92.99 116.161 92.99 116.406C92.99 116.659 93.2309 116.851 93.7127 116.982C94.219 117.113 94.6682 117.3 95.0602 117.545C95.2644 117.668 95.4359 117.852 95.5747 118.097C95.7135 118.342 95.783 118.636 95.783 118.979C95.783 119.624 95.5665 120.134 95.1337 120.51C94.7009 120.886 94.1047 121.074 93.3452 121.074C92.5857 121.074 91.9079 120.898 91.3117 120.547L91.6547 119.371Z"
        fill="black"
      />
      <path
        d="M598.179 55H596.415L595.802 52.9052H593.217L592.617 55H590.914L593.487 46.425H595.582L598.179 55ZM595.471 51.4965L594.528 47.9685L593.573 51.4965H595.471ZM600.679 57.9033H599.086V48.875H600.299L600.593 49.5242C600.895 49.2711 601.169 49.0792 601.414 48.9485C601.667 48.8178 601.949 48.7525 602.259 48.7525C602.937 48.7525 603.451 49.0342 603.802 49.5977C604.162 50.1612 604.341 50.9493 604.341 51.962C604.341 52.9747 604.113 53.7505 603.655 54.2895C603.198 54.8203 602.659 55.0858 602.038 55.0858C601.589 55.0858 601.136 54.8897 600.679 54.4977V57.9033ZM600.679 50.7615V53.0032C600.94 53.4279 601.263 53.6402 601.646 53.6402C602.038 53.6402 602.308 53.5014 602.455 53.2237C602.61 52.9461 602.688 52.5214 602.688 51.9497C602.688 51.3781 602.606 50.9371 602.443 50.6267C602.279 50.3164 602.075 50.1612 601.83 50.1612C601.479 50.1612 601.095 50.3613 600.679 50.7615ZM607.366 57.9033H605.774V48.875H606.986L607.28 49.5242C607.582 49.2711 607.856 49.0792 608.101 48.9485C608.354 48.8178 608.636 48.7525 608.946 48.7525C609.624 48.7525 610.139 49.0342 610.49 49.5977C610.849 50.1612 611.029 50.9493 611.029 51.962C611.029 52.9747 610.8 53.7505 610.343 54.2895C609.885 54.8203 609.346 55.0858 608.726 55.0858C608.277 55.0858 607.823 54.8897 607.366 54.4977V57.9033ZM607.366 50.7615V53.0032C607.627 53.4279 607.95 53.6402 608.334 53.6402C608.726 53.6402 608.995 53.5014 609.142 53.2237C609.297 52.9461 609.375 52.5214 609.375 51.9497C609.375 51.3781 609.293 50.9371 609.13 50.6267C608.967 50.3164 608.763 50.1612 608.518 50.1612C608.166 50.1612 607.783 50.3613 607.366 50.7615ZM612.351 53.3707C612.898 53.6484 613.457 53.7872 614.029 53.7872C614.609 53.7872 614.899 53.5749 614.899 53.1502C614.899 52.7582 614.572 52.4683 613.919 52.2805C613.641 52.207 613.363 52.1212 613.086 52.0232C612.816 51.9171 612.583 51.7497 612.387 51.521C612.199 51.2842 612.106 50.982 612.106 50.6145C612.106 50.0183 612.289 49.561 612.657 49.2425C613.024 48.9158 613.535 48.7525 614.188 48.7525C614.85 48.7525 615.474 48.8668 616.062 49.0955L615.805 50.3695C615.266 50.149 614.739 50.0387 614.225 50.0387C613.865 50.0387 613.686 50.1612 613.686 50.4062C613.686 50.6594 613.927 50.8513 614.409 50.982C614.915 51.1127 615.364 51.3005 615.756 51.5455C615.96 51.668 616.132 51.8517 616.271 52.0967C616.409 52.3417 616.479 52.6357 616.479 52.9787C616.479 53.6239 616.262 54.1343 615.83 54.51C615.397 54.8857 614.801 55.0735 614.041 55.0735C613.282 55.0735 612.604 54.8979 612.008 54.5467L612.351 53.3707Z"
        fill="black"
      />
      <path
        d="M575.4 185.4H572.6C572.213 185.4 571.9 185.713 571.9 186.1V188.9C571.9 189.287 572.213 189.6 572.6 189.6H575.4C575.787 189.6 576.1 189.287 576.1 188.9V186.1C576.1 185.713 575.787 185.4 575.4 185.4ZM571.2 179.1C571.2 178.713 570.887 178.4 570.5 178.4H567.7C567.313 178.4 567 178.713 567 179.1V181.9C567 182.287 567.313 182.6 567.7 182.6H569.794L571.394 185.401C571.637 184.984 572.084 184.7 572.6 184.7H572.606L571.2 182.239V181.2H576.1V179.8H571.2V179.1ZM580.3 178.4H577.5C577.113 178.4 576.8 178.713 576.8 179.1V181.9C576.8 182.287 577.113 182.6 577.5 182.6H580.3C580.687 182.6 581 182.287 581 181.9V179.1C581 178.713 580.687 178.4 580.3 178.4Z"
        fill="black"
      />
      <path
        d="M594.957 188.061C593.756 188.061 592.85 187.649 592.237 186.824C591.625 185.991 591.319 184.933 591.319 183.651C591.319 182.369 591.625 181.324 592.237 180.515C592.858 179.707 593.764 179.302 594.957 179.302C596.157 179.302 597.068 179.707 597.689 180.515C598.309 181.324 598.62 182.369 598.62 183.651C598.62 185.407 598.085 186.673 597.015 187.449C596.451 187.857 595.765 188.061 594.957 188.061ZM594.981 180.711C594.548 180.711 594.185 180.862 593.891 181.164C593.368 181.687 593.107 182.516 593.107 183.651C593.107 184.509 593.266 185.223 593.585 185.795C593.903 186.358 594.369 186.64 594.981 186.64C595.602 186.64 596.067 186.354 596.378 185.783C596.688 185.203 596.843 184.501 596.843 183.676C596.843 182.843 596.676 182.14 596.341 181.569C596.014 180.997 595.561 180.711 594.981 180.711ZM599.874 186.677V183.222H599.25V181.875H599.887V180.123H601.467V181.875H602.753V183.222H601.455V185.893C601.455 186.44 601.622 186.714 601.957 186.714C602.145 186.714 602.345 186.689 602.557 186.64L602.814 187.914C602.439 188.02 602.039 188.074 601.614 188.074C601.197 188.074 600.801 187.967 600.426 187.755C600.058 187.534 599.874 187.175 599.874 186.677ZM609.352 188H607.76V184.337C607.76 184.002 607.694 183.733 607.564 183.529C607.433 183.316 607.213 183.21 606.902 183.21C606.592 183.21 606.212 183.398 605.763 183.774V188H604.17V179.425H605.763V182.426C606.114 182.165 606.416 181.989 606.669 181.899C606.931 181.801 607.233 181.752 607.576 181.752C608.123 181.752 608.556 181.936 608.874 182.304C609.193 182.663 609.352 183.198 609.352 183.908V188ZM615.795 187.62C615.019 187.922 614.301 188.074 613.639 188.074C611.72 188.074 610.76 187.036 610.76 184.962C610.76 183.908 610.993 183.112 611.459 182.573C611.924 182.026 612.602 181.752 613.492 181.752C614.227 181.752 614.815 181.981 615.256 182.438C615.697 182.896 615.918 183.574 615.918 184.472C615.918 184.831 615.901 185.146 615.869 185.415H612.328C612.328 185.897 612.459 186.252 612.72 186.481C612.982 186.71 613.333 186.824 613.774 186.824C614.215 186.824 614.799 186.726 615.526 186.53L615.795 187.62ZM614.386 184.288V184.202C614.386 183.827 614.305 183.525 614.141 183.296C613.978 183.067 613.721 182.953 613.37 182.953C613.019 182.953 612.757 183.08 612.586 183.333C612.414 183.586 612.324 183.904 612.316 184.288H614.386ZM619.006 183.933V188H617.401V181.875H618.675L618.822 182.475C619.149 182.214 619.423 182.03 619.643 181.924C619.864 181.81 620.056 181.752 620.219 181.752C620.39 181.752 620.505 181.757 620.562 181.765C620.619 181.765 620.668 181.769 620.709 181.777C620.75 181.785 620.819 181.801 620.917 181.826L620.77 183.284C620.623 183.235 620.423 183.21 620.17 183.21C619.827 183.21 619.439 183.451 619.006 183.933ZM629.929 179.731L629.635 181.164L628.875 180.956C628.336 180.834 627.867 180.772 627.466 180.772C626.911 180.772 626.633 181.038 626.633 181.569C626.633 181.773 626.727 181.961 626.915 182.132C627.111 182.296 627.356 182.434 627.65 182.549C627.944 182.655 628.259 182.79 628.593 182.953C628.928 183.116 629.243 183.292 629.537 183.48C629.831 183.668 630.072 183.925 630.259 184.251C630.455 184.578 630.553 184.954 630.553 185.378C630.553 186.22 630.28 186.881 629.733 187.363C629.194 187.837 628.43 188.074 627.442 188.074C626.936 188.074 626.429 188.008 625.923 187.877C625.425 187.739 625.012 187.579 624.686 187.4L625.212 186.089C625.964 186.432 626.707 186.603 627.442 186.603C627.858 186.603 628.185 186.51 628.422 186.322C628.659 186.126 628.777 185.877 628.777 185.574C628.777 185.272 628.642 185.023 628.373 184.827C628.103 184.623 627.777 184.443 627.393 184.288C627.009 184.125 626.625 183.945 626.241 183.749C625.858 183.545 625.531 183.263 625.261 182.904C624.992 182.536 624.857 182.104 624.857 181.605C624.857 180.862 625.09 180.295 625.555 179.903C626.021 179.503 626.646 179.302 627.43 179.302C628.222 179.302 629.055 179.445 629.929 179.731ZM636.455 187.62C635.679 187.922 634.961 188.074 634.299 188.074C632.38 188.074 631.42 187.036 631.42 184.962C631.42 183.908 631.653 183.112 632.119 182.573C632.584 182.026 633.262 181.752 634.152 181.752C634.887 181.752 635.475 181.981 635.916 182.438C636.357 182.896 636.578 183.574 636.578 184.472C636.578 184.831 636.561 185.146 636.529 185.415H632.988C632.988 185.897 633.119 186.252 633.38 186.481C633.642 186.71 633.993 186.824 634.434 186.824C634.875 186.824 635.459 186.726 636.186 186.53L636.455 187.62ZM635.046 184.288V184.202C635.046 183.827 634.965 183.525 634.801 183.296C634.638 183.067 634.381 182.953 634.03 182.953C633.678 182.953 633.417 183.08 633.246 183.333C633.074 183.586 632.984 183.904 632.976 184.288H635.046ZM639.666 183.933V188H638.061V181.875H639.335L639.482 182.475C639.809 182.214 640.083 182.03 640.303 181.924C640.524 181.81 640.716 181.752 640.879 181.752C641.05 181.752 641.165 181.757 641.222 181.765C641.279 181.765 641.328 181.769 641.369 181.777C641.41 181.785 641.479 181.801 641.577 181.826L641.43 183.284C641.283 183.235 641.083 183.21 640.83 183.21C640.487 183.21 640.099 183.451 639.666 183.933ZM647.538 181.875L645.59 188H643.802L641.866 181.875H643.52L644.708 186.407L645.909 181.875H647.538ZM650.084 180.956H648.492V179.425H650.084V180.956ZM650.084 188H648.492V181.875H650.084V188ZM655.82 186.665L656.016 187.767C655.305 187.971 654.742 188.074 654.325 188.074C653.312 188.074 652.581 187.808 652.132 187.277C651.683 186.746 651.459 185.975 651.459 184.962C651.459 183.941 651.691 183.153 652.157 182.598C652.622 182.034 653.3 181.752 654.19 181.752C654.713 181.752 655.309 181.85 655.979 182.046L655.403 183.161C654.954 183.022 654.582 182.953 654.288 182.953C653.994 182.953 653.762 183.01 653.59 183.124C653.427 183.239 653.308 183.402 653.235 183.614C653.112 183.966 653.051 184.447 653.051 185.06C653.051 185.664 653.178 186.109 653.431 186.395C653.684 186.681 654.051 186.824 654.533 186.824C655.015 186.824 655.444 186.771 655.82 186.665ZM661.745 187.62C660.969 187.922 660.25 188.074 659.589 188.074C657.67 188.074 656.71 187.036 656.71 184.962C656.71 183.908 656.943 183.112 657.408 182.573C657.874 182.026 658.552 181.752 659.442 181.752C660.177 181.752 660.765 181.981 661.206 182.438C661.647 182.896 661.867 183.574 661.867 184.472C661.867 184.831 661.851 185.146 661.818 185.415H658.278C658.278 185.897 658.409 186.252 658.67 186.481C658.931 186.71 659.282 186.824 659.723 186.824C660.164 186.824 660.748 186.726 661.475 186.53L661.745 187.62ZM660.336 184.288V184.202C660.336 183.827 660.254 183.525 660.091 183.296C659.928 183.067 659.67 182.953 659.319 182.953C658.968 182.953 658.707 183.08 658.535 183.333C658.364 183.586 658.274 183.904 658.266 184.288H660.336ZM663.241 186.371C663.788 186.648 664.347 186.787 664.919 186.787C665.499 186.787 665.789 186.575 665.789 186.15C665.789 185.758 665.462 185.468 664.809 185.28C664.531 185.207 664.253 185.121 663.976 185.023C663.706 184.917 663.473 184.75 663.277 184.521C663.09 184.284 662.996 183.982 662.996 183.614C662.996 183.018 663.179 182.561 663.547 182.242C663.914 181.916 664.425 181.752 665.078 181.752C665.74 181.752 666.364 181.867 666.952 182.095L666.695 183.369C666.156 183.149 665.629 183.039 665.115 183.039C664.756 183.039 664.576 183.161 664.576 183.406C664.576 183.659 664.817 183.851 665.299 183.982C665.805 184.113 666.254 184.3 666.646 184.545C666.85 184.668 667.022 184.852 667.161 185.097C667.299 185.342 667.369 185.636 667.369 185.979C667.369 186.624 667.152 187.134 666.72 187.51C666.287 187.886 665.691 188.074 664.931 188.074C664.172 188.074 663.494 187.898 662.898 187.547L663.241 186.371Z"
        fill="black"
      />
      <path
        d="M598.558 116.406C598.558 117.786 598.158 118.897 597.358 119.738C596.557 120.579 595.488 121 594.148 121H591.87V112.425H594.528C595.745 112.425 596.721 112.797 597.456 113.54C598.191 114.283 598.558 115.238 598.558 116.406ZM596.709 116.308C596.709 115.541 596.5 114.936 596.084 114.495C595.667 114.054 595.165 113.834 594.577 113.834H593.597V119.591H594.259C594.945 119.591 595.524 119.301 595.998 118.721C596.472 118.133 596.709 117.329 596.709 116.308ZM603.17 121L602.925 120.387C602.639 120.649 602.386 120.833 602.165 120.939C601.945 121.037 601.679 121.086 601.369 121.086C600.846 121.086 600.389 120.906 599.997 120.547C599.613 120.179 599.421 119.693 599.421 119.089C599.421 118.485 599.658 118.011 600.132 117.668C600.606 117.317 601.32 117.141 602.276 117.141H602.778C602.778 116.79 602.692 116.508 602.521 116.296C602.357 116.084 602.104 115.977 601.761 115.977C601.165 115.977 600.561 116.059 599.948 116.222L599.679 115.144C600.487 114.883 601.3 114.752 602.116 114.752C603.603 114.752 604.346 115.447 604.346 116.835V121H603.17ZM602.753 118.317H602.227C601.769 118.317 601.459 118.378 601.296 118.501C601.132 118.623 601.051 118.803 601.051 119.04C601.051 119.269 601.112 119.456 601.234 119.603C601.357 119.75 601.516 119.824 601.712 119.824C601.99 119.824 602.337 119.603 602.753 119.162V118.317ZM606.023 119.677V116.222H605.399V114.875H606.036V113.123H607.616V114.875H608.902V116.222H607.604V118.893C607.604 119.44 607.771 119.714 608.106 119.714C608.294 119.714 608.494 119.689 608.706 119.64L608.963 120.914C608.588 121.02 608.187 121.074 607.763 121.074C607.346 121.074 606.95 120.967 606.575 120.755C606.207 120.534 606.023 120.175 606.023 119.677ZM613.566 121L613.321 120.387C613.035 120.649 612.782 120.833 612.561 120.939C612.341 121.037 612.075 121.086 611.765 121.086C611.242 121.086 610.785 120.906 610.393 120.547C610.009 120.179 609.817 119.693 609.817 119.089C609.817 118.485 610.054 118.011 610.528 117.668C611.001 117.317 611.716 117.141 612.671 117.141H613.174C613.174 116.79 613.088 116.508 612.916 116.296C612.753 116.084 612.5 115.977 612.157 115.977C611.561 115.977 610.956 116.059 610.344 116.222L610.074 115.144C610.883 114.883 611.695 114.752 612.512 114.752C613.998 114.752 614.742 115.447 614.742 116.835V121H613.566ZM613.149 118.317H612.622C612.165 118.317 611.855 118.378 611.691 118.501C611.528 118.623 611.446 118.803 611.446 119.04C611.446 119.269 611.508 119.456 611.63 119.603C611.753 119.75 611.912 119.824 612.108 119.824C612.386 119.824 612.733 119.603 613.149 119.162V118.317ZM621.834 117.705H621.197V121H619.42V112.425H622.115C623.12 112.425 623.847 112.641 624.296 113.074C624.745 113.499 624.97 114.16 624.97 115.059C624.97 115.949 624.692 116.614 624.137 117.055C623.589 117.488 622.822 117.705 621.834 117.705ZM621.699 113.821H621.197V116.308H621.393C622.013 116.308 622.466 116.214 622.752 116.026C623.046 115.839 623.193 115.524 623.193 115.083C623.193 114.634 623.075 114.311 622.838 114.115C622.601 113.919 622.221 113.821 621.699 113.821ZM627.763 121H626.17V112.425H627.763V121ZM633.113 121L632.868 120.387C632.582 120.649 632.329 120.833 632.109 120.939C631.888 121.037 631.623 121.086 631.312 121.086C630.79 121.086 630.332 120.906 629.94 120.547C629.556 120.179 629.365 119.693 629.365 119.089C629.365 118.485 629.601 118.011 630.075 117.668C630.549 117.317 631.263 117.141 632.219 117.141H632.721C632.721 116.79 632.635 116.508 632.464 116.296C632.3 116.084 632.047 115.977 631.704 115.977C631.108 115.977 630.504 116.059 629.891 116.222L629.622 115.144C630.43 114.883 631.243 114.752 632.06 114.752C633.546 114.752 634.289 115.447 634.289 116.835V121H633.113ZM632.697 118.317H632.17C631.712 118.317 631.402 118.378 631.239 118.501C631.075 118.623 630.994 118.803 630.994 119.04C630.994 119.269 631.055 119.456 631.178 119.603C631.3 119.75 631.459 119.824 631.655 119.824C631.933 119.824 632.28 119.603 632.697 119.162V118.317ZM635.966 119.677V116.222H635.342V114.875H635.979V113.123H637.559V114.875H638.845V116.222H637.547V118.893C637.547 119.44 637.714 119.714 638.049 119.714C638.237 119.714 638.437 119.689 638.649 119.64L638.906 120.914C638.531 121.02 638.131 121.074 637.706 121.074C637.289 121.074 636.893 120.967 636.518 120.755C636.15 120.534 635.966 120.175 635.966 119.677ZM643.313 112.413L643.105 113.552C642.9 113.511 642.708 113.491 642.529 113.491C642.357 113.491 642.223 113.544 642.125 113.65C642.027 113.756 641.978 113.952 641.978 114.238V114.875H642.982V116.186H641.978V121H640.397V116.186H639.699V114.875H640.41V113.944C640.41 113.421 640.557 113.017 640.851 112.731C641.153 112.445 641.565 112.302 642.088 112.302C642.61 112.302 643.019 112.339 643.313 112.413ZM649.305 117.95C649.305 118.93 649.056 119.697 648.558 120.253C648.06 120.808 647.354 121.086 646.439 121.086C645.524 121.086 644.83 120.808 644.356 120.253C643.883 119.697 643.646 118.926 643.646 117.938C643.646 116.949 643.883 116.173 644.356 115.61C644.83 115.038 645.512 114.752 646.402 114.752C647.292 114.752 647.999 115.042 648.521 115.622C649.044 116.194 649.305 116.97 649.305 117.95ZM647.676 117.925C647.676 116.676 647.276 116.051 646.476 116.051C645.659 116.051 645.251 116.672 645.251 117.913C645.251 119.154 645.663 119.775 646.488 119.775C646.929 119.775 647.235 119.62 647.407 119.309C647.586 118.991 647.676 118.53 647.676 117.925ZM652.311 116.933V121H650.706V114.875H651.98L652.127 115.475C652.454 115.214 652.727 115.03 652.948 114.924C653.168 114.81 653.36 114.752 653.524 114.752C653.695 114.752 653.809 114.757 653.867 114.765C653.924 114.765 653.973 114.769 654.014 114.777C654.054 114.785 654.124 114.801 654.222 114.826L654.075 116.284C653.928 116.235 653.728 116.21 653.475 116.21C653.132 116.21 652.744 116.451 652.311 116.933ZM657.096 121H655.491V114.875H656.839L657.047 115.426C657.398 115.165 657.7 114.989 657.954 114.899C658.215 114.801 658.517 114.752 658.86 114.752C659.481 114.752 659.934 115.034 660.22 115.598C660.677 115.263 661.045 115.038 661.322 114.924C661.608 114.81 661.918 114.752 662.253 114.752C662.76 114.752 663.16 114.94 663.454 115.316C663.748 115.683 663.895 116.227 663.895 116.945V121H662.29V117.374C662.29 116.623 662.065 116.247 661.616 116.247C661.281 116.247 660.898 116.435 660.465 116.81V121H658.872V117.374C658.872 116.623 658.652 116.247 658.211 116.247C657.884 116.247 657.513 116.423 657.096 116.774V121ZM665.765 119.371C666.312 119.648 666.871 119.787 667.443 119.787C668.023 119.787 668.313 119.575 668.313 119.15C668.313 118.758 667.986 118.468 667.333 118.28C667.055 118.207 666.777 118.121 666.5 118.023C666.23 117.917 665.998 117.75 665.802 117.521C665.614 117.284 665.52 116.982 665.52 116.614C665.52 116.018 665.704 115.561 666.071 115.242C666.439 114.916 666.949 114.752 667.602 114.752C668.264 114.752 668.889 114.867 669.477 115.095L669.219 116.369C668.68 116.149 668.154 116.039 667.639 116.039C667.28 116.039 667.1 116.161 667.1 116.406C667.1 116.659 667.341 116.851 667.823 116.982C668.329 117.113 668.778 117.3 669.17 117.545C669.374 117.668 669.546 117.852 669.685 118.097C669.824 118.342 669.893 118.636 669.893 118.979C669.893 119.624 669.677 120.134 669.244 120.51C668.811 120.886 668.215 121.074 667.455 121.074C666.696 121.074 666.018 120.898 665.422 120.547L665.765 119.371Z"
        fill="black"
      />
      <path
        d="M580.125 114.375H567.875C567.392 114.375 567 113.983 567 113.5V111.75C567 111.267 567.392 110.875 567.875 110.875H580.125C580.608 110.875 581 111.267 581 111.75V113.5C581 113.983 580.608 114.375 580.125 114.375ZM578.812 111.969C578.45 111.969 578.156 112.263 578.156 112.625C578.156 112.987 578.45 113.281 578.812 113.281C579.175 113.281 579.469 112.987 579.469 112.625C579.469 112.263 579.175 111.969 578.812 111.969ZM577.062 111.969C576.7 111.969 576.406 112.263 576.406 112.625C576.406 112.987 576.7 113.281 577.062 113.281C577.425 113.281 577.719 112.987 577.719 112.625C577.719 112.263 577.425 111.969 577.062 111.969ZM580.125 118.75H567.875C567.392 118.75 567 118.358 567 117.875V116.125C567 115.642 567.392 115.25 567.875 115.25H580.125C580.608 115.25 581 115.642 581 116.125V117.875C581 118.358 580.608 118.75 580.125 118.75ZM578.812 116.344C578.45 116.344 578.156 116.638 578.156 117C578.156 117.362 578.45 117.656 578.812 117.656C579.175 117.656 579.469 117.362 579.469 117C579.469 116.638 579.175 116.344 578.812 116.344ZM577.062 116.344C576.7 116.344 576.406 116.638 576.406 117C576.406 117.362 576.7 117.656 577.062 117.656C577.425 117.656 577.719 117.362 577.719 117C577.719 116.638 577.425 116.344 577.062 116.344ZM580.125 123.125H567.875C567.392 123.125 567 122.733 567 122.25V120.5C567 120.017 567.392 119.625 567.875 119.625H580.125C580.608 119.625 581 120.017 581 120.5V122.25C581 122.733 580.608 123.125 580.125 123.125ZM578.812 120.719C578.45 120.719 578.156 121.013 578.156 121.375C578.156 121.737 578.45 122.031 578.812 122.031C579.175 122.031 579.469 121.737 579.469 121.375C579.469 121.013 579.175 120.719 578.812 120.719ZM577.062 120.719C576.7 120.719 576.406 121.013 576.406 121.375C576.406 121.737 576.7 122.031 577.062 122.031C577.425 122.031 577.719 121.737 577.719 121.375C577.719 121.013 577.425 120.719 577.062 120.719Z"
        fill="black"
      />
      <path
        d="M573.101 56.5891L571.767 56.2019C571.627 56.1625 571.548 56.0159 571.587 55.8759L574.573 45.5903C574.612 45.4503 574.759 45.3716 574.899 45.4109L576.233 45.7981C576.373 45.8375 576.452 45.9841 576.413 46.1241L573.427 56.4097C573.385 56.5497 573.241 56.6306 573.101 56.5891V56.5891ZM570.607 54.1347L571.559 53.1197C571.659 53.0125 571.653 52.8419 571.541 52.7434L569.559 51L571.541 49.2566C571.653 49.1581 571.662 48.9875 571.559 48.8803L570.607 47.8653C570.509 47.7603 570.342 47.7538 570.235 47.8544L567.083 50.8075C566.972 50.9103 566.972 51.0875 567.083 51.1903L570.235 54.1456C570.342 54.2463 570.509 54.2419 570.607 54.1347V54.1347ZM577.765 54.1478L580.917 51.1925C581.028 51.0897 581.028 50.9125 580.917 50.8097L577.765 47.8522C577.66 47.7538 577.493 47.7581 577.393 47.8631L576.441 48.8781C576.341 48.9853 576.347 49.1559 576.459 49.2544L578.441 51L576.459 52.7434C576.347 52.8419 576.338 53.0125 576.441 53.1197L577.393 54.1347C577.491 54.2419 577.657 54.2463 577.765 54.1478V54.1478Z"
        fill="black"
      />
      <path
        d="M661.068 11.063C659.997 11.063 659.174 10.727 658.6 10.055C658.033 9.376 657.75 8.459 657.75 7.304C657.75 6.149 658.051 5.2355 658.653 4.5635C659.262 3.8915 660.105 3.5555 661.183 3.5555C661.771 3.5555 662.356 3.657 662.937 3.86L662.643 5.036C662.216 4.854 661.712 4.763 661.131 4.763C660.55 4.763 660.095 4.9835 659.766 5.4245C659.437 5.8655 659.272 6.4745 659.272 7.2515C659.272 8.0285 659.426 8.6585 659.734 9.1415C660.042 9.6175 660.476 9.8555 661.036 9.8555C661.456 9.8555 662.055 9.719 662.832 9.446L663.147 10.517C662.51 10.881 661.817 11.063 661.068 11.063ZM667.483 11.0525C666.454 11.0525 665.677 10.699 665.152 9.992C664.627 9.278 664.365 8.3715 664.365 7.2725C664.365 6.1735 664.627 5.2775 665.152 4.5845C665.684 3.8915 666.461 3.545 667.483 3.545C668.512 3.545 669.293 3.8915 669.825 4.5845C670.357 5.2775 670.623 6.1735 670.623 7.2725C670.623 8.7775 670.164 9.8625 669.247 10.5275C668.764 10.8775 668.176 11.0525 667.483 11.0525ZM667.504 4.7525C667.133 4.7525 666.822 4.882 666.57 5.141C666.122 5.589 665.898 6.2995 665.898 7.2725C665.898 8.0075 666.034 8.62 666.307 9.11C666.58 9.593 666.979 9.8345 667.504 9.8345C668.036 9.8345 668.435 9.5895 668.701 9.0995C668.967 8.6025 669.1 8.0005 669.1 7.2935C669.1 6.5795 668.957 5.9775 668.67 5.4875C668.39 4.9975 668.001 4.7525 667.504 4.7525ZM677.809 11.0105H676.213L673.725 6.485V11H672.171V3.65H673.725L676.287 8.396V3.65H677.809V11.0105ZM683.938 3.9125L683.686 5.141L683.035 4.9625C682.573 4.8575 682.171 4.805 681.828 4.805C681.352 4.805 681.114 5.0325 681.114 5.4875C681.114 5.6625 681.194 5.8235 681.355 5.9705C681.523 6.1105 681.733 6.2295 681.985 6.3275C682.237 6.4185 682.507 6.534 682.794 6.674C683.081 6.814 683.35 6.9645 683.602 7.1255C683.854 7.2865 684.061 7.507 684.222 7.787C684.39 8.067 684.474 8.389 684.474 8.753C684.474 9.474 684.239 10.041 683.77 10.454C683.308 10.86 682.654 11.063 681.807 11.063C681.373 11.063 680.939 11.007 680.505 10.895C680.078 10.776 679.724 10.6395 679.444 10.4855L679.896 9.362C680.54 9.656 681.177 9.803 681.807 9.803C682.164 9.803 682.444 9.7225 682.647 9.5615C682.85 9.3935 682.951 9.18 682.951 8.921C682.951 8.662 682.836 8.4485 682.605 8.2805C682.374 8.1055 682.094 7.9515 681.765 7.8185C681.436 7.6785 681.107 7.5245 680.778 7.3565C680.449 7.1815 680.169 6.94 679.938 6.632C679.707 6.317 679.591 5.946 679.591 5.519C679.591 4.882 679.791 4.3955 680.19 4.0595C680.589 3.7165 681.124 3.545 681.796 3.545C682.475 3.545 683.189 3.6675 683.938 3.9125ZM690.908 10.37C690.439 10.832 689.76 11.063 688.871 11.063C687.982 11.063 687.303 10.832 686.834 10.37C686.365 9.901 686.13 9.208 686.13 8.291V3.65H687.663V8.417C687.663 8.879 687.765 9.236 687.968 9.488C688.178 9.733 688.475 9.8555 688.86 9.8555C689.245 9.8555 689.543 9.733 689.753 9.488C689.97 9.236 690.078 8.879 690.078 8.417V3.65H691.611V8.291C691.611 9.208 691.377 9.901 690.908 10.37ZM700.243 11H698.721V6.443L697.408 9.278H696.085L694.773 6.4535V11H693.261V3.65H694.878L696.757 7.5875L698.721 3.65H700.243V11ZM706.273 11H701.895V3.65H706.273V4.8575H703.417V6.401H706.011V7.6295H703.417V9.7925H706.273V11ZM709.759 7.808H709.633V10.9895H708.111V3.6395H710.442C711.233 3.6395 711.824 3.8145 712.216 4.1645C712.608 4.5075 712.804 5.001 712.804 5.645C712.804 6.037 712.668 6.3975 712.395 6.7265C712.122 7.0485 711.789 7.234 711.397 7.283C711.677 7.36 711.894 7.4895 712.048 7.6715C712.202 7.8465 712.363 8.1335 712.531 8.5325L713.571 10.9895H712.006L710.988 8.6375C710.841 8.3015 710.683 8.081 710.515 7.976C710.354 7.864 710.102 7.808 709.759 7.808ZM710.4 4.8365H709.633V6.611H710.295C710.575 6.611 710.792 6.52 710.946 6.338C711.107 6.156 711.187 5.932 711.187 5.666C711.187 5.113 710.925 4.8365 710.4 4.8365ZM719.078 3.9125L718.826 5.141L718.175 4.9625C717.713 4.8575 717.311 4.805 716.968 4.805C716.492 4.805 716.254 5.0325 716.254 5.4875C716.254 5.6625 716.334 5.8235 716.495 5.9705C716.663 6.1105 716.873 6.2295 717.125 6.3275C717.377 6.4185 717.647 6.534 717.934 6.674C718.221 6.814 718.49 6.9645 718.742 7.1255C718.994 7.2865 719.201 7.507 719.362 7.787C719.53 8.067 719.614 8.389 719.614 8.753C719.614 9.474 719.379 10.041 718.91 10.454C718.448 10.86 717.794 11.063 716.947 11.063C716.513 11.063 716.079 11.007 715.645 10.895C715.218 10.776 714.864 10.6395 714.584 10.4855L715.036 9.362C715.68 9.656 716.317 9.803 716.947 9.803C717.304 9.803 717.584 9.7225 717.787 9.5615C717.99 9.3935 718.091 9.18 718.091 8.921C718.091 8.662 717.976 8.4485 717.745 8.2805C717.514 8.1055 717.234 7.9515 716.905 7.8185C716.576 7.6785 716.247 7.5245 715.918 7.3565C715.589 7.1815 715.309 6.94 715.078 6.632C714.847 6.317 714.731 5.946 714.731 5.519C714.731 4.882 714.931 4.3955 715.33 4.0595C715.729 3.7165 716.264 3.545 716.936 3.545C717.615 3.545 718.329 3.6675 719.078 3.9125Z"
        fill="#94A3B8"
      />
      <g filter="url(#filter4_dd_443_23382)">
        <circle cx="362" cy="117" r="31" fill="white" />
      </g>
      <path
        d="M373.66 113.489C374.373 111.254 373.945 106.792 372.561 105.145C372.38 104.929 372.041 104.96 371.891 105.197L370.186 107.887C369.763 108.426 369.004 108.549 368.435 108.174C366.586 106.958 364.375 106.25 362 106.25C359.625 106.25 357.414 106.958 355.565 108.174C354.996 108.549 354.237 108.423 353.814 107.887L352.109 105.197C351.959 104.96 351.62 104.929 351.439 105.145C350.055 106.792 349.627 111.254 350.34 113.489C350.576 114.231 350.643 115.016 350.502 115.782C350.365 116.539 350.224 117.456 350.224 118.09C350.224 124.628 355.498 129.931 362 129.931C368.505 129.931 373.776 124.631 373.776 118.09C373.776 117.453 373.638 116.539 373.498 115.782C373.357 115.016 373.424 114.231 373.66 113.489ZM362 127.284C356.974 127.284 352.884 123.172 352.884 118.118C352.884 117.952 352.89 117.789 352.896 117.626C353.08 114.182 355.158 111.236 358.103 109.832C359.285 109.266 360.607 108.952 362 108.952C363.393 108.952 364.715 109.269 365.9 109.836C368.845 111.239 370.923 114.185 371.107 117.626C371.116 117.789 371.119 117.952 371.119 118.118C371.116 123.172 367.026 127.284 362 127.284Z"
        fill="black"
      />
      <path
        d="M365.949 121.645L363.619 117.586L361.62 114.2C361.574 114.12 361.489 114.071 361.394 114.071H359.484C359.389 114.071 359.303 114.123 359.257 114.203C359.211 114.286 359.211 114.388 359.26 114.468L361.17 117.699L358.605 121.633C358.553 121.713 358.547 121.818 358.593 121.904C358.639 121.99 358.728 122.042 358.822 122.042H360.745C360.834 122.042 360.916 121.996 360.965 121.922L362.352 119.743L363.595 121.91C363.641 121.993 363.729 122.042 363.821 122.042H365.716C365.811 122.042 365.897 121.993 365.943 121.91C365.998 121.827 365.998 121.728 365.949 121.645Z"
        fill="black"
      />
      <line x1="171" y1="116.5" x2="331" y2="116.5" stroke="#94A3B8" />
      <path
        d="M171 47C225 116.5 260 116.5 331 116.5"
        stroke="#94A3B8"
        strokeLinejoin="round"
      />
      <path
        d="M171 185.5C225 116 260 116 331 116"
        stroke="#94A3B8"
        strokeLinejoin="round"
      />
      <line
        y1="-0.5"
        x2="160"
        y2="-0.5"
        transform="matrix(-1 0 0 1 553 117)"
        stroke="#94A3B8"
      />
      <path
        d="M553 47C499 116.5 464 116.5 393 116.5"
        stroke="#94A3B8"
        strokeLinejoin="round"
      />
      <path
        d="M553 186.5C499 117 464 117 393 117"
        stroke="#94A3B8"
        strokeLinejoin="round"
      />
      <path
        d="M29.8025 48.375L29.5975 48.7325C29.5225 48.865 29.3625 48.92 29.22 48.8675C28.925 48.7575 28.655 48.6 28.4175 48.4025C28.3025 48.3075 28.2725 48.14 28.3475 48.01L28.5525 47.6525C28.38 47.4525 28.245 47.22 28.155 46.9675H27.7425C27.5925 46.9675 27.4625 46.86 27.4375 46.71C27.3875 46.41 27.385 46.095 27.4375 45.7825C27.4625 45.6325 27.5925 45.5225 27.7425 45.5225H28.155C28.245 45.27 28.38 45.0375 28.5525 44.8375L28.3475 44.48C28.2725 44.35 28.3 44.1825 28.4175 44.0875C28.655 43.89 28.9275 43.7325 29.22 43.6225C29.3625 43.57 29.5225 43.625 29.5975 43.7575L29.8025 44.115C30.065 44.0675 30.3325 44.0675 30.595 44.115L30.8 43.7575C30.875 43.625 31.035 43.57 31.1775 43.6225C31.4725 43.7325 31.7425 43.89 31.98 44.0875C32.095 44.1825 32.125 44.35 32.05 44.48L31.845 44.8375C32.0175 45.0375 32.1525 45.27 32.2425 45.5225H32.655C32.805 45.5225 32.935 45.63 32.96 45.78C33.01 46.08 33.0125 46.395 32.96 46.7075C32.935 46.8575 32.805 46.9675 32.655 46.9675H32.2425C32.1525 47.22 32.0175 47.4525 31.845 47.6525L32.05 48.01C32.125 48.14 32.0975 48.3075 31.98 48.4025C31.7425 48.6 31.47 48.7575 31.1775 48.8675C31.035 48.92 30.875 48.865 30.8 48.7325L30.595 48.375C30.335 48.4225 30.065 48.4225 29.8025 48.375V48.375ZM29.54 46.905C30.5025 47.645 31.6 46.5475 30.86 45.585C29.8975 44.8425 28.8 45.9425 29.54 46.905V46.905ZM26.6575 50.7525L27.5 51.1725C27.7525 51.3175 27.8625 51.625 27.7625 51.9C27.54 52.505 27.1025 53.06 26.6975 53.545C26.5125 53.7675 26.1925 53.8225 25.94 53.6775L25.2125 53.2575C24.8125 53.6 24.3475 53.8725 23.84 54.05V54.89C23.84 55.18 23.6325 55.43 23.3475 55.48C22.7325 55.585 22.0875 55.59 21.45 55.48C21.1625 55.43 20.95 55.1825 20.95 54.89V54.05C20.4425 53.87 19.9775 53.6 19.5775 53.2575L18.85 53.675C18.6 53.82 18.2775 53.765 18.0925 53.5425C17.6875 53.0575 17.26 52.5025 17.0375 51.9C16.9375 51.6275 17.0475 51.32 17.3 51.1725L18.1325 50.7525C18.035 50.23 18.035 49.6925 18.1325 49.1675L17.3 48.745C17.0475 48.6 16.935 48.2925 17.0375 48.02C17.26 47.415 17.6875 46.86 18.0925 46.375C18.2775 46.1525 18.5975 46.0975 18.85 46.2425L19.5775 46.6625C19.9775 46.32 20.4425 46.0475 20.95 45.87V45.0275C20.95 44.74 21.155 44.49 21.44 44.44C22.055 44.335 22.7025 44.33 23.34 44.4375C23.6275 44.4875 23.84 44.735 23.84 45.0275V45.8675C24.3475 46.0475 24.8125 46.3175 25.2125 46.66L25.94 46.24C26.19 46.095 26.5125 46.15 26.6975 46.3725C27.1025 46.8575 27.5275 47.4125 27.75 48.0175C27.85 48.29 27.7525 48.5975 27.5 48.745L26.6575 49.165C26.755 49.69 26.755 50.2275 26.6575 50.7525V50.7525ZM23.7175 51.28C25.1975 49.355 23 47.1575 21.075 48.6375C19.595 50.5625 21.7925 52.76 23.7175 51.28ZM29.8025 55.8475L29.5975 56.205C29.5225 56.3375 29.3625 56.3925 29.22 56.34C28.925 56.23 28.655 56.0725 28.4175 55.875C28.3025 55.78 28.2725 55.6125 28.3475 55.4825L28.5525 55.125C28.38 54.925 28.245 54.6925 28.155 54.44H27.7425C27.5925 54.44 27.4625 54.3325 27.4375 54.1825C27.3875 53.8825 27.385 53.5675 27.4375 53.255C27.4625 53.105 27.5925 52.995 27.7425 52.995H28.155C28.245 52.7425 28.38 52.51 28.5525 52.31L28.3475 51.9525C28.2725 51.8225 28.3 51.655 28.4175 51.56C28.655 51.3625 28.9275 51.205 29.22 51.095C29.3625 51.0425 29.5225 51.0975 29.5975 51.23L29.8025 51.5875C30.065 51.54 30.3325 51.54 30.595 51.5875L30.8 51.23C30.875 51.0975 31.035 51.0425 31.1775 51.095C31.4725 51.205 31.7425 51.3625 31.98 51.56C32.095 51.655 32.125 51.8225 32.05 51.9525L31.845 52.31C32.0175 52.51 32.1525 52.7425 32.2425 52.995H32.655C32.805 52.995 32.935 53.1025 32.96 53.2525C33.01 53.5525 33.0125 53.8675 32.96 54.18C32.935 54.33 32.805 54.44 32.655 54.44H32.2425C32.1525 54.6925 32.0175 54.925 31.845 55.125L32.05 55.4825C32.125 55.6125 32.0975 55.78 31.98 55.875C31.7425 56.0725 31.47 56.23 31.1775 56.34C31.035 56.3925 30.875 56.3375 30.8 56.205L30.595 55.8475C30.335 55.895 30.065 55.895 29.8025 55.8475ZM29.54 54.375C30.5025 55.115 31.6 54.0175 30.86 53.055C29.8975 52.315 28.8 53.4125 29.54 54.375V54.375Z"
        fill="#94A3B8"
      />
      <path
        d="M32 111.286V112.714C32 113.973 28.8646 115 25 115C21.1354 115 18 113.973 18 112.714V111.286C18 110.027 21.1354 109 25 109C28.8646 109 32 110.027 32 111.286ZM32 114.5V117.714C32 118.973 28.8646 120 25 120C21.1354 120 18 118.973 18 117.714V114.5C19.5039 115.536 22.2565 116.018 25 116.018C27.7435 116.018 30.4961 115.536 32 114.5ZM32 119.5V122.714C32 123.973 28.8646 125 25 125C21.1354 125 18 123.973 18 122.714V119.5C19.5039 120.536 22.2565 121.018 25 121.018C27.7435 121.018 30.4961 120.536 32 119.5Z"
        fill="black"
      />
      <path
        d="M29.5 176.125C29.5 175.827 29.3815 175.54 29.1705 175.33C28.9595 175.119 28.6734 175 28.375 175C28.0766 175 27.7905 175.119 27.5795 175.33C27.3685 175.54 27.25 175.827 27.25 176.125V179.5H29.5V176.125ZM31.1875 180.625H18.8125C18.6633 180.625 18.5202 180.684 18.4148 180.79C18.3093 180.895 18.25 181.038 18.25 181.188V182.312C18.25 182.462 18.3093 182.605 18.4148 182.71C18.5202 182.816 18.6633 182.875 18.8125 182.875H19.375V184C19.3752 185.297 19.8231 186.553 20.6431 187.558C21.463 188.562 22.6047 189.253 23.875 189.512V193H26.125V189.512C27.3953 189.253 28.537 188.562 29.3569 187.558C30.1769 186.553 30.6248 185.297 30.625 184V182.875H31.1875C31.3367 182.875 31.4798 182.816 31.5852 182.71C31.6907 182.605 31.75 182.462 31.75 182.312V181.188C31.75 181.038 31.6907 180.895 31.5852 180.79C31.4798 180.684 31.3367 180.625 31.1875 180.625ZM22.75 176.125C22.75 175.827 22.6315 175.54 22.4205 175.33C22.2095 175.119 21.9234 175 21.625 175C21.3266 175 21.0405 175.119 20.8295 175.33C20.6185 175.54 20.5 175.827 20.5 176.125V179.5H22.75V176.125Z"
        fill="#94A3B8"
      />
      <g filter="url(#filter5_dd_443_23382)">
        <circle cx="393" cy="117" r="12" fill="white" />
      </g>
      <path
        d="M394.202 111.601L396.846 113.127C396.925 113.043 397.018 112.969 397.124 112.908C397.722 112.564 398.485 112.769 398.833 113.367C399.177 113.966 398.973 114.729 398.374 115.077C398.244 115.151 398.105 115.2 397.965 115.225V118.244C398.104 118.269 398.24 118.317 398.369 118.391C398.971 118.739 399.175 119.501 398.827 120.099C398.484 120.697 397.717 120.901 397.12 120.558C396.971 120.472 396.847 120.361 396.75 120.233L394.154 121.731C394.217 121.881 394.251 122.045 394.251 122.218C394.251 122.906 393.692 123.469 393 123.469C392.308 123.469 391.749 122.91 391.749 122.218C391.749 122.081 391.771 121.95 391.811 121.827L389.186 120.311C389.1 120.407 388.997 120.492 388.88 120.56C388.278 120.904 387.514 120.7 387.17 120.101C386.826 119.503 387.031 118.739 387.629 118.392C387.72 118.339 387.815 118.3 387.912 118.272V115.197C387.814 115.169 387.718 115.129 387.626 115.077C387.027 114.732 386.823 113.966 387.167 113.367C387.511 112.769 388.278 112.564 388.876 112.908C388.962 112.958 389.039 113.016 389.108 113.081L391.782 111.537C391.761 111.445 391.749 111.349 391.749 111.251C391.749 110.559 392.308 110 393 110C393.692 110 394.251 110.559 394.251 111.251C394.251 111.372 394.234 111.49 394.202 111.601ZM393.926 112.094C393.898 112.125 393.868 112.154 393.837 112.182L397.361 118.285C397.374 118.281 397.387 118.277 397.399 118.273V115.194C397.1 115.107 396.832 114.909 396.665 114.618C396.482 114.3 396.454 113.937 396.557 113.613L393.926 112.094ZM392.085 112.105C392.067 112.086 392.05 112.066 392.033 112.045L389.422 113.553C389.549 113.891 389.529 114.28 389.335 114.618C389.145 114.948 388.826 115.159 388.478 115.223V118.245C388.496 118.248 388.515 118.252 388.534 118.256L392.085 112.105ZM393.342 112.455C393.234 112.486 393.119 112.502 393 112.502C392.844 112.502 392.694 112.474 392.556 112.421L389.043 118.505C389.159 118.598 389.259 118.714 389.339 118.85C389.391 118.941 389.431 119.036 389.458 119.133H396.542C396.569 119.036 396.609 118.941 396.661 118.85C396.721 118.746 396.793 118.654 396.875 118.575L393.342 112.455ZM393.875 121.322L396.534 119.787C396.527 119.758 396.52 119.728 396.515 119.699H389.485C389.478 119.738 389.469 119.777 389.458 119.816L392.105 121.344C392.332 121.111 392.649 120.967 393 120.967C393.341 120.967 393.649 121.102 393.875 121.322Z"
        fill="#E535AB"
      />
      <g filter="url(#filter6_dd_443_23382)">
        <circle cx="420" cy="117" r="3" fill="#F59E0B" />
        <circle cx="420" cy="117" r="2.5" stroke="#F59E0B" />
      </g>
      <g filter="url(#filter7_dd_443_23382)">
        <circle cx="537" cy="67" r="3" fill="#F59E0B" />
        <circle cx="537" cy="67" r="2.5" stroke="#F59E0B" />
      </g>
      <g filter="url(#filter8_dd_443_23382)">
        <circle cx="497" cy="100" r="3" fill="#F59E0B" />
        <circle cx="497" cy="100" r="2.5" stroke="#F59E0B" />
      </g>
      <g filter="url(#filter9_dd_443_23382)">
        <circle cx="505" cy="138" r="3" fill="#F59E0B" />
        <circle cx="505" cy="138" r="2.5" stroke="#F59E0B" />
      </g>
      <g filter="url(#filter10_dd_443_23382)">
        <circle cx="526" cy="117" r="3" fill="#F59E0B" />
        <circle cx="526" cy="117" r="2.5" stroke="#F59E0B" />
      </g>
      <g filter="url(#filter11_dd_443_23382)">
        <circle cx="547" cy="179" r="3" fill="#F59E0B" />
        <circle cx="547" cy="179" r="2.5" stroke="#F59E0B" />
      </g>
      <defs>
        <filter
          id="filter0_dd_443_23382"
          x="0"
          y="88"
          width="174"
          height="60"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter1_dd_443_23382"
          x="550"
          y="21"
          width="174"
          height="60"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter2_dd_443_23382"
          x="550"
          y="88"
          width="174"
          height="60"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter3_dd_443_23382"
          x="550"
          y="155"
          width="174"
          height="60"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter4_dd_443_23382"
          x="328"
          y="84"
          width="68"
          height="68"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter5_dd_443_23382"
          x="378"
          y="103"
          width="30"
          height="30"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter6_dd_443_23382"
          x="414"
          y="112"
          width="12"
          height="12"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter7_dd_443_23382"
          x="531"
          y="62"
          width="12"
          height="12"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter8_dd_443_23382"
          x="491"
          y="95"
          width="12"
          height="12"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter9_dd_443_23382"
          x="499"
          y="133"
          width="12"
          height="12"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter10_dd_443_23382"
          x="520"
          y="112"
          width="12"
          height="12"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
        <filter
          id="filter11_dd_443_23382"
          x="541"
          y="174"
          width="12"
          height="12"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_443_23382"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_443_23382"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_443_23382"
            result="effect2_dropShadow_443_23382"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_443_23382"
            result="shape"
          />
        </filter>
      </defs>
    </svg>
  );
}
