import { Table, TableType } from '../types';

export const allTables = [
  {
    table_schema: 'public',
    table_name: 'testing',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'testing',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('testing_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'jsonb',
        table_name: 'testing',
        column_name: 'metadata',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'jsonb',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'timestamp with time zone',
        table_name: 'testing',
        column_name: 'deleted_at',
        is_nullable: 'YES',
        table_schema: 'public',
        column_default: 'now()',
        data_type_name: 'timestamptz',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'testing',
      constraint_name: 'testing_pkey',
      columns: ['id'],
    },
    relationships: [],
    permissions: [
      {
        role_name: 'user',
        permissions: {
          insert: { check: {}, columns: ['id', 'metadata', 'deleted_at'] },
          update: { columns: ['id', 'metadata'], filter: {}, check: {} },
          select: {
            columns: ['deleted_at', 'id', 'metadata'],
            filter: { deleted_at: { _is_null: true } },
            allow_aggregations: true,
          },
        },
        table_name: 'testing',
        table_schema: 'public',
      },
      {
        role_name: 'asdf',
        permissions: {
          select: { columns: ['id', 'metadata', 'deleted_at'], filter: {} },
        },
        table_name: 'testing',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'user',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'user',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('user_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'user',
        column_name: 'name',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'timestamp with time zone',
        table_name: 'user',
        column_name: 'deleted_at',
        is_nullable: 'YES',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'timestamptz',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'user',
      constraint_name: 'user_pkey',
      columns: ['id'],
    },
    relationships: [
      {
        rel_def: {
          foreign_key_constraint_on: {
            column: 'student_id',
            table: { name: 'class_student', schema: 'public' },
          },
        },
        rel_name: 'class_students',
        table_name: 'user',
        table_schema: 'public',
        rel_type: 'array',
      },
    ],
    permissions: [
      {
        role_name: 'sdfsf',
        permissions: {
          select: {
            columns: ['id', 'name', 'deleted_at'],
            filter: { _or: [] },
            query_root_fields: ['select', 'select_by_pk'],
            subscription_root_fields: ['select', 'select_by_pk'],
          },
        },
        table_name: 'user',
        table_schema: 'public',
      },
      {
        role_name: 'user',
        permissions: {
          select: {
            columns: ['deleted_at', 'id', 'name'],
            filter: { deleted_at: { _is_null: true } },
            query_root_fields: ['select', 'select_by_pk'],
            subscription_root_fields: ['select', 'select_by_pk'],
          },
        },
        table_name: 'user',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class_student',
        constraint_name: 'class_student_student_id_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'user',
        column_mapping: { student_id: 'id' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'class',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'class',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('class_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'class',
        column_name: 'enum_relation',
        is_nullable: 'YES',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'class',
        column_name: 'teacher',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'class',
      constraint_name: 'class_pkey',
      columns: ['id'],
    },
    relationships: [
      {
        rel_def: {
          foreign_key_constraint_on: {
            column: 'class',
            table: { name: 'class_student', schema: 'public' },
          },
        },
        rel_name: 'class_students',
        table_name: 'class',
        table_schema: 'public',
        rel_type: 'array',
      },
      {
        rel_def: { foreign_key_constraint_on: 'enum_relation' },
        rel_name: 'an_enum',
        table_name: 'class',
        table_schema: 'public',
        rel_type: 'object',
      },
      {
        rel_def: {
          manual_configuration: {
            column_mapping: { id: 'id' },
            insertion_order: null,
            remote_table: { name: 'identitytest', schema: 'public' },
          },
        },
        rel_name: 'object_relationship',
        table_name: 'class',
        table_schema: 'public',
        rel_type: 'object',
      },
    ],
    permissions: [
      {
        role_name: 'asdf',
        permissions: {
          select: {
            columns: ['id'],
            filter: { enum_relation: { _is_null: true } },
          },
        },
        table_name: 'class',
        table_schema: 'public',
      },
      {
        role_name: 'new',
        permissions: {
          select: {
            columns: [],
            filter: {
              _exists: {
                _table: { name: 'class_student', schema: 'public' },
                _where: {
                  classByClass: {
                    enum_relation: { _clt: ['$', 'enum_relation'] },
                  },
                },
              },
            },
          },
          delete: { filter: { teacher: { _eq: 'X-Hasura-User-Id' } } },
        },
        table_name: 'class',
        table_schema: 'public',
      },
      {
        role_name: 'user',
        permissions: {
          select: {
            columns: ['id'],
            filter: { _not: { id: { _eq: 1 } } },
            allow_aggregations: true,
            query_root_fields: ['select_aggregate', 'select', 'select_by_pk'],
            subscription_root_fields: ['select', 'select_stream'],
          },
          delete: { filter: { id: { _eq: 1 } } },
        },
        table_name: 'class',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class',
        constraint_name: 'class_enum_relation_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'an_enum',
        column_mapping: { enum_relation: 'name' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    opp_foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class_student',
        constraint_name: 'class_student_class_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'class',
        column_mapping: { class: 'id' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    view_info: null,
    remote_relationships: [
      {
        remote_relationship_name: 'Album_Artists',
        table_name: 'class',
        table_schema: 'public',
        definition: {
          to_source: {
            field_mapping: { teacher: 'Title' },
            relationship_type: 'object',
            source: 'Chinook',
            table: ['Album'],
          },
        },
      },
    ],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'class_student',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'class_student',
        column_name: 'class',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'int4',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'integer',
        table_name: 'class_student',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('class_student_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'integer',
        table_name: 'class_student',
        column_name: 'student_id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'int4',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'class_student',
      constraint_name: 'class_student_pkey',
      columns: ['id'],
    },
    relationships: [
      {
        rel_def: { foreign_key_constraint_on: 'class' },
        rel_name: 'classByClass',
        table_name: 'class_student',
        table_schema: 'public',
        rel_type: 'object',
      },
      {
        rel_def: { foreign_key_constraint_on: 'student_id' },
        rel_name: 'user',
        table_name: 'class_student',
        table_schema: 'public',
        rel_type: 'object',
      },
    ],
    permissions: [
      {
        role_name: 'new',
        permissions: {
          select: {
            columns: ['class', 'id'],
            filter: {},
            allow_aggregations: true,
            query_root_fields: ['select_aggregate', 'select', 'select_by_pk'],
            subscription_root_fields: [
              'select_aggregate',
              'select',
              'select_by_pk',
            ],
          },
        },
        table_name: 'class_student',
        table_schema: 'public',
      },
      {
        role_name: 'user',
        permissions: {
          select: {
            columns: ['class', 'id', 'student_id'],
            filter: {},
            allow_aggregations: true,
          },
        },
        table_name: 'class_student',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class_student',
        constraint_name: 'class_student_class_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'class',
        column_mapping: { class: 'id' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
      {
        table_schema: 'public',
        table_name: 'class_student',
        constraint_name: 'class_student_student_id_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'user',
        column_mapping: { student_id: 'id' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'identitytest',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'identitytest',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('identitytest_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'identitytest',
        column_name: 'identity',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'identitytest',
      constraint_name: 'identitytest_pkey',
      columns: ['id'],
    },
    relationships: [],
    permissions: [],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'testtest',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'testtest',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('testtest_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'integer',
        table_name: 'testtest',
        column_name: 'user_id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'int4',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'testtest',
        column_name: 'name',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'testtest',
      constraint_name: 'testtest_pkey',
      columns: ['id'],
    },
    relationships: [],
    permissions: [
      {
        role_name: 'asdf',
        permissions: { select: { columns: ['id', 'name'], filter: {} } },
        table_name: 'testtest',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'some_table',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'uuid',
        table_name: 'some_table',
        column_name: 'ID',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: 'gen_random_uuid()',
        data_type_name: 'uuid',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'uuid',
        table_name: 'some_table',
        column_name: 'ID2',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: 'gen_random_uuid()',
        data_type_name: 'uuid',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'some_table',
      constraint_name: 'some_table_pkey',
      columns: ['ID2', 'ID'],
    },
    relationships: [],
    permissions: [],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'an_enum',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'text',
        table_name: 'an_enum',
        column_name: 'desc',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'an_enum',
        column_name: 'name',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'an_enum',
      constraint_name: 'an_enum_pkey',
      columns: ['name'],
    },
    relationships: [],
    permissions: [],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class',
        constraint_name: 'class_enum_relation_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'an_enum',
        column_mapping: { enum_relation: 'name' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    view_info: null,
    remote_relationships: [],
    is_enum: true,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'perm_test',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'perm_test',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('perm_test_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'perm_test',
        column_name: 'name',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'perm_test',
        column_name: 'surname',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'perm_test',
      constraint_name: 'perm_test_pkey',
      columns: ['id'],
    },
    relationships: [],
    permissions: [
      {
        role_name: 'user',
        permissions: {
          select: {
            columns: ['id', 'name'],
            filter: { id: { _eq: 'X-Hasura-User-Id' } },
          },
        },
        table_name: 'perm_test',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
] as Table[];

export const startTable = {
  table_schema: 'public',
  table_name: 'class',
  table_type: 'TABLE',
  is_table_tracked: true,
  columns: [
    {
      comment: null,
      data_type: 'integer',
      table_name: 'class',
      column_name: 'id',
      is_nullable: 'NO',
      table_schema: 'public',
      column_default: "nextval('class_id_seq'::regclass)",
      data_type_name: 'int4',
      ordinal_position: 1,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
    {
      comment: null,
      data_type: 'text',
      table_name: 'class',
      column_name: 'enum_relation',
      is_nullable: 'YES',
      table_schema: 'public',
      column_default: null,
      data_type_name: 'text',
      ordinal_position: 3,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
    {
      comment: null,
      data_type: 'text',
      table_name: 'class',
      column_name: 'teacher',
      is_nullable: 'NO',
      table_schema: 'public',
      column_default: null,
      data_type_name: 'text',
      ordinal_position: 2,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
  ],
  comment: null,
  triggers: [],
  primary_key: {
    table_schema: 'public',
    table_name: 'class',
    constraint_name: 'class_pkey',
    columns: ['id'],
  },
  relationships: [
    {
      rel_def: {
        foreign_key_constraint_on: {
          column: 'class',
          table: { name: 'class_student', schema: 'public' },
        },
      },
      rel_name: 'class_students',
      table_name: 'class',
      table_schema: 'public',
      rel_type: 'array',
    },
    {
      rel_def: { foreign_key_constraint_on: 'enum_relation' },
      rel_name: 'an_enum',
      table_name: 'class',
      table_schema: 'public',
      rel_type: 'object',
    },
    {
      rel_def: {
        manual_configuration: {
          column_mapping: { id: 'id' },
          insertion_order: null,
          remote_table: { name: 'identitytest', schema: 'public' },
        },
      },
      rel_name: 'object_relationship',
      table_name: 'class',
      table_schema: 'public',
      rel_type: 'object',
    },
  ],
  permissions: [
    {
      role_name: 'asdf',
      permissions: {
        select: {
          columns: ['id'],
          filter: { enum_relation: { _is_null: true } },
        },
      },
      table_name: 'class',
      table_schema: 'public',
    },
    {
      role_name: 'new',
      permissions: {
        select: {
          columns: [],
          filter: {
            _exists: {
              _table: { name: 'class_student', schema: 'public' },
              _where: {
                classByClass: {
                  enum_relation: { _clt: ['$', 'enum_relation'] },
                },
              },
            },
          },
        },
        delete: { filter: { teacher: { _eq: 'X-Hasura-User-Id' } } },
      },
      table_name: 'class',
      table_schema: 'public',
    },
    {
      role_name: 'user',
      permissions: {
        select: {
          columns: ['id'],
          filter: { _not: { id: { _eq: 1 } } },
          allow_aggregations: true,
          query_root_fields: ['select_aggregate', 'select', 'select_by_pk'],
          subscription_root_fields: ['select', 'select_stream'],
        },
        delete: { filter: { id: { _eq: 1 } } },
      },
      table_name: 'class',
      table_schema: 'public',
    },
  ],
  unique_constraints: [],
  check_constraints: [],
  foreign_key_constraints: [
    {
      table_schema: 'public',
      table_name: 'class',
      constraint_name: 'class_enum_relation_fkey',
      ref_table_table_schema: 'public',
      ref_table: 'an_enum',
      column_mapping: { enum_relation: 'name' },
      on_update: 'r',
      on_delete: 'r',
      is_table_tracked: true,
      is_ref_table_tracked: true,
    },
  ],
  opp_foreign_key_constraints: [
    {
      table_schema: 'public',
      table_name: 'class_student',
      constraint_name: 'class_student_class_fkey',
      ref_table_table_schema: 'public',
      ref_table: 'class',
      column_mapping: { class: 'id' },
      on_update: 'r',
      on_delete: 'r',
      is_table_tracked: true,
      is_ref_table_tracked: true,
    },
  ],
  view_info: null,
  remote_relationships: [
    {
      remote_relationship_name: 'Album_Artists',
      table_name: 'class',
      table_schema: 'public',
      definition: {
        to_source: {
          field_mapping: { teacher: 'Title' },
          relationship_type: 'object',
          source: 'Chinook',
          table: ['Album'],
        },
      },
    },
  ],
  is_enum: false,
  is_apollo_federation_supported: false,
  computed_fields: [],
} as unknown as Table;

export const expectedObjectResult = {
  table_schema: 'public',
  table_name: 'identitytest',
  table_type: 'TABLE' as TableType,
  is_table_tracked: true,
  columns: [
    {
      comment: null,
      data_type: 'integer',
      table_name: 'identitytest',
      column_name: 'id',
      is_nullable: 'NO',
      table_schema: 'public',
      column_default: "nextval('identitytest_id_seq'::regclass)",
      data_type_name: 'int4',
      ordinal_position: 1,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
    {
      comment: null,
      data_type: 'text',
      table_name: 'identitytest',
      column_name: 'identity',
      is_nullable: 'NO',
      table_schema: 'public',
      column_default: null,
      data_type_name: 'text',
      ordinal_position: 2,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
  ],
  comment: null,
  triggers: [],
  primary_key: {
    table_schema: 'public',
    table_name: 'identitytest',
    constraint_name: 'identitytest_pkey',
    columns: ['id'],
  },
  relationships: [],
  permissions: [],
  unique_constraints: [],
  check_constraints: [],
  foreign_key_constraints: [],
  opp_foreign_key_constraints: [],
  view_info: null,
  remote_relationships: [],
  is_enum: false,
  is_apollo_federation_supported: false,
  configuration: {},
  computed_fields: [],
};

export const expectedArrayResult = {
  table_schema: 'public',
  table_name: 'class_student',
  table_type: 'TABLE' as TableType,
  is_table_tracked: true,
  columns: [
    {
      comment: null,
      data_type: 'integer',
      table_name: 'class_student',
      column_name: 'class',
      is_nullable: 'NO',
      table_schema: 'public',
      column_default: null,
      data_type_name: 'int4',
      ordinal_position: 2,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
    {
      comment: null,
      data_type: 'integer',
      table_name: 'class_student',
      column_name: 'id',
      is_nullable: 'NO',
      table_schema: 'public',
      column_default: "nextval('class_student_id_seq'::regclass)",
      data_type_name: 'int4',
      ordinal_position: 1,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
    {
      comment: null,
      data_type: 'integer',
      table_name: 'class_student',
      column_name: 'student_id',
      is_nullable: 'NO',
      table_schema: 'public',
      column_default: null,
      data_type_name: 'int4',
      ordinal_position: 3,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
  ],
  comment: null,
  triggers: [],
  primary_key: {
    table_schema: 'public',
    table_name: 'class_student',
    constraint_name: 'class_student_pkey',
    columns: ['id'],
  },
  relationships: [
    {
      rel_def: { foreign_key_constraint_on: 'class' },
      rel_name: 'classByClass',
      table_name: 'class_student',
      table_schema: 'public',
      rel_type: 'object',
    },
    {
      rel_def: { foreign_key_constraint_on: 'student_id' },
      rel_name: 'user',
      table_name: 'class_student',
      table_schema: 'public',
      rel_type: 'object',
    },
  ],
  permissions: [
    {
      role_name: 'new',
      permissions: {
        select: {
          columns: ['class', 'id'],
          filter: {},
          allow_aggregations: true,
          query_root_fields: ['select_aggregate', 'select', 'select_by_pk'],
          subscription_root_fields: [
            'select_aggregate',
            'select',
            'select_by_pk',
          ],
        },
      },
      table_name: 'class_student',
      table_schema: 'public',
    },
    {
      role_name: 'user',
      permissions: {
        select: {
          columns: ['class', 'id', 'student_id'],
          filter: {},
          allow_aggregations: true,
        },
      },
      table_name: 'class_student',
      table_schema: 'public',
    },
  ],
  unique_constraints: [],
  check_constraints: [],
  foreign_key_constraints: [
    {
      table_schema: 'public',
      table_name: 'class_student',
      constraint_name: 'class_student_class_fkey',
      ref_table_table_schema: 'public',
      ref_table: 'class',
      column_mapping: { class: 'id' },
      on_update: 'r',
      on_delete: 'r',
      is_table_tracked: true,
      is_ref_table_tracked: true,
    },
    {
      table_schema: 'public',
      table_name: 'class_student',
      constraint_name: 'class_student_student_id_fkey',
      ref_table_table_schema: 'public',
      ref_table: 'user',
      column_mapping: { student_id: 'id' },
      on_update: 'r',
      on_delete: 'r',
      is_table_tracked: true,
      is_ref_table_tracked: true,
    },
  ],
  opp_foreign_key_constraints: [],
  view_info: null,
  remote_relationships: [],
  is_enum: false,
  is_apollo_federation_supported: false,
  configuration: {},
  computed_fields: [],
} as unknown as Table;

export const objectStartTable = {
  table_schema: 'public',
  table_name: 'class',
  table_type: 'TABLE' as TableType,
  is_table_tracked: true,
  columns: [
    {
      comment: null,
      data_type: 'integer',
      table_name: 'class',
      column_name: 'id',
      is_nullable: 'NO',
      table_schema: 'public',
      column_default: "nextval('class_id_seq'::regclass)",
      data_type_name: 'int4',
      ordinal_position: 1,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
    {
      comment: null,
      data_type: 'text',
      table_name: 'class',
      column_name: 'enum_relation',
      is_nullable: 'YES',
      table_schema: 'public',
      column_default: null,
      data_type_name: 'text',
      ordinal_position: 3,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
    {
      comment: null,
      data_type: 'text',
      table_name: 'class',
      column_name: 'teacher',
      is_nullable: 'NO',
      table_schema: 'public',
      column_default: null,
      data_type_name: 'text',
      ordinal_position: 2,
      is_generated: false,
      is_identity: false,
      identity_generation: null,
    },
  ],
  comment: null,
  triggers: [],
  primary_key: {
    table_schema: 'public',
    table_name: 'class',
    constraint_name: 'class_pkey',
    columns: ['id'],
  },
  relationships: [
    {
      rel_def: {
        foreign_key_constraint_on: {
          column: 'class',
          table: { name: 'class_student', schema: 'public' },
        },
      },
      rel_name: 'class_students',
      table_name: 'class',
      table_schema: 'public',
      rel_type: 'array' as const,
    },
    {
      rel_def: { foreign_key_constraint_on: 'enum_relation' },
      rel_name: 'an_enum',
      table_name: 'class',
      table_schema: 'public',
      rel_type: 'object' as const,
    },
    {
      rel_def: {
        manual_configuration: {
          column_mapping: { id: 'id' },
          insertion_order: null,
          remote_table: { name: 'identitytest', schema: 'public' },
        },
      },
      rel_name: 'object_relationship',
      table_name: 'class',
      table_schema: 'public',
      rel_type: 'object' as const,
    },
  ],
  permissions: [
    {
      role_name: 'asdf',
      permissions: {
        select: {
          columns: ['id'],
          filter: { enum_relation: { _is_null: true } },
        },
      },
      table_name: 'class',
      table_schema: 'public',
    },
    {
      role_name: 'new',
      permissions: {
        select: {
          columns: [],
          filter: {
            _exists: {
              _table: { name: 'class_student', schema: 'public' },
              _where: {
                classByClass: { teacher: { _clte: ['$', 'teacher'] } },
              },
            },
          },
        },
        delete: { filter: { teacher: { _eq: 'X-Hasura-User-Id' } } },
      },
      table_name: 'class',
      table_schema: 'public',
    },
    {
      role_name: 'user',
      permissions: {
        select: {
          columns: ['id'],
          filter: { _not: { id: { _eq: 1 } } },
          allow_aggregations: true,
          query_root_fields: ['select_aggregate', 'select', 'select_by_pk'],
          subscription_root_fields: ['select', 'select_stream'],
        },
        delete: { filter: { id: { _eq: 1 } } },
      },
      table_name: 'class',
      table_schema: 'public',
    },
  ],
  unique_constraints: [],
  check_constraints: [],
  foreign_key_constraints: [
    {
      table_schema: 'public',
      table_name: 'class',
      constraint_name: 'class_enum_relation_fkey',
      ref_table_table_schema: 'public',
      ref_table: 'an_enum',
      column_mapping: { enum_relation: 'name' },
      on_update: 'r',
      on_delete: 'r',
      is_table_tracked: true,
      is_ref_table_tracked: true,
    },
  ],
  opp_foreign_key_constraints: [
    {
      table_schema: 'public',
      table_name: 'class_student',
      constraint_name: 'class_student_class_fkey',
      ref_table_table_schema: 'public',
      ref_table: 'class',
      column_mapping: { class: 'id' },
      on_update: 'r',
      on_delete: 'r',
      is_table_tracked: true,
      is_ref_table_tracked: true,
    },
  ],
  view_info: null,
  remote_relationships: [
    {
      remote_relationship_name: 'Album_Artists',
      table_name: 'class',
      table_schema: 'public',
      definition: {
        to_source: {
          field_mapping: { teacher: 'Title' },
          relationship_type: 'object',
          source: 'Chinook',
          table: ['Album'],
        },
      },
    },
  ],
  is_enum: false,
  is_apollo_federation_supported: false,
  configuration: {} as Table['configuration'],
  computed_fields: [],
} as any;

export const objectAllTables = [
  {
    table_schema: 'public',
    table_name: 'testing',
    table_type: 'TABLE' as const,
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'testing',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('testing_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'jsonb',
        table_name: 'testing',
        column_name: 'metadata',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'jsonb',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'timestamp with time zone',
        table_name: 'testing',
        column_name: 'deleted_at',
        is_nullable: 'YES',
        table_schema: 'public',
        column_default: 'now()',
        data_type_name: 'timestamptz',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'testing',
      constraint_name: 'testing_pkey',
      columns: ['id'],
    },
    relationships: [],
    permissions: [
      {
        role_name: 'user',
        permissions: {
          insert: { check: {}, columns: ['id', 'metadata', 'deleted_at'] },
          update: { columns: ['id', 'metadata'], filter: {}, check: {} },
          select: {
            columns: ['deleted_at', 'id', 'metadata'],
            filter: { deleted_at: { _is_null: true } },
            allow_aggregations: true,
          },
        },
        table_name: 'testing',
        table_schema: 'public',
      },
      {
        role_name: 'asdf',
        permissions: {
          select: { columns: ['id', 'metadata', 'deleted_at'], filter: {} },
        },
        table_name: 'testing',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'user',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'user',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('user_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'user',
        column_name: 'name',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'timestamp with time zone',
        table_name: 'user',
        column_name: 'deleted_at',
        is_nullable: 'YES',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'timestamptz',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'user',
      constraint_name: 'user_pkey',
      columns: ['id'],
    },
    relationships: [
      {
        rel_def: {
          foreign_key_constraint_on: {
            column: 'student_id',
            table: { name: 'class_student', schema: 'public' },
          },
        },
        rel_name: 'class_students',
        table_name: 'user',
        table_schema: 'public',
        rel_type: 'array',
      },
    ],
    permissions: [
      {
        role_name: 'sdfsf',
        permissions: {
          select: {
            columns: ['id', 'name', 'deleted_at'],
            filter: { _or: [] },
            query_root_fields: ['select', 'select_by_pk'],
            subscription_root_fields: ['select', 'select_by_pk'],
          },
        },
        table_name: 'user',
        table_schema: 'public',
      },
      {
        role_name: 'user',
        permissions: {
          select: {
            columns: ['deleted_at', 'id', 'name'],
            filter: { deleted_at: { _is_null: true } },
            query_root_fields: ['select', 'select_by_pk'],
            subscription_root_fields: ['select', 'select_by_pk'],
          },
        },
        table_name: 'user',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class_student',
        constraint_name: 'class_student_student_id_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'user',
        column_mapping: { student_id: 'id' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'class',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'class',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('class_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'class',
        column_name: 'enum_relation',
        is_nullable: 'YES',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'class',
        column_name: 'teacher',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'class',
      constraint_name: 'class_pkey',
      columns: ['id'],
    },
    relationships: [
      {
        rel_def: {
          foreign_key_constraint_on: {
            column: 'class',
            table: { name: 'class_student', schema: 'public' },
          },
        },
        rel_name: 'class_students',
        table_name: 'class',
        table_schema: 'public',
        rel_type: 'array',
      },
      {
        rel_def: { foreign_key_constraint_on: 'enum_relation' },
        rel_name: 'an_enum',
        table_name: 'class',
        table_schema: 'public',
        rel_type: 'object',
      },
      {
        rel_def: {
          manual_configuration: {
            column_mapping: { id: 'id' },
            insertion_order: null,
            remote_table: { name: 'identitytest', schema: 'public' },
          },
        },
        rel_name: 'object_relationship',
        table_name: 'class',
        table_schema: 'public',
        rel_type: 'object',
      },
    ],
    permissions: [
      {
        role_name: 'asdf',
        permissions: {
          select: {
            columns: ['id'],
            filter: { enum_relation: { _is_null: true } },
          },
        },
        table_name: 'class',
        table_schema: 'public',
      },
      {
        role_name: 'new',
        permissions: {
          select: {
            columns: [],
            filter: {
              _exists: {
                _table: { name: 'class_student', schema: 'public' },
                _where: {
                  classByClass: { teacher: { _clte: ['$', 'teacher'] } },
                },
              },
            },
          },
          delete: { filter: { teacher: { _eq: 'X-Hasura-User-Id' } } },
        },
        table_name: 'class',
        table_schema: 'public',
      },
      {
        role_name: 'user',
        permissions: {
          select: {
            columns: ['id'],
            filter: { _not: { id: { _eq: 1 } } },
            allow_aggregations: true,
            query_root_fields: ['select_aggregate', 'select', 'select_by_pk'],
            subscription_root_fields: ['select', 'select_stream'],
          },
          delete: { filter: { id: { _eq: 1 } } },
        },
        table_name: 'class',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class',
        constraint_name: 'class_enum_relation_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'an_enum',
        column_mapping: { enum_relation: 'name' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    opp_foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class_student',
        constraint_name: 'class_student_class_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'class',
        column_mapping: { class: 'id' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    view_info: null,
    remote_relationships: [
      {
        remote_relationship_name: 'Album_Artists',
        table_name: 'class',
        table_schema: 'public',
        definition: {
          to_source: {
            field_mapping: { teacher: 'Title' },
            relationship_type: 'object',
            source: 'Chinook',
            table: ['Album'],
          },
        },
      },
    ],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'class_student',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'class_student',
        column_name: 'class',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'int4',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'integer',
        table_name: 'class_student',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('class_student_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'integer',
        table_name: 'class_student',
        column_name: 'student_id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'int4',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'class_student',
      constraint_name: 'class_student_pkey',
      columns: ['id'],
    },
    relationships: [
      {
        rel_def: { foreign_key_constraint_on: 'class' },
        rel_name: 'classByClass',
        table_name: 'class_student',
        table_schema: 'public',
        rel_type: 'object',
      },
      {
        rel_def: { foreign_key_constraint_on: 'student_id' },
        rel_name: 'user',
        table_name: 'class_student',
        table_schema: 'public',
        rel_type: 'object',
      },
    ],
    permissions: [
      {
        role_name: 'new',
        permissions: {
          select: {
            columns: ['class', 'id'],
            filter: {},
            allow_aggregations: true,
            query_root_fields: ['select_aggregate', 'select', 'select_by_pk'],
            subscription_root_fields: [
              'select_aggregate',
              'select',
              'select_by_pk',
            ],
          },
        },
        table_name: 'class_student',
        table_schema: 'public',
      },
      {
        role_name: 'user',
        permissions: {
          select: {
            columns: ['class', 'id', 'student_id'],
            filter: {},
            allow_aggregations: true,
          },
        },
        table_name: 'class_student',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class_student',
        constraint_name: 'class_student_class_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'class',
        column_mapping: { class: 'id' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
      {
        table_schema: 'public',
        table_name: 'class_student',
        constraint_name: 'class_student_student_id_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'user',
        column_mapping: { student_id: 'id' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'identitytest',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'identitytest',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('identitytest_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'identitytest',
        column_name: 'identity',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'identitytest',
      constraint_name: 'identitytest_pkey',
      columns: ['id'],
    },
    relationships: [],
    permissions: [],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'testtest',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'testtest',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('testtest_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'integer',
        table_name: 'testtest',
        column_name: 'user_id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'int4',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'testtest',
        column_name: 'name',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'testtest',
      constraint_name: 'testtest_pkey',
      columns: ['id'],
    },
    relationships: [],
    permissions: [
      {
        role_name: 'asdf',
        permissions: { select: { columns: ['id', 'name'], filter: {} } },
        table_name: 'testtest',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'some_table',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'uuid',
        table_name: 'some_table',
        column_name: 'ID',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: 'gen_random_uuid()',
        data_type_name: 'uuid',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'uuid',
        table_name: 'some_table',
        column_name: 'ID2',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: 'gen_random_uuid()',
        data_type_name: 'uuid',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'some_table',
      constraint_name: 'some_table_pkey',
      columns: ['ID2', 'ID'],
    },
    relationships: [],
    permissions: [],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'an_enum',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'text',
        table_name: 'an_enum',
        column_name: 'desc',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'an_enum',
        column_name: 'name',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'an_enum',
      constraint_name: 'an_enum_pkey',
      columns: ['name'],
    },
    relationships: [],
    permissions: [],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [
      {
        table_schema: 'public',
        table_name: 'class',
        constraint_name: 'class_enum_relation_fkey',
        ref_table_table_schema: 'public',
        ref_table: 'an_enum',
        column_mapping: { enum_relation: 'name' },
        on_update: 'r',
        on_delete: 'r',
        is_table_tracked: true,
        is_ref_table_tracked: true,
      },
    ],
    view_info: null,
    remote_relationships: [],
    is_enum: true,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
  {
    table_schema: 'public',
    table_name: 'perm_test',
    table_type: 'TABLE',
    is_table_tracked: true,
    columns: [
      {
        comment: null,
        data_type: 'integer',
        table_name: 'perm_test',
        column_name: 'id',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: "nextval('perm_test_id_seq'::regclass)",
        data_type_name: 'int4',
        ordinal_position: 1,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'perm_test',
        column_name: 'name',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 2,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
      {
        comment: null,
        data_type: 'text',
        table_name: 'perm_test',
        column_name: 'surname',
        is_nullable: 'NO',
        table_schema: 'public',
        column_default: null,
        data_type_name: 'text',
        ordinal_position: 3,
        is_generated: false,
        is_identity: false,
        identity_generation: null,
      },
    ],
    comment: null,
    triggers: [],
    primary_key: {
      table_schema: 'public',
      table_name: 'perm_test',
      constraint_name: 'perm_test_pkey',
      columns: ['id'],
    },
    relationships: [],
    permissions: [
      {
        role_name: 'user',
        permissions: {
          select: {
            columns: ['id', 'name'],
            filter: { id: { _eq: 'X-Hasura-User-Id' } },
          },
        },
        table_name: 'perm_test',
        table_schema: 'public',
      },
    ],
    unique_constraints: [],
    check_constraints: [],
    foreign_key_constraints: [],
    opp_foreign_key_constraints: [],
    view_info: null,
    remote_relationships: [],
    is_enum: false,
    is_apollo_federation_supported: false,
    configuration: {},
    computed_fields: [],
  },
] as any;
