import React from 'react';

type LogoModes = 'default' | 'primary' | 'brand';
type LogoSize = 'sm' | 'md' | 'lg';

type Props = {
  /**
   * The logo size
   */
  size?: LogoSize;
  /**
   * The logo mode
   */
  mode?: LogoModes;
};

const logoSizing: Record<LogoSize, string> = {
  sm: 'h-8 mx-1.5',
  md: 'h-14 mx-2',
  lg: 'h-20 mx-2',
};

const logoModesStyles: Record<LogoModes, string> = {
  default: 'black',
  primary: 'white',
  brand: '#1eb4d4',
};

export function HasuraLogoFull(props: Props) {
  const { size = 'md', mode = 'default' } = props;

  const logoFill = logoModesStyles[mode];
  const textFill = mode === 'brand' ? 'black' : logoModesStyles[mode];

  return (
    <svg
      className={logoSizing[size]}
      viewBox="0 0 285 84"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_5273_22707)">
        <path
          d="M81.771 28.7984C84.2262 21.3329 82.7493 6.43933 77.9917 0.940859C77.3682 0.219597 76.208 0.322635 75.6899 1.11883L69.8299 10.1018C68.3814 11.9003 65.7727 12.3125 63.8061 11.0573C57.4471 6.99198 49.8511 4.63147 41.6889 4.63147C33.5267 4.63147 25.9304 6.99198 19.5714 11.0573C17.6148 12.3125 15.006 11.8909 13.5481 10.1018L7.68787 1.11883C7.16996 0.322635 6.00938 0.228964 5.38597 0.940859C0.628701 6.44866 -0.848352 21.3422 1.60701 28.7984C2.42227 31.2807 2.64287 33.9035 2.16331 36.4513C1.68374 38.9804 1.20418 42.0341 1.20418 44.1603C1.20418 65.9951 19.3316 83.689 41.6793 83.689C64.0365 83.689 82.1542 65.9858 82.1542 44.1603C82.1542 42.0341 81.6749 38.9804 81.1955 36.4513C80.7254 33.9035 80.9553 31.2807 81.771 28.7984ZM41.6793 74.8658C24.3959 74.8658 10.3447 61.1334 10.3447 44.2541C10.3447 43.7014 10.3638 43.1581 10.3926 42.6148C11.016 31.1121 18.1711 21.2861 28.2899 16.6026C32.347 14.7104 36.8933 13.6613 41.6889 13.6613C46.4845 13.6613 51.0212 14.7104 55.088 16.6119C65.2066 21.2954 72.3616 31.1308 72.9851 42.6242C73.014 43.1675 73.0331 43.7201 73.0331 44.2634C73.0233 61.1334 58.9628 74.8658 41.6793 74.8658Z"
          fill={logoFill}
        />
        <path
          d="M55.2591 56.0378L47.2505 42.4741L40.3832 31.1681C40.2201 30.8965 39.9228 30.7372 39.6063 30.7372H33.0459C32.7197 30.7372 32.4224 30.9058 32.2594 31.1869C32.0963 31.4585 32.1059 31.7957 32.269 32.0673L38.839 42.8488L30.0246 55.9816C29.8424 56.2533 29.8328 56.5996 29.9863 56.8806C30.1397 57.1615 30.4466 57.3398 30.7823 57.3398H37.3907C37.6976 57.3398 37.9854 57.1898 38.1484 56.9367L42.9153 49.668L47.1929 56.9089C47.356 57.1806 47.6533 57.3491 47.9699 57.3491H54.4823C54.8082 57.3491 55.1057 57.1806 55.2591 56.9089C55.4224 56.6466 55.4224 56.3095 55.2591 56.0378Z"
          fill={logoFill}
        />
        <path
          d="M119.484 21.5306H127.838V66.2673H119.484V47.2056H110.046V66.2771H101.692V21.5306H110.046V40.9578H119.484V21.5306Z"
          fill={textFill}
        />
        <path
          d="M153.61 66.276L151.864 56.9842H141.842L140.24 66.276H131.886L141.103 21.5391H152.353L162.012 66.276H153.61ZM142.935 50.811H150.704L146.714 29.398L142.935 50.811Z"
          fill={textFill}
        />
        <path
          d="M180.619 58.1171V48.5442C180.619 47.7855 180.476 47.2797 180.188 47.0174C179.9 46.7551 179.363 46.624 178.586 46.624H172.707C167.719 46.624 165.226 44.2635 165.226 39.5331V28.555C165.226 23.8714 167.834 21.5391 173.061 21.5391H181.051C186.278 21.5391 188.887 23.8808 188.887 28.555V34.7934H180.466V29.6884C180.466 28.9296 180.322 28.4238 180.035 28.1615C179.747 27.8993 179.21 27.7682 178.433 27.7682H175.671C174.846 27.7682 174.289 27.8993 174.002 28.1615C173.714 28.4238 173.57 28.9296 173.57 29.6884V38.6901C173.57 39.4488 173.714 39.9546 174.002 40.2169C174.289 40.4792 174.846 40.6103 175.671 40.6103H181.406C186.489 40.6103 189.031 42.924 189.031 47.5607V59.2603C189.031 63.9436 186.394 66.276 181.118 66.276H173.273C167.998 66.276 165.36 63.9343 165.36 59.2603V53.0872H173.704V58.1171C173.704 58.8758 173.848 59.382 174.136 59.6443C174.424 59.9062 174.98 60.0376 175.805 60.0376H178.567C179.344 60.0376 179.871 59.9062 180.169 59.6443C180.466 59.382 180.619 58.8758 180.619 58.1171Z"
          fill={textFill}
        />
        <path
          d="M211.32 21.5306H219.664V59.2516C219.664 63.9349 217.027 66.2673 211.752 66.2673H202.899C197.624 66.2673 194.986 63.9256 194.986 59.2516V21.5306H203.34V58.1182C203.34 58.8769 203.484 59.3826 203.772 59.6449C204.059 59.9073 204.597 60.0382 205.374 60.0382H209.219C210.044 60.0382 210.601 59.9073 210.888 59.6449C211.176 59.3826 211.32 58.8769 211.32 58.1182V21.5306Z"
          fill={textFill}
        />
        <path
          d="M234.914 48.8355V66.2771H226.569V21.5306H243.412C248.687 21.5306 251.324 23.8723 251.324 28.5465V41.8102C251.324 45.6882 249.56 47.955 246.021 48.62L253.646 66.2771H244.64L237.667 48.8355H234.914ZM234.914 27.769V42.8031H240.937C241.714 42.8031 242.242 42.672 242.539 42.4097C242.827 42.1474 242.97 41.6416 242.97 40.8829V29.6893C242.97 28.9305 242.827 28.4247 242.539 28.1624C242.251 27.9001 241.714 27.769 240.937 27.769H234.914Z"
          fill={textFill}
        />
        <path
          d="M276.589 66.276L274.843 56.9842H264.82L263.218 66.276H254.874L264.091 21.5391H275.342L285 66.276H276.589ZM265.923 50.811H273.692L269.702 29.398L265.923 50.811Z"
          fill={textFill}
        />
      </g>
      <defs>
        <clipPath id="clip0_5273_22707">
          <rect width="285" height="84" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}
