/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	serviceprofilev1alpha1 "github.com/linkerd/linkerd2/controller/gen/apis/serviceprofile/v1alpha1"
	versioned "github.com/linkerd/linkerd2/controller/gen/client/clientset/versioned"
	internalinterfaces "github.com/linkerd/linkerd2/controller/gen/client/informers/externalversions/internalinterfaces"
	v1alpha1 "github.com/linkerd/linkerd2/controller/gen/client/listers/serviceprofile/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// ServiceProfileInformer provides access to a shared informer and lister for
// ServiceProfiles.
type ServiceProfileInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.ServiceProfileLister
}

type serviceProfileInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewServiceProfileInformer constructs a new informer for ServiceProfile type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewServiceProfileInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredServiceProfileInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredServiceProfileInformer constructs a new informer for ServiceProfile type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredServiceProfileInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.LinkerdV1alpha1().ServiceProfiles(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.LinkerdV1alpha1().ServiceProfiles(namespace).Watch(options)
			},
		},
		&serviceprofilev1alpha1.ServiceProfile{},
		resyncPeriod,
		indexers,
	)
}

func (f *serviceProfileInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredServiceProfileInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *serviceProfileInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&serviceprofilev1alpha1.ServiceProfile{}, f.defaultInformer)
}

func (f *serviceProfileInformer) Lister() v1alpha1.ServiceProfileLister {
	return v1alpha1.NewServiceProfileLister(f.Informer().GetIndexer())
}
