# Linkerd Governance

This document defines project governance for Linkerd.

## Roles

There are two roles that convey decision-making powers: maintainer and
super-maintainer. MAINTAINERS.md defines the membership of these roles.

## Expectations

Maintainers are responsible for one or more components, and are expected to
contribute code, field incoming PRs, triage issues, proactively fix bugs, and
generally perform maintainance tasks for these components.

Super-maintainers are responsible for the project as a whole, and are expected
to guide general project direction as well as being the final reviewer on PRs.

## Decisionmaking

Ideally, all project decisions are resolved by consensus. If this is not
possible, maintainers may call a vote. Unless otherwise specified in this
document, the vote will be decided by a simple majority in which each
super-maintainer receives two votes and each maintainer receives one vote.

## Changes in Maintainership

New maintainers must be proposed by an existing maintainer and must be elected
by a 2/3 majority organization vote. Maintainers can be removed by a 2/3
majority organization vote.

Super-maintainers must be proposed by an existing super-maintainer and must be
elected by a 2/3 majority organization vote. Super-maintainers can be removed
by a 2/3 majority organization vote.

## GitHub Project Administration

Maintainers will be added to the linkerd GitHub organization, and be made an
owner of the GitHub organization.

## Approving PRs

All PRs must receive approval from at least one super maintainer before merge.

## Changes in Governance

All changes in Governance require a 2/3 majority organization vote.

