/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/linkerd/linkerd2/controller/gen/apis/serviceprofile/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeServiceProfiles implements ServiceProfileInterface
type FakeServiceProfiles struct {
	Fake *FakeLinkerdV1alpha1
	ns   string
}

var serviceprofilesResource = schema.GroupVersionResource{Group: "linkerd.io", Version: "v1alpha1", Resource: "serviceprofiles"}

var serviceprofilesKind = schema.GroupVersionKind{Group: "linkerd.io", Version: "v1alpha1", Kind: "ServiceProfile"}

// Get takes name of the serviceProfile, and returns the corresponding serviceProfile object, and an error if there is any.
func (c *FakeServiceProfiles) Get(name string, options v1.GetOptions) (result *v1alpha1.ServiceProfile, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(serviceprofilesResource, c.ns, name), &v1alpha1.ServiceProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ServiceProfile), err
}

// List takes label and field selectors, and returns the list of ServiceProfiles that match those selectors.
func (c *FakeServiceProfiles) List(opts v1.ListOptions) (result *v1alpha1.ServiceProfileList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(serviceprofilesResource, serviceprofilesKind, c.ns, opts), &v1alpha1.ServiceProfileList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ServiceProfileList{ListMeta: obj.(*v1alpha1.ServiceProfileList).ListMeta}
	for _, item := range obj.(*v1alpha1.ServiceProfileList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested serviceProfiles.
func (c *FakeServiceProfiles) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(serviceprofilesResource, c.ns, opts))

}

// Create takes the representation of a serviceProfile and creates it.  Returns the server's representation of the serviceProfile, and an error, if there is any.
func (c *FakeServiceProfiles) Create(serviceProfile *v1alpha1.ServiceProfile) (result *v1alpha1.ServiceProfile, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(serviceprofilesResource, c.ns, serviceProfile), &v1alpha1.ServiceProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ServiceProfile), err
}

// Update takes the representation of a serviceProfile and updates it. Returns the server's representation of the serviceProfile, and an error, if there is any.
func (c *FakeServiceProfiles) Update(serviceProfile *v1alpha1.ServiceProfile) (result *v1alpha1.ServiceProfile, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(serviceprofilesResource, c.ns, serviceProfile), &v1alpha1.ServiceProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ServiceProfile), err
}

// Delete takes name of the serviceProfile and deletes it. Returns an error if one occurs.
func (c *FakeServiceProfiles) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(serviceprofilesResource, c.ns, name), &v1alpha1.ServiceProfile{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeServiceProfiles) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(serviceprofilesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.ServiceProfileList{})
	return err
}

// Patch applies the patch and returns the patched serviceProfile.
func (c *FakeServiceProfiles) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ServiceProfile, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(serviceprofilesResource, c.ns, name, data, subresources...), &v1alpha1.ServiceProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ServiceProfile), err
}
