import './../../../css/svg-wrappers.css';

import React from 'react';

export const slackIcon = (
  <svg style={{"width":"24px", "height":"24px"}} viewBox="0 0 24 24">
    <path fill="#757575" d="M10.23,11.16L12.91,10.27L13.77,12.84L11.09,13.73L10.23,11.16M17.69,13.71C18.23,13.53 18.5,12.94 18.34,12.4C18.16,11.86 17.57,11.56 17.03,11.75L15.73,12.18L14.87,9.61L16.17,9.17C16.71,9 17,8.4 16.82,7.86C16.64,7.32 16.05,7 15.5,7.21L14.21,7.64L13.76,6.3C13.58,5.76 13,5.46 12.45,5.65C11.91,5.83 11.62,6.42 11.8,6.96L12.25,8.3L9.57,9.19L9.12,7.85C8.94,7.31 8.36,7 7.81,7.2C7.27,7.38 7,7.97 7.16,8.5L7.61,9.85L6.31,10.29C5.77,10.47 5.5,11.06 5.66,11.6C5.8,12 6.19,12.3 6.61,12.31L6.97,12.25L8.27,11.82L9.13,14.39L7.83,14.83C7.29,15 7,15.6 7.18,16.14C7.32,16.56 7.71,16.84 8.13,16.85L8.5,16.79L9.79,16.36L10.24,17.7C10.38,18.13 10.77,18.4 11.19,18.41L11.55,18.35C12.09,18.17 12.38,17.59 12.2,17.04L11.75,15.7L14.43,14.81L14.88,16.15C15,16.57 15.41,16.84 15.83,16.85L16.19,16.8C16.73,16.62 17,16.03 16.84,15.5L16.39,14.15L17.69,13.71M21.17,9.25C23.23,16.12 21.62,19.1 14.75,21.17C7.88,23.23 4.9,21.62 2.83,14.75C0.77,7.88 2.38,4.9 9.25,2.83C16.12,0.77 19.1,2.38 21.17,9.25Z" />
  </svg>
);

export const githubIcon = (
  <svg style={{"width":"24px", "height":"24px"}} viewBox="0 0 24 24">
    <path fill="#757575" d="M12,2A10,10 0 0,0 2,12C2,16.42 4.87,20.17 8.84,21.5C9.34,21.58 9.5,21.27 9.5,21C9.5,20.77 9.5,20.14 9.5,19.31C6.73,19.91 6.14,17.97 6.14,17.97C5.68,16.81 5.03,16.5 5.03,16.5C4.12,15.88 5.1,15.9 5.1,15.9C6.1,15.97 6.63,16.93 6.63,16.93C7.5,18.45 8.97,18 9.54,17.76C9.63,17.11 9.89,16.67 10.17,16.42C7.95,16.17 5.62,15.31 5.62,11.5C5.62,10.39 6,9.5 6.65,8.79C6.55,8.54 6.2,7.5 6.75,6.15C6.75,6.15 7.59,5.88 9.5,7.17C10.29,6.95 11.15,6.84 12,6.84C12.85,6.84 13.71,6.95 14.5,7.17C16.41,5.88 17.25,6.15 17.25,6.15C17.8,7.5 17.45,8.54 17.35,8.79C18,9.5 18.38,10.39 18.38,11.5C18.38,15.32 16.04,16.16 13.81,16.41C14.17,16.72 14.5,17.33 14.5,18.26C14.5,19.6 14.5,20.68 14.5,21C14.5,21.27 14.66,21.59 15.17,21.5C19.14,20.16 22,16.42 22,12A10,10 0 0,0 12,2Z" />
  </svg>
);

export const grafanaIcon = (
  <svg
    version="1.1"
    id="Layer_1"
    x="0px"
    y="0px"
    width="15px"
    height="15px"
    viewBox="0 0 351 365"
    style={{"enableBackground:": "new 0 0 351 365"}}
    xmlSpace="preserve">
    <g id="Layer_1_1_" />
    <linearGradient id="SVGID_1_grafana" gradientUnits="userSpaceOnUse" x1="175.5" y1="445.4948" x2="175.5" y2="114.0346">
      <stop  offset="0" style={{"stopColor":"#FFF100"}} />
      <stop  offset="1" style={{"stopColor":"#F05A28"}} />
    </linearGradient>
    <path
      className="grafana-st0"
      d="M342,161.2c-0.6-6.1-1.6-13.1-3.6-20.9c-2-7.7-5-16.2-9.4-25c-4.4-8.8-10.1-17.9-17.5-26.8	c-2.9-3.5-6.1-6.9-9.5-10.2c5.1-20.3-6.2-37.9-6.2-37.9c-19.5-1.2-31.9,6.1-36.5,9.4c-0.8-0.3-1.5-0.7-2.3-1	c-3.3-1.3-6.7-2.6-10.3-3.7c-3.5-1.1-7.1-2.1-10.8-3c-3.7-0.9-7.4-1.6-11.2-2.2c-0.7-0.1-1.3-0.2-2-0.3	c-8.5-27.2-32.9-38.6-32.9-38.6c-27.3,17.3-32.4,41.5-32.4,41.5s-0.1,0.5-0.3,1.4c-1.5,0.4-3,0.9-4.5,1.3c-2.1,0.6-4.2,1.4-6.2,2.2	c-2.1,0.8-4.1,1.6-6.2,2.5c-4.1,1.8-8.2,3.8-12.2,6c-3.9,2.2-7.7,4.6-11.4,7.1c-0.5-0.2-1-0.4-1-0.4c-37.8-14.4-71.3,2.9-71.3,2.9	c-3.1,40.2,15.1,65.5,18.7,70.1c-0.9,2.5-1.7,5-2.5,7.5c-2.8,9.1-4.9,18.4-6.2,28.1c-0.2,1.4-0.4,2.8-0.5,4.2	C18.8,192.7,8.5,228,8.5,228c29.1,33.5,63.1,35.6,63.1,35.6c0,0,0.1-0.1,0.1-0.1c4.3,7.7,9.3,15,14.9,21.9c2.4,2.9,4.8,5.6,7.4,8.3	c-10.6,30.4,1.5,55.6,1.5,55.6c32.4,1.2,53.7-14.2,58.2-17.7c3.2,1.1,6.5,2.1,9.8,2.9c10,2.6,20.2,4.1,30.4,4.5	c2.5,0.1,5.1,0.2,7.6,0.1l1.2,0l0.8,0l1.6,0l1.6-0.1l0,0.1c15.3,21.8,42.1,24.9,42.1,24.9c19.1-20.1,20.2-40.1,20.2-44.4l0,0	c0,0,0-0.1,0-0.3c0-0.4,0-0.6,0-0.6l0,0c0-0.3,0-0.6,0-0.9c4-2.8,7.8-5.8,11.4-9.1c7.6-6.9,14.3-14.8,19.9-23.3	c0.5-0.8,1-1.6,1.5-2.4c21.6,1.2,36.9-13.4,36.9-13.4c-3.6-22.5-16.4-33.5-19.1-35.6l0,0c0,0-0.1-0.1-0.3-0.2	c-0.2-0.1-0.2-0.2-0.2-0.2c0,0,0,0,0,0c-0.1-0.1-0.3-0.2-0.5-0.3c0.1-1.4,0.2-2.7,0.3-4.1c0.2-2.4,0.2-4.9,0.2-7.3l0-1.8l0-0.9	l0-0.5c0-0.6,0-0.4,0-0.6l-0.1-1.5l-0.1-2c0-0.7-0.1-1.3-0.2-1.9c-0.1-0.6-0.1-1.3-0.2-1.9l-0.2-1.9l-0.3-1.9	c-0.4-2.5-0.8-4.9-1.4-7.4c-2.3-9.7-6.1-18.9-11-27.2c-5-8.3-11.2-15.6-18.3-21.8c-7-6.2-14.9-11.2-23.1-14.9	c-8.3-3.7-16.9-6.1-25.5-7.2c-4.3-0.6-8.6-0.8-12.9-0.7l-1.6,0l-0.4,0c-0.1,0-0.6,0-0.5,0l-0.7,0l-1.6,0.1c-0.6,0-1.2,0.1-1.7,0.1	c-2.2,0.2-4.4,0.5-6.5,0.9c-8.6,1.6-16.7,4.7-23.8,9c-7.1,4.3-13.3,9.6-18.3,15.6c-5,6-8.9,12.7-11.6,19.6c-2.7,6.9-4.2,14.1-4.6,21	c-0.1,1.7-0.1,3.5-0.1,5.2c0,0.4,0,0.9,0,1.3l0.1,1.4c0.1,0.8,0.1,1.7,0.2,2.5c0.3,3.5,1,6.9,1.9,10.1c1.9,6.5,4.9,12.4,8.6,17.4	c3.7,5,8.2,9.1,12.9,12.4c4.7,3.2,9.8,5.5,14.8,7c5,1.5,10,2.1,14.7,2.1c0.6,0,1.2,0,1.7,0c0.3,0,0.6,0,0.9,0c0.3,0,0.6,0,0.9-0.1	c0.5,0,1-0.1,1.5-0.1c0.1,0,0.3,0,0.4-0.1l0.5-0.1c0.3,0,0.6-0.1,0.9-0.1c0.6-0.1,1.1-0.2,1.7-0.3c0.6-0.1,1.1-0.2,1.6-0.4	c1.1-0.2,2.1-0.6,3.1-0.9c2-0.7,4-1.5,5.7-2.4c1.8-0.9,3.4-2,5-3c0.4-0.3,0.9-0.6,1.3-1c1.6-1.3,1.9-3.7,0.6-5.3	c-1.1-1.4-3.1-1.8-4.7-0.9c-0.4,0.2-0.8,0.4-1.2,0.6c-1.4,0.7-2.8,1.3-4.3,1.8c-1.5,0.5-3.1,0.9-4.7,1.2c-0.8,0.1-1.6,0.2-2.5,0.3	c-0.4,0-0.8,0.1-1.3,0.1c-0.4,0-0.9,0-1.2,0c-0.4,0-0.8,0-1.2,0c-0.5,0-1,0-1.5-0.1c0,0-0.3,0-0.1,0l-0.2,0l-0.3,0	c-0.2,0-0.5,0-0.7-0.1c-0.5-0.1-0.9-0.1-1.4-0.2c-3.7-0.5-7.4-1.6-10.9-3.2c-3.6-1.6-7-3.8-10.1-6.6c-3.1-2.8-5.8-6.1-7.9-9.9	c-2.1-3.8-3.6-8-4.3-12.4c-0.3-2.2-0.5-4.5-0.4-6.7c0-0.6,0.1-1.2,0.1-1.8c0,0.2,0-0.1,0-0.1l0-0.2l0-0.5c0-0.3,0.1-0.6,0.1-0.9	c0.1-1.2,0.3-2.4,0.5-3.6c1.7-9.6,6.5-19,13.9-26.1c1.9-1.8,3.9-3.4,6-4.9c2.1-1.5,4.4-2.8,6.8-3.9c2.4-1.1,4.8-2,7.4-2.7	c2.5-0.7,5.1-1.1,7.8-1.4c1.3-0.1,2.6-0.2,4-0.2c0.4,0,0.6,0,0.9,0l1.1,0l0.7,0c0.3,0,0,0,0.1,0l0.3,0l1.1,0.1	c2.9,0.2,5.7,0.6,8.5,1.3c5.6,1.2,11.1,3.3,16.2,6.1c10.2,5.7,18.9,14.5,24.2,25.1c2.7,5.3,4.6,11,5.5,16.9c0.2,1.5,0.4,3,0.5,4.5	l0.1,1.1l0.1,1.1c0,0.4,0,0.8,0,1.1c0,0.4,0,0.8,0,1.1l0,1l0,1.1c0,0.7-0.1,1.9-0.1,2.6c-0.1,1.6-0.3,3.3-0.5,4.9	c-0.2,1.6-0.5,3.2-0.8,4.8c-0.3,1.6-0.7,3.2-1.1,4.7c-0.8,3.1-1.8,6.2-3,9.3c-2.4,6-5.6,11.8-9.4,17.1	c-7.7,10.6-18.2,19.2-30.2,24.7c-6,2.7-12.3,4.7-18.8,5.7c-3.2,0.6-6.5,0.9-9.8,1l-0.6,0l-0.5,0l-1.1,0l-1.6,0l-0.8,0	c0.4,0-0.1,0-0.1,0l-0.3,0c-1.8,0-3.5-0.1-5.3-0.3c-7-0.5-13.9-1.8-20.7-3.7c-6.7-1.9-13.2-4.6-19.4-7.8	c-12.3-6.6-23.4-15.6-32-26.5c-4.3-5.4-8.1-11.3-11.2-17.4c-3.1-6.1-5.6-12.6-7.4-19.1c-1.8-6.6-2.9-13.3-3.4-20.1l-0.1-1.3l0-0.3	l0-0.3l0-0.6l0-1.1l0-0.3l0-0.4l0-0.8l0-1.6l0-0.3c0,0,0,0.1,0-0.1l0-0.6c0-0.8,0-1.7,0-2.5c0.1-3.3,0.4-6.8,0.8-10.2	c0.4-3.4,1-6.9,1.7-10.3c0.7-3.4,1.5-6.8,2.5-10.2c1.9-6.7,4.3-13.2,7.1-19.3c5.7-12.2,13.1-23.1,22-31.8c2.2-2.2,4.5-4.2,6.9-6.2	c2.4-1.9,4.9-3.7,7.5-5.4c2.5-1.7,5.2-3.2,7.9-4.6c1.3-0.7,2.7-1.4,4.1-2c0.7-0.3,1.4-0.6,2.1-0.9c0.7-0.3,1.4-0.6,2.1-0.9	c2.8-1.2,5.7-2.2,8.7-3.1c0.7-0.2,1.5-0.4,2.2-0.7c0.7-0.2,1.5-0.4,2.2-0.6c1.5-0.4,3-0.8,4.5-1.1c0.7-0.2,1.5-0.3,2.3-0.5	c0.8-0.2,1.5-0.3,2.3-0.5c0.8-0.1,1.5-0.3,2.3-0.4l1.1-0.2l1.2-0.2c0.8-0.1,1.5-0.2,2.3-0.3c0.9-0.1,1.7-0.2,2.6-0.3	c0.7-0.1,1.9-0.2,2.6-0.3c0.5-0.1,1.1-0.1,1.6-0.2l1.1-0.1l0.5-0.1l0.6,0c0.9-0.1,1.7-0.1,2.6-0.2l1.3-0.1c0,0,0.5,0,0.1,0l0.3,0	l0.6,0c0.7,0,1.5-0.1,2.2-0.1c2.9-0.1,5.9-0.1,8.8,0c5.8,0.2,11.5,0.9,17,1.9c11.1,2.1,21.5,5.6,31,10.3	c9.5,4.6,17.9,10.3,25.3,16.5c0.5,0.4,0.9,0.8,1.4,1.2c0.4,0.4,0.9,0.8,1.3,1.2c0.9,0.8,1.7,1.6,2.6,2.4c0.9,0.8,1.7,1.6,2.5,2.4	c0.8,0.8,1.6,1.6,2.4,2.5c3.1,3.3,6,6.6,8.6,10c5.2,6.7,9.4,13.5,12.7,19.9c0.2,0.4,0.4,0.8,0.6,1.2c0.2,0.4,0.4,0.8,0.6,1.2	c0.4,0.8,0.8,1.6,1.1,2.4c0.4,0.8,0.7,1.5,1.1,2.3c0.3,0.8,0.7,1.5,1,2.3c1.2,3,2.4,5.9,3.3,8.6c1.5,4.4,2.6,8.3,3.5,11.7	c0.3,1.4,1.6,2.3,3,2.1c1.5-0.1,2.6-1.3,2.6-2.8C342.6,170.4,342.5,166.1,342,161.2z" />
  </svg>
);

export const linkerdLogoOnly = (
  <svg id="linkerd-logo" className="linkerd-logo-only" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 138.9 129.2">
    <linearGradient
      id="SVGID_1_"
      gradientUnits="userSpaceOnUse"
      x1="130.52"
      y1="24.532"
      x2="130.52"
      y2="79.491">
      <stop offset="0" stopColor="#2beda7" />
      <stop offset="1" stopColor="#018afd" />
    </linearGradient>
    <polygon
      className="st0"
      points="125.9,24.5 125.9,74.2 135.1,79.5 135.1,29.8" />
    <linearGradient
      id="SVGID_2_"
      gradientUnits="userSpaceOnUse"
      x1="7.78"
      y1="24.534"
      x2="7.78"
      y2="79.495">
      <stop offset="0" stopColor="#2beda7" />
      <stop offset="1" stopColor="#018afd" />
    </linearGradient>
    <polygon
      className="st1"
      points="3.2,79.5 12.4,74.2 12.4,24.5 3.2,29.8" />
    <g>
      <polygon
        className="st2"
        points="48.1,79 90.2,103.3 90.2,92.8 50.8,70 48.1,71.5 48.1,71.5" />
      <path
        className="st2"
        d="M92.6,117.4L48.1,91.7v10.6l11.9,6.9l-14.3,8.3c-1,0.6-1,1.9,0,2.5l7,4l16.5-9.5l16.5,9.5l7-4 C93.6,119.4,93.6,118,92.6,117.4z" />
    </g>
    <g>
      <linearGradient
        id="SVGID_3_"
        gradientUnits="userSpaceOnUse"
        x1="130.52"
        y1="48.861"
        x2="130.52"
        y2="99.634">
        <stop offset="0" stopColor="#2beda7" />
        <stop offset="1" stopColor="#018afd" />
      </linearGradient>
      <path
        className="st3"
        d="M125.9,54.1v44c0,1.1,1.2,1.8,2.2,1.3l6.3-3.6c0.4-0.3,0.7-0.7,0.7-1.3V48.9L125.9,54.1z" />
      <linearGradient
        id="SVGID_4_"
        gradientUnits="userSpaceOnUse"
        x1="110.368"
        y1="60.496"
        x2="110.368"
        y2="111.269">
        <stop offset="0" stopColor="#2beda7" />
        <stop offset="1" stopColor="#018afd" />
      </linearGradient>
      <path
        className="st4"
        d="M108,111.1l5.9-3.4c0.7-0.4,1.1-1.1,1.1-1.9V60.5l-9.2,5.3v44C105.8,110.9,107,111.6,108,111.1z" />
      <linearGradient
        id="SVGID_5_"
        gradientUnits="userSpaceOnUse"
        x1="90.216"
        y1="72.13"
        x2="90.216"
        y2="123.959">
        <stop offset="0" stopColor="#2beda7" />
        <stop offset="1" stopColor="#018afd" />
      </linearGradient>
      <path
        className="st5"
        d="M85.6,124l8.4-4.9c0.4-0.3,0.7-0.7,0.7-1.3V72.1l-9.2,5.3V124z" />
      <linearGradient
        id="SVGID_6_"
        gradientUnits="userSpaceOnUse"
        x1="48.089"
        y1="72.13"
        x2="48.089"
        y2="123.958">
        <stop offset="0" stopColor="#2beda7" />
        <stop offset="1" stopColor="#018afd" />
      </linearGradient>
      <path
        className="st6"
        d="M44.2,119.1l8.4,4.9V77.4l-9.2-5.3v45.7C43.5,118.4,43.8,118.8,44.2,119.1z" />
      <linearGradient
        id="SVGID_7_"
        gradientUnits="userSpaceOnUse"
        x1="27.937"
        y1="60.495"
        x2="27.937"
        y2="111.269">
        <stop offset="0" stopColor="#2beda7" />
        <stop offset="1" stopColor="#018afd" />
      </linearGradient>
      <path
        className="st7"
        d="M24.4,107.7l5.9,3.4c1,0.6,2.2-0.1,2.2-1.3v-44l-9.2-5.3v45.3C23.4,106.6,23.8,107.3,24.4,107.7z" />
      <linearGradient
        id="SVGID_8_"
        gradientUnits="userSpaceOnUse"
        x1="7.785"
        y1="48.861"
        x2="7.785"
        y2="99.633">
        <stop offset="0" stopColor="#2beda7" />
        <stop offset="1" stopColor="#018afd" />
      </linearGradient>
      <path
        className="st8"
        d="M4.3,96l5.9,3.4c1,0.6,2.2-0.1,2.2-1.3v-44l-9.2-5.3v45.3C3.2,94.9,3.6,95.6,4.3,96z" />
    </g>
    <g>
      <path
        className="st2"
        d="M135.1,29.8l-9.2-5.3l-16.5,9.5l-11-6.3l14.3-8.3c1-0.6,1-1.9,0-2.5l-5.9-3.4c-0.7-0.4-1.5-0.4-2.2,0 l-15.4,8.9l-11-6.3l14.3-8.3c1-0.6,1-1.9,0-2.5l-5.9-3.4c-0.7-0.4-1.5-0.4-2.2,0l-15.4,8.9L53.7,1.9c-0.7-0.4-1.5-0.4-2.2,0 l-5.9,3.4c-1,0.6-1,1.9,0,2.5l80.3,46.3l9.2-5.3l-16.5-9.5L135.1,29.8z" />
      <path
        className="st2"
        d="M31.4,13.5l-5.9,3.4c-1,0.6-1,1.9,0,2.5l80.3,46.3l9.2-5.3l-81.4-47C32.9,13.1,32.1,13.1,31.4,13.5z" />
      <polygon
        className="st2"
        points="3.2,29.8 19.7,39.3 3.2,48.9 12.4,54.2 28.9,44.6 39.8,51 23.4,60.5 32.5,65.8 49,56.3 60,62.6 43.5,72.1 52.7,77.4 69.1,67.9 85.6,77.4 94.8,72.1 12.4,24.5" />
    </g>
  </svg>
);

export const linkerdWordLogo = (
  <svg className="linkerd-word-logo" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1092.4 233.7">
    <g id="Layer_1">
      <path
        className="st2"
        d="M300.7,164.6v-97c0-4.6,3.9-8.5,8.7-8.5c4.6,0,8.4,3.9,8.4,8.5v91.1h44.8c4.1,0,7.7,3.2,7.7,7.3 c0,4.3-3.6,7.7-7.7,7.7h-52.7C303.9,173.6,300.7,170.4,300.7,164.6z" />
      <path
        className="st2"
        d="M403.5,165.9V67.5c0-4.6,3.9-8.5,8.7-8.5c4.6,0,8.4,3.9,8.4,8.5v98.4c0,4.6-3.8,8.5-8.4,8.5 C407.4,174.5,403.5,170.5,403.5,165.9z" />
      <path
        className="st2"
        d="M538.7,170l-60.4-83.7v79.6c0,4.6-3.8,8.5-8.4,8.5c-4.8,0-8.7-3.9-8.7-8.5V70.3c0-6.1,4.9-11.3,11.3-11.3 c3.6,0,7,1.7,9,4.6l59.2,81.5V67.5c0-4.6,3.8-8.5,8.4-8.5c4.8,0,8.7,3.9,8.7,8.5v96.3c0,5.8-4.8,10.6-10.6,10.6 C543.7,174.5,540.6,172.9,538.7,170z" />
      <path
        className="st2"
        d="M683.5,166.3c0,4.4-3.4,8.2-7.8,8.2c-2.2,0-4.3-0.5-6-2.4l-43.3-47.6l-10.9,11.6v29.8c0,4.6-3.8,8.5-8.5,8.5 c-4.6,0-8.5-3.9-8.5-8.5V67.5c0-4.6,3.9-8.5,8.5-8.5c4.8,0,8.5,3.9,8.5,8.5v49.1l50.1-55.1c1.7-1.9,3.8-2.6,6-2.6 c4.3,0,8,3.4,8,7.8c0,2-0.5,3.9-2.2,5.5l-39.6,42.1l43.5,46.4C682.6,162.4,683.5,164.4,683.5,166.3z" />
      <path
        className="st2"
        d="M717.9,164.6V68.9c0-5.8,3.2-9,9.2-9h60.4c4.1,0,7.7,3.4,7.7,7.7c0,4.1-3.6,7.3-7.7,7.3H735v33.3h51.3 c4.1,0,7.7,3.2,7.7,7.3c0,4.3-3.6,7.7-7.7,7.7H735v35.5h52.5c4.1,0,7.7,3.2,7.7,7.3c0,4.3-3.6,7.7-7.7,7.7h-60.4 C721.2,173.6,717.9,170.4,717.9,164.6z" />
      <path
        className="st2"
        d="M915.7,166.6c0,3.6-3.2,7.8-8,7.8c-2.9,0-5.6-1.4-7.2-3.6l-28.5-41.1h-24v36.2c0,4.6-3.8,8.5-8.4,8.5 c-4.8,0-8.7-3.9-8.7-8.5v-97c0-5.8,3.2-9,9.2-9h38.7c21.7,0,36.5,14,36.5,35c0,19.1-11.9,30-25.4,32.7l24,33.8 C915,162.5,915.7,163.9,915.7,166.6z M848,114.8h28.6c12.3,0,21.1-8,21.1-20c0-11.9-8.9-20-21.1-20H848V114.8z" />
      <path
        className="st2"
        d="M951.7,164.6V68.9c0-5.8,3.2-9,9.2-9h31.4c35.5,0,59,24.2,59,57c0,32.9-23.5,56.8-59,56.8h-31.4 C954.9,173.6,951.7,170.4,951.7,164.6z M992.3,158.6c26.3,0,41.4-18.8,41.4-41.8c0-23.4-14.7-41.9-41.4-41.9h-23.5v83.7H992.3z" />
      <g>
        <linearGradient
          id="SVGID_1_"
          gradientUnits="userSpaceOnUse"
          x1="239.749"
          y1="43.139"
          x2="239.749"
          y2="146.622">
          <stop offset="0" stopColor="#2beda7" />
          <stop offset="1" stopColor="#018afd" />
        </linearGradient>
        <polygon
          className="st3"
          points="231.1,43.1 231.1,136.7 248.4,146.6 248.4,53.1" />
        <linearGradient
          id="SVGID_2_"
          gradientUnits="userSpaceOnUse"
          x1="8.642"
          y1="43.142"
          x2="8.642"
          y2="146.628">
          <stop offset="0" stopColor="#2beda7" />
          <stop offset="1" stopColor="#018afd" />
        </linearGradient>
        <polygon
          className="st4"
          points="0,146.6 17.3,136.7 17.3,43.1 0,53.1" />
        <g>
          <polygon
            className="st5"
            points="84.5,145.7 163.9,191.5 163.9,171.6 89.6,128.7 84.5,131.6 84.5,131.7" />
          <path
            className="st5"
            d="M168.4,218l-83.9-48.4v19.9l22.4,12.9L80,218c-1.8,1-1.8,3.7,0,4.7l13.2,7.6l31-17.9l31,17.9l13.2-7.6 C170.2,221.7,170.2,219.1,168.4,218z" />
        </g>
        <g>
          <linearGradient
            id="SVGID_3_"
            gradientUnits="userSpaceOnUse"
            x1="239.749"
            y1="88.949"
            x2="239.749"
            y2="184.549">
            <stop offset="0" stopColor="#2beda7" />
            <stop offset="1" stopColor="#018afd" />
          </linearGradient>
          <path
            className="st6"
            d="M231.1,98.9v82.9c0,2.1,2.3,3.4,4.1,2.4l11.8-6.8c0.8-0.5,1.4-1.4,1.4-2.4V88.9L231.1,98.9z" />
          <linearGradient
            id="SVGID_4_"
            gradientUnits="userSpaceOnUse"
            x1="201.805"
            y1="110.855"
            x2="201.805"
            y2="206.455">
            <stop offset="0" stopColor="#2beda7" />
            <stop offset="1" stopColor="#018afd" />
          </linearGradient>
          <path
            className="st7"
            d="M197.3,206.1l11.1-6.4c1.3-0.7,2-2.1,2-3.5v-85.3l-17.2,10v82.9C193.2,205.8,195.4,207.1,197.3,206.1z" />
          <linearGradient
            id="SVGID_5_"
            gradientUnits="userSpaceOnUse"
            x1="163.861"
            y1="132.761"
            x2="163.861"
            y2="230.35">
            <stop offset="0" stopColor="#2beda7" />
            <stop offset="1" stopColor="#018afd" />
          </linearGradient>
          <path
            className="st8"
            d="M155.2,230.3l15.9-9.2c0.8-0.5,1.4-1.4,1.4-2.4v-86.1l-17.2,10V230.3z" />
          <linearGradient
            id="SVGID_6_"
            gradientUnits="userSpaceOnUse"
            x1="84.539"
            y1="132.761"
            x2="84.539"
            y2="230.348">
            <stop offset="0" stopColor="#2beda7" />
            <stop offset="1" stopColor="#018afd" />
          </linearGradient>
          <path
            className="st9"
            d="M77.3,221.2l15.9,9.2v-87.6l-17.2-10v86.1C75.9,219.8,76.4,220.7,77.3,221.2z" />
          <linearGradient
            id="SVGID_7_"
            gradientUnits="userSpaceOnUse"
            x1="46.595"
            y1="110.855"
            x2="46.595"
            y2="206.455">
            <stop offset="0" stopColor="#2beda7" />
            <stop offset="1" stopColor="#018afd" />
          </linearGradient>
          <path
            className="st10"
            d="M40,199.7l11.1,6.4c1.8,1,4.1-0.3,4.1-2.4v-82.9l-17.2-10v85.3C38,197.6,38.7,198.9,40,199.7z" />
          <linearGradient
            id="SVGID_8_"
            gradientUnits="userSpaceOnUse"
            x1="8.651"
            y1="88.947"
            x2="8.651"
            y2="184.548">
            <stop offset="0" stopColor="#2beda7" />
            <stop offset="1" stopColor="#018afd" />
          </linearGradient>
          <path
            className="st11"
            d="M2.1,177.8l11.1,6.4c1.8,1,4.1-0.3,4.1-2.4V98.9L0,88.9v85.3C0,175.7,0.8,177,2.1,177.8z" />
        </g>
        <g>
          <path
            className="st5"
            d="M248.4,53.1l-17.3-10l-31,17.9l-20.7-11.9l27-15.6c1.8-1,1.8-3.7,0-4.7l-11.1-6.4c-1.3-0.7-2.8-0.7-4.1,0 l-29,16.7l-20.7-11.9l27-15.6c1.8-1,1.8-3.7,0-4.7l-11.1-6.4c-1.3-0.7-2.8-0.7-4.1,0l-29,16.7l-29-16.8c-1.3-0.7-2.8-0.7-4.1,0 L80,6.9c-1.8,1-1.8,3.7,0,4.7l151.1,87.3l17.2-10l-31-17.9L248.4,53.1z" />
          <path
            className="st5"
            d="M53.2,22.4L42,28.8c-1.8,1-1.8,3.7,0,4.7l151.1,87.3l17.3-10L57.3,22.4C56,21.7,54.4,21.7,53.2,22.4z" />
          <polygon
            className="st5"
            points="0,53.1 31.1,71 0,89 17.3,98.9 48.3,81 69,92.9 38,110.9 55.2,120.8 86.3,102.9 106.9,114.8 75.9,132.8 93.2,142.7 124.2,124.8 155.2,142.7 172.5,132.8 17.3,43.1" />
        </g>
      </g>
    </g>
  </svg>
)
;
