/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/linkerd/linkerd2/controller/gen/apis/serviceprofile/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ServiceProfileLister helps list ServiceProfiles.
type ServiceProfileLister interface {
	// List lists all ServiceProfiles in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.ServiceProfile, err error)
	// ServiceProfiles returns an object that can list and get ServiceProfiles.
	ServiceProfiles(namespace string) ServiceProfileNamespaceLister
	ServiceProfileListerExpansion
}

// serviceProfileLister implements the ServiceProfileLister interface.
type serviceProfileLister struct {
	indexer cache.Indexer
}

// NewServiceProfileLister returns a new ServiceProfileLister.
func NewServiceProfileLister(indexer cache.Indexer) ServiceProfileLister {
	return &serviceProfileLister{indexer: indexer}
}

// List lists all ServiceProfiles in the indexer.
func (s *serviceProfileLister) List(selector labels.Selector) (ret []*v1alpha1.ServiceProfile, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ServiceProfile))
	})
	return ret, err
}

// ServiceProfiles returns an object that can list and get ServiceProfiles.
func (s *serviceProfileLister) ServiceProfiles(namespace string) ServiceProfileNamespaceLister {
	return serviceProfileNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ServiceProfileNamespaceLister helps list and get ServiceProfiles.
type ServiceProfileNamespaceLister interface {
	// List lists all ServiceProfiles in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.ServiceProfile, err error)
	// Get retrieves the ServiceProfile from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.ServiceProfile, error)
	ServiceProfileNamespaceListerExpansion
}

// serviceProfileNamespaceLister implements the ServiceProfileNamespaceLister
// interface.
type serviceProfileNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ServiceProfiles in the indexer for a given namespace.
func (s serviceProfileNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.ServiceProfile, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ServiceProfile))
	})
	return ret, err
}

// Get retrieves the ServiceProfile from the indexer for a given namespace and name.
func (s serviceProfileNamespaceLister) Get(name string) (*v1alpha1.ServiceProfile, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("serviceprofile"), name)
	}
	return obj.(*v1alpha1.ServiceProfile), nil
}
