// This file was generated by Conjure and should not be manually edited.

package actions

import (
	"context"
	"fmt"

	"github.com/palantir/pkg/safejson"
	"github.com/palantir/pkg/safeyaml"
)

// Payload is sent to user function.
type Payload struct {
	typ               string
	periodic          *PeriodicPayload
	webhook           *WebhookPayload
	block             *BlockPayload
	transaction       *TransactionPayload
	transactionsimple *TransactionPayload
	alert             *AlertPayload
}

type payloadDeserializer struct {
	Type              string              `json:"type"`
	Periodic          *PeriodicPayload    `json:"periodic"`
	Webhook           *WebhookPayload     `json:"webhook"`
	Block             *BlockPayload       `json:"block"`
	Transaction       *TransactionPayload `json:"transaction"`
	Transactionsimple *TransactionPayload `json:"transactionsimple"`
	Alert             *AlertPayload       `json:"alert"`
}

func (u *payloadDeserializer) toStruct() Payload {
	return Payload{typ: u.Type, periodic: u.Periodic, webhook: u.Webhook, block: u.Block, transaction: u.Transaction, transactionsimple: u.Transactionsimple, alert: u.Alert}
}

func (u *Payload) toSerializer() (interface{}, error) {
	switch u.typ {
	default:
		return nil, fmt.Errorf("unknown type %s", u.typ)
	case "periodic":
		return struct {
			Type     string          `json:"type"`
			Periodic PeriodicPayload `json:"periodic"`
		}{Type: "periodic", Periodic: *u.periodic}, nil
	case "webhook":
		return struct {
			Type    string         `json:"type"`
			Webhook WebhookPayload `json:"webhook"`
		}{Type: "webhook", Webhook: *u.webhook}, nil
	case "block":
		return struct {
			Type  string       `json:"type"`
			Block BlockPayload `json:"block"`
		}{Type: "block", Block: *u.block}, nil
	case "transaction":
		return struct {
			Type        string             `json:"type"`
			Transaction TransactionPayload `json:"transaction"`
		}{Type: "transaction", Transaction: *u.transaction}, nil
	case "transactionsimple":
		return struct {
			Type              string             `json:"type"`
			Transactionsimple TransactionPayload `json:"transactionsimple"`
		}{Type: "transactionsimple", Transactionsimple: *u.transactionsimple}, nil
	case "alert":
		return struct {
			Type  string       `json:"type"`
			Alert AlertPayload `json:"alert"`
		}{Type: "alert", Alert: *u.alert}, nil
	}
}

func (u Payload) MarshalJSON() ([]byte, error) {
	ser, err := u.toSerializer()
	if err != nil {
		return nil, err
	}
	return safejson.Marshal(ser)
}

func (u *Payload) UnmarshalJSON(data []byte) error {
	var deser payloadDeserializer
	if err := safejson.Unmarshal(data, &deser); err != nil {
		return err
	}
	*u = deser.toStruct()
	return nil
}

func (u Payload) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(u)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (u *Payload) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&u)
}

func (u *Payload) Accept(v PayloadVisitor) error {
	switch u.typ {
	default:
		if u.typ == "" {
			return fmt.Errorf("invalid value in union type")
		}
		return v.VisitUnknown(u.typ)
	case "periodic":
		return v.VisitPeriodic(*u.periodic)
	case "webhook":
		return v.VisitWebhook(*u.webhook)
	case "block":
		return v.VisitBlock(*u.block)
	case "transaction":
		return v.VisitTransaction(*u.transaction)
	case "transactionsimple":
		return v.VisitTransactionsimple(*u.transactionsimple)
	case "alert":
		return v.VisitAlert(*u.alert)
	}
}

type PayloadVisitor interface {
	VisitPeriodic(v PeriodicPayload) error
	VisitWebhook(v WebhookPayload) error
	VisitBlock(v BlockPayload) error
	VisitTransaction(v TransactionPayload) error
	VisitTransactionsimple(v TransactionPayload) error
	VisitAlert(v AlertPayload) error
	VisitUnknown(typeName string) error
}

func (u *Payload) AcceptWithContext(ctx context.Context, v PayloadVisitorWithContext) error {
	switch u.typ {
	default:
		if u.typ == "" {
			return fmt.Errorf("invalid value in union type")
		}
		return v.VisitUnknownWithContext(ctx, u.typ)
	case "periodic":
		return v.VisitPeriodicWithContext(ctx, *u.periodic)
	case "webhook":
		return v.VisitWebhookWithContext(ctx, *u.webhook)
	case "block":
		return v.VisitBlockWithContext(ctx, *u.block)
	case "transaction":
		return v.VisitTransactionWithContext(ctx, *u.transaction)
	case "transactionsimple":
		return v.VisitTransactionsimpleWithContext(ctx, *u.transactionsimple)
	case "alert":
		return v.VisitAlertWithContext(ctx, *u.alert)
	}
}

type PayloadVisitorWithContext interface {
	VisitPeriodicWithContext(ctx context.Context, v PeriodicPayload) error
	VisitWebhookWithContext(ctx context.Context, v WebhookPayload) error
	VisitBlockWithContext(ctx context.Context, v BlockPayload) error
	VisitTransactionWithContext(ctx context.Context, v TransactionPayload) error
	VisitTransactionsimpleWithContext(ctx context.Context, v TransactionPayload) error
	VisitAlertWithContext(ctx context.Context, v AlertPayload) error
	VisitUnknownWithContext(ctx context.Context, typeName string) error
}

func NewPayloadFromPeriodic(v PeriodicPayload) Payload {
	return Payload{typ: "periodic", periodic: &v}
}

func NewPayloadFromWebhook(v WebhookPayload) Payload {
	return Payload{typ: "webhook", webhook: &v}
}

func NewPayloadFromBlock(v BlockPayload) Payload {
	return Payload{typ: "block", block: &v}
}

func NewPayloadFromTransaction(v TransactionPayload) Payload {
	return Payload{typ: "transaction", transaction: &v}
}

func NewPayloadFromTransactionsimple(v TransactionPayload) Payload {
	return Payload{typ: "transactionsimple", transactionsimple: &v}
}

func NewPayloadFromAlert(v AlertPayload) Payload {
	return Payload{typ: "alert", alert: &v}
}

// Payload summary is exposed in dashboard, in list views.
type PayloadSummary struct {
	typ               string
	periodic          *PeriodicPayloadSummary
	webhook           *WebhookPayloadSummary
	block             *BlockPayloadSummary
	transaction       *TransactionPayloadSummary
	transactionsimple *TransactionPayloadSummary
	alert             *AlertPayloadSummary
}

type payloadSummaryDeserializer struct {
	Type              string                     `json:"type"`
	Periodic          *PeriodicPayloadSummary    `json:"periodic"`
	Webhook           *WebhookPayloadSummary     `json:"webhook"`
	Block             *BlockPayloadSummary       `json:"block"`
	Transaction       *TransactionPayloadSummary `json:"transaction"`
	Transactionsimple *TransactionPayloadSummary `json:"transactionsimple"`
	Alert             *AlertPayloadSummary       `json:"alert"`
}

func (u *payloadSummaryDeserializer) toStruct() PayloadSummary {
	return PayloadSummary{typ: u.Type, periodic: u.Periodic, webhook: u.Webhook, block: u.Block, transaction: u.Transaction, transactionsimple: u.Transactionsimple, alert: u.Alert}
}

func (u *PayloadSummary) toSerializer() (interface{}, error) {
	switch u.typ {
	default:
		return nil, fmt.Errorf("unknown type %s", u.typ)
	case "periodic":
		return struct {
			Type     string                 `json:"type"`
			Periodic PeriodicPayloadSummary `json:"periodic"`
		}{Type: "periodic", Periodic: *u.periodic}, nil
	case "webhook":
		return struct {
			Type    string                `json:"type"`
			Webhook WebhookPayloadSummary `json:"webhook"`
		}{Type: "webhook", Webhook: *u.webhook}, nil
	case "block":
		return struct {
			Type  string              `json:"type"`
			Block BlockPayloadSummary `json:"block"`
		}{Type: "block", Block: *u.block}, nil
	case "transaction":
		return struct {
			Type        string                    `json:"type"`
			Transaction TransactionPayloadSummary `json:"transaction"`
		}{Type: "transaction", Transaction: *u.transaction}, nil
	case "transactionsimple":
		return struct {
			Type              string                    `json:"type"`
			Transactionsimple TransactionPayloadSummary `json:"transactionsimple"`
		}{Type: "transactionsimple", Transactionsimple: *u.transactionsimple}, nil
	case "alert":
		return struct {
			Type  string              `json:"type"`
			Alert AlertPayloadSummary `json:"alert"`
		}{Type: "alert", Alert: *u.alert}, nil
	}
}

func (u PayloadSummary) MarshalJSON() ([]byte, error) {
	ser, err := u.toSerializer()
	if err != nil {
		return nil, err
	}
	return safejson.Marshal(ser)
}

func (u *PayloadSummary) UnmarshalJSON(data []byte) error {
	var deser payloadSummaryDeserializer
	if err := safejson.Unmarshal(data, &deser); err != nil {
		return err
	}
	*u = deser.toStruct()
	return nil
}

func (u PayloadSummary) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(u)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (u *PayloadSummary) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&u)
}

func (u *PayloadSummary) Accept(v PayloadSummaryVisitor) error {
	switch u.typ {
	default:
		if u.typ == "" {
			return fmt.Errorf("invalid value in union type")
		}
		return v.VisitUnknown(u.typ)
	case "periodic":
		return v.VisitPeriodic(*u.periodic)
	case "webhook":
		return v.VisitWebhook(*u.webhook)
	case "block":
		return v.VisitBlock(*u.block)
	case "transaction":
		return v.VisitTransaction(*u.transaction)
	case "transactionsimple":
		return v.VisitTransactionsimple(*u.transactionsimple)
	case "alert":
		return v.VisitAlert(*u.alert)
	}
}

type PayloadSummaryVisitor interface {
	VisitPeriodic(v PeriodicPayloadSummary) error
	VisitWebhook(v WebhookPayloadSummary) error
	VisitBlock(v BlockPayloadSummary) error
	VisitTransaction(v TransactionPayloadSummary) error
	VisitTransactionsimple(v TransactionPayloadSummary) error
	VisitAlert(v AlertPayloadSummary) error
	VisitUnknown(typeName string) error
}

func (u *PayloadSummary) AcceptWithContext(ctx context.Context, v PayloadSummaryVisitorWithContext) error {
	switch u.typ {
	default:
		if u.typ == "" {
			return fmt.Errorf("invalid value in union type")
		}
		return v.VisitUnknownWithContext(ctx, u.typ)
	case "periodic":
		return v.VisitPeriodicWithContext(ctx, *u.periodic)
	case "webhook":
		return v.VisitWebhookWithContext(ctx, *u.webhook)
	case "block":
		return v.VisitBlockWithContext(ctx, *u.block)
	case "transaction":
		return v.VisitTransactionWithContext(ctx, *u.transaction)
	case "transactionsimple":
		return v.VisitTransactionsimpleWithContext(ctx, *u.transactionsimple)
	case "alert":
		return v.VisitAlertWithContext(ctx, *u.alert)
	}
}

type PayloadSummaryVisitorWithContext interface {
	VisitPeriodicWithContext(ctx context.Context, v PeriodicPayloadSummary) error
	VisitWebhookWithContext(ctx context.Context, v WebhookPayloadSummary) error
	VisitBlockWithContext(ctx context.Context, v BlockPayloadSummary) error
	VisitTransactionWithContext(ctx context.Context, v TransactionPayloadSummary) error
	VisitTransactionsimpleWithContext(ctx context.Context, v TransactionPayloadSummary) error
	VisitAlertWithContext(ctx context.Context, v AlertPayloadSummary) error
	VisitUnknownWithContext(ctx context.Context, typeName string) error
}

func NewPayloadSummaryFromPeriodic(v PeriodicPayloadSummary) PayloadSummary {
	return PayloadSummary{typ: "periodic", periodic: &v}
}

func NewPayloadSummaryFromWebhook(v WebhookPayloadSummary) PayloadSummary {
	return PayloadSummary{typ: "webhook", webhook: &v}
}

func NewPayloadSummaryFromBlock(v BlockPayloadSummary) PayloadSummary {
	return PayloadSummary{typ: "block", block: &v}
}

func NewPayloadSummaryFromTransaction(v TransactionPayloadSummary) PayloadSummary {
	return PayloadSummary{typ: "transaction", transaction: &v}
}

func NewPayloadSummaryFromTransactionsimple(v TransactionPayloadSummary) PayloadSummary {
	return PayloadSummary{typ: "transactionsimple", transactionsimple: &v}
}

func NewPayloadSummaryFromAlert(v AlertPayloadSummary) PayloadSummary {
	return PayloadSummary{typ: "alert", alert: &v}
}

// Trigger is confired by user. CLI has another trigger representation and does translation.
type Trigger struct {
	typ               string
	periodic          *PeriodicTrigger
	webhook           *WebhookTrigger
	block             *BlockTrigger
	transaction       *TransactionTrigger
	transactionsimple *TransactionSimpleTrigger
	alert             *AlertTrigger
}

type triggerDeserializer struct {
	Type              string                    `json:"type"`
	Periodic          *PeriodicTrigger          `json:"periodic"`
	Webhook           *WebhookTrigger           `json:"webhook"`
	Block             *BlockTrigger             `json:"block"`
	Transaction       *TransactionTrigger       `json:"transaction"`
	Transactionsimple *TransactionSimpleTrigger `json:"transactionsimple"`
	Alert             *AlertTrigger             `json:"alert"`
}

func (u *triggerDeserializer) toStruct() Trigger {
	return Trigger{typ: u.Type, periodic: u.Periodic, webhook: u.Webhook, block: u.Block, transaction: u.Transaction, transactionsimple: u.Transactionsimple, alert: u.Alert}
}

func (u *Trigger) toSerializer() (interface{}, error) {
	switch u.typ {
	default:
		return nil, fmt.Errorf("unknown type %s", u.typ)
	case "periodic":
		return struct {
			Type     string          `json:"type"`
			Periodic PeriodicTrigger `json:"periodic"`
		}{Type: "periodic", Periodic: *u.periodic}, nil
	case "webhook":
		return struct {
			Type    string         `json:"type"`
			Webhook WebhookTrigger `json:"webhook"`
		}{Type: "webhook", Webhook: *u.webhook}, nil
	case "block":
		return struct {
			Type  string       `json:"type"`
			Block BlockTrigger `json:"block"`
		}{Type: "block", Block: *u.block}, nil
	case "transaction":
		return struct {
			Type        string             `json:"type"`
			Transaction TransactionTrigger `json:"transaction"`
		}{Type: "transaction", Transaction: *u.transaction}, nil
	case "transactionsimple":
		return struct {
			Type              string                   `json:"type"`
			Transactionsimple TransactionSimpleTrigger `json:"transactionsimple"`
		}{Type: "transactionsimple", Transactionsimple: *u.transactionsimple}, nil
	case "alert":
		return struct {
			Type  string       `json:"type"`
			Alert AlertTrigger `json:"alert"`
		}{Type: "alert", Alert: *u.alert}, nil
	}
}

func (u Trigger) MarshalJSON() ([]byte, error) {
	ser, err := u.toSerializer()
	if err != nil {
		return nil, err
	}
	return safejson.Marshal(ser)
}

func (u *Trigger) UnmarshalJSON(data []byte) error {
	var deser triggerDeserializer
	if err := safejson.Unmarshal(data, &deser); err != nil {
		return err
	}
	*u = deser.toStruct()
	return nil
}

func (u Trigger) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(u)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (u *Trigger) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&u)
}

func (u *Trigger) Accept(v TriggerVisitor) error {
	switch u.typ {
	default:
		if u.typ == "" {
			return fmt.Errorf("invalid value in union type")
		}
		return v.VisitUnknown(u.typ)
	case "periodic":
		return v.VisitPeriodic(*u.periodic)
	case "webhook":
		return v.VisitWebhook(*u.webhook)
	case "block":
		return v.VisitBlock(*u.block)
	case "transaction":
		return v.VisitTransaction(*u.transaction)
	case "transactionsimple":
		return v.VisitTransactionsimple(*u.transactionsimple)
	case "alert":
		return v.VisitAlert(*u.alert)
	}
}

type TriggerVisitor interface {
	VisitPeriodic(v PeriodicTrigger) error
	VisitWebhook(v WebhookTrigger) error
	VisitBlock(v BlockTrigger) error
	VisitTransaction(v TransactionTrigger) error
	VisitTransactionsimple(v TransactionSimpleTrigger) error
	VisitAlert(v AlertTrigger) error
	VisitUnknown(typeName string) error
}

func (u *Trigger) AcceptWithContext(ctx context.Context, v TriggerVisitorWithContext) error {
	switch u.typ {
	default:
		if u.typ == "" {
			return fmt.Errorf("invalid value in union type")
		}
		return v.VisitUnknownWithContext(ctx, u.typ)
	case "periodic":
		return v.VisitPeriodicWithContext(ctx, *u.periodic)
	case "webhook":
		return v.VisitWebhookWithContext(ctx, *u.webhook)
	case "block":
		return v.VisitBlockWithContext(ctx, *u.block)
	case "transaction":
		return v.VisitTransactionWithContext(ctx, *u.transaction)
	case "transactionsimple":
		return v.VisitTransactionsimpleWithContext(ctx, *u.transactionsimple)
	case "alert":
		return v.VisitAlertWithContext(ctx, *u.alert)
	}
}

type TriggerVisitorWithContext interface {
	VisitPeriodicWithContext(ctx context.Context, v PeriodicTrigger) error
	VisitWebhookWithContext(ctx context.Context, v WebhookTrigger) error
	VisitBlockWithContext(ctx context.Context, v BlockTrigger) error
	VisitTransactionWithContext(ctx context.Context, v TransactionTrigger) error
	VisitTransactionsimpleWithContext(ctx context.Context, v TransactionSimpleTrigger) error
	VisitAlertWithContext(ctx context.Context, v AlertTrigger) error
	VisitUnknownWithContext(ctx context.Context, typeName string) error
}

func NewTriggerFromPeriodic(v PeriodicTrigger) Trigger {
	return Trigger{typ: "periodic", periodic: &v}
}

func NewTriggerFromWebhook(v WebhookTrigger) Trigger {
	return Trigger{typ: "webhook", webhook: &v}
}

func NewTriggerFromBlock(v BlockTrigger) Trigger {
	return Trigger{typ: "block", block: &v}
}

func NewTriggerFromTransaction(v TransactionTrigger) Trigger {
	return Trigger{typ: "transaction", transaction: &v}
}

func NewTriggerFromTransactionsimple(v TransactionSimpleTrigger) Trigger {
	return Trigger{typ: "transactionsimple", transactionsimple: &v}
}

func NewTriggerFromAlert(v AlertTrigger) Trigger {
	return Trigger{typ: "alert", alert: &v}
}
