// This file was generated by Conjure and should not be manually edited.

package actions

import (
	"github.com/palantir/pkg/datetime"
	"github.com/palantir/pkg/safejson"
	"github.com/palantir/pkg/safeyaml"
)

type AccountReference struct {
	Address string `json:"address"`
}

func (o AccountReference) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *AccountReference) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type Action struct {
	Id          string       `json:"id"`
	ProjectId   string       `json:"projectId"`
	Name        string       `json:"name"`
	Description *string      `json:"description"`
	Status      DeployStatus `json:"status"`
	// True if action trigger is stopped - trigger is ignoring events.
	// Action will remain stopped even on new publish / deploy until it is resumed.
	Stopped bool `json:"stopped" conjure-docs:"True if action trigger is stopped - trigger is ignoring events.\nAction will remain stopped even on new publish / deploy until it is resumed.\n"`
	// Version that is considered active for this action.
	Version Version `json:"version" conjure-docs:"Version that is considered active for this action.\n"`
	// Used to determine if source can be edited via dashboard UI.
	// If publish is done through the cli, edit shouldn't be allowed.
	Editable bool `json:"editable" conjure-docs:"Used to determine if source can be edited via dashboard UI.\nIf publish is done through the cli, edit shouldn't be allowed.\n"`
}

func (o Action) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *Action) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// Specification of action resource inside project. Resource is defined in either yaml or json format.
type ActionSpec struct {
	Name        string  `json:"name"`
	Description *string `json:"description"`
	// Source code, usually just top level file when function is defined.
	Source         *string     `json:"source" conjure-docs:"Source code, usually just top level file when function is defined."`
	Runtime        Runtime     `json:"runtime"`
	Function       Function    `json:"function"`
	TriggerType    TriggerType `json:"triggerType"`
	Trigger        *Trigger    `json:"trigger"`
	InvocationType string      `json:"invocationType"`
}

func (o ActionSpec) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ActionSpec) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type AlertPayload struct {
	AlertId         string `json:"alertId"`
	Network         string `json:"network"`
	TransactionHash string `json:"transactionHash"`
}

func (o AlertPayload) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *AlertPayload) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type AlertPayloadSummary struct {
	AlertId         string `json:"alertId"`
	Network         string `json:"network"`
	TransactionHash string `json:"transactionHash"`
}

func (o AlertPayloadSummary) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *AlertPayloadSummary) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type AlertTrigger struct {
}

func (o AlertTrigger) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *AlertTrigger) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type BlockPayload struct {
	Network     string `json:"network"`
	BlockNumber int    `json:"blockNumber"`
	BlockHash   string `json:"blockHash"`
}

func (o BlockPayload) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *BlockPayload) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type BlockPayloadRequest struct {
	Network     string `json:"network"`
	BlockNumber int    `json:"blockNumber"`
}

func (o BlockPayloadRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *BlockPayloadRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type BlockPayloadSummary struct {
	Network     string `json:"network"`
	BlockNumber int    `json:"blockNumber"`
	BlockHash   string `json:"blockHash"`
}

func (o BlockPayloadSummary) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *BlockPayloadSummary) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type BlockTrigger struct {
	Network []string `json:"network"`
	// Runs when block number on configured network modulo blocks is zero.
	Blocks int `json:"blocks" conjure-docs:"Runs when block number on configured network modulo blocks is zero."`
}

func (o BlockTrigger) MarshalJSON() ([]byte, error) {
	if o.Network == nil {
		o.Network = make([]string, 0)
	}
	type BlockTriggerAlias BlockTrigger
	return safejson.Marshal(BlockTriggerAlias(o))
}

func (o *BlockTrigger) UnmarshalJSON(data []byte) error {
	type BlockTriggerAlias BlockTrigger
	var rawBlockTrigger BlockTriggerAlias
	if err := safejson.Unmarshal(data, &rawBlockTrigger); err != nil {
		return err
	}
	if rawBlockTrigger.Network == nil {
		rawBlockTrigger.Network = make([]string, 0)
	}
	*o = BlockTrigger(rawBlockTrigger)
	return nil
}

func (o BlockTrigger) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *BlockTrigger) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// Action invokation result.
type Call struct {
	Id              string            `json:"id"`
	ActionId        string            `json:"actionId"`
	VersionId       string            `json:"versionId"`
	CreatedAt       datetime.DateTime `json:"createdAt"`
	Type            CallType          `json:"type"`
	Status          CallStatus        `json:"status"`
	StatusUpdatedAt datetime.DateTime `json:"statusUpdatedAt"`
	Payload         Payload           `json:"payload"`
	StorageType     CallStorageType   `json:"storageType"`
	// Id of the storage used during this execution. A storage with id can be browsed just like project storage.
	StorageId string `json:"storageId" conjure-docs:"Id of the storage used during this execution. A storage with id can be browsed just like project storage.\n"`
	// Used memory in MBs.
	Memory *int `json:"memory" conjure-docs:"Used memory in MBs."`
	// Used time in milliseconds.
	Time *int `json:"time" conjure-docs:"Used time in milliseconds."`
	// Parsed logs from executing action.
	ParsedLogs *CallLog `json:"parsedLogs" conjure-docs:"Parsed logs from executing action."`
	// Parsed error from executing action.
	ParsedError *CallError `json:"parsedError" conjure-docs:"Parsed error from executing action."`
}

func (o Call) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *Call) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// Parsed error.
type CallError struct {
	Name       string `json:"name"`
	Message    string `json:"message"`
	Stacktrace string `json:"stacktrace"`
}

func (o CallError) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *CallError) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// Parsed logs.
type CallLog struct {
	Lines []CallLogLine `json:"lines"`
}

func (o CallLog) MarshalJSON() ([]byte, error) {
	if o.Lines == nil {
		o.Lines = make([]CallLogLine, 0)
	}
	type CallLogAlias CallLog
	return safejson.Marshal(CallLogAlias(o))
}

func (o *CallLog) UnmarshalJSON(data []byte) error {
	type CallLogAlias CallLog
	var rawCallLog CallLogAlias
	if err := safejson.Unmarshal(data, &rawCallLog); err != nil {
		return err
	}
	if rawCallLog.Lines == nil {
		rawCallLog.Lines = make([]CallLogLine, 0)
	}
	*o = CallLog(rawCallLog)
	return nil
}

func (o CallLog) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *CallLog) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type CallLogLine struct {
	Time     datetime.DateTime `json:"time"`
	Severity string            `json:"severity"`
	Message  string            `json:"message"`
}

func (o CallLogLine) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *CallLogLine) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type CallRequest struct {
	Payload     Payload         `json:"payload"`
	StorageType CallStorageType `json:"storageType"`
}

func (o CallRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *CallRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// Basic stats for single call.
type CallStat struct {
	CreatedAt datetime.DateTime `json:"createdAt"`
	Type      CallType          `json:"type"`
	Status    CallStatus        `json:"status"`
}

func (o CallStat) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *CallStat) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// Statistics of calls for action.
type CallStats struct {
	ActionId string `json:"actionId"`
	// Returns call status for last 10 calls ordered starting from latest call.
	Stats []CallStat `json:"stats" conjure-docs:"Returns call status for last 10 calls ordered starting from latest call."`
}

func (o CallStats) MarshalJSON() ([]byte, error) {
	if o.Stats == nil {
		o.Stats = make([]CallStat, 0)
	}
	type CallStatsAlias CallStats
	return safejson.Marshal(CallStatsAlias(o))
}

func (o *CallStats) UnmarshalJSON(data []byte) error {
	type CallStatsAlias CallStats
	var rawCallStats CallStatsAlias
	if err := safejson.Unmarshal(data, &rawCallStats); err != nil {
		return err
	}
	if rawCallStats.Stats == nil {
		rawCallStats.Stats = make([]CallStat, 0)
	}
	*o = CallStats(rawCallStats)
	return nil
}

func (o CallStats) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *CallStats) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// Summary of action invokation result since full call can be large. Keep this in sync with call.
type CallSummary struct {
	Id              string            `json:"id"`
	ActionId        string            `json:"actionId"`
	VersionId       string            `json:"versionId"`
	CreatedAt       datetime.DateTime `json:"createdAt"`
	Type            CallType          `json:"type"`
	Status          CallStatus        `json:"status"`
	StatusUpdatedAt datetime.DateTime `json:"statusUpdatedAt"`
	Payload         PayloadSummary    `json:"payload"`
	StorageType     CallStorageType   `json:"storageType"`
	StorageId       string            `json:"storageId"`
	Memory          *int              `json:"memory"`
	Time            *int              `json:"time"`
}

func (o CallSummary) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *CallSummary) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ComparableAny struct {
	Str *ComparableStr `json:"str"`
	Int *ComparableInt `json:"int"`
	Map *ComparableMap `json:"map"`
}

func (o ComparableAny) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ComparableAny) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// Int must match all set fields to match comparable.
type ComparableInt struct {
	Gte *int `json:"gte"`
	Lte *int `json:"lte"`
	Eq  *int `json:"eq"`
	Gt  *int `json:"gt"`
	Lt  *int `json:"lt"`
}

func (o ComparableInt) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ComparableInt) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ComparableMap struct {
	Key   string        `json:"key"`
	Value ComparableAny `json:"value"`
}

func (o ComparableMap) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ComparableMap) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ComparableStr struct {
	Exact *string `json:"exact"`
}

func (o ComparableStr) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ComparableStr) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ContractReference struct {
	Address        string                 `json:"address"`
	InvocationType ContractInvocationType `json:"invocationType"`
}

func (o ContractReference) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ContractReference) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type DefaultPayloadRequest struct {
	Block       *BlockPayloadRequest       `json:"block"`
	Transaction *TransactionPayloadRequest `json:"transaction"`
}

func (o DefaultPayloadRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *DefaultPayloadRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type DeployRequest struct {
	VersionId string `json:"versionId"`
}

func (o DeployRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *DeployRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// Empty for now, but in the future we can add progress reporting.
type DeployResponse struct {
}

func (o DeployResponse) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *DeployResponse) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type EthBalanceFilter struct {
	Account AccountReference `json:"account"`
	Value   ComparableInt    `json:"value"`
}

func (o EthBalanceFilter) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *EthBalanceFilter) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type EventEmittedFilter struct {
	Contract ContractReference `json:"contract"`
	Id       *string           `json:"id"`
	Name     *string           `json:"name"`
}

func (o EventEmittedFilter) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *EventEmittedFilter) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ExecutionPayload struct {
	Storage StoragePayload `json:"storage"`
	Secrets SecretsPayload `json:"secrets"`
	Event   Payload        `json:"event"`
}

func (o ExecutionPayload) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ExecutionPayload) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

// All set collections are any of. All fields are ANDed.
type Filter struct {
	Network      []string             `json:"network"`
	Status       []Status             `json:"status"`
	Value        []ComparableInt      `json:"value"`
	GasLimit     []ComparableInt      `json:"gasLimit"`
	GasUsed      []ComparableInt      `json:"gasUsed"`
	Fee          []ComparableInt      `json:"fee"`
	From         []ComparableStr      `json:"from"`
	To           []ComparableStr      `json:"to"`
	Function     []FunctionFilter     `json:"function"`
	EventEmitted []EventEmittedFilter `json:"eventEmitted"`
	LogEmmitted  []LogEmittedFilter   `json:"logEmmitted"`
}

func (o Filter) MarshalJSON() ([]byte, error) {
	if o.Network == nil {
		o.Network = make([]string, 0)
	}
	if o.Status == nil {
		o.Status = make([]Status, 0)
	}
	if o.Value == nil {
		o.Value = make([]ComparableInt, 0)
	}
	if o.GasLimit == nil {
		o.GasLimit = make([]ComparableInt, 0)
	}
	if o.GasUsed == nil {
		o.GasUsed = make([]ComparableInt, 0)
	}
	if o.Fee == nil {
		o.Fee = make([]ComparableInt, 0)
	}
	if o.From == nil {
		o.From = make([]ComparableStr, 0)
	}
	if o.To == nil {
		o.To = make([]ComparableStr, 0)
	}
	if o.Function == nil {
		o.Function = make([]FunctionFilter, 0)
	}
	if o.EventEmitted == nil {
		o.EventEmitted = make([]EventEmittedFilter, 0)
	}
	if o.LogEmmitted == nil {
		o.LogEmmitted = make([]LogEmittedFilter, 0)
	}
	type FilterAlias Filter
	return safejson.Marshal(FilterAlias(o))
}

func (o *Filter) UnmarshalJSON(data []byte) error {
	type FilterAlias Filter
	var rawFilter FilterAlias
	if err := safejson.Unmarshal(data, &rawFilter); err != nil {
		return err
	}
	if rawFilter.Network == nil {
		rawFilter.Network = make([]string, 0)
	}
	if rawFilter.Status == nil {
		rawFilter.Status = make([]Status, 0)
	}
	if rawFilter.Value == nil {
		rawFilter.Value = make([]ComparableInt, 0)
	}
	if rawFilter.GasLimit == nil {
		rawFilter.GasLimit = make([]ComparableInt, 0)
	}
	if rawFilter.GasUsed == nil {
		rawFilter.GasUsed = make([]ComparableInt, 0)
	}
	if rawFilter.Fee == nil {
		rawFilter.Fee = make([]ComparableInt, 0)
	}
	if rawFilter.From == nil {
		rawFilter.From = make([]ComparableStr, 0)
	}
	if rawFilter.To == nil {
		rawFilter.To = make([]ComparableStr, 0)
	}
	if rawFilter.Function == nil {
		rawFilter.Function = make([]FunctionFilter, 0)
	}
	if rawFilter.EventEmitted == nil {
		rawFilter.EventEmitted = make([]EventEmittedFilter, 0)
	}
	if rawFilter.LogEmmitted == nil {
		rawFilter.LogEmmitted = make([]LogEmittedFilter, 0)
	}
	*o = Filter(rawFilter)
	return nil
}

func (o Filter) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *Filter) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type FunctionFilter struct {
	Contract ContractReference `json:"contract"`
	Name     *string           `json:"name"`
}

func (o FunctionFilter) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *FunctionFilter) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type LogEmittedFilter struct {
	TopicsStartsWith []string           `json:"topicsStartsWith"`
	Contract         *ContractReference `json:"contract"`
	MatchAny         bool               `json:"matchAny,omitempty"`
}

func (o LogEmittedFilter) MarshalJSON() ([]byte, error) {
	if o.TopicsStartsWith == nil {
		o.TopicsStartsWith = make([]string, 0)
	}
	type LogEmittedFilterAlias LogEmittedFilter
	return safejson.Marshal(LogEmittedFilterAlias(o))
}

func (o *LogEmittedFilter) UnmarshalJSON(data []byte) error {
	type LogEmittedFilterAlias LogEmittedFilter
	var rawLogEmittedFilter LogEmittedFilterAlias
	if err := safejson.Unmarshal(data, &rawLogEmittedFilter); err != nil {
		return err
	}
	if rawLogEmittedFilter.TopicsStartsWith == nil {
		rawLogEmittedFilter.TopicsStartsWith = make([]string, 0)
	}
	*o = LogEmittedFilter(rawLogEmittedFilter)
	return nil
}

func (o LogEmittedFilter) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *LogEmittedFilter) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type PeriodicPayload struct {
	Timestamp int `json:"timestamp"`
}

func (o PeriodicPayload) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *PeriodicPayload) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type PeriodicPayloadSummary struct {
	Time datetime.DateTime `json:"time"`
}

func (o PeriodicPayloadSummary) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *PeriodicPayloadSummary) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type PeriodicTrigger struct {
	Cron string `json:"cron"`
	// When interval is specified and translated to cron. Not used in execution, just for UX.
	Interval *string `json:"interval" conjure-docs:"When interval is specified and translated to cron. Not used in execution, just for UX."`
}

func (o PeriodicTrigger) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *PeriodicTrigger) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type PublishFileRequest struct {
	Action ActionSpec `json:"action"`
	Deploy bool       `json:"deploy"`
}

func (o PublishFileRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *PublishFileRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type PublishRequest struct {
	// Map from action name to action spec.
	Actions map[string]ActionSpec `json:"actions" conjure-docs:"Map from action name to action spec."`
	// If true, for each action in DEPLOYED state, new version will be deployed.
	Deploy bool `json:"deploy" conjure-docs:"If true, for each action in DEPLOYED state, new version will be deployed."`
	// Zipped source code. Limited to 25MB. Omitted only if older logic can be reused.
	LogicZip *[]byte `json:"logicZip" conjure-docs:"Zipped source code. Limited to 25MB. Omitted only if older logic can be reused."`
	// Used to decide if new logic layer to be published or old can be reused.
	LogicVersion *string `json:"logicVersion" conjure-docs:"Used to decide if new logic layer to be published or old can be reused."`
	// Zipped node_modules dependencies. Limited to 25MB.
	DependenciesZip *[]byte `json:"dependenciesZip" conjure-docs:"Zipped node_modules dependencies. Limited to 25MB."`
	// Used to decide if new dependencies layer needs to be published or old can be reused.
	DependenciesVersion *string `json:"dependenciesVersion" conjure-docs:"Used to decide if new dependencies layer needs to be published or old can be reused."`
	// Content of package-lock.json for example.
	DependenciesLock *string `json:"dependenciesLock" conjure-docs:"Content of package-lock.json for example."`
	// Commit hash or tag name.
	Commitish *string `json:"commitish" conjure-docs:"Commit hash or tag name."`
}

func (o PublishRequest) MarshalJSON() ([]byte, error) {
	if o.Actions == nil {
		o.Actions = make(map[string]ActionSpec, 0)
	}
	type PublishRequestAlias PublishRequest
	return safejson.Marshal(PublishRequestAlias(o))
}

func (o *PublishRequest) UnmarshalJSON(data []byte) error {
	type PublishRequestAlias PublishRequest
	var rawPublishRequest PublishRequestAlias
	if err := safejson.Unmarshal(data, &rawPublishRequest); err != nil {
		return err
	}
	if rawPublishRequest.Actions == nil {
		rawPublishRequest.Actions = make(map[string]ActionSpec, 0)
	}
	*o = PublishRequest(rawPublishRequest)
	return nil
}

func (o PublishRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *PublishRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type PublishResponse struct {
	// Published action version for action name.
	Actions map[string]Version `json:"actions" conjure-docs:"Published action version for action name."`
}

func (o PublishResponse) MarshalJSON() ([]byte, error) {
	if o.Actions == nil {
		o.Actions = make(map[string]Version, 0)
	}
	type PublishResponseAlias PublishResponse
	return safejson.Marshal(PublishResponseAlias(o))
}

func (o *PublishResponse) UnmarshalJSON(data []byte) error {
	type PublishResponseAlias PublishResponse
	var rawPublishResponse PublishResponseAlias
	if err := safejson.Unmarshal(data, &rawPublishResponse); err != nil {
		return err
	}
	if rawPublishResponse.Actions == nil {
		rawPublishResponse.Actions = make(map[string]Version, 0)
	}
	*o = PublishResponse(rawPublishResponse)
	return nil
}

func (o PublishResponse) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *PublishResponse) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ResumeRequest struct {
	// Action ids to resume. IF EMTPY, ALL ACTIONS IN PROJECT WILL BE RESUMED.
	Actions []string `json:"actions" conjure-docs:"Action ids to resume. IF EMTPY, ALL ACTIONS IN PROJECT WILL BE RESUMED."`
}

func (o ResumeRequest) MarshalJSON() ([]byte, error) {
	if o.Actions == nil {
		o.Actions = make([]string, 0)
	}
	type ResumeRequestAlias ResumeRequest
	return safejson.Marshal(ResumeRequestAlias(o))
}

func (o *ResumeRequest) UnmarshalJSON(data []byte) error {
	type ResumeRequestAlias ResumeRequest
	var rawResumeRequest ResumeRequestAlias
	if err := safejson.Unmarshal(data, &rawResumeRequest); err != nil {
		return err
	}
	if rawResumeRequest.Actions == nil {
		rawResumeRequest.Actions = make([]string, 0)
	}
	*o = ResumeRequest(rawResumeRequest)
	return nil
}

func (o ResumeRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ResumeRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type SecretsPayload struct {
	Secrets map[string]string `json:"secrets"`
}

func (o SecretsPayload) MarshalJSON() ([]byte, error) {
	if o.Secrets == nil {
		o.Secrets = make(map[string]string, 0)
	}
	type SecretsPayloadAlias SecretsPayload
	return safejson.Marshal(SecretsPayloadAlias(o))
}

func (o *SecretsPayload) UnmarshalJSON(data []byte) error {
	type SecretsPayloadAlias SecretsPayload
	var rawSecretsPayload SecretsPayloadAlias
	if err := safejson.Unmarshal(data, &rawSecretsPayload); err != nil {
		return err
	}
	if rawSecretsPayload.Secrets == nil {
		rawSecretsPayload.Secrets = make(map[string]string, 0)
	}
	*o = SecretsPayload(rawSecretsPayload)
	return nil
}

func (o SecretsPayload) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *SecretsPayload) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type StateChangedFilter struct {
	Contract      ContractReference `json:"contract"`
	Key           *string           `json:"key"`
	Field         *string           `json:"field"`
	Value         *ComparableAny    `json:"value"`
	PreviousValue *ComparableAny    `json:"previousValue"`
}

func (o StateChangedFilter) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *StateChangedFilter) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type StopRequest struct {
	// Action ids to stop. IF EMTPY, ALL ACTIONS IN PROJECT WILL BE STOPPED.
	Actions []string `json:"actions" conjure-docs:"Action ids to stop. IF EMTPY, ALL ACTIONS IN PROJECT WILL BE STOPPED."`
}

func (o StopRequest) MarshalJSON() ([]byte, error) {
	if o.Actions == nil {
		o.Actions = make([]string, 0)
	}
	type StopRequestAlias StopRequest
	return safejson.Marshal(StopRequestAlias(o))
}

func (o *StopRequest) UnmarshalJSON(data []byte) error {
	type StopRequestAlias StopRequest
	var rawStopRequest StopRequestAlias
	if err := safejson.Unmarshal(data, &rawStopRequest); err != nil {
		return err
	}
	if rawStopRequest.Actions == nil {
		rawStopRequest.Actions = make([]string, 0)
	}
	*o = StopRequest(rawStopRequest)
	return nil
}

func (o StopRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *StopRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type StoragePayload struct {
	Id    string `json:"id"`
	Token string `json:"token"`
}

func (o StoragePayload) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *StoragePayload) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type TransactionFilter struct {
	// ORed set of filters.
	Any []Filter `json:"any" conjure-docs:"ORed set of filters."`
	// ANDed with any result.
	And *TransactionFilter `json:"and" conjure-docs:"ANDed with any result."`
}

func (o TransactionFilter) MarshalJSON() ([]byte, error) {
	if o.Any == nil {
		o.Any = make([]Filter, 0)
	}
	type TransactionFilterAlias TransactionFilter
	return safejson.Marshal(TransactionFilterAlias(o))
}

func (o *TransactionFilter) UnmarshalJSON(data []byte) error {
	type TransactionFilterAlias TransactionFilter
	var rawTransactionFilter TransactionFilterAlias
	if err := safejson.Unmarshal(data, &rawTransactionFilter); err != nil {
		return err
	}
	if rawTransactionFilter.Any == nil {
		rawTransactionFilter.Any = make([]Filter, 0)
	}
	*o = TransactionFilter(rawTransactionFilter)
	return nil
}

func (o TransactionFilter) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *TransactionFilter) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type TransactionLog struct {
	Address string   `json:"address"`
	Topics  []string `json:"topics"`
	Data    string   `json:"data"`
}

func (o TransactionLog) MarshalJSON() ([]byte, error) {
	if o.Topics == nil {
		o.Topics = make([]string, 0)
	}
	type TransactionLogAlias TransactionLog
	return safejson.Marshal(TransactionLogAlias(o))
}

func (o *TransactionLog) UnmarshalJSON(data []byte) error {
	type TransactionLogAlias TransactionLog
	var rawTransactionLog TransactionLogAlias
	if err := safejson.Unmarshal(data, &rawTransactionLog); err != nil {
		return err
	}
	if rawTransactionLog.Topics == nil {
		rawTransactionLog.Topics = make([]string, 0)
	}
	*o = TransactionLog(rawTransactionLog)
	return nil
}

func (o TransactionLog) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *TransactionLog) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type TransactionPayload struct {
	Network     string           `json:"network"`
	BlockHash   string           `json:"blockHash"`
	BlockNumber int              `json:"blockNumber"`
	Hash        string           `json:"hash"`
	From        string           `json:"from"`
	To          *string          `json:"to"`
	Logs        []TransactionLog `json:"logs"`
	// Optional because it is added later so some payloads don't have it.
	Input *string `json:"input" conjure-docs:"Optional because it is added later so some payloads don't have it."`
	// Optional because it is added later so some payloads don't have it.
	Value *string `json:"value" conjure-docs:"Optional because it is added later so some payloads don't have it."`
	// Optional because it is added later so some payloads don't have it.
	Nonce *string `json:"nonce" conjure-docs:"Optional because it is added later so some payloads don't have it."`
	// Optional because it is added later so some payloads don't have it.
	Gas *string `json:"gas" conjure-docs:"Optional because it is added later so some payloads don't have it."`
	// Optional because it is added later so some payloads don't have it.
	GasUsed *string `json:"gasUsed" conjure-docs:"Optional because it is added later so some payloads don't have it."`
	// Optional because it is added later so some payloads don't have it.
	CumulativeGasUsed *string `json:"cumulativeGasUsed" conjure-docs:"Optional because it is added later so some payloads don't have it."`
	// Optional because it is added later so some payloads don't have it.
	GasPrice *string `json:"gasPrice" conjure-docs:"Optional because it is added later so some payloads don't have it."`
	// Optional because it is added later so some payloads don't have it.
	GasTipCap *string `json:"gasTipCap" conjure-docs:"Optional because it is added later so some payloads don't have it."`
	// Optional because it is added later so some payloads don't have it.
	GasFeeCap *string `json:"gasFeeCap" conjure-docs:"Optional because it is added later so some payloads don't have it."`
	AlertId   *string `json:"alertId"`
}

func (o TransactionPayload) MarshalJSON() ([]byte, error) {
	if o.Logs == nil {
		o.Logs = make([]TransactionLog, 0)
	}
	type TransactionPayloadAlias TransactionPayload
	return safejson.Marshal(TransactionPayloadAlias(o))
}

func (o *TransactionPayload) UnmarshalJSON(data []byte) error {
	type TransactionPayloadAlias TransactionPayload
	var rawTransactionPayload TransactionPayloadAlias
	if err := safejson.Unmarshal(data, &rawTransactionPayload); err != nil {
		return err
	}
	if rawTransactionPayload.Logs == nil {
		rawTransactionPayload.Logs = make([]TransactionLog, 0)
	}
	*o = TransactionPayload(rawTransactionPayload)
	return nil
}

func (o TransactionPayload) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *TransactionPayload) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type TransactionPayloadRequest struct {
	Network string `json:"network"`
	Hash    string `json:"hash"`
}

func (o TransactionPayloadRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *TransactionPayloadRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type TransactionPayloadSummary struct {
	Network     string `json:"network"`
	BlockHash   string `json:"blockHash"`
	BlockNumber int    `json:"blockNumber"`
	Hash        string `json:"hash"`
}

func (o TransactionPayloadSummary) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *TransactionPayloadSummary) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type TransactionSimpleTrigger struct {
}

func (o TransactionSimpleTrigger) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *TransactionSimpleTrigger) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type TransactionTrigger struct {
	Status []TransactionStatus `json:"status"`
	Filter TransactionFilter   `json:"filter"`
}

func (o TransactionTrigger) MarshalJSON() ([]byte, error) {
	if o.Status == nil {
		o.Status = make([]TransactionStatus, 0)
	}
	type TransactionTriggerAlias TransactionTrigger
	return safejson.Marshal(TransactionTriggerAlias(o))
}

func (o *TransactionTrigger) UnmarshalJSON(data []byte) error {
	type TransactionTriggerAlias TransactionTrigger
	var rawTransactionTrigger TransactionTriggerAlias
	if err := safejson.Unmarshal(data, &rawTransactionTrigger); err != nil {
		return err
	}
	if rawTransactionTrigger.Status == nil {
		rawTransactionTrigger.Status = make([]TransactionStatus, 0)
	}
	*o = TransactionTrigger(rawTransactionTrigger)
	return nil
}

func (o TransactionTrigger) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *TransactionTrigger) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ValidateError struct {
	Name    string `json:"name"`
	Message string `json:"message"`
}

func (o ValidateError) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ValidateError) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ValidateFileRequest struct {
	Action ActionSpec `json:"action"`
}

func (o ValidateFileRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ValidateFileRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ValidateRequest struct {
	// Map from action name to action spec.
	Actions map[string]ActionSpec `json:"actions" conjure-docs:"Map from action name to action spec."`
	// Used to decide if new logic layer to be published or old can be reused.
	LogicVersion *string `json:"logicVersion" conjure-docs:"Used to decide if new logic layer to be published or old can be reused."`
	// Used to decide if new dependencies layer needs to be published or old can be reused.
	DependenciesVersion *string `json:"dependenciesVersion" conjure-docs:"Used to decide if new dependencies layer needs to be published or old can be reused."`
}

func (o ValidateRequest) MarshalJSON() ([]byte, error) {
	if o.Actions == nil {
		o.Actions = make(map[string]ActionSpec, 0)
	}
	type ValidateRequestAlias ValidateRequest
	return safejson.Marshal(ValidateRequestAlias(o))
}

func (o *ValidateRequest) UnmarshalJSON(data []byte) error {
	type ValidateRequestAlias ValidateRequest
	var rawValidateRequest ValidateRequestAlias
	if err := safejson.Unmarshal(data, &rawValidateRequest); err != nil {
		return err
	}
	if rawValidateRequest.Actions == nil {
		rawValidateRequest.Actions = make(map[string]ActionSpec, 0)
	}
	*o = ValidateRequest(rawValidateRequest)
	return nil
}

func (o ValidateRequest) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ValidateRequest) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type ValidateResponse struct {
	// Set of action names that would be created on publish.
	Create []string `json:"create" conjure-docs:"Set of action names that would be created on publish."`
	// Set of action names that would be updated on publish.
	Update []string `json:"update" conjure-docs:"Set of action names that would be updated on publish."`
	// Map from action name to errors, for action resources that have errors.
	Errors            map[string][]ValidateError `json:"errors" conjure-docs:"Map from action name to errors, for action resources that have errors."`
	LogicFound        bool                       `json:"logicFound"`
	DependenciesFound bool                       `json:"dependenciesFound"`
}

func (o ValidateResponse) MarshalJSON() ([]byte, error) {
	if o.Create == nil {
		o.Create = make([]string, 0)
	}
	if o.Update == nil {
		o.Update = make([]string, 0)
	}
	if o.Errors == nil {
		o.Errors = make(map[string][]ValidateError, 0)
	}
	type ValidateResponseAlias ValidateResponse
	return safejson.Marshal(ValidateResponseAlias(o))
}

func (o *ValidateResponse) UnmarshalJSON(data []byte) error {
	type ValidateResponseAlias ValidateResponse
	var rawValidateResponse ValidateResponseAlias
	if err := safejson.Unmarshal(data, &rawValidateResponse); err != nil {
		return err
	}
	if rawValidateResponse.Create == nil {
		rawValidateResponse.Create = make([]string, 0)
	}
	if rawValidateResponse.Update == nil {
		rawValidateResponse.Update = make([]string, 0)
	}
	if rawValidateResponse.Errors == nil {
		rawValidateResponse.Errors = make(map[string][]ValidateError, 0)
	}
	*o = ValidateResponse(rawValidateResponse)
	return nil
}

func (o ValidateResponse) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *ValidateResponse) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type Version struct {
	Id              string            `json:"id"`
	Index           int               `json:"index"`
	ActionId        string            `json:"actionId"`
	Runtime         Runtime           `json:"runtime"`
	Function        Function          `json:"function"`
	TriggerType     TriggerType       `json:"triggerType"`
	Trigger         *Trigger          `json:"trigger"`
	Commitish       *string           `json:"commitish"`
	Source          *string           `json:"source"`
	CreatedAt       datetime.DateTime `json:"createdAt"`
	DeployRequested bool              `json:"deployRequested"`
	DeployError     *string           `json:"deployError"`
}

func (o Version) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *Version) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type WebhookPayload struct {
	Timestamp int                    `json:"timestamp"`
	Body      map[string]interface{} `json:"body"`
}

func (o WebhookPayload) MarshalJSON() ([]byte, error) {
	if o.Body == nil {
		o.Body = make(map[string]interface{}, 0)
	}
	type WebhookPayloadAlias WebhookPayload
	return safejson.Marshal(WebhookPayloadAlias(o))
}

func (o *WebhookPayload) UnmarshalJSON(data []byte) error {
	type WebhookPayloadAlias WebhookPayload
	var rawWebhookPayload WebhookPayloadAlias
	if err := safejson.Unmarshal(data, &rawWebhookPayload); err != nil {
		return err
	}
	if rawWebhookPayload.Body == nil {
		rawWebhookPayload.Body = make(map[string]interface{}, 0)
	}
	*o = WebhookPayload(rawWebhookPayload)
	return nil
}

func (o WebhookPayload) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *WebhookPayload) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type WebhookPayloadSummary struct {
	Time datetime.DateTime `json:"time"`
}

func (o WebhookPayloadSummary) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *WebhookPayloadSummary) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type WebhookResponse struct {
}

func (o WebhookResponse) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *WebhookResponse) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}

type WebhookTrigger struct {
	Authenticated bool `json:"authenticated"`
}

func (o WebhookTrigger) MarshalYAML() (interface{}, error) {
	jsonBytes, err := safejson.Marshal(o)
	if err != nil {
		return nil, err
	}
	return safeyaml.JSONtoYAMLMapSlice(jsonBytes)
}

func (o *WebhookTrigger) UnmarshalYAML(unmarshal func(interface{}) error) error {
	jsonBytes, err := safeyaml.UnmarshalerToJSONBytes(unmarshal)
	if err != nil {
		return err
	}
	return safejson.Unmarshal(jsonBytes, *&o)
}
