

## 1. `generate_diff_report.py`

### 概要
このスクリプトは、Gitリポジトリ内の最新のリリースと前回のリリースの間の差分を取得し、それをマークダウン形式のレポートに変換します。

### 主な機能
- **`run_command`関数**: 指定されたコマンドを実行し、その出力をキャプチャして表示します。
- **`get_git_diff`関数**: 最新のGitタグを取得し、それと前のタグの間の差分を生成します。
- **`generate_markdown_report`関数**: 差分情報を整理し、マークダウン形式のレポートを生成します。
- **`main`関数**: 全体のプロセスを管理し、実行します。

---

## 2. `get_diff.py`

### 概要
このスクリプトは、現在のGitリポジトリのステージングエリアにある変更を取得し、その差分を表示します。

### 主な機能
- **リポジトリの初期化**: 指定されたパスのGitリポジトリを初期化します。
- **差分の取得**: ステージングエリアにある変更を取得し、それを表示します。

---

## 3. `get_issues.py`

### 概要
このスクリプトは、指定されたGitHubリポジトリから開いているIssueを取得し、そのデータをJSONファイルとして保存します。

### 主な機能
- **GitHub APIの使用**: GitHub APIを利用して、指定されたリポジトリから開いているIssueを取得します。
- **データの保存**: 取得したIssueデータをJSON形式で保存します。

---

## 4. `make_issue_res.py`

### 概要
このスクリプトは、取得したIssueデータを元に、指定されたテンプレートを使用してマークダウンファイルを生成します。

### 主な機能
- **テンプレートの読み込み**: 指定されたテンプレートファイルを読み込みます。
- **マークダウンファイルの生成**: 各Issueに対してテンプレートを適用し、マークダウンファイルを生成します。

---

以上が`example`フォルダ内の各ファイルの日本語解説です。それぞれのスクリプトは、SourceSageプロジェクトの様々な自動化タスクをサポートするために設計されています。