<div align="center">

![LiteLLM Test Tools](../assets/script-header.svg)

このディレクトリには、LiteLLMプロキシサーバーの機能をテストするための各種スクリプトが含まれています。

</div>

## 🛠️ セットアップ

必要なパッケージのインストール:
```bash
pip install -r requirements.txt
```

## 📝 利用可能なスクリプト

### チャット補完テスト
`test_simple_chat.py`
- 通常のチャット補完とJSON形式での応答をテスト
- Claude 3.5 Sonnetを使用
- システムプロンプトとユーザープロンプトの設定
- トークン使用量の確認

### 埋め込みモデルテスト
`test_embeddings.py`
- AWS Bedrockの各種埋め込みモデルをテスト
  - amazon.titan-embed-text-v1
  - cohere.embed-english-v3
  - cohere.embed-multilingual-v3
- テキストの多言語対応確認
- 処理時間と次元数の計測

### シンプル埋め込みテスト
`test_simple_embedding.py`
- OpenAI互換APIを使用した埋め込みテスト
- 英語と日本語のテキストサンプル使用
- ベクトル次元数とトークン使用量の確認

### モデルサポートチェック
`check_json_support.py`
- 各モデルのJSON応答フォーマットサポート状況を確認
- 詳細なレポート生成
- サポート/非サポートモデルの一覧作成

### パラメータサポートチェック
`check_model_params.py`
- 各モデルがサポートするパラメータを確認
- パラメータをカテゴリ別に分類
- 詳細なサポート状況レポート生成

## 📊 ログ出力

すべてのテストスクリプトは`loguru`を使用して：
- コンソールにリアルタイムで進捗を表示
- 日付付きのログファイルを生成 (`*_test_{time}.log`)
- エラー発生時は詳細情報を記録

## ⚠️ エラーハンドリング

主なエラーと対処方法：

1. レートリミット (429)
   - エラーメッセージ: "レートリミットに達しました"
   - 対処: リクエスト間に待機時間を設定（デフォルト20秒）

2. 接続エラー
   - API_BASEの設定を確認
   - ネットワーク接続を確認

3. 認証エラー
   - 環境変数の設定を確認
   - APIキーの有効性を確認

## 🔍 詳細情報

その他の詳細については、[メインのREADME](/README.md#-テストツール)を参照してください。
