# Webhooks

## About this directory

* `src/webhooks/lib/index.js` is human-editable.
* `src/rest/data/**/*.payload.json` are manually edited and copied. When a new GHES release is created, the static webhook files from the previous version's directory are copied to a new version directory.

## Editable files

* `src/webhooks/lib/index.js` consumes the static JSON files in `src/webhooks/data` and exports the data used by the REST middleware contextualizer.

## Static files

Generated by `src/rest/scripts/update-files.js`:

* `src/rest/data` - files generated from the dereferenced OpenAPI schema with the Markdown descriptions rendered in HTML
* `src/rest/data/dereferenced` - **NOTE** These are only generated if you pass the --keep-dereferenced-files option and are not checked into the repository. This option is for debug only.

## Rendering docs

When the server starts, `middleware/contextualizers/webhooks.js` accesses the data exported from the static webhook JSON files, fetches the data for the current version and requested path, and adds it to the `context` object. The added property is:

* `req.context.webhookPayloadsForCurrentVersion` - all webhook payloads with a version matching the current version

Markdown files in `content/developers/webhooks-and-events/webhooks/webhook-events-and-payloads.md` use Liquid to display the webhook payloads in `req.context.webhookPayloadsForCurrentVersion`. For example `{{ webhookPayloadsForCurrentVersion.user.created }}` references the payload file `user.created.payload.json` for the version being viewed.

**Note** Payload files either contain the webhook action type or no action type at all. For example, `user.created.payload.json` is the webhook `user` with the action type of `created`. Not all webhooks have action types. If a file exists with no action type (e.g., `user.payload.json`) and the action types (e.g., `user.created.payload.json` and `user.deleted.payload.json`), the entry in the context for the file with no action type will be `default`. For example, for the three static file mentioned, the object would be:

```
{
  user: {
    default: "STRING VALUE",
    created: "STRING VALUE",
    deleted: "STRING VALUE"
  }
}
```

If no action types exist, and only `user.payload.json` exists, the object would be:

```
{
  user: "STRING VALUE"
}
