# REST

## About this directory

* `src/rest/lib/index.js` is human-editable.
* `src/rest/data/*.json` are generated by [scripts](../../src/rest/scripts/README.md).

## Editable files

* `src/rest/lib/index.js` consumes the static decorated schema files and exports `categories`, `operations`, and `operationsEnabledForGitHubApps` used by the REST middleware contextualizer.

## Static files

Generated by `src/rest/scripts/update-files.js`:

* `src/rest/data` - files generated from the dereferenced OpenAPI schema with the Markdown descriptions rendered in HTML
* `src/rest/data/dereferenced` - **NOTE** These are only generated if you pass the --keep-dereferenced-files option and are not checked into the repository. This option is for debug only.

## Rendering docs

When the server starts, `middleware/contextualizers/rest.js` accesses the data exported from the static decorated JSON files, fetches the data for the current version and requested path, and adds it to the `context` object. The added property is:

* `req.context.currentRestOperations` - all operations with a category matching the current path

Markdown files in `content/rest/reference` use Liquid to loop over these context properties. The Liquid calls HTML files in the `includes` directory to do most of the rendering. Writers can add content to the Markdown files alongside the Liquid.
