# Product landing examples

Pages that use the `product-landing` layout may optionally include an `Examples` section. Currently, we support three types of examples:

1. Code examples
  See https://docs.github.com/en/codespaces#code-examples.

2. Community examples
  See https://docs.github.com/en/discussions#community-examples.

3. User examples
  See https://docs.github.com/en/sponsors#community-examples.

## How it works

Example data for each product is defined in `data/product-landing-examples`, in a subdirectory named for the **product** and a YML file named for the **example type** (e.g., `data/product-examples/sponsors/user-examples.yml` or `data/product-examples/codespaces/code-examples.yml`). We currently only support one type of example per product.

### Versioning

At the moment, versioning is only supported in code examples. If an example block should be available in **all** versions, you don't need to do anything special. But if an example block should only be available in some versions, you can add a `versions` prop like this:

```
- title: Dependabot version update PR
  description: Example pull request generated by the Dependabot version updates configuration in the Super linter repository.
  href: /github/super-linter/pull/1398
  languages:
  tags:
    - Dependabot
    - Version updates
    - Pull requests
  versions:
    fpt: '*'
  ```

where the syntax for `versions` is the same as the [frontmatter `versions` property](content/README.md) and can support semver notation.

## Rendering

The product example data is added to the `context` object in `middleware/contextualizers/product-examples.js`.

The data is then rendered by `components/landing`.

## Schema enforcement

TODO
