# Using videos in GitHub Docs content

Videos are used in conjunction with written text to help users understand content in the GitHub docs.

Use these guidelines to determine if a video is appropriate to include in an article or on a landing page in the GitHub docs. If you have questions about whether or not a video would be a good addition to the docs, contact the Docs Content Strategy team.

If you add a link to a video or embed a video in the GitHub Docs, add the video's metadata to the "[Videos in GitHub Docs](#videos-in-github-docs)" section below.

The Docs team does not create or maintain video content. Videos are purely supplemental to help communicate significant or complex topics, and should be used sparingly because they aren't a content type owned by the Docs team.

## Video checklist

Use this checklist to quickly determine if a video might be appropriate to add to an article or landing page.

- [ ] Does GitHub own the video?
- [ ] Is the video well produced? (See the [Best practices](#best-practices) below for more information)
- [ ] Is the video accessible? (See the [Accessibility requirements](#accessibility-requirements))
- [ ] Is the video less than five minutes long?
- [ ] Does the video have a specific audience and purpose in the docs? If it is only relevant to a particular product or feature, you must use [versioning](#versioning)

If you answer "no" to any of these items, the video is not suitable for adding to the GitHub docs.

### Maintenance

Does the video have a maintenance schedule or a team directly responsible for auditing and updating the content if it becomes out of date?

If yes, you can include the video without any additional steps.

If no, create an issue with an appropriate target date to review or remove the video.

## Best practices

Good videos introduce an instructional agenda that includes steps and goals so that someone watching quickly knows what they will learn. Videos are demonstrative, both showing and explaining the relevant steps that are performed. Videos should be engaging and encouraging. Videos must be well produced to be included in the GitHub docs. A well produced video meets accessibility requirements, has professional narration (if it is a narrated video), has clear visuals, and comes from a reputable source such as GitHub or Microsoft.

Videos are broadly grouped into three categories: product overviews, feature videos, and tutorials. These descriptions are generalizations of each video type. Some videos might not fit perfectly in one category, but can still be useful without meeting the exact guidelines.

### Product overviews
- **Purpose**: Briefly explain what the product is, showcase the main functionality, and get people interested
- **Length**: Less than a minute
- **Possible audiences**: People who want to know if a feature is useful for their goals, people who are new to GitHub and trying to understand what the products do
- **Possible locations in the docs**: Landing pages and guides
- **Example**: "[GitHub Discussions in 60 seconds](https://www.youtube.com/watch?time_continue=28&v=IpBw2SJkFyk&feature=emb_title)" on the [Discussions landing page](https://docs.github.com/en/discussions)

### Feature videos
- **Purpose**: Supplement conceptual or procedural content
- **Length**: As short as possible, without exceeding five minutes. Break longer content into multiple shorter, focused videos
- **Possible audiences**: People who are learning about or how to use a feature
- **Possible locations in the docs**: Guides, conceptual articles, procedural articles
- **Example:** "[Pull Requests • GitHub & Git Foundations](https://www.youtube.com/watch?v=d5wpJ5VimSU&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=20)" in "[Git and GitHub learning resources](https://docs.github.com/en/get-started/quickstart/git-and-github-learning-resources#tune-in)"

### Tutorials
- **Purpose**: Help novice users get going with a product, drive adoption, or explain complex functionalities
- **Length**: Individual videos should be five minutes or less. Complex topics can have a series of shorter videos spread across an article. Total length should be a maximum of 15 minutes
- **Possible audiences**: New users of features or products
- **Possible locations**: Guides
- **Example:** "[Setting up your GitHub Enterprise licenses with Visual Studio subscriptions](https://www.youtube.com/watch?v=P_zBgp_BE_I)" in "[Setting up Visual Studio subscriptions with GitHub Enterprise](https://docs.github.com/en/enterprise-cloud@latest/billing/managing-licenses-for-visual-studio-subscriptions-with-github-enterprise/setting-up-visual-studio-subscriptions-with-github-enterprise#about-setup-of-visual-studio-subscriptions-with-github-enterprise)"

## When to use videos

We might use videos instead of other visuals such as screenshots or diagrams when it is important to show movement or changes in state, like when someone navigates from one screen to another or demos a feature that involves progressing through multiple menus.

Videos can also be helpful to introduce features or products where a 30 second video can supplement information that requires multiple paragraphs to write.

Use videos that explain the value of the procedure or concept that they are showing.

## When to not use videos

Do not use videos for features that change quickly and may make videos out of date. Do not use videos that contradict the written content or violate any parts of the [content style guide](./content-style-guide.md). Do not use videos that just show a task without explaining or elaborating on the procedure.

## Accessibility requirements

These are the minimum accessibility requirements for a video to be included in the GitHub docs. If a video violates any of these requirements, it cannot be added to the docs. Videos must meet the MAS-C standards for accessibility.

- No flashing or strobe effects
- Must have [closed captions](https://webaim.org/techniques/captions/#captions). See "[Creating video captions](#creating-video-captions)" below for more information
- No graphics overlap with where captions appear
- Typography must be legible
- Any overlays must meet [WCAG contrast standards](https://webaim.org/articles/contrast/)
- Any text must be on the screen long enough to be read (the text should appear onscreen for longer than it takes to read it out loud twice)
- Must have proofread [descriptive transcripts](https://www.w3.org/WAI/media/av/transcripts/) for what happens scene-by-scene. See "[Creating video transcripts](#creating-video-transcripts)" below for more information
- Videos do not autoplay

### Creating video captions

Videos must have human-generated captions before being added to the Docs site. You can use auto caption technology to help create the captions, but they must be proofread and edited for accuracy by a person. If the video hosting service has a native caption tool, like YouTube, you can use that tool to prepare captions or create a properly formatted `SRT` or `VTT` transcript file to upload with the video.

Creating captions is part of the process of producing accessible videos, so the owner of a video being added to GitHub Docs should provide captions.

#### Guidelines for captions

Where possible, captions should exactly match the words spoken in the video. Do not paraphrase or truncate captions, unless serious time constraints mean it would be difficult for someone to read the captions in the time given.

Captions must be synchronized to appear at approximately the same time as the audio. Captions should always be timed to appear on screen at the moment the speaker begins talking. For fast speech, where it would be difficult to read captions timed precisely to the audio, you can extend the captions to stay on screen after the speech has finished.

If a video has multiple speakers, identify the speakers in the captions. Do this by adding the speaker's name, or a descriptive name such as `Developer`, before the start of the sentence. For example: `Jimmy: Hello.`. You only need to do this when the speaker changes, not for every line of dialogue. If it's obvious from the visuals who is speaking, you do not need to identify the speaker.

Captions must be one or two lines, and no more than 32 characters per line. Put each new sentence on a new line. If you need to break a line mid-sentence, do so at a logical point, for example after commas or before conjunctions like `and` or `but`.

#### Adding and editing captions on YouTube

For videos hosted on YouTube, see "[Add subtitles and captions](https://support.google.com/youtube/answer/2734796?hl=en&ref_topic=7296214)" and "[Edit or remove captions](https://support.google.com/youtube/answer/2734705?hl=en&ref_topic=7296214)" in the YouTube docs.

### Creating video transcripts

A descriptive transcript includes a text version of both audio and visual information needed to understand the content of a video.

Creating transcripts is part of the process of producing accessible videos, so the owner of a video being added to the docs site should provide the transcript.

If you have captions, you can use them to create the transcript. Edit the captions to remove any timestamps and include the relevant information detailed below. Create an article in [`content/video-transcripts`](https://github.com/github/docs/tree/main/content/video-transcripts) with the transcript. Title the article `Transcript - VIDEO NAME`.

- If a video has multiple speakers, identify the speakers in the transcript
- Format the transcript in logical paragraphs, lists, and sections. If it helps people understand the content, you may add headers to sections. Consider how someone would get information from the transcript if they are not also viewing the video
- Add any onscreen text, relevant visual elements, or non-speech sounds that are not included in the captions. Place these descriptions after the spoken text that accompanies them in the video. Format visual information in brackets. For example, `[Background music plays. The narrator clicks the Code button and then the "+ New codespace" button.]`
- Add a `product_video_transcript` property below the `product_video` property in the article utilizing the video. The value of `product_video_transcript` is a link to the transcript article
- Link to the YouTube URL of the video in the transcript article's `product_video` property. This will display in the transcript as an external link to the video.
- At the end of the transcript, link to the landing page for the product the video is about using the pattern `For more information about PRODUCT, see the ["Product" documentation](link/to/landing-page).`

See "[Text Transcript with Description of Visuals](https://www.w3.org/WAI/perspective-videos/captions/#transcript)" in the W3C docs for more examples of audio and visual transcriptions.

#### Linking to transcripts from externally hosted videos

Add a link to the article with a video's transcript in the description of the video on the platform where it is hosted. For more information, see "[Edit video settings](https://support.google.com/youtube/answer/57404?)" in the YouTube documentation.

## Titles for videos

Titles should be descriptive and follow the guidelines for titles in the [content model](./content-model.md#titles).

## Versioning

If a video is only relevant for specific GitHub products (Free, Pro and Team; GitHub Enterprise Server; GitHub AE; and GitHub Enterprise Cloud), the video must be versioned for those products. Use [Liquid](liquid-helpers.md) conditional statements to version the videos appropriately. The Liquid conditional versioning may need to be added when the content is initially created, or may need to be added when the content is updated for a feature update or Enterprise release.

## Video hosting

Videos must be hosted somewhere that GitHub owns and can grant the Docs team access to. Videos should not track users or use cookies. Currently, GitHub's videos are hosted on YouTube and added to the docs using the [Privacy Enhanced Mode](https://support.google.com/youtube/answer/171780?hl=en#zippy=%2Cturn-on-privacy-enhanced-mode) by changing the domain for the embedded URL from `https://www.youtube.com/VIDEO` to `https://www.youtube-nocookie.com/VIDEO`.

## Resources
- https://webaim.org
- https://www.w3.org/TR/WCAG22/#time-based-media

## Videos in GitHub Docs

Add the following metadata for each video added to the GitHub Docs.

```markdown{:copy}
Title: Video title
URL: YouTube.com/
Description: One sentence
Product: e.x. Projects
Versions: e.x. fpt, GHES > 3.2
Date added: YYYY-MM-DD
Location: /where/in/docs
Transcript: ./content/video-transcripts/filename
```

```
Title: GitHub Actions - Supercharge your GitHub Flow
URL: https://www.youtube-nocookie.com/embed/cP0I9w2coGU
Description: A 3 minute overview of how GitHub Actions fits in the GitHub flow.
Product: Actions
Versions: All
Date added: 2020-12-03
Location: content/actions/index.md
Transcript: TBD
```

```
Title: Codespaces - Your instant dev box in the cloud
URL: https://www.youtube-nocookie.com/embed/_W9B7qc9lVc
Description: A 1.5 minute overview of GitHub Codespaces.
Product: Codespaces
Versions: fpt, ghec
Date added: 2021-05-11
Location: /content/codespaces/index.md
Transcript: TBD
```

```
Title: GitHub Discussions in 60 seconds
URL: https://www.youtube-nocookie.com/embed/IpBw2SJkFyk
Description: A 1 minute overview of GitHub Discussions.
Product: Discussions
Versions: fpt, ghec, ghes > 3.5
Date added: 2021-01-20
Location: /content/discussions/index.md
Transcript: TBD
```

```
Title: GitHub Classroom Getting Started Guide
URL: https://www.youtube.com/playlist?list=PLIRjfNq867bewk3ZGV6Z7a16YDNRCpK3u
Description: A 9 video series introducing GitHub Classroom.
Product: Classroom
Versions: fpt
Date added: ?
Location: content/education/manage-coursework-with-github-classroom/get-started-with-github-classroom/basics-of-setting-up-github-classroom.md
Transcript: TBD
```

```
Title: Pull Requests • GitHub & Git Foundations
URL: https://www.youtube.com/watch?v=d5wpJ5VimSU&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=19
Description: A 4.5 minute video introducing pull requests.
Product: Pull requests, getting started
Versions: All
Date added: ?
Location: content/get-started/quickstart/git-and-github-learning-resources.md
Transcript: TBD
```

```
Title: Rebase • GitHub & Git Foundations
URL: https://www.youtube.com/watch?v=SxzjZtJwOgo&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=22
Description: A 4.5 minute introduction to using Git Rebase.
Product: Getting started
Versions: All
Date added: ?
Location: content/get-started/quickstart/git-and-github-learning-resources.md
Transcript: TBD
```

```
Title: Reset• GitHub & Git Foundations
URL: https://www.youtube.com/watch?v=BKPjPMVB81g
Description: A 4 minute introduction to using Git Reset.
Product: Getting started
Versions: All
Date added: ?
Location: content/get-started/quickstart/git-and-github-learning-resources.md
Transcript: TBD
```

```
Title: Forking • GitHub & Git Foundations
URL: https://www.youtube.com/watch?v=5oJHRbqEofs
Description: A 2 minute introduction to forking projects on GitHub.
Product: Getting started
Versions: All
Date added: ?
Location: content/get-started/quickstart/git-and-github-learning-resources.md
Transcript: TBD
```

```
Title: Git & GitHub: Working Locally
URL: https://www.youtube.com/watch?v=rBbbOouhI-s&index=2&list=PLg7s6cbtAD17Gw5u8644bgKhgRLiJXdX4
Description: A 1.5 minute overview of working locally in the command line.
Product: Getting started
Versions: All
Date added: ?
Location: content/get-started/using-git/about-git.md
Transcript: TBD
```

```
Title: Git & GitHub: Git Status
URL: https://www.youtube.com/watch?v=SxmveNrZb5k&list=PLg7s6cbtAD17Gw5u8644bgKhgRLiJXdX4&index=3
Description: A 1 minute overview of the git status command.
Product: Getting started
Versions: All
Date added: ?
Location: content/get-started/using-git/about-git.md
Transcript: TBD
```

```
Title: Git & GitHub: Git Pull and Git Push
URL: https://www.youtube.com/watch?v=-uQHV9GOA0w&index=5&list=PLg7s6cbtAD17Gw5u8644bgKhgRLiJXdX4
Description: A 1 minute introduction to using Git Push and Git Pull.
Product: Getting started
Versions: All
Date added: ?
Location: content/get-started/using-git/about-git.md
Transcript: TBD
```

```
Title: Git & GiHub: Saved Changes
URL: https://www.youtube.com/watch?v=Vb0Ghkkc2hk&index=4&list=PLg7s6cbtAD17Gw5u8644bgKhgRLiJXdX4
Description: A 1.5 minute introduction to saving work and pushing commits.
Product: Getting started
Versions: All
Date added: ?
Location: content/get-started/using-git/about-git.md
Transcript: TBD
```

```
Title: Planning at scale with Issues – GitHub Universe 2021
URL: https://www.youtube-nocookie.com/embed/ha1KHcPMAEk
Description: A 20 minute presentation by Mario Rodriguez.Nbobigogc
Product: Issues
Versions: All
Date added: YYYY-MM-DD
Location: /content/issues/index.md
Transcript: TBD
```

```
Title: Planning at GitHub (Projects + Issues) - GitHub Universe 2021
URL: https://www.youtube-nocookie.com/embed/HwpVvDURHKw
Description: A 20 minute presentation by Matt Butler.
Product: Issues
Versions: All
Date added: 2022-01-19
Location: /content/issues/index.md
Transcript: TBD
```

```
Title: Issue Forms for open source - GitHub Universe 2021
URL: https://www.youtube-nocookie.com/embed/2Yh8ueUE0oY
Description: A 20 minute presentation by Luke Hefson.
Product: Issues
Versions: All
Date added: 2022-01-19
Location: /content/issues/index.md
Transcript: TBD
```

```
Title: GitHub Issues
URL: https://www.youtube-nocookie.com/embed/uiaLWluYJsA
Description: A 2.5 minute overview of Issues for planning and tracking work.
Product: Issues
Versions: All
Date added: 2022-02-02
Location: /content/issues/index.md
Transcript: TBD
```

```
Title: Using Projects for feature planning
URL: https://www.youtube-nocookie.com/embed/yFQ-p6wMS_Y?list=PL0lo9MOBetEG8TZty9Z38oSZAY8FjkaB7&index=1
Description: A 3 minute introduction to Projects for developers.
Product: Issues, Projects
Versions: All
Date added: 2022-08-01
Location: /content/issues/index.md
Transcript: TBD
```
