---
title: Sponsoring an open source contributor
intro: 'You can make a monthly recurring payment to a developer or organization who designs, creates, or maintains open source projects you depend on.'
redirect_from:
  - /articles/sponsoring-a-developer
  - /articles/sponsoring-an-open-source-contributor
  - /github/supporting-the-open-source-community-with-github-sponsors/sponsoring-a-developer
  - /github/supporting-the-open-source-community-with-github-sponsors/sponsoring-an-open-source-contributor
versions:
  fpt: '*'
  ghec: '*'
permissions: Anyone can sponsor accounts on behalf of their own personal account. Organization owners and billing managers can sponsor accounts on behalf of their organization.
type: how_to
topics:
  - Open Source
  - Sponsors payments
shortTitle: Sponsor a contributor
---

{% data reusables.sponsors.paypal-deprecation %}

{% data reusables.sponsors.org-sponsors-release-phase %}

## About sponsorships

{% data reusables.sponsors.sponsorship-details %}

You can sponsor an account on behalf of your personal account to invest in projects that you personally benefit from. You can sponsor an account on behalf of your organization for many reasons.
- Sustaining specific libraries that your organization's work depends on
- Investing in the ecosystem you rely on as an organization (such as blockchain)
- Developing brand awareness as an organization that values open source
- Thanking open source developers for building libraries that complement the product your organization offers

You can use a credit card to sponsor an account on {% data variables.product.product_name %}. If your organization wants to pay by invoice, you can read more at [Paying for {% data variables.product.prodname_sponsors %} via invoice](/sponsors/sponsoring-open-source-contributors/paying-for-github-sponsors-via-invoice).

{% data reusables.sponsors.no-fees %} For more information, see "[About billing for {% data variables.product.prodname_sponsors %}](/articles/about-billing-for-github-sponsors)."

When you sponsor an account using a credit card, the change will become effective immediately. {% data reusables.sponsors.prorated-sponsorship %}

We may share certain limited tax information with sponsored accounts. For more information, see "[Tax information](#tax-information)."

{% data reusables.sponsors.manage-updates-for-orgs %}

You can choose whether to display your sponsorship publicly. One-time sponsorships remain visible for one month.

If the sponsored account retires your tier, the tier will remain in place for you until you choose a different tier or cancel your subscription. For more information, see "[Upgrading a sponsorship](/articles/upgrading-a-sponsorship)" and "[Downgrading a sponsorship](/articles/downgrading-a-sponsorship)."

If the account you want to sponsor does not have a profile on {% data variables.product.prodname_sponsors %}, you can encourage the account to join. For more information, see "[Setting up {% data variables.product.prodname_sponsors %} for your personal account](/sponsors/receiving-sponsorships-through-github-sponsors/setting-up-github-sponsors-for-your-personal-account)" and "[Setting up {% data variables.product.prodname_sponsors %} for your organization](/sponsors/receiving-sponsorships-through-github-sponsors/setting-up-github-sponsors-for-your-organization)."

{% data reusables.sponsors.sponsorships-not-tax-deductible %}

{% note %}

**Note:** {% data variables.product.prodname_dotcom %} is not responsible for how developers represent themselves nor does {% data variables.product.prodname_dotcom %} endorse any sponsored open source projects. The claims are solely the responsibility of the developer receiving the funds. Make sure you trust a person before offering a sponsorship. For more information, see the [{% data variables.product.prodname_sponsors %} Additional Terms](/free-pro-team@latest/github/site-policy/github-sponsors-additional-terms).

{% endnote %}

## Tax information

As a sponsor, you acknowledge that we may disclose to the owner of each account you sponsor the following limited information about your sponsorship payments to the account, since the inception of the Sponsors Program:

- Transaction date
- Amount paid
- The country, state, and province from where payment was made
- Whether payment was made by a business or individual

This information is necessary to enable payment and reporting of any taxes arising from such sponsorship payments.

## Sponsoring an account

Before you can sponsor an account, you must have a verified email address. For more information, see "[Verifying your email address](/github/getting-started-with-github/verifying-your-email-address)."

1. On {% data variables.product.product_name %}, navigate to the profile of the user or organization you want to sponsor.
1. Navigate to your sponsorship dashboard for the account.
   - To sponsor a developer, under the developer's name, click **Sponsor**.
     ![Sponsor button](/assets/images/help/profile/sponsor-button.png)
   - To sponsor an organization, to the right of the organization's name, click **Sponsor**.
     ![Sponsor button](/assets/images/help/sponsors/sponsor-org-button.png)
1. Optionally, on the right side of the page, to sponsor the account on behalf of your organization, use the **Sponsor as** drop-down menu, and click the organization.
  ![Drop-down menu to choose the account you'll sponsor as](/assets/images/help/sponsors/sponsor-as-drop-down-menu.png)
{% data reusables.sponsors.select-a-tier %}
{% data reusables.sponsors.pay-prorated-amount %}
{% data reusables.sponsors.select-sponsorship-billing %}
  ![Edit payment button](/assets/images/help/sponsors/edit-sponsorship-payment-button.png)
{% data reusables.sponsors.who-can-see-your-sponsorship %}
  ![Radio buttons to choose who can see your sponsorship](/assets/images/help/sponsors/who-can-see-sponsorship.png)
{% data reusables.sponsors.choose-updates %}
{% data reusables.sponsors.sponsor-account %}
