---
title: GitHub Privacy Statement
redirect_from:
  - /privacy
  - /privacy-policy
  - /privacy-statement
  - /github-privacy-policy
  - /articles/github-privacy-policy
  - /articles/github-privacy-statement
  - /github/site-policy/github-privacy-statement
  - /site-policy/privacy-policies/global-privacy-practices
versions:
  fpt: '*'
topics:
  - Policy
  - Legal
---

Effective date: December 15, 2022

Thanks for entrusting GitHub, Inc. or GitHub B.V. (“GitHub”, “we”, "us" or "our") with your source code, your projects, and your personal data. This Privacy Statement explains our practices regarding the collection, use, and disclosure of your data, including any personal data we collect and process in connection with our website and any applications, software, products, and services provided by GitHub, including any Beta Previews (collectively, the “Service(s)”).

All capitalized terms have their definition in [GitHub’s Terms of Service](/github/site-policy/github-terms-of-service), unless otherwise noted here.


## The short version

We use your personal information as this Privacy Statement describes. No matter where you are, where you live, or what your citizenship is, you have the same high standard of privacy protection when using GitHub's products as all our users around the world, regardless of their country of origin or location.

To see our Privacy Notice for U.S. Residents, please go to [GitHub's Notice about U.S. State Data Privacy](#us-state-data-privacy) or scroll down.

## Summary

| Section | What can you find there? |
|---|---|
| [Who is responsible for the processing of your information](#who-is-responsible-for-the-processing-of-your-information) | Subject to limited exceptions, GitHub is the controller and entity responsible for the processing of your personal data in connection with the Website or Service if you are in North America. For individuals outside North America the data controller is GitHub B.V. |
| [What information GitHub collects](#what-information-github-collects) | GitHub collects information directly from you for your registration, payment, transactions, and user profile. We also automatically collect from you your usage information, cookies, and device information, subject, where necessary, to your consent. GitHub may also collect personal data from third parties. We only collect the minimum amount of personal data necessary to provide innovative services and personalized experiences, unless you choose to provide more.|
| [How GitHub uses your information](#how-github-uses-your-information) | In this section, we describe the ways in which we use your information, including to provide you the Service, to communicate with you, for security and compliance purposes, and to improve our Website or Service or develop new features and functionality of our Website or Service. We also describe the legal basis upon which we process your information, where legally required. |
| [How we share the information we collect](#how-we-share-the-information-we-collect) | We may share your information with third parties under one of the following circumstances: with your consent, with our service providers, for security purposes, to comply with our legal obligations, or when there is a change of control or sale of corporate entities or business units. We do not sell your personal information and we do not display advertising on GitHub. |
| [Your choices regarding our processing of your personal data](#your-choices-regarding-our-processing-of-your-personal-data) | We provide ways for you to access, alter, or delete your personal information. |
| [Cookies and tracking technologies](#cookies-and-tracking-technologies) | Except for some of the cookies used on our Enterprise Marketing Pages, we only use strictly necessary cookies to provide, secure, and improve our Website or Service or develop new features and functionality of our Website or Service.<br><br>As described below, we may use non-essential cookies on certain pages of our website to support our enterprise marketing efforts and market our products and services to enterprise customers, for example on resources.github.com (collectively “Enterprise Marketing Pages”).<br><br>We offer a [page](https://github.com/privacy/cookies) that makes all uses of cookies very transparent. |
| [How GitHub secures your information](#how-github-secures-your-information) | We take all measures reasonably necessary to protect the confidentiality, integrity, and availability of your personal data on GitHub and to protect the resilience of our servers. |
| [Communication preferences](#communication-preferences) | We communicate with you by email. You can control the way we contact you in your account settings, or by contacting us. |
| [Resolving complaints](#resolving-complaints) | In the unlikely event that we are unable to resolve a privacy concern quickly and thoroughly, we provide a path of dispute resolution. |
| [Changes to our Privacy Statement](#changes-to-our-privacy-statement) | We notify you of material changes to this Privacy Statement 30 days before any such changes become effective. You may also track changes in our Site Policy repository. |
| [License](#license) | This Privacy Statement is licensed under the [Creative Commons Zero license](https://creativecommons.org/publicdomain/zero/1.0/). |
| [Contacting GitHub](#contacting-github) | Please feel free to contact us if you have questions about our Privacy Statement. |
| [Translations](#translations) | We provide links to some translations of the Privacy Statement. |

## GitHub Privacy Statement

## Who is responsible for the processing of your information?
The data controller of your personal data is GitHub, Inc. For individuals outside North America, the data controller is GitHub B.V. 
 
This privacy statement does not apply to personal data we process as a service provider or data processor on behalf of our enterprise customers. Our data processing activities as service provider or data processor is governed by our [Data Protection Agreement](https://github.com/customer-terms/github-data-protection-agreement). If you are an end-user of one of those organizations, such as an employee or student, you should read that organization’s privacy statement and direct any privacy inquiries to that organization. 

## GitHub acting on your behalf

In some cases, GitHub is acting only on your behalf for the personal data we collect and process in connection with our Service (for example, for the personal data added to a repository by the contributors to such repository). In such cases, GitHub will only process the data in order to provide, protect, and improve Service. Please note that subject to our [Private Information Removal Policy](/site-policy/content-removal-policies/github-private-information-removal-policy) contributors’ requests to remove personal data generally require notice to and action from the repository owner.

## What information GitHub collects

The personal data we collect depends on how you interact with us, the services you use, and the choices you make. We collect information about you from different sources and in various ways when you use our Service, including information you provide directly, information collected automatically, third-party data sources, and data we infer or generate from other data.

### Information users provide directly to GitHub
We collect personal data you provide to us. For example:

#### Registration information
We collect information such as your name and contact data, including username and email address, and credentials such as your password, during account creation.

#### Demographic information
In some cases, we request that you provide age, gender, and similar demographic details.

#### Payment and billing information
If you make a purchase or other financial transaction, we collect credit card numbers, financial account information, and other payment details.

#### Content and files
We collect any code, text, photographs, documents, or other files, including videos or recordings, you upload to our Service; and if you send us email messages or other communications, we collect and retain those communications. For example, you may choose to give us more information for your Account profile, such as your full name, an avatar which may include a photograph, your biography, your location, your company, and a URL to a third-party website. Please note that your profile information may be visible to other Users of our Service.

#### Feedback and ratings
We collect any feedback or ratings you provide, including through written communications and via surveys. 

### Information GitHub automatically collects
When you visit or use our Service, we collect some information automatically. For example:

#### Transaction information, Subscription and licensing data 
If you have a paid Account or subscription with us, or make a purchase or sale using our Service, we automatically collect certain information about your transactions on the Service, such as your full name, address, region, state, country, zip code, the date, time, and amount charged.

#### Usage information and Interactions
If you're accessing or using our Service, we may automatically collect information about how you use and how your device interacts with the Service, such as the pages you view, the referring site, your IP address and information about your device, session information, the date and time of each request, device type and ID, operation system and application version, information contained in or relating to your contributions to individual repositories, and telemetry data (i.e., information about how a specific feature or service is performing) regarding your use of other features and functionality of the Service. As further described below, we automatically collect usage information and interaction data using cookies (which may use  a cookie ID), depending on your settings or preferences, in connection with our Service.

#### Geolocation information
In connection with certain features and depending on the functionality of the Service, we collect geolocation information such as through IP addresses or the location information you choose to provide in your Account profile.

### Information we create or generate
We infer new information from other data we collect, including using automated means to generate information about your likely preferences or other characteristics (“inferences”). For example, we infer your general geographic location (such as city, state, and country) based on your IP address.

### Information we collect from third parties

Other companies with whom you choose to engage. GitHub may collect personal data about you from third parties. For example, this may happen if you sign up for training or to receive information about GitHub from one of our vendors, partners, or affiliates. GitHub does not purchase personal data from third-party data brokers. 
 
Service Providers. We may also receive information from processors or service providers who process the data on our behalf, such as our payment processor who process payment and billing information in connection with our Service.
 
Content you post on our Service. Information you store in, or contribute to, a public repository, provide for use in connection with a Community Feature or make otherwise publicly available through the Service will be collected by GitHub as described in this Privacy Statement. Such information may also be available to the GitHub user community as well as the general public. For more information, please review details regarding public repositories and community features [here](/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/about-your-profile).
 
Co-branding/marketing partners. We may receive information from partners with which we offer co-branded services or engage in joint marketing activities. 
 
Publicly available sources. We may also obtain information from publicly available sources as GitHub repositories. 
 
When you are asked to provide personal data, you may decline. And you may use web browser or operating system controls to prevent certain types of automatic data collection. But if you choose not to provide or allow information that is necessary for certain services or features, those services or features may not be available or fully functional.

## How GitHub uses your information
We may use your information to provide, administer, analyze, manage, and operate our Service. For example, we use your information for the following purposes:
- Provide our products and deliver our services including troubleshooting, improving, and personalizing the features on the Service.
- Business operations such as billing, accounting, improving our internal operations, securing our systems, detecting fraudulent or illegal activity, and meeting our legal obligations.
- Improve and develop our products and services including to develop new services or features, and conduct research.
- Personalization of our Service by understanding you and your preferences to enhance your experience and enjoyment using our Service.
- Provide customer support and respond to your questions.
- Deliver promotional communications with you about new services, features, offers, promotions, and other information about our Service.
- Personalize and measure the effectiveness of enterprise business ads, including those you see off of the Services, promotional communications or marketing you receive related to the Enterprise Marketing Pages.
- Send you information, including confirmations, invoices, technical notices, updates, security alerts, support and administrative messages.

We combine data we collect from different sources for these purposes and to give you a more seamless, consistent, and personalized experience.

## How we share the information we collect

We share personal data as described below, including with your consent or as necessary to complete your transactions or provide the services you have requested or authorized. In addition, we may share each of the categories of your personal data described above with the types of third parties described below for the following business purposes:

### Public information
You may select options available through our Service to publicly display and share your name and/or username and certain other information, such as your profile, demographic data, content and files, or geolocation data. For example, if you would like your email address to remain private, even when you’re commenting on public repositories, [you can adjust your setting for your email address to be private in your user profile](https://github.com/settings/emails). You can also [update your local Git configuration to use your private email address](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). Please see more about email addresses in commit messages [here](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). 

Please note that if you would like to compile GitHub data, you must comply with our [Terms of Service](/site-policy/github-terms/github-terms-of-service) regarding information usage and privacy, and you may only use any public-facing information you gather for the purpose for which our user authorized it. For example, where a GitHub user has made an email address public-facing for the purpose of identification and attribution, do not use that email address for the purposes of sending unsolicited emails to users or selling personal information, such as to recruiters, headhunters, and job boards, or for commercial advertising. We expect you to reasonably secure information you have gathered from GitHub, and to respond promptly to complaints, removal requests, and "do not contact" requests from GitHub or GitHub users.

### Third-party applications
We share your personal data with third party applications when you tell us to do so. For example, if you purchase an application listed on our Marketplace, we share your username to allow the application developer to provide you with services. You can enable or add third-party applications, known as "Developer Products," to your Account. These Developer Products are not necessary for your use of GitHub. We will share your personal data with such third-party applications when you ask us to; however, you are responsible for your use of the third-party Developer Products and for the amount of personal data you choose to share with it. You can check our [API documentation](/v3/users) to see what information is provided when you authenticate into a Developer Product using your GitHub profile.

### Organizations with which you engage
You may indicate, through your actions on GitHub, that you are willing to share your personal data with Organizations, as defined in [GitHub’s Terms of Service](/github/site-policy/github-terms-of-service), who also use the Services. If you collaborate on or become a member of an Organization, then its Account owners may receive your personal data, for example by having the ability to view your activity in the Organization’s access log.

When you accept an invitation to an Organization, you will be notified of the types of information owners may be able to see (for more information, see [About Organization Membership](/github/setting-up-and-managing-your-github-user-account/about-organization-membership)). Please contact the Account owners for more information about how they might process your personal data in their Organization and the ways for you to access, update, alter, or delete your personal data stored in the Account.

### Service providers
We share your personal data with service providers who process the information on our behalf to provide or improve our Service. For example, our service providers may perform payment processing, customer support ticketing, network data transmission, web analytics, marketing operations, security, online advertising, and other similar services. Our service providers may process data in your region, in the United States, or in any other country where they operate facilities.

Such processing by service providers and any related cross border data transfers will be in compliance with applicable law.
 
 ### Affiliates
 We enable access to personal data across our subsidiaries, affiliates, and related companies, for example, where we share common data systems, when affiliates provide services on our behalf, or where access is needed to operate and provide the Service. 

### For security purposes
We will disclose personal data if we believe it is necessary to:
- protect our customers and others, for example to prevent spam or attempts to commit fraud, or to help prevent the loss of life or serious injury of anyone; 
- operate and maintain the security of the Service, including to prevent or stop an attack on our systems or networks; or 
- protect the rights or property or ourselves or others, including enforcing our agreements, terms, and policies.

### For legal disclosure
GitHub may disclose personal data or other information we collect about you to law enforcement or other governmental agencies if required in response to a valid legal process. For more information about our disclosure in response to legal requests, see our [Guidelines for Legal Requests of User Data](/github/site-policy/guidelines-for-legal-requests-of-user-data).

### Change in control or sale
We may share your personal data if we are involved in a merger, sale, or acquisition of corporate entities or business units as described in this Privacy Statement.
 
Please note that some of the features on our Service include integrations, references, or links to services provided by third parties whose privacy practices differ from ours. If you provide personal data to any of those third parties, or allow us to share personal data with them, that data is governed by their privacy statements.
 
Finally, we may share de-identified information in accordance with applicable law.

## Your choices regarding our processing of your personal data
We provide choices about the personal data we collect about you. The choices you make will not apply to any personal data associated with an Organization under your Account. 
 
Access, correction, and deletion. If you're a GitHub user, you may access, update, alter, or delete your basic user profile information by [editing your user profile](https://github.com/settings/profile) or contacting [GitHub Support](https://support.github.com/contact) or [GitHub Premium Support](https://enterprise.githubsupport.com/hc/en-us). You can control the information we collect about you by limiting what information is in your profile, by keeping your information current, by changing your cookie preferences, or by contacting [GitHub Support](https://support.github.com/contact) or [GitHub Premium Support](https://enterprise.githubsupport.com/hc/en-us).
 
We retain and use your information as described in this Privacy Statement, but barring legal requirements, we will delete your full profile within 90 days of your request. After an account has been deleted, certain data, such as contributions to other Users' repositories and comments in others' issues, will remain. However, we will delete or de-identify your personal data, including your username and email address, from the author field of issues, pull requests, and comments by associating them with a ghost user. That said, the email address you have provided via your Git commit settings will always be associated with your commits in the Git system. If you choose to make your email address private, you should also update your Git commit settings. We are unable to change or delete data in the Git commit history — the Git software is designed to maintain a record — but we do enable you to control what information you put in that record.
 
If GitHub processes personal data other than your profile information, such as information about you GitHub receives from [third parties](/github/site-policy/github-privacy-statement#information-we-collect-from-third-parties), then you may, subject to applicable law, access, update, alter, delete, object to or restrict the processing of your personal data by contacting [GitHub Support](https://support.github.com/contact) or [GitHub Premium Support](https://enterprise.githubsupport.com/hc/en-us).  
 
You can adjust the settings on your Account regarding the display of your personal data in private or public repositories or personal data processed in connection with Community Features (such as GitHub Feed, GitHub Sponsors, and GitHub Explore) through [profile settings](https://github.com/settings/profile).
 
Additionally, if you are unable to access certain personal data we have via the means described above, you can request access by contacting us as described at the bottom of this privacy statement.

### Data portability

As a GitHub User, you can always take your data with you. You can [clone your repositories to your desktop](/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop), for example, or you can use our [Data Portability tools](https://developer.github.com/changes/2018-05-24-user-migration-api/) to download information we have about you.

### Communication preferences
We use your email address to communicate with you, if you've said that's okay, and only for the reasons you’ve said that’s okay. For example, if you contact our Support team with a request, we respond to you via email. You have control over how your email address is used and shared with other Users on and through our Service. You may manage your communication preferences in your [profile](https://github.com/settings/emails).
 
By design, the Git version control system associates many actions with a user's email address, such as commit messages. See more details regarding [setting your commit email address](https://github.com/settings/emails). 
 
Depending on your [email settings](https://github.com/settings/emails), GitHub may occasionally send notification emails, for example, about changes in a repository you’re watching, new features, requests for feedback, important policy changes, or to offer customer support. We may also send marketing emails, based on your choices and in accordance with applicable laws and regulations. There's an “unsubscribe” link located at the bottom of each of the marketing emails we send you. 
 
Please note that you cannot opt out of receiving important communications from us, such as emails from our Support team or system emails, but you can configure your notifications settings in your profile to opt out of other communications.

## Our use of cookies and tracking technologies

### Cookies and tracking technologies

GitHub uses cookies to provide, secure and improve our Service or to develop new features and functionality of our Service. For example, we use them to (i) keep you logged in, (ii) remember your preferences, (iii) identify your device for security and fraud purposes, including as needed to maintain the integrity of our Service, (iv) compile statistical reports, and (v) provide information and insight for future development of GitHub. We provide more information about [cookies on GitHub](https://github.com/privacy/cookies) that describes the cookies we set, the needs we have for those cookies, and the expiration of such cookies. 

For Enterprise Marketing Pages, we may also use non-essential cookies to  (i) gather information about enterprise users’ interests and online activities to personalize their experiences, including by making the ads, content, recommendations, and marketing seen or received more relevant and (ii) serve and measure the effectiveness of targeted advertising and other marketing efforts. If you disable the non-essential cookies on the Enterprise Marketing Pages, the ads, content, and marketing you see may be less relevant.

Our emails to users may contain a pixel tag, which is a small, clear image that can tell us whether or not you have opened an email and what your IP address is. We use this pixel tag to make our email communications more effective and to make sure we are not sending you unwanted email.

The length of time a cookie will stay on your browser or device depends on whether it is a “persistent” or “session” cookie. Session cookies will only stay on your device until you stop browsing. Persistent cookies stay until they expire or are deleted. The expiration time or retention period applicable to persistent cookies depends on the purpose of the cookie collection and tool used. You may be able to delete cookie data as described [here](/site-policy/privacy-policies/github-privacy-statement#what-are-your-cookie-choices-and-controls).

#### What are cookies and similar technologies?

We use cookies and similar technologies, such as web beacons, local storage, and mobile analytics, to operate and provide our Services. When visiting Enterprise Marketing Pages, like resources.github.com, these and additional cookies, like advertising IDs, may be used for sales and marketing purposes.

Cookies are small text files stored by your browser on your device. A cookie can later be read when your browser connects to a web server in the same domain that placed the cookie. The text in a cookie contains a string of numbers and letters that may uniquely identify your device and can contain other information as well. This allows the web server to recognize your browser over time, each time it connects to that web server.

Web beacons are electronic images (also called “single-pixel” or “clear GIFs”) that are contained within a website or email. When your browser opens a webpage or email that contains a web beacon, it automatically connects to the web server that hosts the image (typically operated by a third party). This allows that web server to log information about your device and to set and read its own cookies. In the same way, third-party content on our websites (such as embedded videos, plug-ins, or ads) results in your browser connecting to the third-party web server that hosts that content. 

Mobile identifiers for analytics can be accessed and used by apps on mobile devices in much the same way that websites access and use cookies. When visiting Enterprise Marketing pages, like resources.github.com, on a mobile device these may allow us and our third-party analytics and advertising partners to collect data for sales and marketing purposes.

We may also use so-called “flash cookies” (also known as “Local Shared Objects” or “LSOs”) to collect and store information about your use of our Services. Flash cookies are commonly used for advertisements and videos.

#### How do we and our partners use cookies and similar technologies?

The GitHub Services use cookies and similar technologies for a variety of purposes, including to store your preferences and settings, enable you to sign-in, analyze how our Services perform, track your interaction with the Services, develop inferences, combat fraud, and fulfill other legitimate purposes. Some of these cookies and technologies may be provided by third parties, including service providers and advertising partners. For example, our analytics and advertising partners may use these technologies in our Services to collect personal information (such as the pages you visit, the links you click on, and similar usage information, identifiers, and device information) related to your online activities over time and across Services for various purposes, including targeted advertising. GitHub will place non-essential cookies on pages where we market products and services to enterprise customers, for example, on resources.github.com. 

We and/or our partners also share the information we collect or infer with third parties for these purposes.

The table below provides additional information about how we use different types of cookies:

| Purpose | Description |
|:---|:---|
| Required Cookies | GitHub uses required cookies to perform essential website functions and to provide the services. For example, cookies are used to log you in, save your language preferences, provide a shopping cart experience, improve performance, route traffic between web servers, detect the size of your screen, determine page load times, improve user experience, and for audience measurement. These cookies are necessary for our websites to work. | 
| Analytics | We allow third parties to use analytics cookies to understand how you use our websites so we can make them better. For example, cookies are used to gather information about the pages you visit and how many clicks you need to accomplish a task. We also use some analytics cookies to provide personalized advertising. |
| Social Media | GitHub and third parties use social media cookies to show you ads and content based on your social media profiles and activity on GitHub’s  websites. This ensures that the ads and content you see on our websites and on social media will better reflect your interests. This also enables third parties to develop and improve their products, which they may use on websites that are not owned or operated by GitHub. | 
| Advertising | In addition, GitHub and third parties use advertising cookies to show you new ads based on ads you've already seen. Cookies also track which ads you click or purchases you make after clicking an ad. This is done both for payment purposes and to show you ads that are more relevant to you. For example, cookies are used to detect when you click an ad and to show you ads based on your social media interests and website browsing history. | 

#### What are your cookie choices and controls?

  You have several options to disable non-essential cookies:

  1. **Specifically on GitHub Enterprise Marketing Pages**
   
     Any GitHub page that serves non-essential cookies will have a link in the page’s footer to cookie settings. You can express your preferences at any time by clicking on that linking and updating your settings.

     Some users will also be able to manage non-essential cookies via a cookie consent banner, including the options to accept, manage, and reject all non-essential cookies.
  2. **Generally for all websites**
  You can control the cookies you encounter on the web using a variety of widely-available tools. For example:
  - If your browser sends a [Do Not Track](https://en.wikipedia.org/wiki/Do_Not_Track) (DNT) signal, GitHub will not set non-essential cookies and will not load third party resources which set non-essential cookies.
  - Many browsers provide cookie controls which may limit the types of cookies you encounter online. Check out the documentation for your browser to learn more.
  - If you enable a browser extension designed to block tracking, such as [Privacy Badger](https://en.wikipedia.org/wiki/Privacy_Badger), non-essential cookies set by a website or third parties may be disabled.
  - If you enable a browser extension designed to block unwanted content, such as [uBlock Origin](https://en.wikipedia.org/wiki/UBlock_Origin), non-essential cookies will be disabled to the extent that content that sets non-essential cookies will be blocked.
  - You may use the Global Privacy Control (GPC) to communicate your privacy preferences. If GitHub detects the GPC signal from your device, GitHub will not share your data (we do not sell your data). To learn more, visit [Global Privacy Control — Take Control Of Your Privacy](https://globalprivacycontrol.org/)
  - Advertising controls. Our advertising partners may participate in associations that provide simple ways to opt out of ad targeting, which you can access at:
  - United States: [NAI](http://optout.networkadvertising.org) and [DAA](http://optout.aboutads.info/)
  - Canada: [Digital Advertising Alliance of Canada](https://youradchoices.ca/)
  - Europe: [European Digital Advertising Alliance](http://www.youronlinechoices.com/)

These choices are specific to the browser you are using. If you access our Services from other devices or browsers, take these actions from those systems to ensure your choices apply to the data collected when you use those systems.

## Retention of personal data
We retain personal data for as long as necessary to provide the services and fulfill the transactions you have requested, comply with our legal obligations, resolve disputes, enforce our agreements, and other legitimate and lawful business purposes. Because these needs can vary for different data types in the context of different services, actual retention periods can vary significantly based on criteria such as user expectations or consent, the sensitivity of the data, the availability of automated controls that enable users to delete data, and our legal or contractual obligations. For example, we may retain your personal data for longer periods, where necessary, subject to applicable law, for security purposes. 

## How GitHub secures your information
GitHub takes reasonable measures necessary to protect your personal data from unauthorized access, alteration, or destruction; maintain data accuracy; and help ensure the appropriate use of your personal data. To help us protect personal data, we request that you use a strong password and never share your password with anyone or use the same password with other sites or accounts.

In addition, if your account has private repositories, you control the access to that Content. GitHub personnel does not access private repository content except for
- security purposes, 
- automated scanning for known vulnerabilities, active malware, or other content known to violate our Terms of Service
- to assist the repository owner with a support matter
- to maintain the integrity of the Service
- to comply with our legal obligations if we have reason to believe the contents are in violation of the law, 
- or with your consent.

GitHub will provide notice regarding private repository access where not prohibited by law or if in response to a security threat or other risk to security.

### Cross-border data transfers
GitHub may store and process your personal data in your region, in the United States, and in any other country where GitHub or its affiliates, subsidiaries, or service providers operate facilities. 

We transfer personal data from the European Union, the United Kingdom, and Switzerland to other countries, some of which have not yet been determined by the European Commission to have an adequate level of data protection. For example, their laws may not guarantee you the same rights, or there may not be a privacy supervisory authority there that is capable of addressing your complaints. When we engage in such transfers, we use a variety of legal mechanisms, including contracts, such as the standard contractual clauses published by the European Commission under Commission Implementing Decision 2021/914, to help protect your rights and enable these protections to travel with your data. You may request a copy of the Standard Contractual Clauses using the contact details provided in the section entitled “Contacting GitHub” below.

### How to Contact Us
If you have a privacy inquiry or concerns about the way GitHub is handling your personal data, please let us know immediately. We want to help. You may contact us by filling out the [Privacy contact form](https://support.github.com/contact/privacy). We will respond promptly.

Our addresses are:

**GitHub Privacy Team**

GitHub, Inc. <br/>
88 Colin P. Kelly Jr. St. <br/>
San Francisco, CA 94107 <br/>
United States

[Privacy contact form](https://support.github.com/contact/privacy)

**GitHub Data Protection Officer**

c/o DP Dock DPO Services GmbH, <br/>
Attn: GitHub BV, Gut Projensdorf, <br/>
24161 Altenholz, Germany 

CC: GitHub BV, Vijzelstraat 68-72, 1017 HL Amsterdam, The Netherlands

[Privacy contact form](https://support.github.com/contact/privacy) 

### Dispute resolution process

In the unlikely event that a dispute arises between you and GitHub regarding our handling of your personal data, please email us directly at (privacy [at] github [dot] com) with the subject line "Privacy Concerns". We will respond promptly and do our best to resolve the dispute. 
Additionally, you may have the right to file a complaint with your local data protection or privacy agency or supervisory authority.

## Changes to our Privacy Statement

GitHub may change this Privacy Statement from time to time for a variety of reasons, including to comply with new laws and regulations, to cover new features and functionality, and to increase transparency. We will provide notice of material changes to this Privacy Statement through our Website at least 30 days prior to the change taking effect by posting a notice on our home page or sending email to the primary email address specified in your GitHub account. We will also update our [Site Policy repository](https://github.com/github/site-policy/), which tracks all changes to this policy. For other changes to this Privacy Statement, we encourage Users to [watch](/github/managing-subscriptions-and-notifications-on-github/configuring-notifications#configuring-your-watch-settings-for-an-individual-repository) or to check our Site Policy repository frequently.

## License

This Privacy Statement is licensed under this [Creative Commons Zero license](https://creativecommons.org/publicdomain/zero/1.0/). For details, see our [site-policy repository](https://github.com/github/site-policy#license).

## Contacting GitHub
Questions regarding GitHub's Privacy Statement or information practices should be directed to our [Privacy contact form](https://support.github.com/contact/privacy).

## Translations

Below are translations of this document into other languages. In the event of any conflict, uncertainty, or apparent inconsistency between any of those versions and the English version, this English version is the controlling version.

### French
Cliquez ici pour obtenir la version française: [Déclaration de confidentialité de GitHub](/assets/images/help/site-policy/github-privacy-statement(07.22.20)(FR).pdf)

### Other translations

For translations of this statement into other languages, please visit [https://docs.github.com/](/) and select a language from the drop-down menu under “English.”

## European Data Protection Rights Notice

If you are in the European Economic Area, we process your personal data in accordance with applicable laws, and the processing of personal data about you is subject to European Union data protection law, you have certain rights with respect to that data:

You can request access to, and rectification or erasure of, personal data; If any automated processing of personal data is based on your consent or a contract with you, you have a right to transfer or receive a copy of the personal data in a usable and portable format; If the processing of personal data is based on your consent, you can withdraw consent at any time for future processing; You can to object to, or obtain a restriction of, the processing of personal data under certain circumstances; and fFor residents of France, you can send us specific instructions regarding the use of your data after your death.

To make such requests, please use the contact information at the bottom of this statement. When we are processing data on behalf of another party (i.e., where GitHub is acting as a data processor) you should direct your request to that party. You also have the right to lodge a complaint with a supervisory authority, but we encourage you to first contact us with any questions or concerns.

We rely on different lawful bases for collecting and processing personal data about you, for example, with your consent and/or as necessary to provide the services you use, operate our business, meet our contractual and legal obligations, protect the security of our systems and our customers, or fulfill other legitimate interests.

## U.S. State Data Privacy
If you are a U.S. resident, we process your personal data in accordance with applicable U.S. state data privacy laws, including the California Consumer Privacy Act (CCPA). This section of our Privacy Statement contains information required by the CCPA and other U.S. state data privacy laws and supplements our Privacy Statement. 

**Sale**. We do not sell your personal data. So, we do not offer an opt-out to the sale of personal data. 

**Share**. We may “share” your personal data for targeted advertising purposes. You may opt out of sharing data for cross-contextual advertising purposes, and make additional privacy choices on GitHub’s Enterprise Marketing pages by selecting [Managing Your Cookie Preferences](/account-and-profile/setting-up-and-managing-your-personal-account-on-github/managing-personal-account-settings/managing-your-cookie-preferences-for-githubs-enterprise-marketing-pages). Here are the categories of personal data shared over the past 12 months with additional details. 

| Categories of Personal Data Shared | Categories of Recipients | Business or commercial purpose for sharing |
|:---                                |:---                      |:---                                        |
| Usage information and Interactions | Advertisers | To support GitHub’s enterprise marketing efforts |

**Rights**. You have the right to request that we (i) disclose what personal data we collect, use, disclose, share, and sell, (ii) delete your personal data, (iii) correct your personal data, and (iv) restrict the use and disclosure of your sensitive data, and (v) opt-out of future “sharing” of personal data for targeted advertising purposes. You may make these requests yourself or through an authorized agent. If you use an authorized agent, we provide your agent with detailed guidance on how to exercise your privacy rights. 

Please see [Your choices regarding our processing of your personal data](#your-choices-regarding-our-processing-of-your-personal-data) section of the GitHub Privacy Statement for additional information on how to exercise these rights. You can use GitHub’s User Migration API to access and download your data. Learn more [here](/get-started/privacy-on-github/requesting-an-archive-of-your-personal-accounts-data).

If you have a GitHub account, you must exercise your rights through the tools provided, which requires you to log in to your GitHub account. If you have an additional request or questions after logging in, you may contact GitHub at the address in the [How to contact us](#how-to-contact-us) section, including through our web form.

If you do not have an account, you may exercise your rights by contacting us as described above. We may ask for additional information to validate your request before honoring the request. To submit a request based on these rights, you can also contact us via our [contact form](https://support.github.com/request?tags=docs-policy).

You may opt-out of “sharing” information for cross-contextual behavioral advertising purposes, and make additional privacy choices related to GitHub’s Enterprise Marketing pages by selecting [Managing Your Cookie Preferences](/account-and-profile/setting-up-and-managing-your-personal-account-on-github/managing-personal-account-settings/managing-your-cookie-preferences-for-githubs-enterprise-marketing-pages). You have a right not to receive discriminatory treatment if you exercise your privacy rights. We will not discriminate against you if you exercise your privacy rights.

Additionally, under California Civil Code section 1798.83, also known as the “Shine the Light” law, California residents who have provided personal information to a business with which the individual has established a business relationship for personal, family, or household purposes (“California Customers”) may request information about whether the business has disclosed personal information to any third parties for the third parties’ direct marketing purposes. Please be aware that we do not disclose personal information to any third parties for their direct marketing purposes as defined by this law. California Customers may request further information about our compliance with this law by emailing (privacy [at] github [dot] com). Please note that businesses are required to respond to one request per California Customer each year and may not be required to respond to requests made by means other than through the designated email address.

California residents under the age of 18 who are registered users of online sites, services, or applications have a right under California Business and Professions Code Section 22581 to remove, or request and obtain removal of, content or information they have publicly posted. To remove content or information you have publicly posted, please submit a [Private Information Removal request](https://support.github.com/contact/private-information). Alternatively, to request that we remove such content or information, please send a detailed description of the specific content or information you wish to have removed to [GitHub support](https://support.github.com/request). Please be aware that your request does not guarantee complete or comprehensive removal of content or information posted online and that the law may not permit or require removal in certain circumstances. If you have any questions about our privacy practices with respect to California residents, please contact us via our [contact form](https://support.github.com/request?tags=docs-policy).

### Our handling of personal information
The table below contains information about the categories of personal information we collect, our purposes of processing, and the categories of third-party recipients with whom we share the personal information. Please see the [GitHub Privacy Statement](/github/site-policy/github-privacy-statement) for full details, including a description of the data included in each category.

|Category of Personal Data   |Sources of Personal Data    |Purposes of Processing    |Recipients    |
|:----                       |:----                       |:----                     |:----         |
|Registration information|Users and customers who use create an account|Provide and personalize our Services; authenticate and provide account access; respond to user and customer questions; help, secure, and troubleshoot; honor users rights; and marketing| Service providers and user-directed entities|
|Demographic information|Users and customers, third-party data brokers|Provide and personalize our Services; product improvement and development; help, secure, and troubleshoot; and marketing|Service providers and user-directed entities|
|Payment and billing information|Users and customers, financial institutions|Transact commerce; provide our Services; process transactions; fulfill orders; help, secure, and troubleshoot; and detect and prevent fraud|Service providers and user-directed entities|
|Content and files|Users and customers|Provide our Services; safety; compliance; and help, secure, and troubleshoot; honor user rights|Service providers and user-directed entities|
|Feedback and ratings|Users and customers|Provide our Services; product improvement; product improvement and development; marketing; customer support; and help, secure, and troubleshoot|Service providers and user-directed entities|
|Transaction information, subscription and licensing data|Users and customers|Provide, personalize, and activate our Services; customer support; help, secure, and troubleshoot; and marketing|Service providers and user-directed entities|
|Usage information and Interactions|Users, customers, website visitors|Provide and personalize our Services; product improvement and development; marketing; and help, secure and troubleshoot|Service providers and user-directed entities|
|Geolocation information|Users, customers, website visitors|Provide and personalize our Services; product improvement and development; marketing; and help, secure and troubleshoot|Service providers and user-directed entities|

**Categories of Sensitive Data**.  We may collect, process, or disclose certain personal data that qualifies as “sensitive data” under applicable U.S. state data privacy laws. For example, this data may be collected if you participate in a survey, share it in your account profile, or are engaged in certain community-focused repos. Sensitive data is a subset of personal data. In the list below, we outline the categories of sensitive data we collect, the sources of the sensitive data, our purposes of processing, and the categories of third-party recipients with whom we share the sensitive data. Please see the "[What information GitHub collects](#what-information-github-collects)" section for more information about the sensitive data we may collect. 

|Sensitive Data Type    |Purposes of Processing    |Recipients    |
|:----                  |:----                     |:----         |
|Account log-in, financial account, debit or credit card number, and the means to access the account (security or access code, password, credentials, etc.)|Transact commerce; process transactions; fulfill orders; provide our Services; help, secure, and troubleshoot; and detect and prevent fraud|Service providers and user-directed entities|
|Racial or ethnic origin, religious or philosophical beliefs, or union membership|Provide and personalize our products; product development; help, secure, and troubleshoot; and marketing|Service providers and user-directed entities|
|Medical or mental health, sex life, or sexual orientation|Provide and personalize our products; product development; help, secure, and troubleshoot; and marketing|Service providers and user-directed entities|
|Contents of your mail, email, or text messages (where GitHub is not the intended recipient of the communication)|Provide our products; safety; compliance; and help, secure, and troubleshoot|Service providers and user-directed entities|

GitHub asks your consent to collect and process your sensitive data or does so at your direction. We do not use or disclose your sensitive data for purposes other than the following:
- To perform the services, fulfill the transactions, or provide the goods or Services you reasonably expect; 
- To help ensure the security and integrity of our Services, to combat malicious deceptive, fraudulent or illegal acts, and to protect the physical safety of individuals, to the extent the processing is reasonably necessary and proportionate; 
- for transient use (including non-personalized advertising), so long as the personal data is not used for profiling, and is not used to alter an individual’s experience outside the current interaction with GitHub; 
- To perform services to operate our business, such as maintaining accounts, providing customer service, processing, or fulfilling orders/transactions, verifying customer information, processing payments, provide financing, providing analytics, providing storage, and similar services; 
- To undertake activities to verify or maintain the quality or safety of, or improve, upgrade, or enhance a service or device owned or controlled by GitHub; and 
- To conduct any other activities in accordance with applicable law.

The charts above contain the primary sources, purposes of processing, and recipients for each category of personal data. We use the categories of personal information described above for the purposes listed in the "[How GitHub uses your information](/github/site-policy/github-privacy-statement#how-github-uses-your-information)" section of our Privacy Statement, such as meeting our legal obligations, improving our internal operations, and doing research. We also disclose the categories of personal information listed above for business or compliance purposes. Please see the "[How we share the information we collect](/github/site-policy/github-privacy-statement#how-we-share-the-information-we-collect)" section of our Privacy Statement for additional details. 

**Not in a Position to Identify Data**. In some situations GitHub may process data in a state called Not in a Position to Identify Data (NPI) or de-identified data. Data is in this state when we are not able to link data to an individual to whom such data may relate without taking additional steps. In those instances, and unless allowed under applicable law, we will maintain such information in an NPI state, and will not try to re-identify the individual to whom NPI data relates. 

**Disclosures of personal data for business or commercial purposes**. As indicated in the How We share the information we collect section, we share personal data with third parties for various business and commercial purposes. The primary business and commercial purposes for which we share personal data are the purposes of processing listed in the table above. We also disclose the categories of personal information listed above for business purposes. Please see the "[How we share the information we collect](/github/site-policy/github-privacy-statement#how-we-share-the-information-we-collect)" section of our Privacy Statement for additional details. 

**Parties that control collection of personal data**. In certain situations, we may allow a third party to control the collection of your personal data. For example, on our Enterprise Marketing Pages, advertisers may be the controllers of information they collect through their cookies. 

We use the categories of personal information described above for the purposes listed in the "[How GitHub uses your information](/github/site-policy/github-privacy-statement#how-github-uses-your-information)" section of our Privacy Statement. We also disclose the categories of personal information listed above for business purposes. Please see the "[How we share the information we collect](/github/site-policy/github-privacy-statement#how-we-share-the-information-we-collect)" section of our Privacy Statement for additional details. 
