---
title: GitHub Appeal and Reinstatement
versions:
  fpt: '*'
topics:
  - Policy
  - Legal
---
## Appeal and Reinstatement

While the majority of interactions between individuals in GitHub’s community fall within our Acceptable Use Policies and Community Guidelines, violations of those policies do occur at times. When they do, GitHub staff may need to take enforcement action to address the violations. However, in some cases there may be a basis to reverse a moderation action taken by GitHub Staff.

## What are appeals and reinstatements?

Both appeals and reinstatements arise in relation to disabling of content or restrictions to access an account.

**Reinstatement**: The user wishes to regain access to their account or content and is willing to make any necessary changes to address the violation and must agree not to violate our terms going forward.

**Appeal**: The user disputes that a violation occurred and can provide additional information to show that a different decision should have been reached.

## How this works

If you seek reinstatement or wish to appeal an enforcement action, please fill out our [Appeal and Reinstatement form](https://support.github.com/contact/reinstatement).

GitHub staff will review the information provided in the form to determine whether there is sufficient information to warrant reinstatement or granting of an appeal.

* **Reinstatement**: Where a user can agree to abide by our Acceptable Use Policies moving forward and has made the changes necessary to address the violation(s), we may choose to reinstate their account or content depending on the circumstances and severity of the initial violation.

All legitimate reinstatement requests will be reviewed initially by GitHub staff and will be answered with a decision.

* **Appeal**: Where a user seeks to dispute a decision, they can use the form to explain their basis for disputing the decision and to provide any additional information regarding the alleged violation that they believe should have led to a different decision. If the information provided demonstrates that a different conclusion should have been reached, we may be able to grant an appeal.

If the GitHub staff reviewer is the same person who made the initial determination and that staff member believes their initial conclusion was correct (and thus would be inclined to deny the appeal), a different member of GitHub’s staff will independently review the appeal. All legitimate appeals will be answered with a final decision.

## Transparency

We track appeals and reinstatements in our [transparency reports](https://github.blog/2022-01-27-2021-transparency-report/#Appeals_and_other_reinstatements).
