---
title: GitHub Acceptable Use Policies
redirect_from:
  - /articles/github-acceptable-use-policies
  - /github/site-policy/github-acceptable-use-policies
versions:
  fpt: '*'
topics:
  - Policy
  - Legal
---

**Short version:** _We host a wide variety of collaborative projects from all over the world, and that collaboration only works when our users are able to work together in good faith. While using the Service, you must comply with our Acceptable Use Policies, which include some restrictions on content and conduct on GitHub related to user safety, intellectual property, privacy, authenticity, and other limitations. In short, be excellent to each other._

Capitalized terms used but not defined in these Acceptable Use Policies have the meanings assigned to them in our [Terms of Service](/articles/github-terms-of-service), [Corporate Terms of Service](/articles/github-corporate-terms-of-service), and [Privacy Statement](/articles/github-privacy-statement). For customers subject to the [Corporate Terms of Service](/articles/github-corporate-terms-of-service), "you" and "your" refer to "Customer" or "Users". "We", "us", "our" refer to "GitHub".

## 1. Compliance with Laws and Regulations
You are responsible for using the Service in compliance with all applicable laws, regulations, and all of our Acceptable Use Policies. These policies may be updated from time to time and are provided below, as well as in our [Terms of Service](/articles/github-terms-of-service) and [Corporate Terms of Service](/articles/github-corporate-terms-of-service).

## 2. User Safety
We do not allow content or activity on GitHub that:

- is unlawful or promotes unlawful activities;

- is [sexually obscene](/github/site-policy/github-sexually-obscene-content) or relates to sexual exploitation or abuse, including of minors;

- is libelous, defamatory, or fraudulent;

- is [discriminatory or abusive](/github/site-policy/github-hate-speech-and-discrimination) toward any individual or group;

- is [false, inaccurate, or intentionally deceptive information](/github/site-policy/github-misinformation-and-disinformation) and likely to adversely affect the public interest (including health, safety, election integrity, and civic participation);

- [harasses or abuses](/github/site-policy/github-bullying-and-harassment) another individual or group, including our employees, officers, and agents, or other users;

- [threatens or incites violence](/github/site-policy/github-threats-of-violence-and-gratuitously-violent-content) toward any individual or group, especially on the basis of who they are; 

- [gratuitously depicts or glorifies violence](/github/site-policy/github-threats-of-violence-and-gratuitously-violent-content), including violent images; or

- is off-topic, or interacts with platform features in a way that significantly or repeatedly [disrupts the experience of other users](/github/site-policy/github-disrupting-the-experience-of-other-users).


## 3. Intellectual Property, Authenticity, and Private Information
We do not allow content or activity on GitHub that:

- infringes any proprietary right of any party, including patent, trademark, trade secret, copyright, right of publicity, or other right;

- unlawfully shares unauthorized product licensing keys, software for generating unauthorized product licensing keys, or software for bypassing checks for product licensing keys, including extension of a free license beyond its trial period;

- [impersonates any person or entity](/github/site-policy/github-impersonation), including any of our employees or representatives, including through false association with GitHub, or by fraudulently misrepresenting your identity or site's purpose; or

- [violates the privacy of any third party](/github/site-policy/github-doxxing-and-invasion-of-privacy), such as by posting another person's personal information without consent.

## 4. Spam and Inauthentic Activity on GitHub
We do not allow content or activity on GitHub that is:
- automated excessive bulk activity and coordinated inauthentic activity, such as 
   * spamming 
   * cryptocurrency mining;
* bulk distribution of promotions and advertising prohibited by GitHub terms and policies;
* inauthentic interactions, such as fake accounts and automated inauthentic activity;
* rank abuse, such as automated starring or following;
* creation of or participation in secondary markets for the purpose of the proliferation of inauthentic activity;
* using GitHub as a platform for propagating abuse on other platforms;
* phishing or attempted phishing; or
* using our servers for any form of excessive automated bulk activity, to place undue burden on our servers through automated means, or to relay any form of unsolicited advertising or solicitation through our servers, such as get-rich-quick schemes;
* incentivized by (or incentivizes inauthentic engagement with) rewards such as cryptocurrency airdrops, tokens, credits, gifts or other give-aways.

## 5. Site Access and Safety
We do not allow content or activity on GitHub that:

- directly supports [unlawful active attack or malware campaigns](/github/site-policy/github-active-malware-or-exploits) that are causing technical harms — such as using our platform to deliver malicious executables or as attack infrastructure, for example by organizing denial of service attacks or managing command and control servers — with no implicit or explicit dual-use purpose prior to the abuse occurring; or
- uses our servers to disrupt or to attempt to disrupt, or to gain or to attempt to gain unauthorized access to, any service, device, data, account or network. Please note, activities permitted under bug bounty programs, such as the [GitHub Bug Bounty program](https://bounty.github.com), are not considered “unauthorized,” but must only affect the organization whose bug bounty program authorized the activity.


## 6. Services Usage Limits
You will not reproduce, duplicate, copy, sell, resell or exploit any portion of the Service, use of the Service, or access to the Service without our express written permission.

## 7. Information Usage Restrictions
You may use information from our Service for the following reasons, regardless of whether the information was scraped, collected through our API, or obtained otherwise:

-  Researchers may use public, non-personal information from the Service for research purposes, only if any publications resulting from that research are [open access](https://en.wikipedia.org/wiki/Open_access).
-  Archivists may use public information from the Service for archival purposes.

Scraping refers to extracting information from our Service via an automated process, such as a bot or webcrawler. Scraping does not refer to the collection of information through our API. Please see Section H of our [Terms of Service](/articles/github-terms-of-service#h-api-terms) for our API Terms. 

You may not use information from the Service (whether scraped, collected through our API, or obtained otherwise) for spamming purposes, including for the purposes of sending unsolicited emails to users or selling personal information, such as to recruiters, headhunters, and job boards.

Your use of information from the Service must comply with the [GitHub Privacy Statement](/github/site-policy/github-privacy-statement).

## 8. Privacy
Misuse of personal information is prohibited.

Any person, entity, or service collecting data from the Service must comply with the [GitHub Privacy Statement](/articles/github-privacy-statement), particularly in regards to the collection of personal information. If you collect any personal information from the Service, you agree that you will only use that personal information for the purpose for which that User has authorized it. You agree that you will reasonably secure any personal information you have gathered from the Service, and you will respond promptly to complaints, removal requests, and "do not contact" requests from us or other users.

## 9. Excessive Bandwidth Use
The Service's bandwidth limitations vary based on the features you use. If we determine your bandwidth usage to be significantly excessive in relation to other users of similar features, we reserve the right to suspend your Account, throttle your file hosting, or otherwise limit your activity until you can reduce your bandwidth consumption. We also reserve the right—after providing advance notice—to delete repositories that we determine to be placing undue strain on our infrastructure. For guidance on acceptable use of object storage in repositories, refer to "[What is my disk quota?](/github/managing-large-files/what-is-my-disk-quota)". For more details on specific features' bandwidth limitations, see the [GitHub Additional Product Terms](/github/site-policy/github-additional-product-terms).

## 10. Advertising on GitHub
**Short version:** *We do not generally prohibit use of GitHub for advertising. However, we expect our users to follow certain limitations, so GitHub does not become a spam haven. No one wants that.*

While we understand that you may want to promote your Content by posting supporters' names or logos in your Account, the primary focus of the Content posted in or through your Account to the Service should not be advertising or promotional marketing. This includes Content posted in or through Pages, Packages, repositories, and all other parts of the Service. You may include static images, links, and promotional text in the README documents or project description sections associated with your Account, but they must be related to the project you are hosting on GitHub. You may not advertise in other Users' Accounts, such as by posting monetized or excessive bulk content in issues.

You may not promote or distribute content or activity that is illegal or otherwise prohibited by our [Terms of Service](/github/site-policy/github-terms-of-service/) or [Acceptable Use Policies](/github/site-policy/github-acceptable-use-policies/), including excessive automated bulk activity (for example, spamming), get-rich-quick schemes, and misrepresentation or deception related to your promotion.

If you decide to post any promotional materials in your Account, you are solely responsible for complying with all applicable laws and regulations, including without limitation the U.S. Federal Trade Commission's Guidelines on Endorsements and Testimonials. We reserve the right to remove any promotional materials or advertisements that, in our sole discretion, violate any GitHub terms or policies.

## 11. User Protection
You must not engage in activity that significantly harms other users.   
  
We will interpret our policies and resolve disputes in favor of protecting users as a whole.

---

**Enforcement.** GitHub retains full discretion to [take action](/github/site-policy/github-community-guidelines#what-happens-if-someone-violates-githubs-policies) in response to a violation of these policies, including account suspension, account [termination](/github/site-policy/github-terms-of-service#3-github-may-terminate), or [removal](/github/site-policy/github-terms-of-service#2-github-may-remove-content) of content. Please also see our [Community Guidelines](/site-policy/github-terms/github-community-guidelines) for actions you can take if something or someone offends you.

**Reinstatement and appeal.** If your content or account has been disabled or restricted and you seek reinstatement or wish to appeal, please see our [Appeal and Reinstatement page](/site-policy/acceptable-use-policies/github-appeal-and-reinstatement) for information about the process and use our [Appeal and Reinstatement form](https://support.github.com/contact/reinstatement) to submit a request.
