---
title: About archiving content and data on GitHub
intro: 'You can archive content and data on {% data variables.product.product_name %} for other people to view and reference.'
redirect_from:
  - /articles/about-archiving-content-and-data-on-github
  - /github/creating-cloning-and-archiving-repositories/about-archiving-content-and-data-on-github
  - /github/creating-cloning-and-archiving-repositories/archiving-a-github-repository/about-archiving-content-and-data-on-github
versions:
  fpt: '*'
  ghec: '*'
topics:
  - Repositories
shortTitle: Archive content & data
---
## Persistence of public repositories

{% data variables.product.product_name %} intends to keep your public repositories available unless you remove them. In some cases, we may make public content unavailable, for example if:

- We receive a [DMCA Takedown Notice](/free-pro-team@latest/github/site-policy/dmca-takedown-policy) for content in a repository.
- We determine that a repository's content violates our [Community Guidelines](/free-pro-team@latest/github/site-policy/github-community-guidelines) or [Terms of Service](/free-pro-team@latest/github/site-policy/github-terms-of-service).

Academics and researchers can reference this information in data management plans.

## About the {% data variables.product.prodname_archive %}

{% data reusables.repositories.about-github-archive-program %}

The {% data variables.product.prodname_archive %} enables third-party partners to archive public repositories using the public API. These partners archive different types of data at varying frequencies and make the data available to the public. The {% data variables.product.prodname_archive %} also protects the data on an ongoing basis by storing multiple copies across various data formats and locations. For example, {% data variables.product.company_short %} stores repositories in the {% data variables.product.prodname_arctic_vault %}, a very-long-term archive intended to last at least 1,000 years. For more information, see [{% data variables.product.prodname_archive %}](https://archiveprogram.github.com/).

Responsible use of archives includes respecting users' privacy. For more information, see "[Public information on GitHub](/free-pro-team@latest/github/site-policy/github-privacy-statement#public-information-on-github)."

You can opt out of the {% data variables.product.prodname_archive %} for your repository. For more information, see "[Opting into or out of the {% data variables.product.prodname_archive %} for your public repository](/get-started/privacy-on-github/opting-into-or-out-of-the-github-archive-program-for-your-public-repository)."

## Adding an open source license to increase archivability

Libraries and researchers may require legal protections to create archives of publicly available content. If you want third parties to consider your work on {% data variables.product.product_name %} for archiving, you can add an [open source license](/articles/open-source-licensing) to your projects. An open source license gives contributors explicit permissions to copy and distribute the material in your repositories.
