---
title: 'Adding your {% data variables.projects.project_v2 %} to a repository'
shortTitle: 'Adding a {% data variables.projects.project_v2 %} to a repo'
intro: 'You can add your {% data variables.projects.project_v2 %} to a repository to make it accessible from that repository.'
miniTocMaxHeadingLevel: 3
versions:
  feature: projects-v2
type: tutorial
topics:
  - Projects
allowTitleToDifferFromFilename: true
---

You can list relevant projects in a repository. You can only list projects that are owned by the same user or organization that owns the repository.

In order for repository members to see a project listed in a repository, they must have visibility for the project. For more information, see "[Managing visibility of your {% data variables.projects.projects_v2 %}](/issues/planning-and-tracking-with-projects/managing-your-project/managing-visibility-of-your-projects)" and "[Managing access to your {% data variables.projects.projects_v2 %}](/issues/planning-and-tracking-with-projects/managing-your-project/managing-access-to-your-projects)."

1. On {% data variables.product.prodname_dotcom %}, navigate to the main page of your repository.
1. Click {% octicon "table" aria-label="the project icon" %} **Projects**.
   ![Screenshot showing projects tab in a repository](/assets/images/help/projects-v2/repo-tab.png)
1. Click **Add project**.
   ![Screenshot showing "Add project" button](/assets/images/help/projects-v2/add-to-repo-button.png)
1. In the search bar that appears, search for projects that are owned by the same user or organization that owns the repository.
   ![Screenshot showing searching for a project](/assets/images/help/projects-v2/add-to-repo-search.png)
1. Click on a project to list it in your repository.
   ![Screenshot showing "Add project" button](/assets/images/help/projects-v2/add-to-repo.png)
