---
title: Supported browsers
redirect_from:
  - /articles/why-doesn-t-graphs-work-with-ie-8
  - /articles/why-don-t-graphs-work-with-ie8
  - /articles/supported-browsers
  - /github/getting-started-with-github/supported-browsers
  - /github/getting-started-with-github/using-github/supported-browsers
intro: 'For the best experience with {% data variables.product.product_name %}, we recommend using the latest version of [Chrome](https://google.com/chrome), [Edge](https://www.microsoft.com/en-us/edge), [Firefox](https://mozilla.org/firefox), or [Safari](https://apple.com/safari).'
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
---

## About web browser support for {% data variables.product.product_name %}

We design {% data variables.product.product_name %} with the latest web browsers in mind. We recommend that you use the latest version of one of the following browsers.

 - [Apple Safari](https://apple.com/safari)
 - [Google Chrome](https://google.com/chrome)
 - [Microsoft Edge](https://www.microsoft.com/en-us/edge)
 - [Mozilla Firefox](https://mozilla.org/firefox)

If you do not use the latest version of a recommended browser, or if you use a browser that is not listed above, {% data variables.product.product_name %} or some features may not work as you expect, or at all.

For more information about how we maintain browser compatibility for {% data variables.product.company_short %}'s products, see the [`github/browser-support`](https://github.com/github/browser-support) repository.
## Extended support for recommended web browsers

Some browser vendors provide extended support releases. We do our best to ensure that {% data variables.product.product_name %} functions properly in the latest extended support release for:

- Chrome's [extended stable channel](https://support.google.com/chrome/a/answer/9027636)
- Edge's [Extended Stable Channel](https://docs.microsoft.com/en-gb/deployedge/microsoft-edge-channels#extended-stable-channel)
- Firefox's [Extended Support Release](https://www.mozilla.org/en-US/firefox/organizations/) (ESR)

In earlier extended support releases, {% data variables.product.product_name %} may not work as you expect, and some features may not be available.


## Beta and developer builds

You may encounter unexpected bugs in beta and developer builds of our supported browsers. If you encounter a bug on {% data variables.product.product_name %} in one of these unreleased builds, please verify that it also exists in the stable version of the same browser. If the bug only exists in the unstable version, consider reporting the bug to the browser developer.
