---
title: Exploring early access releases with feature preview
intro: You can use feature preview to see products or features that are available in beta and to enable or disable each feature for your personal account.
redirect_from:
  - /articles/exploring-early-access-releases-with-feature-preview
  - /github/getting-started-with-github/exploring-early-access-releases-with-feature-preview
  - /github/getting-started-with-github/using-github/exploring-early-access-releases-with-feature-preview
versions:
  fpt: '*'
  ghec: '*'
topics:
  - Early access
shortTitle: Feature preview
---
## {% data variables.product.prodname_dotcom %}'s release cycle

{% data variables.product.prodname_dotcom %}'s products and features can go through multiple release phases.

| Phase | Description |
|-------|-------------|
| Alpha | The product or feature is under heavy development and often has changing requirements and scope. The feature is available for demonstration and test purposes but may not be documented. Alpha releases are not necessarily feature complete, no service level agreements (SLAs) are provided, and there are no technical support obligations. <br><br> **Note**: A product or feature released as a "Technology Preview" is considered to be in the alpha release stage. Technology Preview releases share the same characteristics of alpha releases as described above.|
| Beta | The product or feature is ready for broader distribution. Beta releases can be public or private, are documented, but do not have any SLAs or technical support obligations. |
| General availability (GA) | The product or feature is fully tested and open publicly to all users. GA releases are ready for production use, and associated SLA and technical support obligations apply. |

## Exploring beta releases with feature preview

You can see a list of features that are available in beta and a brief description for each feature. Each feature includes a link to give feedback.

{% data reusables.feature-preview.feature-preview-setting  %}
2. Optionally, to the right of a feature, click **Enable** or **Disable**.
  ![Enable button in feature preview](/assets/images/help/settings/enable-feature-button.png)
