---
title: Guides for GitHub Education
intro: 'These guides for {% data variables.product.prodname_education %} help you teach and learn both {% data variables.product.product_name %} and software development.'
allowTitleToDifferFromFilename: true
versions:
  fpt: '*'
shortTitle: Guides
---

## Get started with {% data variables.product.product_name %}

Teachers, students, and researchers can use tools from {% data variables.product.product_name %} to enrich a software development curriculum and develop real-world collaboration skills.

- [Sign up for a new {% data variables.product.prodname_dotcom %}  account](/github/getting-started-with-github/signing-up-for-a-new-github-account)
- [Git and {% data variables.product.prodname_dotcom %} quickstart ](/github/getting-started-with-github/quickstart)
- [About {% data variables.product.prodname_global_campus %} for students](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/github-global-campus-for-students/about-github-global-campus-for-students)
- [Apply to {% data variables.product.prodname_global_campus %} as a teacher](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/github-global-campus-for-teachers/apply-to-github-global-campus-as-a-teacher)
- [Apply to {% data variables.product.prodname_global_campus %} as a student](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/github-global-campus-for-students/apply-to-github-global-campus-as-a-student)

## Run a software development course with {% data variables.product.company_short %}

Administer a classroom, assign and review work from your students, and teach the new generation of software developers with {% data variables.product.prodname_classroom %}.

- [About {% data variables.product.prodname_global_campus %} for teachers](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/github-global-campus-for-teachers/about-github-global-campus-for-teachers)
- [Basics of setting up {% data variables.product.prodname_classroom %} ](/education/manage-coursework-with-github-classroom/basics-of-setting-up-github-classroom)
- [Manage classrooms](/education/manage-coursework-with-github-classroom/manage-classrooms)
- [Use the Git and {% data variables.product.company_short %} starter assignment](/education/manage-coursework-with-github-classroom/use-the-git-and-github-starter-assignment)
- [Create an individual assignment](/education/manage-coursework-with-github-classroom/create-an-individual-assignment)
- [Create a group assignment](/education/manage-coursework-with-github-classroom/create-a-group-assignment)
- [Create an assignment from a template repository](/education/manage-coursework-with-github-classroom/create-an-assignment-from-a-template-repository)
- [Leave feedback with pull requests](/education/manage-coursework-with-github-classroom/leave-feedback-with-pull-requests)
- [Use autograding](/education/manage-coursework-with-github-classroom/use-autograding)

## Learn to develop software

Incorporate {% data variables.product.prodname_dotcom %} into your education, and use the same tools as the professionals.

- [Git and {% data variables.product.prodname_dotcom %} learning resources](/github/getting-started-with-github/git-and-github-learning-resources)
- [{% data variables.product.prodname_global_campus %} for students](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/github-global-campus-for-students)
- [Try {% data variables.product.prodname_desktop %}](/desktop)
- [Try {% data variables.product.prodname_cli %}](/github/getting-started-with-github/github-cli)

## Contribute to the community

Participate in the community, get training from {% data variables.product.company_short %}, and learn or teach new skills.

- [{% data variables.product.prodname_education_community %}]({% data variables.product.prodname_education_forum_link %})
- [About {% data variables.product.prodname_global_campus %} for students](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/github-global-campus-for-students/about-github-global-campus-for-students)
- [About {% data variables.product.prodname_student_leader_program %}](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/use-github-at-your-educational-institution/about-github-campus-experts)
- [Applying to be a {% data variables.product.prodname_student_leader_program_singular %}](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/use-github-at-your-educational-institution/applying-to-be-a-github-campus-expert)
- [Contribute with GitHub Community Exchange](/education/contribute-with-github-community-exchange)
