---
title: Submitting your repository to GitHub Community Exchange
shortTitle: Submit your repository
intro: 'You can submit your repository to {% data variables.product.prodname_community_exchange %} for others to view or contribute to.'
versions:
  fpt: '*'
---

## About repository submissions

Only public repositories owned by personal accounts can be submitted to {% data variables.product.prodname_community_exchange %}.

There are three types of repository submissions:

- **Learn.** A repository to share step-by-step instructions to build a project.
- **Collaborate.** A repository seeking collaborators to work on a project.
- **Learn and Collaborate.** A repository which is a combination of `Learn` and `Collaborate`.

Consider what the main purpose of your repository is when choosing the type of submission for your repository.

To promote your project and make it more discoverable to other students, you should assign one or more topics and {% data variables.product.prodname_student_pack %} offers to your repository. For more information, see "[Classifying your repository with topics](/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/classifying-your-repository-with-topics)."

Once a repository has been submitted to {% data variables.product.prodname_community_exchange %}, it will be published immediately with the purpose, topics, and offers you've chosen. The {% data variables.product.prodname_community_exchange %} community moderates all repository submissions.

### Submission requirements

Your repository must meet a minimum set of requirements for a submission to be accepted. During the submission process, if the submission criteria hasn't been met for your selected repository, you will be notified of the missing items.

For a submission with a purpose of `Learn`, your repository must have:
- A description.
- A LEARN.md file to provide step-by-step instructions, with text and/or media, on how you built your project. Ideally, your LEARN.md file will deconstruct your project into small components and provide thorough details of each step, so that other students can code their project by following your instructions.
- A README.md file to provide a detailed description of your project.
- A License so others are aware of what they can and cannot do with your source code.

For a submission with a purpose of `Collaborate`, your repository must have:
- A description.
- A README.md file to provide a detailed description of your project.
- A License so others are aware of what they can and cannot do with your source code.
- One or more issues for collaborators to work on.
- CONTRIBUTING.md file to communicate how to contribute to your project.

A good repository submission for both `Learn` and `Collaborate` purposes, is a repository that follows community standards. For more information, see "[About community profiles for public repositories](/communities/setting-up-your-project-for-healthy-contributions/about-community-profiles-for-public-repositories)."

## Submitting your repository

1. From your {% data variables.product.prodname_global_campus %} dashboard, navigate to the {% data variables.product.prodname_community_exchange %} home page.
1. Above the list of repositories, to the right of the search and dropdown filters, click **Add repository**.
  ![Screenshot of the Add repository button](/assets/images/help/education/community-exchange-submission-add-repo.png)
1. Use the **What is the purpose of your submission?** drop-down menu and select one or more entries matching your submission.
  ![Screenshot of the purpose dropdown for a repository submission](/assets/images/help/education/community-exchange-repo-submission-purpose.png)
1. Use the **Which repository would you like to use?** drop-down menu and select the repository for your submission. If the submission criteria hasn't been met, you will be notified of the missing items.
  ![Screenshot of the repository dropdown for a repository submission](/assets/images/help/education/community-exchange-repo-submission-repo.png)
1. Use the **Which offers did you use for your project?** drop-down menu and select one or more entries matching your submission.
  ![Screenshot of the offers dropdown for a repository submission](/assets/images/help/education/community-exchange-repo-submission-offers.png)
1. Click **Submit the project**.
