---
title: Granting higher permissions to top contributors
intro: Repository administrators can promote any community member to a moderator and maintainer.
versions:
  feature: discussions
shortTitle: Grant higher permissions
---


## Introduction

The most helpful contributors for the past 30 days are highlighted on the {% data variables.product.prodname_discussions %} dashboard, based on how many comments were marked as answers by other community members. Helpful contributors can help drive a healthy community and moderate and guide the community space in addition to maintainers.

## Step 1: Audit your {% data variables.product.prodname_discussions %} top contributors

{% data reusables.discussions.navigate-to-repo-or-org %}
{% data reusables.discussions.discussions-tab %}
1. Compare the list of contributors with their access permissions to the repository or, for organization discussions, to the source repository to see who qualifies to moderate the discussion.
  ![Screenshot of most helpful contributors](/assets/images/help/discussions/most-helpful.png)

## Step 2: Review permission levels for {% data variables.product.prodname_discussions %}

People with triage permissions for a repository can help moderate that repository's discussions by marking comments as answers, locking discussions that are no longer useful or are damaging to the community, and converting issues to discussions when an idea is still in the early stages of development. Similarly, people with triage permissions for the source repository for organization discussions can moderate the organization's discussions. For more information, see "[Moderating discussions](/discussions/managing-discussions-for-your-community/moderating-discussions)."

For more information about repository permission levels and {% data variables.product.prodname_discussions %}, see "[Repository permissions levels for an organization](/organizations/managing-access-to-your-organizations-repositories/repository-permission-levels-for-an-organization)."

## Step 3: Change permissions levels for top contributors

You can change a contributor's permission levels to give them more access to the tooling they need to moderate GitHub Discussions. To change a person's or team's permission levels, see "[Managing teams and people with access to your repository](/github/administering-a-repository/managing-teams-and-people-with-access-to-your-repository)."

## Step 4: Notify community members of elevated access

When you change a collaborators permission level, they will receive a notification for the change.
