---
title: Best practices for community conversations on GitHub
shortTitle: Best practices for community conversations
intro: 'You can use discussions to brainstorm with your team, and eventually move the conversation to an issue when you are ready to scope out the work.'
versions:
  feature: discussions
---


## Community conversations in {% data variables.product.prodname_discussions %}

Since {% data variables.product.prodname_discussions %} is an open forum, there is an opportunity to bring non-code collaboration into a project's repository or organization and gather diverse feedback and ideas more quickly. You can help drive a productive conversation in a number of ways.

- Asking pointed questions and follow-up questions to garner specific feedback
- Capturing a diverse experience and distilling it down to main points
- Opening an issue to take action based on the conversation, where applicable

For more information about opening an issue and cross-referencing a discussion, see "[Opening an issue from a comment](/github/managing-your-work-on-github/opening-an-issue-from-a-comment)."

## Learning about conversations on GitHub

You can create and participate in discussions, issues, and pull requests, depending on the type of conversation you'd like to have.

You can use {% data variables.product.prodname_discussions %} to discuss big picture ideas, brainstorm, and develop a project's specific details before committing it to an issue, which can then be scoped. {% data variables.product.prodname_discussions %} is useful for teams in a number of scenarios.
- You are in the discovery phase of a project and are still learning which direction your team wants to go in
- You want to collect feedback from a wider community about a project
- You want to keep bug fixes, feature requests, and general conversations separate
- You want to measure interest in new ideas and gauge community opinion using polls

You might use repository discussions to discuss topics that are specific to the repository. If your project spans multiple repositories, you might use organization discussions to discuss topics that aren't specific to a single repository in your organization.

Issues are useful for discussing specific details of a project such as bug reports and planned improvements. For more information, see "[About issues](/articles/about-issues)." Pull requests allow you to comment directly on proposed changes. For more information, see "[About pull requests](/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)" and "[Commenting on a pull request](/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/commenting-on-a-pull-request)."

## Following contributing guidelines

Before you open a discussion in a repository, check to see if the repository has contributing guidelines. The CONTRIBUTING file includes information about how the repository maintainer would like you to contribute ideas to the project.

For more information, see "[Setting up your project for healthy contributions](/communities/setting-up-your-project-for-healthy-contributions)."

## Next steps

To continue learning about {% data variables.product.prodname_discussions %} and quickly create a discussion for your community, see "[Quickstart for {% data variables.product.prodname_discussions %}](/discussions/quickstart)."

## Further reading

- "[Setting up your project for healthy contributions](/communities/setting-up-your-project-for-healthy-contributions)"
- "[Using templates to encourage useful issues and pull requests](/communities/using-templates-to-encourage-useful-issues-and-pull-requests)"
- "[Moderating comments and conversations](/communities/moderating-comments-and-conversations)"
- "[Writing on {% data variables.product.prodname_dotcom %}](/articles/writing-on-github)"
