---
title: Keyboard shortcuts
intro: 'You can use keyboard shortcuts in {% data variables.product.prodname_desktop %}.'
redirect_from:
  - /desktop/getting-started-with-github-desktop/keyboard-shortcuts-in-github-desktop
  - /desktop/getting-started-with-github-desktop/keyboard-shortcuts
  - /desktop/installing-and-configuring-github-desktop/keyboard-shortcuts
versions:
  fpt: '*'
---
{% mac %}

GitHub Desktop keyboard shortcuts on macOS

## Site wide shortcuts

| Keyboard shortcut | Description
|-----------|------------
|<kbd>Command</kbd>+<kbd>,</kbd> | Go to Preferences
|<kbd>Command</kbd>+<kbd>H</kbd> | Hide the {% data variables.product.prodname_desktop %} application
|<kbd>Option</kbd>+<kbd>Command</kbd>+<kbd>H</kbd> | Hide all other applications
|<kbd>Command</kbd>+<kbd>Q</kbd> | Quit {% data variables.product.prodname_desktop %}
|<kbd>Control</kbd>+<kbd>Command</kbd>+<kbd>F</kbd> | Toggle full screen view
|<kbd>Command</kbd>+<kbd>0</kbd> | Reset zoom to default text size
|<kbd>Command</kbd>+<kbd>=</kbd> | Zoom in for larger text and graphics
|<kbd>Command</kbd>+<kbd>-</kbd> | Zoom out for smaller text and graphics
|<kbd>Option</kbd>+<kbd>Command</kbd>+<kbd>I</kbd> | Toggle Developer Tools

## Repositories

| Keyboard shortcut | Description
|-----------|------------
|<kbd>Command</kbd>+<kbd>N</kbd> | Add a new repository
|<kbd>Command</kbd>+<kbd>O</kbd> | Add a local repository
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>O</kbd> | Clone a repository from {% data variables.product.prodname_dotcom %}
|<kbd>Command</kbd>+<kbd>T</kbd> | Show a list of your repositories
|<kbd>Command</kbd>+<kbd>P</kbd> | Push the latest commits to {% data variables.product.prodname_dotcom %}
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>P</kbd> | Pull down the latest changes from {% data variables.product.prodname_dotcom %}
|<kbd>Command</kbd>+<kbd>Delete</kbd> | Remove an existing repository
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>G</kbd> | View the repository on {% data variables.product.prodname_dotcom %}
|<kbd>Control</kbd>+<kbd>&grave;</kbd> | Open repository in your preferred terminal tool
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>F</kbd> | Show the repository in Finder
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>A</kbd> | Open the repository in your preferred editor tool
|<kbd>Command</kbd>+<kbd>I</kbd> | Create an issue on {% data variables.product.prodname_dotcom %}

## Branches

| Keyboard shortcut | Description
|-----------|------------
|<kbd>Command</kbd>+<kbd>1</kbd> | Show all your changes before committing
|<kbd>Command</kbd>+<kbd>2</kbd> | Show your commit history
|<kbd>Command</kbd>+<kbd>B</kbd> | Show all your branches
|<kbd>Command</kbd>+<kbd>G</kbd> | Go to the commit summary field
|<kbd>Command</kbd>+<kbd>Enter</kbd> | Commit changes when summary or description field is active
|<kbd>Space</kbd>| Select or deselect all highlighted files
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>N</kbd> | Create a new branch
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>R</kbd> | Rename the current branch
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>D</kbd> | Delete the current branch
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>U</kbd> | Update from default branch
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>B</kbd> | Compare to an existing branch
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>M</kbd> | Merge into current branch
|<kbd>Control</kbd>+<kbd>H</kbd> | Show or hide stashed changes
|<kbd>Shift</kbd>+<kbd>Command</kbd>+<kbd>C</kbd> | Compare branches on {% data variables.product.prodname_dotcom %}
|<kbd>Command</kbd>+<kbd>R</kbd> | Show the current pull request on {% data variables.product.prodname_dotcom %}

{% endmac %}

{% windows %}

GitHub Desktop keyboard shortcuts on Windows

## Site wide shortcuts

| Keyboard shortcut | Description
|-----------|------------
|<kbd>Ctrl</kbd>+<kbd>,</kbd> | Go to Options
|<kbd>F11</kbd> | Toggle full screen view
|<kbd>Ctrl</kbd>+<kbd>0</kbd> | Reset zoom to default text size
|<kbd>Ctrl</kbd>+<kbd>=</kbd> | Zoom in for larger text and graphics
|<kbd>Ctrl</kbd>+<kbd>-</kbd> | Zoom out for smaller text and graphics
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>I</kbd> | Toggle Developer Tools

## Repositories

| Keyboard Shortcut | Description
|-----------|------------
|<kbd>Ctrl</kbd>+<kbd>N</kbd> | Add a new repository
|<kbd>Ctrl</kbd>+<kbd>O</kbd> | Add a local repository
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>O</kbd> | Clone a repository from {% data variables.product.prodname_dotcom %}
|<kbd>Ctrl</kbd>+<kbd>T</kbd> | Show a list of your repositories
|<kbd>Ctrl</kbd>+<kbd>P</kbd> | Push the latest commits to {% data variables.product.prodname_dotcom %}
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>P</kbd> | Pull down the latest changes from {% data variables.product.prodname_dotcom %}
|<kbd>Ctrl</kbd>+<kbd>Delete</kbd> | Remove an existing repository
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>G</kbd> | View the repository on {% data variables.product.prodname_dotcom %}
|<kbd>Ctrl</kbd>+<kbd>&grave;</kbd> | Open repository in your preferred command line tool
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>F</kbd> | Show the repository in Explorer
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>A</kbd> | Open the repository in your preferred editor tool
|<kbd>Ctrl</kbd>+<kbd>I</kbd> | Create an issue on {% data variables.product.prodname_dotcom %}

## Branches

| Keyboard shortcut | Description
|-----------|------------
|<kbd>Ctrl</kbd>+<kbd>1</kbd> | Show all your changes before committing
|<kbd>Ctrl</kbd>+<kbd>2</kbd> | Show your commit history
|<kbd>Ctrl</kbd>+<kbd>B</kbd> | Show all your branches
|<kbd>Ctrl</kbd>+<kbd>G</kbd> | Go to the commit summary field
|<kbd>Ctrl</kbd>+<kbd>Enter</kbd> | Commit changes when summary or description field is active
|<kbd>Space</kbd>| Select or deselect all highlighted files
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>N</kbd> | Create a new branch
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>R</kbd> | Rename the current branch
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>D</kbd> | Delete the current branch
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>U</kbd> | Update from default branch
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>B</kbd> | Compare to an existing branch
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>M</kbd> | Merge into current branch
|<kbd>Ctrl</kbd>+<kbd>H</kbd> | Show or hide stashed changes
|<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>C</kbd> | Compare branches on {% data variables.product.prodname_dotcom %}
|<kbd>Ctrl</kbd>+<kbd>R</kbd> | Show the current pull request on {% data variables.product.prodname_dotcom %}

{% endwindows %}
