---
title: Configuring a default editor
intro: You can configure GitHub Desktop to open files in your project with your preferred text editor or integrated development environment (IDE).
redirect_from:
  - /desktop/getting-started-with-github-desktop/configuring-a-default-editor
  - /desktop/installing-and-configuring-github-desktop/configuring-a-default-editor
versions:
  fpt: '*'
shortTitle: Configure default editor
---
## Supported editors

{% data variables.product.prodname_desktop %} supports the following editors.

{% mac %}

- [MacVim](https://macvim-dev.github.io/macvim/)
- [{% data variables.product.prodname_vscode %}](https://code.visualstudio.com/)
- [Visual Studio Codium](https://vscodium.com/)
- [Sublime Text](https://www.sublimetext.com/)
- [BBEdit](http://www.barebones.com/products/bbedit/)
- [JetBrains WebStorm](https://www.jetbrains.com/webstorm/)
- [JetBrains PhpStorm](https://www.jetbrains.com/phpstorm/)
- [JetBrains Rider](https://www.jetbrains.com/rider/)
- [JetBrains PyCharm](https://www.jetbrains.com/pycharm/)
- [JetBrains RubyMine](https://www.jetbrains.com/rubymine/)
- [JetBrains IntelliJ IDEA](https://www.jetbrains.com/idea/)
- [JetBrains GoLand](https://www.jetbrains.com/go/)
- [TextMate](https://macromates.com/)
- [Brackets](http://brackets.io/)
  - To use Brackets with {% data variables.product.prodname_desktop %}, you must install the Command Line shortcut. To install the shortcut, open Brackets, click **File** in the menu bar, then click **Install Command Line Shortcut**.
- [Typora](https://typora.io/)
- [CodeRunner](https://coderunnerapp.com/)
- [SlickEdit](https://www.slickedit.com/)
- [Xcode](https://developer.apple.com/xcode/)
- [RStudio](https://rstudio.com/)
- [Nova](https://nova.app/)
- [Android Studio](https://developer.android.com/studio)
- [Aptana Studio](http://www.aptana.com/)

{% endmac %}

{% windows %}

- [{% data variables.product.prodname_vscode %}](https://code.visualstudio.com/)
- [Visual Studio Codium](https://vscodium.com/)
- [Sublime Text](https://www.sublimetext.com/)
- [ColdFusion Builder](https://www.adobe.com/products/coldfusion-builder.html)
- [Typora](https://typora.io/)
- [SlickEdit](https://www.slickedit.com/)
- [JetBrains IntelliJ Idea](https://www.jetbrains.com/idea/)
- [JetBrains WebStorm](https://www.jetbrains.com/webstorm/)
- [JetBrains PhpStorm](https://www.jetbrains.com/phpstorm/)
- [JetBrains Rider](https://www.jetbrains.com/rider/)
- [JetBrains CLion](https://www.jetbrains.com/clion/)
- [JetBrains PyCharm](https://www.jetbrains.com/pycharm/)
- [JetBrains RubyMine](https://www.jetbrains.com/rubymine/)
- [JetBrains GoLand](https://www.jetbrains.com/go/)
- [Android Studio](https://developer.android.com/studio)
- [Brackets](http://brackets.io/)
- [Notepad++](https://notepad-plus-plus.org/)
- [RStudio](https://rstudio.com/)
- [Aptana Studio](http://www.aptana.com/)

{% endwindows %}

## Configuring a default editor

{% mac %}

{% data reusables.desktop.mac-select-desktop-menu %}
3. In the Preferences window, select **Integrations**.
  ![The Integrations pane in the Preferences window](/assets/images/help/desktop/mac-select-integrations-pane.png)
4. Use the "External Editor" drop-down menu, and choose the editor you want to set as your default.
  ![The External editor menu in the Preferences menu bar](/assets/images/help/desktop/mac-editor-menu.png)
5. Click **Save**.  

{% endmac %}

{% windows %}

{% data reusables.desktop.windows-choose-options %}
3. In the Options window, select **Integrations**.
  ![The Integrations pane in the Options window](/assets/images/help/desktop/windows-select-integrations-pane.png)
4. Use the "External Editor" drop-down menu, and choose the editor you want to set as your default.
  ![The External editor menu in the Options menu bar](/assets/images/help/desktop/windows-editor-menu.png)
5. Click **Save**.  

{% endwindows %}
