---
title: About community management and moderation
intro: '{% data variables.product.prodname_dotcom %} offers tools that help repository maintainers establish and enforce standards of behavior in their communities on {% data variables.product.prodname_dotcom_the_website %}.'
versions:
  fpt: '*'
  ghec: '*'
redirect_from:
  - /github/building-a-strong-community/about-community-management-and-moderation
topics:
  - Community
shortTitle: Management & moderation
---

## About community management and moderation

{% data reusables.policies.github-community-guidelines-and-terms %}

{% data variables.product.prodname_dotcom %} also offers tools for repository maintainers to define and enforce higher standards of behavior in their own communities on {% data variables.product.prodname_dotcom_the_website %}.

Organization owners can specify organization members as moderators. This gives these members access to moderation features otherwise reserved for organization owners. For more information, see "[Managing moderators in your organization](/organizations/managing-peoples-access-to-your-organization-with-roles/managing-moderators-in-your-organization)."

After you establish standards of behavior for your community, you can encourage a pleasant and productive environment by responding to disruptive behavior in a fast, fair way. Effective moderation builds trust within your community and helps contributors feel safe and welcome.

## Tools for moderating your community

{% data variables.product.prodname_dotcom %}'s tools streamline management and moderation tasks in your community without requiring extensive moderation experience.

As a repository maintainer, you can author guidelines for contributing to your project and share them in the project's repository. {% data variables.product.prodname_dotcom %} offers a community profile checklist to help you author and publish community health files. Potential contributors to your project can review the community profile checklist to learn about your community's standards and decide whether they want to contribute. For more information, see "[Setting up your project for healthy contributions](/communities/setting-up-your-project-for-healthy-contributions)."

{% data reusables.community.tools-for-moderating %}

Contributors can always report disruptive content to {% data variables.contact.github_support %}. If you opt into reported content for a public repository in your organization, contributors can also report comments containing disruptive behavior directly to repository maintainers. For more information, see "[Managing reported content in your organization's repository](/communities/moderating-comments-and-conversations/managing-reported-content-in-your-organizations-repository)."

## Further reading

- "[Your Code of Conduct](https://opensource.guide/code-of-conduct/)" from the Open Source Guides
- "[Building Welcoming Communities](https://opensource.guide/building-community/)" from the Open Source Guides
- "[Leadership and Governance](https://opensource.guide/leadership-and-governance/)" from the Open Source Guides
