---
title: Limiting interactions for your personal account
intro: You can temporarily enforce a period of limited activity for certain users in all public repositories owned by your personal account.
versions:
  fpt: '*'
  ghec: '*'
permissions: Anyone can limit interactions for their own personal account.
redirect_from:
  - /github/building-a-strong-community/limiting-interactions-for-your-user-account
  - /communities/moderating-comments-and-conversations/limiting-interactions-for-your-user-account
topics:
  - Community
shortTitle: Limit interactions in account
---

## About temporary interaction limits

Limiting interactions for your personal account enables temporary interaction limits for all public repositories owned by your personal account. {% data reusables.community.interaction-limits-restrictions %}

{% data reusables.community.interaction-limits-duration %} After the duration of your limit passes, users can resume normal activity in your public repositories.

{% data reusables.community.types-of-interaction-limits %}

When you enable user-wide activity limitations, you can't enable or disable interaction limits on individual repositories. For more information on limiting activity for an individual repository, see "[Limiting interactions in your repository](/communities/moderating-comments-and-conversations/limiting-interactions-in-your-repository)."

You can also block users. For more information, see "[Blocking a user from your personal account](/communities/maintaining-your-safety-on-github/blocking-a-user-from-your-personal-account)." 

## Limiting interactions for your personal account

{% data reusables.user-settings.access_settings %}
1. In the "Access" section of the sidebar, select **{% octicon "report" aria-label="The report icon" %} Moderation** then click **Interaction limits**.
{% data reusables.community.set-interaction-limit %}
  ![Temporary interaction limit options](/assets/images/help/settings/user-account-temporary-interaction-limits-options.png)
