---
title: Reporting abuse or spam
intro: You can report behavior and content that violates community guidelines and terms.
permissions: 'Owners, collaborators, prior contributors, and people with write access can report issues, pull requests, and comments on issues, pull requests, and commits. Anyone can report apps in {% data variables.product.prodname_marketplace %}.'
redirect_from:
  - /articles/reporting-abuse-or-spam
  - /github/building-a-strong-community/reporting-abuse-or-spam
versions:
  fpt: '*'
  ghec: '*'
topics:
  - Community
---

## About reporting abuse or spam

{% data reusables.policies.github-community-guidelines-and-terms %}

You can report users that have violated {% data variables.product.prodname_dotcom %}'s Community Guidelines or Terms of Service through {% data variables.contact.report_abuse %} or {% data variables.contact.report_content %}. You can also report issues, pull requests, or comments on issues, pull requests, and commits.

If reported content is enabled for a public repository, you can also report content directly to repository maintainers.

Users in India can contact GitHub's Grievance Officer for India [here](https://support.github.com/contact/india-grievance-officer).

## Reporting a user

{% data reusables.profile.user_profile_page_navigation %}
{% data reusables.profile.user_profile_page_block_or_report %}
3. Click **Report abuse**.
  ![Modal box with options to block user or report abuse](/assets/images/help/profile/profile-report-abuse.png)
4. Complete the contact form to tell {% data variables.contact.contact_support %} about the user's behavior, then click **Send request**.

## Reporting an issue or pull request

1. Navigate to the issue or pull request you'd like to report.
2. In the upper-right corner of the issue or pull request, click {% octicon "kebab-horizontal" aria-label="The horizontal kebab octicon" %}, then click **Report content**.
  ![Button to report a comment](/assets/images/help/repository/menu-report-issue-or-pr.png)
{% data reusables.community.report-content %}

## Reporting a comment

1. Navigate to the comment you'd like to report.
2. In the upper-right corner of the comment, click {% octicon "kebab-horizontal" aria-label="The horizontal kebab octicon" %}, then click **Report content**.
![Kebab menu with option to report a comment](/assets/images/help/repository/menu-report-comment.png)
{% data reusables.community.report-content %}

## Reporting an app in {% data variables.product.prodname_marketplace %}

{% data reusables.marketplace.visit-marketplace %}
2. Browse to the app you'd like to report.
3. In the left sidebar, under the "Developer links" section, click {% octicon "report" aria-label="The report symbol" %} **Report abuse**.
  ![Button to report an app in {% data variables.product.prodname_marketplace %}](/assets/images/help/marketplace/marketplace-report-app.png)
4. Complete the contact form to tell {% data variables.contact.contact_support %} about the app's behavior, then click **Send request**.

## Reporting contact link abuse in the template chooser

1. Navigate to the repository that contains the contact link you'd like to report.
2. Under the repository name, click {% octicon "issue-opened" aria-label="The issues icon" %} **Issues**.
3. In the lower-right corner of the template chooser, click **Report abuse**.
  ![Link to report an abuse](/assets/images/help/repository/template-chooser-report-abuse.png)
4. Complete the contact form to tell {% data variables.contact.contact_support %} about the contact link's behavior, then click **Send request**.

## Further reading

- "[Setting up your project for healthy contributions](/communities/setting-up-your-project-for-healthy-contributions)"
- "[Using templates to encourage useful issues and pull requests](/communities/using-templates-to-encourage-useful-issues-and-pull-requests)"
- "[Managing disruptive comments](/communities/moderating-comments-and-conversations/managing-disruptive-comments)"{% ifversion fpt or ghec %}
- "[Maintaining your safety on {% data variables.product.prodname_dotcom %}](/communities/maintaining-your-safety-on-github)"
- "[Limiting interactions in your repository](/communities/moderating-comments-and-conversations/limiting-interactions-in-your-repository)"{% endif %}
- "[Tracking changes in a comment](/communities/moderating-comments-and-conversations/tracking-changes-in-a-comment)"
