---
title: Managing prebuilds
shortTitle: Manage prebuilds
intro: 'You can review, modify, and delete the prebuild configurations for your repository.'
versions:
  fpt: '*'
  ghec: '*'
type: how_to
topics:
  - Codespaces
miniTocMaxHeadingLevel: 3
---

## Checking, changing, and deleting your prebuild configurations

The prebuilds that you configure for a repository are created and updated using a {% data variables.product.prodname_actions %} workflow, managed by the {% data variables.product.prodname_github_codespaces %} service. 

Depending on the settings in a prebuild configuration, the workflow to update the prebuild may be triggered by these events:

* Creating or updating the prebuild configuration
* Pushing a commit or a pull request to a branch that's configured to have prebuilds
* Changing any of the dev container configuration files
* A schedule that you've defined in the prebuild configuration
* Manually triggering the workflow

The settings in the prebuild configuration determine which events automatically trigger an update of the prebuild. For more information, see "[Configuring prebuilds](/codespaces/prebuilding-your-codespaces/configuring-prebuilds#configuring-prebuilds)." 

People with admin access to a repository can check the progress of prebuilds, edit, and delete prebuild configurations. 

### Viewing the progress of prebuilds
You can view the current status of the latest workflow run for each prebuild configuration you've set up on the {% data variables.product.prodname_github_codespaces %} page of your repository settings. For example, "Currently running" or "Last run 1 hour ago."

To see the log output for the latest prebuild workflow run, click **See output**.

![The 'See output' button](/assets/images/help/codespaces/prebuilds-see-output.png) 

This displays the output of the most recent run of the workflow in the **Actions** tab.

![The prebuild workflow output](/assets/images/help/codespaces/prebuilds-log-output.png) 

Alternatively, to view all prebuild workflow runs associated with the specified branch, click the ellipsis button and choose **View runs** from the dropdown menu.

![The 'View runs' option in the dropdown menu](/assets/images/help/codespaces/prebuilds-view-runs.png) 

This displays the workflow run history for prebuilds for the associated branch.

![The workflow run history](/assets/images/help/codespaces/prebuilds-workflow-runs.png) 

### Editing a prebuild configuration

1. On the {% data variables.product.prodname_codespaces %} page of your repository settings, click the ellipsis to the right of the prebuild configuration you want to edit.
1. In the dropdown menu, click **Edit**.
 
   ![The 'Edit' option in the dropdown menu](/assets/images/help/codespaces/prebuilds-edit.png) 

1. Make the required changes to the prebuild configuration, then click **Update**. 

   {% data reusables.codespaces.prebuilds-permission-authorization %}


### Disabling a prebuild configuration

To pause the update of prebuilds for a configuration, you can disable workflow runs for the configuration. Disabling the workflow runs for a prebuild configuration does not delete any previously created prebuilds for that configuration and, as a result, codespaces will continue to be generated from an existing prebuild.

Disabling the workflow runs for a prebuild configuration is useful if you need to investigate prebuild creation failures.

1. On the {% data variables.product.prodname_codespaces %} page of your repository settings, click the ellipsis to the right of the prebuild configuration you want to disable.
1. In the dropdown menu, click **Disable runs**.

   ![The 'Disable runs' option in the dropdown menu](/assets/images/help/codespaces/prebuilds-disable.png)

1. To confirm that you want to disable this configuration, click **OK**.

### Deleting a prebuild configuration

Deleting a prebuild configuration also deletes all previously created prebuilds for that configuration. As a result, shortly after you delete a configuration, prebuilds generated by that configuration will no longer be available when you create a new codespace.

After you delete a prebuild configuration, workflow runs for that configuration that have been queued or started will still run. They will be listed in the workflow run history, along with previously completed workflow runs.

1. On the {% data variables.product.prodname_codespaces %} page of your repository settings, click the ellipsis to the right of the prebuild configuration you want to delete.
1. In the dropdown menu, click **Delete**.

   ![The 'Delete' option in the dropdown menu](/assets/images/help/codespaces/prebuilds-delete.png)

1. Click **OK** to confirm the deletion.

### Manually trigger prebuilds

It may be useful to manually trigger a workflow run for a prebuild configuration. Generally this is only necessary if you are debugging a problem with the workflow for a prebuild configuration.

1. On the {% data variables.product.prodname_codespaces %} page of your repository settings, click the ellipsis to the right of the prebuild configuration whose workflow you want to trigger.
1. In the dropdown menu, click **Manually trigger**.

   ![The 'Manually trigger' option in the dropdown menu](/assets/images/help/codespaces/prebuilds-manually-trigger.png) 

## Further reading

- "[Troubleshooting prebuilds](/codespaces/troubleshooting/troubleshooting-prebuilds)"
