---
title: Configuring private vulnerability reporting for an organization
intro: Organization owners and security managers can allow security researchers to report vulnerabilities securely in repositories within the organization by enabling private vulnerability reporting for all its public repositories.
permissions: 'Anyone with admin permissions to an organization, or with a security manager role within the organization, can enable and disable private vulnerability reporting for that organization.'
versions:
  fpt: '*'
  ghec: '*'
type: how_to
miniTocMaxHeadingLevel: 3
topics:
  - Security advisories
  - Vulnerabilities
shortTitle: Configure for an organization
---

{% data reusables.security-advisory.private-vulnerability-reporting-beta %}

## About privately reporting a security vulnerability

Security researchers often feel responsible for alerting users to a vulnerability that could be exploited. If there are no clear instructions about contacting maintainers of the repository containing the vulnerability, security researchers may have no other choice but to post about the vulnerability on social media, send direct messages to the maintainer, or even create public issues. This situation can potentially lead to a public disclosure of the vulnerability details.

{% data reusables.security-advisory.private-vulnerability-reporting-overview %}

For organization owners and security managers, the benefits of using private vulnerability reporting are: 
{% data reusables.security-advisory.private-vulnerability-reporting-benefits %}

The instructions below refer to enablement at organization level. For information about enabling the feature for a repository, see "[Configuring private vulnerability reporting for a repository](/code-security/security-advisories/repository-security-advisories/configuring-private-vulnerability-reporting-for-a-repository)."

## Enabling or disabling private vulnerability reporting for all the existing public repositories in an organization

{% data reusables.profile.access_org %}
{% data reusables.profile.org_settings %}
{% data reusables.organizations.security-and-analysis %}
1. Under "Code security and analysis", to the right of "Private vulnerability reporting", click **Enable all** or **Disable all**, to enable or disable the feature for all the public repositories within the organization, respectively.

 ![Screenshot of the "Code security and analysis" page with the "Disable all" and the "Enable all" button emphasized for private vulnerability reporting](/assets/images/help/security/private-vulnerability-reporting-enable-or-disable-org.png)

## Enabling or disabling private vulnerability reporting for new public repositories added to the organization
{% data reusables.profile.access_org %}
{% data reusables.profile.org_settings %}
{% data reusables.organizations.security-and-analysis %}
1. Under "Code security and analysis", to the right of the feature, click **Automatically enable for new public repositories**.

 ![Screenshot of the "Code security and analysis" page with the "Automatically enable for new public repositories" checkbox emphasized for private vulnerability reporting](/assets/images/help/security/private-vulnerability-reporting-enable-or-disable-org-new-repos.png)

1. To the right of "Private vulnerability reporting", click **Enable all** or **Disable all**, to enable or disable the feature for all new public repositories that will be added to the organization, respectively.

## What having private vulnerability reporting enabled for a repository looks like for a security researcher

{% data reusables.security-advisory.private-vulnerability-reporting-security-researcher %}