---
title: Privately reporting a security vulnerability
intro: Some public repositories configure security advisories so that anyone can report security vulnerabilities directly and privately to the maintainers.
versions:
  fpt: '*'
  ghec: '*'
type: how_to
miniTocMaxHeadingLevel: 3
topics:
  - Security advisories
  - Vulnerabilities
shortTitle: Privately reporting
---

{% data reusables.security-advisory.private-vulnerability-reporting-beta %}

{% data reusables.security-advisory.private-vulnerability-reporting-enable %}

## About privately reporting a security vulnerability

Security researchers often feel responsible for alerting users to a vulnerability that could be exploited. If there are no clear instructions about contacting maintainers of the repository containing the vulnerability, security researchers may have no other choice but to post about the vulnerability on social media, send direct messages to the maintainer, or even create public issues. This situation can potentially lead to a public disclosure of the vulnerability details.

Private vulnerability reporting makes it easy for security researchers to report vulnerabilities directly to repository maintainer using a simple form. 

For security researchers, the benefits of using private vulnerability reporting are: 
- Less frustration, and less time spent trying to figure out how to contact the maintainer.
- A smoother process for disclosing and discussing vulnerability details.
- The opportunity to discuss vulnerability details privately with repository maintainer.

{% note %}

**Note:** If the repository doesn't have private vulnerability reporting enabled, you need to initiate the reporting process by following the instructions in the security policy for the repository, or create an issue asking the maintainers for a preferred security contact. For more information, see "[About coordinated disclosure of security vulnerabilities](/code-security/security-advisories/guidance-on-reporting-and-writing/about-coordinated-disclosure-of-security-vulnerabilities#about-reporting-and-disclosing-vulnerabilities-in-projects-on-github)."

{% endnote %}

## Privately reporting a security vulnerability

Security researchers can privately report a security vulnerability to repository maintainers.

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-security %}
{% data reusables.repositories.sidebar-advisories %}
1. Click **Report a vulnerability** to open the advisory form.
   
   ![Screenshot showing the "Report a vulnerability" button](/assets/images/help/security/report-a-vulnerability-button.png)
   
2. Fill in the advisory details form.
  {% tip %}
  
  **Tip:** In this form, only the title and description are mandatory. (In the general draft security advisory form, which the repository maintainer initiates, specifying the ecosystem is also required.) However, we recommend security researchers provide as much information as possible on the form so that the maintainers can make an informed decision about the submitted report. You can adopt the template used by our security researchers from the {% data variables.product.prodname_security %}, which is available on the [`github/securitylab` repository](https://github.com/github/securitylab/blob/main/docs/report-template.md)."
  
  {% endtip %}
  
  For more information about the fields available and guidance on filling in the form, see "[Creating a repository security advisory](/code-security/security-advisories/repository-security-advisories/creating-a-repository-security-advisory)" and "[Best practices for writing repository security advisories](/code-security/security-advisories/guidance-on-reporting-and-writing/best-practices-for-writing-repository-security-advisories)."

1. At the bottom of the form, click **Submit report**. {% data variables.product.prodname_dotcom %} will display a message letting you know that maintainers have been notified and that you have a pending credit for this security advisory.
  
  ![Screenshot showing the "Submit report" button](/assets/images/help/security/advisory-submit-report-button.png)
  
  {% tip %}
  
  **Tip:** When the report is submitted, {% data variables.product.prodname_dotcom %} automatically adds the reporter of the vulnerability as a collaborator and as a credited user on the proposed advisory.
  
  {% endtip %}

1. Optionally, click **Start a temporary private fork** if you want to start to fix the issue. Note that only the repository maintainer can merge that private fork.
  
  ![Screenshot showing the "Start a temporary fork" button](/assets/images/help/security/advisory-start-a-temporary-private-fork-button.png)

The next steps depend on the action taken by the repository maintainer. For more information, see "[Managing privately reported security vulnerabilities](/code-security/security-advisories/guidance-on-reporting-and-writing/managing-privately-reported-security-vulnerabilities)."
