---
title: Guides for code security
intro: 'Learn about the different ways that {% data variables.product.product_name %} can help you improve your code''s security.'
allowTitleToDifferFromFilename: true
layout: product-guides
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
learningTracks:
  - security_advisories
  - dependabot_alerts
  - dependabot_security_updates
  - dependency_version_updates
  - security_alerts
  - secret_scanning
  - code_security_actions
  - code_security_ci
  - code_security_integration
  - end_to_end_supply_chain
includeGuides:
  - /code-security/getting-started/adding-a-security-policy-to-your-repository
  - /code-security/getting-started/github-security-features
  - /code-security/getting-started/securing-your-organization
  - /code-security/getting-started/securing-your-repository
  - /code-security/secret-scanning/about-secret-scanning
  - /code-security/secret-scanning/configuring-secret-scanning-for-your-repositories
  - /code-security/secret-scanning/defining-custom-patterns-for-secret-scanning
  - /code-security/secret-scanning/managing-alerts-from-secret-scanning
  - /code-security/secret-scanning/protecting-pushes-with-secret-scanning
  - /code-security/secret-scanning/pushing-a-branch-blocked-by-push-protection
  - /code-security/secret-scanning/secret-scanning-patterns
  - /code-security/secret-scanning/troubleshooting-secret-scanning
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/tracking-code-scanning-alerts-in-issues-using-task-lists
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning-alerts
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning-with-codeql
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/customizing-code-scanning
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/configuring-the-codeql-workflow-for-compiled-languages
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/managing-code-scanning-alerts-for-your-repository
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/running-codeql-code-scanning-in-a-container
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/configuring-code-scanning-for-a-repository
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/triaging-code-scanning-alerts-in-pull-requests
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/troubleshooting-the-codeql-workflow
  - /code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/viewing-code-scanning-logs
  - /code-security/code-scanning/integrating-with-code-scanning/about-integration-with-code-scanning
  - /code-security/code-scanning/integrating-with-code-scanning/sarif-support-for-code-scanning
  - /code-security/code-scanning/integrating-with-code-scanning/uploading-a-sarif-file-to-github
  - /code-security/code-scanning/using-codeql-code-scanning-with-your-existing-ci-system/about-codeql-code-scanning-in-your-ci-system
  - /code-security/code-scanning/using-codeql-code-scanning-with-your-existing-ci-system/configuring-codeql-cli-in-your-ci-system
  - /code-security/code-scanning/using-codeql-code-scanning-with-your-existing-ci-system/installing-codeql-cli-in-your-ci-system
  - /code-security/code-scanning/using-codeql-code-scanning-with-your-existing-ci-system/migrating-from-the-codeql-runner-to-codeql-cli
  - /code-security/repository-security-advisories/about-github-security-advisories-for-repositories
  - /code-security/security-advisories/repository-security-advisories/configuring-private-vulnerability-reporting-for-a-repository
  - /code-security/security-advisories/repository-security-advisories/configuring-private-vulnerability-reporting-for-an-organization
  - /code-security/repository-security-advisories/adding-a-collaborator-to-a-repository-security-advisory
  - /code-security/repository-security-advisories/collaborating-in-a-temporary-private-fork-to-resolve-a-repository-security-vulnerability
  - /code-security/repository-security-advisories/creating-a-repository-security-advisory
  - /code-security/repository-security-advisories/editing-a-repository-security-advisory
  - /code-security/repository-security-advisories/permission-levels-for-repository-security-advisories
  - /code-security/repository-security-advisories/publishing-a-repository-security-advisory
  - /code-security/repository-security-advisories/removing-a-collaborator-from-a-repository-security-advisory
  - /code-security/repository-security-advisories/withdrawing-a-repository-security-advisory
  - /code-security/security-advisories/guidance-on-reporting-and-writing/about-coordinated-disclosure-of-security-vulnerabilities
  - /code-security/security-advisories/guidance-on-reporting-and-writing/best-practices-for-writing-repository-security-advisories
  - /code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability
  - /code-security/security-advisories/guidance-on-reporting-and-writing/managing-privately-reported-security-vulnerabilities
  - /code-security/security-overview/about-the-security-overview
  - /code-security/security-overview/filtering-alerts-in-the-security-overview
  - /code-security/security-overview/viewing-the-security-overview
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/about-dependabot-version-updates
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/automating-dependabot-with-github-actions
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/customizing-dependency-updates
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/enabling-and-disabling-dependabot-version-updates
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/keeping-your-actions-up-to-date-with-dependabot
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/listing-dependencies-configured-for-version-updates
  - /code-security/dependabot/working-with-dependabot/configuring-access-to-private-registries-for-dependabot
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/managing-pull-requests-for-dependency-updates
  - /code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/about-alerts-for-vulnerable-dependencies
  - /code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/about-dependabot-security-updates
  - /code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/browsing-security-vulnerabilities-in-the-github-advisory-database
  - /code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/editing-security-advisories-in-the-github-advisory-database
  - /code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/configuring-dependabot-security-updates
  - /code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/configuring-notifications-for-vulnerable-dependencies
  - /code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/troubleshooting-dependabot-errors
  - /code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/troubleshooting-the-detection-of-vulnerable-dependencies
  - /code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/viewing-and-updating-vulnerable-dependencies-in-your-repository
  - /code-security/supply-chain-security/understanding-your-software-supply-chain/about-dependency-review
  - /code-security/supply-chain-security/understanding-your-software-supply-chain/about-the-dependency-graph
  - /code-security/supply-chain-security/understanding-your-software-supply-chain/using-the-dependency-submission-api
  - /code-security/supply-chain-security/understanding-your-software-supply-chain/exploring-the-dependencies-of-a-repository
---
