---
title: GitHub Enterprise guides
shortTitle: Guides
intro: 'Learn how to increase developer productivity and code quality with {% data variables.product.product_name %}.'
allowTitleToDifferFromFilename: true
layout: product-guides
versions:
  ghec: '*'
  ghes: '*'
  ghae: '*'
learningTracks:
  - '{% ifversion ghec %}get_started_with_your_enterprise_account{% endif %}'
  - '{% ifversion ghae %}get_started_with_github_ae{% endif %}'
  - '{% ifversion ghes %}deploy_an_instance{% endif %}'
  - '{% ifversion ghes %}upgrade_your_instance{% endif %}'
  - adopting_github_actions_for_your_enterprise_ghec
  - adopting_github_actions_for_your_enterprise_ghes_and_ghae
  - '{% ifversion ghes %}increase_fault_tolerance{% endif %}'
  - '{% ifversion ghes %}improve_security_of_your_instance{% endif %}'
  - '{% ifversion ghes %}configure_github_actions{% endif %}'
  - '{% ifversion ghes %}configure_github_advanced_security{% endif %}'
includeGuides:
  - /admin/authentication/allowing-built-in-authentication-for-users-outside-your-identity-provider
  - /admin/authentication/changing-authentication-methods
  - /admin/authentication/configuring-authentication-and-provisioning-for-your-enterprise-using-azure-ad
  - /admin/authentication/configuring-saml-single-sign-on-for-your-enterprise
  - /admin/authentication/configuring-user-provisioning-for-your-enterprise
  - /admin/authentication/managing-identity-and-access-for-your-enterprise/about-identity-and-access-management-for-your-enterprise
  - /admin/authentication/managing-identity-and-access-for-your-enterprise/configuring-saml-single-sign-on-for-your-enterprise
  - /admin/authentication/managing-identity-and-access-for-your-enterprise/configuring-saml-single-sign-on-for-your-enterprise-using-okta
  - /admin/authentication/managing-identity-and-access-for-your-enterprise/managing-team-synchronization-for-organizations-in-your-enterprise
  - /admin/authentication/managing-identity-and-access-for-your-enterprise/switching-your-saml-configuration-from-an-organization-to-an-enterprise-account
  - /admin/authentication/managing-your-enterprise-users-with-your-identity-provider/about-enterprise-managed-users
  - /admin/authentication/managing-your-enterprise-users-with-your-identity-provider/configuring-saml-single-sign-on-for-enterprise-managed-users
  - /admin/authentication/managing-your-enterprise-users-with-your-identity-provider/configuring-scim-provisioning-for-enterprise-managed-users
  - /admin/authentication/managing-your-enterprise-users-with-your-identity-provider/configuring-scim-provisioning-for-enterprise-managed-users-with-okta
  - /admin/authentication/managing-your-enterprise-users-with-your-identity-provider/managing-team-memberships-with-identity-provider-groups
  - /admin/authentication/using-cas
  - /admin/authentication/using-ldap
  - /admin/authentication/using-saml
  - /admin/configuration/accessing-the-administrative-shell-ssh
  - /admin/configuration/accessing-the-management-console
  - /admin/configuration/configuring-a-hostname
  - /admin/configuration/configuring-backups-on-your-appliance
  - /admin/configuration/configuring-built-in-firewall-rules
  - /admin/configuration/configuring-code-scanning-for-your-appliance
  - /admin/configuration/configuring-data-encryption-for-your-enterprise
  - /admin/code-security/managing-github-advanced-security-for-your-enterprise/configuring-dependency-review-for-your-appliance
  - /admin/configuration/configuring-dns-nameservers
  - /admin/configuration/configuring-rate-limits
  - /admin/configuration/configuring-secret-scanning-for-your-appliance
  - /admin/configuration/configuring-tls
  - /admin/configuration/configuring-your-enterprise/verifying-or-approving-a-domain-for-your-enterprise
  - /admin/configuration/configuring-your-enterprise/managing-github-mobile-for-your-enterprise
  - /admin/configuration/connecting-your-enterprise-account-to-github-enterprise-cloud
  - /admin/configuration/configuring-your-enterprise/configuring-ssh-connections-to-your-instance
  - /admin/configuration/configuring-your-enterprise/configuring-host-keys-for-your-instance
  - /admin/configuration/enabling-and-scheduling-maintenance-mode
  - /admin/configuration/configuring-github-connect/enabling-automatic-user-license-sync-for-your-enterprise
  - /admin/configuration/enabling-private-mode
  - /admin/configuration/enabling-subdomain-isolation
  - /admin/configuration/configuring-github-connect/enabling-unified-contributions-for-your-enterprise
  - /admin/configuration/configuring-github-connect/enabling-unified-search-for-your-enterprise
  - /admin/configuration/initializing-github-ae
  - /admin/configuration/network-ports
  - /admin/configuration/restricting-network-traffic-to-your-enterprise-with-an-ip-allow-list
  - /admin/configuration/site-admin-dashboard
  - /admin/configuration/troubleshooting-ssl-errors
  - /admin/configuration/using-github-enterprise-server-with-a-load-balancer
  - /admin/enterprise-management/about-high-availability-configuration
  - /admin/enterprise-management/accessing-the-monitor-dashboard
  - /admin/enterprise-management/creating-a-high-availability-replica
  - /admin/enterprise-management/differences-between-clustering-and-high-availability-ha
  - /admin/enterprise-management/enabling-automatic-update-checks
  - /admin/enterprise-management/initiating-a-failover-to-your-replica-appliance
  - /admin/enterprise-management/recommended-alert-thresholds
  - /admin/enterprise-management/setting-up-external-monitoring
  - /admin/enterprise-management/upgrade-requirements
  - /admin/enterprise-management/upgrading-github-enterprise-server
  - /admin/enterprise-management/monitoring-your-appliance/about-system-logs
  - /admin/enterprise-support/about-github-enterprise-support
  - /admin/github-actions/about-using-actions-in-your-enterprise
  - /admin/github-actions/backing-up-and-restoring-github-enterprise-server-with-github-actions-enabled
  - /admin/github-actions/enabling-automatic-access-to-githubcom-actions-using-github-connect
  - /admin/github-actions/enforcing-github-actions-policies-for-your-enterprise
  - /admin/github-actions/getting-started-with-github-actions-for-github-enterprise-server
  - /admin/github-actions/high-availability-for-github-actions
  - /admin/github-actions/using-a-staging-environment
  - /admin/overview/about-data-residency
  - /admin/overview/about-enterprise-accounts
  - /admin/overview/about-github-ae
  - /admin/overview/about-upgrades-to-new-releases
  - /admin/packages/configuring-package-ecosystem-support-for-your-enterprise
  - /admin/packages/quickstart-for-configuring-your-minio-storage-bucket-for-github-packages
  - /admin/policies/about-pre-receive-hooks
  - /admin/policies/creating-a-pre-receive-hook-environment
  - /admin/policies/creating-a-pre-receive-hook-script
  - /admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-advanced-security-in-your-enterprise
  - /admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-dependency-insights-in-your-enterprise
  - /admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise
  - /admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-security-settings-in-your-enterprise
  - /admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-projects-in-your-enterprise
  - /admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise
  - /admin/policies/enforcing-policies-for-your-enterprise/enforcing-team-policies-in-your-enterprise
  - /admin/policies/enforcing-policies-for-your-enterprise/restricting-email-notifications-for-your-enterprise
  - /admin/policies/managing-pre-receive-hooks-on-the-github-enterprise-server-appliance
  - /admin/user-management/about-migrations
  - /admin/user-management/adding-people-to-teams
  - /admin/user-management/auditing-ssh-keys
  - /admin/user-management/auditing-users-across-your-enterprise
  - /admin/user-management/configuring-git-large-file-storage-for-your-enterprise
  - /admin/user-management/configuring-visibility-for-organization-membership
  - /admin/user-management/continuous-integration-using-jenkins
  - /admin/user-management/creating-teams
  - /admin/user-management/disabling-git-ssh-access-on-your-enterprise
  - /admin/user-management/exporting-migration-data-from-githubcom
  - /admin/user-management/exporting-migration-data-from-your-enterprise
  - /admin/user-management/importing-data-from-third-party-version-control-systems
  - /admin/user-management/managing-dormant-users
  - /admin/monitoring-activity-in-your-enterprise/reviewing-audit-logs-for-your-enterprise/about-the-audit-log-for-your-enterprise
  - /admin/monitoring-activity-in-your-enterprise/reviewing-audit-logs-for-your-enterprise/accessing-the-audit-log-for-your-enterprise
  - /admin/monitoring-activity-in-your-enterprise/reviewing-audit-logs-for-your-enterprise/searching-the-audit-log-for-your-enterprise
  - /admin/monitoring-activity-in-your-enterprise/reviewing-audit-logs-for-your-enterprise/configuring-the-audit-log-for-your-enterprise
  - /admin/monitoring-activity-in-your-enterprise/reviewing-audit-logs-for-your-enterprise/exporting-audit-log-activity-for-your-enterprise
  - /admin/monitoring-activity-in-your-enterprise/reviewing-audit-logs-for-your-enterprise/streaming-the-audit-log-for-your-enterprise
  - /admin/monitoring-activity-in-your-enterprise/reviewing-audit-logs-for-your-enterprise/using-the-audit-log-api-for-your-enterprise
  - /admin/monitoring-activity-in-your-enterprise/reviewing-audit-logs-for-your-enterprise/audit-log-events-for-your-enterprise
  - /admin/monitoring-activity-in-your-enterprise/exploring-user-activity/activity-dashboard
  - /admin/monitoring-activity-in-your-enterprise/exploring-user-activity/viewing-push-logs
  - /admin/monitoring-activity-in-your-enterprise/exploring-user-activity/log-forwarding
  - /admin/monitoring-activity-in-your-enterprise/exploring-user-activity/managing-global-webhooks
  - /admin/user-management/managing-organizations-in-your-enterprise/adding-organizations-to-your-enterprise
  - /admin/user-management/managing-projects-using-jira
  - /admin/user-management/managing-users-in-your-enterprise/inviting-people-to-manage-your-enterprise
  - /admin/user-management/managing-users-in-your-enterprise/managing-support-entitlements-for-your-enterprise
  - /admin/user-management/managing-users-in-your-enterprise/roles-in-an-enterprise
  - /admin/user-management/managing-users-in-your-enterprise/viewing-and-managing-a-users-saml-access-to-your-enterprise
  - /admin/user-management/managing-users-in-your-enterprise/viewing-people-in-your-enterprise
  - /admin/user-management/migrating-data-to-your-enterprise
  - /admin/user-management/migrating-to-internal-repositories
  - /admin/user-management/placing-a-legal-hold-on-a-user-or-organization
  - /admin/user-management/preparing-to-migrate-data-to-your-enterprise
  - /admin/user-management/preventing-users-from-creating-organizations
  - /admin/user-management/rebuilding-contributions-data
  - /admin/user-management/removing-users-from-teams-and-organizations
  - /admin/user-management/requiring-two-factor-authentication-for-an-organization
  - /admin/user-management/suspending-and-unsuspending-users
  - /admin/overview/creating-an-enterprise-account
  - /admin/user-management/managing-organizations-in-your-enterprise/restoring-a-deleted-organization
  - /admin/configuration/administering-your-instance-from-the-management-console/about-the-management-console
  - /admin/configuration/administering-your-instance-from-the-management-console/managing-access-to-the-management-console
  - /admin/configuration/administering-your-instance-from-the-management-console/accessing-the-management-console
  - /admin/configuration/administering-your-instance-from-the-management-console/troubleshooting-access-to-the-management-console
---

