---
title: Getting started with GitHub Actions for GitHub Enterprise Server
shortTitle: Get started
intro: 'Learn about enabling and configuring {% data variables.product.prodname_actions %} on {% data variables.product.prodname_ghe_server %} for the first time.'
permissions: 'Site administrators can enable {% data variables.product.prodname_actions %} and configure enterprise settings.'
redirect_from:
  - /enterprise/admin/github-actions/enabling-github-actions-and-configuring-storage
  - /admin/github-actions/enabling-github-actions-and-configuring-storage
  - /admin/github-actions/getting-started-with-github-actions-for-github-enterprise-server
  - /admin/github-actions/enabling-github-actions-for-github-enterprise-server/getting-started-with-github-actions-for-github-enterprise-server
versions:
  ghes: '*'
type: how_to
topics:
  - Actions
  - Enterprise
---
{% data reusables.actions.enterprise-beta %}

{% data reusables.actions.enterprise-github-hosted-runners %}

## About {% data variables.product.prodname_actions %} on {% data variables.product.prodname_ghe_server %}

This article explains how site administrators can configure {% data variables.product.prodname_ghe_server %} to use {% data variables.product.prodname_actions %}.

{% data reusables.actions.ghes-actions-not-enabled-by-default %} You'll need to determine whether your instance has adequate CPU and memory resources to handle the load from {% data variables.product.prodname_actions %} without causing performance loss, and possibly increase those resources. You'll also need to decide which storage provider you'll use for the blob storage required to store artifacts{% ifversion actions-caching %} and caches{% endif %} generated by workflow runs. Then, you'll enable {% data variables.product.prodname_actions %} for your enterprise, manage access permissions, and add self-hosted runners to run workflows.

{% data reusables.actions.introducing-enterprise %}

{% data reusables.actions.migrating-enterprise %}

## Review hardware requirements

{%- ifversion ghes < 3.6 %}

The CPU and memory resources available to {% data variables.location.product_location %} determine the number of jobs that can be run concurrently without performance loss. {% data reusables.actions.minimum-hardware %}

The peak quantity of concurrent jobs running without performance loss depends on such factors as job duration, artifact usage, number of repositories running Actions, and how much other work your instance is doing not related to Actions. Internal testing at GitHub demonstrated the following performance targets for GitHub Enterprise Server on a range of CPU and memory configurations:

{% endif %}

{%- ifversion ghes > 3.5 %}

The CPU and memory resources available to {% data variables.location.product_location %} determine the number of runners that can be configured without performance loss. {% data reusables.actions.minimum-hardware %}

The peak quantity of connected runners without performance loss depends on such factors as job duration, artifact usage, number of repositories running Actions, and how much other work your instance is doing not related to Actions. Internal testing at GitHub demonstrated the following performance targets for GitHub Enterprise Server on a range of CPU and memory configurations:

{% endif %}


{%- ifversion ghes = 3.4 %}

{% data reusables.actions.hardware-requirements-3.4 %}

Maximum concurrency was measured using multiple repositories, job duration of approximately 10 minutes, and 10 MB artifact uploads. You may experience different performance depending on the overall levels of activity on your instance.

{%- endif %}

{%- ifversion ghes = 3.5 %}

{% data reusables.actions.hardware-requirements-3.5 %}

{% data variables.product.company_short %} measured maximum concurrency using multiple repositories, job duration of approximately 10 minutes, and 10 MB artifact uploads. You may experience different performance depending on the overall levels of activity on your instance.

{% note %}

**Note:** Beginning with {% data variables.product.prodname_ghe_server %} 3.5, {% data variables.product.company_short %}'s internal testing uses 3rd generation CPUs to better reflect a typical customer configuration. This change in CPU represents a small portion of the changes to performance targets in this version of {% data variables.product.prodname_ghe_server %}.

{% endnote %}

{%- endif %}

{%- ifversion ghes > 3.5 %}

| vCPUs | Memory | Maximum Connected Runners |
| :---| :--- | :--- |
| 8   | 64 GB  | 740  runners |
| 32  | 160 GB | 2700 runners |
| 96  | 384 GB | 7000 runners |
| 128 | 512 GB | 7000 runners |

{% data variables.product.company_short %} measured maximum connected runners using multiple repositories, job duration of approximately 10 minutes, and 10 MB artifact uploads. You may experience different performance depending on the overall levels of activity on your instance.

{% note %}

**Notes:**

- Beginning with {% data variables.product.prodname_ghe_server %} 3.6, {% data variables.product.company_short %} documents connected runners as opposed to concurrent jobs. Connected runners represents the most runners you can connect and expect to utilize. It should also be noted that connecting more runners than you can expect to utilize can negatively impact performance.

- Beginning with {% data variables.product.prodname_ghe_server %} 3.5, {% data variables.product.company_short %}'s internal testing uses 3rd generation CPUs to better reflect a typical customer configuration. This change in CPU represents a small portion of the changes to performance targets in this version of {% data variables.product.prodname_ghe_server %}.
{% endnote %}
{%- endif %}

If you plan to enable {% data variables.product.prodname_actions %} for the users of an existing instance, review the levels of activity for users and automations on the instance and ensure that you have provisioned adequate CPU and memory for your users. For more information about monitoring the capacity and performance of {% data variables.product.prodname_ghe_server %}, see "[Monitoring your appliance](/admin/enterprise-management/monitoring-your-appliance)."

For more information about minimum hardware requirements for {% data variables.location.product_location %}, see the hardware considerations for your instance's platform.

- [AWS](/admin/installation/installing-github-enterprise-server-on-aws#hardware-considerations)
- [Azure](/admin/installation/installing-github-enterprise-server-on-azure#hardware-considerations)
- [Google Cloud Platform](/admin/installation/installing-github-enterprise-server-on-google-cloud-platform#hardware-considerations)
- [Hyper-V](/admin/installation/installing-github-enterprise-server-on-hyper-v#hardware-considerations)
- [OpenStack KVM](/admin/installation/installing-github-enterprise-server-on-openstack-kvm#hardware-considerations)
- [VMware](/admin/installation/installing-github-enterprise-server-on-vmware#hardware-considerations)

{% data reusables.enterprise_installation.about-adjusting-resources %}

{% ifversion ghes > 3.4 %}

Optionally, you can limit resource consumption on {% data variables.location.product_location %} by configuring a rate limit for {% data variables.product.prodname_actions %}. For more information, see "[Configuring rate limits](/admin/configuration/configuring-your-enterprise/configuring-rate-limits#configuring-rate-limits-for-github-actions)."

{% endif %}

## External storage requirements

To enable {% data variables.product.prodname_actions %} on {% data variables.product.prodname_ghe_server %}, you must have access to external blob storage.

{% data reusables.actions.enterprise-storage-contents %} The amount of storage required depends on your usage of {% data variables.product.prodname_actions %}. Only a single external storage configuration is supported, and you can't use multiple storage providers at the same time.

All other {% data variables.product.prodname_actions %} data, such as the workflow files in a repository's file structure, are stored on the data storage volume for {% data variables.location.product_location %}.

{% data variables.product.prodname_actions %} supports these storage providers:

* Azure Blob storage
* Amazon S3
{%- ifversion actions-ghes-gcp-storage %}
* Google Cloud Storage
{%- endif %}
* S3-compatible MinIO cluster

{% note %}

**Note:** These are the only storage providers that {% data variables.product.company_short %} supports and can provide assistance with.

{% data reusables.actions.enterprise-s3-tech-partners %}

{% endnote %}

## Networking considerations

{% data reusables.actions.proxy-considerations %} For more information about using a proxy with {% data variables.product.prodname_ghe_server %}, see "[Configuring an outbound web proxy server](/admin/configuration/configuring-network-settings/configuring-an-outbound-web-proxy-server)."

{% ifversion ghes %}

## Enabling {% data variables.product.prodname_actions %} with your storage provider

Follow one of the procedures below to enable {% data variables.product.prodname_actions %} with your chosen storage provider:

* [Enabling GitHub Actions with Azure Blob storage](/admin/github-actions/enabling-github-actions-for-github-enterprise-server/enabling-github-actions-with-azure-blob-storage)
* [Enabling GitHub Actions with Amazon S3 storage](/admin/github-actions/enabling-github-actions-for-github-enterprise-server/enabling-github-actions-with-amazon-s3-storage)
{%- ifversion actions-ghes-gcp-storage %}
* [Enabling GitHub Actions with Google Cloud Storage](/admin/github-actions/enabling-github-actions-for-github-enterprise-server/enabling-github-actions-with-google-cloud-storage)
{%- endif %}
* [Enabling GitHub Actions with MinIO storage](/admin/github-actions/enabling-github-actions-for-github-enterprise-server/enabling-github-actions-with-minio-storage)

## Managing access permissions for {% data variables.product.prodname_actions %} in your enterprise

You can use policies to manage access to {% data variables.product.prodname_actions %}. For more information, see "[Enforcing GitHub Actions policies for your enterprise](/admin/github-actions/enforcing-github-actions-policies-for-your-enterprise)."

## Adding self-hosted runners

{% data reusables.actions.enterprise-github-hosted-runners %}

To run {% data variables.product.prodname_actions %} workflows, you need to add self-hosted runners. You can add self-hosted runners at the enterprise, organization, or repository levels. For more information, see "[Adding self-hosted runners](/actions/hosting-your-own-runners/adding-self-hosted-runners)."

## Managing which actions can be used in your enterprise

You can control which actions your users are allowed to use in your enterprise. This includes setting up {% data variables.product.prodname_github_connect %} for automatic access to actions from {% data variables.product.prodname_dotcom_the_website %}, or manually syncing actions from {% data variables.product.prodname_dotcom_the_website %}.

For more information, see "[About using actions in your enterprise](/admin/github-actions/about-using-actions-in-your-enterprise)."

{% data reusables.actions.general-security-hardening %}

{% endif %}

## Reserved names

When you enable {% data variables.product.prodname_actions %} for your enterprise, two organizations are created: `github` and `actions`. If your enterprise already uses the `github` organization name, `github-org` (or `github-github-org` if `github-org` is also in use) will be used instead. If your enterprise already uses the `actions` organization name, `github-actions` (or `github-actions-org` if `github-actions` is also in use) will be used instead. Once actions is enabled, you won't be able to use these names anymore.
