---
title: Enabling GitHub Actions with MinIO storage
intro: 'You can enable {% data variables.product.prodname_actions %} on {% data variables.product.prodname_ghe_server %} and use MinIO storage to store data generated by workflow runs.'
permissions: 'Site administrators can enable {% data variables.product.prodname_actions %} and configure enterprise settings.'
versions:
  ghes: '*'
type: how_to
topics:
  - Actions
  - Enterprise
  - Infrastructure
  - Storage
redirect_from:
  - /admin/github-actions/enabling-github-actions-with-minio-gateway-for-nas-storage
  - /admin/github-actions/enabling-github-actions-for-github-enterprise-server/enabling-github-actions-with-minio-gateway-for-nas-storage
shortTitle: MinIO storage
---

{% data reusables.actions.enterprise-storage-about %}

## Prerequisites

Before enabling {% data variables.product.prodname_actions %}, make sure you have completed the following steps:

* Create your MinIO bucket for storing data generated by workflow runs. For more information about installing and configuring MinIO, see "[MinIO High Performance Object Storage](https://min.io/docs/minio/container/index.html)" and "[mc mb](https://min.io/docs/minio/linux/reference/minio-mc/mc-mb.html)" in the MinIO documentation.

  To avoid resource contention on the appliance, we recommend that MinIO be hosted separately from {% data variables.location.product_location %}.

  {% indented_data_reference reusables.actions.enterprise-s3-permission spaces=2 %}
{% data reusables.actions.enterprise-common-prereqs %}

## Enabling {% data variables.product.prodname_actions %} with MinIO storage

{% data reusables.enterprise_site_admin_settings.access-settings %}
{% data reusables.enterprise_site_admin_settings.management-console %}
{% data reusables.enterprise_management_console.actions %}
{% data reusables.actions.enterprise-enable-checkbox %}
{%- ifversion ghes-actions-storage-oidc %}
{% data reusables.actions.enterprise-s3-storage-setup %}
1. Under "Authentication", select **Credentials-based**, and enter your storage bucket's details:

   {% note %}

   **Note:** For MinIO, you cannot use OpenID Connect (OIDC) authentication. You must use credentials-based authentication.

   {% endnote %}

{% indented_data_reference reusables.actions.enterprise-minio-storage-credential-fields spaces=3 %}
{%- else %}
1. Under "Artifact & Log Storage", select **Amazon S3**, and enter your storage bucket's details:

{% indented_data_reference reusables.actions.enterprise-minio-storage-credential-fields spaces=3 %}
{% endif %}
1. Under "Artifact & Log Storage", select **Force path style**.
{% data reusables.enterprise_management_console.test-storage-button %}
{% data reusables.enterprise_management_console.save-settings %}

{% data reusables.actions.enterprise-postinstall-nextsteps %}
