---
title: Enabling GitHub Actions with Amazon S3 storage
intro: 'You can enable {% data variables.product.prodname_actions %} on {% data variables.product.prodname_ghe_server %} and use Amazon S3 storage to store data generated by workflow runs.'
permissions: 'Site administrators can enable {% data variables.product.prodname_actions %} and configure enterprise settings.'
versions:
  ghes: '*'
type: how_to
topics:
  - Actions
  - Enterprise
  - Infrastructure
  - Storage
redirect_from:
  - /admin/github-actions/enabling-github-actions-with-amazon-s3-storage
shortTitle: Amazon S3 storage
miniTocMaxHeadingLevel: 3
---

{% data reusables.actions.enterprise-storage-about %}

{% ifversion ghes-actions-storage-oidc %}
{% data reusables.actions.enterprise-storage-about-oidc %}

{% data reusables.actions.ghes-storage-oidc-beta-note %}
{% endif %}

## Prerequisites

{% note %}

**Note:** The only {% data variables.product.prodname_dotcom %}-supported S3 storage providers are Amazon S3 and MinIO Gateway for NAS.

{% data reusables.actions.enterprise-s3-tech-partners %}

{% endnote %}

Before enabling {% data variables.product.prodname_actions %}, make sure you have completed the following steps:

* Create your Amazon S3 bucket for storing data generated by workflow runs.
{% data reusables.actions.enterprise-common-prereqs %}
{% data reusables.actions.enterprise-oidc-prereqs %}

{% ifversion ghes-actions-storage-oidc %}
## Enabling {% data variables.product.prodname_actions %} with Amazon S3 using OIDC (recommended)

{% data reusables.actions.ghes-storage-oidc-beta-note %}

To configure {% data variables.product.prodname_ghe_server %} to use OIDC with an Amazon S3 bucket, you must first create an Amazon OIDC provider, then create an Identity and Access Management (IAM) role, and finally configure {% data variables.product.prodname_ghe_server %} to use the provider and role to access your S3 bucket.

### 1. Create an Amazon OIDC provider

1. Get the thumbprint for {% data variables.location.product_location_enterprise %}.
   1. Use the following OpenSSL command to get the SHA1 thumbprint for {% data variables.location.product_location_enterprise %}, replacing `HOSTNAME` with the public hostname for {% data variables.location.product_location_enterprise %}

      ```shell{:copy}
      openssl s_client -connect HOSTNAME:443 < /dev/null 2>/dev/null | openssl x509 -fingerprint -noout -sha1 -in /dev/stdin
      ```

      For example:

      ```shell
      openssl s_client -connect my-ghes-host.example.com:443 < /dev/null 2>/dev/null | openssl x509 -fingerprint -noout -sha1 -in /dev/stdin
      ```

      The command returns a thumbprint in the following format:

      ```
      SHA1 Fingerprint=AB:12:34:56:78:90:AB:CD:EF:12:34:56:78:90:AB:CD:EF:12:34:56
      ```
   1. Remove the colons (`:`) from the thumbprint value, and save the value to use later.

      For example, the thumbprint for the value returned in the previous step is:

      ```
      AB1234567890ABCDEF1234567890ABCDEF123456
      ```
1. Using the AWS CLI, use the following command to create an OIDC provider for {% data variables.location.product_location_enterprise %}. Replace `HOSTNAME` with the public hostname for {% data variables.location.product_location_enterprise %}, and `THUMBPRINT` with the thumbprint value from the previous step.

   ```shell{:copy}
   aws iam create-open-id-connect-provider \
     --url https://HOSTNAME/_services/token \
     --client-id-list "sts.amazonaws.com" \
     --thumbprint-list "THUMBPRINT"
   ```

   For example:

   ```shell{:copy}
   aws iam create-open-id-connect-provider \
     --url https://my-ghes-host.example.com/_services/token \
     --client-id-list "sts.amazonaws.com" \
     --thumbprint-list "AB1234567890ABCDEF1234567890ABCDEF123456"
   ```

   For more information on installing the AWS CLI, see the [Amazon documentation](https://docs.aws.amazon.com/cli/latest/userguide/getting-started-install.html).

   {% warning %}

   **Warning:** If the certificate for {% data variables.location.product_location_enterprise %} changes in the future, you must update the thumbprint value in the Amazon OIDC provider for the OIDC trust to continue to work.

   {% endwarning %}

### 2. Create an IAM role

1. Open the AWS Console, and navigate to the Identity and Access Management (IAM) service.
1. In the left menu, under "Access management", click **Roles**, then click **Create Role**.
1. On the "Select trusted entity" page, enter the following options:
   * For "Trusted entity type", click **Web identity**.
   * For "Identity provider", use the **Choose provider** drop-down menu and select the OIDC provider you created in the previous steps. It should be named `HOSTNAME/_services/token`, where `HOSTNAME` is the public hostname for {% data variables.location.product_location_enterprise %}.
   * For "Audience", select `sts.amazonaws.com`.
1. Click **Next**.
1. On the "Add permissions" page, use the filter to find and select the  `AmazonS3FullAccess` policy.
1. Click **Next**.
1. On the "Name, review, and create" page, enter a name for the role, and click **Create role**.
1. On the IAM "Roles" page, select the role you just created.
1. Under "Summary", note the ARN value for the role, as this is needed later.
1. Click the **Trust relationships** tab, then click **Edit trust policy**.
1. Edit the trust policy to add a new `sub` claim. The value for `Condition` must match the following example, replacing `HOSTNAME` with the public hostname for {% data variables.location.product_location_enterprise %}:

   ```json
   ...
   "Condition": {
     "StringEquals": {
       "HOSTNAME/_services/token:aud": "sts.amazonaws.com",
       "HOSTNAME/_services/token:sub": "HOSTNAME"
     }
   }
   ...
   ```

   For example:

   ```json
   ...
   "Condition": {
     "StringEquals": {
       "my-ghes-host.example.com/_services/token:aud": "sts.amazonaws.com",
       "my-ghes-host.example.com/_services/token:sub": "my-ghes-host.example.com"
     }
   }
   ...
   ```
1. Click **Update policy**.

### 3. Configure {% data variables.product.prodname_ghe_server %} to connect to Amazon S3 using OIDC

{% data reusables.enterprise_site_admin_settings.access-settings %}
{% data reusables.enterprise_site_admin_settings.management-console %}
{% data reusables.enterprise_management_console.actions %}
{% data reusables.actions.enterprise-enable-checkbox %}
{% data reusables.actions.enterprise-s3-storage-setup %}
1. Under "Authentication", select **OpenID Connect (OIDC)**, and enter the values for your storage:
   * **AWS S3 Bucket**: The name of your S3 bucket.
   * **AWS Role**: The ARN for the role you created in the previous procedures. For example, `arn:aws:iam::123456789:role/my-role-name`.
   * **AWS Region**: The AWS region for your bucket. For example, `us-east-1`.
{% data reusables.enterprise_management_console.test-storage-button %}
{% data reusables.enterprise_management_console.save-settings %}

{% endif %}

## Enabling {% data variables.product.prodname_actions %} with Amazon S3 storage{% ifversion ghes-actions-storage-oidc %} using access keys{% endif %}

1. Using the AWS Console or CLI, create an access key for your storage bucket. {% indented_data_reference reusables.actions.enterprise-s3-permission spaces=3 %}

   For more information on managing AWS access keys, see the "[AWS Identity and Access Management Documentation](https://docs.aws.amazon.com/iam/index.html)."
{% data reusables.enterprise_site_admin_settings.access-settings %}
{% data reusables.enterprise_site_admin_settings.management-console %}
{% data reusables.enterprise_management_console.actions %}
{% data reusables.actions.enterprise-enable-checkbox %}
{%- ifversion ghes-actions-storage-oidc %}
{% data reusables.actions.enterprise-s3-storage-setup %}
1. Under "Authentication", select **Credentials-based**, and enter your storage bucket's details:

{% indented_data_reference reusables.actions.enterprise-s3-storage-credential-fields spaces=3 %}
{%- else %}
1. Under "Artifact & Log Storage", select **Amazon S3**, then enter your storage bucket's details:

{% indented_data_reference reusables.actions.enterprise-s3-storage-credential-fields spaces=3 %}
{%- endif %}
{% data reusables.enterprise_management_console.test-storage-button %}
{% data reusables.enterprise_management_console.save-settings %}

{% data reusables.actions.enterprise-postinstall-nextsteps %}
