---
title: Permission levels for a project board owned by a personal account
intro: 'A project board owned by a personal account has two permission levels: the project board owner and collaborators.'
redirect_from:
  - /articles/permission-levels-for-user-owned-project-boards
  - /github/setting-up-and-managing-your-github-user-account/permission-levels-for-user-owned-project-boards
  - /github/setting-up-and-managing-your-github-user-account/managing-user-account-settings/permission-levels-for-user-owned-project-boards
  - /account-and-profile/setting-up-and-managing-your-github-user-account/managing-user-account-settings/permission-levels-for-user-owned-project-boards
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
topics:
  - Accounts
shortTitle: Project board permissions
---
## Permissions overview

There is only one owner of a user-owned project board; this permission cannot be shared with another personal account. In addition to the owner, other people can collaborate on project boards.

There are three levels of permissions for project board collaborators:

{% data reusables.project-management.project-board-permissions %}

## Owner and admin permissions for a user-owned project board

The project board owner and collaborators with admin access have full control of the project board. In addition to all the permissions allowed by project board collaborators, a project board owner and collaborator with admin access can:

- [Manage, view, and add collaborators](/articles/managing-access-to-your-user-account-s-project-boards)
- [Configure a project board as {% ifversion ghae %}internal{% else %}public{% endif %} or private](/articles/changing-project-board-visibility)
- [Delete a project board](/articles/deleting-a-project-board/)
- [Close a project board](/articles/closing-a-project-board/)
- [Reopen a closed project board](/articles/reopening-a-closed-project-board)

## Read and write permissions for a user-owned project board

Collaborators with read access to a user-owned project board can:

- View a project board
- Copy a project board
- Filter cards on a project board

Collaborators with write access to a user-owned project board can:

- View a project board
- Copy a project board
- Filter cards on a project board
- Edit a project board
- Link a repository to a project board
- Configure automation for project boards
- Copy a project board
- Add issues and pull requests to a project board
- Add notes to a project board
- Track progress on your project board
- Archive cards on a project board

## Project board visibility

You can change the project board's visibility from private to {% ifversion ghae %}internal{% else %}public{% endif %} and back again. By default, user-owned project boards are private. For more information, see "[Changing project board visibility](/articles/changing-project-board-visibility)."

## Further reading

  - "[Managing access to your personal account's project boards](/articles/managing-access-to-your-user-account-s-project-boards)"
